// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct StartDeviceAuthorizationInput {
    /// <p>The unique identifier string for the client that is registered with IAM Identity Center. This value should come from the persisted result of the <code>RegisterClient</code> API operation.</p>
    pub client_id: ::std::option::Option<::std::string::String>,
    /// <p>A secret string that is generated for the client. This value should come from the persisted result of the <code>RegisterClient</code> API operation.</p>
    pub client_secret: ::std::option::Option<::std::string::String>,
    /// <p>The URL for the Amazon Web Services access portal. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/using-the-portal.html">Using the Amazon Web Services access portal</a> in the <i>IAM Identity Center User Guide</i>.</p>
    pub start_url: ::std::option::Option<::std::string::String>,
}
impl StartDeviceAuthorizationInput {
    /// <p>The unique identifier string for the client that is registered with IAM Identity Center. This value should come from the persisted result of the <code>RegisterClient</code> API operation.</p>
    pub fn client_id(&self) -> ::std::option::Option<&str> {
        self.client_id.as_deref()
    }
    /// <p>A secret string that is generated for the client. This value should come from the persisted result of the <code>RegisterClient</code> API operation.</p>
    pub fn client_secret(&self) -> ::std::option::Option<&str> {
        self.client_secret.as_deref()
    }
    /// <p>The URL for the Amazon Web Services access portal. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/using-the-portal.html">Using the Amazon Web Services access portal</a> in the <i>IAM Identity Center User Guide</i>.</p>
    pub fn start_url(&self) -> ::std::option::Option<&str> {
        self.start_url.as_deref()
    }
}
impl ::std::fmt::Debug for StartDeviceAuthorizationInput {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("StartDeviceAuthorizationInput");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &"*** Sensitive Data Redacted ***");
        formatter.field("start_url", &self.start_url);
        formatter.finish()
    }
}
impl StartDeviceAuthorizationInput {
    /// Creates a new builder-style object to manufacture [`StartDeviceAuthorizationInput`](crate::operation::start_device_authorization::StartDeviceAuthorizationInput).
    pub fn builder() -> crate::operation::start_device_authorization::builders::StartDeviceAuthorizationInputBuilder {
        crate::operation::start_device_authorization::builders::StartDeviceAuthorizationInputBuilder::default()
    }
}

/// A builder for [`StartDeviceAuthorizationInput`](crate::operation::start_device_authorization::StartDeviceAuthorizationInput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
pub struct StartDeviceAuthorizationInputBuilder {
    pub(crate) client_id: ::std::option::Option<::std::string::String>,
    pub(crate) client_secret: ::std::option::Option<::std::string::String>,
    pub(crate) start_url: ::std::option::Option<::std::string::String>,
}
impl StartDeviceAuthorizationInputBuilder {
    /// <p>The unique identifier string for the client that is registered with IAM Identity Center. This value should come from the persisted result of the <code>RegisterClient</code> API operation.</p>
    /// This field is required.
    pub fn client_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.client_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The unique identifier string for the client that is registered with IAM Identity Center. This value should come from the persisted result of the <code>RegisterClient</code> API operation.</p>
    pub fn set_client_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.client_id = input;
        self
    }
    /// <p>The unique identifier string for the client that is registered with IAM Identity Center. This value should come from the persisted result of the <code>RegisterClient</code> API operation.</p>
    pub fn get_client_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.client_id
    }
    /// <p>A secret string that is generated for the client. This value should come from the persisted result of the <code>RegisterClient</code> API operation.</p>
    /// This field is required.
    pub fn client_secret(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.client_secret = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A secret string that is generated for the client. This value should come from the persisted result of the <code>RegisterClient</code> API operation.</p>
    pub fn set_client_secret(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.client_secret = input;
        self
    }
    /// <p>A secret string that is generated for the client. This value should come from the persisted result of the <code>RegisterClient</code> API operation.</p>
    pub fn get_client_secret(&self) -> &::std::option::Option<::std::string::String> {
        &self.client_secret
    }
    /// <p>The URL for the Amazon Web Services access portal. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/using-the-portal.html">Using the Amazon Web Services access portal</a> in the <i>IAM Identity Center User Guide</i>.</p>
    /// This field is required.
    pub fn start_url(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.start_url = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The URL for the Amazon Web Services access portal. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/using-the-portal.html">Using the Amazon Web Services access portal</a> in the <i>IAM Identity Center User Guide</i>.</p>
    pub fn set_start_url(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.start_url = input;
        self
    }
    /// <p>The URL for the Amazon Web Services access portal. For more information, see <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/using-the-portal.html">Using the Amazon Web Services access portal</a> in the <i>IAM Identity Center User Guide</i>.</p>
    pub fn get_start_url(&self) -> &::std::option::Option<::std::string::String> {
        &self.start_url
    }
    /// Consumes the builder and constructs a [`StartDeviceAuthorizationInput`](crate::operation::start_device_authorization::StartDeviceAuthorizationInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::start_device_authorization::StartDeviceAuthorizationInput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(crate::operation::start_device_authorization::StartDeviceAuthorizationInput {
            client_id: self.client_id,
            client_secret: self.client_secret,
            start_url: self.start_url,
        })
    }
}
impl ::std::fmt::Debug for StartDeviceAuthorizationInputBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("StartDeviceAuthorizationInputBuilder");
        formatter.field("client_id", &self.client_id);
        formatter.field("client_secret", &"*** Sensitive Data Redacted ***");
        formatter.field("start_url", &self.start_url);
        formatter.finish()
    }
}
