// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Detailed information about the external key store proxy (XKS proxy). Your external key store proxy translates KMS requests into a format that your external key manager can understand. These fields appear in a <code>DescribeCustomKeyStores</code> response only when the <code>CustomKeyStoreType</code> is <code>EXTERNAL_KEY_STORE</code>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct XksProxyConfigurationType {
    /// <p>Indicates whether the external key store proxy uses a public endpoint or an Amazon VPC endpoint service to communicate with KMS.</p>
    pub connectivity: ::std::option::Option<crate::types::XksProxyConnectivityType>,
    /// <p>The part of the external key store <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateCustomKeyStore.html#KMS-CreateCustomKeyStore-request-XksProxyAuthenticationCredential">proxy authentication credential</a> that uniquely identifies the secret access key.</p>
    pub access_key_id: ::std::option::Option<::std::string::String>,
    /// <p>The URI endpoint for the external key store proxy.</p>
    /// <p>If the external key store proxy has a public endpoint, it is displayed here.</p>
    /// <p>If the external key store proxy uses an Amazon VPC endpoint service name, this field displays the private DNS name associated with the VPC endpoint service.</p>
    pub uri_endpoint: ::std::option::Option<::std::string::String>,
    /// <p>The path to the external key store proxy APIs.</p>
    pub uri_path: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon VPC endpoint service used to communicate with the external key store proxy. This field appears only when the external key store proxy uses an Amazon VPC endpoint service to communicate with KMS.</p>
    pub vpc_endpoint_service_name: ::std::option::Option<::std::string::String>,
}
impl XksProxyConfigurationType {
    /// <p>Indicates whether the external key store proxy uses a public endpoint or an Amazon VPC endpoint service to communicate with KMS.</p>
    pub fn connectivity(&self) -> ::std::option::Option<&crate::types::XksProxyConnectivityType> {
        self.connectivity.as_ref()
    }
    /// <p>The part of the external key store <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateCustomKeyStore.html#KMS-CreateCustomKeyStore-request-XksProxyAuthenticationCredential">proxy authentication credential</a> that uniquely identifies the secret access key.</p>
    pub fn access_key_id(&self) -> ::std::option::Option<&str> {
        self.access_key_id.as_deref()
    }
    /// <p>The URI endpoint for the external key store proxy.</p>
    /// <p>If the external key store proxy has a public endpoint, it is displayed here.</p>
    /// <p>If the external key store proxy uses an Amazon VPC endpoint service name, this field displays the private DNS name associated with the VPC endpoint service.</p>
    pub fn uri_endpoint(&self) -> ::std::option::Option<&str> {
        self.uri_endpoint.as_deref()
    }
    /// <p>The path to the external key store proxy APIs.</p>
    pub fn uri_path(&self) -> ::std::option::Option<&str> {
        self.uri_path.as_deref()
    }
    /// <p>The Amazon VPC endpoint service used to communicate with the external key store proxy. This field appears only when the external key store proxy uses an Amazon VPC endpoint service to communicate with KMS.</p>
    pub fn vpc_endpoint_service_name(&self) -> ::std::option::Option<&str> {
        self.vpc_endpoint_service_name.as_deref()
    }
}
impl ::std::fmt::Debug for XksProxyConfigurationType {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("XksProxyConfigurationType");
        formatter.field("connectivity", &self.connectivity);
        formatter.field("access_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("uri_endpoint", &self.uri_endpoint);
        formatter.field("uri_path", &self.uri_path);
        formatter.field("vpc_endpoint_service_name", &self.vpc_endpoint_service_name);
        formatter.finish()
    }
}
impl XksProxyConfigurationType {
    /// Creates a new builder-style object to manufacture [`XksProxyConfigurationType`](crate::types::XksProxyConfigurationType).
    pub fn builder() -> crate::types::builders::XksProxyConfigurationTypeBuilder {
        crate::types::builders::XksProxyConfigurationTypeBuilder::default()
    }
}

/// A builder for [`XksProxyConfigurationType`](crate::types::XksProxyConfigurationType).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
pub struct XksProxyConfigurationTypeBuilder {
    pub(crate) connectivity: ::std::option::Option<crate::types::XksProxyConnectivityType>,
    pub(crate) access_key_id: ::std::option::Option<::std::string::String>,
    pub(crate) uri_endpoint: ::std::option::Option<::std::string::String>,
    pub(crate) uri_path: ::std::option::Option<::std::string::String>,
    pub(crate) vpc_endpoint_service_name: ::std::option::Option<::std::string::String>,
}
impl XksProxyConfigurationTypeBuilder {
    /// <p>Indicates whether the external key store proxy uses a public endpoint or an Amazon VPC endpoint service to communicate with KMS.</p>
    pub fn connectivity(mut self, input: crate::types::XksProxyConnectivityType) -> Self {
        self.connectivity = ::std::option::Option::Some(input);
        self
    }
    /// <p>Indicates whether the external key store proxy uses a public endpoint or an Amazon VPC endpoint service to communicate with KMS.</p>
    pub fn set_connectivity(mut self, input: ::std::option::Option<crate::types::XksProxyConnectivityType>) -> Self {
        self.connectivity = input;
        self
    }
    /// <p>Indicates whether the external key store proxy uses a public endpoint or an Amazon VPC endpoint service to communicate with KMS.</p>
    pub fn get_connectivity(&self) -> &::std::option::Option<crate::types::XksProxyConnectivityType> {
        &self.connectivity
    }
    /// <p>The part of the external key store <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateCustomKeyStore.html#KMS-CreateCustomKeyStore-request-XksProxyAuthenticationCredential">proxy authentication credential</a> that uniquely identifies the secret access key.</p>
    pub fn access_key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.access_key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The part of the external key store <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateCustomKeyStore.html#KMS-CreateCustomKeyStore-request-XksProxyAuthenticationCredential">proxy authentication credential</a> that uniquely identifies the secret access key.</p>
    pub fn set_access_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.access_key_id = input;
        self
    }
    /// <p>The part of the external key store <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateCustomKeyStore.html#KMS-CreateCustomKeyStore-request-XksProxyAuthenticationCredential">proxy authentication credential</a> that uniquely identifies the secret access key.</p>
    pub fn get_access_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.access_key_id
    }
    /// <p>The URI endpoint for the external key store proxy.</p>
    /// <p>If the external key store proxy has a public endpoint, it is displayed here.</p>
    /// <p>If the external key store proxy uses an Amazon VPC endpoint service name, this field displays the private DNS name associated with the VPC endpoint service.</p>
    pub fn uri_endpoint(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.uri_endpoint = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The URI endpoint for the external key store proxy.</p>
    /// <p>If the external key store proxy has a public endpoint, it is displayed here.</p>
    /// <p>If the external key store proxy uses an Amazon VPC endpoint service name, this field displays the private DNS name associated with the VPC endpoint service.</p>
    pub fn set_uri_endpoint(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.uri_endpoint = input;
        self
    }
    /// <p>The URI endpoint for the external key store proxy.</p>
    /// <p>If the external key store proxy has a public endpoint, it is displayed here.</p>
    /// <p>If the external key store proxy uses an Amazon VPC endpoint service name, this field displays the private DNS name associated with the VPC endpoint service.</p>
    pub fn get_uri_endpoint(&self) -> &::std::option::Option<::std::string::String> {
        &self.uri_endpoint
    }
    /// <p>The path to the external key store proxy APIs.</p>
    pub fn uri_path(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.uri_path = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The path to the external key store proxy APIs.</p>
    pub fn set_uri_path(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.uri_path = input;
        self
    }
    /// <p>The path to the external key store proxy APIs.</p>
    pub fn get_uri_path(&self) -> &::std::option::Option<::std::string::String> {
        &self.uri_path
    }
    /// <p>The Amazon VPC endpoint service used to communicate with the external key store proxy. This field appears only when the external key store proxy uses an Amazon VPC endpoint service to communicate with KMS.</p>
    pub fn vpc_endpoint_service_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.vpc_endpoint_service_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon VPC endpoint service used to communicate with the external key store proxy. This field appears only when the external key store proxy uses an Amazon VPC endpoint service to communicate with KMS.</p>
    pub fn set_vpc_endpoint_service_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.vpc_endpoint_service_name = input;
        self
    }
    /// <p>The Amazon VPC endpoint service used to communicate with the external key store proxy. This field appears only when the external key store proxy uses an Amazon VPC endpoint service to communicate with KMS.</p>
    pub fn get_vpc_endpoint_service_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.vpc_endpoint_service_name
    }
    /// Consumes the builder and constructs a [`XksProxyConfigurationType`](crate::types::XksProxyConfigurationType).
    pub fn build(self) -> crate::types::XksProxyConfigurationType {
        crate::types::XksProxyConfigurationType {
            connectivity: self.connectivity,
            access_key_id: self.access_key_id,
            uri_endpoint: self.uri_endpoint,
            uri_path: self.uri_path,
            vpc_endpoint_service_name: self.vpc_endpoint_service_name,
        }
    }
}
impl ::std::fmt::Debug for XksProxyConfigurationTypeBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("XksProxyConfigurationTypeBuilder");
        formatter.field("connectivity", &self.connectivity);
        formatter.field("access_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("uri_endpoint", &self.uri_endpoint);
        formatter.field("uri_path", &self.uri_path);
        formatter.field("vpc_endpoint_service_name", &self.vpc_endpoint_service_name);
        formatter.finish()
    }
}
