# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=wrong-import-position

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ._patch import *  # pylint: disable=unused-wildcard-import


from ._models_py3 import (  # type: ignore
    AccessUri,
    ApiError,
    ApiErrorBase,
    CopyCompletionError,
    CreationData,
    Disk,
    DiskAccess,
    DiskAccessList,
    DiskAccessUpdate,
    DiskEncryptionSet,
    DiskEncryptionSetList,
    DiskEncryptionSetUpdate,
    DiskList,
    DiskRestorePoint,
    DiskRestorePointList,
    DiskSecurityProfile,
    DiskSku,
    DiskUpdate,
    Encryption,
    EncryptionSetIdentity,
    EncryptionSettingsCollection,
    EncryptionSettingsElement,
    ExtendedLocation,
    GrantAccessData,
    ImageDiskReference,
    InnerError,
    KeyForDiskEncryptionSet,
    KeyVaultAndKeyReference,
    KeyVaultAndSecretReference,
    PrivateEndpoint,
    PrivateEndpointConnection,
    PrivateEndpointConnectionListResult,
    PrivateLinkResource,
    PrivateLinkResourceListResult,
    PrivateLinkServiceConnectionState,
    PropertyUpdatesInProgress,
    ProxyOnlyResource,
    PurchasePlan,
    Resource,
    ResourceUriList,
    ResourceWithOptionalLocation,
    ShareInfoElement,
    Snapshot,
    SnapshotList,
    SnapshotSku,
    SnapshotUpdate,
    SourceVault,
    SubResource,
    SubResourceReadOnly,
    SupportedCapabilities,
    SystemData,
    UserAssignedIdentitiesValue,
)

from ._compute_management_client_enums import (  # type: ignore
    AccessLevel,
    Architecture,
    CopyCompletionErrorReason,
    DataAccessAuthMode,
    DiskCreateOption,
    DiskEncryptionSetIdentityType,
    DiskEncryptionSetType,
    DiskSecurityTypes,
    DiskState,
    DiskStorageAccountTypes,
    EncryptionType,
    ExtendedLocationTypes,
    HyperVGeneration,
    NetworkAccessPolicy,
    OperatingSystemTypes,
    PrivateEndpointConnectionProvisioningState,
    PrivateEndpointServiceConnectionStatus,
    PublicNetworkAccess,
    SnapshotStorageAccountTypes,
)
from ._patch import __all__ as _patch_all
from ._patch import *
from ._patch import patch_sdk as _patch_sdk

__all__ = [
    "AccessUri",
    "ApiError",
    "ApiErrorBase",
    "CopyCompletionError",
    "CreationData",
    "Disk",
    "DiskAccess",
    "DiskAccessList",
    "DiskAccessUpdate",
    "DiskEncryptionSet",
    "DiskEncryptionSetList",
    "DiskEncryptionSetUpdate",
    "DiskList",
    "DiskRestorePoint",
    "DiskRestorePointList",
    "DiskSecurityProfile",
    "DiskSku",
    "DiskUpdate",
    "Encryption",
    "EncryptionSetIdentity",
    "EncryptionSettingsCollection",
    "EncryptionSettingsElement",
    "ExtendedLocation",
    "GrantAccessData",
    "ImageDiskReference",
    "InnerError",
    "KeyForDiskEncryptionSet",
    "KeyVaultAndKeyReference",
    "KeyVaultAndSecretReference",
    "PrivateEndpoint",
    "PrivateEndpointConnection",
    "PrivateEndpointConnectionListResult",
    "PrivateLinkResource",
    "PrivateLinkResourceListResult",
    "PrivateLinkServiceConnectionState",
    "PropertyUpdatesInProgress",
    "ProxyOnlyResource",
    "PurchasePlan",
    "Resource",
    "ResourceUriList",
    "ResourceWithOptionalLocation",
    "ShareInfoElement",
    "Snapshot",
    "SnapshotList",
    "SnapshotSku",
    "SnapshotUpdate",
    "SourceVault",
    "SubResource",
    "SubResourceReadOnly",
    "SupportedCapabilities",
    "SystemData",
    "UserAssignedIdentitiesValue",
    "AccessLevel",
    "Architecture",
    "CopyCompletionErrorReason",
    "DataAccessAuthMode",
    "DiskCreateOption",
    "DiskEncryptionSetIdentityType",
    "DiskEncryptionSetType",
    "DiskSecurityTypes",
    "DiskState",
    "DiskStorageAccountTypes",
    "EncryptionType",
    "ExtendedLocationTypes",
    "HyperVGeneration",
    "NetworkAccessPolicy",
    "OperatingSystemTypes",
    "PrivateEndpointConnectionProvisioningState",
    "PrivateEndpointServiceConnectionStatus",
    "PublicNetworkAccess",
    "SnapshotStorageAccountTypes",
]
__all__.extend([p for p in _patch_all if p not in __all__])  # pyright: ignore
_patch_sdk()
