
// Copyright (C) 2008-2018 Lorenzo Caminiti
// Distributed under the Boost Software License, Version 1.0 (see accompanying
// file LICENSE_1_0.txt or a copy at http://www.boost.org/LICENSE_1_0.txt).
// See: http://www.boost.org/doc/libs/release/libs/contract/doc/html/index.html

#include <boost/contract.hpp>
#include <vector>
#include <algorithm>
#include <limits>

int main() {
    std::vector<int> v;
    v.push_back(1);
    v.push_back(2);
    v.push_back(3);

    //[loop
    int total = 0;
    // Contract for a for-loop (same for while- and all other loops).
    for(std::vector<int>::const_iterator i = v.begin(); i != v.end(); ++i) {
        boost::contract::old_ptr<int> old_total = BOOST_CONTRACT_OLDOF(total);
        boost::contract::check c = boost::contract::function()
            .precondition([&] {
                BOOST_CONTRACT_ASSERT(
                        total < std::numeric_limits<int>::max() - *i);
            })
            .postcondition([&] {
                BOOST_CONTRACT_ASSERT(total == *old_total + *i);
            })
        ;

        total += *i; // For-loop body.
    }
    //]

    assert(total == 6);
    return 0;
}

