/*
  Copyright (c) [2020] SUSE LLC
  
  This library is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the
  License, or (at your option) version 3.0 of the License. This library
  is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
  License for more details. You should have received a copy of the GNU
  Lesser General Public License along with this library; if not, write
  to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
  Floor, Boston, MA 02110-1301 USA
*/


#ifndef LoremIpsum_h
#define LoremIpsum_h

#include <string>

/**
 * Return a text of length 'len' of the "lorem ipsum" text below.
 * A length of -1 returns the complete text.
 **/
std::string loremIpsum( int len = -1 );


std::string loremIpsumLong =
    // Generated by https://loremipsum.io/generator/
    "Lörem üpsum dolör sit amet, consectetür ädipiscing elit, sed dö "
    "eiusmod tempor incididunt ut labore et dolore magna aliqua. Quis "
    "commodo odio aenean sed adipiscing diam donec adipiscing "
    "tristique. Fermentum posuere urna nec tincidunt praesent semper. Cras "
    "fermentum odio eu feugiat pretium nibh ipsum consequat nisl. Ac felis "
    "donec et odio. Semper eget duis at tellus at urna condimentum. "
    "Pellentesque massa placerat duis ultricies lacus sed turpis. Aliquam "
    "id diam maecenas ultricies mi eget mauris pharetra. Vulputate odio ut "
    "enim blandit. Sit amet aliquam id diam maecenas ultricies mi. Mi sit "
    "amet mauris commodo. Velit aliquet sagittis id consectetur purus "
    "ut. Nam at lectus urna duis. Cras semper auctor neque vitae "
    "tempus. Tristique et egestas quis ipsum suspendisse ultrices."
    "\n"
    "Auctor elit sed vulputate mi sit amet mauris commodo. Nunc eget lorem "
    "dolor sed viverra ipsum. Id donec ultrices tincidunt arcu non "
    "sodales. Eget felis eget nunc lobortis mattis aliquam faucibus "
    "purus. Sit amet consectetur adipiscing elit. Faucibus et molestie ac "
    "feugiat sed lectus vestibulum. Vel quam elementum pulvinar etiam "
    "non. Ridiculus mus mauris vitae ultricies. Senectus et netus et "
    "malesuada fames ac turpis egestas. Id leo in vitae turpis massa. "
    "Condimentum lacinia quis vel eros. Porttitor massa id neque aliquam "
    "vestibulum morbi. Vel eros donec ac odio tempor orci. Nec sagittis "
    "aliquam malesuada bibendum. Tincidunt vitae semper quis lectus nulla "
    "at volutpat diam ut. Vel pharetra vel turpis nunc eget lorem dolor "
    "sed."
    "\n"
    "Ultricies integer quis auctor elit sed vulputate mi sit. Vel elit "
    "scelerisque mauris pellentesque. Consequat id porta nibh venenatis "
    "cras sed felis eget velit. Ornare massa eget egestas purus viverra. "
    "Curabitur gravida arcu ac tortor dignissim convallis aenean et "
    "tortor. Mauris vitae ultricies leo integer. Pellentesque eu tincidunt "
    "tortor aliquam nulla facilisi. Consectetur a erat nam at lectus. Amet "
    "tellus cras adipiscing enim eu turpis egestas pretium. Vehicula ipsum "
    "a arcu cursus vitae. Massa sapien faucibus et molestie ac feugiat sed "
    "lectus vestibulum. Turpis egestas sed tempus urna et. Iaculis eu non "
    "diam phasellus. Consectetur lorem donec massa sapien. Lobortis "
    "elementum nibh tellus molestie nunc non. Eget mauris pharetra et "
    "ultrices neque ornare aenean euismod. Nec tincidunt praesent semper "
    "feugiat. In massa tempor nec feugiat nisl.";


std::string loremIpsum( int len )
{
    if ( len < 1 )
        return loremIpsumLong;
    else
        return loremIpsumLong.substr( 0, len );
}


#endif // LoremIpsum_h
