/**********************************************************************
 * $list_nets example -- C source code using ACC PLI routines
 *
 * C source to scan through a module and list the names of all nets in
 * the module with the current logic value.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: $list_nets(<module_instance>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_ListNets_checktf(),
 *              PLIbook_ListNets_calltf();
 *  /* table entries -/
 *   {usertask,                       /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     PLIbook_ListNets_checktf,      /* checktf routine -/
 *     0,                             /* sizetf routine -/
 *     PLIbook_ListNets_calltf,       /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$list_nets",                  /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_ListNets_checktf()
{
  acc_initialize();
  if (tf_nump() != 1)
    tf_error("$list_nets must have 1 argument.");
  else if (tf_typep(1) == TF_NULLPARAM)
    tf_error("$list_nets arg cannot be null.");
  else if (acc_fetch_type(acc_handle_tfarg(1)) != accModule)
    tf_error("$list_nets arg must be a module instance.");
  acc_close();
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_ListNets_calltf()
{
  handle module_h, net_h;
  acc_initialize();
  module_h = acc_handle_tfarg(1);
  io_printf("\nNet values in module %s:\n",
            acc_fetch_fullname(module_h));
  net_h = null;    /* start with known value for target handle */
  while (net_h = acc_next_net(module_h, net_h)) {
    io_printf("  %-10s:  %s\n",
              acc_fetch_name(net_h),
              acc_fetch_value(net_h, "%b", null));
  }
  acc_close();
  return(0);
}
/*********************************************************************/

