/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.StringTokenizer;

public final class FinalList {
    public static final String ALL = "#all";
    public static final String EXTENSION = "extension";
    public static final String RESTRICTION = "restriction";
    private boolean _all = false;
    private boolean _extension = false;
    private boolean _restriction = false;

    public FinalList() {
    }

    public FinalList(String listOfValues) {
        if (listOfValues != null) {
            this.parseValues(listOfValues);
        }
    }

    public boolean hasAll() {
        return this._all;
    }

    public boolean hasExtension() {
        return this._extension;
    }

    public boolean hasRestriction() {
        return this._restriction;
    }

    public String toString() {
        if (this._all) {
            return ALL;
        }
        StringBuffer value = new StringBuffer();
        if (this._extension) {
            value.append(EXTENSION);
        }
        if (this._restriction) {
            if (value.length() > 0) {
                value.append(' ');
            }
            value.append(RESTRICTION);
        }
        return value.toString();
    }

    private void parseValues(String values) {
        if (ALL.equals(values)) {
            this._all = true;
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(values);
        while (tokenizer.hasMoreTokens()) {
            String value = tokenizer.nextToken();
            if (EXTENSION.equals(value)) {
                this._extension = true;
                continue;
            }
            if (RESTRICTION.equals(value)) {
                this._restriction = true;
                continue;
            }
            String err = "invalid final list: " + values;
            throw new IllegalArgumentException(err);
        }
    }
}

