/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.dtd;

import org.exolab.castor.xml.dtd.DTDdocument;

public class GeneralEntity {
    private static final short INTERNAL = 0;
    private static final short EXTERNAL_PUBLIC = 1;
    private static final short EXTERNAL_SYSTEM = 2;
    private String name = null;
    private DTDdocument document = null;
    private String value = null;
    private short type = (short)-1;
    private String pubIdentifier = null;
    private String sysIdentifier = null;
    private String ndata = null;

    public GeneralEntity() {
    }

    public GeneralEntity(DTDdocument document, String name) {
        if (document == null) {
            String err = "GeneralEntity constructor: document must not be null.";
            throw new IllegalArgumentException(err);
        }
        if (name == null || name.equals("")) {
            String err = "GeneralEntity constructor: name must not be empty.";
            throw new IllegalArgumentException(err);
        }
        this.name = name;
        this.document = document;
    }

    public String getName() {
        return this.name;
    }

    public DTDdocument getDocument() {
        return this.document;
    }

    public void setValue(String value) {
        if (value == null) {
            String err = "GeneralEntity: can not set null value.";
            throw new IllegalArgumentException(err);
        }
        this.type = 0;
        this.value = value;
    }

    public boolean isInternal() {
        return this.type == 0;
    }

    public String getValue() {
        if (this.isInternal()) {
            return this.value;
        }
        return null;
    }

    public void setExternalPublic(String pubId, String sysId) {
        if (pubId == null) {
            String err = "GeneralEntity: can not set null public ID.";
            throw new IllegalArgumentException(err);
        }
        if (sysId == null) {
            String err = "GeneralEntity: can not set null system ID.";
            throw new IllegalArgumentException(err);
        }
        this.type = 1;
        this.pubIdentifier = pubId;
        this.sysIdentifier = sysId;
    }

    public boolean isExternalPublic() {
        return this.type == 1;
    }

    public void setExternalSystem(String sysId) {
        if (sysId == null) {
            String err = "GeneralEntity: can not set null system ID.";
            throw new IllegalArgumentException(err);
        }
        this.type = (short)2;
        this.sysIdentifier = sysId;
    }

    public boolean isExternalSystem() {
        return this.type == 2;
    }

    public String getSysIdentifier() {
        if (this.isExternalSystem() || this.isExternalPublic()) {
            return this.sysIdentifier;
        }
        return null;
    }

    public String getPubIdentifier() {
        if (this.isExternalPublic()) {
            return this.pubIdentifier;
        }
        return null;
    }

    public void setNDATA(String notationName) {
        if (notationName == null || notationName.equals("")) {
            String err = "General Entity: can not set empty associated notation name.";
            throw new IllegalArgumentException(err);
        }
        this.ndata = notationName;
    }

    public boolean isExternalUnparsed() {
        return (this.isExternalPublic() || this.isExternalSystem()) && this.ndata != null;
    }

    public String getNotation() {
        if (this.isExternalPublic() || this.isExternalSystem()) {
            return this.ndata;
        }
        return null;
    }
}

