/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.report;

import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import fr.jayasoft.ivy.report.ConfigurationResolveReport;
import fr.jayasoft.ivy.report.ReportOutputter;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResolveReport {
    private ModuleDescriptor _md;
    private Map _confReports = new LinkedHashMap();

    public ResolveReport(ModuleDescriptor md) {
        this._md = md;
    }

    public void addReport(String conf, ConfigurationResolveReport report) {
        this._confReports.put(conf, report);
    }

    public ConfigurationResolveReport getConfigurationReport(String conf) {
        return (ConfigurationResolveReport)this._confReports.get(conf);
    }

    public String[] getConfigurations() {
        return this._confReports.keySet().toArray(new String[this._confReports.size()]);
    }

    public boolean hasError() {
        boolean hasError;
        ConfigurationResolveReport report;
        Iterator it = this._confReports.values().iterator();
        for (hasError = false; it.hasNext() && !hasError; hasError |= report.hasError()) {
            report = (ConfigurationResolveReport)it.next();
        }
        return hasError;
    }

    public void output(ReportOutputter[] outputters, File cache) {
        for (int i = 0; i < outputters.length; ++i) {
            outputters[i].output(this, cache);
        }
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this._md;
    }

    public IvyNode[] getEvictedNodes() {
        HashSet<IvyNode> all = new HashSet<IvyNode>();
        Iterator iter = this._confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            all.addAll(Arrays.asList(report.getEvictedNodes()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public IvyNode[] getUnresolvedDependencies() {
        HashSet<IvyNode> all = new HashSet<IvyNode>();
        Iterator iter = this._confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            all.addAll(Arrays.asList(report.getUnresolvedDependencies()));
        }
        return all.toArray(new IvyNode[all.size()]);
    }

    public ArtifactDownloadReport[] getFailedArtifactsReports() {
        HashSet<ArtifactDownloadReport> all = new HashSet<ArtifactDownloadReport>();
        Iterator iter = this._confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            all.addAll(Arrays.asList(report.getFailedArtifactsReports()));
        }
        return all.toArray(new ArtifactDownloadReport[all.size()]);
    }

    public boolean hasChanged() {
        Iterator iter = this._confReports.values().iterator();
        while (iter.hasNext()) {
            ConfigurationResolveReport report = (ConfigurationResolveReport)iter.next();
            if (!report.hasChanged()) continue;
            return true;
        }
        return false;
    }
}

