# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
from typing import Any, Callable, Dict, IO, List, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ... import models as _models
from ..._operations._operations import build_quickpulse_ping_request, build_quickpulse_post_request
from .._vendor import QuickpulseClientMixinABC

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class QuickpulseClientOperationsMixin(QuickpulseClientMixinABC):
    @overload
    async def ping(
        self,
        monitoring_data_point: Optional[_models.MonitoringDataPoint] = None,
        *,
        ikey: str,
        apikey: Optional[str] = None,
        x_ms_qps_transmission_time: Optional[int] = None,
        x_ms_qps_machine_name: Optional[str] = None,
        x_ms_qps_instance_name: Optional[str] = None,
        x_ms_qps_stream_id: Optional[str] = None,
        x_ms_qps_role_name: Optional[str] = None,
        x_ms_qps_invariant_version: Optional[str] = None,
        x_ms_qps_configuration_etag: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[_models.CollectionConfigurationInfo, _models.ServiceError]:
        """SDK ping.

        SDK ping.

        :param monitoring_data_point: Data contract between SDK and QuickPulse.
         /QuickPulseService.svc/ping uses this as a backup source of machine name, instance name and
         invariant version. Default value is None.
        :type monitoring_data_point: ~quickpulse_client.models.MonitoringDataPoint
        :keyword ikey: The ikey of the target Application Insights component that displays server info
         sent by /QuickPulseService.svc/ping. Required.
        :paramtype ikey: str
        :keyword apikey: Deprecated. An alternative way to pass api key. Use AAD auth instead. Default
         value is None.
        :paramtype apikey: str
        :keyword x_ms_qps_transmission_time: Timestamp when SDK transmits the metrics and documents to
         QuickPulse. A 8-byte long type of ticks. Default value is None.
        :paramtype x_ms_qps_transmission_time: int
        :keyword x_ms_qps_machine_name: Computer name where AI SDK lives. QuickPulse uses machine name
         with instance name as a backup. Default value is None.
        :paramtype x_ms_qps_machine_name: str
        :keyword x_ms_qps_instance_name: Service instance name where AI SDK lives. QuickPulse uses
         machine name with instance name as a backup. Default value is None.
        :paramtype x_ms_qps_instance_name: str
        :keyword x_ms_qps_stream_id: Identifies an AI SDK as trusted agent to report metrics and
         documents. Default value is None.
        :paramtype x_ms_qps_stream_id: str
        :keyword x_ms_qps_role_name: Cloud role name for which SDK reports metrics and documents.
         Default value is None.
        :paramtype x_ms_qps_role_name: str
        :keyword x_ms_qps_invariant_version: Version/generation of the data contract
         (MonitoringDataPoint) between SDK and QuickPulse. Default value is None.
        :paramtype x_ms_qps_invariant_version: str
        :keyword x_ms_qps_configuration_etag: An encoded string that indicates whether the collection
         configuration is changed. Default value is None.
        :paramtype x_ms_qps_configuration_etag: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CollectionConfigurationInfo or ServiceError
        :rtype: ~quickpulse_client.models.CollectionConfigurationInfo or
         ~quickpulse_client.models.ServiceError
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def ping(
        self,
        monitoring_data_point: Optional[IO[bytes]] = None,
        *,
        ikey: str,
        apikey: Optional[str] = None,
        x_ms_qps_transmission_time: Optional[int] = None,
        x_ms_qps_machine_name: Optional[str] = None,
        x_ms_qps_instance_name: Optional[str] = None,
        x_ms_qps_stream_id: Optional[str] = None,
        x_ms_qps_role_name: Optional[str] = None,
        x_ms_qps_invariant_version: Optional[str] = None,
        x_ms_qps_configuration_etag: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[_models.CollectionConfigurationInfo, _models.ServiceError]:
        """SDK ping.

        SDK ping.

        :param monitoring_data_point: Data contract between SDK and QuickPulse.
         /QuickPulseService.svc/ping uses this as a backup source of machine name, instance name and
         invariant version. Default value is None.
        :type monitoring_data_point: IO[bytes]
        :keyword ikey: The ikey of the target Application Insights component that displays server info
         sent by /QuickPulseService.svc/ping. Required.
        :paramtype ikey: str
        :keyword apikey: Deprecated. An alternative way to pass api key. Use AAD auth instead. Default
         value is None.
        :paramtype apikey: str
        :keyword x_ms_qps_transmission_time: Timestamp when SDK transmits the metrics and documents to
         QuickPulse. A 8-byte long type of ticks. Default value is None.
        :paramtype x_ms_qps_transmission_time: int
        :keyword x_ms_qps_machine_name: Computer name where AI SDK lives. QuickPulse uses machine name
         with instance name as a backup. Default value is None.
        :paramtype x_ms_qps_machine_name: str
        :keyword x_ms_qps_instance_name: Service instance name where AI SDK lives. QuickPulse uses
         machine name with instance name as a backup. Default value is None.
        :paramtype x_ms_qps_instance_name: str
        :keyword x_ms_qps_stream_id: Identifies an AI SDK as trusted agent to report metrics and
         documents. Default value is None.
        :paramtype x_ms_qps_stream_id: str
        :keyword x_ms_qps_role_name: Cloud role name for which SDK reports metrics and documents.
         Default value is None.
        :paramtype x_ms_qps_role_name: str
        :keyword x_ms_qps_invariant_version: Version/generation of the data contract
         (MonitoringDataPoint) between SDK and QuickPulse. Default value is None.
        :paramtype x_ms_qps_invariant_version: str
        :keyword x_ms_qps_configuration_etag: An encoded string that indicates whether the collection
         configuration is changed. Default value is None.
        :paramtype x_ms_qps_configuration_etag: str
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CollectionConfigurationInfo or ServiceError
        :rtype: ~quickpulse_client.models.CollectionConfigurationInfo or
         ~quickpulse_client.models.ServiceError
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def ping(
        self,
        monitoring_data_point: Optional[Union[_models.MonitoringDataPoint, IO[bytes]]] = None,
        *,
        ikey: str,
        apikey: Optional[str] = None,
        x_ms_qps_transmission_time: Optional[int] = None,
        x_ms_qps_machine_name: Optional[str] = None,
        x_ms_qps_instance_name: Optional[str] = None,
        x_ms_qps_stream_id: Optional[str] = None,
        x_ms_qps_role_name: Optional[str] = None,
        x_ms_qps_invariant_version: Optional[str] = None,
        x_ms_qps_configuration_etag: Optional[str] = None,
        **kwargs: Any
    ) -> Union[_models.CollectionConfigurationInfo, _models.ServiceError]:
        """SDK ping.

        SDK ping.

        :param monitoring_data_point: Data contract between SDK and QuickPulse.
         /QuickPulseService.svc/ping uses this as a backup source of machine name, instance name and
         invariant version. Is either a MonitoringDataPoint type or a IO[bytes] type. Default value is
         None.
        :type monitoring_data_point: ~quickpulse_client.models.MonitoringDataPoint or IO[bytes]
        :keyword ikey: The ikey of the target Application Insights component that displays server info
         sent by /QuickPulseService.svc/ping. Required.
        :paramtype ikey: str
        :keyword apikey: Deprecated. An alternative way to pass api key. Use AAD auth instead. Default
         value is None.
        :paramtype apikey: str
        :keyword x_ms_qps_transmission_time: Timestamp when SDK transmits the metrics and documents to
         QuickPulse. A 8-byte long type of ticks. Default value is None.
        :paramtype x_ms_qps_transmission_time: int
        :keyword x_ms_qps_machine_name: Computer name where AI SDK lives. QuickPulse uses machine name
         with instance name as a backup. Default value is None.
        :paramtype x_ms_qps_machine_name: str
        :keyword x_ms_qps_instance_name: Service instance name where AI SDK lives. QuickPulse uses
         machine name with instance name as a backup. Default value is None.
        :paramtype x_ms_qps_instance_name: str
        :keyword x_ms_qps_stream_id: Identifies an AI SDK as trusted agent to report metrics and
         documents. Default value is None.
        :paramtype x_ms_qps_stream_id: str
        :keyword x_ms_qps_role_name: Cloud role name for which SDK reports metrics and documents.
         Default value is None.
        :paramtype x_ms_qps_role_name: str
        :keyword x_ms_qps_invariant_version: Version/generation of the data contract
         (MonitoringDataPoint) between SDK and QuickPulse. Default value is None.
        :paramtype x_ms_qps_invariant_version: str
        :keyword x_ms_qps_configuration_etag: An encoded string that indicates whether the collection
         configuration is changed. Default value is None.
        :paramtype x_ms_qps_configuration_etag: str
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: CollectionConfigurationInfo or ServiceError
        :rtype: ~quickpulse_client.models.CollectionConfigurationInfo or
         ~quickpulse_client.models.ServiceError
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Union[_models.CollectionConfigurationInfo, _models.ServiceError]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(monitoring_data_point, (IOBase, bytes)):
            _content = monitoring_data_point
        else:
            if monitoring_data_point is not None:
                _json = self._serialize.body(monitoring_data_point, "MonitoringDataPoint")
            else:
                _json = None

        _request = build_quickpulse_ping_request(
            ikey=ikey,
            apikey=apikey,
            x_ms_qps_transmission_time=x_ms_qps_transmission_time,
            x_ms_qps_machine_name=x_ms_qps_machine_name,
            x_ms_qps_instance_name=x_ms_qps_instance_name,
            x_ms_qps_stream_id=x_ms_qps_stream_id,
            x_ms_qps_role_name=x_ms_qps_role_name,
            x_ms_qps_invariant_version=x_ms_qps_invariant_version,
            x_ms_qps_configuration_etag=x_ms_qps_configuration_etag,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Host": self._serialize.url("self._config.host", self._config.host, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 403, 404, 500, 503]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["x-ms-qps-subscribed"] = self._deserialize(
                "str", response.headers.get("x-ms-qps-subscribed")
            )
            response_headers["x-ms-qps-configuration-etag"] = self._deserialize(
                "str", response.headers.get("x-ms-qps-configuration-etag")
            )
            response_headers["x-ms-qps-service-polling-interval-hint"] = self._deserialize(
                "int", response.headers.get("x-ms-qps-service-polling-interval-hint")
            )
            response_headers["x-ms-qps-service-endpoint-redirect-v2"] = self._deserialize(
                "str", response.headers.get("x-ms-qps-service-endpoint-redirect-v2")
            )

            deserialized = self._deserialize("CollectionConfigurationInfo", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("ServiceError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("ServiceError", pipeline_response)

        if response.status_code == 403:
            deserialized = self._deserialize("ServiceError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("ServiceError", pipeline_response)

        if response.status_code == 500:
            deserialized = self._deserialize("ServiceError", pipeline_response)

        if response.status_code == 503:
            deserialized = self._deserialize("ServiceError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def post(
        self,
        monitoring_data_points: Optional[List[_models.MonitoringDataPoint]] = None,
        *,
        ikey: str,
        apikey: Optional[str] = None,
        x_ms_qps_configuration_etag: Optional[str] = None,
        x_ms_qps_transmission_time: Optional[int] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[_models.CollectionConfigurationInfo, _models.ServiceError]:
        """SDK post.

        SDK post.

        :param monitoring_data_points: Data contract between SDK and QuickPulse.
         /QuickPulseService.svc/post uses this to publish metrics and documents to the backend
         QuickPulse server. Default value is None.
        :type monitoring_data_points: list[~quickpulse_client.models.MonitoringDataPoint]
        :keyword ikey: The ikey of the target Application Insights component that displays metrics and
         documents sent by /QuickPulseService.svc/post. Required.
        :paramtype ikey: str
        :keyword apikey: An alternative way to pass api key. Deprecated. Use AAD authentication
         instead. Default value is None.
        :paramtype apikey: str
        :keyword x_ms_qps_configuration_etag: An encoded string that indicates whether the collection
         configuration is changed. Default value is None.
        :paramtype x_ms_qps_configuration_etag: str
        :keyword x_ms_qps_transmission_time: Timestamp when SDK transmits the metrics and documents to
         QuickPulse. A 8-byte long type of ticks. Default value is None.
        :paramtype x_ms_qps_transmission_time: int
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CollectionConfigurationInfo or ServiceError
        :rtype: ~quickpulse_client.models.CollectionConfigurationInfo or
         ~quickpulse_client.models.ServiceError
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def post(
        self,
        monitoring_data_points: Optional[IO[bytes]] = None,
        *,
        ikey: str,
        apikey: Optional[str] = None,
        x_ms_qps_configuration_etag: Optional[str] = None,
        x_ms_qps_transmission_time: Optional[int] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> Union[_models.CollectionConfigurationInfo, _models.ServiceError]:
        """SDK post.

        SDK post.

        :param monitoring_data_points: Data contract between SDK and QuickPulse.
         /QuickPulseService.svc/post uses this to publish metrics and documents to the backend
         QuickPulse server. Default value is None.
        :type monitoring_data_points: IO[bytes]
        :keyword ikey: The ikey of the target Application Insights component that displays metrics and
         documents sent by /QuickPulseService.svc/post. Required.
        :paramtype ikey: str
        :keyword apikey: An alternative way to pass api key. Deprecated. Use AAD authentication
         instead. Default value is None.
        :paramtype apikey: str
        :keyword x_ms_qps_configuration_etag: An encoded string that indicates whether the collection
         configuration is changed. Default value is None.
        :paramtype x_ms_qps_configuration_etag: str
        :keyword x_ms_qps_transmission_time: Timestamp when SDK transmits the metrics and documents to
         QuickPulse. A 8-byte long type of ticks. Default value is None.
        :paramtype x_ms_qps_transmission_time: int
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CollectionConfigurationInfo or ServiceError
        :rtype: ~quickpulse_client.models.CollectionConfigurationInfo or
         ~quickpulse_client.models.ServiceError
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def post(
        self,
        monitoring_data_points: Optional[Union[List[_models.MonitoringDataPoint], IO[bytes]]] = None,
        *,
        ikey: str,
        apikey: Optional[str] = None,
        x_ms_qps_configuration_etag: Optional[str] = None,
        x_ms_qps_transmission_time: Optional[int] = None,
        **kwargs: Any
    ) -> Union[_models.CollectionConfigurationInfo, _models.ServiceError]:
        """SDK post.

        SDK post.

        :param monitoring_data_points: Data contract between SDK and QuickPulse.
         /QuickPulseService.svc/post uses this to publish metrics and documents to the backend
         QuickPulse server. Is either a [MonitoringDataPoint] type or a IO[bytes] type. Default value is
         None.
        :type monitoring_data_points: list[~quickpulse_client.models.MonitoringDataPoint] or IO[bytes]
        :keyword ikey: The ikey of the target Application Insights component that displays metrics and
         documents sent by /QuickPulseService.svc/post. Required.
        :paramtype ikey: str
        :keyword apikey: An alternative way to pass api key. Deprecated. Use AAD authentication
         instead. Default value is None.
        :paramtype apikey: str
        :keyword x_ms_qps_configuration_etag: An encoded string that indicates whether the collection
         configuration is changed. Default value is None.
        :paramtype x_ms_qps_configuration_etag: str
        :keyword x_ms_qps_transmission_time: Timestamp when SDK transmits the metrics and documents to
         QuickPulse. A 8-byte long type of ticks. Default value is None.
        :paramtype x_ms_qps_transmission_time: int
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: CollectionConfigurationInfo or ServiceError
        :rtype: ~quickpulse_client.models.CollectionConfigurationInfo or
         ~quickpulse_client.models.ServiceError
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[Union[_models.CollectionConfigurationInfo, _models.ServiceError]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(monitoring_data_points, (IOBase, bytes)):
            _content = monitoring_data_points
        else:
            if monitoring_data_points is not None:
                _json = self._serialize.body(monitoring_data_points, "[MonitoringDataPoint]")
            else:
                _json = None

        _request = build_quickpulse_post_request(
            ikey=ikey,
            apikey=apikey,
            x_ms_qps_configuration_etag=x_ms_qps_configuration_etag,
            x_ms_qps_transmission_time=x_ms_qps_transmission_time,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "Host": self._serialize.url("self._config.host", self._config.host, "str", skip_quote=True),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 400, 401, 403, 404, 500, 503]:
            if _stream:
                await response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["x-ms-qps-subscribed"] = self._deserialize(
                "str", response.headers.get("x-ms-qps-subscribed")
            )
            response_headers["x-ms-qps-configuration-etag"] = self._deserialize(
                "str", response.headers.get("x-ms-qps-configuration-etag")
            )
            response_headers["x-ms-qps-service-polling-interval-hint"] = self._deserialize(
                "int", response.headers.get("x-ms-qps-service-polling-interval-hint")
            )
            response_headers["x-ms-qps-service-endpoint-redirect"] = self._deserialize(
                "str", response.headers.get("x-ms-qps-service-endpoint-redirect")
            )
            response_headers["x-ms-qps-service-endpoint-redirect-v2"] = self._deserialize(
                "str", response.headers.get("x-ms-qps-service-endpoint-redirect-v2")
            )

            deserialized = self._deserialize("CollectionConfigurationInfo", pipeline_response)

        if response.status_code == 400:
            deserialized = self._deserialize("ServiceError", pipeline_response)

        if response.status_code == 401:
            deserialized = self._deserialize("ServiceError", pipeline_response)

        if response.status_code == 403:
            deserialized = self._deserialize("ServiceError", pipeline_response)

        if response.status_code == 404:
            deserialized = self._deserialize("ServiceError", pipeline_response)

        if response.status_code == 500:
            deserialized = self._deserialize("ServiceError", pipeline_response)

        if response.status_code == 503:
            deserialized = self._deserialize("ServiceError", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore
