/* valatypeparameter.c generated by valac, the Vala compiler
 * generated from valatypeparameter.vala, do not modify */

/* valatypeparameter.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>



static gpointer vala_typeparameter_parent_class = NULL;

static void vala_typeparameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);


/**
 * Creates a new generic type parameter.
 *
 * @param name              parameter name
 * @param source_reference  reference to source code
 * @return                  newly created generic type parameter
 */
ValaTypeParameter* vala_typeparameter_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference) {
	ValaTypeParameter* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	self = (ValaTypeParameter*) vala_symbol_construct (object_type, _tmp0_, _tmp1_, NULL);
	return self;
}


ValaTypeParameter* vala_typeparameter_new (const gchar* name, ValaSourceReference* source_reference) {
	return vala_typeparameter_construct (VALA_TYPE_TYPEPARAMETER, name, source_reference);
}


static void vala_typeparameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaTypeParameter * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaTypeParameter*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_type_parameter (_tmp0_, self);
}


/**
 * Checks two type parameters for equality.
 *
 * @param param2 a type parameter
 * @return      true if this type parameter is equal to param2, false
 *              otherwise
 */
gboolean vala_typeparameter_equals (ValaTypeParameter* self, ValaTypeParameter* param2) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	ValaTypeParameter* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp15_ = FALSE;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	ValaTypeParameter* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (param2 != NULL, FALSE);
	_tmp1_ = vala_symbol_get_owner ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = param2;
	_tmp4_ = vala_symbol_get_owner ((ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_scope_is_subscope_of (_tmp2_, _tmp5_);
	if (!_tmp6_) {
		ValaTypeParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		gboolean _tmp12_;
		_tmp7_ = param2;
		_tmp8_ = vala_symbol_get_owner ((ValaSymbol*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_scope_is_subscope_of (_tmp9_, _tmp11_);
		_tmp0_ = !_tmp12_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp14_ = _tmp13_;
		vala_report_error (_tmp14_, "internal error: comparing type parameters from different scopes");
		result = FALSE;
		return result;
	}
	_tmp16_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = param2;
	_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
	_tmp20_ = _tmp19_;
	if (g_strcmp0 (_tmp17_, _tmp20_) == 0) {
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaTypeParameter* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp21_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = param2;
		_tmp24_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp15_ = _tmp22_ == _tmp25_;
	} else {
		_tmp15_ = FALSE;
	}
	result = _tmp15_;
	return result;
}


static void vala_typeparameter_class_init (ValaTypeParameterClass * klass) {
	vala_typeparameter_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_typeparameter_real_accept;
}


static void vala_typeparameter_instance_init (ValaTypeParameter * self) {
}


/**
 * Represents a generic type parameter in the source code.
 */
GType vala_typeparameter_get_type (void) {
	static volatile gsize vala_typeparameter_type_id__volatile = 0;
	if (g_once_init_enter (&vala_typeparameter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeparameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeParameter), 0, (GInstanceInitFunc) vala_typeparameter_instance_init, NULL };
		GType vala_typeparameter_type_id;
		vala_typeparameter_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaTypeParameter", &g_define_type_info, 0);
		g_once_init_leave (&vala_typeparameter_type_id__volatile, vala_typeparameter_type_id);
	}
	return vala_typeparameter_type_id__volatile;
}



