/* valaparameter.c generated by valac, the Vala compiler
 * generated from valaparameter.vala, do not modify */

/* valaparameter.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaParameterPrivate {
	ValaParameterDirection _direction;
	gboolean _ellipsis;
	gboolean _params_array;
	gboolean _captured;
	ValaParameter* _base_parameter;
};


static gpointer vala_parameter_parent_class = NULL;

#define VALA_PARAMETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PARAMETER, ValaParameterPrivate))
static void vala_parameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_parameter_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_parameter_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static void vala_parameter_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_parameter_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_parameter_finalize (ValaCodeNode * obj);


/**
 * Creates a new formal parameter.
 *
 * @param name              parameter name
 * @param variable_type     parameter type
 * @param source_reference  reference to source code
 * @return                  newly created formal parameter
 */
ValaParameter* vala_parameter_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference) {
	ValaParameter* self = NULL;
	ValaDataType* _tmp0_;
	const gchar* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = variable_type;
	_tmp1_ = name;
	_tmp2_ = source_reference;
	self = (ValaParameter*) vala_variable_construct (object_type, _tmp0_, _tmp1_, NULL, _tmp2_, NULL);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaParameter* vala_parameter_new (const gchar* name, ValaDataType* variable_type, ValaSourceReference* source_reference) {
	return vala_parameter_construct (VALA_TYPE_PARAMETER, name, variable_type, source_reference);
}


/**
 * Creates a new ellipsis parameter representing an indefinite number of
 * parameters.
 */
ValaParameter* vala_parameter_construct_with_ellipsis (GType object_type, ValaSourceReference* source_reference) {
	ValaParameter* self = NULL;
	ValaSourceReference* _tmp0_;
	_tmp0_ = source_reference;
	self = (ValaParameter*) vala_variable_construct (object_type, NULL, NULL, NULL, _tmp0_, NULL);
	vala_parameter_set_ellipsis (self, TRUE);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}


ValaParameter* vala_parameter_new_with_ellipsis (ValaSourceReference* source_reference) {
	return vala_parameter_construct_with_ellipsis (VALA_TYPE_PARAMETER, source_reference);
}


static void vala_parameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaParameter * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaParameter*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_formal_parameter (_tmp0_, self);
}


static void vala_parameter_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaParameter * self;
	gboolean _tmp0_;
	self = (ValaParameter*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_ellipsis;
	if (!_tmp0_) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		ValaCodeVisitor* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp1_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp2_, _tmp3_);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			ValaExpression* _tmp6_;
			ValaExpression* _tmp7_;
			ValaCodeVisitor* _tmp8_;
			_tmp6_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp7_ = _tmp6_;
			_tmp8_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, _tmp8_);
		}
	}
}


static void vala_parameter_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaParameter * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaParameter*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp3_);
	}
}


static void vala_parameter_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaParameter * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaParameter*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_variable_set_initializer ((ValaVariable*) self, _tmp3_);
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


ValaParameter* vala_parameter_copy (ValaParameter* self) {
	ValaParameter* result = NULL;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ellipsis;
	if (!_tmp0_) {
		ValaParameter* _result_ = NULL;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaParameter* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		gboolean _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameterDirection _tmp14_;
		ValaParameter* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		GList* _tmp18_;
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_data_type_copy (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_parameter_new (_tmp2_, _tmp6_, _tmp8_);
		_tmp10_ = _tmp9_;
		_vala_code_node_unref0 (_tmp6_);
		_result_ = _tmp10_;
		_tmp11_ = _result_;
		_tmp12_ = self->priv->_params_array;
		vala_parameter_set_params_array (_tmp11_, _tmp12_);
		_tmp13_ = _result_;
		_tmp14_ = self->priv->_direction;
		vala_parameter_set_direction (_tmp13_, _tmp14_);
		_tmp15_ = _result_;
		_tmp16_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp17_ = _tmp16_;
		vala_variable_set_initializer ((ValaVariable*) _tmp15_, _tmp17_);
		_tmp18_ = ((ValaCodeNode*) self)->attributes;
		{
			GList* a_collection = NULL;
			GList* a_it = NULL;
			a_collection = _tmp18_;
			for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
				ValaAttribute* _tmp19_;
				ValaAttribute* a = NULL;
				_tmp19_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
				a = _tmp19_;
				{
					ValaParameter* _tmp20_;
					ValaAttribute* _tmp21_;
					ValaAttribute* _tmp22_;
					_tmp20_ = _result_;
					_tmp21_ = a;
					_tmp22_ = _vala_code_node_ref0 (_tmp21_);
					((ValaCodeNode*) _tmp20_)->attributes = g_list_append (((ValaCodeNode*) _tmp20_)->attributes, _tmp22_);
					_vala_code_node_unref0 (a);
				}
			}
		}
		result = _result_;
		return result;
	} else {
		ValaParameter* _tmp23_;
		_tmp23_ = vala_parameter_new_with_ellipsis (NULL);
		result = _tmp23_;
		return result;
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_parameter_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaParameter * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaCodeContext* _tmp25_;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaSymbol* _tmp28_;
	ValaSymbol* _tmp29_;
	ValaDataType* _tmp30_;
	ValaDataType* _tmp31_;
	gboolean _tmp39_;
	ValaExpression* _tmp70_;
	ValaExpression* _tmp71_;
	gboolean _tmp136_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp155_;
	ValaSymbol* _tmp156_;
	ValaMethod* _tmp157_;
	ValaMethod* _tmp158_;
	ValaCodeContext* _tmp186_;
	ValaSemanticAnalyzer* _tmp187_;
	ValaSemanticAnalyzer* _tmp188_;
	ValaSourceFile* _tmp189_;
	ValaCodeContext* _tmp190_;
	ValaSemanticAnalyzer* _tmp191_;
	ValaSemanticAnalyzer* _tmp192_;
	ValaSymbol* _tmp193_;
	gboolean _tmp194_;
	gboolean _tmp195_;
	self = (ValaParameter*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (_tmp14_);
	old_symbol = _tmp15_;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaCodeContext* _tmp18_;
		ValaSemanticAnalyzer* _tmp19_;
		ValaSemanticAnalyzer* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaSourceFile* _tmp23_;
		ValaSourceFile* _tmp24_;
		_tmp18_ = context;
		_tmp19_ = vala_code_context_get_analyzer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_source_reference_get_file (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_semantic_analyzer_set_current_source_file (_tmp20_, _tmp24_);
	}
	_tmp25_ = context;
	_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp29_ = _tmp28_;
	vala_semantic_analyzer_set_current_symbol (_tmp27_, _tmp29_);
	_tmp30_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp31_ = _tmp30_;
	if (_tmp31_ != NULL) {
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		ValaDataType* _tmp36_;
		ValaDataType* _tmp37_;
		ValaCodeContext* _tmp38_;
		_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp33_ = _tmp32_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_VOID_TYPE)) {
			ValaSourceReference* _tmp34_;
			ValaSourceReference* _tmp35_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp35_ = _tmp34_;
			vala_report_error (_tmp35_, "'void' not supported as parameter type");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp36_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp37_, _tmp38_);
	}
	_tmp39_ = self->priv->_ellipsis;
	if (!_tmp39_) {
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaCodeContext* _tmp42_;
		gboolean _tmp43_ = FALSE;
		gboolean _tmp44_;
		gboolean _tmp49_ = FALSE;
		gboolean _tmp50_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp40_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp41_ = _tmp40_;
		_tmp42_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp41_, _tmp42_);
		_tmp44_ = self->priv->_params_array;
		if (_tmp44_) {
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			_tmp45_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp46_ = _tmp45_;
			_tmp43_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, VALA_TYPE_ARRAY_TYPE);
		} else {
			_tmp43_ = FALSE;
		}
		if (_tmp43_) {
			ValaSourceReference* _tmp47_;
			ValaSourceReference* _tmp48_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp48_ = _tmp47_;
			vala_report_error (_tmp48_, "parameter array expected");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp50_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "CCode", "scope");
		if (_tmp50_) {
			ValaDataType* _tmp51_;
			ValaDataType* _tmp52_;
			_tmp51_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp52_ = _tmp51_;
			_tmp49_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			ValaDelegateType* delegate_type = NULL;
			ValaDataType* _tmp53_;
			ValaDataType* _tmp54_;
			ValaDelegateType* _tmp55_;
			ValaDelegateType* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp53_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp54_ = _tmp53_;
			_tmp55_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			delegate_type = _tmp55_;
			_tmp56_ = delegate_type;
			_tmp57_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "CCode", "scope", NULL);
			_tmp58_ = _tmp57_;
			vala_delegate_type_set_is_called_once (_tmp56_, g_strcmp0 (_tmp58_, "async") == 0);
			_g_free0 (_tmp58_);
			_vala_code_node_unref0 (delegate_type);
		}
		_tmp59_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp60_ = _tmp59_;
		if (_tmp60_ != NULL) {
			ValaExpression* _tmp61_;
			ValaExpression* _tmp62_;
			ValaDataType* _tmp63_;
			ValaDataType* _tmp64_;
			ValaDataType* _tmp65_;
			ValaDataType* _tmp66_;
			ValaExpression* _tmp67_;
			ValaExpression* _tmp68_;
			ValaCodeContext* _tmp69_;
			_tmp61_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_data_type_copy (_tmp64_);
			_tmp66_ = _tmp65_;
			vala_expression_set_target_type (_tmp62_, _tmp66_);
			_vala_code_node_unref0 (_tmp66_);
			_tmp67_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp68_ = _tmp67_;
			_tmp69_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp68_, _tmp69_);
		}
	}
	_tmp70_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp71_ = _tmp70_;
	if (_tmp71_ != NULL) {
		gboolean _tmp72_ = FALSE;
		gboolean _tmp73_ = FALSE;
		ValaExpression* _tmp74_;
		ValaExpression* _tmp75_;
		_tmp74_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp75_ = _tmp74_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp75_, VALA_TYPE_NULL_LITERAL)) {
			ValaDataType* _tmp76_;
			ValaDataType* _tmp77_;
			gboolean _tmp78_;
			gboolean _tmp79_;
			_tmp76_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp77_ = _tmp76_;
			_tmp78_ = vala_data_type_get_nullable (_tmp77_);
			_tmp79_ = _tmp78_;
			_tmp73_ = !_tmp79_;
		} else {
			_tmp73_ = FALSE;
		}
		if (_tmp73_) {
			ValaParameterDirection _tmp80_;
			_tmp80_ = self->priv->_direction;
			_tmp72_ = _tmp80_ != VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp72_ = FALSE;
		}
		if (_tmp72_) {
			ValaSourceReference* _tmp81_;
			ValaSourceReference* _tmp82_;
			ValaDataType* _tmp83_;
			ValaDataType* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp82_ = _tmp81_;
			_tmp83_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_code_node_to_string ((ValaCodeNode*) _tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = g_strdup_printf ("`null' incompatible with parameter type `%s`", _tmp86_);
			_tmp88_ = _tmp87_;
			vala_report_warning (_tmp82_, _tmp88_);
			_g_free0 (_tmp88_);
			_g_free0 (_tmp86_);
		} else {
			gboolean _tmp89_ = FALSE;
			ValaExpression* _tmp90_;
			ValaExpression* _tmp91_;
			_tmp90_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp91_ = _tmp90_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp91_, VALA_TYPE_NULL_LITERAL)) {
				ValaParameterDirection _tmp92_;
				_tmp92_ = self->priv->_direction;
				_tmp89_ = _tmp92_ == VALA_PARAMETER_DIRECTION_OUT;
			} else {
				_tmp89_ = FALSE;
			}
			if (_tmp89_) {
				ValaSourceReference* _tmp93_;
				ValaSourceReference* _tmp94_;
				_tmp93_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp94_ = _tmp93_;
				vala_report_error (_tmp94_, "only `null' is allowed as default value for out parameters");
			} else {
				gboolean _tmp95_ = FALSE;
				ValaParameterDirection _tmp96_;
				_tmp96_ = self->priv->_direction;
				if (_tmp96_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaExpression* _tmp97_;
					ValaExpression* _tmp98_;
					ValaDataType* _tmp99_;
					ValaDataType* _tmp100_;
					ValaDataType* _tmp101_;
					ValaDataType* _tmp102_;
					gboolean _tmp103_;
					_tmp97_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp98_ = _tmp97_;
					_tmp99_ = vala_expression_get_value_type (_tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = vala_variable_get_variable_type ((ValaVariable*) self);
					_tmp102_ = _tmp101_;
					_tmp103_ = vala_data_type_compatible (_tmp100_, _tmp102_);
					_tmp95_ = !_tmp103_;
				} else {
					_tmp95_ = FALSE;
				}
				if (_tmp95_) {
					ValaExpression* _tmp104_;
					ValaExpression* _tmp105_;
					ValaSourceReference* _tmp106_;
					ValaSourceReference* _tmp107_;
					ValaExpression* _tmp108_;
					ValaExpression* _tmp109_;
					ValaDataType* _tmp110_;
					ValaDataType* _tmp111_;
					gchar* _tmp112_;
					gchar* _tmp113_;
					ValaDataType* _tmp114_;
					ValaDataType* _tmp115_;
					gchar* _tmp116_;
					gchar* _tmp117_;
					gchar* _tmp118_;
					gchar* _tmp119_;
					_tmp104_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp105_ = _tmp104_;
					_tmp106_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp105_);
					_tmp107_ = _tmp106_;
					_tmp108_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp109_ = _tmp108_;
					_tmp110_ = vala_expression_get_value_type (_tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = vala_code_node_to_string ((ValaCodeNode*) _tmp111_);
					_tmp113_ = _tmp112_;
					_tmp114_ = vala_variable_get_variable_type ((ValaVariable*) self);
					_tmp115_ = _tmp114_;
					_tmp116_ = vala_code_node_to_string ((ValaCodeNode*) _tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp113_, _tmp117_);
					_tmp119_ = _tmp118_;
					vala_report_error (_tmp107_, _tmp119_);
					_g_free0 (_tmp119_);
					_g_free0 (_tmp117_);
					_g_free0 (_tmp113_);
				} else {
					ValaParameterDirection _tmp120_;
					_tmp120_ = self->priv->_direction;
					if (_tmp120_ == VALA_PARAMETER_DIRECTION_REF) {
						ValaSourceReference* _tmp121_;
						ValaSourceReference* _tmp122_;
						_tmp121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp122_ = _tmp121_;
						vala_report_error (_tmp122_, "default value not allowed for ref parameter");
					} else {
						ValaExpression* _tmp123_;
						ValaExpression* _tmp124_;
						gboolean _tmp125_;
						_tmp123_ = vala_variable_get_initializer ((ValaVariable*) self);
						_tmp124_ = _tmp123_;
						_tmp125_ = vala_expression_is_accessible (_tmp124_, (ValaSymbol*) self);
						if (!_tmp125_) {
							ValaExpression* _tmp126_;
							ValaExpression* _tmp127_;
							ValaSourceReference* _tmp128_;
							ValaSourceReference* _tmp129_;
							ValaSymbol* _tmp130_;
							ValaSymbol* _tmp131_;
							gchar* _tmp132_;
							gchar* _tmp133_;
							gchar* _tmp134_;
							gchar* _tmp135_;
							_tmp126_ = vala_variable_get_initializer ((ValaVariable*) self);
							_tmp127_ = _tmp126_;
							_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp127_);
							_tmp129_ = _tmp128_;
							_tmp130_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
							_tmp131_ = _tmp130_;
							_tmp132_ = vala_symbol_get_full_name (_tmp131_);
							_tmp133_ = _tmp132_;
							_tmp134_ = g_strdup_printf ("default value is less accessible than method `%s'", _tmp133_);
							_tmp135_ = _tmp134_;
							vala_report_error (_tmp129_, _tmp135_);
							_g_free0 (_tmp135_);
							_g_free0 (_tmp133_);
						}
					}
				}
			}
		}
	}
	_tmp136_ = self->priv->_ellipsis;
	if (!_tmp136_) {
		ValaCodeContext* _tmp137_;
		ValaSemanticAnalyzer* _tmp138_;
		ValaSemanticAnalyzer* _tmp139_;
		ValaDataType* _tmp140_;
		ValaDataType* _tmp141_;
		gboolean _tmp142_;
		_tmp137_ = context;
		_tmp138_ = vala_code_context_get_analyzer (_tmp137_);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp141_ = _tmp140_;
		_tmp142_ = vala_semantic_analyzer_is_type_accessible (_tmp139_, (ValaSymbol*) self, _tmp141_);
		if (!_tmp142_) {
			ValaSourceReference* _tmp143_;
			ValaSourceReference* _tmp144_;
			ValaDataType* _tmp145_;
			ValaDataType* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			ValaSymbol* _tmp149_;
			ValaSymbol* _tmp150_;
			gchar* _tmp151_;
			gchar* _tmp152_;
			gchar* _tmp153_;
			gchar* _tmp154_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp146_ = _tmp145_;
			_tmp147_ = vala_code_node_to_string ((ValaCodeNode*) _tmp146_);
			_tmp148_ = _tmp147_;
			_tmp149_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_symbol_get_full_name (_tmp150_);
			_tmp152_ = _tmp151_;
			_tmp153_ = g_strdup_printf ("parameter type `%s` is less accessible than method `%s`", _tmp148_, _tmp152_);
			_tmp154_ = _tmp153_;
			vala_report_error (_tmp144_, _tmp154_);
			_g_free0 (_tmp154_);
			_g_free0 (_tmp152_);
			_g_free0 (_tmp148_);
		}
	}
	_tmp155_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp156_ = _tmp155_;
	_tmp157_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp156_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp156_) : NULL);
	m = _tmp157_;
	_tmp158_ = m;
	if (_tmp158_ != NULL) {
		ValaMethod* _tmp159_ = NULL;
		ValaMethod* _tmp160_;
		ValaMethod* _tmp161_;
		ValaMethod* _tmp162_;
		ValaMethod* base_method = NULL;
		ValaMethod* _tmp169_;
		gboolean _tmp170_ = FALSE;
		ValaMethod* _tmp171_;
		_tmp160_ = m;
		_tmp161_ = vala_method_get_base_method (_tmp160_);
		_tmp162_ = _tmp161_;
		if (_tmp162_ != NULL) {
			ValaMethod* _tmp163_;
			ValaMethod* _tmp164_;
			ValaMethod* _tmp165_;
			_tmp163_ = m;
			_tmp164_ = vala_method_get_base_method (_tmp163_);
			_tmp165_ = _tmp164_;
			_tmp159_ = _tmp165_;
		} else {
			ValaMethod* _tmp166_;
			ValaMethod* _tmp167_;
			ValaMethod* _tmp168_;
			_tmp166_ = m;
			_tmp167_ = vala_method_get_base_interface_method (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp159_ = _tmp168_;
		}
		_tmp169_ = _vala_code_node_ref0 (_tmp159_);
		base_method = _tmp169_;
		_tmp171_ = base_method;
		if (_tmp171_ != NULL) {
			ValaMethod* _tmp172_;
			ValaMethod* _tmp173_;
			_tmp172_ = base_method;
			_tmp173_ = m;
			_tmp170_ = _tmp172_ != _tmp173_;
		} else {
			_tmp170_ = FALSE;
		}
		if (_tmp170_) {
			gint index = 0;
			ValaMethod* _tmp174_;
			ValaList* _tmp175_;
			ValaList* _tmp176_;
			gint _tmp177_;
			gint _tmp178_;
			gint _tmp179_;
			_tmp174_ = m;
			_tmp175_ = vala_callable_get_parameters ((ValaCallable*) _tmp174_);
			_tmp176_ = _tmp175_;
			_tmp177_ = vala_list_index_of (_tmp176_, self);
			_tmp178_ = _tmp177_;
			_vala_iterable_unref0 (_tmp176_);
			index = _tmp178_;
			_tmp179_ = index;
			if (_tmp179_ >= 0) {
				ValaMethod* _tmp180_;
				ValaList* _tmp181_;
				ValaList* _tmp182_;
				gint _tmp183_;
				gpointer _tmp184_;
				ValaParameter* _tmp185_;
				_tmp180_ = base_method;
				_tmp181_ = vala_callable_get_parameters ((ValaCallable*) _tmp180_);
				_tmp182_ = _tmp181_;
				_tmp183_ = index;
				_tmp184_ = vala_list_get (_tmp182_, _tmp183_);
				_tmp185_ = (ValaParameter*) _tmp184_;
				vala_parameter_set_base_parameter (self, _tmp185_);
				_vala_code_node_unref0 (_tmp185_);
				_vala_iterable_unref0 (_tmp182_);
			}
		}
		_vala_code_node_unref0 (base_method);
	}
	_tmp186_ = context;
	_tmp187_ = vala_code_context_get_analyzer (_tmp186_);
	_tmp188_ = _tmp187_;
	_tmp189_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp188_, _tmp189_);
	_tmp190_ = context;
	_tmp191_ = vala_code_context_get_analyzer (_tmp190_);
	_tmp192_ = _tmp191_;
	_tmp193_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp192_, _tmp193_);
	_tmp194_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp195_ = _tmp194_;
	result = !_tmp195_;
	_vala_code_node_unref0 (m);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaParameterDirection vala_parameter_get_direction (ValaParameter* self) {
	ValaParameterDirection result;
	ValaParameterDirection _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_direction;
	result = _tmp0_;
	return result;
}


void vala_parameter_set_direction (ValaParameter* self, ValaParameterDirection value) {
	ValaParameterDirection _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_direction = _tmp0_;
}


gboolean vala_parameter_get_ellipsis (ValaParameter* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_ellipsis;
	result = _tmp0_;
	return result;
}


void vala_parameter_set_ellipsis (ValaParameter* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_ellipsis = _tmp0_;
}


gboolean vala_parameter_get_params_array (ValaParameter* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_params_array;
	result = _tmp0_;
	return result;
}


void vala_parameter_set_params_array (ValaParameter* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_params_array = _tmp0_;
}


gboolean vala_parameter_get_captured (ValaParameter* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_captured;
	result = _tmp0_;
	return result;
}


void vala_parameter_set_captured (ValaParameter* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_captured = _tmp0_;
}


gboolean vala_parameter_get_format_arg (ValaParameter* self) {
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "FormatArg");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


ValaParameter* vala_parameter_get_base_parameter (ValaParameter* self) {
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_parameter;
	result = _tmp0_;
	return result;
}


void vala_parameter_set_base_parameter (ValaParameter* self, ValaParameter* value) {
	ValaParameter* _tmp0_;
	ValaParameter* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_base_parameter);
	self->priv->_base_parameter = _tmp1_;
}


static void vala_parameter_class_init (ValaParameterClass * klass) {
	vala_parameter_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_parameter_finalize;
	g_type_class_add_private (klass, sizeof (ValaParameterPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_parameter_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_parameter_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_parameter_real_replace_type;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_parameter_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_parameter_real_check;
}


static void vala_parameter_instance_init (ValaParameter * self) {
	self->priv = VALA_PARAMETER_GET_PRIVATE (self);
	self->priv->_direction = VALA_PARAMETER_DIRECTION_IN;
}


static void vala_parameter_finalize (ValaCodeNode * obj) {
	ValaParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PARAMETER, ValaParameter);
	_vala_code_node_unref0 (self->priv->_base_parameter);
	VALA_CODE_NODE_CLASS (vala_parameter_parent_class)->finalize (obj);
}


/**
 * Represents a formal parameter in method and callback signatures.
 */
GType vala_parameter_get_type (void) {
	static volatile gsize vala_parameter_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parameter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaParameter), 0, (GInstanceInitFunc) vala_parameter_instance_init, NULL };
		GType vala_parameter_type_id;
		vala_parameter_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaParameter", &g_define_type_info, 0);
		g_once_init_leave (&vala_parameter_type_id__volatile, vala_parameter_type_id);
	}
	return vala_parameter_type_id__volatile;
}


GType vala_parameter_direction_get_type (void) {
	static volatile gsize vala_parameter_direction_type_id__volatile = 0;
	if (g_once_init_enter (&vala_parameter_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_PARAMETER_DIRECTION_IN, "VALA_PARAMETER_DIRECTION_IN", "in"}, {VALA_PARAMETER_DIRECTION_OUT, "VALA_PARAMETER_DIRECTION_OUT", "out"}, {VALA_PARAMETER_DIRECTION_REF, "VALA_PARAMETER_DIRECTION_REF", "ref"}, {0, NULL, NULL}};
		GType vala_parameter_direction_type_id;
		vala_parameter_direction_type_id = g_enum_register_static ("ValaParameterDirection", values);
		g_once_init_leave (&vala_parameter_direction_type_id__volatile, vala_parameter_direction_type_id);
	}
	return vala_parameter_direction_type_id__volatile;
}



