// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package installer

import (
	"sync"
)

// Ensure, that InstallerMock does implement Installer.
// If this is not the case, regenerate this file with moq.
var _ Installer = &InstallerMock{}

// InstallerMock is a mock implementation of Installer.
//
//	func TestSomethingThatUsesInstaller(t *testing.T) {
//
//		// make and configure a mocked Installer
//		mockedInstaller := &InstallerMock{
//			InstallFunc: func(s string) error {
//				panic("mock out the Install method")
//			},
//		}
//
//		// use mockedInstaller in code that requires Installer
//		// and then make assertions.
//
//	}
type InstallerMock struct {
	// InstallFunc mocks the Install method.
	InstallFunc func(s string) error

	// calls tracks calls to the methods.
	calls struct {
		// Install holds details about calls to the Install method.
		Install []struct {
			// S is the s argument value.
			S string
		}
	}
	lockInstall sync.RWMutex
}

// Install calls InstallFunc.
func (mock *InstallerMock) Install(s string) error {
	if mock.InstallFunc == nil {
		panic("InstallerMock.InstallFunc: method is nil but Installer.Install was just called")
	}
	callInfo := struct {
		S string
	}{
		S: s,
	}
	mock.lockInstall.Lock()
	mock.calls.Install = append(mock.calls.Install, callInfo)
	mock.lockInstall.Unlock()
	return mock.InstallFunc(s)
}

// InstallCalls gets all the calls that were made to Install.
// Check the length with:
//
//	len(mockedInstaller.InstallCalls())
func (mock *InstallerMock) InstallCalls() []struct {
	S string
} {
	var calls []struct {
		S string
	}
	mock.lockInstall.RLock()
	calls = mock.calls.Install
	mock.lockInstall.RUnlock()
	return calls
}
