# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "network watcher flow-log update",
)
class Update(AAZCommand):
    """Update the flow log configuration of a network security group.

    :example: Update storage account with name to let resource group identify the storage account and network watcher
        az network watcher flow-log update --location westus --resource-group MyResourceGroup --name MyFlowLog --storage-account accountname

    :example: Update storage account with ID to let location identify the network watcher
        az network watcher flow-log update --location westus --resource-group MyResourceGroup --name MyFlowLog --storage-account accountid

    :example: Update Network Security Group on another resource group
        az network watcher flow-log update --location westus --resource-group MyAnotherResourceGroup --name MyFlowLog --nsg MyNSG

    :example: Update Virtual Network on another resource group
        az network watcher flow-log update --location westus --resource-group MyAnotherResourceGroup --name MyFlowLog --vnet MyVNet

    :example: Update Subnet on another resource group
        az network watcher flow-log update --location westus --resource-group MyAnotherResourceGroup --name MyFlowLog --vnet MyVNet --subnet MySubnet

    :example: Update Network Interface on another resource group
        az network watcher flow-log update --location westus --resource-group MyAnotherResourceGroup --name MyFlowLog --nic MyNIC

    :example: Update Workspace on another resource group
        az network watcher flow-log update --location westus --resource-group MyAnotherResourceGroup --name MyFlowLog --workspace MyAnotherLogAnalyticWorkspace
    """

    _aaz_info = {
        "version": "2023-11-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/networkwatchers/{}/flowlogs/{}", "2023-11-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    AZ_SUPPORT_GENERIC_UPDATE = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The name of the flow logger.",
            required=True,
            id_part="child_name_1",
        )
        _args_schema.network_watcher_name = AAZStrArg(
            options=["--network-watcher-name"],
            help="The name of the network watcher.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.location = AAZResourceLocationArg(
            help="Location to identify the exclusive Network Watcher under a region. Only one Network Watcher can be existed per subscription and region.",
            nullable=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.enabled = AAZBoolArg(
            options=["--enabled"],
            help="Enable logging.",
            nullable=True,
        )
        _args_schema.storage_account = AAZStrArg(
            options=["--storage-account"],
            help="Name or ID of the storage account in which to save the flow logs.                                Must be in the same region of flow log.",
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            help="Space-separated tags: key[=value] [key[=value] ...]. Use \"\" to clear                                existing tags.",
            nullable=True,
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg(
            nullable=True,
        )

        # define Arg Group "Format"

        _args_schema = cls._args_schema
        _args_schema.format = AAZStrArg(
            options=["--format"],
            arg_group="Format",
            help="File type of the flow log.",
            nullable=True,
            enum={"JSON": "JSON"},
        )
        _args_schema.log_version = AAZIntArg(
            options=["--log-version"],
            arg_group="Format",
            help="Version (revision) of the flow log.",
            nullable=True,
        )

        # define Arg Group "Parameters"

        _args_schema = cls._args_schema
        _args_schema.identity = AAZObjectArg(
            options=["--identity"],
            arg_group="Parameters",
            help="FlowLog resource Managed Identity",
            nullable=True,
        )

        identity = cls._args_schema.identity
        identity.type = AAZStrArg(
            options=["type"],
            help="The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.",
            nullable=True,
            enum={"None": "None", "SystemAssigned": "SystemAssigned", "SystemAssigned, UserAssigned": "SystemAssigned, UserAssigned", "UserAssigned": "UserAssigned"},
        )
        identity.user_assigned_identities = AAZDictArg(
            options=["user-assigned-identities"],
            help="The list of user identities associated with resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.",
            nullable=True,
        )

        user_assigned_identities = cls._args_schema.identity.user_assigned_identities
        user_assigned_identities.Element = AAZObjectArg(
            nullable=True,
            blank={},
        )

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.flow_analytics_configuration = AAZObjectArg(
            options=["--flow-analytics-configuration"],
            arg_group="Properties",
            help="Parameters that define the configuration of traffic analytics.",
            nullable=True,
        )
        _args_schema.retention_policy = AAZObjectArg(
            options=["--retention-policy"],
            arg_group="Properties",
            help="Parameters that define the retention policy for flow log.",
            nullable=True,
        )
        _args_schema.target_resource_id = AAZStrArg(
            options=["--target-resource-id"],
            arg_group="Properties",
            help="ID of network security group to which flow log will be applied.",
        )

        flow_analytics_configuration = cls._args_schema.flow_analytics_configuration
        flow_analytics_configuration.enabled = AAZBoolArg(
            options=["enabled"],
            help="Flag to enable/disable traffic analytics.",
            nullable=True,
        )
        flow_analytics_configuration.traffic_analytics_interval = AAZIntArg(
            options=["traffic-analytics-interval"],
            help="The interval in minutes which would decide how frequently TA service should do flow analytics.",
            nullable=True,
        )
        flow_analytics_configuration.workspace_id = AAZStrArg(
            options=["workspace-id"],
            help="The resource guid of the attached workspace.",
            nullable=True,
        )
        flow_analytics_configuration.workspace_region = AAZStrArg(
            options=["workspace-region"],
            help="The location of the attached workspace.",
            nullable=True,
        )
        flow_analytics_configuration.workspace_resource_id = AAZStrArg(
            options=["workspace-resource-id"],
            help="Resource Id of the attached workspace.",
            nullable=True,
        )

        retention_policy = cls._args_schema.retention_policy
        retention_policy.days = AAZIntArg(
            options=["days"],
            help="Number of days to retain flow log records.",
            nullable=True,
        )
        retention_policy.enabled = AAZBoolArg(
            options=["enabled"],
            help="Flag to enable/disable retention.",
            nullable=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.FlowLogsGet(ctx=self.ctx)()
        self.pre_instance_update(self.ctx.vars.instance)
        self.InstanceUpdateByJson(ctx=self.ctx)()
        self.InstanceUpdateByGeneric(ctx=self.ctx)()
        self.post_instance_update(self.ctx.vars.instance)
        yield self.FlowLogsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    @register_callback
    def pre_instance_update(self, instance):
        pass

    @register_callback
    def post_instance_update(self, instance):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class FlowLogsGet(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "GET"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "flowLogName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "networkWatcherName", self.ctx.args.network_watcher_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()
            _UpdateHelper._build_schema_flow_log_read(cls._schema_on_200)

            return cls._schema_on_200

    class FlowLogsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/networkWatchers/{networkWatcherName}/flowLogs/{flowLogName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "flowLogName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "networkWatcherName", self.ctx.args.network_watcher_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2023-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=self.ctx.vars.instance,
            )

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _UpdateHelper._build_schema_flow_log_read(cls._schema_on_200_201)

            return cls._schema_on_200_201

    class InstanceUpdateByJson(AAZJsonInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance(self.ctx.vars.instance)

        def _update_instance(self, instance):
            _instance_value, _builder = self.new_content_builder(
                self.ctx.args,
                value=instance,
                typ=AAZObjectType
            )
            _builder.set_prop("identity", AAZObjectType, ".identity")
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            identity = _builder.get(".identity")
            if identity is not None:
                identity.set_prop("type", AAZStrType, ".type")
                identity.set_prop("userAssignedIdentities", AAZDictType, ".user_assigned_identities")

            user_assigned_identities = _builder.get(".identity.userAssignedIdentities")
            if user_assigned_identities is not None:
                user_assigned_identities.set_elements(AAZObjectType, ".")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("enabled", AAZBoolType, ".enabled")
                properties.set_prop("flowAnalyticsConfiguration", AAZObjectType, ".flow_analytics_configuration")
                properties.set_prop("format", AAZObjectType)
                properties.set_prop("retentionPolicy", AAZObjectType, ".retention_policy")
                properties.set_prop("storageId", AAZStrType, ".storage_account", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("targetResourceId", AAZStrType, ".target_resource_id", typ_kwargs={"flags": {"required": True}})

            flow_analytics_configuration = _builder.get(".properties.flowAnalyticsConfiguration")
            if flow_analytics_configuration is not None:
                flow_analytics_configuration.set_prop("networkWatcherFlowAnalyticsConfiguration", AAZObjectType)

            network_watcher_flow_analytics_configuration = _builder.get(".properties.flowAnalyticsConfiguration.networkWatcherFlowAnalyticsConfiguration")
            if network_watcher_flow_analytics_configuration is not None:
                network_watcher_flow_analytics_configuration.set_prop("enabled", AAZBoolType, ".enabled")
                network_watcher_flow_analytics_configuration.set_prop("trafficAnalyticsInterval", AAZIntType, ".traffic_analytics_interval")
                network_watcher_flow_analytics_configuration.set_prop("workspaceId", AAZStrType, ".workspace_id")
                network_watcher_flow_analytics_configuration.set_prop("workspaceRegion", AAZStrType, ".workspace_region")
                network_watcher_flow_analytics_configuration.set_prop("workspaceResourceId", AAZStrType, ".workspace_resource_id")

            format = _builder.get(".properties.format")
            if format is not None:
                format.set_prop("type", AAZStrType, ".format")
                format.set_prop("version", AAZIntType, ".log_version")

            retention_policy = _builder.get(".properties.retentionPolicy")
            if retention_policy is not None:
                retention_policy.set_prop("days", AAZIntType, ".days")
                retention_policy.set_prop("enabled", AAZBoolType, ".enabled")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return _instance_value

    class InstanceUpdateByGeneric(AAZGenericInstanceUpdateOperation):

        def __call__(self, *args, **kwargs):
            self._update_instance_by_generic(
                self.ctx.vars.instance,
                self.ctx.generic_update_args
            )


class _UpdateHelper:
    """Helper class for Update"""

    _schema_flow_log_read = None

    @classmethod
    def _build_schema_flow_log_read(cls, _schema):
        if cls._schema_flow_log_read is not None:
            _schema.etag = cls._schema_flow_log_read.etag
            _schema.id = cls._schema_flow_log_read.id
            _schema.identity = cls._schema_flow_log_read.identity
            _schema.location = cls._schema_flow_log_read.location
            _schema.name = cls._schema_flow_log_read.name
            _schema.properties = cls._schema_flow_log_read.properties
            _schema.tags = cls._schema_flow_log_read.tags
            _schema.type = cls._schema_flow_log_read.type
            return

        cls._schema_flow_log_read = _schema_flow_log_read = AAZObjectType()

        flow_log_read = _schema_flow_log_read
        flow_log_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        flow_log_read.id = AAZStrType()
        flow_log_read.identity = AAZObjectType()
        flow_log_read.location = AAZStrType()
        flow_log_read.name = AAZStrType(
            flags={"read_only": True},
        )
        flow_log_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        flow_log_read.tags = AAZDictType()
        flow_log_read.type = AAZStrType(
            flags={"read_only": True},
        )

        identity = _schema_flow_log_read.identity
        identity.principal_id = AAZStrType(
            serialized_name="principalId",
            flags={"read_only": True},
        )
        identity.tenant_id = AAZStrType(
            serialized_name="tenantId",
            flags={"read_only": True},
        )
        identity.type = AAZStrType()
        identity.user_assigned_identities = AAZDictType(
            serialized_name="userAssignedIdentities",
        )

        user_assigned_identities = _schema_flow_log_read.identity.user_assigned_identities
        user_assigned_identities.Element = AAZObjectType()

        _element = _schema_flow_log_read.identity.user_assigned_identities.Element
        _element.client_id = AAZStrType(
            serialized_name="clientId",
            flags={"read_only": True},
        )
        _element.principal_id = AAZStrType(
            serialized_name="principalId",
            flags={"read_only": True},
        )

        properties = _schema_flow_log_read.properties
        properties.enabled = AAZBoolType()
        properties.flow_analytics_configuration = AAZObjectType(
            serialized_name="flowAnalyticsConfiguration",
        )
        properties.format = AAZObjectType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.retention_policy = AAZObjectType(
            serialized_name="retentionPolicy",
        )
        properties.storage_id = AAZStrType(
            serialized_name="storageId",
            flags={"required": True},
        )
        properties.target_resource_guid = AAZStrType(
            serialized_name="targetResourceGuid",
            flags={"read_only": True},
        )
        properties.target_resource_id = AAZStrType(
            serialized_name="targetResourceId",
            flags={"required": True},
        )

        flow_analytics_configuration = _schema_flow_log_read.properties.flow_analytics_configuration
        flow_analytics_configuration.network_watcher_flow_analytics_configuration = AAZObjectType(
            serialized_name="networkWatcherFlowAnalyticsConfiguration",
        )

        network_watcher_flow_analytics_configuration = _schema_flow_log_read.properties.flow_analytics_configuration.network_watcher_flow_analytics_configuration
        network_watcher_flow_analytics_configuration.enabled = AAZBoolType()
        network_watcher_flow_analytics_configuration.traffic_analytics_interval = AAZIntType(
            serialized_name="trafficAnalyticsInterval",
        )
        network_watcher_flow_analytics_configuration.workspace_id = AAZStrType(
            serialized_name="workspaceId",
        )
        network_watcher_flow_analytics_configuration.workspace_region = AAZStrType(
            serialized_name="workspaceRegion",
        )
        network_watcher_flow_analytics_configuration.workspace_resource_id = AAZStrType(
            serialized_name="workspaceResourceId",
        )

        format = _schema_flow_log_read.properties.format
        format.type = AAZStrType()
        format.version = AAZIntType()

        retention_policy = _schema_flow_log_read.properties.retention_policy
        retention_policy.days = AAZIntType()
        retention_policy.enabled = AAZBoolType()

        tags = _schema_flow_log_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_flow_log_read.etag
        _schema.id = cls._schema_flow_log_read.id
        _schema.identity = cls._schema_flow_log_read.identity
        _schema.location = cls._schema_flow_log_read.location
        _schema.name = cls._schema_flow_log_read.name
        _schema.properties = cls._schema_flow_log_read.properties
        _schema.tags = cls._schema_flow_log_read.tags
        _schema.type = cls._schema_flow_log_read.type


__all__ = ["Update"]
