//
// Copyright (c) 2016-2019 Vinnie Falco (vinnie dot falco at gmail dot com)
//
// Distributed under the Boost Software License, Version 1.0. (See accompanying
// file LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)
//
// Official repository: https://github.com/boostorg/beast
//

#include "urls_large_data.hpp"

// Data from Alexa top 1 million sites
// http://s3.amazonaws.com/alexa-static/top-1m.csv.zip
//
std::vector<char const*> const&
urls_large_data()
{
    static std::vector <char const*> const urls ({
        "google.com",
        "facebook.com",
        "youtube.com",
        "yahoo.com",
        "baidu.com",
        "wikipedia.org",
        "qq.com",
        "linkedin.com",
        "taobao.com",
        "twitter.com",
        "live.com",
        "amazon.com",
        "sina.com.cn",
        "google.co.in",
        "hao123.com",
        "blogspot.com",
        "weibo.com",
        "wordpress.com",
        "yandex.ru",
        "yahoo.co.jp",
        "tmall.com",
        "bing.com",
        "vk.com",
        "ebay.com",
        "360.cn",
        "google.de",
        "sohu.com",
        "pinterest.com",
        "google.co.uk",
        "ask.com",
        "google.fr",
        "msn.com",
        "163.com",
        "soso.com",
        "tumblr.com",
        "google.co.jp",
        "instagram.com",
        "mail.ru",
        "google.com.br",
        "microsoft.com",
        "paypal.com",
        "google.ru",
        "xvideos.com",
        "google.es",
        "imdb.com",
        "apple.com",
        "google.it",
        "adcash.com",
        "craigslist.org",
        "stackoverflow.com",
        "amazon.co.jp",
        "neobux.com",
        "google.com.hk",
        "imgur.com",
        "ifeng.com",
        "cnn.com",
        "google.com.mx",
        "xhamster.com",
        "xinhuanet.com",
        "gmw.cn",
        "reddit.com",
        "bbc.co.uk",
        "blogger.com",
        "google.ca",
        "fc2.com",
        "vube.com",
        "go.com",
        "akamaihd.net",
        "alipay.com",
        "about.com",
        "people.com.cn",
        "t.co",
        "googleusercontent.com",
        "wordpress.org",
        "odnoklassniki.ru",
        "alibaba.com",
        "google.com.tr",
        "aliexpress.com",
        "youku.com",
        "conduit.com",
        "huffingtonpost.com",
        "godaddy.com",
        "flickr.com",
        "pornhub.com",
        "google.com.au",
        "amazon.de",
        "blogspot.in",
        "kickass.to",
        "ebay.de",
        "netflix.com",
        "google.pl",
        "thepiratebay.se",
        "bp.blogspot.com",
        "adobe.com",
        "dailymotion.com",
        "china.com",
        "vimeo.com",
        "dailymail.co.uk",
        "cnet.com",
        "rakuten.co.jp",
        "espn.go.com",
        "ku6.com",
        "ebay.co.uk",
        "themeforest.net",
        "xnxx.com",
        "livejasmin.com",
        "indiatimes.com",
        "aol.com",
        "redtube.com",
        "dropbox.com",
        "amazonaws.com",
        "uol.com.br",
        "weather.com",
        "m2newmedia.com",
        "amazon.co.uk",
        "google.com.ar",
        "google.com.sa",
        "pixnet.net",
        "nytimes.com",
        "slideshare.net",
        "youporn.com",
        "google.com.eg",
        "buzzfeed.com",
        "wikimedia.org",
        "booking.com",
        "livejournal.com",
        "globo.com",
        "fiverr.com",
        "adf.ly",
        "secureserver.net",
        "mozilla.org",
        "google.com.pk",
        "google.com.tw",
        "google.nl",
        "yelp.com",
        "sogou.com",
        "ameblo.jp",
        "directrev.com",
        "clkmon.com",
        "hootsuite.com",
        "deviantart.com",
        "blogfa.com",
        "wikia.com",
        "outbrain.com",
        "flipkart.com",
        "wikihow.com",
        "etsy.com",
        "google.co.th",
        "soundcloud.com",
        "google.co.za",
        "avg.com",
        "w3schools.com",
        "theguardian.com",
        "stumbleupon.com",
        "espncricinfo.com",
        "livedoor.com",
        "forbes.com",
        "archive.org",
        "4shared.com",
        "foxnews.com",
        "files.wordpress.com",
        "answers.com",
        "bankofamerica.com",
        "chase.com",
        "google.co.ve",
        "mediafire.com",
        "torrentz.eu",
        "badoo.com",
        "salesforce.com",
        "aweber.com",
        "sourceforge.net",
        "bbc.com",
        "addthis.com",
        "liveinternet.ru",
        "china.com.cn",
        "indeed.com",
        "reference.com",
        "github.com",
        "skype.com",
        "hostgator.com",
        "google.gr",
        "bet365.com",
        "spiegel.de",
        "ask.fm",
        "so.com",
        "statcounter.com",
        "gameforge.com",
        "onet.pl",
        "naver.com",
        "google.com.co",
        "developunit.info",
        "google.com.vn",
        "google.co.id",
        "nicovideo.jp",
        "shutterstock.com",
        "walmart.com",
        "google.be",
        "mailchimp.com",
        "softonic.com",
        "stackexchange.com",
        "google.com.ng",
        "google.com.ua",
        "popads.net",
        "allegro.pl",
        "gamer.com.tw",
        "wordreference.com",
        "wellsfargo.com",
        "loading-delivery1.com",
        "zillow.com",
        "tripadvisor.com",
        "quikr.com",
        "pandora.com",
        "wsj.com",
        "goo.ne.jp",
        "bild.de",
        "tube8.com",
        "wix.com",
        "google.se",
        "coccoc.com",
        "google.ro",
        "suning.com",
        "photobucket.com",
        "weebly.com",
        "tianya.cn",
        "warriorforum.com",
        "telegraph.co.uk",
        "google.dz",
        "naver.jp",
        "php.net",
        "ups.com",
        "rambler.ru",
        "zedo.com",
        "reuters.com",
        "google.at",
        "media.tumblr.com",
        "taringa.net",
        "google.com.ph",
        "chinaz.com",
        "mashable.com",
        "blogspot.com.es",
        "hurriyet.com.tr",
        "google.com.pe",
        "bleacherreport.com",
        "gmx.net",
        "wp.pl",
        "goodreads.com",
        "leboncoin.fr",
        "rutracker.org",
        "lenta.ru",
        "babylon.com",
        "domaintools.com",
        "sharelive.net",
        "rediff.com",
        "google.ch",
        "comcast.net",
        "twitch.tv",
        "avito.ru",
        "kaskus.co.id",
        "nbcnews.com",
        "onclickads.net",
        "businessinsider.com",
        "ikea.com",
        "codecanyon.net",
        "ndtv.com",
        "usps.com",
        "google.cl",
        "doublepimp.com",
        "moz.com",
        "google.com.sg",
        "usatoday.com",
        "dmm.co.jp",
        "amazon.fr",
        "google.pt",
        "ucoz.ru",
        "rt.com",
        "milliyet.com.tr",
        "xuite.net",
        "samsung.com",
        "fedex.com",
        "uploaded.net",
        "pcpop.com",
        "google.com.bd",
        "bitly.com",
        "goodgamestudios.com",
        "ettoday.net",
        "baomihua.com",
        "39.net",
        "web.de",
        "rbc.ru",
        "9gag.com",
        "disqus.com",
        "snapdeal.com",
        "xcar.com.cn",
        "washingtonpost.com",
        "bloomberg.com",
        "scribd.com",
        "hp.com",
        "constantcontact.com",
        "4dsply.com",
        "gsmarena.com",
        "intuit.com",
        "meetup.com",
        "nih.gov",
        "americanexpress.com",
        "ehow.com",
        "infusionsoft.com",
        "google.cz",
        "mercadolivre.com.br",
        "myntra.com",
        "varzesh3.com",
        "mobile01.com",
        "hardsextube.com",
        "goal.com",
        "thefreecamsecret.com",
        "thefreedictionary.com",
        "douban.com",
        "iqiyi.com",
        "it168.com",
        "mama.cn",
        "tmz.com",
        "time.com",
        "olx.in",
        "microsoftonline.com",
        "hulu.com",
        "enet.com.cn",
        "speedtest.net",
        "orange.fr",
        "free.fr",
        "detik.com",
        "bluehost.com",
        "libero.it",
        "histats.com",
        "webmd.com",
        "eazel.com",
        "hudong.com",
        "extratorrent.cc",
        "google.co.kr",
        "chaturbate.com",
        "huanqiu.com",
        "cnzz.com",
        "daum.net",
        "xing.com",
        "force.com",
        "jrj.com.cn",
        "pchome.net",
        "cj.com",
        "youjizz.com",
        "delta-search.com",
        "techcrunch.com",
        "motherless.com",
        "tinyurl.com",
        "beeg.com",
        "kooora.com",
        "google.cn",
        "clickbank.com",
        "yandex.ua",
        "ad6media.fr",
        "google.no",
        "amazon.cn",
        "zippyshare.com",
        "acesse.com",
        "google.co.hu",
        "google.ae",
        "hdfcbank.com",
        "nba.com",
        "zendesk.com",
        "blogspot.co.uk",
        "bestbuy.com",
        "accuweather.com",
        "getresponse.com",
        "repubblica.it",
        "xywy.com",
        "ci123.com",
        "ebay.in",
        "in.com",
        "ign.com",
        "groupon.com",
        "yesky.com",
        "elpais.com",
        "marca.com",
        "kwejk.pl",
        "caijing.com.cn",
        "google.ie",
        "cloudfront.net",
        "intoday.in",
        "wideinfo.org",
        "pof.com",
        "kakaku.com",
        "bitauto.com",
        "life.com.tw",
        "xe.com",
        "goo.gl",
        "google.az",
        "feedly.com",
        "tagged.com",
        "amazon.in",
        "list-manage.com",
        "w3.org",
        "quora.com",
        "ixxx.com",
        "mysearchdial.com",
        "dell.com",
        "seznam.cz",
        "t-online.de",
        "plugrush.com",
        "nydailynews.com",
        "okcupid.com",
        "istockphoto.com",
        "snapdo.com",
        "abcnews.go.com",
        "target.com",
        "latimes.com",
        "mywebsearch.com",
        "joomla.org",
        "odesk.com",
        "surveymonkey.com",
        "elmundo.es",
        "siteadvisor.com",
        "aili.com",
        "uimserv.net",
        "ebay.com.au",
        "doubleclick.com",
        "zeobit.com",
        "google.co.il",
        "fbcdn.net",
        "ero-advertising.com",
        "issuu.com",
        "naukri.com",
        "gazeta.pl",
        "ck101.com",
        "udn.com",
        "google.dk",
        "ce.cn",
        "capitalone.com",
        "att.com",
        "drudgereport.com",
        "blackhatworld.com",
        "adrotator.se",
        "retailmenot.com",
        "justdial.com",
        "icicibank.com",
        "likes.com",
        "elance.com",
        "cntv.cn",
        "ameba.jp",
        "java.com",
        "lifehacker.com",
        "jabong.com",
        "gizmodo.com",
        "ebay.it",
        "lenovo.com",
        "hypergames.net",
        "google.fi",
        "doorblog.jp",
        "blogspot.de",
        "jimdo.com",
        "probux.com",
        "blogspot.it",
        "habrahabr.ru",
        "webmoney.ru",
        "irctc.co.in",
        "sahibinden.com",
        "github.io",
        "informer.com",
        "mysearchresults.com",
        "upworthy.com",
        "pch.com",
        "eyny.com",
        "canadaalltax.com",
        "b5m.com",
        "freelancer.com",
        "match.com",
        "searchfun.in",
        "adnxs.com",
        "sberbank.ru",
        "ig.com.br",
        "trulia.com",
        "subscene.com",
        "corriere.it",
        "livescore.com",
        "irs.gov",
        "twoo.com",
        "clixsense.com",
        "4399.com",
        "xda-developers.com",
        "iminent.com",
        "google.com.my",
        "onlinesbi.com",
        "empowernetwork.com",
        "zing.vn",
        "youdao.com",
        "systweak.com",
        "flipora.com",
        "ning.com",
        "engadget.com",
        "abril.com.br",
        "exoclick.com",
        "semrush.com",
        "commentcamarche.net",
        "shareasale.com",
        "vnexpress.net",
        "battle.net",
        "youm7.com",
        "digg.com",
        "rapidgator.net",
        "expedia.com",
        "twimg.com",
        "newegg.com",
        "lady8844.com",
        "xgo.com.cn",
        "pcgames.com.cn",
        "fotolia.com",
        "rednet.cn",
        "inspsearch.com",
        "lemonde.fr",
        "adultfriendfinder.com",
        "typepad.com",
        "mercadolibre.com.ar",
        "homedepot.com",
        "chip.de",
        "lefigaro.fr",
        "swagbucks.com",
        "taleo.net",
        "kinopoisk.ru",
        "oracle.com",
        "who.is",
        "2ch.net",
        "qtrax.com",
        "eonline.com",
        "sochi2014.com",
        "myfreecams.com",
        "pcbaby.com.cn",
        "gome.com.cn",
        "amazon.it",
        "timeanddate.com",
        "bestusefuldownloads.com",
        "foursquare.com",
        "telexfree.com",
        "gc.ca",
        "58.com",
        "hubspot.com",
        "backpage.com",
        "examiner.com",
        "ria.ru",
        "google.sk",
        "opensiteexplorer.org",
        "awesomehp.com",
        "sexlog.com",
        "gutefrage.net",
        "steampowered.com",
        "slate.com",
        "marketwatch.com",
        "beva.com",
        "shaadi.com",
        "v1.cn",
        "teensdigest.com",
        "blogspot.ru",
        "taboola.com",
        "citrixonline.com",
        "hatena.ne.jp",
        "seesaa.net",
        "houzz.com",
        "bodybuilding.com",
        "webs.com",
        "chexun.com",
        "ya.ru",
        "citibank.com",
        "viralnova.com",
        "2345.com",
        "ashleyrnadison.com",
        "verizonwireless.com",
        "55bbs.com",
        "theblaze.com",
        "123rf.com",
        "gotomeeting.com",
        "kijiji.ca",
        "linkbucks.com",
        "haber7.com",
        "pravda.com.ua",
        "altervista.org",
        "mihanblog.com",
        "terra.com.br",
        "soku.com",
        "urbandictionary.com",
        "mercadolibre.com.mx",
        "pixiv.net",
        "oneindia.in",
        "yellowpages.com",
        "hotels.com",
        "drtuber.com",
        "scoop.it",
        "blogspot.jp",
        "cbslocal.com",
        "movie4k.to",
        "cpmterra.com",
        "hubpages.com",
        "mobile.de",
        "yaolan.com",
        "etao.com",
        "hidemyass.com",
        "ca.gov",
        "dreamstime.com",
        "firedrive.com",
        "searchengines.ru",
        "m-w.com",
        "ebay.fr",
        "templatemonster.com",
        "evernote.com",
        "fastdailyfind.com",
        "amazon.es",
        "gateable.com",
        "hupu.com",
        "y8.com",
        "blogspot.com.tr",
        "tokobagus.com",
        "azlyrics.com",
        "website-unavailable.com",
        "r10.net",
        "wiktionary.org",
        "bongacams.com",
        "focus.de",
        "linksynergy.com",
        "steamcommunity.com",
        "vk.me",
        "sakura.ne.jp",
        "foxsports.com",
        "optmd.com",
        "tabelog.com",
        "narod.ru",
        "glassdoor.com",
        "outlook.com",
        "europa.eu",
        "viadeo.com",
        "leadpages.net",
        "ouedkniss.com",
        "facenama.com",
        "lpcloudsvr302.com",
        "agoda.com",
        "qvo6.com",
        "majesticseo.com",
        "mirror.co.uk",
        "google.com.kw",
        "filehippo.com",
        "moneycontrol.com",
        "duckduckgo.com",
        "npr.org",
        "coupons.com",
        "mynet.com",
        "allrecipes.com",
        "priceline.com",
        "liveleak.com",
        "jqw.com",
        "slickdeals.net",
        "webcrawler.com",
        "babytree.com",
        "amung.us",
        "tomshardware.com",
        "openadserving.com",
        "independent.co.uk",
        "kompas.com",
        "turbobit.net",
        "google.kz",
        "leo.org",
        "yandex.com.tr",
        "mp3skull.com",
        "nordstrom.com",
        "news.com.au",
        "traidnt.net",
        "wunderground.com",
        "cnbc.com",
        "jquery.com",
        "dict.cc",
        "persianblog.ir",
        "clarin.com",
        "all-free-download.com",
        "fhserve.com",
        "sape.ru",
        "asos.com",
        "addmefast.com",
        "lequipe.fr",
        "lapatilla.com",
        "ancestry.com",
        "stockstar.com",
        "monster.com",
        "people.com",
        "gawker.com",
        "howstuffworks.com",
        "tradedoubler.com",
        "over-blog.com",
        "cbc.ca",
        "fishcod.com",
        "yoka.com",
        "macys.com",
        "gazeta.ru",
        "free-tv-video-online.me",
        "google.bg",
        "google.lk",
        "southwest.com",
        "realtor.com",
        "custhelp.com",
        "bhaskar.com",
        "softpedia.com",
        "farsnews.com",
        "cy-pr.com",
        "theverge.com",
        "tudou.com",
        "youboy.com",
        "porn.com",
        "wetransfer.com",
        "virgilio.it",
        "mega.co.nz",
        "sfgate.com",
        "delta-homes.com",
        "squarespace.com",
        "watchseries.lt",
        "overstock.com",
        "nifty.com",
        "jvzoo.com",
        "lanacion.com.ar",
        "prntscr.com",
        "vesti.ru",
        "zimbio.com",
        "adscale.de",
        "google.co.nz",
        "yac.mx",
        "tickld.com",
        "kayak.com",
        "youth.cn",
        "jd.com",
        "shopclues.com",
        "allocine.fr",
        "cracked.com",
        "eventbrite.com",
        "behance.net",
        "youtube-mp3.org",
        "bankmellat.ir",
        "echo.msk.ru",
        "autohome.com.cn",
        "yandex.kz",
        "sex.com",
        "smh.com.au",
        "digikala.com",
        "mackolik.com",
        "rottentomatoes.com",
        "renren.com",
        "wired.com",
        "imageshack.us",
        "interia.pl",
        "zanox.com",
        "eastday.com",
        "fool.com",
        "chinabyte.com",
        "haberturk.com",
        "hespress.com",
        "wow.com",
        "jobrapido.com",
        "idnes.cz",
        "qinbei.com",
        "pr-cy.ru",
        "klikbca.com",
        "17ok.com",
        "gamefaqs.com",
        "immobilienscout24.de",
        "biblegateway.com",
        "espnfc.com",
        "ehowenespanol.com",
        "tabnak.ir",
        "avazutracking.net",
        "sapo.pt",
        "welt.de",
        "google.com.ec",
        "sears.com",
        "pcmag.com",
        "nownews.com",
        "kickstarter.com",
        "pixlr.com",
        "hongkiat.com",
        "chinatimes.com",
        "zoho.com",
        "reverso.net",
        "indianrail.gov.in",
        "privatehomeclips.com",
        "cbssports.com",
        "entrepreneur.com",
        "sporx.com",
        "bhphotovideo.com",
        "fatakat.com",
        "xunlei.com",
        "nikkei.com",
        "chron.com",
        "24h.com.vn",
        "basecamp.com",
        "airtel.in",
        "dealshark.com",
        "shopify.com",
        "babycenter.com",
        "letitbit.net",
        "nuvid.com",
        "yts.re",
        "aparat.com",
        "r2games.com",
        "prestashop.com",
        "alarabiya.net",
        "india.com",
        "magentocommerce.com",
        "heise.de",
        "sulekha.com",
        "mpnrs.com",
        "ibm.com",
        "cbsnews.com",
        "searchengineland.com",
        "mapquest.com",
        "ccb.com",
        "zappos.com",
        "rightmove.co.uk",
        "sahadan.com",
        "milanuncios.com",
        "wenku.baidu.com/user/reg",
        "ovh.net",
        "screencast.com",
        "ahrefs.com",
        "6.cn",
        "businessweek.com",
        "linternaute.com",
        "dafont.com",
        "bestblackhatforum.com",
        "streamcloud.eu",
        "as.com",
        "gtmetrix.com",
        "wmmail.ru",
        "spankwire.com",
        "google.com.do",
        "jeuxvideo.com",
        "digitalpoint.com",
        "amazon.ca",
        "mlb.com",
        "weheartit.com",
        "list.ru",
        "leagueoflegends.com",
        "56.com",
        "bloglovin.com",
        "payoneer.com",
        "nokia.com",
        "aizhan.com",
        "novinky.cz",
        "ustream.tv",
        "getbootstrap.com",
        "seekingalpha.com",
        "codwide.com",
        "vice.com",
        "usmagazine.com",
        "primewire.ag",
        "cam4.com",
        "thehindu.com",
        "deezer.com",
        "graphicriver.net",
        "dmm.com",
        "biglobe.ne.jp",
        "google.rs",
        "z5x.net",
        "tutsplus.com",
        "icicibank.co.in",
        "indiamart.com",
        "gap.com",
        "ensonhaber.com",
        "sitepoint.com",
        "rutor.org",
        "chinanews.com",
        "brainyquote.com",
        "keepvid.com",
        "censor.net.ua",
        "subito.it",
        "tablica.pl",
        "onlylady.com",
        "zulily.com",
        "squidoo.com",
        "change.org",
        "sh.st",
        "webhostingtalk.com",
        "9gag.tv",
        "nairaland.com",
        "gulfup.com",
        "staples.com",
        "gamespot.com",
        "woorank.com",
        "box.com",
        "infobae.com",
        "elegantthemes.com",
        "104.com.tw",
        "aftonbladet.se",
        "google.hr",
        "myegy.com",
        "noticias24.com",
        "eastmoney.com",
        "lowes.com",
        "xtube.com",
        "worldstarhiphop.com",
        "glispa.com",
        "verizon.com",
        "united.com",
        "linkwithin.com",
        "google.com.ly",
        "whitepages.com",
        "games.la",
        "dmoz.org",
        "imagebam.com",
        "careerbuilder.com",
        "sky.com",
        "instructables.com",
        "mercadolibre.com.ve",
        "makemytrip.com",
        "pinimg.com",
        "pingdom.com",
        "foodnetwork.com",
        "orf.at",
        "android.com",
        "wiocha.pl",
        "csdn.net",
        "appledaily.com.tw",
        "nike.com",
        "eluniversal.com.mx",
        "delta.com",
        "ezinearticles.com",
        "sueddeutsche.de",
        "woothemes.com",
        "comcast.com",
        "gismeteo.ru",
        "lotour.com",
        "nfl.com",
        "xbox.com",
        "almanar.com.lb",
        "disney.go.com",
        "ctrip.com",
        "forexfactory.com",
        "clicksvenue.com",
        "nhl.com",
        "ted.com",
        "gstatic.com",
        "forobeta.com",
        "ovh.com",
        "mystart.com",
        "maktoob.com",
        "nouvelobs.com",
        "hindustantimes.com",
        "billdesk.com",
        "1und1.de",
        "zhaopin.com",
        "weather.gov",
        "kioskea.net",
        "myspace.com",
        "firstpost.com",
        "picmonkey.com",
        "grooveshark.com",
        "exblog.jp",
        "pantip.com",
        "earthlink.net",
        "styletv.com.cn",
        "icloud.com",
        "manta.com",
        "google.by",
        "mediaset.it",
        "searchenginewatch.com",
        "japanpost.jp",
        "postimg.org",
        "mbc.net",
        "cheezburger.com",
        "workercn.cn",
        "directadvert.ru",
        "nationzoom.com",
        "caixa.gov.br",
        "gumtree.com",
        "51job.com",
        "viooz.co",
        "usbank.com",
        "wmtransfer.com",
        "fidelity.com",
        "gogetlinks.net",
        "office365.com",
        "pchome.com.tw",
        "feedburner.com",
        "mp3truck.net",
        "sfr.fr",
        "junglee.com",
        "keezmovies.com",
        "binarysystem4u.com",
        "way2sms.com",
        "oyunskor.com",
        "peyvandha.ir",
        "ticketmaster.com",
        "lacaixa.es",
        "video-one.com",
        "yomiuri.co.jp",
        "popcash.net",
        "nypost.com",
        "dubizzle.com",
        "wpmudev.org",
        "mgid.com",
        "google.lt",
        "zazzle.com",
        "nbcolympics.com",
        "battlefield.com",
        "avast.com",
        "jsfiddle.net",
        "namecheap.com",
        "css-tricks.com",
        "friv.com",
        "6park.com",
        "xhamstercams.com",
        "mysql.com",
        "dx.com",
        "thechive.com",
        "vsuch.com",
        "souq.com",
        "anyoption.com",
        "dantri.com.vn",
        "ebay.es",
        "abc.es",
        "whatsapp.com",
        "bitshare.com",
        "savefrom.net",
        "beytoote.com",
        "xiaomi.com",
        "prweb.com",
        "prothom-alo.com",
        "pagesjaunes.fr",
        "bbb.org",
        "eenadu.net",
        "tinypic.com",
        "whois.com",
        "sourtimes.org",
        "adk2.com",
        "criteo.com",
        "tistory.com",
        "ilyke.net",
        "ruten.com.tw",
        "skysports.com",
        "makeuseof.com",
        "p5w.net",
        "hh.ru",
        "nationalgeographic.com",
        "pornmd.com",
        "rakuten.ne.jp",
        "idealo.de",
        "telegraaf.nl",
        "barnesandnoble.com",
        "mynavi.jp",
        "4chan.org",
        "media-fire.org",
        "crunchbase.com",
        "bravotube.net",
        "myfitnesspal.com",
        "today.com",
        "mit.edu",
        "cnmo.com",
        "nu.nl",
        "tripadvisor.co.uk",
        "spotify.com",
        "homeway.com.cn",
        "dianping.com",
        "costco.com",
        "pastebin.com",
        "dhgate.com",
        "windowsphone.com",
        "stagram.com",
        "investopedia.com",
        "ninemsn.com.au",
        "excite.co.jp",
        "22find.com",
        "google.iq",
        "hi5.com",
        "ad4game.com",
        "kohls.com",
        "online.sh.cn",
        "geocities.jp",
        "investing.com",
        "haberler.com",
        "ft.com",
        "weblio.jp",
        "google.tn",
        "list-manage1.com",
        "hsbc.co.uk",
        "ppstream.com",
        "cloob.com",
        "korrespondent.net",
        "ucoz.com",
        "1and1.com",
        "mail.com",
        "fotostrana.ru",
        "accountonline.com",
        "forgeofempires.com",
        "dribbble.com",
        "city-data.com",
        "drupal.org",
        "tunein.com",
        "51fanli.com",
        "ibtimes.com",
        "intel.com",
        "polyvore.com",
        "cbs.com",
        "bab.la",
        "imobile.com.cn",
        "bestadbid.com",
        "eztv.it",
        "smashingmagazine.com",
        "skyrock.com",
        "copyscape.com",
        "cookpad.com",
        "smallseotools.com",
        "asus.com",
        "anysex.com",
        "nbcsports.com",
        "kinox.to",
        "mbank.com.pl",
        "500px.com",
        "sofanti.com",
        "marktplaats.nl",
        "cpanel.net",
        "hm.com",
        "chicagotribune.com",
        "ultimate-guitar.com",
        "infolinks.com",
        "merdeka.com",
        "yandex.by",
        "tribalfusion.com",
        "livedoor.biz",
        "prezi.com",
        "last.fm",
        "sznews.com",
        "junbi-tracker.com",
        "so-net.ne.jp",
        "cocolog-nifty.com",
        "ocn.ne.jp",
        "perezhilton.com",
        "yaplakal.com",
        "championat.com",
        "ebay.ca",
        "mangareader.net",
        "donanimhaber.com",
        "miniclip.com",
        "vcommission.com",
        "noaa.gov",
        "imagefap.com",
        "gumtree.com.au",
        "liveperson.net",
        "gfycat.com",
        "hollywoodreporter.com",
        "dropboxusercontent.com",
        "akhbarak.net",
        "sou300.com",
        "kicker.de",
        "livestream.com",
        "tribunnews.com",
        "kp.ru",
        "techradar.com",
        "315che.com",
        "dw.de",
        "codeproject.com",
        "newsru.com",
        "pconline.com.cn",
        "aa.com",
        "usaa.com",
        "asahi.com",
        "themetapicture.com",
        "quicksprout.com",
        "piriform.com",
        "888poker.com",
        "gittigidiyor.com",
        "nhk.or.jp",
        "statigr.am",
        "ipage.com",
        "gazzetta.it",
        "letv.com",
        "yourlust.com",
        "freepik.com",
        "trello.com",
        "mixi.jp",
        "livememe.com",
        "ew.com",
        "seosprint.net",
        "doisongphapluat.com",
        "autotrader.com",
        "docstoc.com",
        "viva.co.id",
        "livestrong.com",
        "inc.com",
        "hunantv.com",
        "bahn.de",
        "depositphotos.com",
        "rackspace.com",
        "flippa.com",
        "norton.com",
        "lynda.com",
        "teamviewer.com",
        "vip.com",
        "ksl.com",
        "solarmovie.so",
        "klout.com",
        "pikabu.ru",
        "vporn.com",
        "apache.org",
        "sportbox.ru",
        "correios.com.br",
        "toptenreviews.com",
        "ea.com",
        "thenextweb.com",
        "superuser.com",
        "delicious.com",
        "zoosk.com",
        "inbox.com",
        "kongregate.com",
        "starbaby.cn",
        "888casino.com",
        "brazzers.com",
        "sockshare.com",
        "megashare.info",
        "vistaprint.com",
        "porntube.com",
        "seriesyonkis.com",
        "20minutos.es",
        "jagran.com",
        "programme-tv.net",
        "elcomercio.pe",
        "blogspot.kr",
        "t411.me",
        "googleapis.com",
        "blog.com",
        "qingdaonews.com",
        "sedo.com",
        "itmedia.co.jp",
        "mtv.com",
        "ynet.co.il",
        "playstation.com",
        "pornhublive.com",
        "thedailybeast.com",
        "r7.com",
        "sabah.com.tr",
        "126.com",
        "topix.com",
        "liga.net",
        "marriott.com",
        "tvn24.pl",
        "sitesell.com",
        "netdna-cdn.com",
        "startimes.com",
        "hstpnetwork.com",
        "blogspot.com.au",
        "17u.cn",
        "subscribe.ru",
        "woot.com",
        "rozblog.com",
        "wimp.com",
        "vg.no",
        "t-mobile.com",
        "bmi.ir",
        "kankan.com",
        "tsn.ua",
        "gumtree.co.za",
        "googleadservices.com",
        "pnc.com",
        "cars.com",
        "soccerway.com",
        "o2.pl",
        "zeit.de",
        "zopim.com",
        "cloudflare.com",
        "givemesport.com",
        "statscrop.com",
        "gravatar.com",
        "flightradar24.com",
        "ubuntu.com",
        "salon.com",
        "ytimg.com",
        "trovigo.com",
        "sunporno.com",
        "libertagia.com",
        "mihanwebads.com",
        "shopathome.com",
        "cdiscount.com",
        "commbank.com.au",
        "elwatannews.com",
        "discovercard.com",
        "infowars.com",
        "blogimg.jp",
        "portaldosites.com",
        "fixya.com",
        "drom.ru",
        "fastpic.ru",
        "pbs.org",
        "kandao.com",
        "okwave.jp",
        "faz.net",
        "sbnation.com",
        "hilton.com",
        "duba.com",
        "homeshop18.com",
        "ultimasnoticias.com.ve",
        "bankrate.com",
        "megasesso.com",
        "studiopress.com",
        "sports.ru",
        "asriran.com",
        "etoro.com",
        "cafemom.com",
        "dhl.de",
        "indiegogo.com",
        "tdcanadatrust.com",
        "1tv.ru",
        "gogvo.com",
        "bt.com",
        "blogspot.tw",
        "zergnet.com",
        "garanti.com.tr",
        "privatbank.ua",
        "sanook.com",
        "travelocity.com",
        "networksolutions.com",
        "thqafawe3lom.com",
        "trklnks.com",
        "torchbrowser.com",
        "logmein.com",
        "williamhill.com",
        "zhihu.com",
        "auto.ru",
        "craigslist.ca",
        "olx.com.pk",
        "smi2.ru",
        "ukr.net",
        "dpreview.com",
        "boston.com",
        "folha.uol.com.br",
        "name.com",
        "ashemaletube.com",
        "slimspots.com",
        "envato.com",
        "6pm.com",
        "fandango.com",
        "sozcu.com.tr",
        "nikkeibp.co.jp",
        "aufeminin.com",
        "baiducontent.com",
        "buscape.com.br",
        "funnyordie.com",
        "337.com",
        "sakshi.com",
        "airasia.com",
        "samanyoluhaber.com",
        "picofile.com",
        "blackberry.com",
        "google.com.gt",
        "io9.com",
        "easyhits4u.com",
        "qianyan001.com",
        "flashx.tv",
        "zap2it.com",
        "dnsrsearch.com",
        "patch.com",
        "staticflickr.com",
        "clicksor.com",
        "mcafee.com",
        "zerohedge.com",
        "zara.com",
        "freelotto.com",
        "tutorialspoint.com",
        "qone8.com",
        "olx.com.br",
        "axisbank.com",
        "marketgid.com",
        "your-server.de",
        "game321.com",
        "harvard.edu",
        "indianexpress.com",
        "fatwallet.com",
        "nudevista.com",
        "paper.li",
        "opera.com",
        "serving-sys.com",
        "nowvideo.sx",
        "theatlantic.com",
        "cisco.com",
        "bookmyshow.com",
        "webmasterworld.com",
        "metro.co.uk",
        "leparisien.fr",
        "orbitz.com",
        "h2porn.com",
        "4cdn.org",
        "itar-tass.com",
        "nasa.gov",
        "macrumors.com",
        "google.si",
        "usnews.com",
        "premierleague.com",
        "largeporntube.com",
        "blogsky.com",
        "bufferapp.com",
        "zeroredirect1.com",
        "sendspace.com",
        "stanford.edu",
        "state.gov",
        "yjc.ir",
        "abc.net.au",
        "pornsharing.com",
        "4pda.ru",
        "52pk.net",
        "meituan.com",
        "mmgp.ru",
        "sponichi.co.jp",
        "masrawy.com",
        "whatismyipaddress.com",
        "onlinewebfind.com",
        "news24.com",
        "zdnet.com",
        "imagevenue.com",
        "gameaholic.com",
        "mediaplex.com",
        "clip.vn",
        "2mdn.net",
        "nmisr.com",
        "musica.com",
        "networkedblogs.com",
        "metrolyrics.com",
        "chacha.com",
        "internetdownloadmanager.com",
        "legacy.com",
        "wwe.com",
        "icbc.com.cn",
        "ny.gov",
        "chomikuj.pl",
        "alexa.com",
        "pcworld.com",
        "overthumbs.com",
        "adp.com",
        "ad2games.com",
        "adme.ru",
        "bidvertiser.com",
        "rtl.de",
        "sweetim.com",
        "gaana.com",
        "7k7k.com",
        "livingsocial.com",
        "netteller.com",
        "rakuten.com",
        "chess.com",
        "blackboard.com",
        "thekitchn.com",
        "ilfattoquotidiano.it",
        "20minutes.fr",
        "soufun.com",
        "nerdbux.com",
        "breitbart.com",
        "webtretho.com",
        "tvguide.com",
        "miralinks.ru",
        "weather.com.cn",
        "zalando.de",
        "dangdang.com",
        "bubblews.com",
        "thoughtcatalog.com",
        "114la.com",
        "msn.ca",
        "blogmura.com",
        "americanas.com.br",
        "elitedaily.com",
        "lightinthebox.com",
        "bizjournals.com",
        "yixun.com",
        "itau.com.br",
        "51.la",
        "doodle.com",
        "arabyonline.com",
        "opencart.com",
        "bomnegocio.com",
        "lego.com",
        "pclady.com.cn",
        "metacafe.com",
        "kimiss.com",
        "journaldunet.com",
        "gnavi.co.jp",
        "51auto.com",
        "clickey.com",
        "chekb.com",
        "searchnu.com",
        "diply.com",
        "walgreens.com",
        "descargar.es",
        "mirrorcreator.com",
        "pornerbros.com",
        "askmen.com",
        "shop.com",
        "inmotionhosting.com",
        "filmweb.pl",
        "kbb.com",
        "appround.biz",
        "aljazeera.com",
        "lumosity.com",
        "sweet-page.com",
        "pole-emploi.fr",
        "fishki.net",
        "rollingstone.com",
        "kapanlagi.com",
        "yandex.com",
        "cnblogs.com",
        "plaintube.com",
        "intentmedia.net",
        "about.me",
        "torrentz.in",
        "01net.com",
        "gyazo.com",
        "nic.ru",
        "juicyads.com",
        "trend.az",
        "askubuntu.com",
        "unam.mx",
        "tradus.com",
        "tigerdirect.com",
        "letras.mus.br",
        "imagetwist.com",
        "perfectmoney.is",
        "wpbeginner.com",
        "thepiratetrader.com",
        "victoriassecret.com",
        "images-amazon.com",
        "tusfiles.net",
        "chefkoch.de",
        "ojooo.com",
        "alphaporno.com",
        "betfair.com",
        "tympanus.net",
        "td.com",
        "4tube.com",
        "phonearena.com",
        "bankmandiri.co.id",
        "cox.net",
        "ozon.ru",
        "perfectgirls.net",
        "asana.com",
        "sprint.com",
        "berniaga.com",
        "vente-privee.com",
        "ing.nl",
        "finn.no",
        "atwiki.jp",
        "toysrus.com",
        "petflow.com",
        "reverbnation.com",
        "freeones.com",
        "abc.go.com",
        "bradesco.com.br",
        "yenisafak.com.tr",
        "profit-partner.ru",
        "redfin.com",
        "mangafox.me",
        "appnexus.com",
        "sxc.hu",
        "speedanalysis.net",
        "n-tv.de",
        "qidian.com",
        "teespring.com",
        "break.com",
        "nailedhard.com",
        "jalan.net",
        "authorize.net",
        "adultadworld.com",
        "sootoo.com",
        "roboform.com",
        "kotaku.com",
        "multitran.ru",
        "food.com",
        "twitpic.com",
        "pogo.com",
        "sabq.org",
        "priceminister.com",
        "lexpress.fr",
        "livetv.sx",
        "nikkansports.com",
        "securepaynet.net",
        "vodoumedia.com",
        "airbnb.com",
        "trafficholder.com",
        "rr.com",
        "expireddomains.net",
        "bandcamp.com",
        "wayfair.com",
        "tut.by",
        "maybank2u.com.my",
        "similarweb.com",
        "zol.com.cn",
        "247realmedia.com",
        "asp.net",
        "lonelyplanet.com",
        "seopult.ru",
        "whois.net",
        "academia.edu",
        "univision.com",
        "interfax.ru",
        "amarillasinternet.com",
        "miercn.com",
        "barclays.co.uk",
        "societe.com",
        "khabaronline.ir",
        "unity3d.com",
        "nyaa.se",
        "euronews.com",
        "verizon.net",
        "rutube.ru",
        "wetter.com",
        "imlive.com",
        "ggpht.com",
        "docin.com",
        "yify-torrents.com",
        "yhd.com",
        "citibank.co.in",
        "xdating.com",
        "roblox.com",
        "voyages-sncf.com",
        "189.cn",
        "identi.li",
        "bayt.com",
        "medicinenet.com",
        "wmaraci.com",
        "stern.de",
        "eluniversal.com",
        "zoopla.co.uk",
        "easyjet.com",
        "dhl.com",
        "freakshare.com",
        "rojadirecta.me",
        "sp.gov.br",
        "friendfeed.com",
        "beamtele.com",
        "searchenginejournal.com",
        "nocookie.net",
        "reliancenetconnect.co.in",
        "google.co.ma",
        "fanpop.com",
        "adk2.co",
        "tagesschau.de",
        "nate.com",
        "ole.com.ar",
        "index.hu",
        "aruba.it",
        "eltiempo.com",
        "resellerclub.com",
        "qip.ru",
        "xossip.com",
        "siteground.com",
        "royalbank.com",
        "advfn.com",
        "tebyan.net",
        "iciba.com",
        "bigcartel.com",
        "sciencedirect.com",
        "hepsiburada.com",
        "cpasbien.me",
        "alfabank.ru",
        "microsoftstore.com",
        "discogs.com",
        "onliner.by",
        "socialmediaexaminer.com",
        "seasonvar.ru",
        "tripadvisor.in",
        "360doc.com",
        "chinabroadcast.cn",
        "realestate.com.au",
        "avira.com",
        "herokuapp.com",
        "downloadsetup.net",
        "torcache.net",
        "uefa.com",
        "rg.ru",
        "qianlong.com",
        "hugedomains.com",
        "arstechnica.com",
        "fifa.com",
        "ryanair.com",
        "i.ua",
        "axisbank.co.in",
        "alimama.com",
        "wanggou.com",
        "radikal.com.tr",
        "echoroukonline.com",
        "unian.net",
        "slashdot.org",
        "dmv.org",
        "mayoclinic.org",
        "newsmax.com",
        "google.com.et",
        "icontact.com",
        "vanguardngr.com",
        "infojobs.net",
        "say-move.org",
        "ileehoo.com",
        "mirtesen.ru",
        "yam.com",
        "e-hentai.org",
        "wikimapia.org",
        "shop-pro.jp",
        "bukalapak.com",
        "jcpenney.com",
        "ilmeteo.it",
        "iltasanomat.fi",
        "telecomitalia.it",
        "kariyer.net",
        "shutterfly.com",
        "santabanta.com",
        "softlayer.com",
        "complex.com",
        "mamba.ru",
        "netshoes.com.br",
        "theweathernetwork.com",
        "politico.com",
        "advego.ru",
        "eroprofile.com",
        "mainichi.jp",
        "nta.go.jp",
        "sfimg.com",
        "ap.org",
        "webex.com",
        "hinet.net",
        "skyscrapercity.com",
        "affili.net",
        "adplxmd.com",
        "iltalehti.fi",
        "impress.co.jp",
        "jezebel.com",
        "extremetube.com",
        "digitaltrends.com",
        "one.com",
        "ranker.com",
        "qiwi.com",
        "collegehumor.com",
        "nbc.com",
        "boursorama.com",
        "watch32.com",
        "meetcheap.com",
        "forums.wordpress.com",
        "cvs.com",
        "kenh14.vn",
        "yallakora.com",
        "plurk.com",
        "xtool.ru",
        "airtel.com",
        "wp.com",
        "sftimes.co",
        "economist.com",
        "rapidshare.com",
        "redbox.com",
        "audible.com",
        "kissmetrics.com",
        "atpanel.com",
        "wargaming.net",
        "1337x.org",
        "shahrekhabar.com",
        "bdnews24.com",
        "tvrain.ru",
        "wykop.pl",
        "mts.ru",
        "nnm-club.me",
        "schwab.com",
        "elconfidencial.com",
        "modelmayhem.com",
        "zhidao.baidu.com/user/admin",
        "aastocks.com",
        "tiscali.it",
        "qadabra.com",
        "autoscout24.de",
        "vatanim.com.tr",
        "gotowebinar.com",
        "edmunds.com",
        "ebaumsworld.com",
        "megafilmeshd.net",
        "poste.it",
        "mcssl.com",
        "aljazeera.net",
        "netvibes.com",
        "sme.sk",
        "tesco.com",
        "525j.com.cn",
        "tf1.fr",
        "ccidnet.com",
        "ldblog.jp",
        "blockchain.info",
        "played.to",
        "nthwall.com",
        "justanswer.com",
        "clickbank.net",
        "fnac.com",
        "gmarket.co.kr",
        "clipconverter.cc",
        "nextmedia.com",
        "bb.com.br",
        "learntotradethemarket.com",
        "pornoid.com",
        "downloadha.com",
        "hellporno.com",
        "ooo-sex.com",
        "blocket.se",
        "tubeplus.me",
        "seek.com.au",
        "filestube.to",
        "ceneo.pl",
        "walmart.com.br",
        "sonymobile.com",
        "dyndns.org",
        "ulmart.ru",
        "vrbo.com",
        "sport.pl",
        "ashleymadison.com",
        "el-wlid.com",
        "boredpanda.com",
        "udemy.com",
        "mobogenie.com",
        "tubegalore.com",
        "theglobeandmail.com",
        "bancobrasil.com.br",
        "888.com",
        "adreactor.com",
        "zomato.com",
        "depositfiles.com",
        "moneysavingexpert.com",
        "dofus.com",
        "oanda.com",
        "sport1.de",
        "justhost.com",
        "longhoo.net",
        "otomoto.pl",
        "techrepublic.com",
        "westpac.com.au",
        "dreamhost.com",
        "ilsole24ore.com",
        "clubic.com",
        "gamme.com.tw",
        "doctissimo.fr",
        "isna.ir",
        "s2d6.com",
        "tdbank.com",
        "zwaar.net",
        "slando.ua",
        "segodnya.ua",
        "appannie.com",
        "bartarinha.ir",
        "egotastic.com",
        "ed.gov",
        "lg.com",
        "120ask.com",
        "hostmonster.com",
        "super.cz",
        "mercola.com",
        "bayproxy.me",
        "day.az",
        "dummies.com",
        "azet.sk",
        "huffingtonpost.co.uk",
        "okezone.com",
        "medu.ir",
        "lavanguardia.com",
        "espreso.tv",
        "nymag.com",
        "autotrader.co.uk",
        "socialmediatoday.com",
        "wn.com",
        "rtbpop.com",
        "99designs.com",
        "sanspo.com",
        "proboards.com",
        "virginmedia.com",
        "99acres.com",
        "blic.rs",
        "pingomatic.com",
        "prnewswire.com",
        "sony.com",
        "seobuilding.ru",
        "www.gov.uk",
        "jugem.jp",
        "watchtower.com",
        "seoprofiler.com",
        "centrum.cz",
        "techbrowsing.com",
        "almasryalyoum.com",
        "lolking.net",
        "nipic.com",
        "fanfiction.net",
        "bwin.com",
        "anyporn.com",
        "sulit.com.ph",
        "quickmeme.com",
        "carview.co.jp",
        "haizhangs.com",
        "airtelforum.com",
        "flirt4free.com",
        "billboard.com",
        "trademe.co.nz",
        "rapgenius.com",
        "pchouse.com.cn",
        "beforeitsnews.com",
        "peopleperhour.com",
        "basecamphq.com",
        "onlinedown.net",
        "bet365.es",
        "fucked-tube.com",
        "santander.co.uk",
        "speedbit.com",
        "gi-akademie.com",
        "google.com.pr",
        "winupdatevideos.com",
        "bizrate.com",
        "xxxbunker.com",
        "coursera.org",
        "zoominfo.com",
        "rarbg.com",
        "ahram.org.eg",
        "howtogeek.com",
        "focus.cn",
        "duden.de",
        "mufg.jp",
        "ex.ua",
        "titan24.com",
        "greatandhra.com",
        "qqbaobao.com",
        "rtve.es",
        "yandex.net",
        "yle.fi",
        "panoramio.com",
        "google.com.af",
        "scol.com.cn",
        "gamestop.com",
        "xiami.com",
        "webpagetest.org",
        "creativecommons.org",
        "archive.is",
        "timesjobs.com",
        "centurylink.com",
        "wowhead.com",
        "wordstream.com",
        "lloydsbank.co.uk",
        "incredibar.com",
        "vagalume.com.br",
        "installerapplicationusa.com",
        "shinobi.jp",
        "ruvr.ru",
        "natwest.com",
        "roulettebotplus.com",
        "wildberries.ru",
        "huaban.com",
        "buenosearch.com",
        "reg.ru",
        "tempo.co",
        "qvc.com",
        "mangahere.com",
        "tv.com",
        "boc.cn",
        "fnb.co.za",
        "made-in-china.com",
        "eleconomista.es",
        "ubuntuforums.org",
        "derstandard.at",
        "xml-sitemaps.com",
        "jang.com.pk",
        "jiayuan.com",
        "credit-agricole.fr",
        "androidcentral.com",
        "urbanspoon.com",
        "pornoxo.com",
        "regnum.ru",
        "bedbathandbeyond.com",
        "skladchik.com",
        "daily.co.jp",
        "n-mobile.net",
        "suntrust.com",
        "justjared.com",
        "vid2c.com",
        "gettyimages.com",
        "tubecup.com",
        "kinogo.net",
        "similarsites.com",
        "fling.com",
        "vine.co",
        "banglanews24.com",
        "pudelek.pl",
        "support.wordpress.com",
        "cox.com",
        "xkcd.com",
        "adbooth.com",
        "anz.com",
        "adxcore.com",
        "google.com.sv",
        "indeed.co.in",
        "scottrade.com",
        "v9.com",
        "isohunt.to",
        "srclick.ru",
        "gharreh.com",
        "zaman.com.tr",
        "monsterindia.com",
        "delfi.lt",
        "chewen.com",
        "empowernetwork.com/QUbsgqDwpjjbkpOgwgOeaw==",
        "state.tx.us",
        "segundamano.es",
        "utro.ru",
        "sitescout.com",
        "justclick.ru",
        "wnd.com",
        "cosmopolitan.com",
        "local.com",
        "anitube.se",
        "sport.es",
        "google.com.qa",
        "ads-id.com",
        "google.lv",
        "capitalone360.com",
        "hattrick.org",
        "qualtrics.com",
        "inagist.com",
        "filgoal.com",
        "incredibar-search.com",
        "adslgate.com",
        "directv.com",
        "ilivid.com",
        "warthunder.ru",
        "jasmin.com",
        "cyberciti.biz",
        "msn.co.jp",
        "canalblog.com",
        "boerse.bz",
        "tnaflix.com",
        "apa.az",
        "prchecker.info",
        "reclameaqui.com.br",
        "onlyworldnews.com",
        "submarino.com.br",
        "kuronekoyamato.co.jp",
        "paipai.com",
        "realitykings.com",
        "deadspin.com",
        "islamweb.net",
        "no-ip.com",
        "lostfilm.tv",
        "wattpad.com",
        "wav.tv",
        "citi.com",
        "buysellads.com",
        "prezentacya.ru",
        "forocoches.com",
        "donga.com",
        "drive2.ru",
        "netsuite.com",
        "privalia.com",
        "bidorbuy.co.za",
        "cmbchina.com",
        "searchresultsguide.com",
        "odatv.com",
        "skrill.com",
        "en.wordpress.com",
        "dojki.com",
        "unibet.com",
        "hotpepper.jp",
        "simplyhired.com",
        "vesti.ua",
        "ibtimes.co.uk",
        "creativebloq.com",
        "filmesonlinegratis.net",
        "videohive.net",
        "kmart.com",
        "metacritic.com",
        "rikunabi.com",
        "zozo.jp",
        "venturebeat.com",
        "1and1.es",
        "banesconline.com",
        "internethaber.com",
        "rae.es",
        "planetsuzy.org",
        "wpengine.com",
        "kizi.com",
        "armorgames.com",
        "argos.co.uk",
        "dtiblog.com",
        "diigo.com",
        "forever21.com",
        "flashscore.com",
        "vedomosti.ru",
        "ccavenue.com",
        "att.net",
        "esporte.uol.com.br",
        "empowernetwork.com/PXQ7Uz1Kyg+LR1APrG7pKQ==",
        "to8to.com",
        "hotwire.com",
        "all.biz",
        "info.com",
        "xhamster.com/user/video",
        "000webhost.com",
        "worldoftanks.ru",
        "dagbladet.no",
        "computerbild.de",
        "nasdaq.com",
        "chitika.com",
        "ipeen.com.tw",
        "abola.pt",
        "wiley.com",
        "lpcloudsvr303.com",
        "tinsao.net",
        "mehrnews.com",
        "hugesex.tv",
        "christian-dogma.com",
        "search.us.com",
        "garmin.com",
        "tgbus.com",
        "iherb.com",
        "torntv-tvv.org",
        "chosun.com",
        "kinozal.tv",
        "berkeley.edu",
        "techtarget.com",
        "labanquepostale.fr",
        "fitbit.com",
        "folkd.com",
        "theonion.com",
        "idealista.com",
        "oscar.go.com",
        "jiji.com",
        "anonym.to",
        "allabout.co.jp",
        "wufoo.com",
        "rantlifestyle.com",
        "google.com.bo",
        "28.com",
        "rocketnews24.com",
        "hotspotshield.com",
        "opentable.com",
        "admngronline.com",
        "naturalnews.com",
        "zeroredirect2.com",
        "ero-video.net",
        "dinamalar.com",
        "fl.ru",
        "mtsindia.in",
        "kapook.com",
        "theage.com.au",
        "allmyvideos.net",
        "dinodirect.com",
        "videodownloadconverter.com",
        "tripleclicks.com",
        "brassring.com",
        "fapdu.com",
        "cafepress.com",
        "infospace.com",
        "express.com.pk",
        "fumu.com",
        "infibeam.com",
        "etrade.com",
        "meneame.net",
        "seroundtable.com",
        "bigpoint.com",
        "chinadaily.com.cn",
        "myfonts.com",
        "ezdownloadpro.info",
        "codeplex.com",
        "xl.pt",
        "kaspersky.com",
        "khabarfarsi.com",
        "admitad.com",
        "flirchi.com",
        "dpstream.net",
        "miniinthebox.com",
        "samsclub.com",
        "charter.net",
        "techbang.com",
        "tiu.ru",
        "fanpage.it",
        "spokeo.com",
        "imageshack.com",
        "ijreview.com",
        "bc.vc",
        "lazada.co.id",
        "gofirstrow.eu",
        "uptobox.com",
        "newsnow.co.uk",
        "symantec.com",
        "editor.wix.com",
        "avaxhome.cc",
        "canalplus.fr",
        "copyblogger.com",
        "vetogate.com",
        "yahoo-mbga.jp",
        "manoramaonline.com",
        "ah-me.com",
        "elheddaf.com",
        "bitcointalk.org",
        "haqaik.com",
        "bbandt.com",
        "linguee.de",
        "blogspot.nl",
        "minus.com",
        "amarujala.com",
        "openclassrooms.com",
        "bigmir.net",
        "koramgame.com",
        "commonfloor.com",
        "gayromeo.com",
        "cleartrip.com",
        "kompasiana.com",
        "tankionline.com",
        "google.co.tz",
        "springer.com",
        "lifenews.ru",
        "sify.com",
        "tvoyauda4a.ru",
        "dfiles.ru",
        "technorati.com",
        "myorderbox.com",
        "fanatik.com.tr",
        "activesearchresults.com",
        "laposte.net",
        "whirlpool.net.au",
        "stockcharts.com",
        "leadimpact.com",
        "cardekho.com",
        "ryushare.com",
        "blog.jp",
        "fastcompany.com",
        "eurosport.fr",
        "emirates.com",
        "lb.ua",
        "serverfault.com",
        "forbes.ru",
        "bfmtv.com",
        "google.jo",
        "17173.com",
        "wikispaces.com",
        "tokopedia.com",
        "liberation.fr",
        "a10.com",
        "kdnet.net",
        "variety.com",
        "blog.me",
        "homeaway.com",
        "ameritrade.com",
        "adult-empire.com",
        "national.com.au",
        "haraj.com.sa",
        "timewarnercable.com",
        "casino.com",
        "sheknows.com",
        "google.com.uy",
        "abv.bg",
        "liputan6.com",
        "etxt.ru",
        "bigstockphoto.com",
        "strato.de",
        "cashtasks.com",
        "columbia.edu",
        "zdf.de",
        "pptv.com",
        "cricbuzz.com",
        "sharesuper.info",
        "radaronline.com",
        "pornolab.net",
        "google.ba",
        "opensubtitles.org",
        "abclocal.go.com",
        "ansa.it",
        "pbskids.org",
        "vz.ru",
        "iconfinder.com",
        "vitaminl.tv",
        "ntv.ru",
        "peliculasyonkis.com",
        "foto-hd.com",
        "paytm.com",
        "rantsports.com",
        "optimum.net",
        "postbank.de",
        "index.hr",
        "smugmug.com",
        "haivl.com",
        "arbeitsagentur.de",
        "dailycaller.com",
        "freshbooks.com",
        "genieo.com",
        "alnaddy.com",
        "britishairways.com",
        "20min.ch",
        "findthebest.com",
        "autoblog.com",
        "warez-bb.org",
        "iza.ne.jp",
        "filmaffinity.com",
        "megogo.net",
        "soccermanager.com",
        "dawanda.com",
        "parallels.com",
        "clickjogos.uol.com.br",
        "12306.cn",
        "jstv.com",
        "cliphunter.com",
        "pixabay.com",
        "milenio.com",
        "keybinary.com",
        "suumo.jp",
        "mediatakeout.com",
        "vodafone.in",
        "cheapoair.com",
        "seobook.com",
        "videoyoum7.com",
        "yr.no",
        "gofundme.com",
        "ixbt.com",
        "starbucks.com",
        "conferenceplus.com",
        "media1first.com",
        "sergey-mavrodi.com",
        "rafflecopter.com",
        "591.com.tw",
        "mangapanda.com",
        "huffingtonpost.fr",
        "tiboo.cn",
        "bancomer.com.mx",
        "handelsblatt.com",
        "hpylgr.com",
        "psu.edu",
        "bancomercantil.com",
        "sport-express.ru",
        "codepen.io",
        "foundationapi.com",
        "ow.ly",
        "vatgia.com",
        "kommersant.ru",
        "srvsinf.com",
        "telderi.ru",
        "mercadolibre.com.co",
        "hsbc.com.hk",
        "t3n.de",
        "magicbricks.com",
        "shopstyle.com",
        "mudah.my",
        "punchng.com",
        "therichest.com",
        "fansshare.com",
        "lepoint.fr",
        "vipzona.info",
        "globaltestmarket.com",
        "jqueryui.com",
        "bcsh.com",
        "mundodeportivo.com",
        "newyorker.com",
        "funnyjunk.com",
        "gongchang.com",
        "a8.net",
        "ecollege.com",
        "newhdplugin.net",
        "befuck.com",
        "elespectador.com",
        "drugs.com",
        "abplive.in",
        "feelcars.com",
        "psychologytoday.com",
        "instaforex.com",
        "strtsrv.com",
        "atpworldtour.com",
        "incruit.com",
        "starwoodhotels.com",
        "zone-telechargement.com",
        "songspk.name",
        "hatenablog.com",
        "enfemenino.com",
        "msnbc.com",
        "freebitco.in",
        "akairan.com",
        "discovery.com",
        "angieslist.com",
        "lesechos.fr",
        "transfermarkt.de",
        "sephora.com",
        "come.in",
        "dailykos.com",
        "deutsche-bank.de",
        "warriorplus.com",
        "awwwards.com",
        "lomadee.com",
        "365jia.cn",
        "lotterypost.com",
        "egrana.com.br",
        "rivals.com",
        "literotica.com",
        "myfreshnet.com",
        "ihg.com",
        "fazenda.gov.br",
        "tomnod.com",
        "filesharefanatic.com",
        "hotukdeals.com",
        "bitsnoop.com",
        "tenpay.com",
        "putlocker.bz",
        "ziddu.com",
        "ntvmsnbc.com",
        "surveyzrewardcenter.com",
        "aliyun.com",
        "media.net",
        "comdirect.de",
        "yoox.com",
        "hotelscombined.com",
        "vgsgaming-ads.com",
        "robokassa.ru",
        "webdesignerdepot.com",
        "rotoworld.com",
        "jmw.com.cn",
        "seloger.com",
        "dsdomination.com",
        "affiliatewindow.com",
        "abs-cbnnews.com",
        "bmo.com",
        "iconarchive.com",
        "funshion.com",
        "admin5.com",
        "playhe.com",
        "bigcommerce.com",
        "yodobashi.com",
        "bigfishgames.com",
        "onlinecreditcenter6.com",
        "homes.co.jp",
        "gameninja.com",
        "ebates.com",
        "banamex.com.mx",
        "google.com.lb",
        "2chblog.jp",
        "entertainment-factory.com",
        "asg.to",
        "walla.co.il",
        "mktmobi.com",
        "opensooq.com",
        "adam4adam.com",
        "expressen.se",
        "elephanttube.com",
        "ingdirect.es",
        "clicrbs.com.br",
        "seriespepito.com",
        "skyscanner.net",
        "shine.com",
        "appround.us",
        "washingtontimes.com",
        "nrk.no",
        "1stwebdesigner.com",
        "gucheng.com",
        "ghanaweb.com",
        "jzip.com",
        "rozetka.com.ua",
        "wiziwig.tv",
        "jobsdb.com",
        "kitco.com",
        "rpp.com.pe",
        "aljaras.com",
        "telecinco.es",
        "storify.com",
        "netease.com",
        "business-standard.com",
        "babble.com",
        "noticias.uol.com.br",
        "alice.it",
        "bizdec.ru",
        "voanews.com",
        "freejobalert.com",
        "origo.hu",
        "list-manage2.com",
        "gavick.com",
        "national-lottery.co.uk",
        "gazzetta.gr",
        "freevideodownloadforpc.com",
        "xmarks.com",
        "wikibooks.org",
        "sexad.net",
        "alc.co.jp",
        "emol.com",
        "careesma.in",
        "cdc.gov",
        "toshiba.com",
        "imgchili.net",
        "rbcroyalbank.com",
        "indowebster.com",
        "zynga.com",
        "telekom.com",
        "jiameng.com",
        "adsmarket.com",
        "utorrent.com",
        "aarp.org",
        "cityadspix.com",
        "ekstrabladet.dk",
        "doc88.com",
        "fetlife.com",
        "fh21.com.cn",
        "cambridge.org",
        "tune.pk",
        "auction.co.kr",
        "patheos.com",
        "search-results.com",
        "lds.org",
        "webrankinfo.com",
        "newsit.gr",
        "techtudo.com.br",
        "moviepilot.com",
        "mercador.ro",
        "nguoiduatin.vn",
        "tripadvisor.it",
        "lurkmore.to",
        "europapress.es",
        "uspto.gov",
        "excelsior.com.mx",
        "myvideo.de",
        "jetblue.com",
        "camfrog.com",
        "blick.ch",
        "batepapo.uol.com.br",
        "manager.co.th",
        "goibibo.com",
        "cornell.edu",
        "apetube.com",
        "nation.com",
        "allmusic.com",
        "naughtyamerica.com",
        "obozrevatel.com",
        "telegrafi.com",
        "neimanmarcus.com",
        "yabancidiziizle1.com",
        "globalewallet.com",
        "beeline.ru",
        "hinkhoj.com",
        "sitemeter.com",
        "almesryoon.com",
        "localmoxie.com",
        "grotal.com",
        "knowyourmeme.com",
        "qiwi.ru",
        "yieldmanager.com",
        "yimg.com",
        "horoscopedays.com",
        "gfy.com",
        "mxtoolbox.com",
        "searchgol.com",
        "inquirer.net",
        "hollywoodlife.com",
        "ebrun.com",
        "shopbop.com",
        "mysmartprice.com",
        "kijiji.it",
        "visual.ly",
        "mop.com",
        "1fichier.com",
        "prlog.org",
        "xjtour.com",
        "shorouknews.com",
        "thegioinet.net",
        "hln.be",
        "enom.com",
        "thaqafnafsak.com",
        "wahuu.com",
        "ganji.com",
        "russianpost.ru",
        "myplaycity.com",
        "dzone.com",
        "dns-shop.ru",
        "aif.ru",
        "ssisurveys.com",
        "uploadboy.com",
        "madpandatv.net",
        "pcauto.com.cn",
        "meinestadt.de",
        "tasnimnews.com",
        "rockettheme.com",
        "imesh.com",
        "home.pl",
        "lindaikeji.blogspot.com",
        "zamunda.net",
        "with2.net",
        "calameo.com",
        "myonlinearcade.com",
        "xcams.com",
        "unicredit.it",
        "clip2net.com",
        "mediatemple.net",
        "nosub.tv",
        "click.in",
        "alluc.to",
        "thestar.com.my",
        "niksalehi.com",
        "lastampa.it",
        "itv.com",
        "hihi2.com",
        "digitalocean.com",
        "tripadvisor.fr",
        "willhaben.at",
        "laodong.com.vn",
        "591hx.com",
        "tineye.com",
        "ptt.cc",
        "beatport.com",
        "infoseek.co.jp",
        "avangate.com",
        "indiaproperty.com",
        "books.com.tw",
        "nj.com",
        "avaaz.org",
        "wikitravel.org",
        "direct.gov.uk",
        "wangtu.com",
        "discover.com",
        "slon.ru",
        "startpage.com",
        "thestar.com",
        "meishichina.com",
        "finanzen.net",
        "estadao.com.br",
        "indeed.co.uk",
        "expansion.com",
        "irpopup.ir",
        "arvixe.com",
        "secureinternetbank.com",
        "csmonitor.com",
        "carwale.com",
        "mtime.com",
        "ceconline.com",
        "abchina.com",
        "cgbchina.com.cn",
        "mediotiempo.com",
        "vic.gov.au",
        "cnbeta.com",
        "alarab.net",
        "vietnamnet.vn",
        "gay.com",
        "watchmygf.net",
        "myanimelist.net",
        "bannersbroker.com",
        "asklaila.com",
        "heureka.cz",
        "grepolis.com",
        "meteofrance.com",
        "bol.com",
        "hasoffers.com",
        "bigrock.in",
        "ibanking-services.com",
        "nos.nl",
        "google.com.gh",
        "beppegrillo.it",
        "nhaccuatui.com",
        "hamariweb.com",
        "wikiquote.org",
        "evite.com",
        "jobdiagnosis.com",
        "17track.net",
        "baixing.com",
        "awempire.com",
        "healthgrades.com",
        "unifiedlayer.com",
        "thisav.com",
        "himado.in",
        "zcool.com.cn",
        "tsn.ca",
        "atlassian.net",
        "binary500.com",
        "alotporn.com",
        "dnaindia.com",
        "sherdog.com",
        "www.nhs.uk",
        "gruposantander.es",
        "quantcast.com",
        "usearchmedia.com",
        "merchantcircle.com",
        "blog.hu",
        "wallstcheatsheet.com",
        "iptorrents.com",
        "apsense.com",
        "redirsvc.com",
        "indiarailinfo.com",
        "mobile.ir",
        "xvideo-jp.com",
        "boxofficemojo.com",
        "scamadviser.com",
        "rotapost.ru",
        "someecards.com",
        "mydealz.de",
        "lvye.cn",
        "videoweed.es",
        "xlovecam.com",
        "pepperjamnetwork.com",
        "khabarpu.com",
        "mathrubhumi.com",
        "online-convert.com",
        "b92.net",
        "tiptopsoft.org",
        "el-balad.com",
        "qihoo.com",
        "iheart.com",
        "campaign-archive1.com",
        "photodune.net",
        "labnol.org",
        "kotobank.jp",
        "medium.com",
        "google.lu",
        "tm1111.com",
        "gigazine.net",
        "mypcbackup.com",
        "instantcheckmate.com",
        "seemorgh.com",
        "topky.sk",
        "puu.sh",
        "aeriagames.com",
        "whatismyip.com",
        "rising.cn",
        "scotiabank.com",
        "wo.com.cn",
        "yootheme.com",
        "channel4.com",
        "heavy-r.com",
        "omgpm.com",
        "milli.az",
        "bnpparibas.net",
        "vmware.com",
        "diretta.it",
        "skycn.com",
        "sap.com",
        "zyalt.livejournal.com",
        "bookryanair.com",
        "kkbox.com",
        "subtitleseeker.com",
        "abckj123.com",
        "mashreghnews.ir",
        "websitewelcome.com",
        "2ch-c.net",
        "health.com",
        "uproxx.com",
        "uast.ac.ir",
        "bol.uol.com.br",
        "feedsportal.com",
        "ip-adress.com",
        "sedty.com",
        "ilsistemabinario.com",
        "nabble.com",
        "hightail.com",
        "superjob.ru",
        "tokyo.jp",
        "hrblock.com",
        "china.cn",
        "tsetmc.com",
        "unfranchise.com.tw",
        "bhg.com",
        "htmlbook.ru",
        "stardoll.com",
        "crictime.com",
        "hsn.com",
        "royalmail.com",
        "globallshare.com",
        "wikiwiki.jp",
        "petardas.com",
        "usembassy.gov",
        "rakuten-bank.co.jp",
        "golem.de",
        "stepstone.de",
        "aucfan.com",
        "stubhub.com",
        "rbcdaily.ru",
        "ro2.biz",
        "huffingtonpost.ca",
        "timeout.com",
        "digitalspy.co.uk",
        "foreningssparbanken.se",
        "autodesk.com",
        "98ia.com",
        "gtbank.com",
        "runetki.com",
        "freshdesk.com",
        "ieee.org",
        "getpocket.com",
        "jutarnji.hr",
        "caisse-epargne.fr",
        "profitcentr.com",
        "51.com",
        "oi.com.br",
        "sina.com.tw",
        "fontspace.com",
        "dynamicdrive.com",
        "maduradas.com",
        "ligtv.com.tr",
        "sport24.gr",
        "stargazete.com",
        "bola.net",
        "template-help.com",
        "codecademy.com",
        "officedepot.com",
        "researchgate.net",
        "17u.com",
        "gfxtra.com",
        "weiphone.com",
        "shoutmeloud.com",
        "hc360.com",
        "lintas.me",
        "mk.ru",
        "wplocker.com",
        "thumbtack.com",
        "szn.cz",
        "yatra.com",
        "societegenerale.fr",
        "wyborcza.pl",
        "demotywatory.pl",
        "thomann.de",
        "imperiaonline.org",
        "magento.com",
        "skillpages.com",
        "cam4ads.com",
        "spiceworks.com",
        "homestead.com",
        "locanto.in",
        "hotelurbano.com",
        "sinaimg.cn",
        "chetxia.com",
        "menshealth.com",
        "ideacellular.com",
        "snopes.com",
        "newgrounds.com",
        "autosottocosto.com",
        "admob.com",
        "linguee.fr",
        "net-a-porter.com",
        "text.ru",
        "sharebeast.com",
        "televisionfanatic.com",
        "netlog.com",
        "lufthansa.com",
        "ngoisao.net",
        "3911.net",
        "worldssl.net",
        "rabobank.nl",
        "lvmama.com",
        "sharethis.com",
        "sambaporno.com",
        "mci.ir",
        "inosmi.ru",
        "joyreactor.cc",
        "cartfill.in",
        "cooltext.com",
        "qz.com",
        "onthe.io",
        "citilink.ru",
        "apartmenttherapy.com",
        "lloydsbank.com",
        "metroer.com",
        "koyotesoft.com",
        "subdivx.com",
        "alriyadh.com",
        "backlinkwatch.com",
        "coindesk.com",
        "porntube1.xxx",
        "zovi.com",
        "thestreet.com",
        "rtbstream.com",
        "etnet.com.hk",
        "creditkarma.com",
        "lifebuzz.com",
        "opodo.co.uk",
        "developpez.net",
        "tinydeal.com",
        "nature.com",
        "oxforddictionaries.com",
        "anchorfree.net",
        "tn.com.ar",
        "findicons.com",
        "joomlart.com",
        "hmrc.gov.uk",
        "btc-e.com",
        "extra.com.br",
        "ad.nl",
        "megafon.ru",
        "qafqazinfo.az",
        "shahvani.com",
        "googlecode.com",
        "milliyet.tv",
        "deadline.com",
        "grindtv.com",
        "logitech.com",
        "nzherald.co.nz",
        "ninisite.com",
        "webgains.com",
        "oschina.net",
        "webmasters.ru",
        "filmix.net",
        "seowhy.com",
        "met-art.com",
        "discart.ru",
        "keywordblocks.com",
        "vodly.to",
        "redvak.com",
        "tomshardware.co.uk",
        "2shared.com",
        "zoznam.sk",
        "icims.com",
        "virtapay.com",
        "blomaga.jp",
        "wasu.cn",
        "carsensor.net",
        "sportsdirect.com",
        "uservoice.com",
        "livescience.com",
        "gamebase.com.tw",
        "persiangig.com",
        "livesmi.com",
        "eharmony.com",
        "banorte.com",
        "radiojavan.com",
        "startv.com.tr",
        "coolmath-games.com",
        "downloadquick.net",
        "worldoftanks.eu",
        "filelist.ro",
        "fontsquirrel.com",
        "superpages.com",
        "yolasite.com",
        "funnie.st",
        "51cto.com",
        "goo-net.com",
        "builtwith.com",
        "shaparak.ir",
        "nuomi.com",
        "omegle.com",
        "poringa.net",
        "lan.com",
        "desi-tashan.com",
        "shabdkosh.com",
        "freedigitalphotos.net",
        "betradar.com",
        "womenshealthmag.com",
        "realsimple.com",
        "maxbounty.com",
        "bbva.es",
        "sweetpacks.com",
        "pinoy-ako.info",
        "jobstreet.com",
        "cafe24.com",
        "goldenbirds.biz",
        "anandtech.com",
        "mapion.co.jp",
        "rawstory.com",
        "streamate.com",
        "celebuzz.com",
        "freepornvs.com",
        "divyabhaskar.co.in",
        "lifehack.org",
        "holidaycheck.de",
        "quizlet.com",
        "zhibo8.cc",
        "askmefast.com",
        "manageflitter.com",
        "campaign-archive2.com",
        "cityheaven.net",
        "uniqlo.com",
        "seoclerks.com",
        "tecmundo.com.br",
        "the-binary-options-guide.com",
        "gigaom.com",
        "mywot.com",
        "playcast.ru",
        "tatadocomo.com",
        "csfd.cz",
        "ganool.com",
        "kaschpo.ru",
        "webdunia.com",
        "philly.com",
        "doctoroz.com",
        "jumei.com",
        "poponclick.com",
        "rueducommerce.fr",
        "fararu.com",
        "po.st",
        "nextag.com",
        "manhunt.net",
        "sistrix.com",
        "woman.ru",
        "appbank.net",
        "iobit.com",
        "joins.com",
        "vidtomp3.com",
        "un.org",
        "volusion.com",
        "lipsum.com",
        "afkarnews.ir",
        "goldenline.pl",
        "clickansave.net",
        "softgozar.com",
        "thefind.com",
        "mozzi.com",
        "wenxuecity.com",
        "up2c.com",
        "searchfunmoods.com",
        "cabelas.com",
        "coffetube.com",
        "otto.de",
        "webalta.ru",
        "tataindicom.com",
        "ctvnews.ca",
        "inlinkz.com",
        "kajabi.com",
        "greatergood.com",
        "whmcs.com",
        "telekom.de",
        "christianpost.com",
        "fiducia.de",
        "bancsabadell.com",
        "pirateproxy.net",
        "woobox.com",
        "google.cm",
        "noulinx.com",
        "nick.com",
        "moviehuts.com",
        "mvideo.ru",
        "couchtuner.eu",
        "wyborcza.biz",
        "tradeindia.com",
        "girlsgogames.com",
        "healthcare.gov",
        "videolan.org",
        "sky.it",
        "tuniu.com",
        "ime.nu",
        "n4g.com",
        "cyberforum.ru",
        "justin.tv",
        "createspace.com",
        "joemonster.org",
        "registro.br",
        "elkhabar.com",
        "open24news.tv",
        "irr.ru",
        "sanjesh.org",
        "standardbank.co.za",
        "neogaf.com",
        "doyo.cn",
        "am15.net",
        "ana.co.jp",
        "amd.com",
        "gidonlinekino.com",
        "sitetalk.com",
        "nesn.com",
        "arabseed.com",
        "ingbank.pl",
        "webpronews.com",
        "saavn.com",
        "yourdictionary.com",
        "mobile9.com",
        "jagranjosh.com",
        "www.net.cn",
        "computerbase.de",
        "3djuegos.com",
        "htc.com",
        "the-binary-theorem.com",
        "google.com.np",
        "n11.com",
        "vivastreet.com",
        "mthai.com",
        "seomastering.com",
        "mercadolibre.cl",
        "searchmetrics.com",
        "mentalfloss.com",
        "russia.tv",
        "ubi.com",
        "dwnews.com",
        "ecplaza.net",
        "trafficfactory.biz",
        "loopnet.com",
        "refinery29.com",
        "minecraftforum.net",
        "moviefone.com",
        "bom.gov.au",
        "google.com.bh",
        "eltiempo.es",
        "cuantarazon.com",
        "2258.com",
        "google.ee",
        "nwolb.com",
        "bezaat.com",
        "eelly.com",
        "icmwebserv.com",
        "techsmith.com",
        "timeweb.ru",
        "johnlewis.com",
        "independent.ie",
        "bankia.es",
        "dkb.de",
        "gilt.com",
        "duolingo.com",
        "3file.info",
        "cam4.de.com",
        "pcanalysis.net",
        "br.de",
        "vodlocker.com",
        "adfoc.us",
        "ymlp.com",
        "dailyfx.com",
        "business2community.com",
        "banki.ru",
        "yell.com",
        "smartresponder.ru",
        "yaske.to",
        "bokra.net",
        "mercadolibre.com",
        "viewster.com",
        "recipesfinder.com",
        "rei.com",
        "dogpile.com",
        "caf.fr",
        "sbrf.ru",
        "soha.vn",
        "voila.fr",
        "rp-online.de",
        "members.webs.com",
        "duvamis.com",
        "nazwa.pl",
        "google.com.ni",
        "ilovemobi.com",
        "retrogamer.com",
        "blogtalkradio.com",
        "utexas.edu",
        "sonyentertainmentnetwork.com",
        "dr.dk",
        "jjwxc.net",
        "service-public.fr",
        "care2.com",
        "musavat.com",
        "h12-media.com",
        "smartfren.com",
        "immowelt.de",
        "discuz.net",
        "m1905.com",
        "cas.sk",
        "bitcoinwisdom.com",
        "monografias.com",
        "mindbodygreen.com",
        "getfirebug.com",
        "godlikeproductions.com",
        "mydrivers.com",
        "voc.com.cn",
        "truecaller.com",
        "livemook.com",
        "i8ti.com",
        "agame.com",
        "kurir-info.rs",
        "urbanoutfitters.com",
        "shopping.uol.com.br",
        "2ip.ru",
        "91.com",
        "banquepopulaire.fr",
        "rappler.com",
        "mint.com",
        "jz123.cn",
        "zurb.com",
        "sport.cz",
        "justunfollow.com",
        "billionuploads.com",
        "thaivisa.com",
        "seitwert.de",
        "ciudad.com.ar",
        "archdaily.com",
        "jalopnik.com",
        "1news.az",
        "dailyfinance.com",
        "okitspace.com",
        "dn.se",
        "el-nacional.com",
        "larousse.fr",
        "mojo-themes.com",
        "draugiem.lv",
        "teamtreehouse.com",
        "xiu.com",
        "ennaharonline.com",
        "oricon.co.jp",
        "openoffice.org",
        "tny.cz",
        "forumfree.it",
        "youthwant.com.tw",
        "khamsat.com",
        "vitacost.com",
        "alrakoba.net",
        "marmiton.org",
        "yebhi.com",
        "the-binary-trader.biz",
        "dominos.com",
        "dice.com",
        "like4like.org",
        "tvmuse.com",
        "standardchartered.com",
        "bitbucket.org",
        "driveropti.net",
        "google.hn",
        "indiblogger.in",
        "torrenthound.com",
        "wolframalpha.com",
        "experienceproject.com",
        "nsw.gov.au",
        "olx.pt",
        "sciencedaily.com",
        "viglink.com",
        "plala.or.jp",
        "sxsw.com",
        "mileroticos.com",
        "namejet.com",
        "1hai.cn",
        "skroutz.gr",
        "bilibili.tv",
        "travelzoo.com",
        "saksfifthavenue.com",
        "get-a-fuck-tonight.com",
        "barclaycardus.com",
        "withgoogle.com",
        "whitehouse.gov",
        "oprah.com",
        "fishwrapper.com",
        "softbank.jp",
        "slutload.com",
        "latercera.cl",
        "100bestbuy.com",
        "nur.kz",
        "topit.me",
        "computerhope.com",
        "snob.ru",
        "rackcdn.com",
        "3158.cn",
        "artlebedev.ru",
        "yobt.com",
        "rai.it",
        "hs.fi",
        "tinhte.vn",
        "fotocasa.es",
        "nyu.edu",
        "dawn.com",
        "series.ly",
        "movshare.net",
        "fineartamerica.com",
        "westernunion.com",
        "leaseweb.com",
        "wayn.com",
        "ivi.ru",
        "bloomingdales.com",
        "pons.com",
        "rapidtrk.com",
        "bama.ir",
        "hackforums.net",
        "dfiles.eu",
        "intercambiosvirtuales.org",
        "sdo.com",
        "homes.com",
        "colissimo.fr",
        "discuss.com.hk",
        "afreeca.com",
        "rbc.ua",
        "novamov.com",
        "jungle.gr",
        "iol.co.za",
        "btcclicks.com",
        "mapsofindia.com",
        "propellerads.com",
        "fab.com",
        "princeton.edu",
        "reliancebroadband.co.in",
        "xdf.cn",
        "mako.co.il",
        "protothema.gr",
        "booloo.com",
        "livrariasaraiva.com.br",
        "efukt.com",
        "acrobat.com",
        "globovision.com",
        "xero.com",
        "sevenforums.com",
        "semalt.com",
        "audiojungle.net",
        "e1.ru",
        "quoka.de",
        "chinaiiss.com",
        "gonzoxxxmovies.com",
        "wallpaperswide.com",
        "fapvid.com",
        "trk4.com",
        "forosdelweb.com",
        "fark.com",
        "my.tv.sohu.com/user/video",
        "kaixin001.com",
        "ntvspor.net",
        "mobafire.com",
        "zigwheels.com",
        "filmifullizle.com",
        "8tracks.com",
        "readmanga.eu",
        "lelong.com.my",
        "planetromeo.com",
        "192.com",
        "republika.co.id",
        "in.gr",
        "televisao.uol.com.br",
        "kalerkantho.com",
        "usairways.com",
        "malaysiakini.com",
        "anonymouse.org",
        "xxxhost.me",
        "stuff.co.nz",
        "dek-d.com",
        "bbvanet.com.mx",
        "watchseries-online.eu",
        "malaysiaairlines.com",
        "policymic.com",
        "serviporno.com",
        "aprod.hu",
        "gelocal.it",
        "tradetracker.com",
        "cibc.com",
        "umich.edu",
        "smartshe.com",
        "sony.jp",
        "taobaocdn.com",
        "bestgfx.biz",
        "irib.ir",
        "aliimg.com",
        "esuteru.com",
        "healthline.com",
        "cnnamador.com",
        "sat.gob.mx",
        "childsafedownloadx.asia",
        "playmillion.com",
        "strawberrynet.com",
        "alnilin.com",
        "trustedreviews.com",
        "21cn.com",
        "persianv.com",
        "baomoi.com",
        "firestorage.jp",
        "google.co.ke",
        "admaimai.com",
        "sbnlife.com",
        "surveyrouter.com",
        "megaindex.ru",
        "intodns.com",
        "yiqifa.com",
        "mixcloud.com",
        "softonic.fr",
        "bakecaincontrii.com",
        "payu.in",
        "rakuten-card.co.jp",
        "almaany.com",
        "grantland.com",
        "ricardo.ch",
        "heavy.com",
        "niusnews.com",
        "canstockphoto.com",
        "acunn.com",
        "diythemes.com",
        "canalrcnmsn.com",
        "ngs.ru",
        "rassd.com",
        "groupon.co.in",
        "depositfiles.org",
        "mango.com",
        "theregister.co.uk",
        "worldfree4u.com",
        "f-lite.ru",
        "boingboing.net",
        "bangbros.com",
        "neteller.com",
        "tonicmovies.com",
        "p2up.ir",
        "cartoonnetwork.com",
        "lun.com",
        "nk.pl",
        "webry.info",
        "burningcamel.com",
        "mplife.com",
        "nationalreview.com",
        "williamhill.es",
        "sssc.cn",
        "col3negoriginal.lk",
        "yoast.com",
        "svyaznoy.ru",
        "chengdu.cn",
        "listverse.com",
        "lastminute.com",
        "guardianlv.com",
        "39yst.com",
        "bahseazad.ir",
        "debian.org",
        "tokyo-porn-tube.com",
        "ilbe.com",
        "upsocl.com",
        "balatarin.com",
        "charter97.org",
        "wpexplorer.com",
        "immi.gov.au",
        "yokamen.cn",
        "esmas.com",
        "hbr.org",
        "livechatinc.com",
        "crazyegg.com",
        "palcomp3.com",
        "calottery.com",
        "wistia.com",
        "locaweb.com.br",
        "techspot.com",
        "bit.ly",
        "yammer.com",
        "uscis.gov",
        "bramjnet.com",
        "linio.com.mx",
        "tharunaya.co.uk",
        "desirulez.net",
        "madmimi.com",
        "everydayhealth.com",
        "secondlife.com",
        "ceskatelevize.cz",
        "enter.ru",
        "glopart.ru",
        "woso.cn",
        "pitlap.info",
        "worldoftanks.com",
        "videarn.com",
        "dafiti.com.br",
        "segundamano.mx",
        "eamroomsnacks.com",
        "vulture.com",
        "humblebundle.com",
        "rockstargames.com",
        "wsodownloads.info",
        "yazete.com",
        "pcadvisor.co.uk",
        "07073.com",
        "modcloth.com",
        "attracta.com",
        "iol.pt",
        "travideos.com",
        "sparkpeople.com",
        "rankingsandreviews.com",
        "entekhab.ir",
        "goarticles.com",
        "wonderhowto.com",
        "kankanews.com",
        "rzb.ir",
        "p30download.com",
        "infojobs.it",
        "socialspark.com",
        "picstopin.com",
        "celebritynetworth.com",
        "tweakers.net",
        "gi-backoffice.com",
        "isbank.com.tr",
        "qiyou.com",
        "templatic.com",
        "cyberpresse.ca",
        "consumerreports.org",
        "focalprice.com",
        "linkpad.ru",
        "svd.se",
        "desitvforum.net",
        "bulbagarden.net",
        "showup.tv",
        "webgozar.com",
        "3dnews.ru",
        "spyfu.com",
        "bikhir.ma",
        "trovaprezzi.it",
        "autov.com.cn",
        "podnapisi.net",
        "tocmai.ro",
        "realitatea.net",
        "geico.com",
        "joydownload.com",
        "kddi.com",
        "unbounce.com",
        "meb.gov.tr",
        "anchorfree.us",
        "gumtree.pl",
        "dbs.com",
        "ebayimg.com",
        "ptcsolution.com",
        "clip.dj",
        "samplicio.us",
        "47news.jp",
        "todo1.com",
        "anspress.com",
        "24sata.hr",
        "cineblog01.tv",
        "sport-fm.gr",
        "unetenet.com",
        "tenki.jp",
        "jia.com",
        "filefactory.com",
        "onedio.com",
        "gendai.net",
        "nickjr.com",
        "finviz.com",
        "bytes.com",
        "inkthemes.com",
        "oriflame.com",
        "aporrea.org",
        "mazika2day.com",
        "baimao.com",
        "logme.in",
        "downloadactivate.com",
        "vista.ir",
        "duowan.com",
        "sinaapp.com",
        "proceso.com.mx",
        "xxxconnect.com",
        "dvdvideosoft.com",
        "nomorerack.com",
        "almubasher.com.sa",
        "afisha.ru",
        "clicksure.com",
        "11st.co.kr",
        "turkishairlines.com",
        "freekaamaal.com",
        "findwide.com",
        "sbisec.co.jp",
        "mythemeshop.com",
        "webnode.com",
        "cumhuriyet.com.tr",
        "morningstar.com",
        "trafficshop.com",
        "gopro.com",
        "jeevansathi.com",
        "dasoertliche.de",
        "markets.com",
        "absa.co.za",
        "ikman.lk",
        "fmworld.net",
        "hyatt.com",
        "virgin-atlantic.com",
        "tfl.gov.uk",
        "immonet.de",
        "haodf.com",
        "thewrap.com",
        "appgame.com",
        "hdwallpapers.in",
        "canon.com",
        "newsle.com",
        "jorudan.co.jp",
        "pcwelt.de",
        "coinbase.com",
        "yourgirlfriends.com",
        "djmaza.info",
        "findagrave.com",
        "lainformacion.com",
        "teacup.com",
        "ezilon.com",
        "redbubble.com",
        "guru.com",
        "brothersoft.com",
        "coinmarketcap.com",
        "mediabistro.com",
        "elfagr.org",
        "glavcom.ua",
        "jino.ru",
        "1e100.net",
        "g9g.com",
        "join.me",
        "ynet.com",
        "news247.gr",
        "rcom.co.in",
        "baby.ru",
        "argentglobalnetwork.com",
        "hsselite.com",
        "foxbusiness.com",
        "cookmates.com",
        "lidl.de",
        "timesofindia.com",
        "fakt.pl",
        "bgr.com",
        "ghatreh.com",
        "woxikon.de",
        "pontofrio.com.br",
        "gizmag.com",
        "signup.wordpress.com",
        "tre.it",
        "gardenweb.com",
        "alfalfalfa.com",
        "prcm.jp",
        "freemail.hu",
        "iteye.com",
        "katproxy.com",
        "kickassunblock.info",
        "wisegeek.com",
        "zaobao.com",
        "vpsdomain4.eu",
        "naij.com",
        "olx.co.za",
        "mihanstore.org",
        "gezinti.com",
        "vistaprint.in",
        "dastelefonbuch.de",
        "blackhatteam.com",
        "yummly.com",
        "minecraft.net",
        "justcloud.com",
        "biblehub.com",
        "argentinawarez.com",
        "gandul.info",
        "trialpay.com",
        "paruvendu.fr",
        "khanacademy.org",
        "topsy.com",
        "angelfire.com",
        "nseindia.com",
        "seositecheckup.com",
        "hostelworld.com",
        "zalukaj.tv",
        "animeflv.net",
        "laptopmag.com",
        "tripadvisor.de",
        "sec.gov",
        "tripadvisor.es",
        "oreilly.com",
        "kanald.com.tr",
        "halifax-online.co.uk",
        "extremetracking.com",
        "reimageplus.com",
        "jal.co.jp",
        "vuiviet.net",
        "yeslibertin.com",
        "pichunter.com",
        "empowernetwork.com/aI3zkH7s3g6tZH8TDmh8LA==",
        "reforma.com",
        "singlessalad.com",
        "upenn.edu",
        "1ting.com",
        "hsbc.com.mx",
        "sulia.com",
        "yepporn.com",
        "scrubtheweb.com",
        "e-autopay.com",
        "rechargeitnow.com",
        "ppomppu.co.kr",
        "zemtv.com",
        "gofeminin.de",
        "peoplestylewatch.com",
        "france24.com",
        "comodo.com",
        "openmace.net",
        "maultalk.com",
        "fancy.com",
        "vodafone.it",
        "pokerstrategy.com",
        "crunchyroll.com",
        "aipai.com",
        "3dcartstores.com",
        "leancy.com",
        "myblogguest.com",
        "papajohns.com",
        "tuolar.com",
        "junkmail.co.za",
        "nyc.gov",
        "rentalcars.com",
        "sovsport.ru",
        "marketo.com",
        "smbc.co.jp",
        "yale.edu",
        "pitchfork.com",
        "thetoptens.com",
        "joyme.com",
        "linuxquestions.org",
        "htmlgoodies.com",
        "laredoute.fr",
        "0427d7.se",
        "journaldesfemmes.com",
        "xici.net",
        "alwafd.org",
        "daniweb.com",
        "mtgox.com",
        "jetstar.com",
        "plotek.pl",
        "jobvite.com",
        "adage.com",
        "aukro.cz",
        "ford.com",
        "problogger.net",
        "518.com.tw",
        "blogbigtime.com",
        "nieuwsblad.be",
        "register.com",
        "24tv.ua",
        "aftenposten.no",
        "weightwatchers.com",
        "smartpassiveincome.com",
        "radiosvoboda.org",
        "web.com",
        "caixin.com",
        "digitalmarketer.com",
        "soup.io",
        "soft98.ir",
        "muzofon.com",
        "gao7.com",
        "freefilmshd.com",
        "hsbc.com",
        "xhamsterhq.com",
        "my.tv.sohu.com/user/reg",
        "trade65.com",
        "chow.com",
        "google.com.kh",
        "inps.it",
        "seesaa.jp",
        "hoovers.com",
        "peru21.pe",
        "sdpnoticias.com",
        "schema.org",
        "linode.com",
        "theknot.com",
        "blesk.cz",
        "google.ci",
        "loltrk.com",
        "vod.pl",
        "geenstijl.nl",
        "moneymakergroup.com",
        "tupaki.com",
        "huvrtech.com",
        "metafilter.com",
        "jumia.com.ng",
        "newsvine.com",
        "mylant.com",
        "accenture.com",
        "feedjit.com",
        "twipple.jp",
        "getgoodlinks.ru",
        "radiofarda.com",
        "informador.com.mx",
        "wisc.edu",
        "windows.net",
        "zamzar.com",
        "nationalpost.com",
        "epnet.com",
        "naaptol.com",
        "x-art.com",
        "ebookbrowsee.net",
        "marketingland.com",
        "thedailyshow.com",
        "s-oman.net",
        "theme-fusion.com",
        "immobiliare.it",
        "allvoices.com",
        "adroll.com",
        "francetvinfo.fr",
        "callandput.com",
        "entireweb.com",
        "instructure.com",
        "megacinema.fr",
        "djelfa.info",
        "flightaware.com",
        "magazineluiza.com.br",
        "ighome.com",
        "mature-beauty.com",
        "yuku.com",
        "peerfly.com",
        "hardware.fr",
        "dcinside.com",
        "telerik.com",
        "pengpeng.com",
        "gazetaexpress.com",
        "publico.es",
        "nwsource.com",
        "oneandone.co.uk",
        "qoo10.sg",
        "aboutus.org",
        "adsupplyads.com",
        "wa.gov",
        "google.co.cr",
        "benchmarkemail.com",
        "valuedealshopper.com",
        "hola.com",
        "mizuhobank.co.jp",
        "zzstream.li",
        "kriesi.at",
        "exist.ru",
        "nvidia.com",
        "giallozafferano.it",
        "jusbrasil.com.br",
        "konga.com",
        "avclub.com",
        "reed.co.uk",
        "advertig.com",
        "ripoffreport.com",
        "gooddrama.net",
        "pornyaz.com",
        "budsgunshop.com",
        "78.cn",
        "livesurf.ru",
        "99114.com",
        "pornorama.com",
        "marksandspencer.com",
        "vmall.com",
        "fatcow.com",
        "mylife.com",
        "irishtimes.com",
        "medicalnewstoday.com",
        "uiuc.edu",
        "groupon.it",
        "washington.edu",
        "addictinggames.com",
        "anonymz.com",
        "kindgirls.com",
        "jne.co.id",
        "guiamais.com.br",
        "lyricsfreak.com",
        "uloz.to",
        "tagesanzeiger.ch",
        "fashionandyou.com",
        "bollywoodhungama.com",
        "nationwide.co.uk",
        "kboing.com.br",
        "python.org",
        "theladbible.com",
        "eurosport.com",
        "webinarjam.com",
        "theme.wordpress.com",
        "myfxbook.com",
        "allwomenstalk.com",
        "ucla.edu",
        "opendns.com",
        "pornbb.org",
        "money.pl",
        "domain.com.au",
        "standaard.be",
        "wanelo.com",
        "express.co.uk",
        "exam8.com",
        "zum.com",
        "amtrak.com",
        "boots.com",
        "800notes.com",
        "fabfurnish.com",
        "amoureux.com",
        "ebizmba.com",
        "ujian.cc",
        "stargames.at",
        "panasonic.com",
        "ge.tt",
        "scout.com",
        "tiexue.net",
        "nanapi.jp",
        "eclipse.org",
        "searchquotes.com",
        "wetplace.com",
        "lpcloudbox300.com",
        "hollyscoop.com",
        "bdjobs.com",
        "larepublica.pe",
        "hizliresim.com",
        "yepme.com",
        "bitcoincharts.com",
        "bsnl.co.in",
        "ucwan87.net",
        "tianji.com",
        "hgtv.com",
        "cleanfiles.net",
        "moonsy.com",
        "tomsguide.com",
        "datpiff.com",
        "net.hr",
        "orange.pl",
        "bankrate.com.cn",
        "mafiashare.net",
        "giaoduc.net.vn",
        "sucuri.net",
        "ringcentral.com",
        "gamingwonderland.com",
        "freenet.de",
        "cian.ru",
        "gayboystube.com",
        "gog.com",
        "gruenderszene.de",
        "econsultancy.com",
        "aktuality.sk",
        "webrankstats.com",
        "j-cast.com",
        "popsugar.com",
        "mr-guangdong.com",
        "on.cc",
        "jb51.net",
        "lamoda.ru",
        "sprashivai.ru",
        "animoto.com",
        "winzip.com",
        "vanityfair.com",
        "svt.se",
        "noyapps.com",
        "mnn.com",
        "lancenet.com.br",
        "e-monsite.com",
        "gazeta.ua",
        "cari.com.my",
        "coub.com",
        "veoh.com",
        "kienthuc.net.vn",
        "eldorado.ru",
        "overclock.net",
        "meetic.fr",
        "tam.com.br",
        "alfemminile.com",
        "telmex.com",
        "newsbomb.gr",
        "funda.nl",
        "netcoc.com",
        "bhinneka.com",
        "layalina.com",
        "clubpenguin.com",
        "talktalk.co.uk",
        "dumpert.nl",
        "almastba.com",
        "clker.com",
        "adweek.com",
        "gigya.com",
        "disponivel.uol.com.br",
        "tomoson.com",
        "w.org",
        "rfi.fr",
        "imgbox.com",
        "omniture.com",
        "n24.de",
        "webdesignrazzi.com",
        "medscape.com",
        "playboy.com",
        "usda.gov",
        "cuevana.tv",
        "trenitalia.com",
        "explosm.net",
        "mail.uol.com.br",
        "delfi.lv",
        "elektroda.pl",
        "hulkshare.com",
        "kotak.com",
        "gi-akademie.ning.com",
        "yelp.de",
        "lrytas.lt",
        "couchsurfing.org",
        "drugstore.com",
        "ssa.gov",
        "seriescoco.com",
        "iran-tejarat.com",
        "hafiz.gov.sa",
        "intellicast.com",
        "sub.jp",
        "paginasamarillas.es",
        "anime44.com",
        "babyschool.com.cn",
        "advertisernets.com",
        "vpsdomain2.eu",
        "arcor.de",
        "video2mp3.net",
        "marthastewart.com",
        "hawahome.com",
        "articlesbase.com",
        "spanishdict.com",
        "meilishuo.com",
        "grammarly.com",
        "sportlemon.tv",
        "zend.com",
        "bigideamastermind.com",
        "hawaaworld.com",
        "pagseguro.uol.com.br",
        "keywordspy.com",
        "7search.com",
        "cnki.net",
        "aamaadmiparty.org",
        "javaplayer.info",
        "sidereel.com",
        "azcentral.com",
        "passportindia.gov.in",
        "memurlar.net",
        "bouyguestelecom.fr",
        "buenastareas.com",
        "ernmoneynow.com",
        "eurosport.ru",
        "blog.163.com",
        "pizzahut.com",
        "bossip.com",
        "webdeveloper.com",
        "add-anime.net",
        "pimptubed.com",
        "movistar.es",
        "megashare.sh",
        "empireavenue.com",
        "btemplates.com",
        "amkspor.com",
        "payza.com",
        "farfesh.com",
        "mcgraw-hill.com",
        "motor-talk.de",
        "purepeople.com",
        "i-gamer.net",
        "sotmarket.ru",
        "anthropologie.com",
        "google.org",
        "rai.tv",
        "wikidot.com",
        "canoe.ca",
        "orange.es",
        "umn.edu",
        "emag.ro",
        "webutations.org",
        "ykb.com",
        "canadapost.ca",
        "zhubajie.com",
        "nextcar.cn",
        "next.co.uk",
        "freemovie-hd.com",
        "telegraf.com.ua",
        "ajc.com",
        "xsrv.jp",
        "vanguard.com",
        "mybroadband.co.za",
        "999120.net",
        "panet.co.il",
        "bellemaison.jp",
        "fonearena.com",
        "playvid.com",
        "purdue.edu",
        "thesuperficial.com",
        "114so.cn",
        "irna.ir",
        "websitetonight.com",
        "edublogs.org",
        "provincial.com",
        "jahaniha.com",
        "heroturko.me",
        "dynadot.com",
        "txtsrving.info",
        "adclickxpress.com",
        "sammobile.com",
        "ebay.at",
        "yaplog.jp",
        "imtranslator.net",
        "fotor.com",
        "myvidster.com",
        "williamhill.it",
        "argaam.com",
        "zoomby.ru",
        "tcsbank.ru",
        "origin.com",
        "vov.vn",
        "wrapbootstrap.com",
        "imvu.com",
        "fbsbx.com",
        "elcorteingles.es",
        "cerdas.com",
        "google.com.om",
        "dramasonline.com",
        "businesswire.com",
        "serpbook.com",
        "santanderrio.com.ar",
        "meta.ua",
        "kenhgioitre.com",
        "watchcartoononline.com",
        "athome.co.jp",
        "2checkout.com",
        "moheet.com",
        "jeu.info",
        "ankieta-online.pl",
        "triberr.com",
        "wordtracker.com",
        "blogher.com",
        "colourlovers.com",
        "maalaimalar.com",
        "bakeca.it",
        "thepostgame.com",
        "beget.ru",
        "abebooks.com",
        "certified-toolbar.com",
        "publico.pt",
        "footmercato.net",
        "indiabix.com",
        "zakzak.co.jp",
        "hotfile.com",
        "virustotal.com",
        "usgs.gov",
        "tukif.com",
        "banglamail24.com",
        "graphicstock.com",
        "svpressa.ru",
        "sanalpazar.com",
        "logsoku.com",
        "loteriasyapuestas.es",
        "youjizzlive.com",
        "all-inkl.com",
        "arcot.com",
        "blogspot.fi",
        "inbox.lv",
        "anno-online.com",
        "tikona.in",
        "newsru.ua",
        "centerblog.net",
        "jahannews.com",
        "joxi.ru",
        "proxybay.eu",
        "2gis.ru",
        "indeed.fr",
        "novayagazeta.ru",
        "intelius.com",
        "hosteurope.de",
        "autoscout24.it",
        "postjoint.com",
        "pulsk.com",
        "biobiochile.cl",
        "homevv.com",
        "zapbux.com",
        "gsp.ro",
        "priyo.com",
        "jamnews.ir",
        "addtoany.com",
        "lookbook.nu",
        "e-travel.com",
        "themelock.com",
        "bestsocialfeed.com",
        "eqla3.com",
        "klm.com",
        "realtor.ca",
        "tv2.no",
        "jqueryrain.com",
        "seo-fast.ru",
        "academic.ru",
        "clicksia.com",
        "lpcloudbox30.com",
        "worldpay.com",
        "gogoanime.com",
        "photoshelter.com",
        "mlive.com",
        "wetteronline.de",
        "jkforum.net",
        "secure.ipage.com",
        "antena3.com",
        "elsevier.com",
        "thaiseoboard.com",
        "addic7ed.com",
        "rookee.ru",
        "jstor.org",
        "rajanews.com",
        "uline.com",
        "o2online.de",
        "fbdownloader.com",
        "wetpaint.com",
        "nnm.me",
        "50onred.com",
        "tvtropes.org",
        "philips.com",
        "watchseries.to",
        "perfectinter.net",
        "progressive.com",
        "stcn.com",
        "golsearch.com",
        "sarayanews.com",
        "screenrant.com",
        "macworld.com",
        "classifiedads.com",
        "ip138.com",
        "izlesene.com",
        "ovguide.com",
        "gametop.com",
        "urlm.co",
        "isitdownrightnow.com",
        "redhat.com",
        "stafaband.info",
        "biglion.ru",
        "twitterfeed.com",
        "ttnet.com.tr",
        "panasonic.jp",
        "loc.gov",
        "telstra.com.au",
        "jiathis.com",
        "perfil.com.ar",
        "inquisitr.com",
        "ratp.fr",
        "libertaddigital.com",
        "bni.co.id",
        "ycombinator.com",
        "paginegialle.it",
        "momoshop.com.tw",
        "theweek.com",
        "tuoitre.vn",
        "scriptmafia.org",
        "megavod.fr",
        "indiavisiontv.com",
        "history.com",
        "flyeralarm.com",
        "salespider.com",
        "ard.de",
        "dslreports.com",
        "tokyo-tube.com",
        "brazzersnetwork.com",
        "bonanza.com",
        "storenvy.com",
        "37signals.com",
        "jxnews.com.cn",
        "1sale.com",
        "allanalpass.com",
        "yiiframework.com",
        "kimsufi.com",
        "nastygal.com",
        "immoral.jp",
        "icq.com",
        "loxblog.com",
        "jcrew.com",
        "diamond.jp",
        "nissen.co.jp",
        "fxstreet.com",
        "15min.lt",
        "lifo.gr",
        "alef.ir",
        "iis.net",
        "giphy.com",
        "mypopup.ir",
        "bsnl.in",
        "distractify.com",
        "foro20.com",
        "chachaba.com",
        "fx-trend.com",
        "imanhua.com",
        "playxn.com",
        "gocomics.com",
        "lcl.fr",
        "hsw.cn",
        "ellislab.com",
        "persiantools.com",
        "coupondunia.in",
        "fengniao.com",
        "coinmill.com",
        "freelancer.in",
        "blogdetik.com",
        "data.com",
        "trafficjunky.net",
        "neverblue.com",
        "flvto.com",
        "lijit.com",
        "zaycev.net",
        "salamnews.org",
        "siliconrus.com",
        "dv37.com",
        "conrad.de",
        "ascii.jp",
        "yesfreeporn.com",
        "globalpost.com",
        "d4000.com",
        "dobreprogramy.pl",
        "hammihan.com",
        "wjunction.com",
        "liverpoolfc.tv",
        "nordea.fi",
        "mail2web.com",
        "songkick.com",
        "comicbookresources.com",
        "jwplayer.com",
        "moi.gov.sa",
        "iranecar.com",
        "kayako.com",
        "listal.com",
        "technet.com",
        "infonews.com",
        "fun698.com",
        "frys.com",
        "vectorstock.com",
        "vbox7.com",
        "leroymerlin.fr",
        "gpotato.eu",
        "gulfnews.com",
        "hot-sex-tube.com",
        "buzzle.com",
        "uludagsozluk.com",
        "onlinefastpaydayloan.com",
        "forumcommunity.net",
        "potins.net",
        "bwin.es",
        "lobstertube.com",
        "katestube.com",
        "endomondo.com",
        "navalny.livejournal.com",
        "wayport.net",
        "dealspl.us",
        "pixhost.org",
        "webopedia.com",
        "flagcounter.com",
        "hotnewhiphop.com",
        "matomy.com",
        "privat24.ua",
        "fuq.com",
        "readserver.net",
        "haiwainet.cn",
        "light-dark.net",
        "decolar.com",
        "tlbb8.com",
        "tomtom.com",
        "fontanka.ru",
        "tchibo.de",
        "slutfinder.com",
        "rbc.cn",
        "pepperfry.com",
        "freshersworld.com",
        "mob.org",
        "brobible.com",
        "phim3s.net",
        "parsiblog.com",
        "link-assistant.com",
        "smotri.com",
        "flyertalk.com",
        "iefimerida.gr",
        "pornyeah.com",
        "trustpilot.com",
        "wowslider.com",
        "sekindo.com",
        "shape.com",
        "pizap.com",
        "bluedart.com",
        "cmu.edu",
        "shueisha.co.jp",
        "royal-search.com",
        "123greetings.com",
        "albawabhnews.com",
        "holiday-weather.com",
        "4travel.jp",
        "lpcloudsvr203.com",
        "panorama.com.ve",
        "htcmania.com",
        "skorer.tv",
        "mymovies.it",
        "fileice.net",
        "1and1.fr",
        "legiaodosherois.com.br",
        "tomsguide.fr",
        "baymirror.com",
        "thesun.co.uk",
        "huffingtonpost.es",
        "61baobao.com",
        "juegos.com",
        "joyclub.de",
        "qatarairways.com",
        "ayosdito.ph",
        "translate.ru",
        "yithemes.com",
        "buyvip.com",
        "pearltrees.com",
        "thinkprogress.org",
        "twitcasting.tv",
        "lusongsong.com",
        "irecommend.ru",
        "aukro.ua",
        "eldiario.es",
        "pop-music.ir",
        "libertytimes.com.tw",
        "themalaysianinsider.com",
        "paddypower.it",
        "delfi.ee",
        "appthemes.com",
        "tdameritrade.com",
        "flashback.org",
        "tubelib.com",
        "claro.com.br",
        "jotform.com",
        "bigresource.com",
        "libsyn.com",
        "sendgrid.com",
        "silikonvadisi.tv",
        "geo.tv",
        "pricegrabber.com",
        "futhead.com",
        "testberichte.de",
        "skybet.com",
        "wpcentral.com",
        "lesnumeriques.com",
        "clientoo.com",
        "mathsisfun.com",
        "expert.ru",
        "maxptp.com",
        "mediaite.com",
        "regions.com",
        "fast-torrent.ru",
        "enlacespepito.com",
        "redtram.com",
        "benesse.ne.jp",
        "jappy.de",
        "wizzair.com",
        "adevarul.ro",
        "mhlw.go.jp",
        "dev-point.com",
        "ibtimes.co.in",
        "coinwarz.com",
        "slidesharecdn.com",
        "classmates.com",
        "tsite.jp",
        "niazerooz.com",
        "jma.go.jp",
        "motherjones.com",
        "easports.com",
        "elbotola.com",
        "tripadvisor.com.au",
        "rozee.pk",
        "vivanuncios.com.mx",
        "lashou.com",
        "theaustralian.com.au",
        "superstarmagazine.com",
        "zedge.net",
        "hardwarezone.com.sg",
        "yyets.com",
        "nowgamez.com",
        "blogspot.ch",
        "gq.com",
        "adidas.com",
        "uyan.cc",
        "dailydot.com",
        "xenforo.com",
        "ilmessaggero.it",
        "state.nj.us",
        "16888.com",
        "searchengines.guru",
        "nascar.com",
        "dnb.no",
        "smosh.com",
        "shinyinnovation.com",
        "who.int",
        "mybet.com",
        "yoo7.com",
        "xrea.com",
        "fotolog.net",
        "smartprix.com",
        "esquire.com",
        "google.com.cy",
        "santander.com.br",
        "realclearpolitics.com",
        "financereports24.com",
        "onlinesoccermanager.com",
        "noticiaaldia.com",
        "kelkoo.com",
        "drakulastream.eu",
        "vodafone.de",
        "bt.dk",
        "greenwichmeantime.com",
        "ufc.com",
        "webstatsdomain.org",
        "taoche.com",
        "thinkgeek.com",
        "caranddriver.com",
        "123-reg.co.uk",
        "translit.ru",
        "w3school.com.cn",
        "zwinky.com",
        "inboxdollars.com",
        "gratka.pl",
        "vecernji.hr",
        "taikang.com",
        "bolshoyvopros.ru",
        "urbita.com",
        "api.ning.com",
        "alltop.com",
        "readwrite.com",
        "medhelp.org",
        "totaljobs.com",
        "accorhotels.com",
        "prom.ua",
        "cuny.edu",
        "livemint.com",
        "berlin.de",
        "blogspot.hk",
        "orkut.com.br",
        "lzjl.com",
        "metric-conversions.org",
        "nationalrail.co.uk",
        "oxu.az",
        "mql5.com",
        "chinaluxus.com",
        "linguee.es",
        "saudiairlines.com",
        "standardmedia.co.ke",
        "alkislarlayasiyorum.com",
        "apk.tw",
        "lesoir.be",
        "whatculture.com",
        "indiewire.com",
        "pccomponentes.com",
        "paytm.in",
        "ebaypartnernetwork.com",
        "haivl.tv",
        "e-junkie.com",
        "tvp.pl",
        "ifilez.org",
        "aristeguinoticias.com",
        "bangkokpost.com",
        "whatmobile.com.pk",
        "prodavalnik.com",
        "arsenal.com",
        "buyma.com",
        "torrentday.com",
        "sammydress.com",
        "blogcu.com",
        "imore.com",
        "shitaraba.com",
        "pasadrexam2014.in",
        "songspk.at",
        "eforosh.com",
        "nocoty.pl",
        "koreus.com",
        "verticalresponse.com",
        "arte.tv",
        "ocnk.net",
        "cryptsy.com",
        "haaretz.com",
        "straitstimes.com",
        "2domains.ru",
        "usnetads.com",
        "pracuj.pl",
        "edreams.it",
        "sba.gov",
        "instabang.com",
        "domainnamesales.com",
        "teensnow.com",
        "visualwebsiteoptimizer.com",
        "blogos.com",
        "santander.com.mx",
        "solidfiles.com",
        "authorstream.com",
        "teslamotors.com",
        "tema.livejournal.com",
        "kolesa.kz",
        "startribune.com",
        "vevo.com",
        "clien.net",
        "3asq.com",
        "tvnet.lv",
        "mouthshut.com",
        "binary-machine.com",
        "adultwork.com",
        "hypebeast.com",
        "itrack.it",
        "network-tools.com",
        "brandsoftheworld.com",
        "comedycentral.com",
        "hotscripts.com",
        "meristation.com",
        "rlsbb.com",
        "uzai.com",
        "volkskrant.nl",
        "terra.com.mx",
        "howtoforge.com",
        "178.com",
        "wickedfire.com",
        "dilandau.eu",
        "seriales.us",
        "xataka.com",
        "hktdc.com",
        "express.pk",
        "surfcanyon.com",
        "buildhr.com",
        "ouest-france.fr",
        "stltoday.com",
        "alternet.org",
        "site5.com",
        "payserve.com",
        "society6.com",
        "douguo.com",
        "prosieben.de",
        "verywed.com",
        "enikos.gr",
        "tubewolf.com",
        "openrice.com",
        "blankrefer.com",
        "gouv.qc.ca",
        "torrentfreak.com",
        "craveonline.com",
        "unfollowers.com",
        "deser.pl",
        "quanjing.com",
        "runetki.tv",
        "yepi.com",
        "socialbakers.com",
        "webmotors.com.br",
        "mmo-champion.com",
        "globososo.com",
        "whois.sc",
        "sportskeeda.com",
        "socialblade.com",
        "jin115.com",
        "avjavjav.com",
        "thenewstribe.com",
        "pinkrod.com",
        "blox.pl",
        "mediamarkt.de",
        "vivo.com.br",
        "facilisimo.com",
        "sinarharian.com.my",
        "leguide.com",
        "voegol.com.br",
        "j.gs",
        "okgj.com",
        "revolveclothing.com",
        "lolinez.com",
        "go2cloud.org",
        "vmoptions.com",
        "myip.ms",
        "ay.gy",
        "liquidweb.com",
        "sbi.co.in",
        "alamaula.com",
        "reshareable.tv",
        "stirileprotv.ro",
        "siriusxm.com",
        "banvenez.com",
        "sergey-mavrodi-mmm.net",
        "ocj.com.cn",
        "elderscrollsonline.com",
        "webaslan.com",
        "dereferer.org",
        "newsbeast.gr",
        "778669.com",
        "yeucahat.com",
        "guitarcenter.com",
        "mercurynews.com",
        "channeladvisor.com",
        "go2000.com",
        "google.ge",
        "pandora.tv",
        "haqqin.az",
        "google.tt",
        "32d1d3b9c.se",
        "sexdatenow.net",
        "befunky.com",
        "micromaxinfo.com",
        "jquerymobile.com",
        "radikal.ru",
        "wigetmedia.com",
        "girlsplay.com",
        "pureleverage.com",
        "mathxl.com",
        "themefuse.com",
        "giga.de",
        "freevideo.cz",
        "stylebistro.com",
        "iwriter.com",
        "winporn.com",
        "tripadvisor.ca",
        "atresplayer.com",
        "igma.tv",
        "ravelry.com",
        "semana.com",
        "verycd.com",
        "sblo.jp",
        "fansided.com",
        "goalunited.org",
        "petfinder.com",
        "worthofweb.com",
        "memuruz.net",
        "njuskalo.hr",
        "yellowpages.ca",
        "91jm.com",
        "webconfs.com",
        "interpals.net",
        "erepublik.com",
        "akismet.com",
        "gaadi.com",
        "casasbahia.com.br",
        "techsupportalert.com",
        "bostonglobe.com",
        "uploadable.ch",
        "smartprofitsystem.com",
        "cimbclicks.com.my",
        "uwants.com",
        "gamestar.de",
        "neowin.net",
        "inilah.com",
        "toster.ru",
        "gosuslugi.ru",
        "windguru.cz",
        "3366.com",
        "beinsports.net",
        "vector.co.jp",
        "memecenter.com",
        "hotnews.ro",
        "webgame.web.id",
        "llnw.com",
        "jobstreet.co.id",
        "congratulations-you-won.com",
        "libertatea.ro",
        "app111.com",
        "scientificamerican.com",
        "strava.com",
        "iranjib.ir",
        "coneco.net",
        "fdrmx.com",
        "nps.gov",
        "businessinsider.in",
        "uniblue.com",
        "proporn.com",
        "dm5.com",
        "qld.gov.au",
        "nexusmods.com",
        "mandatory.com",
        "moskva.fm",
        "prosperityteam.com",
        "lent.az",
        "appbrain.com",
        "24smi.org",
        "avaxsearch.com",
        "gorillavid.in",
        "realgm.com",
        "favicon.cc",
        "astro.com",
        "joomlaforum.ru",
        "joystiq.com",
        "computerworld.com",
        "tvspielfilm.de",
        "centos.org",
        "bugun.com.tr",
        "amctv.com",
        "relianceada.com",
        "papystreaming.com",
        "clickindia.com",
        "sayyac.com",
        "q.gs",
        "bravoerotica.com",
        "bibsonomy.org",
        "netload.in",
        "shopatron.com",
        "iautos.cn",
        "banggood.com",
        "commerzbanking.de",
        "legacyclix.com",
        "intesasanpaolo.com",
        "awesomescreenshot.com",
        "desidime.com",
        "eporner.com",
        "alwatanvoice.com",
        "ok.ru",
        "europe1.fr",
        "karnaval.com",
        "tornn-tv.com",
        "frmtr.com",
        "pulscen.ru",
        "groupon.co.uk",
        "tradera.com",
        "comingsoon.net",
        "speckyboy.com",
        "cargurus.com",
        "citysearch.com",
        "brother.com",
        "acfun.tv",
        "jamejamonline.ir",
        "enterprise.com",
        "elotrolado.net",
        "userscripts.org",
        "confirmit.com",
        "compete.com",
        "auctiva.com",
        "potterybarn.com",
        "ivoox.com",
        "multiupload.nl",
        "glavnoe.ua",
        "p30world.com",
        "snapnames.com",
        "filmon.com",
        "flipkey.com",
        "rhhbschool.com",
        "worldbank.org",
        "proz.com",
        "docusign.net",
        "akakce.com",
        "empflix.com",
        "androidforums.com",
        "mos.ru",
        "contenko.com",
        "malwarebytes.org",
        "voyeurhit.com",
        "filmvz.com",
        "windowsazure.com",
        "rlslog.net",
        "zulagames.com",
        "onlinefinder.net",
        "blekko.com",
        "tvb.com",
        "mojomarketplace.com",
        "warnerbros.com",
        "rogers.com",
        "sparkasse.at",
        "bigcinema.tv",
        "mattcutts.com",
        "vemale.com",
        "pgatour.com",
        "bakusai.com",
        "lavozdegalicia.es",
        "style.com",
        "torrentino.com",
        "activeden.net",
        "sweetpacks-search.com",
        "pcstore.com.tw",
        "starmedia.com",
        "lycos.com",
        "uncomo.com",
        "caribbeancom.com",
        "googleping.com",
        "sondakika.com",
        "premiumwp.com",
        "tribune.com.pk",
        "sc.com",
        "91mobiles.com",
        "elle.com",
        "motortrend.com",
        "starsports.com",
        "otlan.com",
        "planetminecraft.com",
        "oregonlive.com",
        "publichd.se",
        "financialexpress.com",
        "huxiu.com",
        "hotwords.com",
        "asda.com",
        "impiego24.it",
        "tunisia-sat.com",
        "xojane.com",
        "shiftdelete.net",
        "hamshahrionline.ir",
        "mp3.es",
        "minutebuzz.com",
        "footlocker.com",
        "rusnovosti.ru",
        "defencenet.gr",
        "ndr.de",
        "blogosfera.uol.com.br",
        "quibids.com",
        "soft32.com",
        "davidwalsh.name",
        "blogun.ru",
        "webbirga.net",
        "dict.cn",
        "groupon.jp",
        "abovetopsecret.com",
        "contra.gr",
        "zn.ua",
        "jetbrains.com",
        "myus.com",
        "redbus.in",
        "creativemarket.com",
        "uainfo.org",
        "rtbf.be",
        "forexpf.ru",
        "mainlink.ru",
        "fantasti.cc",
        "usagc.org",
        "narutoget.com",
        "trendyol.com",
        "carsales.com.au",
        "fujitv.co.jp",
        "dardarkom.com",
        "corrieredellosport.it",
        "mcanime.net",
        "nolo.com",
        "beareyes.com.cn",
        "familysearch.org",
        "eprice.com.tw",
        "indonetwork.co.id",
        "geizhals.at",
        "watchfreemovies.ch",
        "siweiw.com",
        "elnuevoherald.com",
        "codecupdaters.com",
        "p1.com",
        "imhonet.ru",
        "spox.com",
        "spreadshirt.com",
        "bittorrent.com",
        "airberlin.com",
        "epicurious.com",
        "adverstitial.com",
        "researchnow.com",
        "lolnexus.com",
        "xbabe.com",
        "designmodo.com",
        "hamusoku.com",
        "radioshack.com",
        "teamliquid.net",
        "helpster.de",
        "globalsources.com",
        "fasttech.com",
        "dickssportinggoods.com",
        "j-sen.jp",
        "smashwords.com",
        "adversal.com",
        "musiciansfriend.com",
        "whoishostingthis.com",
        "ads8.com",
        "trend4pay.com",
        "tribune.com",
        "xsrving.com",
        "youngleafs.com",
        "gamersky.com",
        "podio.com",
        "state.pa.us",
        "iphoneogram.com",
        "datehookup.com",
        "hbs.edu",
        "ally.com",
        "mitbbs.com",
        "siasat.pk",
        "miratuserie.tv",
        "active.com",
        "ricardoeletro.com.br",
        "html.it",
        "minnano-av.com",
        "meetly.in",
        "denverpost.com",
        "supersport.com",
        "grupobancolombia.com",
        "freemake.com",
        "bankier.pl",
        "instapaper.com",
        "derwesten.de",
        "blogspot.hu",
        "tamindir.com",
        "play.pl",
        "warthunder.com",
        "team-bhp.com",
        "freepeople.com",
        "laposte.fr",
        "cnews.ru",
        "fayerwayer.com",
        "hitta.se",
        "hao123.com.eg",
        "it-ebooks.info",
        "freep.com",
        "newser.com",
        "lexilogos.com",
        "polldaddy.com",
        "auspost.com.au",
        "aib.ie",
        "cs.com.cn",
        "providesupport.com",
        "unblocksit.es",
        "twittercounter.com",
        "luisaviaroma.com",
        "imgbabes.com",
        "tharunee.lk",
        "nexon.com",
        "airliners.net",
        "srf.ch",
        "angel.co",
        "tokyo-sports.co.jp",
        "mt5.com",
        "down1oads.com",
        "vodonet.net",
        "axar.az",
        "taknaz.ir",
        "google.com.py",
        "ss.lv",
        "stuffgate.com",
        "giveawayoftheday.com",
        "climatempo.com.br",
        "xnxxmovies.com",
        "heartinternet.co.uk",
        "digikey.com",
        "zimbra.free.fr",
        "line.me",
        "talkingpointsmemo.com",
        "dyn.com",
        "exacttarget.com",
        "yourtango.com",
        "shopping.com",
        "king.com",
        "crackberry.com",
        "sm3na.com",
        "matchesfashion.com",
        "rk.com",
        "ems.com.cn",
        "xiaomi.cn",
        "hillnews.com",
        "geforce.com",
        "internetslang.com",
        "theoldreader.com",
        "digitaljournal.com",
        "aol.co.uk",
        "straightdope.com",
        "farfetch.com",
        "lupoporno.com",
        "ilgiornale.it",
        "binzhi.com",
        "loveplanet.ru",
        "sogi.com.tw",
        "googlevideo.com",
        "nintendo.com",
        "jreast.co.jp",
        "coinad.com",
        "keek.com",
        "chegg.com",
        "sparknotes.com",
        "mywapblog.com",
        "idlebrain.com",
        "boardgamegeek.com",
        "daserste.de",
        "nicozon.net",
        "ampnetzwerk.de",
        "agenziaentrate.gov.it",
        "apec.fr",
        "redbull.com",
        "listentoyoutube.com",
        "diepresse.com",
        "gohappy.com.tw",
        "morguefile.com",
        "dallasnews.com",
        "adxpansion.com",
        "almos3a.com",
        "updatetube.com",
        "lowyat.net",
        "lolipop.jp",
        "terafile.co",
        "eversave.com",
        "sportingnews.com",
        "517dv.com",
        "milfmovs.com",
        "myflorida.com",
        "brooonzyah.net",
        "cdn-cachefront.net",
        "ig.com",
        "indiapost.gov.in",
        "hangame.co.jp",
        "ithemes.com",
        "monova.org",
        "udmserve.net",
        "impactradius.com",
        "teasernet.com",
        "gmx.at",
        "mmotraffic.com",
        "citehr.com",
        "viator.com",
        "rt.ru",
        "japannetbank.co.jp",
        "zonealarm.com",
        "ebayclassifieds.com",
        "safecart.com",
        "proptp.net",
        "51hejia.com",
        "telkomsel.com",
        "deutschepost.de",
        "startpagina.nl",
        "alexaboostup.com",
        "istgah.com",
        "aufreeads.com",
        "thinkstockphotos.com",
        "similarsitesearch.com",
        "gossiplankanews.com",
        "venere.com",
        "javascriptkit.com",
        "square-enix.com",
        "tvtoday.de",
        "netaffiliation.com",
        "computrabajo.com.mx",
        "arioo.com",
        "fromdoctopdf.com",
        "lookany.com",
        "bleepingcomputer.com",
        "perfectmoney.com",
        "dorkly.com",
        "macmillandictionary.com",
        "fotka.pl",
        "porntubevidz.com",
        "rj.gov.br",
        "1.1.1.1",
        "ebay.be",
        "divxplanet.com",
        "cyworld.com",
        "biography.com",
        "p1.cn",
        "bazos.sk",
        "55.la",
        "lockerdome.com",
        "yola.com",
        "ccbill.com",
        "groupon.de",
        "okazii.ro",
        "izismile.com",
        "velvet.hu",
        "news-postseven.com",
        "ardmediathek.de",
        "sagawa-exp.co.jp",
        "sarzamindownload.com",
        "pdfonline.com",
        "gaaks.com",
        "azhibo.com",
        "pensador.uol.com.br",
        "surveygizmo.com",
        "familydoctor.com.cn",
        "lazada.vn",
        "guokr.com",
        "enjoydressup.com",
        "sky.de",
        "afp.com",
        "imujer.com",
        "livescore.net",
        "xinnet.com",
        "mypageresults.com",
        "safaribooksonline.com",
        "extremetech.com",
        "ecnavi.jp",
        "babyblog.ru",
        "practicalecommerce.com",
        "vidspot.net",
        "studymode.com",
        "nation.co.ke",
        "cpmrocket.com",
        "es.wix.com",
        "google.com.cu",
        "pravda.ru",
        "cda.pl",
        "appszoom.com",
        "selfhtml.org",
        "zmovie.tw",
        "dba.dk",
        "domain.com",
        "brightcove.com",
        "lol55.com",
        "textsale.ru",
        "casualclub.com",
        "gudvin.tv",
        "torrentreactor.net",
        "downloadcamp.com",
        "eset.com",
        "softonic.it",
        "internations.org",
        "retre.org",
        "3quan.com",
        "companieshouse.gov.uk",
        "hautelook.com",
        "edx.org",
        "ono.es",
        "jango.com",
        "7sur7.be",
        "spinrewriter.com",
        "hqxnxx.com",
        "elperiodico.com",
        "arabiaweather.com",
        "liansuo.com",
        "pcgamer.com",
        "offervault.com",
        "mytheresa.com",
        "memegenerator.net",
        "gsm.ir",
        "britannica.com",
        "mensfitness.com",
        "flaticon.com",
        "newrelic.com",
        "greatmmos.com",
        "ifixit.com",
        "aiyellow.com",
        "my.tv.sohu.com/user/card",
        "ce4arab.com",
        "news-us.jp",
        "slando.kz",
        "redflagdeals.com",
        "gsmhosting.com",
        "raiffeisen.at",
        "tagesspiegel.de",
        "epravda.com.ua",
        "bell.ca",
        "sleazyneasy.com",
        "dhnet.be",
        "webcars.com.cn",
        "freepik.es",
        "androidpolice.com",
        "cbr.ru",
        "thanhnien.com.vn",
        "shoptime.com.br",
        "dailytelegraph.com.au",
        "fastcodesign.com",
        "full-stream.net",
        "google.al",
        "creativecow.net",
        "centrum24.pl",
        "openstat.ru",
        "unfollowed.me",
        "brb.to",
        "babal.net",
        "ibotoolbox.com",
        "torrentdownloads.me",
        "miami.com",
        "mubasher.info",
        "patient.co.uk",
        "ayudawordpress.com",
        "makepolo.com",
        "exactseek.com",
        "echosign.com",
        "epson.com",
        "somo.vn",
        "tripadvisor.jp",
        "bikroy.com",
        "postimees.ee",
        "band.uol.com.br",
        "adopteunmec.com",
        "imgserve.net",
        "toofab.com",
        "neeu.com",
        "mailjet.com",
        "kinja.com",
        "qwertypay.com",
        "cosme.net",
        "dreammovies.com",
        "avvo.com",
        "wenyard.com",
        "dir.bg",
        "digital-photography-school.com",
        "peru.com",
        "thomsonreuters.com",
        "grazia.com.cn",
        "vivastreet.co.in",
        "officemax.com",
        "creditmutuel.fr",
        "themify.me",
        "ait-themes.com",
        "share-links.biz",
        "graphixshare.com",
        "theoutnet.com",
        "revolvermaps.com",
        "careers360.com",
        "tyroodr.com",
        "escapistmagazine.com",
        "ofreegames.com",
        "surveryewadcentrez.eu",
        "notebookcheck.net",
        "k2s.cc",
        "barstoolsports.com",
        "townhall.com",
        "mk.co.kr",
        "epochtimes.com",
        "arduino.cc",
        "blogcms.jp",
        "udacity.com",
        "habervaktim.com",
        "funweek.it",
        "techtunes.com.bd",
        "shopzilla.com",
        "sun-sentinel.com",
        "tfile.me",
        "novafile.com",
        "eurogamer.net",
        "thenewporn.com",
        "tuttosport.com",
        "sverve.com",
        "simplemachines.org",
        "nginx.org",
        "kepu.com.cn",
        "jxedt.com",
        "southparkstudios.com",
        "gusuwang.com",
        "utrace.de",
        "peperonity.de",
        "hvg.hu",
        "cairodar.com",
        "mappy.com",
        "kouclo.com",
        "my.tv.sohu.com/user/lucky",
        "lushstories.com",
        "stocktwits.com",
        "atlantico.fr",
        "baihe.com",
        "wowkeren.com",
        "v7n.com",
        "mozilla.com",
        "centurylink.net",
        "1001freefonts.com",
        "pubdirecte.com",
        "mercadolibre.com.pe",
        "vandelaydesign.com",
        "cpaelites.com",
        "wanyh.com",
        "propertyguru.com.sg",
        "esy.es",
        "torrentbutler.eu",
        "final.ir",
        "53.com",
        "clips4sale.com",
        "freerepublic.com",
        "huffingtonpost.de",
        "boards.ie",
        "fluege.de",
        "parents.com",
        "gimp.org",
        "adorocinema.com",
        "yelp.ca",
        "twicsy.com",
        "kuaibo.com",
        "gnu.org",
        "parsine.com",
        "jpc.com",
        "cloudapp.net",
        "expatriates.com",
        "sproutsocial.com",
        "natemat.pl",
        "livingrichwithcoupons.com",
        "x-ho.com",
        "adv-adserver.com",
        "downloadchop.com",
        "sagepub.com",
        "eleconomista.com.mx",
        "formula1.com",
        "quackit.com",
        "dlsite.com",
        "powned.tv",
        "stream-tv.me",
        "mindbodyonline.com",
        "mindmeister.com",
        "twitlonger.com",
        "ebay.ie",
        "deccanchronicle.com",
        "domaintuno.com",
        "thethirdmedia.com",
        "laiguana.tv",
        "flurry.com",
        "eloqua.com",
        "createsend.com",
        "hrloo.com",
        "interfax.com.ua",
        "admin.ch",
        "zgzcw.com",
        "bancoestado.cl",
        "fda.gov",
        "chinayes.com",
        "beslist.nl",
        "crossfit.com",
        "skai.gr",
        "covers.com",
        "antpoker.com",
        "perfectworld.com",
        "momdot.com",
        "1c-bitrix.ru",
        "feiren.com",
        "navitime.co.jp",
        "siliconindia.com",
        "warning.or.kr",
        "qatarliving.com",
        "uber.com",
        "ing-diba.de",
        "boldsky.com",
        "animeid.tv",
        "tom.com",
        "whatsmyserp.com",
        "ftbpro.com",
        "yobt.tv",
        "toluna.com",
        "burrp.com",
        "viber.com",
        "df.eu",
        "vatera.hu",
        "songmeanings.com",
        "smbc-card.com",
        "hip2save.com",
        "wmzona.com",
        "banamex.com",
        "chinaacc.com",
        "t-online.hu",
        "indianpornvideos.com",
        "runescape.com",
        "wapka.mobi",
        "115.com",
        "blogspot.no",
        "aksam.com.tr",
        "bankcomm.com",
        "giantbomb.com",
        "maxcdn.com",
        "topshop.com",
        "livescores.com",
        "rosbalt.ru",
        "gandi.net",
        "ioffer.com",
        "mihandownload.com",
        "eweb4.com",
        "britishcouncil.org",
        "cheetahmail.com",
        "vbulletin.com",
        "bradsdeals.com",
        "empowernetwork.com/commissionloophole",
        "vueling.com",
        "raventools.com",
        "yext.com",
        "everychina.com",
        "reduxmediia.com",
        "openstreetmap.org",
        "wed114.cn",
        "dzwww.com",
        "miibeian.gov.cn",
        "ufl.edu",
        "deseretnews.com",
        "presstv.ir",
        "copy.com",
        "fourhourworkweek.com",
        "buzztheme.net",
        "bollywoodlife.com",
        "redtubelive.com",
        "pengyou.com",
        "antaranews.com",
        "selectornews.com",
        "lavoz.com.ar",
        "avm.de",
        "flalottery.com",
        "jmp9.com",
        "baltimoresun.com",
        "mozillazine.org",
        "dnevnik.hr",
        "aebn.net",
        "mightydeals.com",
        "livescore.eu",
        "publipt.com",
        "xbmc.org",
        "scmp.com",
        "sbobet.com",
        "alpari.ru",
        "harborfreight.com",
        "linio.com.pe",
        "2500sz.com",
        "rdio.com",
        "bearshare.com",
        "thetrainline.com",
        "888poker.es",
        "filecrop.com",
        "twiends.com",
        "elnuevodia.com",
        "rasekhoon.net",
        "36.cn",
        "axeso5.com",
        "mzamin.com",
        "webmastersitesi.com",
        "thinkdigit.com",
        "lifescript.com",
        "experian.com",
        "adorama.com",
        "d1net.com",
        "torrentz.pro",
        "fullhdfilmizle.org",
        "space.com",
        "collider.com",
        "zalando.it",
        "slate.fr",
        "carmax.com",
        "recode.net",
        "gfan.com",
        "fonts.com",
        "honda.com",
        "ecwid.com",
        "debate.com.mx",
        "bmail.uol.com.br",
        "santandernet.com.br",
        "coderanch.com",
        "lyricsmode.com",
        "gametrailers.com",
        "3600.com",
        "designboom.com",
        "131.com",
        "finam.ru",
        "df.gob.mx",
        "85dcf732d593.se",
        "coches.net",
        "dhs.gov",
        "neurs.com",
        "poppen.de",
        "public-api.wordpress.com",
        "magnovideo.com",
        "squareup.com",
        "balagana.net",
        "goodsearch.com",
        "blog.ir",
        "ne10.uol.com.br",
        "di.se",
        "sinembargo.mx",
        "k618.cn",
        "eventim.de",
        "mysavings.com",
        "futureshop.ca",
        "spinding.com",
        "landsend.com",
        "oqenadserving.com",
        "here.com",
        "upi.com",
        "picresize.com",
        "abnamro.nl",
        "filenuke.com",
        "yxku.com",
        "mypearson.com",
        "dinakaran.com",
        "correos.es",
        "hotchatdirect.com",
        "markafoni.com",
        "gofuckbiz.com",
        "webfindpage.com",
        "cancan.ro",
        "hostgator.in",
        "latribune.fr",
        "adxite.com",
        "mofos.com",
        "bluewin.ch",
        "24ur.com",
        "dion.ne.jp",
        "vpsdomain3.eu",
        "newsweek.com",
        "oasgames.com",
        "mtv3.fi",
        "internetworld.de",
        "yatedo.com",
        "globaltimes.cn",
        "paddypower.com",
        "berlin1.de",
        "norwegian.com",
        "opteck.com",
        "zenfolio.com",
        "kakprosto.ru",
        "ecosia.org",
        "check24.de",
        "idbibank.co.in",
        "zoomit.ir",
        "notebooksbilliger.de",
        "torontosun.com",
        "egopay.com",
        "cnnexpansion.com",
        "emoneyspace.com",
        "rsport.ru",
        "fok.nl",
        "mql4.com",
        "inhabitat.com",
        "tqn.com",
        "noticierodigital.com",
        "wrike.com",
        "bazos.cz",
        "phonegap.com",
        "microlancer.com",
        "anipo.jp",
        "fotocommunity.de",
        "kuwo.cn",
        "chinacaipu.com",
        "terra.cl",
        "500px.org",
        "qantas.com.au",
        "advertising.com",
        "push2check.net",
        "livefyre.com",
        "philstar.com",
        "erail.in",
        "mywebgrocer.com",
        "der-postillon.com",
        "ru-board.com",
        "saramin.co.kr",
        "yjbys.com",
        "aaa.com",
        "flavorwire.com",
        "fcbarcelona.com",
        "lacentrale.fr",
        "googlegroups.com",
        "luck4.me",
        "catho.com.br",
        "centauro.com.br",
        "sia.az",
        "forumactif.com",
        "paltalk.com",
        "beyond.com",
        "occ.com.mx",
        "stamps.com",
        "getoffmyinternets.net",
        "mbok.jp",
        "cleveland.com",
        "ucdavis.edu",
        "tielabs.com",
        "hkgolden.com",
        "vandal.net",
        "lyst.com",
        "mrskin.com",
        "bunshun.jp",
        "netcarshow.com",
        "b1.org",
        "hromadske.tv",
        "sf-express.com",
        "pirateproxy.ca",
        "getcashforsurveys.com",
        "clikz4freakz.com",
        "adsupply.com",
        "truste.org",
        "boxuu.com",
        "webartex.ru",
        "usc.edu",
        "moo.com",
        "winkal.com",
        "deloitte.com",
        "xvideos-field5.com",
        "suomi24.fi",
        "flexmls.com",
        "weeklystandard.com",
        "debenhams.com",
        "mejortorrent.com",
        "vconnect.com",
        "ligatus.com",
        "skynewsarabia.com",
        "herschina.com",
        "92lux.cn",
        "care.com",
        "chip.com.tr",
        "tangdou.com",
        "vatanbilgisayar.com",
        "uppit.com",
        "metronews.fr",
        "parenting.com.tw",
        "meteo.gr",
        "meetgee.com",
        "ldlc.com",
        "ubs.com",
        "elcolombiano.com",
        "mafengwo.cn",
        "moodle.org",
        "asiaone.com",
        "huffingtonpost.it",
        "ipas2free.com",
        "casa.it",
        "kaiserpermanente.org",
        "listindiario.com",
        "treehugger.com",
        "payeer.com",
        "mypoints.com",
        "pjmedia.com",
        "foreca.com",
        "luxup.ru",
        "halifax.co.uk",
        "webinarjam.net",
        "webmeup.com",
        "webdesignledger.com",
        "rte.ie",
        "18andabused.com",
        "vbulletin.org",
        "apne.tv",
        "immoweb.be",
        "colonelcassad.livejournal.com",
        "atlassian.com",
        "investors.com",
        "globalbux.net",
        "wechat.com",
        "kanoon.ir",
        "mawaly.com",
        "self.com",
        "drive.ru",
        "autozone.com",
        "creditonebank.com",
        "fdj.fr",
        "hsbc.com.br",
        "desk.com",
        "dlvr.it",
        "wpml.org",
        "newmobilelife.com",
        "crosswalk.com",
        "thehun.com",
        "hobbyking.com",
        "tiantian.com",
        "hichina.com",
        "cyanogenmod.org",
        "horoscope.com",
        "bizsugar.com",
        "popularmechanics.com",
        "egaliteetreconciliation.fr",
        "eol.cn",
        "rzd.ru",
        "escalatenetwork.net",
        "yad2.co.il",
        "cna.com.tw",
        "zi-m.com",
        "leonardo.it",
        "ap.gov.in",
        "rakuten.de",
        "wallsave.com",
        "netzwelt.de",
        "bitrix24.ru",
        "techinasia.com",
        "bitstamp.net",
        "hostelbookers.com",
        "shoplocal.com",
        "200please.com",
        "tune-up.com",
        "mapy.cz",
        "dealnews.com",
        "livescore.co.uk",
        "seocentro.com",
        "rstyle.me",
        "neoseeker.com",
        "kaban.tv",
        "visualstudio.com",
        "cinetux.org",
        "groupon.com.br",
        "lastpass.com",
        "rincondelvago.com",
        "popsci.com",
        "2144.cn",
        "clickfair.com",
        "dsebd.org",
        "banesco.com",
        "spi0n.com",
        "blogspot.cz",
        "tnews.ir",
        "nme.com",
        "paperblog.com",
        "firstcry.com",
        "tophotels.ru",
        "liepin.com",
        "korabia.com",
        "ifttt.com",
        "aemet.es",
        "alot.com",
        "manutd.com",
        "edreams.es",
        "turkcell.com.tr",
        "eva.vn",
        "techpowerup.com",
        "vkrugudruzei.ru",
        "feed2all.eu",
        "thehindubusinessline.com",
        "express.de",
        "ixquick.com",
        "thrillist.com",
        "iqilu.com",
        "seriouseats.com",
        "edgesuite.net",
        "telexads.com",
        "alza.cz",
        "en-japan.com",
        "al.com",
        "dota2lounge.com",
        "totalping.com",
        "seocheki.net",
        "iceporn.com",
        "col3negoriginel.lk",
        "porsyar.com",
        "property24.com",
        "madamenoire.com",
        "markethealth.com",
        "alphacoders.com",
        "webempresa.com",
        "empireonline.com",
        "downforeveryoneorjustme.com",
        "lankadeepa.lk",
        "darty.com",
        "census.gov",
        "wapka.me",
        "kdslife.com",
        "jpost.com",
        "cricfree.tv",
        "7xxxtube.com",
        "businesscatalyst.com",
        "dilbert.com",
        "gaymaletube.com",
        "bellanaija.com",
        "renfe.es",
        "equifax.com",
        "pornmaki.com",
        "lolesports.com",
        "yunfan.com",
        "everybitcity.com",
        "9yao.com",
        "avantlink.com",
        "paginebianche.it",
        "xrosview.com",
        "newsday.com",
        "usportnews.com",
        "petapixel.com",
        "pistonheads.com",
        "lidovky.cz",
        "cvent.com",
        "adlandpro.com",
        "wikisource.org",
        "ename.com",
        "prosport.ro",
        "sharebuilder.com",
        "prisjakt.nu",
        "cw.com.tw",
        "datafilehost.com",
        "aircanada.com",
        "osu.edu",
        "linuxmint.com",
        "toyota.com",
        "google.am",
        "adobeconnect.com",
        "h33t.to",
        "companycheck.co.uk",
        "juno.com",
        "beitaichufang.com",
        "alaskaair.com",
        "tipsandtricks-hq.com",
        "yourstory.com",
        "wow-impulse.ru",
        "wishpond.com",
        "promosite.ru",
        "weddingwire.com",
        "icicidirect.com",
        "mouser.com",
        "shopstyle.co.uk",
        "sinemalar.com",
        "addurl.nu",
        "seccionamarilla.com.mx",
        "yllix.com",
        "motorola.com",
        "huawei.com",
        "mp3juices.com",
        "fitday.com",
        "pakwheels.com",
        "uploading.com",
        "snapwidget.com",
        "rsb.ru",
        "mturk.com",
        "libreoffice.org",
        "acer.com",
        "rd.com",
        "aa.com.tr",
        "glamour.com",
        "docnhat.net",
        "cnbb.com.cn",
        "piwik.org",
        "mycompanyadmin.com",
        "ohozaa.com",
        "fox.com",
        "mastercard.com.au",
        "microsofttranslator.com",
        "myhabit.com",
        "acesso.uol.com.br",
        "cqnews.net",
        "default-search.net",
        "juntadeandalucia.es",
        "carigold.com",
        "tweepi.com",
        "gamedog.cn",
        "videomega.tv",
        "softarchive.net",
        "akamai.com",
        "adorika.net",
        "zorpia.com",
        "bitdefender.com",
        "formstack.com",
        "al3abbarq.com",
        "ruelala.com",
        "andhrajyothy.com",
        "siteheart.com",
        "spankbang.com",
        "buxp.org",
        "subtlepatterns.com",
        "cucirca.eu",
        "apontador.com.br",
        "sbs.co.kr",
        "rong360.com",
        "billmelater.com",
        "nowdownload.ch",
        "pingmyurl.com",
        "main.jp",
        "allabolag.se",
        "fastspring.com",
        "20d625b48e.se",
        "wpzoom.com",
        "dl-protect.com",
        "onvista.de",
        "iberia.com",
        "learni.st",
        "minijuegos.com",
        "ae.com",
        "india-forums.com",
        "port.hu",
        "truelocal.com.au",
        "ziprecruiter.com",
        "toyokeizai.net",
        "24timezones.com",
        "tzetze.it",
        "the-village.ru",
        "ptcapusa.com",
        "indiaresults.com",
        "desjardins.com",
        "nchsoftware.com",
        "yasdl.com",
        "delo.ua",
        "baskino.com",
        "salary.com",
        "freecontact.com",
        "wumii.com",
        "ssc.nic.in",
        "synology.com",
        "nttdocomo.co.jp",
        "racing-games.com",
        "freeonlinegames.com",
        "aftabnews.ir",
        "zumi.pl",
        "efshop.com.tw",
        "hawamer.com",
        "eastbay.com",
        "izvestia.ru",
        "mosaiquefm.net",
        "twitchy.com",
        "slaati.com",
        "bookingbuddy.com",
        "networksolutionsemail.com",
        "etsystatic.com",
        "sina.com",
        "asiandatingbeauties.com",
        "blogs.com",
        "france3.fr",
        "healthcentral.com",
        "downloadatoz.com",
        "matthewwoodward.co.uk",
        "legalzoom.com",
        "phun.org",
        "campaignmonitor.com",
        "cifraclub.com.br",
        "hir24.hu",
        "twoplustwo.com",
        "hotshame.com",
        "arvixededicated.com",
        "designcrowd.com",
        "mrexcel.com",
        "blu-ray.com",
        "bundesliga.de",
        "comments.ua",
        "filmstarts.de",
        "3sk.tv",
        "donedeal.ie",
        "natunbarta.com",
        "forex-mmcis.com",
        "lifehacker.ru",
        "sitepronews.com",
        "tudogostoso.com.br",
        "titanfall.com",
        "brainpickings.org",
        "saharareporters.com",
        "vidto.me",
        "mlit.go.jp",
        "terapeak.com",
        "techweb.com.cn",
        "premiere.fr",
        "kanui.com.br",
        "asianetnews.tv",
        "cric.lk",
        "exxxtrasmall.com",
        "hiphopdx.com",
        "5617.com",
        "namepros.com",
        "humanmetrics.com",
        "allin1convert.com",
        "ox.ac.uk",
        "msecnd.net",
        "cathaypacific.com",
        "bet365affiliates.com",
        "tcs.com",
        "trafficestimate.com",
        "lmgtfy.com",
        "finance.ua",
        "find404.com",
        "pagesperso-orange.fr",
        "curbed.com",
        "tasteofhome.com",
        "ar15.com",
        "mydigitallife.info",
        "promiflash.de",
        "technobuffalo.com",
        "gamestorrents.com",
        "labirint.ru",
        "pclab.pl",
        "indiatvnews.com",
        "finya.de",
        "redmondpie.com",
        "rabota.ru",
        "share-online.biz",
        "packtpub.com",
        "techgig.com",
        "shaw.ca",
        "apkmania.co",
        "bet-at-home.com",
        "barclaycard.co.uk",
        "onefloorserve.com",
        "raiffeisen.ru",
        "t-nation.com",
        "mbalib.com",
        "staseraintv.com",
        "uswitch.com",
        "smartadserver.com",
        "bbcgoodfood.com",
        "elitetorrent.net",
        "backlinko.com",
        "naszemiasto.pl",
        "submitexpress.com",
        "savings.com",
        "gem.pl",
        "ahlamontada.com",
        "fotomac.com.tr",
        "gougou.com",
        "payamsara.com",
        "klix.ba",
        "doostiha.ir",
        "bibliocommons.com",
        "wealthyaffiliate.com",
        "emgn.com",
        "sifyitest.com",
        "washingtonexaminer.com",
        "rakuten-sec.co.jp",
        "mysurvey.com",
        "uuu9.com",
        "uscourts.gov",
        "showroomprive.com",
        "cargocollective.com",
        "hsoub.com",
        "afterbuy.de",
        "marunadanmalayali.com",
        "jumponhottie.com",
        "avon.com",
        "lazada.com.my",
        "51netu.com.cn",
        "ria.com",
        "sankakucomplex.com",
        "tvline.com",
        "devshed.com",
        "superherohype.com",
        "tv-series.me",
        "stylecraze.com",
        "wizards.com",
        "linkcollider.com",
        "xinjunshi.com",
        "bestchange.ru",
        "1111.com.tw",
        "fakenamegenerator.com",
        "newsmth.net",
        "noupe.com",
        "marketingprofs.com",
        "bluestacks.com",
        "jemtube.com",
        "bestbuy.ca",
        "backcountry.com",
        "designshack.net",
        "pond5.com",
        "highsnobiety.com",
        "rtl.fr",
        "pearsoncmg.com",
        "hellowork.go.jp",
        "koimoi.com",
        "soali.ir",
        "incentria.com",
        "vagas.com.br",
        "huaxi100.com",
        "cheaa.com",
        "lohaco.jp",
        "gov.on.ca",
        "fabthemes.com",
        "pipl.com",
        "comscore.com",
        "pcfinancial.ca",
        "craigslist.co.in",
        "michaels.com",
        "jibjab.com",
        "sankeibiz.jp",
        "dominos.co.in",
        "supermoney.eu",
        "itusozluk.com",
        "sdchina.com",
        "allkpop.com",
        "cam4.com.br",
        "stayfriends.de",
        "futbol24.com",
        "searchina.net",
        "sgcpanel.com",
        "informe21.com",
        "alsacreations.com",
        "crateandbarrel.com",
        "alliancewarfare.com",
        "filerio.in",
        "emailsrvr.com",
        "reventmedia.com",
        "vietcombank.com.vn",
        "rxlist.com",
        "acidcow.com",
        "orange.co.uk",
        "hellocoton.fr",
        "boldchat.com",
        "psychcentral.com",
        "surfline.com",
        "xxxkinky.com",
        "es.wordpress.com",
        "publika.az",
        "shufoo.net",
        "hertz.com",
        "businessweekly.com.tw",
        "virgula.uol.com.br",
        "linkis.com",
        "ixwebhosting.com",
        "usa.gov",
        "linguee.com",
        "yengo.com",
        "huffingtonpost.jp",
        "1x3x.com",
        "mediametrics.ru",
        "ec21.com",
        "80018.cn",
        "get-tune.net",
        "yupoo.com",
        "moviepilot.de",
        "ihned.cz",
        "fio.cz",
        "pubted.com",
        "cinemablend.com",
        "stooorage.com",
        "thevault.bz",
        "journaldugeek.com",
        "sommer-sommer.com",
        "travelchannel.com",
        "softonic.de",
        "petsmart.com",
        "ufxmarkets.com",
        "e24.no",
        "spirit.com",
        "dabi.ir",
        "admin5.net",
        "serialu.net",
        "vancouversun.com",
        "submanga.com",
        "sbicard.com",
        "affaritaliani.it",
        "idownloadblog.com",
        "castorama.fr",
        "sudouest.fr",
        "payscale.com",
        "serebii.net",
        "storypick.com",
        "jobkorea.co.kr",
        "gowildcasino.com",
        "hmetro.com.my",
        "parimatch.com",
        "51pinwei.com",
        "globalnews.ca",
        "mercadopago.com",
        "sixrevisions.com",
        "saisoncard.co.jp",
        "gov.kz",
        "gossip-tv.gr",
        "zbozi.cz",
        "aliorbank.pl",
        "huanqiuauto.com",
        "okaz.com.sa",
        "cplusplus.com",
        "mochimedia.com",
        "google.sn",
        "jquery-plugins.net",
        "peoplesmart.com",
        "mmafighting.com",
        "ponpare.jp",
        "porsche.com",
        "charter.com",
        "scrabblefinder.com",
        "unpcn.com",
        "loveaholics.com",
        "geocities.co.jp",
        "ladbrokes.com",
        "52che.com",
        "swansonvitamins.com",
        "sweetwater.com",
        "ali213.net",
        "savenkeep.com",
        "hotair.com",
        "orgasmatrix.com",
        "runrun.es",
        "filezilla-project.org",
        "looti.net",
        "pagesix.com",
        "twentytwowords.com",
        "gingersoftware.com",
        "youxiduo.com",
        "isimtescil.net",
        "rui.jp",
        "d1g.com",
        "2dbook.com",
        "zigzig.ir",
        "123telugu.com",
        "wdr.de",
        "hankyung.com",
        "pr.com",
        "search.ch",
        "iranproud.com",
        "raaga.com",
        "alt1040.com",
        "okpay.com",
        "recordchina.co.jp",
        "dreamincode.net",
        "bendibao.com",
        "creativelive.com",
        "socialoomph.com",
        "cssdeck.com",
        "taxactonline.com",
        "pb.com",
        "fnac.es",
        "ucsd.edu",
        "tmart.com",
        "whorush.com",
        "spicejet.com",
        "socialadr.com",
        "tutorialzine.com",
        "christianmingle.com",
        "torrentleech.org",
        "statefarm.com",
        "orkut.com",
        "whoscored.com",
        "truthaboutonlinesluts.com",
        "32red.com",
        "wp-themes.com",
        "adpost.com",
        "cnr.cn",
        "180upload.com",
        "snagajob.com",
        "textbroker.com",
        "freshome.com",
        "talkgold.com",
        "dudamobile.com",
        "weblancer.net",
        "newone.org",
        "nacion.com",
        "takepart.com",
        "voici.fr",
        "gizmodo.jp",
        "viki.com",
        "symbaloo.com",
        "topface.com",
        "businessdictionary.com",
        "adtech.info",
        "elandroidelibre.com",
        "fux.com",
        "21-sun.com",
        "cpmfx.com",
        "siemens.com",
        "edmodo.com",
        "notitarde.com",
        "babypips.com",
        "silkroad.com",
        "onextrapixel.com",
        "notdoppler.com",
        "walmart.ca",
        "marvel.com",
        "groupon.fr",
        "us1.com",
        "bunte.de",
        "findlaw.com",
        "topito.com",
        "carrefour.fr",
        "aawsat.com",
        "super.ae",
        "kicktipp.de",
        "simplyrecipes.com",
        "i-mobile.co.jp",
        "podrobnosti.ua",
        "snn.ir",
        "successfactors.com",
        "paixie.net",
        "wiwo.de",
        "glowgaze.com",
        "mapsofworld.com",
        "limetorrents.com",
        "plarium.com",
        "tvi.ua",
        "corel.com",
        "adhitprofits.com",
        "findthecompany.com",
        "noticiasaldiayalahora.co",
        "160by2.com",
        "jobberman.com",
        "rus.ec",
        "fujitsu.com",
        "ladepeche.fr",
        "pravda.sk",
        "wwtdd.com",
        "b9dm.com",
        "marathonbet.com",
        "sexlunch.com",
        "komputronik.pl",
        "gutenberg.org",
        "dizo.com.cn",
        "comunio.de",
        "naked.com",
        "gamesradar.com",
        "moneysupermarket.com",
        "cheaptickets.com",
        "assembla.com",
        "timesonline.co.uk",
        "mckinsey.com",
        "ebook3000.com",
        "videoblocks.com",
        "ruseller.com",
        "pideo.net",
        "joomlacode.org",
        "pciconcursos.com.br",
        "channelnewsasia.com",
        "cnnturk.com",
        "consultant.ru",
        "michigan.gov",
        "manoto1.com",
        "10010.com",
        "wholefoodsmarket.com",
        "globalgrind.com",
        "pichak.net",
        "morpakampus.com",
        "crazydomains.com.au",
        "uptodown.com",
        "polygon.com",
        "raspberrypi.org",
        "atmarkit.co.jp",
        "heftig.co",
        "informationweek.com",
        "trendhunter.com",
        "state.ny.us",
        "pornpros.com",
        "tnt.com",
        "sportal.bg",
        "spritzinc.com",
        "theladders.com",
        "lulu.com",
        "applesfera.com",
        "qoo10.jp",
        "notebookreview.com",
        "startertv.fr",
        "healthkart.com",
        "imgsin.com",
        "mp3olimp.net",
        "readms.com",
        "casadellibro.com",
        "nalog.ru",
        "4gamer.net",
        "jquery4u.com",
        "betfred.com",
        "3dwwwgame.com",
        "appleinsider.com",
        "dailystar.co.uk",
        "swalif.com",
        "hushmail.com",
        "worldtimebuddy.com",
        "sportschau.de",
        "mediatraffic.com",
        "gismeteo.ua",
        "record.com.mx",
        "putnik1.livejournal.com",
        "nextbigwhat.com",
        "vinescope.com",
        "jarchi.ir",
        "yidio.com",
        "dunyanews.tv",
        "hangseng.com",
        "interpark.com",
        "scholastic.com",
        "penny-arcade.com",
        "geilundlive.com",
        "budbi.com",
        "stop55.com",
        "jaidefinichon.com",
        "smartsheet.com",
        "vector.me",
        "farecompare.com",
        "vodafone.com.eg",
        "craftsy.com",
        "theresumator.com",
        "downloadab.com",
        "abendzeitung-muenchen.de",
        "dicio.com.br",
        "fobshanghai.com",
        "2dehands.be",
        "thethao247.vn",
        "cams.com",
        "gothamist.com",
        "moneynews.com",
        "zocdoc.com",
        "rol.ro",
        "nic.ar",
        "avenues.info",
        "cleverbridge.com",
        "usajobs.gov",
        "divxstage.eu",
        "jsticket.net",
        "himasoku.com",
        "thrivethemes.com",
        "orientaltrading.com",
        "premiumpress.com",
        "house365.com",
        "drugoi.livejournal.com",
        "monster.co.uk",
        "quickanddirtytips.com",
        "virtuemart.net",
        "huffpost.com",
        "real.com",
        "teacherspayteachers.com",
        "t24.com.tr",
        "zakon.kz",
        "shoppinglifestyle.com",
        "trendmicro.com",
        "surfingbird.ru",
        "cam.ac.uk",
        "navyfederal.org",
        "rateyourmusic.com",
        "bravenet.com",
        "polo.com",
        "cl.ly",
        "nanacast.com",
        "cnfol.com",
        "24option.com",
        "myscienceacademy.org",
        "getsoftfree.com",
        "cba.pl",
        "templateism.com",
        "actudesfinances.org",
        "1.254.254.254",
        "jobtalk.jp",
        "barbie.com",
        "rahnama.com",
        "gigporno.com",
        "buddypress.org",
        "corporationwiki.com",
        "enorth.com.cn",
        "thepioneerwoman.com",
        "cam4ultimate.com",
        "phpclasses.org",
        "uplus.metroer.com/~content",
        "komando.com",
        "iha.com.tr",
        "televisa.com",
        "tmtpost.com",
        "classifiedsgiant.com",
        "sportinglife.com",
        "askul.co.jp",
        "travelagency.travel",
        "jqueryscript.net",
        "rusfolder.com",
        "netcq.net",
        "irangrand.ir",
        "interaztv.com",
        "downvids.net",
        "mongodb.org",
        "nasgo.net",
        "thesitewizard.com",
        "songspk.cc",
        "travelandleisure.com",
        "d-h.st",
        "wasanga.com",
        "cgg.gov.in",
        "silverclix.com",
        "almogaz.com",
        "sexmob.es",
        "mistreci.com",
        "nukistream.com",
        "postaffiliatepro.com",
        "dish.com",
        "ulta.com",
        "worldcat.org",
        "crackle.com",
        "cineblog01.net",
        "parispornmovies.com",
        "avito.ma",
        "nethouse.ru",
        "elfinanciero.com.mx",
        "ab-in-den-urlaub.de",
        "pixeden.com",
        "thetimenow.com",
        "divar.ir",
        "coolrom.com",
        "akbank.com",
        "saturn.de",
        "dstv.com",
        "mttbsystem.com",
        "hujiang.com",
        "bash.im",
        "sextgem.com",
        "subaonet.com",
        "cnsnews.com",
        "informationng.com",
        "utoronto.ca",
        "hetzner.de",
        "vend-o.com",
        "cybozu.com",
        "autotimes.com.cn",
        "5giay.vn",
        "theepochtimes.com",
        "penesalud.com",
        "livenation.com",
        "qoinpro.com",
        "myway.com",
        "safe-swaps.com",
        "elephantjournal.com",
        "curse.com",
        "17zwd.com",
        "hitleap.com",
        "mec.gov.br",
        "freewebcams.com",
        "westelm.com",
        "imagegals.com",
        "streeteasy.com",
        "ekitan.com",
        "git-scm.com",
        "p30day.com",
        "kapaza.be",
        "svoboda.org",
        "google.mg",
        "timesofisrael.com",
        "roodo.com",
        "malwaretips.com",
        "dumpaday.com",
        "dha.com.tr",
        "diary.ru",
        "epa.gov",
        "jonloomer.com",
        "holidaylettings.co.uk",
        "oem.com.mx",
        "oxfordjournals.org",
        "3bmeteo.com",
        "iwebtool.com",
        "yinyuetai.com",
        "ixl.com",
        "rezultati.com",
        "51sole.com",
        "moudamepo.com",
        "macromill.com",
        "nzz.ch",
        "buzznet.com",
        "roku.com",
        "posta.com.tr",
        "letsbonus.com",
        "theoatmeal.com",
        "artofmanliness.com",
        "tubepornkiss.com",
        "aviny.com",
        "sabresonicweb.com",
        "tech-wd.com",
        "qbank.ru",
        "getsatisfaction.com",
        "prokerala.com",
        "ebc.com.br",
        "typiol.com",
        "photo.net",
        "rockpapershotgun.com",
        "netgear.com",
        "mg.co.za",
        "impressrd.jp",
        "jkbk.cn",
        "bakufu.jp",
        "lgmi.com",
        "tnt-online.ru",
        "frequency.com",
        "zip-codes.com",
        "sport.ro",
        "wolfram.com",
        "pgmediaserve.com",
        "icann.org",
        "twistedsifter.com",
        "mopo.de",
        "vogue.co.uk",
        "chatrandom.com",
        "checkpagerank.net",
        "colorzilla.com",
        "autobip.com",
        "laban.vn",
        "pricecheck.co.za",
        "notimex.com.mx",
        "pik.ba",
        "monster.de",
        "google.cd",
        "economia.uol.com.br",
        "vsnl.net.in",
        "futura-sciences.com",
        "appstorm.net",
        "icefilms.info",
        "dicelacancion.com",
        "hypovereinsbank.de",
        "piratestreaming.tv",
        "101domain.com",
        "google.mn",
        "rutgers.edu",
        "behindwoods.com",
        "downloadmaster.ru",
        "smartinsights.com",
        "wiziq.com",
        "ftc.gov",
        "animenewsnetwork.com",
        "tandfonline.com",
        "seagate.com",
        "famitsu.com",
        "onekingslane.com",
        "zalando.fr",
        "convio.com",
        "seochat.com",
        "qq163.com",
        "capital.gr",
        "tamin.ir",
        "phpfreaks.com",
        "cricketcountry.com",
        "ubersuggest.org",
        "ntv.co.jp",
        "olark.com",
        "1001fonts.com",
        "appsgeyser.com",
        "elsiglodetorreon.com.mx",
        "lyricsmint.com",
        "tovima.gr",
        "petco.com",
        "campograndenews.com.br",
        "amadeus.com",
        "tinychat.com",
        "astrology.com",
        "idg.se",
        "nordea.se",
        "gelbeseiten.de",
        "nrc.nl",
        "houseoffraser.co.uk",
        "hepsibahis3.com",
        "empowernetwork.com/almostasecret",
        "phpnuke.org",
        "xfwed.com",
        "gulte.com",
        "msi.com",
        "netfirms.com",
        "ovcanada.com",
        "smzdm.com",
        "wwwhatsnew.com",
        "mydomainadvisor.com",
        "newindianexpress.com",
        "luxtarget.com",
        "evz.ro",
        "otodom.pl",
        "linkin.net",
        "moneysavingmom.com",
        "uploadbaz.com",
        "egyup.com",
        "three.co.uk",
        "co-operativebank.co.uk",
        "redad.ru",
        "ipsosinteractive.com",
        "all-union.com",
        "trustlink.ru",
        "softango.com",
        "toucharcade.com",
        "tv2.dk",
        "thisissouthwales.co.uk",
        "jra.go.jp",
        "alfavita.gr",
        "ibigdan.livejournal.com",
        "gtarcade.com",
        "jc001.cn",
        "microcenter.com",
        "optimizepress.com",
        "beyebe.com",
        "muyzorras.com",
        "expedia.co.uk",
        "volvocars.com",
        "lyd.com.cn",
        "korben.info",
        "disput.az",
        "aeroflot.ru",
        "betanews.com",
        "avangard.ru",
        "wrzko.eu",
        "cakephp.org",
        "majorgeeks.com",
        "dreamteammoney.com",
        "foroactivo.com",
        "ut.ac.ir",
        "eonet.jp",
        "vn-zoom.com",
        "footytube.com",
        "expedia.de",
        "barneys.com",
        "lieyunwang.com",
        "gartner.com",
        "lazada.com.ph",
        "ourtime.com",
        "ohnotheydidnt.livejournal.com",
        "e-rewards.com",
        "updatestar.com",
        "cafef.vn",
        "cookinglight.com",
        "expressdownload.net",
        "shockmansion.com",
        "adserverpub.com",
        "ipko.pl",
        "gsa-online.de",
        "car.gr",
        "cqcounter.com",
        "thenews.com.pk",
        "gnc.com",
        "teambeachbody.com",
        "kobobooks.com",
        "cwan.com",
        "ca.com",
        "list.ly",
        "baijob.com",
        "gunbroker.com",
        "rtl.be",
        "myadvertisingpays.com",
        "mediapost.com",
        "groupalia.com",
        "anquan.org",
        "mixshowblast.com",
        "myscore.ru",
        "bancochile.cl",
        "a2hosting.com",
        "hayneedle.com",
        "myfc.ir",
        "aktifhaber.com",
        "eater.com",
        "anymeeting.com",
        "cylex.de",
        "sayidaty.net",
        "synonym.com",
        "comprendrechoisir.com",
        "prlog.ru",
        "solidtrustpay.com",
        "cinejosh.com",
        "yelp.co.uk",
        "olx.com.ar",
        "dihitt.com",
        "donkeymails.com",
        "chainreactioncycles.com",
        "wearehairy.com",
        "ebuyer.com",
        "bplans.com",
        "ponparemall.com",
        "readthedocs.org",
        "tehparadox.com",
        "source-wave.com",
        "tbs.co.jp",
        "redcoon.de",
        "francetv.fr",
        "freelogoservices.com",
        "ogone.com",
        "jeanmarcmorandini.com",
        "lasexta.com",
        "sponsoredreviews.com",
        "govome.com",
        "vecteezy.com",
        "alhayat.com",
        "cnhubei.com",
        "mumayi.com",
        "webfail.com",
        "eluniverso.com",
        "moddb.com",
        "gaiaonline.com",
        "gordonua.com",
        "liveadexchanger.com",
        "zhe800.com",
        "softonic.com.br",
        "cnyes.com",
        "cumlouder.com",
        "krakow.pl",
        "nullrefer.com",
        "zaluu.com",
        "diretube.com",
        "seattlepi.com",
        "eanswers.com",
        "gostorego.com",
        "play.com",
        "lenskart.com",
        "unblog.fr",
        "chatwork.com",
        "bronto.com",
        "jobisjob.co.in",
        "mercadolibre.com.uy",
        "overdrive.com",
        "runkeeper.com",
        "smartshopping.com",
        "getrichradio.com",
        "grader.com",
        "101greatgoals.com",
        "elbilad.net",
        "kopp-verlag.de",
        "ranksignals.com",
        "trome.pe",
        "jobstreet.com.my",
        "farnell.com",
        "fastmail.fm",
        "faithit.com",
        "blogdohotelurbano.com",
        "sencha.com",
        "daisycon.com",
        "random.org",
        "tportal.hr",
        "rkanr.com",
        "fc2-erodouga.com",
        "youngpornvideos.com",
        "bravoteens.com",
        "mobile.free.fr",
        "mitele.es",
        "edis.at",
        "questionablecontent.net",
        "indiangilma.com",
        "comunio.es",
        "bitnami.com",
        "sliptalk.com",
        "sourceforge.jp",
        "lyoness.net",
        "nespresso.com",
        "ultrafarma.com.br",
        "lik.cl",
        "jsoftj.com",
        "metoffice.gov.uk",
        "androidauthority.com",
        "360safe.com",
        "wikimart.ru",
        "tutu.ru",
        "truetwit.com",
        "xinruijunshi.com",
        "online-sweepstakes.com",
        "singaporeair.com",
        "cwtv.com",
        "politiken.dk",
        "alaan.tv",
        "tuttomercatoweb.com",
        "imagehost123.com",
        "drakensang.com",
        "frenchweb.fr",
        "syosetu.com",
        "zhifang.com",
        "viptube.com",
        "theme123.net",
        "statista.com",
        "51bi.com",
        "clickz.com",
        "kingworldnews.com",
        "qunar.com",
        "pimpandhost.com",
        "pagina12.com.ar",
        "xinmin.cn",
        "kidshealth.org",
        "pics.livejournal.com",
        "kabum.com.br",
        "anandabazar.com",
        "pnu.ac.ir",
        "scene7.com",
        "paperpkads.com",
        "mylikes.com",
        "longtailvideo.com",
        "firmy.cz",
        "bitcoinity.org",
        "inopressa.ru",
        "expat-blog.com",
        "governmentjobs.com",
        "airdroid.com",
        "mid-day.com",
        "frandroid.com",
        "webceo.com",
        "cadenaser.com",
        "minutouno.com",
        "onamae.com",
        "onlinekhabar.com",
        "williams-sonoma.com",
        "freewebsubmission.com",
        "vozforums.com",
        "bigpicture.ru",
        "mymodernmet.com",
        "presseportal.de",
        "licindia.in",
        "ismedia.jp",
        "depor.pe",
        "sing365.com",
        "v2cigs.com",
        "postimage.org",
        "gencat.cat",
        "west263.com",
        "alohatube.com",
        "eenadupratibha.net",
        "terra.com",
        "bri.co.id",
        "silktide.com",
        "anyang.gov.cn",
        "speedanalysis.com",
        "bitcoin.org",
        "toodledo.com",
        "topgear.com",
        "rtvslo.si",
        "hotpads.com",
        "nedsecure.co.za",
        "expedia.ca",
        "thairath.co.th",
        "gizbot.com",
        "naukrigulf.com",
        "guffins.com",
        "twilio.com",
        "avsforum.com",
        "sharpnews.ru",
        "inoreader.com",
        "stgeorge.com.au",
        "shoebuy.com",
        "sbwire.com",
        "bfm.ru",
        "dongtaiwang.com",
        "mandrillapp.com",
        "176.com",
        "olx.com",
        "trustpilot.co.uk",
        "tgju.org",
        "pap.fr",
        "iphonehacks.com",
        "gry-online.pl",
        "mp3xd.com",
        "viabcp.com",
        "bizcommunity.com",
        "chillingeffects.org",
        "thomasnet.com",
        "performersoft.com",
        "paymaster.ru",
        "comdotgame.com",
        "bseindia.com",
        "foodgawker.com",
        "clicktale.com",
        "dot.tk",
        "smbc-comics.com",
        "vvmembers.co",
        "c-sharpcorner.com",
        "acdcads.com",
        "goldporntube.com",
        "abakus-internet-marketing.de",
        "babbel.com",
        "fzg360.com",
        "99inf.com",
        "cduniverse.com",
        "autobild.de",
        "tvrage.com",
        "phoenix.edu",
        "hurriyetemlak.com",
        "va.gov",
        "maxmind.com",
        "lifehacker.jp",
        "nola.com",
        "niroensani.ir",
        "ihotelier.com",
        "mianbao.com",
        "powerball.com",
        "express.com",
        "freshdesignweb.com",
        "o2.co.uk",
        "utusan.com.my",
        "overclockers.ru",
        "fsiblog.com",
        "launchpad.net",
        "prizee.com",
        "alalam.ir",
        "imtalk.org",
        "vavel.com",
        "nyc.ny.us",
        "youmob.com",
        "dailythanthi.com",
        "ksu.edu.sa",
        "nlayer.net",
        "kurier.at",
        "expert-offers.com",
        "marry52.com",
        "cityads.ru",
        "darkorbit.com",
        "cio.com",
        "a9.com",
        "symfony.com",
        "crobo.com",
        "shatel.ir",
        "opposingviews.com",
        "myvoffice.com",
        "vkmag.com",
        "starpulse.com",
        "bls.gov",
        "lifebettering.com",
        "fanhuan.com",
        "upload7.ir",
        "infoplease.com",
        "suruga-ya.jp",
        "deredactie.be",
        "shangdu.com",
        "portail.free.fr",
        "smartaddons.com",
        "w3layouts.com",
        "wallstreet-online.de",
        "yapo.cl",
        "standard.co.uk",
        "atlas.sk",
        "seowizard.ru",
        "currys.co.uk",
        "nova.cz",
        "mygully.com",
        "favstar.fm",
        "themuse.com",
        "yudu.com",
        "urlopener.com",
        "ellentv.com",
        "imgsrc.ru",
        "km.ru",
        "guildwars2.com",
        "google.mu",
        "androidpit.de",
        "mrporter.com",
        "ttt4.com",
        "cbox.ws",
        "hf365.com",
        "1mobile.com",
        "punjabkesari.in",
        "msu.edu",
        "grasscity.com",
        "abduzeedo.com",
        "sublimetext.com",
        "jtb.co.jp",
        "mensxp.com",
        "myheritage.com",
        "onvasortir.com",
        "safeway.com",
        "comicvine.com",
        "cpubenchmark.net",
        "nn.ru",
        "animefreak.tv",
        "angularjs.org",
        "managewp.com",
        "ameli.fr",
        "merrjep.com",
        "christianbook.com",
        "nubiles.net",
        "klmty.net",
        "247sports.com",
        "aramex.com",
        "tubent.com",
        "cognitiveseo.com",
        "bankpasargad.com",
        "pingler.com",
        "compareja.com.br",
        "surveyzrewardcenter.eu",
        "allyes.com",
        "graaam.com",
        "poriborton.com",
        "seslisozluk.net",
        "shopyourway.com",
        "awd.ru",
        "wa.gov.au",
        "slrclub.com",
        "apollo.lv",
        "girls-ly.com",
        "totalfilm.com",
        "cam4.it",
        "gogecapital.com",
        "sketchup.com",
        "muscleandfitness.com",
        "m24.ru",
        "blinklist.com",
        "artisteer.com",
        "nettavisen.no",
        "enjin.com",
        "pc6.com",
        "citrix.com",
        "indgovtjobs.in",
        "phpbb.com",
        "laughingsquid.com",
        "fblife.com",
        "stansberryresearch.com",
        "hugefiles.net",
        "mp3monkey.net",
        "mcdonalds.com",
        "vodafone.co.uk",
        "t-mobile.de",
        "tp-link.com.cn",
        "iflscience.com",
        "nst.com.my",
        "zoom.com.br",
        "dsw.com",
        "tigerair.com",
        "doityourself.com",
        "bongdainfo.com",
        "imacros.net",
        "paperlesspost.com",
        "sprinthost.ru",
        "lovoo.net",
        "kadinlarkulubu.com",
        "championselect.net",
        "jcb.co.jp",
        "miui.com",
        "impots.gouv.fr",
        "linkshop.com.cn",
        "pando.com",
        "ckeditor.com",
        "arabylife.com",
        "ml.com",
        "sheldonsfans.com",
        "freecharge.in",
        "magicmovies.com",
        "laweekly.com",
        "highrisehq.com",
        "tr.gg",
        "vidbull.com",
        "diy.com",
        "yieldtraffic.com",
        "cima4u.com",
        "gendama.jp",
        "netpnb.com",
        "kannaway.com",
        "soft112.com",
        "die-boersenformel.com",
        "movie25.so",
        "footyroom.com",
        "dostor.org",
        "aol.de",
        "desimartini.com",
        "themeko.org",
        "danarimedia.com",
        "toroporno.com",
        "stylemepretty.com",
        "urlm.de",
        "demotivation.me",
        "gentside.com",
        "carfax.com",
        "huzhou.gov.cn",
        "hotline.ua",
        "fullmoneysystem.com",
        "pornomovies.com",
        "fsymbols.com",
        "blog.de",
        "clickpoint.com",
        "tv-asahi.co.jp",
        "flightstats.com",
        "sonico.com",
        "afamily.vn",
        "anadolu.edu.tr",
        "rs-online.com",
        "androidpit.com",
        "a-telecharger.com",
        "wikifeet.com",
        "nix.ru",
        "tvmao.com",
        "groupon.es",
        "hitfix.com",
        "weathernews.jp",
        "dig.do",
        "googledrive.com",
        "fodors.com",
        "melon.com",
        "testflightapp.com",
        "markt.de",
        "mahua.com",
        "sedo.co.uk",
        "tuenti.com",
        "comm100.com",
        "olx.co.id",
        "lefrecce.it",
        "gov.cl",
        "wplift.com",
        "unn.com.ua",
        "arizona.edu",
        "msn.com.cn",
        "k7x.com",
        "techz.vn",
        "jobomas.com",
        "extranetinvestment.com",
        "tengrinews.kz",
        "comicbookmovie.com",
        "4porn.com",
        "rubiconproject.com",
        "gametracker.com",
        "otcmarkets.com",
        "mismarcadores.com",
        "trojmiasto.pl",
        "cleverreach.com",
        "contactform7.com",
        "weloveshopping.com",
        "runnersworld.com",
        "falabella.com",
        "airtelbroadband.in",
        "twistys.com",
        "ebesucher.de",
        "belastingdienst.nl",
        "orlandosentinel.com",
        "th3professional.com",
        "duke.edu",
        "opensubtitles.us",
        "clickme.net",
        "infor.pl",
        "unesco.org",
        "socialfabric.us",
        "ename.net",
        "alternativeto.net",
        "rotahaber.com",
        "johnchow.com",
        "pervclips.com",
        "linkfeed.ru",
        "dtvideo.com",
        "kinoman.tv",
        "siteprice.org",
        "lacuerda.net",
        "amulyam.in",
        "mandghomebusiness.com",
        "infojobs.com.br",
        "hirufm.lk",
        "mybloggertricks.com",
        "athemes.com",
        "moikrug.ru",
        "fybersearch.com",
        "wine-searcher.com",
        "davidicke.com",
        "dotabuff.com",
        "sainsburys.co.uk",
        "ovaustralia.com",
        "updatesoftnow.com",
        "desarrolloweb.com",
        "elaph.com",
        "icc-cricket.com",
        "gaytube.com",
        "di.fm",
        "99wed.com",
        "c-and-a.com",
        "mlxchange.com",
        "realgfporn.com",
        "synxis.com",
        "optymalizacja.com",
        "ibtesama.com",
        "hankooki.com",
        "shiksha.com",
        "anoox.com",
        "seamless.com",
        "stripe.com",
        "ets.org",
        "fresherslive.com",
        "webcoinpay.net",
        "oscommerce.com",
        "gratisprogramas.org",
        "football365.com",
        "mkyong.com",
        "antichat.ru",
        "spamarrest.com",
        "ubc.ca",
        "36kr.com",
        "startv.in",
        "shoutcast.com",
        "heureka.sk",
        "entheosweb.com",
        "51wan.com",
        "madadsmedia.com",
        "parse.com",
        "ngacn.cc",
        "techbargains.com",
        "tvmovie.de",
        "cpmstar.com",
        "torproject.org",
        "residentadvisor.net",
        "genbeta.com",
        "hulu.jp",
        "pluralsight.com",
        "postini.com",
        "zombie.jp",
        "skimlinks.com",
        "liverail.com",
        "phys.org",
        "slashfilm.com",
        "livemaster.ru",
        "idwebgame.com",
        "pho.to",
        "dealfish.co.th",
        "s1979.com",
        "designfloat.com",
        "live365.com",
        "pbase.com",
        "eniro.se",
        "irannaz.com",
        "socialmonkee.com",
        "uidai.gov.in",
        "joomlashine.com",
        "allhyipmon.ru",
        "upbulk.com",
        "diapers.com",
        "flypgs.com",
        "hotmart.com.br",
        "globus-inter.com",
        "airfrance.fr",
        "t3.com",
        "unetepubli.com",
        "yahoo-help.jp",
        "iphones.ru",
        "95559.com.cn",
        "glamsham.com",
        "gophoto.it",
        "statmyweb.com",
        "aftermarket.pl",
        "forumotion.com",
        "iafd.com",
        "hotlog.ru",
        "drclix.com",
        "wawa-mania.ec",
        "nichepursuits.com",
        "imp.free.fr",
        "baofeng.com",
        "binsearch.info",
        "neswangy.net",
        "parperfeito.com.br",
        "theeroticreview.com",
        "sabayacafe.com",
        "maplestage.com",
        "icook.tw",
        "customerhub.net",
        "uid.me",
        "viperchill.com",
        "askfrank.net",
        "juegosjuegos.com",
        "debonairblog.com",
        "coingeneration.com",
        "onetravel.com",
        "slutroulette.com",
        "jetpack.me",
        "embedupload.com",
        "bancodevenezuela.com",
        "mysavingsmedia.net",
        "smallbiztrends.com",
        "emirates247.com",
        "bu.edu",
        "fineco.it",
        "netbarg.com",
        "gatech.edu",
        "zik.ua",
        "peliculascoco.com",
        "hkjc.com",
        "turkiyegazetesi.com.tr",
        "cooperativa.cl",
        "challenges.fr",
        "usingenglish.com",
        "vouchercodes.co.uk",
        "bonprix.de",
        "disneylatino.com",
        "townwork.net",
        "rentanything.com",
        "krypt.com",
        "wral.com",
        "globes.co.il",
        "designtaxi.com",
        "mp-success.com",
        "invisionpower.com",
        "liontravel.com",
        "classicrummy.com",
        "mt.co.kr",
        "inccel.com",
        "santander.cl",
        "afip.gov.ar",
        "yellowpages.com.au",
        "osclass.org",
        "couriermail.com.au",
        "stream.cz",
        "wizaz.pl",
        "linkresearchtools.com",
        "cam4.co.uk",
        "allafrica.com",
        "gezginler.net",
        "free-ebooks.net",
        "hopesandfears.com",
        "ticketmaster.com.mx",
        "ohio.gov",
        "liberoquotidiano.it",
        "neurs.net",
        "forumophilia.com",
        "odnako.org",
        "gamekult.com",
        "vh1.com",
        "zxart.cn",
        "mass.gov",
        "tv-tokyo.co.jp",
        "mundopromocion.com",
        "theme-junkie.com",
        "asu.edu",
        "lalibre.be",
        "pornokopilka.info",
        "fx678.com",
        "netbeans.org",
        "chinabidding.com.cn",
        "lunapic.com",
        "dramafever.com",
        "hbogo.com",
        "torrents.net",
        "woopra.com",
        "justfab.com",
        "fitnessmagazine.com",
        "tripadvisor.com.mx",
        "183.com.cn",
        "adscendmedia.com",
        "geek.com",
        "thepetitionsite.com",
        "skyscanner.ru",
        "morningpost.com.cn",
        "concursolutions.com",
        "camplace.com",
        "smarturl.it",
        "browsershots.org",
        "piktochart.com",
        "elcorreo.com",
        "collegeboard.org",
        "kasikornbank.com",
        "adsoftheworld.com",
        "fakku.net",
        "jpn.org",
        "sahafah.net",
        "rubias19.com",
        "fc2web.com",
        "redsurf.ru",
        "iproperty.com.my",
        "browsersafeguard.com",
        "mmajunkie.com",
        "bangkokbank.com",
        "ovi.com",
        "fap.to",
        "filmygyan.in",
        "edaily.vn",
        "affilorama.com",
        "valuecommerce.ne.jp",
        "softaculous.com",
        "exchanger.ru",
        "html-color-codes.info",
        "hd-xvideos.com",
        "realself.com",
        "geocaching.com",
        "mom.me",
        "stc.com.sa",
        "video-i365.com",
        "umd.edu",
        "jeffbullas.com",
        "kora.com",
        "cyberchimps.com",
        "popupads.ir",
        "chatango.com",
        "gearslutz.com",
        "fout.jp",
        "contactmusic.com",
        "linkcrypt.ws",
        "sophos.com",
        "forum-auto.com",
        "svtplay.se",
        "newsbusters.org",
        "fileswap.com",
        "phpfox.com",
        "denic.de",
        "riverisland.com",
        "encuentra24.com",
        "foxnewsinsider.com",
        "dtdc.com",
        "tayyar.org",
        "thepushbuttonmillionaire.com",
        "brokenlinkcheck.com",
        "ju51.com",
        "stihi.ru",
        "psdgraphics.com",
        "mommyfucktube.com",
        "mangocity.com",
        "routard.com",
        "whicdn.com",
        "socialtriggers.com",
        "e-bookspdf.org",
        "songspk3.in",
        "paginasamarillas.com",
        "webgame.in.th",
        "xxxdessert.com",
        "materiel.net",
        "skillshare.com",
        "tubepleasure.com",
        "paypal.de",
        "yeahmobi.com",
        "torrentz-proxy.com",
        "aircel.com",
        "openask.com",
        "trafficg.com",
        "anthem.com",
        "aleseriale.pl",
        "f-page.ru",
        "hrsmart.com",
        "cbengine.com",
        "startlap.com",
        "spamhaus.org",
        "trovit.com",
        "sporcle.com",
        "xs8.cn",
        "romwe.com",
        "powtoon.com",
        "cybozulive.com",
        "zbiornik.com",
        "cebit.de",
        "flipboard.com",
        "news.am",
        "wm-panel.com",
        "topnews.ru",
        "usp.br",
        "realmadrid.com",
        "fastdist.net",
        "unian.ua",
        "youtube.com/user/PewDiePie",
        "unc.edu",
        "tamu.edu",
        "ip2location.com",
        "americanapparel.net",
        "virtualedge.com",
        "vikatan.com",
        "goodlayers.com",
        "feedblitz.com",
        "dateinasia.com",
        "freepdfconvert.com",
        "iweb.com",
        "lachainemeteo.com",
        "aetna.com",
        "ti.com",
        "gratisjuegos.org",
        "webhostinghub.com",
        "preev.com",
        "holidayiq.com",
        "elpais.com.uy",
        "uchicago.edu",
        "telcel.com",
        "feebbo.com",
        "webhallen.com",
        "dmir.ru",
        "emailmg.ipage.com",
        "hrs.de",
        "propakistani.pk",
        "theme.co",
        "bigpara.com",
        "finishline.com",
        "fardanews.com",
        "nat.gov.tw",
        "stoloto.ru",
        "sermepa.es",
        "radaris.com",
        "softportal.com",
        "turkiye.gov.tr",
        "nnn.ru",
        "e-familynet.com",
        "wenkang.cn",
        "teamworkpm.net",
        "videohelp.com",
        "pixmania.com",
        "games.com",
        "guns.ru",
        "plus28.com",
        "pf.pl",
        "pbworks.com",
        "sedo.de",
        "freedownloadscenter.com",
        "backpackers.com.tw",
        "mycokerewards.com",
        "chinaunix.net",
        "invisionapp.com",
        "wordhippo.com",
        "unitezz.com",
        "yan.vn",
        "sonhoo.com",
        "spielaffe.de",
        "d.pr",
        "technologyreview.com",
        "democraticunderground.com",
        "molotok.ru",
        "watchever.de",
        "wdc.com",
        "torg.com",
        "ivillage.com",
        "portableapps.com",
        "ovh.es",
        "vse.kz",
        "alrajhibank.com.sa",
        "dhl-usa.com",
        "pingan.com",
        "excite.com",
        "cincodias.com",
        "marksdailyapple.com",
        "bter.com",
        "nationaljournal.com",
        "fao.org",
        "oddee.com",
        "digitalriver.com",
        "livescore.in",
        "siilu.com",
        "gofirstrowus.eu",
        "alquds.co.uk",
        "autoevolution.com",
        "zerx.ru",
        "trovit.it",
        "hvylya.org",
        "carters.com",
        "shejis.com",
        "radio-canada.ca",
        "vodafone.es",
        "sky.fm",
        "maturetube.com",
        "virtualtourist.com",
        "line25.com",
        "rzeczpospolita.pl",
        "megacurioso.com.br",
        "beliefnet.com",
        "eklablog.com",
        "hbo.com",
        "bsi.ir",
        "fastweb.it",
        "webrazzi.com",
        "telam.com.ar",
        "downloadming.me",
        "bluefly.com",
        "thewire.com",
        "erotube.org",
        "vt.edu",
        "jsbin.com",
        "ibosocial.com",
        "brides.com.cn",
        "jn.pt",
        "togetter.com",
        "olhardigital.uol.com.br",
        "ebookee.org",
        "socialgamenet.com",
        "romaniatv.net",
        "epweike.com",
        "pronto.com",
        "blog.pl",
        "top81.cn",
        "flagfox.wordpress.com",
        "unionbank.com",
        "visitkorea.or.kr",
        "blogspot.dk",
        "fermasosedi.ru",
        "inmobi.com",
        "abc.com.py",
        "iqoo.me",
        "17k.com",
        "onlineapplicationsdownloads.com",
        "komli.com",
        "tala.ir",
        "videopremium.me",
        "job.ru",
        "sunbiz.org",
        "tw116.com",
        "browserstack.com",
        "youtu.be",
        "yardbarker.com",
        "flvmplayer.com",
        "kulichki.net",
        "gravity.com",
        "levelclix.com",
        "kissanime.com",
        "insightexpressai.com",
        "colorhexa.com",
        "citizensbankonline.com",
        "hjenglish.com",
        "voeazul.com.br",
        "paraskhnio.gr",
        "es.tl",
        "busuu.com",
        "appsumo.com",
        "metacrawler.com",
        "ciku5.com",
        "android-hilfe.de",
        "laterooms.com",
        "google.com.bn",
        "gamefront.com",
        "rev2pub.com",
        "bharatiyamobile.com",
        "publicidees.com",
        "jossandmain.com",
        "babycentre.co.uk",
        "zetabux.com",
        "movieweb.com",
        "timescity.com",
        "dnevnik.ru",
        "nlcafe.hu",
        "magazine3k.com",
        "irancell.ir",
        "kalaydo.de",
        "e5.ru",
        "lecai.com",
        "sbs.com.au",
        "sierratradingpost.com",
        "girlfriendvideos.com",
        "ink361.com",
        "corporate-ir.net",
        "allgameshome.com",
        "povarenok.ru",
        "typo3.org",
        "turbosquid.com",
        "miniurls.co",
        "thinkwithgoogle.com",
        "haber3.com",
        "newsmeback.com",
        "sipse.com",
        "osxdaily.com",
        "9lessons.info",
        "cyclopaedia.net",
        "reallifecam.com",
        "gameblog.fr",
        "colourbox.com",
        "mixedmartialarts.com",
        "prostoporno.net",
        "chanel.com",
        "maxim.com",
        "cam4.es",
        "olx.com.mx",
        "newscientist.com",
        "netcombo.com.br",
        "serienjunkies.org",
        "shablol.com",
        "bnpparibasfortis.be",
        "canada.com",
        "timeslive.co.za",
        "cinematoday.jp",
        "21cineplex.com",
        "bodisparking.com",
        "cruisecritic.com",
        "vertoz.com",
        "glosbe.com",
        "nstarikov.ru",
        "epinions.com",
        "colbertnation.com",
        "marketglory.com",
        "emailmeform.com",
        "angloinfo.com",
        "filfan.com",
        "yougetsignal.com",
        "broker.to",
        "quickbux.net",
        "gottabemobile.com",
        "beyondtherack.com",
        "tripadvisor.ru",
        "jschina.com.cn",
        "registraduria.gov.co",
        "thisoldhouse.com",
        "appcelerator.com",
        "noticias24carabobo.com",
        "skelbiu.lt",
        "ru.wix.com",
        "iransong.com",
        "i-sux.com",
        "telerama.fr",
        "mydala.com",
        "pia.jp",
        "fusebux.com",
        "biquge.com",
        "microworkers.com",
        "onlywire.com",
        "fanbox.com",
        "ambitoweb.com",
        "tripadvisor.com.br",
        "postgresql.org",
        "telenet.be",
        "thegeekstuff.com",
        "primelocation.com",
        "ee.co.uk",
        "phoenixads.co.in",
        "brigitte.de",
        "360kad.com",
        "kathimerini.gr",
        "batoto.net",
        "babebuns.com",
        "webimpresion.com",
        "olx.com.ng",
        "which.co.uk",
        "f5haber.com",
        "cic.fr",
        "talkfusion.com",
        "ctrlq.org",
        "caracol.com.co",
        "wer-weiss-was.de",
        "invisionzone.com",
        "head-fi.org",
        "thingiverse.com",
        "manager-magazin.de",
        "bzwbk.pl",
        "f1news.ru",
        "tweetreach.com",
        "sj998.com",
        "streetdirectory.com",
        "asos.fr",
        "kalahari.com",
        "classiccars.com",
        "bitacoras.com",
        "bravotv.com",
        "beanfun.com",
        "bonappetit.com",
        "fashionara.com",
        "techdirt.com",
        "newlook.com",
        "iyinet.com",
        "mogujie.com",
        "carros.com.br",
        "starfall.com",
        "rp5.ru",
        "pocket-lint.com",
        "homeadvisor.com",
        "webhostbox.net",
        "cameraboys.com",
        "pricerunner.com",
        "worldcarfans.com",
        "meganovosti.net",
        "taxheaven.gr",
        "freewebsitetemplates.com",
        "mr90.ir",
        "cheapflights.co.uk",
        "bankinter.com",
        "euroresidentes.com",
        "bettycrocker.com",
        "filmey.com",
        "sheinside.com",
        "2ememain.be",
        "tu.tv",
        "kugou.com",
        "destructoid.com",
        "todoist.com",
        "karmaloop.com",
        "appadvice.com",
        "html5rocks.com",
        "osdir.com",
        "webisgreat.info",
        "dailyblogtips.com",
        "mca.gov.in",
        "e-estekhdam.com",
        "hlntv.com",
        "proprofs.com",
        "his-j.com",
        "im286.com",
        "mmorpg.com",
        "shooshtime.com",
        "terra.es",
        "lpcloudbox301.com",
        "tubepornstars.com",
        "tableausoftware.com",
        "soccersuck.com",
        "websurf.ru",
        "indiafreestuff.in",
        "pimei.com",
        "colatour.com.tw",
        "fssnet.co.in",
        "maxpark.com",
        "foodandwine.com",
        "apachefriends.org",
        "standardchartered.co.in",
        "waveapps.com",
        "gosong.net",
        "spring.me",
        "weatherbug.com",
        "iw33.com",
        "apserver.net",
        "thenationonlineng.net",
        "tjournal.ru",
        "greatschools.net",
        "3movs.com",
        "61.com",
        "directpaybiz.com",
        "w3snoop.com",
        "jsonline.com",
        "grainger.com",
        "prevention.com",
        "blizzard.com",
        "baseball-reference.com",
        "cjn.cn",
        "fasthosts.co.uk",
        "kym-cdn.com",
        "cuponation.in",
        "cam4.fr",
        "lalawan67.net",
        "videovantage.co",
        "elimparcial.com",
        "edlen24.com",
        "donya-e-eqtesad.com",
        "englishforums.com",
        "dom2.ru",
        "cinepolis.com",
        "healthtap.com",
        "astroawani.com",
        "autosport.com",
        "finalfantasyxiv.com",
        "valueclickmedia.com",
        "vitaminshoppe.com",
        "apartmentguide.com",
        "notjustok.com",
        "gratispeliculas.org",
        "intporn.com",
        "eroticbeauties.net",
        "egloos.com",
        "nujij.nl",
        "godvine.com",
        "punishtube.com",
        "wisegeek.org",
        "somuch.com",
        "taz.de",
        "zetaboards.com",
        "gravityforms.com",
        "telegraf.rs",
        "odn.ne.jp",
        "topeleven.com",
        "peekyou.com",
        "razerzone.com",
        "furaffinity.net",
        "mobikwik.com",
        "eventful.com",
        "sextube.fm",
        "treccani.it",
        "phatograph.com",
        "feedthebot.com",
        "netdoctor.co.uk",
        "collarme.com",
        "reformal.ru",
        "hemnet.se",
        "jacquieetmicheltv.net",
        "9ku.com",
        "kraloyun.com",
        "directadmin.com",
        "bongda.com.vn",
        "ddizi.org",
        "tedata.net",
        "fb.org",
        "pagemodo.com",
        "satu.kz",
        "nodejs.org",
        "tiberiumalliances.com",
        "wallst.com",
        "dezeen.com",
        "rense.com",
        "hawkhost.com",
        "vonage.com",
        "zjol.com.cn",
        "housefun.com.tw",
        "ad1.ru",
        "myredbook.com",
        "rarlab.com",
        "audiopoisk.com",
        "pbebank.com",
        "whocallsme.com",
        "playground.ru",
        "tnr.com",
        "firstdirect.com",
        "xinhua.jp",
        "gmane.org",
        "verseriesynovelas.com",
        "broadwayworld.com",
        "thefrisky.com",
        "rapmls.com",
        "skapiec.pl",
        "wholesale-dress.net",
        "alison.com",
        "n4hr.com",
        "prefiles.com",
        "vtc.vn",
        "coral.co.uk",
        "azyya.com",
        "smithsonianmag.com",
        "ticksy.com",
        "theync.com",
        "pcinpact.com",
        "eventbrite.co.uk",
        "buenosaires.gob.ar",
        "a5cee7.se",
        "bazingamob.com",
        "pp.cc",
        "shortnews.de",
        "responsinator.com",
        "filepost.com",
        "securefreedom.com",
        "notepad-plus-plus.org",
        "thekrazycouponlady.com",
        "apktops.ir",
        "nr2.ru",
        "timinternet.it",
        "man.lv",
        "forexpeacearmy.com",
        "plius.lt",
        "vcp.ir",
        "mysitecost.ru",
        "yourfiledownloader.com",
        "dealguardian.com",
        "sql.ru",
        "laravel.com",
        "shape5.com",
        "visa.com",
        "vocus.com",
        "stackthatmoney.com",
        "pornicom.com",
        "my.tv.sohu.com/user/cc128",
        "urban-rivals.com",
        "robotstxt.org",
        "colorlabsproject.com",
        "mg.gov.br",
        "local.ch",
        "adbooth.net",
        "se.pl",
        "al-akhbar.com",
        "he.net",
        "covoiturage.fr",
        "sakshieducation.com",
        "thisdaylive.com",
        "thestudentroom.co.uk",
        "pzy.be",
        "designyoutrust.com",
        "forbes.ua",
        "fandongxi.com",
        "expertreviews.co.uk",
        "dream-demo.com",
        "barchart.com",
        "ht.ly",
        "burbuja.info",
        "edgecastcdn.net",
        "amazinglytimedphotos.com",
        "value-domain.com",
        "shareaholic.com",
        "promptfile.com",
        "voetbalzone.nl",
        "ziare.com",
        "trafficbroker.com",
        "coolsport.tv",
        "vanguardia.com.mx",
        "makeshop.jp",
        "mobilism.org",
        "rebelmouse.com",
        "brisbanetimes.com.au",
        "publimetro.com.mx",
        "coolkora.com",
        "realsparrow.com",
        "honda.co.jp",
        "dealcatcher.com",
        "sinoptik.ua",
        "lefeng.com",
        "mamaclub.com",
        "bezuzyteczna.pl",
        "smn.gov.ar",
        "manhub.com",
        "pcgameshardware.de",
        "shipstation.com",
        "zive.cz",
        "disneystore.com",
        "despegar.com.mx",
        "addictivetips.com",
        "path.com",
        "pathofexile.com",
        "seitenreport.de",
        "pardot.com",
        "decathlon.fr",
        "flvrunner.com",
        "xat.com",
        "matchendirect.fr",
        "roem.ru",
        "wat.tv",
        "edline.net",
        "znds.com",
        "northwestern.edu",
        "friendscout24.de",
        "movoto.com",
        "dengiprosto.info",
        "dlisted.com",
        "sports.fr",
        "maxifoot.fr",
        "hubspot.net",
        "natalie.mu",
        "tabloidpulsa.co.id",
        "polki.pl",
        "gamasutra.com",
        "matomeantena.com",
        "adwords-community.com",
        "gallup.com",
        "redtubenacional.com",
        "mangastream.com",
        "zulutrade.com",
        "wunderlist.com",
        "taste.com.au",
        "myhosting.com",
        "totalbeauty.com",
        "8pic.ir",
        "sltrib.com",
        "88db.com",
        "minikoyuncu.com",
        "net4.in",
        "nuevoloquo.com",
        "cago365.com",
        "afip.gob.ar",
        "keep2share.cc",
        "kw.com",
        "terra.com.pe",
        "profi-forex.org",
        "filecloud.io",
        "peliculas4.com",
        "mysitemyway.com",
        "ilmattino.it",
        "geizhals.de",
        "sheershanews.com",
        "whatwpthemeisthat.com",
        "teknosa.com",
        "myshopping.com.au",
        "teamskeet.com",
        "gandalfporn.com",
        "2670.com",
        "peoplefinders.com",
        "elo7.com.br",
        "sofoot.com",
        "uhaul.com",
        "sagepay.com",
        "unb.br",
        "jhu.edu",
        "barrons.com",
        "hasznaltauto.hu",
        "winfxstrategy.com",
        "spamcop.net",
        "az.pl",
        "op.fi",
        "istruzione.it",
        "eveonline.com",
        "imgnip.com",
        "jjoobb.cn",
        "itesm.mx",
        "wptavern.com",
        "kproxy.com",
        "pulptastic.com",
        "quidco.com",
        "ekantipur.com",
        "joann.com",
        "whattoexpect.com",
        "tomshw.it",
        "internetbookshop.it",
        "followerwonk.com",
        "cisionpoint.com",
        "cint.com",
        "quondos.com",
        "suntimes.com",
        "saveinter.net",
        "eiga.com",
        "jdzj.com",
        "goldprice.org",
        "websitemagazine.com",
        "051jk.com",
        "inweb24.com",
        "gamgos.ae",
        "elog-ch.com",
        "trovit.com.mx",
        "webnode.cz",
        "ethnos.gr",
        "oodle.com",
        "subtitulos.es",
        "gameinformer.com",
        "9to5mac.com",
        "youwatch.org",
        "ibps.in",
        "biggerpockets.com",
        "sport24.co.za",
        "my.tv.sohu.com/user/cc133",
        "capsulecrm.com",
        "fuett.mx",
        "poznan.pl",
        "melateiran.com",
        "divxtotal.com",
        "aftabir.com",
        "cyberlink.com",
        "ulozto.cz",
        "jetswap.com",
        "premium.wix.com",
        "eprize.com",
        "huntington.com",
        "careerlink.vn",
        "allhyipmonitors.com",
        "autorambler.ru",
        "jamieoliver.com",
        "minube.com",
        "credomatic.com",
        "oddschecker.com",
        "listia.com",
        "mrrebates.com",
        "8684.cn",
        "kabam.com",
        "tripit.com",
        "gry.pl",
        "ecvv.com",
        "utanbaby.com",
        "lavoixdunord.fr",
        "just-eat.co.uk",
        "go-for-files.com",
        "afpbb.com",
        "mybb.com",
        "madmoizelle.com",
        "sensacine.com",
        "jtl-software.de",
        "worldtimeserver.com",
        "sunmaker.com",
        "marieforleo.com",
        "123sdfsdfsdfsd.ru",
        "duga.jp",
        "avery.com",
        "tvguide.co.uk",
        "salliemae.com",
        "zap.com.br",
        "my.tv.sohu.com/user/cc112",
        "bookmark4you.com",
        "twodollarclick.com",
        "encontreinarede.com",
        "joomshaper.com",
        "marinetraffic.com",
        "feedermatrix.com",
        "nowvideo.at",
        "millenium.org",
        "newalbumreleases.net",
        "frankkern.com",
        "onlineconversion.com",
        "ahlalhdeeth.com",
        "mediawiki.org",
        "xseo.in",
        "generation-nt.com",
        "naftemporiki.gr",
        "hardforum.com",
        "hornbunny.com",
        "my.tv.sohu.com/user/cc124",
        "housing.com",
        "vogue.es",
        "safemls.net",
        "cuisineaz.com",
        "estekhtam.com",
        "coqnu.com",
        "despegar.com.ar",
        "fedoraproject.org",
        "france2.fr",
        "autovit.ro",
        "tradetang.com",
        "levelupgames.uol.com.br",
        "dnforum.com",
        "homebank.kz",
        "carnival.com",
        "hzycsj.com",
        "army.mil",
        "bootsnipp.com",
        "istockimg.com",
        "po-kaki-to.com",
        "qiushibaike.com",
        "tsb.co.uk",
        "gzmama.com",
        "aitnews.com",
        "tripwiremagazine.com",
        "torrenty.org",
        "djangoproject.com",
        "chelseafc.com",
        "gamesgames.com",
        "herold.at",
        "baur.de",
        "kauppalehti.fi",
        "nrelate.com",
        "clickwebinar.com",
        "entropay.com",
        "gridserver.com",
        "virginia.gov",
        "tuan800.com",
        "trueactivist.com",
        "caras.uol.com.br",
        "fontawesome.io",
        "haodou.com",
        "reshareworthy.com",
        "royalcaribbean.com",
        "crakrevenue.com",
        "motika.com.mk",
        "xovi.de",
        "deutsche-startups.de",
        "inven.co.kr",
        "atrapalo.com",
        "ictv.ua",
        "muji.net",
        "kingplayer.com",
        "adworkmedia.com",
        "xjtu.edu.cn",
        "thenounproject.com",
        "professionali.ru",
        "xizhi.com",
        "boo-box.com",
        "customink.com",
        "groupon.my",
        "spartoo.com",
        "bannersdontwork.com",
        "ncore.cc",
        "reklama5.mk",
        "macrojuegos.com",
        "zenhabits.net",
        "te3p.com",
        "utah.gov",
        "telesurtv.net",
        "101.ru",
        "5yi.com",
        "lide.cz",
        "ancestry.co.uk",
        "sana.sy",
        "siteslike.com",
        "vg247.com",
        "tyzhden.ua",
        "ncsu.edu",
        "apherald.com",
        "taaza.com",
        "traffic-delivery.com",
        "uuyoyo.com",
        "hwupgrade.it",
        "game-debate.com",
        "jetpack.wordpress.com",
        "anycodes.com",
        "femina.hu",
        "zattoo.com",
        "acm.org",
        "comenity.net",
        "tarot.com",
        "azadliq.org",
        "advertiserdigital.com",
        "osym.gov.tr",
        "empornium.me",
        "netzero.net",
        "myfico.com",
        "nolix.ru",
        "cnwnews.com",
        "springpad.com",
        "ahangestan.in",
        "localbitcoins.com",
        "nikkei.co.jp",
        "youlikehits.com",
        "boyfriendtv.com",
        "wampserver.com",
        "elnorte.com",
        "codeschool.com",
        "si.edu",
        "nosis.com",
        "downloadhelper.net",
        "global-free-classified-ads.com",
        "flagmantube.com",
        "elnuevodiario.com.ni",
        "handelsbanken.se",
        "sverigesradio.se",
        "femjoy.com",
        "444.hu",
        "calcalist.co.il",
        "asiatech.ir",
        "tv.nu",
        "installmac.com",
        "programmableweb.com",
        "fotki.com",
        "vidivodo.com",
        "websquash.com",
        "selfgrowth.com",
        "wehkamp.nl",
        "amawebs.com",
        "3dlat.com",
        "comunidades.net",
        "streamin.to",
        "idbi.com",
        "cshtracker.com",
        "cdbaby.com",
        "mycommerce.com",
        "united-domains.de",
        "tradingview.com",
        "niniweblog.com",
        "avn.info.ve",
        "apa.tv",
        "pinnaclesports.com",
        "adafruit.com",
        "ipower.com",
        "lebuteur.com",
        "utah.edu",
        "mobeoffice.com",
        "lingualeo.com",
        "fuub.net",
        "tvmongol.com",
        "namasthetelangaana.com",
        "secretsearchenginelabs.com",
        "whowhatwear.com",
        "hiapk.com",
        "torrentz.sx",
        "php.su",
        "sodahead.com",
        "sbb.ch",
        "k12.ca.us",
        "jecontacte.com",
        "thehollywoodgossip.com",
        "pekao24.pl",
        "yourtest-india.com",
        "screwfix.com",
        "humoron.com",
        "yiwugou.com",
        "mulher.uol.com.br",
        "thehackernews.com",
        "shopmania.ro",
        "dlink.com",
        "despegar.com",
        "archlinux.org",
        "nielsen.com",
        "rosnet.ru",
        "appsapk.com",
        "funfarsi.ir",
        "4over.com",
        "subscribe.wordpress.com",
        "lewrockwell.com",
        "portalnet.cl",
        "antenam.info",
        "letribunaldunet.fr",
        "see-tube.com",
        "tureng.com",
        "topcashback.co.uk",
        "contactcars.com",
        "jeux.fr",
        "khan.co.kr",
        "ffffound.com",
        "gmail.com",
        "laprensa.com.ni",
        "jizzhut.com",
        "liilas.com",
        "muare.vn",
        "kting.cn",
        "heteml.jp",
        "genericsteps.com",
        "searchcompletion.com",
        "dwayir.com",
        "dicionarioinformal.com.br",
        "vcita.com",
        "fitsugar.com",
        "kleiderkreisel.de",
        "collective-evolution.com",
        "ethz.ch",
        "sendreach.com",
        "abidjan.net",
        "islamicfinder.org",
        "elong.com",
        "yonhapnews.co.kr",
        "seratnews.ir",
        "stream2watch.me",
        "content-watch.ru",
        "seotechnocrat.com",
        "todaoferta.uol.com.br",
        "toyota.jp",
        "purevid.com",
        "incredimail.com",
        "kia.com",
        "intensedebate.com",
        "kaufmich.com",
        "servis24.cz",
        "brusheezy.com",
        "rtbtraf.com",
        "tejiawang.com",
        "expedia.co.in",
        "food52.com",
        "top-channel.tv",
        "jpnn.com",
        "desitorrents.com",
        "faxingw.cn",
        "crutchfield.com",
        "seneweb.com",
        "usenet.nl",
        "aviasales.ru",
        "nesine.com",
        "appshopper.com",
        "dressupgamesite.com",
        "lowendtalk.com",
        "muslima.com",
        "v-webs.com",
        "linkomanija.net",
        "geniuzz.com",
        "caringbridge.org",
        "gooya.com",
        "dospy.com",
        "siol.net",
        "games.co.id",
        "archiveofourown.org",
        "rocketlawyer.com",
        "free-downloadz.net",
        "pastemagazine.com",
        "invest-system.net",
        "el-ahly.com",
        "todayhumor.co.kr",
        "racingpost.com",
        "stereogum.com",
        "soompi.com",
        "pof.com.br",
        "brainabundance.com",
        "fontpalace.com",
        "canon.jp",
        "eldeforma.com",
        "sacbee.com",
        "jobscore.com",
        "fashionista.com",
        "mywork.vn",
        "thisis50.com",
        "cubadebate.cu",
        "healthguru.com",
        "instatheme.com",
        "apotheken-umschau.de",
        "blizko.ru",
        "tinymce.com",
        "virtualbox.org",
        "tehran.ir",
        "pr.gov.br",
        "mlmleadsystempro.com",
        "resbux.com",
        "komonews.com",
        "childrensplace.com",
        "yoyopress.com",
        "cloudify.cc",
        "24livenewspaper.com",
        "w4.com",
        "islamway.net",
        "fantagazzetta.com",
        "imgspice.com",
        "bovada.lv",
        "payback.de",
        "peb.pl",
        "hotnigerianjobs.com",
        "dev7studios.com",
        "tejaratbank.net",
        "takuhai.jp",
        "travelmath.com",
        "cultofmac.com",
        "wakeupnow.com",
        "insidefacebook.com",
        "mediamarkt.es",
        "500wan.com",
        "rumah123.com",
        "contentmarketinginstitute.com",
        "ed.ac.uk",
        "phimvang.com",
        "womansday.com",
        "lookatme.ru",
        "citizensbank.com",
        "esam.ir",
        "phandroid.com",
        "canadiantire.ca",
        "serienjunkies.de",
        "bbspink.com",
        "yaranehkala.ir",
        "vesti.bg",
        "el-carabobeno.com",
        "smarty.net",
        "6tie.com",
        "antpedia.com",
        "p-world.co.jp",
        "camelcamelcamel.com",
        "sudu.cn",
        "priberam.pt",
        "infoworld.com",
        "myrecipes.com",
        "metrodeal.com",
        "widgetbox.com",
        "krone.at",
        "outfox.tv",
        "mymp4.in",
        "685wo.com",
        "sadanduseless.com",
        "cgd.pt",
        "mrmlsmatrix.com",
        "parenting.com",
        "tradepub.com",
        "linkvehicle.com",
        "mobiledia.com",
        "rghost.ru",
        "xxsy.net",
        "goanimate.com",
        "pikacn.com",
        "metropcs.com",
        "byu.edu",
        "bitelia.com",
        "designscrazed.com",
        "wpde.org",
        "paheal.net",
        "nulled.cc",
        "hmv.co.jp",
        "openx.com",
        "hyundai.com",
        "vvvdj.com",
        "reason.com",
        "livesports.pl",
        "polskieradio.pl",
        "oszone.net",
        "chinhphu.vn",
        "performancehorizon.com",
        "internetretailer.com",
        "skoob.com.br",
        "mediaworld.it",
        "imgrind.com",
        "bancopopular.es",
        "seogadget.ru",
        "m6.fr",
        "rongbay.com",
        "niazpardaz.com",
        "rewity.com",
        "ssense.com",
        "sky-fire.com",
        "flibusta.net",
        "eat24hours.com",
        "lotto.pl",
        "cnw.com.cn",
        "takvim.com.tr",
        "englishtown.com",
        "letudiant.fr",
        "peliculasmas.com",
        "askme.com",
        "linksmanagement.com",
        "webseoanalytics.com",
        "presse-citron.net",
        "eldiariodeamerica.com",
        "instantshift.com",
        "ampxchange.com",
        "xe.gr",
        "experts-exchange.com",
        "sportcategory.com",
        "sharecash.org",
        "linksys.com",
        "yninfo.com",
        "onlinelic.in",
        "aflamneek.com",
        "22.cn",
        "ubuntu-fr.org",
        "cjs.com.cn",
        "mp3clan.com",
        "grani.ru",
        "zen-cart.com",
        "shippingchina.com",
        "jsfor.net",
        "wanadoo.es",
        "zurker.com",
        "chotot.vn",
        "masaladesi.com",
        "insight.ly",
        "trivago.de",
        "neue-sexpartner.com",
        "boe.es",
        "military.com",
        "moonbasa.com",
        "langlaoda.com",
        "tnooz.com",
        "zacks.com",
        "liverpool.com.mx",
        "internic.net",
        "ecuavisa.com",
        "autonews.ru",
        "mcafeesecure.com",
        "peopleclick.com",
        "madthumbs.com",
        "hot-live-chat.com",
        "sugarcrm.com",
        "notonthehighstreet.com",
        "linio.com.co",
        "smartbrief.com",
        "auto-motor-und-sport.de",
        "kyivpost.com",
        "instantteleseminar.com",
        "dillards.com",
        "5i5j.com",
        "runtastic.com",
        "danawa.com",
        "ladunliadi.blogspot.com",
        "getnews.jp",
        "romedic.ro",
        "rodfile.com",
        "instyle.com",
        "swoodoo.com",
        "bannersnack.com",
        "evolife.cn",
        "ktonanovenkogo.ru",
        "office.com",
        "zamalekfans.com",
        "magiran.com",
        "ithome.com",
        "ktrmr.com",
        "spoonful.com",
        "olleh.com",
        "bgr.in",
        "industrialthemes.com",
        "adbkm.com",
        "tsa-algerie.com",
        "bloggang.com",
        "mojang.com",
        "geoiptool.com",
        "autocarindia.com",
        "ajansspor.com",
        "onmeda.de",
        "midwayusa.com",
        "alicdn.com",
        "sportdog.gr",
        "ideeli.com",
        "haspa.de",
        "gladbux.com",
        "porn-star.com",
        "experiandirect.com",
        "yicheshi.com",
        "acervoamador.com",
        "designwall.com",
        "balkanweb.com",
        "response.jp",
        "nettoos.com",
        "beruby.com",
        "manageyourloans.com",
        "kidstaff.com.ua",
        "indeed.co.za",
        "monoprice.com",
        "chsi.com.cn",
        "boorsekala.com",
        "mstaml.com",
        "trafficvance.com",
        "tatatele.in",
        "startbootstrap.com",
        "graphicburger.com",
        "ad-vid-webs.com",
        "jp.dk",
        "one.co.il",
        "athensvoice.gr",
        "payu2blog.com",
        "epidemz.net",
        "dondominio.com",
        "doviz.com",
        "disquscdn.com",
        "work.ua",
        "vsemayki.ru",
        "ikyu.com",
        "songlyrics.com",
        "onlinebank.com",
        "thebump.com",
        "travian.com.tr",
        "java2s.com",
        "twittmate.com",
        "ignou.ac.in",
        "relink.us",
        "4738.com",
        "printvenue.com",
        "tekstowo.pl",
        "natro.com",
        "dengi-tut.info",
        "freeservers.com",
        "inbound.org",
        "free-press-release.com",
        "mydirtyhobby.com",
        "gamefly.com",
        "overclockers.co.uk",
        "eci.nic.in",
        "196.1.211.6",
        "versus.com",
        "batdongsan.com.vn",
        "vrisko.gr",
        "albayan.ae",
        "trendcounter.com",
        "500.com",
        "pagomiscuentas.com",
        "wankoz.com",
        "duote.com",
        "javascript.ru",
        "chevrolet.com",
        "coach.com",
        "decidatriunfar.net",
        "rememberthemilk.com",
        "virginmobileusa.com",
        "google.com.jm",
        "ucm.es",
        "ninja.co.jp",
        "rqzao.com",
        "periodistadigital.com",
        "heritage.org",
        "momtubesex.xxx",
        "vocabulary.com",
        "kupujemprodajem.com",
        "e-cigarette-forum.com",
        "paxum.com",
        "ilpost.it",
        "abercrombie.com",
        "pearsonmylabandmastering.com",
        "echoecho.com",
        "expedia.co.jp",
        "ticketfly.com",
        "colostate.edu",
        "sjtu.edu.cn",
        "seobudget.ru",
        "gigabyte.com",
        "gsmspain.com",
        "misr5.com",
        "enterfactory.com",
        "ciao.de",
        "wuv.de",
        "dagospia.com",
        "slashgear.com",
        "urdupoint.com",
        "themepunch.com",
        "travian.com",
        "discuz.com",
        "pixroute.com",
        "otzovik.com",
        "ubergizmo.com",
        "edreams.fr",
        "internet-positif.org",
        "asmcentral.com",
        "copadomundo.uol.com.br",
        "adjal.com",
        "gotomypc.com",
        "partycity.com",
        "leggo.it",
        "blogosfere.it",
        "teamcoco.com",
        "pricedealsindia.com",
        "glennbeck.com",
        "allyou.com",
        "china.org.cn",
        "xitek.com",
        "photoshopessentials.com",
        "infopraca.pl",
        "boardingarea.com",
        "geni.com",
        "rotaban.ru",
        "foxtab.com",
        "sadistic.pl",
        "socialbro.com",
        "tradesparq.com",
        "itp.ne.jp",
        "swefilmer.com",
        "jobsite.co.uk",
        "topwar.ru",
        "yemeksepeti.com",
        "tokfm.pl",
        "businessinsider.com.au",
        "moe.gov.eg",
        "swedbank.lt",
        "jxgdw.com",
        "bayern.de",
        "alistapart.com",
        "bebinin.com",
        "annunci69.it",
        "plimus.com",
        "cuevana2.tv",
        "viamichelin.fr",
        "whatsmydns.net",
        "tarad.com",
        "hostgator.com.br",
        "hasbro.com",
        "hi-chic.com",
        "driverscollection.com",
        "onetad.com",
        "game2.com.cn",
        "elitepvpers.com",
        "tvuol.uol.com.br",
        "caclubindia.com",
        "diariocorreo.pe",
        "c-rewards.com",
        "business.gov.au",
        "chooseauto.com.cn",
        "timetrade.com",
        "alternate.de",
        "syracuse.com",
        "advanceautoparts.com",
        "shopware.de",
        "newpct.com",
        "proranktracker.com",
        "cex.io",
        "thebot.net",
        "tradekorea.com",
        "legifrance.gouv.fr",
        "cpan.org",
        "rightel.ir",
        "247wallst.com",
        "goldentowns.com",
        "bankifsccode.com",
        "color-hex.com",
        "consumerist.com",
        "juegosdiarios.com",
        "on24.com",
        "stockfreeimages.com",
        "m4.cn",
        "sponsoredtweets.com",
        "open.ac.uk",
        "bilyoner.com",
        "lexisnexis.com",
        "gsu.edu",
        "popscreen.com",
        "stiftung-warentest.de",
        "education.com",
        "leckerficken.de",
        "hostinger.ru",
        "staples.ca",
        "greenpeace.org",
        "mes-meilleurs-films.fr",
        "delish.com",
        "register.it",
        "idiva.com",
        "static.squarespace.com",
        "ololo.fm",
        "basketball-reference.com",
        "tro-ma-ktiko.blogspot.gr",
        "arabianbusiness.com",
        "avianca.com",
        "watchuseek.com",
        "6play.fr",
        "kora-online.tv",
        "armagedomfilmes.biz",
        "531314.com",
        "craigslist.co.uk",
        "inchallah.com",
        "bongdaso.com",
        "toprankblog.com",
        "k12.com",
        "itimes.com",
        "html.net",
        "utsandiego.com",
        "gyakorikerdesek.hu",
        "viddyhddownload.com",
        "wannonce.com",
        "qudong.com",
        "ibicn.com",
        "w3resource.com",
        "socialsecurity.gov",
        "tvn.pl",
        "momsexclipz.com",
        "fstoppers.com",
        "kafeteria.pl",
        "boulanger.fr",
        "guj.nic.in",
        "divaina.com",
        "desktopnexus.com",
        "topseda.ir",
        "payumoney.com",
        "klicktel.de",
        "foxtv.es",
        "cuatro.com",
        "publix.com",
        "astrosage.com",
        "kompass.com",
        "web-hosting.com",
        "nus.edu.sg",
        "jamiiforums.com",
        "lancers.jp",
        "peixeurbano.com.br",
        "buysub.com",
        "yp.com",
        "enstage.com",
        "6eat.com",
        "1ent.com.cn",
        "unionpaysecure.com",
        "pcgames.de",
        "ccidcom.com",
        "lavenir.net",
        "novaposhta.ua",
        "hotpornshow.com",
        "telebank.ru",
        "avaz.ba",
        "doit.com.cn",
        "setlinks.ru",
        "zagat.com",
        "sportmaster.ru",
        "utarget.ru",
        "lingualeo.ru",
        "compucalitv.com",
        "anastasiadate.com",
        "webmaster-rank.info",
        "fastcoexist.com",
        "lavasoft.com",
        "ppvguru.com",
        "greatist.com",
        "knack.be",
        "wowwiki.com",
        "ilcorsaronero.info",
        "jword.jp",
        "750g.com",
        "pantipmarket.com",
        "top.de",
        "photofunia.com",
        "dryicons.com",
        "alweeam.com.sa",
        "dnfight.com",
        "wpolityce.pl",
        "vimeocdn.com",
        "visit-x.net",
        "takungpao.com",
        "perfectworld.eu",
        "kat.ph",
        "hefei.cc",
        "cmse.ru",
        "virginia.edu",
        "fudan.edu.cn",
        "sethgodin.typepad.com",
        "caracaschronicles.com",
        "18qt.com",
        "be2.com.br",
        "rakuten.tw",
        "bukkit.org",
        "miss-no1.com",
        "nts.org.pk",
        "ulozto.net",
        "mixpanel.com",
        "glavred.info",
        "vui.vn",
        "mindspark.com",
        "worldmarket.com",
        "walmart.com.mx",
        "deperu.com",
        "taxact.com",
        "m5zn.com",
        "navy.mil",
        "hibapress.com",
        "cpasbien.com",
        "interjet.com.mx",
        "llbean.com",
        "kenrockwell.com",
        "japan-guide.com",
        "financialpost.com",
        "rankingsinstitute.com",
        "master-x.com",
        "pandawill.com",
        "marketingweek.co.uk",
        "freeforums.org",
        "ysear.ch",
        "pokerstars.com",
        "wired.co.uk",
        "amino.dk",
        "rapidcrush.com",
        "vivanuncios.com",
        "blogsvertise.com",
        "cwb.gov.tw",
        "piter.tv",
        "gistmania.com",
        "topdocumentaryfilms.com",
        "shoghlanty.com",
        "bankmillennium.pl",
        "burberry.com",
        "youporngay.com",
        "webresourcesdepot.com",
        "beachbody.com",
        "asstr.org",
        "pwc.com",
        "competitor.com",
        "rss2search.com",
        "vocuspr.com",
        "behindthename.com",
        "moniker.com",
        "jayde.com",
        "opensuse.org",
        "poemhunter.com",
        "toranoana.jp",
        "interaksyon.com",
        "aeon.co.jp",
        "gungho.jp",
        "fgov.be",
        "xpg.uol.com.br",
        "logic-immo.com",
        "worldsex.com",
        "watchonlineseries.eu",
        "google.co.mz",
        "discas.net",
        "chmail.ir",
        "consumercomplaints.in",
        "allstate.com",
        "twelveskip.com",
        "ibibo.com",
        "noelshack.com",
        "bonprix.ru",
        "directupload.net",
        "equipobimlatino.com",
        "weather2umbrella.com",
        "aibang.com",
        "blog.wordpress.com",
        "turner.com",
        "mediapart.fr",
        "bloog.pl",
        "monotaro.com",
        "online.net",
        "bodmillenium.com",
        "distancesfrom.com",
        "naosalvo.com.br",
        "ap7am.com",
        "focus.ua",
        "cokeandpopcorn.ch",
        "qwant.com",
        "megaplan.ru",
        "sinhvienit.net",
        "dream-marriage.com",
        "voicefive.com",
        "forex.com.cn",
        "xabbs.com",
        "netmums.com",
        "tuxboard.com",
        "cs-cart.com",
        "bitcoin.it",
        "boblil.com",
        "nirsoft.net",
        "neopets.com",
        "spin.com",
        "costco.ca",
        "mirraw.com",
        "ara.cat",
        "klamm.de",
        "glam.com",
        "guenstiger.de",
        "citruspay.com",
        "dnslink.com",
        "guyism.com",
        "shopotam.ru",
        "tim.it",
        "3suisses.fr",
        "gooroops.com",
        "kau.edu.sa",
        "ukbusinessforums.co.uk",
        "gree.jp",
        "komikid.com",
        "redakcja.pl",
        "qpic.cn",
        "voyeurweb.com",
        "mathworks.com",
        "monster.fr",
        "seniat.gob.ve",
        "computrabajo.com.co",
        "xilu.com",
        "madrid.org",
        "ostraining.com",
        "bharian.com.my",
        "telegram.org",
        "sumofus.org",
        "whosdatedwho.com",
        "moreofit.com",
        "meetic.it",
        "femina.mk",
        "itworld.com",
        "indiaglitz.com",
        "cheatcc.com",
        "filmfanatic.com",
        "the-bux.net",
        "very.co.uk",
        "fetishshrine.com",
        "speakingtree.in",
        "iu.edu",
        "modern.az",
        "tak.ru",
        "internetmarketingninjas.com",
        "example.com",
        "sportgeza.hu",
        "wrestlezone.com",
        "jameda.de",
        "caikuu.com",
        "gioco.it",
        "yourtv.com.au",
        "euro.com.pl",
        "anz.co.nz",
        "daft.ie",
        "tirerack.com",
        "vivareal.com.br",
        "definebabe.com",
        "ittefaq.com.bd",
        "lastfm.es",
        "zocalo.com.mx",
        "dpd.de",
        "somethingawful.com",
        "virgin.com",
        "shtyle.fm",
        "viralforest.com",
        "dntrck.com",
        "its-mo.com",
        "q.cc",
        "kinghost.net",
        "elpais.com.co",
        "joomlaspanish.org",
        "sopitas.com",
        "wallbase.cc",
        "cpalead.com",
        "torrentfunk.com",
        "bizcom.com.ru",
        "quizony.com",
        "rcgroups.com",
        "spring.io",
        "kuaidi100.com",
        "xatakandroid.com",
        "mlstatic.com",
        "borsaat.com",
        "jagobd.com",
        "cosmiq.de",
        "crucial.com",
        "cdstm.cn",
        "betclic.fr",
        "telewebion.com",
        "exhentai.org",
        "gnezdo.ru",
        "cebupacificair.com",
        "fusionmls.com",
        "shafaf.ir",
        "ticketmaster.co.uk",
        "adslzone.net",
        "k8.cn",
        "recipdonor.com",
        "in.gov",
        "mforos.com",
        "asscj.com",
        "linkconnector.com",
        "ohfreesex.com",
        "cntraveler.com",
        "scambioetico.org",
        "ladenzeile.de",
        "ntn24.com",
        "beyazperde.com",
        "motherearthnews.com",
        "yupptv.com",
        "220tube.com",
        "fizzle.co",
        "lakii.com",
        "deutsche-wirtschafts-nachrichten.de",
        "saaid.net",
        "bimlatino.com",
        "verisign.com",
        "funpatogh.com",
        "matadornetwork.com",
        "seatguru.com",
        "lululemon.com",
        "uzise.com",
        "networkworld.com",
        "hottube.me",
        "jobsdb.com.hk",
        "life.hu",
        "bonusvid.com",
        "incometaxindiaefiling.gov.in",
        "ey.com",
        "alraimedia.com",
        "allposters.com",
        "authorityroi.com",
        "bmwusa.com",
        "ebaystatic.com",
        "entertainmentcrave.com",
        "ehow.com.br",
        "prisonplanet.com",
        "elnashra.com",
        "email.cz",
        "yes123.com.tw",
        "uitzendinggemist.nl",
        "mindtools.com",
        "atv.com.tr",
        "shoes.net.cn",
        "joomlaportal.de",
        "themoneyconverter.com",
        "meteomedia.com",
        "bankaustria.at",
        "advertise.com",
        "trafficswarm.com",
        "aztecaporno.com",
        "fourseasons.com",
        "movie-blog.org",
        "govdelivery.com",
        "didigames.com",
        "invideo.biz",
        "linux.org.ru",
        "omelete.uol.com.br",
        "babybus.cn",
        "oursogo.com",
        "ero-an.com",
        "mediafax.ro",
        "football.ua",
        "sii.cl",
        "dreamamateurs.com",
        "cheaperthandirt.com",
        "iplocation.net",
        "insideview.com",
        "hihe.vn",
        "stop-sex.com",
        "fubiz.net",
        "url.org",
        "greenmangaming.com",
        "pornup.me",
        "indofeed.com",
        "forumhouse.ru",
        "restaurant.com",
        "key.com",
        "windstream.net",
        "brightedge.com",
        "foreignpolicy.com",
        "noticiasdatv.uol.com.br",
        "logopond.com",
        "datemule.com",
        "webrootanywhere.com",
        "stomp.com.sg",
        "trthaber.com",
        "bitterstrawberry.com",
        "turbo.az",
        "kbs.co.kr",
        "joblo.com",
        "seatimes.com.vn",
        "kuwait.tt",
        "258.com",
        "kp.ua",
        "moviesmobile.net",
        "flamingtext.com",
        "youngt.com",
        "etradenow.cn",
        "copart.com",
        "tuanweihui.com",
        "zinkwaphd.com",
        "adsl.free.fr",
        "infomaniak.ch",
        "re-direcciona.me",
        "mejorenvo.com",
        "instantservice.com",
        "harpersbazaar.com",
        "colorado.edu",
        "belboon.com",
        "telelistas.net",
        "photofans.cn",
        "51seer.com",
        "danjur.com",
        "wunderweib.de",
        "extratorrentlive.com",
        "serpfox.com",
        "androidkade.com",
        "raja.ir",
        "tampabay.com",
        "ser-mujer.org",
        "imasters.com.br",
        "coachfactory.com",
        "mojopages.com",
        "makezine.com",
        "forexschoolonline.com",
        "bochk.com",
        "siamsport.co.th",
        "mdpr.jp",
        "serialssolutions.com",
        "videosexarchive.com",
        "enlnks.com",
        "cision.com",
        "scratchinginfo.com",
        "skidrowgames.net",
        "optimizely.com",
        "video2brain.com",
        "ariva.de",
        "audiomack.com",
        "pimproll.com",
        "house.gov",
        "acs.org",
        "pijamasurf.com",
        "autoc-one.jp",
        "southcn.com",
        "vesti.az",
        "300mbfilms.com",
        "speedmystream.com",
        "wooservers.com",
        "siteliner.com",
        "tinmoi.vn",
        "extremepornvideos.com",
        "cqsq.com",
        "hello-today.com",
        "turkcealtyazi.org",
        "tvyo.com",
        "dealmoon.com",
        "openenglish.com",
        "golfchannel.com",
        "irancloob.com",
        "ebs.in",
        "portalcorreio.uol.com.br",
        "beemp3s.org",
        "condenast.com",
        "mtwebcenters.com.tw",
        "hatelabo.jp",
        "pathci.net",
        "mamsy.ru",
        "noticiasdelmundo.org",
        "guru3d.com",
        "logomaker.com",
        "adhitz.com",
        "swiki.jp",
        "turnitin.com",
        "patoghu.com",
        "carnaval.uol.com.br",
        "cancer.org",
        "clickprime8.com",
        "fahrinfo-berlin.de",
        "unisender.com",
        "flashkhor.com",
        "goodfon.ru",
        "ethiotube.net",
        "cunbang.com",
        "ti-da.net",
        "1phads.com",
        "bien.hu",
        "home77.com",
        "mbabycare.com",
        "vudu.com",
        "fantasy8.com",
        "landrover.com",
        "opencartforum.ru",
        "antena3.ro",
        "getapp.com",
        "torlock.com",
        "wind.it",
        "expatads.com",
        "bloglines.com",
        "sexytube.me",
        "frontier.com",
        "asandownload.com",
        "groupon.pl",
        "storesonlinepro.com",
        "brands4friends.de",
        "infogr.am",
        "webeffector.ru",
        "google.com.mm",
        "ppchero.com",
        "privacystar.com",
        "ocregister.com",
        "liex.ru",
        "kopatheme.com",
        "toggl.com",
        "raywenderlich.com",
        "hecha.cn",
        "vpls.net",
        "manpianyi.com",
        "1881.no",
        "scbeasy.com",
        "plex.tv",
        "selfridges.com",
        "anumex.com",
        "postplanner.com",
        "thisiscolossal.com",
        "you-will-date.com",
        "idealist.org",
        "emarketer.com",
        "anibis.ch",
        "dansmovies.com",
        "footballitarin.com",
        "fragrantica.com",
        "10minutemail.com",
        "ntu.edu.tw",
        "clasicooo.com",
        "onsugar.com",
        "vr-zone.com",
        "walkerplus.com",
        "easymobilerecharge.com",
        "cz001.com.cn",
        "sportsseoul.com",
        "inazumanews2.com",
        "marketingdirecto.com",
        "chartboost.com",
        "unblocked.co",
        "rhymezone.com",
        "portalinmobiliario.com",
        "afrointroductions.com",
        "transunion.com",
        "panorama.it",
        "powershow.com",
        "avval.ir",
        "onlinemeetingnow.com",
        "xoom.com",
        "wnbc.com",
        "tlen.pl",
        "jetairways.com",
        "vtb24.ru",
        "offcn.com",
        "crx7601.com",
        "adverts.ie",
        "kasserver.com",
        "minhavida.com.br",
        "jkpj.com",
        "123contactform.com",
        "imgtiger.com",
        "folha.com.br",
        "npcgo.com",
        "semprot.com",
        "moonfruit.com",
        "jizzbell.com",
        "online-stopwatch.com",
        "allhiphop.com",
        "hackaday.com",
        "digitalplayground.com",
        "careers24.com",
        "cwq.com",
        "wondershare.com",
        "filesend.to",
        "puromarketing.com",
        "workopolis.com",
        "mudainodocument.com",
        "home.ne.jp",
        "shorte.st",
        "tanea.gr",
        "sporza.be",
        "vgorode.ua",
        "google.co.zm",
        "argumentua.com",
        "3m.com",
        "komputerswiat.pl",
        "bongdaplus.vn",
        "supersonicads.com",
        "soundclick.com",
        "lollipop-network.com",
        "lpcloudsvr304.com",
        "313.cn",
        "rtl2.de",
        "ts.cn",
        "mglradio.com",
        "diynetwork.com",
        "komikcaps.net",
        "all-that-is-interesting.com",
        "ultipro.com",
        "frombar.com",
        "sitedeals.nl",
        "codingforums.com",
        "kansascity.com",
        "twtrland.com",
        "cengage.com",
        "lolspotsarticles.com",
        "jackthreads.com",
        "jobstreet.com.sg",
        "diffen.com",
        "eme2000.com",
        "superbru.com",
        "droid-life.com",
        "itb-berlin.de",
        "estibot.com",
        "yourepeat.com",
        "112.ua",
        "70e.com",
        "grid.mk",
        "cromaretail.com",
        "jobstreet.com.ph",
        "gloadmarket.com",
        "gemius.com",
        "huuto.net",
        "vogue.it",
        "divxonline.info",
        "mytoys.de",
        "cashnhits.com",
        "minkchan.com",
        "talabat.com",
        "helpareporter.com",
        "grandascent.com",
        "catalunyacaixa.com",
        "sparwelt.de",
        "tvboxnow.com",
        "imagecurl.org",
        "coocan.jp",
        "eatingwell.com",
        "truelife.com",
        "binaryoptionsbrands.com",
        "foxsportsla.com",
        "jjshouse.com",
        "makaan.com",
        "yamaha.com",
        "activerain.com",
        "excelforum.com",
        "mobinnet.ir",
        "kasikornbankgroup.com",
        "googleplex.com",
        "medianama.com",
        "fullsail.edu",
        "makeupandbeauty.com",
        "marketwired.com",
        "beachbodycoach.com",
        "taloussanomat.fi",
        "youngliving.us",
        "dana.ir",
        "adsgostar.com",
        "esquire.com.cn",
        "meyerweb.com",
        "positivemed.com",
        "harvestapp.com",
        "tim.com.br",
        "sumorobo.net",
        "zbigz.com",
        "schulferien.org",
        "quzhao.com",
        "tsinghua.edu.cn",
        "vogue.com",
        "ecrater.com",
        "internetbs.net",
        "oper.ru",
        "kingstone.com.tw",
        "olympic.org",
        "code.org",
        "wp.tv",
        "adchakra.net",
        "passarela.com.br",
        "damn.com",
        "spn.com.cn",
        "sacitaslan.com",
        "uplod.ir",
        "kununu.com",
        "englishclub.com",
        "ibood.com",
        "buzzfed.com",
        "peopledaily.com.cn",
        "vivastreet.it",
        "adshostnet.com",
        "npmjs.org",
        "lovethatsex.com",
        "garena.tw",
        "hq-sex-tube.com",
        "tvsubtitles.net",
        "trademarkia.com",
        "96down.com",
        "morhipo.com",
        "chuguoqu.com",
        "free-css.com",
        "getsecuredfiles.com",
        "justia.com",
        "paypal-community.com",
        "wezoner.com",
        "google-analytics.com",
        "outsideonline.com",
        "simplymeasured.com",
        "wattsupwiththat.com",
        "vancl.com",
        "leadership.ng",
        "plaisio.gr",
        "fastcocreate.com",
        "fewo-direkt.de",
        "dedecms.com",
        "bostonherald.com",
        "elmundo.com.ve",
        "idhostinger.com",
        "animaljam.com",
        "infoq.com",
        "exler.ru",
        "leprosorium.ru",
        "avis.com",
        "ulusalpost.com",
        "namnak.com",
        "goindigo.in",
        "activeboard.com",
        "fatsecret.com",
        "4umf.com",
        "porn-w.org",
        "sarkariexam.co.in",
        "patagonia.com",
        "3u5.net",
        "roshd.ir",
        "netechangisme.com",
        "ojogo.pt",
        "ujipin.com",
        "topuniversities.com",
        "consequenceofsound.net",
        "no-ip.biz",
        "webdesignerwall.com",
        "fin24.com",
        "openculture.com",
        "pbh2.com",
        "dota2.com",
        "secureupload.eu",
        "alfajertv.com",
        "canlidizihdtv.com",
        "muffingroup.com",
        "imageforum.com",
        "paris.fr",
        "kaufda.de",
        "pelis24.com",
        "ixian.cn",
        "ebenpagan.com",
        "sportsauthority.com",
        "wish.com",
        "ganeshaspeaks.com",
        "meritnation.com",
        "ijie.com",
        "vodafone.com.tr",
        "trovit.es",
        "farsisubtitle.com",
        "musawvir.com",
        "resellerratings.com",
        "soyentrepreneur.com",
        "samakal.net",
        "dietnavi.com",
        "55tuan.com",
        "elcomercio.com",
        "hereisthecity.com",
        "buienradar.nl",
        "arenabg.com",
        "indiansexstories.net",
        "slideboom.com",
        "findsection.net",
        "rankrecon.com",
        "e-radio.gr",
        "cnn.co.jp",
        "gucci.com",
        "natura.net",
        "googlesyndication.com",
        "advancedwebranking.com",
        "lib.ru",
        "sfora.pl",
        "uci.edu",
        "haaretz.co.il",
        "ing.be",
        "yokboylebirsey.com.tr",
        "myfact.tv",
        "yenibiris.com",
        "stuff.tv",
        "dn.pt",
        "whydontyoutrythis.com",
        "nediyor.com",
        "worldoftanks.asia",
        "megamillions.com",
        "elemanonline.net",
        "computrabajo.com.pe",
        "arxiv.org",
        "livescore.tv",
        "aintitcool.com",
        "girlschannel.net",
        "madbid.com",
        "tadawul.com.sa",
        "liqpay.com",
        "softonic.jp",
        "alhilal.com",
        "bizpowa.com",
        "thatguywiththeglasses.com",
        "yemeneconomist.com",
        "pazar3.mk",
        "repai.com",
        "1jux.net",
        "solvusoft.com",
        "yotpo.com",
        "cuantocabron.com",
        "ba.gov.br",
        "arin.net",
        "loginza.ru",
        "homebank.ro",
        "0755car.com",
        "carscoops.com",
        "antarvasna.com",
        "tizag.com",
        "offerpop.com",
        "techmeme.com",
        "ipress.ua",
        "emuparadise.me",
        "sexvidx.com",
        "whatseek.com",
        "become.co.jp",
        "snapfish.com",
        "gsis.gr",
        "speedyshare.com",
        "uncrate.com",
        "doda.jp",
        "straighttalk.com",
        "rsjoomla.com",
        "vozpopuli.com",
        "gotprint.net",
        "finansbank.com.tr",
        "chinatrust.com.tw",
        "stratoserver.net",
        "icnetwork.co.uk",
        "getpopcornti.me",
        "pornper.com",
        "3dmgame.com",
        "squirt.org",
        "mbusa.com",
        "katespade.com",
        "skat.dk",
        "radiko.jp",
        "dexonline.ro",
        "bicaps.net",
        "bitsoma.com",
        "brasil247.com",
        "alittlemarket.com",
        "bd-pratidin.com",
        "amorincontro.com",
        "bigxvideos.com",
        "nissan.co.jp",
        "incomediary.com",
        "theranking.com",
        "el7l.co",
        "webcamtoy.com",
        "steamgifts.com",
        "miles-and-more.com",
        "szonline.net",
        "blocked-website.com",
        "kaztorka.org",
        "avforums.com",
        "indulgy.com",
        "extendcp.co.uk",
        "yonkis.com",
        "ad1111.com",
        "unionbankph.com",
        "job.com",
        "samanepay.com",
        "aceona.com",
        "kar.nic.in",
        "tipico.com",
        "sa.ae",
        "froma.com",
        "songza.com",
        "calciomercato.com",
        "besaba.com",
        "x-rates.com",
        "arsys.es",
        "sisal.it",
        "amateur.tv",
        "designyourway.net",
        "alpha.gr",
        "nimble.com",
        "livefreefun.com",
        "wipo.int",
        "webssearches.com",
        "vodjk.com",
        "91tiger.com",
        "swisscom.com",
        "tuvaro.com",
        "parsonline.net",
        "uolhost.com.br",
        "cnwest.com",
        "roksa.pl",
        "socialmention.com",
        "unibytes.com",
        "screamingfrog.co.uk",
        "owncloud.org",
        "jacquielawson.com",
        "openclipart.org",
        "zimbra.com",
        "poczta-polska.pl",
        "hayah.cc",
        "ringtonematcher.com",
        "emai.com",
        "wealink.com",
        "celebzen.com",
        "pichost.me",
        "rediffmail.com",
        "dinos.co.jp",
        "netvasco.com.br",
        "meilele.com",
        "career.ru",
        "signupgenius.com",
        "screencast-o-matic.com",
        "nav.no",
        "reactiongifs.com",
        "italki.com",
        "mo.gov",
        "bandsintown.com",
        "elwatan.com",
        "jdate.com",
        "quiente.net",
        "skynet.be",
        "googlekeywordtool.com",
        "nubilefilms.com",
        "memedeportes.com",
        "rewardingzonez.com",
        "litmus.com",
        "iyaxin.com",
        "collegeconfidential.com",
        "semperplugins.com",
        "sofort.com",
        "ineedhits.com",
        "live24.gr",
        "acronymfinder.com",
        "jobui.com",
        "9show.com",
        "thedirty.com",
        "tsutaya.co.jp",
        "9787.com",
        "brighthouse.com",
        "boxingscene.com",
        "indeed.com.br",
        "morazzia.com",
        "privatejobshub.blogspot.in",
        "searchenginepeople.com",
        "pozdravok.ru",
        "watchstore.com.cn",
        "rts.ch",
        "pluska.sk",
        "villagevoice.com",
        "sprintrade.com",
        "conversionxl.com",
        "evsuite.com",
        "bci.cl",
        "lampsplus.com",
        "gossipcop.com",
        "valuecommerce.com",
        "zalora.co.id",
        "fastshop.com.br",
        "hockeysfuture.com",
        "bootply.com",
        "chinavasion.com",
        "menards.com",
        "kinobar.net",
        "tokyodisneyresort.jp",
        "knownhost.com",
        "ozbargain.com.au",
        "olx.com.ve",
        "sgk.gov.tr",
        "berliner-sparkasse.de",
        "bancogalicia.com.ar",
        "joomla-master.org",
        "augsburger-allgemeine.de",
        "kroger.com",
        "pulse.ng",
        "putlocker.com",
        "jrtj.com",
        "tapuz.co.il",
        "madhyamam.com",
        "donews.com",
        "showhaber.com",
        "allxnxx.com",
        "uned.es",
        "adsharebux.com",
        "d-addicts.com",
        "banki.ir",
        "levi.com",
        "e97527f0.se",
        "entertainmentwise.com",
        "xvideos-field.com",
        "naver.net",
        "urbia.de",
        "fashionsfriend.com",
        "emuch.net",
        "yelp.fr",
        "metatube.com",
        "sina.com.hk",
        "omb100.com",
        "grameenphone.com",
        "stylebook.de",
        "funny-games.biz",
        "googlewebmastercentral.blogspot.com",
        "vogella.com",
        "surveymonkey.net",
        "forex4you.org",
        "mex.tl",
        "online-fish-games.com",
        "millenniumbcp.pt",
        "fileom.com",
        "friendorfollow.com",
        "downloads.nl",
        "typekit.com",
        "gongkong.com",
        "iqoption.com",
        "tori.fi",
        "smartsource.com",
        "1616.net",
        "1shoppingcart.com",
        "novosti.rs",
        "yofond.com",
        "idokep.hu",
        "motor.ru",
        "xbiao.com",
        "colorcombos.com",
        "pway.cn",
        "egynews.net",
        "elshaab.org",
        "telus.com",
        "olx.com.co",
        "cctvcj.com",
        "kpopstarz.com",
        "razorsocial.com",
        "ncrypt.in",
        "zonetheme.com",
        "gumroad.com",
        "e-shop.gr",
        "kugli.com",
        "levif.be",
        "bookfi.org",
        "globalresearch.ca",
        "sas.com",
        "cloudaccess.net",
        "uplooder.net",
        "exposedwebcams.com",
        "1prime.ru",
        "webappers.com",
        "crocko.com",
        "remax.com",
        "ikco.com",
        "dinside.no",
        "winbank.gr",
        "mijnwoordenboek.nl",
        "weatherzone.com.au",
        "allday2.com",
        "sunat.gob.pe",
        "getit.in",
        "entrance-exam.net",
        "i2ya.com",
        "tlife.gr",
        "qyer.com",
        "calibre-ebook.com",
        "internetcorkboard.com",
        "unitedhyipleague.com",
        "spyrestudios.com",
        "metal-archives.com",
        "aeromexico.com",
        "cv-library.co.uk",
        "bdr1.net",
        "aremo.com.br",
        "blip.tv",
        "afilio.com.br",
        "renewalcoupons.com",
        "proxfree.com",
        "magix.com",
        "jobs.net",
        "souism.com",
        "adtcstrk.com",
        "goodhousekeeping.com",
        "lastfm.ru",
        "sharecare.com",
        "porn.xxx",
        "deathandtaxesmag.com",
        "unocero.com",
        "wer-kennt-wen.de",
        "hotfrog.com",
        "intraship.de",
        "press24.mk",
        "yournewscorner.com",
        "rbc.com",
        "eventure.com",
        "minglebox.com",
        "legendas.tv",
        "drp.su",
        "voicefrom.me",
        "venezuelaaldia.com",
        "cooks.com",
        "numbeo.com",
        "chilehardware.cl",
        "cryptocointalk.com",
        "venusfactor.com",
        "recruitmentcareer.in",
        "larazon.es",
        "sptechs.com",
        "asx.com.au",
        "ahlife.com",
        "st001.com",
        "actudesfinances.info",
        "talkarcades.com",
        "nitori-net.jp",
        "chinahr.com",
        "websitetestlink.com",
        "hypem.com",
        "demorgen.be",
        "sharefile.com",
        "prensalibre.com",
        "eldia.com.ar",
        "billiger.de",
        "3docean.net",
        "streamsend.com",
        "tuaw.com",
        "portafolio.co",
        "trivago.com",
        "olxpix.com",
        "geotrust.com",
        "torrentgun.net",
        "enha.kr",
        "pcastuces.com",
        "t.cn",
        "dimsemenov.com",
        "cam4.nl",
        "basspro.com",
        "macupdate.com",
        "strawpoll.me",
        "elintransigente.com",
        "homeaway.co.uk",
        "my.ecwid.com",
        "graphpaperpress.com",
        "architonic.com",
        "flowplayer.org",
        "syshl.com",
        "18schoolgirlz.com"
    });

    return urls;
}
