/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi.location;

import java.lang.reflect.Method;
import org.apache.log4j.spi.LocationInfo;

public class StackTraceElementExtractor {
    protected static boolean haveStackTraceElement = false;
    private static Method getStackTrace = null;
    private static Method getClassName = null;
    private static Method getFileName = null;
    private static Method getMethodName = null;
    private static Method getLineNumber = null;
    private static Object[] nullArgs = new Object[0];
    static /* synthetic */ Class class$java$lang$Throwable;

    public static void extract(LocationInfo li, Throwable t, String fqnOfInvokingClass) {
        if (t == null) {
            return;
        }
        Object location = null;
        try {
            Object[] stes = (Object[])getStackTrace.invoke((Object)t, nullArgs);
            boolean match = false;
            int i = 0;
            while (i < stes.length) {
                if (((String)getClassName.invoke(stes[i], nullArgs)).equals(fqnOfInvokingClass)) {
                    match = true;
                } else if (match) {
                    location = stes[i];
                    break;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (location == null) {
            li.className = "?";
            li.fileName = "?";
            li.lineNumber = "?";
            li.methodName = "?";
        } else {
            StackTraceElementExtractor.setClassName(li, location);
            StackTraceElementExtractor.setFileName(li, location);
            StackTraceElementExtractor.setMethodName(li, location);
            StackTraceElementExtractor.setLineNumber(li, location);
        }
    }

    static void setClassName(LocationInfo li, Object location) {
        try {
            li.className = (String)getClassName.invoke(location, nullArgs);
        }
        catch (Throwable e) {
            li.className = "?";
        }
    }

    static void setFileName(LocationInfo li, Object location) {
        try {
            li.fileName = (String)getFileName.invoke(location, nullArgs);
        }
        catch (Throwable e) {
            li.fileName = "?";
        }
    }

    static void setLineNumber(LocationInfo li, Object location) {
        Integer ln = null;
        try {
            ln = (Integer)getLineNumber.invoke(location, nullArgs);
            if (ln >= 0) {
                li.lineNumber = ln.toString();
            }
        }
        catch (Throwable e) {
            li.lineNumber = "?";
        }
    }

    static void setMethodName(LocationInfo li, Object location) {
        try {
            li.methodName = (String)getMethodName.invoke(location, nullArgs);
        }
        catch (Throwable e) {
            li.methodName = "?";
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class<?> cStackTraceElement = Class.forName("java.lang.StackTraceElement");
            Class[] nullClassArray = new Class[]{};
            getStackTrace = (class$java$lang$Throwable == null ? (class$java$lang$Throwable = StackTraceElementExtractor.class$("java.lang.Throwable")) : class$java$lang$Throwable).getDeclaredMethod("getStackTrace", nullClassArray);
            getClassName = cStackTraceElement.getDeclaredMethod("getClassName", nullClassArray);
            getFileName = cStackTraceElement.getDeclaredMethod("getFileName", nullClassArray);
            getMethodName = cStackTraceElement.getDeclaredMethod("getMethodName", nullClassArray);
            getLineNumber = cStackTraceElement.getDeclaredMethod("getLineNumber", nullClassArray);
            haveStackTraceElement = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

