/**********************************************************************
 * $realpow example -- C source code using TF/ACC PLI routines
 *
 * C source to calculate the result of a number to the power of an
 * exponent.  The value is returned to simulation as a system function.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: result = $realpow(<base>,<exponent>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_realpow_checktf(),
 *              PLIbook_realpow_calltf();
 *  /* table entries -/
 *   {userrealfunction,             /* type of PLI routine -/
 *     0,                           /* user_data value -/
 *     PLIbook_realpow_checktf,     /* checktf routine -/
 *     0,                           /* sizetf routine -/
 *     PLIbook_realpow_calltf,      /* calltf routine -/
 *     0,                           /* misctf routine -/
 *     "$realpow",                  /* system task/function name -/
 *     1                            /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */

/**********************************************************************
 * Sizetf application -- not used to userrealfunction type
 *********************************************************************/

/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_realpow_checktf()
{
  int arg_type;
  
  if (tf_nump() != 2) {
    tf_error("$pow must have 2 arguments.\n");
    return(0);
  }
  arg_type = tf_typep(1);
  if (arg_type == TF_NULLPARAM)
    tf_error("$pow arg 1 cannot be null.\n");
  else 
  if (   (arg_type != TF_READONLY)
      && (arg_type != TF_READONLYREAL)
      && (arg_type != TF_READWRITE)
      && (arg_type != TF_READWRITEREAL) ) {
    tf_error("$pow arg 1 must be number, variable or net.\n");
  }
  arg_type = tf_typep(2);
  if (arg_type == TF_NULLPARAM)
    tf_error("$pow arg 2 cannot be null.\n");
  else 
  if (   (arg_type != TF_READONLY)
      && (arg_type != TF_READONLYREAL)
      && (arg_type != TF_READWRITE)
      && (arg_type != TF_READWRITEREAL) ) {
    tf_error("$pow arg 2 must be number, variable or net.\n");
  }
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
#include <math.h>
int PLIbook_realpow_calltf()
{
  double base, exp, result;
  int    arg_type;

  arg_type = tf_typep(1);
  if (   (arg_type == TF_READONLYREAL)
      || (arg_type == TF_READWRITEREAL) )
    base   = tf_getrealp(1);       /* read double value from tfarg 1 */
  else
    base   = (double)tf_getp(1);   /* read int value from tfarg 1 */

  arg_type = tf_typep(2);
  if (   (arg_type == TF_READONLYREAL)
      || (arg_type == TF_READWRITEREAL) )
    exp   = tf_getrealp(2);        /* read double value from tfarg 2 */
  else
    exp   = (double)tf_getp(2);    /* read int value from tfarg 2 */

  result = pow(base, exp);

  tf_putrealp(0,result);           /* return result */

  return(0);
}

/*********************************************************************/

