/* collection.c generated by valac, the Vala compiler
 * generated from collection.vala, do not modify */

/* collection.vala
 *
 * Copyright (C) 2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "valagee.h"
#include <float.h>
#include <math.h>

#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

struct _ValaCollectionPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};


static gpointer vala_collection_parent_class = NULL;

#define VALA_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_COLLECTION, ValaCollectionPrivate))
static gboolean vala_collection_real_contains (ValaCollection* self, gconstpointer item);
static gboolean vala_collection_real_add (ValaCollection* self, gconstpointer item);
static gboolean vala_collection_real_remove (ValaCollection* self, gconstpointer item);
static void vala_collection_real_clear (ValaCollection* self);
static gboolean vala_collection_real_add_all (ValaCollection* self, ValaCollection* collection);
static gpointer* vala_collection_real_to_array (ValaCollection* self, int* result_length1);
static gboolean* vala_collection_to_bool_array (ValaCollection* coll, int* result_length1);
static gchar* vala_collection_to_char_array (ValaCollection* coll, int* result_length1);
static guchar* vala_collection_to_uchar_array (ValaCollection* coll, int* result_length1);
static gint* vala_collection_to_int_array (ValaCollection* coll, int* result_length1);
static guint* vala_collection_to_uint_array (ValaCollection* coll, int* result_length1);
static gint64** vala_collection_to_int64_array (ValaCollection* coll, int* result_length1);
static guint64** vala_collection_to_uint64_array (ValaCollection* coll, int* result_length1);
static glong* vala_collection_to_long_array (ValaCollection* coll, int* result_length1);
static gulong* vala_collection_to_ulong_array (ValaCollection* coll, int* result_length1);
static gfloat** vala_collection_to_float_array (ValaCollection* coll, int* result_length1);
static gdouble** vala_collection_to_double_array (ValaCollection* coll, int* result_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * Determines whether this collection contains the specified item.
 *
 * @param item the item to locate in the collection
 *
 * @return     true if item is found, false otherwise
 */
static gboolean vala_collection_real_contains (ValaCollection* self, gconstpointer item) {
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `vala_collection_contains'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}


gboolean vala_collection_contains (ValaCollection* self, gconstpointer item) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_COLLECTION_GET_CLASS (self)->contains (self, item);
}


/**
 * Adds an item to this collection. Must not be called on read-only
 * collections.
 *
 * @param item the item to add to the collection
 *
 * @return     true if the collection has been changed, false otherwise
 */
static gboolean vala_collection_real_add (ValaCollection* self, gconstpointer item) {
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `vala_collection_add'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}


gboolean vala_collection_add (ValaCollection* self, gconstpointer item) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_COLLECTION_GET_CLASS (self)->add (self, item);
}


/**
 * Removes the first occurrence of an item from this collection. Must not
 * be called on read-only collections.
 *
 * @param item the item to remove from the collection
 *
 * @return     true if the collection has been changed, false otherwise
 */
static gboolean vala_collection_real_remove (ValaCollection* self, gconstpointer item) {
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `vala_collection_remove'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}


gboolean vala_collection_remove (ValaCollection* self, gconstpointer item) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_COLLECTION_GET_CLASS (self)->remove (self, item);
}


/**
 * Removes all items from this collection. Must not be called on
 * read-only collections.
 */
static void vala_collection_real_clear (ValaCollection* self) {
	g_critical ("Type `%s' does not implement abstract method `vala_collection_clear'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void vala_collection_clear (ValaCollection* self) {
	g_return_if_fail (self != NULL);
	VALA_COLLECTION_GET_CLASS (self)->clear (self);
}


/**
 * Adds all items in the input collection to this collection.
 *
 * @param collection the collection which items will be added to this
 *                   collection.
 *
 * @return     ``true`` if the collection has been changed, ``false`` otherwise
 */
static gboolean vala_collection_real_add_all (ValaCollection* self, ValaCollection* collection) {
	gboolean result = FALSE;
	gboolean changed = FALSE;
	g_return_val_if_fail (collection != NULL, FALSE);
	changed = FALSE;
	{
		ValaIterator* iter = NULL;
		ValaCollection* _tmp0_;
		ValaIterator* _tmp1_;
		_tmp0_ = collection;
		_tmp1_ = vala_iterable_iterator ((ValaIterable*) _tmp0_);
		iter = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				ValaIterator* _tmp3_;
				gboolean _tmp4_;
				gpointer item = NULL;
				ValaIterator* _tmp5_;
				gpointer _tmp6_;
				gconstpointer _tmp7_;
				gboolean _tmp8_;
				if (!_tmp2_) {
				}
				_tmp2_ = FALSE;
				_tmp3_ = iter;
				_tmp4_ = vala_iterator_next (_tmp3_);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = iter;
				_tmp6_ = vala_iterator_get (_tmp5_);
				item = _tmp6_;
				_tmp7_ = item;
				_tmp8_ = vala_collection_contains (self, _tmp7_);
				if (!_tmp8_) {
					gconstpointer _tmp9_;
					_tmp9_ = item;
					vala_collection_add (self, _tmp9_);
					changed = TRUE;
				}
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
			}
		}
		_vala_iterator_unref0 (iter);
	}
	result = changed;
	return result;
}


gboolean vala_collection_add_all (ValaCollection* self, ValaCollection* collection) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_COLLECTION_GET_CLASS (self)->add_all (self, collection);
}


/**
 * Returns an array containing all of items from this collection.
 *
 * @return an array containing all of items from this collection
 */
static gpointer* vala_collection_real_to_array (ValaCollection* self, int* result_length1) {
	gpointer* result = NULL;
	GType t = 0UL;
	GType _tmp0_;
	t = self->priv->g_type;
	_tmp0_ = t;
	if (_tmp0_ == G_TYPE_BOOLEAN) {
		gint _tmp1_;
		gboolean* _tmp2_;
		gpointer* _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = vala_collection_to_bool_array (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_COLLECTION, ValaCollection), &_tmp1_);
		_tmp3_ = (gpointer*) _tmp2_;
		_tmp3__length1 = _tmp1_;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	} else {
		GType _tmp4_;
		_tmp4_ = t;
		if (_tmp4_ == G_TYPE_CHAR) {
			gint _tmp5_;
			gchar* _tmp6_;
			gpointer* _tmp7_;
			gint _tmp7__length1;
			_tmp6_ = vala_collection_to_char_array (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_COLLECTION, ValaCollection), &_tmp5_);
			_tmp7_ = (gpointer*) _tmp6_;
			_tmp7__length1 = _tmp5_;
			if (result_length1) {
				*result_length1 = _tmp7__length1;
			}
			result = _tmp7_;
			return result;
		} else {
			GType _tmp8_;
			_tmp8_ = t;
			if (_tmp8_ == G_TYPE_UCHAR) {
				gint _tmp9_;
				guchar* _tmp10_;
				gpointer* _tmp11_;
				gint _tmp11__length1;
				_tmp10_ = vala_collection_to_uchar_array (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_COLLECTION, ValaCollection), &_tmp9_);
				_tmp11_ = (gpointer*) _tmp10_;
				_tmp11__length1 = _tmp9_;
				if (result_length1) {
					*result_length1 = _tmp11__length1;
				}
				result = _tmp11_;
				return result;
			} else {
				GType _tmp12_;
				_tmp12_ = t;
				if (_tmp12_ == G_TYPE_INT) {
					gint _tmp13_;
					gint* _tmp14_;
					gpointer* _tmp15_;
					gint _tmp15__length1;
					_tmp14_ = vala_collection_to_int_array (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_COLLECTION, ValaCollection), &_tmp13_);
					_tmp15_ = (gpointer*) _tmp14_;
					_tmp15__length1 = _tmp13_;
					if (result_length1) {
						*result_length1 = _tmp15__length1;
					}
					result = _tmp15_;
					return result;
				} else {
					GType _tmp16_;
					_tmp16_ = t;
					if (_tmp16_ == G_TYPE_UINT) {
						gint _tmp17_;
						guint* _tmp18_;
						gpointer* _tmp19_;
						gint _tmp19__length1;
						_tmp18_ = vala_collection_to_uint_array (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_COLLECTION, ValaCollection), &_tmp17_);
						_tmp19_ = (gpointer*) _tmp18_;
						_tmp19__length1 = _tmp17_;
						if (result_length1) {
							*result_length1 = _tmp19__length1;
						}
						result = _tmp19_;
						return result;
					} else {
						GType _tmp20_;
						_tmp20_ = t;
						if (_tmp20_ == G_TYPE_INT64) {
							gint _tmp21_;
							gint64** _tmp22_;
							gpointer* _tmp23_;
							gint _tmp23__length1;
							_tmp22_ = vala_collection_to_int64_array (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_COLLECTION, ValaCollection), &_tmp21_);
							_tmp23_ = (gpointer*) _tmp22_;
							_tmp23__length1 = _tmp21_;
							if (result_length1) {
								*result_length1 = _tmp23__length1;
							}
							result = _tmp23_;
							return result;
						} else {
							GType _tmp24_;
							_tmp24_ = t;
							if (_tmp24_ == G_TYPE_UINT64) {
								gint _tmp25_;
								guint64** _tmp26_;
								gpointer* _tmp27_;
								gint _tmp27__length1;
								_tmp26_ = vala_collection_to_uint64_array (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_COLLECTION, ValaCollection), &_tmp25_);
								_tmp27_ = (gpointer*) _tmp26_;
								_tmp27__length1 = _tmp25_;
								if (result_length1) {
									*result_length1 = _tmp27__length1;
								}
								result = _tmp27_;
								return result;
							} else {
								GType _tmp28_;
								_tmp28_ = t;
								if (_tmp28_ == G_TYPE_LONG) {
									gint _tmp29_;
									glong* _tmp30_;
									gpointer* _tmp31_;
									gint _tmp31__length1;
									_tmp30_ = vala_collection_to_long_array (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_COLLECTION, ValaCollection), &_tmp29_);
									_tmp31_ = (gpointer*) _tmp30_;
									_tmp31__length1 = _tmp29_;
									if (result_length1) {
										*result_length1 = _tmp31__length1;
									}
									result = _tmp31_;
									return result;
								} else {
									GType _tmp32_;
									_tmp32_ = t;
									if (_tmp32_ == G_TYPE_ULONG) {
										gint _tmp33_;
										gulong* _tmp34_;
										gpointer* _tmp35_;
										gint _tmp35__length1;
										_tmp34_ = vala_collection_to_ulong_array (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_COLLECTION, ValaCollection), &_tmp33_);
										_tmp35_ = (gpointer*) _tmp34_;
										_tmp35__length1 = _tmp33_;
										if (result_length1) {
											*result_length1 = _tmp35__length1;
										}
										result = _tmp35_;
										return result;
									} else {
										GType _tmp36_;
										_tmp36_ = t;
										if (_tmp36_ == G_TYPE_FLOAT) {
											gint _tmp37_;
											gfloat** _tmp38_;
											gpointer* _tmp39_;
											gint _tmp39__length1;
											_tmp38_ = vala_collection_to_float_array (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_COLLECTION, ValaCollection), &_tmp37_);
											_tmp39_ = (gpointer*) _tmp38_;
											_tmp39__length1 = _tmp37_;
											if (result_length1) {
												*result_length1 = _tmp39__length1;
											}
											result = _tmp39_;
											return result;
										} else {
											GType _tmp40_;
											_tmp40_ = t;
											if (_tmp40_ == G_TYPE_DOUBLE) {
												gint _tmp41_;
												gdouble** _tmp42_;
												gpointer* _tmp43_;
												gint _tmp43__length1;
												_tmp42_ = vala_collection_to_double_array (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_COLLECTION, ValaCollection), &_tmp41_);
												_tmp43_ = (gpointer*) _tmp42_;
												_tmp43__length1 = _tmp41_;
												if (result_length1) {
													*result_length1 = _tmp43__length1;
												}
												result = _tmp43_;
												return result;
											} else {
												gboolean _tmp44_ = FALSE;
												GType _tmp45_;
												gboolean _tmp46_;
												_tmp45_ = t;
												_tmp46_ = G_TYPE_IS_ENUM (_tmp45_);
												if (_tmp46_) {
													_tmp44_ = TRUE;
												} else {
													GType _tmp47_;
													gboolean _tmp48_;
													_tmp47_ = t;
													_tmp48_ = G_TYPE_IS_FLAGS (_tmp47_);
													_tmp44_ = _tmp48_;
												}
												if (_tmp44_) {
													gint _tmp49_;
													gint* _tmp50_;
													gpointer* _tmp51_;
													gint _tmp51__length1;
													_tmp50_ = vala_collection_to_int_array (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_COLLECTION, ValaCollection), &_tmp49_);
													_tmp51_ = (gpointer*) _tmp50_;
													_tmp51__length1 = _tmp49_;
													if (result_length1) {
														*result_length1 = _tmp51__length1;
													}
													result = _tmp51_;
													return result;
												} else {
													gpointer* array = NULL;
													gint _tmp52_;
													gint _tmp53_;
													gpointer* _tmp54_;
													gint array_length1;
													gint _array_size_;
													gint index = 0;
													gpointer* _tmp64_;
													gint _tmp64__length1;
													_tmp52_ = vala_collection_get_size (self);
													_tmp53_ = _tmp52_;
													_tmp54_ = g_new0 (gpointer, _tmp53_);
													array = _tmp54_;
													array_length1 = _tmp53_;
													_array_size_ = array_length1;
													index = 0;
													{
														ValaIterator* _element_it = NULL;
														ValaIterator* _tmp55_;
														_tmp55_ = vala_iterable_iterator ((ValaIterable*) self);
														_element_it = _tmp55_;
														while (TRUE) {
															ValaIterator* _tmp56_;
															gboolean _tmp57_;
															gpointer element = NULL;
															ValaIterator* _tmp58_;
															gpointer _tmp59_;
															gpointer* _tmp60_;
															gint _tmp60__length1;
															gint _tmp61_;
															gpointer _tmp62_;
															gpointer _tmp63_;
															_tmp56_ = _element_it;
															_tmp57_ = vala_iterator_next (_tmp56_);
															if (!_tmp57_) {
																break;
															}
															_tmp58_ = _element_it;
															_tmp59_ = vala_iterator_get (_tmp58_);
															element = _tmp59_;
															_tmp60_ = array;
															_tmp60__length1 = array_length1;
															_tmp61_ = index;
															index = _tmp61_ + 1;
															_tmp62_ = element;
															element = NULL;
															((_tmp60_[_tmp61_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp60_[_tmp61_] = (self->priv->g_destroy_func (_tmp60_[_tmp61_]), NULL));
															_tmp60_[_tmp61_] = _tmp62_;
															_tmp63_ = _tmp60_[_tmp61_];
															((element == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (element = (self->priv->g_destroy_func (element), NULL));
														}
														_vala_iterator_unref0 (_element_it);
													}
													_tmp64_ = array;
													_tmp64__length1 = array_length1;
													if (result_length1) {
														*result_length1 = _tmp64__length1;
													}
													result = _tmp64_;
													return result;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


gpointer* vala_collection_to_array (ValaCollection* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_COLLECTION_GET_CLASS (self)->to_array (self, result_length1);
}


static gboolean* vala_collection_to_bool_array (ValaCollection* coll, int* result_length1) {
	gboolean* result = NULL;
	gboolean* array = NULL;
	ValaCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean* _tmp3_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gboolean* _tmp14_;
	gint _tmp14__length1;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = coll;
	_tmp1_ = vala_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gboolean, _tmp2_);
	array = _tmp3_;
	array_length1 = _tmp2_;
	_array_size_ = array_length1;
	index = 0;
	{
		ValaIterator* _element_it = NULL;
		ValaCollection* _tmp4_;
		ValaIterator* _tmp5_;
		_tmp4_ = coll;
		_tmp5_ = vala_iterable_iterator ((ValaIterable*) _tmp4_);
		_element_it = _tmp5_;
		while (TRUE) {
			ValaIterator* _tmp6_;
			gboolean _tmp7_;
			gboolean element = FALSE;
			ValaIterator* _tmp8_;
			gpointer _tmp9_;
			gboolean* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_;
			_tmp6_ = _element_it;
			_tmp7_ = vala_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _element_it;
			_tmp9_ = vala_iterator_get (_tmp8_);
			element = (gboolean) ((gintptr) _tmp9_);
			_tmp10_ = array;
			_tmp10__length1 = array_length1;
			_tmp11_ = index;
			index = _tmp11_ + 1;
			_tmp12_ = element;
			_tmp10_[_tmp11_] = _tmp12_;
			_tmp13_ = _tmp10_[_tmp11_];
		}
		_vala_iterator_unref0 (_element_it);
	}
	_tmp14_ = array;
	_tmp14__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}


static gchar* vala_collection_to_char_array (ValaCollection* coll, int* result_length1) {
	gchar* result = NULL;
	gchar* array = NULL;
	ValaCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gchar* _tmp3_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gchar* _tmp14_;
	gint _tmp14__length1;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = coll;
	_tmp1_ = vala_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gchar, _tmp2_);
	array = _tmp3_;
	array_length1 = _tmp2_;
	_array_size_ = array_length1;
	index = 0;
	{
		ValaIterator* _element_it = NULL;
		ValaCollection* _tmp4_;
		ValaIterator* _tmp5_;
		_tmp4_ = coll;
		_tmp5_ = vala_iterable_iterator ((ValaIterable*) _tmp4_);
		_element_it = _tmp5_;
		while (TRUE) {
			ValaIterator* _tmp6_;
			gboolean _tmp7_;
			gchar element = '\0';
			ValaIterator* _tmp8_;
			gpointer _tmp9_;
			gchar* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			gchar _tmp12_;
			gchar _tmp13_;
			_tmp6_ = _element_it;
			_tmp7_ = vala_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _element_it;
			_tmp9_ = vala_iterator_get (_tmp8_);
			element = (gchar) ((gintptr) _tmp9_);
			_tmp10_ = array;
			_tmp10__length1 = array_length1;
			_tmp11_ = index;
			index = _tmp11_ + 1;
			_tmp12_ = element;
			_tmp10_[_tmp11_] = _tmp12_;
			_tmp13_ = _tmp10_[_tmp11_];
		}
		_vala_iterator_unref0 (_element_it);
	}
	_tmp14_ = array;
	_tmp14__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}


static guchar* vala_collection_to_uchar_array (ValaCollection* coll, int* result_length1) {
	guchar* result = NULL;
	guchar* array = NULL;
	ValaCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guchar* _tmp3_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	guchar* _tmp14_;
	gint _tmp14__length1;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = coll;
	_tmp1_ = vala_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (guchar, _tmp2_);
	array = _tmp3_;
	array_length1 = _tmp2_;
	_array_size_ = array_length1;
	index = 0;
	{
		ValaIterator* _element_it = NULL;
		ValaCollection* _tmp4_;
		ValaIterator* _tmp5_;
		_tmp4_ = coll;
		_tmp5_ = vala_iterable_iterator ((ValaIterable*) _tmp4_);
		_element_it = _tmp5_;
		while (TRUE) {
			ValaIterator* _tmp6_;
			gboolean _tmp7_;
			guchar element = '\0';
			ValaIterator* _tmp8_;
			gpointer _tmp9_;
			guchar* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			guchar _tmp12_;
			guchar _tmp13_;
			_tmp6_ = _element_it;
			_tmp7_ = vala_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _element_it;
			_tmp9_ = vala_iterator_get (_tmp8_);
			element = (guchar) ((guintptr) _tmp9_);
			_tmp10_ = array;
			_tmp10__length1 = array_length1;
			_tmp11_ = index;
			index = _tmp11_ + 1;
			_tmp12_ = element;
			_tmp10_[_tmp11_] = _tmp12_;
			_tmp13_ = _tmp10_[_tmp11_];
		}
		_vala_iterator_unref0 (_element_it);
	}
	_tmp14_ = array;
	_tmp14__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}


static gint* vala_collection_to_int_array (ValaCollection* coll, int* result_length1) {
	gint* result = NULL;
	gint* array = NULL;
	ValaCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint* _tmp3_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gint* _tmp14_;
	gint _tmp14__length1;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = coll;
	_tmp1_ = vala_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gint, _tmp2_);
	array = _tmp3_;
	array_length1 = _tmp2_;
	_array_size_ = array_length1;
	index = 0;
	{
		ValaIterator* _element_it = NULL;
		ValaCollection* _tmp4_;
		ValaIterator* _tmp5_;
		_tmp4_ = coll;
		_tmp5_ = vala_iterable_iterator ((ValaIterable*) _tmp4_);
		_element_it = _tmp5_;
		while (TRUE) {
			ValaIterator* _tmp6_;
			gboolean _tmp7_;
			gint element = 0;
			ValaIterator* _tmp8_;
			gpointer _tmp9_;
			gint* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp6_ = _element_it;
			_tmp7_ = vala_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _element_it;
			_tmp9_ = vala_iterator_get (_tmp8_);
			element = (gint) ((gintptr) _tmp9_);
			_tmp10_ = array;
			_tmp10__length1 = array_length1;
			_tmp11_ = index;
			index = _tmp11_ + 1;
			_tmp12_ = element;
			_tmp10_[_tmp11_] = _tmp12_;
			_tmp13_ = _tmp10_[_tmp11_];
		}
		_vala_iterator_unref0 (_element_it);
	}
	_tmp14_ = array;
	_tmp14__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}


static guint* vala_collection_to_uint_array (ValaCollection* coll, int* result_length1) {
	guint* result = NULL;
	guint* array = NULL;
	ValaCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint* _tmp3_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	guint* _tmp14_;
	gint _tmp14__length1;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = coll;
	_tmp1_ = vala_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (guint, _tmp2_);
	array = _tmp3_;
	array_length1 = _tmp2_;
	_array_size_ = array_length1;
	index = 0;
	{
		ValaIterator* _element_it = NULL;
		ValaCollection* _tmp4_;
		ValaIterator* _tmp5_;
		_tmp4_ = coll;
		_tmp5_ = vala_iterable_iterator ((ValaIterable*) _tmp4_);
		_element_it = _tmp5_;
		while (TRUE) {
			ValaIterator* _tmp6_;
			gboolean _tmp7_;
			guint element = 0U;
			ValaIterator* _tmp8_;
			gpointer _tmp9_;
			guint* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			guint _tmp12_;
			guint _tmp13_;
			_tmp6_ = _element_it;
			_tmp7_ = vala_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _element_it;
			_tmp9_ = vala_iterator_get (_tmp8_);
			element = (guint) ((guintptr) _tmp9_);
			_tmp10_ = array;
			_tmp10__length1 = array_length1;
			_tmp11_ = index;
			index = _tmp11_ + 1;
			_tmp12_ = element;
			_tmp10_[_tmp11_] = _tmp12_;
			_tmp13_ = _tmp10_[_tmp11_];
		}
		_vala_iterator_unref0 (_element_it);
	}
	_tmp14_ = array;
	_tmp14__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}


static gint64** vala_collection_to_int64_array (ValaCollection* coll, int* result_length1) {
	gint64** result = NULL;
	gint64** array = NULL;
	ValaCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint64** _tmp3_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gint64** _tmp14_;
	gint _tmp14__length1;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = coll;
	_tmp1_ = vala_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gint64*, _tmp2_);
	array = _tmp3_;
	array_length1 = _tmp2_;
	_array_size_ = array_length1;
	index = 0;
	{
		ValaIterator* _element_it = NULL;
		ValaCollection* _tmp4_;
		ValaIterator* _tmp5_;
		_tmp4_ = coll;
		_tmp5_ = vala_iterable_iterator ((ValaIterable*) _tmp4_);
		_element_it = _tmp5_;
		while (TRUE) {
			ValaIterator* _tmp6_;
			gboolean _tmp7_;
			gint64* element = NULL;
			ValaIterator* _tmp8_;
			gpointer _tmp9_;
			gint64** _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			gint64* _tmp12_;
			gint64* _tmp13_;
			_tmp6_ = _element_it;
			_tmp7_ = vala_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _element_it;
			_tmp9_ = vala_iterator_get (_tmp8_);
			element = (gint64*) _tmp9_;
			_tmp10_ = array;
			_tmp10__length1 = array_length1;
			_tmp11_ = index;
			index = _tmp11_ + 1;
			_tmp12_ = element;
			element = NULL;
			_g_free0 (_tmp10_[_tmp11_]);
			_tmp10_[_tmp11_] = _tmp12_;
			_tmp13_ = _tmp10_[_tmp11_];
			_g_free0 (element);
		}
		_vala_iterator_unref0 (_element_it);
	}
	_tmp14_ = array;
	_tmp14__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}


static guint64** vala_collection_to_uint64_array (ValaCollection* coll, int* result_length1) {
	guint64** result = NULL;
	guint64** array = NULL;
	ValaCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint64** _tmp3_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	guint64** _tmp14_;
	gint _tmp14__length1;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = coll;
	_tmp1_ = vala_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (guint64*, _tmp2_);
	array = _tmp3_;
	array_length1 = _tmp2_;
	_array_size_ = array_length1;
	index = 0;
	{
		ValaIterator* _element_it = NULL;
		ValaCollection* _tmp4_;
		ValaIterator* _tmp5_;
		_tmp4_ = coll;
		_tmp5_ = vala_iterable_iterator ((ValaIterable*) _tmp4_);
		_element_it = _tmp5_;
		while (TRUE) {
			ValaIterator* _tmp6_;
			gboolean _tmp7_;
			guint64* element = NULL;
			ValaIterator* _tmp8_;
			gpointer _tmp9_;
			guint64** _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			guint64* _tmp12_;
			guint64* _tmp13_;
			_tmp6_ = _element_it;
			_tmp7_ = vala_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _element_it;
			_tmp9_ = vala_iterator_get (_tmp8_);
			element = (guint64*) _tmp9_;
			_tmp10_ = array;
			_tmp10__length1 = array_length1;
			_tmp11_ = index;
			index = _tmp11_ + 1;
			_tmp12_ = element;
			element = NULL;
			_g_free0 (_tmp10_[_tmp11_]);
			_tmp10_[_tmp11_] = _tmp12_;
			_tmp13_ = _tmp10_[_tmp11_];
			_g_free0 (element);
		}
		_vala_iterator_unref0 (_element_it);
	}
	_tmp14_ = array;
	_tmp14__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}


static glong* vala_collection_to_long_array (ValaCollection* coll, int* result_length1) {
	glong* result = NULL;
	glong* array = NULL;
	ValaCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	glong* _tmp3_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	glong* _tmp14_;
	gint _tmp14__length1;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = coll;
	_tmp1_ = vala_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (glong, _tmp2_);
	array = _tmp3_;
	array_length1 = _tmp2_;
	_array_size_ = array_length1;
	index = 0;
	{
		ValaIterator* _element_it = NULL;
		ValaCollection* _tmp4_;
		ValaIterator* _tmp5_;
		_tmp4_ = coll;
		_tmp5_ = vala_iterable_iterator ((ValaIterable*) _tmp4_);
		_element_it = _tmp5_;
		while (TRUE) {
			ValaIterator* _tmp6_;
			gboolean _tmp7_;
			glong element = 0L;
			ValaIterator* _tmp8_;
			gpointer _tmp9_;
			glong* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			glong _tmp12_;
			glong _tmp13_;
			_tmp6_ = _element_it;
			_tmp7_ = vala_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _element_it;
			_tmp9_ = vala_iterator_get (_tmp8_);
			element = (glong) ((gintptr) _tmp9_);
			_tmp10_ = array;
			_tmp10__length1 = array_length1;
			_tmp11_ = index;
			index = _tmp11_ + 1;
			_tmp12_ = element;
			_tmp10_[_tmp11_] = _tmp12_;
			_tmp13_ = _tmp10_[_tmp11_];
		}
		_vala_iterator_unref0 (_element_it);
	}
	_tmp14_ = array;
	_tmp14__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}


static gulong* vala_collection_to_ulong_array (ValaCollection* coll, int* result_length1) {
	gulong* result = NULL;
	gulong* array = NULL;
	ValaCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gulong* _tmp3_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gulong* _tmp14_;
	gint _tmp14__length1;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = coll;
	_tmp1_ = vala_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gulong, _tmp2_);
	array = _tmp3_;
	array_length1 = _tmp2_;
	_array_size_ = array_length1;
	index = 0;
	{
		ValaIterator* _element_it = NULL;
		ValaCollection* _tmp4_;
		ValaIterator* _tmp5_;
		_tmp4_ = coll;
		_tmp5_ = vala_iterable_iterator ((ValaIterable*) _tmp4_);
		_element_it = _tmp5_;
		while (TRUE) {
			ValaIterator* _tmp6_;
			gboolean _tmp7_;
			gulong element = 0UL;
			ValaIterator* _tmp8_;
			gpointer _tmp9_;
			gulong* _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			gulong _tmp12_;
			gulong _tmp13_;
			_tmp6_ = _element_it;
			_tmp7_ = vala_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _element_it;
			_tmp9_ = vala_iterator_get (_tmp8_);
			element = (gulong) ((guintptr) _tmp9_);
			_tmp10_ = array;
			_tmp10__length1 = array_length1;
			_tmp11_ = index;
			index = _tmp11_ + 1;
			_tmp12_ = element;
			_tmp10_[_tmp11_] = _tmp12_;
			_tmp13_ = _tmp10_[_tmp11_];
		}
		_vala_iterator_unref0 (_element_it);
	}
	_tmp14_ = array;
	_tmp14__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}


static gfloat** vala_collection_to_float_array (ValaCollection* coll, int* result_length1) {
	gfloat** result = NULL;
	gfloat** array = NULL;
	ValaCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gfloat** _tmp3_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gfloat** _tmp14_;
	gint _tmp14__length1;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = coll;
	_tmp1_ = vala_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gfloat*, _tmp2_);
	array = _tmp3_;
	array_length1 = _tmp2_;
	_array_size_ = array_length1;
	index = 0;
	{
		ValaIterator* _element_it = NULL;
		ValaCollection* _tmp4_;
		ValaIterator* _tmp5_;
		_tmp4_ = coll;
		_tmp5_ = vala_iterable_iterator ((ValaIterable*) _tmp4_);
		_element_it = _tmp5_;
		while (TRUE) {
			ValaIterator* _tmp6_;
			gboolean _tmp7_;
			gfloat* element = NULL;
			ValaIterator* _tmp8_;
			gpointer _tmp9_;
			gfloat** _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			gfloat* _tmp12_;
			gfloat* _tmp13_;
			_tmp6_ = _element_it;
			_tmp7_ = vala_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _element_it;
			_tmp9_ = vala_iterator_get (_tmp8_);
			element = (gfloat*) _tmp9_;
			_tmp10_ = array;
			_tmp10__length1 = array_length1;
			_tmp11_ = index;
			index = _tmp11_ + 1;
			_tmp12_ = element;
			element = NULL;
			_g_free0 (_tmp10_[_tmp11_]);
			_tmp10_[_tmp11_] = _tmp12_;
			_tmp13_ = _tmp10_[_tmp11_];
			_g_free0 (element);
		}
		_vala_iterator_unref0 (_element_it);
	}
	_tmp14_ = array;
	_tmp14__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}


static gdouble** vala_collection_to_double_array (ValaCollection* coll, int* result_length1) {
	gdouble** result = NULL;
	gdouble** array = NULL;
	ValaCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gdouble** _tmp3_;
	gint array_length1;
	gint _array_size_;
	gint index = 0;
	gdouble** _tmp14_;
	gint _tmp14__length1;
	g_return_val_if_fail (coll != NULL, NULL);
	_tmp0_ = coll;
	_tmp1_ = vala_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gdouble*, _tmp2_);
	array = _tmp3_;
	array_length1 = _tmp2_;
	_array_size_ = array_length1;
	index = 0;
	{
		ValaIterator* _element_it = NULL;
		ValaCollection* _tmp4_;
		ValaIterator* _tmp5_;
		_tmp4_ = coll;
		_tmp5_ = vala_iterable_iterator ((ValaIterable*) _tmp4_);
		_element_it = _tmp5_;
		while (TRUE) {
			ValaIterator* _tmp6_;
			gboolean _tmp7_;
			gdouble* element = NULL;
			ValaIterator* _tmp8_;
			gpointer _tmp9_;
			gdouble** _tmp10_;
			gint _tmp10__length1;
			gint _tmp11_;
			gdouble* _tmp12_;
			gdouble* _tmp13_;
			_tmp6_ = _element_it;
			_tmp7_ = vala_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _element_it;
			_tmp9_ = vala_iterator_get (_tmp8_);
			element = (gdouble*) _tmp9_;
			_tmp10_ = array;
			_tmp10__length1 = array_length1;
			_tmp11_ = index;
			index = _tmp11_ + 1;
			_tmp12_ = element;
			element = NULL;
			_g_free0 (_tmp10_[_tmp11_]);
			_tmp10_[_tmp11_] = _tmp12_;
			_tmp13_ = _tmp10_[_tmp11_];
			_g_free0 (element);
		}
		_vala_iterator_unref0 (_element_it);
	}
	_tmp14_ = array;
	_tmp14__length1 = array_length1;
	if (result_length1) {
		*result_length1 = _tmp14__length1;
	}
	result = _tmp14_;
	return result;
}


ValaCollection* vala_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	ValaCollection* self = NULL;
	self = (ValaCollection*) vala_iterable_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


gint vala_collection_get_size (ValaCollection* self) {
	g_return_val_if_fail (self != NULL, 0);
	return VALA_COLLECTION_GET_CLASS (self)->get_size (self);
}


gboolean vala_collection_get_is_empty (ValaCollection* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return VALA_COLLECTION_GET_CLASS (self)->get_is_empty (self);
}


static gboolean vala_collection_real_get_is_empty (ValaCollection* base) {
	gboolean result;
	ValaCollection* self;
	gint _tmp0_;
	gint _tmp1_;
	self = base;
	_tmp0_ = vala_collection_get_size (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == 0;
	return result;
}


static void vala_collection_class_init (ValaCollectionClass * klass) {
	vala_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCollectionPrivate));
	((ValaCollectionClass *) klass)->contains = (gboolean (*) (ValaCollection *, gconstpointer)) vala_collection_real_contains;
	((ValaCollectionClass *) klass)->add = (gboolean (*) (ValaCollection *, gconstpointer)) vala_collection_real_add;
	((ValaCollectionClass *) klass)->remove = (gboolean (*) (ValaCollection *, gconstpointer)) vala_collection_real_remove;
	((ValaCollectionClass *) klass)->clear = (void (*) (ValaCollection *)) vala_collection_real_clear;
	((ValaCollectionClass *) klass)->add_all = (gboolean (*) (ValaCollection *, ValaCollection*)) vala_collection_real_add_all;
	((ValaCollectionClass *) klass)->to_array = (gpointer* (*) (ValaCollection *, int*)) vala_collection_real_to_array;
	VALA_COLLECTION_CLASS (klass)->get_is_empty = vala_collection_real_get_is_empty;
}


static void vala_collection_instance_init (ValaCollection * self) {
	self->priv = VALA_COLLECTION_GET_PRIVATE (self);
}


/**
 * Serves as the base interface for implementing collection classes. Defines
 * size, iteration, and modification methods.
 */
GType vala_collection_get_type (void) {
	static volatile gsize vala_collection_type_id__volatile = 0;
	if (g_once_init_enter (&vala_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCollection), 0, (GInstanceInitFunc) vala_collection_instance_init, NULL };
		GType vala_collection_type_id;
		vala_collection_type_id = g_type_register_static (VALA_TYPE_ITERABLE, "ValaCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&vala_collection_type_id__volatile, vala_collection_type_id);
	}
	return vala_collection_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



