export type Parent = import('hast').Parent
export type Literal = import('hast').Literal
export type Root = import('hast').Root
export type Comment = import('hast').Comment
export type Element = import('hast').Element
export type Text = import('hast').Text
export type Raw = Literal & {
  type: 'raw'
}
export type Child = Parent['children'][number]
export type Properties = import('hast').Properties
export type PropertyValue = Properties[string]
export type Node = Child | Root
export type StringifyEntitiesOptions = import('stringify-entities').Options
export type Schema = import('property-information').Schema
export type Handle = (
  context: Context,
  node: Node,
  index: number | null,
  parent: Parent | null
) => string
export type OmitHandle = (
  node: Element,
  index: number | null,
  parent: Parent | null
) => boolean
export type Omission = {
  opening?: OmitHandle
  closing?: OmitHandle
}
export type Space = 'html' | 'svg'
export type Quote = '"' | "'"
export type Options = {
  /**
   * Whether the *root* of the *tree* is in the `'html'` or `'svg'` space. If an `svg` element is found in the HTML space, `toHtml` automatically switches to the SVG space when entering the element, and switches back when exiting
   */
  space?: Space
  /**
   * Configuration for `stringify-entities`
   */
  entities?: Omit<
    StringifyEntitiesOptions,
    'escapeOnly' | 'attribute' | 'subset'
  >
  /**
   * Tag names of *elements* to serialize without closing tag. Not used in the SVG space. Defaults to `html-void-elements`
   */
  voids?: Array<string>
  /**
   * Use a `<!DOCTYPE…` instead of `<!doctype…`. Useless except for XHTML
   */
  upperDoctype?: boolean
  /**
   * Preferred quote to use
   */
  quote?: Quote
  /**
   * Use the other quote if that results in less bytes
   */
  quoteSmart?: boolean
  /**
   * Leave attributes unquoted if that results in less bytes. Not used in the SVG space
   */
  preferUnquoted?: boolean
  /**
   * Omit optional opening and closing tags. For example, in `<ol><li>one</li><li>two</li></ol>`, both `</li>` closing tags can be omitted. The first because it’s followed by another `li`, the last because it’s followed by nothing. Not used in the SVG space
   */
  omitOptionalTags?: boolean
  /**
   * Collapse empty attributes: `class=""` is stringified as `class` instead. **Note**: boolean attributes, such as `hidden`, are always collapsed. Not used in the SVG space
   */
  collapseEmptyAttributes?: boolean
  /**
   * Close self-closing nodes with an extra slash (`/`): `<img />` instead of `<img>`. See `tightSelfClosing` to control whether a space is used before the slash. Not used in the SVG space
   */
  closeSelfClosing?: boolean
  /**
   * Close SVG elements without any content with slash (`/`) on the opening tag instead of an end tag: `<circle />` instead of `<circle></circle>`. See `tightSelfClosing` to control whether a space is used before the slash. Not used in the HTML space
   */
  closeEmptyElements?: boolean
  /**
   * Do not use an extra space when closing self-closing elements: `<img/>` instead of `<img />`. **Note**: Only used if `closeSelfClosing: true` or `closeEmptyElements: true`
   */
  tightSelfClosing?: boolean
  /**
   * Join known comma-separated attribute values with just a comma (`,`), instead of padding them on the right as well (`,·`, where `·` represents a space)
   */
  tightCommaSeparatedLists?: boolean
  /**
   * Join attributes together, without whitespace, if possible: `class="a b" title="c d"` is stringified as `class="a b"title="c d"` instead to save bytes. **Note**: creates invalid (but working) markup. Not used in the SVG space
   */
  tightAttributes?: boolean
  /**
   * Drop unneeded spaces in doctypes: `<!doctypehtml>` instead of `<!doctype html>` to save bytes. **Note**: creates invalid (but working) markup
   */
  tightDoctype?: boolean
  /**
   * Use “bogus comments” instead of comments to save byes: `<?charlie>` instead of `<!--charlie-->`. **Note**: creates invalid (but working) markup
   */
  bogusComments?: boolean
  /**
   * Do not encode characters which cause parse errors (even though they work), to save bytes. **Note**: creates invalid (but working) markup. Not used in the SVG space
   */
  allowParseErrors?: boolean
  /**
   * Do not encode some characters which cause XSS vulnerabilities in older browsers. **Note**: Only set this if you completely trust the content
   */
  allowDangerousCharacters?: boolean
  /**
   * Allow `raw` nodes and insert them as raw HTML. When falsey, encodes `raw` nodes. **Note**: Only set this if you completely trust the content
   */
  allowDangerousHtml?: boolean
}
export type Context = {
  valid: number
  safe: number
  schema: Schema
  omit: Omission
  quote: Quote
  alternative: Quote
  smart: boolean
  unquoted: boolean
  tight: boolean
  upperDoctype: boolean
  tightDoctype: boolean
  bogusComments: boolean
  tightLists: boolean
  tightClose: boolean
  collapseEmpty: boolean
  dangerous: boolean
  voids: Array<string>
  entities: StringifyEntitiesOptions
  close: boolean
  closeEmpty: boolean
}
