/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.repository.url;

import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.url.URLHandler;
import fr.jayasoft.ivy.url.URLHandlerRegistry;
import java.net.URL;

public class URLResource
implements Resource {
    private URL _url;
    private boolean _init = false;
    private long _lastModified;
    private long _contentLength;
    private boolean _exists;

    public URLResource(URL url) {
        this._url = url;
    }

    public String getName() {
        return this._url.toExternalForm();
    }

    public long getLastModified() {
        if (!this._init) {
            this.init();
        }
        return this._lastModified;
    }

    private void init() {
        URLHandler.URLInfo info = URLHandlerRegistry.getDefault().getURLInfo(this._url);
        this._contentLength = info.getContentLength();
        this._lastModified = info.getLastModified();
        this._exists = info.isReachable();
        this._init = true;
    }

    public long getContentLength() {
        if (!this._init) {
            this.init();
        }
        return this._contentLength;
    }

    public boolean exists() {
        if (!this._init) {
            this.init();
        }
        return this._exists;
    }

    public URL getURL() {
        return this._url;
    }

    public String toString() {
        return this.getName();
    }
}

