<!-- Stylesheet to be executed client-side to supply the navigation menu in each page -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    
  <xsl:output method="html"/>  
    
  <xsl:variable name="img" select="'../img'"/>
     
  <xsl:template match="*">
    <xsl:copy>
        <xsl:copy-of select="@*"/>
        <xsl:apply-templates/>
    </xsl:copy>
  </xsl:template>
  
  <xsl:template match="this-is"/>     
    
 <xsl:template match="div[@id='MenuArea']">
    <xsl:variable name="this-page" select="(//this-is)[1]"/>
    <xsl:variable name="path-prefix">
        <xsl:choose>
            <xsl:when test="$this-page/@subpage=''">../</xsl:when>
            <xsl:otherwise>../../</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="short-prefix">
        <xsl:choose>
            <xsl:when test="$this-page/@subpage=''"></xsl:when>
            <xsl:otherwise>../</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:copy>
        <xsl:copy-of select="@*"/>
            <table width="164" border="0" bgcolor="#3D5B96" cellspacing="1" cellpadding="1"></table>
            <br/>
            <table border="0" cellspacing="0" cellpadding="0">
              <tr>
                <td class="title" colspan="2">
                  <a href="{$path-prefix}../index.xml">Saxon Documentation</a>
                </td>
              </tr>
              <tr>
                <td colspan="2">
                  <img src="{$path-prefix}{$img}/spacer.gif" width="120" height="10" border="0" alt=""/>
                </td>
              </tr>
              <tr>
                <td colspan="2">
                  <a href="{$path-prefix}contents.html">Full Contents</a>
                </td>
              </tr>
              <tr>
                <td colspan="2">
                  <img src="{$path-prefix}{$img}/text_blue_dot.gif" width="164" height="1" border="0" alt=""/>
                </td>
              </tr>
              <xsl:for-each select="document('contents.xml')/*/section">
                <tr>
                  <td colspan="2"><a href="{$path-prefix}{@name}/intro.xml"><xsl:value-of select="@title"/></a></td>
                </tr>
        
                <xsl:if test="@name = $this-page/@section">
                  <xsl:for-each select="page">
                    <tr>
                      <td>
                        <xsl:choose>
                          <xsl:when test="@name = $this-page/@page">&#xbb;&#xa0;</xsl:when>
                          <xsl:otherwise>
                            <img src="{$path-prefix}{$img}/spacer.gif" width="10" height="5" border="0"
                              alt="blank space"/>
                          </xsl:otherwise>
                        </xsl:choose>
                      </td>
                      <td>
                         <a href="{$short-prefix}{@name}.xml"><xsl:value-of select="@title"/></a>
                      </td>
                    </tr>
                  </xsl:for-each>
                </xsl:if>
                <tr>
                  <td colspan="2">
                    <img src="{$path-prefix}{$img}/text_blue_dot.gif" width="164" height="1" border="0"
                      alt=""/>
                  </td>
                </tr>
              </xsl:for-each>
            </table>
      </xsl:copy>
  </xsl:template>
  
  </xsl:stylesheet>