// Copyright 2018 The Mangos Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use file except in compliance with the License.
// You may obtain a copy of the license at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Package mangos provides a pure Go implementation of the Scalability
// Protocols.  These are more commonly known as "nanomsg" which is the
// C-based software package that is also their reference implementation.
//
// These protocols facilitate the rapid creation of applications which
// rely on multiple participants in sometimes complex communications
// topologies, including Request/Reply, Publish/Subscribe, Push/Pull,
// Surveyor/Respondent, etc.
//
// For more information, see www.nanomsg.org.
//
package mangos
