// Code generated by "precompile.go". DO NOT EDIT.

package rulesdata

import "github.com/quasilyte/go-ruleguard/ruleguard/ir"

var PrecompiledRules = &ir.File{
	PkgPath:       "gorules",
	CustomDecls:   []string{},
	BundleImports: []ir.BundleImport{},
	RuleGroups: []ir.RuleGroup{
		{
			Line:        11,
			Name:        "redundantSprint",
			MatcherName: "m",
			DocTags:     []string{"style", "experimental"},
			DocSummary:  "Detects redundant fmt.Sprint calls",
			DocBefore:   "fmt.Sprint(x)",
			DocAfter:    "x.String()",
			Rules: []ir.Rule{
				{
					Line: 12,
					SyntaxPatterns: []ir.PatternString{
						{Line: 12, Value: "fmt.Sprint($x)"},
						{Line: 12, Value: "fmt.Sprintf(\"%s\", $x)"},
						{Line: 12, Value: "fmt.Sprintf(\"%v\", $x)"},
					},
					ReportTemplate:  "use $x.String() instead",
					SuggestTemplate: "$x.String()",
					WhereExpr: ir.FilterExpr{
						Line: 13,
						Op:   ir.FilterAndOp,
						Src:  "!m[\"x\"].Type.Is(`reflect.Value`) && m[\"x\"].Type.Implements(`fmt.Stringer`)",
						Args: []ir.FilterExpr{
							{
								Line: 13,
								Op:   ir.FilterNotOp,
								Src:  "!m[\"x\"].Type.Is(`reflect.Value`)",
								Args: []ir.FilterExpr{{
									Line:  13,
									Op:    ir.FilterVarTypeIsOp,
									Src:   "m[\"x\"].Type.Is(`reflect.Value`)",
									Value: "x",
									Args:  []ir.FilterExpr{{Line: 13, Op: ir.FilterStringOp, Src: "`reflect.Value`", Value: "reflect.Value"}},
								}},
							},
							{
								Line:  13,
								Op:    ir.FilterVarTypeImplementsOp,
								Src:   "m[\"x\"].Type.Implements(`fmt.Stringer`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 13, Op: ir.FilterStringOp, Src: "`fmt.Stringer`", Value: "fmt.Stringer"}},
							},
						},
					},
				},
				{
					Line: 17,
					SyntaxPatterns: []ir.PatternString{
						{Line: 17, Value: "fmt.Sprint($x)"},
						{Line: 17, Value: "fmt.Sprintf(\"%s\", $x)"},
						{Line: 17, Value: "fmt.Sprintf(\"%v\", $x)"},
					},
					ReportTemplate:  "use $x.Error() instead",
					SuggestTemplate: "$x.Error()",
					WhereExpr: ir.FilterExpr{
						Line:  18,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"x\"].Type.Implements(`error`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 18, Op: ir.FilterStringOp, Src: "`error`", Value: "error"}},
					},
				},
				{
					Line: 22,
					SyntaxPatterns: []ir.PatternString{
						{Line: 22, Value: "fmt.Sprint($x)"},
						{Line: 22, Value: "fmt.Sprintf(\"%s\", $x)"},
						{Line: 22, Value: "fmt.Sprintf(\"%v\", $x)"},
					},
					ReportTemplate:  "$x is already string",
					SuggestTemplate: "$x",
					WhereExpr: ir.FilterExpr{
						Line:  23,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`string`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 23, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
					},
				},
			},
		},
		{
			Line:        32,
			Name:        "deferUnlambda",
			MatcherName: "m",
			DocTags:     []string{"style", "experimental"},
			DocSummary:  "Detects deferred function literals that can be simplified",
			DocBefore:   "defer func() { f() }()",
			DocAfter:    "defer f()",
			Rules: []ir.Rule{
				{
					Line:           33,
					SyntaxPatterns: []ir.PatternString{{Line: 33, Value: "defer func() { $f($*args) }()"}},
					ReportTemplate: "can rewrite as `defer $f($args)`",
					WhereExpr: ir.FilterExpr{
						Line: 34,
						Op:   ir.FilterAndOp,
						Src:  "m[\"f\"].Node.Is(`Ident`) && m[\"f\"].Text != \"panic\" && m[\"f\"].Text != \"recover\" && m[\"args\"].Const",
						Args: []ir.FilterExpr{
							{
								Line: 34,
								Op:   ir.FilterAndOp,
								Src:  "m[\"f\"].Node.Is(`Ident`) && m[\"f\"].Text != \"panic\" && m[\"f\"].Text != \"recover\"",
								Args: []ir.FilterExpr{
									{
										Line: 34,
										Op:   ir.FilterAndOp,
										Src:  "m[\"f\"].Node.Is(`Ident`) && m[\"f\"].Text != \"panic\"",
										Args: []ir.FilterExpr{
											{
												Line:  34,
												Op:    ir.FilterVarNodeIsOp,
												Src:   "m[\"f\"].Node.Is(`Ident`)",
												Value: "f",
												Args:  []ir.FilterExpr{{Line: 34, Op: ir.FilterStringOp, Src: "`Ident`", Value: "Ident"}},
											},
											{
												Line: 34,
												Op:   ir.FilterNeqOp,
												Src:  "m[\"f\"].Text != \"panic\"",
												Args: []ir.FilterExpr{
													{Line: 34, Op: ir.FilterVarTextOp, Src: "m[\"f\"].Text", Value: "f"},
													{Line: 34, Op: ir.FilterStringOp, Src: "\"panic\"", Value: "panic"},
												},
											},
										},
									},
									{
										Line: 34,
										Op:   ir.FilterNeqOp,
										Src:  "m[\"f\"].Text != \"recover\"",
										Args: []ir.FilterExpr{
											{Line: 34, Op: ir.FilterVarTextOp, Src: "m[\"f\"].Text", Value: "f"},
											{Line: 34, Op: ir.FilterStringOp, Src: "\"recover\"", Value: "recover"},
										},
									},
								},
							},
							{
								Line:  34,
								Op:    ir.FilterVarConstOp,
								Src:   "m[\"args\"].Const",
								Value: "args",
							},
						},
					},
				},
				{
					Line:           37,
					SyntaxPatterns: []ir.PatternString{{Line: 37, Value: "defer func() { $pkg.$f($*args) }()"}},
					ReportTemplate: "can rewrite as `defer $pkg.$f($args)`",
					WhereExpr: ir.FilterExpr{
						Line: 38,
						Op:   ir.FilterAndOp,
						Src:  "m[\"f\"].Node.Is(`Ident`) && m[\"args\"].Const && m[\"pkg\"].Object.Is(`PkgName`)",
						Args: []ir.FilterExpr{
							{
								Line: 38,
								Op:   ir.FilterAndOp,
								Src:  "m[\"f\"].Node.Is(`Ident`) && m[\"args\"].Const",
								Args: []ir.FilterExpr{
									{
										Line:  38,
										Op:    ir.FilterVarNodeIsOp,
										Src:   "m[\"f\"].Node.Is(`Ident`)",
										Value: "f",
										Args:  []ir.FilterExpr{{Line: 38, Op: ir.FilterStringOp, Src: "`Ident`", Value: "Ident"}},
									},
									{
										Line:  38,
										Op:    ir.FilterVarConstOp,
										Src:   "m[\"args\"].Const",
										Value: "args",
									},
								},
							},
							{
								Line:  38,
								Op:    ir.FilterVarObjectIsOp,
								Src:   "m[\"pkg\"].Object.Is(`PkgName`)",
								Value: "pkg",
								Args:  []ir.FilterExpr{{Line: 38, Op: ir.FilterStringOp, Src: "`PkgName`", Value: "PkgName"}},
							},
						},
					},
				},
			},
		},
		{
			Line:        46,
			Name:        "ioutilDeprecated",
			MatcherName: "m",
			DocTags:     []string{"style", "experimental"},
			DocSummary:  "Detects deprecated io/ioutil package usages",
			DocBefore:   "ioutil.ReadAll(r)",
			DocAfter:    "io.ReadAll(r)",
			Rules: []ir.Rule{
				{
					Line:           47,
					SyntaxPatterns: []ir.PatternString{{Line: 47, Value: "ioutil.ReadAll($_)"}},
					ReportTemplate: "ioutil.ReadAll is deprecated, use io.ReadAll instead",
					WhereExpr: ir.FilterExpr{
						Line:  48,
						Op:    ir.FilterGoVersionGreaterEqThanOp,
						Src:   "m.GoVersion().GreaterEqThan(\"1.16\")",
						Value: "1.16",
					},
				},
				{
					Line:           51,
					SyntaxPatterns: []ir.PatternString{{Line: 51, Value: "ioutil.ReadFile($_)"}},
					ReportTemplate: "ioutil.ReadFile is deprecated, use os.ReadFile instead",
					WhereExpr: ir.FilterExpr{
						Line:  52,
						Op:    ir.FilterGoVersionGreaterEqThanOp,
						Src:   "m.GoVersion().GreaterEqThan(\"1.16\")",
						Value: "1.16",
					},
				},
				{
					Line:           55,
					SyntaxPatterns: []ir.PatternString{{Line: 55, Value: "ioutil.WriteFile($_, $_, $_)"}},
					ReportTemplate: "ioutil.WriteFile is deprecated, use os.WriteFile instead",
					WhereExpr: ir.FilterExpr{
						Line:  56,
						Op:    ir.FilterGoVersionGreaterEqThanOp,
						Src:   "m.GoVersion().GreaterEqThan(\"1.16\")",
						Value: "1.16",
					},
				},
				{
					Line:           59,
					SyntaxPatterns: []ir.PatternString{{Line: 59, Value: "ioutil.ReadDir($_)"}},
					ReportTemplate: "ioutil.ReadDir is deprecated, use os.ReadDir instead",
					WhereExpr: ir.FilterExpr{
						Line:  60,
						Op:    ir.FilterGoVersionGreaterEqThanOp,
						Src:   "m.GoVersion().GreaterEqThan(\"1.16\")",
						Value: "1.16",
					},
				},
				{
					Line:           63,
					SyntaxPatterns: []ir.PatternString{{Line: 63, Value: "ioutil.NopCloser($_)"}},
					ReportTemplate: "ioutil.NopCloser is deprecated, use io.NopCloser instead",
					WhereExpr: ir.FilterExpr{
						Line:  64,
						Op:    ir.FilterGoVersionGreaterEqThanOp,
						Src:   "m.GoVersion().GreaterEqThan(\"1.16\")",
						Value: "1.16",
					},
				},
				{
					Line:           67,
					SyntaxPatterns: []ir.PatternString{{Line: 67, Value: "ioutil.Discard"}},
					ReportTemplate: "ioutil.Discard is deprecated, use io.Discard instead",
					WhereExpr: ir.FilterExpr{
						Line:  68,
						Op:    ir.FilterGoVersionGreaterEqThanOp,
						Src:   "m.GoVersion().GreaterEqThan(\"1.16\")",
						Value: "1.16",
					},
				},
			},
		},
		{
			Line:        76,
			Name:        "badLock",
			MatcherName: "m",
			DocTags:     []string{"diagnostic", "experimental"},
			DocSummary:  "Detects suspicious mutex lock/unlock operations",
			DocBefore:   "mu.Lock(); mu.Unlock()",
			DocAfter:    "mu.Lock(); defer mu.Unlock()",
			Rules: []ir.Rule{
				{
					Line:           80,
					SyntaxPatterns: []ir.PatternString{{Line: 80, Value: "$mu1.Lock(); $mu2.Unlock()"}},
					ReportTemplate: "defer is missing, mutex is unlocked immediately",
					WhereExpr: ir.FilterExpr{
						Line: 81,
						Op:   ir.FilterEqOp,
						Src:  "m[\"mu1\"].Text == m[\"mu2\"].Text",
						Args: []ir.FilterExpr{
							{Line: 81, Op: ir.FilterVarTextOp, Src: "m[\"mu1\"].Text", Value: "mu1"},
							{Line: 81, Op: ir.FilterVarTextOp, Src: "m[\"mu2\"].Text", Value: "mu2"},
						},
					},
					LocationVar: "mu2",
				},
				{
					Line:           85,
					SyntaxPatterns: []ir.PatternString{{Line: 85, Value: "$mu1.RLock(); $mu2.RUnlock()"}},
					ReportTemplate: "defer is missing, mutex is unlocked immediately",
					WhereExpr: ir.FilterExpr{
						Line: 86,
						Op:   ir.FilterEqOp,
						Src:  "m[\"mu1\"].Text == m[\"mu2\"].Text",
						Args: []ir.FilterExpr{
							{Line: 86, Op: ir.FilterVarTextOp, Src: "m[\"mu1\"].Text", Value: "mu1"},
							{Line: 86, Op: ir.FilterVarTextOp, Src: "m[\"mu2\"].Text", Value: "mu2"},
						},
					},
					LocationVar: "mu2",
				},
				{
					Line:           91,
					SyntaxPatterns: []ir.PatternString{{Line: 91, Value: "$mu1.Lock(); defer $mu2.RUnlock()"}},
					ReportTemplate: "suspicious unlock, maybe Unlock was intended?",
					WhereExpr: ir.FilterExpr{
						Line: 92,
						Op:   ir.FilterEqOp,
						Src:  "m[\"mu1\"].Text == m[\"mu2\"].Text",
						Args: []ir.FilterExpr{
							{Line: 92, Op: ir.FilterVarTextOp, Src: "m[\"mu1\"].Text", Value: "mu1"},
							{Line: 92, Op: ir.FilterVarTextOp, Src: "m[\"mu2\"].Text", Value: "mu2"},
						},
					},
					LocationVar: "mu2",
				},
				{
					Line:           96,
					SyntaxPatterns: []ir.PatternString{{Line: 96, Value: "$mu1.RLock(); defer $mu2.Unlock()"}},
					ReportTemplate: "suspicious unlock, maybe RUnlock was intended?",
					WhereExpr: ir.FilterExpr{
						Line: 97,
						Op:   ir.FilterEqOp,
						Src:  "m[\"mu1\"].Text == m[\"mu2\"].Text",
						Args: []ir.FilterExpr{
							{Line: 97, Op: ir.FilterVarTextOp, Src: "m[\"mu1\"].Text", Value: "mu1"},
							{Line: 97, Op: ir.FilterVarTextOp, Src: "m[\"mu2\"].Text", Value: "mu2"},
						},
					},
					LocationVar: "mu2",
				},
				{
					Line:           102,
					SyntaxPatterns: []ir.PatternString{{Line: 102, Value: "$mu1.Lock(); defer $mu2.Lock()"}},
					ReportTemplate: "maybe defer $mu1.Unlock() was intended?",
					WhereExpr: ir.FilterExpr{
						Line: 103,
						Op:   ir.FilterEqOp,
						Src:  "m[\"mu1\"].Text == m[\"mu2\"].Text",
						Args: []ir.FilterExpr{
							{Line: 103, Op: ir.FilterVarTextOp, Src: "m[\"mu1\"].Text", Value: "mu1"},
							{Line: 103, Op: ir.FilterVarTextOp, Src: "m[\"mu2\"].Text", Value: "mu2"},
						},
					},
					LocationVar: "mu2",
				},
				{
					Line:           107,
					SyntaxPatterns: []ir.PatternString{{Line: 107, Value: "$mu1.RLock(); defer $mu2.RLock()"}},
					ReportTemplate: "maybe defer $mu1.RUnlock() was intended?",
					WhereExpr: ir.FilterExpr{
						Line: 108,
						Op:   ir.FilterEqOp,
						Src:  "m[\"mu1\"].Text == m[\"mu2\"].Text",
						Args: []ir.FilterExpr{
							{Line: 108, Op: ir.FilterVarTextOp, Src: "m[\"mu1\"].Text", Value: "mu1"},
							{Line: 108, Op: ir.FilterVarTextOp, Src: "m[\"mu2\"].Text", Value: "mu2"},
						},
					},
					LocationVar: "mu2",
				},
			},
		},
		{
			Line:        117,
			Name:        "httpNoBody",
			MatcherName: "m",
			DocTags:     []string{"style", "experimental"},
			DocSummary:  "Detects nil usages in http.NewRequest calls, suggesting http.NoBody as an alternative",
			DocBefore:   "http.NewRequest(\"GET\", url, nil)",
			DocAfter:    "http.NewRequest(\"GET\", url, http.NoBody)",
			Rules: []ir.Rule{
				{
					Line:            118,
					SyntaxPatterns:  []ir.PatternString{{Line: 118, Value: "http.NewRequest($method, $url, $nil)"}},
					ReportTemplate:  "http.NoBody should be preferred to the nil request body",
					SuggestTemplate: "http.NewRequest($method, $url, http.NoBody)",
					WhereExpr: ir.FilterExpr{
						Line: 119,
						Op:   ir.FilterEqOp,
						Src:  "m[\"nil\"].Text == \"nil\"",
						Args: []ir.FilterExpr{
							{Line: 119, Op: ir.FilterVarTextOp, Src: "m[\"nil\"].Text", Value: "nil"},
							{Line: 119, Op: ir.FilterStringOp, Src: "\"nil\"", Value: "nil"},
						},
					},
				},
				{
					Line:            123,
					SyntaxPatterns:  []ir.PatternString{{Line: 123, Value: "http.NewRequestWithContext($ctx, $method, $url, $nil)"}},
					ReportTemplate:  "http.NoBody should be preferred to the nil request body",
					SuggestTemplate: "http.NewRequestWithContext($ctx, $method, $url, http.NoBody)",
					WhereExpr: ir.FilterExpr{
						Line: 124,
						Op:   ir.FilterEqOp,
						Src:  "m[\"nil\"].Text == \"nil\"",
						Args: []ir.FilterExpr{
							{Line: 124, Op: ir.FilterVarTextOp, Src: "m[\"nil\"].Text", Value: "nil"},
							{Line: 124, Op: ir.FilterStringOp, Src: "\"nil\"", Value: "nil"},
						},
					},
				},
			},
		},
		{
			Line:        134,
			Name:        "preferDecodeRune",
			MatcherName: "m",
			DocTags:     []string{"performance", "experimental"},
			DocSummary:  "Detects expressions like []rune(s)[0] that may cause unwanted rune slice allocation",
			DocBefore:   "r := []rune(s)[0]",
			DocAfter:    "r, _ := utf8.DecodeRuneInString(s)",
			DocNote:     "See Go issue for details: https://github.com/golang/go/issues/45260",
			Rules: []ir.Rule{{
				Line:           135,
				SyntaxPatterns: []ir.PatternString{{Line: 135, Value: "[]rune($s)[0]"}},
				ReportTemplate: "consider replacing $$ with utf8.DecodeRuneInString($s)",
				WhereExpr: ir.FilterExpr{
					Line:  136,
					Op:    ir.FilterVarTypeIsOp,
					Src:   "m[\"s\"].Type.Is(`string`)",
					Value: "s",
					Args:  []ir.FilterExpr{{Line: 136, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
				},
			}},
		},
		{
			Line:        144,
			Name:        "sloppyLen",
			MatcherName: "m",
			DocTags:     []string{"style"},
			DocSummary:  "Detects usage of `len` when result is obvious or doesn't make sense",
			DocBefore:   "len(arr) <= 0",
			DocAfter:    "len(arr) == 0",
			Rules: []ir.Rule{
				{
					Line:           145,
					SyntaxPatterns: []ir.PatternString{{Line: 145, Value: "len($_) >= 0"}},
					ReportTemplate: "$$ is always true",
				},
				{
					Line:           146,
					SyntaxPatterns: []ir.PatternString{{Line: 146, Value: "len($_) < 0"}},
					ReportTemplate: "$$ is always false",
				},
				{
					Line:           147,
					SyntaxPatterns: []ir.PatternString{{Line: 147, Value: "len($x) <= 0"}},
					ReportTemplate: "$$ can be len($x) == 0",
				},
			},
		},
		{
			Line:        154,
			Name:        "valSwap",
			MatcherName: "m",
			DocTags:     []string{"style"},
			DocSummary:  "Detects value swapping code that are not using parallel assignment",
			DocBefore:   "*tmp = *x; *x = *y; *y = *tmp",
			DocAfter:    "*x, *y = *y, *x",
			Rules: []ir.Rule{{
				Line:           155,
				SyntaxPatterns: []ir.PatternString{{Line: 155, Value: "$tmp := $y; $y = $x; $x = $tmp"}},
				ReportTemplate: "can re-write as `$y, $x = $x, $y`",
			}},
		},
		{
			Line:        163,
			Name:        "switchTrue",
			MatcherName: "m",
			DocTags:     []string{"style"},
			DocSummary:  "Detects switch-over-bool statements that use explicit `true` tag value",
			DocBefore:   "switch true {...}",
			DocAfter:    "switch {...}",
			Rules: []ir.Rule{
				{
					Line:           164,
					SyntaxPatterns: []ir.PatternString{{Line: 164, Value: "switch true { $*_ }"}},
					ReportTemplate: "replace 'switch true {}' with 'switch {}'",
				},
				{
					Line:           166,
					SyntaxPatterns: []ir.PatternString{{Line: 166, Value: "switch $x; true { $*_ }"}},
					ReportTemplate: "replace 'switch $x; true {}' with 'switch $x; {}'",
				},
			},
		},
		{
			Line:        174,
			Name:        "flagDeref",
			MatcherName: "m",
			DocTags:     []string{"diagnostic"},
			DocSummary:  "Detects immediate dereferencing of `flag` package pointers",
			DocBefore:   "b := *flag.Bool(\"b\", false, \"b docs\")",
			DocAfter:    "var b bool; flag.BoolVar(&b, \"b\", false, \"b docs\")",
			Rules: []ir.Rule{
				{
					Line:           175,
					SyntaxPatterns: []ir.PatternString{{Line: 175, Value: "*flag.Bool($*_)"}},
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.BoolVar",
				},
				{
					Line:           176,
					SyntaxPatterns: []ir.PatternString{{Line: 176, Value: "*flag.Duration($*_)"}},
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.DurationVar",
				},
				{
					Line:           177,
					SyntaxPatterns: []ir.PatternString{{Line: 177, Value: "*flag.Float64($*_)"}},
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.Float64Var",
				},
				{
					Line:           178,
					SyntaxPatterns: []ir.PatternString{{Line: 178, Value: "*flag.Int($*_)"}},
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.IntVar",
				},
				{
					Line:           179,
					SyntaxPatterns: []ir.PatternString{{Line: 179, Value: "*flag.Int64($*_)"}},
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.Int64Var",
				},
				{
					Line:           180,
					SyntaxPatterns: []ir.PatternString{{Line: 180, Value: "*flag.String($*_)"}},
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.StringVar",
				},
				{
					Line:           181,
					SyntaxPatterns: []ir.PatternString{{Line: 181, Value: "*flag.Uint($*_)"}},
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.UintVar",
				},
				{
					Line:           182,
					SyntaxPatterns: []ir.PatternString{{Line: 182, Value: "*flag.Uint64($*_)"}},
					ReportTemplate: "immediate deref in $$ is most likely an error; consider using flag.Uint64Var",
				},
			},
		},
		{
			Line:        189,
			Name:        "emptyStringTest",
			MatcherName: "m",
			DocTags:     []string{"style", "experimental"},
			DocSummary:  "Detects empty string checks that can be written more idiomatically",
			DocBefore:   "len(s) == 0",
			DocAfter:    "s == \"\"",
			Rules: []ir.Rule{
				{
					Line:           190,
					SyntaxPatterns: []ir.PatternString{{Line: 190, Value: "len($s) != 0"}},
					ReportTemplate: "replace `$$` with `$s != \"\"`",
					WhereExpr: ir.FilterExpr{
						Line:  191,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"s\"].Type.Is(`string`)",
						Value: "s",
						Args:  []ir.FilterExpr{{Line: 191, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
					},
				},
				{
					Line:           194,
					SyntaxPatterns: []ir.PatternString{{Line: 194, Value: "len($s) == 0"}},
					ReportTemplate: "replace `$$` with `$s == \"\"`",
					WhereExpr: ir.FilterExpr{
						Line:  195,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"s\"].Type.Is(`string`)",
						Value: "s",
						Args:  []ir.FilterExpr{{Line: 195, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
					},
				},
			},
		},
		{
			Line:        203,
			Name:        "stringXbytes",
			MatcherName: "m",
			DocTags:     []string{"performance"},
			DocSummary:  "Detects redundant conversions between string and []byte",
			DocBefore:   "copy(b, []byte(s))",
			DocAfter:    "copy(b, s)",
			Rules: []ir.Rule{
				{
					Line:           204,
					SyntaxPatterns: []ir.PatternString{{Line: 204, Value: "copy($_, []byte($s))"}},
					ReportTemplate: "can simplify `[]byte($s)` to `$s`",
				},
				{
					Line:            206,
					SyntaxPatterns:  []ir.PatternString{{Line: 206, Value: "string($b) == \"\""}},
					ReportTemplate:  "suggestion: len($b) == 0",
					SuggestTemplate: "len($b) == 0",
					WhereExpr: ir.FilterExpr{
						Line:  206,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"b\"].Type.Is(`[]byte`)",
						Value: "b",
						Args:  []ir.FilterExpr{{Line: 206, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
					},
				},
				{
					Line:            207,
					SyntaxPatterns:  []ir.PatternString{{Line: 207, Value: "string($b) != \"\""}},
					ReportTemplate:  "suggestion: len($b) != 0",
					SuggestTemplate: "len($b) != 0",
					WhereExpr: ir.FilterExpr{
						Line:  207,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"b\"].Type.Is(`[]byte`)",
						Value: "b",
						Args:  []ir.FilterExpr{{Line: 207, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
					},
				},
				{
					Line:            209,
					SyntaxPatterns:  []ir.PatternString{{Line: 209, Value: "len(string($b))"}},
					ReportTemplate:  "suggestion: len($b)",
					SuggestTemplate: "len($b)",
					WhereExpr: ir.FilterExpr{
						Line:  209,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"b\"].Type.Is(`[]byte`)",
						Value: "b",
						Args:  []ir.FilterExpr{{Line: 209, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
					},
				},
				{
					Line:            211,
					SyntaxPatterns:  []ir.PatternString{{Line: 211, Value: "string($x) == string($y)"}},
					ReportTemplate:  "suggestion: bytes.Equal($x, $y)",
					SuggestTemplate: "bytes.Equal($x, $y)",
					WhereExpr: ir.FilterExpr{
						Line: 212,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Type.Is(`[]byte`) && m[\"y\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line:  212,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`[]byte`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 212, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
							{
								Line:  212,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"y\"].Type.Is(`[]byte`)",
								Value: "y",
								Args:  []ir.FilterExpr{{Line: 212, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            215,
					SyntaxPatterns:  []ir.PatternString{{Line: 215, Value: "string($x) != string($y)"}},
					ReportTemplate:  "suggestion: !bytes.Equal($x, $y)",
					SuggestTemplate: "!bytes.Equal($x, $y)",
					WhereExpr: ir.FilterExpr{
						Line: 216,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Type.Is(`[]byte`) && m[\"y\"].Type.Is(`[]byte`)",
						Args: []ir.FilterExpr{
							{
								Line:  216,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`[]byte`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 216, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
							{
								Line:  216,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"y\"].Type.Is(`[]byte`)",
								Value: "y",
								Args:  []ir.FilterExpr{{Line: 216, Op: ir.FilterStringOp, Src: "`[]byte`", Value: "[]byte"}},
							},
						},
					},
				},
				{
					Line:            219,
					SyntaxPatterns:  []ir.PatternString{{Line: 219, Value: "$re.Match([]byte($s))"}},
					ReportTemplate:  "suggestion: $re.MatchString($s)",
					SuggestTemplate: "$re.MatchString($s)",
					WhereExpr: ir.FilterExpr{
						Line: 220,
						Op:   ir.FilterAndOp,
						Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"s\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line:  220,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"re\"].Type.Is(`*regexp.Regexp`)",
								Value: "re",
								Args:  []ir.FilterExpr{{Line: 220, Op: ir.FilterStringOp, Src: "`*regexp.Regexp`", Value: "*regexp.Regexp"}},
							},
							{
								Line:  220,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 220, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            223,
					SyntaxPatterns:  []ir.PatternString{{Line: 223, Value: "$re.FindIndex([]byte($s))"}},
					ReportTemplate:  "suggestion: $re.FindStringIndex($s)",
					SuggestTemplate: "$re.FindStringIndex($s)",
					WhereExpr: ir.FilterExpr{
						Line: 224,
						Op:   ir.FilterAndOp,
						Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"s\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line:  224,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"re\"].Type.Is(`*regexp.Regexp`)",
								Value: "re",
								Args:  []ir.FilterExpr{{Line: 224, Op: ir.FilterStringOp, Src: "`*regexp.Regexp`", Value: "*regexp.Regexp"}},
							},
							{
								Line:  224,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 224, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
				{
					Line:            227,
					SyntaxPatterns:  []ir.PatternString{{Line: 227, Value: "$re.FindAllIndex([]byte($s), $n)"}},
					ReportTemplate:  "suggestion: $re.FindAllStringIndex($s, $n)",
					SuggestTemplate: "$re.FindAllStringIndex($s, $n)",
					WhereExpr: ir.FilterExpr{
						Line: 228,
						Op:   ir.FilterAndOp,
						Src:  "m[\"re\"].Type.Is(`*regexp.Regexp`) && m[\"s\"].Type.Is(`string`)",
						Args: []ir.FilterExpr{
							{
								Line:  228,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"re\"].Type.Is(`*regexp.Regexp`)",
								Value: "re",
								Args:  []ir.FilterExpr{{Line: 228, Op: ir.FilterStringOp, Src: "`*regexp.Regexp`", Value: "*regexp.Regexp"}},
							},
							{
								Line:  228,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"s\"].Type.Is(`string`)",
								Value: "s",
								Args:  []ir.FilterExpr{{Line: 228, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
							},
						},
					},
				},
			},
		},
		{
			Line:        237,
			Name:        "indexAlloc",
			MatcherName: "m",
			DocTags:     []string{"performance"},
			DocSummary:  "Detects strings.Index calls that may cause unwanted allocs",
			DocBefore:   "strings.Index(string(x), y)",
			DocAfter:    "bytes.Index(x, []byte(y))",
			DocNote:     "See Go issue for details: https://github.com/golang/go/issues/25864",
			Rules: []ir.Rule{{
				Line:           238,
				SyntaxPatterns: []ir.PatternString{{Line: 238, Value: "strings.Index(string($x), $y)"}},
				ReportTemplate: "consider replacing $$ with bytes.Index($x, []byte($y))",
				WhereExpr: ir.FilterExpr{
					Line: 239,
					Op:   ir.FilterAndOp,
					Src:  "m[\"x\"].Pure && m[\"y\"].Pure",
					Args: []ir.FilterExpr{
						{Line: 239, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
						{Line: 239, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
					},
				},
			}},
		},
		{
			Line:        247,
			Name:        "wrapperFunc",
			MatcherName: "m",
			DocTags:     []string{"style"},
			DocSummary:  "Detects function calls that can be replaced with convenience wrappers",
			DocBefore:   "wg.Add(-1)",
			DocAfter:    "wg.Done()",
			Rules: []ir.Rule{
				{
					Line:           248,
					SyntaxPatterns: []ir.PatternString{{Line: 248, Value: "$wg.Add(-1)"}},
					ReportTemplate: "use WaitGroup.Done method in `$$`",
					WhereExpr: ir.FilterExpr{
						Line:  249,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"wg\"].Type.Is(`sync.WaitGroup`)",
						Value: "wg",
						Args:  []ir.FilterExpr{{Line: 249, Op: ir.FilterStringOp, Src: "`sync.WaitGroup`", Value: "sync.WaitGroup"}},
					},
				},
				{
					Line:           252,
					SyntaxPatterns: []ir.PatternString{{Line: 252, Value: "$buf.Truncate(0)"}},
					ReportTemplate: "use Buffer.Reset method in `$$`",
					WhereExpr: ir.FilterExpr{
						Line:  253,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"buf\"].Type.Is(`bytes.Buffer`)",
						Value: "buf",
						Args:  []ir.FilterExpr{{Line: 253, Op: ir.FilterStringOp, Src: "`bytes.Buffer`", Value: "bytes.Buffer"}},
					},
				},
				{
					Line:           256,
					SyntaxPatterns: []ir.PatternString{{Line: 256, Value: "http.HandlerFunc(http.NotFound)"}},
					ReportTemplate: "use http.NotFoundHandler method in `$$`",
				},
				{
					Line:           258,
					SyntaxPatterns: []ir.PatternString{{Line: 258, Value: "strings.SplitN($_, $_, -1)"}},
					ReportTemplate: "use strings.Split method in `$$`",
				},
				{
					Line:           259,
					SyntaxPatterns: []ir.PatternString{{Line: 259, Value: "strings.Replace($_, $_, $_, -1)"}},
					ReportTemplate: "use strings.ReplaceAll method in `$$`",
				},
				{
					Line:           260,
					SyntaxPatterns: []ir.PatternString{{Line: 260, Value: "strings.Map(unicode.ToTitle, $_)"}},
					ReportTemplate: "use strings.ToTitle method in `$$`",
				},
				{
					Line:           262,
					SyntaxPatterns: []ir.PatternString{{Line: 262, Value: "bytes.SplitN(b, []byte(\".\"), -1)"}},
					ReportTemplate: "use bytes.Split method in `$$`",
				},
				{
					Line:           263,
					SyntaxPatterns: []ir.PatternString{{Line: 263, Value: "bytes.Replace($_, $_, $_, -1)"}},
					ReportTemplate: "use bytes.ReplaceAll method in `$$`",
				},
				{
					Line:           264,
					SyntaxPatterns: []ir.PatternString{{Line: 264, Value: "bytes.Map(unicode.ToUpper, $_)"}},
					ReportTemplate: "use bytes.ToUpper method in `$$`",
				},
				{
					Line:           265,
					SyntaxPatterns: []ir.PatternString{{Line: 265, Value: "bytes.Map(unicode.ToLower, $_)"}},
					ReportTemplate: "use bytes.ToLower method in `$$`",
				},
				{
					Line:           266,
					SyntaxPatterns: []ir.PatternString{{Line: 266, Value: "bytes.Map(unicode.ToTitle, $_)"}},
					ReportTemplate: "use bytes.ToTitle method in `$$`",
				},
				{
					Line:           268,
					SyntaxPatterns: []ir.PatternString{{Line: 268, Value: "draw.DrawMask($_, $_, $_, $_, nil, image.Point{}, $_)"}},
					ReportTemplate: "use draw.Draw method in `$$`",
				},
			},
		},
		{
			Line:        276,
			Name:        "regexpMust",
			MatcherName: "m",
			DocTags:     []string{"style"},
			DocSummary:  "Detects `regexp.Compile*` that can be replaced with `regexp.MustCompile*`",
			DocBefore:   "re, _ := regexp.Compile(\"const pattern\")",
			DocAfter:    "re := regexp.MustCompile(\"const pattern\")",
			Rules: []ir.Rule{
				{
					Line:           277,
					SyntaxPatterns: []ir.PatternString{{Line: 277, Value: "regexp.Compile($pat)"}},
					ReportTemplate: "for const patterns like $pat, use regexp.MustCompile",
					WhereExpr: ir.FilterExpr{
						Line:  278,
						Op:    ir.FilterVarConstOp,
						Src:   "m[\"pat\"].Const",
						Value: "pat",
					},
				},
				{
					Line:           281,
					SyntaxPatterns: []ir.PatternString{{Line: 281, Value: "regexp.CompilePOSIX($pat)"}},
					ReportTemplate: "for const patterns like $pat, use regexp.MustCompilePOSIX",
					WhereExpr: ir.FilterExpr{
						Line:  282,
						Op:    ir.FilterVarConstOp,
						Src:   "m[\"pat\"].Const",
						Value: "pat",
					},
				},
			},
		},
		{
			Line:        290,
			Name:        "badCall",
			MatcherName: "m",
			DocTags:     []string{"diagnostic"},
			DocSummary:  "Detects suspicious function calls",
			DocBefore:   "strings.Replace(s, from, to, 0)",
			DocAfter:    "strings.Replace(s, from, to, -1)",
			Rules: []ir.Rule{
				{
					Line:           291,
					SyntaxPatterns: []ir.PatternString{{Line: 291, Value: "strings.Replace($_, $_, $_, $zero)"}},
					ReportTemplate: "suspicious arg 0, probably meant -1",
					WhereExpr: ir.FilterExpr{
						Line: 292,
						Op:   ir.FilterEqOp,
						Src:  "m[\"zero\"].Value.Int() == 0",
						Args: []ir.FilterExpr{
							{
								Line:  292,
								Op:    ir.FilterVarValueIntOp,
								Src:   "m[\"zero\"].Value.Int()",
								Value: "zero",
							},
							{
								Line:  292,
								Op:    ir.FilterIntOp,
								Src:   "0",
								Value: int64(0),
							},
						},
					},
					LocationVar: "zero",
				},
				{
					Line:           294,
					SyntaxPatterns: []ir.PatternString{{Line: 294, Value: "bytes.Replace($_, $_, $_, $zero)"}},
					ReportTemplate: "suspicious arg 0, probably meant -1",
					WhereExpr: ir.FilterExpr{
						Line: 295,
						Op:   ir.FilterEqOp,
						Src:  "m[\"zero\"].Value.Int() == 0",
						Args: []ir.FilterExpr{
							{
								Line:  295,
								Op:    ir.FilterVarValueIntOp,
								Src:   "m[\"zero\"].Value.Int()",
								Value: "zero",
							},
							{
								Line:  295,
								Op:    ir.FilterIntOp,
								Src:   "0",
								Value: int64(0),
							},
						},
					},
					LocationVar: "zero",
				},
				{
					Line:           298,
					SyntaxPatterns: []ir.PatternString{{Line: 298, Value: "strings.SplitN($_, $_, $zero)"}},
					ReportTemplate: "suspicious arg 0, probably meant -1",
					WhereExpr: ir.FilterExpr{
						Line: 299,
						Op:   ir.FilterEqOp,
						Src:  "m[\"zero\"].Value.Int() == 0",
						Args: []ir.FilterExpr{
							{
								Line:  299,
								Op:    ir.FilterVarValueIntOp,
								Src:   "m[\"zero\"].Value.Int()",
								Value: "zero",
							},
							{
								Line:  299,
								Op:    ir.FilterIntOp,
								Src:   "0",
								Value: int64(0),
							},
						},
					},
					LocationVar: "zero",
				},
				{
					Line:           301,
					SyntaxPatterns: []ir.PatternString{{Line: 301, Value: "bytes.SplitN($_, $_, $zero)"}},
					ReportTemplate: "suspicious arg 0, probably meant -1",
					WhereExpr: ir.FilterExpr{
						Line: 302,
						Op:   ir.FilterEqOp,
						Src:  "m[\"zero\"].Value.Int() == 0",
						Args: []ir.FilterExpr{
							{
								Line:  302,
								Op:    ir.FilterVarValueIntOp,
								Src:   "m[\"zero\"].Value.Int()",
								Value: "zero",
							},
							{
								Line:  302,
								Op:    ir.FilterIntOp,
								Src:   "0",
								Value: int64(0),
							},
						},
					},
					LocationVar: "zero",
				},
				{
					Line:           305,
					SyntaxPatterns: []ir.PatternString{{Line: 305, Value: "append($_)"}},
					ReportTemplate: "no-op append call, probably missing arguments",
				},
				{
					Line:           307,
					SyntaxPatterns: []ir.PatternString{{Line: 307, Value: "filepath.Join($_)"}},
					ReportTemplate: "suspicious Join on 1 argument",
				},
			},
		},
		{
			Line:        314,
			Name:        "assignOp",
			MatcherName: "m",
			DocTags:     []string{"style"},
			DocSummary:  "Detects assignments that can be simplified by using assignment operators",
			DocBefore:   "x = x * 2",
			DocAfter:    "x *= 2",
			Rules: []ir.Rule{
				{
					Line:           315,
					SyntaxPatterns: []ir.PatternString{{Line: 315, Value: "$x = $x + 1"}},
					ReportTemplate: "replace `$$` with `$x++`",
					WhereExpr:      ir.FilterExpr{Line: 315, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line:           316,
					SyntaxPatterns: []ir.PatternString{{Line: 316, Value: "$x = $x - 1"}},
					ReportTemplate: "replace `$$` with `$x--`",
					WhereExpr:      ir.FilterExpr{Line: 316, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line:           318,
					SyntaxPatterns: []ir.PatternString{{Line: 318, Value: "$x = $x + $y"}},
					ReportTemplate: "replace `$$` with `$x += $y`",
					WhereExpr:      ir.FilterExpr{Line: 318, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line:           319,
					SyntaxPatterns: []ir.PatternString{{Line: 319, Value: "$x = $x - $y"}},
					ReportTemplate: "replace `$$` with `$x -= $y`",
					WhereExpr:      ir.FilterExpr{Line: 319, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line:           321,
					SyntaxPatterns: []ir.PatternString{{Line: 321, Value: "$x = $x * $y"}},
					ReportTemplate: "replace `$$` with `$x *= $y`",
					WhereExpr:      ir.FilterExpr{Line: 321, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line:           322,
					SyntaxPatterns: []ir.PatternString{{Line: 322, Value: "$x = $x / $y"}},
					ReportTemplate: "replace `$$` with `$x /= $y`",
					WhereExpr:      ir.FilterExpr{Line: 322, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line:           323,
					SyntaxPatterns: []ir.PatternString{{Line: 323, Value: "$x = $x % $y"}},
					ReportTemplate: "replace `$$` with `$x %= $y`",
					WhereExpr:      ir.FilterExpr{Line: 323, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line:           324,
					SyntaxPatterns: []ir.PatternString{{Line: 324, Value: "$x = $x & $y"}},
					ReportTemplate: "replace `$$` with `$x &= $y`",
					WhereExpr:      ir.FilterExpr{Line: 324, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line:           325,
					SyntaxPatterns: []ir.PatternString{{Line: 325, Value: "$x = $x | $y"}},
					ReportTemplate: "replace `$$` with `$x |= $y`",
					WhereExpr:      ir.FilterExpr{Line: 325, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line:           326,
					SyntaxPatterns: []ir.PatternString{{Line: 326, Value: "$x = $x ^ $y"}},
					ReportTemplate: "replace `$$` with `$x ^= $y`",
					WhereExpr:      ir.FilterExpr{Line: 326, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line:           327,
					SyntaxPatterns: []ir.PatternString{{Line: 327, Value: "$x = $x << $y"}},
					ReportTemplate: "replace `$$` with `$x <<= $y`",
					WhereExpr:      ir.FilterExpr{Line: 327, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line:           328,
					SyntaxPatterns: []ir.PatternString{{Line: 328, Value: "$x = $x >> $y"}},
					ReportTemplate: "replace `$$` with `$x >>= $y`",
					WhereExpr:      ir.FilterExpr{Line: 328, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line:           329,
					SyntaxPatterns: []ir.PatternString{{Line: 329, Value: "$x = $x &^ $y"}},
					ReportTemplate: "replace `$$` with `$x &^= $y`",
					WhereExpr:      ir.FilterExpr{Line: 329, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
			},
		},
		{
			Line:        336,
			Name:        "preferWriteByte",
			MatcherName: "m",
			DocTags:     []string{"performance", "experimental", "opinionated"},
			DocSummary:  "Detects WriteRune calls with rune literal argument that is single byte and reports to use WriteByte instead",
			DocBefore:   "w.WriteRune('\\n')",
			DocAfter:    "w.WriteByte('\\n')",
			Rules: []ir.Rule{{
				Line:           340,
				SyntaxPatterns: []ir.PatternString{{Line: 340, Value: "$w.WriteRune($c)"}},
				ReportTemplate: "consider writing single byte rune $c with $w.WriteByte($c)",
				WhereExpr: ir.FilterExpr{
					Line: 341,
					Op:   ir.FilterAndOp,
					Src:  "m[\"w\"].Type.Implements(\"io.ByteWriter\") && (m[\"c\"].Const && m[\"c\"].Value.Int() < runeSelf)",
					Args: []ir.FilterExpr{
						{
							Line:  341,
							Op:    ir.FilterVarTypeImplementsOp,
							Src:   "m[\"w\"].Type.Implements(\"io.ByteWriter\")",
							Value: "w",
							Args:  []ir.FilterExpr{{Line: 341, Op: ir.FilterStringOp, Src: "\"io.ByteWriter\"", Value: "io.ByteWriter"}},
						},
						{
							Line: 341,
							Op:   ir.FilterAndOp,
							Src:  "(m[\"c\"].Const && m[\"c\"].Value.Int() < runeSelf)",
							Args: []ir.FilterExpr{
								{
									Line:  341,
									Op:    ir.FilterVarConstOp,
									Src:   "m[\"c\"].Const",
									Value: "c",
								},
								{
									Line: 341,
									Op:   ir.FilterLtOp,
									Src:  "m[\"c\"].Value.Int() < runeSelf",
									Args: []ir.FilterExpr{
										{
											Line:  341,
											Op:    ir.FilterVarValueIntOp,
											Src:   "m[\"c\"].Value.Int()",
											Value: "c",
										},
										{
											Line:  341,
											Op:    ir.FilterIntOp,
											Src:   "runeSelf",
											Value: int64(128),
										},
									},
								},
							},
						},
					},
				},
			}},
		},
		{
			Line:        349,
			Name:        "preferFprint",
			MatcherName: "m",
			DocTags:     []string{"performance", "experimental"},
			DocSummary:  "Detects fmt.Sprint(f/ln) calls which can be replaced with fmt.Fprint(f/ln)",
			DocBefore:   "w.Write([]byte(fmt.Sprintf(\"%x\", 10)))",
			DocAfter:    "fmt.Fprintf(w, \"%x\", 10)",
			Rules: []ir.Rule{
				{
					Line:            350,
					SyntaxPatterns:  []ir.PatternString{{Line: 350, Value: "$w.Write([]byte(fmt.Sprint($*args)))"}},
					ReportTemplate:  "fmt.Fprint($w, $args) should be preferred to the $$",
					SuggestTemplate: "fmt.Fprint($w, $args)",
					WhereExpr: ir.FilterExpr{
						Line:  351,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"w\"].Type.Implements(\"io.Writer\")",
						Value: "w",
						Args:  []ir.FilterExpr{{Line: 351, Op: ir.FilterStringOp, Src: "\"io.Writer\"", Value: "io.Writer"}},
					},
				},
				{
					Line:            355,
					SyntaxPatterns:  []ir.PatternString{{Line: 355, Value: "$w.Write([]byte(fmt.Sprintf($*args)))"}},
					ReportTemplate:  "fmt.Fprintf($w, $args) should be preferred to the $$",
					SuggestTemplate: "fmt.Fprintf($w, $args)",
					WhereExpr: ir.FilterExpr{
						Line:  356,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"w\"].Type.Implements(\"io.Writer\")",
						Value: "w",
						Args:  []ir.FilterExpr{{Line: 356, Op: ir.FilterStringOp, Src: "\"io.Writer\"", Value: "io.Writer"}},
					},
				},
				{
					Line:            360,
					SyntaxPatterns:  []ir.PatternString{{Line: 360, Value: "$w.Write([]byte(fmt.Sprintln($*args)))"}},
					ReportTemplate:  "fmt.Fprintln($w, $args) should be preferred to the $$",
					SuggestTemplate: "fmt.Fprintln($w, $args)",
					WhereExpr: ir.FilterExpr{
						Line:  361,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"w\"].Type.Implements(\"io.Writer\")",
						Value: "w",
						Args:  []ir.FilterExpr{{Line: 361, Op: ir.FilterStringOp, Src: "\"io.Writer\"", Value: "io.Writer"}},
					},
				},
				{
					Line:            365,
					SyntaxPatterns:  []ir.PatternString{{Line: 365, Value: "io.WriteString($w, fmt.Sprint($*args))"}},
					ReportTemplate:  "suggestion: fmt.Fprint($w, $args)",
					SuggestTemplate: "fmt.Fprint($w, $args)",
				},
				{
					Line:            366,
					SyntaxPatterns:  []ir.PatternString{{Line: 366, Value: "io.WriteString($w, fmt.Sprintf($*args))"}},
					ReportTemplate:  "suggestion: fmt.Fprintf($w, $args)",
					SuggestTemplate: "fmt.Fprintf($w, $args)",
				},
				{
					Line:            367,
					SyntaxPatterns:  []ir.PatternString{{Line: 367, Value: "io.WriteString($w, fmt.Sprintln($*args))"}},
					ReportTemplate:  "suggestion: fmt.Fprintln($w, $args)",
					SuggestTemplate: "fmt.Fprintln($w, $args)",
				},
			},
		},
		{
			Line:        374,
			Name:        "dupArg",
			MatcherName: "m",
			DocTags:     []string{"diagnostic"},
			DocSummary:  "Detects suspicious duplicated arguments",
			DocBefore:   "copy(dst, dst)",
			DocAfter:    "copy(dst, src)",
			Rules: []ir.Rule{
				{
					Line: 375,
					SyntaxPatterns: []ir.PatternString{
						{Line: 375, Value: "$x.Equal($x)"},
						{Line: 375, Value: "$x.Equals($x)"},
						{Line: 375, Value: "$x.Compare($x)"},
						{Line: 375, Value: "$x.Cmp($x)"},
					},
					ReportTemplate: "suspicious method call with the same argument and receiver",
					WhereExpr:      ir.FilterExpr{Line: 376, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
				{
					Line: 379,
					SyntaxPatterns: []ir.PatternString{
						{Line: 379, Value: "copy($x, $x)"},
						{Line: 380, Value: "math.Max($x, $x)"},
						{Line: 381, Value: "math.Min($x, $x)"},
						{Line: 382, Value: "reflect.Copy($x, $x)"},
						{Line: 383, Value: "reflect.DeepEqual($x, $x)"},
						{Line: 384, Value: "strings.Contains($x, $x)"},
						{Line: 385, Value: "strings.Compare($x, $x)"},
						{Line: 386, Value: "strings.EqualFold($x, $x)"},
						{Line: 387, Value: "strings.HasPrefix($x, $x)"},
						{Line: 388, Value: "strings.HasSuffix($x, $x)"},
						{Line: 389, Value: "strings.Index($x, $x)"},
						{Line: 390, Value: "strings.LastIndex($x, $x)"},
						{Line: 391, Value: "strings.Split($x, $x)"},
						{Line: 392, Value: "strings.SplitAfter($x, $x)"},
						{Line: 393, Value: "strings.SplitAfterN($x, $x, $_)"},
						{Line: 394, Value: "strings.SplitN($x, $x, $_)"},
						{Line: 395, Value: "strings.Replace($_, $x, $x, $_)"},
						{Line: 396, Value: "strings.ReplaceAll($_, $x, $x)"},
						{Line: 397, Value: "bytes.Contains($x, $x)"},
						{Line: 398, Value: "bytes.Compare($x, $x)"},
						{Line: 399, Value: "bytes.Equal($x, $x)"},
						{Line: 400, Value: "bytes.EqualFold($x, $x)"},
						{Line: 401, Value: "bytes.HasPrefix($x, $x)"},
						{Line: 402, Value: "bytes.HasSuffix($x, $x)"},
						{Line: 403, Value: "bytes.Index($x, $x)"},
						{Line: 404, Value: "bytes.LastIndex($x, $x)"},
						{Line: 405, Value: "bytes.Split($x, $x)"},
						{Line: 406, Value: "bytes.SplitAfter($x, $x)"},
						{Line: 407, Value: "bytes.SplitAfterN($x, $x, $_)"},
						{Line: 408, Value: "bytes.SplitN($x, $x, $_)"},
						{Line: 409, Value: "bytes.Replace($_, $x, $x, $_)"},
						{Line: 410, Value: "bytes.ReplaceAll($_, $x, $x)"},
						{Line: 411, Value: "types.Identical($x, $x)"},
						{Line: 412, Value: "types.IdenticalIgnoreTags($x, $x)"},
						{Line: 413, Value: "draw.Draw($x, $_, $x, $_, $_)"},
					},
					ReportTemplate: "suspicious duplicated args in $$",
					WhereExpr:      ir.FilterExpr{Line: 414, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
				},
			},
		},
		{
			Line:        422,
			Name:        "returnAfterHttpError",
			MatcherName: "m",
			DocTags:     []string{"diagnostic", "experimental"},
			DocSummary:  "Detects suspicious http.Error call without following return",
			DocBefore:   "if err != nil { http.Error(...); }",
			DocAfter:    "if err != nil { http.Error(...); return; }",
			Rules: []ir.Rule{{
				Line:           423,
				SyntaxPatterns: []ir.PatternString{{Line: 423, Value: "if $_ { $*_; http.Error($w, $err, $code) }"}},
				ReportTemplate: "Possibly return is missed after the http.Error call",
				LocationVar:    "w",
			}},
		},
		{
			Line:        432,
			Name:        "preferFilepathJoin",
			MatcherName: "m",
			DocTags:     []string{"style", "experimental"},
			DocSummary:  "Detects concatenation with os.PathSeparator which can be replaced with filepath.Join",
			DocBefore:   "x + string(os.PathSeparator) + y",
			DocAfter:    "filepath.Join(x, y)",
			Rules: []ir.Rule{{
				Line:            433,
				SyntaxPatterns:  []ir.PatternString{{Line: 433, Value: "$x + string(os.PathSeparator) + $y"}},
				ReportTemplate:  "filepath.Join($x, $y) should be preferred to the $$",
				SuggestTemplate: "filepath.Join($x, $y)",
				WhereExpr: ir.FilterExpr{
					Line: 434,
					Op:   ir.FilterAndOp,
					Src:  "m[\"x\"].Type.Is(`string`) && m[\"y\"].Type.Is(`string`)",
					Args: []ir.FilterExpr{
						{
							Line:  434,
							Op:    ir.FilterVarTypeIsOp,
							Src:   "m[\"x\"].Type.Is(`string`)",
							Value: "x",
							Args:  []ir.FilterExpr{{Line: 434, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
						},
						{
							Line:  434,
							Op:    ir.FilterVarTypeIsOp,
							Src:   "m[\"y\"].Type.Is(`string`)",
							Value: "y",
							Args:  []ir.FilterExpr{{Line: 434, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
						},
					},
				},
			}},
		},
		{
			Line:        443,
			Name:        "preferStringWriter",
			MatcherName: "m",
			DocTags:     []string{"performance", "experimental"},
			DocSummary:  "Detects w.Write or io.WriteString calls which can be replaced with w.WriteString",
			DocBefore:   "w.Write([]byte(\"foo\"))",
			DocAfter:    "w.WriteString(\"foo\")",
			Rules: []ir.Rule{
				{
					Line:            444,
					SyntaxPatterns:  []ir.PatternString{{Line: 444, Value: "$w.Write([]byte($s))"}},
					ReportTemplate:  "$w.WriteString($s) should be preferred to the $$",
					SuggestTemplate: "$w.WriteString($s)",
					WhereExpr: ir.FilterExpr{
						Line:  445,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"w\"].Type.Implements(\"io.StringWriter\")",
						Value: "w",
						Args:  []ir.FilterExpr{{Line: 445, Op: ir.FilterStringOp, Src: "\"io.StringWriter\"", Value: "io.StringWriter"}},
					},
				},
				{
					Line:            449,
					SyntaxPatterns:  []ir.PatternString{{Line: 449, Value: "io.WriteString($w, $s)"}},
					ReportTemplate:  "$w.WriteString($s) should be preferred to the $$",
					SuggestTemplate: "$w.WriteString($s)",
					WhereExpr: ir.FilterExpr{
						Line:  450,
						Op:    ir.FilterVarTypeImplementsOp,
						Src:   "m[\"w\"].Type.Implements(\"io.StringWriter\")",
						Value: "w",
						Args:  []ir.FilterExpr{{Line: 450, Op: ir.FilterStringOp, Src: "\"io.StringWriter\"", Value: "io.StringWriter"}},
					},
				},
			},
		},
		{
			Line:        459,
			Name:        "sliceClear",
			MatcherName: "m",
			DocTags:     []string{"performance", "experimental"},
			DocSummary:  "Detects slice clear loops, suggests an idiom that is recognized by the Go compiler",
			DocBefore:   "for i := 0; i < len(buf); i++ { buf[i] = 0 }",
			DocAfter:    "for i := range buf { buf[i] = 0 }",
			Rules: []ir.Rule{{
				Line:           460,
				SyntaxPatterns: []ir.PatternString{{Line: 460, Value: "for $i := 0; $i < len($xs); $i++ { $xs[$i] = $zero }"}},
				ReportTemplate: "rewrite as for-range so compiler can recognize this pattern",
				WhereExpr: ir.FilterExpr{
					Line: 461,
					Op:   ir.FilterEqOp,
					Src:  "m[\"zero\"].Value.Int() == 0",
					Args: []ir.FilterExpr{
						{
							Line:  461,
							Op:    ir.FilterVarValueIntOp,
							Src:   "m[\"zero\"].Value.Int()",
							Value: "zero",
						},
						{
							Line:  461,
							Op:    ir.FilterIntOp,
							Src:   "0",
							Value: int64(0),
						},
					},
				},
			}},
		},
		{
			Line:        469,
			Name:        "syncMapLoadAndDelete",
			MatcherName: "m",
			DocTags:     []string{"diagnostic", "experimental"},
			DocSummary:  "Detects sync.Map load+delete operations that can be replaced with LoadAndDelete",
			DocBefore:   "v, ok := m.Load(k); if ok { m.Delete($k); f(v); }",
			DocAfter:    "v, deleted := m.LoadAndDelete(k); if deleted { f(v) }",
			Rules: []ir.Rule{{
				Line:           470,
				SyntaxPatterns: []ir.PatternString{{Line: 470, Value: "$_, $ok := $m.Load($k); if $ok { $m.Delete($k); $*_ }"}},
				ReportTemplate: "use $m.LoadAndDelete to perform load+delete operations atomically",
				WhereExpr: ir.FilterExpr{
					Line: 471,
					Op:   ir.FilterAndOp,
					Src:  "m.GoVersion().GreaterEqThan(\"1.15\") &&\n\tm[\"m\"].Type.Is(`*sync.Map`)",
					Args: []ir.FilterExpr{
						{
							Line:  471,
							Op:    ir.FilterGoVersionGreaterEqThanOp,
							Src:   "m.GoVersion().GreaterEqThan(\"1.15\")",
							Value: "1.15",
						},
						{
							Line:  472,
							Op:    ir.FilterVarTypeIsOp,
							Src:   "m[\"m\"].Type.Is(`*sync.Map`)",
							Value: "m",
							Args:  []ir.FilterExpr{{Line: 472, Op: ir.FilterStringOp, Src: "`*sync.Map`", Value: "*sync.Map"}},
						},
					},
				},
			}},
		},
		{
			Line:        480,
			Name:        "sprintfQuotedString",
			MatcherName: "m",
			DocTags:     []string{"diagnostic", "experimental"},
			DocSummary:  "Detects \"%s\" formatting directives that can be replaced with %q",
			DocBefore:   "fmt.Sprintf(`\"%s\"`, s)",
			DocAfter:    "fmt.Sprintf(`%q`, s)",
			Rules: []ir.Rule{{
				Line:           481,
				SyntaxPatterns: []ir.PatternString{{Line: 481, Value: "fmt.Sprintf($s, $*_)"}},
				ReportTemplate: "use %q instead of \"%s\" for quoted strings",
				WhereExpr: ir.FilterExpr{
					Line: 482,
					Op:   ir.FilterOrOp,
					Src:  "m[\"s\"].Text.Matches(\"^`.*\\\"%s\\\".*`$\") ||\n\tm[\"s\"].Text.Matches(`^\".*\\\\\"%s\\\\\".*\"$`)",
					Args: []ir.FilterExpr{
						{
							Line:  482,
							Op:    ir.FilterVarTextMatchesOp,
							Src:   "m[\"s\"].Text.Matches(\"^`.*\\\"%s\\\".*`$\")",
							Value: "s",
							Args:  []ir.FilterExpr{{Line: 482, Op: ir.FilterStringOp, Src: "\"^`.*\\\"%s\\\".*`$\"", Value: "^`.*\"%s\".*`$"}},
						},
						{
							Line:  483,
							Op:    ir.FilterVarTextMatchesOp,
							Src:   "m[\"s\"].Text.Matches(`^\".*\\\\\"%s\\\\\".*\"$`)",
							Value: "s",
							Args:  []ir.FilterExpr{{Line: 483, Op: ir.FilterStringOp, Src: "`^\".*\\\\\"%s\\\\\".*\"$`", Value: "^\".*\\\\\"%s\\\\\".*\"$"}},
						},
					},
				},
			}},
		},
		{
			Line:        491,
			Name:        "offBy1",
			MatcherName: "m",
			DocTags:     []string{"diagnostic"},
			DocSummary:  "Detects various off-by-one kind of errors",
			DocBefore:   "xs[len(xs)]",
			DocAfter:    "xs[len(xs)-1]",
			Rules: []ir.Rule{
				{
					Line:            492,
					SyntaxPatterns:  []ir.PatternString{{Line: 492, Value: "$x[len($x)]"}},
					ReportTemplate:  "index expr always panics; maybe you wanted $x[len($x)-1]?",
					SuggestTemplate: "$x[len($x)-1]",
					WhereExpr: ir.FilterExpr{
						Line: 493,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Pure && m[\"x\"].Type.Is(`[]$_`)",
						Args: []ir.FilterExpr{
							{Line: 493, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
							{
								Line:  493,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"x\"].Type.Is(`[]$_`)",
								Value: "x",
								Args:  []ir.FilterExpr{{Line: 493, Op: ir.FilterStringOp, Src: "`[]$_`", Value: "[]$_"}},
							},
						},
					},
				},
				{
					Line: 500,
					SyntaxPatterns: []ir.PatternString{
						{Line: 501, Value: "$i := strings.Index($s, $_); $_ := $slicing[$i:]"},
						{Line: 502, Value: "$i := strings.Index($s, $_); $_ = $slicing[$i:]"},
						{Line: 503, Value: "$i := bytes.Index($s, $_); $_ := $slicing[$i:]"},
						{Line: 504, Value: "$i := bytes.Index($s, $_); $_ = $slicing[$i:]"},
					},
					ReportTemplate: "Index() can return -1; maybe you wanted to do $s[$i+1:]",
					WhereExpr: ir.FilterExpr{
						Line: 505,
						Op:   ir.FilterEqOp,
						Src:  "m[\"s\"].Text == m[\"slicing\"].Text",
						Args: []ir.FilterExpr{
							{Line: 505, Op: ir.FilterVarTextOp, Src: "m[\"s\"].Text", Value: "s"},
							{Line: 505, Op: ir.FilterVarTextOp, Src: "m[\"slicing\"].Text", Value: "slicing"},
						},
					},
					LocationVar: "slicing",
				},
				{
					Line: 509,
					SyntaxPatterns: []ir.PatternString{
						{Line: 510, Value: "$i := strings.Index($s, $_); $_ := $slicing[:$i]"},
						{Line: 511, Value: "$i := strings.Index($s, $_); $_ = $slicing[:$i]"},
						{Line: 512, Value: "$i := bytes.Index($s, $_); $_ := $slicing[:$i]"},
						{Line: 513, Value: "$i := bytes.Index($s, $_); $_ = $slicing[:$i]"},
					},
					ReportTemplate: "Index() can return -1; maybe you wanted to do $s[:$i+1]",
					WhereExpr: ir.FilterExpr{
						Line: 514,
						Op:   ir.FilterEqOp,
						Src:  "m[\"s\"].Text == m[\"slicing\"].Text",
						Args: []ir.FilterExpr{
							{Line: 514, Op: ir.FilterVarTextOp, Src: "m[\"s\"].Text", Value: "s"},
							{Line: 514, Op: ir.FilterVarTextOp, Src: "m[\"slicing\"].Text", Value: "slicing"},
						},
					},
					LocationVar: "slicing",
				},
				{
					Line: 518,
					SyntaxPatterns: []ir.PatternString{
						{Line: 519, Value: "$s[strings.Index($s, $_):]"},
						{Line: 520, Value: "$s[:strings.Index($s, $_)]"},
						{Line: 521, Value: "$s[bytes.Index($s, $_):]"},
						{Line: 522, Value: "$s[:bytes.Index($s, $_)]"},
					},
					ReportTemplate: "Index() can return -1; maybe you wanted to do Index()+1",
				},
			},
		},
		{
			Line:        530,
			Name:        "unslice",
			MatcherName: "m",
			DocTags:     []string{"style"},
			DocSummary:  "Detects slice expressions that can be simplified to sliced expression itself",
			DocBefore:   "copy(b[:], values...)",
			DocAfter:    "copy(b, values...)",
			Rules: []ir.Rule{{
				Line:            531,
				SyntaxPatterns:  []ir.PatternString{{Line: 531, Value: "$s[:]"}},
				ReportTemplate:  "could simplify $$ to $s",
				SuggestTemplate: "$s",
				WhereExpr: ir.FilterExpr{
					Line: 532,
					Op:   ir.FilterOrOp,
					Src:  "m[\"s\"].Type.Is(`string`) || m[\"s\"].Type.Is(`[]$_`)",
					Args: []ir.FilterExpr{
						{
							Line:  532,
							Op:    ir.FilterVarTypeIsOp,
							Src:   "m[\"s\"].Type.Is(`string`)",
							Value: "s",
							Args:  []ir.FilterExpr{{Line: 532, Op: ir.FilterStringOp, Src: "`string`", Value: "string"}},
						},
						{
							Line:  532,
							Op:    ir.FilterVarTypeIsOp,
							Src:   "m[\"s\"].Type.Is(`[]$_`)",
							Value: "s",
							Args:  []ir.FilterExpr{{Line: 532, Op: ir.FilterStringOp, Src: "`[]$_`", Value: "[]$_"}},
						},
					},
				},
			}},
		},
		{
			Line:        541,
			Name:        "yodaStyleExpr",
			MatcherName: "m",
			DocTags:     []string{"style", "experimental"},
			DocSummary:  "Detects Yoda style expressions and suggests to replace them",
			DocBefore:   "return nil != ptr",
			DocAfter:    "return ptr != nil",
			Rules: []ir.Rule{
				{
					Line:           542,
					SyntaxPatterns: []ir.PatternString{{Line: 542, Value: "$constval != $x"}},
					ReportTemplate: "consider to change order in expression to $x != $constval",
					WhereExpr: ir.FilterExpr{
						Line: 542,
						Op:   ir.FilterAndOp,
						Src:  "m[\"constval\"].Node.Is(`BasicLit`) && !m[\"x\"].Node.Is(`BasicLit`)",
						Args: []ir.FilterExpr{
							{
								Line:  542,
								Op:    ir.FilterVarNodeIsOp,
								Src:   "m[\"constval\"].Node.Is(`BasicLit`)",
								Value: "constval",
								Args:  []ir.FilterExpr{{Line: 542, Op: ir.FilterStringOp, Src: "`BasicLit`", Value: "BasicLit"}},
							},
							{
								Line: 542,
								Op:   ir.FilterNotOp,
								Src:  "!m[\"x\"].Node.Is(`BasicLit`)",
								Args: []ir.FilterExpr{{
									Line:  542,
									Op:    ir.FilterVarNodeIsOp,
									Src:   "m[\"x\"].Node.Is(`BasicLit`)",
									Value: "x",
									Args:  []ir.FilterExpr{{Line: 542, Op: ir.FilterStringOp, Src: "`BasicLit`", Value: "BasicLit"}},
								}},
							},
						},
					},
				},
				{
					Line:           544,
					SyntaxPatterns: []ir.PatternString{{Line: 544, Value: "$constval == $x"}},
					ReportTemplate: "consider to change order in expression to $x == $constval",
					WhereExpr: ir.FilterExpr{
						Line: 544,
						Op:   ir.FilterAndOp,
						Src:  "m[\"constval\"].Node.Is(`BasicLit`) && !m[\"x\"].Node.Is(`BasicLit`)",
						Args: []ir.FilterExpr{
							{
								Line:  544,
								Op:    ir.FilterVarNodeIsOp,
								Src:   "m[\"constval\"].Node.Is(`BasicLit`)",
								Value: "constval",
								Args:  []ir.FilterExpr{{Line: 544, Op: ir.FilterStringOp, Src: "`BasicLit`", Value: "BasicLit"}},
							},
							{
								Line: 544,
								Op:   ir.FilterNotOp,
								Src:  "!m[\"x\"].Node.Is(`BasicLit`)",
								Args: []ir.FilterExpr{{
									Line:  544,
									Op:    ir.FilterVarNodeIsOp,
									Src:   "m[\"x\"].Node.Is(`BasicLit`)",
									Value: "x",
									Args:  []ir.FilterExpr{{Line: 544, Op: ir.FilterStringOp, Src: "`BasicLit`", Value: "BasicLit"}},
								}},
							},
						},
					},
				},
				{
					Line:           547,
					SyntaxPatterns: []ir.PatternString{{Line: 547, Value: "nil != $x"}},
					ReportTemplate: "consider to change order in expression to $x != nil",
					WhereExpr: ir.FilterExpr{
						Line: 547,
						Op:   ir.FilterNotOp,
						Src:  "!m[\"x\"].Node.Is(`BasicLit`)",
						Args: []ir.FilterExpr{{
							Line:  547,
							Op:    ir.FilterVarNodeIsOp,
							Src:   "m[\"x\"].Node.Is(`BasicLit`)",
							Value: "x",
							Args:  []ir.FilterExpr{{Line: 547, Op: ir.FilterStringOp, Src: "`BasicLit`", Value: "BasicLit"}},
						}},
					},
				},
				{
					Line:           549,
					SyntaxPatterns: []ir.PatternString{{Line: 549, Value: "nil == $x"}},
					ReportTemplate: "consider to change order in expression to $x == nil",
					WhereExpr: ir.FilterExpr{
						Line: 549,
						Op:   ir.FilterNotOp,
						Src:  "!m[\"x\"].Node.Is(`BasicLit`)",
						Args: []ir.FilterExpr{{
							Line:  549,
							Op:    ir.FilterVarNodeIsOp,
							Src:   "m[\"x\"].Node.Is(`BasicLit`)",
							Value: "x",
							Args:  []ir.FilterExpr{{Line: 549, Op: ir.FilterStringOp, Src: "`BasicLit`", Value: "BasicLit"}},
						}},
					},
				},
			},
		},
		{
			Line:        557,
			Name:        "equalFold",
			MatcherName: "m",
			DocTags:     []string{"performance", "experimental"},
			DocSummary:  "Detects unoptimal strings/bytes case-insensitive comparison",
			DocBefore:   "strings.ToLower(x) == strings.ToLower(y)",
			DocAfter:    "strings.EqualFold(x, y)",
			Rules: []ir.Rule{
				{
					Line: 566,
					SyntaxPatterns: []ir.PatternString{
						{Line: 567, Value: "strings.ToLower($x) == $y"},
						{Line: 568, Value: "strings.ToLower($x) == strings.ToLower($y)"},
						{Line: 569, Value: "$x == strings.ToLower($y)"},
						{Line: 570, Value: "strings.ToUpper($x) == $y"},
						{Line: 571, Value: "strings.ToUpper($x) == strings.ToUpper($y)"},
						{Line: 572, Value: "$x == strings.ToUpper($y)"},
					},
					ReportTemplate:  "consider replacing with strings.EqualFold($x, $y)",
					SuggestTemplate: "strings.EqualFold($x, $y)",
					WhereExpr: ir.FilterExpr{
						Line: 573,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Pure && m[\"y\"].Pure && m[\"x\"].Text != m[\"y\"].Text",
						Args: []ir.FilterExpr{
							{
								Line: 573,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure && m[\"y\"].Pure",
								Args: []ir.FilterExpr{
									{Line: 573, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
									{Line: 573, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
								},
							},
							{
								Line: 573,
								Op:   ir.FilterNeqOp,
								Src:  "m[\"x\"].Text != m[\"y\"].Text",
								Args: []ir.FilterExpr{
									{Line: 573, Op: ir.FilterVarTextOp, Src: "m[\"x\"].Text", Value: "x"},
									{Line: 573, Op: ir.FilterVarTextOp, Src: "m[\"y\"].Text", Value: "y"},
								},
							},
						},
					},
				},
				{
					Line: 578,
					SyntaxPatterns: []ir.PatternString{
						{Line: 579, Value: "strings.ToLower($x) != $y"},
						{Line: 580, Value: "strings.ToLower($x) != strings.ToLower($y)"},
						{Line: 581, Value: "$x != strings.ToLower($y)"},
						{Line: 582, Value: "strings.ToUpper($x) != $y"},
						{Line: 583, Value: "strings.ToUpper($x) != strings.ToUpper($y)"},
						{Line: 584, Value: "$x != strings.ToUpper($y)"},
					},
					ReportTemplate:  "consider replacing with !strings.EqualFold($x, $y)",
					SuggestTemplate: "!strings.EqualFold($x, $y)",
					WhereExpr: ir.FilterExpr{
						Line: 585,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Pure && m[\"y\"].Pure && m[\"x\"].Text != m[\"y\"].Text",
						Args: []ir.FilterExpr{
							{
								Line: 585,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure && m[\"y\"].Pure",
								Args: []ir.FilterExpr{
									{Line: 585, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
									{Line: 585, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
								},
							},
							{
								Line: 585,
								Op:   ir.FilterNeqOp,
								Src:  "m[\"x\"].Text != m[\"y\"].Text",
								Args: []ir.FilterExpr{
									{Line: 585, Op: ir.FilterVarTextOp, Src: "m[\"x\"].Text", Value: "x"},
									{Line: 585, Op: ir.FilterVarTextOp, Src: "m[\"y\"].Text", Value: "y"},
								},
							},
						},
					},
				},
				{
					Line: 590,
					SyntaxPatterns: []ir.PatternString{
						{Line: 591, Value: "bytes.Equal(bytes.ToLower($x), $y)"},
						{Line: 592, Value: "bytes.Equal(bytes.ToLower($x), bytes.ToLower($y))"},
						{Line: 593, Value: "bytes.Equal($x, bytes.ToLower($y))"},
						{Line: 594, Value: "bytes.Equal(bytes.ToUpper($x), $y)"},
						{Line: 595, Value: "bytes.Equal(bytes.ToUpper($x), bytes.ToUpper($y))"},
						{Line: 596, Value: "bytes.Equal($x, bytes.ToUpper($y))"},
					},
					ReportTemplate:  "consider replacing with bytes.EqualFold($x, $y)",
					SuggestTemplate: "bytes.EqualFold($x, $y)",
					WhereExpr: ir.FilterExpr{
						Line: 597,
						Op:   ir.FilterAndOp,
						Src:  "m[\"x\"].Pure && m[\"y\"].Pure && m[\"x\"].Text != m[\"y\"].Text",
						Args: []ir.FilterExpr{
							{
								Line: 597,
								Op:   ir.FilterAndOp,
								Src:  "m[\"x\"].Pure && m[\"y\"].Pure",
								Args: []ir.FilterExpr{
									{Line: 597, Op: ir.FilterVarPureOp, Src: "m[\"x\"].Pure", Value: "x"},
									{Line: 597, Op: ir.FilterVarPureOp, Src: "m[\"y\"].Pure", Value: "y"},
								},
							},
							{
								Line: 597,
								Op:   ir.FilterNeqOp,
								Src:  "m[\"x\"].Text != m[\"y\"].Text",
								Args: []ir.FilterExpr{
									{Line: 597, Op: ir.FilterVarTextOp, Src: "m[\"x\"].Text", Value: "x"},
									{Line: 597, Op: ir.FilterVarTextOp, Src: "m[\"y\"].Text", Value: "y"},
								},
							},
						},
					},
				},
			},
		},
		{
			Line:        606,
			Name:        "argOrder",
			MatcherName: "m",
			DocTags:     []string{"diagnostic"},
			DocSummary:  "Detects suspicious arguments order",
			DocBefore:   "strings.HasPrefix(\"#\", userpass)",
			DocAfter:    "strings.HasPrefix(userpass, \"#\")",
			Rules: []ir.Rule{{
				Line: 607,
				SyntaxPatterns: []ir.PatternString{
					{Line: 608, Value: "strings.HasPrefix($lit, $s)"},
					{Line: 609, Value: "bytes.HasPrefix($lit, $s)"},
					{Line: 610, Value: "strings.HasSuffix($lit, $s)"},
					{Line: 611, Value: "bytes.HasSuffix($lit, $s)"},
					{Line: 612, Value: "strings.Contains($lit, $s)"},
					{Line: 613, Value: "bytes.Contains($lit, $s)"},
					{Line: 614, Value: "strings.TrimPrefix($lit, $s)"},
					{Line: 615, Value: "bytes.TrimPrefix($lit, $s)"},
					{Line: 616, Value: "strings.TrimSuffix($lit, $s)"},
					{Line: 617, Value: "bytes.TrimSuffix($lit, $s)"},
					{Line: 618, Value: "strings.Split($lit, $s)"},
					{Line: 619, Value: "bytes.Split($lit, $s)"},
				},
				ReportTemplate: "$lit and $s arguments order looks reversed",
				WhereExpr: ir.FilterExpr{
					Line: 620,
					Op:   ir.FilterAndOp,
					Src:  "(m[\"lit\"].Const || m[\"lit\"].ConstSlice) &&\n\t!(m[\"s\"].Const || m[\"s\"].ConstSlice) &&\n\t!m[\"lit\"].Node.Is(`Ident`)",
					Args: []ir.FilterExpr{
						{
							Line: 620,
							Op:   ir.FilterAndOp,
							Src:  "(m[\"lit\"].Const || m[\"lit\"].ConstSlice) &&\n\t!(m[\"s\"].Const || m[\"s\"].ConstSlice)",
							Args: []ir.FilterExpr{
								{
									Line: 620,
									Op:   ir.FilterOrOp,
									Src:  "(m[\"lit\"].Const || m[\"lit\"].ConstSlice)",
									Args: []ir.FilterExpr{
										{
											Line:  620,
											Op:    ir.FilterVarConstOp,
											Src:   "m[\"lit\"].Const",
											Value: "lit",
										},
										{
											Line:  620,
											Op:    ir.FilterVarConstSliceOp,
											Src:   "m[\"lit\"].ConstSlice",
											Value: "lit",
										},
									},
								},
								{
									Line: 621,
									Op:   ir.FilterNotOp,
									Src:  "!(m[\"s\"].Const || m[\"s\"].ConstSlice)",
									Args: []ir.FilterExpr{{
										Line: 621,
										Op:   ir.FilterOrOp,
										Src:  "(m[\"s\"].Const || m[\"s\"].ConstSlice)",
										Args: []ir.FilterExpr{
											{
												Line:  621,
												Op:    ir.FilterVarConstOp,
												Src:   "m[\"s\"].Const",
												Value: "s",
											},
											{
												Line:  621,
												Op:    ir.FilterVarConstSliceOp,
												Src:   "m[\"s\"].ConstSlice",
												Value: "s",
											},
										},
									}},
								},
							},
						},
						{
							Line: 622,
							Op:   ir.FilterNotOp,
							Src:  "!m[\"lit\"].Node.Is(`Ident`)",
							Args: []ir.FilterExpr{{
								Line:  622,
								Op:    ir.FilterVarNodeIsOp,
								Src:   "m[\"lit\"].Node.Is(`Ident`)",
								Value: "lit",
								Args:  []ir.FilterExpr{{Line: 622, Op: ir.FilterStringOp, Src: "`Ident`", Value: "Ident"}},
							}},
						},
					},
				},
			}},
		},
		{
			Line:        630,
			Name:        "stringConcatSimplify",
			MatcherName: "m",
			DocTags:     []string{"style", "experimental"},
			DocSummary:  "Detects string concat operations that can be simplified",
			DocBefore:   "strings.Join([]string{x, y}, \"_\")",
			DocAfter:    "x + \"_\" + y",
			Rules: []ir.Rule{
				{
					Line:            631,
					SyntaxPatterns:  []ir.PatternString{{Line: 631, Value: "strings.Join([]string{$x, $y}, \"\")"}},
					ReportTemplate:  "suggestion: $x + $y",
					SuggestTemplate: "$x + $y",
				},
				{
					Line:            632,
					SyntaxPatterns:  []ir.PatternString{{Line: 632, Value: "strings.Join([]string{$x, $y, $z}, \"\")"}},
					ReportTemplate:  "suggestion: $x + $y + $z",
					SuggestTemplate: "$x + $y + $z",
				},
				{
					Line:            633,
					SyntaxPatterns:  []ir.PatternString{{Line: 633, Value: "strings.Join([]string{$x, $y}, $glue)"}},
					ReportTemplate:  "suggestion: $x + $glue + $y",
					SuggestTemplate: "$x + $glue + $y",
				},
			},
		},
		{
			Line:        640,
			Name:        "timeExprSimplify",
			MatcherName: "m",
			DocTags:     []string{"style", "experimental"},
			DocSummary:  "Detects manual conversion to milli- or microseconds",
			DocBefore:   "t.Unix() / 1000",
			DocAfter:    "t.UnixMilli()",
			Rules: []ir.Rule{
				{
					Line:            645,
					SyntaxPatterns:  []ir.PatternString{{Line: 645, Value: "$t.Unix() / 1000"}},
					ReportTemplate:  "use $t.UnixMilli() instead of $$",
					SuggestTemplate: "$t.UnixMilli()",
					WhereExpr: ir.FilterExpr{
						Line: 646,
						Op:   ir.FilterAndOp,
						Src:  "m.GoVersion().GreaterEqThan(\"1.17\") && isTime(m[\"t\"])",
						Args: []ir.FilterExpr{
							{
								Line:  646,
								Op:    ir.FilterGoVersionGreaterEqThanOp,
								Src:   "m.GoVersion().GreaterEqThan(\"1.17\")",
								Value: "1.17",
							},
							{
								Line: 646,
								Op:   ir.FilterOrOp,
								Src:  "isTime(m[\"t\"])",
								Args: []ir.FilterExpr{
									{
										Line:  646,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"t\"].Type.Is(`time.Time`)",
										Value: "t",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`time.Time`", Value: "time.Time"}},
									},
									{
										Line:  646,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"t\"].Type.Is(`*time.Time`)",
										Value: "t",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*time.Time`", Value: "*time.Time"}},
									},
								},
							},
						},
					},
				},
				{
					Line:            650,
					SyntaxPatterns:  []ir.PatternString{{Line: 650, Value: "$t.UnixNano() * 1000"}},
					ReportTemplate:  "use $t.UnixMicro() instead of $$",
					SuggestTemplate: "$t.UnixMicro()",
					WhereExpr: ir.FilterExpr{
						Line: 651,
						Op:   ir.FilterAndOp,
						Src:  "m.GoVersion().GreaterEqThan(\"1.17\") && isTime(m[\"t\"])",
						Args: []ir.FilterExpr{
							{
								Line:  651,
								Op:    ir.FilterGoVersionGreaterEqThanOp,
								Src:   "m.GoVersion().GreaterEqThan(\"1.17\")",
								Value: "1.17",
							},
							{
								Line: 651,
								Op:   ir.FilterOrOp,
								Src:  "isTime(m[\"t\"])",
								Args: []ir.FilterExpr{
									{
										Line:  651,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"t\"].Type.Is(`time.Time`)",
										Value: "t",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`time.Time`", Value: "time.Time"}},
									},
									{
										Line:  651,
										Op:    ir.FilterVarTypeIsOp,
										Src:   "m[\"t\"].Type.Is(`*time.Time`)",
										Value: "t",
										Args:  []ir.FilterExpr{{Line: 642, Op: ir.FilterStringOp, Src: "`*time.Time`", Value: "*time.Time"}},
									},
								},
							},
						},
					},
				},
			},
		},
		{
			Line:        660,
			Name:        "timeCmpSimplify",
			MatcherName: "m",
			DocTags:     []string{"style", "experimental"},
			DocSummary:  "Detects Before/After call of time.Time that can be simplified",
			DocBefore:   "!t.Before(tt)",
			DocAfter:    "t.After(tt)",
			Rules: []ir.Rule{
				{
					Line:            665,
					SyntaxPatterns:  []ir.PatternString{{Line: 665, Value: "!$t.Before($tt)"}},
					ReportTemplate:  "suggestion: $t.After($tt)",
					SuggestTemplate: "$t.After($tt)",
					WhereExpr: ir.FilterExpr{
						Line: 666,
						Op:   ir.FilterOrOp,
						Src:  "isTime(m[\"t\"])",
						Args: []ir.FilterExpr{
							{
								Line:  666,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"t\"].Type.Is(`time.Time`)",
								Value: "t",
								Args:  []ir.FilterExpr{{Line: 662, Op: ir.FilterStringOp, Src: "`time.Time`", Value: "time.Time"}},
							},
							{
								Line:  666,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"t\"].Type.Is(`*time.Time`)",
								Value: "t",
								Args:  []ir.FilterExpr{{Line: 662, Op: ir.FilterStringOp, Src: "`*time.Time`", Value: "*time.Time"}},
							},
						},
					},
				},
				{
					Line:            669,
					SyntaxPatterns:  []ir.PatternString{{Line: 669, Value: "!$t.After($tt)"}},
					ReportTemplate:  "suggestion: $t.Before($tt)",
					SuggestTemplate: "$t.Before($tt)",
					WhereExpr: ir.FilterExpr{
						Line: 670,
						Op:   ir.FilterOrOp,
						Src:  "isTime(m[\"t\"])",
						Args: []ir.FilterExpr{
							{
								Line:  670,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"t\"].Type.Is(`time.Time`)",
								Value: "t",
								Args:  []ir.FilterExpr{{Line: 662, Op: ir.FilterStringOp, Src: "`time.Time`", Value: "time.Time"}},
							},
							{
								Line:  670,
								Op:    ir.FilterVarTypeIsOp,
								Src:   "m[\"t\"].Type.Is(`*time.Time`)",
								Value: "t",
								Args:  []ir.FilterExpr{{Line: 662, Op: ir.FilterStringOp, Src: "`*time.Time`", Value: "*time.Time"}},
							},
						},
					},
				},
			},
		},
		{
			Line:        678,
			Name:        "exposedSyncMutex",
			MatcherName: "m",
			DocTags:     []string{"style", "experimental"},
			DocSummary:  "Detects exposed methods from sync.Mutex and sync.RWMutex",
			DocBefore:   "type Foo struct{ ...; sync.Mutex; ... }",
			DocAfter:    "type Foo struct{ ...; mu sync.Mutex; ... }",
			Rules: []ir.Rule{
				{
					Line:           683,
					SyntaxPatterns: []ir.PatternString{{Line: 683, Value: "type $x struct { $*_; sync.Mutex; $*_ }"}},
					ReportTemplate: "don't embed sync.Mutex",
					WhereExpr: ir.FilterExpr{
						Line:  684,
						Op:    ir.FilterVarTextMatchesOp,
						Src:   "isExported(m[\"x\"])",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 680, Op: ir.FilterStringOp, Src: "`^\\p{Lu}`", Value: "^\\p{Lu}"}},
					},
				},
				{
					Line:           687,
					SyntaxPatterns: []ir.PatternString{{Line: 687, Value: "type $x struct { $*_; *sync.Mutex; $*_ }"}},
					ReportTemplate: "don't embed *sync.Mutex",
					WhereExpr: ir.FilterExpr{
						Line:  688,
						Op:    ir.FilterVarTextMatchesOp,
						Src:   "isExported(m[\"x\"])",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 680, Op: ir.FilterStringOp, Src: "`^\\p{Lu}`", Value: "^\\p{Lu}"}},
					},
				},
				{
					Line:           691,
					SyntaxPatterns: []ir.PatternString{{Line: 691, Value: "type $x struct { $*_; sync.RWMutex; $*_ }"}},
					ReportTemplate: "don't embed sync.RWMutex",
					WhereExpr: ir.FilterExpr{
						Line:  692,
						Op:    ir.FilterVarTextMatchesOp,
						Src:   "isExported(m[\"x\"])",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 680, Op: ir.FilterStringOp, Src: "`^\\p{Lu}`", Value: "^\\p{Lu}"}},
					},
				},
				{
					Line:           695,
					SyntaxPatterns: []ir.PatternString{{Line: 695, Value: "type $x struct { $*_; *sync.RWMutex; $*_ }"}},
					ReportTemplate: "don't embed *sync.RWMutex",
					WhereExpr: ir.FilterExpr{
						Line:  696,
						Op:    ir.FilterVarTextMatchesOp,
						Src:   "isExported(m[\"x\"])",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 680, Op: ir.FilterStringOp, Src: "`^\\p{Lu}`", Value: "^\\p{Lu}"}},
					},
				},
			},
		},
		{
			Line:        704,
			Name:        "badSorting",
			MatcherName: "m",
			DocTags:     []string{"diagnostic", "experimental"},
			DocSummary:  "Detects bad usage of sort package",
			DocBefore:   "xs = sort.StringSlice(xs)",
			DocAfter:    "sort.Strings(xs)",
			Rules: []ir.Rule{
				{
					Line:            705,
					SyntaxPatterns:  []ir.PatternString{{Line: 705, Value: "$x = sort.IntSlice($x)"}},
					ReportTemplate:  "suspicious sort.IntSlice usage, maybe sort.Ints was intended?",
					SuggestTemplate: "sort.Ints($x)",
					WhereExpr: ir.FilterExpr{
						Line:  706,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`[]int`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 706, Op: ir.FilterStringOp, Src: "`[]int`", Value: "[]int"}},
					},
				},
				{
					Line:            710,
					SyntaxPatterns:  []ir.PatternString{{Line: 710, Value: "$x = sort.Float64Slice($x)"}},
					ReportTemplate:  "suspicious sort.Float64s usage, maybe sort.Float64s was intended?",
					SuggestTemplate: "sort.Float64s($x)",
					WhereExpr: ir.FilterExpr{
						Line:  711,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`[]float64`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 711, Op: ir.FilterStringOp, Src: "`[]float64`", Value: "[]float64"}},
					},
				},
				{
					Line:            715,
					SyntaxPatterns:  []ir.PatternString{{Line: 715, Value: "$x = sort.StringSlice($x)"}},
					ReportTemplate:  "suspicious sort.StringSlice usage, maybe sort.Strings was intended?",
					SuggestTemplate: "sort.Strings($x)",
					WhereExpr: ir.FilterExpr{
						Line:  716,
						Op:    ir.FilterVarTypeIsOp,
						Src:   "m[\"x\"].Type.Is(`[]string`)",
						Value: "x",
						Args:  []ir.FilterExpr{{Line: 716, Op: ir.FilterStringOp, Src: "`[]string`", Value: "[]string"}},
					},
				},
			},
		},
		{
			Line:        725,
			Name:        "externalErrorReassign",
			MatcherName: "m",
			DocTags:     []string{"diagnostic", "experimental"},
			DocSummary:  "Detects suspicious reassigment of error from another package",
			DocBefore:   "io.EOF = nil",
			DocAfter:    "/* don't do it */",
			Rules: []ir.Rule{{
				Line:           726,
				SyntaxPatterns: []ir.PatternString{{Line: 726, Value: "$pkg.$err = $x"}},
				ReportTemplate: "suspicious reassigment of error from another package",
				WhereExpr: ir.FilterExpr{
					Line: 727,
					Op:   ir.FilterAndOp,
					Src:  "m[\"err\"].Type.Is(`error`) && m[\"pkg\"].Object.Is(`PkgName`)",
					Args: []ir.FilterExpr{
						{
							Line:  727,
							Op:    ir.FilterVarTypeIsOp,
							Src:   "m[\"err\"].Type.Is(`error`)",
							Value: "err",
							Args:  []ir.FilterExpr{{Line: 727, Op: ir.FilterStringOp, Src: "`error`", Value: "error"}},
						},
						{
							Line:  727,
							Op:    ir.FilterVarObjectIsOp,
							Src:   "m[\"pkg\"].Object.Is(`PkgName`)",
							Value: "pkg",
							Args:  []ir.FilterExpr{{Line: 727, Op: ir.FilterStringOp, Src: "`PkgName`", Value: "PkgName"}},
						},
					},
				},
			}},
		},
		{
			Line:        735,
			Name:        "emptyDecl",
			MatcherName: "m",
			DocTags:     []string{"diagnostic", "experimental"},
			DocSummary:  "Detects suspicious empty declarations blocks",
			DocBefore:   "var()",
			DocAfter:    "/* nothing */",
			Rules: []ir.Rule{
				{
					Line:           736,
					SyntaxPatterns: []ir.PatternString{{Line: 736, Value: "var()"}},
					ReportTemplate: "empty var() block",
				},
				{
					Line:           737,
					SyntaxPatterns: []ir.PatternString{{Line: 737, Value: "const()"}},
					ReportTemplate: "empty const() block",
				},
				{
					Line:           738,
					SyntaxPatterns: []ir.PatternString{{Line: 738, Value: "type()"}},
					ReportTemplate: "empty type() block",
				},
			},
		},
		{
			Line:        745,
			Name:        "dynamicFmtString",
			MatcherName: "m",
			DocTags:     []string{"diagnostic", "experimental"},
			DocSummary:  "Detects suspicious formatting strings usage",
			DocBefore:   "fmt.Errorf(msg)",
			DocAfter:    "fmt.Errorf(\"%s\", msg)",
			Rules: []ir.Rule{
				{
					Line:            746,
					SyntaxPatterns:  []ir.PatternString{{Line: 746, Value: "fmt.Errorf($f)"}},
					ReportTemplate:  "use errors.New($f) or fmt.Errorf(\"%s\", $f) instead",
					SuggestTemplate: "errors.New($f)",
					WhereExpr: ir.FilterExpr{
						Line: 747,
						Op:   ir.FilterNotOp,
						Src:  "!m[\"f\"].Const",
						Args: []ir.FilterExpr{{
							Line:  747,
							Op:    ir.FilterVarConstOp,
							Src:   "m[\"f\"].Const",
							Value: "f",
						}},
					},
				},
				{
					Line:            751,
					SyntaxPatterns:  []ir.PatternString{{Line: 751, Value: "fmt.Errorf($f($*args))"}},
					ReportTemplate:  "use errors.New($f($*args)) or fmt.Errorf(\"%s\", $f($*args)) instead",
					SuggestTemplate: "errors.New($f($*args))",
				},
			},
		},
		{
			Line:        760,
			Name:        "stringsCompare",
			MatcherName: "m",
			DocTags:     []string{"style", "experimental"},
			DocSummary:  "Detects strings.Compare usage",
			DocBefore:   "strings.Compare(x, y)",
			DocAfter:    "x < y",
			Rules: []ir.Rule{
				{
					Line:            761,
					SyntaxPatterns:  []ir.PatternString{{Line: 761, Value: "strings.Compare($s1, $s2) == 0"}},
					ReportTemplate:  "suggestion: $s1 == $s2",
					SuggestTemplate: "$s1 == $s2",
				},
				{
					Line: 764,
					SyntaxPatterns: []ir.PatternString{
						{Line: 764, Value: "strings.Compare($s1, $s2) == -1"},
						{Line: 765, Value: "strings.Compare($s1, $s2) < 0"},
					},
					ReportTemplate:  "suggestion: $s1 < $s2",
					SuggestTemplate: "$s1 < $s2",
				},
				{
					Line: 768,
					SyntaxPatterns: []ir.PatternString{
						{Line: 768, Value: "strings.Compare($s1, $s2) == 1"},
						{Line: 769, Value: "strings.Compare($s1, $s2) > 0"},
					},
					ReportTemplate:  "suggestion: $s1 > $s2",
					SuggestTemplate: "$s1 > $s2",
				},
			},
		},
		{
			Line:        777,
			Name:        "uncheckedInlineErr",
			MatcherName: "m",
			DocTags:     []string{"diagnostic", "experimental"},
			DocSummary:  "Detects unchecked errors in if statements",
			DocBefore:   "if err := expr(); err2 != nil { /*...*/ }",
			DocAfter:    "if err := expr(); err != nil { /*...*/ }",
			Rules: []ir.Rule{{
				Line: 778,
				SyntaxPatterns: []ir.PatternString{
					{Line: 779, Value: "if $err := $_($*_); $err2 != nil { $*_ }"},
					{Line: 780, Value: "if $err = $_($*_); $err2 != nil { $*_ }"},
					{Line: 781, Value: "if $*_, $err := $_($*_); $err2 != nil { $*_ }"},
					{Line: 782, Value: "if $*_, $err = $_($*_); $err2 != nil { $*_ }"},
				},
				ReportTemplate: "$err error is unchecked, maybe intended to check it instead of $err2",
				WhereExpr: ir.FilterExpr{
					Line: 783,
					Op:   ir.FilterAndOp,
					Src:  "m[\"err\"].Type.Implements(\"error\") && m[\"err2\"].Type.Implements(\"error\") &&\n\tm[\"err\"].Text != m[\"err2\"].Text",
					Args: []ir.FilterExpr{
						{
							Line: 783,
							Op:   ir.FilterAndOp,
							Src:  "m[\"err\"].Type.Implements(\"error\") && m[\"err2\"].Type.Implements(\"error\")",
							Args: []ir.FilterExpr{
								{
									Line:  783,
									Op:    ir.FilterVarTypeImplementsOp,
									Src:   "m[\"err\"].Type.Implements(\"error\")",
									Value: "err",
									Args:  []ir.FilterExpr{{Line: 783, Op: ir.FilterStringOp, Src: "\"error\"", Value: "error"}},
								},
								{
									Line:  783,
									Op:    ir.FilterVarTypeImplementsOp,
									Src:   "m[\"err2\"].Type.Implements(\"error\")",
									Value: "err2",
									Args:  []ir.FilterExpr{{Line: 783, Op: ir.FilterStringOp, Src: "\"error\"", Value: "error"}},
								},
							},
						},
						{
							Line: 784,
							Op:   ir.FilterNeqOp,
							Src:  "m[\"err\"].Text != m[\"err2\"].Text",
							Args: []ir.FilterExpr{
								{Line: 784, Op: ir.FilterVarTextOp, Src: "m[\"err\"].Text", Value: "err"},
								{Line: 784, Op: ir.FilterVarTextOp, Src: "m[\"err2\"].Text", Value: "err2"},
							},
						},
					},
				},
				LocationVar: "err",
			}},
		},
	},
}

