/*
Copyright The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"

	v1 "github.com/kubernetes-csi/external-snapshotter/client/v4/apis/volumesnapshot/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	scheme "kubevirt.io/client-go/externalsnapshotter/scheme"
)

// VolumeSnapshotContentsGetter has a method to return a VolumeSnapshotContentInterface.
// A group's client should implement this interface.
type VolumeSnapshotContentsGetter interface {
	VolumeSnapshotContents() VolumeSnapshotContentInterface
}

// VolumeSnapshotContentInterface has methods to work with VolumeSnapshotContent resources.
type VolumeSnapshotContentInterface interface {
	Create(ctx context.Context, volumeSnapshotContent *v1.VolumeSnapshotContent, opts metav1.CreateOptions) (*v1.VolumeSnapshotContent, error)
	Update(ctx context.Context, volumeSnapshotContent *v1.VolumeSnapshotContent, opts metav1.UpdateOptions) (*v1.VolumeSnapshotContent, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, volumeSnapshotContent *v1.VolumeSnapshotContent, opts metav1.UpdateOptions) (*v1.VolumeSnapshotContent, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.VolumeSnapshotContent, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.VolumeSnapshotContentList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.VolumeSnapshotContent, err error)
	VolumeSnapshotContentExpansion
}

// volumeSnapshotContents implements VolumeSnapshotContentInterface
type volumeSnapshotContents struct {
	*gentype.ClientWithList[*v1.VolumeSnapshotContent, *v1.VolumeSnapshotContentList]
}

// newVolumeSnapshotContents returns a VolumeSnapshotContents
func newVolumeSnapshotContents(c *SnapshotV1Client) *volumeSnapshotContents {
	return &volumeSnapshotContents{
		gentype.NewClientWithList[*v1.VolumeSnapshotContent, *v1.VolumeSnapshotContentList](
			"volumesnapshotcontents",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *v1.VolumeSnapshotContent { return &v1.VolumeSnapshotContent{} },
			func() *v1.VolumeSnapshotContentList { return &v1.VolumeSnapshotContentList{} }),
	}
}
