; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define double @log_pow(double %x, double %y) {
; CHECK-LABEL: @log_pow(
; CHECK-NEXT:    [[LOG1:%.*]] = call fast double @llvm.log.f64(double [[X:%.*]])
; CHECK-NEXT:    [[MUL:%.*]] = fmul fast double [[LOG1]], [[Y:%.*]]
; CHECK-NEXT:    ret double [[MUL]]
;
  %pow = call fast double @pow(double %x, double %y)
  %log = call fast double @log(double %pow)
  ret double %log
}

define float @log10f_powf(float %x, float %y) {
; CHECK-LABEL: @log10f_powf(
; CHECK-NEXT:    [[LOG1:%.*]] = call fast float @llvm.log10.f32(float [[X:%.*]])
; CHECK-NEXT:    [[MUL:%.*]] = fmul fast float [[LOG1]], [[Y:%.*]]
; CHECK-NEXT:    ret float [[MUL]]
;
  %pow = call fast float @powf(float %x, float %y)
  %log = call fast float @llvm.log10.f32(float %pow)
  ret float %log
}

define <2 x double> @log2v_powv(<2 x double> %x, <2 x double> %y) {
; CHECK-LABEL: @log2v_powv(
; CHECK-NEXT:    [[LOG1:%.*]] = call fast <2 x double> @llvm.log2.v2f64(<2 x double> [[X:%.*]])
; CHECK-NEXT:    [[MUL:%.*]] = fmul fast <2 x double> [[LOG1]], [[Y:%.*]]
; CHECK-NEXT:    ret <2 x double> [[MUL]]
;
  %pow = call fast <2 x double> @llvm.pow.v2f64(<2 x double> %x, <2 x double> %y)
  %log = call fast <2 x double> @llvm.log2.v2f64(<2 x double> %pow)
  ret <2 x double> %log
}

define double @log_pow_not_fast(double %x, double %y) {
; CHECK-LABEL: @log_pow_not_fast(
; CHECK-NEXT:    [[POW:%.*]] = call double @pow(double [[X:%.*]], double [[Y:%.*]])
; CHECK-NEXT:    [[LOG:%.*]] = call fast double @log(double [[POW]])
; CHECK-NEXT:    ret double [[LOG]]
;
  %pow = call double @pow(double %x, double %y)
  %log = call fast double @log(double %pow)
  ret double %log
}

define float @function_pointer(ptr %fptr, float %p1) {
; CHECK-LABEL: @function_pointer(
; CHECK-NEXT:    [[PTR:%.*]] = call float [[FPTR:%.*]]()
; CHECK-NEXT:    [[LOG:%.*]] = call float @logf(float [[PTR]])
; CHECK-NEXT:    ret float [[LOG]]
;
  %ptr = call float %fptr()
  %log = call float @logf(float %ptr)
  ret float %log
}

define double @log10_exp(double %x) {
; CHECK-LABEL: @log10_exp(
; CHECK-NEXT:    [[MUL:%.*]] = fmul fast double [[X:%.*]], 0x3FDBCB7B1526E50E
; CHECK-NEXT:    ret double [[MUL]]
;
  %exp = call fast double @exp(double %x)
  %log = call fast double @log10(double %exp)
  ret double %log
}

define <2 x float> @logv_exp2v(<2 x float> %x) {
; CHECK-LABEL: @logv_exp2v(
; CHECK-NEXT:    [[MUL:%.*]] = fmul fast <2 x float> [[X:%.*]], <float 0x3FE62E4300000000, float 0x3FE62E4300000000>
; CHECK-NEXT:    ret <2 x float> [[MUL]]
;
  %exp = call fast <2 x float> @llvm.exp2.v2f32(<2 x float> %x)
  %log = call fast <2 x float> @llvm.log.v2f32(<2 x float> %exp)
  ret <2 x float> %log
}

define float @log2f_exp10f(float %x) {
; CHECK-LABEL: @log2f_exp10f(
; CHECK-NEXT:    [[MUL:%.*]] = fmul fast float [[X:%.*]], 0x400A934F00000000
; CHECK-NEXT:    ret float [[MUL]]
;
  %exp = call fast float @exp10f(float %x)
  %log = call fast float @log2f(float %exp)
  ret float %log
}

define double @log_exp2_not_fast(double %x) {
; CHECK-LABEL: @log_exp2_not_fast(
; CHECK-NEXT:    [[EXP:%.*]] = call double @exp2(double [[X:%.*]])
; CHECK-NEXT:    [[LOG:%.*]] = call fast double @log(double [[EXP]])
; CHECK-NEXT:    ret double [[LOG]]
;
  %exp = call double @exp2(double %x)
  %log = call fast double @log(double %exp)
  ret double %log
}

define double @pr43617(double %d, i32 %i, ptr %f) {
; CHECK-LABEL: @pr43617(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SUB:%.*]] = fneg double [[D:%.*]]
; CHECK-NEXT:    [[ICALL:%.*]] = tail call fast double [[F:%.*]](i32 [[I:%.*]])
; CHECK-NEXT:    [[LOG:%.*]] = tail call fast double @llvm.log.f64(double [[ICALL]])
; CHECK-NEXT:    [[MUL:%.*]] = fmul double [[LOG]], [[SUB]]
; CHECK-NEXT:    ret double [[MUL]]
;
entry:
  %sub = fsub double -0.000000e+00, %d
  %icall = tail call fast double %f(i32 %i)
  %log = tail call fast double @llvm.log.f64(double %icall)
  %mul = fmul double %log, %sub
  ret double %mul
}

declare double @log(double) #0
declare float @logf(float) #0
declare double @llvm.log.f64(double) #0
declare <2 x float> @llvm.log.v2f32(<2 x float>)
declare float @log2f(float) #0
declare <2 x double> @llvm.log2.v2f64(<2 x double>)
declare double @log10(double) #0
declare float @llvm.log10.f32(float)
declare double @exp(double %x) #0
declare double @exp2(double) #0
declare float @exp10f(float) #0
declare <2 x float> @llvm.exp2.v2f32(<2 x float>)
declare double @pow(double, double) #0
declare float @powf(float, float) #0
declare <2 x double> @llvm.pow.v2f64(<2 x double>, <2 x double>)

attributes #0 = { nounwind readnone }
