; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2,X86-SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2,X64-SSE,X64-SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,X64-SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefixes=AVX,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX512,AVX512BW
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512bw,+avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VL

;
; Truncate
;

define i1 @trunc_v2i64_v2i1(<2 x i64>) nounwind {
; SSE2-LABEL: trunc_v2i64_v2i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllq $63, %xmm0
; SSE2-NEXT:    movmskpd %xmm0, %eax
; SSE2-NEXT:    cmpl $3, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v2i64_v2i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1OR2-LABEL: trunc_v2i64_v2i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX1OR2-NEXT:    setb %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v2i64_v2i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512F-NEXT:    setb %al
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v2i64_v2i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512BW-NEXT:    setb %al
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v2i64_v2i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [1,1]
; AVX512VL-NEXT:    vptest %xmm1, %xmm0
; AVX512VL-NEXT:    setb %al
; AVX512VL-NEXT:    retq
  %a = trunc <2 x i64> %0 to <2 x i1>
  %b = call i1 @llvm.vector.reduce.and.v2i1(<2 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v4i32_v4i1(<4 x i32>) nounwind {
; SSE2-LABEL: trunc_v4i32_v4i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    movmskps %xmm0, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v4i32_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1OR2-LABEL: trunc_v4i32_v4i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX1OR2-NEXT:    setb %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v4i32_v4i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512F-NEXT:    setb %al
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v4i32_v4i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512BW-NEXT:    setb %al
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v4i32_v4i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [4294967297,4294967297]
; AVX512VL-NEXT:    vptest %xmm1, %xmm0
; AVX512VL-NEXT:    setb %al
; AVX512VL-NEXT:    retq
  %a = trunc <4 x i32> %0 to <4 x i1>
  %b = call i1 @llvm.vector.reduce.and.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v8i16_v8i1(<8 x i16>) nounwind {
; SSE2-LABEL: trunc_v8i16_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllw $7, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    notl %eax
; SSE2-NEXT:    testl $21845, %eax # imm = 0x5555
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v8i16_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1OR2-LABEL: trunc_v8i16_v8i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX1OR2-NEXT:    setb %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v8i16_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512F-NEXT:    setb %al
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v8i16_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512BW-NEXT:    setb %al
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v8i16_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [281479271743489,281479271743489]
; AVX512VL-NEXT:    vptest %xmm1, %xmm0
; AVX512VL-NEXT:    setb %al
; AVX512VL-NEXT:    retq
  %a = trunc <8 x i16> %0 to <8 x i1>
  %b = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v16i8_v16i1(<16 x i8>) nounwind {
; SSE2-LABEL: trunc_v16i8_v16i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    psllw $7, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v16i8_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1OR2-LABEL: trunc_v16i8_v16i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX1OR2-NEXT:    setb %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v16i8_v16i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512F-NEXT:    setb %al
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v16i8_v16i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX512BW-NEXT:    setb %al
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v16i8_v16i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [72340172838076673,72340172838076673]
; AVX512VL-NEXT:    vptest %xmm1, %xmm0
; AVX512VL-NEXT:    setb %al
; AVX512VL-NEXT:    retq
  %a = trunc <16 x i8> %0 to <16 x i1>
  %b = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v4i64_v4i1(<4 x i64>) nounwind {
; SSE2-LABEL: trunc_v4i64_v4i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    movmskps %xmm0, %eax
; SSE2-NEXT:    cmpl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v4i64_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v4i64_v4i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v4i64_v4i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v4i64_v4i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setb %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <4 x i64> %0 to <4 x i1>
  %b = call i1 @llvm.vector.reduce.and.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v8i32_v8i1(<8 x i32>) nounwind {
; SSE2-LABEL: trunc_v8i32_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pslld $31, %xmm0
; SSE2-NEXT:    movmskps %xmm0, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v8i32_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v8i32_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v8i32_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967297,4294967297,4294967297,4294967297]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v8i32_v8i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967297,4294967297,4294967297,4294967297]
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setb %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <8 x i32> %0 to <8 x i1>
  %b = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v16i16_v16i1(<16 x i16>) nounwind {
; SSE2-LABEL: trunc_v16i16_v16i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    psllw $7, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    notl %eax
; SSE2-NEXT:    testl $21845, %eax # imm = 0x5555
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v16i16_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v16i16_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v16i16_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [281479271743489,281479271743489,281479271743489,281479271743489]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v16i16_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [281479271743489,281479271743489,281479271743489,281479271743489]
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setb %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <16 x i16> %0 to <16 x i1>
  %b = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v32i8_v32i1(<32 x i8>) nounwind {
; SSE2-LABEL: trunc_v32i8_v32i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    psllw $7, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: trunc_v32i8_v32i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v32i8_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v32i8_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [72340172838076673,72340172838076673,72340172838076673,72340172838076673]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v32i8_v32i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [72340172838076673,72340172838076673,72340172838076673,72340172838076673]
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setb %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <32 x i8> %0 to <32 x i1>
  %b = call i1 @llvm.vector.reduce.and.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v8i64_v8i1(<8 x i64>) nounwind {
; X86-SSE2-LABEL: trunc_v8i64_v8i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; X86-SSE2-NEXT:    pslld $16, %xmm0
; X86-SSE2-NEXT:    psrad $16, %xmm0
; X86-SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],mem[0,2]
; X86-SSE2-NEXT:    pslld $16, %xmm2
; X86-SSE2-NEXT:    psrad $16, %xmm2
; X86-SSE2-NEXT:    packssdw %xmm2, %xmm0
; X86-SSE2-NEXT:    psllw $15, %xmm0
; X86-SSE2-NEXT:    packsswb %xmm0, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    cmpb $-1, %al
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: trunc_v8i64_v8i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; X64-SSE2-NEXT:    pslld $16, %xmm2
; X64-SSE2-NEXT:    psrad $16, %xmm2
; X64-SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; X64-SSE2-NEXT:    pslld $16, %xmm0
; X64-SSE2-NEXT:    psrad $16, %xmm0
; X64-SSE2-NEXT:    packssdw %xmm2, %xmm0
; X64-SSE2-NEXT:    psllw $15, %xmm0
; X64-SSE2-NEXT:    packsswb %xmm0, %xmm0
; X64-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE2-NEXT:    cmpb $-1, %al
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: trunc_v8i64_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm3, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v8i64_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v8i64_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v8i64_v8i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} zmm1 = [1,1,1,1,1,1,1,1]
; AVX512-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <8 x i64> %0 to <8 x i1>
  %b = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v16i32_v16i1(<16 x i32>) nounwind {
; X86-SSE2-LABEL: trunc_v16i32_v16i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pand 8(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    pslld $31, %xmm1
; X86-SSE2-NEXT:    movmskps %xmm1, %eax
; X86-SSE2-NEXT:    xorl $15, %eax
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: trunc_v16i32_v16i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pand %xmm3, %xmm1
; X64-SSE2-NEXT:    pand %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    pslld $31, %xmm0
; X64-SSE2-NEXT:    movmskps %xmm0, %eax
; X64-SSE2-NEXT:    xorl $15, %eax
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: trunc_v16i32_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm3, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v16i32_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v16i32_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967297,4294967297,4294967297,4294967297]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v16i32_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vptestnmd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = trunc <16 x i32> %0 to <16 x i1>
  %b = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v32i16_v32i1(<32 x i16>) nounwind {
; X86-SSE2-LABEL: trunc_v32i16_v32i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pand 8(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    psllw $7, %xmm1
; X86-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X86-SSE2-NEXT:    notl %eax
; X86-SSE2-NEXT:    testl $21845, %eax # imm = 0x5555
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: trunc_v32i16_v32i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pand %xmm3, %xmm1
; X64-SSE2-NEXT:    pand %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    psllw $7, %xmm0
; X64-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE2-NEXT:    notl %eax
; X64-SSE2-NEXT:    testl $21845, %eax # imm = 0x5555
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: trunc_v32i16_v32i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm3, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v32i16_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v32i16_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [281479271743489,281479271743489,281479271743489,281479271743489]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v32i16_v32i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} zmm1 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512F-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512F-NEXT:    kortestw %k0, %k0
; AVX512F-NEXT:    sete %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v32i16_v32i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastw {{.*#+}} zmm1 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kortestw %k0, %k0
; AVX512BW-NEXT:    sete %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v32i16_v32i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastw {{.*#+}} zmm1 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512VL-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512VL-NEXT:    kortestw %k0, %k0
; AVX512VL-NEXT:    sete %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = trunc <32 x i16> %0 to <32 x i1>
  %b = call i1 @llvm.vector.reduce.and.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @trunc_v64i8_v64i1(<64 x i8>) nounwind {
; X86-SSE2-LABEL: trunc_v64i8_v64i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pand 8(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    psllw $7, %xmm1
; X86-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X86-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: trunc_v64i8_v64i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pand %xmm3, %xmm1
; X64-SSE2-NEXT:    pand %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    psllw $7, %xmm0
; X64-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: trunc_v64i8_v64i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm3, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v64i8_v64i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v64i8_v64i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [72340172838076673,72340172838076673,72340172838076673,72340172838076673]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: trunc_v64i8_v64i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpbroadcastd {{.*#+}} zmm1 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512F-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512F-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512F-NEXT:    kortestw %k0, %k0
; AVX512F-NEXT:    sete %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: trunc_v64i8_v64i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpbroadcastb {{.*#+}} zmm1 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512BW-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512BW-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512BW-NEXT:    kortestw %k0, %k0
; AVX512BW-NEXT:    sete %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: trunc_v64i8_v64i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpbroadcastb {{.*#+}} zmm1 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512VL-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512VL-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512VL-NEXT:    kortestw %k0, %k0
; AVX512VL-NEXT:    sete %al
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    retq
  %a = trunc <64 x i8> %0 to <64 x i1>
  %b = call i1 @llvm.vector.reduce.and.v64i1(<64 x i1> %a)
  ret i1 %b
}

;
; Comparison With Zero
;

define i1 @icmp0_v2i64_v2i1(<2 x i64>) nounwind {
; SSE2-LABEL: icmp0_v2i64_v2i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp0_v2i64_v2i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp0_v2i64_v2i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vptest %xmm0, %xmm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %a = icmp eq <2 x i64> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.and.v2i1(<2 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v4i32_v4i1(<4 x i32>) nounwind {
; SSE2-LABEL: icmp0_v4i32_v4i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp0_v4i32_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp0_v4i32_v4i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vptest %xmm0, %xmm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %a = icmp eq <4 x i32> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.and.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v8i16_v8i1(<8 x i16>) nounwind {
; SSE2-LABEL: icmp0_v8i16_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE2-NEXT:    pmovmskb %xmm1, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp0_v8i16_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp0_v8i16_v8i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vptest %xmm0, %xmm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %a = icmp eq <8 x i16> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v16i8_v16i1(<16 x i8>) nounwind {
; SSE2-LABEL: icmp0_v16i8_v16i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE2-NEXT:    pmovmskb %xmm1, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp0_v16i8_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp0_v16i8_v16i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vptest %xmm0, %xmm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %a = icmp eq <16 x i8> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v4i64_v4i1(<4 x i64>) nounwind {
; SSE2-LABEL: icmp0_v4i64_v4i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp0_v4i64_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp0_v4i64_v4i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vptest %ymm0, %ymm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
  %a = icmp eq <4 x i64> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.and.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v8i32_v8i1(<8 x i32>) nounwind {
; SSE2-LABEL: icmp0_v8i32_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp0_v8i32_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp0_v8i32_v8i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vptest %ymm0, %ymm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
  %a = icmp eq <8 x i32> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v16i16_v16i1(<16 x i16>) nounwind {
; SSE2-LABEL: icmp0_v16i16_v16i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE2-NEXT:    pmovmskb %xmm1, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp0_v16i16_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp0_v16i16_v16i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vptest %ymm0, %ymm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
  %a = icmp eq <16 x i16> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v32i8_v32i1(<32 x i8>) nounwind {
; SSE2-LABEL: icmp0_v32i8_v32i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE2-NEXT:    pmovmskb %xmm1, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp0_v32i8_v32i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp0_v32i8_v32i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vptest %ymm0, %ymm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
  %a = icmp eq <32 x i8> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.and.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v8i64_v8i1(<8 x i64>) nounwind {
; X86-SSE2-LABEL: icmp0_v8i64_v8i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    por %xmm2, %xmm0
; X86-SSE2-NEXT:    por 8(%ebp), %xmm1
; X86-SSE2-NEXT:    por %xmm0, %xmm1
; X86-SSE2-NEXT:    pxor %xmm0, %xmm0
; X86-SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; X86-SSE2-NEXT:    movmskps %xmm0, %eax
; X86-SSE2-NEXT:    xorl $15, %eax
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp0_v8i64_v8i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    por %xmm3, %xmm1
; X64-SSE2-NEXT:    por %xmm2, %xmm0
; X64-SSE2-NEXT:    por %xmm1, %xmm0
; X64-SSE2-NEXT:    pxor %xmm1, %xmm1
; X64-SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; X64-SSE2-NEXT:    movmskps %xmm1, %eax
; X64-SSE2-NEXT:    xorl $15, %eax
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp0_v8i64_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp0_v8i64_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest %ymm0, %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp0_v8i64_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vptest %ymm0, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp0_v8i64_v8i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <8 x i64> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v16i32_v16i1(<16 x i32>) nounwind {
; X86-SSE2-LABEL: icmp0_v16i32_v16i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    por %xmm2, %xmm0
; X86-SSE2-NEXT:    por 8(%ebp), %xmm1
; X86-SSE2-NEXT:    por %xmm0, %xmm1
; X86-SSE2-NEXT:    pxor %xmm0, %xmm0
; X86-SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; X86-SSE2-NEXT:    movmskps %xmm0, %eax
; X86-SSE2-NEXT:    xorl $15, %eax
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp0_v16i32_v16i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    por %xmm3, %xmm1
; X64-SSE2-NEXT:    por %xmm2, %xmm0
; X64-SSE2-NEXT:    por %xmm1, %xmm0
; X64-SSE2-NEXT:    pxor %xmm1, %xmm1
; X64-SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; X64-SSE2-NEXT:    movmskps %xmm1, %eax
; X64-SSE2-NEXT:    xorl $15, %eax
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp0_v16i32_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp0_v16i32_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest %ymm0, %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp0_v16i32_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vptest %ymm0, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp0_v16i32_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <16 x i32> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v32i16_v32i1(<32 x i16>) nounwind {
; X86-SSE2-LABEL: icmp0_v32i16_v32i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    por %xmm2, %xmm0
; X86-SSE2-NEXT:    por 8(%ebp), %xmm1
; X86-SSE2-NEXT:    por %xmm0, %xmm1
; X86-SSE2-NEXT:    pxor %xmm0, %xmm0
; X86-SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp0_v32i16_v32i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    por %xmm3, %xmm1
; X64-SSE2-NEXT:    por %xmm2, %xmm0
; X64-SSE2-NEXT:    por %xmm1, %xmm0
; X64-SSE2-NEXT:    pxor %xmm1, %xmm1
; X64-SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; X64-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X64-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp0_v32i16_v32i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp0_v32i16_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest %ymm0, %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp0_v32i16_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vptest %ymm0, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp0_v32i16_v32i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <32 x i16> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.and.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @icmp0_v64i8_v64i1(<64 x i8>) nounwind {
; X86-SSE2-LABEL: icmp0_v64i8_v64i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    por %xmm2, %xmm0
; X86-SSE2-NEXT:    por 8(%ebp), %xmm1
; X86-SSE2-NEXT:    por %xmm0, %xmm1
; X86-SSE2-NEXT:    pxor %xmm0, %xmm0
; X86-SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp0_v64i8_v64i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    por %xmm3, %xmm1
; X64-SSE2-NEXT:    por %xmm2, %xmm0
; X64-SSE2-NEXT:    por %xmm1, %xmm0
; X64-SSE2-NEXT:    pxor %xmm1, %xmm1
; X64-SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; X64-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X64-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp0_v64i8_v64i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp0_v64i8_v64i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest %ymm0, %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp0_v64i8_v64i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vptest %ymm0, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp0_v64i8_v64i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <64 x i8> %0, zeroinitializer
  %b = call i1 @llvm.vector.reduce.and.v64i1(<64 x i1> %a)
  ret i1 %b
}

define i8 @icmp0_v8i1(<8 x i8>) nounwind {
; SSE2-LABEL: icmp0_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psllw $15, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    testl $43690, %eax # imm = 0xAAAA
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp0_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; SSE41-NEXT:    psllw $15, %xmm0
; SSE41-NEXT:    pmovmskb %xmm0, %eax
; SSE41-NEXT:    testl $43690, %eax # imm = 0xAAAA
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1OR2-LABEL: icmp0_v8i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX1OR2-NEXT:    vpsllw $15, %xmm0, %xmm0
; AVX1OR2-NEXT:    vpsraw $15, %xmm0, %xmm0
; AVX1OR2-NEXT:    vpmovmskb %xmm0, %eax
; AVX1OR2-NEXT:    testl %eax, %eax
; AVX1OR2-NEXT:    sete %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: icmp0_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    testb %al, %al
; AVX512F-NEXT:    sete %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp0_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX512BW-NEXT:    vpmovb2m %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    testb %al, %al
; AVX512BW-NEXT:    sete %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp0_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovb2m %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    testb %al, %al
; AVX512VL-NEXT:    sete %al
; AVX512VL-NEXT:    retq
  %a = trunc <8 x i8> %0 to <8 x i1>
  %b = icmp eq <8 x i1> %a, zeroinitializer
  %c = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %b)
  %d = zext i1 %c to i8
  ret i8 %d
}

;
; Comparison With All Ones
;

define i1 @icmp1_v2i64_v2i1(<2 x i64>) nounwind {
; SSE2-LABEL: icmp1_v2i64_v2i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp1_v2i64_v2i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp1_v2i64_v2i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vptest %xmm1, %xmm0
; AVX-NEXT:    setb %al
; AVX-NEXT:    retq
  %a = icmp eq <2 x i64> %0, <i64 -1, i64 -1>
  %b = call i1 @llvm.vector.reduce.and.v2i1(<2 x i1> %a)
  ret i1 %b
}

define i1 @icmp1_v4i32_v4i1(<4 x i32>) nounwind {
; SSE2-LABEL: icmp1_v4i32_v4i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp1_v4i32_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp1_v4i32_v4i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vptest %xmm1, %xmm0
; AVX-NEXT:    setb %al
; AVX-NEXT:    retq
  %a = icmp eq <4 x i32> %0, <i32 -1, i32 -1, i32 -1, i32 -1>
  %b = call i1 @llvm.vector.reduce.and.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @icmp1_v8i16_v8i1(<8 x i16>) nounwind {
; SSE2-LABEL: icmp1_v8i16_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE2-NEXT:    pmovmskb %xmm1, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp1_v8i16_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp1_v8i16_v8i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vptest %xmm1, %xmm0
; AVX-NEXT:    setb %al
; AVX-NEXT:    retq
  %a = icmp eq <8 x i16> %0, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %b = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp1_v16i8_v16i1(<16 x i8>) nounwind {
; SSE2-LABEL: icmp1_v16i8_v16i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE2-NEXT:    pmovmskb %xmm1, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp1_v16i8_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp1_v16i8_v16i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX-NEXT:    vptest %xmm1, %xmm0
; AVX-NEXT:    setb %al
; AVX-NEXT:    retq
  %a = icmp eq <16 x i8> %0, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %b = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp1_v4i64_v4i1(<4 x i64>) nounwind {
; SSE2-LABEL: icmp1_v4i64_v4i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp1_v4i64_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp1_v4i64_v4i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp1_v4i64_v4i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp1_v4i64_v4i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setb %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <4 x i64> %0, <i64 -1, i64 -1, i64 -1, i64 -1>
  %b = call i1 @llvm.vector.reduce.and.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @icmp1_v8i32_v8i1(<8 x i32>) nounwind {
; SSE2-LABEL: icmp1_v8i32_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    movmskps %xmm1, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp1_v8i32_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp1_v8i32_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp1_v8i32_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp1_v8i32_v8i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setb %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <8 x i32> %0, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %b = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp1_v16i16_v16i1(<16 x i16>) nounwind {
; SSE2-LABEL: icmp1_v16i16_v16i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE2-NEXT:    pmovmskb %xmm1, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp1_v16i16_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp1_v16i16_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp1_v16i16_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp1_v16i16_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setb %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <16 x i16> %0, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %b = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp1_v32i8_v32i1(<32 x i8>) nounwind {
; SSE2-LABEL: icmp1_v32i8_v32i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; SSE2-NEXT:    pmovmskb %xmm1, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp1_v32i8_v32i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp1_v32i8_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp1_v32i8_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp1_v32i8_v32i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setb %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <32 x i8> %0, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %b = call i1 @llvm.vector.reduce.and.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @icmp1_v8i64_v8i1(<8 x i64>) nounwind {
; X86-SSE2-LABEL: icmp1_v8i64_v8i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pand 8(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; X86-SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; X86-SSE2-NEXT:    movmskps %xmm0, %eax
; X86-SSE2-NEXT:    xorl $15, %eax
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp1_v8i64_v8i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pand %xmm3, %xmm1
; X64-SSE2-NEXT:    pand %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; X64-SSE2-NEXT:    movmskps %xmm1, %eax
; X64-SSE2-NEXT:    xorl $15, %eax
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp1_v8i64_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm3, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp1_v8i64_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp1_v8i64_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp1_v8i64_v8i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1
; AVX512-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <8 x i64> %0, <i64 -1, i64 -1, i64 -1, i64 -1, i64 -1, i64 -1, i64 -1, i64 -1>
  %b = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp1_v16i32_v16i1(<16 x i32>) nounwind {
; X86-SSE2-LABEL: icmp1_v16i32_v16i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pand 8(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; X86-SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; X86-SSE2-NEXT:    movmskps %xmm0, %eax
; X86-SSE2-NEXT:    xorl $15, %eax
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp1_v16i32_v16i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pand %xmm3, %xmm1
; X64-SSE2-NEXT:    pand %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; X64-SSE2-NEXT:    movmskps %xmm1, %eax
; X64-SSE2-NEXT:    xorl $15, %eax
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp1_v16i32_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm3, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp1_v16i32_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp1_v16i32_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp1_v16i32_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1
; AVX512-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <16 x i32> %0, <i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1, i32 -1>
  %b = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp1_v32i16_v32i1(<32 x i16>) nounwind {
; X86-SSE2-LABEL: icmp1_v32i16_v32i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pand 8(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; X86-SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp1_v32i16_v32i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pand %xmm3, %xmm1
; X64-SSE2-NEXT:    pand %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; X64-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X64-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp1_v32i16_v32i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm3, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp1_v32i16_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp1_v32i16_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp1_v32i16_v32i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1
; AVX512-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <32 x i16> %0, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %b = call i1 @llvm.vector.reduce.and.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @icmp1_v64i8_v64i1(<64 x i8>) nounwind {
; X86-SSE2-LABEL: icmp1_v64i8_v64i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pand 8(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    pcmpeqd %xmm0, %xmm0
; X86-SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp1_v64i8_v64i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pand %xmm3, %xmm1
; X64-SSE2-NEXT:    pand %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; X64-SSE2-NEXT:    pcmpeqb %xmm0, %xmm1
; X64-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X64-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp1_v64i8_v64i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm3, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    ptest %xmm1, %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp1_v64i8_v64i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vcmptrueps %ymm1, %ymm1, %ymm1
; AVX1-NEXT:    vptest %ymm1, %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp1_v64i8_v64i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm1, %ymm1
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp1_v64i8_v64i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpternlogd $255, %zmm1, %zmm1, %zmm1
; AVX512-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <64 x i8> %0, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %b = call i1 @llvm.vector.reduce.and.v64i1(<64 x i1> %a)
  ret i1 %b
}

define i8 @icmp1_v8i1(<8 x i8>) nounwind {
; SSE2-LABEL: icmp1_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    punpcklbw {{.*#+}} xmm0 = xmm0[0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7]
; SSE2-NEXT:    psllw $15, %xmm0
; SSE2-NEXT:    packsswb %xmm0, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    cmpb $-1, %al
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp1_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; SSE41-NEXT:    psllw $15, %xmm0
; SSE41-NEXT:    packsswb %xmm0, %xmm0
; SSE41-NEXT:    pmovmskb %xmm0, %eax
; SSE41-NEXT:    cmpb $-1, %al
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1OR2-LABEL: icmp1_v8i1:
; AVX1OR2:       # %bb.0:
; AVX1OR2-NEXT:    vpmovzxbw {{.*#+}} xmm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX1OR2-NEXT:    vpsllw $15, %xmm0, %xmm0
; AVX1OR2-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX1OR2-NEXT:    vpmovmskb %xmm0, %eax
; AVX1OR2-NEXT:    cmpb $-1, %al
; AVX1OR2-NEXT:    sete %al
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: icmp1_v8i1:
; AVX512F:       # %bb.0:
; AVX512F-NEXT:    vpmovsxbd %xmm0, %zmm0
; AVX512F-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kmovw %k0, %eax
; AVX512F-NEXT:    cmpb $-1, %al
; AVX512F-NEXT:    sete %al
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512BW-LABEL: icmp1_v8i1:
; AVX512BW:       # %bb.0:
; AVX512BW-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX512BW-NEXT:    vpmovb2m %zmm0, %k0
; AVX512BW-NEXT:    kmovd %k0, %eax
; AVX512BW-NEXT:    cmpb $-1, %al
; AVX512BW-NEXT:    sete %al
; AVX512BW-NEXT:    vzeroupper
; AVX512BW-NEXT:    retq
;
; AVX512VL-LABEL: icmp1_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX512VL-NEXT:    vpmovb2m %xmm0, %k0
; AVX512VL-NEXT:    kmovd %k0, %eax
; AVX512VL-NEXT:    cmpb $-1, %al
; AVX512VL-NEXT:    sete %al
; AVX512VL-NEXT:    retq
  %a = trunc <8 x i8> %0 to <8 x i1>
  %b = icmp eq <8 x i1> %a, <i1 -1, i1 -1, i1 -1, i1 -1, i1 -1, i1 -1, i1 -1, i1 -1>
  %c = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %b)
  %d = zext i1 %c to i8
  ret i8 %d
}

;
; Comparison
;

define i1 @icmp_v2i64_v2i1(<2 x i64>, <2 x i64>) nounwind {
; SSE2-LABEL: icmp_v2i64_v2i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    movmskps %xmm0, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp_v2i64_v2i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp_v2i64_v2i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vptest %xmm0, %xmm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %a = icmp eq <2 x i64> %0, %1
  %b = call i1 @llvm.vector.reduce.and.v2i1(<2 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v4i32_v4i1(<4 x i32>, <4 x i32>) nounwind {
; SSE2-LABEL: icmp_v4i32_v4i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    movmskps %xmm0, %eax
; SSE2-NEXT:    xorl $15, %eax
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp_v4i32_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp_v4i32_v4i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vptest %xmm0, %xmm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %a = icmp eq <4 x i32> %0, %1
  %b = call i1 @llvm.vector.reduce.and.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v8i16_v8i1(<8 x i16>, <8 x i16>) nounwind {
; SSE2-LABEL: icmp_v8i16_v8i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp_v8i16_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp_v8i16_v8i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vptest %xmm0, %xmm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %a = icmp eq <8 x i16> %0, %1
  %b = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v16i8_v16i1(<16 x i8>, <16 x i8>) nounwind {
; SSE2-LABEL: icmp_v16i8_v16i1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE2-NEXT:    pmovmskb %xmm0, %eax
; SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-NEXT:    sete %al
; SSE2-NEXT:    ret{{[l|q]}}
;
; SSE41-LABEL: icmp_v16i8_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX-LABEL: icmp_v16i8_v16i1:
; AVX:       # %bb.0:
; AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vptest %xmm0, %xmm0
; AVX-NEXT:    sete %al
; AVX-NEXT:    retq
  %a = icmp eq <16 x i8> %0, %1
  %b = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v4i64_v4i1(<4 x i64>, <4 x i64>) nounwind {
; X86-SSE2-LABEL: icmp_v4i64_v4i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqd 8(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    movmskps %xmm1, %eax
; X86-SSE2-NEXT:    xorl $15, %eax
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp_v4i64_v4i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pcmpeqd %xmm3, %xmm1
; X64-SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    movmskps %xmm0, %eax
; X64-SSE2-NEXT:    xorl $15, %eax
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp_v4i64_v4i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm3, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp_v4i64_v4i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest %ymm0, %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v4i64_v4i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vptest %ymm0, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp_v4i64_v4i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vptest %ymm0, %ymm0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <4 x i64> %0, %1
  %b = call i1 @llvm.vector.reduce.and.v4i1(<4 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v8i32_v8i1(<8 x i32>, <8 x i32>) nounwind {
; X86-SSE2-LABEL: icmp_v8i32_v8i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqd 8(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    movmskps %xmm1, %eax
; X86-SSE2-NEXT:    xorl $15, %eax
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp_v8i32_v8i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pcmpeqd %xmm3, %xmm1
; X64-SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    movmskps %xmm0, %eax
; X64-SSE2-NEXT:    xorl $15, %eax
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp_v8i32_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm3, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp_v8i32_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest %ymm0, %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v8i32_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vptest %ymm0, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp_v8i32_v8i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vptest %ymm0, %ymm0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <8 x i32> %0, %1
  %b = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v16i16_v16i1(<16 x i16>, <16 x i16>) nounwind {
; X86-SSE2-LABEL: icmp_v16i16_v16i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pcmpeqb %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqb 8(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X86-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp_v16i16_v16i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pcmpeqb %xmm3, %xmm1
; X64-SSE2-NEXT:    pcmpeqb %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp_v16i16_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm3, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp_v16i16_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest %ymm0, %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v16i16_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vptest %ymm0, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp_v16i16_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vptest %ymm0, %ymm0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <16 x i16> %0, %1
  %b = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v32i8_v32i1(<32 x i8>, <32 x i8>) nounwind {
; X86-SSE2-LABEL: icmp_v32i8_v32i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    pcmpeqb %xmm2, %xmm0
; X86-SSE2-NEXT:    pcmpeqb 8(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm0, %xmm1
; X86-SSE2-NEXT:    pmovmskb %xmm1, %eax
; X86-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp_v32i8_v32i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pcmpeqb %xmm3, %xmm1
; X64-SSE2-NEXT:    pcmpeqb %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp_v32i8_v32i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm3, %xmm1
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp_v32i8_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest %ymm0, %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v32i8_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vptest %ymm0, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp_v32i8_v32i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vptest %ymm0, %ymm0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <32 x i8> %0, %1
  %b = call i1 @llvm.vector.reduce.and.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v8i64_v8i1(<8 x i64>, <8 x i64>) nounwind {
; X86-SSE2-LABEL: icmp_v8i64_v8i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    movdqa 8(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqd 72(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqd 40(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm3, %xmm1
; X86-SSE2-NEXT:    pcmpeqd 56(%ebp), %xmm2
; X86-SSE2-NEXT:    pcmpeqd 24(%ebp), %xmm0
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pand %xmm1, %xmm0
; X86-SSE2-NEXT:    movmskps %xmm0, %eax
; X86-SSE2-NEXT:    xorl $15, %eax
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp_v8i64_v8i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pcmpeqd %xmm7, %xmm3
; X64-SSE2-NEXT:    pcmpeqd %xmm5, %xmm1
; X64-SSE2-NEXT:    pand %xmm3, %xmm1
; X64-SSE2-NEXT:    pcmpeqd %xmm6, %xmm2
; X64-SSE2-NEXT:    pcmpeqd %xmm4, %xmm0
; X64-SSE2-NEXT:    pand %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    movmskps %xmm0, %eax
; X64-SSE2-NEXT:    xorl $15, %eax
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp_v8i64_v8i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm7, %xmm3
; SSE41-NEXT:    pxor %xmm5, %xmm1
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    pxor %xmm6, %xmm2
; SSE41-NEXT:    pxor %xmm4, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp_v8i64_v8i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest %ymm0, %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v8i64_v8i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vptest %ymm0, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp_v8i64_v8i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <8 x i64> %0, %1
  %b = call i1 @llvm.vector.reduce.and.v8i1(<8 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v16i32_v16i1(<16 x i32>, <16 x i32>) nounwind {
; X86-SSE2-LABEL: icmp_v16i32_v16i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    movdqa 8(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqd 72(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqd 40(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm3, %xmm1
; X86-SSE2-NEXT:    pcmpeqd 56(%ebp), %xmm2
; X86-SSE2-NEXT:    pcmpeqd 24(%ebp), %xmm0
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pand %xmm1, %xmm0
; X86-SSE2-NEXT:    movmskps %xmm0, %eax
; X86-SSE2-NEXT:    xorl $15, %eax
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp_v16i32_v16i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pcmpeqd %xmm7, %xmm3
; X64-SSE2-NEXT:    pcmpeqd %xmm5, %xmm1
; X64-SSE2-NEXT:    pand %xmm3, %xmm1
; X64-SSE2-NEXT:    pcmpeqd %xmm6, %xmm2
; X64-SSE2-NEXT:    pcmpeqd %xmm4, %xmm0
; X64-SSE2-NEXT:    pand %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    movmskps %xmm0, %eax
; X64-SSE2-NEXT:    xorl $15, %eax
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp_v16i32_v16i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm7, %xmm3
; SSE41-NEXT:    pxor %xmm5, %xmm1
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    pxor %xmm6, %xmm2
; SSE41-NEXT:    pxor %xmm4, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp_v16i32_v16i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest %ymm0, %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v16i32_v16i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vptest %ymm0, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp_v16i32_v16i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <16 x i32> %0, %1
  %b = call i1 @llvm.vector.reduce.and.v16i1(<16 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v32i16_v32i1(<32 x i16>, <32 x i16>) nounwind {
; X86-SSE2-LABEL: icmp_v32i16_v32i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    movdqa 8(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqb 72(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqb 40(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm3, %xmm1
; X86-SSE2-NEXT:    pcmpeqb 56(%ebp), %xmm2
; X86-SSE2-NEXT:    pcmpeqb 24(%ebp), %xmm0
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pand %xmm1, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp_v32i16_v32i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pcmpeqb %xmm7, %xmm3
; X64-SSE2-NEXT:    pcmpeqb %xmm5, %xmm1
; X64-SSE2-NEXT:    pand %xmm3, %xmm1
; X64-SSE2-NEXT:    pcmpeqb %xmm6, %xmm2
; X64-SSE2-NEXT:    pcmpeqb %xmm4, %xmm0
; X64-SSE2-NEXT:    pand %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp_v32i16_v32i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm7, %xmm3
; SSE41-NEXT:    pxor %xmm5, %xmm1
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    pxor %xmm6, %xmm2
; SSE41-NEXT:    pxor %xmm4, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp_v32i16_v32i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest %ymm0, %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v32i16_v32i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vptest %ymm0, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp_v32i16_v32i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <32 x i16> %0, %1
  %b = call i1 @llvm.vector.reduce.and.v32i1(<32 x i1> %a)
  ret i1 %b
}

define i1 @icmp_v64i8_v64i1(<64 x i8>, <64 x i8>) nounwind {
; X86-SSE2-LABEL: icmp_v64i8_v64i1:
; X86-SSE2:       # %bb.0:
; X86-SSE2-NEXT:    pushl %ebp
; X86-SSE2-NEXT:    movl %esp, %ebp
; X86-SSE2-NEXT:    andl $-16, %esp
; X86-SSE2-NEXT:    subl $16, %esp
; X86-SSE2-NEXT:    movdqa 8(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqb 72(%ebp), %xmm3
; X86-SSE2-NEXT:    pcmpeqb 40(%ebp), %xmm1
; X86-SSE2-NEXT:    pand %xmm3, %xmm1
; X86-SSE2-NEXT:    pcmpeqb 56(%ebp), %xmm2
; X86-SSE2-NEXT:    pcmpeqb 24(%ebp), %xmm0
; X86-SSE2-NEXT:    pand %xmm2, %xmm0
; X86-SSE2-NEXT:    pand %xmm1, %xmm0
; X86-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X86-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X86-SSE2-NEXT:    sete %al
; X86-SSE2-NEXT:    movl %ebp, %esp
; X86-SSE2-NEXT:    popl %ebp
; X86-SSE2-NEXT:    retl
;
; X64-SSE2-LABEL: icmp_v64i8_v64i1:
; X64-SSE2:       # %bb.0:
; X64-SSE2-NEXT:    pcmpeqb %xmm7, %xmm3
; X64-SSE2-NEXT:    pcmpeqb %xmm5, %xmm1
; X64-SSE2-NEXT:    pand %xmm3, %xmm1
; X64-SSE2-NEXT:    pcmpeqb %xmm6, %xmm2
; X64-SSE2-NEXT:    pcmpeqb %xmm4, %xmm0
; X64-SSE2-NEXT:    pand %xmm2, %xmm0
; X64-SSE2-NEXT:    pand %xmm1, %xmm0
; X64-SSE2-NEXT:    pmovmskb %xmm0, %eax
; X64-SSE2-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; X64-SSE2-NEXT:    sete %al
; X64-SSE2-NEXT:    retq
;
; SSE41-LABEL: icmp_v64i8_v64i1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pxor %xmm7, %xmm3
; SSE41-NEXT:    pxor %xmm5, %xmm1
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    pxor %xmm6, %xmm2
; SSE41-NEXT:    pxor %xmm4, %xmm0
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: icmp_v64i8_v64i1:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest %ymm0, %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: icmp_v64i8_v64i1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vptest %ymm0, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: icmp_v64i8_v64i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %a = icmp eq <64 x i8> %0, %1
  %b = call i1 @llvm.vector.reduce.and.v64i1(<64 x i1> %a)
  ret i1 %b
}

declare i1 @llvm.vector.reduce.and.v2i1(<2 x i1>)
declare i1 @llvm.vector.reduce.and.v4i1(<4 x i1>)
declare i1 @llvm.vector.reduce.and.v8i1(<8 x i1>)
declare i1 @llvm.vector.reduce.and.v16i1(<16 x i1>)
declare i1 @llvm.vector.reduce.and.v32i1(<32 x i1>)
declare i1 @llvm.vector.reduce.and.v64i1(<64 x i1>)
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; SSE: {{.*}}
; X64-SSE: {{.*}}
