; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512f,avx512vl -O3 | FileCheck %s --check-prefixes=CHECK,AVX512VL,AVX512VL-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,avx512vl -O3 | FileCheck %s --check-prefixes=CHECK,AVX512VL,AVX512VL-64
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=avx512f,avx512dq -O3 | FileCheck %s --check-prefixes=CHECK,AVX512DQ
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=avx512f,avx512dq -O3 | FileCheck %s --check-prefixes=CHECK,AVX512DQ

declare <8 x i64> @llvm.experimental.constrained.fptosi.v8i64.v8f64(<8 x double>, metadata)
declare <8 x i64> @llvm.experimental.constrained.fptoui.v8i64.v8f64(<8 x double>, metadata)
declare <8 x i64> @llvm.experimental.constrained.fptosi.v8i64.v8f32(<8 x float>, metadata)
declare <8 x i64> @llvm.experimental.constrained.fptoui.v8i64.v8f32(<8 x float>, metadata)
declare <8 x i32> @llvm.experimental.constrained.fptosi.v8i32.v8f64(<8 x double>, metadata)
declare <8 x i32> @llvm.experimental.constrained.fptoui.v8i32.v8f64(<8 x double>, metadata)
declare <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f64(<8 x double>, metadata)
declare <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f64(<8 x double>, metadata)
declare <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f64(<8 x double>, metadata)
declare <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f64(<8 x double>, metadata)
declare <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f64(<8 x double>, metadata)
declare <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f64(<8 x double>, metadata)
declare <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f32(<8 x float>, metadata)
declare <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f32(<8 x float>, metadata)

declare <16 x i32> @llvm.experimental.constrained.fptosi.v16i32.v16f32(<16 x float>, metadata)
declare <16 x i32> @llvm.experimental.constrained.fptoui.v16i32.v16f32(<16 x float>, metadata)
declare <16 x i16> @llvm.experimental.constrained.fptosi.v16i16.v16f32(<16 x float>, metadata)
declare <16 x i16> @llvm.experimental.constrained.fptoui.v16i16.v16f32(<16 x float>, metadata)
declare <16 x i8> @llvm.experimental.constrained.fptosi.v16i8.v16f32(<16 x float>, metadata)
declare <16 x i8> @llvm.experimental.constrained.fptoui.v16i8.v16f32(<16 x float>, metadata)
declare <16 x i1> @llvm.experimental.constrained.fptosi.v16i1.v16f32(<16 x float>, metadata)
declare <16 x i1> @llvm.experimental.constrained.fptoui.v16i1.v16f32(<16 x float>, metadata)

define <8 x i64> @strict_vector_fptosi_v8f64_to_v8i64(<8 x double> %a) #0 {
; AVX512VL-32-LABEL: strict_vector_fptosi_v8f64_to_v8i64:
; AVX512VL-32:       # %bb.0:
; AVX512VL-32-NEXT:    pushl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512VL-32-NEXT:    .cfi_offset %ebp, -8
; AVX512VL-32-NEXT:    movl %esp, %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX512VL-32-NEXT:    andl $-8, %esp
; AVX512VL-32-NEXT:    subl $64, %esp
; AVX512VL-32-NEXT:    vextractf32x4 $2, %zmm0, %xmm1
; AVX512VL-32-NEXT:    vmovlps %xmm1, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vmovhps %xmm1, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractf32x4 $3, %zmm0, %xmm1
; AVX512VL-32-NEXT:    vmovlps %xmm1, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vmovhps %xmm1, (%esp)
; AVX512VL-32-NEXT:    vmovlps %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vmovhps %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX512VL-32-NEXT:    vmovlps %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vmovhps %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl (%esp)
; AVX512VL-32-NEXT:    fisttpll (%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    wait
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $2, (%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm2, %xmm2
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm2, %xmm2
; AVX512VL-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm2, %xmm2
; AVX512VL-32-NEXT:    vinserti128 $1, %xmm2, %ymm1, %ymm1
; AVX512VL-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512VL-32-NEXT:    movl %ebp, %esp
; AVX512VL-32-NEXT:    popl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX512VL-32-NEXT:    retl
;
; AVX512VL-64-LABEL: strict_vector_fptosi_v8f64_to_v8i64:
; AVX512VL-64:       # %bb.0:
; AVX512VL-64-NEXT:    vextractf32x4 $3, %zmm0, %xmm1
; AVX512VL-64-NEXT:    vcvttsd2si %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vshufpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX512VL-64-NEXT:    vcvttsd2si %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm1
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512VL-64-NEXT:    vextractf32x4 $2, %zmm0, %xmm2
; AVX512VL-64-NEXT:    vcvttsd2si %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vshufpd {{.*#+}} xmm2 = xmm2[1,0]
; AVX512VL-64-NEXT:    vcvttsd2si %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512VL-64-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512VL-64-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX512VL-64-NEXT:    vcvttsd2si %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vshufpd {{.*#+}} xmm2 = xmm2[1,0]
; AVX512VL-64-NEXT:    vcvttsd2si %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512VL-64-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-64-NEXT:    vcvttsd2si %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm0
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm3[0],xmm0[0]
; AVX512VL-64-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-64-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512VL-64-NEXT:    retq
;
; AVX512DQ-LABEL: strict_vector_fptosi_v8f64_to_v8i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2qq %zmm0, %zmm0
; AVX512DQ-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i64> @llvm.experimental.constrained.fptosi.v8i64.v8f64(<8 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i64> %ret
}

define <8 x i64> @strict_vector_fptoui_v8f64_to_v8i64(<8 x double> %a) #0 {
; AVX512VL-32-LABEL: strict_vector_fptoui_v8f64_to_v8i64:
; AVX512VL-32:       # %bb.0:
; AVX512VL-32-NEXT:    pushl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512VL-32-NEXT:    .cfi_offset %ebp, -8
; AVX512VL-32-NEXT:    movl %esp, %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX512VL-32-NEXT:    pushl %ebx
; AVX512VL-32-NEXT:    pushl %edi
; AVX512VL-32-NEXT:    pushl %esi
; AVX512VL-32-NEXT:    andl $-8, %esp
; AVX512VL-32-NEXT:    subl $80, %esp
; AVX512VL-32-NEXT:    .cfi_offset %esi, -20
; AVX512VL-32-NEXT:    .cfi_offset %edi, -16
; AVX512VL-32-NEXT:    .cfi_offset %ebx, -12
; AVX512VL-32-NEXT:    vextractf32x4 $3, %zmm0, %xmm2
; AVX512VL-32-NEXT:    vshufpd {{.*#+}} xmm3 = xmm2[1,0]
; AVX512VL-32-NEXT:    vmovsd {{.*#+}} xmm1 = mem[0],zero
; AVX512VL-32-NEXT:    xorl %eax, %eax
; AVX512VL-32-NEXT:    vcomisd %xmm1, %xmm3
; AVX512VL-32-NEXT:    setae %al
; AVX512VL-32-NEXT:    kmovw %eax, %k1
; AVX512VL-32-NEXT:    movl %eax, %edi
; AVX512VL-32-NEXT:    vmovsd %xmm1, %xmm1, %xmm4 {%k1} {z}
; AVX512VL-32-NEXT:    vsubsd %xmm4, %xmm3, %xmm3
; AVX512VL-32-NEXT:    vmovsd %xmm3, (%esp)
; AVX512VL-32-NEXT:    xorl %eax, %eax
; AVX512VL-32-NEXT:    vcomisd %xmm1, %xmm2
; AVX512VL-32-NEXT:    setae %al
; AVX512VL-32-NEXT:    kmovw %eax, %k1
; AVX512VL-32-NEXT:    movl %eax, %esi
; AVX512VL-32-NEXT:    vmovsd %xmm1, %xmm1, %xmm3 {%k1} {z}
; AVX512VL-32-NEXT:    vsubsd %xmm3, %xmm2, %xmm2
; AVX512VL-32-NEXT:    vmovsd %xmm2, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractf32x4 $2, %zmm0, %xmm2
; AVX512VL-32-NEXT:    vshufpd {{.*#+}} xmm3 = xmm2[1,0]
; AVX512VL-32-NEXT:    xorl %eax, %eax
; AVX512VL-32-NEXT:    vcomisd %xmm1, %xmm3
; AVX512VL-32-NEXT:    setae %al
; AVX512VL-32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; AVX512VL-32-NEXT:    kmovw %eax, %k1
; AVX512VL-32-NEXT:    vmovsd %xmm1, %xmm1, %xmm4 {%k1} {z}
; AVX512VL-32-NEXT:    vsubsd %xmm4, %xmm3, %xmm3
; AVX512VL-32-NEXT:    vmovsd %xmm3, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    xorl %edx, %edx
; AVX512VL-32-NEXT:    vcomisd %xmm1, %xmm2
; AVX512VL-32-NEXT:    setae %dl
; AVX512VL-32-NEXT:    kmovw %edx, %k1
; AVX512VL-32-NEXT:    vmovsd %xmm1, %xmm1, %xmm3 {%k1} {z}
; AVX512VL-32-NEXT:    vsubsd %xmm3, %xmm2, %xmm2
; AVX512VL-32-NEXT:    vmovsd %xmm2, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX512VL-32-NEXT:    vshufpd {{.*#+}} xmm3 = xmm2[1,0]
; AVX512VL-32-NEXT:    xorl %eax, %eax
; AVX512VL-32-NEXT:    vcomisd %xmm1, %xmm3
; AVX512VL-32-NEXT:    setae %al
; AVX512VL-32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; AVX512VL-32-NEXT:    kmovw %eax, %k1
; AVX512VL-32-NEXT:    vmovsd %xmm1, %xmm1, %xmm4 {%k1} {z}
; AVX512VL-32-NEXT:    vsubsd %xmm4, %xmm3, %xmm3
; AVX512VL-32-NEXT:    vmovsd %xmm3, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    xorl %ecx, %ecx
; AVX512VL-32-NEXT:    vcomisd %xmm1, %xmm2
; AVX512VL-32-NEXT:    setae %cl
; AVX512VL-32-NEXT:    kmovw %ecx, %k1
; AVX512VL-32-NEXT:    vmovsd %xmm1, %xmm1, %xmm3 {%k1} {z}
; AVX512VL-32-NEXT:    vsubsd %xmm3, %xmm2, %xmm2
; AVX512VL-32-NEXT:    vmovsd %xmm2, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX512VL-32-NEXT:    xorl %ebx, %ebx
; AVX512VL-32-NEXT:    vcomisd %xmm1, %xmm2
; AVX512VL-32-NEXT:    setae %bl
; AVX512VL-32-NEXT:    kmovw %ebx, %k1
; AVX512VL-32-NEXT:    vmovsd %xmm1, %xmm1, %xmm3 {%k1} {z}
; AVX512VL-32-NEXT:    vsubsd %xmm3, %xmm2, %xmm2
; AVX512VL-32-NEXT:    vmovsd %xmm2, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    xorl %eax, %eax
; AVX512VL-32-NEXT:    vcomisd %xmm1, %xmm0
; AVX512VL-32-NEXT:    setae %al
; AVX512VL-32-NEXT:    kmovw %eax, %k1
; AVX512VL-32-NEXT:    vmovsd %xmm1, %xmm1, %xmm1 {%k1} {z}
; AVX512VL-32-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; AVX512VL-32-NEXT:    vmovsd %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl (%esp)
; AVX512VL-32-NEXT:    fisttpll (%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fldl {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    wait
; AVX512VL-32-NEXT:    shll $31, %esi
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %esi
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, %esi, %xmm0, %xmm0
; AVX512VL-32-NEXT:    shll $31, %edi
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %edi
; AVX512VL-32-NEXT:    vpinsrd $2, (%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $3, %edi, %xmm0, %xmm0
; AVX512VL-32-NEXT:    shll $31, %edx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, %edx, %xmm1, %xmm1
; AVX512VL-32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; AVX512VL-32-NEXT:    shll $31, %edx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $3, %edx, %xmm1, %xmm1
; AVX512VL-32-NEXT:    shll $31, %ecx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, %ecx, %xmm2, %xmm2
; AVX512VL-32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; AVX512VL-32-NEXT:    shll $31, %ecx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm2, %xmm2
; AVX512VL-32-NEXT:    vpinsrd $3, %ecx, %xmm2, %xmm2
; AVX512VL-32-NEXT:    shll $31, %eax
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, %eax, %xmm3, %xmm3
; AVX512VL-32-NEXT:    shll $31, %ebx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %ebx
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm3, %xmm3
; AVX512VL-32-NEXT:    vpinsrd $3, %ebx, %xmm3, %xmm3
; AVX512VL-32-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512VL-32-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm1
; AVX512VL-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512VL-32-NEXT:    leal -12(%ebp), %esp
; AVX512VL-32-NEXT:    popl %esi
; AVX512VL-32-NEXT:    popl %edi
; AVX512VL-32-NEXT:    popl %ebx
; AVX512VL-32-NEXT:    popl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX512VL-32-NEXT:    retl
;
; AVX512VL-64-LABEL: strict_vector_fptoui_v8f64_to_v8i64:
; AVX512VL-64:       # %bb.0:
; AVX512VL-64-NEXT:    vextractf32x4 $3, %zmm0, %xmm1
; AVX512VL-64-NEXT:    vcvttsd2usi %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vshufpd {{.*#+}} xmm1 = xmm1[1,0]
; AVX512VL-64-NEXT:    vcvttsd2usi %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm1
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm2[0],xmm1[0]
; AVX512VL-64-NEXT:    vextractf32x4 $2, %zmm0, %xmm2
; AVX512VL-64-NEXT:    vcvttsd2usi %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vshufpd {{.*#+}} xmm2 = xmm2[1,0]
; AVX512VL-64-NEXT:    vcvttsd2usi %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512VL-64-NEXT:    vinserti128 $1, %xmm1, %ymm2, %ymm1
; AVX512VL-64-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX512VL-64-NEXT:    vcvttsd2usi %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vshufpd {{.*#+}} xmm2 = xmm2[1,0]
; AVX512VL-64-NEXT:    vcvttsd2usi %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512VL-64-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vshufpd {{.*#+}} xmm0 = xmm0[1,0]
; AVX512VL-64-NEXT:    vcvttsd2usi %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm0
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm3[0],xmm0[0]
; AVX512VL-64-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-64-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512VL-64-NEXT:    retq
;
; AVX512DQ-LABEL: strict_vector_fptoui_v8f64_to_v8i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2uqq %zmm0, %zmm0
; AVX512DQ-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i64> @llvm.experimental.constrained.fptoui.v8i64.v8f64(<8 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i64> %ret
}

define <8 x i64> @strict_vector_fptosi_v8f32_to_v8i64(<8 x float> %a) #0 {
; AVX512VL-32-LABEL: strict_vector_fptosi_v8f32_to_v8i64:
; AVX512VL-32:       # %bb.0:
; AVX512VL-32-NEXT:    pushl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512VL-32-NEXT:    .cfi_offset %ebp, -8
; AVX512VL-32-NEXT:    movl %esp, %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX512VL-32-NEXT:    andl $-8, %esp
; AVX512VL-32-NEXT:    subl $64, %esp
; AVX512VL-32-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512VL-32-NEXT:    vmovd %xmm1, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractps $1, %xmm1, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractps $2, %xmm1, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractps $3, %xmm1, (%esp)
; AVX512VL-32-NEXT:    vmovd %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractps $1, %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractps $2, %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vextractps $3, %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds (%esp)
; AVX512VL-32-NEXT:    fisttpll (%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    wait
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $2, (%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, {{[0-9]+}}(%esp), %xmm2, %xmm2
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm2, %xmm2
; AVX512VL-32-NEXT:    vpinsrd $3, {{[0-9]+}}(%esp), %xmm2, %xmm2
; AVX512VL-32-NEXT:    vinserti128 $1, %xmm2, %ymm1, %ymm1
; AVX512VL-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512VL-32-NEXT:    movl %ebp, %esp
; AVX512VL-32-NEXT:    popl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX512VL-32-NEXT:    retl
;
; AVX512VL-64-LABEL: strict_vector_fptosi_v8f32_to_v8i64:
; AVX512VL-64:       # %bb.0:
; AVX512VL-64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512VL-64-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[3,3,3,3]
; AVX512VL-64-NEXT:    vcvttss2si %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vshufpd {{.*#+}} xmm3 = xmm1[1,0]
; AVX512VL-64-NEXT:    vcvttss2si %xmm3, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512VL-64-NEXT:    vcvttss2si %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm1[1,1,3,3]
; AVX512VL-64-NEXT:    vcvttss2si %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm1
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm1[0]
; AVX512VL-64-NEXT:    vinserti128 $1, %xmm2, %ymm1, %ymm1
; AVX512VL-64-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[3,3,3,3]
; AVX512VL-64-NEXT:    vcvttss2si %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vshufpd {{.*#+}} xmm3 = xmm0[1,0]
; AVX512VL-64-NEXT:    vcvttss2si %xmm3, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512VL-64-NEXT:    vcvttss2si %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512VL-64-NEXT:    vcvttss2si %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm0
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm3[0],xmm0[0]
; AVX512VL-64-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-64-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512VL-64-NEXT:    retq
;
; AVX512DQ-LABEL: strict_vector_fptosi_v8f32_to_v8i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2qq %ymm0, %zmm0
; AVX512DQ-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i64> @llvm.experimental.constrained.fptosi.v8i64.v8f32(<8 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i64> %ret
}

define <8 x i64> @strict_vector_fptoui_v8f32_to_v8i64(<8 x float> %a) #0 {
; AVX512VL-32-LABEL: strict_vector_fptoui_v8f32_to_v8i64:
; AVX512VL-32:       # %bb.0:
; AVX512VL-32-NEXT:    pushl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_offset 8
; AVX512VL-32-NEXT:    .cfi_offset %ebp, -8
; AVX512VL-32-NEXT:    movl %esp, %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa_register %ebp
; AVX512VL-32-NEXT:    pushl %ebx
; AVX512VL-32-NEXT:    pushl %edi
; AVX512VL-32-NEXT:    pushl %esi
; AVX512VL-32-NEXT:    andl $-8, %esp
; AVX512VL-32-NEXT:    subl $80, %esp
; AVX512VL-32-NEXT:    .cfi_offset %esi, -20
; AVX512VL-32-NEXT:    .cfi_offset %edi, -16
; AVX512VL-32-NEXT:    .cfi_offset %ebx, -12
; AVX512VL-32-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX512VL-32-NEXT:    vshufps {{.*#+}} xmm3 = xmm2[3,3,3,3]
; AVX512VL-32-NEXT:    vmovss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    xorl %eax, %eax
; AVX512VL-32-NEXT:    vcomiss %xmm1, %xmm3
; AVX512VL-32-NEXT:    setae %al
; AVX512VL-32-NEXT:    kmovw %eax, %k1
; AVX512VL-32-NEXT:    movl %eax, %edi
; AVX512VL-32-NEXT:    vmovss %xmm1, %xmm1, %xmm4 {%k1} {z}
; AVX512VL-32-NEXT:    vsubss %xmm4, %xmm3, %xmm3
; AVX512VL-32-NEXT:    vmovss %xmm3, (%esp)
; AVX512VL-32-NEXT:    vshufpd {{.*#+}} xmm3 = xmm2[1,0]
; AVX512VL-32-NEXT:    xorl %eax, %eax
; AVX512VL-32-NEXT:    vcomiss %xmm1, %xmm3
; AVX512VL-32-NEXT:    setae %al
; AVX512VL-32-NEXT:    kmovw %eax, %k1
; AVX512VL-32-NEXT:    movl %eax, %esi
; AVX512VL-32-NEXT:    vmovss %xmm1, %xmm1, %xmm4 {%k1} {z}
; AVX512VL-32-NEXT:    vsubss %xmm4, %xmm3, %xmm3
; AVX512VL-32-NEXT:    vmovss %xmm3, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vmovshdup {{.*#+}} xmm3 = xmm2[1,1,3,3]
; AVX512VL-32-NEXT:    xorl %eax, %eax
; AVX512VL-32-NEXT:    vcomiss %xmm1, %xmm3
; AVX512VL-32-NEXT:    setae %al
; AVX512VL-32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; AVX512VL-32-NEXT:    kmovw %eax, %k1
; AVX512VL-32-NEXT:    vmovss %xmm1, %xmm1, %xmm4 {%k1} {z}
; AVX512VL-32-NEXT:    vsubss %xmm4, %xmm3, %xmm3
; AVX512VL-32-NEXT:    vmovss %xmm3, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    xorl %edx, %edx
; AVX512VL-32-NEXT:    vcomiss %xmm1, %xmm2
; AVX512VL-32-NEXT:    setae %dl
; AVX512VL-32-NEXT:    kmovw %edx, %k1
; AVX512VL-32-NEXT:    vmovss %xmm1, %xmm1, %xmm3 {%k1} {z}
; AVX512VL-32-NEXT:    vsubss %xmm3, %xmm2, %xmm2
; AVX512VL-32-NEXT:    vmovss %xmm2, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[3,3,3,3]
; AVX512VL-32-NEXT:    xorl %eax, %eax
; AVX512VL-32-NEXT:    vcomiss %xmm1, %xmm2
; AVX512VL-32-NEXT:    setae %al
; AVX512VL-32-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; AVX512VL-32-NEXT:    kmovw %eax, %k1
; AVX512VL-32-NEXT:    vmovss %xmm1, %xmm1, %xmm3 {%k1} {z}
; AVX512VL-32-NEXT:    vsubss %xmm3, %xmm2, %xmm2
; AVX512VL-32-NEXT:    vmovss %xmm2, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vshufpd {{.*#+}} xmm2 = xmm0[1,0]
; AVX512VL-32-NEXT:    xorl %ecx, %ecx
; AVX512VL-32-NEXT:    vcomiss %xmm1, %xmm2
; AVX512VL-32-NEXT:    setae %cl
; AVX512VL-32-NEXT:    kmovw %ecx, %k1
; AVX512VL-32-NEXT:    vmovss %xmm1, %xmm1, %xmm3 {%k1} {z}
; AVX512VL-32-NEXT:    vsubss %xmm3, %xmm2, %xmm2
; AVX512VL-32-NEXT:    vmovss %xmm2, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    vmovshdup {{.*#+}} xmm2 = xmm0[1,1,3,3]
; AVX512VL-32-NEXT:    xorl %ebx, %ebx
; AVX512VL-32-NEXT:    vcomiss %xmm1, %xmm2
; AVX512VL-32-NEXT:    setae %bl
; AVX512VL-32-NEXT:    kmovw %ebx, %k1
; AVX512VL-32-NEXT:    vmovss %xmm1, %xmm1, %xmm3 {%k1} {z}
; AVX512VL-32-NEXT:    vsubss %xmm3, %xmm2, %xmm2
; AVX512VL-32-NEXT:    vmovss %xmm2, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    xorl %eax, %eax
; AVX512VL-32-NEXT:    vcomiss %xmm1, %xmm0
; AVX512VL-32-NEXT:    setae %al
; AVX512VL-32-NEXT:    kmovw %eax, %k1
; AVX512VL-32-NEXT:    vmovss %xmm1, %xmm1, %xmm1 {%k1} {z}
; AVX512VL-32-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX512VL-32-NEXT:    vmovss %xmm0, {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds (%esp)
; AVX512VL-32-NEXT:    fisttpll (%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    flds {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    fisttpll {{[0-9]+}}(%esp)
; AVX512VL-32-NEXT:    wait
; AVX512VL-32-NEXT:    shll $31, %esi
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %esi
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, %esi, %xmm0, %xmm0
; AVX512VL-32-NEXT:    shll $31, %edi
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %edi
; AVX512VL-32-NEXT:    vpinsrd $2, (%esp), %xmm0, %xmm0
; AVX512VL-32-NEXT:    vpinsrd $3, %edi, %xmm0, %xmm0
; AVX512VL-32-NEXT:    shll $31, %edx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, %edx, %xmm1, %xmm1
; AVX512VL-32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %edx # 4-byte Reload
; AVX512VL-32-NEXT:    shll $31, %edx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm1, %xmm1
; AVX512VL-32-NEXT:    vpinsrd $3, %edx, %xmm1, %xmm1
; AVX512VL-32-NEXT:    shll $31, %ecx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm2 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, %ecx, %xmm2, %xmm2
; AVX512VL-32-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; AVX512VL-32-NEXT:    shll $31, %ecx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %ecx
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm2, %xmm2
; AVX512VL-32-NEXT:    vpinsrd $3, %ecx, %xmm2, %xmm2
; AVX512VL-32-NEXT:    shll $31, %eax
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; AVX512VL-32-NEXT:    vmovd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; AVX512VL-32-NEXT:    vpinsrd $1, %eax, %xmm3, %xmm3
; AVX512VL-32-NEXT:    shll $31, %ebx
; AVX512VL-32-NEXT:    xorl {{[0-9]+}}(%esp), %ebx
; AVX512VL-32-NEXT:    vpinsrd $2, {{[0-9]+}}(%esp), %xmm3, %xmm3
; AVX512VL-32-NEXT:    vpinsrd $3, %ebx, %xmm3, %xmm3
; AVX512VL-32-NEXT:    vinserti128 $1, %xmm0, %ymm1, %ymm0
; AVX512VL-32-NEXT:    vinserti128 $1, %xmm2, %ymm3, %ymm1
; AVX512VL-32-NEXT:    vinserti64x4 $1, %ymm0, %zmm1, %zmm0
; AVX512VL-32-NEXT:    leal -12(%ebp), %esp
; AVX512VL-32-NEXT:    popl %esi
; AVX512VL-32-NEXT:    popl %edi
; AVX512VL-32-NEXT:    popl %ebx
; AVX512VL-32-NEXT:    popl %ebp
; AVX512VL-32-NEXT:    .cfi_def_cfa %esp, 4
; AVX512VL-32-NEXT:    retl
;
; AVX512VL-64-LABEL: strict_vector_fptoui_v8f32_to_v8i64:
; AVX512VL-64:       # %bb.0:
; AVX512VL-64-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX512VL-64-NEXT:    vshufps {{.*#+}} xmm2 = xmm1[3,3,3,3]
; AVX512VL-64-NEXT:    vcvttss2usi %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vshufpd {{.*#+}} xmm3 = xmm1[1,0]
; AVX512VL-64-NEXT:    vcvttss2usi %xmm3, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512VL-64-NEXT:    vcvttss2usi %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vmovshdup {{.*#+}} xmm1 = xmm1[1,1,3,3]
; AVX512VL-64-NEXT:    vcvttss2usi %xmm1, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm1
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm1 = xmm3[0],xmm1[0]
; AVX512VL-64-NEXT:    vinserti128 $1, %xmm2, %ymm1, %ymm1
; AVX512VL-64-NEXT:    vshufps {{.*#+}} xmm2 = xmm0[3,3,3,3]
; AVX512VL-64-NEXT:    vcvttss2usi %xmm2, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm2
; AVX512VL-64-NEXT:    vshufpd {{.*#+}} xmm3 = xmm0[1,0]
; AVX512VL-64-NEXT:    vcvttss2usi %xmm3, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm2 = xmm3[0],xmm2[0]
; AVX512VL-64-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm3
; AVX512VL-64-NEXT:    vmovshdup {{.*#+}} xmm0 = xmm0[1,1,3,3]
; AVX512VL-64-NEXT:    vcvttss2usi %xmm0, %rax
; AVX512VL-64-NEXT:    vmovq %rax, %xmm0
; AVX512VL-64-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm3[0],xmm0[0]
; AVX512VL-64-NEXT:    vinserti128 $1, %xmm2, %ymm0, %ymm0
; AVX512VL-64-NEXT:    vinserti64x4 $1, %ymm1, %zmm0, %zmm0
; AVX512VL-64-NEXT:    retq
;
; AVX512DQ-LABEL: strict_vector_fptoui_v8f32_to_v8i64:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2uqq %ymm0, %zmm0
; AVX512DQ-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i64> @llvm.experimental.constrained.fptoui.v8i64.v8f32(<8 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i64> %ret
}

define <8 x i32> @strict_vector_fptosi_v8f64_to_v8i32(<8 x double> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v8f64_to_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2dq %zmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i32> @llvm.experimental.constrained.fptosi.v8i32.v8f64(<8 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i32> %ret
}

define <8 x i32> @strict_vector_fptoui_v8f64_to_v8i32(<8 x double> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v8f64_to_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttpd2udq %zmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i32> @llvm.experimental.constrained.fptoui.v8i32.v8f64(<8 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i32> %ret
}

define <8 x i16> @strict_vector_fptosi_v8f64_to_v8i16(<8 x double> %a) #0 {
; AVX512VL-LABEL: strict_vector_fptosi_v8f64_to_v8i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptosi_v8f64_to_v8i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512DQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i16> @llvm.experimental.constrained.fptosi.v8i16.v8f64(<8 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i16> %ret
}

define <8 x i16> @strict_vector_fptoui_v8f64_to_v8i16(<8 x double> %a) #0 {
; AVX512VL-LABEL: strict_vector_fptoui_v8f64_to_v8i16:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptoui_v8f64_to_v8i16:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512DQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i16> @llvm.experimental.constrained.fptoui.v8i16.v8f64(<8 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i16> %ret
}

define <8 x i8> @strict_vector_fptosi_v8f64_to_v8i8(<8 x double> %a) #0 {
; AVX512VL-LABEL: strict_vector_fptosi_v8f64_to_v8i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512VL-NEXT:    vpmovdb %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptosi_v8f64_to_v8i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i8> @llvm.experimental.constrained.fptosi.v8i8.v8f64(<8 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i8> %ret
}

define <8 x i8> @strict_vector_fptoui_v8f64_to_v8i8(<8 x double> %a) #0 {
; AVX512VL-LABEL: strict_vector_fptoui_v8f64_to_v8i8:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512VL-NEXT:    vpmovdb %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptoui_v8f64_to_v8i8:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i8> @llvm.experimental.constrained.fptoui.v8i8.v8f64(<8 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i8> %ret
}

define <8 x i1> @strict_vector_fptosi_v8f64_to_v8i1(<8 x double> %a) #0 {
; AVX512VL-LABEL: strict_vector_fptosi_v8f64_to_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptosi_v8f64_to_v8i1:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512DQ-NEXT:    vpmovd2m %zmm0, %k0
; AVX512DQ-NEXT:    vpmovm2d %k0, %zmm0
; AVX512DQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i1> @llvm.experimental.constrained.fptosi.v8i1.v8f64(<8 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i1> %ret
}

define <8 x i1> @strict_vector_fptoui_v8f64_to_v8i1(<8 x double> %a) #0 {
; AVX512VL-LABEL: strict_vector_fptoui_v8f64_to_v8i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512VL-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512VL-NEXT:    vptestmd %ymm0, %ymm0, %k1
; AVX512VL-NEXT:    vpcmpeqd %ymm0, %ymm0, %ymm0
; AVX512VL-NEXT:    vmovdqa32 %ymm0, %ymm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdw %ymm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptoui_v8f64_to_v8i1:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttpd2dq %zmm0, %ymm0
; AVX512DQ-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX512DQ-NEXT:    vpmovd2m %zmm0, %k0
; AVX512DQ-NEXT:    vpmovm2d %k0, %zmm0
; AVX512DQ-NEXT:    vpmovdw %zmm0, %ymm0
; AVX512DQ-NEXT:    # kill: def $xmm0 killed $xmm0 killed $ymm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
  %ret = call <8 x i1> @llvm.experimental.constrained.fptoui.v8i1.v8f64(<8 x double> %a,
                                              metadata !"fpexcept.strict") #0
  ret <8 x i1> %ret
}

define <16 x i32> @strict_vector_fptosi_v16f32_to_v16i32(<16 x float> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v16f32_to_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2dq %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <16 x i32> @llvm.experimental.constrained.fptosi.v16i32.v16f32(<16 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <16 x i32> %ret
}

define <16 x i32> @strict_vector_fptoui_v16f32_to_v16i32(<16 x float> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v16f32_to_v16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2udq %zmm0, %zmm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <16 x i32> @llvm.experimental.constrained.fptoui.v16i32.v16f32(<16 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <16 x i32> %ret
}

define <16 x i16> @strict_vector_fptosi_v16f32_to_v16i16(<16 x float> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v16f32_to_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2dq %zmm0, %zmm0
; CHECK-NEXT:    vpmovdw %zmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <16 x i16> @llvm.experimental.constrained.fptosi.v16i16.v16f32(<16 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <16 x i16> %ret
}

define <16 x i16> @strict_vector_fptoui_v16f32_to_v16i16(<16 x float> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v16f32_to_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2udq %zmm0, %zmm0
; CHECK-NEXT:    vpmovdw %zmm0, %ymm0
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <16 x i16> @llvm.experimental.constrained.fptoui.v16i16.v16f32(<16 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <16 x i16> %ret
}

define <16 x i8> @strict_vector_fptosi_v16f32_to_v16i8(<16 x float> %a) #0 {
; CHECK-LABEL: strict_vector_fptosi_v16f32_to_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2dq %zmm0, %zmm0
; CHECK-NEXT:    vpmovdb %zmm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <16 x i8> @llvm.experimental.constrained.fptosi.v16i8.v16f32(<16 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <16 x i8> %ret
}

define <16 x i8> @strict_vector_fptoui_v16f32_to_v16i8(<16 x float> %a) #0 {
; CHECK-LABEL: strict_vector_fptoui_v16f32_to_v16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcvttps2dq %zmm0, %zmm0
; CHECK-NEXT:    vpmovdb %zmm0, %xmm0
; CHECK-NEXT:    vzeroupper
; CHECK-NEXT:    ret{{[l|q]}}
  %ret = call <16 x i8> @llvm.experimental.constrained.fptoui.v16i8.v16f32(<16 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <16 x i8> %ret
}

define <16 x i1> @strict_vector_fptosi_v16f32_to_v16i1(<16 x float> %a) #0 {
; AVX512VL-LABEL: strict_vector_fptosi_v16f32_to_v16i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2dq %zmm0, %zmm0
; AVX512VL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptosi_v16f32_to_v16i1:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2dq %zmm0, %zmm0
; AVX512DQ-NEXT:    vpmovd2m %zmm0, %k0
; AVX512DQ-NEXT:    vpmovm2d %k0, %zmm0
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
  %ret = call <16 x i1> @llvm.experimental.constrained.fptosi.v16i1.v16f32(<16 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <16 x i1> %ret
}

define <16 x i1> @strict_vector_fptoui_v16f32_to_v16i1(<16 x float> %a) #0 {
; AVX512VL-LABEL: strict_vector_fptoui_v16f32_to_v16i1:
; AVX512VL:       # %bb.0:
; AVX512VL-NEXT:    vcvttps2dq %zmm0, %zmm0
; AVX512VL-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512VL-NEXT:    vptestmd %zmm0, %zmm0, %k1
; AVX512VL-NEXT:    vpternlogd $255, %zmm0, %zmm0, %zmm0 {%k1} {z}
; AVX512VL-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512VL-NEXT:    vzeroupper
; AVX512VL-NEXT:    ret{{[l|q]}}
;
; AVX512DQ-LABEL: strict_vector_fptoui_v16f32_to_v16i1:
; AVX512DQ:       # %bb.0:
; AVX512DQ-NEXT:    vcvttps2dq %zmm0, %zmm0
; AVX512DQ-NEXT:    vpslld $31, %zmm0, %zmm0
; AVX512DQ-NEXT:    vpmovd2m %zmm0, %k0
; AVX512DQ-NEXT:    vpmovm2d %k0, %zmm0
; AVX512DQ-NEXT:    vpmovdb %zmm0, %xmm0
; AVX512DQ-NEXT:    vzeroupper
; AVX512DQ-NEXT:    ret{{[l|q]}}
  %ret = call <16 x i1> @llvm.experimental.constrained.fptoui.v16i1.v16f32(<16 x float> %a,
                                              metadata !"fpexcept.strict") #0
  ret <16 x i1> %ret
}


attributes #0 = { strictfp }
