; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers -mattr=+simd128 | FileCheck %s --check-prefix=SIMD128
; RUN: llc < %s -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers -mattr=+simd128 -fast-isel | FileCheck %s --check-prefix=SIMD128-FAST
; RUN: llc < %s -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers | FileCheck %s --check-prefix=NO-SIMD128
; RUN: llc < %s -verify-machineinstrs -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers -fast-isel | FileCheck %s --check-prefix=NO-SIMD128-FAST

; check that a non-test run (including explicit locals pass) at least finishes
; RUN: llc < %s -O0 -mattr=+simd128
; RUN: llc < %s -O2 -mattr=+simd128

; Test that basic SIMD128 arithmetic operations assemble as expected.

target triple = "wasm32-unknown-unknown"

; ==============================================================================
; 16 x i8
; ==============================================================================
define <16 x i8> @add_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: add_v16i8:
; SIMD128:         .functype add_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.add $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: add_v16i8:
; SIMD128-FAST:         .functype add_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.add $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: add_v16i8:
; NO-SIMD128:         .functype add_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.add $push0=, $9, $25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop0
; NO-SIMD128-NEXT:    i32.add $push1=, $5, $21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop1
; NO-SIMD128-NEXT:    i32.add $push2=, $3, $19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-NEXT:    i32.add $push3=, $2, $18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop3
; NO-SIMD128-NEXT:    i32.add $push4=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push6=, 15
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.add $push5=, $16, $32
; NO-SIMD128-NEXT:    i32.store8 0($pop7), $pop5
; NO-SIMD128-NEXT:    i32.const $push9=, 14
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    i32.add $push8=, $15, $31
; NO-SIMD128-NEXT:    i32.store8 0($pop10), $pop8
; NO-SIMD128-NEXT:    i32.const $push12=, 13
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.add $push11=, $14, $30
; NO-SIMD128-NEXT:    i32.store8 0($pop13), $pop11
; NO-SIMD128-NEXT:    i32.const $push15=, 12
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.add $push14=, $13, $29
; NO-SIMD128-NEXT:    i32.store8 0($pop16), $pop14
; NO-SIMD128-NEXT:    i32.const $push18=, 11
; NO-SIMD128-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-NEXT:    i32.add $push17=, $12, $28
; NO-SIMD128-NEXT:    i32.store8 0($pop19), $pop17
; NO-SIMD128-NEXT:    i32.const $push21=, 10
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.add $push20=, $11, $27
; NO-SIMD128-NEXT:    i32.store8 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push24=, 9
; NO-SIMD128-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-NEXT:    i32.add $push23=, $10, $26
; NO-SIMD128-NEXT:    i32.store8 0($pop25), $pop23
; NO-SIMD128-NEXT:    i32.const $push27=, 7
; NO-SIMD128-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-NEXT:    i32.add $push26=, $8, $24
; NO-SIMD128-NEXT:    i32.store8 0($pop28), $pop26
; NO-SIMD128-NEXT:    i32.const $push30=, 6
; NO-SIMD128-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-NEXT:    i32.add $push29=, $7, $23
; NO-SIMD128-NEXT:    i32.store8 0($pop31), $pop29
; NO-SIMD128-NEXT:    i32.const $push33=, 5
; NO-SIMD128-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-NEXT:    i32.add $push32=, $6, $22
; NO-SIMD128-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-NEXT:    i32.const $push36=, 3
; NO-SIMD128-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-NEXT:    i32.add $push35=, $4, $20
; NO-SIMD128-NEXT:    i32.store8 0($pop37), $pop35
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: add_v16i8:
; NO-SIMD128-FAST:         .functype add_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.add $push1=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop8), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.add $push12=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop11), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop14), $pop15
; NO-SIMD128-FAST-NEXT:    i32.add $push16=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.add $push19=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop19
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop21), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-FAST-NEXT:    i32.add $push25=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop24), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop27), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-FAST-NEXT:    i32.add $push31=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop30), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $0, $pop32
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop33), $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-FAST-NEXT:    i32.add $push37=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop36), $pop37
; NO-SIMD128-FAST-NEXT:    return
  %a = add <16 x i8> %x, %y
  ret <16 x i8> %a
}

define <16 x i8> @sub_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: sub_v16i8:
; SIMD128:         .functype sub_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.sub $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sub_v16i8:
; SIMD128-FAST:         .functype sub_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.sub $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sub_v16i8:
; NO-SIMD128:         .functype sub_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.sub $push0=, $9, $25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop0
; NO-SIMD128-NEXT:    i32.sub $push1=, $5, $21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop1
; NO-SIMD128-NEXT:    i32.sub $push2=, $3, $19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-NEXT:    i32.sub $push3=, $2, $18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop3
; NO-SIMD128-NEXT:    i32.sub $push4=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push6=, 15
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.sub $push5=, $16, $32
; NO-SIMD128-NEXT:    i32.store8 0($pop7), $pop5
; NO-SIMD128-NEXT:    i32.const $push9=, 14
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    i32.sub $push8=, $15, $31
; NO-SIMD128-NEXT:    i32.store8 0($pop10), $pop8
; NO-SIMD128-NEXT:    i32.const $push12=, 13
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.sub $push11=, $14, $30
; NO-SIMD128-NEXT:    i32.store8 0($pop13), $pop11
; NO-SIMD128-NEXT:    i32.const $push15=, 12
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.sub $push14=, $13, $29
; NO-SIMD128-NEXT:    i32.store8 0($pop16), $pop14
; NO-SIMD128-NEXT:    i32.const $push18=, 11
; NO-SIMD128-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-NEXT:    i32.sub $push17=, $12, $28
; NO-SIMD128-NEXT:    i32.store8 0($pop19), $pop17
; NO-SIMD128-NEXT:    i32.const $push21=, 10
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.sub $push20=, $11, $27
; NO-SIMD128-NEXT:    i32.store8 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push24=, 9
; NO-SIMD128-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-NEXT:    i32.sub $push23=, $10, $26
; NO-SIMD128-NEXT:    i32.store8 0($pop25), $pop23
; NO-SIMD128-NEXT:    i32.const $push27=, 7
; NO-SIMD128-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-NEXT:    i32.sub $push26=, $8, $24
; NO-SIMD128-NEXT:    i32.store8 0($pop28), $pop26
; NO-SIMD128-NEXT:    i32.const $push30=, 6
; NO-SIMD128-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-NEXT:    i32.sub $push29=, $7, $23
; NO-SIMD128-NEXT:    i32.store8 0($pop31), $pop29
; NO-SIMD128-NEXT:    i32.const $push33=, 5
; NO-SIMD128-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-NEXT:    i32.sub $push32=, $6, $22
; NO-SIMD128-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-NEXT:    i32.const $push36=, 3
; NO-SIMD128-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-NEXT:    i32.sub $push35=, $4, $20
; NO-SIMD128-NEXT:    i32.store8 0($pop37), $pop35
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sub_v16i8:
; NO-SIMD128-FAST:         .functype sub_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.sub $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.sub $push1=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.sub $push5=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.sub $push9=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop8), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.sub $push12=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop11), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.sub $push15=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop14), $pop15
; NO-SIMD128-FAST-NEXT:    i32.sub $push16=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.sub $push19=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop19
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-FAST-NEXT:    i32.sub $push22=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop21), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-FAST-NEXT:    i32.sub $push25=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop24), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.sub $push28=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop27), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-FAST-NEXT:    i32.sub $push31=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop30), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $0, $pop32
; NO-SIMD128-FAST-NEXT:    i32.sub $push34=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop33), $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-FAST-NEXT:    i32.sub $push37=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop36), $pop37
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <16 x i8> %x, %y
  ret <16 x i8> %a
}

define <16 x i8> @mul_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: mul_v16i8:
; SIMD128:         .functype mul_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.extract_lane_u $push4=, $0, 0
; SIMD128-NEXT:    i8x16.extract_lane_u $push3=, $1, 0
; SIMD128-NEXT:    i32.mul $push5=, $pop4, $pop3
; SIMD128-NEXT:    i8x16.splat $push6=, $pop5
; SIMD128-NEXT:    i8x16.extract_lane_u $push1=, $0, 1
; SIMD128-NEXT:    i8x16.extract_lane_u $push0=, $1, 1
; SIMD128-NEXT:    i32.mul $push2=, $pop1, $pop0
; SIMD128-NEXT:    i8x16.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    i8x16.extract_lane_u $push9=, $0, 2
; SIMD128-NEXT:    i8x16.extract_lane_u $push8=, $1, 2
; SIMD128-NEXT:    i32.mul $push10=, $pop9, $pop8
; SIMD128-NEXT:    i8x16.replace_lane $push11=, $pop7, 2, $pop10
; SIMD128-NEXT:    i8x16.extract_lane_u $push13=, $0, 3
; SIMD128-NEXT:    i8x16.extract_lane_u $push12=, $1, 3
; SIMD128-NEXT:    i32.mul $push14=, $pop13, $pop12
; SIMD128-NEXT:    i8x16.replace_lane $push15=, $pop11, 3, $pop14
; SIMD128-NEXT:    i8x16.extract_lane_u $push17=, $0, 4
; SIMD128-NEXT:    i8x16.extract_lane_u $push16=, $1, 4
; SIMD128-NEXT:    i32.mul $push18=, $pop17, $pop16
; SIMD128-NEXT:    i8x16.replace_lane $push19=, $pop15, 4, $pop18
; SIMD128-NEXT:    i8x16.extract_lane_u $push21=, $0, 5
; SIMD128-NEXT:    i8x16.extract_lane_u $push20=, $1, 5
; SIMD128-NEXT:    i32.mul $push22=, $pop21, $pop20
; SIMD128-NEXT:    i8x16.replace_lane $push23=, $pop19, 5, $pop22
; SIMD128-NEXT:    i8x16.extract_lane_u $push25=, $0, 6
; SIMD128-NEXT:    i8x16.extract_lane_u $push24=, $1, 6
; SIMD128-NEXT:    i32.mul $push26=, $pop25, $pop24
; SIMD128-NEXT:    i8x16.replace_lane $push27=, $pop23, 6, $pop26
; SIMD128-NEXT:    i8x16.extract_lane_u $push29=, $0, 7
; SIMD128-NEXT:    i8x16.extract_lane_u $push28=, $1, 7
; SIMD128-NEXT:    i32.mul $push30=, $pop29, $pop28
; SIMD128-NEXT:    i8x16.replace_lane $push31=, $pop27, 7, $pop30
; SIMD128-NEXT:    i8x16.extract_lane_u $push33=, $0, 8
; SIMD128-NEXT:    i8x16.extract_lane_u $push32=, $1, 8
; SIMD128-NEXT:    i32.mul $push34=, $pop33, $pop32
; SIMD128-NEXT:    i8x16.replace_lane $push35=, $pop31, 8, $pop34
; SIMD128-NEXT:    i8x16.extract_lane_u $push37=, $0, 9
; SIMD128-NEXT:    i8x16.extract_lane_u $push36=, $1, 9
; SIMD128-NEXT:    i32.mul $push38=, $pop37, $pop36
; SIMD128-NEXT:    i8x16.replace_lane $push39=, $pop35, 9, $pop38
; SIMD128-NEXT:    i8x16.extract_lane_u $push41=, $0, 10
; SIMD128-NEXT:    i8x16.extract_lane_u $push40=, $1, 10
; SIMD128-NEXT:    i32.mul $push42=, $pop41, $pop40
; SIMD128-NEXT:    i8x16.replace_lane $push43=, $pop39, 10, $pop42
; SIMD128-NEXT:    i8x16.extract_lane_u $push45=, $0, 11
; SIMD128-NEXT:    i8x16.extract_lane_u $push44=, $1, 11
; SIMD128-NEXT:    i32.mul $push46=, $pop45, $pop44
; SIMD128-NEXT:    i8x16.replace_lane $push47=, $pop43, 11, $pop46
; SIMD128-NEXT:    i8x16.extract_lane_u $push49=, $0, 12
; SIMD128-NEXT:    i8x16.extract_lane_u $push48=, $1, 12
; SIMD128-NEXT:    i32.mul $push50=, $pop49, $pop48
; SIMD128-NEXT:    i8x16.replace_lane $push51=, $pop47, 12, $pop50
; SIMD128-NEXT:    i8x16.extract_lane_u $push53=, $0, 13
; SIMD128-NEXT:    i8x16.extract_lane_u $push52=, $1, 13
; SIMD128-NEXT:    i32.mul $push54=, $pop53, $pop52
; SIMD128-NEXT:    i8x16.replace_lane $push55=, $pop51, 13, $pop54
; SIMD128-NEXT:    i8x16.extract_lane_u $push57=, $0, 14
; SIMD128-NEXT:    i8x16.extract_lane_u $push56=, $1, 14
; SIMD128-NEXT:    i32.mul $push58=, $pop57, $pop56
; SIMD128-NEXT:    i8x16.replace_lane $push59=, $pop55, 14, $pop58
; SIMD128-NEXT:    i8x16.extract_lane_u $push61=, $0, 15
; SIMD128-NEXT:    i8x16.extract_lane_u $push60=, $1, 15
; SIMD128-NEXT:    i32.mul $push62=, $pop61, $pop60
; SIMD128-NEXT:    i8x16.replace_lane $push63=, $pop59, 15, $pop62
; SIMD128-NEXT:    return $pop63
;
; SIMD128-FAST-LABEL: mul_v16i8:
; SIMD128-FAST:         .functype mul_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push5=, $0, 0
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push4=, $1, 0
; SIMD128-FAST-NEXT:    i32.mul $push6=, $pop5, $pop4
; SIMD128-FAST-NEXT:    i8x16.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push2=, $0, 1
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.mul $push3=, $pop2, $pop1
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push8=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push10=, $0, 2
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push9=, $1, 2
; SIMD128-FAST-NEXT:    i32.mul $push11=, $pop10, $pop9
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push12=, $pop8, 2, $pop11
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push14=, $0, 3
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push13=, $1, 3
; SIMD128-FAST-NEXT:    i32.mul $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push16=, $pop12, 3, $pop15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push18=, $0, 4
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push17=, $1, 4
; SIMD128-FAST-NEXT:    i32.mul $push19=, $pop18, $pop17
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push20=, $pop16, 4, $pop19
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push22=, $0, 5
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push21=, $1, 5
; SIMD128-FAST-NEXT:    i32.mul $push23=, $pop22, $pop21
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push24=, $pop20, 5, $pop23
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push26=, $0, 6
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push25=, $1, 6
; SIMD128-FAST-NEXT:    i32.mul $push27=, $pop26, $pop25
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push28=, $pop24, 6, $pop27
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push30=, $0, 7
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push29=, $1, 7
; SIMD128-FAST-NEXT:    i32.mul $push31=, $pop30, $pop29
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push32=, $pop28, 7, $pop31
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push34=, $0, 8
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push33=, $1, 8
; SIMD128-FAST-NEXT:    i32.mul $push35=, $pop34, $pop33
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push36=, $pop32, 8, $pop35
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push38=, $0, 9
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push37=, $1, 9
; SIMD128-FAST-NEXT:    i32.mul $push39=, $pop38, $pop37
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push40=, $pop36, 9, $pop39
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push42=, $0, 10
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push41=, $1, 10
; SIMD128-FAST-NEXT:    i32.mul $push43=, $pop42, $pop41
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push44=, $pop40, 10, $pop43
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push46=, $0, 11
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push45=, $1, 11
; SIMD128-FAST-NEXT:    i32.mul $push47=, $pop46, $pop45
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push48=, $pop44, 11, $pop47
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push50=, $0, 12
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push49=, $1, 12
; SIMD128-FAST-NEXT:    i32.mul $push51=, $pop50, $pop49
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push52=, $pop48, 12, $pop51
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push54=, $0, 13
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push53=, $1, 13
; SIMD128-FAST-NEXT:    i32.mul $push55=, $pop54, $pop53
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push56=, $pop52, 13, $pop55
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push58=, $0, 14
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push57=, $1, 14
; SIMD128-FAST-NEXT:    i32.mul $push59=, $pop58, $pop57
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push60=, $pop56, 14, $pop59
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push62=, $0, 15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push61=, $1, 15
; SIMD128-FAST-NEXT:    i32.mul $push63=, $pop62, $pop61
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push0=, $pop60, 15, $pop63
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: mul_v16i8:
; NO-SIMD128:         .functype mul_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.mul $push0=, $9, $25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop0
; NO-SIMD128-NEXT:    i32.mul $push1=, $5, $21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop1
; NO-SIMD128-NEXT:    i32.mul $push2=, $3, $19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-NEXT:    i32.mul $push3=, $2, $18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop3
; NO-SIMD128-NEXT:    i32.mul $push4=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push6=, 15
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.mul $push5=, $16, $32
; NO-SIMD128-NEXT:    i32.store8 0($pop7), $pop5
; NO-SIMD128-NEXT:    i32.const $push9=, 14
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    i32.mul $push8=, $15, $31
; NO-SIMD128-NEXT:    i32.store8 0($pop10), $pop8
; NO-SIMD128-NEXT:    i32.const $push12=, 13
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.mul $push11=, $14, $30
; NO-SIMD128-NEXT:    i32.store8 0($pop13), $pop11
; NO-SIMD128-NEXT:    i32.const $push15=, 12
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.mul $push14=, $13, $29
; NO-SIMD128-NEXT:    i32.store8 0($pop16), $pop14
; NO-SIMD128-NEXT:    i32.const $push18=, 11
; NO-SIMD128-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-NEXT:    i32.mul $push17=, $12, $28
; NO-SIMD128-NEXT:    i32.store8 0($pop19), $pop17
; NO-SIMD128-NEXT:    i32.const $push21=, 10
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.mul $push20=, $11, $27
; NO-SIMD128-NEXT:    i32.store8 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push24=, 9
; NO-SIMD128-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-NEXT:    i32.mul $push23=, $10, $26
; NO-SIMD128-NEXT:    i32.store8 0($pop25), $pop23
; NO-SIMD128-NEXT:    i32.const $push27=, 7
; NO-SIMD128-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-NEXT:    i32.mul $push26=, $8, $24
; NO-SIMD128-NEXT:    i32.store8 0($pop28), $pop26
; NO-SIMD128-NEXT:    i32.const $push30=, 6
; NO-SIMD128-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-NEXT:    i32.mul $push29=, $7, $23
; NO-SIMD128-NEXT:    i32.store8 0($pop31), $pop29
; NO-SIMD128-NEXT:    i32.const $push33=, 5
; NO-SIMD128-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-NEXT:    i32.mul $push32=, $6, $22
; NO-SIMD128-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-NEXT:    i32.const $push36=, 3
; NO-SIMD128-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-NEXT:    i32.mul $push35=, $4, $20
; NO-SIMD128-NEXT:    i32.store8 0($pop37), $pop35
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: mul_v16i8:
; NO-SIMD128-FAST:         .functype mul_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.mul $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.mul $push1=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.mul $push5=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    i32.mul $push6=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.mul $push9=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop8), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.mul $push12=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop11), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.mul $push15=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop14), $pop15
; NO-SIMD128-FAST-NEXT:    i32.mul $push16=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.mul $push19=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop19
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-FAST-NEXT:    i32.mul $push22=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop21), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-FAST-NEXT:    i32.mul $push25=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop24), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.mul $push28=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop27), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-FAST-NEXT:    i32.mul $push31=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop30), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $0, $pop32
; NO-SIMD128-FAST-NEXT:    i32.mul $push34=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop33), $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-FAST-NEXT:    i32.mul $push37=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop36), $pop37
; NO-SIMD128-FAST-NEXT:    return
  %a = mul <16 x i8> %x, %y
  ret <16 x i8> %a
}

define <16 x i8> @min_s_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: min_s_v16i8:
; SIMD128:         .functype min_s_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.min_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_s_v16i8:
; SIMD128-FAST:         .functype min_s_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.min_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_s_v16i8:
; NO-SIMD128:         .functype min_s_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push4=, 15
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.extend8_s $push1=, $16
; NO-SIMD128-NEXT:    i32.extend8_s $push0=, $32
; NO-SIMD128-NEXT:    i32.lt_s $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.select $push3=, $16, $32, $pop2
; NO-SIMD128-NEXT:    i32.store8 0($pop5), $pop3
; NO-SIMD128-NEXT:    i32.const $push10=, 14
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.extend8_s $push7=, $15
; NO-SIMD128-NEXT:    i32.extend8_s $push6=, $31
; NO-SIMD128-NEXT:    i32.lt_s $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.select $push9=, $15, $31, $pop8
; NO-SIMD128-NEXT:    i32.store8 0($pop11), $pop9
; NO-SIMD128-NEXT:    i32.const $push16=, 13
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.extend8_s $push13=, $14
; NO-SIMD128-NEXT:    i32.extend8_s $push12=, $30
; NO-SIMD128-NEXT:    i32.lt_s $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.select $push15=, $14, $30, $pop14
; NO-SIMD128-NEXT:    i32.store8 0($pop17), $pop15
; NO-SIMD128-NEXT:    i32.const $push22=, 12
; NO-SIMD128-NEXT:    i32.add $push23=, $0, $pop22
; NO-SIMD128-NEXT:    i32.extend8_s $push19=, $13
; NO-SIMD128-NEXT:    i32.extend8_s $push18=, $29
; NO-SIMD128-NEXT:    i32.lt_s $push20=, $pop19, $pop18
; NO-SIMD128-NEXT:    i32.select $push21=, $13, $29, $pop20
; NO-SIMD128-NEXT:    i32.store8 0($pop23), $pop21
; NO-SIMD128-NEXT:    i32.const $push28=, 11
; NO-SIMD128-NEXT:    i32.add $push29=, $0, $pop28
; NO-SIMD128-NEXT:    i32.extend8_s $push25=, $12
; NO-SIMD128-NEXT:    i32.extend8_s $push24=, $28
; NO-SIMD128-NEXT:    i32.lt_s $push26=, $pop25, $pop24
; NO-SIMD128-NEXT:    i32.select $push27=, $12, $28, $pop26
; NO-SIMD128-NEXT:    i32.store8 0($pop29), $pop27
; NO-SIMD128-NEXT:    i32.const $push34=, 10
; NO-SIMD128-NEXT:    i32.add $push35=, $0, $pop34
; NO-SIMD128-NEXT:    i32.extend8_s $push31=, $11
; NO-SIMD128-NEXT:    i32.extend8_s $push30=, $27
; NO-SIMD128-NEXT:    i32.lt_s $push32=, $pop31, $pop30
; NO-SIMD128-NEXT:    i32.select $push33=, $11, $27, $pop32
; NO-SIMD128-NEXT:    i32.store8 0($pop35), $pop33
; NO-SIMD128-NEXT:    i32.const $push40=, 9
; NO-SIMD128-NEXT:    i32.add $push41=, $0, $pop40
; NO-SIMD128-NEXT:    i32.extend8_s $push37=, $10
; NO-SIMD128-NEXT:    i32.extend8_s $push36=, $26
; NO-SIMD128-NEXT:    i32.lt_s $push38=, $pop37, $pop36
; NO-SIMD128-NEXT:    i32.select $push39=, $10, $26, $pop38
; NO-SIMD128-NEXT:    i32.store8 0($pop41), $pop39
; NO-SIMD128-NEXT:    i32.extend8_s $push43=, $9
; NO-SIMD128-NEXT:    i32.extend8_s $push42=, $25
; NO-SIMD128-NEXT:    i32.lt_s $push44=, $pop43, $pop42
; NO-SIMD128-NEXT:    i32.select $push45=, $9, $25, $pop44
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop45
; NO-SIMD128-NEXT:    i32.const $push50=, 7
; NO-SIMD128-NEXT:    i32.add $push51=, $0, $pop50
; NO-SIMD128-NEXT:    i32.extend8_s $push47=, $8
; NO-SIMD128-NEXT:    i32.extend8_s $push46=, $24
; NO-SIMD128-NEXT:    i32.lt_s $push48=, $pop47, $pop46
; NO-SIMD128-NEXT:    i32.select $push49=, $8, $24, $pop48
; NO-SIMD128-NEXT:    i32.store8 0($pop51), $pop49
; NO-SIMD128-NEXT:    i32.const $push56=, 6
; NO-SIMD128-NEXT:    i32.add $push57=, $0, $pop56
; NO-SIMD128-NEXT:    i32.extend8_s $push53=, $7
; NO-SIMD128-NEXT:    i32.extend8_s $push52=, $23
; NO-SIMD128-NEXT:    i32.lt_s $push54=, $pop53, $pop52
; NO-SIMD128-NEXT:    i32.select $push55=, $7, $23, $pop54
; NO-SIMD128-NEXT:    i32.store8 0($pop57), $pop55
; NO-SIMD128-NEXT:    i32.const $push62=, 5
; NO-SIMD128-NEXT:    i32.add $push63=, $0, $pop62
; NO-SIMD128-NEXT:    i32.extend8_s $push59=, $6
; NO-SIMD128-NEXT:    i32.extend8_s $push58=, $22
; NO-SIMD128-NEXT:    i32.lt_s $push60=, $pop59, $pop58
; NO-SIMD128-NEXT:    i32.select $push61=, $6, $22, $pop60
; NO-SIMD128-NEXT:    i32.store8 0($pop63), $pop61
; NO-SIMD128-NEXT:    i32.extend8_s $push65=, $5
; NO-SIMD128-NEXT:    i32.extend8_s $push64=, $21
; NO-SIMD128-NEXT:    i32.lt_s $push66=, $pop65, $pop64
; NO-SIMD128-NEXT:    i32.select $push67=, $5, $21, $pop66
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop67
; NO-SIMD128-NEXT:    i32.const $push72=, 3
; NO-SIMD128-NEXT:    i32.add $push73=, $0, $pop72
; NO-SIMD128-NEXT:    i32.extend8_s $push69=, $4
; NO-SIMD128-NEXT:    i32.extend8_s $push68=, $20
; NO-SIMD128-NEXT:    i32.lt_s $push70=, $pop69, $pop68
; NO-SIMD128-NEXT:    i32.select $push71=, $4, $20, $pop70
; NO-SIMD128-NEXT:    i32.store8 0($pop73), $pop71
; NO-SIMD128-NEXT:    i32.extend8_s $push75=, $3
; NO-SIMD128-NEXT:    i32.extend8_s $push74=, $19
; NO-SIMD128-NEXT:    i32.lt_s $push76=, $pop75, $pop74
; NO-SIMD128-NEXT:    i32.select $push77=, $3, $19, $pop76
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop77
; NO-SIMD128-NEXT:    i32.extend8_s $push79=, $2
; NO-SIMD128-NEXT:    i32.extend8_s $push78=, $18
; NO-SIMD128-NEXT:    i32.lt_s $push80=, $pop79, $pop78
; NO-SIMD128-NEXT:    i32.select $push81=, $2, $18, $pop80
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop81
; NO-SIMD128-NEXT:    i32.extend8_s $push83=, $1
; NO-SIMD128-NEXT:    i32.extend8_s $push82=, $17
; NO-SIMD128-NEXT:    i32.lt_s $push84=, $pop83, $pop82
; NO-SIMD128-NEXT:    i32.select $push85=, $1, $17, $pop84
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop85
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_s_v16i8:
; NO-SIMD128-FAST:         .functype min_s_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push0=, $17
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $1, $17, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push5=, $2
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push4=, $18
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $2, $18, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push9=, $3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push8=, $19
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push10=, $pop9, $pop8
; NO-SIMD128-FAST-NEXT:    i32.select $push11=, $3, $19, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push16=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push13=, $4
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push12=, $20
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.select $push15=, $4, $20, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop17), $pop15
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push19=, $5
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push18=, $21
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push20=, $pop19, $pop18
; NO-SIMD128-FAST-NEXT:    i32.select $push21=, $5, $21, $pop20
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push23=, $6
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push22=, $22
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push24=, $pop23, $pop22
; NO-SIMD128-FAST-NEXT:    i32.select $push25=, $6, $22, $pop24
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop27), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $0, $pop32
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push29=, $7
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push28=, $23
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.select $push31=, $7, $23, $pop30
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop33), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $0, $pop38
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push35=, $8
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push34=, $24
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push36=, $pop35, $pop34
; NO-SIMD128-FAST-NEXT:    i32.select $push37=, $8, $24, $pop36
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop39), $pop37
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push41=, $9
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push40=, $25
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push42=, $pop41, $pop40
; NO-SIMD128-FAST-NEXT:    i32.select $push43=, $9, $25, $pop42
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop43
; NO-SIMD128-FAST-NEXT:    i32.const $push48=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push49=, $0, $pop48
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push45=, $10
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push44=, $26
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push46=, $pop45, $pop44
; NO-SIMD128-FAST-NEXT:    i32.select $push47=, $10, $26, $pop46
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop49), $pop47
; NO-SIMD128-FAST-NEXT:    i32.const $push54=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push55=, $0, $pop54
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push51=, $11
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push50=, $27
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push52=, $pop51, $pop50
; NO-SIMD128-FAST-NEXT:    i32.select $push53=, $11, $27, $pop52
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop55), $pop53
; NO-SIMD128-FAST-NEXT:    i32.const $push60=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push61=, $0, $pop60
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push57=, $12
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push56=, $28
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push58=, $pop57, $pop56
; NO-SIMD128-FAST-NEXT:    i32.select $push59=, $12, $28, $pop58
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop61), $pop59
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push67=, $0, $pop66
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push63=, $13
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push62=, $29
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push64=, $pop63, $pop62
; NO-SIMD128-FAST-NEXT:    i32.select $push65=, $13, $29, $pop64
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop67), $pop65
; NO-SIMD128-FAST-NEXT:    i32.const $push72=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push73=, $0, $pop72
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push69=, $14
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push68=, $30
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push70=, $pop69, $pop68
; NO-SIMD128-FAST-NEXT:    i32.select $push71=, $14, $30, $pop70
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop73), $pop71
; NO-SIMD128-FAST-NEXT:    i32.const $push78=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push79=, $0, $pop78
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push75=, $15
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push74=, $31
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push76=, $pop75, $pop74
; NO-SIMD128-FAST-NEXT:    i32.select $push77=, $15, $31, $pop76
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop79), $pop77
; NO-SIMD128-FAST-NEXT:    i32.const $push84=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push85=, $0, $pop84
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push81=, $16
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push80=, $32
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push82=, $pop81, $pop80
; NO-SIMD128-FAST-NEXT:    i32.select $push83=, $16, $32, $pop82
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop85), $pop83
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp slt <16 x i8> %x, %y
  %a = select <16 x i1> %c, <16 x i8> %x, <16 x i8> %y
  ret <16 x i8> %a
}

define <16 x i8> @min_u_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: min_u_v16i8:
; SIMD128:         .functype min_u_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.min_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_u_v16i8:
; SIMD128-FAST:         .functype min_u_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.min_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_u_v16i8:
; NO-SIMD128:         .functype min_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push5=, 15
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push2=, $16, $pop0
; NO-SIMD128-NEXT:    i32.const $push117=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $32, $pop117
; NO-SIMD128-NEXT:    i32.lt_u $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.select $push4=, $16, $32, $pop3
; NO-SIMD128-NEXT:    i32.store8 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push11=, 14
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.const $push116=, 255
; NO-SIMD128-NEXT:    i32.and $push8=, $15, $pop116
; NO-SIMD128-NEXT:    i32.const $push115=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $31, $pop115
; NO-SIMD128-NEXT:    i32.lt_u $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.select $push10=, $15, $31, $pop9
; NO-SIMD128-NEXT:    i32.store8 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push17=, 13
; NO-SIMD128-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-NEXT:    i32.const $push114=, 255
; NO-SIMD128-NEXT:    i32.and $push14=, $14, $pop114
; NO-SIMD128-NEXT:    i32.const $push113=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $30, $pop113
; NO-SIMD128-NEXT:    i32.lt_u $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.select $push16=, $14, $30, $pop15
; NO-SIMD128-NEXT:    i32.store8 0($pop18), $pop16
; NO-SIMD128-NEXT:    i32.const $push23=, 12
; NO-SIMD128-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-NEXT:    i32.const $push112=, 255
; NO-SIMD128-NEXT:    i32.and $push20=, $13, $pop112
; NO-SIMD128-NEXT:    i32.const $push111=, 255
; NO-SIMD128-NEXT:    i32.and $push19=, $29, $pop111
; NO-SIMD128-NEXT:    i32.lt_u $push21=, $pop20, $pop19
; NO-SIMD128-NEXT:    i32.select $push22=, $13, $29, $pop21
; NO-SIMD128-NEXT:    i32.store8 0($pop24), $pop22
; NO-SIMD128-NEXT:    i32.const $push29=, 11
; NO-SIMD128-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-NEXT:    i32.const $push110=, 255
; NO-SIMD128-NEXT:    i32.and $push26=, $12, $pop110
; NO-SIMD128-NEXT:    i32.const $push109=, 255
; NO-SIMD128-NEXT:    i32.and $push25=, $28, $pop109
; NO-SIMD128-NEXT:    i32.lt_u $push27=, $pop26, $pop25
; NO-SIMD128-NEXT:    i32.select $push28=, $12, $28, $pop27
; NO-SIMD128-NEXT:    i32.store8 0($pop30), $pop28
; NO-SIMD128-NEXT:    i32.const $push35=, 10
; NO-SIMD128-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-NEXT:    i32.const $push108=, 255
; NO-SIMD128-NEXT:    i32.and $push32=, $11, $pop108
; NO-SIMD128-NEXT:    i32.const $push107=, 255
; NO-SIMD128-NEXT:    i32.and $push31=, $27, $pop107
; NO-SIMD128-NEXT:    i32.lt_u $push33=, $pop32, $pop31
; NO-SIMD128-NEXT:    i32.select $push34=, $11, $27, $pop33
; NO-SIMD128-NEXT:    i32.store8 0($pop36), $pop34
; NO-SIMD128-NEXT:    i32.const $push41=, 9
; NO-SIMD128-NEXT:    i32.add $push42=, $0, $pop41
; NO-SIMD128-NEXT:    i32.const $push106=, 255
; NO-SIMD128-NEXT:    i32.and $push38=, $10, $pop106
; NO-SIMD128-NEXT:    i32.const $push105=, 255
; NO-SIMD128-NEXT:    i32.and $push37=, $26, $pop105
; NO-SIMD128-NEXT:    i32.lt_u $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.select $push40=, $10, $26, $pop39
; NO-SIMD128-NEXT:    i32.store8 0($pop42), $pop40
; NO-SIMD128-NEXT:    i32.const $push104=, 255
; NO-SIMD128-NEXT:    i32.and $push44=, $9, $pop104
; NO-SIMD128-NEXT:    i32.const $push103=, 255
; NO-SIMD128-NEXT:    i32.and $push43=, $25, $pop103
; NO-SIMD128-NEXT:    i32.lt_u $push45=, $pop44, $pop43
; NO-SIMD128-NEXT:    i32.select $push46=, $9, $25, $pop45
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop46
; NO-SIMD128-NEXT:    i32.const $push51=, 7
; NO-SIMD128-NEXT:    i32.add $push52=, $0, $pop51
; NO-SIMD128-NEXT:    i32.const $push102=, 255
; NO-SIMD128-NEXT:    i32.and $push48=, $8, $pop102
; NO-SIMD128-NEXT:    i32.const $push101=, 255
; NO-SIMD128-NEXT:    i32.and $push47=, $24, $pop101
; NO-SIMD128-NEXT:    i32.lt_u $push49=, $pop48, $pop47
; NO-SIMD128-NEXT:    i32.select $push50=, $8, $24, $pop49
; NO-SIMD128-NEXT:    i32.store8 0($pop52), $pop50
; NO-SIMD128-NEXT:    i32.const $push57=, 6
; NO-SIMD128-NEXT:    i32.add $push58=, $0, $pop57
; NO-SIMD128-NEXT:    i32.const $push100=, 255
; NO-SIMD128-NEXT:    i32.and $push54=, $7, $pop100
; NO-SIMD128-NEXT:    i32.const $push99=, 255
; NO-SIMD128-NEXT:    i32.and $push53=, $23, $pop99
; NO-SIMD128-NEXT:    i32.lt_u $push55=, $pop54, $pop53
; NO-SIMD128-NEXT:    i32.select $push56=, $7, $23, $pop55
; NO-SIMD128-NEXT:    i32.store8 0($pop58), $pop56
; NO-SIMD128-NEXT:    i32.const $push63=, 5
; NO-SIMD128-NEXT:    i32.add $push64=, $0, $pop63
; NO-SIMD128-NEXT:    i32.const $push98=, 255
; NO-SIMD128-NEXT:    i32.and $push60=, $6, $pop98
; NO-SIMD128-NEXT:    i32.const $push97=, 255
; NO-SIMD128-NEXT:    i32.and $push59=, $22, $pop97
; NO-SIMD128-NEXT:    i32.lt_u $push61=, $pop60, $pop59
; NO-SIMD128-NEXT:    i32.select $push62=, $6, $22, $pop61
; NO-SIMD128-NEXT:    i32.store8 0($pop64), $pop62
; NO-SIMD128-NEXT:    i32.const $push96=, 255
; NO-SIMD128-NEXT:    i32.and $push66=, $5, $pop96
; NO-SIMD128-NEXT:    i32.const $push95=, 255
; NO-SIMD128-NEXT:    i32.and $push65=, $21, $pop95
; NO-SIMD128-NEXT:    i32.lt_u $push67=, $pop66, $pop65
; NO-SIMD128-NEXT:    i32.select $push68=, $5, $21, $pop67
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop68
; NO-SIMD128-NEXT:    i32.const $push73=, 3
; NO-SIMD128-NEXT:    i32.add $push74=, $0, $pop73
; NO-SIMD128-NEXT:    i32.const $push94=, 255
; NO-SIMD128-NEXT:    i32.and $push70=, $4, $pop94
; NO-SIMD128-NEXT:    i32.const $push93=, 255
; NO-SIMD128-NEXT:    i32.and $push69=, $20, $pop93
; NO-SIMD128-NEXT:    i32.lt_u $push71=, $pop70, $pop69
; NO-SIMD128-NEXT:    i32.select $push72=, $4, $20, $pop71
; NO-SIMD128-NEXT:    i32.store8 0($pop74), $pop72
; NO-SIMD128-NEXT:    i32.const $push92=, 255
; NO-SIMD128-NEXT:    i32.and $push76=, $3, $pop92
; NO-SIMD128-NEXT:    i32.const $push91=, 255
; NO-SIMD128-NEXT:    i32.and $push75=, $19, $pop91
; NO-SIMD128-NEXT:    i32.lt_u $push77=, $pop76, $pop75
; NO-SIMD128-NEXT:    i32.select $push78=, $3, $19, $pop77
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop78
; NO-SIMD128-NEXT:    i32.const $push90=, 255
; NO-SIMD128-NEXT:    i32.and $push80=, $2, $pop90
; NO-SIMD128-NEXT:    i32.const $push89=, 255
; NO-SIMD128-NEXT:    i32.and $push79=, $18, $pop89
; NO-SIMD128-NEXT:    i32.lt_u $push81=, $pop80, $pop79
; NO-SIMD128-NEXT:    i32.select $push82=, $2, $18, $pop81
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop82
; NO-SIMD128-NEXT:    i32.const $push88=, 255
; NO-SIMD128-NEXT:    i32.and $push84=, $1, $pop88
; NO-SIMD128-NEXT:    i32.const $push87=, 255
; NO-SIMD128-NEXT:    i32.and $push83=, $17, $pop87
; NO-SIMD128-NEXT:    i32.lt_u $push85=, $pop84, $pop83
; NO-SIMD128-NEXT:    i32.select $push86=, $1, $17, $pop85
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop86
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_u_v16i8:
; NO-SIMD128-FAST:         .functype min_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push117=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $17, $pop117
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.select $push4=, $1, $17, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push116=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $2, $pop116
; NO-SIMD128-FAST-NEXT:    i32.const $push115=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $18, $pop115
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.select $push8=, $2, $18, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push114=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $3, $pop114
; NO-SIMD128-FAST-NEXT:    i32.const $push113=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $19, $pop113
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.select $push12=, $3, $19, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push112=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $4, $pop112
; NO-SIMD128-FAST-NEXT:    i32.const $push111=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $20, $pop111
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.select $push16=, $4, $20, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push110=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $5, $pop110
; NO-SIMD128-FAST-NEXT:    i32.const $push109=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $21, $pop109
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.select $push22=, $5, $21, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push108=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $6, $pop108
; NO-SIMD128-FAST-NEXT:    i32.const $push107=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $22, $pop107
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push25=, $pop24, $pop23
; NO-SIMD128-FAST-NEXT:    i32.select $push26=, $6, $22, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop28), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-FAST-NEXT:    i32.const $push106=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $7, $pop106
; NO-SIMD128-FAST-NEXT:    i32.const $push105=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $23, $pop105
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.select $push32=, $7, $23, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-FAST-NEXT:    i32.const $push104=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push36=, $8, $pop104
; NO-SIMD128-FAST-NEXT:    i32.const $push103=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push35=, $24, $pop103
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push37=, $pop36, $pop35
; NO-SIMD128-FAST-NEXT:    i32.select $push38=, $8, $24, $pop37
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop40), $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push102=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push42=, $9, $pop102
; NO-SIMD128-FAST-NEXT:    i32.const $push101=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push41=, $25, $pop101
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push43=, $pop42, $pop41
; NO-SIMD128-FAST-NEXT:    i32.select $push44=, $9, $25, $pop43
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push50=, $0, $pop49
; NO-SIMD128-FAST-NEXT:    i32.const $push100=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push46=, $10, $pop100
; NO-SIMD128-FAST-NEXT:    i32.const $push99=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push45=, $26, $pop99
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push47=, $pop46, $pop45
; NO-SIMD128-FAST-NEXT:    i32.select $push48=, $10, $26, $pop47
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop50), $pop48
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push56=, $0, $pop55
; NO-SIMD128-FAST-NEXT:    i32.const $push98=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push52=, $11, $pop98
; NO-SIMD128-FAST-NEXT:    i32.const $push97=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push51=, $27, $pop97
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push53=, $pop52, $pop51
; NO-SIMD128-FAST-NEXT:    i32.select $push54=, $11, $27, $pop53
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop56), $pop54
; NO-SIMD128-FAST-NEXT:    i32.const $push61=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push62=, $0, $pop61
; NO-SIMD128-FAST-NEXT:    i32.const $push96=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push58=, $12, $pop96
; NO-SIMD128-FAST-NEXT:    i32.const $push95=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push57=, $28, $pop95
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push59=, $pop58, $pop57
; NO-SIMD128-FAST-NEXT:    i32.select $push60=, $12, $28, $pop59
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop62), $pop60
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push68=, $0, $pop67
; NO-SIMD128-FAST-NEXT:    i32.const $push94=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push64=, $13, $pop94
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push63=, $29, $pop93
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push65=, $pop64, $pop63
; NO-SIMD128-FAST-NEXT:    i32.select $push66=, $13, $29, $pop65
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop68), $pop66
; NO-SIMD128-FAST-NEXT:    i32.const $push73=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push74=, $0, $pop73
; NO-SIMD128-FAST-NEXT:    i32.const $push92=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push70=, $14, $pop92
; NO-SIMD128-FAST-NEXT:    i32.const $push91=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push69=, $30, $pop91
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push71=, $pop70, $pop69
; NO-SIMD128-FAST-NEXT:    i32.select $push72=, $14, $30, $pop71
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop74), $pop72
; NO-SIMD128-FAST-NEXT:    i32.const $push79=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push80=, $0, $pop79
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push76=, $15, $pop90
; NO-SIMD128-FAST-NEXT:    i32.const $push89=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push75=, $31, $pop89
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push77=, $pop76, $pop75
; NO-SIMD128-FAST-NEXT:    i32.select $push78=, $15, $31, $pop77
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop80), $pop78
; NO-SIMD128-FAST-NEXT:    i32.const $push85=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push86=, $0, $pop85
; NO-SIMD128-FAST-NEXT:    i32.const $push88=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push82=, $16, $pop88
; NO-SIMD128-FAST-NEXT:    i32.const $push87=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push81=, $32, $pop87
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push83=, $pop82, $pop81
; NO-SIMD128-FAST-NEXT:    i32.select $push84=, $16, $32, $pop83
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop86), $pop84
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp ult <16 x i8> %x, %y
  %a = select <16 x i1> %c, <16 x i8> %x, <16 x i8> %y
  ret <16 x i8> %a
}

define <16 x i8> @max_s_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: max_s_v16i8:
; SIMD128:         .functype max_s_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.max_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_s_v16i8:
; SIMD128-FAST:         .functype max_s_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.max_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_s_v16i8:
; NO-SIMD128:         .functype max_s_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push4=, 15
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.extend8_s $push1=, $16
; NO-SIMD128-NEXT:    i32.extend8_s $push0=, $32
; NO-SIMD128-NEXT:    i32.gt_s $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.select $push3=, $16, $32, $pop2
; NO-SIMD128-NEXT:    i32.store8 0($pop5), $pop3
; NO-SIMD128-NEXT:    i32.const $push10=, 14
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.extend8_s $push7=, $15
; NO-SIMD128-NEXT:    i32.extend8_s $push6=, $31
; NO-SIMD128-NEXT:    i32.gt_s $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.select $push9=, $15, $31, $pop8
; NO-SIMD128-NEXT:    i32.store8 0($pop11), $pop9
; NO-SIMD128-NEXT:    i32.const $push16=, 13
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.extend8_s $push13=, $14
; NO-SIMD128-NEXT:    i32.extend8_s $push12=, $30
; NO-SIMD128-NEXT:    i32.gt_s $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.select $push15=, $14, $30, $pop14
; NO-SIMD128-NEXT:    i32.store8 0($pop17), $pop15
; NO-SIMD128-NEXT:    i32.const $push22=, 12
; NO-SIMD128-NEXT:    i32.add $push23=, $0, $pop22
; NO-SIMD128-NEXT:    i32.extend8_s $push19=, $13
; NO-SIMD128-NEXT:    i32.extend8_s $push18=, $29
; NO-SIMD128-NEXT:    i32.gt_s $push20=, $pop19, $pop18
; NO-SIMD128-NEXT:    i32.select $push21=, $13, $29, $pop20
; NO-SIMD128-NEXT:    i32.store8 0($pop23), $pop21
; NO-SIMD128-NEXT:    i32.const $push28=, 11
; NO-SIMD128-NEXT:    i32.add $push29=, $0, $pop28
; NO-SIMD128-NEXT:    i32.extend8_s $push25=, $12
; NO-SIMD128-NEXT:    i32.extend8_s $push24=, $28
; NO-SIMD128-NEXT:    i32.gt_s $push26=, $pop25, $pop24
; NO-SIMD128-NEXT:    i32.select $push27=, $12, $28, $pop26
; NO-SIMD128-NEXT:    i32.store8 0($pop29), $pop27
; NO-SIMD128-NEXT:    i32.const $push34=, 10
; NO-SIMD128-NEXT:    i32.add $push35=, $0, $pop34
; NO-SIMD128-NEXT:    i32.extend8_s $push31=, $11
; NO-SIMD128-NEXT:    i32.extend8_s $push30=, $27
; NO-SIMD128-NEXT:    i32.gt_s $push32=, $pop31, $pop30
; NO-SIMD128-NEXT:    i32.select $push33=, $11, $27, $pop32
; NO-SIMD128-NEXT:    i32.store8 0($pop35), $pop33
; NO-SIMD128-NEXT:    i32.const $push40=, 9
; NO-SIMD128-NEXT:    i32.add $push41=, $0, $pop40
; NO-SIMD128-NEXT:    i32.extend8_s $push37=, $10
; NO-SIMD128-NEXT:    i32.extend8_s $push36=, $26
; NO-SIMD128-NEXT:    i32.gt_s $push38=, $pop37, $pop36
; NO-SIMD128-NEXT:    i32.select $push39=, $10, $26, $pop38
; NO-SIMD128-NEXT:    i32.store8 0($pop41), $pop39
; NO-SIMD128-NEXT:    i32.extend8_s $push43=, $9
; NO-SIMD128-NEXT:    i32.extend8_s $push42=, $25
; NO-SIMD128-NEXT:    i32.gt_s $push44=, $pop43, $pop42
; NO-SIMD128-NEXT:    i32.select $push45=, $9, $25, $pop44
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop45
; NO-SIMD128-NEXT:    i32.const $push50=, 7
; NO-SIMD128-NEXT:    i32.add $push51=, $0, $pop50
; NO-SIMD128-NEXT:    i32.extend8_s $push47=, $8
; NO-SIMD128-NEXT:    i32.extend8_s $push46=, $24
; NO-SIMD128-NEXT:    i32.gt_s $push48=, $pop47, $pop46
; NO-SIMD128-NEXT:    i32.select $push49=, $8, $24, $pop48
; NO-SIMD128-NEXT:    i32.store8 0($pop51), $pop49
; NO-SIMD128-NEXT:    i32.const $push56=, 6
; NO-SIMD128-NEXT:    i32.add $push57=, $0, $pop56
; NO-SIMD128-NEXT:    i32.extend8_s $push53=, $7
; NO-SIMD128-NEXT:    i32.extend8_s $push52=, $23
; NO-SIMD128-NEXT:    i32.gt_s $push54=, $pop53, $pop52
; NO-SIMD128-NEXT:    i32.select $push55=, $7, $23, $pop54
; NO-SIMD128-NEXT:    i32.store8 0($pop57), $pop55
; NO-SIMD128-NEXT:    i32.const $push62=, 5
; NO-SIMD128-NEXT:    i32.add $push63=, $0, $pop62
; NO-SIMD128-NEXT:    i32.extend8_s $push59=, $6
; NO-SIMD128-NEXT:    i32.extend8_s $push58=, $22
; NO-SIMD128-NEXT:    i32.gt_s $push60=, $pop59, $pop58
; NO-SIMD128-NEXT:    i32.select $push61=, $6, $22, $pop60
; NO-SIMD128-NEXT:    i32.store8 0($pop63), $pop61
; NO-SIMD128-NEXT:    i32.extend8_s $push65=, $5
; NO-SIMD128-NEXT:    i32.extend8_s $push64=, $21
; NO-SIMD128-NEXT:    i32.gt_s $push66=, $pop65, $pop64
; NO-SIMD128-NEXT:    i32.select $push67=, $5, $21, $pop66
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop67
; NO-SIMD128-NEXT:    i32.const $push72=, 3
; NO-SIMD128-NEXT:    i32.add $push73=, $0, $pop72
; NO-SIMD128-NEXT:    i32.extend8_s $push69=, $4
; NO-SIMD128-NEXT:    i32.extend8_s $push68=, $20
; NO-SIMD128-NEXT:    i32.gt_s $push70=, $pop69, $pop68
; NO-SIMD128-NEXT:    i32.select $push71=, $4, $20, $pop70
; NO-SIMD128-NEXT:    i32.store8 0($pop73), $pop71
; NO-SIMD128-NEXT:    i32.extend8_s $push75=, $3
; NO-SIMD128-NEXT:    i32.extend8_s $push74=, $19
; NO-SIMD128-NEXT:    i32.gt_s $push76=, $pop75, $pop74
; NO-SIMD128-NEXT:    i32.select $push77=, $3, $19, $pop76
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop77
; NO-SIMD128-NEXT:    i32.extend8_s $push79=, $2
; NO-SIMD128-NEXT:    i32.extend8_s $push78=, $18
; NO-SIMD128-NEXT:    i32.gt_s $push80=, $pop79, $pop78
; NO-SIMD128-NEXT:    i32.select $push81=, $2, $18, $pop80
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop81
; NO-SIMD128-NEXT:    i32.extend8_s $push83=, $1
; NO-SIMD128-NEXT:    i32.extend8_s $push82=, $17
; NO-SIMD128-NEXT:    i32.gt_s $push84=, $pop83, $pop82
; NO-SIMD128-NEXT:    i32.select $push85=, $1, $17, $pop84
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop85
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_s_v16i8:
; NO-SIMD128-FAST:         .functype max_s_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push0=, $17
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $1, $17, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push5=, $2
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push4=, $18
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $2, $18, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push9=, $3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push8=, $19
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push10=, $pop9, $pop8
; NO-SIMD128-FAST-NEXT:    i32.select $push11=, $3, $19, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push16=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push13=, $4
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push12=, $20
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.select $push15=, $4, $20, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop17), $pop15
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push19=, $5
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push18=, $21
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push20=, $pop19, $pop18
; NO-SIMD128-FAST-NEXT:    i32.select $push21=, $5, $21, $pop20
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push23=, $6
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push22=, $22
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push24=, $pop23, $pop22
; NO-SIMD128-FAST-NEXT:    i32.select $push25=, $6, $22, $pop24
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop27), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $0, $pop32
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push29=, $7
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push28=, $23
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.select $push31=, $7, $23, $pop30
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop33), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $0, $pop38
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push35=, $8
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push34=, $24
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push36=, $pop35, $pop34
; NO-SIMD128-FAST-NEXT:    i32.select $push37=, $8, $24, $pop36
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop39), $pop37
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push41=, $9
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push40=, $25
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push42=, $pop41, $pop40
; NO-SIMD128-FAST-NEXT:    i32.select $push43=, $9, $25, $pop42
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop43
; NO-SIMD128-FAST-NEXT:    i32.const $push48=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push49=, $0, $pop48
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push45=, $10
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push44=, $26
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push46=, $pop45, $pop44
; NO-SIMD128-FAST-NEXT:    i32.select $push47=, $10, $26, $pop46
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop49), $pop47
; NO-SIMD128-FAST-NEXT:    i32.const $push54=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push55=, $0, $pop54
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push51=, $11
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push50=, $27
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push52=, $pop51, $pop50
; NO-SIMD128-FAST-NEXT:    i32.select $push53=, $11, $27, $pop52
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop55), $pop53
; NO-SIMD128-FAST-NEXT:    i32.const $push60=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push61=, $0, $pop60
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push57=, $12
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push56=, $28
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push58=, $pop57, $pop56
; NO-SIMD128-FAST-NEXT:    i32.select $push59=, $12, $28, $pop58
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop61), $pop59
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push67=, $0, $pop66
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push63=, $13
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push62=, $29
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push64=, $pop63, $pop62
; NO-SIMD128-FAST-NEXT:    i32.select $push65=, $13, $29, $pop64
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop67), $pop65
; NO-SIMD128-FAST-NEXT:    i32.const $push72=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push73=, $0, $pop72
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push69=, $14
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push68=, $30
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push70=, $pop69, $pop68
; NO-SIMD128-FAST-NEXT:    i32.select $push71=, $14, $30, $pop70
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop73), $pop71
; NO-SIMD128-FAST-NEXT:    i32.const $push78=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push79=, $0, $pop78
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push75=, $15
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push74=, $31
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push76=, $pop75, $pop74
; NO-SIMD128-FAST-NEXT:    i32.select $push77=, $15, $31, $pop76
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop79), $pop77
; NO-SIMD128-FAST-NEXT:    i32.const $push84=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push85=, $0, $pop84
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push81=, $16
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push80=, $32
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push82=, $pop81, $pop80
; NO-SIMD128-FAST-NEXT:    i32.select $push83=, $16, $32, $pop82
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop85), $pop83
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp sgt <16 x i8> %x, %y
  %a = select <16 x i1> %c, <16 x i8> %x, <16 x i8> %y
  ret <16 x i8> %a
}

define <16 x i8> @max_u_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: max_u_v16i8:
; SIMD128:         .functype max_u_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.max_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_u_v16i8:
; SIMD128-FAST:         .functype max_u_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.max_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_u_v16i8:
; NO-SIMD128:         .functype max_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push5=, 15
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push2=, $16, $pop0
; NO-SIMD128-NEXT:    i32.const $push117=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $32, $pop117
; NO-SIMD128-NEXT:    i32.gt_u $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.select $push4=, $16, $32, $pop3
; NO-SIMD128-NEXT:    i32.store8 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push11=, 14
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.const $push116=, 255
; NO-SIMD128-NEXT:    i32.and $push8=, $15, $pop116
; NO-SIMD128-NEXT:    i32.const $push115=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $31, $pop115
; NO-SIMD128-NEXT:    i32.gt_u $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.select $push10=, $15, $31, $pop9
; NO-SIMD128-NEXT:    i32.store8 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push17=, 13
; NO-SIMD128-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-NEXT:    i32.const $push114=, 255
; NO-SIMD128-NEXT:    i32.and $push14=, $14, $pop114
; NO-SIMD128-NEXT:    i32.const $push113=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $30, $pop113
; NO-SIMD128-NEXT:    i32.gt_u $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.select $push16=, $14, $30, $pop15
; NO-SIMD128-NEXT:    i32.store8 0($pop18), $pop16
; NO-SIMD128-NEXT:    i32.const $push23=, 12
; NO-SIMD128-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-NEXT:    i32.const $push112=, 255
; NO-SIMD128-NEXT:    i32.and $push20=, $13, $pop112
; NO-SIMD128-NEXT:    i32.const $push111=, 255
; NO-SIMD128-NEXT:    i32.and $push19=, $29, $pop111
; NO-SIMD128-NEXT:    i32.gt_u $push21=, $pop20, $pop19
; NO-SIMD128-NEXT:    i32.select $push22=, $13, $29, $pop21
; NO-SIMD128-NEXT:    i32.store8 0($pop24), $pop22
; NO-SIMD128-NEXT:    i32.const $push29=, 11
; NO-SIMD128-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-NEXT:    i32.const $push110=, 255
; NO-SIMD128-NEXT:    i32.and $push26=, $12, $pop110
; NO-SIMD128-NEXT:    i32.const $push109=, 255
; NO-SIMD128-NEXT:    i32.and $push25=, $28, $pop109
; NO-SIMD128-NEXT:    i32.gt_u $push27=, $pop26, $pop25
; NO-SIMD128-NEXT:    i32.select $push28=, $12, $28, $pop27
; NO-SIMD128-NEXT:    i32.store8 0($pop30), $pop28
; NO-SIMD128-NEXT:    i32.const $push35=, 10
; NO-SIMD128-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-NEXT:    i32.const $push108=, 255
; NO-SIMD128-NEXT:    i32.and $push32=, $11, $pop108
; NO-SIMD128-NEXT:    i32.const $push107=, 255
; NO-SIMD128-NEXT:    i32.and $push31=, $27, $pop107
; NO-SIMD128-NEXT:    i32.gt_u $push33=, $pop32, $pop31
; NO-SIMD128-NEXT:    i32.select $push34=, $11, $27, $pop33
; NO-SIMD128-NEXT:    i32.store8 0($pop36), $pop34
; NO-SIMD128-NEXT:    i32.const $push41=, 9
; NO-SIMD128-NEXT:    i32.add $push42=, $0, $pop41
; NO-SIMD128-NEXT:    i32.const $push106=, 255
; NO-SIMD128-NEXT:    i32.and $push38=, $10, $pop106
; NO-SIMD128-NEXT:    i32.const $push105=, 255
; NO-SIMD128-NEXT:    i32.and $push37=, $26, $pop105
; NO-SIMD128-NEXT:    i32.gt_u $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.select $push40=, $10, $26, $pop39
; NO-SIMD128-NEXT:    i32.store8 0($pop42), $pop40
; NO-SIMD128-NEXT:    i32.const $push104=, 255
; NO-SIMD128-NEXT:    i32.and $push44=, $9, $pop104
; NO-SIMD128-NEXT:    i32.const $push103=, 255
; NO-SIMD128-NEXT:    i32.and $push43=, $25, $pop103
; NO-SIMD128-NEXT:    i32.gt_u $push45=, $pop44, $pop43
; NO-SIMD128-NEXT:    i32.select $push46=, $9, $25, $pop45
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop46
; NO-SIMD128-NEXT:    i32.const $push51=, 7
; NO-SIMD128-NEXT:    i32.add $push52=, $0, $pop51
; NO-SIMD128-NEXT:    i32.const $push102=, 255
; NO-SIMD128-NEXT:    i32.and $push48=, $8, $pop102
; NO-SIMD128-NEXT:    i32.const $push101=, 255
; NO-SIMD128-NEXT:    i32.and $push47=, $24, $pop101
; NO-SIMD128-NEXT:    i32.gt_u $push49=, $pop48, $pop47
; NO-SIMD128-NEXT:    i32.select $push50=, $8, $24, $pop49
; NO-SIMD128-NEXT:    i32.store8 0($pop52), $pop50
; NO-SIMD128-NEXT:    i32.const $push57=, 6
; NO-SIMD128-NEXT:    i32.add $push58=, $0, $pop57
; NO-SIMD128-NEXT:    i32.const $push100=, 255
; NO-SIMD128-NEXT:    i32.and $push54=, $7, $pop100
; NO-SIMD128-NEXT:    i32.const $push99=, 255
; NO-SIMD128-NEXT:    i32.and $push53=, $23, $pop99
; NO-SIMD128-NEXT:    i32.gt_u $push55=, $pop54, $pop53
; NO-SIMD128-NEXT:    i32.select $push56=, $7, $23, $pop55
; NO-SIMD128-NEXT:    i32.store8 0($pop58), $pop56
; NO-SIMD128-NEXT:    i32.const $push63=, 5
; NO-SIMD128-NEXT:    i32.add $push64=, $0, $pop63
; NO-SIMD128-NEXT:    i32.const $push98=, 255
; NO-SIMD128-NEXT:    i32.and $push60=, $6, $pop98
; NO-SIMD128-NEXT:    i32.const $push97=, 255
; NO-SIMD128-NEXT:    i32.and $push59=, $22, $pop97
; NO-SIMD128-NEXT:    i32.gt_u $push61=, $pop60, $pop59
; NO-SIMD128-NEXT:    i32.select $push62=, $6, $22, $pop61
; NO-SIMD128-NEXT:    i32.store8 0($pop64), $pop62
; NO-SIMD128-NEXT:    i32.const $push96=, 255
; NO-SIMD128-NEXT:    i32.and $push66=, $5, $pop96
; NO-SIMD128-NEXT:    i32.const $push95=, 255
; NO-SIMD128-NEXT:    i32.and $push65=, $21, $pop95
; NO-SIMD128-NEXT:    i32.gt_u $push67=, $pop66, $pop65
; NO-SIMD128-NEXT:    i32.select $push68=, $5, $21, $pop67
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop68
; NO-SIMD128-NEXT:    i32.const $push73=, 3
; NO-SIMD128-NEXT:    i32.add $push74=, $0, $pop73
; NO-SIMD128-NEXT:    i32.const $push94=, 255
; NO-SIMD128-NEXT:    i32.and $push70=, $4, $pop94
; NO-SIMD128-NEXT:    i32.const $push93=, 255
; NO-SIMD128-NEXT:    i32.and $push69=, $20, $pop93
; NO-SIMD128-NEXT:    i32.gt_u $push71=, $pop70, $pop69
; NO-SIMD128-NEXT:    i32.select $push72=, $4, $20, $pop71
; NO-SIMD128-NEXT:    i32.store8 0($pop74), $pop72
; NO-SIMD128-NEXT:    i32.const $push92=, 255
; NO-SIMD128-NEXT:    i32.and $push76=, $3, $pop92
; NO-SIMD128-NEXT:    i32.const $push91=, 255
; NO-SIMD128-NEXT:    i32.and $push75=, $19, $pop91
; NO-SIMD128-NEXT:    i32.gt_u $push77=, $pop76, $pop75
; NO-SIMD128-NEXT:    i32.select $push78=, $3, $19, $pop77
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop78
; NO-SIMD128-NEXT:    i32.const $push90=, 255
; NO-SIMD128-NEXT:    i32.and $push80=, $2, $pop90
; NO-SIMD128-NEXT:    i32.const $push89=, 255
; NO-SIMD128-NEXT:    i32.and $push79=, $18, $pop89
; NO-SIMD128-NEXT:    i32.gt_u $push81=, $pop80, $pop79
; NO-SIMD128-NEXT:    i32.select $push82=, $2, $18, $pop81
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop82
; NO-SIMD128-NEXT:    i32.const $push88=, 255
; NO-SIMD128-NEXT:    i32.and $push84=, $1, $pop88
; NO-SIMD128-NEXT:    i32.const $push87=, 255
; NO-SIMD128-NEXT:    i32.and $push83=, $17, $pop87
; NO-SIMD128-NEXT:    i32.gt_u $push85=, $pop84, $pop83
; NO-SIMD128-NEXT:    i32.select $push86=, $1, $17, $pop85
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop86
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_u_v16i8:
; NO-SIMD128-FAST:         .functype max_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push117=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $17, $pop117
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.select $push4=, $1, $17, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push116=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $2, $pop116
; NO-SIMD128-FAST-NEXT:    i32.const $push115=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $18, $pop115
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.select $push8=, $2, $18, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push114=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $3, $pop114
; NO-SIMD128-FAST-NEXT:    i32.const $push113=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $19, $pop113
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.select $push12=, $3, $19, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push112=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $4, $pop112
; NO-SIMD128-FAST-NEXT:    i32.const $push111=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $20, $pop111
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.select $push16=, $4, $20, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push110=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $5, $pop110
; NO-SIMD128-FAST-NEXT:    i32.const $push109=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $21, $pop109
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.select $push22=, $5, $21, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push108=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $6, $pop108
; NO-SIMD128-FAST-NEXT:    i32.const $push107=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $22, $pop107
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push25=, $pop24, $pop23
; NO-SIMD128-FAST-NEXT:    i32.select $push26=, $6, $22, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop28), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-FAST-NEXT:    i32.const $push106=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $7, $pop106
; NO-SIMD128-FAST-NEXT:    i32.const $push105=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $23, $pop105
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.select $push32=, $7, $23, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-FAST-NEXT:    i32.const $push104=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push36=, $8, $pop104
; NO-SIMD128-FAST-NEXT:    i32.const $push103=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push35=, $24, $pop103
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push37=, $pop36, $pop35
; NO-SIMD128-FAST-NEXT:    i32.select $push38=, $8, $24, $pop37
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop40), $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push102=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push42=, $9, $pop102
; NO-SIMD128-FAST-NEXT:    i32.const $push101=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push41=, $25, $pop101
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push43=, $pop42, $pop41
; NO-SIMD128-FAST-NEXT:    i32.select $push44=, $9, $25, $pop43
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push50=, $0, $pop49
; NO-SIMD128-FAST-NEXT:    i32.const $push100=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push46=, $10, $pop100
; NO-SIMD128-FAST-NEXT:    i32.const $push99=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push45=, $26, $pop99
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push47=, $pop46, $pop45
; NO-SIMD128-FAST-NEXT:    i32.select $push48=, $10, $26, $pop47
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop50), $pop48
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push56=, $0, $pop55
; NO-SIMD128-FAST-NEXT:    i32.const $push98=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push52=, $11, $pop98
; NO-SIMD128-FAST-NEXT:    i32.const $push97=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push51=, $27, $pop97
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push53=, $pop52, $pop51
; NO-SIMD128-FAST-NEXT:    i32.select $push54=, $11, $27, $pop53
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop56), $pop54
; NO-SIMD128-FAST-NEXT:    i32.const $push61=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push62=, $0, $pop61
; NO-SIMD128-FAST-NEXT:    i32.const $push96=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push58=, $12, $pop96
; NO-SIMD128-FAST-NEXT:    i32.const $push95=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push57=, $28, $pop95
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push59=, $pop58, $pop57
; NO-SIMD128-FAST-NEXT:    i32.select $push60=, $12, $28, $pop59
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop62), $pop60
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push68=, $0, $pop67
; NO-SIMD128-FAST-NEXT:    i32.const $push94=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push64=, $13, $pop94
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push63=, $29, $pop93
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push65=, $pop64, $pop63
; NO-SIMD128-FAST-NEXT:    i32.select $push66=, $13, $29, $pop65
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop68), $pop66
; NO-SIMD128-FAST-NEXT:    i32.const $push73=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push74=, $0, $pop73
; NO-SIMD128-FAST-NEXT:    i32.const $push92=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push70=, $14, $pop92
; NO-SIMD128-FAST-NEXT:    i32.const $push91=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push69=, $30, $pop91
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push71=, $pop70, $pop69
; NO-SIMD128-FAST-NEXT:    i32.select $push72=, $14, $30, $pop71
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop74), $pop72
; NO-SIMD128-FAST-NEXT:    i32.const $push79=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push80=, $0, $pop79
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push76=, $15, $pop90
; NO-SIMD128-FAST-NEXT:    i32.const $push89=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push75=, $31, $pop89
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push77=, $pop76, $pop75
; NO-SIMD128-FAST-NEXT:    i32.select $push78=, $15, $31, $pop77
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop80), $pop78
; NO-SIMD128-FAST-NEXT:    i32.const $push85=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push86=, $0, $pop85
; NO-SIMD128-FAST-NEXT:    i32.const $push88=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push82=, $16, $pop88
; NO-SIMD128-FAST-NEXT:    i32.const $push87=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push81=, $32, $pop87
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push83=, $pop82, $pop81
; NO-SIMD128-FAST-NEXT:    i32.select $push84=, $16, $32, $pop83
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop86), $pop84
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp ugt <16 x i8> %x, %y
  %a = select <16 x i1> %c, <16 x i8> %x, <16 x i8> %y
  ret <16 x i8> %a
}

define <16 x i8> @avgr_u_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: avgr_u_v16i8:
; SIMD128:         .functype avgr_u_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.avgr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: avgr_u_v16i8:
; SIMD128-FAST:         .functype avgr_u_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.avgr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: avgr_u_v16i8:
; NO-SIMD128:         .functype avgr_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 15
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.add $push2=, $16, $32
; NO-SIMD128-NEXT:    i32.const $push3=, 1
; NO-SIMD128-NEXT:    i32.add $push4=, $pop2, $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 254
; NO-SIMD128-NEXT:    i32.and $push6=, $pop4, $pop5
; NO-SIMD128-NEXT:    i32.const $push133=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push7=, $pop6, $pop133
; NO-SIMD128-NEXT:    i32.store8 0($pop1), $pop7
; NO-SIMD128-NEXT:    i32.const $push8=, 14
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.add $push10=, $15, $31
; NO-SIMD128-NEXT:    i32.const $push132=, 1
; NO-SIMD128-NEXT:    i32.add $push11=, $pop10, $pop132
; NO-SIMD128-NEXT:    i32.const $push131=, 254
; NO-SIMD128-NEXT:    i32.and $push12=, $pop11, $pop131
; NO-SIMD128-NEXT:    i32.const $push130=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push13=, $pop12, $pop130
; NO-SIMD128-NEXT:    i32.store8 0($pop9), $pop13
; NO-SIMD128-NEXT:    i32.const $push14=, 13
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.add $push16=, $14, $30
; NO-SIMD128-NEXT:    i32.const $push129=, 1
; NO-SIMD128-NEXT:    i32.add $push17=, $pop16, $pop129
; NO-SIMD128-NEXT:    i32.const $push128=, 254
; NO-SIMD128-NEXT:    i32.and $push18=, $pop17, $pop128
; NO-SIMD128-NEXT:    i32.const $push127=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push19=, $pop18, $pop127
; NO-SIMD128-NEXT:    i32.store8 0($pop15), $pop19
; NO-SIMD128-NEXT:    i32.const $push20=, 12
; NO-SIMD128-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-NEXT:    i32.add $push22=, $13, $29
; NO-SIMD128-NEXT:    i32.const $push126=, 1
; NO-SIMD128-NEXT:    i32.add $push23=, $pop22, $pop126
; NO-SIMD128-NEXT:    i32.const $push125=, 254
; NO-SIMD128-NEXT:    i32.and $push24=, $pop23, $pop125
; NO-SIMD128-NEXT:    i32.const $push124=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push25=, $pop24, $pop124
; NO-SIMD128-NEXT:    i32.store8 0($pop21), $pop25
; NO-SIMD128-NEXT:    i32.const $push26=, 11
; NO-SIMD128-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-NEXT:    i32.add $push28=, $12, $28
; NO-SIMD128-NEXT:    i32.const $push123=, 1
; NO-SIMD128-NEXT:    i32.add $push29=, $pop28, $pop123
; NO-SIMD128-NEXT:    i32.const $push122=, 254
; NO-SIMD128-NEXT:    i32.and $push30=, $pop29, $pop122
; NO-SIMD128-NEXT:    i32.const $push121=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push31=, $pop30, $pop121
; NO-SIMD128-NEXT:    i32.store8 0($pop27), $pop31
; NO-SIMD128-NEXT:    i32.const $push32=, 10
; NO-SIMD128-NEXT:    i32.add $push33=, $0, $pop32
; NO-SIMD128-NEXT:    i32.add $push34=, $11, $27
; NO-SIMD128-NEXT:    i32.const $push120=, 1
; NO-SIMD128-NEXT:    i32.add $push35=, $pop34, $pop120
; NO-SIMD128-NEXT:    i32.const $push119=, 254
; NO-SIMD128-NEXT:    i32.and $push36=, $pop35, $pop119
; NO-SIMD128-NEXT:    i32.const $push118=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push37=, $pop36, $pop118
; NO-SIMD128-NEXT:    i32.store8 0($pop33), $pop37
; NO-SIMD128-NEXT:    i32.const $push38=, 9
; NO-SIMD128-NEXT:    i32.add $push39=, $0, $pop38
; NO-SIMD128-NEXT:    i32.add $push40=, $10, $26
; NO-SIMD128-NEXT:    i32.const $push117=, 1
; NO-SIMD128-NEXT:    i32.add $push41=, $pop40, $pop117
; NO-SIMD128-NEXT:    i32.const $push116=, 254
; NO-SIMD128-NEXT:    i32.and $push42=, $pop41, $pop116
; NO-SIMD128-NEXT:    i32.const $push115=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push43=, $pop42, $pop115
; NO-SIMD128-NEXT:    i32.store8 0($pop39), $pop43
; NO-SIMD128-NEXT:    i32.add $push44=, $9, $25
; NO-SIMD128-NEXT:    i32.const $push114=, 1
; NO-SIMD128-NEXT:    i32.add $push45=, $pop44, $pop114
; NO-SIMD128-NEXT:    i32.const $push113=, 254
; NO-SIMD128-NEXT:    i32.and $push46=, $pop45, $pop113
; NO-SIMD128-NEXT:    i32.const $push112=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push47=, $pop46, $pop112
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop47
; NO-SIMD128-NEXT:    i32.const $push48=, 7
; NO-SIMD128-NEXT:    i32.add $push49=, $0, $pop48
; NO-SIMD128-NEXT:    i32.add $push50=, $8, $24
; NO-SIMD128-NEXT:    i32.const $push111=, 1
; NO-SIMD128-NEXT:    i32.add $push51=, $pop50, $pop111
; NO-SIMD128-NEXT:    i32.const $push110=, 254
; NO-SIMD128-NEXT:    i32.and $push52=, $pop51, $pop110
; NO-SIMD128-NEXT:    i32.const $push109=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push53=, $pop52, $pop109
; NO-SIMD128-NEXT:    i32.store8 0($pop49), $pop53
; NO-SIMD128-NEXT:    i32.const $push54=, 6
; NO-SIMD128-NEXT:    i32.add $push55=, $0, $pop54
; NO-SIMD128-NEXT:    i32.add $push56=, $7, $23
; NO-SIMD128-NEXT:    i32.const $push108=, 1
; NO-SIMD128-NEXT:    i32.add $push57=, $pop56, $pop108
; NO-SIMD128-NEXT:    i32.const $push107=, 254
; NO-SIMD128-NEXT:    i32.and $push58=, $pop57, $pop107
; NO-SIMD128-NEXT:    i32.const $push106=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push59=, $pop58, $pop106
; NO-SIMD128-NEXT:    i32.store8 0($pop55), $pop59
; NO-SIMD128-NEXT:    i32.const $push60=, 5
; NO-SIMD128-NEXT:    i32.add $push61=, $0, $pop60
; NO-SIMD128-NEXT:    i32.add $push62=, $6, $22
; NO-SIMD128-NEXT:    i32.const $push105=, 1
; NO-SIMD128-NEXT:    i32.add $push63=, $pop62, $pop105
; NO-SIMD128-NEXT:    i32.const $push104=, 254
; NO-SIMD128-NEXT:    i32.and $push64=, $pop63, $pop104
; NO-SIMD128-NEXT:    i32.const $push103=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push65=, $pop64, $pop103
; NO-SIMD128-NEXT:    i32.store8 0($pop61), $pop65
; NO-SIMD128-NEXT:    i32.add $push66=, $5, $21
; NO-SIMD128-NEXT:    i32.const $push102=, 1
; NO-SIMD128-NEXT:    i32.add $push67=, $pop66, $pop102
; NO-SIMD128-NEXT:    i32.const $push101=, 254
; NO-SIMD128-NEXT:    i32.and $push68=, $pop67, $pop101
; NO-SIMD128-NEXT:    i32.const $push100=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push69=, $pop68, $pop100
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop69
; NO-SIMD128-NEXT:    i32.const $push70=, 3
; NO-SIMD128-NEXT:    i32.add $push71=, $0, $pop70
; NO-SIMD128-NEXT:    i32.add $push72=, $4, $20
; NO-SIMD128-NEXT:    i32.const $push99=, 1
; NO-SIMD128-NEXT:    i32.add $push73=, $pop72, $pop99
; NO-SIMD128-NEXT:    i32.const $push98=, 254
; NO-SIMD128-NEXT:    i32.and $push74=, $pop73, $pop98
; NO-SIMD128-NEXT:    i32.const $push97=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push75=, $pop74, $pop97
; NO-SIMD128-NEXT:    i32.store8 0($pop71), $pop75
; NO-SIMD128-NEXT:    i32.add $push76=, $3, $19
; NO-SIMD128-NEXT:    i32.const $push96=, 1
; NO-SIMD128-NEXT:    i32.add $push77=, $pop76, $pop96
; NO-SIMD128-NEXT:    i32.const $push95=, 254
; NO-SIMD128-NEXT:    i32.and $push78=, $pop77, $pop95
; NO-SIMD128-NEXT:    i32.const $push94=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push79=, $pop78, $pop94
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop79
; NO-SIMD128-NEXT:    i32.add $push80=, $2, $18
; NO-SIMD128-NEXT:    i32.const $push93=, 1
; NO-SIMD128-NEXT:    i32.add $push81=, $pop80, $pop93
; NO-SIMD128-NEXT:    i32.const $push92=, 254
; NO-SIMD128-NEXT:    i32.and $push82=, $pop81, $pop92
; NO-SIMD128-NEXT:    i32.const $push91=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push83=, $pop82, $pop91
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop83
; NO-SIMD128-NEXT:    i32.add $push84=, $1, $17
; NO-SIMD128-NEXT:    i32.const $push90=, 1
; NO-SIMD128-NEXT:    i32.add $push85=, $pop84, $pop90
; NO-SIMD128-NEXT:    i32.const $push89=, 254
; NO-SIMD128-NEXT:    i32.and $push86=, $pop85, $pop89
; NO-SIMD128-NEXT:    i32.const $push88=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push87=, $pop86, $pop88
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop87
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: avgr_u_v16i8:
; NO-SIMD128-FAST:         .functype avgr_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $pop0, $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push133=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push5=, $pop4, $pop133
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.const $push132=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push7=, $pop6, $pop132
; NO-SIMD128-FAST-NEXT:    i32.const $push131=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $pop7, $pop131
; NO-SIMD128-FAST-NEXT:    i32.const $push130=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop130
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.const $push129=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $pop10, $pop129
; NO-SIMD128-FAST-NEXT:    i32.const $push128=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $pop11, $pop128
; NO-SIMD128-FAST-NEXT:    i32.const $push127=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push13=, $pop12, $pop127
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-FAST-NEXT:    i32.add $push16=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.const $push126=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push17=, $pop16, $pop126
; NO-SIMD128-FAST-NEXT:    i32.const $push125=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop125
; NO-SIMD128-FAST-NEXT:    i32.const $push124=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push19=, $pop18, $pop124
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop15), $pop19
; NO-SIMD128-FAST-NEXT:    i32.add $push20=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.const $push123=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push21=, $pop20, $pop123
; NO-SIMD128-FAST-NEXT:    i32.const $push122=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $pop21, $pop122
; NO-SIMD128-FAST-NEXT:    i32.const $push121=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push23=, $pop22, $pop121
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop23
; NO-SIMD128-FAST-NEXT:    i32.const $push24=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-FAST-NEXT:    i32.add $push26=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.const $push120=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $pop26, $pop120
; NO-SIMD128-FAST-NEXT:    i32.const $push119=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop119
; NO-SIMD128-FAST-NEXT:    i32.const $push118=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push29=, $pop28, $pop118
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop25), $pop29
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-FAST-NEXT:    i32.add $push32=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.const $push117=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $pop32, $pop117
; NO-SIMD128-FAST-NEXT:    i32.const $push116=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $pop33, $pop116
; NO-SIMD128-FAST-NEXT:    i32.const $push115=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push35=, $pop34, $pop115
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop31), $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-FAST-NEXT:    i32.add $push38=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.const $push114=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $pop38, $pop114
; NO-SIMD128-FAST-NEXT:    i32.const $push113=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push40=, $pop39, $pop113
; NO-SIMD128-FAST-NEXT:    i32.const $push112=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push41=, $pop40, $pop112
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop37), $pop41
; NO-SIMD128-FAST-NEXT:    i32.add $push42=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.const $push111=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push43=, $pop42, $pop111
; NO-SIMD128-FAST-NEXT:    i32.const $push110=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push44=, $pop43, $pop110
; NO-SIMD128-FAST-NEXT:    i32.const $push109=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push45=, $pop44, $pop109
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop45
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push47=, $0, $pop46
; NO-SIMD128-FAST-NEXT:    i32.add $push48=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.const $push108=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push49=, $pop48, $pop108
; NO-SIMD128-FAST-NEXT:    i32.const $push107=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push50=, $pop49, $pop107
; NO-SIMD128-FAST-NEXT:    i32.const $push106=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push51=, $pop50, $pop106
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop47), $pop51
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push53=, $0, $pop52
; NO-SIMD128-FAST-NEXT:    i32.add $push54=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.const $push105=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push55=, $pop54, $pop105
; NO-SIMD128-FAST-NEXT:    i32.const $push104=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push56=, $pop55, $pop104
; NO-SIMD128-FAST-NEXT:    i32.const $push103=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push57=, $pop56, $pop103
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop53), $pop57
; NO-SIMD128-FAST-NEXT:    i32.const $push58=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push59=, $0, $pop58
; NO-SIMD128-FAST-NEXT:    i32.add $push60=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.const $push102=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push61=, $pop60, $pop102
; NO-SIMD128-FAST-NEXT:    i32.const $push101=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push62=, $pop61, $pop101
; NO-SIMD128-FAST-NEXT:    i32.const $push100=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push63=, $pop62, $pop100
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop59), $pop63
; NO-SIMD128-FAST-NEXT:    i32.const $push64=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push65=, $0, $pop64
; NO-SIMD128-FAST-NEXT:    i32.add $push66=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.const $push99=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push67=, $pop66, $pop99
; NO-SIMD128-FAST-NEXT:    i32.const $push98=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push68=, $pop67, $pop98
; NO-SIMD128-FAST-NEXT:    i32.const $push97=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push69=, $pop68, $pop97
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop65), $pop69
; NO-SIMD128-FAST-NEXT:    i32.const $push70=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push71=, $0, $pop70
; NO-SIMD128-FAST-NEXT:    i32.add $push72=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.const $push96=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push73=, $pop72, $pop96
; NO-SIMD128-FAST-NEXT:    i32.const $push95=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push74=, $pop73, $pop95
; NO-SIMD128-FAST-NEXT:    i32.const $push94=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push75=, $pop74, $pop94
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop71), $pop75
; NO-SIMD128-FAST-NEXT:    i32.const $push76=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push77=, $0, $pop76
; NO-SIMD128-FAST-NEXT:    i32.add $push78=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push79=, $pop78, $pop93
; NO-SIMD128-FAST-NEXT:    i32.const $push92=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push80=, $pop79, $pop92
; NO-SIMD128-FAST-NEXT:    i32.const $push91=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push81=, $pop80, $pop91
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop77), $pop81
; NO-SIMD128-FAST-NEXT:    i32.const $push82=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push83=, $0, $pop82
; NO-SIMD128-FAST-NEXT:    i32.add $push84=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push85=, $pop84, $pop90
; NO-SIMD128-FAST-NEXT:    i32.const $push89=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push86=, $pop85, $pop89
; NO-SIMD128-FAST-NEXT:    i32.const $push88=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push87=, $pop86, $pop88
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop83), $pop87
; NO-SIMD128-FAST-NEXT:    return
  %a = add nuw <16 x i8> %x, %y
  %b = add nuw <16 x i8> %a, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1,
                              i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %c = udiv <16 x i8> %b, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2,
                           i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  ret <16 x i8> %c
}

define <16 x i8> @avgr_u_v16i8_wrap(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: avgr_u_v16i8_wrap:
; SIMD128:         .functype avgr_u_v16i8_wrap (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.add $push0=, $0, $1
; SIMD128-NEXT:    v128.const $push1=, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
; SIMD128-NEXT:    i8x16.add $push2=, $pop0, $pop1
; SIMD128-NEXT:    i32.const $push3=, 1
; SIMD128-NEXT:    i8x16.shr_u $push4=, $pop2, $pop3
; SIMD128-NEXT:    return $pop4
;
; SIMD128-FAST-LABEL: avgr_u_v16i8_wrap:
; SIMD128-FAST:         .functype avgr_u_v16i8_wrap (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.add $push2=, $0, $1
; SIMD128-FAST-NEXT:    v128.const $push3=, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
; SIMD128-FAST-NEXT:    i8x16.add $push1=, $pop2, $pop3
; SIMD128-FAST-NEXT:    i32.const $push4=, 1
; SIMD128-FAST-NEXT:    i8x16.shr_u $push0=, $pop1, $pop4
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: avgr_u_v16i8_wrap:
; NO-SIMD128:         .functype avgr_u_v16i8_wrap (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 15
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.add $push2=, $16, $32
; NO-SIMD128-NEXT:    i32.const $push3=, 1
; NO-SIMD128-NEXT:    i32.add $push4=, $pop2, $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 254
; NO-SIMD128-NEXT:    i32.and $push6=, $pop4, $pop5
; NO-SIMD128-NEXT:    i32.const $push133=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push7=, $pop6, $pop133
; NO-SIMD128-NEXT:    i32.store8 0($pop1), $pop7
; NO-SIMD128-NEXT:    i32.const $push8=, 14
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.add $push10=, $15, $31
; NO-SIMD128-NEXT:    i32.const $push132=, 1
; NO-SIMD128-NEXT:    i32.add $push11=, $pop10, $pop132
; NO-SIMD128-NEXT:    i32.const $push131=, 254
; NO-SIMD128-NEXT:    i32.and $push12=, $pop11, $pop131
; NO-SIMD128-NEXT:    i32.const $push130=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push13=, $pop12, $pop130
; NO-SIMD128-NEXT:    i32.store8 0($pop9), $pop13
; NO-SIMD128-NEXT:    i32.const $push14=, 13
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.add $push16=, $14, $30
; NO-SIMD128-NEXT:    i32.const $push129=, 1
; NO-SIMD128-NEXT:    i32.add $push17=, $pop16, $pop129
; NO-SIMD128-NEXT:    i32.const $push128=, 254
; NO-SIMD128-NEXT:    i32.and $push18=, $pop17, $pop128
; NO-SIMD128-NEXT:    i32.const $push127=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push19=, $pop18, $pop127
; NO-SIMD128-NEXT:    i32.store8 0($pop15), $pop19
; NO-SIMD128-NEXT:    i32.const $push20=, 12
; NO-SIMD128-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-NEXT:    i32.add $push22=, $13, $29
; NO-SIMD128-NEXT:    i32.const $push126=, 1
; NO-SIMD128-NEXT:    i32.add $push23=, $pop22, $pop126
; NO-SIMD128-NEXT:    i32.const $push125=, 254
; NO-SIMD128-NEXT:    i32.and $push24=, $pop23, $pop125
; NO-SIMD128-NEXT:    i32.const $push124=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push25=, $pop24, $pop124
; NO-SIMD128-NEXT:    i32.store8 0($pop21), $pop25
; NO-SIMD128-NEXT:    i32.const $push26=, 11
; NO-SIMD128-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-NEXT:    i32.add $push28=, $12, $28
; NO-SIMD128-NEXT:    i32.const $push123=, 1
; NO-SIMD128-NEXT:    i32.add $push29=, $pop28, $pop123
; NO-SIMD128-NEXT:    i32.const $push122=, 254
; NO-SIMD128-NEXT:    i32.and $push30=, $pop29, $pop122
; NO-SIMD128-NEXT:    i32.const $push121=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push31=, $pop30, $pop121
; NO-SIMD128-NEXT:    i32.store8 0($pop27), $pop31
; NO-SIMD128-NEXT:    i32.const $push32=, 10
; NO-SIMD128-NEXT:    i32.add $push33=, $0, $pop32
; NO-SIMD128-NEXT:    i32.add $push34=, $11, $27
; NO-SIMD128-NEXT:    i32.const $push120=, 1
; NO-SIMD128-NEXT:    i32.add $push35=, $pop34, $pop120
; NO-SIMD128-NEXT:    i32.const $push119=, 254
; NO-SIMD128-NEXT:    i32.and $push36=, $pop35, $pop119
; NO-SIMD128-NEXT:    i32.const $push118=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push37=, $pop36, $pop118
; NO-SIMD128-NEXT:    i32.store8 0($pop33), $pop37
; NO-SIMD128-NEXT:    i32.const $push38=, 9
; NO-SIMD128-NEXT:    i32.add $push39=, $0, $pop38
; NO-SIMD128-NEXT:    i32.add $push40=, $10, $26
; NO-SIMD128-NEXT:    i32.const $push117=, 1
; NO-SIMD128-NEXT:    i32.add $push41=, $pop40, $pop117
; NO-SIMD128-NEXT:    i32.const $push116=, 254
; NO-SIMD128-NEXT:    i32.and $push42=, $pop41, $pop116
; NO-SIMD128-NEXT:    i32.const $push115=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push43=, $pop42, $pop115
; NO-SIMD128-NEXT:    i32.store8 0($pop39), $pop43
; NO-SIMD128-NEXT:    i32.add $push44=, $9, $25
; NO-SIMD128-NEXT:    i32.const $push114=, 1
; NO-SIMD128-NEXT:    i32.add $push45=, $pop44, $pop114
; NO-SIMD128-NEXT:    i32.const $push113=, 254
; NO-SIMD128-NEXT:    i32.and $push46=, $pop45, $pop113
; NO-SIMD128-NEXT:    i32.const $push112=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push47=, $pop46, $pop112
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop47
; NO-SIMD128-NEXT:    i32.const $push48=, 7
; NO-SIMD128-NEXT:    i32.add $push49=, $0, $pop48
; NO-SIMD128-NEXT:    i32.add $push50=, $8, $24
; NO-SIMD128-NEXT:    i32.const $push111=, 1
; NO-SIMD128-NEXT:    i32.add $push51=, $pop50, $pop111
; NO-SIMD128-NEXT:    i32.const $push110=, 254
; NO-SIMD128-NEXT:    i32.and $push52=, $pop51, $pop110
; NO-SIMD128-NEXT:    i32.const $push109=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push53=, $pop52, $pop109
; NO-SIMD128-NEXT:    i32.store8 0($pop49), $pop53
; NO-SIMD128-NEXT:    i32.const $push54=, 6
; NO-SIMD128-NEXT:    i32.add $push55=, $0, $pop54
; NO-SIMD128-NEXT:    i32.add $push56=, $7, $23
; NO-SIMD128-NEXT:    i32.const $push108=, 1
; NO-SIMD128-NEXT:    i32.add $push57=, $pop56, $pop108
; NO-SIMD128-NEXT:    i32.const $push107=, 254
; NO-SIMD128-NEXT:    i32.and $push58=, $pop57, $pop107
; NO-SIMD128-NEXT:    i32.const $push106=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push59=, $pop58, $pop106
; NO-SIMD128-NEXT:    i32.store8 0($pop55), $pop59
; NO-SIMD128-NEXT:    i32.const $push60=, 5
; NO-SIMD128-NEXT:    i32.add $push61=, $0, $pop60
; NO-SIMD128-NEXT:    i32.add $push62=, $6, $22
; NO-SIMD128-NEXT:    i32.const $push105=, 1
; NO-SIMD128-NEXT:    i32.add $push63=, $pop62, $pop105
; NO-SIMD128-NEXT:    i32.const $push104=, 254
; NO-SIMD128-NEXT:    i32.and $push64=, $pop63, $pop104
; NO-SIMD128-NEXT:    i32.const $push103=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push65=, $pop64, $pop103
; NO-SIMD128-NEXT:    i32.store8 0($pop61), $pop65
; NO-SIMD128-NEXT:    i32.add $push66=, $5, $21
; NO-SIMD128-NEXT:    i32.const $push102=, 1
; NO-SIMD128-NEXT:    i32.add $push67=, $pop66, $pop102
; NO-SIMD128-NEXT:    i32.const $push101=, 254
; NO-SIMD128-NEXT:    i32.and $push68=, $pop67, $pop101
; NO-SIMD128-NEXT:    i32.const $push100=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push69=, $pop68, $pop100
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop69
; NO-SIMD128-NEXT:    i32.const $push70=, 3
; NO-SIMD128-NEXT:    i32.add $push71=, $0, $pop70
; NO-SIMD128-NEXT:    i32.add $push72=, $4, $20
; NO-SIMD128-NEXT:    i32.const $push99=, 1
; NO-SIMD128-NEXT:    i32.add $push73=, $pop72, $pop99
; NO-SIMD128-NEXT:    i32.const $push98=, 254
; NO-SIMD128-NEXT:    i32.and $push74=, $pop73, $pop98
; NO-SIMD128-NEXT:    i32.const $push97=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push75=, $pop74, $pop97
; NO-SIMD128-NEXT:    i32.store8 0($pop71), $pop75
; NO-SIMD128-NEXT:    i32.add $push76=, $3, $19
; NO-SIMD128-NEXT:    i32.const $push96=, 1
; NO-SIMD128-NEXT:    i32.add $push77=, $pop76, $pop96
; NO-SIMD128-NEXT:    i32.const $push95=, 254
; NO-SIMD128-NEXT:    i32.and $push78=, $pop77, $pop95
; NO-SIMD128-NEXT:    i32.const $push94=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push79=, $pop78, $pop94
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop79
; NO-SIMD128-NEXT:    i32.add $push80=, $2, $18
; NO-SIMD128-NEXT:    i32.const $push93=, 1
; NO-SIMD128-NEXT:    i32.add $push81=, $pop80, $pop93
; NO-SIMD128-NEXT:    i32.const $push92=, 254
; NO-SIMD128-NEXT:    i32.and $push82=, $pop81, $pop92
; NO-SIMD128-NEXT:    i32.const $push91=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push83=, $pop82, $pop91
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop83
; NO-SIMD128-NEXT:    i32.add $push84=, $1, $17
; NO-SIMD128-NEXT:    i32.const $push90=, 1
; NO-SIMD128-NEXT:    i32.add $push85=, $pop84, $pop90
; NO-SIMD128-NEXT:    i32.const $push89=, 254
; NO-SIMD128-NEXT:    i32.and $push86=, $pop85, $pop89
; NO-SIMD128-NEXT:    i32.const $push88=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push87=, $pop86, $pop88
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop87
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: avgr_u_v16i8_wrap:
; NO-SIMD128-FAST:         .functype avgr_u_v16i8_wrap (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $pop0, $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push133=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push5=, $pop4, $pop133
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.const $push132=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push7=, $pop6, $pop132
; NO-SIMD128-FAST-NEXT:    i32.const $push131=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $pop7, $pop131
; NO-SIMD128-FAST-NEXT:    i32.const $push130=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop130
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.const $push129=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $pop10, $pop129
; NO-SIMD128-FAST-NEXT:    i32.const $push128=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $pop11, $pop128
; NO-SIMD128-FAST-NEXT:    i32.const $push127=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push13=, $pop12, $pop127
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-FAST-NEXT:    i32.add $push16=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.const $push126=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push17=, $pop16, $pop126
; NO-SIMD128-FAST-NEXT:    i32.const $push125=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop125
; NO-SIMD128-FAST-NEXT:    i32.const $push124=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push19=, $pop18, $pop124
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop15), $pop19
; NO-SIMD128-FAST-NEXT:    i32.add $push20=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.const $push123=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push21=, $pop20, $pop123
; NO-SIMD128-FAST-NEXT:    i32.const $push122=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $pop21, $pop122
; NO-SIMD128-FAST-NEXT:    i32.const $push121=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push23=, $pop22, $pop121
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop23
; NO-SIMD128-FAST-NEXT:    i32.const $push24=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-FAST-NEXT:    i32.add $push26=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.const $push120=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $pop26, $pop120
; NO-SIMD128-FAST-NEXT:    i32.const $push119=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop119
; NO-SIMD128-FAST-NEXT:    i32.const $push118=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push29=, $pop28, $pop118
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop25), $pop29
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-FAST-NEXT:    i32.add $push32=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.const $push117=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $pop32, $pop117
; NO-SIMD128-FAST-NEXT:    i32.const $push116=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $pop33, $pop116
; NO-SIMD128-FAST-NEXT:    i32.const $push115=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push35=, $pop34, $pop115
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop31), $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-FAST-NEXT:    i32.add $push38=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.const $push114=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $pop38, $pop114
; NO-SIMD128-FAST-NEXT:    i32.const $push113=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push40=, $pop39, $pop113
; NO-SIMD128-FAST-NEXT:    i32.const $push112=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push41=, $pop40, $pop112
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop37), $pop41
; NO-SIMD128-FAST-NEXT:    i32.add $push42=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.const $push111=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push43=, $pop42, $pop111
; NO-SIMD128-FAST-NEXT:    i32.const $push110=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push44=, $pop43, $pop110
; NO-SIMD128-FAST-NEXT:    i32.const $push109=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push45=, $pop44, $pop109
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop45
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push47=, $0, $pop46
; NO-SIMD128-FAST-NEXT:    i32.add $push48=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.const $push108=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push49=, $pop48, $pop108
; NO-SIMD128-FAST-NEXT:    i32.const $push107=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push50=, $pop49, $pop107
; NO-SIMD128-FAST-NEXT:    i32.const $push106=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push51=, $pop50, $pop106
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop47), $pop51
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push53=, $0, $pop52
; NO-SIMD128-FAST-NEXT:    i32.add $push54=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.const $push105=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push55=, $pop54, $pop105
; NO-SIMD128-FAST-NEXT:    i32.const $push104=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push56=, $pop55, $pop104
; NO-SIMD128-FAST-NEXT:    i32.const $push103=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push57=, $pop56, $pop103
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop53), $pop57
; NO-SIMD128-FAST-NEXT:    i32.const $push58=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push59=, $0, $pop58
; NO-SIMD128-FAST-NEXT:    i32.add $push60=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.const $push102=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push61=, $pop60, $pop102
; NO-SIMD128-FAST-NEXT:    i32.const $push101=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push62=, $pop61, $pop101
; NO-SIMD128-FAST-NEXT:    i32.const $push100=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push63=, $pop62, $pop100
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop59), $pop63
; NO-SIMD128-FAST-NEXT:    i32.const $push64=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push65=, $0, $pop64
; NO-SIMD128-FAST-NEXT:    i32.add $push66=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.const $push99=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push67=, $pop66, $pop99
; NO-SIMD128-FAST-NEXT:    i32.const $push98=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push68=, $pop67, $pop98
; NO-SIMD128-FAST-NEXT:    i32.const $push97=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push69=, $pop68, $pop97
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop65), $pop69
; NO-SIMD128-FAST-NEXT:    i32.const $push70=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push71=, $0, $pop70
; NO-SIMD128-FAST-NEXT:    i32.add $push72=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.const $push96=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push73=, $pop72, $pop96
; NO-SIMD128-FAST-NEXT:    i32.const $push95=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push74=, $pop73, $pop95
; NO-SIMD128-FAST-NEXT:    i32.const $push94=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push75=, $pop74, $pop94
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop71), $pop75
; NO-SIMD128-FAST-NEXT:    i32.const $push76=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push77=, $0, $pop76
; NO-SIMD128-FAST-NEXT:    i32.add $push78=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push79=, $pop78, $pop93
; NO-SIMD128-FAST-NEXT:    i32.const $push92=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push80=, $pop79, $pop92
; NO-SIMD128-FAST-NEXT:    i32.const $push91=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push81=, $pop80, $pop91
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop77), $pop81
; NO-SIMD128-FAST-NEXT:    i32.const $push82=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push83=, $0, $pop82
; NO-SIMD128-FAST-NEXT:    i32.add $push84=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push85=, $pop84, $pop90
; NO-SIMD128-FAST-NEXT:    i32.const $push89=, 254
; NO-SIMD128-FAST-NEXT:    i32.and $push86=, $pop85, $pop89
; NO-SIMD128-FAST-NEXT:    i32.const $push88=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push87=, $pop86, $pop88
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop83), $pop87
; NO-SIMD128-FAST-NEXT:    return
  %a = add <16 x i8> %x, %y
  %b = add <16 x i8> %a, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1,
                          i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %c = udiv <16 x i8> %b, <i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2,
                           i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2, i8 2>
  ret <16 x i8> %c
}

define <16 x i8> @abs_v16i8(<16 x i8> %x) {
; SIMD128-LABEL: abs_v16i8:
; SIMD128:         .functype abs_v16i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.abs $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: abs_v16i8:
; SIMD128-FAST:         .functype abs_v16i8 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.abs $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: abs_v16i8:
; NO-SIMD128:         .functype abs_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push4=, 15
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.extend8_s $push0=, $16
; NO-SIMD128-NEXT:    i32.const $push1=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push117=, $pop0, $pop1
; NO-SIMD128-NEXT:    local.tee $push116=, $17=, $pop117
; NO-SIMD128-NEXT:    i32.xor $push2=, $16, $pop116
; NO-SIMD128-NEXT:    i32.sub $push3=, $pop2, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop5), $pop3
; NO-SIMD128-NEXT:    i32.const $push9=, 14
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    i32.extend8_s $push6=, $15
; NO-SIMD128-NEXT:    i32.const $push115=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push114=, $pop6, $pop115
; NO-SIMD128-NEXT:    local.tee $push113=, $16=, $pop114
; NO-SIMD128-NEXT:    i32.xor $push7=, $15, $pop113
; NO-SIMD128-NEXT:    i32.sub $push8=, $pop7, $16
; NO-SIMD128-NEXT:    i32.store8 0($pop10), $pop8
; NO-SIMD128-NEXT:    i32.const $push14=, 13
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.extend8_s $push11=, $14
; NO-SIMD128-NEXT:    i32.const $push112=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push111=, $pop11, $pop112
; NO-SIMD128-NEXT:    local.tee $push110=, $16=, $pop111
; NO-SIMD128-NEXT:    i32.xor $push12=, $14, $pop110
; NO-SIMD128-NEXT:    i32.sub $push13=, $pop12, $16
; NO-SIMD128-NEXT:    i32.store8 0($pop15), $pop13
; NO-SIMD128-NEXT:    i32.const $push19=, 12
; NO-SIMD128-NEXT:    i32.add $push20=, $0, $pop19
; NO-SIMD128-NEXT:    i32.extend8_s $push16=, $13
; NO-SIMD128-NEXT:    i32.const $push109=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push108=, $pop16, $pop109
; NO-SIMD128-NEXT:    local.tee $push107=, $16=, $pop108
; NO-SIMD128-NEXT:    i32.xor $push17=, $13, $pop107
; NO-SIMD128-NEXT:    i32.sub $push18=, $pop17, $16
; NO-SIMD128-NEXT:    i32.store8 0($pop20), $pop18
; NO-SIMD128-NEXT:    i32.const $push24=, 11
; NO-SIMD128-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-NEXT:    i32.extend8_s $push21=, $12
; NO-SIMD128-NEXT:    i32.const $push106=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push105=, $pop21, $pop106
; NO-SIMD128-NEXT:    local.tee $push104=, $16=, $pop105
; NO-SIMD128-NEXT:    i32.xor $push22=, $12, $pop104
; NO-SIMD128-NEXT:    i32.sub $push23=, $pop22, $16
; NO-SIMD128-NEXT:    i32.store8 0($pop25), $pop23
; NO-SIMD128-NEXT:    i32.const $push29=, 10
; NO-SIMD128-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-NEXT:    i32.extend8_s $push26=, $11
; NO-SIMD128-NEXT:    i32.const $push103=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push102=, $pop26, $pop103
; NO-SIMD128-NEXT:    local.tee $push101=, $16=, $pop102
; NO-SIMD128-NEXT:    i32.xor $push27=, $11, $pop101
; NO-SIMD128-NEXT:    i32.sub $push28=, $pop27, $16
; NO-SIMD128-NEXT:    i32.store8 0($pop30), $pop28
; NO-SIMD128-NEXT:    i32.const $push34=, 9
; NO-SIMD128-NEXT:    i32.add $push35=, $0, $pop34
; NO-SIMD128-NEXT:    i32.extend8_s $push31=, $10
; NO-SIMD128-NEXT:    i32.const $push100=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push99=, $pop31, $pop100
; NO-SIMD128-NEXT:    local.tee $push98=, $16=, $pop99
; NO-SIMD128-NEXT:    i32.xor $push32=, $10, $pop98
; NO-SIMD128-NEXT:    i32.sub $push33=, $pop32, $16
; NO-SIMD128-NEXT:    i32.store8 0($pop35), $pop33
; NO-SIMD128-NEXT:    i32.extend8_s $push36=, $9
; NO-SIMD128-NEXT:    i32.const $push97=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push96=, $pop36, $pop97
; NO-SIMD128-NEXT:    local.tee $push95=, $16=, $pop96
; NO-SIMD128-NEXT:    i32.xor $push37=, $9, $pop95
; NO-SIMD128-NEXT:    i32.sub $push38=, $pop37, $16
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop38
; NO-SIMD128-NEXT:    i32.const $push94=, 7
; NO-SIMD128-NEXT:    i32.add $push42=, $0, $pop94
; NO-SIMD128-NEXT:    i32.extend8_s $push39=, $8
; NO-SIMD128-NEXT:    i32.const $push93=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push92=, $pop39, $pop93
; NO-SIMD128-NEXT:    local.tee $push91=, $16=, $pop92
; NO-SIMD128-NEXT:    i32.xor $push40=, $8, $pop91
; NO-SIMD128-NEXT:    i32.sub $push41=, $pop40, $16
; NO-SIMD128-NEXT:    i32.store8 0($pop42), $pop41
; NO-SIMD128-NEXT:    i32.const $push46=, 6
; NO-SIMD128-NEXT:    i32.add $push47=, $0, $pop46
; NO-SIMD128-NEXT:    i32.extend8_s $push43=, $7
; NO-SIMD128-NEXT:    i32.const $push90=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push89=, $pop43, $pop90
; NO-SIMD128-NEXT:    local.tee $push88=, $16=, $pop89
; NO-SIMD128-NEXT:    i32.xor $push44=, $7, $pop88
; NO-SIMD128-NEXT:    i32.sub $push45=, $pop44, $16
; NO-SIMD128-NEXT:    i32.store8 0($pop47), $pop45
; NO-SIMD128-NEXT:    i32.const $push51=, 5
; NO-SIMD128-NEXT:    i32.add $push52=, $0, $pop51
; NO-SIMD128-NEXT:    i32.extend8_s $push48=, $6
; NO-SIMD128-NEXT:    i32.const $push87=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push86=, $pop48, $pop87
; NO-SIMD128-NEXT:    local.tee $push85=, $16=, $pop86
; NO-SIMD128-NEXT:    i32.xor $push49=, $6, $pop85
; NO-SIMD128-NEXT:    i32.sub $push50=, $pop49, $16
; NO-SIMD128-NEXT:    i32.store8 0($pop52), $pop50
; NO-SIMD128-NEXT:    i32.extend8_s $push53=, $5
; NO-SIMD128-NEXT:    i32.const $push84=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push83=, $pop53, $pop84
; NO-SIMD128-NEXT:    local.tee $push82=, $16=, $pop83
; NO-SIMD128-NEXT:    i32.xor $push54=, $5, $pop82
; NO-SIMD128-NEXT:    i32.sub $push55=, $pop54, $16
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop55
; NO-SIMD128-NEXT:    i32.const $push59=, 3
; NO-SIMD128-NEXT:    i32.add $push60=, $0, $pop59
; NO-SIMD128-NEXT:    i32.extend8_s $push56=, $4
; NO-SIMD128-NEXT:    i32.const $push81=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push80=, $pop56, $pop81
; NO-SIMD128-NEXT:    local.tee $push79=, $16=, $pop80
; NO-SIMD128-NEXT:    i32.xor $push57=, $4, $pop79
; NO-SIMD128-NEXT:    i32.sub $push58=, $pop57, $16
; NO-SIMD128-NEXT:    i32.store8 0($pop60), $pop58
; NO-SIMD128-NEXT:    i32.extend8_s $push61=, $3
; NO-SIMD128-NEXT:    i32.const $push78=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push77=, $pop61, $pop78
; NO-SIMD128-NEXT:    local.tee $push76=, $16=, $pop77
; NO-SIMD128-NEXT:    i32.xor $push62=, $3, $pop76
; NO-SIMD128-NEXT:    i32.sub $push63=, $pop62, $16
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop63
; NO-SIMD128-NEXT:    i32.extend8_s $push64=, $2
; NO-SIMD128-NEXT:    i32.const $push75=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push74=, $pop64, $pop75
; NO-SIMD128-NEXT:    local.tee $push73=, $16=, $pop74
; NO-SIMD128-NEXT:    i32.xor $push65=, $2, $pop73
; NO-SIMD128-NEXT:    i32.sub $push66=, $pop65, $16
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop66
; NO-SIMD128-NEXT:    i32.extend8_s $push67=, $1
; NO-SIMD128-NEXT:    i32.const $push72=, 7
; NO-SIMD128-NEXT:    i32.shr_s $push71=, $pop67, $pop72
; NO-SIMD128-NEXT:    local.tee $push70=, $16=, $pop71
; NO-SIMD128-NEXT:    i32.xor $push68=, $1, $pop70
; NO-SIMD128-NEXT:    i32.sub $push69=, $pop68, $16
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop69
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: abs_v16i8:
; NO-SIMD128-FAST:         .functype abs_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push0=, $1
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push117=, $pop0, $pop1
; NO-SIMD128-FAST-NEXT:    local.tee $push116=, $17=, $pop117
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $1, $pop116
; NO-SIMD128-FAST-NEXT:    i32.sub $push3=, $pop2, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push4=, $2
; NO-SIMD128-FAST-NEXT:    i32.const $push115=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push114=, $pop4, $pop115
; NO-SIMD128-FAST-NEXT:    local.tee $push113=, $1=, $pop114
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $2, $pop113
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $pop5, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push7=, $3
; NO-SIMD128-FAST-NEXT:    i32.const $push112=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push111=, $pop7, $pop112
; NO-SIMD128-FAST-NEXT:    local.tee $push110=, $2=, $pop111
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $3, $pop110
; NO-SIMD128-FAST-NEXT:    i32.sub $push9=, $pop8, $2
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push10=, $4
; NO-SIMD128-FAST-NEXT:    i32.const $push109=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push108=, $pop10, $pop109
; NO-SIMD128-FAST-NEXT:    local.tee $push107=, $3=, $pop108
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $4, $pop107
; NO-SIMD128-FAST-NEXT:    i32.sub $push12=, $pop11, $3
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop14), $pop12
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push15=, $5
; NO-SIMD128-FAST-NEXT:    i32.const $push106=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push105=, $pop15, $pop106
; NO-SIMD128-FAST-NEXT:    local.tee $push104=, $4=, $pop105
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $5, $pop104
; NO-SIMD128-FAST-NEXT:    i32.sub $push17=, $pop16, $4
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push18=, $6
; NO-SIMD128-FAST-NEXT:    i32.const $push103=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push102=, $pop18, $pop103
; NO-SIMD128-FAST-NEXT:    local.tee $push101=, $5=, $pop102
; NO-SIMD128-FAST-NEXT:    i32.xor $push19=, $6, $pop101
; NO-SIMD128-FAST-NEXT:    i32.sub $push20=, $pop19, $5
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop22), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push23=, $7
; NO-SIMD128-FAST-NEXT:    i32.const $push100=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push99=, $pop23, $pop100
; NO-SIMD128-FAST-NEXT:    local.tee $push98=, $6=, $pop99
; NO-SIMD128-FAST-NEXT:    i32.xor $push24=, $7, $pop98
; NO-SIMD128-FAST-NEXT:    i32.sub $push25=, $pop24, $6
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop27), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push97=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push31=, $0, $pop97
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push28=, $8
; NO-SIMD128-FAST-NEXT:    i32.const $push96=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push95=, $pop28, $pop96
; NO-SIMD128-FAST-NEXT:    local.tee $push94=, $7=, $pop95
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $8, $pop94
; NO-SIMD128-FAST-NEXT:    i32.sub $push30=, $pop29, $7
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop31), $pop30
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push32=, $9
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push92=, $pop32, $pop93
; NO-SIMD128-FAST-NEXT:    local.tee $push91=, $8=, $pop92
; NO-SIMD128-FAST-NEXT:    i32.xor $push33=, $9, $pop91
; NO-SIMD128-FAST-NEXT:    i32.sub $push34=, $pop33, $8
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $0, $pop38
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push35=, $10
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push89=, $pop35, $pop90
; NO-SIMD128-FAST-NEXT:    local.tee $push88=, $9=, $pop89
; NO-SIMD128-FAST-NEXT:    i32.xor $push36=, $10, $pop88
; NO-SIMD128-FAST-NEXT:    i32.sub $push37=, $pop36, $9
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop39), $pop37
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push44=, $0, $pop43
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push40=, $11
; NO-SIMD128-FAST-NEXT:    i32.const $push87=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push86=, $pop40, $pop87
; NO-SIMD128-FAST-NEXT:    local.tee $push85=, $10=, $pop86
; NO-SIMD128-FAST-NEXT:    i32.xor $push41=, $11, $pop85
; NO-SIMD128-FAST-NEXT:    i32.sub $push42=, $pop41, $10
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop44), $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push48=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push49=, $0, $pop48
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push45=, $12
; NO-SIMD128-FAST-NEXT:    i32.const $push84=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push83=, $pop45, $pop84
; NO-SIMD128-FAST-NEXT:    local.tee $push82=, $11=, $pop83
; NO-SIMD128-FAST-NEXT:    i32.xor $push46=, $12, $pop82
; NO-SIMD128-FAST-NEXT:    i32.sub $push47=, $pop46, $11
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop49), $pop47
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push54=, $0, $pop53
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push50=, $13
; NO-SIMD128-FAST-NEXT:    i32.const $push81=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push80=, $pop50, $pop81
; NO-SIMD128-FAST-NEXT:    local.tee $push79=, $12=, $pop80
; NO-SIMD128-FAST-NEXT:    i32.xor $push51=, $13, $pop79
; NO-SIMD128-FAST-NEXT:    i32.sub $push52=, $pop51, $12
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop54), $pop52
; NO-SIMD128-FAST-NEXT:    i32.const $push58=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push59=, $0, $pop58
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push55=, $14
; NO-SIMD128-FAST-NEXT:    i32.const $push78=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push77=, $pop55, $pop78
; NO-SIMD128-FAST-NEXT:    local.tee $push76=, $13=, $pop77
; NO-SIMD128-FAST-NEXT:    i32.xor $push56=, $14, $pop76
; NO-SIMD128-FAST-NEXT:    i32.sub $push57=, $pop56, $13
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop59), $pop57
; NO-SIMD128-FAST-NEXT:    i32.const $push63=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push64=, $0, $pop63
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push60=, $15
; NO-SIMD128-FAST-NEXT:    i32.const $push75=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push74=, $pop60, $pop75
; NO-SIMD128-FAST-NEXT:    local.tee $push73=, $14=, $pop74
; NO-SIMD128-FAST-NEXT:    i32.xor $push61=, $15, $pop73
; NO-SIMD128-FAST-NEXT:    i32.sub $push62=, $pop61, $14
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop64), $pop62
; NO-SIMD128-FAST-NEXT:    i32.const $push68=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push69=, $0, $pop68
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push65=, $16
; NO-SIMD128-FAST-NEXT:    i32.const $push72=, 7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push71=, $pop65, $pop72
; NO-SIMD128-FAST-NEXT:    local.tee $push70=, $0=, $pop71
; NO-SIMD128-FAST-NEXT:    i32.xor $push66=, $16, $pop70
; NO-SIMD128-FAST-NEXT:    i32.sub $push67=, $pop66, $0
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop69), $pop67
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <16 x i8> zeroinitializer, %x
  %b = icmp slt <16 x i8> %x, zeroinitializer
  %c = select <16 x i1> %b, <16 x i8> %a, <16 x i8> %x
  ret <16 x i8> %c
}

define <16 x i8> @neg_v16i8(<16 x i8> %x) {
; SIMD128-LABEL: neg_v16i8:
; SIMD128:         .functype neg_v16i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.neg $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: neg_v16i8:
; SIMD128-FAST:         .functype neg_v16i8 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.neg $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: neg_v16i8:
; NO-SIMD128:         .functype neg_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 0
; NO-SIMD128-NEXT:    i32.sub $push1=, $pop0, $9
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push53=, 0
; NO-SIMD128-NEXT:    i32.sub $push2=, $pop53, $5
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push52=, 0
; NO-SIMD128-NEXT:    i32.sub $push3=, $pop52, $3
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push51=, 0
; NO-SIMD128-NEXT:    i32.sub $push4=, $pop51, $2
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push50=, 0
; NO-SIMD128-NEXT:    i32.sub $push5=, $pop50, $1
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push7=, 15
; NO-SIMD128-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-NEXT:    i32.const $push49=, 0
; NO-SIMD128-NEXT:    i32.sub $push6=, $pop49, $16
; NO-SIMD128-NEXT:    i32.store8 0($pop8), $pop6
; NO-SIMD128-NEXT:    i32.const $push10=, 14
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.const $push48=, 0
; NO-SIMD128-NEXT:    i32.sub $push9=, $pop48, $15
; NO-SIMD128-NEXT:    i32.store8 0($pop11), $pop9
; NO-SIMD128-NEXT:    i32.const $push13=, 13
; NO-SIMD128-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-NEXT:    i32.const $push47=, 0
; NO-SIMD128-NEXT:    i32.sub $push12=, $pop47, $14
; NO-SIMD128-NEXT:    i32.store8 0($pop14), $pop12
; NO-SIMD128-NEXT:    i32.const $push16=, 12
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.const $push46=, 0
; NO-SIMD128-NEXT:    i32.sub $push15=, $pop46, $13
; NO-SIMD128-NEXT:    i32.store8 0($pop17), $pop15
; NO-SIMD128-NEXT:    i32.const $push19=, 11
; NO-SIMD128-NEXT:    i32.add $push20=, $0, $pop19
; NO-SIMD128-NEXT:    i32.const $push45=, 0
; NO-SIMD128-NEXT:    i32.sub $push18=, $pop45, $12
; NO-SIMD128-NEXT:    i32.store8 0($pop20), $pop18
; NO-SIMD128-NEXT:    i32.const $push22=, 10
; NO-SIMD128-NEXT:    i32.add $push23=, $0, $pop22
; NO-SIMD128-NEXT:    i32.const $push44=, 0
; NO-SIMD128-NEXT:    i32.sub $push21=, $pop44, $11
; NO-SIMD128-NEXT:    i32.store8 0($pop23), $pop21
; NO-SIMD128-NEXT:    i32.const $push25=, 9
; NO-SIMD128-NEXT:    i32.add $push26=, $0, $pop25
; NO-SIMD128-NEXT:    i32.const $push43=, 0
; NO-SIMD128-NEXT:    i32.sub $push24=, $pop43, $10
; NO-SIMD128-NEXT:    i32.store8 0($pop26), $pop24
; NO-SIMD128-NEXT:    i32.const $push28=, 7
; NO-SIMD128-NEXT:    i32.add $push29=, $0, $pop28
; NO-SIMD128-NEXT:    i32.const $push42=, 0
; NO-SIMD128-NEXT:    i32.sub $push27=, $pop42, $8
; NO-SIMD128-NEXT:    i32.store8 0($pop29), $pop27
; NO-SIMD128-NEXT:    i32.const $push31=, 6
; NO-SIMD128-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-NEXT:    i32.const $push41=, 0
; NO-SIMD128-NEXT:    i32.sub $push30=, $pop41, $7
; NO-SIMD128-NEXT:    i32.store8 0($pop32), $pop30
; NO-SIMD128-NEXT:    i32.const $push34=, 5
; NO-SIMD128-NEXT:    i32.add $push35=, $0, $pop34
; NO-SIMD128-NEXT:    i32.const $push40=, 0
; NO-SIMD128-NEXT:    i32.sub $push33=, $pop40, $6
; NO-SIMD128-NEXT:    i32.store8 0($pop35), $pop33
; NO-SIMD128-NEXT:    i32.const $push37=, 3
; NO-SIMD128-NEXT:    i32.add $push38=, $0, $pop37
; NO-SIMD128-NEXT:    i32.const $push39=, 0
; NO-SIMD128-NEXT:    i32.sub $push36=, $pop39, $4
; NO-SIMD128-NEXT:    i32.store8 0($pop38), $pop36
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: neg_v16i8:
; NO-SIMD128-FAST:         .functype neg_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $pop53, $2
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push3=, $pop52, $3
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $pop51, $4
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop5), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push7=, $pop50, $5
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push10=, $pop49, $6
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop9), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push11=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push48=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push13=, $pop48, $7
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop12), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push16=, $pop47, $8
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop15), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push17=, $pop46, $9
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push20=, $pop45, $10
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop19), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push23=, $pop44, $11
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop22), $pop23
; NO-SIMD128-FAST-NEXT:    i32.const $push24=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push26=, $pop43, $12
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop25), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push29=, $pop42, $13
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop28), $pop29
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push32=, $pop41, $14
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop31), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push35=, $pop40, $15
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop34), $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push38=, $pop39, $16
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop37), $pop38
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <16 x i8> <i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0,
                      i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0, i8 0>,
                     %x
  ret <16 x i8> %a
}

define <16 x i8> @shl_v16i8(<16 x i8> %v, i8 %x) {
; SIMD128-LABEL: shl_v16i8:
; SIMD128:         .functype shl_v16i8 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shl $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shl_v16i8:
; SIMD128-FAST:         .functype shl_v16i8 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.shl $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_v16i8:
; NO-SIMD128:         .functype shl_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push40=, $17, $pop0
; NO-SIMD128-NEXT:    local.tee $push39=, $17=, $pop40
; NO-SIMD128-NEXT:    i32.shl $push1=, $9, $pop39
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop1
; NO-SIMD128-NEXT:    i32.shl $push2=, $5, $17
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop2
; NO-SIMD128-NEXT:    i32.shl $push3=, $3, $17
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop3
; NO-SIMD128-NEXT:    i32.shl $push4=, $2, $17
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop4
; NO-SIMD128-NEXT:    i32.shl $push5=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push7=, 15
; NO-SIMD128-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-NEXT:    i32.shl $push6=, $16, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop8), $pop6
; NO-SIMD128-NEXT:    i32.const $push10=, 14
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.shl $push9=, $15, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop11), $pop9
; NO-SIMD128-NEXT:    i32.const $push13=, 13
; NO-SIMD128-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-NEXT:    i32.shl $push12=, $14, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop14), $pop12
; NO-SIMD128-NEXT:    i32.const $push16=, 12
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.shl $push15=, $13, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop17), $pop15
; NO-SIMD128-NEXT:    i32.const $push19=, 11
; NO-SIMD128-NEXT:    i32.add $push20=, $0, $pop19
; NO-SIMD128-NEXT:    i32.shl $push18=, $12, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop20), $pop18
; NO-SIMD128-NEXT:    i32.const $push22=, 10
; NO-SIMD128-NEXT:    i32.add $push23=, $0, $pop22
; NO-SIMD128-NEXT:    i32.shl $push21=, $11, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop23), $pop21
; NO-SIMD128-NEXT:    i32.const $push25=, 9
; NO-SIMD128-NEXT:    i32.add $push26=, $0, $pop25
; NO-SIMD128-NEXT:    i32.shl $push24=, $10, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop26), $pop24
; NO-SIMD128-NEXT:    i32.const $push28=, 7
; NO-SIMD128-NEXT:    i32.add $push29=, $0, $pop28
; NO-SIMD128-NEXT:    i32.shl $push27=, $8, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop29), $pop27
; NO-SIMD128-NEXT:    i32.const $push31=, 6
; NO-SIMD128-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-NEXT:    i32.shl $push30=, $7, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop32), $pop30
; NO-SIMD128-NEXT:    i32.const $push34=, 5
; NO-SIMD128-NEXT:    i32.add $push35=, $0, $pop34
; NO-SIMD128-NEXT:    i32.shl $push33=, $6, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop35), $pop33
; NO-SIMD128-NEXT:    i32.const $push37=, 3
; NO-SIMD128-NEXT:    i32.add $push38=, $0, $pop37
; NO-SIMD128-NEXT:    i32.shl $push36=, $4, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop38), $pop36
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_v16i8:
; NO-SIMD128-FAST:         .functype shl_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push40=, $17, $pop0
; NO-SIMD128-FAST-NEXT:    local.tee $push39=, $17=, $pop40
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $2, $pop39
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.shl $push3=, $3, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-FAST-NEXT:    i32.shl $push6=, $4, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop5), $pop6
; NO-SIMD128-FAST-NEXT:    i32.shl $push7=, $5, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-FAST-NEXT:    i32.shl $push10=, $6, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop9), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push11=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-FAST-NEXT:    i32.shl $push13=, $7, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop12), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-FAST-NEXT:    i32.shl $push16=, $8, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop15), $pop16
; NO-SIMD128-FAST-NEXT:    i32.shl $push17=, $9, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-FAST-NEXT:    i32.shl $push20=, $10, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop19), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.shl $push23=, $11, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop22), $pop23
; NO-SIMD128-FAST-NEXT:    i32.const $push24=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-FAST-NEXT:    i32.shl $push26=, $12, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop25), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.shl $push29=, $13, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop28), $pop29
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-FAST-NEXT:    i32.shl $push32=, $14, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop31), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-FAST-NEXT:    i32.shl $push35=, $15, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop34), $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-FAST-NEXT:    i32.shl $push38=, $16, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop37), $pop38
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <16 x i8> undef, i8 %x, i32 0
  %s = shufflevector <16 x i8> %t, <16 x i8> undef,
    <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0,
                i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %a = shl <16 x i8> %v, %s
  ret <16 x i8> %a
}

define <16 x i8> @shl_const_v16i8(<16 x i8> %v) {
; SIMD128-LABEL: shl_const_v16i8:
; SIMD128:         .functype shl_const_v16i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.const $push0=, 5
; SIMD128-NEXT:    i8x16.shl $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shl_const_v16i8:
; SIMD128-FAST:         .functype shl_const_v16i8 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.const $push1=, 5
; SIMD128-FAST-NEXT:    i8x16.shl $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_const_v16i8:
; NO-SIMD128:         .functype shl_const_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 5
; NO-SIMD128-NEXT:    i32.shl $push1=, $9, $pop0
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push53=, 5
; NO-SIMD128-NEXT:    i32.shl $push2=, $5, $pop53
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push52=, 5
; NO-SIMD128-NEXT:    i32.shl $push3=, $3, $pop52
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push51=, 5
; NO-SIMD128-NEXT:    i32.shl $push4=, $2, $pop51
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push50=, 5
; NO-SIMD128-NEXT:    i32.shl $push5=, $1, $pop50
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push7=, 15
; NO-SIMD128-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-NEXT:    i32.const $push49=, 5
; NO-SIMD128-NEXT:    i32.shl $push6=, $16, $pop49
; NO-SIMD128-NEXT:    i32.store8 0($pop8), $pop6
; NO-SIMD128-NEXT:    i32.const $push10=, 14
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.const $push48=, 5
; NO-SIMD128-NEXT:    i32.shl $push9=, $15, $pop48
; NO-SIMD128-NEXT:    i32.store8 0($pop11), $pop9
; NO-SIMD128-NEXT:    i32.const $push13=, 13
; NO-SIMD128-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-NEXT:    i32.const $push47=, 5
; NO-SIMD128-NEXT:    i32.shl $push12=, $14, $pop47
; NO-SIMD128-NEXT:    i32.store8 0($pop14), $pop12
; NO-SIMD128-NEXT:    i32.const $push16=, 12
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.const $push46=, 5
; NO-SIMD128-NEXT:    i32.shl $push15=, $13, $pop46
; NO-SIMD128-NEXT:    i32.store8 0($pop17), $pop15
; NO-SIMD128-NEXT:    i32.const $push19=, 11
; NO-SIMD128-NEXT:    i32.add $push20=, $0, $pop19
; NO-SIMD128-NEXT:    i32.const $push45=, 5
; NO-SIMD128-NEXT:    i32.shl $push18=, $12, $pop45
; NO-SIMD128-NEXT:    i32.store8 0($pop20), $pop18
; NO-SIMD128-NEXT:    i32.const $push22=, 10
; NO-SIMD128-NEXT:    i32.add $push23=, $0, $pop22
; NO-SIMD128-NEXT:    i32.const $push44=, 5
; NO-SIMD128-NEXT:    i32.shl $push21=, $11, $pop44
; NO-SIMD128-NEXT:    i32.store8 0($pop23), $pop21
; NO-SIMD128-NEXT:    i32.const $push25=, 9
; NO-SIMD128-NEXT:    i32.add $push26=, $0, $pop25
; NO-SIMD128-NEXT:    i32.const $push43=, 5
; NO-SIMD128-NEXT:    i32.shl $push24=, $10, $pop43
; NO-SIMD128-NEXT:    i32.store8 0($pop26), $pop24
; NO-SIMD128-NEXT:    i32.const $push28=, 7
; NO-SIMD128-NEXT:    i32.add $push29=, $0, $pop28
; NO-SIMD128-NEXT:    i32.const $push42=, 5
; NO-SIMD128-NEXT:    i32.shl $push27=, $8, $pop42
; NO-SIMD128-NEXT:    i32.store8 0($pop29), $pop27
; NO-SIMD128-NEXT:    i32.const $push31=, 6
; NO-SIMD128-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-NEXT:    i32.const $push41=, 5
; NO-SIMD128-NEXT:    i32.shl $push30=, $7, $pop41
; NO-SIMD128-NEXT:    i32.store8 0($pop32), $pop30
; NO-SIMD128-NEXT:    i32.const $push40=, 5
; NO-SIMD128-NEXT:    i32.add $push34=, $0, $pop40
; NO-SIMD128-NEXT:    i32.const $push39=, 5
; NO-SIMD128-NEXT:    i32.shl $push33=, $6, $pop39
; NO-SIMD128-NEXT:    i32.store8 0($pop34), $pop33
; NO-SIMD128-NEXT:    i32.const $push36=, 3
; NO-SIMD128-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-NEXT:    i32.const $push38=, 5
; NO-SIMD128-NEXT:    i32.shl $push35=, $4, $pop38
; NO-SIMD128-NEXT:    i32.store8 0($pop37), $pop35
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_const_v16i8:
; NO-SIMD128-FAST:         .functype shl_const_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $2, $pop53
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push3=, $3, $pop52
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push6=, $4, $pop51
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop5), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push7=, $5, $pop50
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop49
; NO-SIMD128-FAST-NEXT:    i32.const $push48=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push9=, $6, $pop48
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop8), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push12=, $7, $pop47
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop11), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push15=, $8, $pop46
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop14), $pop15
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push16=, $9, $pop45
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push19=, $10, $pop44
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop19
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push22=, $11, $pop43
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop21), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push25=, $12, $pop42
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop24), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push28=, $13, $pop41
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop27), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push31=, $14, $pop40
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop30), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $0, $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push34=, $15, $pop39
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop33), $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push37=, $16, $pop38
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop36), $pop37
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <16 x i8> %v,
    <i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5,
     i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5, i8 5>
  ret <16 x i8> %a
}

define <16 x i8> @shl_vec_v16i8(<16 x i8> %v, <16 x i8> %x) {
; SIMD128-LABEL: shl_vec_v16i8:
; SIMD128:         .functype shl_vec_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.extract_lane_u $push7=, $0, 0
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $1, 0
; SIMD128-NEXT:    i32.const $push1=, 7
; SIMD128-NEXT:    i32.and $push6=, $pop5, $pop1
; SIMD128-NEXT:    i32.shl $push8=, $pop7, $pop6
; SIMD128-NEXT:    i8x16.splat $push9=, $pop8
; SIMD128-NEXT:    i8x16.extract_lane_u $push3=, $0, 1
; SIMD128-NEXT:    i8x16.extract_lane_u $push0=, $1, 1
; SIMD128-NEXT:    i32.const $push95=, 7
; SIMD128-NEXT:    i32.and $push2=, $pop0, $pop95
; SIMD128-NEXT:    i32.shl $push4=, $pop3, $pop2
; SIMD128-NEXT:    i8x16.replace_lane $push10=, $pop9, 1, $pop4
; SIMD128-NEXT:    i8x16.extract_lane_u $push13=, $0, 2
; SIMD128-NEXT:    i8x16.extract_lane_u $push11=, $1, 2
; SIMD128-NEXT:    i32.const $push94=, 7
; SIMD128-NEXT:    i32.and $push12=, $pop11, $pop94
; SIMD128-NEXT:    i32.shl $push14=, $pop13, $pop12
; SIMD128-NEXT:    i8x16.replace_lane $push15=, $pop10, 2, $pop14
; SIMD128-NEXT:    i8x16.extract_lane_u $push18=, $0, 3
; SIMD128-NEXT:    i8x16.extract_lane_u $push16=, $1, 3
; SIMD128-NEXT:    i32.const $push93=, 7
; SIMD128-NEXT:    i32.and $push17=, $pop16, $pop93
; SIMD128-NEXT:    i32.shl $push19=, $pop18, $pop17
; SIMD128-NEXT:    i8x16.replace_lane $push20=, $pop15, 3, $pop19
; SIMD128-NEXT:    i8x16.extract_lane_u $push23=, $0, 4
; SIMD128-NEXT:    i8x16.extract_lane_u $push21=, $1, 4
; SIMD128-NEXT:    i32.const $push92=, 7
; SIMD128-NEXT:    i32.and $push22=, $pop21, $pop92
; SIMD128-NEXT:    i32.shl $push24=, $pop23, $pop22
; SIMD128-NEXT:    i8x16.replace_lane $push25=, $pop20, 4, $pop24
; SIMD128-NEXT:    i8x16.extract_lane_u $push28=, $0, 5
; SIMD128-NEXT:    i8x16.extract_lane_u $push26=, $1, 5
; SIMD128-NEXT:    i32.const $push91=, 7
; SIMD128-NEXT:    i32.and $push27=, $pop26, $pop91
; SIMD128-NEXT:    i32.shl $push29=, $pop28, $pop27
; SIMD128-NEXT:    i8x16.replace_lane $push30=, $pop25, 5, $pop29
; SIMD128-NEXT:    i8x16.extract_lane_u $push33=, $0, 6
; SIMD128-NEXT:    i8x16.extract_lane_u $push31=, $1, 6
; SIMD128-NEXT:    i32.const $push90=, 7
; SIMD128-NEXT:    i32.and $push32=, $pop31, $pop90
; SIMD128-NEXT:    i32.shl $push34=, $pop33, $pop32
; SIMD128-NEXT:    i8x16.replace_lane $push35=, $pop30, 6, $pop34
; SIMD128-NEXT:    i8x16.extract_lane_u $push38=, $0, 7
; SIMD128-NEXT:    i8x16.extract_lane_u $push36=, $1, 7
; SIMD128-NEXT:    i32.const $push89=, 7
; SIMD128-NEXT:    i32.and $push37=, $pop36, $pop89
; SIMD128-NEXT:    i32.shl $push39=, $pop38, $pop37
; SIMD128-NEXT:    i8x16.replace_lane $push40=, $pop35, 7, $pop39
; SIMD128-NEXT:    i8x16.extract_lane_u $push43=, $0, 8
; SIMD128-NEXT:    i8x16.extract_lane_u $push41=, $1, 8
; SIMD128-NEXT:    i32.const $push88=, 7
; SIMD128-NEXT:    i32.and $push42=, $pop41, $pop88
; SIMD128-NEXT:    i32.shl $push44=, $pop43, $pop42
; SIMD128-NEXT:    i8x16.replace_lane $push45=, $pop40, 8, $pop44
; SIMD128-NEXT:    i8x16.extract_lane_u $push48=, $0, 9
; SIMD128-NEXT:    i8x16.extract_lane_u $push46=, $1, 9
; SIMD128-NEXT:    i32.const $push87=, 7
; SIMD128-NEXT:    i32.and $push47=, $pop46, $pop87
; SIMD128-NEXT:    i32.shl $push49=, $pop48, $pop47
; SIMD128-NEXT:    i8x16.replace_lane $push50=, $pop45, 9, $pop49
; SIMD128-NEXT:    i8x16.extract_lane_u $push53=, $0, 10
; SIMD128-NEXT:    i8x16.extract_lane_u $push51=, $1, 10
; SIMD128-NEXT:    i32.const $push86=, 7
; SIMD128-NEXT:    i32.and $push52=, $pop51, $pop86
; SIMD128-NEXT:    i32.shl $push54=, $pop53, $pop52
; SIMD128-NEXT:    i8x16.replace_lane $push55=, $pop50, 10, $pop54
; SIMD128-NEXT:    i8x16.extract_lane_u $push58=, $0, 11
; SIMD128-NEXT:    i8x16.extract_lane_u $push56=, $1, 11
; SIMD128-NEXT:    i32.const $push85=, 7
; SIMD128-NEXT:    i32.and $push57=, $pop56, $pop85
; SIMD128-NEXT:    i32.shl $push59=, $pop58, $pop57
; SIMD128-NEXT:    i8x16.replace_lane $push60=, $pop55, 11, $pop59
; SIMD128-NEXT:    i8x16.extract_lane_u $push63=, $0, 12
; SIMD128-NEXT:    i8x16.extract_lane_u $push61=, $1, 12
; SIMD128-NEXT:    i32.const $push84=, 7
; SIMD128-NEXT:    i32.and $push62=, $pop61, $pop84
; SIMD128-NEXT:    i32.shl $push64=, $pop63, $pop62
; SIMD128-NEXT:    i8x16.replace_lane $push65=, $pop60, 12, $pop64
; SIMD128-NEXT:    i8x16.extract_lane_u $push68=, $0, 13
; SIMD128-NEXT:    i8x16.extract_lane_u $push66=, $1, 13
; SIMD128-NEXT:    i32.const $push83=, 7
; SIMD128-NEXT:    i32.and $push67=, $pop66, $pop83
; SIMD128-NEXT:    i32.shl $push69=, $pop68, $pop67
; SIMD128-NEXT:    i8x16.replace_lane $push70=, $pop65, 13, $pop69
; SIMD128-NEXT:    i8x16.extract_lane_u $push73=, $0, 14
; SIMD128-NEXT:    i8x16.extract_lane_u $push71=, $1, 14
; SIMD128-NEXT:    i32.const $push82=, 7
; SIMD128-NEXT:    i32.and $push72=, $pop71, $pop82
; SIMD128-NEXT:    i32.shl $push74=, $pop73, $pop72
; SIMD128-NEXT:    i8x16.replace_lane $push75=, $pop70, 14, $pop74
; SIMD128-NEXT:    i8x16.extract_lane_u $push78=, $0, 15
; SIMD128-NEXT:    i8x16.extract_lane_u $push76=, $1, 15
; SIMD128-NEXT:    i32.const $push81=, 7
; SIMD128-NEXT:    i32.and $push77=, $pop76, $pop81
; SIMD128-NEXT:    i32.shl $push79=, $pop78, $pop77
; SIMD128-NEXT:    i8x16.replace_lane $push80=, $pop75, 15, $pop79
; SIMD128-NEXT:    return $pop80
;
; SIMD128-FAST-LABEL: shl_vec_v16i8:
; SIMD128-FAST:         .functype shl_vec_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push8=, $0, 0
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push6=, $1, 0
; SIMD128-FAST-NEXT:    i32.const $push2=, 7
; SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop2
; SIMD128-FAST-NEXT:    i32.shl $push9=, $pop8, $pop7
; SIMD128-FAST-NEXT:    i8x16.splat $push10=, $pop9
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push4=, $0, 1
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.const $push95=, 7
; SIMD128-FAST-NEXT:    i32.and $push3=, $pop1, $pop95
; SIMD128-FAST-NEXT:    i32.shl $push5=, $pop4, $pop3
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push11=, $pop10, 1, $pop5
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push14=, $0, 2
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push12=, $1, 2
; SIMD128-FAST-NEXT:    i32.const $push94=, 7
; SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $pop94
; SIMD128-FAST-NEXT:    i32.shl $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push16=, $pop11, 2, $pop15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push19=, $0, 3
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push17=, $1, 3
; SIMD128-FAST-NEXT:    i32.const $push93=, 7
; SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop93
; SIMD128-FAST-NEXT:    i32.shl $push20=, $pop19, $pop18
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push21=, $pop16, 3, $pop20
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push24=, $0, 4
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push22=, $1, 4
; SIMD128-FAST-NEXT:    i32.const $push92=, 7
; SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop92
; SIMD128-FAST-NEXT:    i32.shl $push25=, $pop24, $pop23
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push26=, $pop21, 4, $pop25
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push29=, $0, 5
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push27=, $1, 5
; SIMD128-FAST-NEXT:    i32.const $push91=, 7
; SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop91
; SIMD128-FAST-NEXT:    i32.shl $push30=, $pop29, $pop28
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push31=, $pop26, 5, $pop30
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push34=, $0, 6
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push32=, $1, 6
; SIMD128-FAST-NEXT:    i32.const $push90=, 7
; SIMD128-FAST-NEXT:    i32.and $push33=, $pop32, $pop90
; SIMD128-FAST-NEXT:    i32.shl $push35=, $pop34, $pop33
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push36=, $pop31, 6, $pop35
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push39=, $0, 7
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push37=, $1, 7
; SIMD128-FAST-NEXT:    i32.const $push89=, 7
; SIMD128-FAST-NEXT:    i32.and $push38=, $pop37, $pop89
; SIMD128-FAST-NEXT:    i32.shl $push40=, $pop39, $pop38
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push41=, $pop36, 7, $pop40
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push44=, $0, 8
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push42=, $1, 8
; SIMD128-FAST-NEXT:    i32.const $push88=, 7
; SIMD128-FAST-NEXT:    i32.and $push43=, $pop42, $pop88
; SIMD128-FAST-NEXT:    i32.shl $push45=, $pop44, $pop43
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push46=, $pop41, 8, $pop45
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push49=, $0, 9
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push47=, $1, 9
; SIMD128-FAST-NEXT:    i32.const $push87=, 7
; SIMD128-FAST-NEXT:    i32.and $push48=, $pop47, $pop87
; SIMD128-FAST-NEXT:    i32.shl $push50=, $pop49, $pop48
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push51=, $pop46, 9, $pop50
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push54=, $0, 10
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push52=, $1, 10
; SIMD128-FAST-NEXT:    i32.const $push86=, 7
; SIMD128-FAST-NEXT:    i32.and $push53=, $pop52, $pop86
; SIMD128-FAST-NEXT:    i32.shl $push55=, $pop54, $pop53
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push56=, $pop51, 10, $pop55
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push59=, $0, 11
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push57=, $1, 11
; SIMD128-FAST-NEXT:    i32.const $push85=, 7
; SIMD128-FAST-NEXT:    i32.and $push58=, $pop57, $pop85
; SIMD128-FAST-NEXT:    i32.shl $push60=, $pop59, $pop58
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push61=, $pop56, 11, $pop60
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push64=, $0, 12
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push62=, $1, 12
; SIMD128-FAST-NEXT:    i32.const $push84=, 7
; SIMD128-FAST-NEXT:    i32.and $push63=, $pop62, $pop84
; SIMD128-FAST-NEXT:    i32.shl $push65=, $pop64, $pop63
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push66=, $pop61, 12, $pop65
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push69=, $0, 13
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push67=, $1, 13
; SIMD128-FAST-NEXT:    i32.const $push83=, 7
; SIMD128-FAST-NEXT:    i32.and $push68=, $pop67, $pop83
; SIMD128-FAST-NEXT:    i32.shl $push70=, $pop69, $pop68
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push71=, $pop66, 13, $pop70
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push74=, $0, 14
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push72=, $1, 14
; SIMD128-FAST-NEXT:    i32.const $push82=, 7
; SIMD128-FAST-NEXT:    i32.and $push73=, $pop72, $pop82
; SIMD128-FAST-NEXT:    i32.shl $push75=, $pop74, $pop73
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push76=, $pop71, 14, $pop75
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push79=, $0, 15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push77=, $1, 15
; SIMD128-FAST-NEXT:    i32.const $push81=, 7
; SIMD128-FAST-NEXT:    i32.and $push78=, $pop77, $pop81
; SIMD128-FAST-NEXT:    i32.shl $push80=, $pop79, $pop78
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push0=, $pop76, 15, $pop80
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_vec_v16i8:
; NO-SIMD128:         .functype shl_vec_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $25, $pop0
; NO-SIMD128-NEXT:    i32.shl $push2=, $9, $pop1
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push69=, 255
; NO-SIMD128-NEXT:    i32.and $push3=, $21, $pop69
; NO-SIMD128-NEXT:    i32.shl $push4=, $5, $pop3
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push68=, 255
; NO-SIMD128-NEXT:    i32.and $push5=, $19, $pop68
; NO-SIMD128-NEXT:    i32.shl $push6=, $3, $pop5
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push67=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $18, $pop67
; NO-SIMD128-NEXT:    i32.shl $push8=, $2, $pop7
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push66=, 255
; NO-SIMD128-NEXT:    i32.and $push9=, $17, $pop66
; NO-SIMD128-NEXT:    i32.shl $push10=, $1, $pop9
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push13=, 15
; NO-SIMD128-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-NEXT:    i32.const $push65=, 255
; NO-SIMD128-NEXT:    i32.and $push11=, $32, $pop65
; NO-SIMD128-NEXT:    i32.shl $push12=, $16, $pop11
; NO-SIMD128-NEXT:    i32.store8 0($pop14), $pop12
; NO-SIMD128-NEXT:    i32.const $push17=, 14
; NO-SIMD128-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-NEXT:    i32.const $push64=, 255
; NO-SIMD128-NEXT:    i32.and $push15=, $31, $pop64
; NO-SIMD128-NEXT:    i32.shl $push16=, $15, $pop15
; NO-SIMD128-NEXT:    i32.store8 0($pop18), $pop16
; NO-SIMD128-NEXT:    i32.const $push21=, 13
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.const $push63=, 255
; NO-SIMD128-NEXT:    i32.and $push19=, $30, $pop63
; NO-SIMD128-NEXT:    i32.shl $push20=, $14, $pop19
; NO-SIMD128-NEXT:    i32.store8 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push25=, 12
; NO-SIMD128-NEXT:    i32.add $push26=, $0, $pop25
; NO-SIMD128-NEXT:    i32.const $push62=, 255
; NO-SIMD128-NEXT:    i32.and $push23=, $29, $pop62
; NO-SIMD128-NEXT:    i32.shl $push24=, $13, $pop23
; NO-SIMD128-NEXT:    i32.store8 0($pop26), $pop24
; NO-SIMD128-NEXT:    i32.const $push29=, 11
; NO-SIMD128-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-NEXT:    i32.const $push61=, 255
; NO-SIMD128-NEXT:    i32.and $push27=, $28, $pop61
; NO-SIMD128-NEXT:    i32.shl $push28=, $12, $pop27
; NO-SIMD128-NEXT:    i32.store8 0($pop30), $pop28
; NO-SIMD128-NEXT:    i32.const $push33=, 10
; NO-SIMD128-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-NEXT:    i32.const $push60=, 255
; NO-SIMD128-NEXT:    i32.and $push31=, $27, $pop60
; NO-SIMD128-NEXT:    i32.shl $push32=, $11, $pop31
; NO-SIMD128-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-NEXT:    i32.const $push37=, 9
; NO-SIMD128-NEXT:    i32.add $push38=, $0, $pop37
; NO-SIMD128-NEXT:    i32.const $push59=, 255
; NO-SIMD128-NEXT:    i32.and $push35=, $26, $pop59
; NO-SIMD128-NEXT:    i32.shl $push36=, $10, $pop35
; NO-SIMD128-NEXT:    i32.store8 0($pop38), $pop36
; NO-SIMD128-NEXT:    i32.const $push41=, 7
; NO-SIMD128-NEXT:    i32.add $push42=, $0, $pop41
; NO-SIMD128-NEXT:    i32.const $push58=, 255
; NO-SIMD128-NEXT:    i32.and $push39=, $24, $pop58
; NO-SIMD128-NEXT:    i32.shl $push40=, $8, $pop39
; NO-SIMD128-NEXT:    i32.store8 0($pop42), $pop40
; NO-SIMD128-NEXT:    i32.const $push45=, 6
; NO-SIMD128-NEXT:    i32.add $push46=, $0, $pop45
; NO-SIMD128-NEXT:    i32.const $push57=, 255
; NO-SIMD128-NEXT:    i32.and $push43=, $23, $pop57
; NO-SIMD128-NEXT:    i32.shl $push44=, $7, $pop43
; NO-SIMD128-NEXT:    i32.store8 0($pop46), $pop44
; NO-SIMD128-NEXT:    i32.const $push49=, 5
; NO-SIMD128-NEXT:    i32.add $push50=, $0, $pop49
; NO-SIMD128-NEXT:    i32.const $push56=, 255
; NO-SIMD128-NEXT:    i32.and $push47=, $22, $pop56
; NO-SIMD128-NEXT:    i32.shl $push48=, $6, $pop47
; NO-SIMD128-NEXT:    i32.store8 0($pop50), $pop48
; NO-SIMD128-NEXT:    i32.const $push53=, 3
; NO-SIMD128-NEXT:    i32.add $push54=, $0, $pop53
; NO-SIMD128-NEXT:    i32.const $push55=, 255
; NO-SIMD128-NEXT:    i32.and $push51=, $20, $pop55
; NO-SIMD128-NEXT:    i32.shl $push52=, $4, $pop51
; NO-SIMD128-NEXT:    i32.store8 0($pop54), $pop52
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_vec_v16i8:
; NO-SIMD128-FAST:         .functype shl_vec_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $17, $pop0
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push69=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $18, $pop69
; NO-SIMD128-FAST-NEXT:    i32.shl $push4=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push68=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $19, $pop68
; NO-SIMD128-FAST-NEXT:    i32.shl $push6=, $3, $pop5
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $20, $pop67
; NO-SIMD128-FAST-NEXT:    i32.shl $push10=, $4, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop8), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $21, $pop66
; NO-SIMD128-FAST-NEXT:    i32.shl $push12=, $5, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push65=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $22, $pop65
; NO-SIMD128-FAST-NEXT:    i32.shl $push16=, $6, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop14), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push64=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $23, $pop64
; NO-SIMD128-FAST-NEXT:    i32.shl $push20=, $7, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push63=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $24, $pop63
; NO-SIMD128-FAST-NEXT:    i32.shl $push24=, $8, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop22), $pop24
; NO-SIMD128-FAST-NEXT:    i32.const $push62=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $25, $pop62
; NO-SIMD128-FAST-NEXT:    i32.shl $push26=, $9, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push61=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $26, $pop61
; NO-SIMD128-FAST-NEXT:    i32.shl $push30=, $10, $pop29
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop28), $pop30
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push60=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push33=, $27, $pop60
; NO-SIMD128-FAST-NEXT:    i32.shl $push34=, $11, $pop33
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop32), $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push59=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $28, $pop59
; NO-SIMD128-FAST-NEXT:    i32.shl $push38=, $12, $pop37
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop36), $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-FAST-NEXT:    i32.const $push58=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push41=, $29, $pop58
; NO-SIMD128-FAST-NEXT:    i32.shl $push42=, $13, $pop41
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop40), $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push44=, $0, $pop43
; NO-SIMD128-FAST-NEXT:    i32.const $push57=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push45=, $30, $pop57
; NO-SIMD128-FAST-NEXT:    i32.shl $push46=, $14, $pop45
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop44), $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push48=, $0, $pop47
; NO-SIMD128-FAST-NEXT:    i32.const $push56=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push49=, $31, $pop56
; NO-SIMD128-FAST-NEXT:    i32.shl $push50=, $15, $pop49
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop48), $pop50
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push52=, $0, $pop51
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push53=, $32, $pop55
; NO-SIMD128-FAST-NEXT:    i32.shl $push54=, $16, $pop53
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop52), $pop54
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <16 x i8> %v, %x
  ret <16 x i8> %a
}

define <16 x i8> @shr_s_v16i8(<16 x i8> %v, i8 %x) {
; SIMD128-LABEL: shr_s_v16i8:
; SIMD128:         .functype shr_s_v16i8 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shr_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_s_v16i8:
; SIMD128-FAST:         .functype shr_s_v16i8 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.shr_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_v16i8:
; NO-SIMD128:         .functype shr_s_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend8_s $push1=, $9
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push56=, $17, $pop0
; NO-SIMD128-NEXT:    local.tee $push55=, $17=, $pop56
; NO-SIMD128-NEXT:    i32.shr_s $push2=, $pop1, $pop55
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop2
; NO-SIMD128-NEXT:    i32.extend8_s $push3=, $5
; NO-SIMD128-NEXT:    i32.shr_s $push4=, $pop3, $17
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop4
; NO-SIMD128-NEXT:    i32.extend8_s $push5=, $3
; NO-SIMD128-NEXT:    i32.shr_s $push6=, $pop5, $17
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop6
; NO-SIMD128-NEXT:    i32.extend8_s $push7=, $2
; NO-SIMD128-NEXT:    i32.shr_s $push8=, $pop7, $17
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop8
; NO-SIMD128-NEXT:    i32.extend8_s $push9=, $1
; NO-SIMD128-NEXT:    i32.shr_s $push10=, $pop9, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push13=, 15
; NO-SIMD128-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-NEXT:    i32.extend8_s $push11=, $16
; NO-SIMD128-NEXT:    i32.shr_s $push12=, $pop11, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop14), $pop12
; NO-SIMD128-NEXT:    i32.const $push17=, 14
; NO-SIMD128-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-NEXT:    i32.extend8_s $push15=, $15
; NO-SIMD128-NEXT:    i32.shr_s $push16=, $pop15, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop18), $pop16
; NO-SIMD128-NEXT:    i32.const $push21=, 13
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.extend8_s $push19=, $14
; NO-SIMD128-NEXT:    i32.shr_s $push20=, $pop19, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push25=, 12
; NO-SIMD128-NEXT:    i32.add $push26=, $0, $pop25
; NO-SIMD128-NEXT:    i32.extend8_s $push23=, $13
; NO-SIMD128-NEXT:    i32.shr_s $push24=, $pop23, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop26), $pop24
; NO-SIMD128-NEXT:    i32.const $push29=, 11
; NO-SIMD128-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-NEXT:    i32.extend8_s $push27=, $12
; NO-SIMD128-NEXT:    i32.shr_s $push28=, $pop27, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop30), $pop28
; NO-SIMD128-NEXT:    i32.const $push33=, 10
; NO-SIMD128-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-NEXT:    i32.extend8_s $push31=, $11
; NO-SIMD128-NEXT:    i32.shr_s $push32=, $pop31, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-NEXT:    i32.const $push37=, 9
; NO-SIMD128-NEXT:    i32.add $push38=, $0, $pop37
; NO-SIMD128-NEXT:    i32.extend8_s $push35=, $10
; NO-SIMD128-NEXT:    i32.shr_s $push36=, $pop35, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop38), $pop36
; NO-SIMD128-NEXT:    i32.const $push41=, 7
; NO-SIMD128-NEXT:    i32.add $push42=, $0, $pop41
; NO-SIMD128-NEXT:    i32.extend8_s $push39=, $8
; NO-SIMD128-NEXT:    i32.shr_s $push40=, $pop39, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop42), $pop40
; NO-SIMD128-NEXT:    i32.const $push45=, 6
; NO-SIMD128-NEXT:    i32.add $push46=, $0, $pop45
; NO-SIMD128-NEXT:    i32.extend8_s $push43=, $7
; NO-SIMD128-NEXT:    i32.shr_s $push44=, $pop43, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop46), $pop44
; NO-SIMD128-NEXT:    i32.const $push49=, 5
; NO-SIMD128-NEXT:    i32.add $push50=, $0, $pop49
; NO-SIMD128-NEXT:    i32.extend8_s $push47=, $6
; NO-SIMD128-NEXT:    i32.shr_s $push48=, $pop47, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop50), $pop48
; NO-SIMD128-NEXT:    i32.const $push53=, 3
; NO-SIMD128-NEXT:    i32.add $push54=, $0, $pop53
; NO-SIMD128-NEXT:    i32.extend8_s $push51=, $4
; NO-SIMD128-NEXT:    i32.shr_s $push52=, $pop51, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop54), $pop52
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_v16i8:
; NO-SIMD128-FAST:         .functype shr_s_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push56=, $17, $pop0
; NO-SIMD128-FAST-NEXT:    local.tee $push55=, $1=, $pop56
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push2=, $pop1, $pop55
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push3=, $2
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push4=, $pop3, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push5=, $3
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push6=, $pop5, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push9=, $4
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push10=, $pop9, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop8), $pop10
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push11=, $5
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push12=, $pop11, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push15=, $6
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push16=, $pop15, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop14), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push19=, $7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push20=, $pop19, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push23=, $8
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push24=, $pop23, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop22), $pop24
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push25=, $9
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push26=, $pop25, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push29=, $10
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push30=, $pop29, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop28), $pop30
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push33=, $11
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push34=, $pop33, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop32), $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push37=, $12
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push38=, $pop37, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop36), $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push41=, $13
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push42=, $pop41, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop40), $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push44=, $0, $pop43
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push45=, $14
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push46=, $pop45, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop44), $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push48=, $0, $pop47
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push49=, $15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push50=, $pop49, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop48), $pop50
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push52=, $0, $pop51
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push53=, $16
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push54=, $pop53, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop52), $pop54
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <16 x i8> undef, i8 %x, i32 0
  %s = shufflevector <16 x i8> %t, <16 x i8> undef,
    <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0,
                i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %a = ashr <16 x i8> %v, %s
  ret <16 x i8> %a
}

define <16 x i8> @shr_s_vec_v16i8(<16 x i8> %v, <16 x i8> %x) {
; SIMD128-LABEL: shr_s_vec_v16i8:
; SIMD128:         .functype shr_s_vec_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.extract_lane_s $push7=, $0, 0
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $1, 0
; SIMD128-NEXT:    i32.const $push1=, 7
; SIMD128-NEXT:    i32.and $push6=, $pop5, $pop1
; SIMD128-NEXT:    i32.shr_s $push8=, $pop7, $pop6
; SIMD128-NEXT:    i8x16.splat $push9=, $pop8
; SIMD128-NEXT:    i8x16.extract_lane_s $push3=, $0, 1
; SIMD128-NEXT:    i8x16.extract_lane_u $push0=, $1, 1
; SIMD128-NEXT:    i32.const $push95=, 7
; SIMD128-NEXT:    i32.and $push2=, $pop0, $pop95
; SIMD128-NEXT:    i32.shr_s $push4=, $pop3, $pop2
; SIMD128-NEXT:    i8x16.replace_lane $push10=, $pop9, 1, $pop4
; SIMD128-NEXT:    i8x16.extract_lane_s $push13=, $0, 2
; SIMD128-NEXT:    i8x16.extract_lane_u $push11=, $1, 2
; SIMD128-NEXT:    i32.const $push94=, 7
; SIMD128-NEXT:    i32.and $push12=, $pop11, $pop94
; SIMD128-NEXT:    i32.shr_s $push14=, $pop13, $pop12
; SIMD128-NEXT:    i8x16.replace_lane $push15=, $pop10, 2, $pop14
; SIMD128-NEXT:    i8x16.extract_lane_s $push18=, $0, 3
; SIMD128-NEXT:    i8x16.extract_lane_u $push16=, $1, 3
; SIMD128-NEXT:    i32.const $push93=, 7
; SIMD128-NEXT:    i32.and $push17=, $pop16, $pop93
; SIMD128-NEXT:    i32.shr_s $push19=, $pop18, $pop17
; SIMD128-NEXT:    i8x16.replace_lane $push20=, $pop15, 3, $pop19
; SIMD128-NEXT:    i8x16.extract_lane_s $push23=, $0, 4
; SIMD128-NEXT:    i8x16.extract_lane_u $push21=, $1, 4
; SIMD128-NEXT:    i32.const $push92=, 7
; SIMD128-NEXT:    i32.and $push22=, $pop21, $pop92
; SIMD128-NEXT:    i32.shr_s $push24=, $pop23, $pop22
; SIMD128-NEXT:    i8x16.replace_lane $push25=, $pop20, 4, $pop24
; SIMD128-NEXT:    i8x16.extract_lane_s $push28=, $0, 5
; SIMD128-NEXT:    i8x16.extract_lane_u $push26=, $1, 5
; SIMD128-NEXT:    i32.const $push91=, 7
; SIMD128-NEXT:    i32.and $push27=, $pop26, $pop91
; SIMD128-NEXT:    i32.shr_s $push29=, $pop28, $pop27
; SIMD128-NEXT:    i8x16.replace_lane $push30=, $pop25, 5, $pop29
; SIMD128-NEXT:    i8x16.extract_lane_s $push33=, $0, 6
; SIMD128-NEXT:    i8x16.extract_lane_u $push31=, $1, 6
; SIMD128-NEXT:    i32.const $push90=, 7
; SIMD128-NEXT:    i32.and $push32=, $pop31, $pop90
; SIMD128-NEXT:    i32.shr_s $push34=, $pop33, $pop32
; SIMD128-NEXT:    i8x16.replace_lane $push35=, $pop30, 6, $pop34
; SIMD128-NEXT:    i8x16.extract_lane_s $push38=, $0, 7
; SIMD128-NEXT:    i8x16.extract_lane_u $push36=, $1, 7
; SIMD128-NEXT:    i32.const $push89=, 7
; SIMD128-NEXT:    i32.and $push37=, $pop36, $pop89
; SIMD128-NEXT:    i32.shr_s $push39=, $pop38, $pop37
; SIMD128-NEXT:    i8x16.replace_lane $push40=, $pop35, 7, $pop39
; SIMD128-NEXT:    i8x16.extract_lane_s $push43=, $0, 8
; SIMD128-NEXT:    i8x16.extract_lane_u $push41=, $1, 8
; SIMD128-NEXT:    i32.const $push88=, 7
; SIMD128-NEXT:    i32.and $push42=, $pop41, $pop88
; SIMD128-NEXT:    i32.shr_s $push44=, $pop43, $pop42
; SIMD128-NEXT:    i8x16.replace_lane $push45=, $pop40, 8, $pop44
; SIMD128-NEXT:    i8x16.extract_lane_s $push48=, $0, 9
; SIMD128-NEXT:    i8x16.extract_lane_u $push46=, $1, 9
; SIMD128-NEXT:    i32.const $push87=, 7
; SIMD128-NEXT:    i32.and $push47=, $pop46, $pop87
; SIMD128-NEXT:    i32.shr_s $push49=, $pop48, $pop47
; SIMD128-NEXT:    i8x16.replace_lane $push50=, $pop45, 9, $pop49
; SIMD128-NEXT:    i8x16.extract_lane_s $push53=, $0, 10
; SIMD128-NEXT:    i8x16.extract_lane_u $push51=, $1, 10
; SIMD128-NEXT:    i32.const $push86=, 7
; SIMD128-NEXT:    i32.and $push52=, $pop51, $pop86
; SIMD128-NEXT:    i32.shr_s $push54=, $pop53, $pop52
; SIMD128-NEXT:    i8x16.replace_lane $push55=, $pop50, 10, $pop54
; SIMD128-NEXT:    i8x16.extract_lane_s $push58=, $0, 11
; SIMD128-NEXT:    i8x16.extract_lane_u $push56=, $1, 11
; SIMD128-NEXT:    i32.const $push85=, 7
; SIMD128-NEXT:    i32.and $push57=, $pop56, $pop85
; SIMD128-NEXT:    i32.shr_s $push59=, $pop58, $pop57
; SIMD128-NEXT:    i8x16.replace_lane $push60=, $pop55, 11, $pop59
; SIMD128-NEXT:    i8x16.extract_lane_s $push63=, $0, 12
; SIMD128-NEXT:    i8x16.extract_lane_u $push61=, $1, 12
; SIMD128-NEXT:    i32.const $push84=, 7
; SIMD128-NEXT:    i32.and $push62=, $pop61, $pop84
; SIMD128-NEXT:    i32.shr_s $push64=, $pop63, $pop62
; SIMD128-NEXT:    i8x16.replace_lane $push65=, $pop60, 12, $pop64
; SIMD128-NEXT:    i8x16.extract_lane_s $push68=, $0, 13
; SIMD128-NEXT:    i8x16.extract_lane_u $push66=, $1, 13
; SIMD128-NEXT:    i32.const $push83=, 7
; SIMD128-NEXT:    i32.and $push67=, $pop66, $pop83
; SIMD128-NEXT:    i32.shr_s $push69=, $pop68, $pop67
; SIMD128-NEXT:    i8x16.replace_lane $push70=, $pop65, 13, $pop69
; SIMD128-NEXT:    i8x16.extract_lane_s $push73=, $0, 14
; SIMD128-NEXT:    i8x16.extract_lane_u $push71=, $1, 14
; SIMD128-NEXT:    i32.const $push82=, 7
; SIMD128-NEXT:    i32.and $push72=, $pop71, $pop82
; SIMD128-NEXT:    i32.shr_s $push74=, $pop73, $pop72
; SIMD128-NEXT:    i8x16.replace_lane $push75=, $pop70, 14, $pop74
; SIMD128-NEXT:    i8x16.extract_lane_s $push78=, $0, 15
; SIMD128-NEXT:    i8x16.extract_lane_u $push76=, $1, 15
; SIMD128-NEXT:    i32.const $push81=, 7
; SIMD128-NEXT:    i32.and $push77=, $pop76, $pop81
; SIMD128-NEXT:    i32.shr_s $push79=, $pop78, $pop77
; SIMD128-NEXT:    i8x16.replace_lane $push80=, $pop75, 15, $pop79
; SIMD128-NEXT:    return $pop80
;
; SIMD128-FAST-LABEL: shr_s_vec_v16i8:
; SIMD128-FAST:         .functype shr_s_vec_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push8=, $0, 0
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push6=, $1, 0
; SIMD128-FAST-NEXT:    i32.const $push2=, 7
; SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop2
; SIMD128-FAST-NEXT:    i32.shr_s $push9=, $pop8, $pop7
; SIMD128-FAST-NEXT:    i8x16.splat $push10=, $pop9
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push4=, $0, 1
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.const $push95=, 7
; SIMD128-FAST-NEXT:    i32.and $push3=, $pop1, $pop95
; SIMD128-FAST-NEXT:    i32.shr_s $push5=, $pop4, $pop3
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push11=, $pop10, 1, $pop5
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push14=, $0, 2
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push12=, $1, 2
; SIMD128-FAST-NEXT:    i32.const $push94=, 7
; SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $pop94
; SIMD128-FAST-NEXT:    i32.shr_s $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push16=, $pop11, 2, $pop15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push19=, $0, 3
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push17=, $1, 3
; SIMD128-FAST-NEXT:    i32.const $push93=, 7
; SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop93
; SIMD128-FAST-NEXT:    i32.shr_s $push20=, $pop19, $pop18
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push21=, $pop16, 3, $pop20
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push24=, $0, 4
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push22=, $1, 4
; SIMD128-FAST-NEXT:    i32.const $push92=, 7
; SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop92
; SIMD128-FAST-NEXT:    i32.shr_s $push25=, $pop24, $pop23
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push26=, $pop21, 4, $pop25
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push29=, $0, 5
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push27=, $1, 5
; SIMD128-FAST-NEXT:    i32.const $push91=, 7
; SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop91
; SIMD128-FAST-NEXT:    i32.shr_s $push30=, $pop29, $pop28
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push31=, $pop26, 5, $pop30
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push34=, $0, 6
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push32=, $1, 6
; SIMD128-FAST-NEXT:    i32.const $push90=, 7
; SIMD128-FAST-NEXT:    i32.and $push33=, $pop32, $pop90
; SIMD128-FAST-NEXT:    i32.shr_s $push35=, $pop34, $pop33
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push36=, $pop31, 6, $pop35
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push39=, $0, 7
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push37=, $1, 7
; SIMD128-FAST-NEXT:    i32.const $push89=, 7
; SIMD128-FAST-NEXT:    i32.and $push38=, $pop37, $pop89
; SIMD128-FAST-NEXT:    i32.shr_s $push40=, $pop39, $pop38
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push41=, $pop36, 7, $pop40
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push44=, $0, 8
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push42=, $1, 8
; SIMD128-FAST-NEXT:    i32.const $push88=, 7
; SIMD128-FAST-NEXT:    i32.and $push43=, $pop42, $pop88
; SIMD128-FAST-NEXT:    i32.shr_s $push45=, $pop44, $pop43
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push46=, $pop41, 8, $pop45
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push49=, $0, 9
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push47=, $1, 9
; SIMD128-FAST-NEXT:    i32.const $push87=, 7
; SIMD128-FAST-NEXT:    i32.and $push48=, $pop47, $pop87
; SIMD128-FAST-NEXT:    i32.shr_s $push50=, $pop49, $pop48
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push51=, $pop46, 9, $pop50
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push54=, $0, 10
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push52=, $1, 10
; SIMD128-FAST-NEXT:    i32.const $push86=, 7
; SIMD128-FAST-NEXT:    i32.and $push53=, $pop52, $pop86
; SIMD128-FAST-NEXT:    i32.shr_s $push55=, $pop54, $pop53
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push56=, $pop51, 10, $pop55
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push59=, $0, 11
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push57=, $1, 11
; SIMD128-FAST-NEXT:    i32.const $push85=, 7
; SIMD128-FAST-NEXT:    i32.and $push58=, $pop57, $pop85
; SIMD128-FAST-NEXT:    i32.shr_s $push60=, $pop59, $pop58
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push61=, $pop56, 11, $pop60
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push64=, $0, 12
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push62=, $1, 12
; SIMD128-FAST-NEXT:    i32.const $push84=, 7
; SIMD128-FAST-NEXT:    i32.and $push63=, $pop62, $pop84
; SIMD128-FAST-NEXT:    i32.shr_s $push65=, $pop64, $pop63
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push66=, $pop61, 12, $pop65
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push69=, $0, 13
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push67=, $1, 13
; SIMD128-FAST-NEXT:    i32.const $push83=, 7
; SIMD128-FAST-NEXT:    i32.and $push68=, $pop67, $pop83
; SIMD128-FAST-NEXT:    i32.shr_s $push70=, $pop69, $pop68
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push71=, $pop66, 13, $pop70
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push74=, $0, 14
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push72=, $1, 14
; SIMD128-FAST-NEXT:    i32.const $push82=, 7
; SIMD128-FAST-NEXT:    i32.and $push73=, $pop72, $pop82
; SIMD128-FAST-NEXT:    i32.shr_s $push75=, $pop74, $pop73
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push76=, $pop71, 14, $pop75
; SIMD128-FAST-NEXT:    i8x16.extract_lane_s $push79=, $0, 15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push77=, $1, 15
; SIMD128-FAST-NEXT:    i32.const $push81=, 7
; SIMD128-FAST-NEXT:    i32.and $push78=, $pop77, $pop81
; SIMD128-FAST-NEXT:    i32.shr_s $push80=, $pop79, $pop78
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push0=, $pop76, 15, $pop80
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_vec_v16i8:
; NO-SIMD128:         .functype shr_s_vec_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend8_s $push2=, $9
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $25, $pop0
; NO-SIMD128-NEXT:    i32.shr_s $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop3
; NO-SIMD128-NEXT:    i32.extend8_s $push5=, $5
; NO-SIMD128-NEXT:    i32.const $push85=, 255
; NO-SIMD128-NEXT:    i32.and $push4=, $21, $pop85
; NO-SIMD128-NEXT:    i32.shr_s $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop6
; NO-SIMD128-NEXT:    i32.extend8_s $push8=, $3
; NO-SIMD128-NEXT:    i32.const $push84=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $19, $pop84
; NO-SIMD128-NEXT:    i32.shr_s $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop9
; NO-SIMD128-NEXT:    i32.extend8_s $push11=, $2
; NO-SIMD128-NEXT:    i32.const $push83=, 255
; NO-SIMD128-NEXT:    i32.and $push10=, $18, $pop83
; NO-SIMD128-NEXT:    i32.shr_s $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop12
; NO-SIMD128-NEXT:    i32.extend8_s $push14=, $1
; NO-SIMD128-NEXT:    i32.const $push82=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $17, $pop82
; NO-SIMD128-NEXT:    i32.shr_s $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop15
; NO-SIMD128-NEXT:    i32.const $push19=, 15
; NO-SIMD128-NEXT:    i32.add $push20=, $0, $pop19
; NO-SIMD128-NEXT:    i32.extend8_s $push17=, $16
; NO-SIMD128-NEXT:    i32.const $push81=, 255
; NO-SIMD128-NEXT:    i32.and $push16=, $32, $pop81
; NO-SIMD128-NEXT:    i32.shr_s $push18=, $pop17, $pop16
; NO-SIMD128-NEXT:    i32.store8 0($pop20), $pop18
; NO-SIMD128-NEXT:    i32.const $push24=, 14
; NO-SIMD128-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-NEXT:    i32.extend8_s $push22=, $15
; NO-SIMD128-NEXT:    i32.const $push80=, 255
; NO-SIMD128-NEXT:    i32.and $push21=, $31, $pop80
; NO-SIMD128-NEXT:    i32.shr_s $push23=, $pop22, $pop21
; NO-SIMD128-NEXT:    i32.store8 0($pop25), $pop23
; NO-SIMD128-NEXT:    i32.const $push29=, 13
; NO-SIMD128-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-NEXT:    i32.extend8_s $push27=, $14
; NO-SIMD128-NEXT:    i32.const $push79=, 255
; NO-SIMD128-NEXT:    i32.and $push26=, $30, $pop79
; NO-SIMD128-NEXT:    i32.shr_s $push28=, $pop27, $pop26
; NO-SIMD128-NEXT:    i32.store8 0($pop30), $pop28
; NO-SIMD128-NEXT:    i32.const $push34=, 12
; NO-SIMD128-NEXT:    i32.add $push35=, $0, $pop34
; NO-SIMD128-NEXT:    i32.extend8_s $push32=, $13
; NO-SIMD128-NEXT:    i32.const $push78=, 255
; NO-SIMD128-NEXT:    i32.and $push31=, $29, $pop78
; NO-SIMD128-NEXT:    i32.shr_s $push33=, $pop32, $pop31
; NO-SIMD128-NEXT:    i32.store8 0($pop35), $pop33
; NO-SIMD128-NEXT:    i32.const $push39=, 11
; NO-SIMD128-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-NEXT:    i32.extend8_s $push37=, $12
; NO-SIMD128-NEXT:    i32.const $push77=, 255
; NO-SIMD128-NEXT:    i32.and $push36=, $28, $pop77
; NO-SIMD128-NEXT:    i32.shr_s $push38=, $pop37, $pop36
; NO-SIMD128-NEXT:    i32.store8 0($pop40), $pop38
; NO-SIMD128-NEXT:    i32.const $push44=, 10
; NO-SIMD128-NEXT:    i32.add $push45=, $0, $pop44
; NO-SIMD128-NEXT:    i32.extend8_s $push42=, $11
; NO-SIMD128-NEXT:    i32.const $push76=, 255
; NO-SIMD128-NEXT:    i32.and $push41=, $27, $pop76
; NO-SIMD128-NEXT:    i32.shr_s $push43=, $pop42, $pop41
; NO-SIMD128-NEXT:    i32.store8 0($pop45), $pop43
; NO-SIMD128-NEXT:    i32.const $push49=, 9
; NO-SIMD128-NEXT:    i32.add $push50=, $0, $pop49
; NO-SIMD128-NEXT:    i32.extend8_s $push47=, $10
; NO-SIMD128-NEXT:    i32.const $push75=, 255
; NO-SIMD128-NEXT:    i32.and $push46=, $26, $pop75
; NO-SIMD128-NEXT:    i32.shr_s $push48=, $pop47, $pop46
; NO-SIMD128-NEXT:    i32.store8 0($pop50), $pop48
; NO-SIMD128-NEXT:    i32.const $push54=, 7
; NO-SIMD128-NEXT:    i32.add $push55=, $0, $pop54
; NO-SIMD128-NEXT:    i32.extend8_s $push52=, $8
; NO-SIMD128-NEXT:    i32.const $push74=, 255
; NO-SIMD128-NEXT:    i32.and $push51=, $24, $pop74
; NO-SIMD128-NEXT:    i32.shr_s $push53=, $pop52, $pop51
; NO-SIMD128-NEXT:    i32.store8 0($pop55), $pop53
; NO-SIMD128-NEXT:    i32.const $push59=, 6
; NO-SIMD128-NEXT:    i32.add $push60=, $0, $pop59
; NO-SIMD128-NEXT:    i32.extend8_s $push57=, $7
; NO-SIMD128-NEXT:    i32.const $push73=, 255
; NO-SIMD128-NEXT:    i32.and $push56=, $23, $pop73
; NO-SIMD128-NEXT:    i32.shr_s $push58=, $pop57, $pop56
; NO-SIMD128-NEXT:    i32.store8 0($pop60), $pop58
; NO-SIMD128-NEXT:    i32.const $push64=, 5
; NO-SIMD128-NEXT:    i32.add $push65=, $0, $pop64
; NO-SIMD128-NEXT:    i32.extend8_s $push62=, $6
; NO-SIMD128-NEXT:    i32.const $push72=, 255
; NO-SIMD128-NEXT:    i32.and $push61=, $22, $pop72
; NO-SIMD128-NEXT:    i32.shr_s $push63=, $pop62, $pop61
; NO-SIMD128-NEXT:    i32.store8 0($pop65), $pop63
; NO-SIMD128-NEXT:    i32.const $push69=, 3
; NO-SIMD128-NEXT:    i32.add $push70=, $0, $pop69
; NO-SIMD128-NEXT:    i32.extend8_s $push67=, $4
; NO-SIMD128-NEXT:    i32.const $push71=, 255
; NO-SIMD128-NEXT:    i32.and $push66=, $20, $pop71
; NO-SIMD128-NEXT:    i32.shr_s $push68=, $pop67, $pop66
; NO-SIMD128-NEXT:    i32.store8 0($pop70), $pop68
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_vec_v16i8:
; NO-SIMD128-FAST:         .functype shr_s_vec_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push2=, $1
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $17, $pop0
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push5=, $2
; NO-SIMD128-FAST-NEXT:    i32.const $push85=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $18, $pop85
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push8=, $3
; NO-SIMD128-FAST-NEXT:    i32.const $push84=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $19, $pop84
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push13=, $4
; NO-SIMD128-FAST-NEXT:    i32.const $push83=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $20, $pop83
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop11), $pop14
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push16=, $5
; NO-SIMD128-FAST-NEXT:    i32.const $push82=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $21, $pop82
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push17=, $pop16, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push21=, $6
; NO-SIMD128-FAST-NEXT:    i32.const $push81=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $22, $pop81
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push22=, $pop21, $pop20
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop19), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push26=, $7
; NO-SIMD128-FAST-NEXT:    i32.const $push80=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $23, $pop80
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push27=, $pop26, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop24), $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push28=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push29=, $0, $pop28
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push31=, $8
; NO-SIMD128-FAST-NEXT:    i32.const $push79=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $24, $pop79
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push32=, $pop31, $pop30
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop29), $pop32
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push34=, $9
; NO-SIMD128-FAST-NEXT:    i32.const $push78=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push33=, $25, $pop78
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push35=, $pop34, $pop33
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push39=, $10
; NO-SIMD128-FAST-NEXT:    i32.const $push77=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push38=, $26, $pop77
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push40=, $pop39, $pop38
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop37), $pop40
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push42=, $0, $pop41
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push44=, $11
; NO-SIMD128-FAST-NEXT:    i32.const $push76=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push43=, $27, $pop76
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push45=, $pop44, $pop43
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop42), $pop45
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push47=, $0, $pop46
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push49=, $12
; NO-SIMD128-FAST-NEXT:    i32.const $push75=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push48=, $28, $pop75
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push50=, $pop49, $pop48
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop47), $pop50
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push52=, $0, $pop51
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push54=, $13
; NO-SIMD128-FAST-NEXT:    i32.const $push74=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push53=, $29, $pop74
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push55=, $pop54, $pop53
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop52), $pop55
; NO-SIMD128-FAST-NEXT:    i32.const $push56=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push57=, $0, $pop56
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push59=, $14
; NO-SIMD128-FAST-NEXT:    i32.const $push73=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push58=, $30, $pop73
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push60=, $pop59, $pop58
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop57), $pop60
; NO-SIMD128-FAST-NEXT:    i32.const $push61=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push62=, $0, $pop61
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push64=, $15
; NO-SIMD128-FAST-NEXT:    i32.const $push72=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push63=, $31, $pop72
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push65=, $pop64, $pop63
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop62), $pop65
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push67=, $0, $pop66
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push69=, $16
; NO-SIMD128-FAST-NEXT:    i32.const $push71=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push68=, $32, $pop71
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push70=, $pop69, $pop68
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop67), $pop70
; NO-SIMD128-FAST-NEXT:    return
  %a = ashr <16 x i8> %v, %x
  ret <16 x i8> %a
}

define <16 x i8> @shr_u_v16i8(<16 x i8> %v, i8 %x) {
; SIMD128-LABEL: shr_u_v16i8:
; SIMD128:         .functype shr_u_v16i8 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.shr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_u_v16i8:
; SIMD128-FAST:         .functype shr_u_v16i8 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.shr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_v16i8:
; NO-SIMD128:         .functype shr_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $9, $pop0
; NO-SIMD128-NEXT:    i32.const $push72=, 255
; NO-SIMD128-NEXT:    i32.and $push71=, $17, $pop72
; NO-SIMD128-NEXT:    local.tee $push70=, $17=, $pop71
; NO-SIMD128-NEXT:    i32.shr_u $push2=, $pop1, $pop70
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push69=, 255
; NO-SIMD128-NEXT:    i32.and $push3=, $5, $pop69
; NO-SIMD128-NEXT:    i32.shr_u $push4=, $pop3, $17
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push68=, 255
; NO-SIMD128-NEXT:    i32.and $push5=, $3, $pop68
; NO-SIMD128-NEXT:    i32.shr_u $push6=, $pop5, $17
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push67=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $2, $pop67
; NO-SIMD128-NEXT:    i32.shr_u $push8=, $pop7, $17
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push66=, 255
; NO-SIMD128-NEXT:    i32.and $push9=, $1, $pop66
; NO-SIMD128-NEXT:    i32.shr_u $push10=, $pop9, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push13=, 15
; NO-SIMD128-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-NEXT:    i32.const $push65=, 255
; NO-SIMD128-NEXT:    i32.and $push11=, $16, $pop65
; NO-SIMD128-NEXT:    i32.shr_u $push12=, $pop11, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop14), $pop12
; NO-SIMD128-NEXT:    i32.const $push17=, 14
; NO-SIMD128-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-NEXT:    i32.const $push64=, 255
; NO-SIMD128-NEXT:    i32.and $push15=, $15, $pop64
; NO-SIMD128-NEXT:    i32.shr_u $push16=, $pop15, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop18), $pop16
; NO-SIMD128-NEXT:    i32.const $push21=, 13
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.const $push63=, 255
; NO-SIMD128-NEXT:    i32.and $push19=, $14, $pop63
; NO-SIMD128-NEXT:    i32.shr_u $push20=, $pop19, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push25=, 12
; NO-SIMD128-NEXT:    i32.add $push26=, $0, $pop25
; NO-SIMD128-NEXT:    i32.const $push62=, 255
; NO-SIMD128-NEXT:    i32.and $push23=, $13, $pop62
; NO-SIMD128-NEXT:    i32.shr_u $push24=, $pop23, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop26), $pop24
; NO-SIMD128-NEXT:    i32.const $push29=, 11
; NO-SIMD128-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-NEXT:    i32.const $push61=, 255
; NO-SIMD128-NEXT:    i32.and $push27=, $12, $pop61
; NO-SIMD128-NEXT:    i32.shr_u $push28=, $pop27, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop30), $pop28
; NO-SIMD128-NEXT:    i32.const $push33=, 10
; NO-SIMD128-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-NEXT:    i32.const $push60=, 255
; NO-SIMD128-NEXT:    i32.and $push31=, $11, $pop60
; NO-SIMD128-NEXT:    i32.shr_u $push32=, $pop31, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-NEXT:    i32.const $push37=, 9
; NO-SIMD128-NEXT:    i32.add $push38=, $0, $pop37
; NO-SIMD128-NEXT:    i32.const $push59=, 255
; NO-SIMD128-NEXT:    i32.and $push35=, $10, $pop59
; NO-SIMD128-NEXT:    i32.shr_u $push36=, $pop35, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop38), $pop36
; NO-SIMD128-NEXT:    i32.const $push41=, 7
; NO-SIMD128-NEXT:    i32.add $push42=, $0, $pop41
; NO-SIMD128-NEXT:    i32.const $push58=, 255
; NO-SIMD128-NEXT:    i32.and $push39=, $8, $pop58
; NO-SIMD128-NEXT:    i32.shr_u $push40=, $pop39, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop42), $pop40
; NO-SIMD128-NEXT:    i32.const $push45=, 6
; NO-SIMD128-NEXT:    i32.add $push46=, $0, $pop45
; NO-SIMD128-NEXT:    i32.const $push57=, 255
; NO-SIMD128-NEXT:    i32.and $push43=, $7, $pop57
; NO-SIMD128-NEXT:    i32.shr_u $push44=, $pop43, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop46), $pop44
; NO-SIMD128-NEXT:    i32.const $push49=, 5
; NO-SIMD128-NEXT:    i32.add $push50=, $0, $pop49
; NO-SIMD128-NEXT:    i32.const $push56=, 255
; NO-SIMD128-NEXT:    i32.and $push47=, $6, $pop56
; NO-SIMD128-NEXT:    i32.shr_u $push48=, $pop47, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop50), $pop48
; NO-SIMD128-NEXT:    i32.const $push53=, 3
; NO-SIMD128-NEXT:    i32.add $push54=, $0, $pop53
; NO-SIMD128-NEXT:    i32.const $push55=, 255
; NO-SIMD128-NEXT:    i32.and $push51=, $4, $pop55
; NO-SIMD128-NEXT:    i32.shr_u $push52=, $pop51, $17
; NO-SIMD128-NEXT:    i32.store8 0($pop54), $pop52
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_v16i8:
; NO-SIMD128-FAST:         .functype shr_u_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push72=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push71=, $17, $pop72
; NO-SIMD128-FAST-NEXT:    local.tee $push70=, $1=, $pop71
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push2=, $pop1, $pop70
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push69=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $2, $pop69
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push4=, $pop3, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push68=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $3, $pop68
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push6=, $pop5, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $4, $pop67
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push8=, $pop7, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop10), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $5, $pop66
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push12=, $pop11, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push15=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-FAST-NEXT:    i32.const $push65=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $6, $pop65
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push14=, $pop13, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop16), $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push20=, $0, $pop19
; NO-SIMD128-FAST-NEXT:    i32.const $push64=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $7, $pop64
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push18=, $pop17, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop20), $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-FAST-NEXT:    i32.const $push63=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push21=, $8, $pop63
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push22=, $pop21, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop24), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push62=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $9, $pop62
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push26=, $pop25, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-FAST-NEXT:    i32.const $push61=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push27=, $10, $pop61
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push28=, $pop27, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop30), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-FAST-NEXT:    i32.const $push60=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $11, $pop60
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push32=, $pop31, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push38=, $0, $pop37
; NO-SIMD128-FAST-NEXT:    i32.const $push59=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push35=, $12, $pop59
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push36=, $pop35, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop38), $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push42=, $0, $pop41
; NO-SIMD128-FAST-NEXT:    i32.const $push58=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push39=, $13, $pop58
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push40=, $pop39, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop42), $pop40
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push46=, $0, $pop45
; NO-SIMD128-FAST-NEXT:    i32.const $push57=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push43=, $14, $pop57
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push44=, $pop43, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop46), $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push50=, $0, $pop49
; NO-SIMD128-FAST-NEXT:    i32.const $push56=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push47=, $15, $pop56
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push48=, $pop47, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop50), $pop48
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push54=, $0, $pop53
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push51=, $16, $pop55
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push52=, $pop51, $1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop54), $pop52
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <16 x i8> undef, i8 %x, i32 0
  %s = shufflevector <16 x i8> %t, <16 x i8> undef,
    <16 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0,
                i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %a = lshr <16 x i8> %v, %s
  ret <16 x i8> %a
}

define <16 x i8> @shr_u_vec_v16i8(<16 x i8> %v, <16 x i8> %x) {
; SIMD128-LABEL: shr_u_vec_v16i8:
; SIMD128:         .functype shr_u_vec_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i8x16.extract_lane_u $push7=, $0, 0
; SIMD128-NEXT:    i8x16.extract_lane_u $push5=, $1, 0
; SIMD128-NEXT:    i32.const $push1=, 7
; SIMD128-NEXT:    i32.and $push6=, $pop5, $pop1
; SIMD128-NEXT:    i32.shr_u $push8=, $pop7, $pop6
; SIMD128-NEXT:    i8x16.splat $push9=, $pop8
; SIMD128-NEXT:    i8x16.extract_lane_u $push3=, $0, 1
; SIMD128-NEXT:    i8x16.extract_lane_u $push0=, $1, 1
; SIMD128-NEXT:    i32.const $push95=, 7
; SIMD128-NEXT:    i32.and $push2=, $pop0, $pop95
; SIMD128-NEXT:    i32.shr_u $push4=, $pop3, $pop2
; SIMD128-NEXT:    i8x16.replace_lane $push10=, $pop9, 1, $pop4
; SIMD128-NEXT:    i8x16.extract_lane_u $push13=, $0, 2
; SIMD128-NEXT:    i8x16.extract_lane_u $push11=, $1, 2
; SIMD128-NEXT:    i32.const $push94=, 7
; SIMD128-NEXT:    i32.and $push12=, $pop11, $pop94
; SIMD128-NEXT:    i32.shr_u $push14=, $pop13, $pop12
; SIMD128-NEXT:    i8x16.replace_lane $push15=, $pop10, 2, $pop14
; SIMD128-NEXT:    i8x16.extract_lane_u $push18=, $0, 3
; SIMD128-NEXT:    i8x16.extract_lane_u $push16=, $1, 3
; SIMD128-NEXT:    i32.const $push93=, 7
; SIMD128-NEXT:    i32.and $push17=, $pop16, $pop93
; SIMD128-NEXT:    i32.shr_u $push19=, $pop18, $pop17
; SIMD128-NEXT:    i8x16.replace_lane $push20=, $pop15, 3, $pop19
; SIMD128-NEXT:    i8x16.extract_lane_u $push23=, $0, 4
; SIMD128-NEXT:    i8x16.extract_lane_u $push21=, $1, 4
; SIMD128-NEXT:    i32.const $push92=, 7
; SIMD128-NEXT:    i32.and $push22=, $pop21, $pop92
; SIMD128-NEXT:    i32.shr_u $push24=, $pop23, $pop22
; SIMD128-NEXT:    i8x16.replace_lane $push25=, $pop20, 4, $pop24
; SIMD128-NEXT:    i8x16.extract_lane_u $push28=, $0, 5
; SIMD128-NEXT:    i8x16.extract_lane_u $push26=, $1, 5
; SIMD128-NEXT:    i32.const $push91=, 7
; SIMD128-NEXT:    i32.and $push27=, $pop26, $pop91
; SIMD128-NEXT:    i32.shr_u $push29=, $pop28, $pop27
; SIMD128-NEXT:    i8x16.replace_lane $push30=, $pop25, 5, $pop29
; SIMD128-NEXT:    i8x16.extract_lane_u $push33=, $0, 6
; SIMD128-NEXT:    i8x16.extract_lane_u $push31=, $1, 6
; SIMD128-NEXT:    i32.const $push90=, 7
; SIMD128-NEXT:    i32.and $push32=, $pop31, $pop90
; SIMD128-NEXT:    i32.shr_u $push34=, $pop33, $pop32
; SIMD128-NEXT:    i8x16.replace_lane $push35=, $pop30, 6, $pop34
; SIMD128-NEXT:    i8x16.extract_lane_u $push38=, $0, 7
; SIMD128-NEXT:    i8x16.extract_lane_u $push36=, $1, 7
; SIMD128-NEXT:    i32.const $push89=, 7
; SIMD128-NEXT:    i32.and $push37=, $pop36, $pop89
; SIMD128-NEXT:    i32.shr_u $push39=, $pop38, $pop37
; SIMD128-NEXT:    i8x16.replace_lane $push40=, $pop35, 7, $pop39
; SIMD128-NEXT:    i8x16.extract_lane_u $push43=, $0, 8
; SIMD128-NEXT:    i8x16.extract_lane_u $push41=, $1, 8
; SIMD128-NEXT:    i32.const $push88=, 7
; SIMD128-NEXT:    i32.and $push42=, $pop41, $pop88
; SIMD128-NEXT:    i32.shr_u $push44=, $pop43, $pop42
; SIMD128-NEXT:    i8x16.replace_lane $push45=, $pop40, 8, $pop44
; SIMD128-NEXT:    i8x16.extract_lane_u $push48=, $0, 9
; SIMD128-NEXT:    i8x16.extract_lane_u $push46=, $1, 9
; SIMD128-NEXT:    i32.const $push87=, 7
; SIMD128-NEXT:    i32.and $push47=, $pop46, $pop87
; SIMD128-NEXT:    i32.shr_u $push49=, $pop48, $pop47
; SIMD128-NEXT:    i8x16.replace_lane $push50=, $pop45, 9, $pop49
; SIMD128-NEXT:    i8x16.extract_lane_u $push53=, $0, 10
; SIMD128-NEXT:    i8x16.extract_lane_u $push51=, $1, 10
; SIMD128-NEXT:    i32.const $push86=, 7
; SIMD128-NEXT:    i32.and $push52=, $pop51, $pop86
; SIMD128-NEXT:    i32.shr_u $push54=, $pop53, $pop52
; SIMD128-NEXT:    i8x16.replace_lane $push55=, $pop50, 10, $pop54
; SIMD128-NEXT:    i8x16.extract_lane_u $push58=, $0, 11
; SIMD128-NEXT:    i8x16.extract_lane_u $push56=, $1, 11
; SIMD128-NEXT:    i32.const $push85=, 7
; SIMD128-NEXT:    i32.and $push57=, $pop56, $pop85
; SIMD128-NEXT:    i32.shr_u $push59=, $pop58, $pop57
; SIMD128-NEXT:    i8x16.replace_lane $push60=, $pop55, 11, $pop59
; SIMD128-NEXT:    i8x16.extract_lane_u $push63=, $0, 12
; SIMD128-NEXT:    i8x16.extract_lane_u $push61=, $1, 12
; SIMD128-NEXT:    i32.const $push84=, 7
; SIMD128-NEXT:    i32.and $push62=, $pop61, $pop84
; SIMD128-NEXT:    i32.shr_u $push64=, $pop63, $pop62
; SIMD128-NEXT:    i8x16.replace_lane $push65=, $pop60, 12, $pop64
; SIMD128-NEXT:    i8x16.extract_lane_u $push68=, $0, 13
; SIMD128-NEXT:    i8x16.extract_lane_u $push66=, $1, 13
; SIMD128-NEXT:    i32.const $push83=, 7
; SIMD128-NEXT:    i32.and $push67=, $pop66, $pop83
; SIMD128-NEXT:    i32.shr_u $push69=, $pop68, $pop67
; SIMD128-NEXT:    i8x16.replace_lane $push70=, $pop65, 13, $pop69
; SIMD128-NEXT:    i8x16.extract_lane_u $push73=, $0, 14
; SIMD128-NEXT:    i8x16.extract_lane_u $push71=, $1, 14
; SIMD128-NEXT:    i32.const $push82=, 7
; SIMD128-NEXT:    i32.and $push72=, $pop71, $pop82
; SIMD128-NEXT:    i32.shr_u $push74=, $pop73, $pop72
; SIMD128-NEXT:    i8x16.replace_lane $push75=, $pop70, 14, $pop74
; SIMD128-NEXT:    i8x16.extract_lane_u $push78=, $0, 15
; SIMD128-NEXT:    i8x16.extract_lane_u $push76=, $1, 15
; SIMD128-NEXT:    i32.const $push81=, 7
; SIMD128-NEXT:    i32.and $push77=, $pop76, $pop81
; SIMD128-NEXT:    i32.shr_u $push79=, $pop78, $pop77
; SIMD128-NEXT:    i8x16.replace_lane $push80=, $pop75, 15, $pop79
; SIMD128-NEXT:    return $pop80
;
; SIMD128-FAST-LABEL: shr_u_vec_v16i8:
; SIMD128-FAST:         .functype shr_u_vec_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push8=, $0, 0
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push6=, $1, 0
; SIMD128-FAST-NEXT:    i32.const $push2=, 7
; SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop2
; SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop7
; SIMD128-FAST-NEXT:    i8x16.splat $push10=, $pop9
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push4=, $0, 1
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.const $push95=, 7
; SIMD128-FAST-NEXT:    i32.and $push3=, $pop1, $pop95
; SIMD128-FAST-NEXT:    i32.shr_u $push5=, $pop4, $pop3
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push11=, $pop10, 1, $pop5
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push14=, $0, 2
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push12=, $1, 2
; SIMD128-FAST-NEXT:    i32.const $push94=, 7
; SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $pop94
; SIMD128-FAST-NEXT:    i32.shr_u $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push16=, $pop11, 2, $pop15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push19=, $0, 3
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push17=, $1, 3
; SIMD128-FAST-NEXT:    i32.const $push93=, 7
; SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop93
; SIMD128-FAST-NEXT:    i32.shr_u $push20=, $pop19, $pop18
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push21=, $pop16, 3, $pop20
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push24=, $0, 4
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push22=, $1, 4
; SIMD128-FAST-NEXT:    i32.const $push92=, 7
; SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop92
; SIMD128-FAST-NEXT:    i32.shr_u $push25=, $pop24, $pop23
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push26=, $pop21, 4, $pop25
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push29=, $0, 5
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push27=, $1, 5
; SIMD128-FAST-NEXT:    i32.const $push91=, 7
; SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop91
; SIMD128-FAST-NEXT:    i32.shr_u $push30=, $pop29, $pop28
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push31=, $pop26, 5, $pop30
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push34=, $0, 6
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push32=, $1, 6
; SIMD128-FAST-NEXT:    i32.const $push90=, 7
; SIMD128-FAST-NEXT:    i32.and $push33=, $pop32, $pop90
; SIMD128-FAST-NEXT:    i32.shr_u $push35=, $pop34, $pop33
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push36=, $pop31, 6, $pop35
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push39=, $0, 7
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push37=, $1, 7
; SIMD128-FAST-NEXT:    i32.const $push89=, 7
; SIMD128-FAST-NEXT:    i32.and $push38=, $pop37, $pop89
; SIMD128-FAST-NEXT:    i32.shr_u $push40=, $pop39, $pop38
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push41=, $pop36, 7, $pop40
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push44=, $0, 8
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push42=, $1, 8
; SIMD128-FAST-NEXT:    i32.const $push88=, 7
; SIMD128-FAST-NEXT:    i32.and $push43=, $pop42, $pop88
; SIMD128-FAST-NEXT:    i32.shr_u $push45=, $pop44, $pop43
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push46=, $pop41, 8, $pop45
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push49=, $0, 9
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push47=, $1, 9
; SIMD128-FAST-NEXT:    i32.const $push87=, 7
; SIMD128-FAST-NEXT:    i32.and $push48=, $pop47, $pop87
; SIMD128-FAST-NEXT:    i32.shr_u $push50=, $pop49, $pop48
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push51=, $pop46, 9, $pop50
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push54=, $0, 10
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push52=, $1, 10
; SIMD128-FAST-NEXT:    i32.const $push86=, 7
; SIMD128-FAST-NEXT:    i32.and $push53=, $pop52, $pop86
; SIMD128-FAST-NEXT:    i32.shr_u $push55=, $pop54, $pop53
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push56=, $pop51, 10, $pop55
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push59=, $0, 11
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push57=, $1, 11
; SIMD128-FAST-NEXT:    i32.const $push85=, 7
; SIMD128-FAST-NEXT:    i32.and $push58=, $pop57, $pop85
; SIMD128-FAST-NEXT:    i32.shr_u $push60=, $pop59, $pop58
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push61=, $pop56, 11, $pop60
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push64=, $0, 12
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push62=, $1, 12
; SIMD128-FAST-NEXT:    i32.const $push84=, 7
; SIMD128-FAST-NEXT:    i32.and $push63=, $pop62, $pop84
; SIMD128-FAST-NEXT:    i32.shr_u $push65=, $pop64, $pop63
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push66=, $pop61, 12, $pop65
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push69=, $0, 13
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push67=, $1, 13
; SIMD128-FAST-NEXT:    i32.const $push83=, 7
; SIMD128-FAST-NEXT:    i32.and $push68=, $pop67, $pop83
; SIMD128-FAST-NEXT:    i32.shr_u $push70=, $pop69, $pop68
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push71=, $pop66, 13, $pop70
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push74=, $0, 14
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push72=, $1, 14
; SIMD128-FAST-NEXT:    i32.const $push82=, 7
; SIMD128-FAST-NEXT:    i32.and $push73=, $pop72, $pop82
; SIMD128-FAST-NEXT:    i32.shr_u $push75=, $pop74, $pop73
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push76=, $pop71, 14, $pop75
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push79=, $0, 15
; SIMD128-FAST-NEXT:    i8x16.extract_lane_u $push77=, $1, 15
; SIMD128-FAST-NEXT:    i32.const $push81=, 7
; SIMD128-FAST-NEXT:    i32.and $push78=, $pop77, $pop81
; SIMD128-FAST-NEXT:    i32.shr_u $push80=, $pop79, $pop78
; SIMD128-FAST-NEXT:    i8x16.replace_lane $push0=, $pop76, 15, $pop80
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_vec_v16i8:
; NO-SIMD128:         .functype shr_u_vec_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push2=, $9, $pop0
; NO-SIMD128-NEXT:    i32.const $push101=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $25, $pop101
; NO-SIMD128-NEXT:    i32.shr_u $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push100=, 255
; NO-SIMD128-NEXT:    i32.and $push5=, $5, $pop100
; NO-SIMD128-NEXT:    i32.const $push99=, 255
; NO-SIMD128-NEXT:    i32.and $push4=, $21, $pop99
; NO-SIMD128-NEXT:    i32.shr_u $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push98=, 255
; NO-SIMD128-NEXT:    i32.and $push8=, $3, $pop98
; NO-SIMD128-NEXT:    i32.const $push97=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $19, $pop97
; NO-SIMD128-NEXT:    i32.shr_u $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push96=, 255
; NO-SIMD128-NEXT:    i32.and $push11=, $2, $pop96
; NO-SIMD128-NEXT:    i32.const $push95=, 255
; NO-SIMD128-NEXT:    i32.and $push10=, $18, $pop95
; NO-SIMD128-NEXT:    i32.shr_u $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push94=, 255
; NO-SIMD128-NEXT:    i32.and $push14=, $1, $pop94
; NO-SIMD128-NEXT:    i32.const $push93=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $17, $pop93
; NO-SIMD128-NEXT:    i32.shr_u $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop15
; NO-SIMD128-NEXT:    i32.const $push19=, 15
; NO-SIMD128-NEXT:    i32.add $push20=, $0, $pop19
; NO-SIMD128-NEXT:    i32.const $push92=, 255
; NO-SIMD128-NEXT:    i32.and $push17=, $16, $pop92
; NO-SIMD128-NEXT:    i32.const $push91=, 255
; NO-SIMD128-NEXT:    i32.and $push16=, $32, $pop91
; NO-SIMD128-NEXT:    i32.shr_u $push18=, $pop17, $pop16
; NO-SIMD128-NEXT:    i32.store8 0($pop20), $pop18
; NO-SIMD128-NEXT:    i32.const $push24=, 14
; NO-SIMD128-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-NEXT:    i32.const $push90=, 255
; NO-SIMD128-NEXT:    i32.and $push22=, $15, $pop90
; NO-SIMD128-NEXT:    i32.const $push89=, 255
; NO-SIMD128-NEXT:    i32.and $push21=, $31, $pop89
; NO-SIMD128-NEXT:    i32.shr_u $push23=, $pop22, $pop21
; NO-SIMD128-NEXT:    i32.store8 0($pop25), $pop23
; NO-SIMD128-NEXT:    i32.const $push29=, 13
; NO-SIMD128-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-NEXT:    i32.const $push88=, 255
; NO-SIMD128-NEXT:    i32.and $push27=, $14, $pop88
; NO-SIMD128-NEXT:    i32.const $push87=, 255
; NO-SIMD128-NEXT:    i32.and $push26=, $30, $pop87
; NO-SIMD128-NEXT:    i32.shr_u $push28=, $pop27, $pop26
; NO-SIMD128-NEXT:    i32.store8 0($pop30), $pop28
; NO-SIMD128-NEXT:    i32.const $push34=, 12
; NO-SIMD128-NEXT:    i32.add $push35=, $0, $pop34
; NO-SIMD128-NEXT:    i32.const $push86=, 255
; NO-SIMD128-NEXT:    i32.and $push32=, $13, $pop86
; NO-SIMD128-NEXT:    i32.const $push85=, 255
; NO-SIMD128-NEXT:    i32.and $push31=, $29, $pop85
; NO-SIMD128-NEXT:    i32.shr_u $push33=, $pop32, $pop31
; NO-SIMD128-NEXT:    i32.store8 0($pop35), $pop33
; NO-SIMD128-NEXT:    i32.const $push39=, 11
; NO-SIMD128-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-NEXT:    i32.const $push84=, 255
; NO-SIMD128-NEXT:    i32.and $push37=, $12, $pop84
; NO-SIMD128-NEXT:    i32.const $push83=, 255
; NO-SIMD128-NEXT:    i32.and $push36=, $28, $pop83
; NO-SIMD128-NEXT:    i32.shr_u $push38=, $pop37, $pop36
; NO-SIMD128-NEXT:    i32.store8 0($pop40), $pop38
; NO-SIMD128-NEXT:    i32.const $push44=, 10
; NO-SIMD128-NEXT:    i32.add $push45=, $0, $pop44
; NO-SIMD128-NEXT:    i32.const $push82=, 255
; NO-SIMD128-NEXT:    i32.and $push42=, $11, $pop82
; NO-SIMD128-NEXT:    i32.const $push81=, 255
; NO-SIMD128-NEXT:    i32.and $push41=, $27, $pop81
; NO-SIMD128-NEXT:    i32.shr_u $push43=, $pop42, $pop41
; NO-SIMD128-NEXT:    i32.store8 0($pop45), $pop43
; NO-SIMD128-NEXT:    i32.const $push49=, 9
; NO-SIMD128-NEXT:    i32.add $push50=, $0, $pop49
; NO-SIMD128-NEXT:    i32.const $push80=, 255
; NO-SIMD128-NEXT:    i32.and $push47=, $10, $pop80
; NO-SIMD128-NEXT:    i32.const $push79=, 255
; NO-SIMD128-NEXT:    i32.and $push46=, $26, $pop79
; NO-SIMD128-NEXT:    i32.shr_u $push48=, $pop47, $pop46
; NO-SIMD128-NEXT:    i32.store8 0($pop50), $pop48
; NO-SIMD128-NEXT:    i32.const $push54=, 7
; NO-SIMD128-NEXT:    i32.add $push55=, $0, $pop54
; NO-SIMD128-NEXT:    i32.const $push78=, 255
; NO-SIMD128-NEXT:    i32.and $push52=, $8, $pop78
; NO-SIMD128-NEXT:    i32.const $push77=, 255
; NO-SIMD128-NEXT:    i32.and $push51=, $24, $pop77
; NO-SIMD128-NEXT:    i32.shr_u $push53=, $pop52, $pop51
; NO-SIMD128-NEXT:    i32.store8 0($pop55), $pop53
; NO-SIMD128-NEXT:    i32.const $push59=, 6
; NO-SIMD128-NEXT:    i32.add $push60=, $0, $pop59
; NO-SIMD128-NEXT:    i32.const $push76=, 255
; NO-SIMD128-NEXT:    i32.and $push57=, $7, $pop76
; NO-SIMD128-NEXT:    i32.const $push75=, 255
; NO-SIMD128-NEXT:    i32.and $push56=, $23, $pop75
; NO-SIMD128-NEXT:    i32.shr_u $push58=, $pop57, $pop56
; NO-SIMD128-NEXT:    i32.store8 0($pop60), $pop58
; NO-SIMD128-NEXT:    i32.const $push64=, 5
; NO-SIMD128-NEXT:    i32.add $push65=, $0, $pop64
; NO-SIMD128-NEXT:    i32.const $push74=, 255
; NO-SIMD128-NEXT:    i32.and $push62=, $6, $pop74
; NO-SIMD128-NEXT:    i32.const $push73=, 255
; NO-SIMD128-NEXT:    i32.and $push61=, $22, $pop73
; NO-SIMD128-NEXT:    i32.shr_u $push63=, $pop62, $pop61
; NO-SIMD128-NEXT:    i32.store8 0($pop65), $pop63
; NO-SIMD128-NEXT:    i32.const $push69=, 3
; NO-SIMD128-NEXT:    i32.add $push70=, $0, $pop69
; NO-SIMD128-NEXT:    i32.const $push72=, 255
; NO-SIMD128-NEXT:    i32.and $push67=, $4, $pop72
; NO-SIMD128-NEXT:    i32.const $push71=, 255
; NO-SIMD128-NEXT:    i32.and $push66=, $20, $pop71
; NO-SIMD128-NEXT:    i32.shr_u $push68=, $pop67, $pop66
; NO-SIMD128-NEXT:    i32.store8 0($pop70), $pop68
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_vec_v16i8:
; NO-SIMD128-FAST:         .functype shr_u_vec_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push101=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $17, $pop101
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push100=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $2, $pop100
; NO-SIMD128-FAST-NEXT:    i32.const $push99=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $18, $pop99
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push98=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $3, $pop98
; NO-SIMD128-FAST-NEXT:    i32.const $push97=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $19, $pop97
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push96=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $4, $pop96
; NO-SIMD128-FAST-NEXT:    i32.const $push95=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $20, $pop95
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop14), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push94=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $5, $pop94
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $21, $pop93
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push17=, $pop16, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push92=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $6, $pop92
; NO-SIMD128-FAST-NEXT:    i32.const $push91=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $22, $pop91
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push20=, $pop19, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop22), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $7, $pop90
; NO-SIMD128-FAST-NEXT:    i32.const $push89=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $23, $pop89
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push25=, $pop24, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop27), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push88=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $8, $pop88
; NO-SIMD128-FAST-NEXT:    i32.const $push87=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $24, $pop87
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop32), $pop30
; NO-SIMD128-FAST-NEXT:    i32.const $push86=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $9, $pop86
; NO-SIMD128-FAST-NEXT:    i32.const $push85=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push33=, $25, $pop85
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push35=, $pop34, $pop33
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-FAST-NEXT:    i32.const $push84=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $10, $pop84
; NO-SIMD128-FAST-NEXT:    i32.const $push83=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push36=, $26, $pop83
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push38=, $pop37, $pop36
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop40), $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push45=, $0, $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push82=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push42=, $11, $pop82
; NO-SIMD128-FAST-NEXT:    i32.const $push81=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push41=, $27, $pop81
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push43=, $pop42, $pop41
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop45), $pop43
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push50=, $0, $pop49
; NO-SIMD128-FAST-NEXT:    i32.const $push80=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push47=, $12, $pop80
; NO-SIMD128-FAST-NEXT:    i32.const $push79=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push46=, $28, $pop79
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push48=, $pop47, $pop46
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop50), $pop48
; NO-SIMD128-FAST-NEXT:    i32.const $push54=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push55=, $0, $pop54
; NO-SIMD128-FAST-NEXT:    i32.const $push78=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push52=, $13, $pop78
; NO-SIMD128-FAST-NEXT:    i32.const $push77=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push51=, $29, $pop77
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push53=, $pop52, $pop51
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop55), $pop53
; NO-SIMD128-FAST-NEXT:    i32.const $push59=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push60=, $0, $pop59
; NO-SIMD128-FAST-NEXT:    i32.const $push76=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push57=, $14, $pop76
; NO-SIMD128-FAST-NEXT:    i32.const $push75=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push56=, $30, $pop75
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push58=, $pop57, $pop56
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop60), $pop58
; NO-SIMD128-FAST-NEXT:    i32.const $push64=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push65=, $0, $pop64
; NO-SIMD128-FAST-NEXT:    i32.const $push74=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push62=, $15, $pop74
; NO-SIMD128-FAST-NEXT:    i32.const $push73=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push61=, $31, $pop73
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push63=, $pop62, $pop61
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop65), $pop63
; NO-SIMD128-FAST-NEXT:    i32.const $push69=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push70=, $0, $pop69
; NO-SIMD128-FAST-NEXT:    i32.const $push72=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push67=, $16, $pop72
; NO-SIMD128-FAST-NEXT:    i32.const $push71=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push66=, $32, $pop71
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push68=, $pop67, $pop66
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop70), $pop68
; NO-SIMD128-FAST-NEXT:    return
  %a = lshr <16 x i8> %v, %x
  ret <16 x i8> %a
}

define <16 x i8> @and_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: and_v16i8:
; SIMD128:         .functype and_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.and $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: and_v16i8:
; SIMD128-FAST:         .functype and_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.and $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: and_v16i8:
; NO-SIMD128:         .functype and_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.and $push0=, $9, $25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop0
; NO-SIMD128-NEXT:    i32.and $push1=, $5, $21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop1
; NO-SIMD128-NEXT:    i32.and $push2=, $3, $19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-NEXT:    i32.and $push3=, $2, $18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop3
; NO-SIMD128-NEXT:    i32.and $push4=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push6=, 15
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.and $push5=, $16, $32
; NO-SIMD128-NEXT:    i32.store8 0($pop7), $pop5
; NO-SIMD128-NEXT:    i32.const $push9=, 14
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    i32.and $push8=, $15, $31
; NO-SIMD128-NEXT:    i32.store8 0($pop10), $pop8
; NO-SIMD128-NEXT:    i32.const $push12=, 13
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.and $push11=, $14, $30
; NO-SIMD128-NEXT:    i32.store8 0($pop13), $pop11
; NO-SIMD128-NEXT:    i32.const $push15=, 12
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.and $push14=, $13, $29
; NO-SIMD128-NEXT:    i32.store8 0($pop16), $pop14
; NO-SIMD128-NEXT:    i32.const $push18=, 11
; NO-SIMD128-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-NEXT:    i32.and $push17=, $12, $28
; NO-SIMD128-NEXT:    i32.store8 0($pop19), $pop17
; NO-SIMD128-NEXT:    i32.const $push21=, 10
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.and $push20=, $11, $27
; NO-SIMD128-NEXT:    i32.store8 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push24=, 9
; NO-SIMD128-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-NEXT:    i32.and $push23=, $10, $26
; NO-SIMD128-NEXT:    i32.store8 0($pop25), $pop23
; NO-SIMD128-NEXT:    i32.const $push27=, 7
; NO-SIMD128-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-NEXT:    i32.and $push26=, $8, $24
; NO-SIMD128-NEXT:    i32.store8 0($pop28), $pop26
; NO-SIMD128-NEXT:    i32.const $push30=, 6
; NO-SIMD128-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-NEXT:    i32.and $push29=, $7, $23
; NO-SIMD128-NEXT:    i32.store8 0($pop31), $pop29
; NO-SIMD128-NEXT:    i32.const $push33=, 5
; NO-SIMD128-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-NEXT:    i32.and $push32=, $6, $22
; NO-SIMD128-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-NEXT:    i32.const $push36=, 3
; NO-SIMD128-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-NEXT:    i32.and $push35=, $4, $20
; NO-SIMD128-NEXT:    i32.store8 0($pop37), $pop35
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: and_v16i8:
; NO-SIMD128-FAST:         .functype and_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.and $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop8), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop11), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop14), $pop15
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop19
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop21), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop24), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop27), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop30), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $0, $pop32
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop33), $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop36), $pop37
; NO-SIMD128-FAST-NEXT:    return
  %a = and <16 x i8> %x, %y
  ret <16 x i8> %a
}

define <16 x i8> @or_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: or_v16i8:
; SIMD128:         .functype or_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.or $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: or_v16i8:
; SIMD128-FAST:         .functype or_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.or $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: or_v16i8:
; NO-SIMD128:         .functype or_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.or $push0=, $9, $25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop0
; NO-SIMD128-NEXT:    i32.or $push1=, $5, $21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop1
; NO-SIMD128-NEXT:    i32.or $push2=, $3, $19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-NEXT:    i32.or $push3=, $2, $18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop3
; NO-SIMD128-NEXT:    i32.or $push4=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push6=, 15
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.or $push5=, $16, $32
; NO-SIMD128-NEXT:    i32.store8 0($pop7), $pop5
; NO-SIMD128-NEXT:    i32.const $push9=, 14
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    i32.or $push8=, $15, $31
; NO-SIMD128-NEXT:    i32.store8 0($pop10), $pop8
; NO-SIMD128-NEXT:    i32.const $push12=, 13
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.or $push11=, $14, $30
; NO-SIMD128-NEXT:    i32.store8 0($pop13), $pop11
; NO-SIMD128-NEXT:    i32.const $push15=, 12
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.or $push14=, $13, $29
; NO-SIMD128-NEXT:    i32.store8 0($pop16), $pop14
; NO-SIMD128-NEXT:    i32.const $push18=, 11
; NO-SIMD128-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-NEXT:    i32.or $push17=, $12, $28
; NO-SIMD128-NEXT:    i32.store8 0($pop19), $pop17
; NO-SIMD128-NEXT:    i32.const $push21=, 10
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.or $push20=, $11, $27
; NO-SIMD128-NEXT:    i32.store8 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push24=, 9
; NO-SIMD128-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-NEXT:    i32.or $push23=, $10, $26
; NO-SIMD128-NEXT:    i32.store8 0($pop25), $pop23
; NO-SIMD128-NEXT:    i32.const $push27=, 7
; NO-SIMD128-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-NEXT:    i32.or $push26=, $8, $24
; NO-SIMD128-NEXT:    i32.store8 0($pop28), $pop26
; NO-SIMD128-NEXT:    i32.const $push30=, 6
; NO-SIMD128-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-NEXT:    i32.or $push29=, $7, $23
; NO-SIMD128-NEXT:    i32.store8 0($pop31), $pop29
; NO-SIMD128-NEXT:    i32.const $push33=, 5
; NO-SIMD128-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-NEXT:    i32.or $push32=, $6, $22
; NO-SIMD128-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-NEXT:    i32.const $push36=, 3
; NO-SIMD128-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-NEXT:    i32.or $push35=, $4, $20
; NO-SIMD128-NEXT:    i32.store8 0($pop37), $pop35
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: or_v16i8:
; NO-SIMD128-FAST:         .functype or_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.or $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.or $push1=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.or $push2=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.or $push5=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    i32.or $push6=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.or $push9=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop8), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.or $push12=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop11), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.or $push15=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop14), $pop15
; NO-SIMD128-FAST-NEXT:    i32.or $push16=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.or $push19=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop19
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-FAST-NEXT:    i32.or $push22=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop21), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-FAST-NEXT:    i32.or $push25=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop24), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.or $push28=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop27), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-FAST-NEXT:    i32.or $push31=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop30), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $0, $pop32
; NO-SIMD128-FAST-NEXT:    i32.or $push34=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop33), $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-FAST-NEXT:    i32.or $push37=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop36), $pop37
; NO-SIMD128-FAST-NEXT:    return
  %a = or <16 x i8> %x, %y
  ret <16 x i8> %a
}

define <16 x i8> @xor_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: xor_v16i8:
; SIMD128:         .functype xor_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: xor_v16i8:
; SIMD128-FAST:         .functype xor_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: xor_v16i8:
; NO-SIMD128:         .functype xor_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push0=, $9, $25
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop0
; NO-SIMD128-NEXT:    i32.xor $push1=, $5, $21
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop1
; NO-SIMD128-NEXT:    i32.xor $push2=, $3, $19
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-NEXT:    i32.xor $push3=, $2, $18
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop3
; NO-SIMD128-NEXT:    i32.xor $push4=, $1, $17
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push6=, 15
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.xor $push5=, $16, $32
; NO-SIMD128-NEXT:    i32.store8 0($pop7), $pop5
; NO-SIMD128-NEXT:    i32.const $push9=, 14
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    i32.xor $push8=, $15, $31
; NO-SIMD128-NEXT:    i32.store8 0($pop10), $pop8
; NO-SIMD128-NEXT:    i32.const $push12=, 13
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.xor $push11=, $14, $30
; NO-SIMD128-NEXT:    i32.store8 0($pop13), $pop11
; NO-SIMD128-NEXT:    i32.const $push15=, 12
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.xor $push14=, $13, $29
; NO-SIMD128-NEXT:    i32.store8 0($pop16), $pop14
; NO-SIMD128-NEXT:    i32.const $push18=, 11
; NO-SIMD128-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-NEXT:    i32.xor $push17=, $12, $28
; NO-SIMD128-NEXT:    i32.store8 0($pop19), $pop17
; NO-SIMD128-NEXT:    i32.const $push21=, 10
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.xor $push20=, $11, $27
; NO-SIMD128-NEXT:    i32.store8 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push24=, 9
; NO-SIMD128-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-NEXT:    i32.xor $push23=, $10, $26
; NO-SIMD128-NEXT:    i32.store8 0($pop25), $pop23
; NO-SIMD128-NEXT:    i32.const $push27=, 7
; NO-SIMD128-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-NEXT:    i32.xor $push26=, $8, $24
; NO-SIMD128-NEXT:    i32.store8 0($pop28), $pop26
; NO-SIMD128-NEXT:    i32.const $push30=, 6
; NO-SIMD128-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-NEXT:    i32.xor $push29=, $7, $23
; NO-SIMD128-NEXT:    i32.store8 0($pop31), $pop29
; NO-SIMD128-NEXT:    i32.const $push33=, 5
; NO-SIMD128-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-NEXT:    i32.xor $push32=, $6, $22
; NO-SIMD128-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-NEXT:    i32.const $push36=, 3
; NO-SIMD128-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-NEXT:    i32.xor $push35=, $4, $20
; NO-SIMD128-NEXT:    i32.store8 0($pop37), $pop35
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: xor_v16i8:
; NO-SIMD128-FAST:         .functype xor_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop8), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop11), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.xor $push15=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop14), $pop15
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.xor $push19=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop19
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-FAST-NEXT:    i32.xor $push22=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop21), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-FAST-NEXT:    i32.xor $push25=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop24), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.xor $push28=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop27), $pop28
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-FAST-NEXT:    i32.xor $push31=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop30), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $0, $pop32
; NO-SIMD128-FAST-NEXT:    i32.xor $push34=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop33), $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-FAST-NEXT:    i32.xor $push37=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop36), $pop37
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <16 x i8> %x, %y
  ret <16 x i8> %a
}

define <16 x i8> @not_v16i8(<16 x i8> %x) {
; SIMD128-LABEL: not_v16i8:
; SIMD128:         .functype not_v16i8 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.not $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: not_v16i8:
; SIMD128-FAST:         .functype not_v16i8 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: not_v16i8:
; NO-SIMD128:         .functype not_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $9, $pop0
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push53=, -1
; NO-SIMD128-NEXT:    i32.xor $push2=, $5, $pop53
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push52=, -1
; NO-SIMD128-NEXT:    i32.xor $push3=, $3, $pop52
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push51=, -1
; NO-SIMD128-NEXT:    i32.xor $push4=, $2, $pop51
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push50=, -1
; NO-SIMD128-NEXT:    i32.xor $push5=, $1, $pop50
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push7=, 15
; NO-SIMD128-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-NEXT:    i32.const $push49=, -1
; NO-SIMD128-NEXT:    i32.xor $push6=, $16, $pop49
; NO-SIMD128-NEXT:    i32.store8 0($pop8), $pop6
; NO-SIMD128-NEXT:    i32.const $push10=, 14
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.const $push48=, -1
; NO-SIMD128-NEXT:    i32.xor $push9=, $15, $pop48
; NO-SIMD128-NEXT:    i32.store8 0($pop11), $pop9
; NO-SIMD128-NEXT:    i32.const $push13=, 13
; NO-SIMD128-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-NEXT:    i32.const $push47=, -1
; NO-SIMD128-NEXT:    i32.xor $push12=, $14, $pop47
; NO-SIMD128-NEXT:    i32.store8 0($pop14), $pop12
; NO-SIMD128-NEXT:    i32.const $push16=, 12
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.const $push46=, -1
; NO-SIMD128-NEXT:    i32.xor $push15=, $13, $pop46
; NO-SIMD128-NEXT:    i32.store8 0($pop17), $pop15
; NO-SIMD128-NEXT:    i32.const $push19=, 11
; NO-SIMD128-NEXT:    i32.add $push20=, $0, $pop19
; NO-SIMD128-NEXT:    i32.const $push45=, -1
; NO-SIMD128-NEXT:    i32.xor $push18=, $12, $pop45
; NO-SIMD128-NEXT:    i32.store8 0($pop20), $pop18
; NO-SIMD128-NEXT:    i32.const $push22=, 10
; NO-SIMD128-NEXT:    i32.add $push23=, $0, $pop22
; NO-SIMD128-NEXT:    i32.const $push44=, -1
; NO-SIMD128-NEXT:    i32.xor $push21=, $11, $pop44
; NO-SIMD128-NEXT:    i32.store8 0($pop23), $pop21
; NO-SIMD128-NEXT:    i32.const $push25=, 9
; NO-SIMD128-NEXT:    i32.add $push26=, $0, $pop25
; NO-SIMD128-NEXT:    i32.const $push43=, -1
; NO-SIMD128-NEXT:    i32.xor $push24=, $10, $pop43
; NO-SIMD128-NEXT:    i32.store8 0($pop26), $pop24
; NO-SIMD128-NEXT:    i32.const $push28=, 7
; NO-SIMD128-NEXT:    i32.add $push29=, $0, $pop28
; NO-SIMD128-NEXT:    i32.const $push42=, -1
; NO-SIMD128-NEXT:    i32.xor $push27=, $8, $pop42
; NO-SIMD128-NEXT:    i32.store8 0($pop29), $pop27
; NO-SIMD128-NEXT:    i32.const $push31=, 6
; NO-SIMD128-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-NEXT:    i32.const $push41=, -1
; NO-SIMD128-NEXT:    i32.xor $push30=, $7, $pop41
; NO-SIMD128-NEXT:    i32.store8 0($pop32), $pop30
; NO-SIMD128-NEXT:    i32.const $push34=, 5
; NO-SIMD128-NEXT:    i32.add $push35=, $0, $pop34
; NO-SIMD128-NEXT:    i32.const $push40=, -1
; NO-SIMD128-NEXT:    i32.xor $push33=, $6, $pop40
; NO-SIMD128-NEXT:    i32.store8 0($pop35), $pop33
; NO-SIMD128-NEXT:    i32.const $push37=, 3
; NO-SIMD128-NEXT:    i32.add $push38=, $0, $pop37
; NO-SIMD128-NEXT:    i32.const $push39=, -1
; NO-SIMD128-NEXT:    i32.xor $push36=, $4, $pop39
; NO-SIMD128-NEXT:    i32.store8 0($pop38), $pop36
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: not_v16i8:
; NO-SIMD128-FAST:         .functype not_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $2, $pop53
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $3, $pop52
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $4, $pop51
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop5), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push7=, $5, $pop50
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push10=, $6, $pop49
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop9), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push11=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push48=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $7, $pop48
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop12), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $8, $pop47
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop15), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push17=, $9, $pop46
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push20=, $10, $pop45
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop19), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push23=, $11, $pop44
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop22), $pop23
; NO-SIMD128-FAST-NEXT:    i32.const $push24=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push26=, $12, $pop43
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop25), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $13, $pop42
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop28), $pop29
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push32=, $14, $pop41
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop31), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push35=, $15, $pop40
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop34), $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push38=, $16, $pop39
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop37), $pop38
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <16 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1,
                          i8 -1, i8 -1, i8 -1, i8 -1,
                          i8 -1, i8 -1, i8 -1, i8 -1,
                          i8 -1, i8 -1, i8 -1, i8 -1>
  ret <16 x i8> %a
}

define <16 x i8> @andnot_v16i8(<16 x i8> %x, <16 x i8> %y) {
; SIMD128-LABEL: andnot_v16i8:
; SIMD128:         .functype andnot_v16i8 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.andnot $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: andnot_v16i8:
; SIMD128-FAST:         .functype andnot_v16i8 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $1
; SIMD128-FAST-NEXT:    v128.and $push1=, $0, $pop0
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: andnot_v16i8:
; NO-SIMD128:         .functype andnot_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $25, $pop0
; NO-SIMD128-NEXT:    i32.and $push2=, $9, $pop1
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push69=, -1
; NO-SIMD128-NEXT:    i32.xor $push3=, $21, $pop69
; NO-SIMD128-NEXT:    i32.and $push4=, $5, $pop3
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push68=, -1
; NO-SIMD128-NEXT:    i32.xor $push5=, $19, $pop68
; NO-SIMD128-NEXT:    i32.and $push6=, $3, $pop5
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push67=, -1
; NO-SIMD128-NEXT:    i32.xor $push7=, $18, $pop67
; NO-SIMD128-NEXT:    i32.and $push8=, $2, $pop7
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push66=, -1
; NO-SIMD128-NEXT:    i32.xor $push9=, $17, $pop66
; NO-SIMD128-NEXT:    i32.and $push10=, $1, $pop9
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push13=, 15
; NO-SIMD128-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-NEXT:    i32.const $push65=, -1
; NO-SIMD128-NEXT:    i32.xor $push11=, $32, $pop65
; NO-SIMD128-NEXT:    i32.and $push12=, $16, $pop11
; NO-SIMD128-NEXT:    i32.store8 0($pop14), $pop12
; NO-SIMD128-NEXT:    i32.const $push17=, 14
; NO-SIMD128-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-NEXT:    i32.const $push64=, -1
; NO-SIMD128-NEXT:    i32.xor $push15=, $31, $pop64
; NO-SIMD128-NEXT:    i32.and $push16=, $15, $pop15
; NO-SIMD128-NEXT:    i32.store8 0($pop18), $pop16
; NO-SIMD128-NEXT:    i32.const $push21=, 13
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.const $push63=, -1
; NO-SIMD128-NEXT:    i32.xor $push19=, $30, $pop63
; NO-SIMD128-NEXT:    i32.and $push20=, $14, $pop19
; NO-SIMD128-NEXT:    i32.store8 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push25=, 12
; NO-SIMD128-NEXT:    i32.add $push26=, $0, $pop25
; NO-SIMD128-NEXT:    i32.const $push62=, -1
; NO-SIMD128-NEXT:    i32.xor $push23=, $29, $pop62
; NO-SIMD128-NEXT:    i32.and $push24=, $13, $pop23
; NO-SIMD128-NEXT:    i32.store8 0($pop26), $pop24
; NO-SIMD128-NEXT:    i32.const $push29=, 11
; NO-SIMD128-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-NEXT:    i32.const $push61=, -1
; NO-SIMD128-NEXT:    i32.xor $push27=, $28, $pop61
; NO-SIMD128-NEXT:    i32.and $push28=, $12, $pop27
; NO-SIMD128-NEXT:    i32.store8 0($pop30), $pop28
; NO-SIMD128-NEXT:    i32.const $push33=, 10
; NO-SIMD128-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-NEXT:    i32.const $push60=, -1
; NO-SIMD128-NEXT:    i32.xor $push31=, $27, $pop60
; NO-SIMD128-NEXT:    i32.and $push32=, $11, $pop31
; NO-SIMD128-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-NEXT:    i32.const $push37=, 9
; NO-SIMD128-NEXT:    i32.add $push38=, $0, $pop37
; NO-SIMD128-NEXT:    i32.const $push59=, -1
; NO-SIMD128-NEXT:    i32.xor $push35=, $26, $pop59
; NO-SIMD128-NEXT:    i32.and $push36=, $10, $pop35
; NO-SIMD128-NEXT:    i32.store8 0($pop38), $pop36
; NO-SIMD128-NEXT:    i32.const $push41=, 7
; NO-SIMD128-NEXT:    i32.add $push42=, $0, $pop41
; NO-SIMD128-NEXT:    i32.const $push58=, -1
; NO-SIMD128-NEXT:    i32.xor $push39=, $24, $pop58
; NO-SIMD128-NEXT:    i32.and $push40=, $8, $pop39
; NO-SIMD128-NEXT:    i32.store8 0($pop42), $pop40
; NO-SIMD128-NEXT:    i32.const $push45=, 6
; NO-SIMD128-NEXT:    i32.add $push46=, $0, $pop45
; NO-SIMD128-NEXT:    i32.const $push57=, -1
; NO-SIMD128-NEXT:    i32.xor $push43=, $23, $pop57
; NO-SIMD128-NEXT:    i32.and $push44=, $7, $pop43
; NO-SIMD128-NEXT:    i32.store8 0($pop46), $pop44
; NO-SIMD128-NEXT:    i32.const $push49=, 5
; NO-SIMD128-NEXT:    i32.add $push50=, $0, $pop49
; NO-SIMD128-NEXT:    i32.const $push56=, -1
; NO-SIMD128-NEXT:    i32.xor $push47=, $22, $pop56
; NO-SIMD128-NEXT:    i32.and $push48=, $6, $pop47
; NO-SIMD128-NEXT:    i32.store8 0($pop50), $pop48
; NO-SIMD128-NEXT:    i32.const $push53=, 3
; NO-SIMD128-NEXT:    i32.add $push54=, $0, $pop53
; NO-SIMD128-NEXT:    i32.const $push55=, -1
; NO-SIMD128-NEXT:    i32.xor $push51=, $20, $pop55
; NO-SIMD128-NEXT:    i32.and $push52=, $4, $pop51
; NO-SIMD128-NEXT:    i32.store8 0($pop54), $pop52
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: andnot_v16i8:
; NO-SIMD128-FAST:         .functype andnot_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $17, $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push69=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $18, $pop69
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push68=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $19, $pop68
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $3, $pop5
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $20, $pop67
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $4, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop8), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push66=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $21, $pop66
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $5, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push65=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push15=, $22, $pop65
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $6, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop14), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push64=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push19=, $23, $pop64
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $7, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push63=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push23=, $24, $pop63
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $8, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop22), $pop24
; NO-SIMD128-FAST-NEXT:    i32.const $push62=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push25=, $25, $pop62
; NO-SIMD128-FAST-NEXT:    i32.and $push26=, $9, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push61=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $26, $pop61
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $10, $pop29
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop28), $pop30
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push60=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push33=, $27, $pop60
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $11, $pop33
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop32), $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push59=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push37=, $28, $pop59
; NO-SIMD128-FAST-NEXT:    i32.and $push38=, $12, $pop37
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop36), $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-FAST-NEXT:    i32.const $push58=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push41=, $29, $pop58
; NO-SIMD128-FAST-NEXT:    i32.and $push42=, $13, $pop41
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop40), $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push44=, $0, $pop43
; NO-SIMD128-FAST-NEXT:    i32.const $push57=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push45=, $30, $pop57
; NO-SIMD128-FAST-NEXT:    i32.and $push46=, $14, $pop45
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop44), $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push48=, $0, $pop47
; NO-SIMD128-FAST-NEXT:    i32.const $push56=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push49=, $31, $pop56
; NO-SIMD128-FAST-NEXT:    i32.and $push50=, $15, $pop49
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop48), $pop50
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push52=, $0, $pop51
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push53=, $32, $pop55
; NO-SIMD128-FAST-NEXT:    i32.and $push54=, $16, $pop53
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop52), $pop54
; NO-SIMD128-FAST-NEXT:    return
 %inv_y = xor <16 x i8> %y,
   <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1,
    i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
 %a = and <16 x i8> %x, %inv_y
 ret <16 x i8> %a
}

define <16 x i8> @bitselect_v16i8(<16 x i8> %c, <16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: bitselect_v16i8:
; SIMD128:         .functype bitselect_v16i8 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_v16i8:
; SIMD128-FAST:         .functype bitselect_v16i8 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.and $push0=, $0, $1
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $pop2, $2
; SIMD128-FAST-NEXT:    v128.or $push1=, $pop0, $pop3
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: bitselect_v16i8:
; NO-SIMD128:         .functype bitselect_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push5=, 15
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.and $push0=, $16, $32
; NO-SIMD128-NEXT:    i32.const $push1=, -1
; NO-SIMD128-NEXT:    i32.xor $push2=, $16, $pop1
; NO-SIMD128-NEXT:    i32.and $push3=, $pop2, $48
; NO-SIMD128-NEXT:    i32.or $push4=, $pop0, $pop3
; NO-SIMD128-NEXT:    i32.store8 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push11=, 14
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.and $push7=, $15, $31
; NO-SIMD128-NEXT:    i32.const $push101=, -1
; NO-SIMD128-NEXT:    i32.xor $push8=, $15, $pop101
; NO-SIMD128-NEXT:    i32.and $push9=, $pop8, $47
; NO-SIMD128-NEXT:    i32.or $push10=, $pop7, $pop9
; NO-SIMD128-NEXT:    i32.store8 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push17=, 13
; NO-SIMD128-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-NEXT:    i32.and $push13=, $14, $30
; NO-SIMD128-NEXT:    i32.const $push100=, -1
; NO-SIMD128-NEXT:    i32.xor $push14=, $14, $pop100
; NO-SIMD128-NEXT:    i32.and $push15=, $pop14, $46
; NO-SIMD128-NEXT:    i32.or $push16=, $pop13, $pop15
; NO-SIMD128-NEXT:    i32.store8 0($pop18), $pop16
; NO-SIMD128-NEXT:    i32.const $push23=, 12
; NO-SIMD128-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-NEXT:    i32.and $push19=, $13, $29
; NO-SIMD128-NEXT:    i32.const $push99=, -1
; NO-SIMD128-NEXT:    i32.xor $push20=, $13, $pop99
; NO-SIMD128-NEXT:    i32.and $push21=, $pop20, $45
; NO-SIMD128-NEXT:    i32.or $push22=, $pop19, $pop21
; NO-SIMD128-NEXT:    i32.store8 0($pop24), $pop22
; NO-SIMD128-NEXT:    i32.const $push29=, 11
; NO-SIMD128-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-NEXT:    i32.and $push25=, $12, $28
; NO-SIMD128-NEXT:    i32.const $push98=, -1
; NO-SIMD128-NEXT:    i32.xor $push26=, $12, $pop98
; NO-SIMD128-NEXT:    i32.and $push27=, $pop26, $44
; NO-SIMD128-NEXT:    i32.or $push28=, $pop25, $pop27
; NO-SIMD128-NEXT:    i32.store8 0($pop30), $pop28
; NO-SIMD128-NEXT:    i32.const $push35=, 10
; NO-SIMD128-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-NEXT:    i32.and $push31=, $11, $27
; NO-SIMD128-NEXT:    i32.const $push97=, -1
; NO-SIMD128-NEXT:    i32.xor $push32=, $11, $pop97
; NO-SIMD128-NEXT:    i32.and $push33=, $pop32, $43
; NO-SIMD128-NEXT:    i32.or $push34=, $pop31, $pop33
; NO-SIMD128-NEXT:    i32.store8 0($pop36), $pop34
; NO-SIMD128-NEXT:    i32.const $push41=, 9
; NO-SIMD128-NEXT:    i32.add $push42=, $0, $pop41
; NO-SIMD128-NEXT:    i32.and $push37=, $10, $26
; NO-SIMD128-NEXT:    i32.const $push96=, -1
; NO-SIMD128-NEXT:    i32.xor $push38=, $10, $pop96
; NO-SIMD128-NEXT:    i32.and $push39=, $pop38, $42
; NO-SIMD128-NEXT:    i32.or $push40=, $pop37, $pop39
; NO-SIMD128-NEXT:    i32.store8 0($pop42), $pop40
; NO-SIMD128-NEXT:    i32.and $push43=, $9, $25
; NO-SIMD128-NEXT:    i32.const $push95=, -1
; NO-SIMD128-NEXT:    i32.xor $push44=, $9, $pop95
; NO-SIMD128-NEXT:    i32.and $push45=, $pop44, $41
; NO-SIMD128-NEXT:    i32.or $push46=, $pop43, $pop45
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop46
; NO-SIMD128-NEXT:    i32.const $push51=, 7
; NO-SIMD128-NEXT:    i32.add $push52=, $0, $pop51
; NO-SIMD128-NEXT:    i32.and $push47=, $8, $24
; NO-SIMD128-NEXT:    i32.const $push94=, -1
; NO-SIMD128-NEXT:    i32.xor $push48=, $8, $pop94
; NO-SIMD128-NEXT:    i32.and $push49=, $pop48, $40
; NO-SIMD128-NEXT:    i32.or $push50=, $pop47, $pop49
; NO-SIMD128-NEXT:    i32.store8 0($pop52), $pop50
; NO-SIMD128-NEXT:    i32.const $push57=, 6
; NO-SIMD128-NEXT:    i32.add $push58=, $0, $pop57
; NO-SIMD128-NEXT:    i32.and $push53=, $7, $23
; NO-SIMD128-NEXT:    i32.const $push93=, -1
; NO-SIMD128-NEXT:    i32.xor $push54=, $7, $pop93
; NO-SIMD128-NEXT:    i32.and $push55=, $pop54, $39
; NO-SIMD128-NEXT:    i32.or $push56=, $pop53, $pop55
; NO-SIMD128-NEXT:    i32.store8 0($pop58), $pop56
; NO-SIMD128-NEXT:    i32.const $push63=, 5
; NO-SIMD128-NEXT:    i32.add $push64=, $0, $pop63
; NO-SIMD128-NEXT:    i32.and $push59=, $6, $22
; NO-SIMD128-NEXT:    i32.const $push92=, -1
; NO-SIMD128-NEXT:    i32.xor $push60=, $6, $pop92
; NO-SIMD128-NEXT:    i32.and $push61=, $pop60, $38
; NO-SIMD128-NEXT:    i32.or $push62=, $pop59, $pop61
; NO-SIMD128-NEXT:    i32.store8 0($pop64), $pop62
; NO-SIMD128-NEXT:    i32.and $push65=, $5, $21
; NO-SIMD128-NEXT:    i32.const $push91=, -1
; NO-SIMD128-NEXT:    i32.xor $push66=, $5, $pop91
; NO-SIMD128-NEXT:    i32.and $push67=, $pop66, $37
; NO-SIMD128-NEXT:    i32.or $push68=, $pop65, $pop67
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop68
; NO-SIMD128-NEXT:    i32.const $push73=, 3
; NO-SIMD128-NEXT:    i32.add $push74=, $0, $pop73
; NO-SIMD128-NEXT:    i32.and $push69=, $4, $20
; NO-SIMD128-NEXT:    i32.const $push90=, -1
; NO-SIMD128-NEXT:    i32.xor $push70=, $4, $pop90
; NO-SIMD128-NEXT:    i32.and $push71=, $pop70, $36
; NO-SIMD128-NEXT:    i32.or $push72=, $pop69, $pop71
; NO-SIMD128-NEXT:    i32.store8 0($pop74), $pop72
; NO-SIMD128-NEXT:    i32.and $push75=, $3, $19
; NO-SIMD128-NEXT:    i32.const $push89=, -1
; NO-SIMD128-NEXT:    i32.xor $push76=, $3, $pop89
; NO-SIMD128-NEXT:    i32.and $push77=, $pop76, $35
; NO-SIMD128-NEXT:    i32.or $push78=, $pop75, $pop77
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop78
; NO-SIMD128-NEXT:    i32.and $push79=, $2, $18
; NO-SIMD128-NEXT:    i32.const $push88=, -1
; NO-SIMD128-NEXT:    i32.xor $push80=, $2, $pop88
; NO-SIMD128-NEXT:    i32.and $push81=, $pop80, $34
; NO-SIMD128-NEXT:    i32.or $push82=, $pop79, $pop81
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop82
; NO-SIMD128-NEXT:    i32.and $push83=, $1, $17
; NO-SIMD128-NEXT:    i32.const $push87=, -1
; NO-SIMD128-NEXT:    i32.xor $push84=, $1, $pop87
; NO-SIMD128-NEXT:    i32.and $push85=, $pop84, $33
; NO-SIMD128-NEXT:    i32.or $push86=, $pop83, $pop85
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop86
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_v16i8:
; NO-SIMD128-FAST:         .functype bitselect_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.and $push0=, $1, $17
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $pop2, $33
; NO-SIMD128-FAST-NEXT:    i32.or $push4=, $pop0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $2, $18
; NO-SIMD128-FAST-NEXT:    i32.const $push101=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $2, $pop101
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $34
; NO-SIMD128-FAST-NEXT:    i32.or $push8=, $pop5, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $3, $19
; NO-SIMD128-FAST-NEXT:    i32.const $push100=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push10=, $3, $pop100
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $pop10, $35
; NO-SIMD128-FAST-NEXT:    i32.or $push12=, $pop9, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $4, $20
; NO-SIMD128-FAST-NEXT:    i32.const $push99=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $4, $pop99
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $pop14, $36
; NO-SIMD128-FAST-NEXT:    i32.or $push16=, $pop13, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop16
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $5, $21
; NO-SIMD128-FAST-NEXT:    i32.const $push98=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push20=, $5, $pop98
; NO-SIMD128-FAST-NEXT:    i32.and $push21=, $pop20, $37
; NO-SIMD128-FAST-NEXT:    i32.or $push22=, $pop19, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $6, $22
; NO-SIMD128-FAST-NEXT:    i32.const $push97=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push24=, $6, $pop97
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $pop24, $38
; NO-SIMD128-FAST-NEXT:    i32.or $push26=, $pop23, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop28), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $7, $23
; NO-SIMD128-FAST-NEXT:    i32.const $push96=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push30=, $7, $pop96
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $pop30, $39
; NO-SIMD128-FAST-NEXT:    i32.or $push32=, $pop29, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-FAST-NEXT:    i32.and $push35=, $8, $24
; NO-SIMD128-FAST-NEXT:    i32.const $push95=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push36=, $8, $pop95
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $pop36, $40
; NO-SIMD128-FAST-NEXT:    i32.or $push38=, $pop35, $pop37
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop40), $pop38
; NO-SIMD128-FAST-NEXT:    i32.and $push41=, $9, $25
; NO-SIMD128-FAST-NEXT:    i32.const $push94=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push42=, $9, $pop94
; NO-SIMD128-FAST-NEXT:    i32.and $push43=, $pop42, $41
; NO-SIMD128-FAST-NEXT:    i32.or $push44=, $pop41, $pop43
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push50=, $0, $pop49
; NO-SIMD128-FAST-NEXT:    i32.and $push45=, $10, $26
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push46=, $10, $pop93
; NO-SIMD128-FAST-NEXT:    i32.and $push47=, $pop46, $42
; NO-SIMD128-FAST-NEXT:    i32.or $push48=, $pop45, $pop47
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop50), $pop48
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push56=, $0, $pop55
; NO-SIMD128-FAST-NEXT:    i32.and $push51=, $11, $27
; NO-SIMD128-FAST-NEXT:    i32.const $push92=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push52=, $11, $pop92
; NO-SIMD128-FAST-NEXT:    i32.and $push53=, $pop52, $43
; NO-SIMD128-FAST-NEXT:    i32.or $push54=, $pop51, $pop53
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop56), $pop54
; NO-SIMD128-FAST-NEXT:    i32.const $push61=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push62=, $0, $pop61
; NO-SIMD128-FAST-NEXT:    i32.and $push57=, $12, $28
; NO-SIMD128-FAST-NEXT:    i32.const $push91=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push58=, $12, $pop91
; NO-SIMD128-FAST-NEXT:    i32.and $push59=, $pop58, $44
; NO-SIMD128-FAST-NEXT:    i32.or $push60=, $pop57, $pop59
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop62), $pop60
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push68=, $0, $pop67
; NO-SIMD128-FAST-NEXT:    i32.and $push63=, $13, $29
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push64=, $13, $pop90
; NO-SIMD128-FAST-NEXT:    i32.and $push65=, $pop64, $45
; NO-SIMD128-FAST-NEXT:    i32.or $push66=, $pop63, $pop65
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop68), $pop66
; NO-SIMD128-FAST-NEXT:    i32.const $push73=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push74=, $0, $pop73
; NO-SIMD128-FAST-NEXT:    i32.and $push69=, $14, $30
; NO-SIMD128-FAST-NEXT:    i32.const $push89=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push70=, $14, $pop89
; NO-SIMD128-FAST-NEXT:    i32.and $push71=, $pop70, $46
; NO-SIMD128-FAST-NEXT:    i32.or $push72=, $pop69, $pop71
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop74), $pop72
; NO-SIMD128-FAST-NEXT:    i32.const $push79=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push80=, $0, $pop79
; NO-SIMD128-FAST-NEXT:    i32.and $push75=, $15, $31
; NO-SIMD128-FAST-NEXT:    i32.const $push88=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push76=, $15, $pop88
; NO-SIMD128-FAST-NEXT:    i32.and $push77=, $pop76, $47
; NO-SIMD128-FAST-NEXT:    i32.or $push78=, $pop75, $pop77
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop80), $pop78
; NO-SIMD128-FAST-NEXT:    i32.const $push85=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push86=, $0, $pop85
; NO-SIMD128-FAST-NEXT:    i32.and $push81=, $16, $32
; NO-SIMD128-FAST-NEXT:    i32.const $push87=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push82=, $16, $pop87
; NO-SIMD128-FAST-NEXT:    i32.and $push83=, $pop82, $48
; NO-SIMD128-FAST-NEXT:    i32.or $push84=, $pop81, $pop83
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop86), $pop84
; NO-SIMD128-FAST-NEXT:    return
  %masked_v1 = and <16 x i8> %c, %v1
  %inv_mask = xor <16 x i8> %c,
    <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1,
     i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %masked_v2 = and <16 x i8> %inv_mask, %v2
  %a = or <16 x i8> %masked_v1, %masked_v2
  ret <16 x i8> %a
}

define <16 x i8> @bitselect_xor_v16i8(<16 x i8> %c, <16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: bitselect_xor_v16i8:
; SIMD128:         .functype bitselect_xor_v16i8 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_v16i8:
; SIMD128-FAST:         .functype bitselect_xor_v16i8 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push2=, $1, $2
; SIMD128-FAST-NEXT:    v128.and $push1=, $pop2, $0
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop1, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_v16i8:
; NO-SIMD128:         .functype bitselect_xor_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push3=, 15
; NO-SIMD128-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-NEXT:    i32.xor $push0=, $32, $48
; NO-SIMD128-NEXT:    i32.and $push1=, $pop0, $16
; NO-SIMD128-NEXT:    i32.xor $push2=, $pop1, $48
; NO-SIMD128-NEXT:    i32.store8 0($pop4), $pop2
; NO-SIMD128-NEXT:    i32.const $push8=, 14
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.xor $push5=, $31, $47
; NO-SIMD128-NEXT:    i32.and $push6=, $pop5, $15
; NO-SIMD128-NEXT:    i32.xor $push7=, $pop6, $47
; NO-SIMD128-NEXT:    i32.store8 0($pop9), $pop7
; NO-SIMD128-NEXT:    i32.const $push13=, 13
; NO-SIMD128-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-NEXT:    i32.xor $push10=, $30, $46
; NO-SIMD128-NEXT:    i32.and $push11=, $pop10, $14
; NO-SIMD128-NEXT:    i32.xor $push12=, $pop11, $46
; NO-SIMD128-NEXT:    i32.store8 0($pop14), $pop12
; NO-SIMD128-NEXT:    i32.const $push18=, 12
; NO-SIMD128-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-NEXT:    i32.xor $push15=, $29, $45
; NO-SIMD128-NEXT:    i32.and $push16=, $pop15, $13
; NO-SIMD128-NEXT:    i32.xor $push17=, $pop16, $45
; NO-SIMD128-NEXT:    i32.store8 0($pop19), $pop17
; NO-SIMD128-NEXT:    i32.const $push23=, 11
; NO-SIMD128-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-NEXT:    i32.xor $push20=, $28, $44
; NO-SIMD128-NEXT:    i32.and $push21=, $pop20, $12
; NO-SIMD128-NEXT:    i32.xor $push22=, $pop21, $44
; NO-SIMD128-NEXT:    i32.store8 0($pop24), $pop22
; NO-SIMD128-NEXT:    i32.const $push28=, 10
; NO-SIMD128-NEXT:    i32.add $push29=, $0, $pop28
; NO-SIMD128-NEXT:    i32.xor $push25=, $27, $43
; NO-SIMD128-NEXT:    i32.and $push26=, $pop25, $11
; NO-SIMD128-NEXT:    i32.xor $push27=, $pop26, $43
; NO-SIMD128-NEXT:    i32.store8 0($pop29), $pop27
; NO-SIMD128-NEXT:    i32.const $push33=, 9
; NO-SIMD128-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-NEXT:    i32.xor $push30=, $26, $42
; NO-SIMD128-NEXT:    i32.and $push31=, $pop30, $10
; NO-SIMD128-NEXT:    i32.xor $push32=, $pop31, $42
; NO-SIMD128-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-NEXT:    i32.xor $push35=, $25, $41
; NO-SIMD128-NEXT:    i32.and $push36=, $pop35, $9
; NO-SIMD128-NEXT:    i32.xor $push37=, $pop36, $41
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop37
; NO-SIMD128-NEXT:    i32.const $push41=, 7
; NO-SIMD128-NEXT:    i32.add $push42=, $0, $pop41
; NO-SIMD128-NEXT:    i32.xor $push38=, $24, $40
; NO-SIMD128-NEXT:    i32.and $push39=, $pop38, $8
; NO-SIMD128-NEXT:    i32.xor $push40=, $pop39, $40
; NO-SIMD128-NEXT:    i32.store8 0($pop42), $pop40
; NO-SIMD128-NEXT:    i32.const $push46=, 6
; NO-SIMD128-NEXT:    i32.add $push47=, $0, $pop46
; NO-SIMD128-NEXT:    i32.xor $push43=, $23, $39
; NO-SIMD128-NEXT:    i32.and $push44=, $pop43, $7
; NO-SIMD128-NEXT:    i32.xor $push45=, $pop44, $39
; NO-SIMD128-NEXT:    i32.store8 0($pop47), $pop45
; NO-SIMD128-NEXT:    i32.const $push51=, 5
; NO-SIMD128-NEXT:    i32.add $push52=, $0, $pop51
; NO-SIMD128-NEXT:    i32.xor $push48=, $22, $38
; NO-SIMD128-NEXT:    i32.and $push49=, $pop48, $6
; NO-SIMD128-NEXT:    i32.xor $push50=, $pop49, $38
; NO-SIMD128-NEXT:    i32.store8 0($pop52), $pop50
; NO-SIMD128-NEXT:    i32.xor $push53=, $21, $37
; NO-SIMD128-NEXT:    i32.and $push54=, $pop53, $5
; NO-SIMD128-NEXT:    i32.xor $push55=, $pop54, $37
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop55
; NO-SIMD128-NEXT:    i32.const $push59=, 3
; NO-SIMD128-NEXT:    i32.add $push60=, $0, $pop59
; NO-SIMD128-NEXT:    i32.xor $push56=, $20, $36
; NO-SIMD128-NEXT:    i32.and $push57=, $pop56, $4
; NO-SIMD128-NEXT:    i32.xor $push58=, $pop57, $36
; NO-SIMD128-NEXT:    i32.store8 0($pop60), $pop58
; NO-SIMD128-NEXT:    i32.xor $push61=, $19, $35
; NO-SIMD128-NEXT:    i32.and $push62=, $pop61, $3
; NO-SIMD128-NEXT:    i32.xor $push63=, $pop62, $35
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop63
; NO-SIMD128-NEXT:    i32.xor $push64=, $18, $34
; NO-SIMD128-NEXT:    i32.and $push65=, $pop64, $2
; NO-SIMD128-NEXT:    i32.xor $push66=, $pop65, $34
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop66
; NO-SIMD128-NEXT:    i32.xor $push67=, $17, $33
; NO-SIMD128-NEXT:    i32.and $push68=, $pop67, $1
; NO-SIMD128-NEXT:    i32.xor $push69=, $pop68, $33
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop69
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_v16i8:
; NO-SIMD128-FAST:         .functype bitselect_xor_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $17, $33
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $pop1, $33
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $18, $34
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $pop4, $34
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $19, $35
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $3
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $35
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $20, $36
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $pop11, $4
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $pop12, $36
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop10), $pop13
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $21, $37
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $pop14, $5
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $pop15, $37
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.xor $push19=, $22, $38
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $pop19, $6
; NO-SIMD128-FAST-NEXT:    i32.xor $push21=, $pop20, $38
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push22=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push23=, $0, $pop22
; NO-SIMD128-FAST-NEXT:    i32.xor $push24=, $23, $39
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $pop24, $7
; NO-SIMD128-FAST-NEXT:    i32.xor $push26=, $pop25, $39
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop23), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $24, $40
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $pop29, $8
; NO-SIMD128-FAST-NEXT:    i32.xor $push31=, $pop30, $40
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop28), $pop31
; NO-SIMD128-FAST-NEXT:    i32.xor $push32=, $25, $41
; NO-SIMD128-FAST-NEXT:    i32.and $push33=, $pop32, $9
; NO-SIMD128-FAST-NEXT:    i32.xor $push34=, $pop33, $41
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-FAST-NEXT:    i32.xor $push37=, $26, $42
; NO-SIMD128-FAST-NEXT:    i32.and $push38=, $pop37, $10
; NO-SIMD128-FAST-NEXT:    i32.xor $push39=, $pop38, $42
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop36), $pop39
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push41=, $0, $pop40
; NO-SIMD128-FAST-NEXT:    i32.xor $push42=, $27, $43
; NO-SIMD128-FAST-NEXT:    i32.and $push43=, $pop42, $11
; NO-SIMD128-FAST-NEXT:    i32.xor $push44=, $pop43, $43
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop41), $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push46=, $0, $pop45
; NO-SIMD128-FAST-NEXT:    i32.xor $push47=, $28, $44
; NO-SIMD128-FAST-NEXT:    i32.and $push48=, $pop47, $12
; NO-SIMD128-FAST-NEXT:    i32.xor $push49=, $pop48, $44
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop46), $pop49
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push51=, $0, $pop50
; NO-SIMD128-FAST-NEXT:    i32.xor $push52=, $29, $45
; NO-SIMD128-FAST-NEXT:    i32.and $push53=, $pop52, $13
; NO-SIMD128-FAST-NEXT:    i32.xor $push54=, $pop53, $45
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop51), $pop54
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push56=, $0, $pop55
; NO-SIMD128-FAST-NEXT:    i32.xor $push57=, $30, $46
; NO-SIMD128-FAST-NEXT:    i32.and $push58=, $pop57, $14
; NO-SIMD128-FAST-NEXT:    i32.xor $push59=, $pop58, $46
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop56), $pop59
; NO-SIMD128-FAST-NEXT:    i32.const $push60=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push61=, $0, $pop60
; NO-SIMD128-FAST-NEXT:    i32.xor $push62=, $31, $47
; NO-SIMD128-FAST-NEXT:    i32.and $push63=, $pop62, $15
; NO-SIMD128-FAST-NEXT:    i32.xor $push64=, $pop63, $47
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop61), $pop64
; NO-SIMD128-FAST-NEXT:    i32.const $push65=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push66=, $0, $pop65
; NO-SIMD128-FAST-NEXT:    i32.xor $push67=, $32, $48
; NO-SIMD128-FAST-NEXT:    i32.and $push68=, $pop67, $16
; NO-SIMD128-FAST-NEXT:    i32.xor $push69=, $pop68, $48
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop66), $pop69
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <16 x i8> %v1, %v2
 %and = and <16 x i8> %xor1, %c
 %a = xor <16 x i8> %and, %v2
 ret <16 x i8> %a
}

define <16 x i8> @bitselect_xor_reversed_v16i8(<16 x i8> %c, <16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: bitselect_xor_reversed_v16i8:
; SIMD128:         .functype bitselect_xor_reversed_v16i8 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $2, $1, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_reversed_v16i8:
; SIMD128-FAST:         .functype bitselect_xor_reversed_v16i8 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push1=, $1, $2
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $pop1, $pop2
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop3, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_reversed_v16i8:
; NO-SIMD128:         .functype bitselect_xor_reversed_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push5=, 15
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.xor $push2=, $32, $48
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $16, $pop0
; NO-SIMD128-NEXT:    i32.and $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.xor $push4=, $pop3, $48
; NO-SIMD128-NEXT:    i32.store8 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push11=, 14
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.xor $push8=, $31, $47
; NO-SIMD128-NEXT:    i32.const $push101=, -1
; NO-SIMD128-NEXT:    i32.xor $push7=, $15, $pop101
; NO-SIMD128-NEXT:    i32.and $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.xor $push10=, $pop9, $47
; NO-SIMD128-NEXT:    i32.store8 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push17=, 13
; NO-SIMD128-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-NEXT:    i32.xor $push14=, $30, $46
; NO-SIMD128-NEXT:    i32.const $push100=, -1
; NO-SIMD128-NEXT:    i32.xor $push13=, $14, $pop100
; NO-SIMD128-NEXT:    i32.and $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.xor $push16=, $pop15, $46
; NO-SIMD128-NEXT:    i32.store8 0($pop18), $pop16
; NO-SIMD128-NEXT:    i32.const $push23=, 12
; NO-SIMD128-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-NEXT:    i32.xor $push20=, $29, $45
; NO-SIMD128-NEXT:    i32.const $push99=, -1
; NO-SIMD128-NEXT:    i32.xor $push19=, $13, $pop99
; NO-SIMD128-NEXT:    i32.and $push21=, $pop20, $pop19
; NO-SIMD128-NEXT:    i32.xor $push22=, $pop21, $45
; NO-SIMD128-NEXT:    i32.store8 0($pop24), $pop22
; NO-SIMD128-NEXT:    i32.const $push29=, 11
; NO-SIMD128-NEXT:    i32.add $push30=, $0, $pop29
; NO-SIMD128-NEXT:    i32.xor $push26=, $28, $44
; NO-SIMD128-NEXT:    i32.const $push98=, -1
; NO-SIMD128-NEXT:    i32.xor $push25=, $12, $pop98
; NO-SIMD128-NEXT:    i32.and $push27=, $pop26, $pop25
; NO-SIMD128-NEXT:    i32.xor $push28=, $pop27, $44
; NO-SIMD128-NEXT:    i32.store8 0($pop30), $pop28
; NO-SIMD128-NEXT:    i32.const $push35=, 10
; NO-SIMD128-NEXT:    i32.add $push36=, $0, $pop35
; NO-SIMD128-NEXT:    i32.xor $push32=, $27, $43
; NO-SIMD128-NEXT:    i32.const $push97=, -1
; NO-SIMD128-NEXT:    i32.xor $push31=, $11, $pop97
; NO-SIMD128-NEXT:    i32.and $push33=, $pop32, $pop31
; NO-SIMD128-NEXT:    i32.xor $push34=, $pop33, $43
; NO-SIMD128-NEXT:    i32.store8 0($pop36), $pop34
; NO-SIMD128-NEXT:    i32.const $push41=, 9
; NO-SIMD128-NEXT:    i32.add $push42=, $0, $pop41
; NO-SIMD128-NEXT:    i32.xor $push38=, $26, $42
; NO-SIMD128-NEXT:    i32.const $push96=, -1
; NO-SIMD128-NEXT:    i32.xor $push37=, $10, $pop96
; NO-SIMD128-NEXT:    i32.and $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.xor $push40=, $pop39, $42
; NO-SIMD128-NEXT:    i32.store8 0($pop42), $pop40
; NO-SIMD128-NEXT:    i32.xor $push44=, $25, $41
; NO-SIMD128-NEXT:    i32.const $push95=, -1
; NO-SIMD128-NEXT:    i32.xor $push43=, $9, $pop95
; NO-SIMD128-NEXT:    i32.and $push45=, $pop44, $pop43
; NO-SIMD128-NEXT:    i32.xor $push46=, $pop45, $41
; NO-SIMD128-NEXT:    i32.store8 8($0), $pop46
; NO-SIMD128-NEXT:    i32.const $push51=, 7
; NO-SIMD128-NEXT:    i32.add $push52=, $0, $pop51
; NO-SIMD128-NEXT:    i32.xor $push48=, $24, $40
; NO-SIMD128-NEXT:    i32.const $push94=, -1
; NO-SIMD128-NEXT:    i32.xor $push47=, $8, $pop94
; NO-SIMD128-NEXT:    i32.and $push49=, $pop48, $pop47
; NO-SIMD128-NEXT:    i32.xor $push50=, $pop49, $40
; NO-SIMD128-NEXT:    i32.store8 0($pop52), $pop50
; NO-SIMD128-NEXT:    i32.const $push57=, 6
; NO-SIMD128-NEXT:    i32.add $push58=, $0, $pop57
; NO-SIMD128-NEXT:    i32.xor $push54=, $23, $39
; NO-SIMD128-NEXT:    i32.const $push93=, -1
; NO-SIMD128-NEXT:    i32.xor $push53=, $7, $pop93
; NO-SIMD128-NEXT:    i32.and $push55=, $pop54, $pop53
; NO-SIMD128-NEXT:    i32.xor $push56=, $pop55, $39
; NO-SIMD128-NEXT:    i32.store8 0($pop58), $pop56
; NO-SIMD128-NEXT:    i32.const $push63=, 5
; NO-SIMD128-NEXT:    i32.add $push64=, $0, $pop63
; NO-SIMD128-NEXT:    i32.xor $push60=, $22, $38
; NO-SIMD128-NEXT:    i32.const $push92=, -1
; NO-SIMD128-NEXT:    i32.xor $push59=, $6, $pop92
; NO-SIMD128-NEXT:    i32.and $push61=, $pop60, $pop59
; NO-SIMD128-NEXT:    i32.xor $push62=, $pop61, $38
; NO-SIMD128-NEXT:    i32.store8 0($pop64), $pop62
; NO-SIMD128-NEXT:    i32.xor $push66=, $21, $37
; NO-SIMD128-NEXT:    i32.const $push91=, -1
; NO-SIMD128-NEXT:    i32.xor $push65=, $5, $pop91
; NO-SIMD128-NEXT:    i32.and $push67=, $pop66, $pop65
; NO-SIMD128-NEXT:    i32.xor $push68=, $pop67, $37
; NO-SIMD128-NEXT:    i32.store8 4($0), $pop68
; NO-SIMD128-NEXT:    i32.const $push73=, 3
; NO-SIMD128-NEXT:    i32.add $push74=, $0, $pop73
; NO-SIMD128-NEXT:    i32.xor $push70=, $20, $36
; NO-SIMD128-NEXT:    i32.const $push90=, -1
; NO-SIMD128-NEXT:    i32.xor $push69=, $4, $pop90
; NO-SIMD128-NEXT:    i32.and $push71=, $pop70, $pop69
; NO-SIMD128-NEXT:    i32.xor $push72=, $pop71, $36
; NO-SIMD128-NEXT:    i32.store8 0($pop74), $pop72
; NO-SIMD128-NEXT:    i32.xor $push76=, $19, $35
; NO-SIMD128-NEXT:    i32.const $push89=, -1
; NO-SIMD128-NEXT:    i32.xor $push75=, $3, $pop89
; NO-SIMD128-NEXT:    i32.and $push77=, $pop76, $pop75
; NO-SIMD128-NEXT:    i32.xor $push78=, $pop77, $35
; NO-SIMD128-NEXT:    i32.store8 2($0), $pop78
; NO-SIMD128-NEXT:    i32.xor $push80=, $18, $34
; NO-SIMD128-NEXT:    i32.const $push88=, -1
; NO-SIMD128-NEXT:    i32.xor $push79=, $2, $pop88
; NO-SIMD128-NEXT:    i32.and $push81=, $pop80, $pop79
; NO-SIMD128-NEXT:    i32.xor $push82=, $pop81, $34
; NO-SIMD128-NEXT:    i32.store8 1($0), $pop82
; NO-SIMD128-NEXT:    i32.xor $push84=, $17, $33
; NO-SIMD128-NEXT:    i32.const $push87=, -1
; NO-SIMD128-NEXT:    i32.xor $push83=, $1, $pop87
; NO-SIMD128-NEXT:    i32.and $push85=, $pop84, $pop83
; NO-SIMD128-NEXT:    i32.xor $push86=, $pop85, $33
; NO-SIMD128-NEXT:    i32.store8 0($0), $pop86
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_reversed_v16i8:
; NO-SIMD128-FAST:         .functype bitselect_xor_reversed_v16i8 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $17, $33
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.xor $push4=, $pop3, $33
; NO-SIMD128-FAST-NEXT:    i32.store8 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $18, $34
; NO-SIMD128-FAST-NEXT:    i32.const $push101=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $2, $pop101
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $34
; NO-SIMD128-FAST-NEXT:    i32.store8 1($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.xor $push10=, $19, $35
; NO-SIMD128-FAST-NEXT:    i32.const $push100=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $3, $pop100
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $pop11, $35
; NO-SIMD128-FAST-NEXT:    i32.store8 2($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 3
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $20, $36
; NO-SIMD128-FAST-NEXT:    i32.const $push99=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $4, $pop99
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $pop15, $36
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop18), $pop16
; NO-SIMD128-FAST-NEXT:    i32.xor $push20=, $21, $37
; NO-SIMD128-FAST-NEXT:    i32.const $push98=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push19=, $5, $pop98
; NO-SIMD128-FAST-NEXT:    i32.and $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.xor $push22=, $pop21, $37
; NO-SIMD128-FAST-NEXT:    i32.store8 4($0), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 5
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.xor $push24=, $22, $38
; NO-SIMD128-FAST-NEXT:    i32.const $push97=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push23=, $6, $pop97
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $pop24, $pop23
; NO-SIMD128-FAST-NEXT:    i32.xor $push26=, $pop25, $38
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop28), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-FAST-NEXT:    i32.xor $push30=, $23, $39
; NO-SIMD128-FAST-NEXT:    i32.const $push96=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $7, $pop96
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.xor $push32=, $pop31, $39
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop34), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 7
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-FAST-NEXT:    i32.xor $push36=, $24, $40
; NO-SIMD128-FAST-NEXT:    i32.const $push95=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push35=, $8, $pop95
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $pop36, $pop35
; NO-SIMD128-FAST-NEXT:    i32.xor $push38=, $pop37, $40
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop40), $pop38
; NO-SIMD128-FAST-NEXT:    i32.xor $push42=, $25, $41
; NO-SIMD128-FAST-NEXT:    i32.const $push94=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push41=, $9, $pop94
; NO-SIMD128-FAST-NEXT:    i32.and $push43=, $pop42, $pop41
; NO-SIMD128-FAST-NEXT:    i32.xor $push44=, $pop43, $41
; NO-SIMD128-FAST-NEXT:    i32.store8 8($0), $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 9
; NO-SIMD128-FAST-NEXT:    i32.add $push50=, $0, $pop49
; NO-SIMD128-FAST-NEXT:    i32.xor $push46=, $26, $42
; NO-SIMD128-FAST-NEXT:    i32.const $push93=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push45=, $10, $pop93
; NO-SIMD128-FAST-NEXT:    i32.and $push47=, $pop46, $pop45
; NO-SIMD128-FAST-NEXT:    i32.xor $push48=, $pop47, $42
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop50), $pop48
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push56=, $0, $pop55
; NO-SIMD128-FAST-NEXT:    i32.xor $push52=, $27, $43
; NO-SIMD128-FAST-NEXT:    i32.const $push92=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push51=, $11, $pop92
; NO-SIMD128-FAST-NEXT:    i32.and $push53=, $pop52, $pop51
; NO-SIMD128-FAST-NEXT:    i32.xor $push54=, $pop53, $43
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop56), $pop54
; NO-SIMD128-FAST-NEXT:    i32.const $push61=, 11
; NO-SIMD128-FAST-NEXT:    i32.add $push62=, $0, $pop61
; NO-SIMD128-FAST-NEXT:    i32.xor $push58=, $28, $44
; NO-SIMD128-FAST-NEXT:    i32.const $push91=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push57=, $12, $pop91
; NO-SIMD128-FAST-NEXT:    i32.and $push59=, $pop58, $pop57
; NO-SIMD128-FAST-NEXT:    i32.xor $push60=, $pop59, $44
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop62), $pop60
; NO-SIMD128-FAST-NEXT:    i32.const $push67=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push68=, $0, $pop67
; NO-SIMD128-FAST-NEXT:    i32.xor $push64=, $29, $45
; NO-SIMD128-FAST-NEXT:    i32.const $push90=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push63=, $13, $pop90
; NO-SIMD128-FAST-NEXT:    i32.and $push65=, $pop64, $pop63
; NO-SIMD128-FAST-NEXT:    i32.xor $push66=, $pop65, $45
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop68), $pop66
; NO-SIMD128-FAST-NEXT:    i32.const $push73=, 13
; NO-SIMD128-FAST-NEXT:    i32.add $push74=, $0, $pop73
; NO-SIMD128-FAST-NEXT:    i32.xor $push70=, $30, $46
; NO-SIMD128-FAST-NEXT:    i32.const $push89=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push69=, $14, $pop89
; NO-SIMD128-FAST-NEXT:    i32.and $push71=, $pop70, $pop69
; NO-SIMD128-FAST-NEXT:    i32.xor $push72=, $pop71, $46
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop74), $pop72
; NO-SIMD128-FAST-NEXT:    i32.const $push79=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push80=, $0, $pop79
; NO-SIMD128-FAST-NEXT:    i32.xor $push76=, $31, $47
; NO-SIMD128-FAST-NEXT:    i32.const $push88=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push75=, $15, $pop88
; NO-SIMD128-FAST-NEXT:    i32.and $push77=, $pop76, $pop75
; NO-SIMD128-FAST-NEXT:    i32.xor $push78=, $pop77, $47
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop80), $pop78
; NO-SIMD128-FAST-NEXT:    i32.const $push85=, 15
; NO-SIMD128-FAST-NEXT:    i32.add $push86=, $0, $pop85
; NO-SIMD128-FAST-NEXT:    i32.xor $push82=, $32, $48
; NO-SIMD128-FAST-NEXT:    i32.const $push87=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push81=, $16, $pop87
; NO-SIMD128-FAST-NEXT:    i32.and $push83=, $pop82, $pop81
; NO-SIMD128-FAST-NEXT:    i32.xor $push84=, $pop83, $48
; NO-SIMD128-FAST-NEXT:    i32.store8 0($pop86), $pop84
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <16 x i8> %v1, %v2
 %notc = xor <16 x i8> %c, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1,
                            i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
 %and = and <16 x i8> %xor1, %notc
 %a = xor <16 x i8> %and, %v2
 ret <16 x i8> %a
}

; ==============================================================================
; 8 x i16
; ==============================================================================
define <8 x i16> @add_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: add_v8i16:
; SIMD128:         .functype add_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.add $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: add_v8i16:
; SIMD128-FAST:         .functype add_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.add $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: add_v8i16:
; NO-SIMD128:         .functype add_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.add $push0=, $5, $13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop0
; NO-SIMD128-NEXT:    i32.add $push1=, $3, $11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop1
; NO-SIMD128-NEXT:    i32.add $push2=, $2, $10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop2
; NO-SIMD128-NEXT:    i32.add $push3=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 14
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.add $push4=, $8, $16
; NO-SIMD128-NEXT:    i32.store16 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.add $push7=, $7, $15
; NO-SIMD128-NEXT:    i32.store16 0($pop9), $pop7
; NO-SIMD128-NEXT:    i32.const $push11=, 10
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.add $push10=, $6, $14
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push14=, 6
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.add $push13=, $4, $12
; NO-SIMD128-NEXT:    i32.store16 0($pop15), $pop13
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: add_v8i16:
; NO-SIMD128-FAST:         .functype add_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.add $push1=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop8), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.add $push12=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop11), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop14), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %a = add <8 x i16> %x, %y
  ret <8 x i16> %a
}

define <8 x i16> @sub_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: sub_v8i16:
; SIMD128:         .functype sub_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.sub $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sub_v8i16:
; SIMD128-FAST:         .functype sub_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.sub $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sub_v8i16:
; NO-SIMD128:         .functype sub_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.sub $push0=, $5, $13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop0
; NO-SIMD128-NEXT:    i32.sub $push1=, $3, $11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop1
; NO-SIMD128-NEXT:    i32.sub $push2=, $2, $10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop2
; NO-SIMD128-NEXT:    i32.sub $push3=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 14
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.sub $push4=, $8, $16
; NO-SIMD128-NEXT:    i32.store16 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.sub $push7=, $7, $15
; NO-SIMD128-NEXT:    i32.store16 0($pop9), $pop7
; NO-SIMD128-NEXT:    i32.const $push11=, 10
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.sub $push10=, $6, $14
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push14=, 6
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.sub $push13=, $4, $12
; NO-SIMD128-NEXT:    i32.store16 0($pop15), $pop13
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sub_v8i16:
; NO-SIMD128-FAST:         .functype sub_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.sub $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.sub $push1=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.sub $push5=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.sub $push9=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop8), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.sub $push12=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop11), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.sub $push15=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop14), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <8 x i16> %x, %y
  ret <8 x i16> %a
}

define <8 x i16> @mul_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: mul_v8i16:
; SIMD128:         .functype mul_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.mul $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: mul_v8i16:
; SIMD128-FAST:         .functype mul_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.mul $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: mul_v8i16:
; NO-SIMD128:         .functype mul_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.mul $push0=, $5, $13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop0
; NO-SIMD128-NEXT:    i32.mul $push1=, $3, $11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop1
; NO-SIMD128-NEXT:    i32.mul $push2=, $2, $10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop2
; NO-SIMD128-NEXT:    i32.mul $push3=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 14
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.mul $push4=, $8, $16
; NO-SIMD128-NEXT:    i32.store16 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.mul $push7=, $7, $15
; NO-SIMD128-NEXT:    i32.store16 0($pop9), $pop7
; NO-SIMD128-NEXT:    i32.const $push11=, 10
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.mul $push10=, $6, $14
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push14=, 6
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.mul $push13=, $4, $12
; NO-SIMD128-NEXT:    i32.store16 0($pop15), $pop13
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: mul_v8i16:
; NO-SIMD128-FAST:         .functype mul_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.mul $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.mul $push1=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.mul $push5=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    i32.mul $push6=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.mul $push9=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop8), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.mul $push12=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop11), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.mul $push15=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop14), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %a = mul <8 x i16> %x, %y
  ret <8 x i16> %a
}

define <8 x i16> @min_s_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: min_s_v8i16:
; SIMD128:         .functype min_s_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.min_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_s_v8i16:
; SIMD128-FAST:         .functype min_s_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.min_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_s_v8i16:
; NO-SIMD128:         .functype min_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push4=, 14
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.extend16_s $push1=, $8
; NO-SIMD128-NEXT:    i32.extend16_s $push0=, $16
; NO-SIMD128-NEXT:    i32.lt_s $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.select $push3=, $8, $16, $pop2
; NO-SIMD128-NEXT:    i32.store16 0($pop5), $pop3
; NO-SIMD128-NEXT:    i32.const $push10=, 12
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.extend16_s $push7=, $7
; NO-SIMD128-NEXT:    i32.extend16_s $push6=, $15
; NO-SIMD128-NEXT:    i32.lt_s $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.select $push9=, $7, $15, $pop8
; NO-SIMD128-NEXT:    i32.store16 0($pop11), $pop9
; NO-SIMD128-NEXT:    i32.const $push16=, 10
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.extend16_s $push13=, $6
; NO-SIMD128-NEXT:    i32.extend16_s $push12=, $14
; NO-SIMD128-NEXT:    i32.lt_s $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.select $push15=, $6, $14, $pop14
; NO-SIMD128-NEXT:    i32.store16 0($pop17), $pop15
; NO-SIMD128-NEXT:    i32.extend16_s $push19=, $5
; NO-SIMD128-NEXT:    i32.extend16_s $push18=, $13
; NO-SIMD128-NEXT:    i32.lt_s $push20=, $pop19, $pop18
; NO-SIMD128-NEXT:    i32.select $push21=, $5, $13, $pop20
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop21
; NO-SIMD128-NEXT:    i32.const $push26=, 6
; NO-SIMD128-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-NEXT:    i32.extend16_s $push23=, $4
; NO-SIMD128-NEXT:    i32.extend16_s $push22=, $12
; NO-SIMD128-NEXT:    i32.lt_s $push24=, $pop23, $pop22
; NO-SIMD128-NEXT:    i32.select $push25=, $4, $12, $pop24
; NO-SIMD128-NEXT:    i32.store16 0($pop27), $pop25
; NO-SIMD128-NEXT:    i32.extend16_s $push29=, $3
; NO-SIMD128-NEXT:    i32.extend16_s $push28=, $11
; NO-SIMD128-NEXT:    i32.lt_s $push30=, $pop29, $pop28
; NO-SIMD128-NEXT:    i32.select $push31=, $3, $11, $pop30
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop31
; NO-SIMD128-NEXT:    i32.extend16_s $push33=, $2
; NO-SIMD128-NEXT:    i32.extend16_s $push32=, $10
; NO-SIMD128-NEXT:    i32.lt_s $push34=, $pop33, $pop32
; NO-SIMD128-NEXT:    i32.select $push35=, $2, $10, $pop34
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop35
; NO-SIMD128-NEXT:    i32.extend16_s $push37=, $1
; NO-SIMD128-NEXT:    i32.extend16_s $push36=, $9
; NO-SIMD128-NEXT:    i32.lt_s $push38=, $pop37, $pop36
; NO-SIMD128-NEXT:    i32.select $push39=, $1, $9, $pop38
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop39
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_s_v8i16:
; NO-SIMD128-FAST:         .functype min_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push0=, $9
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $1, $9, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push5=, $2
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push4=, $10
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $2, $10, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push9=, $3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push8=, $11
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push10=, $pop9, $pop8
; NO-SIMD128-FAST-NEXT:    i32.select $push11=, $3, $11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push16=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push13=, $4
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push12=, $12
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.select $push15=, $4, $12, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop17), $pop15
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push19=, $5
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push18=, $13
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push20=, $pop19, $pop18
; NO-SIMD128-FAST-NEXT:    i32.select $push21=, $5, $13, $pop20
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push23=, $6
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push22=, $14
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push24=, $pop23, $pop22
; NO-SIMD128-FAST-NEXT:    i32.select $push25=, $6, $14, $pop24
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop27), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $0, $pop32
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push29=, $7
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push28=, $15
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.select $push31=, $7, $15, $pop30
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop33), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $0, $pop38
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push35=, $8
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push34=, $16
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push36=, $pop35, $pop34
; NO-SIMD128-FAST-NEXT:    i32.select $push37=, $8, $16, $pop36
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop39), $pop37
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp slt <8 x i16> %x, %y
  %a = select <8 x i1> %c, <8 x i16> %x, <8 x i16> %y
  ret <8 x i16> %a
}

define <8 x i16> @min_u_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: min_u_v8i16:
; SIMD128:         .functype min_u_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.min_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_u_v8i16:
; SIMD128-FAST:         .functype min_u_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.min_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_u_v8i16:
; NO-SIMD128:         .functype min_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push5=, 14
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push2=, $8, $pop0
; NO-SIMD128-NEXT:    i32.const $push55=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $16, $pop55
; NO-SIMD128-NEXT:    i32.lt_u $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.select $push4=, $8, $16, $pop3
; NO-SIMD128-NEXT:    i32.store16 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push11=, 12
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.const $push54=, 65535
; NO-SIMD128-NEXT:    i32.and $push8=, $7, $pop54
; NO-SIMD128-NEXT:    i32.const $push53=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $15, $pop53
; NO-SIMD128-NEXT:    i32.lt_u $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.select $push10=, $7, $15, $pop9
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push17=, 10
; NO-SIMD128-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-NEXT:    i32.const $push52=, 65535
; NO-SIMD128-NEXT:    i32.and $push14=, $6, $pop52
; NO-SIMD128-NEXT:    i32.const $push51=, 65535
; NO-SIMD128-NEXT:    i32.and $push13=, $14, $pop51
; NO-SIMD128-NEXT:    i32.lt_u $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.select $push16=, $6, $14, $pop15
; NO-SIMD128-NEXT:    i32.store16 0($pop18), $pop16
; NO-SIMD128-NEXT:    i32.const $push50=, 65535
; NO-SIMD128-NEXT:    i32.and $push20=, $5, $pop50
; NO-SIMD128-NEXT:    i32.const $push49=, 65535
; NO-SIMD128-NEXT:    i32.and $push19=, $13, $pop49
; NO-SIMD128-NEXT:    i32.lt_u $push21=, $pop20, $pop19
; NO-SIMD128-NEXT:    i32.select $push22=, $5, $13, $pop21
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop22
; NO-SIMD128-NEXT:    i32.const $push27=, 6
; NO-SIMD128-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-NEXT:    i32.const $push48=, 65535
; NO-SIMD128-NEXT:    i32.and $push24=, $4, $pop48
; NO-SIMD128-NEXT:    i32.const $push47=, 65535
; NO-SIMD128-NEXT:    i32.and $push23=, $12, $pop47
; NO-SIMD128-NEXT:    i32.lt_u $push25=, $pop24, $pop23
; NO-SIMD128-NEXT:    i32.select $push26=, $4, $12, $pop25
; NO-SIMD128-NEXT:    i32.store16 0($pop28), $pop26
; NO-SIMD128-NEXT:    i32.const $push46=, 65535
; NO-SIMD128-NEXT:    i32.and $push30=, $3, $pop46
; NO-SIMD128-NEXT:    i32.const $push45=, 65535
; NO-SIMD128-NEXT:    i32.and $push29=, $11, $pop45
; NO-SIMD128-NEXT:    i32.lt_u $push31=, $pop30, $pop29
; NO-SIMD128-NEXT:    i32.select $push32=, $3, $11, $pop31
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop32
; NO-SIMD128-NEXT:    i32.const $push44=, 65535
; NO-SIMD128-NEXT:    i32.and $push34=, $2, $pop44
; NO-SIMD128-NEXT:    i32.const $push43=, 65535
; NO-SIMD128-NEXT:    i32.and $push33=, $10, $pop43
; NO-SIMD128-NEXT:    i32.lt_u $push35=, $pop34, $pop33
; NO-SIMD128-NEXT:    i32.select $push36=, $2, $10, $pop35
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop36
; NO-SIMD128-NEXT:    i32.const $push42=, 65535
; NO-SIMD128-NEXT:    i32.and $push38=, $1, $pop42
; NO-SIMD128-NEXT:    i32.const $push41=, 65535
; NO-SIMD128-NEXT:    i32.and $push37=, $9, $pop41
; NO-SIMD128-NEXT:    i32.lt_u $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.select $push40=, $1, $9, $pop39
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop40
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_u_v8i16:
; NO-SIMD128-FAST:         .functype min_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $9, $pop55
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.select $push4=, $1, $9, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push54=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $2, $pop54
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $10, $pop53
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.select $push8=, $2, $10, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $3, $pop52
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $11, $pop51
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.select $push12=, $3, $11, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $4, $pop50
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $12, $pop49
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.select $push16=, $4, $12, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop18), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push48=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $5, $pop48
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $13, $pop47
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.select $push22=, $5, $13, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $6, $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $14, $pop45
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push25=, $pop24, $pop23
; NO-SIMD128-FAST-NEXT:    i32.select $push26=, $6, $14, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop28), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $7, $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $15, $pop43
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.select $push32=, $7, $15, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop34), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push36=, $8, $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push35=, $16, $pop41
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push37=, $pop36, $pop35
; NO-SIMD128-FAST-NEXT:    i32.select $push38=, $8, $16, $pop37
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop40), $pop38
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp ult <8 x i16> %x, %y
  %a = select <8 x i1> %c, <8 x i16> %x, <8 x i16> %y
  ret <8 x i16> %a
}

define <8 x i16> @max_s_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: max_s_v8i16:
; SIMD128:         .functype max_s_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.max_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_s_v8i16:
; SIMD128-FAST:         .functype max_s_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.max_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_s_v8i16:
; NO-SIMD128:         .functype max_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push4=, 14
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.extend16_s $push1=, $8
; NO-SIMD128-NEXT:    i32.extend16_s $push0=, $16
; NO-SIMD128-NEXT:    i32.gt_s $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.select $push3=, $8, $16, $pop2
; NO-SIMD128-NEXT:    i32.store16 0($pop5), $pop3
; NO-SIMD128-NEXT:    i32.const $push10=, 12
; NO-SIMD128-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-NEXT:    i32.extend16_s $push7=, $7
; NO-SIMD128-NEXT:    i32.extend16_s $push6=, $15
; NO-SIMD128-NEXT:    i32.gt_s $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.select $push9=, $7, $15, $pop8
; NO-SIMD128-NEXT:    i32.store16 0($pop11), $pop9
; NO-SIMD128-NEXT:    i32.const $push16=, 10
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.extend16_s $push13=, $6
; NO-SIMD128-NEXT:    i32.extend16_s $push12=, $14
; NO-SIMD128-NEXT:    i32.gt_s $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.select $push15=, $6, $14, $pop14
; NO-SIMD128-NEXT:    i32.store16 0($pop17), $pop15
; NO-SIMD128-NEXT:    i32.extend16_s $push19=, $5
; NO-SIMD128-NEXT:    i32.extend16_s $push18=, $13
; NO-SIMD128-NEXT:    i32.gt_s $push20=, $pop19, $pop18
; NO-SIMD128-NEXT:    i32.select $push21=, $5, $13, $pop20
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop21
; NO-SIMD128-NEXT:    i32.const $push26=, 6
; NO-SIMD128-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-NEXT:    i32.extend16_s $push23=, $4
; NO-SIMD128-NEXT:    i32.extend16_s $push22=, $12
; NO-SIMD128-NEXT:    i32.gt_s $push24=, $pop23, $pop22
; NO-SIMD128-NEXT:    i32.select $push25=, $4, $12, $pop24
; NO-SIMD128-NEXT:    i32.store16 0($pop27), $pop25
; NO-SIMD128-NEXT:    i32.extend16_s $push29=, $3
; NO-SIMD128-NEXT:    i32.extend16_s $push28=, $11
; NO-SIMD128-NEXT:    i32.gt_s $push30=, $pop29, $pop28
; NO-SIMD128-NEXT:    i32.select $push31=, $3, $11, $pop30
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop31
; NO-SIMD128-NEXT:    i32.extend16_s $push33=, $2
; NO-SIMD128-NEXT:    i32.extend16_s $push32=, $10
; NO-SIMD128-NEXT:    i32.gt_s $push34=, $pop33, $pop32
; NO-SIMD128-NEXT:    i32.select $push35=, $2, $10, $pop34
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop35
; NO-SIMD128-NEXT:    i32.extend16_s $push37=, $1
; NO-SIMD128-NEXT:    i32.extend16_s $push36=, $9
; NO-SIMD128-NEXT:    i32.gt_s $push38=, $pop37, $pop36
; NO-SIMD128-NEXT:    i32.select $push39=, $1, $9, $pop38
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop39
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_s_v8i16:
; NO-SIMD128-FAST:         .functype max_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push0=, $9
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $1, $9, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push5=, $2
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push4=, $10
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $2, $10, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push9=, $3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push8=, $11
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push10=, $pop9, $pop8
; NO-SIMD128-FAST-NEXT:    i32.select $push11=, $3, $11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push16=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push13=, $4
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push12=, $12
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.select $push15=, $4, $12, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop17), $pop15
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push19=, $5
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push18=, $13
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push20=, $pop19, $pop18
; NO-SIMD128-FAST-NEXT:    i32.select $push21=, $5, $13, $pop20
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push23=, $6
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push22=, $14
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push24=, $pop23, $pop22
; NO-SIMD128-FAST-NEXT:    i32.select $push25=, $6, $14, $pop24
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop27), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push32=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $0, $pop32
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push29=, $7
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push28=, $15
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.select $push31=, $7, $15, $pop30
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop33), $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $0, $pop38
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push35=, $8
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push34=, $16
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push36=, $pop35, $pop34
; NO-SIMD128-FAST-NEXT:    i32.select $push37=, $8, $16, $pop36
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop39), $pop37
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp sgt <8 x i16> %x, %y
  %a = select <8 x i1> %c, <8 x i16> %x, <8 x i16> %y
  ret <8 x i16> %a
}

define <8 x i16> @max_u_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: max_u_v8i16:
; SIMD128:         .functype max_u_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.max_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_u_v8i16:
; SIMD128-FAST:         .functype max_u_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.max_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_u_v8i16:
; NO-SIMD128:         .functype max_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push5=, 14
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push2=, $8, $pop0
; NO-SIMD128-NEXT:    i32.const $push55=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $16, $pop55
; NO-SIMD128-NEXT:    i32.gt_u $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.select $push4=, $8, $16, $pop3
; NO-SIMD128-NEXT:    i32.store16 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push11=, 12
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.const $push54=, 65535
; NO-SIMD128-NEXT:    i32.and $push8=, $7, $pop54
; NO-SIMD128-NEXT:    i32.const $push53=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $15, $pop53
; NO-SIMD128-NEXT:    i32.gt_u $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.select $push10=, $7, $15, $pop9
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push17=, 10
; NO-SIMD128-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-NEXT:    i32.const $push52=, 65535
; NO-SIMD128-NEXT:    i32.and $push14=, $6, $pop52
; NO-SIMD128-NEXT:    i32.const $push51=, 65535
; NO-SIMD128-NEXT:    i32.and $push13=, $14, $pop51
; NO-SIMD128-NEXT:    i32.gt_u $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.select $push16=, $6, $14, $pop15
; NO-SIMD128-NEXT:    i32.store16 0($pop18), $pop16
; NO-SIMD128-NEXT:    i32.const $push50=, 65535
; NO-SIMD128-NEXT:    i32.and $push20=, $5, $pop50
; NO-SIMD128-NEXT:    i32.const $push49=, 65535
; NO-SIMD128-NEXT:    i32.and $push19=, $13, $pop49
; NO-SIMD128-NEXT:    i32.gt_u $push21=, $pop20, $pop19
; NO-SIMD128-NEXT:    i32.select $push22=, $5, $13, $pop21
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop22
; NO-SIMD128-NEXT:    i32.const $push27=, 6
; NO-SIMD128-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-NEXT:    i32.const $push48=, 65535
; NO-SIMD128-NEXT:    i32.and $push24=, $4, $pop48
; NO-SIMD128-NEXT:    i32.const $push47=, 65535
; NO-SIMD128-NEXT:    i32.and $push23=, $12, $pop47
; NO-SIMD128-NEXT:    i32.gt_u $push25=, $pop24, $pop23
; NO-SIMD128-NEXT:    i32.select $push26=, $4, $12, $pop25
; NO-SIMD128-NEXT:    i32.store16 0($pop28), $pop26
; NO-SIMD128-NEXT:    i32.const $push46=, 65535
; NO-SIMD128-NEXT:    i32.and $push30=, $3, $pop46
; NO-SIMD128-NEXT:    i32.const $push45=, 65535
; NO-SIMD128-NEXT:    i32.and $push29=, $11, $pop45
; NO-SIMD128-NEXT:    i32.gt_u $push31=, $pop30, $pop29
; NO-SIMD128-NEXT:    i32.select $push32=, $3, $11, $pop31
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop32
; NO-SIMD128-NEXT:    i32.const $push44=, 65535
; NO-SIMD128-NEXT:    i32.and $push34=, $2, $pop44
; NO-SIMD128-NEXT:    i32.const $push43=, 65535
; NO-SIMD128-NEXT:    i32.and $push33=, $10, $pop43
; NO-SIMD128-NEXT:    i32.gt_u $push35=, $pop34, $pop33
; NO-SIMD128-NEXT:    i32.select $push36=, $2, $10, $pop35
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop36
; NO-SIMD128-NEXT:    i32.const $push42=, 65535
; NO-SIMD128-NEXT:    i32.and $push38=, $1, $pop42
; NO-SIMD128-NEXT:    i32.const $push41=, 65535
; NO-SIMD128-NEXT:    i32.and $push37=, $9, $pop41
; NO-SIMD128-NEXT:    i32.gt_u $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.select $push40=, $1, $9, $pop39
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop40
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_u_v8i16:
; NO-SIMD128-FAST:         .functype max_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $9, $pop55
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.select $push4=, $1, $9, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push54=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $2, $pop54
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $10, $pop53
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.select $push8=, $2, $10, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $3, $pop52
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $11, $pop51
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.select $push12=, $3, $11, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push14=, $4, $pop50
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $12, $pop49
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.select $push16=, $4, $12, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop18), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push48=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $5, $pop48
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $13, $pop47
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.select $push22=, $5, $13, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $6, $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $14, $pop45
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push25=, $pop24, $pop23
; NO-SIMD128-FAST-NEXT:    i32.select $push26=, $6, $14, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop28), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $7, $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $15, $pop43
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.select $push32=, $7, $15, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop34), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push36=, $8, $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push35=, $16, $pop41
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push37=, $pop36, $pop35
; NO-SIMD128-FAST-NEXT:    i32.select $push38=, $8, $16, $pop37
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop40), $pop38
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp ugt <8 x i16> %x, %y
  %a = select <8 x i1> %c, <8 x i16> %x, <8 x i16> %y
  ret <8 x i16> %a
}

define <8 x i16> @avgr_u_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: avgr_u_v8i16:
; SIMD128:         .functype avgr_u_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.avgr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: avgr_u_v8i16:
; SIMD128-FAST:         .functype avgr_u_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.avgr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: avgr_u_v8i16:
; NO-SIMD128:         .functype avgr_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 14
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.add $push2=, $8, $16
; NO-SIMD128-NEXT:    i32.const $push3=, 1
; NO-SIMD128-NEXT:    i32.add $push4=, $pop2, $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 65534
; NO-SIMD128-NEXT:    i32.and $push6=, $pop4, $pop5
; NO-SIMD128-NEXT:    i32.const $push63=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push7=, $pop6, $pop63
; NO-SIMD128-NEXT:    i32.store16 0($pop1), $pop7
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.add $push10=, $7, $15
; NO-SIMD128-NEXT:    i32.const $push62=, 1
; NO-SIMD128-NEXT:    i32.add $push11=, $pop10, $pop62
; NO-SIMD128-NEXT:    i32.const $push61=, 65534
; NO-SIMD128-NEXT:    i32.and $push12=, $pop11, $pop61
; NO-SIMD128-NEXT:    i32.const $push60=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push13=, $pop12, $pop60
; NO-SIMD128-NEXT:    i32.store16 0($pop9), $pop13
; NO-SIMD128-NEXT:    i32.const $push14=, 10
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.add $push16=, $6, $14
; NO-SIMD128-NEXT:    i32.const $push59=, 1
; NO-SIMD128-NEXT:    i32.add $push17=, $pop16, $pop59
; NO-SIMD128-NEXT:    i32.const $push58=, 65534
; NO-SIMD128-NEXT:    i32.and $push18=, $pop17, $pop58
; NO-SIMD128-NEXT:    i32.const $push57=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push19=, $pop18, $pop57
; NO-SIMD128-NEXT:    i32.store16 0($pop15), $pop19
; NO-SIMD128-NEXT:    i32.add $push20=, $5, $13
; NO-SIMD128-NEXT:    i32.const $push56=, 1
; NO-SIMD128-NEXT:    i32.add $push21=, $pop20, $pop56
; NO-SIMD128-NEXT:    i32.const $push55=, 65534
; NO-SIMD128-NEXT:    i32.and $push22=, $pop21, $pop55
; NO-SIMD128-NEXT:    i32.const $push54=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push23=, $pop22, $pop54
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop23
; NO-SIMD128-NEXT:    i32.const $push24=, 6
; NO-SIMD128-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-NEXT:    i32.add $push26=, $4, $12
; NO-SIMD128-NEXT:    i32.const $push53=, 1
; NO-SIMD128-NEXT:    i32.add $push27=, $pop26, $pop53
; NO-SIMD128-NEXT:    i32.const $push52=, 65534
; NO-SIMD128-NEXT:    i32.and $push28=, $pop27, $pop52
; NO-SIMD128-NEXT:    i32.const $push51=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push29=, $pop28, $pop51
; NO-SIMD128-NEXT:    i32.store16 0($pop25), $pop29
; NO-SIMD128-NEXT:    i32.add $push30=, $3, $11
; NO-SIMD128-NEXT:    i32.const $push50=, 1
; NO-SIMD128-NEXT:    i32.add $push31=, $pop30, $pop50
; NO-SIMD128-NEXT:    i32.const $push49=, 65534
; NO-SIMD128-NEXT:    i32.and $push32=, $pop31, $pop49
; NO-SIMD128-NEXT:    i32.const $push48=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push33=, $pop32, $pop48
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop33
; NO-SIMD128-NEXT:    i32.add $push34=, $2, $10
; NO-SIMD128-NEXT:    i32.const $push47=, 1
; NO-SIMD128-NEXT:    i32.add $push35=, $pop34, $pop47
; NO-SIMD128-NEXT:    i32.const $push46=, 65534
; NO-SIMD128-NEXT:    i32.and $push36=, $pop35, $pop46
; NO-SIMD128-NEXT:    i32.const $push45=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push37=, $pop36, $pop45
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop37
; NO-SIMD128-NEXT:    i32.add $push38=, $1, $9
; NO-SIMD128-NEXT:    i32.const $push44=, 1
; NO-SIMD128-NEXT:    i32.add $push39=, $pop38, $pop44
; NO-SIMD128-NEXT:    i32.const $push43=, 65534
; NO-SIMD128-NEXT:    i32.and $push40=, $pop39, $pop43
; NO-SIMD128-NEXT:    i32.const $push42=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push41=, $pop40, $pop42
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop41
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: avgr_u_v8i16:
; NO-SIMD128-FAST:         .functype avgr_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $pop0, $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push63=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push5=, $pop4, $pop63
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.const $push62=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push7=, $pop6, $pop62
; NO-SIMD128-FAST-NEXT:    i32.const $push61=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $pop7, $pop61
; NO-SIMD128-FAST-NEXT:    i32.const $push60=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop60
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.const $push59=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $pop10, $pop59
; NO-SIMD128-FAST-NEXT:    i32.const $push58=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $pop11, $pop58
; NO-SIMD128-FAST-NEXT:    i32.const $push57=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push13=, $pop12, $pop57
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-FAST-NEXT:    i32.add $push16=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.const $push56=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push17=, $pop16, $pop56
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop55
; NO-SIMD128-FAST-NEXT:    i32.const $push54=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push19=, $pop18, $pop54
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop15), $pop19
; NO-SIMD128-FAST-NEXT:    i32.add $push20=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push21=, $pop20, $pop53
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $pop21, $pop52
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push23=, $pop22, $pop51
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop23
; NO-SIMD128-FAST-NEXT:    i32.const $push24=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-FAST-NEXT:    i32.add $push26=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $pop26, $pop50
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop49
; NO-SIMD128-FAST-NEXT:    i32.const $push48=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push29=, $pop28, $pop48
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop25), $pop29
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-FAST-NEXT:    i32.add $push32=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $pop32, $pop47
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $pop33, $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push35=, $pop34, $pop45
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop31), $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-FAST-NEXT:    i32.add $push38=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $pop38, $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push40=, $pop39, $pop43
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push41=, $pop40, $pop42
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop37), $pop41
; NO-SIMD128-FAST-NEXT:    return
  %a = add nuw <8 x i16> %x, %y
  %b = add nuw <8 x i16> %a, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %c = udiv <8 x i16> %b, <i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2>
  ret <8 x i16> %c
}

define <8 x i16> @avgr_u_v8i16_wrap(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: avgr_u_v8i16_wrap:
; SIMD128:         .functype avgr_u_v8i16_wrap (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.add $push0=, $0, $1
; SIMD128-NEXT:    v128.const $push1=, 1, 1, 1, 1, 1, 1, 1, 1
; SIMD128-NEXT:    i16x8.add $push2=, $pop0, $pop1
; SIMD128-NEXT:    i32.const $push3=, 1
; SIMD128-NEXT:    i16x8.shr_u $push4=, $pop2, $pop3
; SIMD128-NEXT:    return $pop4
;
; SIMD128-FAST-LABEL: avgr_u_v8i16_wrap:
; SIMD128-FAST:         .functype avgr_u_v8i16_wrap (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.add $push2=, $0, $1
; SIMD128-FAST-NEXT:    v128.const $push3=, 1, 1, 1, 1, 1, 1, 1, 1
; SIMD128-FAST-NEXT:    i16x8.add $push1=, $pop2, $pop3
; SIMD128-FAST-NEXT:    i32.const $push4=, 1
; SIMD128-FAST-NEXT:    i16x8.shr_u $push0=, $pop1, $pop4
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: avgr_u_v8i16_wrap:
; NO-SIMD128:         .functype avgr_u_v8i16_wrap (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 14
; NO-SIMD128-NEXT:    i32.add $push1=, $0, $pop0
; NO-SIMD128-NEXT:    i32.add $push2=, $8, $16
; NO-SIMD128-NEXT:    i32.const $push3=, 1
; NO-SIMD128-NEXT:    i32.add $push4=, $pop2, $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 65534
; NO-SIMD128-NEXT:    i32.and $push6=, $pop4, $pop5
; NO-SIMD128-NEXT:    i32.const $push63=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push7=, $pop6, $pop63
; NO-SIMD128-NEXT:    i32.store16 0($pop1), $pop7
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.add $push10=, $7, $15
; NO-SIMD128-NEXT:    i32.const $push62=, 1
; NO-SIMD128-NEXT:    i32.add $push11=, $pop10, $pop62
; NO-SIMD128-NEXT:    i32.const $push61=, 65534
; NO-SIMD128-NEXT:    i32.and $push12=, $pop11, $pop61
; NO-SIMD128-NEXT:    i32.const $push60=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push13=, $pop12, $pop60
; NO-SIMD128-NEXT:    i32.store16 0($pop9), $pop13
; NO-SIMD128-NEXT:    i32.const $push14=, 10
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.add $push16=, $6, $14
; NO-SIMD128-NEXT:    i32.const $push59=, 1
; NO-SIMD128-NEXT:    i32.add $push17=, $pop16, $pop59
; NO-SIMD128-NEXT:    i32.const $push58=, 65534
; NO-SIMD128-NEXT:    i32.and $push18=, $pop17, $pop58
; NO-SIMD128-NEXT:    i32.const $push57=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push19=, $pop18, $pop57
; NO-SIMD128-NEXT:    i32.store16 0($pop15), $pop19
; NO-SIMD128-NEXT:    i32.add $push20=, $5, $13
; NO-SIMD128-NEXT:    i32.const $push56=, 1
; NO-SIMD128-NEXT:    i32.add $push21=, $pop20, $pop56
; NO-SIMD128-NEXT:    i32.const $push55=, 65534
; NO-SIMD128-NEXT:    i32.and $push22=, $pop21, $pop55
; NO-SIMD128-NEXT:    i32.const $push54=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push23=, $pop22, $pop54
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop23
; NO-SIMD128-NEXT:    i32.const $push24=, 6
; NO-SIMD128-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-NEXT:    i32.add $push26=, $4, $12
; NO-SIMD128-NEXT:    i32.const $push53=, 1
; NO-SIMD128-NEXT:    i32.add $push27=, $pop26, $pop53
; NO-SIMD128-NEXT:    i32.const $push52=, 65534
; NO-SIMD128-NEXT:    i32.and $push28=, $pop27, $pop52
; NO-SIMD128-NEXT:    i32.const $push51=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push29=, $pop28, $pop51
; NO-SIMD128-NEXT:    i32.store16 0($pop25), $pop29
; NO-SIMD128-NEXT:    i32.add $push30=, $3, $11
; NO-SIMD128-NEXT:    i32.const $push50=, 1
; NO-SIMD128-NEXT:    i32.add $push31=, $pop30, $pop50
; NO-SIMD128-NEXT:    i32.const $push49=, 65534
; NO-SIMD128-NEXT:    i32.and $push32=, $pop31, $pop49
; NO-SIMD128-NEXT:    i32.const $push48=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push33=, $pop32, $pop48
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop33
; NO-SIMD128-NEXT:    i32.add $push34=, $2, $10
; NO-SIMD128-NEXT:    i32.const $push47=, 1
; NO-SIMD128-NEXT:    i32.add $push35=, $pop34, $pop47
; NO-SIMD128-NEXT:    i32.const $push46=, 65534
; NO-SIMD128-NEXT:    i32.and $push36=, $pop35, $pop46
; NO-SIMD128-NEXT:    i32.const $push45=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push37=, $pop36, $pop45
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop37
; NO-SIMD128-NEXT:    i32.add $push38=, $1, $9
; NO-SIMD128-NEXT:    i32.const $push44=, 1
; NO-SIMD128-NEXT:    i32.add $push39=, $pop38, $pop44
; NO-SIMD128-NEXT:    i32.const $push43=, 65534
; NO-SIMD128-NEXT:    i32.and $push40=, $pop39, $pop43
; NO-SIMD128-NEXT:    i32.const $push42=, 1
; NO-SIMD128-NEXT:    i32.shr_u $push41=, $pop40, $pop42
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop41
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: avgr_u_v8i16_wrap:
; NO-SIMD128-FAST:         .functype avgr_u_v8i16_wrap (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $pop0, $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push63=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push5=, $pop4, $pop63
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.const $push62=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push7=, $pop6, $pop62
; NO-SIMD128-FAST-NEXT:    i32.const $push61=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $pop7, $pop61
; NO-SIMD128-FAST-NEXT:    i32.const $push60=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop60
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.const $push59=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $pop10, $pop59
; NO-SIMD128-FAST-NEXT:    i32.const $push58=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $pop11, $pop58
; NO-SIMD128-FAST-NEXT:    i32.const $push57=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push13=, $pop12, $pop57
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-FAST-NEXT:    i32.add $push16=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.const $push56=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push17=, $pop16, $pop56
; NO-SIMD128-FAST-NEXT:    i32.const $push55=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop55
; NO-SIMD128-FAST-NEXT:    i32.const $push54=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push19=, $pop18, $pop54
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop15), $pop19
; NO-SIMD128-FAST-NEXT:    i32.add $push20=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push21=, $pop20, $pop53
; NO-SIMD128-FAST-NEXT:    i32.const $push52=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push22=, $pop21, $pop52
; NO-SIMD128-FAST-NEXT:    i32.const $push51=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push23=, $pop22, $pop51
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop23
; NO-SIMD128-FAST-NEXT:    i32.const $push24=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push25=, $0, $pop24
; NO-SIMD128-FAST-NEXT:    i32.add $push26=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $pop26, $pop50
; NO-SIMD128-FAST-NEXT:    i32.const $push49=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop49
; NO-SIMD128-FAST-NEXT:    i32.const $push48=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push29=, $pop28, $pop48
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop25), $pop29
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-FAST-NEXT:    i32.add $push32=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push33=, $pop32, $pop47
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push34=, $pop33, $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push35=, $pop34, $pop45
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop31), $pop35
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push37=, $0, $pop36
; NO-SIMD128-FAST-NEXT:    i32.add $push38=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 1
; NO-SIMD128-FAST-NEXT:    i32.add $push39=, $pop38, $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 65534
; NO-SIMD128-FAST-NEXT:    i32.and $push40=, $pop39, $pop43
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push41=, $pop40, $pop42
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop37), $pop41
; NO-SIMD128-FAST-NEXT:    return
  %a = add <8 x i16> %x, %y
  %b = add <8 x i16> %a, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %c = udiv <8 x i16> %b, <i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2, i16 2>
  ret <8 x i16> %c
}

define <8 x i16> @abs_v8i16(<8 x i16> %x) {
; SIMD128-LABEL: abs_v8i16:
; SIMD128:         .functype abs_v8i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.abs $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: abs_v8i16:
; SIMD128-FAST:         .functype abs_v8i16 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.abs $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: abs_v8i16:
; NO-SIMD128:         .functype abs_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push4=, 14
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.extend16_s $push0=, $8
; NO-SIMD128-NEXT:    i32.const $push1=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push55=, $pop0, $pop1
; NO-SIMD128-NEXT:    local.tee $push54=, $9=, $pop55
; NO-SIMD128-NEXT:    i32.xor $push2=, $8, $pop54
; NO-SIMD128-NEXT:    i32.sub $push3=, $pop2, $9
; NO-SIMD128-NEXT:    i32.store16 0($pop5), $pop3
; NO-SIMD128-NEXT:    i32.const $push9=, 12
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    i32.extend16_s $push6=, $7
; NO-SIMD128-NEXT:    i32.const $push53=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push52=, $pop6, $pop53
; NO-SIMD128-NEXT:    local.tee $push51=, $8=, $pop52
; NO-SIMD128-NEXT:    i32.xor $push7=, $7, $pop51
; NO-SIMD128-NEXT:    i32.sub $push8=, $pop7, $8
; NO-SIMD128-NEXT:    i32.store16 0($pop10), $pop8
; NO-SIMD128-NEXT:    i32.const $push14=, 10
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.extend16_s $push11=, $6
; NO-SIMD128-NEXT:    i32.const $push50=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push49=, $pop11, $pop50
; NO-SIMD128-NEXT:    local.tee $push48=, $8=, $pop49
; NO-SIMD128-NEXT:    i32.xor $push12=, $6, $pop48
; NO-SIMD128-NEXT:    i32.sub $push13=, $pop12, $8
; NO-SIMD128-NEXT:    i32.store16 0($pop15), $pop13
; NO-SIMD128-NEXT:    i32.extend16_s $push16=, $5
; NO-SIMD128-NEXT:    i32.const $push47=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push46=, $pop16, $pop47
; NO-SIMD128-NEXT:    local.tee $push45=, $8=, $pop46
; NO-SIMD128-NEXT:    i32.xor $push17=, $5, $pop45
; NO-SIMD128-NEXT:    i32.sub $push18=, $pop17, $8
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop18
; NO-SIMD128-NEXT:    i32.const $push22=, 6
; NO-SIMD128-NEXT:    i32.add $push23=, $0, $pop22
; NO-SIMD128-NEXT:    i32.extend16_s $push19=, $4
; NO-SIMD128-NEXT:    i32.const $push44=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push43=, $pop19, $pop44
; NO-SIMD128-NEXT:    local.tee $push42=, $8=, $pop43
; NO-SIMD128-NEXT:    i32.xor $push20=, $4, $pop42
; NO-SIMD128-NEXT:    i32.sub $push21=, $pop20, $8
; NO-SIMD128-NEXT:    i32.store16 0($pop23), $pop21
; NO-SIMD128-NEXT:    i32.extend16_s $push24=, $3
; NO-SIMD128-NEXT:    i32.const $push41=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push40=, $pop24, $pop41
; NO-SIMD128-NEXT:    local.tee $push39=, $8=, $pop40
; NO-SIMD128-NEXT:    i32.xor $push25=, $3, $pop39
; NO-SIMD128-NEXT:    i32.sub $push26=, $pop25, $8
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop26
; NO-SIMD128-NEXT:    i32.extend16_s $push27=, $2
; NO-SIMD128-NEXT:    i32.const $push38=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push37=, $pop27, $pop38
; NO-SIMD128-NEXT:    local.tee $push36=, $8=, $pop37
; NO-SIMD128-NEXT:    i32.xor $push28=, $2, $pop36
; NO-SIMD128-NEXT:    i32.sub $push29=, $pop28, $8
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop29
; NO-SIMD128-NEXT:    i32.extend16_s $push30=, $1
; NO-SIMD128-NEXT:    i32.const $push35=, 15
; NO-SIMD128-NEXT:    i32.shr_s $push34=, $pop30, $pop35
; NO-SIMD128-NEXT:    local.tee $push33=, $8=, $pop34
; NO-SIMD128-NEXT:    i32.xor $push31=, $1, $pop33
; NO-SIMD128-NEXT:    i32.sub $push32=, $pop31, $8
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop32
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: abs_v8i16:
; NO-SIMD128-FAST:         .functype abs_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push0=, $1
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push55=, $pop0, $pop1
; NO-SIMD128-FAST-NEXT:    local.tee $push54=, $9=, $pop55
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $1, $pop54
; NO-SIMD128-FAST-NEXT:    i32.sub $push3=, $pop2, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push4=, $2
; NO-SIMD128-FAST-NEXT:    i32.const $push53=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push52=, $pop4, $pop53
; NO-SIMD128-FAST-NEXT:    local.tee $push51=, $1=, $pop52
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $2, $pop51
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $pop5, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push7=, $3
; NO-SIMD128-FAST-NEXT:    i32.const $push50=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push49=, $pop7, $pop50
; NO-SIMD128-FAST-NEXT:    local.tee $push48=, $2=, $pop49
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $3, $pop48
; NO-SIMD128-FAST-NEXT:    i32.sub $push9=, $pop8, $2
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push10=, $4
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push46=, $pop10, $pop47
; NO-SIMD128-FAST-NEXT:    local.tee $push45=, $3=, $pop46
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $4, $pop45
; NO-SIMD128-FAST-NEXT:    i32.sub $push12=, $pop11, $3
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop14), $pop12
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push15=, $5
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push43=, $pop15, $pop44
; NO-SIMD128-FAST-NEXT:    local.tee $push42=, $4=, $pop43
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $5, $pop42
; NO-SIMD128-FAST-NEXT:    i32.sub $push17=, $pop16, $4
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push18=, $6
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push40=, $pop18, $pop41
; NO-SIMD128-FAST-NEXT:    local.tee $push39=, $5=, $pop40
; NO-SIMD128-FAST-NEXT:    i32.xor $push19=, $6, $pop39
; NO-SIMD128-FAST-NEXT:    i32.sub $push20=, $pop19, $5
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop22), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push23=, $7
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push37=, $pop23, $pop38
; NO-SIMD128-FAST-NEXT:    local.tee $push36=, $6=, $pop37
; NO-SIMD128-FAST-NEXT:    i32.xor $push24=, $7, $pop36
; NO-SIMD128-FAST-NEXT:    i32.sub $push25=, $pop24, $6
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop27), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push28=, $8
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 15
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push34=, $pop28, $pop35
; NO-SIMD128-FAST-NEXT:    local.tee $push33=, $0=, $pop34
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $8, $pop33
; NO-SIMD128-FAST-NEXT:    i32.sub $push30=, $pop29, $0
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop32), $pop30
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <8 x i16> zeroinitializer, %x
  %b = icmp slt <8 x i16> %x, zeroinitializer
  %c = select <8 x i1> %b, <8 x i16> %a, <8 x i16> %x
  ret <8 x i16> %c
}

define <8 x i16> @neg_v8i16(<8 x i16> %x) {
; SIMD128-LABEL: neg_v8i16:
; SIMD128:         .functype neg_v8i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.neg $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: neg_v8i16:
; SIMD128-FAST:         .functype neg_v8i16 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.neg $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: neg_v8i16:
; NO-SIMD128:         .functype neg_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 0
; NO-SIMD128-NEXT:    i32.sub $push1=, $pop0, $5
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push23=, 0
; NO-SIMD128-NEXT:    i32.sub $push2=, $pop23, $3
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push22=, 0
; NO-SIMD128-NEXT:    i32.sub $push3=, $pop22, $2
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push21=, 0
; NO-SIMD128-NEXT:    i32.sub $push4=, $pop21, $1
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push6=, 14
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.const $push20=, 0
; NO-SIMD128-NEXT:    i32.sub $push5=, $pop20, $8
; NO-SIMD128-NEXT:    i32.store16 0($pop7), $pop5
; NO-SIMD128-NEXT:    i32.const $push9=, 12
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    i32.const $push19=, 0
; NO-SIMD128-NEXT:    i32.sub $push8=, $pop19, $7
; NO-SIMD128-NEXT:    i32.store16 0($pop10), $pop8
; NO-SIMD128-NEXT:    i32.const $push12=, 10
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.const $push18=, 0
; NO-SIMD128-NEXT:    i32.sub $push11=, $pop18, $6
; NO-SIMD128-NEXT:    i32.store16 0($pop13), $pop11
; NO-SIMD128-NEXT:    i32.const $push15=, 6
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.const $push17=, 0
; NO-SIMD128-NEXT:    i32.sub $push14=, $pop17, $4
; NO-SIMD128-NEXT:    i32.store16 0($pop16), $pop14
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: neg_v8i16:
; NO-SIMD128-FAST:         .functype neg_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $pop23, $2
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push22=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push3=, $pop22, $3
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $pop21, $4
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop5), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push7=, $pop20, $5
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push10=, $pop19, $6
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop9), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push11=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push13=, $pop18, $7
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop12), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push16=, $pop17, $8
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop15), $pop16
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <8 x i16> <i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0, i16 0>,
                     %x
  ret <8 x i16> %a
}

define <8 x i16> @shl_v8i16(<8 x i16> %v, i16 %x) {
; SIMD128-LABEL: shl_v8i16:
; SIMD128:         .functype shl_v8i16 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.shl $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shl_v8i16:
; SIMD128-FAST:         .functype shl_v8i16 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.shl $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_v8i16:
; NO-SIMD128:         .functype shl_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push18=, $9, $pop0
; NO-SIMD128-NEXT:    local.tee $push17=, $9=, $pop18
; NO-SIMD128-NEXT:    i32.shl $push1=, $5, $pop17
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop1
; NO-SIMD128-NEXT:    i32.shl $push2=, $3, $9
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-NEXT:    i32.shl $push3=, $2, $9
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop3
; NO-SIMD128-NEXT:    i32.shl $push4=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push6=, 14
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.shl $push5=, $8, $9
; NO-SIMD128-NEXT:    i32.store16 0($pop7), $pop5
; NO-SIMD128-NEXT:    i32.const $push9=, 12
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    i32.shl $push8=, $7, $9
; NO-SIMD128-NEXT:    i32.store16 0($pop10), $pop8
; NO-SIMD128-NEXT:    i32.const $push12=, 10
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.shl $push11=, $6, $9
; NO-SIMD128-NEXT:    i32.store16 0($pop13), $pop11
; NO-SIMD128-NEXT:    i32.const $push15=, 6
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.shl $push14=, $4, $9
; NO-SIMD128-NEXT:    i32.store16 0($pop16), $pop14
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_v8i16:
; NO-SIMD128-FAST:         .functype shl_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $9, $pop0
; NO-SIMD128-FAST-NEXT:    local.tee $push17=, $9=, $pop18
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $2, $pop17
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.shl $push3=, $3, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-FAST-NEXT:    i32.shl $push6=, $4, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop5), $pop6
; NO-SIMD128-FAST-NEXT:    i32.shl $push7=, $5, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-FAST-NEXT:    i32.shl $push10=, $6, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop9), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push11=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-FAST-NEXT:    i32.shl $push13=, $7, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop12), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-FAST-NEXT:    i32.shl $push16=, $8, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop15), $pop16
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <8 x i16> undef, i16 %x, i32 0
  %s = shufflevector <8 x i16> %t, <8 x i16> undef,
    <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %a = shl <8 x i16> %v, %s
  ret <8 x i16> %a
}

define <8 x i16> @shl_const_v8i16(<8 x i16> %v) {
; SIMD128-LABEL: shl_const_v8i16:
; SIMD128:         .functype shl_const_v8i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.const $push0=, 5
; SIMD128-NEXT:    i16x8.shl $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shl_const_v8i16:
; SIMD128-FAST:         .functype shl_const_v8i16 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.const $push1=, 5
; SIMD128-FAST-NEXT:    i16x8.shl $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_const_v8i16:
; NO-SIMD128:         .functype shl_const_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 5
; NO-SIMD128-NEXT:    i32.shl $push1=, $5, $pop0
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push23=, 5
; NO-SIMD128-NEXT:    i32.shl $push2=, $3, $pop23
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push22=, 5
; NO-SIMD128-NEXT:    i32.shl $push3=, $2, $pop22
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push21=, 5
; NO-SIMD128-NEXT:    i32.shl $push4=, $1, $pop21
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push6=, 14
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.const $push20=, 5
; NO-SIMD128-NEXT:    i32.shl $push5=, $8, $pop20
; NO-SIMD128-NEXT:    i32.store16 0($pop7), $pop5
; NO-SIMD128-NEXT:    i32.const $push9=, 12
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    i32.const $push19=, 5
; NO-SIMD128-NEXT:    i32.shl $push8=, $7, $pop19
; NO-SIMD128-NEXT:    i32.store16 0($pop10), $pop8
; NO-SIMD128-NEXT:    i32.const $push12=, 10
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.const $push18=, 5
; NO-SIMD128-NEXT:    i32.shl $push11=, $6, $pop18
; NO-SIMD128-NEXT:    i32.store16 0($pop13), $pop11
; NO-SIMD128-NEXT:    i32.const $push15=, 6
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.const $push17=, 5
; NO-SIMD128-NEXT:    i32.shl $push14=, $4, $pop17
; NO-SIMD128-NEXT:    i32.store16 0($pop16), $pop14
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_const_v8i16:
; NO-SIMD128-FAST:         .functype shl_const_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $2, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push22=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push3=, $3, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push6=, $4, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop5), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push7=, $5, $pop20
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push10=, $6, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop9), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push11=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push13=, $7, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop12), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push16=, $8, $pop17
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop15), $pop16
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <8 x i16> %v,
    <i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5, i16 5>
  ret <8 x i16> %a
}

define <8 x i16> @shl_vec_v8i16(<8 x i16> %v, <8 x i16> %x) {
; SIMD128-LABEL: shl_vec_v8i16:
; SIMD128:         .functype shl_vec_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extract_lane_u $push7=, $0, 0
; SIMD128-NEXT:    i16x8.extract_lane_u $push5=, $1, 0
; SIMD128-NEXT:    i32.const $push1=, 15
; SIMD128-NEXT:    i32.and $push6=, $pop5, $pop1
; SIMD128-NEXT:    i32.shl $push8=, $pop7, $pop6
; SIMD128-NEXT:    i16x8.splat $push9=, $pop8
; SIMD128-NEXT:    i16x8.extract_lane_u $push3=, $0, 1
; SIMD128-NEXT:    i16x8.extract_lane_u $push0=, $1, 1
; SIMD128-NEXT:    i32.const $push47=, 15
; SIMD128-NEXT:    i32.and $push2=, $pop0, $pop47
; SIMD128-NEXT:    i32.shl $push4=, $pop3, $pop2
; SIMD128-NEXT:    i16x8.replace_lane $push10=, $pop9, 1, $pop4
; SIMD128-NEXT:    i16x8.extract_lane_u $push13=, $0, 2
; SIMD128-NEXT:    i16x8.extract_lane_u $push11=, $1, 2
; SIMD128-NEXT:    i32.const $push46=, 15
; SIMD128-NEXT:    i32.and $push12=, $pop11, $pop46
; SIMD128-NEXT:    i32.shl $push14=, $pop13, $pop12
; SIMD128-NEXT:    i16x8.replace_lane $push15=, $pop10, 2, $pop14
; SIMD128-NEXT:    i16x8.extract_lane_u $push18=, $0, 3
; SIMD128-NEXT:    i16x8.extract_lane_u $push16=, $1, 3
; SIMD128-NEXT:    i32.const $push45=, 15
; SIMD128-NEXT:    i32.and $push17=, $pop16, $pop45
; SIMD128-NEXT:    i32.shl $push19=, $pop18, $pop17
; SIMD128-NEXT:    i16x8.replace_lane $push20=, $pop15, 3, $pop19
; SIMD128-NEXT:    i16x8.extract_lane_u $push23=, $0, 4
; SIMD128-NEXT:    i16x8.extract_lane_u $push21=, $1, 4
; SIMD128-NEXT:    i32.const $push44=, 15
; SIMD128-NEXT:    i32.and $push22=, $pop21, $pop44
; SIMD128-NEXT:    i32.shl $push24=, $pop23, $pop22
; SIMD128-NEXT:    i16x8.replace_lane $push25=, $pop20, 4, $pop24
; SIMD128-NEXT:    i16x8.extract_lane_u $push28=, $0, 5
; SIMD128-NEXT:    i16x8.extract_lane_u $push26=, $1, 5
; SIMD128-NEXT:    i32.const $push43=, 15
; SIMD128-NEXT:    i32.and $push27=, $pop26, $pop43
; SIMD128-NEXT:    i32.shl $push29=, $pop28, $pop27
; SIMD128-NEXT:    i16x8.replace_lane $push30=, $pop25, 5, $pop29
; SIMD128-NEXT:    i16x8.extract_lane_u $push33=, $0, 6
; SIMD128-NEXT:    i16x8.extract_lane_u $push31=, $1, 6
; SIMD128-NEXT:    i32.const $push42=, 15
; SIMD128-NEXT:    i32.and $push32=, $pop31, $pop42
; SIMD128-NEXT:    i32.shl $push34=, $pop33, $pop32
; SIMD128-NEXT:    i16x8.replace_lane $push35=, $pop30, 6, $pop34
; SIMD128-NEXT:    i16x8.extract_lane_u $push38=, $0, 7
; SIMD128-NEXT:    i16x8.extract_lane_u $push36=, $1, 7
; SIMD128-NEXT:    i32.const $push41=, 15
; SIMD128-NEXT:    i32.and $push37=, $pop36, $pop41
; SIMD128-NEXT:    i32.shl $push39=, $pop38, $pop37
; SIMD128-NEXT:    i16x8.replace_lane $push40=, $pop35, 7, $pop39
; SIMD128-NEXT:    return $pop40
;
; SIMD128-FAST-LABEL: shl_vec_v8i16:
; SIMD128-FAST:         .functype shl_vec_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push8=, $0, 0
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push6=, $1, 0
; SIMD128-FAST-NEXT:    i32.const $push2=, 15
; SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop2
; SIMD128-FAST-NEXT:    i32.shl $push9=, $pop8, $pop7
; SIMD128-FAST-NEXT:    i16x8.splat $push10=, $pop9
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push4=, $0, 1
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.const $push47=, 15
; SIMD128-FAST-NEXT:    i32.and $push3=, $pop1, $pop47
; SIMD128-FAST-NEXT:    i32.shl $push5=, $pop4, $pop3
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push11=, $pop10, 1, $pop5
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push14=, $0, 2
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push12=, $1, 2
; SIMD128-FAST-NEXT:    i32.const $push46=, 15
; SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $pop46
; SIMD128-FAST-NEXT:    i32.shl $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push16=, $pop11, 2, $pop15
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push19=, $0, 3
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push17=, $1, 3
; SIMD128-FAST-NEXT:    i32.const $push45=, 15
; SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop45
; SIMD128-FAST-NEXT:    i32.shl $push20=, $pop19, $pop18
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push21=, $pop16, 3, $pop20
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push24=, $0, 4
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push22=, $1, 4
; SIMD128-FAST-NEXT:    i32.const $push44=, 15
; SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop44
; SIMD128-FAST-NEXT:    i32.shl $push25=, $pop24, $pop23
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push26=, $pop21, 4, $pop25
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push29=, $0, 5
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push27=, $1, 5
; SIMD128-FAST-NEXT:    i32.const $push43=, 15
; SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop43
; SIMD128-FAST-NEXT:    i32.shl $push30=, $pop29, $pop28
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push31=, $pop26, 5, $pop30
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push34=, $0, 6
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push32=, $1, 6
; SIMD128-FAST-NEXT:    i32.const $push42=, 15
; SIMD128-FAST-NEXT:    i32.and $push33=, $pop32, $pop42
; SIMD128-FAST-NEXT:    i32.shl $push35=, $pop34, $pop33
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push36=, $pop31, 6, $pop35
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push39=, $0, 7
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push37=, $1, 7
; SIMD128-FAST-NEXT:    i32.const $push41=, 15
; SIMD128-FAST-NEXT:    i32.and $push38=, $pop37, $pop41
; SIMD128-FAST-NEXT:    i32.shl $push40=, $pop39, $pop38
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push0=, $pop36, 7, $pop40
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_vec_v8i16:
; NO-SIMD128:         .functype shl_vec_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $13, $pop0
; NO-SIMD128-NEXT:    i32.shl $push2=, $5, $pop1
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push31=, 65535
; NO-SIMD128-NEXT:    i32.and $push3=, $11, $pop31
; NO-SIMD128-NEXT:    i32.shl $push4=, $3, $pop3
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push30=, 65535
; NO-SIMD128-NEXT:    i32.and $push5=, $10, $pop30
; NO-SIMD128-NEXT:    i32.shl $push6=, $2, $pop5
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push29=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $9, $pop29
; NO-SIMD128-NEXT:    i32.shl $push8=, $1, $pop7
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push11=, 14
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.const $push28=, 65535
; NO-SIMD128-NEXT:    i32.and $push9=, $16, $pop28
; NO-SIMD128-NEXT:    i32.shl $push10=, $8, $pop9
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push15=, 12
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.const $push27=, 65535
; NO-SIMD128-NEXT:    i32.and $push13=, $15, $pop27
; NO-SIMD128-NEXT:    i32.shl $push14=, $7, $pop13
; NO-SIMD128-NEXT:    i32.store16 0($pop16), $pop14
; NO-SIMD128-NEXT:    i32.const $push19=, 10
; NO-SIMD128-NEXT:    i32.add $push20=, $0, $pop19
; NO-SIMD128-NEXT:    i32.const $push26=, 65535
; NO-SIMD128-NEXT:    i32.and $push17=, $14, $pop26
; NO-SIMD128-NEXT:    i32.shl $push18=, $6, $pop17
; NO-SIMD128-NEXT:    i32.store16 0($pop20), $pop18
; NO-SIMD128-NEXT:    i32.const $push23=, 6
; NO-SIMD128-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-NEXT:    i32.const $push25=, 65535
; NO-SIMD128-NEXT:    i32.and $push21=, $12, $pop25
; NO-SIMD128-NEXT:    i32.shl $push22=, $4, $pop21
; NO-SIMD128-NEXT:    i32.store16 0($pop24), $pop22
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_vec_v8i16:
; NO-SIMD128-FAST:         .functype shl_vec_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $9, $pop0
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $10, $pop31
; NO-SIMD128-FAST-NEXT:    i32.shl $push4=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $11, $pop30
; NO-SIMD128-FAST-NEXT:    i32.shl $push6=, $3, $pop5
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $12, $pop29
; NO-SIMD128-FAST-NEXT:    i32.shl $push10=, $4, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop8), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push28=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $13, $pop28
; NO-SIMD128-FAST-NEXT:    i32.shl $push12=, $5, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $14, $pop27
; NO-SIMD128-FAST-NEXT:    i32.shl $push16=, $6, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop14), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $15, $pop26
; NO-SIMD128-FAST-NEXT:    i32.shl $push20=, $7, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop18), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push25=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $16, $pop25
; NO-SIMD128-FAST-NEXT:    i32.shl $push24=, $8, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop22), $pop24
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <8 x i16> %v, %x
  ret <8 x i16> %a
}

define <8 x i16> @shr_s_v8i16(<8 x i16> %v, i16 %x) {
; SIMD128-LABEL: shr_s_v8i16:
; SIMD128:         .functype shr_s_v8i16 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.shr_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_s_v8i16:
; SIMD128-FAST:         .functype shr_s_v8i16 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.shr_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_v8i16:
; NO-SIMD128:         .functype shr_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend16_s $push1=, $5
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push26=, $9, $pop0
; NO-SIMD128-NEXT:    local.tee $push25=, $9=, $pop26
; NO-SIMD128-NEXT:    i32.shr_s $push2=, $pop1, $pop25
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop2
; NO-SIMD128-NEXT:    i32.extend16_s $push3=, $3
; NO-SIMD128-NEXT:    i32.shr_s $push4=, $pop3, $9
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop4
; NO-SIMD128-NEXT:    i32.extend16_s $push5=, $2
; NO-SIMD128-NEXT:    i32.shr_s $push6=, $pop5, $9
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-NEXT:    i32.extend16_s $push7=, $1
; NO-SIMD128-NEXT:    i32.shr_s $push8=, $pop7, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push11=, 14
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.extend16_s $push9=, $8
; NO-SIMD128-NEXT:    i32.shr_s $push10=, $pop9, $9
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push15=, 12
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.extend16_s $push13=, $7
; NO-SIMD128-NEXT:    i32.shr_s $push14=, $pop13, $9
; NO-SIMD128-NEXT:    i32.store16 0($pop16), $pop14
; NO-SIMD128-NEXT:    i32.const $push19=, 10
; NO-SIMD128-NEXT:    i32.add $push20=, $0, $pop19
; NO-SIMD128-NEXT:    i32.extend16_s $push17=, $6
; NO-SIMD128-NEXT:    i32.shr_s $push18=, $pop17, $9
; NO-SIMD128-NEXT:    i32.store16 0($pop20), $pop18
; NO-SIMD128-NEXT:    i32.const $push23=, 6
; NO-SIMD128-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-NEXT:    i32.extend16_s $push21=, $4
; NO-SIMD128-NEXT:    i32.shr_s $push22=, $pop21, $9
; NO-SIMD128-NEXT:    i32.store16 0($pop24), $pop22
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_v8i16:
; NO-SIMD128-FAST:         .functype shr_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push26=, $9, $pop0
; NO-SIMD128-FAST-NEXT:    local.tee $push25=, $1=, $pop26
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push2=, $pop1, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push3=, $2
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push4=, $pop3, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push5=, $3
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push6=, $pop5, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push9=, $4
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push10=, $pop9, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop8), $pop10
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push11=, $5
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push12=, $pop11, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push15=, $6
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push16=, $pop15, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop14), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push19=, $7
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push20=, $pop19, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop18), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push23=, $8
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push24=, $pop23, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop22), $pop24
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <8 x i16> undef, i16 %x, i32 0
  %s = shufflevector <8 x i16> %t, <8 x i16> undef,
    <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %a = ashr <8 x i16> %v, %s
  ret <8 x i16> %a
}

define <8 x i16> @shr_s_vec_v8i16(<8 x i16> %v, <8 x i16> %x) {
; SIMD128-LABEL: shr_s_vec_v8i16:
; SIMD128:         .functype shr_s_vec_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extract_lane_s $push7=, $0, 0
; SIMD128-NEXT:    i16x8.extract_lane_u $push5=, $1, 0
; SIMD128-NEXT:    i32.const $push1=, 15
; SIMD128-NEXT:    i32.and $push6=, $pop5, $pop1
; SIMD128-NEXT:    i32.shr_s $push8=, $pop7, $pop6
; SIMD128-NEXT:    i16x8.splat $push9=, $pop8
; SIMD128-NEXT:    i16x8.extract_lane_s $push3=, $0, 1
; SIMD128-NEXT:    i16x8.extract_lane_u $push0=, $1, 1
; SIMD128-NEXT:    i32.const $push47=, 15
; SIMD128-NEXT:    i32.and $push2=, $pop0, $pop47
; SIMD128-NEXT:    i32.shr_s $push4=, $pop3, $pop2
; SIMD128-NEXT:    i16x8.replace_lane $push10=, $pop9, 1, $pop4
; SIMD128-NEXT:    i16x8.extract_lane_s $push13=, $0, 2
; SIMD128-NEXT:    i16x8.extract_lane_u $push11=, $1, 2
; SIMD128-NEXT:    i32.const $push46=, 15
; SIMD128-NEXT:    i32.and $push12=, $pop11, $pop46
; SIMD128-NEXT:    i32.shr_s $push14=, $pop13, $pop12
; SIMD128-NEXT:    i16x8.replace_lane $push15=, $pop10, 2, $pop14
; SIMD128-NEXT:    i16x8.extract_lane_s $push18=, $0, 3
; SIMD128-NEXT:    i16x8.extract_lane_u $push16=, $1, 3
; SIMD128-NEXT:    i32.const $push45=, 15
; SIMD128-NEXT:    i32.and $push17=, $pop16, $pop45
; SIMD128-NEXT:    i32.shr_s $push19=, $pop18, $pop17
; SIMD128-NEXT:    i16x8.replace_lane $push20=, $pop15, 3, $pop19
; SIMD128-NEXT:    i16x8.extract_lane_s $push23=, $0, 4
; SIMD128-NEXT:    i16x8.extract_lane_u $push21=, $1, 4
; SIMD128-NEXT:    i32.const $push44=, 15
; SIMD128-NEXT:    i32.and $push22=, $pop21, $pop44
; SIMD128-NEXT:    i32.shr_s $push24=, $pop23, $pop22
; SIMD128-NEXT:    i16x8.replace_lane $push25=, $pop20, 4, $pop24
; SIMD128-NEXT:    i16x8.extract_lane_s $push28=, $0, 5
; SIMD128-NEXT:    i16x8.extract_lane_u $push26=, $1, 5
; SIMD128-NEXT:    i32.const $push43=, 15
; SIMD128-NEXT:    i32.and $push27=, $pop26, $pop43
; SIMD128-NEXT:    i32.shr_s $push29=, $pop28, $pop27
; SIMD128-NEXT:    i16x8.replace_lane $push30=, $pop25, 5, $pop29
; SIMD128-NEXT:    i16x8.extract_lane_s $push33=, $0, 6
; SIMD128-NEXT:    i16x8.extract_lane_u $push31=, $1, 6
; SIMD128-NEXT:    i32.const $push42=, 15
; SIMD128-NEXT:    i32.and $push32=, $pop31, $pop42
; SIMD128-NEXT:    i32.shr_s $push34=, $pop33, $pop32
; SIMD128-NEXT:    i16x8.replace_lane $push35=, $pop30, 6, $pop34
; SIMD128-NEXT:    i16x8.extract_lane_s $push38=, $0, 7
; SIMD128-NEXT:    i16x8.extract_lane_u $push36=, $1, 7
; SIMD128-NEXT:    i32.const $push41=, 15
; SIMD128-NEXT:    i32.and $push37=, $pop36, $pop41
; SIMD128-NEXT:    i32.shr_s $push39=, $pop38, $pop37
; SIMD128-NEXT:    i16x8.replace_lane $push40=, $pop35, 7, $pop39
; SIMD128-NEXT:    return $pop40
;
; SIMD128-FAST-LABEL: shr_s_vec_v8i16:
; SIMD128-FAST:         .functype shr_s_vec_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push8=, $0, 0
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push6=, $1, 0
; SIMD128-FAST-NEXT:    i32.const $push2=, 15
; SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop2
; SIMD128-FAST-NEXT:    i32.shr_s $push9=, $pop8, $pop7
; SIMD128-FAST-NEXT:    i16x8.splat $push10=, $pop9
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push4=, $0, 1
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.const $push47=, 15
; SIMD128-FAST-NEXT:    i32.and $push3=, $pop1, $pop47
; SIMD128-FAST-NEXT:    i32.shr_s $push5=, $pop4, $pop3
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push11=, $pop10, 1, $pop5
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push14=, $0, 2
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push12=, $1, 2
; SIMD128-FAST-NEXT:    i32.const $push46=, 15
; SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $pop46
; SIMD128-FAST-NEXT:    i32.shr_s $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push16=, $pop11, 2, $pop15
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push19=, $0, 3
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push17=, $1, 3
; SIMD128-FAST-NEXT:    i32.const $push45=, 15
; SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop45
; SIMD128-FAST-NEXT:    i32.shr_s $push20=, $pop19, $pop18
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push21=, $pop16, 3, $pop20
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push24=, $0, 4
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push22=, $1, 4
; SIMD128-FAST-NEXT:    i32.const $push44=, 15
; SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop44
; SIMD128-FAST-NEXT:    i32.shr_s $push25=, $pop24, $pop23
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push26=, $pop21, 4, $pop25
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push29=, $0, 5
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push27=, $1, 5
; SIMD128-FAST-NEXT:    i32.const $push43=, 15
; SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop43
; SIMD128-FAST-NEXT:    i32.shr_s $push30=, $pop29, $pop28
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push31=, $pop26, 5, $pop30
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push34=, $0, 6
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push32=, $1, 6
; SIMD128-FAST-NEXT:    i32.const $push42=, 15
; SIMD128-FAST-NEXT:    i32.and $push33=, $pop32, $pop42
; SIMD128-FAST-NEXT:    i32.shr_s $push35=, $pop34, $pop33
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push36=, $pop31, 6, $pop35
; SIMD128-FAST-NEXT:    i16x8.extract_lane_s $push39=, $0, 7
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push37=, $1, 7
; SIMD128-FAST-NEXT:    i32.const $push41=, 15
; SIMD128-FAST-NEXT:    i32.and $push38=, $pop37, $pop41
; SIMD128-FAST-NEXT:    i32.shr_s $push40=, $pop39, $pop38
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push0=, $pop36, 7, $pop40
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_vec_v8i16:
; NO-SIMD128:         .functype shr_s_vec_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend16_s $push2=, $5
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $13, $pop0
; NO-SIMD128-NEXT:    i32.shr_s $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop3
; NO-SIMD128-NEXT:    i32.extend16_s $push5=, $3
; NO-SIMD128-NEXT:    i32.const $push39=, 65535
; NO-SIMD128-NEXT:    i32.and $push4=, $11, $pop39
; NO-SIMD128-NEXT:    i32.shr_s $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-NEXT:    i32.extend16_s $push8=, $2
; NO-SIMD128-NEXT:    i32.const $push38=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $10, $pop38
; NO-SIMD128-NEXT:    i32.shr_s $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop9
; NO-SIMD128-NEXT:    i32.extend16_s $push11=, $1
; NO-SIMD128-NEXT:    i32.const $push37=, 65535
; NO-SIMD128-NEXT:    i32.and $push10=, $9, $pop37
; NO-SIMD128-NEXT:    i32.shr_s $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push16=, 14
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.extend16_s $push14=, $8
; NO-SIMD128-NEXT:    i32.const $push36=, 65535
; NO-SIMD128-NEXT:    i32.and $push13=, $16, $pop36
; NO-SIMD128-NEXT:    i32.shr_s $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.store16 0($pop17), $pop15
; NO-SIMD128-NEXT:    i32.const $push21=, 12
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.extend16_s $push19=, $7
; NO-SIMD128-NEXT:    i32.const $push35=, 65535
; NO-SIMD128-NEXT:    i32.and $push18=, $15, $pop35
; NO-SIMD128-NEXT:    i32.shr_s $push20=, $pop19, $pop18
; NO-SIMD128-NEXT:    i32.store16 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push26=, 10
; NO-SIMD128-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-NEXT:    i32.extend16_s $push24=, $6
; NO-SIMD128-NEXT:    i32.const $push34=, 65535
; NO-SIMD128-NEXT:    i32.and $push23=, $14, $pop34
; NO-SIMD128-NEXT:    i32.shr_s $push25=, $pop24, $pop23
; NO-SIMD128-NEXT:    i32.store16 0($pop27), $pop25
; NO-SIMD128-NEXT:    i32.const $push31=, 6
; NO-SIMD128-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-NEXT:    i32.extend16_s $push29=, $4
; NO-SIMD128-NEXT:    i32.const $push33=, 65535
; NO-SIMD128-NEXT:    i32.and $push28=, $12, $pop33
; NO-SIMD128-NEXT:    i32.shr_s $push30=, $pop29, $pop28
; NO-SIMD128-NEXT:    i32.store16 0($pop32), $pop30
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_vec_v8i16:
; NO-SIMD128-FAST:         .functype shr_s_vec_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push2=, $1
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $9, $pop0
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push5=, $2
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $10, $pop39
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push8=, $3
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $11, $pop38
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push13=, $4
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $12, $pop37
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop11), $pop14
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push16=, $5
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $13, $pop36
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push17=, $pop16, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push19=, $0, $pop18
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push21=, $6
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $14, $pop35
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push22=, $pop21, $pop20
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop19), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push26=, $7
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $15, $pop34
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push27=, $pop26, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop24), $pop27
; NO-SIMD128-FAST-NEXT:    i32.const $push28=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push29=, $0, $pop28
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push31=, $8
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $16, $pop33
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push32=, $pop31, $pop30
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop29), $pop32
; NO-SIMD128-FAST-NEXT:    return
  %a = ashr <8 x i16> %v, %x
  ret <8 x i16> %a
}

define <8 x i16> @shr_u_v8i16(<8 x i16> %v, i16 %x) {
; SIMD128-LABEL: shr_u_v8i16:
; SIMD128:         .functype shr_u_v8i16 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.shr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_u_v8i16:
; SIMD128-FAST:         .functype shr_u_v8i16 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.shr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_v8i16:
; NO-SIMD128:         .functype shr_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $5, $pop0
; NO-SIMD128-NEXT:    i32.const $push34=, 65535
; NO-SIMD128-NEXT:    i32.and $push33=, $9, $pop34
; NO-SIMD128-NEXT:    local.tee $push32=, $9=, $pop33
; NO-SIMD128-NEXT:    i32.shr_u $push2=, $pop1, $pop32
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push31=, 65535
; NO-SIMD128-NEXT:    i32.and $push3=, $3, $pop31
; NO-SIMD128-NEXT:    i32.shr_u $push4=, $pop3, $9
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push30=, 65535
; NO-SIMD128-NEXT:    i32.and $push5=, $2, $pop30
; NO-SIMD128-NEXT:    i32.shr_u $push6=, $pop5, $9
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push29=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $1, $pop29
; NO-SIMD128-NEXT:    i32.shr_u $push8=, $pop7, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push11=, 14
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.const $push28=, 65535
; NO-SIMD128-NEXT:    i32.and $push9=, $8, $pop28
; NO-SIMD128-NEXT:    i32.shr_u $push10=, $pop9, $9
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push15=, 12
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.const $push27=, 65535
; NO-SIMD128-NEXT:    i32.and $push13=, $7, $pop27
; NO-SIMD128-NEXT:    i32.shr_u $push14=, $pop13, $9
; NO-SIMD128-NEXT:    i32.store16 0($pop16), $pop14
; NO-SIMD128-NEXT:    i32.const $push19=, 10
; NO-SIMD128-NEXT:    i32.add $push20=, $0, $pop19
; NO-SIMD128-NEXT:    i32.const $push26=, 65535
; NO-SIMD128-NEXT:    i32.and $push17=, $6, $pop26
; NO-SIMD128-NEXT:    i32.shr_u $push18=, $pop17, $9
; NO-SIMD128-NEXT:    i32.store16 0($pop20), $pop18
; NO-SIMD128-NEXT:    i32.const $push23=, 6
; NO-SIMD128-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-NEXT:    i32.const $push25=, 65535
; NO-SIMD128-NEXT:    i32.and $push21=, $4, $pop25
; NO-SIMD128-NEXT:    i32.shr_u $push22=, $pop21, $9
; NO-SIMD128-NEXT:    i32.store16 0($pop24), $pop22
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_v8i16:
; NO-SIMD128-FAST:         .functype shr_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push33=, $9, $pop34
; NO-SIMD128-FAST-NEXT:    local.tee $push32=, $1=, $pop33
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push2=, $pop1, $pop32
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $2, $pop31
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push4=, $pop3, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $3, $pop30
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push6=, $pop5, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $4, $pop29
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push8=, $pop7, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop10), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push28=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $5, $pop28
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push12=, $pop11, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push15=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $6, $pop27
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push14=, $pop13, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop16), $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push20=, $0, $pop19
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push17=, $7, $pop26
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push18=, $pop17, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop20), $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-FAST-NEXT:    i32.const $push25=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push21=, $8, $pop25
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push22=, $pop21, $1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop24), $pop22
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <8 x i16> undef, i16 %x, i32 0
  %s = shufflevector <8 x i16> %t, <8 x i16> undef,
    <8 x i32> <i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0>
  %a = lshr <8 x i16> %v, %s
  ret <8 x i16> %a
}

define <8 x i16> @shr_u_vec_v8i16(<8 x i16> %v, <8 x i16> %x) {
; SIMD128-LABEL: shr_u_vec_v8i16:
; SIMD128:         .functype shr_u_vec_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extract_lane_u $push7=, $0, 0
; SIMD128-NEXT:    i16x8.extract_lane_u $push5=, $1, 0
; SIMD128-NEXT:    i32.const $push1=, 15
; SIMD128-NEXT:    i32.and $push6=, $pop5, $pop1
; SIMD128-NEXT:    i32.shr_u $push8=, $pop7, $pop6
; SIMD128-NEXT:    i16x8.splat $push9=, $pop8
; SIMD128-NEXT:    i16x8.extract_lane_u $push3=, $0, 1
; SIMD128-NEXT:    i16x8.extract_lane_u $push0=, $1, 1
; SIMD128-NEXT:    i32.const $push47=, 15
; SIMD128-NEXT:    i32.and $push2=, $pop0, $pop47
; SIMD128-NEXT:    i32.shr_u $push4=, $pop3, $pop2
; SIMD128-NEXT:    i16x8.replace_lane $push10=, $pop9, 1, $pop4
; SIMD128-NEXT:    i16x8.extract_lane_u $push13=, $0, 2
; SIMD128-NEXT:    i16x8.extract_lane_u $push11=, $1, 2
; SIMD128-NEXT:    i32.const $push46=, 15
; SIMD128-NEXT:    i32.and $push12=, $pop11, $pop46
; SIMD128-NEXT:    i32.shr_u $push14=, $pop13, $pop12
; SIMD128-NEXT:    i16x8.replace_lane $push15=, $pop10, 2, $pop14
; SIMD128-NEXT:    i16x8.extract_lane_u $push18=, $0, 3
; SIMD128-NEXT:    i16x8.extract_lane_u $push16=, $1, 3
; SIMD128-NEXT:    i32.const $push45=, 15
; SIMD128-NEXT:    i32.and $push17=, $pop16, $pop45
; SIMD128-NEXT:    i32.shr_u $push19=, $pop18, $pop17
; SIMD128-NEXT:    i16x8.replace_lane $push20=, $pop15, 3, $pop19
; SIMD128-NEXT:    i16x8.extract_lane_u $push23=, $0, 4
; SIMD128-NEXT:    i16x8.extract_lane_u $push21=, $1, 4
; SIMD128-NEXT:    i32.const $push44=, 15
; SIMD128-NEXT:    i32.and $push22=, $pop21, $pop44
; SIMD128-NEXT:    i32.shr_u $push24=, $pop23, $pop22
; SIMD128-NEXT:    i16x8.replace_lane $push25=, $pop20, 4, $pop24
; SIMD128-NEXT:    i16x8.extract_lane_u $push28=, $0, 5
; SIMD128-NEXT:    i16x8.extract_lane_u $push26=, $1, 5
; SIMD128-NEXT:    i32.const $push43=, 15
; SIMD128-NEXT:    i32.and $push27=, $pop26, $pop43
; SIMD128-NEXT:    i32.shr_u $push29=, $pop28, $pop27
; SIMD128-NEXT:    i16x8.replace_lane $push30=, $pop25, 5, $pop29
; SIMD128-NEXT:    i16x8.extract_lane_u $push33=, $0, 6
; SIMD128-NEXT:    i16x8.extract_lane_u $push31=, $1, 6
; SIMD128-NEXT:    i32.const $push42=, 15
; SIMD128-NEXT:    i32.and $push32=, $pop31, $pop42
; SIMD128-NEXT:    i32.shr_u $push34=, $pop33, $pop32
; SIMD128-NEXT:    i16x8.replace_lane $push35=, $pop30, 6, $pop34
; SIMD128-NEXT:    i16x8.extract_lane_u $push38=, $0, 7
; SIMD128-NEXT:    i16x8.extract_lane_u $push36=, $1, 7
; SIMD128-NEXT:    i32.const $push41=, 15
; SIMD128-NEXT:    i32.and $push37=, $pop36, $pop41
; SIMD128-NEXT:    i32.shr_u $push39=, $pop38, $pop37
; SIMD128-NEXT:    i16x8.replace_lane $push40=, $pop35, 7, $pop39
; SIMD128-NEXT:    return $pop40
;
; SIMD128-FAST-LABEL: shr_u_vec_v8i16:
; SIMD128-FAST:         .functype shr_u_vec_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push8=, $0, 0
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push6=, $1, 0
; SIMD128-FAST-NEXT:    i32.const $push2=, 15
; SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop2
; SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop7
; SIMD128-FAST-NEXT:    i16x8.splat $push10=, $pop9
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push4=, $0, 1
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.const $push47=, 15
; SIMD128-FAST-NEXT:    i32.and $push3=, $pop1, $pop47
; SIMD128-FAST-NEXT:    i32.shr_u $push5=, $pop4, $pop3
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push11=, $pop10, 1, $pop5
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push14=, $0, 2
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push12=, $1, 2
; SIMD128-FAST-NEXT:    i32.const $push46=, 15
; SIMD128-FAST-NEXT:    i32.and $push13=, $pop12, $pop46
; SIMD128-FAST-NEXT:    i32.shr_u $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push16=, $pop11, 2, $pop15
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push19=, $0, 3
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push17=, $1, 3
; SIMD128-FAST-NEXT:    i32.const $push45=, 15
; SIMD128-FAST-NEXT:    i32.and $push18=, $pop17, $pop45
; SIMD128-FAST-NEXT:    i32.shr_u $push20=, $pop19, $pop18
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push21=, $pop16, 3, $pop20
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push24=, $0, 4
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push22=, $1, 4
; SIMD128-FAST-NEXT:    i32.const $push44=, 15
; SIMD128-FAST-NEXT:    i32.and $push23=, $pop22, $pop44
; SIMD128-FAST-NEXT:    i32.shr_u $push25=, $pop24, $pop23
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push26=, $pop21, 4, $pop25
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push29=, $0, 5
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push27=, $1, 5
; SIMD128-FAST-NEXT:    i32.const $push43=, 15
; SIMD128-FAST-NEXT:    i32.and $push28=, $pop27, $pop43
; SIMD128-FAST-NEXT:    i32.shr_u $push30=, $pop29, $pop28
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push31=, $pop26, 5, $pop30
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push34=, $0, 6
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push32=, $1, 6
; SIMD128-FAST-NEXT:    i32.const $push42=, 15
; SIMD128-FAST-NEXT:    i32.and $push33=, $pop32, $pop42
; SIMD128-FAST-NEXT:    i32.shr_u $push35=, $pop34, $pop33
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push36=, $pop31, 6, $pop35
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push39=, $0, 7
; SIMD128-FAST-NEXT:    i16x8.extract_lane_u $push37=, $1, 7
; SIMD128-FAST-NEXT:    i32.const $push41=, 15
; SIMD128-FAST-NEXT:    i32.and $push38=, $pop37, $pop41
; SIMD128-FAST-NEXT:    i32.shr_u $push40=, $pop39, $pop38
; SIMD128-FAST-NEXT:    i16x8.replace_lane $push0=, $pop36, 7, $pop40
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_vec_v8i16:
; NO-SIMD128:         .functype shr_u_vec_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push2=, $5, $pop0
; NO-SIMD128-NEXT:    i32.const $push47=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $13, $pop47
; NO-SIMD128-NEXT:    i32.shr_u $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push46=, 65535
; NO-SIMD128-NEXT:    i32.and $push5=, $3, $pop46
; NO-SIMD128-NEXT:    i32.const $push45=, 65535
; NO-SIMD128-NEXT:    i32.and $push4=, $11, $pop45
; NO-SIMD128-NEXT:    i32.shr_u $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push44=, 65535
; NO-SIMD128-NEXT:    i32.and $push8=, $2, $pop44
; NO-SIMD128-NEXT:    i32.const $push43=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $10, $pop43
; NO-SIMD128-NEXT:    i32.shr_u $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push42=, 65535
; NO-SIMD128-NEXT:    i32.and $push11=, $1, $pop42
; NO-SIMD128-NEXT:    i32.const $push41=, 65535
; NO-SIMD128-NEXT:    i32.and $push10=, $9, $pop41
; NO-SIMD128-NEXT:    i32.shr_u $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push16=, 14
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.const $push40=, 65535
; NO-SIMD128-NEXT:    i32.and $push14=, $8, $pop40
; NO-SIMD128-NEXT:    i32.const $push39=, 65535
; NO-SIMD128-NEXT:    i32.and $push13=, $16, $pop39
; NO-SIMD128-NEXT:    i32.shr_u $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.store16 0($pop17), $pop15
; NO-SIMD128-NEXT:    i32.const $push21=, 12
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.const $push38=, 65535
; NO-SIMD128-NEXT:    i32.and $push19=, $7, $pop38
; NO-SIMD128-NEXT:    i32.const $push37=, 65535
; NO-SIMD128-NEXT:    i32.and $push18=, $15, $pop37
; NO-SIMD128-NEXT:    i32.shr_u $push20=, $pop19, $pop18
; NO-SIMD128-NEXT:    i32.store16 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push26=, 10
; NO-SIMD128-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-NEXT:    i32.const $push36=, 65535
; NO-SIMD128-NEXT:    i32.and $push24=, $6, $pop36
; NO-SIMD128-NEXT:    i32.const $push35=, 65535
; NO-SIMD128-NEXT:    i32.and $push23=, $14, $pop35
; NO-SIMD128-NEXT:    i32.shr_u $push25=, $pop24, $pop23
; NO-SIMD128-NEXT:    i32.store16 0($pop27), $pop25
; NO-SIMD128-NEXT:    i32.const $push31=, 6
; NO-SIMD128-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-NEXT:    i32.const $push34=, 65535
; NO-SIMD128-NEXT:    i32.and $push29=, $4, $pop34
; NO-SIMD128-NEXT:    i32.const $push33=, 65535
; NO-SIMD128-NEXT:    i32.and $push28=, $12, $pop33
; NO-SIMD128-NEXT:    i32.shr_u $push30=, $pop29, $pop28
; NO-SIMD128-NEXT:    i32.store16 0($pop32), $pop30
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_vec_v8i16:
; NO-SIMD128-FAST:         .functype shr_u_vec_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $9, $pop47
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $2, $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $10, $pop45
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $3, $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $11, $pop43
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $4, $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $12, $pop41
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop14), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $5, $pop40
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $13, $pop39
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push17=, $pop16, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $6, $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $14, $pop37
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push20=, $pop19, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop22), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $7, $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $15, $pop35
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push25=, $pop24, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop27), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $8, $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $16, $pop33
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop32), $pop30
; NO-SIMD128-FAST-NEXT:    return
  %a = lshr <8 x i16> %v, %x
  ret <8 x i16> %a
}

define <8 x i16> @and_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: and_v8i16:
; SIMD128:         .functype and_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.and $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: and_v8i16:
; SIMD128-FAST:         .functype and_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.and $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: and_v8i16:
; NO-SIMD128:         .functype and_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.and $push0=, $5, $13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop0
; NO-SIMD128-NEXT:    i32.and $push1=, $3, $11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop1
; NO-SIMD128-NEXT:    i32.and $push2=, $2, $10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop2
; NO-SIMD128-NEXT:    i32.and $push3=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 14
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.and $push4=, $8, $16
; NO-SIMD128-NEXT:    i32.store16 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.and $push7=, $7, $15
; NO-SIMD128-NEXT:    i32.store16 0($pop9), $pop7
; NO-SIMD128-NEXT:    i32.const $push11=, 10
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.and $push10=, $6, $14
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push14=, 6
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.and $push13=, $4, $12
; NO-SIMD128-NEXT:    i32.store16 0($pop15), $pop13
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: and_v8i16:
; NO-SIMD128-FAST:         .functype and_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.and $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop8), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop11), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop14), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %a = and <8 x i16> %x, %y
  ret <8 x i16> %a
}

define <8 x i16> @or_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: or_v8i16:
; SIMD128:         .functype or_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.or $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: or_v8i16:
; SIMD128-FAST:         .functype or_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.or $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: or_v8i16:
; NO-SIMD128:         .functype or_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.or $push0=, $5, $13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop0
; NO-SIMD128-NEXT:    i32.or $push1=, $3, $11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop1
; NO-SIMD128-NEXT:    i32.or $push2=, $2, $10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop2
; NO-SIMD128-NEXT:    i32.or $push3=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 14
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.or $push4=, $8, $16
; NO-SIMD128-NEXT:    i32.store16 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.or $push7=, $7, $15
; NO-SIMD128-NEXT:    i32.store16 0($pop9), $pop7
; NO-SIMD128-NEXT:    i32.const $push11=, 10
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.or $push10=, $6, $14
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push14=, 6
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.or $push13=, $4, $12
; NO-SIMD128-NEXT:    i32.store16 0($pop15), $pop13
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: or_v8i16:
; NO-SIMD128-FAST:         .functype or_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.or $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.or $push1=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.or $push2=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.or $push5=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    i32.or $push6=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.or $push9=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop8), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.or $push12=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop11), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.or $push15=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop14), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %a = or <8 x i16> %x, %y
  ret <8 x i16> %a
}

define <8 x i16> @xor_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: xor_v8i16:
; SIMD128:         .functype xor_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: xor_v8i16:
; SIMD128-FAST:         .functype xor_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: xor_v8i16:
; NO-SIMD128:         .functype xor_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push0=, $5, $13
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop0
; NO-SIMD128-NEXT:    i32.xor $push1=, $3, $11
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop1
; NO-SIMD128-NEXT:    i32.xor $push2=, $2, $10
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop2
; NO-SIMD128-NEXT:    i32.xor $push3=, $1, $9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 14
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.xor $push4=, $8, $16
; NO-SIMD128-NEXT:    i32.store16 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.xor $push7=, $7, $15
; NO-SIMD128-NEXT:    i32.store16 0($pop9), $pop7
; NO-SIMD128-NEXT:    i32.const $push11=, 10
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.xor $push10=, $6, $14
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push14=, 6
; NO-SIMD128-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-NEXT:    i32.xor $push13=, $4, $12
; NO-SIMD128-NEXT:    i32.store16 0($pop15), $pop13
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: xor_v8i16:
; NO-SIMD128-FAST:         .functype xor_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $1, $9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $2, $10
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $3, $11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $4, $12
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $5, $13
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $6, $14
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop8), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push10=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push11=, $0, $pop10
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $7, $15
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop11), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.xor $push15=, $8, $16
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop14), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <8 x i16> %x, %y
  ret <8 x i16> %a
}

define <8 x i16> @not_v8i16(<8 x i16> %x) {
; SIMD128-LABEL: not_v8i16:
; SIMD128:         .functype not_v8i16 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.not $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: not_v8i16:
; SIMD128-FAST:         .functype not_v8i16 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: not_v8i16:
; NO-SIMD128:         .functype not_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $5, $pop0
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push23=, -1
; NO-SIMD128-NEXT:    i32.xor $push2=, $3, $pop23
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push22=, -1
; NO-SIMD128-NEXT:    i32.xor $push3=, $2, $pop22
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push21=, -1
; NO-SIMD128-NEXT:    i32.xor $push4=, $1, $pop21
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push6=, 14
; NO-SIMD128-NEXT:    i32.add $push7=, $0, $pop6
; NO-SIMD128-NEXT:    i32.const $push20=, -1
; NO-SIMD128-NEXT:    i32.xor $push5=, $8, $pop20
; NO-SIMD128-NEXT:    i32.store16 0($pop7), $pop5
; NO-SIMD128-NEXT:    i32.const $push9=, 12
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    i32.const $push19=, -1
; NO-SIMD128-NEXT:    i32.xor $push8=, $7, $pop19
; NO-SIMD128-NEXT:    i32.store16 0($pop10), $pop8
; NO-SIMD128-NEXT:    i32.const $push12=, 10
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.const $push18=, -1
; NO-SIMD128-NEXT:    i32.xor $push11=, $6, $pop18
; NO-SIMD128-NEXT:    i32.store16 0($pop13), $pop11
; NO-SIMD128-NEXT:    i32.const $push15=, 6
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.const $push17=, -1
; NO-SIMD128-NEXT:    i32.xor $push14=, $4, $pop17
; NO-SIMD128-NEXT:    i32.store16 0($pop16), $pop14
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: not_v8i16:
; NO-SIMD128-FAST:         .functype not_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push23=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $2, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push22=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $3, $pop22
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $4, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop5), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push7=, $5, $pop20
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push10=, $6, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop9), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push11=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $7, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop12), $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push14=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push15=, $0, $pop14
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $8, $pop17
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop15), $pop16
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <8 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1,
                          i16 -1, i16 -1, i16 -1, i16 -1>
  ret <8 x i16> %a
}

define <8 x i16> @andnot_v8i16(<8 x i16> %x, <8 x i16> %y) {
; SIMD128-LABEL: andnot_v8i16:
; SIMD128:         .functype andnot_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.andnot $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: andnot_v8i16:
; SIMD128-FAST:         .functype andnot_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $1
; SIMD128-FAST-NEXT:    v128.and $push1=, $0, $pop0
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: andnot_v8i16:
; NO-SIMD128:         .functype andnot_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $13, $pop0
; NO-SIMD128-NEXT:    i32.and $push2=, $5, $pop1
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push31=, -1
; NO-SIMD128-NEXT:    i32.xor $push3=, $11, $pop31
; NO-SIMD128-NEXT:    i32.and $push4=, $3, $pop3
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push30=, -1
; NO-SIMD128-NEXT:    i32.xor $push5=, $10, $pop30
; NO-SIMD128-NEXT:    i32.and $push6=, $2, $pop5
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push29=, -1
; NO-SIMD128-NEXT:    i32.xor $push7=, $9, $pop29
; NO-SIMD128-NEXT:    i32.and $push8=, $1, $pop7
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push11=, 14
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.const $push28=, -1
; NO-SIMD128-NEXT:    i32.xor $push9=, $16, $pop28
; NO-SIMD128-NEXT:    i32.and $push10=, $8, $pop9
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push15=, 12
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.const $push27=, -1
; NO-SIMD128-NEXT:    i32.xor $push13=, $15, $pop27
; NO-SIMD128-NEXT:    i32.and $push14=, $7, $pop13
; NO-SIMD128-NEXT:    i32.store16 0($pop16), $pop14
; NO-SIMD128-NEXT:    i32.const $push19=, 10
; NO-SIMD128-NEXT:    i32.add $push20=, $0, $pop19
; NO-SIMD128-NEXT:    i32.const $push26=, -1
; NO-SIMD128-NEXT:    i32.xor $push17=, $14, $pop26
; NO-SIMD128-NEXT:    i32.and $push18=, $6, $pop17
; NO-SIMD128-NEXT:    i32.store16 0($pop20), $pop18
; NO-SIMD128-NEXT:    i32.const $push23=, 6
; NO-SIMD128-NEXT:    i32.add $push24=, $0, $pop23
; NO-SIMD128-NEXT:    i32.const $push25=, -1
; NO-SIMD128-NEXT:    i32.xor $push21=, $12, $pop25
; NO-SIMD128-NEXT:    i32.and $push22=, $4, $pop21
; NO-SIMD128-NEXT:    i32.store16 0($pop24), $pop22
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: andnot_v8i16:
; NO-SIMD128-FAST:         .functype andnot_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $9, $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $10, $pop31
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push30=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $11, $pop30
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $3, $pop5
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push29=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $12, $pop29
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $4, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop8), $pop10
; NO-SIMD128-FAST-NEXT:    i32.const $push28=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $13, $pop28
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $5, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push15=, $14, $pop27
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $6, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop14), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push19=, $15, $pop26
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $7, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop18), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push25=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push23=, $16, $pop25
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $8, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop22), $pop24
; NO-SIMD128-FAST-NEXT:    return
 %inv_y = xor <8 x i16> %y,
   <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
 %a = and <8 x i16> %x, %inv_y
 ret <8 x i16> %a
}

define <8 x i16> @bitselect_v8i16(<8 x i16> %c, <8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: bitselect_v8i16:
; SIMD128:         .functype bitselect_v8i16 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_v8i16:
; SIMD128-FAST:         .functype bitselect_v8i16 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.and $push0=, $1, $0
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $2, $pop2
; SIMD128-FAST-NEXT:    v128.or $push1=, $pop0, $pop3
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: bitselect_v8i16:
; NO-SIMD128:         .functype bitselect_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push5=, 14
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.and $push0=, $16, $8
; NO-SIMD128-NEXT:    i32.const $push1=, -1
; NO-SIMD128-NEXT:    i32.xor $push2=, $8, $pop1
; NO-SIMD128-NEXT:    i32.and $push3=, $24, $pop2
; NO-SIMD128-NEXT:    i32.or $push4=, $pop0, $pop3
; NO-SIMD128-NEXT:    i32.store16 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push11=, 12
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.and $push7=, $15, $7
; NO-SIMD128-NEXT:    i32.const $push47=, -1
; NO-SIMD128-NEXT:    i32.xor $push8=, $7, $pop47
; NO-SIMD128-NEXT:    i32.and $push9=, $23, $pop8
; NO-SIMD128-NEXT:    i32.or $push10=, $pop7, $pop9
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push17=, 10
; NO-SIMD128-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-NEXT:    i32.and $push13=, $14, $6
; NO-SIMD128-NEXT:    i32.const $push46=, -1
; NO-SIMD128-NEXT:    i32.xor $push14=, $6, $pop46
; NO-SIMD128-NEXT:    i32.and $push15=, $22, $pop14
; NO-SIMD128-NEXT:    i32.or $push16=, $pop13, $pop15
; NO-SIMD128-NEXT:    i32.store16 0($pop18), $pop16
; NO-SIMD128-NEXT:    i32.and $push19=, $13, $5
; NO-SIMD128-NEXT:    i32.const $push45=, -1
; NO-SIMD128-NEXT:    i32.xor $push20=, $5, $pop45
; NO-SIMD128-NEXT:    i32.and $push21=, $21, $pop20
; NO-SIMD128-NEXT:    i32.or $push22=, $pop19, $pop21
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop22
; NO-SIMD128-NEXT:    i32.const $push27=, 6
; NO-SIMD128-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-NEXT:    i32.and $push23=, $12, $4
; NO-SIMD128-NEXT:    i32.const $push44=, -1
; NO-SIMD128-NEXT:    i32.xor $push24=, $4, $pop44
; NO-SIMD128-NEXT:    i32.and $push25=, $20, $pop24
; NO-SIMD128-NEXT:    i32.or $push26=, $pop23, $pop25
; NO-SIMD128-NEXT:    i32.store16 0($pop28), $pop26
; NO-SIMD128-NEXT:    i32.and $push29=, $11, $3
; NO-SIMD128-NEXT:    i32.const $push43=, -1
; NO-SIMD128-NEXT:    i32.xor $push30=, $3, $pop43
; NO-SIMD128-NEXT:    i32.and $push31=, $19, $pop30
; NO-SIMD128-NEXT:    i32.or $push32=, $pop29, $pop31
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop32
; NO-SIMD128-NEXT:    i32.and $push33=, $10, $2
; NO-SIMD128-NEXT:    i32.const $push42=, -1
; NO-SIMD128-NEXT:    i32.xor $push34=, $2, $pop42
; NO-SIMD128-NEXT:    i32.and $push35=, $18, $pop34
; NO-SIMD128-NEXT:    i32.or $push36=, $pop33, $pop35
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop36
; NO-SIMD128-NEXT:    i32.and $push37=, $9, $1
; NO-SIMD128-NEXT:    i32.const $push41=, -1
; NO-SIMD128-NEXT:    i32.xor $push38=, $1, $pop41
; NO-SIMD128-NEXT:    i32.and $push39=, $17, $pop38
; NO-SIMD128-NEXT:    i32.or $push40=, $pop37, $pop39
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop40
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_v8i16:
; NO-SIMD128-FAST:         .functype bitselect_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.and $push0=, $9, $1
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $17, $pop2
; NO-SIMD128-FAST-NEXT:    i32.or $push4=, $pop0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $10, $2
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $2, $pop47
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $18, $pop6
; NO-SIMD128-FAST-NEXT:    i32.or $push8=, $pop5, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $11, $3
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push10=, $3, $pop46
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $19, $pop10
; NO-SIMD128-FAST-NEXT:    i32.or $push12=, $pop9, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $12, $4
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $4, $pop45
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $20, $pop14
; NO-SIMD128-FAST-NEXT:    i32.or $push16=, $pop13, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop18), $pop16
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $13, $5
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push20=, $5, $pop44
; NO-SIMD128-FAST-NEXT:    i32.and $push21=, $21, $pop20
; NO-SIMD128-FAST-NEXT:    i32.or $push22=, $pop19, $pop21
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $14, $6
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push24=, $6, $pop43
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $22, $pop24
; NO-SIMD128-FAST-NEXT:    i32.or $push26=, $pop23, $pop25
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop28), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $15, $7
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push30=, $7, $pop42
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $23, $pop30
; NO-SIMD128-FAST-NEXT:    i32.or $push32=, $pop29, $pop31
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop34), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-FAST-NEXT:    i32.and $push35=, $16, $8
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push36=, $8, $pop41
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $24, $pop36
; NO-SIMD128-FAST-NEXT:    i32.or $push38=, $pop35, $pop37
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop40), $pop38
; NO-SIMD128-FAST-NEXT:    return
  %masked_v1 = and <8 x i16> %v1, %c
  %inv_mask = xor <8 x i16>
    <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>,
    %c
  %masked_v2 = and <8 x i16> %v2, %inv_mask
  %a = or <8 x i16> %masked_v1, %masked_v2
  ret <8 x i16> %a
}

define <8 x i16> @bitselect_xor_v8i16(<8 x i16> %c, <8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: bitselect_xor_v8i16:
; SIMD128:         .functype bitselect_xor_v8i16 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_v8i16:
; SIMD128-FAST:         .functype bitselect_xor_v8i16 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push2=, $1, $2
; SIMD128-FAST-NEXT:    v128.and $push1=, $pop2, $0
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop1, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_v8i16:
; NO-SIMD128:         .functype bitselect_xor_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push3=, 14
; NO-SIMD128-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-NEXT:    i32.xor $push0=, $16, $24
; NO-SIMD128-NEXT:    i32.and $push1=, $pop0, $8
; NO-SIMD128-NEXT:    i32.xor $push2=, $pop1, $24
; NO-SIMD128-NEXT:    i32.store16 0($pop4), $pop2
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.xor $push5=, $15, $23
; NO-SIMD128-NEXT:    i32.and $push6=, $pop5, $7
; NO-SIMD128-NEXT:    i32.xor $push7=, $pop6, $23
; NO-SIMD128-NEXT:    i32.store16 0($pop9), $pop7
; NO-SIMD128-NEXT:    i32.const $push13=, 10
; NO-SIMD128-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-NEXT:    i32.xor $push10=, $14, $22
; NO-SIMD128-NEXT:    i32.and $push11=, $pop10, $6
; NO-SIMD128-NEXT:    i32.xor $push12=, $pop11, $22
; NO-SIMD128-NEXT:    i32.store16 0($pop14), $pop12
; NO-SIMD128-NEXT:    i32.xor $push15=, $13, $21
; NO-SIMD128-NEXT:    i32.and $push16=, $pop15, $5
; NO-SIMD128-NEXT:    i32.xor $push17=, $pop16, $21
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop17
; NO-SIMD128-NEXT:    i32.const $push21=, 6
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.xor $push18=, $12, $20
; NO-SIMD128-NEXT:    i32.and $push19=, $pop18, $4
; NO-SIMD128-NEXT:    i32.xor $push20=, $pop19, $20
; NO-SIMD128-NEXT:    i32.store16 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.xor $push23=, $11, $19
; NO-SIMD128-NEXT:    i32.and $push24=, $pop23, $3
; NO-SIMD128-NEXT:    i32.xor $push25=, $pop24, $19
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop25
; NO-SIMD128-NEXT:    i32.xor $push26=, $10, $18
; NO-SIMD128-NEXT:    i32.and $push27=, $pop26, $2
; NO-SIMD128-NEXT:    i32.xor $push28=, $pop27, $18
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop28
; NO-SIMD128-NEXT:    i32.xor $push29=, $9, $17
; NO-SIMD128-NEXT:    i32.and $push30=, $pop29, $1
; NO-SIMD128-NEXT:    i32.xor $push31=, $pop30, $17
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop31
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_v8i16:
; NO-SIMD128-FAST:         .functype bitselect_xor_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $9, $17
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $pop1, $17
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $10, $18
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $pop4, $18
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $11, $19
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $3
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $19
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $12, $20
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $pop11, $4
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $pop12, $20
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop10), $pop13
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $13, $21
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $pop14, $5
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $pop15, $21
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.xor $push19=, $14, $22
; NO-SIMD128-FAST-NEXT:    i32.and $push20=, $pop19, $6
; NO-SIMD128-FAST-NEXT:    i32.xor $push21=, $pop20, $22
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop18), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push22=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push23=, $0, $pop22
; NO-SIMD128-FAST-NEXT:    i32.xor $push24=, $15, $23
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $pop24, $7
; NO-SIMD128-FAST-NEXT:    i32.xor $push26=, $pop25, $23
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop23), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $16, $24
; NO-SIMD128-FAST-NEXT:    i32.and $push30=, $pop29, $8
; NO-SIMD128-FAST-NEXT:    i32.xor $push31=, $pop30, $24
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop28), $pop31
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <8 x i16> %v1, %v2
 %and = and <8 x i16> %xor1, %c
 %a = xor <8 x i16> %and, %v2
 ret <8 x i16> %a
}

define <8 x i16> @bitselect_xor_reversed_v8i16(<8 x i16> %c, <8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: bitselect_xor_reversed_v8i16:
; SIMD128:         .functype bitselect_xor_reversed_v8i16 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $2, $1, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_reversed_v8i16:
; SIMD128-FAST:         .functype bitselect_xor_reversed_v8i16 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push1=, $1, $2
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $pop1, $pop2
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop3, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_reversed_v8i16:
; NO-SIMD128:         .functype bitselect_xor_reversed_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push5=, 14
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.xor $push2=, $16, $24
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $8, $pop0
; NO-SIMD128-NEXT:    i32.and $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.xor $push4=, $pop3, $24
; NO-SIMD128-NEXT:    i32.store16 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push11=, 12
; NO-SIMD128-NEXT:    i32.add $push12=, $0, $pop11
; NO-SIMD128-NEXT:    i32.xor $push8=, $15, $23
; NO-SIMD128-NEXT:    i32.const $push47=, -1
; NO-SIMD128-NEXT:    i32.xor $push7=, $7, $pop47
; NO-SIMD128-NEXT:    i32.and $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.xor $push10=, $pop9, $23
; NO-SIMD128-NEXT:    i32.store16 0($pop12), $pop10
; NO-SIMD128-NEXT:    i32.const $push17=, 10
; NO-SIMD128-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-NEXT:    i32.xor $push14=, $14, $22
; NO-SIMD128-NEXT:    i32.const $push46=, -1
; NO-SIMD128-NEXT:    i32.xor $push13=, $6, $pop46
; NO-SIMD128-NEXT:    i32.and $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.xor $push16=, $pop15, $22
; NO-SIMD128-NEXT:    i32.store16 0($pop18), $pop16
; NO-SIMD128-NEXT:    i32.xor $push20=, $13, $21
; NO-SIMD128-NEXT:    i32.const $push45=, -1
; NO-SIMD128-NEXT:    i32.xor $push19=, $5, $pop45
; NO-SIMD128-NEXT:    i32.and $push21=, $pop20, $pop19
; NO-SIMD128-NEXT:    i32.xor $push22=, $pop21, $21
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop22
; NO-SIMD128-NEXT:    i32.const $push27=, 6
; NO-SIMD128-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-NEXT:    i32.xor $push24=, $12, $20
; NO-SIMD128-NEXT:    i32.const $push44=, -1
; NO-SIMD128-NEXT:    i32.xor $push23=, $4, $pop44
; NO-SIMD128-NEXT:    i32.and $push25=, $pop24, $pop23
; NO-SIMD128-NEXT:    i32.xor $push26=, $pop25, $20
; NO-SIMD128-NEXT:    i32.store16 0($pop28), $pop26
; NO-SIMD128-NEXT:    i32.xor $push30=, $11, $19
; NO-SIMD128-NEXT:    i32.const $push43=, -1
; NO-SIMD128-NEXT:    i32.xor $push29=, $3, $pop43
; NO-SIMD128-NEXT:    i32.and $push31=, $pop30, $pop29
; NO-SIMD128-NEXT:    i32.xor $push32=, $pop31, $19
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop32
; NO-SIMD128-NEXT:    i32.xor $push34=, $10, $18
; NO-SIMD128-NEXT:    i32.const $push42=, -1
; NO-SIMD128-NEXT:    i32.xor $push33=, $2, $pop42
; NO-SIMD128-NEXT:    i32.and $push35=, $pop34, $pop33
; NO-SIMD128-NEXT:    i32.xor $push36=, $pop35, $18
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop36
; NO-SIMD128-NEXT:    i32.xor $push38=, $9, $17
; NO-SIMD128-NEXT:    i32.const $push41=, -1
; NO-SIMD128-NEXT:    i32.xor $push37=, $1, $pop41
; NO-SIMD128-NEXT:    i32.and $push39=, $pop38, $pop37
; NO-SIMD128-NEXT:    i32.xor $push40=, $pop39, $17
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop40
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_reversed_v8i16:
; NO-SIMD128-FAST:         .functype bitselect_xor_reversed_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $9, $17
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.xor $push4=, $pop3, $17
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $10, $18
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $2, $pop47
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $18
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.xor $push10=, $11, $19
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $3, $pop46
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $pop11, $19
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $12, $20
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $4, $pop45
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $pop15, $20
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop18), $pop16
; NO-SIMD128-FAST-NEXT:    i32.xor $push20=, $13, $21
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push19=, $5, $pop44
; NO-SIMD128-FAST-NEXT:    i32.and $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.xor $push22=, $pop21, $21
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop22
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.xor $push24=, $14, $22
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push23=, $6, $pop43
; NO-SIMD128-FAST-NEXT:    i32.and $push25=, $pop24, $pop23
; NO-SIMD128-FAST-NEXT:    i32.xor $push26=, $pop25, $22
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop28), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push34=, $0, $pop33
; NO-SIMD128-FAST-NEXT:    i32.xor $push30=, $15, $23
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push29=, $7, $pop42
; NO-SIMD128-FAST-NEXT:    i32.and $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.xor $push32=, $pop31, $23
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop34), $pop32
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push40=, $0, $pop39
; NO-SIMD128-FAST-NEXT:    i32.xor $push36=, $16, $24
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push35=, $8, $pop41
; NO-SIMD128-FAST-NEXT:    i32.and $push37=, $pop36, $pop35
; NO-SIMD128-FAST-NEXT:    i32.xor $push38=, $pop37, $24
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop40), $pop38
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <8 x i16> %v1, %v2
 %notc = xor <8 x i16> %c, <i16 -1, i16 -1, i16 -1, i16 -1,
                            i16 -1, i16 -1, i16 -1, i16 -1>
 %and = and <8 x i16> %xor1, %notc
 %a = xor <8 x i16> %and, %v2
 ret <8 x i16> %a
}

define <8 x i16> @extmul_low_s_v8i16(<16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: extmul_low_s_v8i16:
; SIMD128:         .functype extmul_low_s_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extmul_low_i8x16_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_low_s_v8i16:
; SIMD128-FAST:         .functype extmul_low_s_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extend_low_i8x16_s $push0=, $0
; SIMD128-FAST-NEXT:    i16x8.extend_low_i8x16_s $push1=, $1
; SIMD128-FAST-NEXT:    i16x8.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_low_s_v8i16:
; NO-SIMD128:         .functype extmul_low_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend8_s $push1=, $5
; NO-SIMD128-NEXT:    i32.extend8_s $push0=, $21
; NO-SIMD128-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop2
; NO-SIMD128-NEXT:    i32.extend8_s $push4=, $3
; NO-SIMD128-NEXT:    i32.extend8_s $push3=, $19
; NO-SIMD128-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop5
; NO-SIMD128-NEXT:    i32.extend8_s $push7=, $2
; NO-SIMD128-NEXT:    i32.extend8_s $push6=, $18
; NO-SIMD128-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop8
; NO-SIMD128-NEXT:    i32.extend8_s $push10=, $1
; NO-SIMD128-NEXT:    i32.extend8_s $push9=, $17
; NO-SIMD128-NEXT:    i32.mul $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop11
; NO-SIMD128-NEXT:    i32.const $push15=, 14
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.extend8_s $push13=, $8
; NO-SIMD128-NEXT:    i32.extend8_s $push12=, $24
; NO-SIMD128-NEXT:    i32.mul $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.store16 0($pop16), $pop14
; NO-SIMD128-NEXT:    i32.const $push20=, 12
; NO-SIMD128-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-NEXT:    i32.extend8_s $push18=, $7
; NO-SIMD128-NEXT:    i32.extend8_s $push17=, $23
; NO-SIMD128-NEXT:    i32.mul $push19=, $pop18, $pop17
; NO-SIMD128-NEXT:    i32.store16 0($pop21), $pop19
; NO-SIMD128-NEXT:    i32.const $push25=, 10
; NO-SIMD128-NEXT:    i32.add $push26=, $0, $pop25
; NO-SIMD128-NEXT:    i32.extend8_s $push23=, $6
; NO-SIMD128-NEXT:    i32.extend8_s $push22=, $22
; NO-SIMD128-NEXT:    i32.mul $push24=, $pop23, $pop22
; NO-SIMD128-NEXT:    i32.store16 0($pop26), $pop24
; NO-SIMD128-NEXT:    i32.const $push30=, 6
; NO-SIMD128-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-NEXT:    i32.extend8_s $push28=, $4
; NO-SIMD128-NEXT:    i32.extend8_s $push27=, $20
; NO-SIMD128-NEXT:    i32.mul $push29=, $pop28, $pop27
; NO-SIMD128-NEXT:    i32.store16 0($pop31), $pop29
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_low_s_v8i16:
; NO-SIMD128-FAST:         .functype extmul_low_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push0=, $17
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push4=, $2
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push3=, $18
; NO-SIMD128-FAST-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push7=, $3
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push6=, $19
; NO-SIMD128-FAST-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push12=, $4
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push11=, $20
; NO-SIMD128-FAST-NEXT:    i32.mul $push13=, $pop12, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop10), $pop13
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push15=, $5
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push14=, $21
; NO-SIMD128-FAST-NEXT:    i32.mul $push16=, $pop15, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push20=, $6
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push19=, $22
; NO-SIMD128-FAST-NEXT:    i32.mul $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop18), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push22=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push23=, $0, $pop22
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push25=, $7
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push24=, $23
; NO-SIMD128-FAST-NEXT:    i32.mul $push26=, $pop25, $pop24
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop23), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push30=, $8
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push29=, $24
; NO-SIMD128-FAST-NEXT:    i32.mul $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop28), $pop31
; NO-SIMD128-FAST-NEXT:    return
  %low1 = shufflevector <16 x i8> %v1, <16 x i8> undef,
           <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %low2 = shufflevector <16 x i8> %v2, <16 x i8> undef,
           <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %extended1 = sext <8 x i8> %low1 to <8 x i16>
  %extended2 = sext <8 x i8> %low2 to <8 x i16>
  %a = mul <8 x i16> %extended1, %extended2
  ret <8 x i16> %a
}

define <8 x i16> @extmul_high_s_v8i16(<16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: extmul_high_s_v8i16:
; SIMD128:         .functype extmul_high_s_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extmul_high_i8x16_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_high_s_v8i16:
; SIMD128-FAST:         .functype extmul_high_s_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extend_high_i8x16_s $push0=, $0
; SIMD128-FAST-NEXT:    i16x8.extend_high_i8x16_s $push1=, $1
; SIMD128-FAST-NEXT:    i16x8.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_high_s_v8i16:
; NO-SIMD128:         .functype extmul_high_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend8_s $push1=, $13
; NO-SIMD128-NEXT:    i32.extend8_s $push0=, $29
; NO-SIMD128-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop2
; NO-SIMD128-NEXT:    i32.extend8_s $push4=, $11
; NO-SIMD128-NEXT:    i32.extend8_s $push3=, $27
; NO-SIMD128-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop5
; NO-SIMD128-NEXT:    i32.extend8_s $push7=, $10
; NO-SIMD128-NEXT:    i32.extend8_s $push6=, $26
; NO-SIMD128-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop8
; NO-SIMD128-NEXT:    i32.extend8_s $push10=, $9
; NO-SIMD128-NEXT:    i32.extend8_s $push9=, $25
; NO-SIMD128-NEXT:    i32.mul $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop11
; NO-SIMD128-NEXT:    i32.const $push15=, 14
; NO-SIMD128-NEXT:    i32.add $push16=, $0, $pop15
; NO-SIMD128-NEXT:    i32.extend8_s $push13=, $16
; NO-SIMD128-NEXT:    i32.extend8_s $push12=, $32
; NO-SIMD128-NEXT:    i32.mul $push14=, $pop13, $pop12
; NO-SIMD128-NEXT:    i32.store16 0($pop16), $pop14
; NO-SIMD128-NEXT:    i32.const $push20=, 12
; NO-SIMD128-NEXT:    i32.add $push21=, $0, $pop20
; NO-SIMD128-NEXT:    i32.extend8_s $push18=, $15
; NO-SIMD128-NEXT:    i32.extend8_s $push17=, $31
; NO-SIMD128-NEXT:    i32.mul $push19=, $pop18, $pop17
; NO-SIMD128-NEXT:    i32.store16 0($pop21), $pop19
; NO-SIMD128-NEXT:    i32.const $push25=, 10
; NO-SIMD128-NEXT:    i32.add $push26=, $0, $pop25
; NO-SIMD128-NEXT:    i32.extend8_s $push23=, $14
; NO-SIMD128-NEXT:    i32.extend8_s $push22=, $30
; NO-SIMD128-NEXT:    i32.mul $push24=, $pop23, $pop22
; NO-SIMD128-NEXT:    i32.store16 0($pop26), $pop24
; NO-SIMD128-NEXT:    i32.const $push30=, 6
; NO-SIMD128-NEXT:    i32.add $push31=, $0, $pop30
; NO-SIMD128-NEXT:    i32.extend8_s $push28=, $12
; NO-SIMD128-NEXT:    i32.extend8_s $push27=, $28
; NO-SIMD128-NEXT:    i32.mul $push29=, $pop28, $pop27
; NO-SIMD128-NEXT:    i32.store16 0($pop31), $pop29
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_high_s_v8i16:
; NO-SIMD128-FAST:         .functype extmul_high_s_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push1=, $9
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push0=, $25
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push4=, $10
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push3=, $26
; NO-SIMD128-FAST-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push7=, $11
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push6=, $27
; NO-SIMD128-FAST-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push12=, $12
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push11=, $28
; NO-SIMD128-FAST-NEXT:    i32.mul $push13=, $pop12, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop10), $pop13
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push15=, $13
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push14=, $29
; NO-SIMD128-FAST-NEXT:    i32.mul $push16=, $pop15, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push20=, $14
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push19=, $30
; NO-SIMD128-FAST-NEXT:    i32.mul $push21=, $pop20, $pop19
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop18), $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push22=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push23=, $0, $pop22
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push25=, $15
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push24=, $31
; NO-SIMD128-FAST-NEXT:    i32.mul $push26=, $pop25, $pop24
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop23), $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push27=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push28=, $0, $pop27
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push30=, $16
; NO-SIMD128-FAST-NEXT:    i32.extend8_s $push29=, $32
; NO-SIMD128-FAST-NEXT:    i32.mul $push31=, $pop30, $pop29
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop28), $pop31
; NO-SIMD128-FAST-NEXT:    return
  %high1 = shufflevector <16 x i8> %v1, <16 x i8> undef,
           <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %high2 = shufflevector <16 x i8> %v2, <16 x i8> undef,
           <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %extended1 = sext <8 x i8> %high1 to <8 x i16>
  %extended2 = sext <8 x i8> %high2 to <8 x i16>
  %a = mul <8 x i16> %extended1, %extended2
  ret <8 x i16> %a
}

define <8 x i16> @extmul_low_u_v8i16(<16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: extmul_low_u_v8i16:
; SIMD128:         .functype extmul_low_u_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extmul_low_i8x16_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_low_u_v8i16:
; SIMD128-FAST:         .functype extmul_low_u_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extend_low_i8x16_u $push0=, $0
; SIMD128-FAST-NEXT:    i16x8.extend_low_i8x16_u $push1=, $1
; SIMD128-FAST-NEXT:    i16x8.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_low_u_v8i16:
; NO-SIMD128:         .functype extmul_low_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push2=, $5, $pop0
; NO-SIMD128-NEXT:    i32.const $push47=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $21, $pop47
; NO-SIMD128-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push46=, 255
; NO-SIMD128-NEXT:    i32.and $push5=, $3, $pop46
; NO-SIMD128-NEXT:    i32.const $push45=, 255
; NO-SIMD128-NEXT:    i32.and $push4=, $19, $pop45
; NO-SIMD128-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push44=, 255
; NO-SIMD128-NEXT:    i32.and $push8=, $2, $pop44
; NO-SIMD128-NEXT:    i32.const $push43=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $18, $pop43
; NO-SIMD128-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push42=, 255
; NO-SIMD128-NEXT:    i32.and $push11=, $1, $pop42
; NO-SIMD128-NEXT:    i32.const $push41=, 255
; NO-SIMD128-NEXT:    i32.and $push10=, $17, $pop41
; NO-SIMD128-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push16=, 14
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.const $push40=, 255
; NO-SIMD128-NEXT:    i32.and $push14=, $8, $pop40
; NO-SIMD128-NEXT:    i32.const $push39=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $24, $pop39
; NO-SIMD128-NEXT:    i32.mul $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.store16 0($pop17), $pop15
; NO-SIMD128-NEXT:    i32.const $push21=, 12
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.const $push38=, 255
; NO-SIMD128-NEXT:    i32.and $push19=, $7, $pop38
; NO-SIMD128-NEXT:    i32.const $push37=, 255
; NO-SIMD128-NEXT:    i32.and $push18=, $23, $pop37
; NO-SIMD128-NEXT:    i32.mul $push20=, $pop19, $pop18
; NO-SIMD128-NEXT:    i32.store16 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push26=, 10
; NO-SIMD128-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-NEXT:    i32.const $push36=, 255
; NO-SIMD128-NEXT:    i32.and $push24=, $6, $pop36
; NO-SIMD128-NEXT:    i32.const $push35=, 255
; NO-SIMD128-NEXT:    i32.and $push23=, $22, $pop35
; NO-SIMD128-NEXT:    i32.mul $push25=, $pop24, $pop23
; NO-SIMD128-NEXT:    i32.store16 0($pop27), $pop25
; NO-SIMD128-NEXT:    i32.const $push31=, 6
; NO-SIMD128-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-NEXT:    i32.const $push34=, 255
; NO-SIMD128-NEXT:    i32.and $push29=, $4, $pop34
; NO-SIMD128-NEXT:    i32.const $push33=, 255
; NO-SIMD128-NEXT:    i32.and $push28=, $20, $pop33
; NO-SIMD128-NEXT:    i32.mul $push30=, $pop29, $pop28
; NO-SIMD128-NEXT:    i32.store16 0($pop32), $pop30
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_low_u_v8i16:
; NO-SIMD128-FAST:         .functype extmul_low_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $17, $pop47
; NO-SIMD128-FAST-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $2, $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $18, $pop45
; NO-SIMD128-FAST-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $3, $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $19, $pop43
; NO-SIMD128-FAST-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $4, $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $20, $pop41
; NO-SIMD128-FAST-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop14), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $5, $pop40
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $21, $pop39
; NO-SIMD128-FAST-NEXT:    i32.mul $push17=, $pop16, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $6, $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $22, $pop37
; NO-SIMD128-FAST-NEXT:    i32.mul $push20=, $pop19, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop22), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $7, $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $23, $pop35
; NO-SIMD128-FAST-NEXT:    i32.mul $push25=, $pop24, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop27), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $8, $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $24, $pop33
; NO-SIMD128-FAST-NEXT:    i32.mul $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop32), $pop30
; NO-SIMD128-FAST-NEXT:    return
  %low1 = shufflevector <16 x i8> %v1, <16 x i8> undef,
           <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %low2 = shufflevector <16 x i8> %v2, <16 x i8> undef,
           <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  %extended1 = zext <8 x i8> %low1 to <8 x i16>
  %extended2 = zext <8 x i8> %low2 to <8 x i16>
  %a = mul <8 x i16> %extended1, %extended2
  ret <8 x i16> %a
}

define <8 x i16> @extmul_high_u_v8i16(<16 x i8> %v1, <16 x i8> %v2) {
; SIMD128-LABEL: extmul_high_u_v8i16:
; SIMD128:         .functype extmul_high_u_v8i16 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i16x8.extmul_high_i8x16_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_high_u_v8i16:
; SIMD128-FAST:         .functype extmul_high_u_v8i16 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i16x8.extend_high_i8x16_u $push0=, $0
; SIMD128-FAST-NEXT:    i16x8.extend_high_i8x16_u $push1=, $1
; SIMD128-FAST-NEXT:    i16x8.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_high_u_v8i16:
; NO-SIMD128:         .functype extmul_high_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 255
; NO-SIMD128-NEXT:    i32.and $push2=, $13, $pop0
; NO-SIMD128-NEXT:    i32.const $push47=, 255
; NO-SIMD128-NEXT:    i32.and $push1=, $29, $pop47
; NO-SIMD128-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store16 8($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push46=, 255
; NO-SIMD128-NEXT:    i32.and $push5=, $11, $pop46
; NO-SIMD128-NEXT:    i32.const $push45=, 255
; NO-SIMD128-NEXT:    i32.and $push4=, $27, $pop45
; NO-SIMD128-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store16 4($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push44=, 255
; NO-SIMD128-NEXT:    i32.and $push8=, $10, $pop44
; NO-SIMD128-NEXT:    i32.const $push43=, 255
; NO-SIMD128-NEXT:    i32.and $push7=, $26, $pop43
; NO-SIMD128-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store16 2($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push42=, 255
; NO-SIMD128-NEXT:    i32.and $push11=, $9, $pop42
; NO-SIMD128-NEXT:    i32.const $push41=, 255
; NO-SIMD128-NEXT:    i32.and $push10=, $25, $pop41
; NO-SIMD128-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store16 0($0), $pop12
; NO-SIMD128-NEXT:    i32.const $push16=, 14
; NO-SIMD128-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-NEXT:    i32.const $push40=, 255
; NO-SIMD128-NEXT:    i32.and $push14=, $16, $pop40
; NO-SIMD128-NEXT:    i32.const $push39=, 255
; NO-SIMD128-NEXT:    i32.and $push13=, $32, $pop39
; NO-SIMD128-NEXT:    i32.mul $push15=, $pop14, $pop13
; NO-SIMD128-NEXT:    i32.store16 0($pop17), $pop15
; NO-SIMD128-NEXT:    i32.const $push21=, 12
; NO-SIMD128-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-NEXT:    i32.const $push38=, 255
; NO-SIMD128-NEXT:    i32.and $push19=, $15, $pop38
; NO-SIMD128-NEXT:    i32.const $push37=, 255
; NO-SIMD128-NEXT:    i32.and $push18=, $31, $pop37
; NO-SIMD128-NEXT:    i32.mul $push20=, $pop19, $pop18
; NO-SIMD128-NEXT:    i32.store16 0($pop22), $pop20
; NO-SIMD128-NEXT:    i32.const $push26=, 10
; NO-SIMD128-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-NEXT:    i32.const $push36=, 255
; NO-SIMD128-NEXT:    i32.and $push24=, $14, $pop36
; NO-SIMD128-NEXT:    i32.const $push35=, 255
; NO-SIMD128-NEXT:    i32.and $push23=, $30, $pop35
; NO-SIMD128-NEXT:    i32.mul $push25=, $pop24, $pop23
; NO-SIMD128-NEXT:    i32.store16 0($pop27), $pop25
; NO-SIMD128-NEXT:    i32.const $push31=, 6
; NO-SIMD128-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-NEXT:    i32.const $push34=, 255
; NO-SIMD128-NEXT:    i32.and $push29=, $12, $pop34
; NO-SIMD128-NEXT:    i32.const $push33=, 255
; NO-SIMD128-NEXT:    i32.and $push28=, $28, $pop33
; NO-SIMD128-NEXT:    i32.mul $push30=, $pop29, $pop28
; NO-SIMD128-NEXT:    i32.store16 0($pop32), $pop30
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_high_u_v8i16:
; NO-SIMD128-FAST:         .functype extmul_high_u_v8i16 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $9, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push47=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $25, $pop47
; NO-SIMD128-FAST-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store16 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push46=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $10, $pop46
; NO-SIMD128-FAST-NEXT:    i32.const $push45=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $26, $pop45
; NO-SIMD128-FAST-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store16 2($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push44=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $11, $pop44
; NO-SIMD128-FAST-NEXT:    i32.const $push43=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $27, $pop43
; NO-SIMD128-FAST-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store16 4($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 6
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push42=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $12, $pop42
; NO-SIMD128-FAST-NEXT:    i32.const $push41=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $28, $pop41
; NO-SIMD128-FAST-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop14), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push40=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push16=, $13, $pop40
; NO-SIMD128-FAST-NEXT:    i32.const $push39=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $29, $pop39
; NO-SIMD128-FAST-NEXT:    i32.mul $push17=, $pop16, $pop15
; NO-SIMD128-FAST-NEXT:    i32.store16 8($0), $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 10
; NO-SIMD128-FAST-NEXT:    i32.add $push22=, $0, $pop21
; NO-SIMD128-FAST-NEXT:    i32.const $push38=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push19=, $14, $pop38
; NO-SIMD128-FAST-NEXT:    i32.const $push37=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push18=, $30, $pop37
; NO-SIMD128-FAST-NEXT:    i32.mul $push20=, $pop19, $pop18
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop22), $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push26=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push27=, $0, $pop26
; NO-SIMD128-FAST-NEXT:    i32.const $push36=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push24=, $15, $pop36
; NO-SIMD128-FAST-NEXT:    i32.const $push35=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push23=, $31, $pop35
; NO-SIMD128-FAST-NEXT:    i32.mul $push25=, $pop24, $pop23
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop27), $pop25
; NO-SIMD128-FAST-NEXT:    i32.const $push31=, 14
; NO-SIMD128-FAST-NEXT:    i32.add $push32=, $0, $pop31
; NO-SIMD128-FAST-NEXT:    i32.const $push34=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push29=, $16, $pop34
; NO-SIMD128-FAST-NEXT:    i32.const $push33=, 255
; NO-SIMD128-FAST-NEXT:    i32.and $push28=, $32, $pop33
; NO-SIMD128-FAST-NEXT:    i32.mul $push30=, $pop29, $pop28
; NO-SIMD128-FAST-NEXT:    i32.store16 0($pop32), $pop30
; NO-SIMD128-FAST-NEXT:    return
  %high1 = shufflevector <16 x i8> %v1, <16 x i8> undef,
           <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %high2 = shufflevector <16 x i8> %v2, <16 x i8> undef,
           <8 x i32> <i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  %extended1 = zext <8 x i8> %high1 to <8 x i16>
  %extended2 = zext <8 x i8> %high2 to <8 x i16>
  %a = mul <8 x i16> %extended1, %extended2
  ret <8 x i16> %a
}

; ==============================================================================
; 4 x i32
; ==============================================================================
define <4 x i32> @add_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: add_v4i32:
; SIMD128:         .functype add_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.add $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: add_v4i32:
; SIMD128-FAST:         .functype add_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.add $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: add_v4i32:
; NO-SIMD128:         .functype add_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.add $push0=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop0
; NO-SIMD128-NEXT:    i32.add $push1=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-NEXT:    i32.add $push2=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.add $push3=, $4, $8
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: add_v4i32:
; NO-SIMD128-FAST:         .functype add_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.add $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.add $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.add $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = add <4 x i32> %x, %y
  ret <4 x i32> %a
}

define <4 x i32> @sub_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: sub_v4i32:
; SIMD128:         .functype sub_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.sub $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sub_v4i32:
; SIMD128-FAST:         .functype sub_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.sub $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sub_v4i32:
; NO-SIMD128:         .functype sub_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.sub $push0=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop0
; NO-SIMD128-NEXT:    i32.sub $push1=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-NEXT:    i32.sub $push2=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.sub $push3=, $4, $8
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sub_v4i32:
; NO-SIMD128-FAST:         .functype sub_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.sub $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.sub $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.sub $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <4 x i32> %x, %y
  ret <4 x i32> %a
}

define <4 x i32> @mul_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: mul_v4i32:
; SIMD128:         .functype mul_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.mul $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: mul_v4i32:
; SIMD128-FAST:         .functype mul_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.mul $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: mul_v4i32:
; NO-SIMD128:         .functype mul_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.mul $push0=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop0
; NO-SIMD128-NEXT:    i32.mul $push1=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-NEXT:    i32.mul $push2=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.mul $push3=, $4, $8
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: mul_v4i32:
; NO-SIMD128-FAST:         .functype mul_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.mul $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.mul $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.mul $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = mul <4 x i32> %x, %y
  ret <4 x i32> %a
}

define <4 x i32> @min_s_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: min_s_v4i32:
; SIMD128:         .functype min_s_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.min_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_s_v4i32:
; SIMD128-FAST:         .functype min_s_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.min_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_s_v4i32:
; NO-SIMD128:         .functype min_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.lt_s $push0=, $3, $7
; NO-SIMD128-NEXT:    i32.select $push1=, $3, $7, $pop0
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.lt_s $push2=, $2, $6
; NO-SIMD128-NEXT:    i32.select $push3=, $2, $6, $pop2
; NO-SIMD128-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-NEXT:    i32.lt_s $push4=, $1, $5
; NO-SIMD128-NEXT:    i32.select $push5=, $1, $5, $pop4
; NO-SIMD128-NEXT:    i32.store 0($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.lt_s $push6=, $4, $8
; NO-SIMD128-NEXT:    i32.select $push7=, $4, $8, $pop6
; NO-SIMD128-NEXT:    i32.store 0($pop9), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_s_v4i32:
; NO-SIMD128-FAST:         .functype min_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.select $push1=, $1, $5, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $2, $6, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.select $push5=, $3, $7, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-FAST-NEXT:    i32.lt_s $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $4, $8, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop9), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp slt <4 x i32> %x, %y
  %a = select <4 x i1> %c, <4 x i32> %x, <4 x i32> %y
  ret <4 x i32> %a
}

define <4 x i32> @min_u_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: min_u_v4i32:
; SIMD128:         .functype min_u_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.min_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_u_v4i32:
; SIMD128-FAST:         .functype min_u_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.min_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_u_v4i32:
; NO-SIMD128:         .functype min_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.lt_u $push0=, $3, $7
; NO-SIMD128-NEXT:    i32.select $push1=, $3, $7, $pop0
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.lt_u $push2=, $2, $6
; NO-SIMD128-NEXT:    i32.select $push3=, $2, $6, $pop2
; NO-SIMD128-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-NEXT:    i32.lt_u $push4=, $1, $5
; NO-SIMD128-NEXT:    i32.select $push5=, $1, $5, $pop4
; NO-SIMD128-NEXT:    i32.store 0($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.lt_u $push6=, $4, $8
; NO-SIMD128-NEXT:    i32.select $push7=, $4, $8, $pop6
; NO-SIMD128-NEXT:    i32.store 0($pop9), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_u_v4i32:
; NO-SIMD128-FAST:         .functype min_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.select $push1=, $1, $5, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $2, $6, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.select $push5=, $3, $7, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-FAST-NEXT:    i32.lt_u $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $4, $8, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop9), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp ult <4 x i32> %x, %y
  %a = select <4 x i1> %c, <4 x i32> %x, <4 x i32> %y
  ret <4 x i32> %a
}

define <4 x i32> @max_s_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: max_s_v4i32:
; SIMD128:         .functype max_s_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.max_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_s_v4i32:
; SIMD128-FAST:         .functype max_s_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.max_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_s_v4i32:
; NO-SIMD128:         .functype max_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.gt_s $push0=, $3, $7
; NO-SIMD128-NEXT:    i32.select $push1=, $3, $7, $pop0
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.gt_s $push2=, $2, $6
; NO-SIMD128-NEXT:    i32.select $push3=, $2, $6, $pop2
; NO-SIMD128-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-NEXT:    i32.gt_s $push4=, $1, $5
; NO-SIMD128-NEXT:    i32.select $push5=, $1, $5, $pop4
; NO-SIMD128-NEXT:    i32.store 0($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.gt_s $push6=, $4, $8
; NO-SIMD128-NEXT:    i32.select $push7=, $4, $8, $pop6
; NO-SIMD128-NEXT:    i32.store 0($pop9), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_s_v4i32:
; NO-SIMD128-FAST:         .functype max_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.select $push1=, $1, $5, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $2, $6, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.select $push5=, $3, $7, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-FAST-NEXT:    i32.gt_s $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $4, $8, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop9), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp sgt <4 x i32> %x, %y
  %a = select <4 x i1> %c, <4 x i32> %x, <4 x i32> %y
  ret <4 x i32> %a
}

define <4 x i32> @max_u_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: max_u_v4i32:
; SIMD128:         .functype max_u_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.max_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_u_v4i32:
; SIMD128-FAST:         .functype max_u_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.max_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_u_v4i32:
; NO-SIMD128:         .functype max_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.gt_u $push0=, $3, $7
; NO-SIMD128-NEXT:    i32.select $push1=, $3, $7, $pop0
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.gt_u $push2=, $2, $6
; NO-SIMD128-NEXT:    i32.select $push3=, $2, $6, $pop2
; NO-SIMD128-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-NEXT:    i32.gt_u $push4=, $1, $5
; NO-SIMD128-NEXT:    i32.select $push5=, $1, $5, $pop4
; NO-SIMD128-NEXT:    i32.store 0($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    i32.gt_u $push6=, $4, $8
; NO-SIMD128-NEXT:    i32.select $push7=, $4, $8, $pop6
; NO-SIMD128-NEXT:    i32.store 0($pop9), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_u_v4i32:
; NO-SIMD128-FAST:         .functype max_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.select $push1=, $1, $5, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $2, $6, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.select $push5=, $3, $7, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-FAST-NEXT:    i32.gt_u $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $4, $8, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop9), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = icmp ugt <4 x i32> %x, %y
  %a = select <4 x i1> %c, <4 x i32> %x, <4 x i32> %y
  ret <4 x i32> %a
}

define <4 x i32> @abs_v4i32(<4 x i32> %x) {
; SIMD128-LABEL: abs_v4i32:
; SIMD128:         .functype abs_v4i32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.abs $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: abs_v4i32:
; SIMD128-FAST:         .functype abs_v4i32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.abs $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: abs_v4i32:
; NO-SIMD128:         .functype abs_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push3=, 12
; NO-SIMD128-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-NEXT:    i32.const $push0=, 31
; NO-SIMD128-NEXT:    i32.shr_s $push21=, $4, $pop0
; NO-SIMD128-NEXT:    local.tee $push20=, $5=, $pop21
; NO-SIMD128-NEXT:    i32.xor $push1=, $4, $pop20
; NO-SIMD128-NEXT:    i32.sub $push2=, $pop1, $5
; NO-SIMD128-NEXT:    i32.store 0($pop4), $pop2
; NO-SIMD128-NEXT:    i32.const $push19=, 31
; NO-SIMD128-NEXT:    i32.shr_s $push18=, $3, $pop19
; NO-SIMD128-NEXT:    local.tee $push17=, $4=, $pop18
; NO-SIMD128-NEXT:    i32.xor $push5=, $3, $pop17
; NO-SIMD128-NEXT:    i32.sub $push6=, $pop5, $4
; NO-SIMD128-NEXT:    i32.store 8($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push16=, 31
; NO-SIMD128-NEXT:    i32.shr_s $push15=, $2, $pop16
; NO-SIMD128-NEXT:    local.tee $push14=, $4=, $pop15
; NO-SIMD128-NEXT:    i32.xor $push7=, $2, $pop14
; NO-SIMD128-NEXT:    i32.sub $push8=, $pop7, $4
; NO-SIMD128-NEXT:    i32.store 4($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push13=, 31
; NO-SIMD128-NEXT:    i32.shr_s $push12=, $1, $pop13
; NO-SIMD128-NEXT:    local.tee $push11=, $4=, $pop12
; NO-SIMD128-NEXT:    i32.xor $push9=, $1, $pop11
; NO-SIMD128-NEXT:    i32.sub $push10=, $pop9, $4
; NO-SIMD128-NEXT:    i32.store 0($0), $pop10
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: abs_v4i32:
; NO-SIMD128-FAST:         .functype abs_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 31
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push21=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    local.tee $push20=, $5=, $pop21
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop20
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $pop1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, 31
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push18=, $2, $pop19
; NO-SIMD128-FAST-NEXT:    local.tee $push17=, $1=, $pop18
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $2, $pop17
; NO-SIMD128-FAST-NEXT:    i32.sub $push4=, $pop3, $1
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push16=, 31
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push15=, $3, $pop16
; NO-SIMD128-FAST-NEXT:    local.tee $push14=, $2=, $pop15
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $3, $pop14
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $pop5, $2
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 31
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push12=, $4, $pop13
; NO-SIMD128-FAST-NEXT:    local.tee $push11=, $0=, $pop12
; NO-SIMD128-FAST-NEXT:    i32.xor $push7=, $4, $pop11
; NO-SIMD128-FAST-NEXT:    i32.sub $push8=, $pop7, $0
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop10), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <4 x i32> zeroinitializer, %x
  %b = icmp slt <4 x i32> %x, zeroinitializer
  %c = select <4 x i1> %b, <4 x i32> %a, <4 x i32> %x
  ret <4 x i32> %c
}

define <4 x i32> @neg_v4i32(<4 x i32> %x) {
; SIMD128-LABEL: neg_v4i32:
; SIMD128:         .functype neg_v4i32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.neg $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: neg_v4i32:
; SIMD128-FAST:         .functype neg_v4i32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.neg $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: neg_v4i32:
; NO-SIMD128:         .functype neg_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 0
; NO-SIMD128-NEXT:    i32.sub $push1=, $pop0, $3
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push9=, 0
; NO-SIMD128-NEXT:    i32.sub $push2=, $pop9, $2
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push8=, 0
; NO-SIMD128-NEXT:    i32.sub $push3=, $pop8, $1
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 12
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.const $push7=, 0
; NO-SIMD128-NEXT:    i32.sub $push4=, $pop7, $4
; NO-SIMD128-NEXT:    i32.store 0($pop6), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: neg_v4i32:
; NO-SIMD128-FAST:         .functype neg_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push2=, $pop9, $2
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push3=, $pop8, $3
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 0
; NO-SIMD128-FAST-NEXT:    i32.sub $push6=, $pop7, $4
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop5), $pop6
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <4 x i32> <i32 0, i32 0, i32 0, i32 0>, %x
  ret <4 x i32> %a
}

define <4 x i32> @shl_v4i32(<4 x i32> %v, i32 %x) {
; SIMD128-LABEL: shl_v4i32:
; SIMD128:         .functype shl_v4i32 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.shl $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shl_v4i32:
; SIMD128-FAST:         .functype shl_v4i32 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.shl $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_v4i32:
; NO-SIMD128:         .functype shl_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.shl $push0=, $3, $5
; NO-SIMD128-NEXT:    i32.store 8($0), $pop0
; NO-SIMD128-NEXT:    i32.shl $push1=, $2, $5
; NO-SIMD128-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-NEXT:    i32.shl $push2=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.shl $push3=, $4, $5
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_v4i32:
; NO-SIMD128-FAST:         .functype shl_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.shl $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $2, $5
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $3, $5
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.shl $push5=, $4, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <4 x i32> undef, i32 %x, i32 0
  %s = shufflevector <4 x i32> %t, <4 x i32> undef,
    <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %a = shl <4 x i32> %v, %s
  ret <4 x i32> %a
}

define <4 x i32> @shl_const_v4i32(<4 x i32> %v) {
; SIMD128-LABEL: shl_const_v4i32:
; SIMD128:         .functype shl_const_v4i32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.const $push0=, 5
; SIMD128-NEXT:    i32x4.shl $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shl_const_v4i32:
; SIMD128-FAST:         .functype shl_const_v4i32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.const $push1=, 5
; SIMD128-FAST-NEXT:    i32x4.shl $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_const_v4i32:
; NO-SIMD128:         .functype shl_const_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 5
; NO-SIMD128-NEXT:    i32.shl $push1=, $3, $pop0
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push9=, 5
; NO-SIMD128-NEXT:    i32.shl $push2=, $2, $pop9
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push8=, 5
; NO-SIMD128-NEXT:    i32.shl $push3=, $1, $pop8
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 12
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.const $push7=, 5
; NO-SIMD128-NEXT:    i32.shl $push4=, $4, $pop7
; NO-SIMD128-NEXT:    i32.store 0($pop6), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_const_v4i32:
; NO-SIMD128-FAST:         .functype shl_const_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $2, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push3=, $3, $pop8
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 5
; NO-SIMD128-FAST-NEXT:    i32.shl $push6=, $4, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop5), $pop6
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <4 x i32> %v, <i32 5, i32 5, i32 5, i32 5>
  ret <4 x i32> %a
}

define <4 x i32> @shl_vec_v4i32(<4 x i32> %v, <4 x i32> %x) {
; SIMD128-LABEL: shl_vec_v4i32:
; SIMD128:         .functype shl_vec_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extract_lane $push4=, $0, 0
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $1, 0
; SIMD128-NEXT:    i32.shl $push5=, $pop4, $pop3
; SIMD128-NEXT:    i32x4.splat $push6=, $pop5
; SIMD128-NEXT:    i32x4.extract_lane $push1=, $0, 1
; SIMD128-NEXT:    i32x4.extract_lane $push0=, $1, 1
; SIMD128-NEXT:    i32.shl $push2=, $pop1, $pop0
; SIMD128-NEXT:    i32x4.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    i32x4.extract_lane $push9=, $0, 2
; SIMD128-NEXT:    i32x4.extract_lane $push8=, $1, 2
; SIMD128-NEXT:    i32.shl $push10=, $pop9, $pop8
; SIMD128-NEXT:    i32x4.replace_lane $push11=, $pop7, 2, $pop10
; SIMD128-NEXT:    i32x4.extract_lane $push13=, $0, 3
; SIMD128-NEXT:    i32x4.extract_lane $push12=, $1, 3
; SIMD128-NEXT:    i32.shl $push14=, $pop13, $pop12
; SIMD128-NEXT:    i32x4.replace_lane $push15=, $pop11, 3, $pop14
; SIMD128-NEXT:    return $pop15
;
; SIMD128-FAST-LABEL: shl_vec_v4i32:
; SIMD128-FAST:         .functype shl_vec_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push5=, $0, 0
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push4=, $1, 0
; SIMD128-FAST-NEXT:    i32.shl $push6=, $pop5, $pop4
; SIMD128-FAST-NEXT:    i32x4.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push2=, $0, 1
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.shl $push3=, $pop2, $pop1
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push8=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push10=, $0, 2
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push9=, $1, 2
; SIMD128-FAST-NEXT:    i32.shl $push11=, $pop10, $pop9
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push12=, $pop8, 2, $pop11
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push14=, $0, 3
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push13=, $1, 3
; SIMD128-FAST-NEXT:    i32.shl $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push0=, $pop12, 3, $pop15
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_vec_v4i32:
; NO-SIMD128:         .functype shl_vec_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.shl $push0=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop0
; NO-SIMD128-NEXT:    i32.shl $push1=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-NEXT:    i32.shl $push2=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.shl $push3=, $4, $8
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_vec_v4i32:
; NO-SIMD128-FAST:         .functype shl_vec_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.shl $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.shl $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shl $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.shl $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <4 x i32> %v, %x
  ret <4 x i32> %a
}

define <4 x i32> @shr_s_v4i32(<4 x i32> %v, i32 %x) {
; SIMD128-LABEL: shr_s_v4i32:
; SIMD128:         .functype shr_s_v4i32 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.shr_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_s_v4i32:
; SIMD128-FAST:         .functype shr_s_v4i32 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.shr_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_v4i32:
; NO-SIMD128:         .functype shr_s_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.shr_s $push0=, $3, $5
; NO-SIMD128-NEXT:    i32.store 8($0), $pop0
; NO-SIMD128-NEXT:    i32.shr_s $push1=, $2, $5
; NO-SIMD128-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-NEXT:    i32.shr_s $push2=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.shr_s $push3=, $4, $5
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_v4i32:
; NO-SIMD128-FAST:         .functype shr_s_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push1=, $2, $5
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push2=, $3, $5
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push5=, $4, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <4 x i32> undef, i32 %x, i32 0
  %s = shufflevector <4 x i32> %t, <4 x i32> undef,
    <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %a = ashr <4 x i32> %v, %s
  ret <4 x i32> %a
}

define <4 x i32> @shr_s_vec_v4i32(<4 x i32> %v, <4 x i32> %x) {
; SIMD128-LABEL: shr_s_vec_v4i32:
; SIMD128:         .functype shr_s_vec_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extract_lane $push4=, $0, 0
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $1, 0
; SIMD128-NEXT:    i32.shr_s $push5=, $pop4, $pop3
; SIMD128-NEXT:    i32x4.splat $push6=, $pop5
; SIMD128-NEXT:    i32x4.extract_lane $push1=, $0, 1
; SIMD128-NEXT:    i32x4.extract_lane $push0=, $1, 1
; SIMD128-NEXT:    i32.shr_s $push2=, $pop1, $pop0
; SIMD128-NEXT:    i32x4.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    i32x4.extract_lane $push9=, $0, 2
; SIMD128-NEXT:    i32x4.extract_lane $push8=, $1, 2
; SIMD128-NEXT:    i32.shr_s $push10=, $pop9, $pop8
; SIMD128-NEXT:    i32x4.replace_lane $push11=, $pop7, 2, $pop10
; SIMD128-NEXT:    i32x4.extract_lane $push13=, $0, 3
; SIMD128-NEXT:    i32x4.extract_lane $push12=, $1, 3
; SIMD128-NEXT:    i32.shr_s $push14=, $pop13, $pop12
; SIMD128-NEXT:    i32x4.replace_lane $push15=, $pop11, 3, $pop14
; SIMD128-NEXT:    return $pop15
;
; SIMD128-FAST-LABEL: shr_s_vec_v4i32:
; SIMD128-FAST:         .functype shr_s_vec_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push5=, $0, 0
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push4=, $1, 0
; SIMD128-FAST-NEXT:    i32.shr_s $push6=, $pop5, $pop4
; SIMD128-FAST-NEXT:    i32x4.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push2=, $0, 1
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.shr_s $push3=, $pop2, $pop1
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push8=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push10=, $0, 2
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push9=, $1, 2
; SIMD128-FAST-NEXT:    i32.shr_s $push11=, $pop10, $pop9
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push12=, $pop8, 2, $pop11
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push14=, $0, 3
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push13=, $1, 3
; SIMD128-FAST-NEXT:    i32.shr_s $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push0=, $pop12, 3, $pop15
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_vec_v4i32:
; NO-SIMD128:         .functype shr_s_vec_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.shr_s $push0=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop0
; NO-SIMD128-NEXT:    i32.shr_s $push1=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-NEXT:    i32.shr_s $push2=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.shr_s $push3=, $4, $8
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_vec_v4i32:
; NO-SIMD128-FAST:         .functype shr_s_vec_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.shr_s $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = ashr <4 x i32> %v, %x
  ret <4 x i32> %a
}

define <4 x i32> @shr_u_v4i32(<4 x i32> %v, i32 %x) {
; SIMD128-LABEL: shr_u_v4i32:
; SIMD128:         .functype shr_u_v4i32 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.shr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_u_v4i32:
; SIMD128-FAST:         .functype shr_u_v4i32 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.shr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_v4i32:
; NO-SIMD128:         .functype shr_u_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.shr_u $push0=, $3, $5
; NO-SIMD128-NEXT:    i32.store 8($0), $pop0
; NO-SIMD128-NEXT:    i32.shr_u $push1=, $2, $5
; NO-SIMD128-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-NEXT:    i32.shr_u $push2=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.shr_u $push3=, $4, $5
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_v4i32:
; NO-SIMD128-FAST:         .functype shr_u_v4i32 (i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push1=, $2, $5
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push2=, $3, $5
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push5=, $4, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <4 x i32> undef, i32 %x, i32 0
  %s = shufflevector <4 x i32> %t, <4 x i32> undef,
    <4 x i32> <i32 0, i32 0, i32 0, i32 0>
  %a = lshr <4 x i32> %v, %s
  ret <4 x i32> %a
}

define <4 x i32> @shr_u_vec_v4i32(<4 x i32> %v, <4 x i32> %x) {
; SIMD128-LABEL: shr_u_vec_v4i32:
; SIMD128:         .functype shr_u_vec_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extract_lane $push4=, $0, 0
; SIMD128-NEXT:    i32x4.extract_lane $push3=, $1, 0
; SIMD128-NEXT:    i32.shr_u $push5=, $pop4, $pop3
; SIMD128-NEXT:    i32x4.splat $push6=, $pop5
; SIMD128-NEXT:    i32x4.extract_lane $push1=, $0, 1
; SIMD128-NEXT:    i32x4.extract_lane $push0=, $1, 1
; SIMD128-NEXT:    i32.shr_u $push2=, $pop1, $pop0
; SIMD128-NEXT:    i32x4.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    i32x4.extract_lane $push9=, $0, 2
; SIMD128-NEXT:    i32x4.extract_lane $push8=, $1, 2
; SIMD128-NEXT:    i32.shr_u $push10=, $pop9, $pop8
; SIMD128-NEXT:    i32x4.replace_lane $push11=, $pop7, 2, $pop10
; SIMD128-NEXT:    i32x4.extract_lane $push13=, $0, 3
; SIMD128-NEXT:    i32x4.extract_lane $push12=, $1, 3
; SIMD128-NEXT:    i32.shr_u $push14=, $pop13, $pop12
; SIMD128-NEXT:    i32x4.replace_lane $push15=, $pop11, 3, $pop14
; SIMD128-NEXT:    return $pop15
;
; SIMD128-FAST-LABEL: shr_u_vec_v4i32:
; SIMD128-FAST:         .functype shr_u_vec_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push5=, $0, 0
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push4=, $1, 0
; SIMD128-FAST-NEXT:    i32.shr_u $push6=, $pop5, $pop4
; SIMD128-FAST-NEXT:    i32x4.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push2=, $0, 1
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push1=, $1, 1
; SIMD128-FAST-NEXT:    i32.shr_u $push3=, $pop2, $pop1
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push8=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push10=, $0, 2
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push9=, $1, 2
; SIMD128-FAST-NEXT:    i32.shr_u $push11=, $pop10, $pop9
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push12=, $pop8, 2, $pop11
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push14=, $0, 3
; SIMD128-FAST-NEXT:    i32x4.extract_lane $push13=, $1, 3
; SIMD128-FAST-NEXT:    i32.shr_u $push15=, $pop14, $pop13
; SIMD128-FAST-NEXT:    i32x4.replace_lane $push0=, $pop12, 3, $pop15
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_vec_v4i32:
; NO-SIMD128:         .functype shr_u_vec_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.shr_u $push0=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop0
; NO-SIMD128-NEXT:    i32.shr_u $push1=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-NEXT:    i32.shr_u $push2=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.shr_u $push3=, $4, $8
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_vec_v4i32:
; NO-SIMD128-FAST:         .functype shr_u_vec_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.shr_u $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = lshr <4 x i32> %v, %x
  ret <4 x i32> %a
}

define <4 x i32> @and_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: and_v4i32:
; SIMD128:         .functype and_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.and $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: and_v4i32:
; SIMD128-FAST:         .functype and_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.and $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: and_v4i32:
; NO-SIMD128:         .functype and_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.and $push0=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop0
; NO-SIMD128-NEXT:    i32.and $push1=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-NEXT:    i32.and $push2=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.and $push3=, $4, $8
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: and_v4i32:
; NO-SIMD128-FAST:         .functype and_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.and $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = and <4 x i32> %x, %y
  ret <4 x i32> %a
}

define <4 x i32> @or_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: or_v4i32:
; SIMD128:         .functype or_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.or $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: or_v4i32:
; SIMD128-FAST:         .functype or_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.or $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: or_v4i32:
; NO-SIMD128:         .functype or_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.or $push0=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop0
; NO-SIMD128-NEXT:    i32.or $push1=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-NEXT:    i32.or $push2=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.or $push3=, $4, $8
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: or_v4i32:
; NO-SIMD128-FAST:         .functype or_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.or $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.or $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.or $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.or $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = or <4 x i32> %x, %y
  ret <4 x i32> %a
}

define <4 x i32> @xor_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: xor_v4i32:
; SIMD128:         .functype xor_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: xor_v4i32:
; SIMD128-FAST:         .functype xor_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: xor_v4i32:
; NO-SIMD128:         .functype xor_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.xor $push0=, $3, $7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop0
; NO-SIMD128-NEXT:    i32.xor $push1=, $2, $6
; NO-SIMD128-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-NEXT:    i32.xor $push2=, $1, $5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    i32.xor $push3=, $4, $8
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: xor_v4i32:
; NO-SIMD128-FAST:         .functype xor_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <4 x i32> %x, %y
  ret <4 x i32> %a
}

define <4 x i32> @not_v4i32(<4 x i32> %x) {
; SIMD128-LABEL: not_v4i32:
; SIMD128:         .functype not_v4i32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.not $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: not_v4i32:
; SIMD128-FAST:         .functype not_v4i32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: not_v4i32:
; NO-SIMD128:         .functype not_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $3, $pop0
; NO-SIMD128-NEXT:    i32.store 8($0), $pop1
; NO-SIMD128-NEXT:    i32.const $push9=, -1
; NO-SIMD128-NEXT:    i32.xor $push2=, $2, $pop9
; NO-SIMD128-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push8=, -1
; NO-SIMD128-NEXT:    i32.xor $push3=, $1, $pop8
; NO-SIMD128-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push5=, 12
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.const $push7=, -1
; NO-SIMD128-NEXT:    i32.xor $push4=, $4, $pop7
; NO-SIMD128-NEXT:    i32.store 0($pop6), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: not_v4i32:
; NO-SIMD128-FAST:         .functype not_v4i32 (i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $2, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $3, $pop8
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $4, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop5), $pop6
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  ret <4 x i32> %a
}

define <4 x i32> @andnot_v4i32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: andnot_v4i32:
; SIMD128:         .functype andnot_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.andnot $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: andnot_v4i32:
; SIMD128-FAST:         .functype andnot_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $1
; SIMD128-FAST-NEXT:    v128.and $push1=, $0, $pop0
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: andnot_v4i32:
; NO-SIMD128:         .functype andnot_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $7, $pop0
; NO-SIMD128-NEXT:    i32.and $push2=, $3, $pop1
; NO-SIMD128-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push13=, -1
; NO-SIMD128-NEXT:    i32.xor $push3=, $6, $pop13
; NO-SIMD128-NEXT:    i32.and $push4=, $2, $pop3
; NO-SIMD128-NEXT:    i32.store 4($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push12=, -1
; NO-SIMD128-NEXT:    i32.xor $push5=, $5, $pop12
; NO-SIMD128-NEXT:    i32.and $push6=, $1, $pop5
; NO-SIMD128-NEXT:    i32.store 0($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push9=, 12
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    i32.const $push11=, -1
; NO-SIMD128-NEXT:    i32.xor $push7=, $8, $pop11
; NO-SIMD128-NEXT:    i32.and $push8=, $4, $pop7
; NO-SIMD128-NEXT:    i32.store 0($pop10), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: andnot_v4i32:
; NO-SIMD128-FAST:         .functype andnot_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $5, $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $6, $pop13
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push12=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $7, $pop12
; NO-SIMD128-FAST-NEXT:    i32.and $push6=, $3, $pop5
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push7=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push8=, $0, $pop7
; NO-SIMD128-FAST-NEXT:    i32.const $push11=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $8, $pop11
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $4, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop8), $pop10
; NO-SIMD128-FAST-NEXT:    return
 %inv_y = xor <4 x i32> %y, <i32 -1, i32 -1, i32 -1, i32 -1>
 %a = and <4 x i32> %x, %inv_y
 ret <4 x i32> %a
}

define <4 x i32> @bitselect_v4i32(<4 x i32> %c, <4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: bitselect_v4i32:
; SIMD128:         .functype bitselect_v4i32 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_v4i32:
; SIMD128-FAST:         .functype bitselect_v4i32 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $pop2, $2
; SIMD128-FAST-NEXT:    v128.and $push0=, $0, $1
; SIMD128-FAST-NEXT:    v128.or $push1=, $pop3, $pop0
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: bitselect_v4i32:
; NO-SIMD128:         .functype bitselect_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push5=, 12
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.const $push1=, -1
; NO-SIMD128-NEXT:    i32.xor $push2=, $4, $pop1
; NO-SIMD128-NEXT:    i32.and $push3=, $pop2, $12
; NO-SIMD128-NEXT:    i32.and $push0=, $4, $8
; NO-SIMD128-NEXT:    i32.or $push4=, $pop3, $pop0
; NO-SIMD128-NEXT:    i32.store 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.const $push21=, -1
; NO-SIMD128-NEXT:    i32.xor $push8=, $3, $pop21
; NO-SIMD128-NEXT:    i32.and $push9=, $pop8, $11
; NO-SIMD128-NEXT:    i32.and $push7=, $3, $7
; NO-SIMD128-NEXT:    i32.or $push10=, $pop9, $pop7
; NO-SIMD128-NEXT:    i32.store 8($0), $pop10
; NO-SIMD128-NEXT:    i32.const $push20=, -1
; NO-SIMD128-NEXT:    i32.xor $push12=, $2, $pop20
; NO-SIMD128-NEXT:    i32.and $push13=, $pop12, $10
; NO-SIMD128-NEXT:    i32.and $push11=, $2, $6
; NO-SIMD128-NEXT:    i32.or $push14=, $pop13, $pop11
; NO-SIMD128-NEXT:    i32.store 4($0), $pop14
; NO-SIMD128-NEXT:    i32.const $push19=, -1
; NO-SIMD128-NEXT:    i32.xor $push16=, $1, $pop19
; NO-SIMD128-NEXT:    i32.and $push17=, $pop16, $9
; NO-SIMD128-NEXT:    i32.and $push15=, $1, $5
; NO-SIMD128-NEXT:    i32.or $push18=, $pop17, $pop15
; NO-SIMD128-NEXT:    i32.store 0($0), $pop18
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_v4i32:
; NO-SIMD128-FAST:         .functype bitselect_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push1=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $pop2, $9
; NO-SIMD128-FAST-NEXT:    i32.and $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    i32.or $push4=, $pop3, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $2, $pop21
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $10
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $2, $6
; NO-SIMD128-FAST-NEXT:    i32.or $push8=, $pop7, $pop5
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push10=, $3, $pop20
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $pop10, $11
; NO-SIMD128-FAST-NEXT:    i32.and $push9=, $3, $7
; NO-SIMD128-FAST-NEXT:    i32.or $push12=, $pop11, $pop9
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $4, $pop19
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $pop14, $12
; NO-SIMD128-FAST-NEXT:    i32.and $push13=, $4, $8
; NO-SIMD128-FAST-NEXT:    i32.or $push16=, $pop15, $pop13
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop18), $pop16
; NO-SIMD128-FAST-NEXT:    return
  %masked_v1 = and <4 x i32> %c, %v1
  %inv_mask = xor <4 x i32> <i32 -1, i32 -1, i32 -1, i32 -1>, %c
  %masked_v2 = and <4 x i32> %inv_mask, %v2
  %a = or <4 x i32> %masked_v2, %masked_v1
  ret <4 x i32> %a
}

define <4 x i32> @bitselect_xor_v4i32(<4 x i32> %c, <4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: bitselect_xor_v4i32:
; SIMD128:         .functype bitselect_xor_v4i32 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_v4i32:
; SIMD128-FAST:         .functype bitselect_xor_v4i32 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push2=, $1, $2
; SIMD128-FAST-NEXT:    v128.and $push1=, $pop2, $0
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop1, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_v4i32:
; NO-SIMD128:         .functype bitselect_xor_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push3=, 12
; NO-SIMD128-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-NEXT:    i32.xor $push0=, $8, $12
; NO-SIMD128-NEXT:    i32.and $push1=, $pop0, $4
; NO-SIMD128-NEXT:    i32.xor $push2=, $pop1, $12
; NO-SIMD128-NEXT:    i32.store 0($pop4), $pop2
; NO-SIMD128-NEXT:    i32.xor $push5=, $7, $11
; NO-SIMD128-NEXT:    i32.and $push6=, $pop5, $3
; NO-SIMD128-NEXT:    i32.xor $push7=, $pop6, $11
; NO-SIMD128-NEXT:    i32.store 8($0), $pop7
; NO-SIMD128-NEXT:    i32.xor $push8=, $6, $10
; NO-SIMD128-NEXT:    i32.and $push9=, $pop8, $2
; NO-SIMD128-NEXT:    i32.xor $push10=, $pop9, $10
; NO-SIMD128-NEXT:    i32.store 4($0), $pop10
; NO-SIMD128-NEXT:    i32.xor $push11=, $5, $9
; NO-SIMD128-NEXT:    i32.and $push12=, $pop11, $1
; NO-SIMD128-NEXT:    i32.xor $push13=, $pop12, $9
; NO-SIMD128-NEXT:    i32.store 0($0), $pop13
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_v4i32:
; NO-SIMD128-FAST:         .functype bitselect_xor_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push0=, $5, $9
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $pop1, $9
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.xor $push3=, $6, $10
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $pop4, $10
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $7, $11
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $3
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $11
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    i32.xor $push11=, $8, $12
; NO-SIMD128-FAST-NEXT:    i32.and $push12=, $pop11, $4
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $pop12, $12
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop10), $pop13
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <4 x i32> %v1, %v2
 %and = and <4 x i32> %xor1, %c
 %a = xor <4 x i32> %and, %v2
 ret <4 x i32> %a
}

define <4 x i32> @bitselect_xor_reversed_v4i32(<4 x i32> %c, <4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: bitselect_xor_reversed_v4i32:
; SIMD128:         .functype bitselect_xor_reversed_v4i32 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $2, $1, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_reversed_v4i32:
; SIMD128-FAST:         .functype bitselect_xor_reversed_v4i32 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push1=, $1, $2
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $pop1, $pop2
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop3, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_reversed_v4i32:
; NO-SIMD128:         .functype bitselect_xor_reversed_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push5=, 12
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    i32.xor $push2=, $8, $12
; NO-SIMD128-NEXT:    i32.const $push0=, -1
; NO-SIMD128-NEXT:    i32.xor $push1=, $4, $pop0
; NO-SIMD128-NEXT:    i32.and $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.xor $push4=, $pop3, $12
; NO-SIMD128-NEXT:    i32.store 0($pop6), $pop4
; NO-SIMD128-NEXT:    i32.xor $push8=, $7, $11
; NO-SIMD128-NEXT:    i32.const $push21=, -1
; NO-SIMD128-NEXT:    i32.xor $push7=, $3, $pop21
; NO-SIMD128-NEXT:    i32.and $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.xor $push10=, $pop9, $11
; NO-SIMD128-NEXT:    i32.store 8($0), $pop10
; NO-SIMD128-NEXT:    i32.xor $push12=, $6, $10
; NO-SIMD128-NEXT:    i32.const $push20=, -1
; NO-SIMD128-NEXT:    i32.xor $push11=, $2, $pop20
; NO-SIMD128-NEXT:    i32.and $push13=, $pop12, $pop11
; NO-SIMD128-NEXT:    i32.xor $push14=, $pop13, $10
; NO-SIMD128-NEXT:    i32.store 4($0), $pop14
; NO-SIMD128-NEXT:    i32.xor $push16=, $5, $9
; NO-SIMD128-NEXT:    i32.const $push19=, -1
; NO-SIMD128-NEXT:    i32.xor $push15=, $1, $pop19
; NO-SIMD128-NEXT:    i32.and $push17=, $pop16, $pop15
; NO-SIMD128-NEXT:    i32.xor $push18=, $pop17, $9
; NO-SIMD128-NEXT:    i32.store 0($0), $pop18
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_reversed_v4i32:
; NO-SIMD128-FAST:         .functype bitselect_xor_reversed_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.xor $push2=, $5, $9
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.and $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.xor $push4=, $pop3, $9
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.xor $push6=, $6, $10
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push5=, $2, $pop21
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i32.xor $push8=, $pop7, $10
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.xor $push10=, $7, $11
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push9=, $3, $pop20
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $pop10, $pop9
; NO-SIMD128-FAST-NEXT:    i32.xor $push12=, $pop11, $11
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop12
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push18=, $0, $pop17
; NO-SIMD128-FAST-NEXT:    i32.xor $push14=, $8, $12
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, -1
; NO-SIMD128-FAST-NEXT:    i32.xor $push13=, $4, $pop19
; NO-SIMD128-FAST-NEXT:    i32.and $push15=, $pop14, $pop13
; NO-SIMD128-FAST-NEXT:    i32.xor $push16=, $pop15, $12
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop18), $pop16
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <4 x i32> %v1, %v2
 %notc = xor <4 x i32> %c, <i32 -1, i32 -1, i32 -1, i32 -1>
 %and = and <4 x i32> %xor1, %notc
 %a = xor <4 x i32> %and, %v2
 ret <4 x i32> %a
}

define <4 x i32> @extmul_low_s_v4i32(<8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: extmul_low_s_v4i32:
; SIMD128:         .functype extmul_low_s_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extmul_low_i16x8_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_low_s_v4i32:
; SIMD128-FAST:         .functype extmul_low_s_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extend_low_i16x8_s $push0=, $0
; SIMD128-FAST-NEXT:    i32x4.extend_low_i16x8_s $push1=, $1
; SIMD128-FAST-NEXT:    i32x4.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_low_s_v4i32:
; NO-SIMD128:         .functype extmul_low_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend16_s $push1=, $3
; NO-SIMD128-NEXT:    i32.extend16_s $push0=, $11
; NO-SIMD128-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-NEXT:    i32.extend16_s $push4=, $2
; NO-SIMD128-NEXT:    i32.extend16_s $push3=, $10
; NO-SIMD128-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i32.store 4($0), $pop5
; NO-SIMD128-NEXT:    i32.extend16_s $push7=, $1
; NO-SIMD128-NEXT:    i32.extend16_s $push6=, $9
; NO-SIMD128-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.store 0($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push12=, 12
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.extend16_s $push10=, $4
; NO-SIMD128-NEXT:    i32.extend16_s $push9=, $12
; NO-SIMD128-NEXT:    i32.mul $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.store 0($pop13), $pop11
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_low_s_v4i32:
; NO-SIMD128-FAST:         .functype extmul_low_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push0=, $9
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push4=, $2
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push3=, $10
; NO-SIMD128-FAST-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push7=, $3
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push6=, $11
; NO-SIMD128-FAST-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push12=, $4
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push11=, $12
; NO-SIMD128-FAST-NEXT:    i32.mul $push13=, $pop12, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop10), $pop13
; NO-SIMD128-FAST-NEXT:    return
  %low1 = shufflevector <8 x i16> %v1, <8 x i16> undef,
           <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %low2 = shufflevector <8 x i16> %v2, <8 x i16> undef,
           <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extended1 = sext <4 x i16> %low1 to <4 x i32>
  %extended2 = sext <4 x i16> %low2 to <4 x i32>
  %a = mul <4 x i32> %extended1, %extended2
  ret <4 x i32> %a
}

define <4 x i32> @extmul_high_s_v4i32(<8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: extmul_high_s_v4i32:
; SIMD128:         .functype extmul_high_s_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extmul_high_i16x8_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_high_s_v4i32:
; SIMD128-FAST:         .functype extmul_high_s_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extend_high_i16x8_s $push0=, $0
; SIMD128-FAST-NEXT:    i32x4.extend_high_i16x8_s $push1=, $1
; SIMD128-FAST-NEXT:    i32x4.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_high_s_v4i32:
; NO-SIMD128:         .functype extmul_high_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.extend16_s $push1=, $7
; NO-SIMD128-NEXT:    i32.extend16_s $push0=, $15
; NO-SIMD128-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.store 8($0), $pop2
; NO-SIMD128-NEXT:    i32.extend16_s $push4=, $6
; NO-SIMD128-NEXT:    i32.extend16_s $push3=, $14
; NO-SIMD128-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i32.store 4($0), $pop5
; NO-SIMD128-NEXT:    i32.extend16_s $push7=, $5
; NO-SIMD128-NEXT:    i32.extend16_s $push6=, $13
; NO-SIMD128-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.store 0($0), $pop8
; NO-SIMD128-NEXT:    i32.const $push12=, 12
; NO-SIMD128-NEXT:    i32.add $push13=, $0, $pop12
; NO-SIMD128-NEXT:    i32.extend16_s $push10=, $8
; NO-SIMD128-NEXT:    i32.extend16_s $push9=, $16
; NO-SIMD128-NEXT:    i32.mul $push11=, $pop10, $pop9
; NO-SIMD128-NEXT:    i32.store 0($pop13), $pop11
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_high_s_v4i32:
; NO-SIMD128-FAST:         .functype extmul_high_s_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push1=, $5
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push0=, $13
; NO-SIMD128-FAST-NEXT:    i32.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push4=, $6
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push3=, $14
; NO-SIMD128-FAST-NEXT:    i32.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push7=, $7
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push6=, $15
; NO-SIMD128-FAST-NEXT:    i32.mul $push8=, $pop7, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push12=, $8
; NO-SIMD128-FAST-NEXT:    i32.extend16_s $push11=, $16
; NO-SIMD128-FAST-NEXT:    i32.mul $push13=, $pop12, $pop11
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop10), $pop13
; NO-SIMD128-FAST-NEXT:    return
  %high1 = shufflevector <8 x i16> %v1, <8 x i16> undef,
           <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %high2 = shufflevector <8 x i16> %v2, <8 x i16> undef,
           <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %extended1 = sext <4 x i16> %high1 to <4 x i32>
  %extended2 = sext <4 x i16> %high2 to <4 x i32>
  %a = mul <4 x i32> %extended1, %extended2
  ret <4 x i32> %a
}

define <4 x i32> @extmul_low_u_v4i32(<8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: extmul_low_u_v4i32:
; SIMD128:         .functype extmul_low_u_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extmul_low_i16x8_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_low_u_v4i32:
; SIMD128-FAST:         .functype extmul_low_u_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extend_low_i16x8_u $push0=, $0
; SIMD128-FAST-NEXT:    i32x4.extend_low_i16x8_u $push1=, $1
; SIMD128-FAST-NEXT:    i32x4.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_low_u_v4i32:
; NO-SIMD128:         .functype extmul_low_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push2=, $3, $pop0
; NO-SIMD128-NEXT:    i32.const $push21=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $11, $pop21
; NO-SIMD128-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store 8($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push20=, 65535
; NO-SIMD128-NEXT:    i32.and $push5=, $2, $pop20
; NO-SIMD128-NEXT:    i32.const $push19=, 65535
; NO-SIMD128-NEXT:    i32.and $push4=, $10, $pop19
; NO-SIMD128-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store 4($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push18=, 65535
; NO-SIMD128-NEXT:    i32.and $push8=, $1, $pop18
; NO-SIMD128-NEXT:    i32.const $push17=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $9, $pop17
; NO-SIMD128-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store 0($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push13=, 12
; NO-SIMD128-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-NEXT:    i32.const $push16=, 65535
; NO-SIMD128-NEXT:    i32.and $push11=, $4, $pop16
; NO-SIMD128-NEXT:    i32.const $push15=, 65535
; NO-SIMD128-NEXT:    i32.and $push10=, $12, $pop15
; NO-SIMD128-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store 0($pop14), $pop12
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_low_u_v4i32:
; NO-SIMD128-FAST:         .functype extmul_low_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $9, $pop21
; NO-SIMD128-FAST-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $2, $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $10, $pop19
; NO-SIMD128-FAST-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $3, $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $11, $pop17
; NO-SIMD128-FAST-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push16=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $4, $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push15=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $12, $pop15
; NO-SIMD128-FAST-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop14), $pop12
; NO-SIMD128-FAST-NEXT:    return
  %low1 = shufflevector <8 x i16> %v1, <8 x i16> undef,
           <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %low2 = shufflevector <8 x i16> %v2, <8 x i16> undef,
           <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %extended1 = zext <4 x i16> %low1 to <4 x i32>
  %extended2 = zext <4 x i16> %low2 to <4 x i32>
  %a = mul <4 x i32> %extended1, %extended2
  ret <4 x i32> %a
}

define <4 x i32> @extmul_high_u_v4i32(<8 x i16> %v1, <8 x i16> %v2) {
; SIMD128-LABEL: extmul_high_u_v4i32:
; SIMD128:         .functype extmul_high_u_v4i32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32x4.extmul_high_i16x8_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_high_u_v4i32:
; SIMD128-FAST:         .functype extmul_high_u_v4i32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32x4.extend_high_i16x8_u $push0=, $0
; SIMD128-FAST-NEXT:    i32x4.extend_high_i16x8_u $push1=, $1
; SIMD128-FAST-NEXT:    i32x4.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_high_u_v4i32:
; NO-SIMD128:         .functype extmul_high_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-NEXT:    i32.and $push2=, $7, $pop0
; NO-SIMD128-NEXT:    i32.const $push21=, 65535
; NO-SIMD128-NEXT:    i32.and $push1=, $15, $pop21
; NO-SIMD128-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i32.store 8($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push20=, 65535
; NO-SIMD128-NEXT:    i32.and $push5=, $6, $pop20
; NO-SIMD128-NEXT:    i32.const $push19=, 65535
; NO-SIMD128-NEXT:    i32.and $push4=, $14, $pop19
; NO-SIMD128-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i32.store 4($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push18=, 65535
; NO-SIMD128-NEXT:    i32.and $push8=, $5, $pop18
; NO-SIMD128-NEXT:    i32.const $push17=, 65535
; NO-SIMD128-NEXT:    i32.and $push7=, $13, $pop17
; NO-SIMD128-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-NEXT:    i32.store 0($0), $pop9
; NO-SIMD128-NEXT:    i32.const $push13=, 12
; NO-SIMD128-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-NEXT:    i32.const $push16=, 65535
; NO-SIMD128-NEXT:    i32.and $push11=, $8, $pop16
; NO-SIMD128-NEXT:    i32.const $push15=, 65535
; NO-SIMD128-NEXT:    i32.and $push10=, $16, $pop15
; NO-SIMD128-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.store 0($pop14), $pop12
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_high_u_v4i32:
; NO-SIMD128-FAST:         .functype extmul_high_u_v4i32 (i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i32.const $push0=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push2=, $5, $pop0
; NO-SIMD128-FAST-NEXT:    i32.const $push21=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push1=, $13, $pop21
; NO-SIMD128-FAST-NEXT:    i32.mul $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push20=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push5=, $6, $pop20
; NO-SIMD128-FAST-NEXT:    i32.const $push19=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push4=, $14, $pop19
; NO-SIMD128-FAST-NEXT:    i32.mul $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push18=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push8=, $7, $pop18
; NO-SIMD128-FAST-NEXT:    i32.const $push17=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push7=, $15, $pop17
; NO-SIMD128-FAST-NEXT:    i32.mul $push9=, $pop8, $pop7
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop9
; NO-SIMD128-FAST-NEXT:    i32.const $push13=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push14=, $0, $pop13
; NO-SIMD128-FAST-NEXT:    i32.const $push16=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push11=, $8, $pop16
; NO-SIMD128-FAST-NEXT:    i32.const $push15=, 65535
; NO-SIMD128-FAST-NEXT:    i32.and $push10=, $16, $pop15
; NO-SIMD128-FAST-NEXT:    i32.mul $push12=, $pop11, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop14), $pop12
; NO-SIMD128-FAST-NEXT:    return
  %high1 = shufflevector <8 x i16> %v1, <8 x i16> undef,
           <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %high2 = shufflevector <8 x i16> %v2, <8 x i16> undef,
           <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %extended1 = zext <4 x i16> %high1 to <4 x i32>
  %extended2 = zext <4 x i16> %high2 to <4 x i32>
  %a = mul <4 x i32> %extended1, %extended2
  ret <4 x i32> %a
}

; ==============================================================================
; 2 x i64
; ==============================================================================
define <2 x i64> @add_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: add_v2i64:
; SIMD128:         .functype add_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.add $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: add_v2i64:
; SIMD128-FAST:         .functype add_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.add $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: add_v2i64:
; NO-SIMD128:         .functype add_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.add $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.add $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: add_v2i64:
; NO-SIMD128-FAST:         .functype add_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.add $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.add $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = add <2 x i64> %x, %y
  ret <2 x i64> %a
}

define <2 x i64> @sub_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: sub_v2i64:
; SIMD128:         .functype sub_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.sub $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sub_v2i64:
; SIMD128-FAST:         .functype sub_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.sub $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sub_v2i64:
; NO-SIMD128:         .functype sub_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.sub $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.sub $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sub_v2i64:
; NO-SIMD128-FAST:         .functype sub_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.sub $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.sub $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <2 x i64> %x, %y
  ret <2 x i64> %a
}

define <2 x i64> @mul_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: mul_v2i64:
; SIMD128:         .functype mul_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.mul $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: mul_v2i64:
; SIMD128-FAST:         .functype mul_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.mul $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: mul_v2i64:
; NO-SIMD128:         .functype mul_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.mul $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.mul $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: mul_v2i64:
; NO-SIMD128-FAST:         .functype mul_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.mul $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.mul $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = mul <2 x i64> %x, %y
  ret <2 x i64> %a
}

define <2 x i64> @abs_v2i64(<2 x i64> %x) {
; SIMD128-LABEL: abs_v2i64:
; SIMD128:         .functype abs_v2i64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.abs $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: abs_v2i64:
; SIMD128-FAST:         .functype abs_v2i64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.abs $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: abs_v2i64:
; NO-SIMD128:         .functype abs_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 63
; NO-SIMD128-NEXT:    i64.shr_s $push9=, $2, $pop0
; NO-SIMD128-NEXT:    local.tee $push8=, $3=, $pop9
; NO-SIMD128-NEXT:    i64.xor $push1=, $2, $pop8
; NO-SIMD128-NEXT:    i64.sub $push2=, $pop1, $3
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.const $push7=, 63
; NO-SIMD128-NEXT:    i64.shr_s $push6=, $1, $pop7
; NO-SIMD128-NEXT:    local.tee $push5=, $2=, $pop6
; NO-SIMD128-NEXT:    i64.xor $push3=, $1, $pop5
; NO-SIMD128-NEXT:    i64.sub $push4=, $pop3, $2
; NO-SIMD128-NEXT:    i64.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: abs_v2i64:
; NO-SIMD128-FAST:         .functype abs_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 63
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push9=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    local.tee $push8=, $3=, $pop9
; NO-SIMD128-FAST-NEXT:    i64.xor $push1=, $1, $pop8
; NO-SIMD128-FAST-NEXT:    i64.sub $push2=, $pop1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.const $push7=, 63
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push6=, $2, $pop7
; NO-SIMD128-FAST-NEXT:    local.tee $push5=, $1=, $pop6
; NO-SIMD128-FAST-NEXT:    i64.xor $push3=, $2, $pop5
; NO-SIMD128-FAST-NEXT:    i64.sub $push4=, $pop3, $1
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <2 x i64> zeroinitializer, %x
  %b = icmp slt <2 x i64> %x, zeroinitializer
  %c = select <2 x i1> %b, <2 x i64> %a, <2 x i64> %x
  ret <2 x i64> %c
}

define <2 x i64> @neg_v2i64(<2 x i64> %x) {
; SIMD128-LABEL: neg_v2i64:
; SIMD128:         .functype neg_v2i64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.neg $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: neg_v2i64:
; SIMD128-FAST:         .functype neg_v2i64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.neg $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: neg_v2i64:
; NO-SIMD128:         .functype neg_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 0
; NO-SIMD128-NEXT:    i64.sub $push1=, $pop0, $2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-NEXT:    i64.const $push3=, 0
; NO-SIMD128-NEXT:    i64.sub $push2=, $pop3, $1
; NO-SIMD128-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: neg_v2i64:
; NO-SIMD128-FAST:         .functype neg_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 0
; NO-SIMD128-FAST-NEXT:    i64.sub $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i64.const $push3=, 0
; NO-SIMD128-FAST-NEXT:    i64.sub $push2=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    return
  %a = sub <2 x i64> <i64 0, i64 0>, %x
  ret <2 x i64> %a
}

define <2 x i64> @shl_v2i64(<2 x i64> %v, i32 %x) {
; SIMD128-LABEL: shl_v2i64:
; SIMD128:         .functype shl_v2i64 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.shl $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shl_v2i64:
; SIMD128-FAST:         .functype shl_v2i64 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.shl $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_v2i64:
; NO-SIMD128:         .functype shl_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_u $push3=, $3
; NO-SIMD128-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-NEXT:    i64.shl $push0=, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shl $push1=, $1, $4
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_v2i64:
; NO-SIMD128-FAST:         .functype shl_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push3=, $3
; NO-SIMD128-FAST-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-FAST-NEXT:    i64.shl $push0=, $2, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shl $push1=, $1, $4
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %x2 = zext i32 %x to i64
  %t = insertelement <2 x i64> undef, i64 %x2, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = shl <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shl_sext_v2i64(<2 x i64> %v, i32 %x) {
; SIMD128-LABEL: shl_sext_v2i64:
; SIMD128:         .functype shl_sext_v2i64 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.shl $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shl_sext_v2i64:
; SIMD128-FAST:         .functype shl_sext_v2i64 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.shl $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_sext_v2i64:
; NO-SIMD128:         .functype shl_sext_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_s $push3=, $3
; NO-SIMD128-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-NEXT:    i64.shl $push0=, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shl $push1=, $1, $4
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_sext_v2i64:
; NO-SIMD128-FAST:         .functype shl_sext_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push3=, $3
; NO-SIMD128-FAST-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-FAST-NEXT:    i64.shl $push0=, $2, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shl $push1=, $1, $4
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %x2 = sext i32 %x to i64
  %t = insertelement <2 x i64> undef, i64 %x2, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = shl <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shl_noext_v2i64(<2 x i64> %v, i64 %x) {
; SIMD128-LABEL: shl_noext_v2i64:
; SIMD128:         .functype shl_noext_v2i64 (v128, i64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.wrap_i64 $push0=, $1
; SIMD128-NEXT:    i64x2.shl $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shl_noext_v2i64:
; SIMD128-FAST:         .functype shl_noext_v2i64 (v128, i64) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.wrap_i64 $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.shl $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_noext_v2i64:
; NO-SIMD128:         .functype shl_noext_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.shl $push0=, $2, $3
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shl $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_noext_v2i64:
; NO-SIMD128-FAST:         .functype shl_noext_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.shl $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shl $push1=, $2, $3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <2 x i64> undef, i64 %x, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = shl <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shl_const_v2i64(<2 x i64> %v) {
; SIMD128-LABEL: shl_const_v2i64:
; SIMD128:         .functype shl_const_v2i64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.const $push0=, 5
; SIMD128-NEXT:    i64x2.shl $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shl_const_v2i64:
; SIMD128-FAST:         .functype shl_const_v2i64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.const $push1=, 5
; SIMD128-FAST-NEXT:    i64x2.shl $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_const_v2i64:
; NO-SIMD128:         .functype shl_const_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 5
; NO-SIMD128-NEXT:    i64.shl $push1=, $2, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-NEXT:    i64.const $push3=, 5
; NO-SIMD128-NEXT:    i64.shl $push2=, $1, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_const_v2i64:
; NO-SIMD128-FAST:         .functype shl_const_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 5
; NO-SIMD128-FAST-NEXT:    i64.shl $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i64.const $push3=, 5
; NO-SIMD128-FAST-NEXT:    i64.shl $push2=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <2 x i64> %v, <i64 5, i64 5>
  ret <2 x i64> %a
}

define <2 x i64> @shl_vec_v2i64(<2 x i64> %v, <2 x i64> %x) {
; SIMD128-LABEL: shl_vec_v2i64:
; SIMD128:         .functype shl_vec_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extract_lane $push4=, $0, 0
; SIMD128-NEXT:    i64x2.extract_lane $push3=, $1, 0
; SIMD128-NEXT:    i64.shl $push5=, $pop4, $pop3
; SIMD128-NEXT:    i64x2.splat $push6=, $pop5
; SIMD128-NEXT:    i64x2.extract_lane $push1=, $0, 1
; SIMD128-NEXT:    i64x2.extract_lane $push0=, $1, 1
; SIMD128-NEXT:    i64.shl $push2=, $pop1, $pop0
; SIMD128-NEXT:    i64x2.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    return $pop7
;
; SIMD128-FAST-LABEL: shl_vec_v2i64:
; SIMD128-FAST:         .functype shl_vec_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push5=, $0, 0
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push4=, $1, 0
; SIMD128-FAST-NEXT:    i64.shl $push6=, $pop5, $pop4
; SIMD128-FAST-NEXT:    i64x2.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push2=, $0, 1
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push1=, $1, 1
; SIMD128-FAST-NEXT:    i64.shl $push3=, $pop2, $pop1
; SIMD128-FAST-NEXT:    i64x2.replace_lane $push0=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shl_vec_v2i64:
; NO-SIMD128:         .functype shl_vec_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.shl $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shl $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shl_vec_v2i64:
; NO-SIMD128-FAST:         .functype shl_vec_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.shl $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shl $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = shl <2 x i64> %v, %x
  ret <2 x i64> %a
}

define <2 x i64> @shr_s_v2i64(<2 x i64> %v, i32 %x) {
; SIMD128-LABEL: shr_s_v2i64:
; SIMD128:         .functype shr_s_v2i64 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.shr_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_s_v2i64:
; SIMD128-FAST:         .functype shr_s_v2i64 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.shr_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_v2i64:
; NO-SIMD128:         .functype shr_s_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_u $push3=, $3
; NO-SIMD128-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-NEXT:    i64.shr_s $push0=, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_s $push1=, $1, $4
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_v2i64:
; NO-SIMD128-FAST:         .functype shr_s_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push3=, $3
; NO-SIMD128-FAST-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push0=, $2, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push1=, $1, $4
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %x2 = zext i32 %x to i64
  %t = insertelement <2 x i64> undef, i64 %x2, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = ashr <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shr_s_sext_v2i64(<2 x i64> %v, i32 %x) {
; SIMD128-LABEL: shr_s_sext_v2i64:
; SIMD128:         .functype shr_s_sext_v2i64 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.shr_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_s_sext_v2i64:
; SIMD128-FAST:         .functype shr_s_sext_v2i64 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.shr_s $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_sext_v2i64:
; NO-SIMD128:         .functype shr_s_sext_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_s $push3=, $3
; NO-SIMD128-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-NEXT:    i64.shr_s $push0=, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_s $push1=, $1, $4
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_sext_v2i64:
; NO-SIMD128-FAST:         .functype shr_s_sext_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push3=, $3
; NO-SIMD128-FAST-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push0=, $2, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push1=, $1, $4
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %x2 = sext i32 %x to i64
  %t = insertelement <2 x i64> undef, i64 %x2, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = ashr <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shr_s_noext_v2i64(<2 x i64> %v, i64 %x) {
; SIMD128-LABEL: shr_s_noext_v2i64:
; SIMD128:         .functype shr_s_noext_v2i64 (v128, i64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.wrap_i64 $push0=, $1
; SIMD128-NEXT:    i64x2.shr_s $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shr_s_noext_v2i64:
; SIMD128-FAST:         .functype shr_s_noext_v2i64 (v128, i64) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.wrap_i64 $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.shr_s $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_noext_v2i64:
; NO-SIMD128:         .functype shr_s_noext_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.shr_s $push0=, $2, $3
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_s $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_noext_v2i64:
; NO-SIMD128-FAST:         .functype shr_s_noext_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push1=, $2, $3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <2 x i64> undef, i64 %x, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = ashr <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shr_s_const_v2i64(<2 x i64> %v) {
; SIMD128-LABEL: shr_s_const_v2i64:
; SIMD128:         .functype shr_s_const_v2i64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.const $push0=, 5
; SIMD128-NEXT:    i64x2.shr_s $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shr_s_const_v2i64:
; SIMD128-FAST:         .functype shr_s_const_v2i64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.const $push1=, 5
; SIMD128-FAST-NEXT:    i64x2.shr_s $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_const_v2i64:
; NO-SIMD128:         .functype shr_s_const_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 5
; NO-SIMD128-NEXT:    i64.shr_s $push1=, $2, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-NEXT:    i64.const $push3=, 5
; NO-SIMD128-NEXT:    i64.shr_s $push2=, $1, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_const_v2i64:
; NO-SIMD128-FAST:         .functype shr_s_const_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 5
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i64.const $push3=, 5
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push2=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    return
  %a = ashr <2 x i64> %v, <i64 5, i64 5>
  ret <2 x i64> %a
}

define <2 x i64> @shr_s_vec_v2i64(<2 x i64> %v, <2 x i64> %x) {
; SIMD128-LABEL: shr_s_vec_v2i64:
; SIMD128:         .functype shr_s_vec_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extract_lane $push4=, $0, 0
; SIMD128-NEXT:    i64x2.extract_lane $push3=, $1, 0
; SIMD128-NEXT:    i64.shr_s $push5=, $pop4, $pop3
; SIMD128-NEXT:    i64x2.splat $push6=, $pop5
; SIMD128-NEXT:    i64x2.extract_lane $push1=, $0, 1
; SIMD128-NEXT:    i64x2.extract_lane $push0=, $1, 1
; SIMD128-NEXT:    i64.shr_s $push2=, $pop1, $pop0
; SIMD128-NEXT:    i64x2.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    return $pop7
;
; SIMD128-FAST-LABEL: shr_s_vec_v2i64:
; SIMD128-FAST:         .functype shr_s_vec_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push5=, $0, 0
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push4=, $1, 0
; SIMD128-FAST-NEXT:    i64.shr_s $push6=, $pop5, $pop4
; SIMD128-FAST-NEXT:    i64x2.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push2=, $0, 1
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push1=, $1, 1
; SIMD128-FAST-NEXT:    i64.shr_s $push3=, $pop2, $pop1
; SIMD128-FAST-NEXT:    i64x2.replace_lane $push0=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_s_vec_v2i64:
; NO-SIMD128:         .functype shr_s_vec_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.shr_s $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_s $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_s_vec_v2i64:
; NO-SIMD128-FAST:         .functype shr_s_vec_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_s $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = ashr <2 x i64> %v, %x
  ret <2 x i64> %a
}

define <2 x i64> @shr_u_v2i64(<2 x i64> %v, i32 %x) {
; SIMD128-LABEL: shr_u_v2i64:
; SIMD128:         .functype shr_u_v2i64 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.shr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_u_v2i64:
; SIMD128-FAST:         .functype shr_u_v2i64 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.shr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_v2i64:
; NO-SIMD128:         .functype shr_u_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_u $push3=, $3
; NO-SIMD128-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-NEXT:    i64.shr_u $push0=, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_u $push1=, $1, $4
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_v2i64:
; NO-SIMD128-FAST:         .functype shr_u_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push3=, $3
; NO-SIMD128-FAST-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push0=, $2, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push1=, $1, $4
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %x2 = zext i32 %x to i64
  %t = insertelement <2 x i64> undef, i64 %x2, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = lshr <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shr_u_sext_v2i64(<2 x i64> %v, i32 %x) {
; SIMD128-LABEL: shr_u_sext_v2i64:
; SIMD128:         .functype shr_u_sext_v2i64 (v128, i32) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.shr_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: shr_u_sext_v2i64:
; SIMD128-FAST:         .functype shr_u_sext_v2i64 (v128, i32) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.shr_u $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_sext_v2i64:
; NO-SIMD128:         .functype shr_u_sext_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_s $push3=, $3
; NO-SIMD128-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-NEXT:    i64.shr_u $push0=, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_u $push1=, $1, $4
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_sext_v2i64:
; NO-SIMD128-FAST:         .functype shr_u_sext_v2i64 (i32, i64, i64, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push3=, $3
; NO-SIMD128-FAST-NEXT:    local.tee $push2=, $4=, $pop3
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push0=, $2, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push1=, $1, $4
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %x2 = sext i32 %x to i64
  %t = insertelement <2 x i64> undef, i64 %x2, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = lshr <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shr_u_noext_v2i64(<2 x i64> %v, i64 %x) {
; SIMD128-LABEL: shr_u_noext_v2i64:
; SIMD128:         .functype shr_u_noext_v2i64 (v128, i64) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.wrap_i64 $push0=, $1
; SIMD128-NEXT:    i64x2.shr_u $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shr_u_noext_v2i64:
; SIMD128-FAST:         .functype shr_u_noext_v2i64 (v128, i64) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.wrap_i64 $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.shr_u $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_noext_v2i64:
; NO-SIMD128:         .functype shr_u_noext_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.shr_u $push0=, $2, $3
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_u $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_noext_v2i64:
; NO-SIMD128-FAST:         .functype shr_u_noext_v2i64 (i32, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push1=, $2, $3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %t = insertelement <2 x i64> undef, i64 %x, i32 0
  %s = shufflevector <2 x i64> %t, <2 x i64> undef, <2 x i32> <i32 0, i32 0>
  %a = lshr <2 x i64> %v, %s
  ret <2 x i64> %a
}

define <2 x i64> @shr_u_const_v2i64(<2 x i64> %v) {
; SIMD128-LABEL: shr_u_const_v2i64:
; SIMD128:         .functype shr_u_const_v2i64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i32.const $push0=, 5
; SIMD128-NEXT:    i64x2.shr_u $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: shr_u_const_v2i64:
; SIMD128-FAST:         .functype shr_u_const_v2i64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i32.const $push1=, 5
; SIMD128-FAST-NEXT:    i64x2.shr_u $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_const_v2i64:
; NO-SIMD128:         .functype shr_u_const_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 5
; NO-SIMD128-NEXT:    i64.shr_u $push1=, $2, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-NEXT:    i64.const $push3=, 5
; NO-SIMD128-NEXT:    i64.shr_u $push2=, $1, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_const_v2i64:
; NO-SIMD128-FAST:         .functype shr_u_const_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 5
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i64.const $push3=, 5
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push2=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    return
  %a = lshr <2 x i64> %v, <i64 5, i64 5>
  ret <2 x i64> %a
}

define <2 x i64> @shr_u_vec_v2i64(<2 x i64> %v, <2 x i64> %x) {
; SIMD128-LABEL: shr_u_vec_v2i64:
; SIMD128:         .functype shr_u_vec_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extract_lane $push4=, $0, 0
; SIMD128-NEXT:    i64x2.extract_lane $push3=, $1, 0
; SIMD128-NEXT:    i64.shr_u $push5=, $pop4, $pop3
; SIMD128-NEXT:    i64x2.splat $push6=, $pop5
; SIMD128-NEXT:    i64x2.extract_lane $push1=, $0, 1
; SIMD128-NEXT:    i64x2.extract_lane $push0=, $1, 1
; SIMD128-NEXT:    i64.shr_u $push2=, $pop1, $pop0
; SIMD128-NEXT:    i64x2.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    return $pop7
;
; SIMD128-FAST-LABEL: shr_u_vec_v2i64:
; SIMD128-FAST:         .functype shr_u_vec_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push5=, $0, 0
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push4=, $1, 0
; SIMD128-FAST-NEXT:    i64.shr_u $push6=, $pop5, $pop4
; SIMD128-FAST-NEXT:    i64x2.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push2=, $0, 1
; SIMD128-FAST-NEXT:    i64x2.extract_lane $push1=, $1, 1
; SIMD128-FAST-NEXT:    i64.shr_u $push3=, $pop2, $pop1
; SIMD128-FAST-NEXT:    i64x2.replace_lane $push0=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: shr_u_vec_v2i64:
; NO-SIMD128:         .functype shr_u_vec_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.shr_u $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.shr_u $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: shr_u_vec_v2i64:
; NO-SIMD128-FAST:         .functype shr_u_vec_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.shr_u $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = lshr <2 x i64> %v, %x
  ret <2 x i64> %a
}

define <2 x i64> @and_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: and_v2i64:
; SIMD128:         .functype and_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.and $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: and_v2i64:
; SIMD128-FAST:         .functype and_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.and $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: and_v2i64:
; NO-SIMD128:         .functype and_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.and $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.and $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: and_v2i64:
; NO-SIMD128-FAST:         .functype and_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.and $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.and $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = and <2 x i64> %x, %y
  ret <2 x i64> %a
}

define <2 x i64> @or_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: or_v2i64:
; SIMD128:         .functype or_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.or $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: or_v2i64:
; SIMD128-FAST:         .functype or_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.or $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: or_v2i64:
; NO-SIMD128:         .functype or_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.or $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.or $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: or_v2i64:
; NO-SIMD128-FAST:         .functype or_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.or $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.or $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = or <2 x i64> %x, %y
  ret <2 x i64> %a
}

define <2 x i64> @xor_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: xor_v2i64:
; SIMD128:         .functype xor_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: xor_v2i64:
; SIMD128-FAST:         .functype xor_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: xor_v2i64:
; NO-SIMD128:         .functype xor_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.xor $push0=, $2, $4
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.xor $push1=, $1, $3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: xor_v2i64:
; NO-SIMD128-FAST:         .functype xor_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.xor $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.xor $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <2 x i64> %x, %y
  ret <2 x i64> %a
}

define <2 x i64> @not_v2i64(<2 x i64> %x) {
; SIMD128-LABEL: not_v2i64:
; SIMD128:         .functype not_v2i64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.not $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: not_v2i64:
; SIMD128-FAST:         .functype not_v2i64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: not_v2i64:
; NO-SIMD128:         .functype not_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, -1
; NO-SIMD128-NEXT:    i64.xor $push1=, $2, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop1
; NO-SIMD128-NEXT:    i64.const $push3=, -1
; NO-SIMD128-NEXT:    i64.xor $push2=, $1, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: not_v2i64:
; NO-SIMD128-FAST:         .functype not_v2i64 (i32, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    i64.const $push3=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push2=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    return
  %a = xor <2 x i64> %x, <i64 -1, i64 -1>
  ret <2 x i64> %a
}

define <2 x i64> @andnot_v2i64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: andnot_v2i64:
; SIMD128:         .functype andnot_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.andnot $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: andnot_v2i64:
; SIMD128-FAST:         .functype andnot_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push0=, $1
; SIMD128-FAST-NEXT:    v128.and $push1=, $0, $pop0
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: andnot_v2i64:
; NO-SIMD128:         .functype andnot_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, -1
; NO-SIMD128-NEXT:    i64.xor $push1=, $4, $pop0
; NO-SIMD128-NEXT:    i64.and $push2=, $2, $pop1
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.const $push5=, -1
; NO-SIMD128-NEXT:    i64.xor $push3=, $3, $pop5
; NO-SIMD128-NEXT:    i64.and $push4=, $1, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: andnot_v2i64:
; NO-SIMD128-FAST:         .functype andnot_v2i64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push1=, $3, $pop0
; NO-SIMD128-FAST-NEXT:    i64.and $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.const $push5=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push3=, $4, $pop5
; NO-SIMD128-FAST-NEXT:    i64.and $push4=, $2, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
 %inv_y = xor <2 x i64> %y, <i64 -1, i64 -1>
 %a = and <2 x i64> %x, %inv_y
 ret <2 x i64> %a
}

define <2 x i64> @bitselect_v2i64(<2 x i64> %c, <2 x i64> %v1, <2 x i64> %v2) {
; SIMD128-LABEL: bitselect_v2i64:
; SIMD128:         .functype bitselect_v2i64 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_v2i64:
; SIMD128-FAST:         .functype bitselect_v2i64 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $2, $pop2
; SIMD128-FAST-NEXT:    v128.and $push0=, $1, $0
; SIMD128-FAST-NEXT:    v128.or $push1=, $pop3, $pop0
; SIMD128-FAST-NEXT:    return $pop1
;
; NO-SIMD128-LABEL: bitselect_v2i64:
; NO-SIMD128:         .functype bitselect_v2i64 (i32, i64, i64, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push1=, -1
; NO-SIMD128-NEXT:    i64.xor $push2=, $2, $pop1
; NO-SIMD128-NEXT:    i64.and $push3=, $6, $pop2
; NO-SIMD128-NEXT:    i64.and $push0=, $4, $2
; NO-SIMD128-NEXT:    i64.or $push4=, $pop3, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop4
; NO-SIMD128-NEXT:    i64.const $push9=, -1
; NO-SIMD128-NEXT:    i64.xor $push6=, $1, $pop9
; NO-SIMD128-NEXT:    i64.and $push7=, $5, $pop6
; NO-SIMD128-NEXT:    i64.and $push5=, $3, $1
; NO-SIMD128-NEXT:    i64.or $push8=, $pop7, $pop5
; NO-SIMD128-NEXT:    i64.store 0($0), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_v2i64:
; NO-SIMD128-FAST:         .functype bitselect_v2i64 (i32, i64, i64, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push1=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push2=, $1, $pop1
; NO-SIMD128-FAST-NEXT:    i64.and $push3=, $5, $pop2
; NO-SIMD128-FAST-NEXT:    i64.and $push0=, $3, $1
; NO-SIMD128-FAST-NEXT:    i64.or $push4=, $pop3, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i64.const $push9=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push6=, $2, $pop9
; NO-SIMD128-FAST-NEXT:    i64.and $push7=, $6, $pop6
; NO-SIMD128-FAST-NEXT:    i64.and $push5=, $4, $2
; NO-SIMD128-FAST-NEXT:    i64.or $push8=, $pop7, $pop5
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %masked_v1 = and <2 x i64> %v1, %c
  %inv_mask = xor <2 x i64> <i64 -1, i64 -1>, %c
  %masked_v2 = and <2 x i64> %v2, %inv_mask
  %a = or <2 x i64> %masked_v2, %masked_v1
  ret <2 x i64> %a
}

define <2 x i64> @bitselect_xor_v2i64(<2 x i64> %c, <2 x i64> %v1, <2 x i64> %v2) {
; SIMD128-LABEL: bitselect_xor_v2i64:
; SIMD128:         .functype bitselect_xor_v2i64 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $1, $2, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_v2i64:
; SIMD128-FAST:         .functype bitselect_xor_v2i64 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push2=, $1, $2
; SIMD128-FAST-NEXT:    v128.and $push1=, $pop2, $0
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop1, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_v2i64:
; NO-SIMD128:         .functype bitselect_xor_v2i64 (i32, i64, i64, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.xor $push0=, $4, $6
; NO-SIMD128-NEXT:    i64.and $push1=, $pop0, $2
; NO-SIMD128-NEXT:    i64.xor $push2=, $pop1, $6
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.xor $push3=, $3, $5
; NO-SIMD128-NEXT:    i64.and $push4=, $pop3, $1
; NO-SIMD128-NEXT:    i64.xor $push5=, $pop4, $5
; NO-SIMD128-NEXT:    i64.store 0($0), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_v2i64:
; NO-SIMD128-FAST:         .functype bitselect_xor_v2i64 (i32, i64, i64, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.xor $push0=, $3, $5
; NO-SIMD128-FAST-NEXT:    i64.and $push1=, $pop0, $1
; NO-SIMD128-FAST-NEXT:    i64.xor $push2=, $pop1, $5
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.xor $push3=, $4, $6
; NO-SIMD128-FAST-NEXT:    i64.and $push4=, $pop3, $2
; NO-SIMD128-FAST-NEXT:    i64.xor $push5=, $pop4, $6
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <2 x i64> %v1, %v2
 %and = and <2 x i64> %xor1, %c
 %a = xor <2 x i64> %and, %v2
 ret <2 x i64> %a
}

define <2 x i64> @bitselect_xor_reversed_v2i64(<2 x i64> %c, <2 x i64> %v1, <2 x i64> %v2) {
; SIMD128-LABEL: bitselect_xor_reversed_v2i64:
; SIMD128:         .functype bitselect_xor_reversed_v2i64 (v128, v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.bitselect $push0=, $2, $1, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: bitselect_xor_reversed_v2i64:
; SIMD128-FAST:         .functype bitselect_xor_reversed_v2i64 (v128, v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.xor $push1=, $1, $2
; SIMD128-FAST-NEXT:    v128.not $push2=, $0
; SIMD128-FAST-NEXT:    v128.and $push3=, $pop1, $pop2
; SIMD128-FAST-NEXT:    v128.xor $push0=, $pop3, $2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: bitselect_xor_reversed_v2i64:
; NO-SIMD128:         .functype bitselect_xor_reversed_v2i64 (i32, i64, i64, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.xor $push2=, $4, $6
; NO-SIMD128-NEXT:    i64.const $push0=, -1
; NO-SIMD128-NEXT:    i64.xor $push1=, $2, $pop0
; NO-SIMD128-NEXT:    i64.and $push3=, $pop2, $pop1
; NO-SIMD128-NEXT:    i64.xor $push4=, $pop3, $6
; NO-SIMD128-NEXT:    i64.store 8($0), $pop4
; NO-SIMD128-NEXT:    i64.xor $push6=, $3, $5
; NO-SIMD128-NEXT:    i64.const $push9=, -1
; NO-SIMD128-NEXT:    i64.xor $push5=, $1, $pop9
; NO-SIMD128-NEXT:    i64.and $push7=, $pop6, $pop5
; NO-SIMD128-NEXT:    i64.xor $push8=, $pop7, $5
; NO-SIMD128-NEXT:    i64.store 0($0), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: bitselect_xor_reversed_v2i64:
; NO-SIMD128-FAST:         .functype bitselect_xor_reversed_v2i64 (i32, i64, i64, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.xor $push2=, $3, $5
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push1=, $1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.and $push3=, $pop2, $pop1
; NO-SIMD128-FAST-NEXT:    i64.xor $push4=, $pop3, $5
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop4
; NO-SIMD128-FAST-NEXT:    i64.xor $push6=, $4, $6
; NO-SIMD128-FAST-NEXT:    i64.const $push9=, -1
; NO-SIMD128-FAST-NEXT:    i64.xor $push5=, $2, $pop9
; NO-SIMD128-FAST-NEXT:    i64.and $push7=, $pop6, $pop5
; NO-SIMD128-FAST-NEXT:    i64.xor $push8=, $pop7, $6
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop8
; NO-SIMD128-FAST-NEXT:    return
 %xor1 = xor <2 x i64> %v1, %v2
 %notc = xor <2 x i64> %c, <i64 -1, i64 -1>
 %and = and <2 x i64> %xor1, %notc
 %a = xor <2 x i64> %and, %v2
 ret <2 x i64> %a
}

define <2 x i64> @extmul_low_s_v2i64(<4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: extmul_low_s_v2i64:
; SIMD128:         .functype extmul_low_s_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extmul_low_i32x4_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_low_s_v2i64:
; SIMD128-FAST:         .functype extmul_low_s_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extend_low_i32x4_s $push0=, $0
; SIMD128-FAST-NEXT:    i64x2.extend_low_i32x4_s $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_low_s_v2i64:
; NO-SIMD128:         .functype extmul_low_s_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_s $push1=, $2
; NO-SIMD128-NEXT:    i64.extend_i32_s $push0=, $6
; NO-SIMD128-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.extend_i32_s $push4=, $1
; NO-SIMD128-NEXT:    i64.extend_i32_s $push3=, $5
; NO-SIMD128-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_low_s_v2i64:
; NO-SIMD128-FAST:         .functype extmul_low_s_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push1=, $1
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push0=, $5
; NO-SIMD128-FAST-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push4=, $2
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push3=, $6
; NO-SIMD128-FAST-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %low1 = shufflevector <4 x i32> %v1, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %low2 = shufflevector <4 x i32> %v2, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %extended1 = sext <2 x i32> %low1 to <2 x i64>
  %extended2 = sext <2 x i32> %low2 to <2 x i64>
  %a = mul <2 x i64> %extended1, %extended2
  ret <2 x i64> %a
}

define <2 x i64> @extmul_high_s_v2i64(<4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: extmul_high_s_v2i64:
; SIMD128:         .functype extmul_high_s_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extmul_high_i32x4_s $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_high_s_v2i64:
; SIMD128-FAST:         .functype extmul_high_s_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extend_high_i32x4_s $push0=, $0
; SIMD128-FAST-NEXT:    i64x2.extend_high_i32x4_s $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_high_s_v2i64:
; NO-SIMD128:         .functype extmul_high_s_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_s $push1=, $4
; NO-SIMD128-NEXT:    i64.extend_i32_s $push0=, $8
; NO-SIMD128-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.extend_i32_s $push4=, $3
; NO-SIMD128-NEXT:    i64.extend_i32_s $push3=, $7
; NO-SIMD128-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_high_s_v2i64:
; NO-SIMD128-FAST:         .functype extmul_high_s_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push1=, $3
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push0=, $7
; NO-SIMD128-FAST-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push4=, $4
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_s $push3=, $8
; NO-SIMD128-FAST-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %high1 = shufflevector <4 x i32> %v1, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %high2 = shufflevector <4 x i32> %v2, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %extended1 = sext <2 x i32> %high1 to <2 x i64>
  %extended2 = sext <2 x i32> %high2 to <2 x i64>
  %a = mul <2 x i64> %extended1, %extended2
  ret <2 x i64> %a
}

define <2 x i64> @extmul_low_u_v2i64(<4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: extmul_low_u_v2i64:
; SIMD128:         .functype extmul_low_u_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extmul_low_i32x4_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_low_u_v2i64:
; SIMD128-FAST:         .functype extmul_low_u_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extend_low_i32x4_u $push0=, $0
; SIMD128-FAST-NEXT:    i64x2.extend_low_i32x4_u $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_low_u_v2i64:
; NO-SIMD128:         .functype extmul_low_u_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_u $push1=, $2
; NO-SIMD128-NEXT:    i64.extend_i32_u $push0=, $6
; NO-SIMD128-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.extend_i32_u $push4=, $1
; NO-SIMD128-NEXT:    i64.extend_i32_u $push3=, $5
; NO-SIMD128-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_low_u_v2i64:
; NO-SIMD128-FAST:         .functype extmul_low_u_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push1=, $1
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push0=, $5
; NO-SIMD128-FAST-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push4=, $2
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push3=, $6
; NO-SIMD128-FAST-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %low1 = shufflevector <4 x i32> %v1, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %low2 = shufflevector <4 x i32> %v2, <4 x i32> undef, <2 x i32> <i32 0, i32 1>
  %extended1 = zext <2 x i32> %low1 to <2 x i64>
  %extended2 = zext <2 x i32> %low2 to <2 x i64>
  %a = mul <2 x i64> %extended1, %extended2
  ret <2 x i64> %a
}

define <2 x i64> @extmul_high_u_v2i64(<4 x i32> %v1, <4 x i32> %v2) {
; SIMD128-LABEL: extmul_high_u_v2i64:
; SIMD128:         .functype extmul_high_u_v2i64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    i64x2.extmul_high_i32x4_u $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: extmul_high_u_v2i64:
; SIMD128-FAST:         .functype extmul_high_u_v2i64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    i64x2.extend_high_i32x4_u $push0=, $0
; SIMD128-FAST-NEXT:    i64x2.extend_high_i32x4_u $push1=, $1
; SIMD128-FAST-NEXT:    i64x2.mul $push2=, $pop0, $pop1
; SIMD128-FAST-NEXT:    return $pop2
;
; NO-SIMD128-LABEL: extmul_high_u_v2i64:
; NO-SIMD128:         .functype extmul_high_u_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.extend_i32_u $push1=, $4
; NO-SIMD128-NEXT:    i64.extend_i32_u $push0=, $8
; NO-SIMD128-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i64.store 8($0), $pop2
; NO-SIMD128-NEXT:    i64.extend_i32_u $push4=, $3
; NO-SIMD128-NEXT:    i64.extend_i32_u $push3=, $7
; NO-SIMD128-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-NEXT:    i64.store 0($0), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: extmul_high_u_v2i64:
; NO-SIMD128-FAST:         .functype extmul_high_u_v2i64 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push1=, $3
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push0=, $7
; NO-SIMD128-FAST-NEXT:    i64.mul $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push4=, $4
; NO-SIMD128-FAST-NEXT:    i64.extend_i32_u $push3=, $8
; NO-SIMD128-FAST-NEXT:    i64.mul $push5=, $pop4, $pop3
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %high1 = shufflevector <4 x i32> %v1, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %high2 = shufflevector <4 x i32> %v2, <4 x i32> undef, <2 x i32> <i32 2, i32 3>
  %extended1 = zext <2 x i32> %high1 to <2 x i64>
  %extended2 = zext <2 x i32> %high2 to <2 x i64>
  %a = mul <2 x i64> %extended1, %extended2
  ret <2 x i64> %a
}

; ==============================================================================
; 4 x float
; ==============================================================================
define <4 x float> @neg_v4f32(<4 x float> %x) {
  ; nsz makes this semantically equivalent to flipping sign bit
; SIMD128-LABEL: neg_v4f32:
; SIMD128:         .functype neg_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.neg $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: neg_v4f32:
; SIMD128-FAST:         .functype neg_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.neg $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: neg_v4f32:
; NO-SIMD128:         .functype neg_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.neg $push0=, $3
; NO-SIMD128-NEXT:    f32.store 8($0), $pop0
; NO-SIMD128-NEXT:    f32.neg $push1=, $2
; NO-SIMD128-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-NEXT:    f32.neg $push2=, $1
; NO-SIMD128-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push3=, 12
; NO-SIMD128-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-NEXT:    f32.neg $push5=, $4
; NO-SIMD128-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: neg_v4f32:
; NO-SIMD128-FAST:         .functype neg_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.neg $push0=, $1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.neg $push1=, $2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.neg $push2=, $3
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    f32.neg $push5=, $4
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = fsub nsz <4 x float> <float 0.0, float 0.0, float 0.0, float 0.0>, %x
  ret <4 x float> %a
}

declare <4 x float> @llvm.fabs.v4f32(<4 x float>) nounwind readnone
define <4 x float> @abs_v4f32(<4 x float> %x) {
; SIMD128-LABEL: abs_v4f32:
; SIMD128:         .functype abs_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.abs $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: abs_v4f32:
; SIMD128-FAST:         .functype abs_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.abs $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: abs_v4f32:
; NO-SIMD128:         .functype abs_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.abs $push0=, $3
; NO-SIMD128-NEXT:    f32.store 8($0), $pop0
; NO-SIMD128-NEXT:    f32.abs $push1=, $2
; NO-SIMD128-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-NEXT:    f32.abs $push2=, $1
; NO-SIMD128-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push3=, 12
; NO-SIMD128-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-NEXT:    f32.abs $push5=, $4
; NO-SIMD128-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: abs_v4f32:
; NO-SIMD128-FAST:         .functype abs_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.abs $push0=, $1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.abs $push1=, $2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.abs $push2=, $3
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    f32.abs $push5=, $4
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = call <4 x float> @llvm.fabs.v4f32(<4 x float> %x)
  ret <4 x float> %a
}

define <4 x float> @min_unordered_v4f32(<4 x float> %x) {
; SIMD128-LABEL: min_unordered_v4f32:
; SIMD128:         .functype min_unordered_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f32x4.pmin $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: min_unordered_v4f32:
; SIMD128-FAST:         .functype min_unordered_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f32x4.pmin $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_unordered_v4f32:
; NO-SIMD128:         .functype min_unordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push17=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.gt $push1=, $3, $pop17
; NO-SIMD128-NEXT:    f32.select $push2=, $pop0, $3, $pop1
; NO-SIMD128-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-NEXT:    f32.const $push16=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.gt $push3=, $2, $pop15
; NO-SIMD128-NEXT:    f32.select $push4=, $pop16, $2, $pop3
; NO-SIMD128-NEXT:    f32.store 4($0), $pop4
; NO-SIMD128-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.gt $push5=, $1, $pop13
; NO-SIMD128-NEXT:    f32.select $push6=, $pop14, $1, $pop5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push9=, 12
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.gt $push7=, $4, $pop11
; NO-SIMD128-NEXT:    f32.select $push8=, $pop12, $4, $pop7
; NO-SIMD128-NEXT:    f32.store 0($pop10), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_unordered_v4f32:
; NO-SIMD128-FAST:         .functype min_unordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push17=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.gt $push1=, $1, $pop17
; NO-SIMD128-FAST-NEXT:    f32.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.const $push16=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.gt $push3=, $2, $pop15
; NO-SIMD128-FAST-NEXT:    f32.select $push4=, $pop16, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.gt $push5=, $3, $pop13
; NO-SIMD128-FAST-NEXT:    f32.select $push6=, $pop14, $3, $pop5
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.gt $push7=, $4, $pop11
; NO-SIMD128-FAST-NEXT:    f32.select $push8=, $pop12, $4, $pop7
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop10), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp ule <4 x float> %x, <float 5., float 5., float 5., float 5.>
  %a = select <4 x i1> %cmps, <4 x float> %x,
    <4 x float> <float 5., float 5., float 5., float 5.>
  ret <4 x float> %a
}

define <4 x float> @max_unordered_v4f32(<4 x float> %x) {
; SIMD128-LABEL: max_unordered_v4f32:
; SIMD128:         .functype max_unordered_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f32x4.pmax $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: max_unordered_v4f32:
; SIMD128-FAST:         .functype max_unordered_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f32x4.pmax $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_unordered_v4f32:
; NO-SIMD128:         .functype max_unordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push17=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.lt $push1=, $3, $pop17
; NO-SIMD128-NEXT:    f32.select $push2=, $pop0, $3, $pop1
; NO-SIMD128-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-NEXT:    f32.const $push16=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.lt $push3=, $2, $pop15
; NO-SIMD128-NEXT:    f32.select $push4=, $pop16, $2, $pop3
; NO-SIMD128-NEXT:    f32.store 4($0), $pop4
; NO-SIMD128-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.lt $push5=, $1, $pop13
; NO-SIMD128-NEXT:    f32.select $push6=, $pop14, $1, $pop5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push9=, 12
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.lt $push7=, $4, $pop11
; NO-SIMD128-NEXT:    f32.select $push8=, $pop12, $4, $pop7
; NO-SIMD128-NEXT:    f32.store 0($pop10), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_unordered_v4f32:
; NO-SIMD128-FAST:         .functype max_unordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push17=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.lt $push1=, $1, $pop17
; NO-SIMD128-FAST-NEXT:    f32.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.const $push16=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.lt $push3=, $2, $pop15
; NO-SIMD128-FAST-NEXT:    f32.select $push4=, $pop16, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.lt $push5=, $3, $pop13
; NO-SIMD128-FAST-NEXT:    f32.select $push6=, $pop14, $3, $pop5
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.lt $push7=, $4, $pop11
; NO-SIMD128-FAST-NEXT:    f32.select $push8=, $pop12, $4, $pop7
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop10), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp uge <4 x float> %x, <float 5., float 5., float 5., float 5.>
  %a = select <4 x i1> %cmps, <4 x float> %x,
    <4 x float> <float 5., float 5., float 5., float 5.>
  ret <4 x float> %a
}

define <4 x float> @min_ordered_v4f32(<4 x float> %x) {
; SIMD128-LABEL: min_ordered_v4f32:
; SIMD128:         .functype min_ordered_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f32x4.pmin $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: min_ordered_v4f32:
; SIMD128-FAST:         .functype min_ordered_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f32x4.pmin $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_ordered_v4f32:
; NO-SIMD128:         .functype min_ordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push17=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.ge $push1=, $3, $pop17
; NO-SIMD128-NEXT:    f32.select $push2=, $pop0, $3, $pop1
; NO-SIMD128-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-NEXT:    f32.const $push16=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.ge $push3=, $2, $pop15
; NO-SIMD128-NEXT:    f32.select $push4=, $pop16, $2, $pop3
; NO-SIMD128-NEXT:    f32.store 4($0), $pop4
; NO-SIMD128-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.ge $push5=, $1, $pop13
; NO-SIMD128-NEXT:    f32.select $push6=, $pop14, $1, $pop5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push9=, 12
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.ge $push7=, $4, $pop11
; NO-SIMD128-NEXT:    f32.select $push8=, $pop12, $4, $pop7
; NO-SIMD128-NEXT:    f32.store 0($pop10), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_ordered_v4f32:
; NO-SIMD128-FAST:         .functype min_ordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push17=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.ge $push1=, $1, $pop17
; NO-SIMD128-FAST-NEXT:    f32.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.const $push16=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.ge $push3=, $2, $pop15
; NO-SIMD128-FAST-NEXT:    f32.select $push4=, $pop16, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.ge $push5=, $3, $pop13
; NO-SIMD128-FAST-NEXT:    f32.select $push6=, $pop14, $3, $pop5
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.ge $push7=, $4, $pop11
; NO-SIMD128-FAST-NEXT:    f32.select $push8=, $pop12, $4, $pop7
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop10), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp ole <4 x float> <float 5., float 5., float 5., float 5.>, %x
  %a = select <4 x i1> %cmps,
    <4 x float> <float 5., float 5., float 5., float 5.>, <4 x float> %x
  ret <4 x float> %a
}

define <4 x float> @max_ordered_v4f32(<4 x float> %x) {
; SIMD128-LABEL: max_ordered_v4f32:
; SIMD128:         .functype max_ordered_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f32x4.pmax $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: max_ordered_v4f32:
; SIMD128-FAST:         .functype max_ordered_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f32x4.pmax $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_ordered_v4f32:
; NO-SIMD128:         .functype max_ordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push17=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.le $push1=, $3, $pop17
; NO-SIMD128-NEXT:    f32.select $push2=, $pop0, $3, $pop1
; NO-SIMD128-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-NEXT:    f32.const $push16=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.le $push3=, $2, $pop15
; NO-SIMD128-NEXT:    f32.select $push4=, $pop16, $2, $pop3
; NO-SIMD128-NEXT:    f32.store 4($0), $pop4
; NO-SIMD128-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.le $push5=, $1, $pop13
; NO-SIMD128-NEXT:    f32.select $push6=, $pop14, $1, $pop5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop6
; NO-SIMD128-NEXT:    i32.const $push9=, 12
; NO-SIMD128-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-NEXT:    f32.le $push7=, $4, $pop11
; NO-SIMD128-NEXT:    f32.select $push8=, $pop12, $4, $pop7
; NO-SIMD128-NEXT:    f32.store 0($pop10), $pop8
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_ordered_v4f32:
; NO-SIMD128-FAST:         .functype max_ordered_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push17=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.le $push1=, $1, $pop17
; NO-SIMD128-FAST-NEXT:    f32.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.const $push16=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push15=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.le $push3=, $2, $pop15
; NO-SIMD128-FAST-NEXT:    f32.select $push4=, $pop16, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop4
; NO-SIMD128-FAST-NEXT:    f32.const $push14=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push13=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.le $push5=, $3, $pop13
; NO-SIMD128-FAST-NEXT:    f32.select $push6=, $pop14, $3, $pop5
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop6
; NO-SIMD128-FAST-NEXT:    i32.const $push9=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push10=, $0, $pop9
; NO-SIMD128-FAST-NEXT:    f32.const $push12=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.const $push11=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f32.le $push7=, $4, $pop11
; NO-SIMD128-FAST-NEXT:    f32.select $push8=, $pop12, $4, $pop7
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop10), $pop8
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp oge <4 x float> <float 5., float 5., float 5., float 5.>, %x
  %a = select <4 x i1> %cmps,
    <4 x float> <float 5., float 5., float 5., float 5.>, <4 x float> %x
  ret <4 x float> %a
}

declare <4 x float> @llvm.minimum.v4f32(<4 x float>, <4 x float>)
define <4 x float> @min_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: min_intrinsic_v4f32:
; SIMD128:         .functype min_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.min $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_intrinsic_v4f32:
; SIMD128-FAST:         .functype min_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.min $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_intrinsic_v4f32:
; NO-SIMD128:         .functype min_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.min $push0=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop0
; NO-SIMD128-NEXT:    f32.min $push1=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-NEXT:    f32.min $push2=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    f32.min $push3=, $4, $8
; NO-SIMD128-NEXT:    f32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype min_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.min $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.min $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.min $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    f32.min $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = call <4 x float> @llvm.minimum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

declare <4 x float> @llvm.minnum.v4f32(<4 x float>, <4 x float>)
define <4 x float> @minnum_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: minnum_intrinsic_v4f32:
; SIMD128:         .functype minnum_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-NEXT:    local.tee $push26=, $3=, $pop27
; SIMD128-NEXT:    f32x4.extract_lane $push25=, $1, 0
; SIMD128-NEXT:    local.tee $push24=, $2=, $pop25
; SIMD128-NEXT:    f32.lt $push2=, $3, $2
; SIMD128-NEXT:    f32.select $push3=, $pop26, $pop24, $pop2
; SIMD128-NEXT:    f32x4.splat $push4=, $pop3
; SIMD128-NEXT:    f32x4.extract_lane $push23=, $0, 1
; SIMD128-NEXT:    local.tee $push22=, $3=, $pop23
; SIMD128-NEXT:    f32x4.extract_lane $push21=, $1, 1
; SIMD128-NEXT:    local.tee $push20=, $2=, $pop21
; SIMD128-NEXT:    f32.lt $push0=, $3, $2
; SIMD128-NEXT:    f32.select $push1=, $pop22, $pop20, $pop0
; SIMD128-NEXT:    f32x4.replace_lane $push5=, $pop4, 1, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push19=, $0, 2
; SIMD128-NEXT:    local.tee $push18=, $3=, $pop19
; SIMD128-NEXT:    f32x4.extract_lane $push17=, $1, 2
; SIMD128-NEXT:    local.tee $push16=, $2=, $pop17
; SIMD128-NEXT:    f32.lt $push6=, $3, $2
; SIMD128-NEXT:    f32.select $push7=, $pop18, $pop16, $pop6
; SIMD128-NEXT:    f32x4.replace_lane $push8=, $pop5, 2, $pop7
; SIMD128-NEXT:    f32x4.extract_lane $push15=, $0, 3
; SIMD128-NEXT:    local.tee $push14=, $3=, $pop15
; SIMD128-NEXT:    f32x4.extract_lane $push13=, $1, 3
; SIMD128-NEXT:    local.tee $push12=, $2=, $pop13
; SIMD128-NEXT:    f32.lt $push9=, $3, $2
; SIMD128-NEXT:    f32.select $push10=, $pop14, $pop12, $pop9
; SIMD128-NEXT:    f32x4.replace_lane $push11=, $pop8, 3, $pop10
; SIMD128-NEXT:    return $pop11
;
; SIMD128-FAST-LABEL: minnum_intrinsic_v4f32:
; SIMD128-FAST:         .functype minnum_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-FAST-NEXT:    local.tee $push26=, $3=, $pop27
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push25=, $1, 0
; SIMD128-FAST-NEXT:    local.tee $push24=, $2=, $pop25
; SIMD128-FAST-NEXT:    f32.lt $push3=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push4=, $pop26, $pop24, $pop3
; SIMD128-FAST-NEXT:    f32x4.splat $push5=, $pop4
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push23=, $0, 1
; SIMD128-FAST-NEXT:    local.tee $push22=, $3=, $pop23
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push21=, $1, 1
; SIMD128-FAST-NEXT:    local.tee $push20=, $2=, $pop21
; SIMD128-FAST-NEXT:    f32.lt $push1=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push2=, $pop22, $pop20, $pop1
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push6=, $pop5, 1, $pop2
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push19=, $0, 2
; SIMD128-FAST-NEXT:    local.tee $push18=, $3=, $pop19
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push17=, $1, 2
; SIMD128-FAST-NEXT:    local.tee $push16=, $2=, $pop17
; SIMD128-FAST-NEXT:    f32.lt $push7=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push8=, $pop18, $pop16, $pop7
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push9=, $pop6, 2, $pop8
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push15=, $0, 3
; SIMD128-FAST-NEXT:    local.tee $push14=, $3=, $pop15
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push13=, $1, 3
; SIMD128-FAST-NEXT:    local.tee $push12=, $2=, $pop13
; SIMD128-FAST-NEXT:    f32.lt $push10=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push11=, $pop14, $pop12, $pop10
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push0=, $pop9, 3, $pop11
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: minnum_intrinsic_v4f32:
; NO-SIMD128:         .functype minnum_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    call $push0=, fminf, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop0
; NO-SIMD128-NEXT:    call $push1=, fminf, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-NEXT:    call $push2=, fminf, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push3=, 12
; NO-SIMD128-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-NEXT:    call $push5=, fminf, $4, $8
; NO-SIMD128-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: minnum_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype minnum_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    call $push0=, fminf, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    call $push1=, fminf, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    call $push2=, fminf, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    call $push5=, fminf, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan <4 x float> @llvm.minnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

define <4 x float> @minnum_nsz_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: minnum_nsz_intrinsic_v4f32:
; SIMD128:         .functype minnum_nsz_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.min $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: minnum_nsz_intrinsic_v4f32:
; SIMD128-FAST:         .functype minnum_nsz_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.min $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: minnum_nsz_intrinsic_v4f32:
; NO-SIMD128:         .functype minnum_nsz_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    call $push0=, fminf, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop0
; NO-SIMD128-NEXT:    call $push1=, fminf, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-NEXT:    call $push2=, fminf, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push3=, 12
; NO-SIMD128-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-NEXT:    call $push5=, fminf, $4, $8
; NO-SIMD128-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: minnum_nsz_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype minnum_nsz_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    call $push0=, fminf, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    call $push1=, fminf, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    call $push2=, fminf, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    call $push5=, fminf, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan nsz <4 x float> @llvm.minnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

define <4 x float> @fminnumv432_non_zero_intrinsic(<4 x float> %x) {
; SIMD128-LABEL: fminnumv432_non_zero_intrinsic:
; SIMD128:         .functype fminnumv432_non_zero_intrinsic (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, -0x1p0, -0x1p0, -0x1p0, -0x1p0
; SIMD128-NEXT:    f32x4.min $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: fminnumv432_non_zero_intrinsic:
; SIMD128-FAST:         .functype fminnumv432_non_zero_intrinsic (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, -0x1p0, -0x1p0, -0x1p0, -0x1p0
; SIMD128-FAST-NEXT:    f32x4.min $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: fminnumv432_non_zero_intrinsic:
; NO-SIMD128:         .functype fminnumv432_non_zero_intrinsic (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-NEXT:    call $push1=, fminf, $3, $pop0
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.const $push9=, -0x1p0
; NO-SIMD128-NEXT:    call $push2=, fminf, $2, $pop9
; NO-SIMD128-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-NEXT:    f32.const $push8=, -0x1p0
; NO-SIMD128-NEXT:    call $push3=, fminf, $1, $pop8
; NO-SIMD128-NEXT:    f32.store 0($0), $pop3
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    f32.const $push7=, -0x1p0
; NO-SIMD128-NEXT:    call $push6=, fminf, $4, $pop7
; NO-SIMD128-NEXT:    f32.store 0($pop5), $pop6
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: fminnumv432_non_zero_intrinsic:
; NO-SIMD128-FAST:         .functype fminnumv432_non_zero_intrinsic (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-FAST-NEXT:    call $push1=, fminf, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.const $push9=, -0x1p0
; NO-SIMD128-FAST-NEXT:    call $push2=, fminf, $2, $pop9
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop2
; NO-SIMD128-FAST-NEXT:    f32.const $push8=, -0x1p0
; NO-SIMD128-FAST-NEXT:    call $push3=, fminf, $3, $pop8
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop3
; NO-SIMD128-FAST-NEXT:    i32.const $push4=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-FAST-NEXT:    f32.const $push7=, -0x1p0
; NO-SIMD128-FAST-NEXT:    call $push6=, fminf, $4, $pop7
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop5), $pop6
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan <4 x float> @llvm.minnum.v4f32(<4 x float> %x, <4 x float><float -1.0, float -1.0, float -1.0, float -1.0>)
  ret <4 x float> %a
}

define <4 x float> @fminnumv432_one_zero_intrinsic(<4 x float> %x) {
; SIMD128-LABEL: fminnumv432_one_zero_intrinsic:
; SIMD128:         .functype fminnumv432_one_zero_intrinsic (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-NEXT:    local.tee $push26=, $1=, $pop27
; SIMD128-NEXT:    f32.const $push3=, -0x1p0
; SIMD128-NEXT:    f32.const $push25=, -0x1p0
; SIMD128-NEXT:    f32.lt $push4=, $1, $pop25
; SIMD128-NEXT:    f32.select $push5=, $pop26, $pop3, $pop4
; SIMD128-NEXT:    f32x4.splat $push6=, $pop5
; SIMD128-NEXT:    f32x4.extract_lane $push24=, $0, 1
; SIMD128-NEXT:    local.tee $push23=, $1=, $pop24
; SIMD128-NEXT:    f32.const $push0=, 0x0p0
; SIMD128-NEXT:    f32.const $push22=, 0x0p0
; SIMD128-NEXT:    f32.lt $push1=, $1, $pop22
; SIMD128-NEXT:    f32.select $push2=, $pop23, $pop0, $pop1
; SIMD128-NEXT:    f32x4.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    f32x4.extract_lane $push21=, $0, 2
; SIMD128-NEXT:    local.tee $push20=, $1=, $pop21
; SIMD128-NEXT:    f32.const $push19=, -0x1p0
; SIMD128-NEXT:    f32.const $push18=, -0x1p0
; SIMD128-NEXT:    f32.lt $push8=, $1, $pop18
; SIMD128-NEXT:    f32.select $push9=, $pop20, $pop19, $pop8
; SIMD128-NEXT:    f32x4.replace_lane $push10=, $pop7, 2, $pop9
; SIMD128-NEXT:    f32x4.extract_lane $push17=, $0, 3
; SIMD128-NEXT:    local.tee $push16=, $1=, $pop17
; SIMD128-NEXT:    f32.const $push15=, -0x1p0
; SIMD128-NEXT:    f32.const $push14=, -0x1p0
; SIMD128-NEXT:    f32.lt $push11=, $1, $pop14
; SIMD128-NEXT:    f32.select $push12=, $pop16, $pop15, $pop11
; SIMD128-NEXT:    f32x4.replace_lane $push13=, $pop10, 3, $pop12
; SIMD128-NEXT:    return $pop13
;
; SIMD128-FAST-LABEL: fminnumv432_one_zero_intrinsic:
; SIMD128-FAST:         .functype fminnumv432_one_zero_intrinsic (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-FAST-NEXT:    local.tee $push26=, $1=, $pop27
; SIMD128-FAST-NEXT:    f32.const $push4=, -0x1p0
; SIMD128-FAST-NEXT:    f32.const $push25=, -0x1p0
; SIMD128-FAST-NEXT:    f32.lt $push5=, $1, $pop25
; SIMD128-FAST-NEXT:    f32.select $push6=, $pop26, $pop4, $pop5
; SIMD128-FAST-NEXT:    f32x4.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push24=, $0, 1
; SIMD128-FAST-NEXT:    local.tee $push23=, $1=, $pop24
; SIMD128-FAST-NEXT:    f32.const $push1=, 0x0p0
; SIMD128-FAST-NEXT:    f32.const $push22=, 0x0p0
; SIMD128-FAST-NEXT:    f32.lt $push2=, $1, $pop22
; SIMD128-FAST-NEXT:    f32.select $push3=, $pop23, $pop1, $pop2
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push8=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push21=, $0, 2
; SIMD128-FAST-NEXT:    local.tee $push20=, $1=, $pop21
; SIMD128-FAST-NEXT:    f32.const $push19=, -0x1p0
; SIMD128-FAST-NEXT:    f32.const $push18=, -0x1p0
; SIMD128-FAST-NEXT:    f32.lt $push9=, $1, $pop18
; SIMD128-FAST-NEXT:    f32.select $push10=, $pop20, $pop19, $pop9
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push11=, $pop8, 2, $pop10
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push17=, $0, 3
; SIMD128-FAST-NEXT:    local.tee $push16=, $1=, $pop17
; SIMD128-FAST-NEXT:    f32.const $push15=, -0x1p0
; SIMD128-FAST-NEXT:    f32.const $push14=, -0x1p0
; SIMD128-FAST-NEXT:    f32.lt $push12=, $1, $pop14
; SIMD128-FAST-NEXT:    f32.select $push13=, $pop16, $pop15, $pop12
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push0=, $pop11, 3, $pop13
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: fminnumv432_one_zero_intrinsic:
; NO-SIMD128:         .functype fminnumv432_one_zero_intrinsic (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-NEXT:    call $push1=, fminf, $3, $pop0
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.const $push2=, 0x0p0
; NO-SIMD128-NEXT:    call $push3=, fminf, $2, $pop2
; NO-SIMD128-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-NEXT:    f32.const $push9=, -0x1p0
; NO-SIMD128-NEXT:    call $push4=, fminf, $1, $pop9
; NO-SIMD128-NEXT:    f32.store 0($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push5=, 12
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    f32.const $push8=, -0x1p0
; NO-SIMD128-NEXT:    call $push7=, fminf, $4, $pop8
; NO-SIMD128-NEXT:    f32.store 0($pop6), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: fminnumv432_one_zero_intrinsic:
; NO-SIMD128-FAST:         .functype fminnumv432_one_zero_intrinsic (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-FAST-NEXT:    call $push1=, fminf, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.const $push2=, 0x0p0
; NO-SIMD128-FAST-NEXT:    call $push3=, fminf, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.const $push9=, -0x1p0
; NO-SIMD128-FAST-NEXT:    call $push4=, fminf, $3, $pop9
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push5=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-FAST-NEXT:    f32.const $push8=, -0x1p0
; NO-SIMD128-FAST-NEXT:    call $push7=, fminf, $4, $pop8
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop6), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan <4 x float> @llvm.minnum.v4f32(<4 x float> %x, <4 x float><float -1.0, float 0.0, float -1.0, float -1.0>)
  ret <4 x float> %a
}

declare <4 x float> @llvm.maximum.v4f32(<4 x float>, <4 x float>)
define <4 x float> @max_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: max_intrinsic_v4f32:
; SIMD128:         .functype max_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.max $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_intrinsic_v4f32:
; SIMD128-FAST:         .functype max_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.max $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_intrinsic_v4f32:
; NO-SIMD128:         .functype max_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.max $push0=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop0
; NO-SIMD128-NEXT:    f32.max $push1=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-NEXT:    f32.max $push2=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    f32.max $push3=, $4, $8
; NO-SIMD128-NEXT:    f32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype max_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.max $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.max $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.max $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    f32.max $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = call <4 x float> @llvm.maximum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

declare <4 x float> @llvm.maxnum.v4f32(<4 x float>, <4 x float>)
define <4 x float> @maxnum_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: maxnum_intrinsic_v4f32:
; SIMD128:         .functype maxnum_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-NEXT:    local.tee $push26=, $3=, $pop27
; SIMD128-NEXT:    f32x4.extract_lane $push25=, $1, 0
; SIMD128-NEXT:    local.tee $push24=, $2=, $pop25
; SIMD128-NEXT:    f32.gt $push2=, $3, $2
; SIMD128-NEXT:    f32.select $push3=, $pop26, $pop24, $pop2
; SIMD128-NEXT:    f32x4.splat $push4=, $pop3
; SIMD128-NEXT:    f32x4.extract_lane $push23=, $0, 1
; SIMD128-NEXT:    local.tee $push22=, $3=, $pop23
; SIMD128-NEXT:    f32x4.extract_lane $push21=, $1, 1
; SIMD128-NEXT:    local.tee $push20=, $2=, $pop21
; SIMD128-NEXT:    f32.gt $push0=, $3, $2
; SIMD128-NEXT:    f32.select $push1=, $pop22, $pop20, $pop0
; SIMD128-NEXT:    f32x4.replace_lane $push5=, $pop4, 1, $pop1
; SIMD128-NEXT:    f32x4.extract_lane $push19=, $0, 2
; SIMD128-NEXT:    local.tee $push18=, $3=, $pop19
; SIMD128-NEXT:    f32x4.extract_lane $push17=, $1, 2
; SIMD128-NEXT:    local.tee $push16=, $2=, $pop17
; SIMD128-NEXT:    f32.gt $push6=, $3, $2
; SIMD128-NEXT:    f32.select $push7=, $pop18, $pop16, $pop6
; SIMD128-NEXT:    f32x4.replace_lane $push8=, $pop5, 2, $pop7
; SIMD128-NEXT:    f32x4.extract_lane $push15=, $0, 3
; SIMD128-NEXT:    local.tee $push14=, $3=, $pop15
; SIMD128-NEXT:    f32x4.extract_lane $push13=, $1, 3
; SIMD128-NEXT:    local.tee $push12=, $2=, $pop13
; SIMD128-NEXT:    f32.gt $push9=, $3, $2
; SIMD128-NEXT:    f32.select $push10=, $pop14, $pop12, $pop9
; SIMD128-NEXT:    f32x4.replace_lane $push11=, $pop8, 3, $pop10
; SIMD128-NEXT:    return $pop11
;
; SIMD128-FAST-LABEL: maxnum_intrinsic_v4f32:
; SIMD128-FAST:         .functype maxnum_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-FAST-NEXT:    local.tee $push26=, $3=, $pop27
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push25=, $1, 0
; SIMD128-FAST-NEXT:    local.tee $push24=, $2=, $pop25
; SIMD128-FAST-NEXT:    f32.gt $push3=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push4=, $pop26, $pop24, $pop3
; SIMD128-FAST-NEXT:    f32x4.splat $push5=, $pop4
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push23=, $0, 1
; SIMD128-FAST-NEXT:    local.tee $push22=, $3=, $pop23
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push21=, $1, 1
; SIMD128-FAST-NEXT:    local.tee $push20=, $2=, $pop21
; SIMD128-FAST-NEXT:    f32.gt $push1=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push2=, $pop22, $pop20, $pop1
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push6=, $pop5, 1, $pop2
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push19=, $0, 2
; SIMD128-FAST-NEXT:    local.tee $push18=, $3=, $pop19
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push17=, $1, 2
; SIMD128-FAST-NEXT:    local.tee $push16=, $2=, $pop17
; SIMD128-FAST-NEXT:    f32.gt $push7=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push8=, $pop18, $pop16, $pop7
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push9=, $pop6, 2, $pop8
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push15=, $0, 3
; SIMD128-FAST-NEXT:    local.tee $push14=, $3=, $pop15
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push13=, $1, 3
; SIMD128-FAST-NEXT:    local.tee $push12=, $2=, $pop13
; SIMD128-FAST-NEXT:    f32.gt $push10=, $3, $2
; SIMD128-FAST-NEXT:    f32.select $push11=, $pop14, $pop12, $pop10
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push0=, $pop9, 3, $pop11
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: maxnum_intrinsic_v4f32:
; NO-SIMD128:         .functype maxnum_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    call $push0=, fmaxf, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop0
; NO-SIMD128-NEXT:    call $push1=, fmaxf, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-NEXT:    call $push2=, fmaxf, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push3=, 12
; NO-SIMD128-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-NEXT:    call $push5=, fmaxf, $4, $8
; NO-SIMD128-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: maxnum_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype maxnum_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    call $push0=, fmaxf, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    call $push1=, fmaxf, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    call $push2=, fmaxf, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    call $push5=, fmaxf, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

define <4 x float> @maxnum_nsz_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: maxnum_nsz_intrinsic_v4f32:
; SIMD128:         .functype maxnum_nsz_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.max $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: maxnum_nsz_intrinsic_v4f32:
; SIMD128-FAST:         .functype maxnum_nsz_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.max $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: maxnum_nsz_intrinsic_v4f32:
; NO-SIMD128:         .functype maxnum_nsz_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    call $push0=, fmaxf, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop0
; NO-SIMD128-NEXT:    call $push1=, fmaxf, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-NEXT:    call $push2=, fmaxf, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push3=, 12
; NO-SIMD128-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-NEXT:    call $push5=, fmaxf, $4, $8
; NO-SIMD128-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: maxnum_nsz_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype maxnum_nsz_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    call $push0=, fmaxf, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    call $push1=, fmaxf, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    call $push2=, fmaxf, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    call $push5=, fmaxf, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan nsz <4 x float> @llvm.maxnum.v4f32(<4 x float> %x, <4 x float> %y)
  ret <4 x float> %a
}

define <4 x float> @maxnum_one_zero_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: maxnum_one_zero_intrinsic_v4f32:
; SIMD128:         .functype maxnum_one_zero_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-NEXT:    local.tee $push26=, $2=, $pop27
; SIMD128-NEXT:    f32.const $push3=, -0x1p0
; SIMD128-NEXT:    f32.const $push25=, -0x1p0
; SIMD128-NEXT:    f32.gt $push4=, $2, $pop25
; SIMD128-NEXT:    f32.select $push5=, $pop26, $pop3, $pop4
; SIMD128-NEXT:    f32x4.splat $push6=, $pop5
; SIMD128-NEXT:    f32x4.extract_lane $push24=, $0, 1
; SIMD128-NEXT:    local.tee $push23=, $2=, $pop24
; SIMD128-NEXT:    f32.const $push0=, 0x0p0
; SIMD128-NEXT:    f32.const $push22=, 0x0p0
; SIMD128-NEXT:    f32.gt $push1=, $2, $pop22
; SIMD128-NEXT:    f32.select $push2=, $pop23, $pop0, $pop1
; SIMD128-NEXT:    f32x4.replace_lane $push7=, $pop6, 1, $pop2
; SIMD128-NEXT:    f32x4.extract_lane $push21=, $0, 2
; SIMD128-NEXT:    local.tee $push20=, $2=, $pop21
; SIMD128-NEXT:    f32.const $push19=, -0x1p0
; SIMD128-NEXT:    f32.const $push18=, -0x1p0
; SIMD128-NEXT:    f32.gt $push8=, $2, $pop18
; SIMD128-NEXT:    f32.select $push9=, $pop20, $pop19, $pop8
; SIMD128-NEXT:    f32x4.replace_lane $push10=, $pop7, 2, $pop9
; SIMD128-NEXT:    f32x4.extract_lane $push17=, $0, 3
; SIMD128-NEXT:    local.tee $push16=, $2=, $pop17
; SIMD128-NEXT:    f32.const $push15=, -0x1p0
; SIMD128-NEXT:    f32.const $push14=, -0x1p0
; SIMD128-NEXT:    f32.gt $push11=, $2, $pop14
; SIMD128-NEXT:    f32.select $push12=, $pop16, $pop15, $pop11
; SIMD128-NEXT:    f32x4.replace_lane $push13=, $pop10, 3, $pop12
; SIMD128-NEXT:    return $pop13
;
; SIMD128-FAST-LABEL: maxnum_one_zero_intrinsic_v4f32:
; SIMD128-FAST:         .functype maxnum_one_zero_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push27=, $0, 0
; SIMD128-FAST-NEXT:    local.tee $push26=, $2=, $pop27
; SIMD128-FAST-NEXT:    f32.const $push4=, -0x1p0
; SIMD128-FAST-NEXT:    f32.const $push25=, -0x1p0
; SIMD128-FAST-NEXT:    f32.gt $push5=, $2, $pop25
; SIMD128-FAST-NEXT:    f32.select $push6=, $pop26, $pop4, $pop5
; SIMD128-FAST-NEXT:    f32x4.splat $push7=, $pop6
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push24=, $0, 1
; SIMD128-FAST-NEXT:    local.tee $push23=, $2=, $pop24
; SIMD128-FAST-NEXT:    f32.const $push1=, 0x0p0
; SIMD128-FAST-NEXT:    f32.const $push22=, 0x0p0
; SIMD128-FAST-NEXT:    f32.gt $push2=, $2, $pop22
; SIMD128-FAST-NEXT:    f32.select $push3=, $pop23, $pop1, $pop2
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push8=, $pop7, 1, $pop3
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push21=, $0, 2
; SIMD128-FAST-NEXT:    local.tee $push20=, $2=, $pop21
; SIMD128-FAST-NEXT:    f32.const $push19=, -0x1p0
; SIMD128-FAST-NEXT:    f32.const $push18=, -0x1p0
; SIMD128-FAST-NEXT:    f32.gt $push9=, $2, $pop18
; SIMD128-FAST-NEXT:    f32.select $push10=, $pop20, $pop19, $pop9
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push11=, $pop8, 2, $pop10
; SIMD128-FAST-NEXT:    f32x4.extract_lane $push17=, $0, 3
; SIMD128-FAST-NEXT:    local.tee $push16=, $2=, $pop17
; SIMD128-FAST-NEXT:    f32.const $push15=, -0x1p0
; SIMD128-FAST-NEXT:    f32.const $push14=, -0x1p0
; SIMD128-FAST-NEXT:    f32.gt $push12=, $2, $pop14
; SIMD128-FAST-NEXT:    f32.select $push13=, $pop16, $pop15, $pop12
; SIMD128-FAST-NEXT:    f32x4.replace_lane $push0=, $pop11, 3, $pop13
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: maxnum_one_zero_intrinsic_v4f32:
; NO-SIMD128:         .functype maxnum_one_zero_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-NEXT:    call $push1=, fmaxf, $3, $pop0
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.const $push2=, 0x0p0
; NO-SIMD128-NEXT:    call $push3=, fmaxf, $2, $pop2
; NO-SIMD128-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-NEXT:    f32.const $push9=, -0x1p0
; NO-SIMD128-NEXT:    call $push4=, fmaxf, $1, $pop9
; NO-SIMD128-NEXT:    f32.store 0($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push5=, 12
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    f32.const $push8=, -0x1p0
; NO-SIMD128-NEXT:    call $push7=, fmaxf, $4, $pop8
; NO-SIMD128-NEXT:    f32.store 0($pop6), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: maxnum_one_zero_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype maxnum_one_zero_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-FAST-NEXT:    call $push1=, fmaxf, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.const $push2=, 0x0p0
; NO-SIMD128-FAST-NEXT:    call $push3=, fmaxf, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.const $push9=, -0x1p0
; NO-SIMD128-FAST-NEXT:    call $push4=, fmaxf, $3, $pop9
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push5=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-FAST-NEXT:    f32.const $push8=, -0x1p0
; NO-SIMD128-FAST-NEXT:    call $push7=, fmaxf, $4, $pop8
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop6), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> %x, <4 x float><float -1.0, float 0.0, float -1.0, float -1.0>)
  ret <4 x float> %a
}

define <4 x float> @maxnum_non_zero_intrinsic_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: maxnum_non_zero_intrinsic_v4f32:
; SIMD128:         .functype maxnum_non_zero_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, -0x1p0, 0x1p0, -0x1p0, -0x1p0
; SIMD128-NEXT:    f32x4.max $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: maxnum_non_zero_intrinsic_v4f32:
; SIMD128-FAST:         .functype maxnum_non_zero_intrinsic_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, -0x1p0, 0x1p0, -0x1p0, -0x1p0
; SIMD128-FAST-NEXT:    f32x4.max $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: maxnum_non_zero_intrinsic_v4f32:
; NO-SIMD128:         .functype maxnum_non_zero_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-NEXT:    call $push1=, fmaxf, $3, $pop0
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.const $push2=, 0x1p0
; NO-SIMD128-NEXT:    call $push3=, fmaxf, $2, $pop2
; NO-SIMD128-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-NEXT:    f32.const $push9=, -0x1p0
; NO-SIMD128-NEXT:    call $push4=, fmaxf, $1, $pop9
; NO-SIMD128-NEXT:    f32.store 0($0), $pop4
; NO-SIMD128-NEXT:    i32.const $push5=, 12
; NO-SIMD128-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-NEXT:    f32.const $push8=, -0x1p0
; NO-SIMD128-NEXT:    call $push7=, fmaxf, $4, $pop8
; NO-SIMD128-NEXT:    f32.store 0($pop6), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: maxnum_non_zero_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype maxnum_non_zero_intrinsic_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.const $push0=, -0x1p0
; NO-SIMD128-FAST-NEXT:    call $push1=, fmaxf, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.const $push2=, 0x1p0
; NO-SIMD128-FAST-NEXT:    call $push3=, fmaxf, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.const $push9=, -0x1p0
; NO-SIMD128-FAST-NEXT:    call $push4=, fmaxf, $3, $pop9
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    i32.const $push5=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push6=, $0, $pop5
; NO-SIMD128-FAST-NEXT:    f32.const $push8=, -0x1p0
; NO-SIMD128-FAST-NEXT:    call $push7=, fmaxf, $4, $pop8
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop6), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %a = call nnan <4 x float> @llvm.maxnum.v4f32(<4 x float> %x, <4 x float><float -1.0, float 1.0, float -1.0, float -1.0>)
  ret <4 x float> %a
}

define <4 x float> @min_const_intrinsic_v4f32() {
; SIMD128-LABEL: min_const_intrinsic_v4f32:
; SIMD128:         .functype min_const_intrinsic_v4f32 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_const_intrinsic_v4f32:
; SIMD128-FAST:         .functype min_const_intrinsic_v4f32 () -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_const_intrinsic_v4f32:
; NO-SIMD128:         .functype min_const_intrinsic_v4f32 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 4656722015785320448
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 4656722015785320448
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_const_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype min_const_intrinsic_v4f32 (i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 4656722015785320448
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.const $push1=, 4656722015785320448
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <4 x float> @llvm.minimum.v4f32(
    <4 x float> <float 42., float 42., float 42., float 42.>,
    <4 x float> <float 5., float 5., float 5., float 5.>
  )
  ret <4 x float> %a
}

define <4 x float> @max_const_intrinsic_v4f32() {
; SIMD128-LABEL: max_const_intrinsic_v4f32:
; SIMD128:         .functype max_const_intrinsic_v4f32 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.5p5, 0x1.5p5, 0x1.5p5, 0x1.5p5
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_const_intrinsic_v4f32:
; SIMD128-FAST:         .functype max_const_intrinsic_v4f32 () -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push0=, 0x1.5p5, 0x1.5p5, 0x1.5p5, 0x1.5p5
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_const_intrinsic_v4f32:
; NO-SIMD128:         .functype max_const_intrinsic_v4f32 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 4767060206681587712
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 4767060206681587712
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_const_intrinsic_v4f32:
; NO-SIMD128-FAST:         .functype max_const_intrinsic_v4f32 (i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 4767060206681587712
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.const $push1=, 4767060206681587712
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <4 x float> @llvm.maximum.v4f32(
    <4 x float> <float 42., float 42., float 42., float 42.>,
    <4 x float> <float 5., float 5., float 5., float 5.>
  )
  ret <4 x float> %a
}

define <4 x float> @pmin_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: pmin_v4f32:
; SIMD128:         .functype pmin_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmin $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmin_v4f32:
; SIMD128-FAST:         .functype pmin_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmin $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmin_v4f32:
; NO-SIMD128:         .functype pmin_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.lt $push0=, $7, $3
; NO-SIMD128-NEXT:    f32.select $push1=, $7, $3, $pop0
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.lt $push2=, $6, $2
; NO-SIMD128-NEXT:    f32.select $push3=, $6, $2, $pop2
; NO-SIMD128-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-NEXT:    f32.lt $push4=, $5, $1
; NO-SIMD128-NEXT:    f32.select $push5=, $5, $1, $pop4
; NO-SIMD128-NEXT:    f32.store 0($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    f32.lt $push6=, $8, $4
; NO-SIMD128-NEXT:    f32.select $push7=, $8, $4, $pop6
; NO-SIMD128-NEXT:    f32.store 0($pop9), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmin_v4f32:
; NO-SIMD128-FAST:         .functype pmin_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.lt $push0=, $5, $1
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $5, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.lt $push2=, $6, $2
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $6, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.lt $push4=, $7, $3
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $7, $3, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-FAST-NEXT:    f32.lt $push6=, $8, $4
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $8, $4, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop9), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp olt <4 x float> %y, %x
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x i32> @pmin_int_v4f32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: pmin_int_v4f32:
; SIMD128:         .functype pmin_int_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmin $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmin_int_v4f32:
; SIMD128-FAST:         .functype pmin_int_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmin $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmin_int_v4f32:
; NO-SIMD128:         .functype pmin_int_v4f32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push1=, $8
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push0=, $4
; NO-SIMD128-NEXT:    f32.lt $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.select $push3=, $8, $4, $pop2
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push7=, $7
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push6=, $3
; NO-SIMD128-NEXT:    f32.lt $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.select $push9=, $7, $3, $pop8
; NO-SIMD128-NEXT:    i32.store 8($0), $pop9
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push11=, $6
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push10=, $2
; NO-SIMD128-NEXT:    f32.lt $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.select $push13=, $6, $2, $pop12
; NO-SIMD128-NEXT:    i32.store 4($0), $pop13
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push15=, $5
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push14=, $1
; NO-SIMD128-NEXT:    f32.lt $push16=, $pop15, $pop14
; NO-SIMD128-NEXT:    i32.select $push17=, $5, $1, $pop16
; NO-SIMD128-NEXT:    i32.store 0($0), $pop17
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmin_int_v4f32:
; NO-SIMD128-FAST:         .functype pmin_int_v4f32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push1=, $5
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push0=, $1
; NO-SIMD128-FAST-NEXT:    f32.lt $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $5, $1, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push5=, $6
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push4=, $2
; NO-SIMD128-FAST-NEXT:    f32.lt $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $6, $2, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop7
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push9=, $7
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push8=, $3
; NO-SIMD128-FAST-NEXT:    f32.lt $push10=, $pop9, $pop8
; NO-SIMD128-FAST-NEXT:    i32.select $push11=, $7, $3, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push16=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push13=, $8
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push12=, $4
; NO-SIMD128-FAST-NEXT:    f32.lt $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.select $push15=, $8, $4, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop17), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %fx = bitcast <4 x i32> %x to <4 x float>
  %fy = bitcast <4 x i32> %y to <4 x float>
  %c = fcmp olt <4 x float> %fy, %fx
  %a = select <4 x i1> %c, <4 x i32> %y, <4 x i32> %x
  ret <4 x i32> %a
}

define <4 x float> @pmax_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: pmax_v4f32:
; SIMD128:         .functype pmax_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmax_v4f32:
; SIMD128-FAST:         .functype pmax_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmax_v4f32:
; NO-SIMD128:         .functype pmax_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.lt $push0=, $3, $7
; NO-SIMD128-NEXT:    f32.select $push1=, $7, $3, $pop0
; NO-SIMD128-NEXT:    f32.store 8($0), $pop1
; NO-SIMD128-NEXT:    f32.lt $push2=, $2, $6
; NO-SIMD128-NEXT:    f32.select $push3=, $6, $2, $pop2
; NO-SIMD128-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-NEXT:    f32.lt $push4=, $1, $5
; NO-SIMD128-NEXT:    f32.select $push5=, $5, $1, $pop4
; NO-SIMD128-NEXT:    f32.store 0($0), $pop5
; NO-SIMD128-NEXT:    i32.const $push8=, 12
; NO-SIMD128-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-NEXT:    f32.lt $push6=, $4, $8
; NO-SIMD128-NEXT:    f32.select $push7=, $8, $4, $pop6
; NO-SIMD128-NEXT:    f32.store 0($pop9), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmax_v4f32:
; NO-SIMD128-FAST:         .functype pmax_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.lt $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.select $push1=, $5, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.lt $push2=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.select $push3=, $6, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.lt $push4=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.select $push5=, $7, $3, $pop4
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop5
; NO-SIMD128-FAST-NEXT:    i32.const $push8=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push9=, $0, $pop8
; NO-SIMD128-FAST-NEXT:    f32.lt $push6=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.select $push7=, $8, $4, $pop6
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop9), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp olt <4 x float> %x, %y
  %a = select <4 x i1> %c, <4 x float> %y, <4 x float> %x
  ret <4 x float> %a
}

define <4 x i32> @pmax_int_v4f32(<4 x i32> %x, <4 x i32> %y) {
; SIMD128-LABEL: pmax_int_v4f32:
; SIMD128:         .functype pmax_int_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmax_int_v4f32:
; SIMD128-FAST:         .functype pmax_int_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.pmax $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmax_int_v4f32:
; NO-SIMD128:         .functype pmax_int_v4f32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push1=, $4
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push0=, $8
; NO-SIMD128-NEXT:    f32.lt $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i32.select $push3=, $8, $4, $pop2
; NO-SIMD128-NEXT:    i32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push7=, $3
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push6=, $7
; NO-SIMD128-NEXT:    f32.lt $push8=, $pop7, $pop6
; NO-SIMD128-NEXT:    i32.select $push9=, $7, $3, $pop8
; NO-SIMD128-NEXT:    i32.store 8($0), $pop9
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push11=, $2
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push10=, $6
; NO-SIMD128-NEXT:    f32.lt $push12=, $pop11, $pop10
; NO-SIMD128-NEXT:    i32.select $push13=, $6, $2, $pop12
; NO-SIMD128-NEXT:    i32.store 4($0), $pop13
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push15=, $1
; NO-SIMD128-NEXT:    f32.reinterpret_i32 $push14=, $5
; NO-SIMD128-NEXT:    f32.lt $push16=, $pop15, $pop14
; NO-SIMD128-NEXT:    i32.select $push17=, $5, $1, $pop16
; NO-SIMD128-NEXT:    i32.store 0($0), $pop17
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmax_int_v4f32:
; NO-SIMD128-FAST:         .functype pmax_int_v4f32 (i32, i32, i32, i32, i32, i32, i32, i32, i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push1=, $1
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push0=, $5
; NO-SIMD128-FAST-NEXT:    f32.lt $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i32.select $push3=, $5, $1, $pop2
; NO-SIMD128-FAST-NEXT:    i32.store 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push5=, $2
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push4=, $6
; NO-SIMD128-FAST-NEXT:    f32.lt $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i32.select $push7=, $6, $2, $pop6
; NO-SIMD128-FAST-NEXT:    i32.store 4($0), $pop7
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push9=, $3
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push8=, $7
; NO-SIMD128-FAST-NEXT:    f32.lt $push10=, $pop9, $pop8
; NO-SIMD128-FAST-NEXT:    i32.select $push11=, $7, $3, $pop10
; NO-SIMD128-FAST-NEXT:    i32.store 8($0), $pop11
; NO-SIMD128-FAST-NEXT:    i32.const $push16=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push17=, $0, $pop16
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push13=, $4
; NO-SIMD128-FAST-NEXT:    f32.reinterpret_i32 $push12=, $8
; NO-SIMD128-FAST-NEXT:    f32.lt $push14=, $pop13, $pop12
; NO-SIMD128-FAST-NEXT:    i32.select $push15=, $8, $4, $pop14
; NO-SIMD128-FAST-NEXT:    i32.store 0($pop17), $pop15
; NO-SIMD128-FAST-NEXT:    return
  %fx = bitcast <4 x i32> %x to <4 x float>
  %fy = bitcast <4 x i32> %y to <4 x float>
  %c = fcmp olt <4 x float> %fx, %fy
  %a = select <4 x i1> %c, <4 x i32> %y, <4 x i32> %x
  ret <4 x i32> %a
}

define <4 x float> @add_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: add_v4f32:
; SIMD128:         .functype add_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.add $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: add_v4f32:
; SIMD128-FAST:         .functype add_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.add $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: add_v4f32:
; NO-SIMD128:         .functype add_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.add $push0=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop0
; NO-SIMD128-NEXT:    f32.add $push1=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-NEXT:    f32.add $push2=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    f32.add $push3=, $4, $8
; NO-SIMD128-NEXT:    f32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: add_v4f32:
; NO-SIMD128-FAST:         .functype add_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.add $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.add $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.add $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    f32.add $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = fadd <4 x float> %x, %y
  ret <4 x float> %a
}

define <4 x float> @sub_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: sub_v4f32:
; SIMD128:         .functype sub_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.sub $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sub_v4f32:
; SIMD128-FAST:         .functype sub_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.sub $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sub_v4f32:
; NO-SIMD128:         .functype sub_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.sub $push0=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop0
; NO-SIMD128-NEXT:    f32.sub $push1=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-NEXT:    f32.sub $push2=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    f32.sub $push3=, $4, $8
; NO-SIMD128-NEXT:    f32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sub_v4f32:
; NO-SIMD128-FAST:         .functype sub_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.sub $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.sub $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.sub $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    f32.sub $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = fsub <4 x float> %x, %y
  ret <4 x float> %a
}

define <4 x float> @div_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: div_v4f32:
; SIMD128:         .functype div_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.div $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: div_v4f32:
; SIMD128-FAST:         .functype div_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.div $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: div_v4f32:
; NO-SIMD128:         .functype div_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.div $push0=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop0
; NO-SIMD128-NEXT:    f32.div $push1=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-NEXT:    f32.div $push2=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    f32.div $push3=, $4, $8
; NO-SIMD128-NEXT:    f32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: div_v4f32:
; NO-SIMD128-FAST:         .functype div_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.div $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.div $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.div $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    f32.div $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = fdiv <4 x float> %x, %y
  ret <4 x float> %a
}

define <4 x float> @mul_v4f32(<4 x float> %x, <4 x float> %y) {
; SIMD128-LABEL: mul_v4f32:
; SIMD128:         .functype mul_v4f32 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.mul $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: mul_v4f32:
; SIMD128-FAST:         .functype mul_v4f32 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.mul $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: mul_v4f32:
; NO-SIMD128:         .functype mul_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.mul $push0=, $3, $7
; NO-SIMD128-NEXT:    f32.store 8($0), $pop0
; NO-SIMD128-NEXT:    f32.mul $push1=, $2, $6
; NO-SIMD128-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-NEXT:    f32.mul $push2=, $1, $5
; NO-SIMD128-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push4=, 12
; NO-SIMD128-NEXT:    i32.add $push5=, $0, $pop4
; NO-SIMD128-NEXT:    f32.mul $push3=, $4, $8
; NO-SIMD128-NEXT:    f32.store 0($pop5), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: mul_v4f32:
; NO-SIMD128-FAST:         .functype mul_v4f32 (i32, f32, f32, f32, f32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.mul $push0=, $1, $5
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.mul $push1=, $2, $6
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.mul $push2=, $3, $7
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    f32.mul $push5=, $4, $8
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = fmul <4 x float> %x, %y
  ret <4 x float> %a
}

declare <4 x float> @llvm.sqrt.v4f32(<4 x float> %x)
define <4 x float> @sqrt_v4f32(<4 x float> %x) {
; SIMD128-LABEL: sqrt_v4f32:
; SIMD128:         .functype sqrt_v4f32 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f32x4.sqrt $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sqrt_v4f32:
; SIMD128-FAST:         .functype sqrt_v4f32 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f32x4.sqrt $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sqrt_v4f32:
; NO-SIMD128:         .functype sqrt_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f32.sqrt $push0=, $3
; NO-SIMD128-NEXT:    f32.store 8($0), $pop0
; NO-SIMD128-NEXT:    f32.sqrt $push1=, $2
; NO-SIMD128-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-NEXT:    f32.sqrt $push2=, $1
; NO-SIMD128-NEXT:    f32.store 0($0), $pop2
; NO-SIMD128-NEXT:    i32.const $push3=, 12
; NO-SIMD128-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-NEXT:    f32.sqrt $push5=, $4
; NO-SIMD128-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sqrt_v4f32:
; NO-SIMD128-FAST:         .functype sqrt_v4f32 (i32, f32, f32, f32, f32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f32.sqrt $push0=, $1
; NO-SIMD128-FAST-NEXT:    f32.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f32.sqrt $push1=, $2
; NO-SIMD128-FAST-NEXT:    f32.store 4($0), $pop1
; NO-SIMD128-FAST-NEXT:    f32.sqrt $push2=, $3
; NO-SIMD128-FAST-NEXT:    f32.store 8($0), $pop2
; NO-SIMD128-FAST-NEXT:    i32.const $push3=, 12
; NO-SIMD128-FAST-NEXT:    i32.add $push4=, $0, $pop3
; NO-SIMD128-FAST-NEXT:    f32.sqrt $push5=, $4
; NO-SIMD128-FAST-NEXT:    f32.store 0($pop4), $pop5
; NO-SIMD128-FAST-NEXT:    return
  %a = call <4 x float> @llvm.sqrt.v4f32(<4 x float> %x)
  ret <4 x float> %a
}

; ==============================================================================
; 2 x double
; ==============================================================================
define <2 x double> @neg_v2f64(<2 x double> %x) {
  ; nsz makes this semantically equivalent to flipping sign bit
; SIMD128-LABEL: neg_v2f64:
; SIMD128:         .functype neg_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.neg $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: neg_v2f64:
; SIMD128-FAST:         .functype neg_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.neg $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: neg_v2f64:
; NO-SIMD128:         .functype neg_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.neg $push0=, $2
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.neg $push1=, $1
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: neg_v2f64:
; NO-SIMD128-FAST:         .functype neg_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.neg $push0=, $1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.neg $push1=, $2
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = fsub nsz <2 x double> <double 0., double 0.>, %x
  ret <2 x double> %a
}

declare <2 x double> @llvm.fabs.v2f64(<2 x double>) nounwind readnone
define <2 x double> @abs_v2f64(<2 x double> %x) {
; SIMD128-LABEL: abs_v2f64:
; SIMD128:         .functype abs_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.abs $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: abs_v2f64:
; SIMD128-FAST:         .functype abs_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.abs $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: abs_v2f64:
; NO-SIMD128:         .functype abs_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.abs $push0=, $2
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.abs $push1=, $1
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: abs_v2f64:
; NO-SIMD128-FAST:         .functype abs_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.abs $push0=, $1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.abs $push1=, $2
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <2 x double> @llvm.fabs.v2f64(<2 x double> %x)
  ret <2 x double> %a
}

define <2 x double> @min_unordered_v2f64(<2 x double> %x) {
; SIMD128-LABEL: min_unordered_v2f64:
; SIMD128:         .functype min_unordered_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f64x2.pmin $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: min_unordered_v2f64:
; SIMD128-FAST:         .functype min_unordered_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f64x2.pmin $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_unordered_v2f64:
; NO-SIMD128:         .functype min_unordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.gt $push1=, $2, $pop7
; NO-SIMD128-NEXT:    f64.select $push2=, $pop0, $2, $pop1
; NO-SIMD128-NEXT:    f64.store 8($0), $pop2
; NO-SIMD128-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.gt $push3=, $1, $pop5
; NO-SIMD128-NEXT:    f64.select $push4=, $pop6, $1, $pop3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_unordered_v2f64:
; NO-SIMD128-FAST:         .functype min_unordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.gt $push1=, $1, $pop7
; NO-SIMD128-FAST-NEXT:    f64.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.gt $push3=, $2, $pop5
; NO-SIMD128-FAST-NEXT:    f64.select $push4=, $pop6, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp ule <2 x double> %x, <double 5., double 5.>
  %a = select <2 x i1> %cmps, <2 x double> %x,
    <2 x double> <double 5., double 5.>
  ret <2 x double> %a
}

define <2 x double> @max_unordered_v2f64(<2 x double> %x) {
; SIMD128-LABEL: max_unordered_v2f64:
; SIMD128:         .functype max_unordered_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f64x2.pmax $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: max_unordered_v2f64:
; SIMD128-FAST:         .functype max_unordered_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f64x2.pmax $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_unordered_v2f64:
; NO-SIMD128:         .functype max_unordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.lt $push1=, $2, $pop7
; NO-SIMD128-NEXT:    f64.select $push2=, $pop0, $2, $pop1
; NO-SIMD128-NEXT:    f64.store 8($0), $pop2
; NO-SIMD128-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.lt $push3=, $1, $pop5
; NO-SIMD128-NEXT:    f64.select $push4=, $pop6, $1, $pop3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_unordered_v2f64:
; NO-SIMD128-FAST:         .functype max_unordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.lt $push1=, $1, $pop7
; NO-SIMD128-FAST-NEXT:    f64.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.lt $push3=, $2, $pop5
; NO-SIMD128-FAST-NEXT:    f64.select $push4=, $pop6, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp uge <2 x double> %x, <double 5., double 5.>
  %a = select <2 x i1> %cmps, <2 x double> %x,
    <2 x double> <double 5., double 5.>
  ret <2 x double> %a
}

define <2 x double> @min_ordered_v2f64(<2 x double> %x) {
; SIMD128-LABEL: min_ordered_v2f64:
; SIMD128:         .functype min_ordered_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f64x2.pmin $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: min_ordered_v2f64:
; SIMD128-FAST:         .functype min_ordered_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f64x2.pmin $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_ordered_v2f64:
; NO-SIMD128:         .functype min_ordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.ge $push1=, $2, $pop7
; NO-SIMD128-NEXT:    f64.select $push2=, $pop0, $2, $pop1
; NO-SIMD128-NEXT:    f64.store 8($0), $pop2
; NO-SIMD128-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.ge $push3=, $1, $pop5
; NO-SIMD128-NEXT:    f64.select $push4=, $pop6, $1, $pop3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_ordered_v2f64:
; NO-SIMD128-FAST:         .functype min_ordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.ge $push1=, $1, $pop7
; NO-SIMD128-FAST-NEXT:    f64.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.ge $push3=, $2, $pop5
; NO-SIMD128-FAST-NEXT:    f64.select $push4=, $pop6, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp ole <2 x double> <double 5., double 5.>, %x
  %a = select <2 x i1> %cmps, <2 x double> <double 5., double 5.>,
    <2 x double> %x
  ret <2 x double> %a
}

define <2 x double> @max_ordered_v2f64(<2 x double> %x) {
; SIMD128-LABEL: max_ordered_v2f64:
; SIMD128:         .functype max_ordered_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    f64x2.pmax $push1=, $0, $pop0
; SIMD128-NEXT:    return $pop1
;
; SIMD128-FAST-LABEL: max_ordered_v2f64:
; SIMD128-FAST:         .functype max_ordered_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push1=, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    f64x2.pmax $push0=, $0, $pop1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_ordered_v2f64:
; NO-SIMD128:         .functype max_ordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.le $push1=, $2, $pop7
; NO-SIMD128-NEXT:    f64.select $push2=, $pop0, $2, $pop1
; NO-SIMD128-NEXT:    f64.store 8($0), $pop2
; NO-SIMD128-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-NEXT:    f64.le $push3=, $1, $pop5
; NO-SIMD128-NEXT:    f64.select $push4=, $pop6, $1, $pop3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop4
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_ordered_v2f64:
; NO-SIMD128-FAST:         .functype max_ordered_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.const $push0=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push7=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.le $push1=, $1, $pop7
; NO-SIMD128-FAST-NEXT:    f64.select $push2=, $pop0, $1, $pop1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop2
; NO-SIMD128-FAST-NEXT:    f64.const $push6=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.const $push5=, 0x1.4p2
; NO-SIMD128-FAST-NEXT:    f64.le $push3=, $2, $pop5
; NO-SIMD128-FAST-NEXT:    f64.select $push4=, $pop6, $2, $pop3
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop4
; NO-SIMD128-FAST-NEXT:    return
  %cmps = fcmp oge <2 x double> <double 5., double 5.>, %x
  %a = select <2 x i1> %cmps, <2 x double> <double 5., double 5.>,
    <2 x double> %x
  ret <2 x double> %a
}

declare <2 x double> @llvm.minimum.v2f64(<2 x double>, <2 x double>)
define <2 x double> @min_intrinsic_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: min_intrinsic_v2f64:
; SIMD128:         .functype min_intrinsic_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.min $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_intrinsic_v2f64:
; SIMD128-FAST:         .functype min_intrinsic_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.min $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_intrinsic_v2f64:
; NO-SIMD128:         .functype min_intrinsic_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.min $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.min $push1=, $1, $3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_intrinsic_v2f64:
; NO-SIMD128-FAST:         .functype min_intrinsic_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.min $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.min $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <2 x double> @llvm.minimum.v2f64(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %a
}

declare <2 x double> @llvm.maximum.v2f64(<2 x double>, <2 x double>)
define <2 x double> @max_intrinsic_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: max_intrinsic_v2f64:
; SIMD128:         .functype max_intrinsic_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.max $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_intrinsic_v2f64:
; SIMD128-FAST:         .functype max_intrinsic_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.max $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_intrinsic_v2f64:
; NO-SIMD128:         .functype max_intrinsic_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.max $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.max $push1=, $1, $3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_intrinsic_v2f64:
; NO-SIMD128-FAST:         .functype max_intrinsic_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.max $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.max $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <2 x double> @llvm.maximum.v2f64(<2 x double> %x, <2 x double> %y)
  ret <2 x double> %a
}

define <2 x double> @min_const_intrinsic_v2f64() {
; SIMD128-LABEL: min_const_intrinsic_v2f64:
; SIMD128:         .functype min_const_intrinsic_v2f64 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: min_const_intrinsic_v2f64:
; SIMD128-FAST:         .functype min_const_intrinsic_v2f64 () -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push0=, 0x1.4p2, 0x1.4p2
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: min_const_intrinsic_v2f64:
; NO-SIMD128:         .functype min_const_intrinsic_v2f64 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 4617315517961601024
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 4617315517961601024
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: min_const_intrinsic_v2f64:
; NO-SIMD128-FAST:         .functype min_const_intrinsic_v2f64 (i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 4617315517961601024
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.const $push1=, 4617315517961601024
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <2 x double> @llvm.minimum.v2f64(
    <2 x double> <double 42., double 42.>,
    <2 x double> <double 5., double 5.>
  )
  ret <2 x double> %a
}

define <2 x double> @max_const_intrinsic_v2f64() {
; SIMD128-LABEL: max_const_intrinsic_v2f64:
; SIMD128:         .functype max_const_intrinsic_v2f64 () -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    v128.const $push0=, 0x1.5p5, 0x1.5p5
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: max_const_intrinsic_v2f64:
; SIMD128-FAST:         .functype max_const_intrinsic_v2f64 () -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    v128.const $push0=, 0x1.5p5, 0x1.5p5
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: max_const_intrinsic_v2f64:
; NO-SIMD128:         .functype max_const_intrinsic_v2f64 (i32) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    i64.const $push0=, 4631107791820423168
; NO-SIMD128-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-NEXT:    i64.const $push1=, 4631107791820423168
; NO-SIMD128-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: max_const_intrinsic_v2f64:
; NO-SIMD128-FAST:         .functype max_const_intrinsic_v2f64 (i32) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    i64.const $push0=, 4631107791820423168
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop0
; NO-SIMD128-FAST-NEXT:    i64.const $push1=, 4631107791820423168
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <2 x double> @llvm.maximum.v2f64(
    <2 x double> <double 42., double 42.>,
    <2 x double> <double 5., double 5.>
  )
  ret <2 x double> %a
}

define <2 x double> @pmin_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: pmin_v2f64:
; SIMD128:         .functype pmin_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.pmin $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmin_v2f64:
; SIMD128-FAST:         .functype pmin_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.pmin $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmin_v2f64:
; NO-SIMD128:         .functype pmin_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.lt $push0=, $4, $2
; NO-SIMD128-NEXT:    f64.select $push1=, $4, $2, $pop0
; NO-SIMD128-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-NEXT:    f64.lt $push2=, $3, $1
; NO-SIMD128-NEXT:    f64.select $push3=, $3, $1, $pop2
; NO-SIMD128-NEXT:    f64.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmin_v2f64:
; NO-SIMD128-FAST:         .functype pmin_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.lt $push0=, $3, $1
; NO-SIMD128-FAST-NEXT:    f64.select $push1=, $3, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f64.lt $push2=, $4, $2
; NO-SIMD128-FAST-NEXT:    f64.select $push3=, $4, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp olt <2 x double> %y, %x
  %a = select <2 x i1> %c, <2 x double> %y, <2 x double> %x
  ret <2 x double> %a
}

define <2 x i64> @pmin_int_v2f64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: pmin_int_v2f64:
; SIMD128:         .functype pmin_int_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.pmin $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmin_int_v2f64:
; SIMD128-FAST:         .functype pmin_int_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.pmin $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmin_int_v2f64:
; NO-SIMD128:         .functype pmin_int_v2f64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push1=, $4
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push0=, $2
; NO-SIMD128-NEXT:    f64.lt $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i64.select $push3=, $4, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop3
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push5=, $3
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push4=, $1
; NO-SIMD128-NEXT:    f64.lt $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i64.select $push7=, $3, $1, $pop6
; NO-SIMD128-NEXT:    i64.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmin_int_v2f64:
; NO-SIMD128-FAST:         .functype pmin_int_v2f64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push1=, $3
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push0=, $1
; NO-SIMD128-FAST-NEXT:    f64.lt $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.select $push3=, $3, $1, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push5=, $4
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push4=, $2
; NO-SIMD128-FAST-NEXT:    f64.lt $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i64.select $push7=, $4, $2, $pop6
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %fx = bitcast <2 x i64> %x to <2 x double>
  %fy = bitcast <2 x i64> %y to <2 x double>
  %c = fcmp olt <2 x double> %fy, %fx
  %a = select <2 x i1> %c, <2 x i64> %y, <2 x i64> %x
  ret <2 x i64> %a
}

define <2 x double> @pmax_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: pmax_v2f64:
; SIMD128:         .functype pmax_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.pmax $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmax_v2f64:
; SIMD128-FAST:         .functype pmax_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.pmax $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmax_v2f64:
; NO-SIMD128:         .functype pmax_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.lt $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.select $push1=, $4, $2, $pop0
; NO-SIMD128-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-NEXT:    f64.lt $push2=, $1, $3
; NO-SIMD128-NEXT:    f64.select $push3=, $3, $1, $pop2
; NO-SIMD128-NEXT:    f64.store 0($0), $pop3
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmax_v2f64:
; NO-SIMD128-FAST:         .functype pmax_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.lt $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.select $push1=, $3, $1, $pop0
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-FAST-NEXT:    f64.lt $push2=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.select $push3=, $4, $2, $pop2
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop3
; NO-SIMD128-FAST-NEXT:    return
  %c = fcmp olt <2 x double> %x, %y
  %a = select <2 x i1> %c, <2 x double> %y, <2 x double> %x
  ret <2 x double> %a
}

define <2 x i64> @pmax_int_v2f64(<2 x i64> %x, <2 x i64> %y) {
; SIMD128-LABEL: pmax_int_v2f64:
; SIMD128:         .functype pmax_int_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.pmax $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: pmax_int_v2f64:
; SIMD128-FAST:         .functype pmax_int_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.pmax $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: pmax_int_v2f64:
; NO-SIMD128:         .functype pmax_int_v2f64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push1=, $2
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push0=, $4
; NO-SIMD128-NEXT:    f64.lt $push2=, $pop1, $pop0
; NO-SIMD128-NEXT:    i64.select $push3=, $4, $2, $pop2
; NO-SIMD128-NEXT:    i64.store 8($0), $pop3
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push5=, $1
; NO-SIMD128-NEXT:    f64.reinterpret_i64 $push4=, $3
; NO-SIMD128-NEXT:    f64.lt $push6=, $pop5, $pop4
; NO-SIMD128-NEXT:    i64.select $push7=, $3, $1, $pop6
; NO-SIMD128-NEXT:    i64.store 0($0), $pop7
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: pmax_int_v2f64:
; NO-SIMD128-FAST:         .functype pmax_int_v2f64 (i32, i64, i64, i64, i64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push1=, $1
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push0=, $3
; NO-SIMD128-FAST-NEXT:    f64.lt $push2=, $pop1, $pop0
; NO-SIMD128-FAST-NEXT:    i64.select $push3=, $3, $1, $pop2
; NO-SIMD128-FAST-NEXT:    i64.store 0($0), $pop3
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push5=, $2
; NO-SIMD128-FAST-NEXT:    f64.reinterpret_i64 $push4=, $4
; NO-SIMD128-FAST-NEXT:    f64.lt $push6=, $pop5, $pop4
; NO-SIMD128-FAST-NEXT:    i64.select $push7=, $4, $2, $pop6
; NO-SIMD128-FAST-NEXT:    i64.store 8($0), $pop7
; NO-SIMD128-FAST-NEXT:    return
  %fx = bitcast <2 x i64> %x to <2 x double>
  %fy = bitcast <2 x i64> %y to <2 x double>
  %c = fcmp olt <2 x double> %fx, %fy
  %a = select <2 x i1> %c, <2 x i64> %y, <2 x i64> %x
  ret <2 x i64> %a
}

define <2 x double> @add_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: add_v2f64:
; SIMD128:         .functype add_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.add $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: add_v2f64:
; SIMD128-FAST:         .functype add_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.add $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: add_v2f64:
; NO-SIMD128:         .functype add_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.add $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.add $push1=, $1, $3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: add_v2f64:
; NO-SIMD128-FAST:         .functype add_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.add $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.add $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = fadd <2 x double> %x, %y
  ret <2 x double> %a
}

define <2 x double> @sub_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: sub_v2f64:
; SIMD128:         .functype sub_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.sub $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sub_v2f64:
; SIMD128-FAST:         .functype sub_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.sub $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sub_v2f64:
; NO-SIMD128:         .functype sub_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.sub $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.sub $push1=, $1, $3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sub_v2f64:
; NO-SIMD128-FAST:         .functype sub_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.sub $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.sub $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = fsub <2 x double> %x, %y
  ret <2 x double> %a
}

define <2 x double> @div_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: div_v2f64:
; SIMD128:         .functype div_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.div $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: div_v2f64:
; SIMD128-FAST:         .functype div_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.div $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: div_v2f64:
; NO-SIMD128:         .functype div_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.div $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.div $push1=, $1, $3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: div_v2f64:
; NO-SIMD128-FAST:         .functype div_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.div $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.div $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = fdiv <2 x double> %x, %y
  ret <2 x double> %a
}

define <2 x double> @mul_v2f64(<2 x double> %x, <2 x double> %y) {
; SIMD128-LABEL: mul_v2f64:
; SIMD128:         .functype mul_v2f64 (v128, v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.mul $push0=, $0, $1
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: mul_v2f64:
; SIMD128-FAST:         .functype mul_v2f64 (v128, v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.mul $push0=, $0, $1
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: mul_v2f64:
; NO-SIMD128:         .functype mul_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.mul $push0=, $2, $4
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.mul $push1=, $1, $3
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: mul_v2f64:
; NO-SIMD128-FAST:         .functype mul_v2f64 (i32, f64, f64, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.mul $push0=, $1, $3
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.mul $push1=, $2, $4
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = fmul <2 x double> %x, %y
  ret <2 x double> %a
}

declare <2 x double> @llvm.sqrt.v2f64(<2 x double> %x)
define <2 x double> @sqrt_v2f64(<2 x double> %x) {
; SIMD128-LABEL: sqrt_v2f64:
; SIMD128:         .functype sqrt_v2f64 (v128) -> (v128)
; SIMD128-NEXT:  # %bb.0:
; SIMD128-NEXT:    f64x2.sqrt $push0=, $0
; SIMD128-NEXT:    return $pop0
;
; SIMD128-FAST-LABEL: sqrt_v2f64:
; SIMD128-FAST:         .functype sqrt_v2f64 (v128) -> (v128)
; SIMD128-FAST-NEXT:  # %bb.0:
; SIMD128-FAST-NEXT:    f64x2.sqrt $push0=, $0
; SIMD128-FAST-NEXT:    return $pop0
;
; NO-SIMD128-LABEL: sqrt_v2f64:
; NO-SIMD128:         .functype sqrt_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-NEXT:  # %bb.0:
; NO-SIMD128-NEXT:    f64.sqrt $push0=, $2
; NO-SIMD128-NEXT:    f64.store 8($0), $pop0
; NO-SIMD128-NEXT:    f64.sqrt $push1=, $1
; NO-SIMD128-NEXT:    f64.store 0($0), $pop1
; NO-SIMD128-NEXT:    return
;
; NO-SIMD128-FAST-LABEL: sqrt_v2f64:
; NO-SIMD128-FAST:         .functype sqrt_v2f64 (i32, f64, f64) -> ()
; NO-SIMD128-FAST-NEXT:  # %bb.0:
; NO-SIMD128-FAST-NEXT:    f64.sqrt $push0=, $1
; NO-SIMD128-FAST-NEXT:    f64.store 0($0), $pop0
; NO-SIMD128-FAST-NEXT:    f64.sqrt $push1=, $2
; NO-SIMD128-FAST-NEXT:    f64.store 8($0), $pop1
; NO-SIMD128-FAST-NEXT:    return
  %a = call <2 x double> @llvm.sqrt.v2f64(<2 x double> %x)
  ret <2 x double> %a
}
