; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+zfhmin \
; RUN:   -verify-machineinstrs -target-abi ilp32f | \
; RUN:   FileCheck -check-prefix=RV32IZFHMIN %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+zfhmin \
; RUN:   -verify-machineinstrs -target-abi lp64f | \
; RUN:   FileCheck -check-prefix=RV64IZFHMIN %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+d \
; RUN:   -mattr=+zfhmin -verify-machineinstrs -target-abi ilp32d | \
; RUN:   FileCheck -check-prefix=RV32IDZFHMIN %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+d \
; RUN:   -mattr=+zfhmin -verify-machineinstrs -target-abi lp64d | \
; RUN:   FileCheck -check-prefix=RV64IDZFHMIN %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+zhinxmin \
; RUN:   -verify-machineinstrs -target-abi ilp32 | \
; RUN:   FileCheck -check-prefix=RV32IZHINXMIN %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+zhinxmin \
; RUN:   -verify-machineinstrs -target-abi lp64 | \
; RUN:   FileCheck -check-prefix=RV64IZHINXMIN %s
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+zdinx \
; RUN:   -mattr=+zhinxmin -verify-machineinstrs -target-abi ilp32 | \
; RUN:   FileCheck -check-prefix=RV32IZDINXZHINXMIN %s
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+zdinx \
; RUN:   -mattr=+zhinxmin -verify-machineinstrs -target-abi lp64 | \
; RUN:   FileCheck -check-prefix=RV64IZDINXZHINXMIN %s

; These intrinsics require half to be a legal type.

declare iXLen @llvm.lrint.iXLen.f16(half)

define iXLen @lrint_f16(half %a) nounwind {
; RV32IZFHMIN-LABEL: lrint_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: lrint_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5
; RV64IZFHMIN-NEXT:    ret
;
; RV32IDZFHMIN-LABEL: lrint_f16:
; RV32IDZFHMIN:       # %bb.0:
; RV32IDZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IDZFHMIN-NEXT:    fcvt.w.s a0, fa5
; RV32IDZFHMIN-NEXT:    ret
;
; RV64IDZFHMIN-LABEL: lrint_f16:
; RV64IDZFHMIN:       # %bb.0:
; RV64IDZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IDZFHMIN-NEXT:    fcvt.l.s a0, fa5
; RV64IDZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: lrint_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: lrint_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0
; RV64IZHINXMIN-NEXT:    ret
;
; RV32IZDINXZHINXMIN-LABEL: lrint_f16:
; RV32IZDINXZHINXMIN:       # %bb.0:
; RV32IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZDINXZHINXMIN-NEXT:    fcvt.w.s a0, a0
; RV32IZDINXZHINXMIN-NEXT:    ret
;
; RV64IZDINXZHINXMIN-LABEL: lrint_f16:
; RV64IZDINXZHINXMIN:       # %bb.0:
; RV64IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZDINXZHINXMIN-NEXT:    fcvt.l.s a0, a0
; RV64IZDINXZHINXMIN-NEXT:    ret
  %1 = call iXLen @llvm.lrint.iXLen.f16(half %a)
  ret iXLen %1
}

declare iXLen @llvm.lround.iXLen.f16(half)

define iXLen @lround_f16(half %a) nounwind {
; RV32IZFHMIN-LABEL: lround_f16:
; RV32IZFHMIN:       # %bb.0:
; RV32IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV32IZFHMIN-NEXT:    ret
;
; RV64IZFHMIN-LABEL: lround_f16:
; RV64IZFHMIN:       # %bb.0:
; RV64IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rmm
; RV64IZFHMIN-NEXT:    ret
;
; RV32IDZFHMIN-LABEL: lround_f16:
; RV32IDZFHMIN:       # %bb.0:
; RV32IDZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV32IDZFHMIN-NEXT:    fcvt.w.s a0, fa5, rmm
; RV32IDZFHMIN-NEXT:    ret
;
; RV64IDZFHMIN-LABEL: lround_f16:
; RV64IDZFHMIN:       # %bb.0:
; RV64IDZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; RV64IDZFHMIN-NEXT:    fcvt.l.s a0, fa5, rmm
; RV64IDZFHMIN-NEXT:    ret
;
; RV32IZHINXMIN-LABEL: lround_f16:
; RV32IZHINXMIN:       # %bb.0:
; RV32IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rmm
; RV32IZHINXMIN-NEXT:    ret
;
; RV64IZHINXMIN-LABEL: lround_f16:
; RV64IZHINXMIN:       # %bb.0:
; RV64IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rmm
; RV64IZHINXMIN-NEXT:    ret
;
; RV32IZDINXZHINXMIN-LABEL: lround_f16:
; RV32IZDINXZHINXMIN:       # %bb.0:
; RV32IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV32IZDINXZHINXMIN-NEXT:    fcvt.w.s a0, a0, rmm
; RV32IZDINXZHINXMIN-NEXT:    ret
;
; RV64IZDINXZHINXMIN-LABEL: lround_f16:
; RV64IZDINXZHINXMIN:       # %bb.0:
; RV64IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; RV64IZDINXZHINXMIN-NEXT:    fcvt.l.s a0, a0, rmm
; RV64IZDINXZHINXMIN-NEXT:    ret
  %1 = call iXLen @llvm.lround.iXLen.f16(half %a)
  ret iXLen %1
}
