; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs -filetype=obj < %s \
; RUN:   -o /dev/null 2>&1
; RUN: llc -mtriple=riscv32 -relocation-model=pic -verify-machineinstrs \
; RUN:   -filetype=obj < %s -o /dev/null 2>&1
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-RV32
; RUN: llc -mtriple=riscv32 -relocation-model=pic -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-RV32
; RUN: llc -mtriple=riscv64 -verify-machineinstrs -filetype=obj < %s \
; RUN:   -o /dev/null 2>&1
; RUN: llc -mtriple=riscv64 -relocation-model=pic -verify-machineinstrs \
; RUN:   -filetype=obj < %s -o /dev/null 2>&1
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-RV64
; RUN: llc -mtriple=riscv64 -relocation-model=pic -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=CHECK,CHECK-RV64

define void @relax_bcc(i1 %a) nounwind {
; CHECK-LABEL: relax_bcc:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    bnez a0, .LBB0_1
; CHECK-NEXT:    j .LBB0_2
; CHECK-NEXT:  .LBB0_1: # %iftrue
; CHECK-NEXT:    #APP
; CHECK-NEXT:    .zero 4096
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:  .LBB0_2: # %tail
; CHECK-NEXT:    ret
  br i1 %a, label %iftrue, label %tail

iftrue:
  call void asm sideeffect ".space 4096", ""()
  br label %tail

tail:
  ret void
}

define i32 @relax_jal(i1 %a) nounwind {
; CHECK-LABEL: relax_jal:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    andi a0, a0, 1
; CHECK-NEXT:    bnez a0, .LBB1_1
; CHECK-NEXT:  # %bb.4:
; CHECK-NEXT:    jump .LBB1_2, a0
; CHECK-NEXT:  .LBB1_1: # %iftrue
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    #APP
; CHECK-NEXT:    .zero 1048576
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:    j .LBB1_3
; CHECK-NEXT:  .LBB1_2: # %jmp
; CHECK-NEXT:    #APP
; CHECK-NEXT:    #NO_APP
; CHECK-NEXT:  .LBB1_3: # %tail
; CHECK-NEXT:    li a0, 1
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  br i1 %a, label %iftrue, label %jmp

jmp:
  call void asm sideeffect "", ""()
  br label %tail

iftrue:
  call void asm sideeffect "", ""()
  br label %space

space:
  call void asm sideeffect ".space 1048576", ""()
  br label %tail

tail:
  ret i32 1
}

; For functions whose names contain 32, only the CHECK-RV32 lines are
; meaningful, and for functions whose names contain 64, only the CHECK-RV64
; lines are meaningful.

define void @relax_jal_spill_32() {
; CHECK-RV32-LABEL: relax_jal_spill_32:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -64
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 64
; CHECK-RV32-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s1, 52(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s2, 48(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s3, 44(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s4, 40(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s5, 36(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s6, 32(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s7, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s8, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s9, 20(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s10, 16(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s11, 12(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    .cfi_offset ra, -4
; CHECK-RV32-NEXT:    .cfi_offset s0, -8
; CHECK-RV32-NEXT:    .cfi_offset s1, -12
; CHECK-RV32-NEXT:    .cfi_offset s2, -16
; CHECK-RV32-NEXT:    .cfi_offset s3, -20
; CHECK-RV32-NEXT:    .cfi_offset s4, -24
; CHECK-RV32-NEXT:    .cfi_offset s5, -28
; CHECK-RV32-NEXT:    .cfi_offset s6, -32
; CHECK-RV32-NEXT:    .cfi_offset s7, -36
; CHECK-RV32-NEXT:    .cfi_offset s8, -40
; CHECK-RV32-NEXT:    .cfi_offset s9, -44
; CHECK-RV32-NEXT:    .cfi_offset s10, -48
; CHECK-RV32-NEXT:    .cfi_offset s11, -52
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li ra, 1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t0, 5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t1, 6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t2, 7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s0, 8
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s1, 9
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a0, 10
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a1, 11
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a2, 12
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a3, 13
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a4, 14
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a5, 15
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a6, 16
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a7, 17
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s2, 18
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s3, 19
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s4, 20
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s5, 21
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s6, 22
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s7, 23
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s8, 24
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s9, 25
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s10, 26
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s11, 27
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t3, 28
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t4, 29
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t5, 30
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t6, 31
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    beq t5, t6, .LBB2_1
; CHECK-RV32-NEXT:  # %bb.3:
; CHECK-RV32-NEXT:    sw s11, 0(sp)
; CHECK-RV32-NEXT:    jump .LBB2_4, s11
; CHECK-RV32-NEXT:  .LBB2_1: # %branch_1
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    .zero 1048576
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    j .LBB2_2
; CHECK-RV32-NEXT:  .LBB2_4: # %branch_2
; CHECK-RV32-NEXT:    lw s11, 0(sp)
; CHECK-RV32-NEXT:  .LBB2_2: # %branch_2
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use ra
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s8
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s9
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s10
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s11
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s1, 52(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s2, 48(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s3, 44(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s4, 40(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s5, 36(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s6, 32(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s7, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s8, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s9, 20(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s10, 16(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s11, 12(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    addi sp, sp, 64
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: relax_jal_spill_32:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    addi sp, sp, -128
; CHECK-RV64-NEXT:    .cfi_def_cfa_offset 128
; CHECK-RV64-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s0, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s1, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s2, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s3, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s4, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s5, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s6, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s7, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s8, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s9, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s10, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s11, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    .cfi_offset ra, -8
; CHECK-RV64-NEXT:    .cfi_offset s0, -16
; CHECK-RV64-NEXT:    .cfi_offset s1, -24
; CHECK-RV64-NEXT:    .cfi_offset s2, -32
; CHECK-RV64-NEXT:    .cfi_offset s3, -40
; CHECK-RV64-NEXT:    .cfi_offset s4, -48
; CHECK-RV64-NEXT:    .cfi_offset s5, -56
; CHECK-RV64-NEXT:    .cfi_offset s6, -64
; CHECK-RV64-NEXT:    .cfi_offset s7, -72
; CHECK-RV64-NEXT:    .cfi_offset s8, -80
; CHECK-RV64-NEXT:    .cfi_offset s9, -88
; CHECK-RV64-NEXT:    .cfi_offset s10, -96
; CHECK-RV64-NEXT:    .cfi_offset s11, -104
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li ra, 1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t0, 5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t1, 6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t2, 7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s0, 8
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s1, 9
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a0, 10
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a1, 11
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a2, 12
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a3, 13
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a4, 14
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a5, 15
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a6, 16
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a7, 17
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s2, 18
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s3, 19
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s4, 20
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s5, 21
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s6, 22
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s7, 23
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s8, 24
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s9, 25
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s10, 26
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s11, 27
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t3, 28
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t4, 29
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t5, 30
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    sd t5, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sext.w t5, t5
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t6, 31
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    sd t6, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sext.w t6, t6
; CHECK-RV64-NEXT:    beq t5, t6, .LBB2_1
; CHECK-RV64-NEXT:  # %bb.3:
; CHECK-RV64-NEXT:    jump .LBB2_2, t5
; CHECK-RV64-NEXT:  .LBB2_1: # %branch_1
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    .zero 1048576
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:  .LBB2_2: # %branch_2
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use ra
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s8
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s9
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s10
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s11
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    ld t5, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    ld t6, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s0, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s1, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s2, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s3, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s4, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s5, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s6, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s7, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s8, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s9, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s10, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s11, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    addi sp, sp, 128
; CHECK-RV64-NEXT:    ret

  %ra = call i32 asm sideeffect "addi ra, x0, 1", "={ra}"()
  %t0 = call i32 asm sideeffect "addi t0, x0, 5", "={t0}"()
  %t1 = call i32 asm sideeffect "addi t1, x0, 6", "={t1}"()
  %t2 = call i32 asm sideeffect "addi t2, x0, 7", "={t2}"()
  %s0 = call i32 asm sideeffect "addi s0, x0, 8", "={s0}"()
  %s1 = call i32 asm sideeffect "addi s1, x0, 9", "={s1}"()
  %a0 = call i32 asm sideeffect "addi a0, x0, 10", "={a0}"()
  %a1 = call i32 asm sideeffect "addi a1, x0, 11", "={a1}"()
  %a2 = call i32 asm sideeffect "addi a2, x0, 12", "={a2}"()
  %a3 = call i32 asm sideeffect "addi a3, x0, 13", "={a3}"()
  %a4 = call i32 asm sideeffect "addi a4, x0, 14", "={a4}"()
  %a5 = call i32 asm sideeffect "addi a5, x0, 15", "={a5}"()
  %a6 = call i32 asm sideeffect "addi a6, x0, 16", "={a6}"()
  %a7 = call i32 asm sideeffect "addi a7, x0, 17", "={a7}"()
  %s2 = call i32 asm sideeffect "addi s2, x0, 18", "={s2}"()
  %s3 = call i32 asm sideeffect "addi s3, x0, 19", "={s3}"()
  %s4 = call i32 asm sideeffect "addi s4, x0, 20", "={s4}"()
  %s5 = call i32 asm sideeffect "addi s5, x0, 21", "={s5}"()
  %s6 = call i32 asm sideeffect "addi s6, x0, 22", "={s6}"()
  %s7 = call i32 asm sideeffect "addi s7, x0, 23", "={s7}"()
  %s8 = call i32 asm sideeffect "addi s8, x0, 24", "={s8}"()
  %s9 = call i32 asm sideeffect "addi s9, x0, 25", "={s9}"()
  %s10 = call i32 asm sideeffect "addi s10, x0, 26", "={s10}"()
  %s11 = call i32 asm sideeffect "addi s11, x0, 27", "={s11}"()
  %t3 = call i32 asm sideeffect "addi t3, x0, 28", "={t3}"()
  %t4 = call i32 asm sideeffect "addi t4, x0, 29", "={t4}"()
  %t5 = call i32 asm sideeffect "addi t5, x0, 30", "={t5}"()
  %t6 = call i32 asm sideeffect "addi t6, x0, 31", "={t6}"()

  %cmp = icmp eq i32 %t5, %t6
  br i1 %cmp, label %branch_1, label %branch_2

branch_1:
  call void asm sideeffect ".space 1048576", ""()
  br label %branch_2

branch_2:
  call void asm sideeffect "# reg use $0", "{ra}"(i32 %ra)
  call void asm sideeffect "# reg use $0", "{t0}"(i32 %t0)
  call void asm sideeffect "# reg use $0", "{t1}"(i32 %t1)
  call void asm sideeffect "# reg use $0", "{t2}"(i32 %t2)
  call void asm sideeffect "# reg use $0", "{s0}"(i32 %s0)
  call void asm sideeffect "# reg use $0", "{s1}"(i32 %s1)
  call void asm sideeffect "# reg use $0", "{a0}"(i32 %a0)
  call void asm sideeffect "# reg use $0", "{a1}"(i32 %a1)
  call void asm sideeffect "# reg use $0", "{a2}"(i32 %a2)
  call void asm sideeffect "# reg use $0", "{a3}"(i32 %a3)
  call void asm sideeffect "# reg use $0", "{a4}"(i32 %a4)
  call void asm sideeffect "# reg use $0", "{a5}"(i32 %a5)
  call void asm sideeffect "# reg use $0", "{a6}"(i32 %a6)
  call void asm sideeffect "# reg use $0", "{a7}"(i32 %a7)
  call void asm sideeffect "# reg use $0", "{s2}"(i32 %s2)
  call void asm sideeffect "# reg use $0", "{s3}"(i32 %s3)
  call void asm sideeffect "# reg use $0", "{s4}"(i32 %s4)
  call void asm sideeffect "# reg use $0", "{s5}"(i32 %s5)
  call void asm sideeffect "# reg use $0", "{s6}"(i32 %s6)
  call void asm sideeffect "# reg use $0", "{s7}"(i32 %s7)
  call void asm sideeffect "# reg use $0", "{s8}"(i32 %s8)
  call void asm sideeffect "# reg use $0", "{s9}"(i32 %s9)
  call void asm sideeffect "# reg use $0", "{s10}"(i32 %s10)
  call void asm sideeffect "# reg use $0", "{s11}"(i32 %s11)
  call void asm sideeffect "# reg use $0", "{t3}"(i32 %t3)
  call void asm sideeffect "# reg use $0", "{t4}"(i32 %t4)
  call void asm sideeffect "# reg use $0", "{t5}"(i32 %t5)
  call void asm sideeffect "# reg use $0", "{t6}"(i32 %t6)

  ret void
}

define void @relax_jal_spill_32_adjust_spill_slot() {
; CHECK-RV32-LABEL: relax_jal_spill_32_adjust_spill_slot:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -2032
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 2032
; CHECK-RV32-NEXT:    sw ra, 2028(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s0, 2024(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s1, 2020(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s2, 2016(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s3, 2012(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s4, 2008(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s5, 2004(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s6, 2000(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s7, 1996(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s8, 1992(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s9, 1988(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s10, 1984(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s11, 1980(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    .cfi_offset ra, -4
; CHECK-RV32-NEXT:    .cfi_offset s0, -8
; CHECK-RV32-NEXT:    .cfi_offset s1, -12
; CHECK-RV32-NEXT:    .cfi_offset s2, -16
; CHECK-RV32-NEXT:    .cfi_offset s3, -20
; CHECK-RV32-NEXT:    .cfi_offset s4, -24
; CHECK-RV32-NEXT:    .cfi_offset s5, -28
; CHECK-RV32-NEXT:    .cfi_offset s6, -32
; CHECK-RV32-NEXT:    .cfi_offset s7, -36
; CHECK-RV32-NEXT:    .cfi_offset s8, -40
; CHECK-RV32-NEXT:    .cfi_offset s9, -44
; CHECK-RV32-NEXT:    .cfi_offset s10, -48
; CHECK-RV32-NEXT:    .cfi_offset s11, -52
; CHECK-RV32-NEXT:    addi s0, sp, 2032
; CHECK-RV32-NEXT:    .cfi_def_cfa s0, 0
; CHECK-RV32-NEXT:    lui a0, 2
; CHECK-RV32-NEXT:    addi a0, a0, -2032
; CHECK-RV32-NEXT:    sub sp, sp, a0
; CHECK-RV32-NEXT:    srli a0, sp, 12
; CHECK-RV32-NEXT:    slli sp, a0, 12
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li ra, 1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t0, 5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t1, 6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t2, 7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s0, 8
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s1, 9
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a0, 10
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a1, 11
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a2, 12
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a3, 13
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a4, 14
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a5, 15
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a6, 16
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a7, 17
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s2, 18
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s3, 19
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s4, 20
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s5, 21
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s6, 22
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s7, 23
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s8, 24
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s9, 25
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s10, 26
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s11, 27
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t3, 28
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t4, 29
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t5, 30
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t6, 31
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    beq t5, t6, .LBB3_1
; CHECK-RV32-NEXT:  # %bb.3:
; CHECK-RV32-NEXT:    sw s11, 0(sp)
; CHECK-RV32-NEXT:    jump .LBB3_4, s11
; CHECK-RV32-NEXT:  .LBB3_1: # %branch_1
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    .zero 1048576
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    j .LBB3_2
; CHECK-RV32-NEXT:  .LBB3_4: # %branch_2
; CHECK-RV32-NEXT:    lw s11, 0(sp)
; CHECK-RV32-NEXT:  .LBB3_2: # %branch_2
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use ra
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s8
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s9
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s10
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s11
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 2
; CHECK-RV32-NEXT:    sub sp, s0, a0
; CHECK-RV32-NEXT:    addi a0, a0, -2032
; CHECK-RV32-NEXT:    add sp, sp, a0
; CHECK-RV32-NEXT:    lw ra, 2028(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s0, 2024(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s1, 2020(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s2, 2016(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s3, 2012(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s4, 2008(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s5, 2004(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s6, 2000(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s7, 1996(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s8, 1992(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s9, 1988(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s10, 1984(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s11, 1980(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    addi sp, sp, 2032
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: relax_jal_spill_32_adjust_spill_slot:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    addi sp, sp, -2032
; CHECK-RV64-NEXT:    .cfi_def_cfa_offset 2032
; CHECK-RV64-NEXT:    sd ra, 2024(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s0, 2016(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s1, 2008(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s2, 2000(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s3, 1992(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s4, 1984(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s5, 1976(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s6, 1968(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s7, 1960(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s8, 1952(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s9, 1944(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s10, 1936(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s11, 1928(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    .cfi_offset ra, -8
; CHECK-RV64-NEXT:    .cfi_offset s0, -16
; CHECK-RV64-NEXT:    .cfi_offset s1, -24
; CHECK-RV64-NEXT:    .cfi_offset s2, -32
; CHECK-RV64-NEXT:    .cfi_offset s3, -40
; CHECK-RV64-NEXT:    .cfi_offset s4, -48
; CHECK-RV64-NEXT:    .cfi_offset s5, -56
; CHECK-RV64-NEXT:    .cfi_offset s6, -64
; CHECK-RV64-NEXT:    .cfi_offset s7, -72
; CHECK-RV64-NEXT:    .cfi_offset s8, -80
; CHECK-RV64-NEXT:    .cfi_offset s9, -88
; CHECK-RV64-NEXT:    .cfi_offset s10, -96
; CHECK-RV64-NEXT:    .cfi_offset s11, -104
; CHECK-RV64-NEXT:    addi s0, sp, 2032
; CHECK-RV64-NEXT:    .cfi_def_cfa s0, 0
; CHECK-RV64-NEXT:    lui a0, 2
; CHECK-RV64-NEXT:    addiw a0, a0, -2032
; CHECK-RV64-NEXT:    sub sp, sp, a0
; CHECK-RV64-NEXT:    srli a0, sp, 12
; CHECK-RV64-NEXT:    slli sp, a0, 12
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li ra, 1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t0, 5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t1, 6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t2, 7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s0, 8
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s1, 9
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a0, 10
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a1, 11
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a2, 12
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a3, 13
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a4, 14
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a5, 15
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a6, 16
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a7, 17
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s2, 18
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s3, 19
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s4, 20
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s5, 21
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s6, 22
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s7, 23
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s8, 24
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s9, 25
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s10, 26
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s11, 27
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t3, 28
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t4, 29
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t5, 30
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    sd t0, 0(sp)
; CHECK-RV64-NEXT:    lui t0, 1
; CHECK-RV64-NEXT:    add t0, sp, t0
; CHECK-RV64-NEXT:    sd t5, -8(t0) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sext.w t5, t5
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t6, 31
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    lui t0, 1
; CHECK-RV64-NEXT:    add t0, sp, t0
; CHECK-RV64-NEXT:    sd t6, -16(t0) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    ld t0, 0(sp)
; CHECK-RV64-NEXT:    sext.w t6, t6
; CHECK-RV64-NEXT:    beq t5, t6, .LBB3_1
; CHECK-RV64-NEXT:  # %bb.3:
; CHECK-RV64-NEXT:    jump .LBB3_2, t5
; CHECK-RV64-NEXT:  .LBB3_1: # %branch_1
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    .zero 1048576
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:  .LBB3_2: # %branch_2
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use ra
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s8
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s9
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s10
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s11
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    lui a0, 1
; CHECK-RV64-NEXT:    add a0, sp, a0
; CHECK-RV64-NEXT:    ld t5, -8(a0) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    lui a0, 1
; CHECK-RV64-NEXT:    add a0, sp, a0
; CHECK-RV64-NEXT:    ld t6, -16(a0) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    lui a0, 2
; CHECK-RV64-NEXT:    sub sp, s0, a0
; CHECK-RV64-NEXT:    addiw a0, a0, -2032
; CHECK-RV64-NEXT:    add sp, sp, a0
; CHECK-RV64-NEXT:    ld ra, 2024(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s0, 2016(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s1, 2008(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s2, 2000(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s3, 1992(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s4, 1984(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s5, 1976(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s6, 1968(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s7, 1960(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s8, 1952(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s9, 1944(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s10, 1936(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s11, 1928(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    addi sp, sp, 2032
; CHECK-RV64-NEXT:    ret

  ; If the stack is large and the offset of BranchRelaxationScratchFrameIndex
  ; is out the range of 12-bit signed integer, check whether the spill slot is
  ; adjusted to close to the stack base register.
  %stack_obj = alloca i32, align 4096

  %ra = call i32 asm sideeffect "addi ra, x0, 1", "={ra}"()
  %t0 = call i32 asm sideeffect "addi t0, x0, 5", "={t0}"()
  %t1 = call i32 asm sideeffect "addi t1, x0, 6", "={t1}"()
  %t2 = call i32 asm sideeffect "addi t2, x0, 7", "={t2}"()
  %s0 = call i32 asm sideeffect "addi s0, x0, 8", "={s0}"()
  %s1 = call i32 asm sideeffect "addi s1, x0, 9", "={s1}"()
  %a0 = call i32 asm sideeffect "addi a0, x0, 10", "={a0}"()
  %a1 = call i32 asm sideeffect "addi a1, x0, 11", "={a1}"()
  %a2 = call i32 asm sideeffect "addi a2, x0, 12", "={a2}"()
  %a3 = call i32 asm sideeffect "addi a3, x0, 13", "={a3}"()
  %a4 = call i32 asm sideeffect "addi a4, x0, 14", "={a4}"()
  %a5 = call i32 asm sideeffect "addi a5, x0, 15", "={a5}"()
  %a6 = call i32 asm sideeffect "addi a6, x0, 16", "={a6}"()
  %a7 = call i32 asm sideeffect "addi a7, x0, 17", "={a7}"()
  %s2 = call i32 asm sideeffect "addi s2, x0, 18", "={s2}"()
  %s3 = call i32 asm sideeffect "addi s3, x0, 19", "={s3}"()
  %s4 = call i32 asm sideeffect "addi s4, x0, 20", "={s4}"()
  %s5 = call i32 asm sideeffect "addi s5, x0, 21", "={s5}"()
  %s6 = call i32 asm sideeffect "addi s6, x0, 22", "={s6}"()
  %s7 = call i32 asm sideeffect "addi s7, x0, 23", "={s7}"()
  %s8 = call i32 asm sideeffect "addi s8, x0, 24", "={s8}"()
  %s9 = call i32 asm sideeffect "addi s9, x0, 25", "={s9}"()
  %s10 = call i32 asm sideeffect "addi s10, x0, 26", "={s10}"()
  %s11 = call i32 asm sideeffect "addi s11, x0, 27", "={s11}"()
  %t3 = call i32 asm sideeffect "addi t3, x0, 28", "={t3}"()
  %t4 = call i32 asm sideeffect "addi t4, x0, 29", "={t4}"()
  %t5 = call i32 asm sideeffect "addi t5, x0, 30", "={t5}"()
  %t6 = call i32 asm sideeffect "addi t6, x0, 31", "={t6}"()

  %cmp = icmp eq i32 %t5, %t6
  br i1 %cmp, label %branch_1, label %branch_2

branch_1:
  call void asm sideeffect ".space 1048576", ""()
  br label %branch_2

branch_2:
  call void asm sideeffect "# reg use $0", "{ra}"(i32 %ra)
  call void asm sideeffect "# reg use $0", "{t0}"(i32 %t0)
  call void asm sideeffect "# reg use $0", "{t1}"(i32 %t1)
  call void asm sideeffect "# reg use $0", "{t2}"(i32 %t2)
  call void asm sideeffect "# reg use $0", "{s0}"(i32 %s0)
  call void asm sideeffect "# reg use $0", "{s1}"(i32 %s1)
  call void asm sideeffect "# reg use $0", "{a0}"(i32 %a0)
  call void asm sideeffect "# reg use $0", "{a1}"(i32 %a1)
  call void asm sideeffect "# reg use $0", "{a2}"(i32 %a2)
  call void asm sideeffect "# reg use $0", "{a3}"(i32 %a3)
  call void asm sideeffect "# reg use $0", "{a4}"(i32 %a4)
  call void asm sideeffect "# reg use $0", "{a5}"(i32 %a5)
  call void asm sideeffect "# reg use $0", "{a6}"(i32 %a6)
  call void asm sideeffect "# reg use $0", "{a7}"(i32 %a7)
  call void asm sideeffect "# reg use $0", "{s2}"(i32 %s2)
  call void asm sideeffect "# reg use $0", "{s3}"(i32 %s3)
  call void asm sideeffect "# reg use $0", "{s4}"(i32 %s4)
  call void asm sideeffect "# reg use $0", "{s5}"(i32 %s5)
  call void asm sideeffect "# reg use $0", "{s6}"(i32 %s6)
  call void asm sideeffect "# reg use $0", "{s7}"(i32 %s7)
  call void asm sideeffect "# reg use $0", "{s8}"(i32 %s8)
  call void asm sideeffect "# reg use $0", "{s9}"(i32 %s9)
  call void asm sideeffect "# reg use $0", "{s10}"(i32 %s10)
  call void asm sideeffect "# reg use $0", "{s11}"(i32 %s11)
  call void asm sideeffect "# reg use $0", "{t3}"(i32 %t3)
  call void asm sideeffect "# reg use $0", "{t4}"(i32 %t4)
  call void asm sideeffect "# reg use $0", "{t5}"(i32 %t5)
  call void asm sideeffect "# reg use $0", "{t6}"(i32 %t6)

  ret void
}

define void @relax_jal_spill_64() {
; CHECK-RV32-LABEL: relax_jal_spill_64:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -272
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 272
; CHECK-RV32-NEXT:    sw ra, 268(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s0, 264(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s1, 260(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s2, 256(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s3, 252(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s4, 248(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s5, 244(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s6, 240(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s7, 236(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s8, 232(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s9, 228(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s10, 224(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s11, 220(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    .cfi_offset ra, -4
; CHECK-RV32-NEXT:    .cfi_offset s0, -8
; CHECK-RV32-NEXT:    .cfi_offset s1, -12
; CHECK-RV32-NEXT:    .cfi_offset s2, -16
; CHECK-RV32-NEXT:    .cfi_offset s3, -20
; CHECK-RV32-NEXT:    .cfi_offset s4, -24
; CHECK-RV32-NEXT:    .cfi_offset s5, -28
; CHECK-RV32-NEXT:    .cfi_offset s6, -32
; CHECK-RV32-NEXT:    .cfi_offset s7, -36
; CHECK-RV32-NEXT:    .cfi_offset s8, -40
; CHECK-RV32-NEXT:    .cfi_offset s9, -44
; CHECK-RV32-NEXT:    .cfi_offset s10, -48
; CHECK-RV32-NEXT:    .cfi_offset s11, -52
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li ra, 1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t0, 5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw t0, 212(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t1, 216(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t1, 6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw t1, 204(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t2, 208(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t2, 7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw t2, 196(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t3, 200(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s0, 8
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw s0, 188(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s1, 192(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s1, 9
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw s1, 180(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s2, 184(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a0, 10
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw a1, 176(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a1, 11
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw a1, 168(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a2, 172(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a2, 12
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw a2, 160(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a3, 164(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a3, 13
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw a3, 152(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a4, 156(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a4, 14
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw a4, 144(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a5, 148(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a5, 15
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw a5, 136(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a6, 140(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a6, 16
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw a6, 128(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a7, 132(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a7, 17
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw a7, 120(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t0, 124(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s2, 18
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw s2, 112(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s3, 116(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s3, 19
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw s3, 104(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s4, 108(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s4, 20
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw s4, 96(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s5, 100(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s5, 21
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw s5, 88(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s6, 92(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s6, 22
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw s6, 80(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s7, 84(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s7, 23
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw s7, 72(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s8, 76(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s8, 24
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw s8, 64(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s9, 68(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s9, 25
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw s9, 56(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s10, 60(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s10, 26
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw s10, 48(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s11, 52(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s11, 27
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw s11, 44(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t3, 28
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw t3, 36(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t4, 40(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t4, 29
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    sw t4, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw t5, 32(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t5, 30
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    mv a1, t6
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t6, 31
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    mv a2, t6
; CHECK-RV32-NEXT:    mv t6, a1
; CHECK-RV32-NEXT:    sw s0, 20(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    xor a1, a1, s0
; CHECK-RV32-NEXT:    sw t5, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw a2, 16(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    xor a2, t5, a2
; CHECK-RV32-NEXT:    or a1, a2, a1
; CHECK-RV32-NEXT:    beqz a1, .LBB4_1
; CHECK-RV32-NEXT:  # %bb.3:
; CHECK-RV32-NEXT:    jump .LBB4_2, a1
; CHECK-RV32-NEXT:  .LBB4_1: # %branch_1
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    .zero 1048576
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:  .LBB4_2: # %branch_2
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use ra
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw t0, 212(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t1, 216(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw t1, 204(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t2, 208(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw t2, 196(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t3, 200(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw s0, 188(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s1, 192(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw s1, 180(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s2, 184(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw a1, 176(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw a1, 168(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a2, 172(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw a2, 160(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a3, 164(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw a3, 152(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a4, 156(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw a4, 144(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a5, 148(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw a5, 136(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a6, 140(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw a6, 128(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw a7, 132(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw a7, 120(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t0, 124(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw s2, 112(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s3, 116(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw s3, 104(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s4, 108(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw s4, 96(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s5, 100(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw s5, 88(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s6, 92(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw s6, 80(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s7, 84(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw s7, 72(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s8, 76(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw s8, 64(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s9, 68(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s8
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw s9, 56(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s10, 60(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s9
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw s10, 48(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s11, 52(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s10
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw s11, 44(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s11
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw t3, 36(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t4, 40(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw t4, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw t5, 32(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw t5, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw t6, 16(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s0, 20(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw ra, 268(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s0, 264(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s1, 260(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s2, 256(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s3, 252(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s4, 248(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s5, 244(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s6, 240(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s7, 236(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s8, 232(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s9, 228(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s10, 224(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s11, 220(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    addi sp, sp, 272
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: relax_jal_spill_64:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    addi sp, sp, -112
; CHECK-RV64-NEXT:    .cfi_def_cfa_offset 112
; CHECK-RV64-NEXT:    sd ra, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s0, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s1, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s2, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s3, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s4, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s5, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s6, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s7, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s8, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s9, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s10, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s11, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    .cfi_offset ra, -8
; CHECK-RV64-NEXT:    .cfi_offset s0, -16
; CHECK-RV64-NEXT:    .cfi_offset s1, -24
; CHECK-RV64-NEXT:    .cfi_offset s2, -32
; CHECK-RV64-NEXT:    .cfi_offset s3, -40
; CHECK-RV64-NEXT:    .cfi_offset s4, -48
; CHECK-RV64-NEXT:    .cfi_offset s5, -56
; CHECK-RV64-NEXT:    .cfi_offset s6, -64
; CHECK-RV64-NEXT:    .cfi_offset s7, -72
; CHECK-RV64-NEXT:    .cfi_offset s8, -80
; CHECK-RV64-NEXT:    .cfi_offset s9, -88
; CHECK-RV64-NEXT:    .cfi_offset s10, -96
; CHECK-RV64-NEXT:    .cfi_offset s11, -104
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li ra, 1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t0, 5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t1, 6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t2, 7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s0, 8
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s1, 9
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a0, 10
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a1, 11
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a2, 12
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a3, 13
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a4, 14
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a5, 15
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a6, 16
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a7, 17
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s2, 18
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s3, 19
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s4, 20
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s5, 21
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s6, 22
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s7, 23
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s8, 24
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s9, 25
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s10, 26
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s11, 27
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t3, 28
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t4, 29
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t5, 30
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t6, 31
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    beq t5, t6, .LBB4_1
; CHECK-RV64-NEXT:  # %bb.3:
; CHECK-RV64-NEXT:    sd s11, 0(sp)
; CHECK-RV64-NEXT:    jump .LBB4_4, s11
; CHECK-RV64-NEXT:  .LBB4_1: # %branch_1
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    .zero 1048576
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    j .LBB4_2
; CHECK-RV64-NEXT:  .LBB4_4: # %branch_2
; CHECK-RV64-NEXT:    ld s11, 0(sp)
; CHECK-RV64-NEXT:  .LBB4_2: # %branch_2
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use ra
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s8
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s9
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s10
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s11
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    ld ra, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s0, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s1, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s2, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s3, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s4, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s5, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s6, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s7, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s8, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s9, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s10, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s11, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    addi sp, sp, 112
; CHECK-RV64-NEXT:    ret

  %ra = call i64 asm sideeffect "addi ra, x0, 1", "={ra}"()
  %t0 = call i64 asm sideeffect "addi t0, x0, 5", "={t0}"()
  %t1 = call i64 asm sideeffect "addi t1, x0, 6", "={t1}"()
  %t2 = call i64 asm sideeffect "addi t2, x0, 7", "={t2}"()
  %s0 = call i64 asm sideeffect "addi s0, x0, 8", "={s0}"()
  %s1 = call i64 asm sideeffect "addi s1, x0, 9", "={s1}"()
  %a0 = call i64 asm sideeffect "addi a0, x0, 10", "={a0}"()
  %a1 = call i64 asm sideeffect "addi a1, x0, 11", "={a1}"()
  %a2 = call i64 asm sideeffect "addi a2, x0, 12", "={a2}"()
  %a3 = call i64 asm sideeffect "addi a3, x0, 13", "={a3}"()
  %a4 = call i64 asm sideeffect "addi a4, x0, 14", "={a4}"()
  %a5 = call i64 asm sideeffect "addi a5, x0, 15", "={a5}"()
  %a6 = call i64 asm sideeffect "addi a6, x0, 16", "={a6}"()
  %a7 = call i64 asm sideeffect "addi a7, x0, 17", "={a7}"()
  %s2 = call i64 asm sideeffect "addi s2, x0, 18", "={s2}"()
  %s3 = call i64 asm sideeffect "addi s3, x0, 19", "={s3}"()
  %s4 = call i64 asm sideeffect "addi s4, x0, 20", "={s4}"()
  %s5 = call i64 asm sideeffect "addi s5, x0, 21", "={s5}"()
  %s6 = call i64 asm sideeffect "addi s6, x0, 22", "={s6}"()
  %s7 = call i64 asm sideeffect "addi s7, x0, 23", "={s7}"()
  %s8 = call i64 asm sideeffect "addi s8, x0, 24", "={s8}"()
  %s9 = call i64 asm sideeffect "addi s9, x0, 25", "={s9}"()
  %s10 = call i64 asm sideeffect "addi s10, x0, 26", "={s10}"()
  %s11 = call i64 asm sideeffect "addi s11, x0, 27", "={s11}"()
  %t3 = call i64 asm sideeffect "addi t3, x0, 28", "={t3}"()
  %t4 = call i64 asm sideeffect "addi t4, x0, 29", "={t4}"()
  %t5 = call i64 asm sideeffect "addi t5, x0, 30", "={t5}"()
  %t6 = call i64 asm sideeffect "addi t6, x0, 31", "={t6}"()

  %cmp = icmp eq i64 %t5, %t6
  br i1 %cmp, label %branch_1, label %branch_2

branch_1:
  call void asm sideeffect ".space 1048576", ""()
  br label %branch_2

branch_2:
  call void asm sideeffect "# reg use $0", "{ra}"(i64 %ra)
  call void asm sideeffect "# reg use $0", "{t0}"(i64 %t0)
  call void asm sideeffect "# reg use $0", "{t1}"(i64 %t1)
  call void asm sideeffect "# reg use $0", "{t2}"(i64 %t2)
  call void asm sideeffect "# reg use $0", "{s0}"(i64 %s0)
  call void asm sideeffect "# reg use $0", "{s1}"(i64 %s1)
  call void asm sideeffect "# reg use $0", "{a0}"(i64 %a0)
  call void asm sideeffect "# reg use $0", "{a1}"(i64 %a1)
  call void asm sideeffect "# reg use $0", "{a2}"(i64 %a2)
  call void asm sideeffect "# reg use $0", "{a3}"(i64 %a3)
  call void asm sideeffect "# reg use $0", "{a4}"(i64 %a4)
  call void asm sideeffect "# reg use $0", "{a5}"(i64 %a5)
  call void asm sideeffect "# reg use $0", "{a6}"(i64 %a6)
  call void asm sideeffect "# reg use $0", "{a7}"(i64 %a7)
  call void asm sideeffect "# reg use $0", "{s2}"(i64 %s2)
  call void asm sideeffect "# reg use $0", "{s3}"(i64 %s3)
  call void asm sideeffect "# reg use $0", "{s4}"(i64 %s4)
  call void asm sideeffect "# reg use $0", "{s5}"(i64 %s5)
  call void asm sideeffect "# reg use $0", "{s6}"(i64 %s6)
  call void asm sideeffect "# reg use $0", "{s7}"(i64 %s7)
  call void asm sideeffect "# reg use $0", "{s8}"(i64 %s8)
  call void asm sideeffect "# reg use $0", "{s9}"(i64 %s9)
  call void asm sideeffect "# reg use $0", "{s10}"(i64 %s10)
  call void asm sideeffect "# reg use $0", "{s11}"(i64 %s11)
  call void asm sideeffect "# reg use $0", "{t3}"(i64 %t3)
  call void asm sideeffect "# reg use $0", "{t4}"(i64 %t4)
  call void asm sideeffect "# reg use $0", "{t5}"(i64 %t5)
  call void asm sideeffect "# reg use $0", "{t6}"(i64 %t6)

  ret void
}

define void @relax_jal_spill_64_adjust_spill_slot() {
; CHECK-RV32-LABEL: relax_jal_spill_64_adjust_spill_slot:
; CHECK-RV32:       # %bb.0:
; CHECK-RV32-NEXT:    addi sp, sp, -2032
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 2032
; CHECK-RV32-NEXT:    sw ra, 2028(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s0, 2024(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s1, 2020(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s2, 2016(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s3, 2012(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s4, 2008(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s5, 2004(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s6, 2000(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s7, 1996(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s8, 1992(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s9, 1988(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s10, 1984(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s11, 1980(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    .cfi_offset ra, -4
; CHECK-RV32-NEXT:    .cfi_offset s0, -8
; CHECK-RV32-NEXT:    .cfi_offset s1, -12
; CHECK-RV32-NEXT:    .cfi_offset s2, -16
; CHECK-RV32-NEXT:    .cfi_offset s3, -20
; CHECK-RV32-NEXT:    .cfi_offset s4, -24
; CHECK-RV32-NEXT:    .cfi_offset s5, -28
; CHECK-RV32-NEXT:    .cfi_offset s6, -32
; CHECK-RV32-NEXT:    .cfi_offset s7, -36
; CHECK-RV32-NEXT:    .cfi_offset s8, -40
; CHECK-RV32-NEXT:    .cfi_offset s9, -44
; CHECK-RV32-NEXT:    .cfi_offset s10, -48
; CHECK-RV32-NEXT:    .cfi_offset s11, -52
; CHECK-RV32-NEXT:    addi s0, sp, 2032
; CHECK-RV32-NEXT:    .cfi_def_cfa s0, 0
; CHECK-RV32-NEXT:    lui a0, 2
; CHECK-RV32-NEXT:    addi a0, a0, -2032
; CHECK-RV32-NEXT:    sub sp, sp, a0
; CHECK-RV32-NEXT:    srli a0, sp, 12
; CHECK-RV32-NEXT:    slli sp, a0, 12
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li ra, 1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t0, 5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    sw t0, -8(a0) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    sw t1, -4(a0) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t1, 6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    sw t1, -16(a0) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    sw t2, -12(a0) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t2, 7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    sw t2, -24(a0) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    sw t3, -20(a0) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s0, 8
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    sw s0, -32(a0) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    sw s1, -28(a0) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s1, 9
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    sw s1, -40(a0) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    sw s2, -36(a0) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a0, 10
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a2, 1
; CHECK-RV32-NEXT:    add a2, sp, a2
; CHECK-RV32-NEXT:    sw a1, -44(a2) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a1, 11
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a3, 1
; CHECK-RV32-NEXT:    add a3, sp, a3
; CHECK-RV32-NEXT:    sw a1, -52(a3) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw a2, -48(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a2, 12
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw a2, -60(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw a3, -56(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a3, 13
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw a3, -68(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw a4, -64(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a4, 14
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw a4, -76(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw a5, -72(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a5, 15
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw a5, -84(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw a6, -80(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a6, 16
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw a6, -92(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw a7, -88(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a7, 17
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw a7, -100(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw t0, -96(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s2, 18
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s2, -108(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s3, -104(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s3, 19
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s3, -116(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s4, -112(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s4, 20
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s4, -124(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s5, -120(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s5, 21
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s5, -132(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s6, -128(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s6, 22
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s6, -140(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s7, -136(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s7, 23
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s7, -148(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s8, -144(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s8, 24
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s8, -156(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s9, -152(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s9, 25
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s9, -164(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s10, -160(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s10, 26
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s10, -172(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s11, -168(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s11, 27
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw s11, -176(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t3, 28
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw t3, -184(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw t4, -180(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t4, 29
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw t4, -192(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    sw t5, -188(a1) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t5, 30
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    mv a1, t6
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t6, 31
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    mv a2, t6
; CHECK-RV32-NEXT:    mv t6, a1
; CHECK-RV32-NEXT:    lui a3, 1
; CHECK-RV32-NEXT:    add a3, sp, a3
; CHECK-RV32-NEXT:    sw s0, -204(a3) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    xor a1, a1, s0
; CHECK-RV32-NEXT:    lui a3, 1
; CHECK-RV32-NEXT:    add a3, sp, a3
; CHECK-RV32-NEXT:    sw t5, -196(a3) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    lui a3, 1
; CHECK-RV32-NEXT:    add a3, sp, a3
; CHECK-RV32-NEXT:    sw a2, -200(a3) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    xor a2, t5, a2
; CHECK-RV32-NEXT:    or a1, a2, a1
; CHECK-RV32-NEXT:    beqz a1, .LBB5_1
; CHECK-RV32-NEXT:  # %bb.3:
; CHECK-RV32-NEXT:    jump .LBB5_2, a1
; CHECK-RV32-NEXT:  .LBB5_1: # %branch_1
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    .zero 1048576
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:  .LBB5_2: # %branch_2
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use ra
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    lw t0, -8(a1) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    lw t1, -4(a1) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    lw t1, -16(a1) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    lw t2, -12(a1) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    lw t2, -24(a1) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    lw t3, -20(a1) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    lw s0, -32(a1) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    lw s1, -28(a1) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    lw s1, -40(a1) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    lw s2, -36(a1) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a1, 1
; CHECK-RV32-NEXT:    add a1, sp, a1
; CHECK-RV32-NEXT:    lw a1, -44(a1) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw a1, -52(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw a2, -48(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw a2, -60(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw a3, -56(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw a3, -68(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw a4, -64(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw a4, -76(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw a5, -72(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw a5, -84(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw a6, -80(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw a6, -92(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw a7, -88(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw a7, -100(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw t0, -96(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s2, -108(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s3, -104(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s3, -116(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s4, -112(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s4, -124(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s5, -120(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s5, -132(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s6, -128(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s6, -140(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s7, -136(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s7, -148(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s8, -144(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s8, -156(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s9, -152(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s8
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s9, -164(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s10, -160(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s9
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s10, -172(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s11, -168(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s10
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s11, -176(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s11
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw t3, -184(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw t4, -180(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw t4, -192(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw t5, -188(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw t5, -196(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw s0, -204(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lui a0, 1
; CHECK-RV32-NEXT:    add a0, sp, a0
; CHECK-RV32-NEXT:    lw t6, -200(a0) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lui a0, 2
; CHECK-RV32-NEXT:    sub sp, s0, a0
; CHECK-RV32-NEXT:    addi a0, a0, -2032
; CHECK-RV32-NEXT:    add sp, sp, a0
; CHECK-RV32-NEXT:    lw ra, 2028(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s0, 2024(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s1, 2020(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s2, 2016(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s3, 2012(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s4, 2008(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s5, 2004(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s6, 2000(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s7, 1996(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s8, 1992(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s9, 1988(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s10, 1984(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s11, 1980(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    addi sp, sp, 2032
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: relax_jal_spill_64_adjust_spill_slot:
; CHECK-RV64:       # %bb.0:
; CHECK-RV64-NEXT:    addi sp, sp, -2032
; CHECK-RV64-NEXT:    .cfi_def_cfa_offset 2032
; CHECK-RV64-NEXT:    sd ra, 2024(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s0, 2016(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s1, 2008(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s2, 2000(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s3, 1992(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s4, 1984(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s5, 1976(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s6, 1968(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s7, 1960(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s8, 1952(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s9, 1944(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s10, 1936(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s11, 1928(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    .cfi_offset ra, -8
; CHECK-RV64-NEXT:    .cfi_offset s0, -16
; CHECK-RV64-NEXT:    .cfi_offset s1, -24
; CHECK-RV64-NEXT:    .cfi_offset s2, -32
; CHECK-RV64-NEXT:    .cfi_offset s3, -40
; CHECK-RV64-NEXT:    .cfi_offset s4, -48
; CHECK-RV64-NEXT:    .cfi_offset s5, -56
; CHECK-RV64-NEXT:    .cfi_offset s6, -64
; CHECK-RV64-NEXT:    .cfi_offset s7, -72
; CHECK-RV64-NEXT:    .cfi_offset s8, -80
; CHECK-RV64-NEXT:    .cfi_offset s9, -88
; CHECK-RV64-NEXT:    .cfi_offset s10, -96
; CHECK-RV64-NEXT:    .cfi_offset s11, -104
; CHECK-RV64-NEXT:    addi s0, sp, 2032
; CHECK-RV64-NEXT:    .cfi_def_cfa s0, 0
; CHECK-RV64-NEXT:    lui a0, 2
; CHECK-RV64-NEXT:    addiw a0, a0, -2032
; CHECK-RV64-NEXT:    sub sp, sp, a0
; CHECK-RV64-NEXT:    srli a0, sp, 12
; CHECK-RV64-NEXT:    slli sp, a0, 12
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li ra, 1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t0, 5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t1, 6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t2, 7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s0, 8
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s1, 9
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a0, 10
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a1, 11
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a2, 12
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a3, 13
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a4, 14
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a5, 15
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a6, 16
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a7, 17
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s2, 18
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s3, 19
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s4, 20
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s5, 21
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s6, 22
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s7, 23
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s8, 24
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s9, 25
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s10, 26
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s11, 27
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t3, 28
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t4, 29
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t5, 30
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t6, 31
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    beq t5, t6, .LBB5_1
; CHECK-RV64-NEXT:  # %bb.3:
; CHECK-RV64-NEXT:    sd s11, 0(sp)
; CHECK-RV64-NEXT:    jump .LBB5_4, s11
; CHECK-RV64-NEXT:  .LBB5_1: # %branch_1
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    .zero 1048576
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    j .LBB5_2
; CHECK-RV64-NEXT:  .LBB5_4: # %branch_2
; CHECK-RV64-NEXT:    ld s11, 0(sp)
; CHECK-RV64-NEXT:  .LBB5_2: # %branch_2
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use ra
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s8
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s9
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s10
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s11
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    lui a0, 2
; CHECK-RV64-NEXT:    sub sp, s0, a0
; CHECK-RV64-NEXT:    addiw a0, a0, -2032
; CHECK-RV64-NEXT:    add sp, sp, a0
; CHECK-RV64-NEXT:    ld ra, 2024(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s0, 2016(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s1, 2008(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s2, 2000(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s3, 1992(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s4, 1984(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s5, 1976(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s6, 1968(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s7, 1960(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s8, 1952(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s9, 1944(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s10, 1936(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s11, 1928(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    addi sp, sp, 2032
; CHECK-RV64-NEXT:    ret

  ; If the stack is large and the offset of BranchRelaxationScratchFrameIndex
  ; is out the range of 12-bit signed integer, check whether the spill slot is
  ; adjusted to close to the stack base register.
  %stack_obj = alloca i64, align 4096

  %ra = call i64 asm sideeffect "addi ra, x0, 1", "={ra}"()
  %t0 = call i64 asm sideeffect "addi t0, x0, 5", "={t0}"()
  %t1 = call i64 asm sideeffect "addi t1, x0, 6", "={t1}"()
  %t2 = call i64 asm sideeffect "addi t2, x0, 7", "={t2}"()
  %s0 = call i64 asm sideeffect "addi s0, x0, 8", "={s0}"()
  %s1 = call i64 asm sideeffect "addi s1, x0, 9", "={s1}"()
  %a0 = call i64 asm sideeffect "addi a0, x0, 10", "={a0}"()
  %a1 = call i64 asm sideeffect "addi a1, x0, 11", "={a1}"()
  %a2 = call i64 asm sideeffect "addi a2, x0, 12", "={a2}"()
  %a3 = call i64 asm sideeffect "addi a3, x0, 13", "={a3}"()
  %a4 = call i64 asm sideeffect "addi a4, x0, 14", "={a4}"()
  %a5 = call i64 asm sideeffect "addi a5, x0, 15", "={a5}"()
  %a6 = call i64 asm sideeffect "addi a6, x0, 16", "={a6}"()
  %a7 = call i64 asm sideeffect "addi a7, x0, 17", "={a7}"()
  %s2 = call i64 asm sideeffect "addi s2, x0, 18", "={s2}"()
  %s3 = call i64 asm sideeffect "addi s3, x0, 19", "={s3}"()
  %s4 = call i64 asm sideeffect "addi s4, x0, 20", "={s4}"()
  %s5 = call i64 asm sideeffect "addi s5, x0, 21", "={s5}"()
  %s6 = call i64 asm sideeffect "addi s6, x0, 22", "={s6}"()
  %s7 = call i64 asm sideeffect "addi s7, x0, 23", "={s7}"()
  %s8 = call i64 asm sideeffect "addi s8, x0, 24", "={s8}"()
  %s9 = call i64 asm sideeffect "addi s9, x0, 25", "={s9}"()
  %s10 = call i64 asm sideeffect "addi s10, x0, 26", "={s10}"()
  %s11 = call i64 asm sideeffect "addi s11, x0, 27", "={s11}"()
  %t3 = call i64 asm sideeffect "addi t3, x0, 28", "={t3}"()
  %t4 = call i64 asm sideeffect "addi t4, x0, 29", "={t4}"()
  %t5 = call i64 asm sideeffect "addi t5, x0, 30", "={t5}"()
  %t6 = call i64 asm sideeffect "addi t6, x0, 31", "={t6}"()

  %cmp = icmp eq i64 %t5, %t6
  br i1 %cmp, label %branch_1, label %branch_2

branch_1:
  call void asm sideeffect ".space 1048576", ""()
  br label %branch_2

branch_2:
  call void asm sideeffect "# reg use $0", "{ra}"(i64 %ra)
  call void asm sideeffect "# reg use $0", "{t0}"(i64 %t0)
  call void asm sideeffect "# reg use $0", "{t1}"(i64 %t1)
  call void asm sideeffect "# reg use $0", "{t2}"(i64 %t2)
  call void asm sideeffect "# reg use $0", "{s0}"(i64 %s0)
  call void asm sideeffect "# reg use $0", "{s1}"(i64 %s1)
  call void asm sideeffect "# reg use $0", "{a0}"(i64 %a0)
  call void asm sideeffect "# reg use $0", "{a1}"(i64 %a1)
  call void asm sideeffect "# reg use $0", "{a2}"(i64 %a2)
  call void asm sideeffect "# reg use $0", "{a3}"(i64 %a3)
  call void asm sideeffect "# reg use $0", "{a4}"(i64 %a4)
  call void asm sideeffect "# reg use $0", "{a5}"(i64 %a5)
  call void asm sideeffect "# reg use $0", "{a6}"(i64 %a6)
  call void asm sideeffect "# reg use $0", "{a7}"(i64 %a7)
  call void asm sideeffect "# reg use $0", "{s2}"(i64 %s2)
  call void asm sideeffect "# reg use $0", "{s3}"(i64 %s3)
  call void asm sideeffect "# reg use $0", "{s4}"(i64 %s4)
  call void asm sideeffect "# reg use $0", "{s5}"(i64 %s5)
  call void asm sideeffect "# reg use $0", "{s6}"(i64 %s6)
  call void asm sideeffect "# reg use $0", "{s7}"(i64 %s7)
  call void asm sideeffect "# reg use $0", "{s8}"(i64 %s8)
  call void asm sideeffect "# reg use $0", "{s9}"(i64 %s9)
  call void asm sideeffect "# reg use $0", "{s10}"(i64 %s10)
  call void asm sideeffect "# reg use $0", "{s11}"(i64 %s11)
  call void asm sideeffect "# reg use $0", "{t3}"(i64 %t3)
  call void asm sideeffect "# reg use $0", "{t4}"(i64 %t4)
  call void asm sideeffect "# reg use $0", "{t5}"(i64 %t5)
  call void asm sideeffect "# reg use $0", "{t6}"(i64 %t6)

  ret void
}

define void @relax_jal_spill_32_restore_block_correspondence() {
; CHECK-RV32-LABEL: relax_jal_spill_32_restore_block_correspondence:
; CHECK-RV32:       # %bb.0: # %entry
; CHECK-RV32-NEXT:    addi sp, sp, -64
; CHECK-RV32-NEXT:    .cfi_def_cfa_offset 64
; CHECK-RV32-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s1, 52(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s2, 48(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s3, 44(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s4, 40(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s5, 36(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s6, 32(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s7, 28(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s8, 24(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s9, 20(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s10, 16(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    sw s11, 12(sp) # 4-byte Folded Spill
; CHECK-RV32-NEXT:    .cfi_offset ra, -4
; CHECK-RV32-NEXT:    .cfi_offset s0, -8
; CHECK-RV32-NEXT:    .cfi_offset s1, -12
; CHECK-RV32-NEXT:    .cfi_offset s2, -16
; CHECK-RV32-NEXT:    .cfi_offset s3, -20
; CHECK-RV32-NEXT:    .cfi_offset s4, -24
; CHECK-RV32-NEXT:    .cfi_offset s5, -28
; CHECK-RV32-NEXT:    .cfi_offset s6, -32
; CHECK-RV32-NEXT:    .cfi_offset s7, -36
; CHECK-RV32-NEXT:    .cfi_offset s8, -40
; CHECK-RV32-NEXT:    .cfi_offset s9, -44
; CHECK-RV32-NEXT:    .cfi_offset s10, -48
; CHECK-RV32-NEXT:    .cfi_offset s11, -52
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li ra, 1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t0, 5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t1, 6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t2, 7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s0, 8
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s1, 9
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a0, 10
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a1, 11
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a2, 12
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a3, 13
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a4, 14
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a5, 15
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a6, 16
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li a7, 17
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s2, 18
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s3, 19
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s4, 20
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s5, 21
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s6, 22
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s7, 23
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s8, 24
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s9, 25
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s10, 26
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li s11, 27
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t3, 28
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t4, 29
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t5, 30
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    li t6, 31
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    bne t5, t6, .LBB6_1
; CHECK-RV32-NEXT:  # %bb.7: # %entry
; CHECK-RV32-NEXT:    sw s11, 0(sp)
; CHECK-RV32-NEXT:    jump .LBB6_8, s11
; CHECK-RV32-NEXT:  .LBB6_1: # %cond_2
; CHECK-RV32-NEXT:    bne t3, t4, .LBB6_2
; CHECK-RV32-NEXT:  # %bb.9: # %cond_2
; CHECK-RV32-NEXT:    sw s11, 0(sp)
; CHECK-RV32-NEXT:    jump .LBB6_10, s11
; CHECK-RV32-NEXT:  .LBB6_2: # %cond_3
; CHECK-RV32-NEXT:    bne t1, t2, .LBB6_3
; CHECK-RV32-NEXT:  # %bb.11: # %cond_3
; CHECK-RV32-NEXT:    sw s11, 0(sp)
; CHECK-RV32-NEXT:    jump .LBB6_12, s11
; CHECK-RV32-NEXT:  .LBB6_3: # %space
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    .zero 1048576
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    j .LBB6_4
; CHECK-RV32-NEXT:  .LBB6_8: # %dest_1
; CHECK-RV32-NEXT:    lw s11, 0(sp)
; CHECK-RV32-NEXT:  .LBB6_4: # %dest_1
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # dest 1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    j .LBB6_5
; CHECK-RV32-NEXT:  .LBB6_10: # %dest_2
; CHECK-RV32-NEXT:    lw s11, 0(sp)
; CHECK-RV32-NEXT:  .LBB6_5: # %dest_2
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # dest 2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    j .LBB6_6
; CHECK-RV32-NEXT:  .LBB6_12: # %dest_3
; CHECK-RV32-NEXT:    lw s11, 0(sp)
; CHECK-RV32-NEXT:  .LBB6_6: # %dest_3
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # dest 3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use ra
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a0
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a1
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use a7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s2
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s7
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s8
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s9
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s10
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use s11
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t3
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t4
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t5
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    #APP
; CHECK-RV32-NEXT:    # reg use t6
; CHECK-RV32-NEXT:    #NO_APP
; CHECK-RV32-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s1, 52(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s2, 48(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s3, 44(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s4, 40(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s5, 36(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s6, 32(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s7, 28(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s8, 24(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s9, 20(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s10, 16(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    lw s11, 12(sp) # 4-byte Folded Reload
; CHECK-RV32-NEXT:    addi sp, sp, 64
; CHECK-RV32-NEXT:    ret
;
; CHECK-RV64-LABEL: relax_jal_spill_32_restore_block_correspondence:
; CHECK-RV64:       # %bb.0: # %entry
; CHECK-RV64-NEXT:    addi sp, sp, -128
; CHECK-RV64-NEXT:    .cfi_def_cfa_offset 128
; CHECK-RV64-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s0, 112(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s1, 104(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s2, 96(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s3, 88(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s4, 80(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s5, 72(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s6, 64(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s7, 56(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s8, 48(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s9, 40(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s10, 32(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sd s11, 24(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    .cfi_offset ra, -8
; CHECK-RV64-NEXT:    .cfi_offset s0, -16
; CHECK-RV64-NEXT:    .cfi_offset s1, -24
; CHECK-RV64-NEXT:    .cfi_offset s2, -32
; CHECK-RV64-NEXT:    .cfi_offset s3, -40
; CHECK-RV64-NEXT:    .cfi_offset s4, -48
; CHECK-RV64-NEXT:    .cfi_offset s5, -56
; CHECK-RV64-NEXT:    .cfi_offset s6, -64
; CHECK-RV64-NEXT:    .cfi_offset s7, -72
; CHECK-RV64-NEXT:    .cfi_offset s8, -80
; CHECK-RV64-NEXT:    .cfi_offset s9, -88
; CHECK-RV64-NEXT:    .cfi_offset s10, -96
; CHECK-RV64-NEXT:    .cfi_offset s11, -104
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li ra, 1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t0, 5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t1, 6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t2, 7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s0, 8
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s1, 9
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a0, 10
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a1, 11
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a2, 12
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a3, 13
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a4, 14
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a5, 15
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a6, 16
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li a7, 17
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s2, 18
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s3, 19
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s4, 20
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s5, 21
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s6, 22
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s7, 23
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s8, 24
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s9, 25
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s10, 26
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li s11, 27
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t3, 28
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t4, 29
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t5, 30
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    li t6, 31
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    sd t6, 8(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sext.w t6, t6
; CHECK-RV64-NEXT:    sd t5, 16(sp) # 8-byte Folded Spill
; CHECK-RV64-NEXT:    sext.w t5, t5
; CHECK-RV64-NEXT:    bne t5, t6, .LBB6_1
; CHECK-RV64-NEXT:  # %bb.7: # %entry
; CHECK-RV64-NEXT:    jump .LBB6_4, t5
; CHECK-RV64-NEXT:  .LBB6_1: # %cond_2
; CHECK-RV64-NEXT:    sext.w t5, t4
; CHECK-RV64-NEXT:    sext.w t6, t3
; CHECK-RV64-NEXT:    bne t6, t5, .LBB6_2
; CHECK-RV64-NEXT:  # %bb.9: # %cond_2
; CHECK-RV64-NEXT:    jump .LBB6_5, t5
; CHECK-RV64-NEXT:  .LBB6_2: # %cond_3
; CHECK-RV64-NEXT:    sext.w t5, t2
; CHECK-RV64-NEXT:    sext.w t6, t1
; CHECK-RV64-NEXT:    bne t6, t5, .LBB6_3
; CHECK-RV64-NEXT:  # %bb.11: # %cond_3
; CHECK-RV64-NEXT:    jump .LBB6_6, t5
; CHECK-RV64-NEXT:  .LBB6_3: # %space
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    .zero 1048576
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:  .LBB6_4: # %dest_1
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # dest 1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:  .LBB6_5: # %dest_2
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # dest 2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:  .LBB6_6: # %dest_3
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # dest 3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use ra
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a0
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a1
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use a7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s2
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s7
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s8
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s9
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s10
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use s11
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t3
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t4
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    ld t5, 16(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t5
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    ld t6, 8(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    #APP
; CHECK-RV64-NEXT:    # reg use t6
; CHECK-RV64-NEXT:    #NO_APP
; CHECK-RV64-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s0, 112(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s1, 104(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s2, 96(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s3, 88(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s4, 80(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s5, 72(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s6, 64(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s7, 56(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s8, 48(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s9, 40(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s10, 32(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    ld s11, 24(sp) # 8-byte Folded Reload
; CHECK-RV64-NEXT:    addi sp, sp, 128
; CHECK-RV64-NEXT:    ret
entry:
  %ra = call i32 asm sideeffect "addi ra, x0, 1", "={ra}"()
  %t0 = call i32 asm sideeffect "addi t0, x0, 5", "={t0}"()
  %t1 = call i32 asm sideeffect "addi t1, x0, 6", "={t1}"()
  %t2 = call i32 asm sideeffect "addi t2, x0, 7", "={t2}"()
  %s0 = call i32 asm sideeffect "addi s0, x0, 8", "={s0}"()
  %s1 = call i32 asm sideeffect "addi s1, x0, 9", "={s1}"()
  %a0 = call i32 asm sideeffect "addi a0, x0, 10", "={a0}"()
  %a1 = call i32 asm sideeffect "addi a1, x0, 11", "={a1}"()
  %a2 = call i32 asm sideeffect "addi a2, x0, 12", "={a2}"()
  %a3 = call i32 asm sideeffect "addi a3, x0, 13", "={a3}"()
  %a4 = call i32 asm sideeffect "addi a4, x0, 14", "={a4}"()
  %a5 = call i32 asm sideeffect "addi a5, x0, 15", "={a5}"()
  %a6 = call i32 asm sideeffect "addi a6, x0, 16", "={a6}"()
  %a7 = call i32 asm sideeffect "addi a7, x0, 17", "={a7}"()
  %s2 = call i32 asm sideeffect "addi s2, x0, 18", "={s2}"()
  %s3 = call i32 asm sideeffect "addi s3, x0, 19", "={s3}"()
  %s4 = call i32 asm sideeffect "addi s4, x0, 20", "={s4}"()
  %s5 = call i32 asm sideeffect "addi s5, x0, 21", "={s5}"()
  %s6 = call i32 asm sideeffect "addi s6, x0, 22", "={s6}"()
  %s7 = call i32 asm sideeffect "addi s7, x0, 23", "={s7}"()
  %s8 = call i32 asm sideeffect "addi s8, x0, 24", "={s8}"()
  %s9 = call i32 asm sideeffect "addi s9, x0, 25", "={s9}"()
  %s10 = call i32 asm sideeffect "addi s10, x0, 26", "={s10}"()
  %s11 = call i32 asm sideeffect "addi s11, x0, 27", "={s11}"()
  %t3 = call i32 asm sideeffect "addi t3, x0, 28", "={t3}"()
  %t4 = call i32 asm sideeffect "addi t4, x0, 29", "={t4}"()
  %t5 = call i32 asm sideeffect "addi t5, x0, 30", "={t5}"()
  %t6 = call i32 asm sideeffect "addi t6, x0, 31", "={t6}"()

  br label %cond_1

cond_1:
  %cmp1 = icmp eq i32 %t5, %t6
  br i1 %cmp1, label %dest_1, label %cond_2

cond_2:
  %cmp2 = icmp eq i32 %t3, %t4
  br i1 %cmp2, label %dest_2, label %cond_3

cond_3:
  %cmp3 = icmp eq i32 %t1, %t2
  br i1 %cmp3, label %dest_3, label %space

space:
  call void asm sideeffect ".space 1048576", ""()
  br label %dest_1

dest_1:
  call void asm sideeffect "# dest 1", ""()
  br label %dest_2

dest_2:
  call void asm sideeffect "# dest 2", ""()
  br label %dest_3

dest_3:
  call void asm sideeffect "# dest 3", ""()
  br label %tail

tail:
  call void asm sideeffect "# reg use $0", "{ra}"(i32 %ra)
  call void asm sideeffect "# reg use $0", "{t0}"(i32 %t0)
  call void asm sideeffect "# reg use $0", "{t1}"(i32 %t1)
  call void asm sideeffect "# reg use $0", "{t2}"(i32 %t2)
  call void asm sideeffect "# reg use $0", "{s0}"(i32 %s0)
  call void asm sideeffect "# reg use $0", "{s1}"(i32 %s1)
  call void asm sideeffect "# reg use $0", "{a0}"(i32 %a0)
  call void asm sideeffect "# reg use $0", "{a1}"(i32 %a1)
  call void asm sideeffect "# reg use $0", "{a2}"(i32 %a2)
  call void asm sideeffect "# reg use $0", "{a3}"(i32 %a3)
  call void asm sideeffect "# reg use $0", "{a4}"(i32 %a4)
  call void asm sideeffect "# reg use $0", "{a5}"(i32 %a5)
  call void asm sideeffect "# reg use $0", "{a6}"(i32 %a6)
  call void asm sideeffect "# reg use $0", "{a7}"(i32 %a7)
  call void asm sideeffect "# reg use $0", "{s2}"(i32 %s2)
  call void asm sideeffect "# reg use $0", "{s3}"(i32 %s3)
  call void asm sideeffect "# reg use $0", "{s4}"(i32 %s4)
  call void asm sideeffect "# reg use $0", "{s5}"(i32 %s5)
  call void asm sideeffect "# reg use $0", "{s6}"(i32 %s6)
  call void asm sideeffect "# reg use $0", "{s7}"(i32 %s7)
  call void asm sideeffect "# reg use $0", "{s8}"(i32 %s8)
  call void asm sideeffect "# reg use $0", "{s9}"(i32 %s9)
  call void asm sideeffect "# reg use $0", "{s10}"(i32 %s10)
  call void asm sideeffect "# reg use $0", "{s11}"(i32 %s11)
  call void asm sideeffect "# reg use $0", "{t3}"(i32 %t3)
  call void asm sideeffect "# reg use $0", "{t4}"(i32 %t4)
  call void asm sideeffect "# reg use $0", "{t5}"(i32 %t5)
  call void asm sideeffect "# reg use $0", "{t6}"(i32 %t6)

  ret void
}
