; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -global-isel=0 -march=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefixes=GCN,SDAG,SI-SDAG %s
; RUN: llc -global-isel=1 -march=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefixes=GCN,GISEL,SI-GISEL %s

; RUN: llc -global-isel=0 -march=amdgcn -mcpu=fiji < %s | FileCheck -check-prefixes=GCN,SDAG,VI-SDAG %s
; RUN: llc -global-isel=1 -march=amdgcn -mcpu=fiji < %s | FileCheck -check-prefixes=GCN,GISEL,VI-GISEL %s

declare i32 @llvm.amdgcn.workitem.id.x()
declare i32 @llvm.amdgcn.readfirstlane(i32)
declare double @llvm.sqrt.f64(double)
declare <2 x double> @llvm.sqrt.v2f64(<2 x double>)
declare double @llvm.amdgcn.sqrt.f64(double)
declare double @llvm.fabs.f64(double)

define amdgpu_ps <2 x i32> @s_rsq_f64(double inreg %x) {
; SI-SDAG-LABEL: s_rsq_f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SI-SDAG-NEXT:    v_bfrev_b32_e32 v1, 8
; SI-SDAG-NEXT:    v_cmp_lt_f64_e32 vcc, s[0:1], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0x260
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], s[0:1], v0
; SI-SDAG-NEXT:    s_and_b64 s[0:1], vcc, exec
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_cselect_b32 s0, 0xffffff80, 0
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v8
; SI-SDAG-NEXT:    s_mov_b32 s2, 0x3ff00000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], s0
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], 1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[0:1], 1.0, v[0:1], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[0:1], s2, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; SI-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; SI-SDAG-NEXT:    ; return to shader part epilog
;
; SI-GISEL-LABEL: s_rsq_f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_mov_b32 s2, 0
; SI-GISEL-NEXT:    s_brev_b32 s3, 8
; SI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; SI-GISEL-NEXT:    v_cmp_lt_f64_e32 vcc, s[0:1], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], s[0:1], v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[0:1], 1.0, v[0:1], 1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[0:1], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; SI-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; SI-GISEL-NEXT:    ; return to shader part epilog
;
; VI-SDAG-LABEL: s_rsq_f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_bfrev_b32_e32 v1, 8
; VI-SDAG-NEXT:    v_cmp_lt_f64_e32 vcc, s[0:1], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], s[0:1], v0
; VI-SDAG-NEXT:    s_and_b64 s[0:1], vcc, exec
; VI-SDAG-NEXT:    s_cselect_b32 s0, 0xffffff80, 0
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0x260
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], s0
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], 1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; VI-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; VI-SDAG-NEXT:    ; return to shader part epilog
;
; VI-GISEL-LABEL: s_rsq_f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_mov_b32 s2, 0
; VI-GISEL-NEXT:    s_brev_b32 s3, 8
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_cmp_lt_f64_e32 vcc, s[0:1], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], s[0:1], v0
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], 1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; VI-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; VI-GISEL-NEXT:    ; return to shader part epilog
  %rsq = call contract double @llvm.sqrt.f64(double %x)
  %result = fdiv contract double 1.0, %rsq
  %cast = bitcast double %result to <2 x i32>
  %cast.0 = extractelement <2 x i32> %cast, i32 0
  %cast.1 = extractelement <2 x i32> %cast, i32 1
  %lane.0 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.0)
  %lane.1 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.1)
  %insert.0 = insertelement <2 x i32> poison, i32 %lane.0, i32 0
  %insert.1 = insertelement <2 x i32> %insert.0, i32 %lane.1, i32 1
  ret <2 x i32> %insert.1
}

define amdgpu_ps <2 x i32> @s_rsq_f64_fabs(double inreg %x) {
; SI-SDAG-LABEL: s_rsq_f64_fabs:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SI-SDAG-NEXT:    v_bfrev_b32_e32 v1, 8
; SI-SDAG-NEXT:    v_cmp_lt_f64_e64 s[2:3], |s[0:1]|, v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0x260
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[2:3]
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], |s[0:1]|, v0
; SI-SDAG-NEXT:    s_and_b64 s[0:1], s[2:3], exec
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_cselect_b32 s0, 0xffffff80, 0
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v8
; SI-SDAG-NEXT:    s_mov_b32 s2, 0x3ff00000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], s0
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], 1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[0:1], 1.0, v[0:1], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[0:1], s2, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; SI-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; SI-SDAG-NEXT:    ; return to shader part epilog
;
; SI-GISEL-LABEL: s_rsq_f64_fabs:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_mov_b32 s2, 0
; SI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; SI-GISEL-NEXT:    s_brev_b32 s3, 8
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; SI-GISEL-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, s[2:3]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], |s[0:1]|, v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[0:1], 1.0, v[0:1], 1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[0:1], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; SI-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; SI-GISEL-NEXT:    ; return to shader part epilog
;
; VI-SDAG-LABEL: s_rsq_f64_fabs:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_bfrev_b32_e32 v1, 8
; VI-SDAG-NEXT:    v_cmp_lt_f64_e64 s[2:3], |s[0:1]|, v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[2:3]
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], |s[0:1]|, v0
; VI-SDAG-NEXT:    s_and_b64 s[0:1], s[2:3], exec
; VI-SDAG-NEXT:    s_cselect_b32 s0, 0xffffff80, 0
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0x260
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], s0
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], 1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; VI-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; VI-SDAG-NEXT:    ; return to shader part epilog
;
; VI-GISEL-LABEL: s_rsq_f64_fabs:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_mov_b32 s2, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    s_brev_b32 s3, 8
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, s[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], |s[0:1]|, v0
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], 1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; VI-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; VI-GISEL-NEXT:    ; return to shader part epilog
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %rsq = call contract double @llvm.sqrt.f64(double %fabs.x)
  %result = fdiv contract double 1.0, %rsq
  %cast = bitcast double %result to <2 x i32>
  %cast.0 = extractelement <2 x i32> %cast, i32 0
  %cast.1 = extractelement <2 x i32> %cast, i32 1
  %lane.0 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.0)
  %lane.1 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.1)
  %insert.0 = insertelement <2 x i32> poison, i32 %lane.0, i32 0
  %insert.1 = insertelement <2 x i32> %insert.0, i32 %lane.1, i32 1
  ret <2 x i32> %insert.1
}

define amdgpu_ps <2 x i32> @s_neg_rsq_f64(double inreg %x) {
; SI-SDAG-LABEL: s_neg_rsq_f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SI-SDAG-NEXT:    v_bfrev_b32_e32 v1, 8
; SI-SDAG-NEXT:    v_cmp_lt_f64_e32 vcc, s[0:1], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0x260
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], s[0:1], v0
; SI-SDAG-NEXT:    s_and_b64 s[0:1], vcc, exec
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_cselect_b32 s0, 0xffffff80, 0
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v8
; SI-SDAG-NEXT:    s_mov_b32 s2, 0xbff00000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], s0
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], -1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[0:1], -1.0, v[0:1], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[0:1], s2, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; SI-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; SI-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; SI-SDAG-NEXT:    ; return to shader part epilog
;
; SI-GISEL-LABEL: s_neg_rsq_f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_mov_b32 s2, 0
; SI-GISEL-NEXT:    s_brev_b32 s3, 8
; SI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; SI-GISEL-NEXT:    v_cmp_lt_f64_e32 vcc, s[0:1], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], s[0:1], v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0xbff00000
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], -1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[0:1], -1.0, v[0:1], -1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[0:1], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; SI-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; SI-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; SI-GISEL-NEXT:    ; return to shader part epilog
;
; VI-SDAG-LABEL: s_neg_rsq_f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_bfrev_b32_e32 v1, 8
; VI-SDAG-NEXT:    v_cmp_lt_f64_e32 vcc, s[0:1], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], s[0:1], v0
; VI-SDAG-NEXT:    s_and_b64 s[0:1], vcc, exec
; VI-SDAG-NEXT:    s_cselect_b32 s0, 0xffffff80, 0
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0x260
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], s0
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], -1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, -1.0, v[0:1], -1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; VI-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; VI-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; VI-SDAG-NEXT:    ; return to shader part epilog
;
; VI-GISEL-LABEL: s_neg_rsq_f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_mov_b32 s2, 0
; VI-GISEL-NEXT:    s_brev_b32 s3, 8
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_cmp_lt_f64_e32 vcc, s[0:1], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], s[0:1], v0
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], -1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, -1.0, v[0:1], -1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; VI-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; VI-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; VI-GISEL-NEXT:    ; return to shader part epilog
  %rsq = call contract double @llvm.sqrt.f64(double %x)
  %result = fdiv contract double -1.0, %rsq
  %cast = bitcast double %result to <2 x i32>
  %cast.0 = extractelement <2 x i32> %cast, i32 0
  %cast.1 = extractelement <2 x i32> %cast, i32 1
  %lane.0 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.0)
  %lane.1 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.1)
  %insert.0 = insertelement <2 x i32> poison, i32 %lane.0, i32 0
  %insert.1 = insertelement <2 x i32> %insert.0, i32 %lane.1, i32 1
  ret <2 x i32> %insert.1
}

define amdgpu_ps <2 x i32> @s_neg_rsq_neg_f64(double inreg %x) {
; SI-SDAG-LABEL: s_neg_rsq_neg_f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SI-SDAG-NEXT:    v_bfrev_b32_e32 v1, 9
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[0:1], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0x260
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], -s[0:1], v0
; SI-SDAG-NEXT:    s_and_b64 s[0:1], vcc, exec
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_cselect_b32 s0, 0xffffff80, 0
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v8
; SI-SDAG-NEXT:    s_mov_b32 s2, 0xbff00000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], s0
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], -1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[0:1], -1.0, v[0:1], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[0:1], s2, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; SI-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; SI-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; SI-SDAG-NEXT:    ; return to shader part epilog
;
; SI-GISEL-LABEL: s_neg_rsq_neg_f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_mov_b32 s2, 0
; SI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; SI-GISEL-NEXT:    s_brev_b32 s3, 8
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; SI-GISEL-NEXT:    v_cmp_lt_f64_e64 vcc, -v[0:1], s[2:3]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], -s[0:1], v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0xbff00000
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], -1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[0:1], -1.0, v[0:1], -1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[0:1], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; SI-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; SI-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; SI-GISEL-NEXT:    ; return to shader part epilog
;
; VI-SDAG-LABEL: s_neg_rsq_neg_f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_bfrev_b32_e32 v1, 9
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[0:1], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], -s[0:1], v0
; VI-SDAG-NEXT:    s_and_b64 s[0:1], vcc, exec
; VI-SDAG-NEXT:    s_cselect_b32 s0, 0xffffff80, 0
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0x260
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], s0
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], -1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, -1.0, v[0:1], -1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; VI-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; VI-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; VI-SDAG-NEXT:    ; return to shader part epilog
;
; VI-GISEL-LABEL: s_neg_rsq_neg_f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_mov_b32 s2, 0
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s0
; VI-GISEL-NEXT:    s_brev_b32 s3, 8
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s1
; VI-GISEL-NEXT:    v_cmp_lt_f64_e64 vcc, -v[0:1], s[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], -s[0:1], v0
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], -1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, -1.0, v[0:1], -1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; VI-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; VI-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; VI-GISEL-NEXT:    ; return to shader part epilog
  %x.neg = fneg double %x
  %rsq = call contract double @llvm.sqrt.f64(double %x.neg)
  %result = fdiv contract double -1.0, %rsq
  %cast = bitcast double %result to <2 x i32>
  %cast.0 = extractelement <2 x i32> %cast, i32 0
  %cast.1 = extractelement <2 x i32> %cast, i32 1
  %lane.0 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.0)
  %lane.1 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.1)
  %insert.0 = insertelement <2 x i32> poison, i32 %lane.0, i32 0
  %insert.1 = insertelement <2 x i32> %insert.0, i32 %lane.1, i32 1
  ret <2 x i32> %insert.1
}

define double @v_rsq_f64(double %x) {
; SI-SDAG-LABEL: v_rsq_f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_mov_b32 s6, 0x3ff00000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], 1.0, v[0:1], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], 1.0, v[0:1], 1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract double @llvm.sqrt.f64(double %x)
  %rsq = fdiv contract double 1.0, %sqrt
  ret double %rsq
}

define double @v_rsq_f64_fabs(double %x) {
; SI-SDAG-LABEL: v_rsq_f64_fabs:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, s[4:5]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_mov_b32 s6, 0x3ff00000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], 1.0, v[0:1], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_f64_fabs:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, s[4:5]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], 1.0, v[0:1], 1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_f64_fabs:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, s[4:5]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_f64_fabs:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_lt_f64_e64 vcc, |v[0:1]|, s[4:5]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], |v[0:1]|, v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %fabs.x = call double @llvm.fabs.f64(double %x)
  %sqrt = call contract double @llvm.sqrt.f64(double %fabs.x)
  %rsq = fdiv contract double 1.0, %sqrt
  ret double %rsq
}

define double @v_rsq_f64_missing_contract0(double %x) {
; SI-SDAG-LABEL: v_rsq_f64_missing_contract0:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_mov_b32 s6, 0x3ff00000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], 1.0, v[0:1], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_f64_missing_contract0:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], 1.0, v[0:1], 1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_f64_missing_contract0:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_f64_missing_contract0:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call double @llvm.sqrt.f64(double %x)
  %rsq = fdiv contract double 1.0, %sqrt
  ret double %rsq
}

define double @v_rsq_f64_missing_contract1(double %x) {
; SI-SDAG-LABEL: v_rsq_f64_missing_contract1:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_mov_b32 s6, 0x3ff00000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], 1.0, v[0:1], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_f64_missing_contract1:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], 1.0, v[0:1], 1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_f64_missing_contract1:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_f64_missing_contract1:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract double @llvm.sqrt.f64(double %x)
  %rsq = fdiv double 1.0, %sqrt
  ret double %rsq
}

define double @v_neg_rsq_f64(double %x) {
; SI-SDAG-LABEL: v_neg_rsq_f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_mov_b32 s6, 0xbff00000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], -1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], -1.0, v[0:1], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_neg_rsq_f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0xbff00000
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], -1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], -1.0, v[0:1], -1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_neg_rsq_f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], -1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, -1.0, v[0:1], -1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_neg_rsq_f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], -1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, -1.0, v[0:1], -1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract double @llvm.sqrt.f64(double %x)
  %rsq = fdiv contract double -1.0, %sqrt
  ret double %rsq
}

define <2 x double> @v_rsq_v2f64(<2 x double> %x) {
; SI-SDAG-LABEL: v_rsq_v2f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v6, 0, 1, s[4:5]
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v6, 8, v6
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v6
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[6:7], v[0:1]
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    s_mov_b32 s6, 0x3ff00000
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[10:11], v[0:1], v[6:7]
; SI-SDAG-NEXT:    v_mul_f64 v[6:7], v[6:7], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 0.5
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[10:11], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[14:15], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], v[18:19], v[6:7], v[10:11]
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[12:13], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[10:11], v[10:11], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v14, 0xffffff80
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[12:13], v[6:7], v[10:11]
; SI-SDAG-NEXT:    v_mov_b32_e32 v15, 0x260
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v10, 0, v14, s[4:5]
; SI-SDAG-NEXT:    v_ldexp_f64 v[6:7], v[6:7], v10
; SI-SDAG-NEXT:    v_cmp_class_f64_e64 s[4:5], v[0:1], v15
; SI-SDAG-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[8:9], v[2:3]
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v1, v7, v1, s[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v0, v6, v0, s[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], v[0:1], v[0:1], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], v[16:17], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[8:9], v[8:9], v[2:3]
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[12:13], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[10:11], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v8, 0, v14, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v8
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v15
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[12:13], 1.0
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[12:13]
; SI-SDAG-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[2:3], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[6:7], v[8:9], 1.0
; SI-SDAG-NEXT:    v_div_scale_f64 v[12:13], s[4:5], 1.0, v[0:1], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[8:9], v[10:11]
; SI-SDAG-NEXT:    v_mul_f64 v[14:15], v[12:13], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v7
; SI-SDAG-NEXT:    v_fma_f64 v[16:17], -v[6:7], v[14:15], v[12:13]
; SI-SDAG-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[8:9], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[8:9], v[18:19], v[8:9]
; SI-SDAG-NEXT:    v_div_scale_f64 v[18:19], s[4:5], 1.0, v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[10:11], v[6:7], 1.0
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v13
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[18:19], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[4:5], v[16:17], v[4:5], v[14:15]
; SI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[10:11], v[8:9], v[18:19]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v11
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v19
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], 1.0
; SI-SDAG-NEXT:    s_nop 0
; SI-SDAG-NEXT:    v_div_fmas_f64 v[6:7], v[12:13], v[6:7], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_v2f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v10, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v4
; SI-GISEL-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[2:3]
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v14, 0xffffff80
; SI-GISEL-NEXT:    v_mov_b32_e32 v15, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v20, 0x3ff00000
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[0:1], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cndmask_b32_e64 v6, 0, v10, s[4:5]
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v6
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v8, 0, v14, vcc
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v8
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v15
; SI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[2:3], v[6:7]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[8:9], v[6:7], 0.5
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[6:7], v[10:11], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[8:9], v[10:11], v[8:9]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_div_scale_f64 v[10:11], s[6:7], v[0:1], v[0:1], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v15
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[12:13], v[10:11]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cndmask_b32_e64 v6, 0, v14, s[4:5]
; SI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[10:11], v[12:13], 1.0
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[12:13], v[6:7], v[12:13]
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[2:3], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[10:11], v[6:7], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[12:13], s[4:5], 1.0, v[0:1], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[6:7], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_mul_f64 v[14:15], v[12:13], v[4:5]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v20, v13
; SI-GISEL-NEXT:    v_fma_f64 v[16:17], -v[10:11], v[14:15], v[12:13]
; SI-GISEL-NEXT:    v_fma_f64 v[18:19], -v[8:9], v[6:7], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[18:19], v[6:7]
; SI-GISEL-NEXT:    v_div_scale_f64 v[18:19], s[4:5], 1.0, v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[6:7], 1.0
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v11
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[12:13], v[6:7]
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[10:11], v[18:19], v[6:7]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[16:17], v[4:5], v[14:15]
; SI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[10:11], v[18:19]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v20, v19
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v3, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], 1.0
; SI-GISEL-NEXT:    s_nop 0
; SI-GISEL-NEXT:    v_div_fmas_f64 v[6:7], v[12:13], v[6:7], v[10:11]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_v2f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; VI-SDAG-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, s[4:5]
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v4
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[6:7], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; VI-SDAG-NEXT:    v_mul_f64 v[10:11], v[0:1], v[6:7]
; VI-SDAG-NEXT:    v_mul_f64 v[6:7], v[6:7], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[12:13], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[14:15], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[8:9], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[10:11], v[10:11], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], v[12:13], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_fma_f64 v[10:11], v[14:15], v[6:7], v[10:11]
; VI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[8:9], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[10:11], v[10:11], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[12:13], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[14:15], v[6:7], v[10:11]
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v10, 0, v8, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v8, 0, v8, s[4:5]
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; VI-SDAG-NEXT:    v_cmp_class_f64_e64 s[4:5], v[2:3], v9
; VI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v10
; VI-SDAG-NEXT:    v_ldexp_f64 v[6:7], v[6:7], v8
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v3, v5, v3, s[4:5]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, v4, v2, s[4:5]
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v7, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[5:6], s[6:7], v[0:1], v[0:1], 1.0
; VI-SDAG-NEXT:    v_div_scale_f64 v[7:8], s[4:5], v[2:3], v[2:3], 1.0
; VI-SDAG-NEXT:    v_div_scale_f64 v[17:18], s[4:5], 1.0, v[2:3], 1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[9:10], v[5:6]
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[11:12], v[7:8]
; VI-SDAG-NEXT:    v_fma_f64 v[13:14], -v[5:6], v[9:10], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[15:16], -v[7:8], v[11:12], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[9:10], v[9:10], v[13:14], v[9:10]
; VI-SDAG-NEXT:    v_div_scale_f64 v[13:14], vcc, 1.0, v[0:1], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[11:12], v[11:12], v[15:16], v[11:12]
; VI-SDAG-NEXT:    v_fma_f64 v[15:16], -v[5:6], v[9:10], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[19:20], -v[7:8], v[11:12], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[9:10], v[9:10], v[15:16], v[9:10]
; VI-SDAG-NEXT:    v_fma_f64 v[11:12], v[11:12], v[19:20], v[11:12]
; VI-SDAG-NEXT:    v_mul_f64 v[15:16], v[13:14], v[9:10]
; VI-SDAG-NEXT:    v_mul_f64 v[19:20], v[17:18], v[11:12]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[5:6], v[15:16], v[13:14]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[7:8], v[19:20], v[17:18]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[9:10], v[15:16]
; VI-SDAG-NEXT:    s_mov_b64 vcc, s[4:5]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[11:12], v[19:20]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], 1.0
; VI-SDAG-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_v2f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v5, 0, v4, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v5
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v4, 0, v4, s[4:5]
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[4:5], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[0:1], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[10:11], v[6:7], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[6:7], v[2:3], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[4:5], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[10:11], v[6:7], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[12:13], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[14:15], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[12:13], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[14:15], v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[12:13], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[14:15], v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v10, 0, v8, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v8, 0, v8, s[4:5]
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; VI-GISEL-NEXT:    v_cmp_class_f64_e64 s[4:5], v[2:3], v9
; VI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v10
; VI-GISEL-NEXT:    v_ldexp_f64 v[6:7], v[6:7], v8
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[4:5], s[6:7], v[0:1], v[0:1], 1.0
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], s[4:5], v[2:3], v[2:3], 1.0
; VI-GISEL-NEXT:    v_div_scale_f64 v[16:17], s[4:5], 1.0, v[2:3], 1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; VI-GISEL-NEXT:    v_div_scale_f64 v[12:13], vcc, 1.0, v[0:1], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[4:5], v[8:9], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[18:19], -v[6:7], v[10:11], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[14:15], v[8:9]
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], v[10:11], v[18:19], v[10:11]
; VI-GISEL-NEXT:    v_mul_f64 v[14:15], v[12:13], v[8:9]
; VI-GISEL-NEXT:    v_mul_f64 v[18:19], v[16:17], v[10:11]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[14:15], v[12:13]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[6:7], v[18:19], v[16:17]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[8:9], v[14:15]
; VI-GISEL-NEXT:    s_mov_b64 vcc, s[4:5]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[10:11], v[18:19]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], 1.0
; VI-GISEL-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call <2 x double> @llvm.sqrt.v2f64(<2 x double> %x)
  %rsq = fdiv <2 x double> <double 1.0, double 1.0>, %sqrt
  ret <2 x double> %rsq
}

define <2 x double> @v_neg_rsq_v2f64(<2 x double> %x) {
; SI-SDAG-LABEL: v_neg_rsq_v2f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v6, 0, 1, s[4:5]
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v6, 8, v6
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v6
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[6:7], v[0:1]
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    s_mov_b32 s6, 0xbff00000
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[10:11], v[0:1], v[6:7]
; SI-SDAG-NEXT:    v_mul_f64 v[6:7], v[6:7], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 0.5
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[10:11], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[14:15], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], v[18:19], v[6:7], v[10:11]
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[12:13], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[10:11], v[10:11], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v14, 0xffffff80
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[12:13], v[6:7], v[10:11]
; SI-SDAG-NEXT:    v_mov_b32_e32 v15, 0x260
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v10, 0, v14, s[4:5]
; SI-SDAG-NEXT:    v_ldexp_f64 v[6:7], v[6:7], v10
; SI-SDAG-NEXT:    v_cmp_class_f64_e64 s[4:5], v[0:1], v15
; SI-SDAG-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[8:9], v[2:3]
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v1, v7, v1, s[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v0, v6, v0, s[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], v[0:1], v[0:1], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], v[16:17], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[8:9], v[8:9], v[2:3]
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[12:13], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[10:11], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v8, 0, v14, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v8
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v15
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[12:13], 1.0
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[12:13]
; SI-SDAG-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[2:3], v[2:3], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[6:7], v[8:9], 1.0
; SI-SDAG-NEXT:    v_div_scale_f64 v[12:13], s[4:5], -1.0, v[0:1], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[8:9], v[10:11]
; SI-SDAG-NEXT:    v_mul_f64 v[14:15], v[12:13], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v7
; SI-SDAG-NEXT:    v_fma_f64 v[16:17], -v[6:7], v[14:15], v[12:13]
; SI-SDAG-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[8:9], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[8:9], v[18:19], v[8:9]
; SI-SDAG-NEXT:    v_div_scale_f64 v[18:19], s[4:5], -1.0, v[2:3], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[10:11], v[6:7], 1.0
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v13
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[18:19], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[4:5], v[16:17], v[4:5], v[14:15]
; SI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[10:11], v[8:9], v[18:19]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v11
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v19
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], -1.0
; SI-SDAG-NEXT:    s_nop 0
; SI-SDAG-NEXT:    v_div_fmas_f64 v[6:7], v[12:13], v[6:7], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], -1.0
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_neg_rsq_v2f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v10, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v4
; SI-GISEL-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[2:3]
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v14, 0xffffff80
; SI-GISEL-NEXT:    v_mov_b32_e32 v15, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v20, 0xbff00000
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[0:1], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cndmask_b32_e64 v6, 0, v10, s[4:5]
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v6
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v8, 0, v14, vcc
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v8
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v15
; SI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[2:3], v[6:7]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[8:9], v[6:7], 0.5
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[6:7], v[10:11], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[8:9], v[10:11], v[8:9]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_div_scale_f64 v[10:11], s[6:7], v[0:1], v[0:1], -1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v15
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[12:13], v[10:11]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cndmask_b32_e64 v6, 0, v14, s[4:5]
; SI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[10:11], v[12:13], 1.0
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[12:13], v[6:7], v[12:13]
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[2:3], v[2:3], -1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[10:11], v[6:7], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[12:13], s[4:5], -1.0, v[0:1], -1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[6:7], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_mul_f64 v[14:15], v[12:13], v[4:5]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v20, v13
; SI-GISEL-NEXT:    v_fma_f64 v[16:17], -v[10:11], v[14:15], v[12:13]
; SI-GISEL-NEXT:    v_fma_f64 v[18:19], -v[8:9], v[6:7], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[18:19], v[6:7]
; SI-GISEL-NEXT:    v_div_scale_f64 v[18:19], s[4:5], -1.0, v[2:3], -1.0
; SI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[6:7], 1.0
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v11
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[12:13], v[6:7]
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[10:11], v[18:19], v[6:7]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[16:17], v[4:5], v[14:15]
; SI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[10:11], v[18:19]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v20, v19
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v3, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], -1.0
; SI-GISEL-NEXT:    s_nop 0
; SI-GISEL-NEXT:    v_div_fmas_f64 v[6:7], v[12:13], v[6:7], v[10:11]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], -1.0
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_neg_rsq_v2f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; VI-SDAG-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, s[4:5]
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v4
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[6:7], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; VI-SDAG-NEXT:    v_mul_f64 v[10:11], v[0:1], v[6:7]
; VI-SDAG-NEXT:    v_mul_f64 v[6:7], v[6:7], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[12:13], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[14:15], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[8:9], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[10:11], v[10:11], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], v[12:13], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_fma_f64 v[10:11], v[14:15], v[6:7], v[10:11]
; VI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[8:9], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[10:11], v[10:11], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[12:13], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[14:15], v[6:7], v[10:11]
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v10, 0, v8, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v8, 0, v8, s[4:5]
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; VI-SDAG-NEXT:    v_cmp_class_f64_e64 s[4:5], v[2:3], v9
; VI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v10
; VI-SDAG-NEXT:    v_ldexp_f64 v[6:7], v[6:7], v8
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v3, v5, v3, s[4:5]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, v4, v2, s[4:5]
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v7, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[5:6], s[6:7], v[0:1], v[0:1], -1.0
; VI-SDAG-NEXT:    v_div_scale_f64 v[7:8], s[4:5], v[2:3], v[2:3], -1.0
; VI-SDAG-NEXT:    v_div_scale_f64 v[17:18], s[4:5], -1.0, v[2:3], -1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[9:10], v[5:6]
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[11:12], v[7:8]
; VI-SDAG-NEXT:    v_fma_f64 v[13:14], -v[5:6], v[9:10], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[15:16], -v[7:8], v[11:12], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[9:10], v[9:10], v[13:14], v[9:10]
; VI-SDAG-NEXT:    v_div_scale_f64 v[13:14], vcc, -1.0, v[0:1], -1.0
; VI-SDAG-NEXT:    v_fma_f64 v[11:12], v[11:12], v[15:16], v[11:12]
; VI-SDAG-NEXT:    v_fma_f64 v[15:16], -v[5:6], v[9:10], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[19:20], -v[7:8], v[11:12], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[9:10], v[9:10], v[15:16], v[9:10]
; VI-SDAG-NEXT:    v_fma_f64 v[11:12], v[11:12], v[19:20], v[11:12]
; VI-SDAG-NEXT:    v_mul_f64 v[15:16], v[13:14], v[9:10]
; VI-SDAG-NEXT:    v_mul_f64 v[19:20], v[17:18], v[11:12]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[5:6], v[15:16], v[13:14]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[7:8], v[19:20], v[17:18]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[9:10], v[15:16]
; VI-SDAG-NEXT:    s_mov_b64 vcc, s[4:5]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[11:12], v[19:20]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], -1.0
; VI-SDAG-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], -1.0
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_neg_rsq_v2f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v5, 0, v4, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v5
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v4, 0, v4, s[4:5]
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[4:5], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[0:1], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[10:11], v[6:7], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[6:7], v[2:3], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[4:5], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[10:11], v[6:7], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[12:13], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[14:15], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[12:13], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[14:15], v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[12:13], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[14:15], v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v10, 0, v8, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v8, 0, v8, s[4:5]
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; VI-GISEL-NEXT:    v_cmp_class_f64_e64 s[4:5], v[2:3], v9
; VI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v10
; VI-GISEL-NEXT:    v_ldexp_f64 v[6:7], v[6:7], v8
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[4:5], s[6:7], v[0:1], v[0:1], -1.0
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], s[4:5], v[2:3], v[2:3], -1.0
; VI-GISEL-NEXT:    v_div_scale_f64 v[16:17], s[4:5], -1.0, v[2:3], -1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; VI-GISEL-NEXT:    v_div_scale_f64 v[12:13], vcc, -1.0, v[0:1], -1.0
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[4:5], v[8:9], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[18:19], -v[6:7], v[10:11], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[14:15], v[8:9]
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], v[10:11], v[18:19], v[10:11]
; VI-GISEL-NEXT:    v_mul_f64 v[14:15], v[12:13], v[8:9]
; VI-GISEL-NEXT:    v_mul_f64 v[18:19], v[16:17], v[10:11]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[14:15], v[12:13]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[6:7], v[18:19], v[16:17]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[8:9], v[14:15]
; VI-GISEL-NEXT:    s_mov_b64 vcc, s[4:5]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[10:11], v[18:19]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], -1.0
; VI-GISEL-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], -1.0
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call <2 x double> @llvm.sqrt.v2f64(<2 x double> %x)
  %rsq = fdiv <2 x double> <double -1.0, double -1.0>, %sqrt
  ret <2 x double> %rsq
}

define <2 x double> @v_neg_rsq_v2f64_poisonelt(<2 x double> %x) {
; SI-SDAG-LABEL: v_neg_rsq_v2f64_poisonelt:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_mov_b32 s6, 0xbff00000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], -1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], -1.0, v[0:1], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; SI-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; SI-SDAG-NEXT:    v_mov_b32_e32 v3, 0x7ff80000
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_neg_rsq_v2f64_poisonelt:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v10, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v4
; SI-GISEL-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[2:3]
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v14, 0xffffff80
; SI-GISEL-NEXT:    v_mov_b32_e32 v15, 0x260
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[0:1], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cndmask_b32_e64 v6, 0, v10, s[4:5]
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v6
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v8, 0, v14, vcc
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v8
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v15
; SI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[2:3], v[6:7]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[8:9], v[6:7], 0.5
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[6:7], v[10:11], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[8:9], v[10:11], v[8:9]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_div_scale_f64 v[10:11], s[6:7], v[0:1], v[0:1], -1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v15
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[12:13], v[10:11]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cndmask_b32_e64 v6, 0, v14, s[4:5]
; SI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[10:11], v[12:13], 1.0
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[12:13], v[6:7], v[12:13]
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[2:3], v[2:3], s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[10:11], v[6:7], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[12:13], s[4:5], -1.0, v[0:1], -1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[6:7], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_mul_f64 v[14:15], v[12:13], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[16:17], -v[10:11], v[14:15], v[12:13]
; SI-GISEL-NEXT:    v_fma_f64 v[18:19], -v[8:9], v[6:7], 1.0
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0xbff00000
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[18:19], v[6:7]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v13
; SI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[6:7], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[18:19], s[4:5], s[4:5], v[2:3], s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[12:13], v[6:7]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v11
; SI-GISEL-NEXT:    v_mul_f64 v[10:11], v[18:19], v[6:7]
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[16:17], v[4:5], v[14:15]
; SI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[10:11], v[18:19]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, s4, v19
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v3, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], -1.0
; SI-GISEL-NEXT:    s_nop 0
; SI-GISEL-NEXT:    v_div_fmas_f64 v[6:7], v[12:13], v[6:7], v[10:11]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], s[4:5]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_neg_rsq_v2f64_poisonelt:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], -1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, -1.0, v[0:1], -1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; VI-SDAG-NEXT:    v_mov_b32_e32 v2, 0
; VI-SDAG-NEXT:    v_mov_b32_e32 v3, 0x7ff80000
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_neg_rsq_v2f64_poisonelt:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v5, 0, v4, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v5
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v4, 0, v4, s[4:5]
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[4:5], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[0:1], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[10:11], v[6:7], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[6:7], v[2:3], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[4:5], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[10:11], v[6:7], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[12:13], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[14:15], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[12:13], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[14:15], v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[12:13], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[14:15], v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v10, 0, v8, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v8, 0, v8, s[4:5]
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; VI-GISEL-NEXT:    v_cmp_class_f64_e64 s[4:5], v[2:3], v9
; VI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v10
; VI-GISEL-NEXT:    v_ldexp_f64 v[6:7], v[6:7], v8
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[4:5], s[6:7], v[0:1], v[0:1], -1.0
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], s[4:5], v[2:3], v[2:3], s[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[16:17], s[4:5], s[4:5], v[2:3], s[4:5]
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; VI-GISEL-NEXT:    v_div_scale_f64 v[12:13], vcc, -1.0, v[0:1], -1.0
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[4:5], v[8:9], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[18:19], -v[6:7], v[10:11], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[14:15], v[8:9]
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], v[10:11], v[18:19], v[10:11]
; VI-GISEL-NEXT:    v_mul_f64 v[14:15], v[12:13], v[8:9]
; VI-GISEL-NEXT:    v_mul_f64 v[18:19], v[16:17], v[10:11]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[14:15], v[12:13]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[6:7], v[18:19], v[16:17]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[8:9], v[14:15]
; VI-GISEL-NEXT:    s_mov_b64 vcc, s[4:5]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[10:11], v[18:19]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], -1.0
; VI-GISEL-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], s[4:5]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call <2 x double> @llvm.sqrt.v2f64(<2 x double> %x)
  %rsq = fdiv <2 x double> <double -1.0, double poison>, %sqrt
  ret <2 x double> %rsq
}

define <2 x double> @v_neg_pos_rsq_v2f64(<2 x double> %x) {
; SI-SDAG-LABEL: v_neg_pos_rsq_v2f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v6, 0, 1, s[4:5]
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v6, 8, v6
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v6
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[6:7], v[0:1]
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    s_mov_b32 s6, 0xbff00000
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[10:11], v[0:1], v[6:7]
; SI-SDAG-NEXT:    v_mul_f64 v[6:7], v[6:7], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 0.5
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[10:11], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[14:15], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], v[18:19], v[6:7], v[10:11]
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[12:13], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[10:11], v[10:11], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v14, 0xffffff80
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[12:13], v[6:7], v[10:11]
; SI-SDAG-NEXT:    v_mov_b32_e32 v15, 0x260
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v10, 0, v14, s[4:5]
; SI-SDAG-NEXT:    v_ldexp_f64 v[6:7], v[6:7], v10
; SI-SDAG-NEXT:    v_cmp_class_f64_e64 s[4:5], v[0:1], v15
; SI-SDAG-NEXT:    v_fma_f64 v[16:17], -v[8:9], v[8:9], v[2:3]
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v1, v7, v1, s[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v0, v6, v0, s[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], v[0:1], v[0:1], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], v[16:17], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[8:9], v[8:9], v[2:3]
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[12:13], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[10:11], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v8, 0, v14, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v8
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v15
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[12:13], 1.0
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], v[12:13], v[8:9], v[12:13]
; SI-SDAG-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[2:3], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[6:7], v[8:9], 1.0
; SI-SDAG-NEXT:    v_div_scale_f64 v[12:13], s[4:5], -1.0, v[0:1], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[8:9], v[10:11]
; SI-SDAG-NEXT:    v_mul_f64 v[14:15], v[12:13], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v7
; SI-SDAG-NEXT:    v_fma_f64 v[16:17], -v[6:7], v[14:15], v[12:13]
; SI-SDAG-NEXT:    v_fma_f64 v[18:19], -v[10:11], v[8:9], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[8:9], v[18:19], v[8:9]
; SI-SDAG-NEXT:    v_div_scale_f64 v[18:19], s[4:5], 1.0, v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[10:11], v[6:7], 1.0
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v13
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[18:19], v[6:7]
; SI-SDAG-NEXT:    s_mov_b32 s4, 0x3ff00000
; SI-SDAG-NEXT:    v_div_fmas_f64 v[4:5], v[16:17], v[4:5], v[14:15]
; SI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[10:11], v[8:9], v[18:19]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v11
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s4, v19
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], -1.0
; SI-SDAG-NEXT:    s_nop 0
; SI-SDAG-NEXT:    v_div_fmas_f64 v[6:7], v[12:13], v[6:7], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_neg_pos_rsq_v2f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v10, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v4
; SI-GISEL-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[2:3]
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v14, 0xffffff80
; SI-GISEL-NEXT:    v_mov_b32_e32 v15, 0x260
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[0:1], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cndmask_b32_e64 v6, 0, v10, s[4:5]
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v6
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v8, 0, v14, vcc
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v8
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v15
; SI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[2:3], v[6:7]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[8:9], v[6:7], 0.5
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[6:7], v[10:11], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[8:9], v[10:11], v[8:9]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_div_scale_f64 v[10:11], s[6:7], v[0:1], v[0:1], -1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v15
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[12:13], v[10:11]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cndmask_b32_e64 v6, 0, v14, s[4:5]
; SI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[10:11], v[12:13], 1.0
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[12:13], v[6:7], v[12:13]
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[2:3], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[10:11], v[6:7], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[12:13], s[4:5], -1.0, v[0:1], -1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[6:7], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_mul_f64 v[14:15], v[12:13], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[16:17], -v[10:11], v[14:15], v[12:13]
; SI-GISEL-NEXT:    v_fma_f64 v[18:19], -v[8:9], v[6:7], 1.0
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0xbff00000
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[18:19], v[6:7]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v13
; SI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[6:7], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[18:19], s[4:5], 1.0, v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[12:13], v[6:7]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v11
; SI-GISEL-NEXT:    v_mul_f64 v[10:11], v[18:19], v[6:7]
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[10:11], v[18:19]
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0x3ff00000
; SI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[16:17], v[4:5], v[14:15]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v8, v19
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v3, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], -1.0
; SI-GISEL-NEXT:    s_nop 0
; SI-GISEL-NEXT:    v_div_fmas_f64 v[6:7], v[12:13], v[6:7], v[10:11]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_neg_pos_rsq_v2f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; VI-SDAG-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, s[4:5]
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v4
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[6:7], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; VI-SDAG-NEXT:    v_mul_f64 v[10:11], v[0:1], v[6:7]
; VI-SDAG-NEXT:    v_mul_f64 v[6:7], v[6:7], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[12:13], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[14:15], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[8:9], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[10:11], v[10:11], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], v[12:13], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_fma_f64 v[10:11], v[14:15], v[6:7], v[10:11]
; VI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[8:9], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[10:11], v[10:11], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[12:13], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[14:15], v[6:7], v[10:11]
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v10, 0, v8, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v8, 0, v8, s[4:5]
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; VI-SDAG-NEXT:    v_cmp_class_f64_e64 s[4:5], v[2:3], v9
; VI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v10
; VI-SDAG-NEXT:    v_ldexp_f64 v[6:7], v[6:7], v8
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v3, v5, v3, s[4:5]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, v4, v2, s[4:5]
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v7, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[5:6], s[6:7], v[0:1], v[0:1], -1.0
; VI-SDAG-NEXT:    v_div_scale_f64 v[7:8], s[4:5], v[2:3], v[2:3], 1.0
; VI-SDAG-NEXT:    v_div_scale_f64 v[17:18], s[4:5], 1.0, v[2:3], 1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[9:10], v[5:6]
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[11:12], v[7:8]
; VI-SDAG-NEXT:    v_fma_f64 v[13:14], -v[5:6], v[9:10], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[15:16], -v[7:8], v[11:12], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[9:10], v[9:10], v[13:14], v[9:10]
; VI-SDAG-NEXT:    v_div_scale_f64 v[13:14], vcc, -1.0, v[0:1], -1.0
; VI-SDAG-NEXT:    v_fma_f64 v[11:12], v[11:12], v[15:16], v[11:12]
; VI-SDAG-NEXT:    v_fma_f64 v[15:16], -v[5:6], v[9:10], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[19:20], -v[7:8], v[11:12], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[9:10], v[9:10], v[15:16], v[9:10]
; VI-SDAG-NEXT:    v_fma_f64 v[11:12], v[11:12], v[19:20], v[11:12]
; VI-SDAG-NEXT:    v_mul_f64 v[15:16], v[13:14], v[9:10]
; VI-SDAG-NEXT:    v_mul_f64 v[19:20], v[17:18], v[11:12]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[5:6], v[15:16], v[13:14]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[7:8], v[19:20], v[17:18]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[9:10], v[15:16]
; VI-SDAG-NEXT:    s_mov_b64 vcc, s[4:5]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[11:12], v[19:20]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], -1.0
; VI-SDAG-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_neg_pos_rsq_v2f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v5, 0, v4, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v5
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v4, 0, v4, s[4:5]
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[4:5], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[0:1], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[10:11], v[6:7], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[6:7], v[2:3], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[4:5], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[10:11], v[6:7], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[12:13], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[14:15], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[12:13], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[14:15], v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[12:13], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[14:15], v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v10, 0, v8, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v8, 0, v8, s[4:5]
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; VI-GISEL-NEXT:    v_cmp_class_f64_e64 s[4:5], v[2:3], v9
; VI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v10
; VI-GISEL-NEXT:    v_ldexp_f64 v[6:7], v[6:7], v8
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[4:5], s[6:7], v[0:1], v[0:1], -1.0
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], s[4:5], v[2:3], v[2:3], 1.0
; VI-GISEL-NEXT:    v_div_scale_f64 v[16:17], s[4:5], 1.0, v[2:3], 1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; VI-GISEL-NEXT:    v_div_scale_f64 v[12:13], vcc, -1.0, v[0:1], -1.0
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[4:5], v[8:9], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[18:19], -v[6:7], v[10:11], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[14:15], v[8:9]
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], v[10:11], v[18:19], v[10:11]
; VI-GISEL-NEXT:    v_mul_f64 v[14:15], v[12:13], v[8:9]
; VI-GISEL-NEXT:    v_mul_f64 v[18:19], v[16:17], v[10:11]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[14:15], v[12:13]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[6:7], v[18:19], v[16:17]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[8:9], v[14:15]
; VI-GISEL-NEXT:    s_mov_b64 vcc, s[4:5]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[6:7], v[6:7], v[10:11], v[18:19]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[0:1], -1.0
; VI-GISEL-NEXT:    v_div_fixup_f64 v[2:3], v[6:7], v[2:3], 1.0
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call <2 x double> @llvm.sqrt.v2f64(<2 x double> %x)
  %rsq = fdiv <2 x double> <double -1.0, double 1.0>, %sqrt
  ret <2 x double> %rsq
}

define double @v_rsq_f64_fneg_fabs(double %x) {
; SI-SDAG-LABEL: v_rsq_f64_fneg_fabs:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 9
; SI-SDAG-NEXT:    v_cmp_gt_f64_e64 vcc, |v[0:1]|, s[4:5]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], -|v[0:1]|, v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_mov_b32 s6, 0x3ff00000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], 1.0, v[0:1], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_f64_fneg_fabs:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_lt_f64_e64 vcc, -|v[0:1]|, s[4:5]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], -|v[0:1]|, v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], 1.0, v[0:1], 1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_f64_fneg_fabs:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 9
; VI-SDAG-NEXT:    v_cmp_gt_f64_e64 vcc, |v[0:1]|, s[4:5]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], -|v[0:1]|, v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_f64_fneg_fabs:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_lt_f64_e64 vcc, -|v[0:1]|, s[4:5]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], -|v[0:1]|, v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %fabs = call double @llvm.fabs.f64(double %x)
  %fneg.fabs = fneg double %fabs
  %sqrt = call contract double @llvm.sqrt.f64(double %fneg.fabs)
  %rsq = fdiv contract double 1.0, %sqrt
  ret double %rsq
}

define double @v_rsq_f64__afn_sqrt(double %x) {
; SI-SDAG-LABEL: v_rsq_f64__afn_sqrt:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_mov_b32 s6, 0x3ff00000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], 1.0, v[0:1], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_f64__afn_sqrt:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], 1.0, v[0:1], 1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_f64__afn_sqrt:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_f64__afn_sqrt:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract afn double @llvm.sqrt.f64(double %x)
  %rsq = fdiv contract double 1.0, %sqrt
  ret double %rsq
}

define double @v_rsq_f64__afn_fdiv(double %x) {
; SI-SDAG-LABEL: v_rsq_f64__afn_fdiv:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_f64__afn_fdiv:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_f64__afn_fdiv:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_f64__afn_fdiv:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract double @llvm.sqrt.f64(double %x)
  %rsq = fdiv contract afn double 1.0, %sqrt
  ret double %rsq
}

define double @v_rsq_f64__afn(double %x) {
; SI-SDAG-LABEL: v_rsq_f64__afn:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_f64__afn:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_f64__afn:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_f64__afn:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract afn double @llvm.sqrt.f64(double %x)
  %rsq = fdiv contract afn double 1.0, %sqrt
  ret double %rsq
}

define double @v_neg_rsq_f64__afn(double %x) {
; SI-SDAG-LABEL: v_neg_rsq_f64__afn:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[2:3], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_neg_rsq_f64__afn:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], -1.0, v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], -1.0
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_neg_rsq_f64__afn:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[2:3], -1.0
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], -1.0
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_neg_rsq_f64__afn:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], -1.0, v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], -1.0
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract afn double @llvm.sqrt.f64(double %x)
  %rsq = fdiv contract afn double -1.0, %sqrt
  ret double %rsq
}

define double @v_rsq_f64__afn_ninf(double %x) {
; SI-SDAG-LABEL: v_rsq_f64__afn_ninf:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_f64__afn_ninf:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_f64__afn_ninf:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_f64__afn_ninf:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract afn ninf double @llvm.sqrt.f64(double %x)
  %rsq = fdiv contract afn ninf double 1.0, %sqrt
  ret double %rsq
}

define double @v_rsq_f64__afn_nnan(double %x) {
; SI-SDAG-LABEL: v_rsq_f64__afn_nnan:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_f64__afn_nnan:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_f64__afn_nnan:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_f64__afn_nnan:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract afn nnan double @llvm.sqrt.f64(double %x)
  %rsq = fdiv contract afn nnan double 1.0, %sqrt
  ret double %rsq
}

define double @v_rsq_f64__afn_nnan_ninf(double %x) {
; SI-SDAG-LABEL: v_rsq_f64__afn_nnan_ninf:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_f64__afn_nnan_ninf:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_f64__afn_nnan_ninf:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_f64__afn_nnan_ninf:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract afn nnan ninf double @llvm.sqrt.f64(double %x)
  %rsq = fdiv contract afn nnan ninf double 1.0, %sqrt
  ret double %rsq
}

define double @v_neg_rsq_f64__afn_nnan_ninf(double %x) {
; SI-SDAG-LABEL: v_neg_rsq_f64__afn_nnan_ninf:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[2:3], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_neg_rsq_f64__afn_nnan_ninf:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], -1.0, v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], -1.0
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_neg_rsq_f64__afn_nnan_ninf:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[2:3], -1.0
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], -1.0
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_neg_rsq_f64__afn_nnan_ninf:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], -1.0, v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], -1.0
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract afn nnan ninf double @llvm.sqrt.f64(double %x)
  %rsq = fdiv contract afn nnan ninf double -1.0, %sqrt
  ret double %rsq
}

define double @v_rsq_f64__nnan_ninf(double %x) {
; SI-SDAG-LABEL: v_rsq_f64__nnan_ninf:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_mov_b32 s6, 0x3ff00000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], 1.0, v[0:1], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_f64__nnan_ninf:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], 1.0, v[0:1], 1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_f64__nnan_ninf:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_f64__nnan_ninf:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract nnan ninf double @llvm.sqrt.f64(double %x)
  %rsq = fdiv contract nnan ninf double 1.0, %sqrt
  ret double %rsq
}

define <2 x double> @v_rsq_v2f64__afn_nnan_ninf(<2 x double> %x) {
; SI-SDAG-LABEL: v_rsq_v2f64__afn_nnan_ninf:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_mov_b32_e32 v14, 0xffffff80
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v12, 0, v14, vcc
; SI-SDAG-NEXT:    v_mov_b32_e32 v15, 0x260
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v15
; SI-SDAG-NEXT:    v_mul_f64 v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v8, 0, 1, s[4:5]
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v8, 8, v8
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[6:7], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v8
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[10:11], v[4:5], v[6:7]
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[8:9], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[6:7], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[10:11], v[4:5], v[6:7]
; SI-SDAG-NEXT:    v_mul_f64 v[6:7], v[0:1], v[8:9]
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[8:9], 0.5
; SI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v12
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[8:9], v[6:7], 0.5
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], v[8:9], v[10:11], v[8:9]
; SI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[6:7], v[6:7], v[0:1]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[12:13], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v15
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[6:7], v[6:7], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[10:11], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v6, 0, v14, s[4:5]
; SI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[2:3], v[6:7], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[10:11], v[6:7], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[0:1], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[2:3], v[6:7], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[10:11], v[6:7], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[0:1], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[4:5], v[4:5]
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_v2f64__afn_nnan_ninf:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v10, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v4
; SI-GISEL-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[2:3]
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v12, 0xffffff80
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v13, 0, v12, vcc
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[0:1], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cndmask_b32_e64 v8, 0, v10, s[4:5]
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v8
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[10:11], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v13
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[10:11], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[8:9], v[2:3], v[10:11]
; SI-GISEL-NEXT:    v_mov_b32_e32 v13, 0x260
; SI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[6:7], v[8:9], 0.5
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v13
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[10:11], v[8:9]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[8:9], v[8:9], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], v[10:11], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; SI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[8:9], v[8:9], v[2:3]
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v13
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[10:11], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_cndmask_b32_e64 v6, 0, v12, s[4:5]
; SI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[0:1]
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[0:1], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[2:3], v[6:7], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[10:11], v[6:7], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[0:1], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[2:3], v[6:7], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[10:11], v[6:7], v[6:7]
; SI-GISEL-NEXT:    v_mul_f64 v[8:9], 1.0, v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[10:11], 1.0, v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[8:9], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[10:11], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[4:5], v[8:9]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[10:11]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_v2f64__afn_nnan_ninf:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; VI-SDAG-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, s[4:5]
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v4
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[6:7], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; VI-SDAG-NEXT:    v_mul_f64 v[10:11], v[0:1], v[6:7]
; VI-SDAG-NEXT:    v_mul_f64 v[6:7], v[6:7], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[8:9], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[10:11], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[12:13], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[14:15], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[8:9], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[10:11], v[10:11], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], v[12:13], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_fma_f64 v[10:11], v[14:15], v[6:7], v[10:11]
; VI-SDAG-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[8:9], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[14:15], -v[10:11], v[10:11], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[12:13], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[14:15], v[6:7], v[10:11]
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v10, 0, v8, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v8, 0, v8, s[4:5]
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; VI-SDAG-NEXT:    v_cmp_class_f64_e64 s[4:5], v[2:3], v9
; VI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v10
; VI-SDAG-NEXT:    v_ldexp_f64 v[6:7], v[6:7], v8
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v3, v5, v3, s[4:5]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, v4, v2, s[4:5]
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v7, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[5:6], v[0:1]
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[7:8], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[9:10], -v[0:1], v[5:6], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[11:12], -v[2:3], v[7:8], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[9:10], v[5:6], v[5:6]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[11:12], v[7:8], v[7:8]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[0:1], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[2:3], v[6:7], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[10:11], v[6:7], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[4:5], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[6:7]
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_v2f64__afn_nnan_ninf:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_cmp_gt_f64_e64 s[4:5], s[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v5, 0, v4, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v4, 0, v4, s[4:5]
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[4:5], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[0:1], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[10:11], v[6:7], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[6:7], v[2:3], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[8:9], v[4:5], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[10:11], v[6:7], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[12:13], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], v[8:9], v[12:13], v[8:9]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[14:15], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], v[10:11], v[14:15], v[10:11]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[12:13], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[14:15], v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[12:13], -v[4:5], v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[14:15], -v[6:7], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[12:13], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[14:15], v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v10, 0, v8, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v8, 0, v8, s[4:5]
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; VI-GISEL-NEXT:    v_cmp_class_f64_e64 s[4:5], v[2:3], v9
; VI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v10
; VI-GISEL-NEXT:    v_ldexp_f64 v[6:7], v[6:7], v8
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v2, v6, v2, s[4:5]
; VI-GISEL-NEXT:    v_cndmask_b32_e64 v3, v7, v3, s[4:5]
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[0:1]
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[0:1], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[2:3], v[6:7], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[10:11], v[6:7], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[0:1], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[2:3], v[6:7], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[10:11], v[6:7], v[6:7]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], 1.0, v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[10:11], 1.0, v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[8:9], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[10:11], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[10:11]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract afn nnan ninf <2 x double> @llvm.sqrt.v2f64(<2 x double> %x)
  %rsq = fdiv contract afn nnan ninf <2 x double> <double 1.0, double 1.0>, %sqrt
  ret <2 x double> %rsq
}

define amdgpu_ps <2 x i32> @s_rsq_f64_unsafe(double inreg %x) #0 {
; SI-SDAG-LABEL: s_rsq_f64_unsafe:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; SI-SDAG-NEXT:    v_bfrev_b32_e32 v1, 8
; SI-SDAG-NEXT:    v_cmp_lt_f64_e32 vcc, s[0:1], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0x260
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], s[0:1], v0
; SI-SDAG-NEXT:    s_and_b64 s[0:1], vcc, exec
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_cselect_b32 s0, 0xffffff80, 0
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v8
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], s0
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; SI-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; SI-SDAG-NEXT:    ; return to shader part epilog
;
; SI-GISEL-LABEL: s_rsq_f64_unsafe:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_mov_b32 s2, 0
; SI-GISEL-NEXT:    s_brev_b32 s3, 8
; SI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; SI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; SI-GISEL-NEXT:    v_cmp_lt_f64_e32 vcc, s[0:1], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], s[0:1], v0
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; SI-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; SI-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; SI-GISEL-NEXT:    ; return to shader part epilog
;
; VI-SDAG-LABEL: s_rsq_f64_unsafe:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    v_mov_b32_e32 v0, 0
; VI-SDAG-NEXT:    v_bfrev_b32_e32 v1, 8
; VI-SDAG-NEXT:    v_cmp_lt_f64_e32 vcc, s[0:1], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v0, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v0, 8, v0
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], s[0:1], v0
; VI-SDAG-NEXT:    s_and_b64 s[0:1], vcc, exec
; VI-SDAG-NEXT:    s_cselect_b32 s0, 0xffffff80, 0
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0x260
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], s0
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; VI-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; VI-SDAG-NEXT:    ; return to shader part epilog
;
; VI-GISEL-LABEL: s_rsq_f64_unsafe:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_mov_b32 s2, 0
; VI-GISEL-NEXT:    s_brev_b32 s3, 8
; VI-GISEL-NEXT:    v_mov_b32_e32 v0, s2
; VI-GISEL-NEXT:    v_mov_b32_e32 v1, s3
; VI-GISEL-NEXT:    v_cmp_lt_f64_e32 vcc, s[0:1], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], s[0:1], v0
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; VI-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; VI-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; VI-GISEL-NEXT:    ; return to shader part epilog
  %rsq = call contract double @llvm.sqrt.f64(double %x)
  %result = fdiv contract double 1.0, %rsq
  %cast = bitcast double %result to <2 x i32>
  %cast.0 = extractelement <2 x i32> %cast, i32 0
  %cast.1 = extractelement <2 x i32> %cast, i32 1
  %lane.0 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.0)
  %lane.1 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.1)
  %insert.0 = insertelement <2 x i32> poison, i32 %lane.0, i32 0
  %insert.1 = insertelement <2 x i32> %insert.0, i32 %lane.1, i32 1
  ret <2 x i32> %insert.1
}

define double @v_rsq_f64_unsafe(double %x) #0 {
; SI-SDAG-LABEL: v_rsq_f64_unsafe:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_f64_unsafe:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_f64_unsafe:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[2:3], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[2:3]
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_f64_unsafe:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[0:1], v[2:3], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[4:5], v[2:3], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], 1.0, v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], -v[0:1], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[0:1], v[0:1], v[2:3], v[4:5]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call double @llvm.sqrt.f64(double %x)
  %rsq = fdiv double 1.0, %sqrt
  ret double %rsq
}

define double @v_rsq_amdgcn_sqrt_f64(double %x) {
; SI-SDAG-LABEL: v_rsq_amdgcn_sqrt_f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    v_sqrt_f64_e32 v[0:1], v[0:1]
; SI-SDAG-NEXT:    s_mov_b32 s6, 0x3ff00000
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], 1.0, v[0:1], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_rsq_amdgcn_sqrt_f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    v_sqrt_f64_e32 v[0:1], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], 1.0, v[0:1], 1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_rsq_amdgcn_sqrt_f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    v_sqrt_f64_e32 v[0:1], v[0:1]
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_rsq_amdgcn_sqrt_f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    v_sqrt_f64_e32 v[0:1], v[0:1]
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], 1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract double @llvm.amdgcn.sqrt.f64(double %x)
  %rsq = fdiv contract double 1.0, %sqrt
  ret double %rsq
}

define double @v_neg_rsq_amdgcn_sqrt_f64(double %x) {
; SI-SDAG-LABEL: v_neg_rsq_amdgcn_sqrt_f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    v_sqrt_f64_e32 v[0:1], v[0:1]
; SI-SDAG-NEXT:    s_mov_b32 s6, 0xbff00000
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], -1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], -1.0, v[0:1], -1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s6, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_neg_rsq_amdgcn_sqrt_f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    v_sqrt_f64_e32 v[0:1], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0xbff00000
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], -1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], -1.0, v[0:1], -1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_neg_rsq_amdgcn_sqrt_f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    v_sqrt_f64_e32 v[0:1], v[0:1]
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], -1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, -1.0, v[0:1], -1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_neg_rsq_amdgcn_sqrt_f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    v_sqrt_f64_e32 v[0:1], v[0:1]
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], -1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, -1.0, v[0:1], -1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], -1.0
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract double @llvm.amdgcn.sqrt.f64(double %x)
  %rsq = fdiv contract double -1.0, %sqrt
  ret double %rsq
}

define amdgpu_ps <2 x i32> @s_rsq_amdgcn_sqrt_f64(double inreg %x) {
; SI-SDAG-LABEL: s_rsq_amdgcn_sqrt_f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    v_sqrt_f64_e32 v[0:1], s[0:1]
; SI-SDAG-NEXT:    s_mov_b32 s2, 0x3ff00000
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], 1.0
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[0:1], 1.0, v[0:1], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[0:1], s2, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[0:1], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; SI-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; SI-SDAG-NEXT:    ; return to shader part epilog
;
; SI-GISEL-LABEL: s_rsq_amdgcn_sqrt_f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    v_sqrt_f64_e32 v[0:1], s[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x3ff00000
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], 1.0
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[0:1], 1.0, v[0:1], 1.0
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[0:1], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; SI-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; SI-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; SI-GISEL-NEXT:    ; return to shader part epilog
;
; VI-SDAG-LABEL: s_rsq_amdgcn_sqrt_f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    v_sqrt_f64_e32 v[0:1], s[0:1]
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], 1.0
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-SDAG-NEXT:    v_readfirstlane_b32 s0, v0
; VI-SDAG-NEXT:    v_readfirstlane_b32 s1, v1
; VI-SDAG-NEXT:    ; return to shader part epilog
;
; VI-GISEL-LABEL: s_rsq_amdgcn_sqrt_f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    v_sqrt_f64_e32 v[0:1], s[0:1]
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[0:1], v[0:1], v[0:1], 1.0
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, 1.0, v[0:1], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], 1.0
; VI-GISEL-NEXT:    v_readfirstlane_b32 s0, v0
; VI-GISEL-NEXT:    v_readfirstlane_b32 s1, v1
; VI-GISEL-NEXT:    ; return to shader part epilog
  %rsq = call contract double @llvm.amdgcn.sqrt.f64(double %x)
  %result = fdiv contract double 1.0, %rsq
  %cast = bitcast double %result to <2 x i32>
  %cast.0 = extractelement <2 x i32> %cast, i32 0
  %cast.1 = extractelement <2 x i32> %cast, i32 1
  %lane.0 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.0)
  %lane.1 = call i32 @llvm.amdgcn.readfirstlane(i32 %cast.1)
  %insert.0 = insertelement <2 x i32> poison, i32 %lane.0, i32 0
  %insert.1 = insertelement <2 x i32> %insert.0, i32 %lane.1, i32 1
  ret <2 x i32> %insert.1
}

define double @v_div_contract_sqrt_f64(double %x, double %y) {
; SI-SDAG-LABEL: v_div_contract_sqrt_f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; SI-SDAG-NEXT:    v_mov_b32_e32 v10, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_mov_b32_e32 v11, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[8:9], v[4:5], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[6:7]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0, v10, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v11
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[0:1], v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v9
; SI-SDAG-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_div_contract_sqrt_f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; SI-GISEL-NEXT:    v_mov_b32_e32 v4, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v6, 0, v10, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; SI-GISEL-NEXT:    v_mov_b32_e32 v6, 0x260
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v6
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[0:1], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v3, v5
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v11
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_mul_f64 v[8:9], v[10:11], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[8:9], v[10:11]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_div_contract_sqrt_f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[8:9], v[4:5], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[6:7]
; VI-SDAG-NEXT:    v_mov_b32_e32 v6, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v7, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0, v6, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v7
; VI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_scale_f64 v[8:9], vcc, v[0:1], v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; VI-SDAG-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_div_contract_sqrt_f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[6:7], v[4:5], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[4:5], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_mov_b32_e32 v6, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v7, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v6, 0, v6, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v7
; VI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_scale_f64 v[8:9], vcc, v[0:1], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract double @llvm.sqrt.f64(double %y)
  %rsq = fdiv contract double %x, %sqrt
  ret double %rsq
}

define double @v_div_arcp_sqrt_f64(double %x, double %y) {
; SI-SDAG-LABEL: v_div_arcp_sqrt_f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; SI-SDAG-NEXT:    v_mov_b32_e32 v10, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_mov_b32_e32 v11, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[8:9], v[4:5], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[6:7]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0, v10, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v11
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[0:1], v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v9
; SI-SDAG-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_div_arcp_sqrt_f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; SI-GISEL-NEXT:    v_mov_b32_e32 v4, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v6, 0, v10, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; SI-GISEL-NEXT:    v_mov_b32_e32 v6, 0x260
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v6
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[0:1], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v3, v5
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v11
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_mul_f64 v[8:9], v[10:11], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[8:9], v[10:11]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_div_arcp_sqrt_f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[8:9], v[4:5], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[6:7]
; VI-SDAG-NEXT:    v_mov_b32_e32 v6, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v7, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0, v6, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v7
; VI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_scale_f64 v[8:9], vcc, v[0:1], v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; VI-SDAG-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_div_arcp_sqrt_f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[6:7], v[4:5], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[4:5], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_mov_b32_e32 v6, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v7, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v6, 0, v6, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v7
; VI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_scale_f64 v[8:9], vcc, v[0:1], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call double @llvm.sqrt.f64(double %y)
  %rsq = fdiv arcp double %x, %sqrt
  ret double %rsq
}

define double @v_div_contract_arcp_sqrt_f64(double %x, double %y) {
; SI-SDAG-LABEL: v_div_contract_arcp_sqrt_f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_mov_b32 s4, 0
; SI-SDAG-NEXT:    s_brev_b32 s5, 8
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; SI-SDAG-NEXT:    v_mov_b32_e32 v10, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_mov_b32_e32 v11, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[8:9], v[4:5], v[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[6:7]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0, v10, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v11
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v3, v5
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_scale_f64 v[8:9], s[4:5], v[0:1], v[2:3], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v9
; SI-SDAG-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_div_contract_arcp_sqrt_f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s4, 0
; SI-GISEL-NEXT:    s_brev_b32 s5, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; SI-GISEL-NEXT:    v_mov_b32_e32 v4, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[4:5], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v6, 0, v10, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; SI-GISEL-NEXT:    v_mov_b32_e32 v6, 0x260
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v6
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_div_scale_f64 v[10:11], s[4:5], v[0:1], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v3, v5
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v11
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; SI-GISEL-NEXT:    v_mul_f64 v[8:9], v[10:11], v[6:7]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[8:9], v[10:11]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_div_contract_arcp_sqrt_f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v4, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v4, 8, v4
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[8:9], v[4:5], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[8:9], v[4:5], v[6:7]
; VI-SDAG-NEXT:    v_mov_b32_e32 v6, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v7, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v6, 0, v6, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v7
; VI-SDAG-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_scale_f64 v[8:9], vcc, v[0:1], v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; VI-SDAG-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_div_contract_arcp_sqrt_f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0x100
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mul_f64 v[6:7], v[4:5], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[6:7], v[4:5], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_mov_b32_e32 v6, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v7, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v6, 0, v6, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[2:3], v7
; VI-GISEL-NEXT:    v_ldexp_f64 v[4:5], v[4:5], v6
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v3, v5, v3, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[4:5], s[4:5], v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[4:5], v[6:7], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_scale_f64 v[8:9], vcc, v[0:1], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[10:11], -v[4:5], v[6:7], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], v[6:7], v[10:11], v[6:7]
; VI-GISEL-NEXT:    v_mul_f64 v[10:11], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], -v[4:5], v[10:11], v[8:9]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[4:5], v[4:5], v[6:7], v[10:11]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[4:5], v[2:3], v[0:1]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract double @llvm.sqrt.f64(double %y)
  %rsq = fdiv contract arcp double %x, %sqrt
  ret double %rsq
}

define double @v_div_const_contract_sqrt_f64(double %x) {
; SI-SDAG-LABEL: v_div_const_contract_sqrt_f64:
; SI-SDAG:       ; %bb.0:
; SI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-SDAG-NEXT:    s_brev_b32 s7, 8
; SI-SDAG-NEXT:    s_mov_b32 s6, 0
; SI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[6:7], v[0:1]
; SI-SDAG-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; SI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; SI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-SDAG-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-SDAG-NEXT:    s_mov_b32 s7, 0x40700000
; SI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; SI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], s[6:7]
; SI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e32 vcc, v1, v3
; SI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-SDAG-NEXT:    v_div_scale_f64 v[6:7], s[4:5], s[6:7], v[0:1], s[6:7]
; SI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; SI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; SI-SDAG-NEXT:    v_cmp_eq_u32_e64 s[4:5], s7, v7
; SI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; SI-SDAG-NEXT:    s_xor_b64 vcc, s[4:5], vcc
; SI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; SI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; SI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], s[6:7]
; SI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; SI-GISEL-LABEL: v_div_const_contract_sqrt_f64:
; SI-GISEL:       ; %bb.0:
; SI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-GISEL-NEXT:    s_mov_b32 s6, 0
; SI-GISEL-NEXT:    s_brev_b32 s7, 8
; SI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[6:7], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; SI-GISEL-NEXT:    v_mov_b32_e32 v8, 0xffffff80
; SI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_mov_b32_e32 v9, 0x260
; SI-GISEL-NEXT:    s_mov_b32 s7, 0x40700000
; SI-GISEL-NEXT:    v_mov_b32_e32 v10, 0x40700000
; SI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v8, vcc
; SI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; SI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v9
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; SI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; SI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[4:5], v[0:1], v[0:1], s[6:7]
; SI-GISEL-NEXT:    v_div_scale_f64 v[8:9], s[4:5], s[6:7], v[0:1], s[6:7]
; SI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; SI-GISEL-NEXT:    v_cmp_eq_u32_e64 s[4:5], v1, v3
; SI-GISEL-NEXT:    v_cmp_eq_u32_e32 vcc, v10, v9
; SI-GISEL-NEXT:    s_xor_b64 vcc, vcc, s[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; SI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; SI-GISEL-NEXT:    v_mul_f64 v[6:7], v[8:9], v[4:5]
; SI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[6:7], v[8:9]
; SI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[6:7]
; SI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], s[6:7]
; SI-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; VI-SDAG-LABEL: v_div_const_contract_sqrt_f64:
; VI-SDAG:       ; %bb.0:
; VI-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-SDAG-NEXT:    s_brev_b32 s5, 8
; VI-SDAG-NEXT:    s_mov_b32 s4, 0
; VI-SDAG-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-SDAG-NEXT:    s_mov_b32 s5, 0x40700000
; VI-SDAG-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; VI-SDAG-NEXT:    v_lshlrev_b32_e32 v2, 8, v2
; VI-SDAG-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-SDAG-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-SDAG-NEXT:    v_mul_f64 v[4:5], v[0:1], v[2:3]
; VI-SDAG-NEXT:    v_mul_f64 v[2:3], v[2:3], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 0.5
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[4:5], v[0:1]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], v[6:7], v[2:3], v[4:5]
; VI-SDAG-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-SDAG-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-SDAG-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-SDAG-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-SDAG-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-SDAG-NEXT:    v_div_scale_f64 v[2:3], s[6:7], v[0:1], v[0:1], s[4:5]
; VI-SDAG-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-SDAG-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_div_scale_f64 v[6:7], vcc, s[4:5], v[0:1], s[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-SDAG-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-SDAG-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-SDAG-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-SDAG-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-SDAG-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], s[4:5]
; VI-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; VI-GISEL-LABEL: v_div_const_contract_sqrt_f64:
; VI-GISEL:       ; %bb.0:
; VI-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-GISEL-NEXT:    s_mov_b32 s4, 0
; VI-GISEL-NEXT:    s_brev_b32 s5, 8
; VI-GISEL-NEXT:    v_cmp_gt_f64_e32 vcc, s[4:5], v[0:1]
; VI-GISEL-NEXT:    v_mov_b32_e32 v2, 0x100
; VI-GISEL-NEXT:    s_mov_b32 s5, 0x40700000
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; VI-GISEL-NEXT:    v_ldexp_f64 v[0:1], v[0:1], v2
; VI-GISEL-NEXT:    v_rsq_f64_e32 v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_mul_f64 v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_mul_f64 v[2:3], v[0:1], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[4:5], v[2:3], 0.5
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[2:3], v[6:7], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[2:3], v[0:1]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], v[6:7], v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_mov_b32_e32 v4, 0xffffff80
; VI-GISEL-NEXT:    v_mov_b32_e32 v5, 0x260
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v4, 0, v4, vcc
; VI-GISEL-NEXT:    v_cmp_class_f64_e32 vcc, v[0:1], v5
; VI-GISEL-NEXT:    v_ldexp_f64 v[2:3], v[2:3], v4
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; VI-GISEL-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; VI-GISEL-NEXT:    v_div_scale_f64 v[2:3], s[6:7], v[0:1], v[0:1], s[4:5]
; VI-GISEL-NEXT:    v_rcp_f64_e32 v[4:5], v[2:3]
; VI-GISEL-NEXT:    v_fma_f64 v[6:7], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_div_scale_f64 v[6:7], vcc, s[4:5], v[0:1], s[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[8:9], -v[2:3], v[4:5], 1.0
; VI-GISEL-NEXT:    v_fma_f64 v[4:5], v[4:5], v[8:9], v[4:5]
; VI-GISEL-NEXT:    v_mul_f64 v[8:9], v[6:7], v[4:5]
; VI-GISEL-NEXT:    v_fma_f64 v[2:3], -v[2:3], v[8:9], v[6:7]
; VI-GISEL-NEXT:    v_div_fmas_f64 v[2:3], v[2:3], v[4:5], v[8:9]
; VI-GISEL-NEXT:    v_div_fixup_f64 v[0:1], v[2:3], v[0:1], s[4:5]
; VI-GISEL-NEXT:    s_setpc_b64 s[30:31]
  %sqrt = call contract double @llvm.sqrt.f64(double %x)
  %rsq = fdiv contract double 256.0, %sqrt
  ret double %rsq
}

attributes #0 = { "unsafe-fp-math"="true" }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GCN: {{.*}}
; GISEL: {{.*}}
; SDAG: {{.*}}
