; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=gfx900 < %s | FileCheck %s -check-prefix=GFX9
; RUN: llc -global-isel -march=amdgcn -mcpu=gfx900 < %s | FileCheck %s -check-prefix=GFX9

; Marking the image loads as invariant should allow both loads to be hoisted
; above both stores.
define amdgpu_ps void @test(<8 x i32> inreg %load, <8 x i32> inreg %store) {
; GFX9-LABEL: test:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 1
; GFX9-NEXT:    image_load v2, v0, s[0:7] dmask:0x1 unorm
; GFX9-NEXT:    image_load v3, v1, s[0:7] dmask:0x1 unorm
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    image_store v2, v0, s[8:15] dmask:0x1 unorm
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    image_store v3, v1, s[8:15] dmask:0x1 unorm
; GFX9-NEXT:    s_endpgm
  %data0 = call float @llvm.amdgcn.image.load.1d.f32.i32(i32 1, i32 0, <8 x i32> %load, i32 0, i32 0), !invariant.load !0
  call void @llvm.amdgcn.image.store.1d.f32.i32(float %data0, i32 1, i32 0, <8 x i32> %store, i32 0, i32 0)
  %data1 = call float @llvm.amdgcn.image.load.1d.f32.i32(i32 1, i32 1, <8 x i32> %load, i32 0, i32 0), !invariant.load !0
  call void @llvm.amdgcn.image.store.1d.f32.i32(float %data1, i32 1, i32 1, <8 x i32> %store, i32 0, i32 0)
  ret void
}

declare float @llvm.amdgcn.image.load.1d.f32.i32(i32 immarg, i32, <8 x i32>, i32 immarg, i32 immarg)
declare void @llvm.amdgcn.image.store.1d.f32.i32(float, i32 immarg, i32, <8 x i32>, i32 immarg, i32 immarg)

!0 = !{}
