; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64-linux-gnu -mattr=+sve | FileCheck %s

define <vscale x 4 x half> @interleave2_nxv4f16(<vscale x 2 x half> %vec0, <vscale x 2 x half> %vec1) {
; CHECK-LABEL: interleave2_nxv4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip2 z2.d, z0.d, z1.d
; CHECK-NEXT:    zip1 z0.d, z0.d, z1.d
; CHECK-NEXT:    uzp1 z0.s, z0.s, z2.s
; CHECK-NEXT:    ret
  %retval = call <vscale x 4 x half> @llvm.experimental.vector.interleave2.nxv4f16(<vscale x 2 x half> %vec0, <vscale x 2 x half> %vec1)
  ret  <vscale x 4 x half>   %retval
}

define <vscale x 8 x half> @interleave2_nxv8f16(<vscale x 4 x half> %vec0, <vscale x 4 x half> %vec1) {
; CHECK-LABEL: interleave2_nxv8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip2 z2.s, z0.s, z1.s
; CHECK-NEXT:    zip1 z0.s, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z2.h
; CHECK-NEXT:    ret
  %retval = call <vscale x 8 x half> @llvm.experimental.vector.interleave2.nxv8f16(<vscale x 4 x half> %vec0, <vscale x 4 x half> %vec1)
  ret  <vscale x 8 x half>   %retval
}

define <vscale x 16 x half> @interleave2_nxv16f16(<vscale x 8 x half> %vec0, <vscale x 8 x half> %vec1) {
; CHECK-LABEL: interleave2_nxv16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip1 z2.h, z0.h, z1.h
; CHECK-NEXT:    zip2 z1.h, z0.h, z1.h
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    ret
  %retval = call <vscale x 16 x half> @llvm.experimental.vector.interleave2.nxv16f16(<vscale x 8 x half> %vec0, <vscale x 8 x half> %vec1)
  ret  <vscale x 16 x half>   %retval
}

define <vscale x 4 x float> @interleave2_nxv4f32(<vscale x 2 x float> %vec0, <vscale x 2 x float> %vec1) {
; CHECK-LABEL: interleave2_nxv4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip2 z2.d, z0.d, z1.d
; CHECK-NEXT:    zip1 z0.d, z0.d, z1.d
; CHECK-NEXT:    uzp1 z0.s, z0.s, z2.s
; CHECK-NEXT:    ret
  %retval = call <vscale x 4 x float> @llvm.experimental.vector.interleave2.nxv4f32(<vscale x 2 x float> %vec0, <vscale x 2 x float> %vec1)
  ret  <vscale x 4 x float>   %retval
}

define <vscale x 8 x float> @interleave2_nxv8f32(<vscale x 4 x float> %vec0, <vscale x 4 x float> %vec1) {
; CHECK-LABEL: interleave2_nxv8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip1 z2.s, z0.s, z1.s
; CHECK-NEXT:    zip2 z1.s, z0.s, z1.s
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    ret
  %retval = call <vscale x 8 x float> @llvm.experimental.vector.interleave2.nxv8f32(<vscale x 4 x float> %vec0, <vscale x 4 x float> %vec1)
  ret  <vscale x 8 x float>   %retval
}

define <vscale x 4 x double> @interleave2_nxv4f64(<vscale x 2 x double> %vec0, <vscale x 2 x double> %vec1) {
; CHECK-LABEL: interleave2_nxv4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip1 z2.d, z0.d, z1.d
; CHECK-NEXT:    zip2 z1.d, z0.d, z1.d
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    ret
  %retval = call <vscale x 4 x double>@llvm.experimental.vector.interleave2.nxv4f64(<vscale x 2 x double> %vec0, <vscale x 2 x double> %vec1)
  ret  <vscale x 4 x double>   %retval
}

; Integers

define <vscale x 32 x i8> @interleave2_nxv32i8(<vscale x 16 x i8> %vec0, <vscale x 16 x i8> %vec1) {
; CHECK-LABEL: interleave2_nxv32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip1 z2.b, z0.b, z1.b
; CHECK-NEXT:    zip2 z1.b, z0.b, z1.b
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    ret
   %retval = call <vscale x 32 x i8> @llvm.experimental.vector.interleave2.nxv32i8(<vscale x 16 x i8> %vec0, <vscale x 16 x i8> %vec1)
  ret  <vscale x 32 x i8>   %retval
}

define <vscale x 16 x i16> @interleave2_nxv16i16(<vscale x 8 x i16> %vec0, <vscale x 8 x i16> %vec1) {
; CHECK-LABEL: interleave2_nxv16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip1 z2.h, z0.h, z1.h
; CHECK-NEXT:    zip2 z1.h, z0.h, z1.h
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    ret
  %retval = call <vscale x 16 x i16> @llvm.experimental.vector.interleave2.nxv16i16(<vscale x 8 x i16> %vec0, <vscale x 8 x i16> %vec1)
  ret  <vscale x 16 x i16>   %retval
}

define <vscale x 8 x i32> @interleave2_nxv8i32(<vscale x 4 x i32> %vec0, <vscale x 4 x i32> %vec1) {
; CHECK-LABEL: interleave2_nxv8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip1 z2.s, z0.s, z1.s
; CHECK-NEXT:    zip2 z1.s, z0.s, z1.s
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    ret
  %retval = call <vscale x 8 x i32> @llvm.experimental.vector.interleave2.nxv8i32(<vscale x 4 x i32> %vec0, <vscale x 4 x i32> %vec1)
  ret  <vscale x 8 x i32>   %retval
}

define <vscale x 4 x i64> @interleave2_nxv4i64(<vscale x 2 x i64> %vec0, <vscale x 2 x i64> %vec1) {
; CHECK-LABEL: interleave2_nxv4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip1 z2.d, z0.d, z1.d
; CHECK-NEXT:    zip2 z1.d, z0.d, z1.d
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    ret
  %retval = call <vscale x 4 x i64> @llvm.experimental.vector.interleave2.nxv4i64(<vscale x 2 x i64> %vec0, <vscale x 2 x i64> %vec1)
  ret  <vscale x 4 x i64>   %retval
}

; Predicated

define <vscale x 32 x i1> @interleave2_nxv32i1(<vscale x 16 x i1> %vec0, <vscale x 16 x i1> %vec1) {
; CHECK-LABEL: interleave2_nxv32i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip1 p2.b, p0.b, p1.b
; CHECK-NEXT:    zip2 p1.b, p0.b, p1.b
; CHECK-NEXT:    mov p0.b, p2.b
; CHECK-NEXT:    ret
   %retval = call <vscale x 32 x i1> @llvm.experimental.vector.interleave2.nxv32i1(<vscale x 16 x i1> %vec0, <vscale x 16 x i1> %vec1)
  ret  <vscale x 32 x i1>   %retval
}

define <vscale x 16 x i1> @interleave2_nxv16i1(<vscale x 8 x i1> %vec0, <vscale x 8 x i1> %vec1) {
; CHECK-LABEL: interleave2_nxv16i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip2 p2.h, p0.h, p1.h
; CHECK-NEXT:    zip1 p0.h, p0.h, p1.h
; CHECK-NEXT:    uzp1 p0.b, p0.b, p2.b
; CHECK-NEXT:    ret
  %retval = call <vscale x 16 x i1> @llvm.experimental.vector.interleave2.nxv16i1(<vscale x 8 x i1> %vec0, <vscale x 8 x i1> %vec1)
  ret  <vscale x 16 x i1>   %retval
}

define <vscale x 8 x i1> @interleave2_nxv8i1(<vscale x 4 x i1> %vec0, <vscale x 4 x i1> %vec1) {
; CHECK-LABEL: interleave2_nxv8i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip2 p2.s, p0.s, p1.s
; CHECK-NEXT:    zip1 p0.s, p0.s, p1.s
; CHECK-NEXT:    uzp1 p0.h, p0.h, p2.h
; CHECK-NEXT:    ret
  %retval = call <vscale x 8 x i1> @llvm.experimental.vector.interleave2.nxv8i1(<vscale x 4 x i1> %vec0, <vscale x 4 x i1> %vec1)
  ret  <vscale x 8 x i1>   %retval
}

define <vscale x 4 x i1> @interleave2_nxv4i1(<vscale x 2 x i1> %vec0, <vscale x 2 x i1> %vec1) {
; CHECK-LABEL: interleave2_nxv4i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip2 p2.d, p0.d, p1.d
; CHECK-NEXT:    zip1 p0.d, p0.d, p1.d
; CHECK-NEXT:    uzp1 p0.s, p0.s, p2.s
; CHECK-NEXT:    ret
  %retval = call <vscale x 4 x i1> @llvm.experimental.vector.interleave2.nxv4i1(<vscale x 2 x i1> %vec0, <vscale x 2 x i1> %vec1)
  ret  <vscale x 4 x i1>   %retval
}

; Split illegal type size

define <vscale x 16 x i32> @interleave2_nxv16i32(<vscale x 8 x i32> %vec0, <vscale x 8 x i32> %vec1) {
; CHECK-LABEL: interleave2_nxv16i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip1 z4.s, z0.s, z2.s
; CHECK-NEXT:    zip2 z5.s, z0.s, z2.s
; CHECK-NEXT:    zip1 z2.s, z1.s, z3.s
; CHECK-NEXT:    zip2 z3.s, z1.s, z3.s
; CHECK-NEXT:    mov z0.d, z4.d
; CHECK-NEXT:    mov z1.d, z5.d
; CHECK-NEXT:    ret
  %retval = call <vscale x 16 x i32>@llvm.experimental.vector.interleave2.nxv16i32(<vscale x 8 x i32> %vec0, <vscale x 8 x i32> %vec1)
  ret <vscale x 16 x i32> %retval
}

define <vscale x 8 x i64> @interleave2_nxv8i64(<vscale x 4 x i64> %vec0, <vscale x 4 x i64> %vec1) {
; CHECK-LABEL: interleave2_nxv8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip1 z4.d, z0.d, z2.d
; CHECK-NEXT:    zip2 z5.d, z0.d, z2.d
; CHECK-NEXT:    zip1 z2.d, z1.d, z3.d
; CHECK-NEXT:    zip2 z3.d, z1.d, z3.d
; CHECK-NEXT:    mov z0.d, z4.d
; CHECK-NEXT:    mov z1.d, z5.d
; CHECK-NEXT:    ret
  %retval = call <vscale x 8 x i64> @llvm.experimental.vector.interleave2.nxv8i64(<vscale x 4 x i64> %vec0, <vscale x 4 x i64> %vec1)
  ret <vscale x 8 x i64> %retval
}

; Promote illegal type size

define <vscale x 16 x i8> @interleave2_nxv8i8(<vscale x 8 x i8> %vec0, <vscale x 8 x i8> %vec1) {
; CHECK-LABEL: interleave2_nxv8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip2 z2.h, z0.h, z1.h
; CHECK-NEXT:    zip1 z0.h, z0.h, z1.h
; CHECK-NEXT:    uzp1 z0.b, z0.b, z2.b
; CHECK-NEXT:    ret
  %retval = call <vscale x 16 x i8> @llvm.experimental.vector.interleave2.nxv16i8(<vscale x 8 x i8> %vec0, <vscale x 8 x i8> %vec1)
  ret <vscale x 16 x i8> %retval
}

define <vscale x 8 x i16> @interleave2_nxv4i16(<vscale x 4 x i16> %vec0, <vscale x 4 x i16> %vec1) {
; CHECK-LABEL: interleave2_nxv4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip2 z2.s, z0.s, z1.s
; CHECK-NEXT:    zip1 z0.s, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z2.h
; CHECK-NEXT:    ret
  %retval = call <vscale x 8 x i16> @llvm.experimental.vector.interleave2.nxv8i16(<vscale x 4 x i16> %vec0, <vscale x 4 x i16> %vec1)
  ret <vscale x 8 x i16> %retval
}

define <vscale x 4 x i32> @interleave2_nxv2i32(<vscale x 2 x i32> %vec0, <vscale x 2 x i32> %vec1) {
; CHECK-LABEL: interleave2_nxv2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip2 z2.d, z0.d, z1.d
; CHECK-NEXT:    zip1 z0.d, z0.d, z1.d
; CHECK-NEXT:    uzp1 z0.s, z0.s, z2.s
; CHECK-NEXT:    ret
  %retval = call <vscale x 4 x i32> @llvm.experimental.vector.interleave2.nxv4i32(<vscale x 2 x i32> %vec0, <vscale x 2 x i32> %vec1)
  ret <vscale x 4 x i32> %retval
}

; Float declarations
declare <vscale x 4 x half> @llvm.experimental.vector.interleave2.nxv4f16(<vscale x 2 x half>, <vscale x 2 x half>)
declare <vscale x 8 x half> @llvm.experimental.vector.interleave2.nxv8f16(<vscale x 4 x half>, <vscale x 4 x half>)
declare <vscale x 16 x half> @llvm.experimental.vector.interleave2.nxv16f16(<vscale x 8 x half>, <vscale x 8 x half>)
declare <vscale x 4 x float> @llvm.experimental.vector.interleave2.nxv4f32(<vscale x 2 x float>, <vscale x 2 x float>)
declare <vscale x 8 x float> @llvm.experimental.vector.interleave2.nxv8f32(<vscale x 4 x float>, <vscale x 4 x float>)
declare <vscale x 4 x double> @llvm.experimental.vector.interleave2.nxv4f64(<vscale x 2 x double>, <vscale x 2 x double>)

; Integer declarations
declare <vscale x 32 x i8> @llvm.experimental.vector.interleave2.nxv32i8(<vscale x 16 x i8>, <vscale x 16 x i8>)
declare <vscale x 16 x i16> @llvm.experimental.vector.interleave2.nxv16i16(<vscale x 8 x i16>, <vscale x 8 x i16>)
declare <vscale x 8 x i32> @llvm.experimental.vector.interleave2.nxv8i32(<vscale x 4 x i32>, <vscale x 4 x i32>)
declare <vscale x 4 x i64> @llvm.experimental.vector.interleave2.nxv4i64(<vscale x 2 x i64>, <vscale x 2 x i64>)

; Predicated
declare <vscale x 32 x i1> @llvm.experimental.vector.interleave2.nxv32i1(<vscale x 16 x i1>, <vscale x 16 x i1>)
declare <vscale x 16 x i1> @llvm.experimental.vector.interleave2.nxv16i1(<vscale x 8 x i1>, <vscale x 8 x i1>)
declare <vscale x 8 x i1> @llvm.experimental.vector.interleave2.nxv8i1(<vscale x 4 x i1>, <vscale x 4 x i1>)
declare <vscale x 4 x i1> @llvm.experimental.vector.interleave2.nxv4i1(<vscale x 2 x i1>, <vscale x 2 x i1>)

; Illegal type size
declare <vscale x 16 x i32> @llvm.experimental.vector.interleave2.nxv16i32(<vscale x 8 x i32>, <vscale x 8 x i32>)
declare <vscale x 8 x i64> @llvm.experimental.vector.interleave2.nxv8i64(<vscale x 4 x i64>, <vscale x 4 x i64>)

declare <vscale x 16 x i8> @llvm.experimental.vector.interleave2.nxv16i8(<vscale x 8 x i8>, <vscale x 8 x i8>)
declare <vscale x 8 x i16> @llvm.experimental.vector.interleave2.nxv8i16(<vscale x 4 x i16>, <vscale x 4 x i16>)
declare <vscale x 4 x i32> @llvm.experimental.vector.interleave2.nxv4i32(<vscale x 2 x i32>, <vscale x 2 x i32>)
