; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve < %s | FileCheck %s

; FDIV

define <vscale x 8 x half> @fdiv_8f16(<vscale x 8 x half> %a, <vscale x 8 x half> %b) {
; CHECK-LABEL: fdiv_8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fdiv z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
  %fdiv = fdiv fast <vscale x 8 x half> %a, %b
  ret <vscale x 8 x half> %fdiv
}

define <vscale x 8 x half> @fdiv_recip_8f16(<vscale x 8 x half> %a, <vscale x 8 x half> %b) #0 {
; CHECK-LABEL: fdiv_recip_8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    frecpe z2.h, z1.h
; CHECK-NEXT:    frecps z3.h, z1.h, z2.h
; CHECK-NEXT:    fmul z2.h, z2.h, z3.h
; CHECK-NEXT:    frecps z1.h, z1.h, z2.h
; CHECK-NEXT:    fmul z1.h, z2.h, z1.h
; CHECK-NEXT:    fmul z0.h, z1.h, z0.h
; CHECK-NEXT:    ret
  %fdiv = fdiv fast <vscale x 8 x half> %a, %b
  ret <vscale x 8 x half> %fdiv
}

define <vscale x 4 x float> @fdiv_4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %b) {
; CHECK-LABEL: fdiv_4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fdiv z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
  %fdiv = fdiv fast <vscale x 4 x float> %a, %b
  ret <vscale x 4 x float> %fdiv
}

define <vscale x 4 x float> @fdiv_recip_4f32(<vscale x 4 x float> %a, <vscale x 4 x float> %b) #0 {
; CHECK-LABEL: fdiv_recip_4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    frecpe z2.s, z1.s
; CHECK-NEXT:    frecps z3.s, z1.s, z2.s
; CHECK-NEXT:    fmul z2.s, z2.s, z3.s
; CHECK-NEXT:    frecps z1.s, z1.s, z2.s
; CHECK-NEXT:    fmul z1.s, z2.s, z1.s
; CHECK-NEXT:    fmul z0.s, z1.s, z0.s
; CHECK-NEXT:    ret
  %fdiv = fdiv fast <vscale x 4 x float> %a, %b
  ret <vscale x 4 x float> %fdiv
}

define <vscale x 2 x double> @fdiv_2f64(<vscale x 2 x double> %a, <vscale x 2 x double> %b) {
; CHECK-LABEL: fdiv_2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fdiv z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
  %fdiv = fdiv fast <vscale x 2 x double> %a, %b
  ret <vscale x 2 x double> %fdiv
}

define <vscale x 2 x double> @fdiv_recip_2f64(<vscale x 2 x double> %a, <vscale x 2 x double> %b) #0 {
; CHECK-LABEL: fdiv_recip_2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    frecpe z2.d, z1.d
; CHECK-NEXT:    frecps z3.d, z1.d, z2.d
; CHECK-NEXT:    fmul z2.d, z2.d, z3.d
; CHECK-NEXT:    frecps z3.d, z1.d, z2.d
; CHECK-NEXT:    fmul z2.d, z2.d, z3.d
; CHECK-NEXT:    frecps z1.d, z1.d, z2.d
; CHECK-NEXT:    fmul z1.d, z2.d, z1.d
; CHECK-NEXT:    fmul z0.d, z1.d, z0.d
; CHECK-NEXT:    ret
  %fdiv = fdiv fast <vscale x 2 x double> %a, %b
  ret <vscale x 2 x double> %fdiv
}

; FSQRT

define <vscale x 8 x half> @fsqrt_8f16(<vscale x 8 x half> %a) {
; CHECK-LABEL: fsqrt_8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fsqrt z0.h, p0/m, z0.h
; CHECK-NEXT:    ret
  %fsqrt = call fast <vscale x 8 x half> @llvm.sqrt.nxv8f16(<vscale x 8 x half> %a)
  ret <vscale x 8 x half> %fsqrt
}

define <vscale x 8 x half> @fsqrt_recip_8f16(<vscale x 8 x half> %a) #0 {
; CHECK-LABEL: fsqrt_recip_8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    frsqrte z1.h, z0.h
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    fmul z2.h, z1.h, z1.h
; CHECK-NEXT:    fcmne p0.h, p0/z, z0.h, #0.0
; CHECK-NEXT:    frsqrts z2.h, z0.h, z2.h
; CHECK-NEXT:    fmul z1.h, z1.h, z2.h
; CHECK-NEXT:    fmul z2.h, z1.h, z1.h
; CHECK-NEXT:    frsqrts z2.h, z0.h, z2.h
; CHECK-NEXT:    fmul z1.h, z1.h, z2.h
; CHECK-NEXT:    fmul z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    ret
  %fsqrt = call fast <vscale x 8 x half> @llvm.sqrt.nxv8f16(<vscale x 8 x half> %a)
  ret <vscale x 8 x half> %fsqrt
}

define <vscale x 4 x float> @fsqrt_4f32(<vscale x 4 x float> %a) {
; CHECK-LABEL: fsqrt_4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fsqrt z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %fsqrt = call fast <vscale x 4 x float> @llvm.sqrt.nxv4f32(<vscale x 4 x float> %a)
  ret <vscale x 4 x float> %fsqrt
}

define <vscale x 4 x float> @fsqrt_recip_4f32(<vscale x 4 x float> %a) #0 {
; CHECK-LABEL: fsqrt_recip_4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    frsqrte z1.s, z0.s
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fmul z2.s, z1.s, z1.s
; CHECK-NEXT:    fcmne p0.s, p0/z, z0.s, #0.0
; CHECK-NEXT:    frsqrts z2.s, z0.s, z2.s
; CHECK-NEXT:    fmul z1.s, z1.s, z2.s
; CHECK-NEXT:    fmul z2.s, z1.s, z1.s
; CHECK-NEXT:    frsqrts z2.s, z0.s, z2.s
; CHECK-NEXT:    fmul z1.s, z1.s, z2.s
; CHECK-NEXT:    fmul z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    ret
  %fsqrt = call fast <vscale x 4 x float> @llvm.sqrt.nxv4f32(<vscale x 4 x float> %a)
  ret <vscale x 4 x float> %fsqrt
}

define <vscale x 2 x double> @fsqrt_2f64(<vscale x 2 x double> %a) {
; CHECK-LABEL: fsqrt_2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fsqrt z0.d, p0/m, z0.d
; CHECK-NEXT:    ret
  %fsqrt = call fast <vscale x 2 x double> @llvm.sqrt.nxv2f64(<vscale x 2 x double> %a)
  ret <vscale x 2 x double> %fsqrt
}

define <vscale x 2 x double> @fsqrt_recip_2f64(<vscale x 2 x double> %a) #0 {
; CHECK-LABEL: fsqrt_recip_2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    frsqrte z1.d, z0.d
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fmul z2.d, z1.d, z1.d
; CHECK-NEXT:    fcmne p0.d, p0/z, z0.d, #0.0
; CHECK-NEXT:    frsqrts z2.d, z0.d, z2.d
; CHECK-NEXT:    fmul z1.d, z1.d, z2.d
; CHECK-NEXT:    fmul z2.d, z1.d, z1.d
; CHECK-NEXT:    frsqrts z2.d, z0.d, z2.d
; CHECK-NEXT:    fmul z1.d, z1.d, z2.d
; CHECK-NEXT:    fmul z2.d, z1.d, z1.d
; CHECK-NEXT:    frsqrts z2.d, z0.d, z2.d
; CHECK-NEXT:    fmul z1.d, z1.d, z2.d
; CHECK-NEXT:    fmul z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    ret
  %fsqrt = call fast <vscale x 2 x double> @llvm.sqrt.nxv2f64(<vscale x 2 x double> %a)
  ret <vscale x 2 x double> %fsqrt
}

declare <vscale x 2 x half> @llvm.sqrt.nxv2f16(<vscale x 2 x half>)
declare <vscale x 4 x half> @llvm.sqrt.nxv4f16(<vscale x 4 x half>)
declare <vscale x 8 x half> @llvm.sqrt.nxv8f16(<vscale x 8 x half>)
declare <vscale x 2 x float> @llvm.sqrt.nxv2f32(<vscale x 2 x float>)
declare <vscale x 4 x float> @llvm.sqrt.nxv4f32(<vscale x 4 x float>)
declare <vscale x 2 x double> @llvm.sqrt.nxv2f64(<vscale x 2 x double>)

attributes #0 = { "reciprocal-estimates"="all" }
