/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UCharacterIterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;
import java.util.Locale;

class TitlecaseTransliterator
extends Transliterator {
    static final String _ID = "Any-Title";
    private Locale loc;
    static final UnicodeSet SKIP = new UnicodeSet("[\u00ad \u2019 \\' [:Mn:] [:Me:] [:Cf:] [:Lm:] [:Sk:]]");
    static final UnicodeSet CASED = new UnicodeSet("[[:Lu:] [:Ll:] [:Lt:]]");
    private char[] buffer = new char[10];
    private static final UCharacterProperty m_charppty_ = UCharacterProperty.getInstance();

    static void register() {
        Transliterator.registerFactory(_ID, new Transliterator.Factory(){

            public Transliterator getInstance(String ID) {
                return new TitlecaseTransliterator(Locale.US);
            }
        });
        Transliterator.registerSpecialInverse("Title", "Lower", false);
    }

    public TitlecaseTransliterator(Locale loc) {
        super(_ID, null);
        this.loc = loc;
        this.setMaximumContextLength(2);
    }

    protected void handleTransliterate(Replaceable text, Transliterator.Position offsets, boolean incremental) {
        boolean doTitle = true;
        int start = offsets.start - 1;
        while (start >= offsets.contextStart) {
            int c = text.char32At(start);
            if (!SKIP.contains(c)) {
                doTitle = !CASED.contains(c);
                break;
            }
            start -= UTF16.getCharCount(c);
        }
        int textPos = offsets.start;
        if (textPos >= offsets.limit) {
            return;
        }
        UCharacterIterator original = UCharacterIterator.getInstance(text);
        int limit = offsets.limit;
        while (textPos < limit) {
            original.setIndex(textPos);
            int cp = original.currentCodePoint();
            int oldLen = UTF16.getCharCount(cp);
            if (!SKIP.contains(cp)) {
                int newLen = doTitle ? m_charppty_.toUpperOrTitleCase(this.loc, cp, original, false, this.buffer) : m_charppty_.toLowerCase(this.loc, cp, original, this.buffer);
                boolean bl = doTitle = !CASED.contains(cp);
                if (newLen >= 0) {
                    text.replace(textPos, textPos + oldLen, this.buffer, 0, newLen);
                    if (newLen != oldLen) {
                        textPos += newLen;
                        offsets.limit += newLen - oldLen;
                        offsets.contextLimit += newLen - oldLen;
                        continue;
                    }
                }
            }
            textPos += oldLen;
        }
        offsets.start = offsets.limit;
    }
}

