/**********************************************************************
 * Example veriusertfs table that is used by many Verilog simulators
 * to register PLI applications that use the TF and ACC libraries of
 * the IEEE 1364 PLI.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *********************************************************************/

/* prototypes of the PLI application routines */
extern int PLIbook_ListPorts_checktf(),
           PLIbook_ListPorts_calltf();
extern int PLIbook_PortInfo_checktf(),
           PLIbook_PortInfo_calltf();
extern int PLIbook_ListCells_checktf(),
           PLIbook_ListCells_calltf();
extern int PLIbook_CountLoads_checktf(),
           PLIbook_CountLoads_sizetf(),
           PLIbook_CountLoads_calltf();
extern int PLIbook_DisplayNets_checktf(),
           PLIbook_DisplayNets_calltf(),
           PLIbook_DisplayNets_misctf();

/* the veriusertfs table */
s_tfcell veriusertfs[] =
{
    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_ListPorts_checktf,     /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_ListPorts_calltf,      /* calltf routine */
      0,                             /* misctf routine */
      "$list_pathout_ports",         /* system task/function name */
      1                              /* forward reference = true */
    },

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_PortInfo_checktf,      /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_PortInfo_calltf,       /* calltf routine */
      0,                             /* misctf routine */
      "$port_info",                  /* system task/function name */
      1                              /* forward reference = true */
    },

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_ListCells_checktf,     /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_ListCells_calltf,      /* calltf routine */
      0,                             /* misctf routine */
      "$list_cells",                 /* system task/function name */
      1                              /* forward reference = true */
    },

    {userfunction,                   /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_CountLoads_checktf,    /* checktf routine */
      PLIbook_CountLoads_sizetf,     /* sizetf routine */
      PLIbook_CountLoads_calltf,     /* calltf routine */
      0,                             /* misctf routine */
      "$count_loads",                /* system task/function name */
      1                              /* forward reference = true */
    },

    {usertask,                       /* type of PLI routine */
      0,                             /* user_data value */
      PLIbook_DisplayNets_checktf,   /* checktf routine */
      0,                             /* sizetf routine */
      PLIbook_DisplayNets_calltf,    /* calltf routine */
      PLIbook_DisplayNets_misctf,    /* misctf routine */
      "$display_all_nets",           /* system task/function name */
      1                              /* forward reference = true */
    },

    {0} /*** final entry must be 0 ***/
};
