# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._access_operations import (
    build_invite_user_request,
    build_list_clusters_request,
    build_list_environments_request,
    build_list_invitations_request,
    build_list_role_bindings_request,
    build_list_service_accounts_request,
    build_list_users_request,
)

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class AccessOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.confluent.aio.ConfluentManagementClient`'s
        :attr:`access` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def list_users(
        self,
        resource_group_name: str,
        organization_name: str,
        body: _models.ListAccessRequestModel,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AccessListUsersSuccessResponse:
        """Organization users details.

        Organization users details.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Required.
        :type body: ~azure.mgmt.confluent.models.ListAccessRequestModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListUsersSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListUsersSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_users(
        self,
        resource_group_name: str,
        organization_name: str,
        body: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AccessListUsersSuccessResponse:
        """Organization users details.

        Organization users details.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListUsersSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListUsersSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_users(
        self,
        resource_group_name: str,
        organization_name: str,
        body: Union[_models.ListAccessRequestModel, IO],
        **kwargs: Any
    ) -> _models.AccessListUsersSuccessResponse:
        """Organization users details.

        Organization users details.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Is either a ListAccessRequestModel type or a IO type.
         Required.
        :type body: ~azure.mgmt.confluent.models.ListAccessRequestModel or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListUsersSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListUsersSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AccessListUsersSuccessResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "ListAccessRequestModel")

        request = build_list_users_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.list_users.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.ResourceProviderDefaultErrorResponse, pipeline_response
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AccessListUsersSuccessResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_users.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/listUsers"
    }

    @overload
    async def list_service_accounts(
        self,
        resource_group_name: str,
        organization_name: str,
        body: _models.ListAccessRequestModel,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AccessListServiceAccountsSuccessResponse:
        """Organization service accounts details.

        Organization service accounts details.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Required.
        :type body: ~azure.mgmt.confluent.models.ListAccessRequestModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListServiceAccountsSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListServiceAccountsSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_service_accounts(
        self,
        resource_group_name: str,
        organization_name: str,
        body: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AccessListServiceAccountsSuccessResponse:
        """Organization service accounts details.

        Organization service accounts details.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListServiceAccountsSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListServiceAccountsSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_service_accounts(
        self,
        resource_group_name: str,
        organization_name: str,
        body: Union[_models.ListAccessRequestModel, IO],
        **kwargs: Any
    ) -> _models.AccessListServiceAccountsSuccessResponse:
        """Organization service accounts details.

        Organization service accounts details.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Is either a ListAccessRequestModel type or a IO type.
         Required.
        :type body: ~azure.mgmt.confluent.models.ListAccessRequestModel or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListServiceAccountsSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListServiceAccountsSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AccessListServiceAccountsSuccessResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "ListAccessRequestModel")

        request = build_list_service_accounts_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.list_service_accounts.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.ResourceProviderDefaultErrorResponse, pipeline_response
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AccessListServiceAccountsSuccessResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_service_accounts.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/listServiceAccounts"
    }

    @overload
    async def list_invitations(
        self,
        resource_group_name: str,
        organization_name: str,
        body: _models.ListAccessRequestModel,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AccessListInvitationsSuccessResponse:
        """Organization accounts invitation details.

        Organization accounts invitation details.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Required.
        :type body: ~azure.mgmt.confluent.models.ListAccessRequestModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListInvitationsSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListInvitationsSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_invitations(
        self,
        resource_group_name: str,
        organization_name: str,
        body: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AccessListInvitationsSuccessResponse:
        """Organization accounts invitation details.

        Organization accounts invitation details.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListInvitationsSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListInvitationsSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_invitations(
        self,
        resource_group_name: str,
        organization_name: str,
        body: Union[_models.ListAccessRequestModel, IO],
        **kwargs: Any
    ) -> _models.AccessListInvitationsSuccessResponse:
        """Organization accounts invitation details.

        Organization accounts invitation details.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Is either a ListAccessRequestModel type or a IO type.
         Required.
        :type body: ~azure.mgmt.confluent.models.ListAccessRequestModel or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListInvitationsSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListInvitationsSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AccessListInvitationsSuccessResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "ListAccessRequestModel")

        request = build_list_invitations_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.list_invitations.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.ResourceProviderDefaultErrorResponse, pipeline_response
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AccessListInvitationsSuccessResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_invitations.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/listInvitations"
    }

    @overload
    async def invite_user(
        self,
        resource_group_name: str,
        organization_name: str,
        body: _models.AccessInviteUserAccountModel,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.InvitationRecord:
        """Invite user to the organization.

        Invite user to the organization.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: Invite user account model. Required.
        :type body: ~azure.mgmt.confluent.models.AccessInviteUserAccountModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: InvitationRecord or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.InvitationRecord
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def invite_user(
        self,
        resource_group_name: str,
        organization_name: str,
        body: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.InvitationRecord:
        """Invite user to the organization.

        Invite user to the organization.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: Invite user account model. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: InvitationRecord or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.InvitationRecord
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def invite_user(
        self,
        resource_group_name: str,
        organization_name: str,
        body: Union[_models.AccessInviteUserAccountModel, IO],
        **kwargs: Any
    ) -> _models.InvitationRecord:
        """Invite user to the organization.

        Invite user to the organization.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: Invite user account model. Is either a AccessInviteUserAccountModel type or a IO
         type. Required.
        :type body: ~azure.mgmt.confluent.models.AccessInviteUserAccountModel or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: InvitationRecord or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.InvitationRecord
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.InvitationRecord] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "AccessInviteUserAccountModel")

        request = build_invite_user_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.invite_user.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.ResourceProviderDefaultErrorResponse, pipeline_response
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("InvitationRecord", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    invite_user.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/createInvitation"
    }

    @overload
    async def list_environments(
        self,
        resource_group_name: str,
        organization_name: str,
        body: _models.ListAccessRequestModel,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AccessListEnvironmentsSuccessResponse:
        """Environment list of an organization.

        Environment list of an organization.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Required.
        :type body: ~azure.mgmt.confluent.models.ListAccessRequestModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListEnvironmentsSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListEnvironmentsSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_environments(
        self,
        resource_group_name: str,
        organization_name: str,
        body: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AccessListEnvironmentsSuccessResponse:
        """Environment list of an organization.

        Environment list of an organization.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListEnvironmentsSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListEnvironmentsSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_environments(
        self,
        resource_group_name: str,
        organization_name: str,
        body: Union[_models.ListAccessRequestModel, IO],
        **kwargs: Any
    ) -> _models.AccessListEnvironmentsSuccessResponse:
        """Environment list of an organization.

        Environment list of an organization.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Is either a ListAccessRequestModel type or a IO type.
         Required.
        :type body: ~azure.mgmt.confluent.models.ListAccessRequestModel or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListEnvironmentsSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListEnvironmentsSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AccessListEnvironmentsSuccessResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "ListAccessRequestModel")

        request = build_list_environments_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.list_environments.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.ResourceProviderDefaultErrorResponse, pipeline_response
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AccessListEnvironmentsSuccessResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_environments.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/listEnvironments"
    }

    @overload
    async def list_clusters(
        self,
        resource_group_name: str,
        organization_name: str,
        body: _models.ListAccessRequestModel,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AccessListClusterSuccessResponse:
        """Cluster details.

        Cluster details.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Required.
        :type body: ~azure.mgmt.confluent.models.ListAccessRequestModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListClusterSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListClusterSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_clusters(
        self,
        resource_group_name: str,
        organization_name: str,
        body: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AccessListClusterSuccessResponse:
        """Cluster details.

        Cluster details.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListClusterSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListClusterSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_clusters(
        self,
        resource_group_name: str,
        organization_name: str,
        body: Union[_models.ListAccessRequestModel, IO],
        **kwargs: Any
    ) -> _models.AccessListClusterSuccessResponse:
        """Cluster details.

        Cluster details.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Is either a ListAccessRequestModel type or a IO type.
         Required.
        :type body: ~azure.mgmt.confluent.models.ListAccessRequestModel or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListClusterSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListClusterSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AccessListClusterSuccessResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "ListAccessRequestModel")

        request = build_list_clusters_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.list_clusters.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.ResourceProviderDefaultErrorResponse, pipeline_response
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AccessListClusterSuccessResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_clusters.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/listClusters"
    }

    @overload
    async def list_role_bindings(
        self,
        resource_group_name: str,
        organization_name: str,
        body: _models.ListAccessRequestModel,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AccessListRoleBindingsSuccessResponse:
        """Organization role bindings.

        Organization role bindings.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Required.
        :type body: ~azure.mgmt.confluent.models.ListAccessRequestModel
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListRoleBindingsSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListRoleBindingsSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def list_role_bindings(
        self,
        resource_group_name: str,
        organization_name: str,
        body: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.AccessListRoleBindingsSuccessResponse:
        """Organization role bindings.

        Organization role bindings.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListRoleBindingsSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListRoleBindingsSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def list_role_bindings(
        self,
        resource_group_name: str,
        organization_name: str,
        body: Union[_models.ListAccessRequestModel, IO],
        **kwargs: Any
    ) -> _models.AccessListRoleBindingsSuccessResponse:
        """Organization role bindings.

        Organization role bindings.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param organization_name: Organization resource name. Required.
        :type organization_name: str
        :param body: List Access Request Model. Is either a ListAccessRequestModel type or a IO type.
         Required.
        :type body: ~azure.mgmt.confluent.models.ListAccessRequestModel or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AccessListRoleBindingsSuccessResponse or the result of cls(response)
        :rtype: ~azure.mgmt.confluent.models.AccessListRoleBindingsSuccessResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.AccessListRoleBindingsSuccessResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "ListAccessRequestModel")

        request = build_list_role_bindings_request(
            resource_group_name=resource_group_name,
            organization_name=organization_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.list_role_bindings.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(
                _models.ResourceProviderDefaultErrorResponse, pipeline_response
            )
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("AccessListRoleBindingsSuccessResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    list_role_bindings.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Confluent/organizations/{organizationName}/access/default/listRoleBindings"
    }
