/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.DependencyResolver;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ResolveData;
import fr.jayasoft.ivy.ResolvedModuleRevision;
import fr.jayasoft.ivy.report.DownloadReport;
import fr.jayasoft.ivy.resolver.AbstractResolver;
import fr.jayasoft.ivy.resolver.ResolvedModuleRevisionProxy;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;

public class DualResolver
extends AbstractResolver {
    private DependencyResolver _ivyResolver;
    private DependencyResolver _artifactResolver;

    public void add(DependencyResolver resolver) {
        if (this._ivyResolver == null) {
            this._ivyResolver = resolver;
        } else if (this._artifactResolver == null) {
            this._artifactResolver = resolver;
        } else {
            throw new IllegalStateException("exactly two resolvers must be added: ivy(1) and artifact(2) one");
        }
    }

    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        if (this._ivyResolver == null || this._artifactResolver == null) {
            throw new IllegalStateException("exactly two resolvers must be added: ivy(1) and artifact(2) one");
        }
        ResolvedModuleRevision mr = this._ivyResolver.getDependency(dd, data = new ResolveData(data, this.doValidate(data)));
        if (mr == null) {
            Message.verbose("ivy resolver didn't find " + dd.getDependencyRevisionId() + ": trying with artifact resolver");
            return this._artifactResolver.getDependency(dd, data);
        }
        return new ResolvedModuleRevisionProxy(mr, this);
    }

    public void reportFailure() {
        this._ivyResolver.reportFailure();
        this._artifactResolver.reportFailure();
    }

    public void reportFailure(Artifact art) {
        this._ivyResolver.reportFailure(art);
        this._artifactResolver.reportFailure(art);
    }

    public DownloadReport download(Artifact[] artifacts, Ivy ivy, File cache) {
        return this._artifactResolver.download(artifacts, ivy, cache);
    }

    public DependencyResolver getArtifactResolver() {
        return this._artifactResolver;
    }

    public void setArtifactResolver(DependencyResolver artifactResolver) {
        this._artifactResolver = artifactResolver;
    }

    public DependencyResolver getIvyResolver() {
        return this._ivyResolver;
    }

    public void setIvyResolver(DependencyResolver ivyResolver) {
        this._ivyResolver = ivyResolver;
    }

    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        if ("ivy".equals(artifact.getType())) {
            this._ivyResolver.publish(artifact, src, overwrite);
        } else {
            this._artifactResolver.publish(artifact, src, overwrite);
        }
    }

    public void dumpConfig() {
        if (this._ivyResolver == null || this._artifactResolver == null) {
            throw new IllegalStateException("exactly two resolvers must be added: ivy(1) and artifact(2) one");
        }
        Message.verbose("\t" + this.getName() + " [dual " + this._ivyResolver.getName() + " " + this._artifactResolver.getName() + "]");
    }

    public boolean exists(Artifact artifact) {
        return this._artifactResolver.exists(artifact);
    }
}

