/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.cli.configuration;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.files.Project;
import org.islandoftex.arara.cli.utils.LoggingUtils;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.Environment;
import org.islandoftex.arara.core.session.LinearExecutor;
import org.islandoftex.arara.core.session.Session;
import org.islandoftex.arara.mvel.configuration.LocalConfiguration;
import org.islandoftex.arara.mvel.utils.MvelState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0004H\u0002\u00a8\u0006\r"}, d2={"Lorg/islandoftex/arara/cli/configuration/ConfigurationUtils;", "", "()V", "configFileForProject", "Ljava/nio/file/Path;", "project", "Lorg/islandoftex/arara/api/files/Project;", "load", "", "file", "currentProject", "loadLocalConfiguration", "Lorg/islandoftex/arara/mvel/configuration/LocalConfiguration;", "cli"})
public final class ConfigurationUtils {
    @NotNull
    public static final ConfigurationUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Path configFileForProject(@NotNull Project project) {
        Path path2;
        Object v0;
        void $this$firstOrNull$iv;
        boolean $i$f$firstOrNull;
        Path path3;
        Object it;
        boolean bl;
        Path path4;
        Collection collection;
        LinkOption[] linkOptionArray;
        Object item$iv$iv;
        Iterable $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        boolean bl2;
        boolean bl3;
        Object object;
        List<String> names2;
        block7: {
            boolean bl4;
            Intrinsics.checkNotNullParameter(project, "project");
            names2 = CollectionsKt.listOf(".araraconfig.yaml", "araraconfig.yaml", ".arararc.yaml", "arararc.yaml");
            object = project.getWorkingDirectory();
            bl3 = false;
            bl2 = false;
            Path workingDir = object;
            boolean bl5 = false;
            $this$map$iv = names2;
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                item$iv$iv = iterator2.next();
                linkOptionArray = (LinkOption[])item$iv$iv;
                collection = destination$iv$iv;
                bl4 = false;
                path4 = workingDir;
                bl = false;
                Intrinsics.checkNotNullExpressionValue(path4.resolve((String)it), "this.resolve(other)");
                collection.add(path3);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Path it2 = (Path)element$iv;
                boolean bl6 = false;
                item$iv$iv = it2;
                it = new LinkOption[]{};
                bl4 = false;
                if (!Files.exists(item$iv$iv, Arrays.copyOf(it, ((LinkOption[])it).length))) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        if ((path2 = (Path)v0) == null) {
            String string = Environment.getSystemPropertyOrNull("user.home");
            if (string != null) {
                Object v3;
                block8: {
                    object = string;
                    bl3 = false;
                    bl2 = false;
                    Object userHome = object;
                    boolean bl7 = false;
                    $this$map$iv = names2;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    Iterator bl6 = $this$mapTo$iv$iv.iterator();
                    while (bl6.hasNext()) {
                        item$iv$iv = bl6.next();
                        it = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl8 = false;
                        Intrinsics.checkNotNullExpressionValue(Paths.get((String)userHome, new String[0]), "Paths.get(userHome)");
                        bl = false;
                        Intrinsics.checkNotNullExpressionValue(path4.resolve((String)it), "this.resolve(other)");
                        collection.add(path3);
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Path it3 = (Path)element$iv;
                        boolean bl9 = false;
                        Path path5 = it3;
                        linkOptionArray = new LinkOption[]{};
                        boolean bl10 = false;
                        if (!Files.exists(path5, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                        v3 = element$iv;
                        break block8;
                    }
                    v3 = null;
                }
                path2 = v3;
            } else {
                path2 = null;
            }
        }
        return path2;
    }

    private final LocalConfiguration loadLocalConfiguration(Path file2) throws AraraException {
        if (!StringsKt.endsWith$default(((Object)file2.getFileName()).toString(), ".yaml", false, 2, null)) {
            String string = "Kotlin DSL not implemented yet";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        return LocalConfiguration.Companion.load(file2);
    }

    public final void load(@NotNull Path file2, @NotNull Project currentProject) throws AraraException {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(currentProject, "currentProject");
        LocalConfiguration resource = this.loadLocalConfiguration(file2);
        LinearExecutor.INSTANCE.setExecutionOptions(resource.toExecutionOptions(currentProject, LinearExecutor.INSTANCE.getExecutionOptions()));
        Session.setLoggingOptions(resource.toLoggingOptions(Session.getLoggingOptions()));
        Session.setUserInterfaceOptions(resource.toUserInterfaceOptions(Session.getUserInterfaceOptions()));
        Map<String, String> map = MvelState.INSTANCE.getPreambles();
        Map<String, String> map2 = resource.getPreambles();
        boolean bl = false;
        map.putAll(map2);
        MvelState.INSTANCE.setDefaultPreamble(resource.getDefaultPreamble());
        MvelState.INSTANCE.setPrependPreambleIfDirectivesGiven(resource.getPrependPreambleIfDirectivesGiven());
        LanguageController.setLocale(Session.getUserInterfaceOptions().getLocale());
        LoggingUtils.INSTANCE.setupLogging(Session.getLoggingOptions());
    }

    private ConfigurationUtils() {
    }

    static {
        ConfigurationUtils configurationUtils;
        INSTANCE = configurationUtils = new ConfigurationUtils();
    }
}

