/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NumberWithRadix {
    @NotNull
    private final String number;
    private final int radix;

    public NumberWithRadix(@NotNull String number, int radix) {
        Intrinsics.checkNotNullParameter(number, "number");
        this.number = number;
        this.radix = radix;
    }

    @NotNull
    public final String component1() {
        return this.number;
    }

    public final int component2() {
        return this.radix;
    }

    @NotNull
    public String toString() {
        return "NumberWithRadix(number=" + this.number + ", radix=" + this.radix + ')';
    }

    public int hashCode() {
        int result2 = this.number.hashCode();
        result2 = result2 * 31 + this.radix;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NumberWithRadix)) {
            return false;
        }
        NumberWithRadix numberWithRadix = (NumberWithRadix)other;
        if (!Intrinsics.areEqual(this.number, numberWithRadix.number)) {
            return false;
        }
        return this.radix == numberWithRadix.radix;
    }
}

