/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin.header;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmBytecodeBinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KotlinClassHeader {
    @NotNull
    private final Kind kind;
    @NotNull
    private final JvmMetadataVersion metadataVersion;
    @NotNull
    private final JvmBytecodeBinaryVersion bytecodeVersion;
    @Nullable
    private final String[] data;
    @Nullable
    private final String[] incompatibleData;
    @Nullable
    private final String[] strings;
    @Nullable
    private final String extraString;
    private final int extraInt;
    @Nullable
    private final String packageName;

    public KotlinClassHeader(@NotNull Kind kind, @NotNull JvmMetadataVersion metadataVersion, @NotNull JvmBytecodeBinaryVersion bytecodeVersion, @Nullable String[] data2, @Nullable String[] incompatibleData, @Nullable String[] strings, @Nullable String extraString, int extraInt, @Nullable String packageName) {
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        Intrinsics.checkNotNullParameter(bytecodeVersion, "bytecodeVersion");
        this.kind = kind;
        this.metadataVersion = metadataVersion;
        this.bytecodeVersion = bytecodeVersion;
        this.data = data2;
        this.incompatibleData = incompatibleData;
        this.strings = strings;
        this.extraString = extraString;
        this.extraInt = extraInt;
        this.packageName = packageName;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @NotNull
    public final JvmMetadataVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Nullable
    public final String[] getData() {
        return this.data;
    }

    @Nullable
    public final String[] getIncompatibleData() {
        return this.incompatibleData;
    }

    @Nullable
    public final String[] getStrings() {
        return this.strings;
    }

    @Nullable
    public final String getMultifileClassName() {
        String string = this.extraString;
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        return this.getKind() == Kind.MULTIFILE_CLASS_PART ? string : null;
    }

    @NotNull
    public final List<String> getMultifilePartNames() {
        String[] stringArray = this.data;
        boolean bl = false;
        boolean bl2 = false;
        String[] it = stringArray;
        boolean bl3 = false;
        Object object = this.getKind() == Kind.MULTIFILE_CLASS ? stringArray : null;
        object = object == null ? null : ArraysKt.asList(object);
        boolean bl4 = false;
        Object object2 = object;
        if (object == null) {
            object2 = CollectionsKt.emptyList();
        }
        return object2;
    }

    public final boolean isUnstableJvmIrBinary() {
        return this.has(this.extraInt, 16) && !this.has(this.extraInt, 32);
    }

    public final boolean isUnstableFirBinary() {
        return this.has(this.extraInt, 64) && !this.has(this.extraInt, 32);
    }

    public final boolean isPreRelease() {
        return this.has(this.extraInt, 2);
    }

    @NotNull
    public String toString() {
        return (Object)((Object)this.kind) + " version=" + this.metadataVersion;
    }

    private final boolean has(int $this$has, int flag2) {
        return ($this$has & flag2) != 0;
    }

    public static final class Kind
    extends Enum<Kind> {
        @NotNull
        public static final Companion Companion;
        private final int id;
        @NotNull
        private static final Map<Integer, Kind> entryById;
        public static final /* enum */ Kind UNKNOWN;
        public static final /* enum */ Kind CLASS;
        public static final /* enum */ Kind FILE_FACADE;
        public static final /* enum */ Kind SYNTHETIC_CLASS;
        public static final /* enum */ Kind MULTIFILE_CLASS;
        public static final /* enum */ Kind MULTIFILE_CLASS_PART;
        private static final /* synthetic */ Kind[] $VALUES;

        private Kind(int id) {
            this.id = id;
        }

        public final int getId() {
            return this.id;
        }

        public static Kind[] values() {
            Kind[] kindArray = $VALUES;
            Kind[] kindArray2 = new Kind[kindArray.length];
            System.arraycopy(kindArray, 0, kindArray2, 0, kindArray.length);
            return kindArray2;
        }

        public static Kind valueOf(String value) {
            Intrinsics.checkNotNullParameter(value, "value");
            return Enum.valueOf(Kind.class, value);
        }

        @JvmStatic
        @NotNull
        public static final Kind getById(int id) {
            return Companion.getById(id);
        }

        /*
         * WARNING - void declaration
         */
        static {
            void $this$associateByTo$iv$iv;
            UNKNOWN = new Kind(0);
            CLASS = new Kind(1);
            FILE_FACADE = new Kind(2);
            SYNTHETIC_CLASS = new Kind(3);
            MULTIFILE_CLASS = new Kind(4);
            MULTIFILE_CLASS_PART = new Kind(5);
            Kind[] kindArray = new Kind[]{UNKNOWN, CLASS, FILE_FACADE, SYNTHETIC_CLASS, MULTIFILE_CLASS, MULTIFILE_CLASS_PART};
            $VALUES = kindArray;
            Companion = new Companion(null);
            Kind[] $this$associateBy$iv = Kind.values();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($this$associateBy$iv.length), 16);
            Kind[] kindArray2 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            void var6_6 = $this$associateByTo$iv$iv;
            int n = ((void)var6_6).length;
            for (int i = 0; i < n; ++i) {
                void p0;
                void element$iv$iv;
                void var10_10 = element$iv$iv = var6_6[i];
                Map map = destination$iv$iv;
                boolean bl = false;
                Integer n2 = p0.getId();
                map.put(n2, element$iv$iv);
            }
            entryById = destination$iv$iv;
        }

        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Kind getById(int id) {
                Kind kind = (Kind)((Object)entryById.get(id));
                return kind == null ? UNKNOWN : kind;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

