/* Do not modify this file. Changes will be overwritten.                      */
/* Generated automatically by the ASN.1 to Wireshark dissector compiler       */
/* packet-lpp.c                                                               */
/* asn2wrs.py -L -p lpp -c ./lpp.cnf -s ./packet-lpp-template -D . -O ../.. LPP-PDU-Definitions.asn LPP-Broadcast-Definitions.asn */

/* packet-lpp.c
 * Routines for 3GPP LTE Positioning Protocol (LPP) packet dissection
 * Copyright 2011-2023 Pascal Quantin <pascal@wireshark.org>
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * Ref 3GPP TS 37.355 version 17.5.0 Release 17
 * http://www.3gpp.org
 */

#include "config.h"

#include "math.h"

#include <epan/packet.h>
#include <epan/asn1.h>
#include <epan/tfs.h>
#include <epan/proto_data.h>

#include "packet-per.h"
#include "packet-lpp.h"

#define PNAME  "LTE Positioning Protocol (LPP)"
#define PSNAME "LPP"
#define PFNAME "lpp"

void proto_register_lpp(void);
void proto_reg_handoff_lpp(void);

/* Initialize the protocol and registered fields */
static int proto_lpp = -1;

static int hf_lpp_LPP_Message_PDU = -1;           /* LPP_Message */
static int hf_lpp_lpp_Ellipsoid_Point_PDU = -1;   /* Ellipsoid_Point */
static int hf_lpp_lpp_Ellipsoid_PointWithUncertaintyCircle_PDU = -1;  /* Ellipsoid_PointWithUncertaintyCircle */
static int hf_lpp_lpp_EllipsoidPointWithUncertaintyEllipse_PDU = -1;  /* EllipsoidPointWithUncertaintyEllipse */
static int hf_lpp_lpp_EllipsoidPointWithAltitude_PDU = -1;  /* EllipsoidPointWithAltitude */
static int hf_lpp_lpp_EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_PDU = -1;  /* EllipsoidPointWithAltitudeAndUncertaintyEllipsoid */
static int hf_lpp_lpp_EllipsoidArc_PDU = -1;      /* EllipsoidArc */
static int hf_lpp_lpp_HorizontalVelocity_PDU = -1;  /* HorizontalVelocity */
static int hf_lpp_lpp_HorizontalWithVerticalVelocity_PDU = -1;  /* HorizontalWithVerticalVelocity */
static int hf_lpp_lpp_HorizontalVelocityWithUncertainty_PDU = -1;  /* HorizontalVelocityWithUncertainty */
static int hf_lpp_lpp_Polygon_PDU = -1;           /* Polygon */
static int hf_lpp_lpp_LocationCoordinates_PDU = -1;  /* LocationCoordinates */
static int hf_lpp_lpp_Velocity_PDU = -1;          /* Velocity */
static int hf_lpp_lpp_LocationError_PDU = -1;     /* LocationError */
static int hf_lpp_lpp_LocationSource_r13_PDU = -1;  /* LocationSource_r13 */
static int hf_lpp_NR_DL_PRS_AssistanceData_r16_PDU = -1;  /* NR_DL_PRS_AssistanceData_r16 */
static int hf_lpp_NR_DL_PRS_TRP_TEG_Info_r17_PDU = -1;  /* NR_DL_PRS_TRP_TEG_Info_r17 */
static int hf_lpp_NR_On_Demand_DL_PRS_Configurations_r17_PDU = -1;  /* NR_On_Demand_DL_PRS_Configurations_r17 */
static int hf_lpp_NR_TRP_BeamAntennaInfo_r17_PDU = -1;  /* NR_TRP_BeamAntennaInfo_r17 */
static int hf_lpp_GNSS_ReferenceTime_PDU = -1;    /* GNSS_ReferenceTime */
static int hf_lpp_GNSS_ReferenceLocation_PDU = -1;  /* GNSS_ReferenceLocation */
static int hf_lpp_GNSS_IonosphericModel_PDU = -1;  /* GNSS_IonosphericModel */
static int hf_lpp_GNSS_EarthOrientationParameters_PDU = -1;  /* GNSS_EarthOrientationParameters */
static int hf_lpp_GNSS_RTK_ReferenceStationInfo_r15_PDU = -1;  /* GNSS_RTK_ReferenceStationInfo_r15 */
static int hf_lpp_GNSS_RTK_CommonObservationInfo_r15_PDU = -1;  /* GNSS_RTK_CommonObservationInfo_r15 */
static int hf_lpp_GNSS_RTK_AuxiliaryStationData_r15_PDU = -1;  /* GNSS_RTK_AuxiliaryStationData_r15 */
static int hf_lpp_GNSS_SSR_CorrectionPoints_r16_PDU = -1;  /* GNSS_SSR_CorrectionPoints_r16 */
static int hf_lpp_GNSS_Integrity_ServiceParameters_r17_PDU = -1;  /* GNSS_Integrity_ServiceParameters_r17 */
static int hf_lpp_GNSS_Integrity_ServiceAlert_r17_PDU = -1;  /* GNSS_Integrity_ServiceAlert_r17 */
static int hf_lpp_GNSS_TimeModelList_PDU = -1;    /* GNSS_TimeModelList */
static int hf_lpp_GNSS_DifferentialCorrections_PDU = -1;  /* GNSS_DifferentialCorrections */
static int hf_lpp_GNSS_NavigationModel_PDU = -1;  /* GNSS_NavigationModel */
static int hf_lpp_GNSS_RealTimeIntegrity_PDU = -1;  /* GNSS_RealTimeIntegrity */
static int hf_lpp_GNSS_DataBitAssistance_PDU = -1;  /* GNSS_DataBitAssistance */
static int hf_lpp_GNSS_AcquisitionAssistance_PDU = -1;  /* GNSS_AcquisitionAssistance */
static int hf_lpp_GNSS_Almanac_PDU = -1;          /* GNSS_Almanac */
static int hf_lpp_GNSS_UTC_Model_PDU = -1;        /* GNSS_UTC_Model */
static int hf_lpp_GNSS_AuxiliaryInformation_PDU = -1;  /* GNSS_AuxiliaryInformation */
static int hf_lpp_BDS_DifferentialCorrections_r12_PDU = -1;  /* BDS_DifferentialCorrections_r12 */
static int hf_lpp_BDS_GridModelParameter_r12_PDU = -1;  /* BDS_GridModelParameter_r12 */
static int hf_lpp_GNSS_RTK_Observations_r15_PDU = -1;  /* GNSS_RTK_Observations_r15 */
static int hf_lpp_GLO_RTK_BiasInformation_r15_PDU = -1;  /* GLO_RTK_BiasInformation_r15 */
static int hf_lpp_GNSS_RTK_MAC_CorrectionDifferences_r15_PDU = -1;  /* GNSS_RTK_MAC_CorrectionDifferences_r15 */
static int hf_lpp_GNSS_RTK_Residuals_r15_PDU = -1;  /* GNSS_RTK_Residuals_r15 */
static int hf_lpp_GNSS_RTK_FKP_Gradients_r15_PDU = -1;  /* GNSS_RTK_FKP_Gradients_r15 */
static int hf_lpp_GNSS_SSR_OrbitCorrections_r15_PDU = -1;  /* GNSS_SSR_OrbitCorrections_r15 */
static int hf_lpp_GNSS_SSR_ClockCorrections_r15_PDU = -1;  /* GNSS_SSR_ClockCorrections_r15 */
static int hf_lpp_GNSS_SSR_CodeBias_r15_PDU = -1;  /* GNSS_SSR_CodeBias_r15 */
static int hf_lpp_GNSS_SSR_URA_r16_PDU = -1;      /* GNSS_SSR_URA_r16 */
static int hf_lpp_GNSS_SSR_PhaseBias_r16_PDU = -1;  /* GNSS_SSR_PhaseBias_r16 */
static int hf_lpp_GNSS_SSR_STEC_Correction_r16_PDU = -1;  /* GNSS_SSR_STEC_Correction_r16 */
static int hf_lpp_GNSS_SSR_GriddedCorrection_r16_PDU = -1;  /* GNSS_SSR_GriddedCorrection_r16 */
static int hf_lpp_NavIC_DifferentialCorrections_r16_PDU = -1;  /* NavIC_DifferentialCorrections_r16 */
static int hf_lpp_NavIC_GridModelParameter_r16_PDU = -1;  /* NavIC_GridModelParameter_r16 */
static int hf_lpp_TBS_AssistanceDataList_r14_PDU = -1;  /* TBS_AssistanceDataList_r14 */
static int hf_lpp_lpp_Sensor_MeasurementInformation_r13_PDU = -1;  /* Sensor_MeasurementInformation_r13 */
static int hf_lpp_lpp_Sensor_MotionInformation_r15_PDU = -1;  /* Sensor_MotionInformation_r15 */
static int hf_lpp_lpp_DisplacementTimeStamp_r15_PDU = -1;  /* DisplacementTimeStamp_r15 */
static int hf_lpp_Sensor_AssistanceDataList_r14_PDU = -1;  /* Sensor_AssistanceDataList_r14 */
static int hf_lpp_OTDOA_UE_Assisted_r15_PDU = -1;  /* OTDOA_UE_Assisted_r15 */
static int hf_lpp_NR_UEB_TRP_LocationData_r16_PDU = -1;  /* NR_UEB_TRP_LocationData_r16 */
static int hf_lpp_NR_UEB_TRP_RTD_Info_r16_PDU = -1;  /* NR_UEB_TRP_RTD_Info_r16 */
static int hf_lpp_transactionID = -1;             /* LPP_TransactionID */
static int hf_lpp_endTransaction = -1;            /* BOOLEAN */
static int hf_lpp_sequenceNumber = -1;            /* SequenceNumber */
static int hf_lpp_acknowledgement = -1;           /* Acknowledgement */
static int hf_lpp_lpp_MessageBody = -1;           /* LPP_MessageBody */
static int hf_lpp_ackRequested = -1;              /* BOOLEAN */
static int hf_lpp_ackIndicator = -1;              /* SequenceNumber */
static int hf_lpp_c1 = -1;                        /* T_c1 */
static int hf_lpp_requestCapabilities = -1;       /* RequestCapabilities */
static int hf_lpp_provideCapabilities = -1;       /* ProvideCapabilities */
static int hf_lpp_requestAssistanceData = -1;     /* RequestAssistanceData */
static int hf_lpp_provideAssistanceData = -1;     /* ProvideAssistanceData */
static int hf_lpp_requestLocationInformation = -1;  /* RequestLocationInformation */
static int hf_lpp_provideLocationInformation = -1;  /* ProvideLocationInformation */
static int hf_lpp_abort = -1;                     /* Abort */
static int hf_lpp_error = -1;                     /* Error */
static int hf_lpp_spare7 = -1;                    /* NULL */
static int hf_lpp_spare6 = -1;                    /* NULL */
static int hf_lpp_spare5 = -1;                    /* NULL */
static int hf_lpp_spare4 = -1;                    /* NULL */
static int hf_lpp_spare3 = -1;                    /* NULL */
static int hf_lpp_spare2 = -1;                    /* NULL */
static int hf_lpp_spare1 = -1;                    /* NULL */
static int hf_lpp_spare0 = -1;                    /* NULL */
static int hf_lpp_messageClassExtension = -1;     /* T_messageClassExtension */
static int hf_lpp_initiator = -1;                 /* Initiator */
static int hf_lpp_transactionNumber = -1;         /* TransactionNumber */
static int hf_lpp_criticalExtensions = -1;        /* T_criticalExtensions */
static int hf_lpp_c1_01 = -1;                     /* T_c1_01 */
static int hf_lpp_requestCapabilities_r9 = -1;    /* RequestCapabilities_r9_IEs */
static int hf_lpp_criticalExtensionsFuture = -1;  /* T_criticalExtensionsFuture */
static int hf_lpp_commonIEsRequestCapabilities = -1;  /* CommonIEsRequestCapabilities */
static int hf_lpp_a_gnss_RequestCapabilities = -1;  /* A_GNSS_RequestCapabilities */
static int hf_lpp_otdoa_RequestCapabilities = -1;  /* OTDOA_RequestCapabilities */
static int hf_lpp_ecid_RequestCapabilities = -1;  /* ECID_RequestCapabilities */
static int hf_lpp_epdu_RequestCapabilities = -1;  /* EPDU_Sequence */
static int hf_lpp_sensor_RequestCapabilities_r13 = -1;  /* Sensor_RequestCapabilities_r13 */
static int hf_lpp_tbs_RequestCapabilities_r13 = -1;  /* TBS_RequestCapabilities_r13 */
static int hf_lpp_wlan_RequestCapabilities_r13 = -1;  /* WLAN_RequestCapabilities_r13 */
static int hf_lpp_bt_RequestCapabilities_r13 = -1;  /* BT_RequestCapabilities_r13 */
static int hf_lpp_nr_ECID_RequestCapabilities_r16 = -1;  /* NR_ECID_RequestCapabilities_r16 */
static int hf_lpp_nr_Multi_RTT_RequestCapabilities_r16 = -1;  /* NR_Multi_RTT_RequestCapabilities_r16 */
static int hf_lpp_nr_DL_AoD_RequestCapabilities_r16 = -1;  /* NR_DL_AoD_RequestCapabilities_r16 */
static int hf_lpp_nr_DL_TDOA_RequestCapabilities_r16 = -1;  /* NR_DL_TDOA_RequestCapabilities_r16 */
static int hf_lpp_nr_UL_RequestCapabilities_r16 = -1;  /* NR_UL_RequestCapabilities_r16 */
static int hf_lpp_criticalExtensions_01 = -1;     /* T_criticalExtensions_01 */
static int hf_lpp_c1_02 = -1;                     /* T_c1_02 */
static int hf_lpp_provideCapabilities_r9 = -1;    /* ProvideCapabilities_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_01 = -1;  /* T_criticalExtensionsFuture_01 */
static int hf_lpp_commonIEsProvideCapabilities = -1;  /* CommonIEsProvideCapabilities */
static int hf_lpp_a_gnss_ProvideCapabilities = -1;  /* A_GNSS_ProvideCapabilities */
static int hf_lpp_otdoa_ProvideCapabilities = -1;  /* OTDOA_ProvideCapabilities */
static int hf_lpp_ecid_ProvideCapabilities = -1;  /* ECID_ProvideCapabilities */
static int hf_lpp_epdu_ProvideCapabilities = -1;  /* EPDU_Sequence */
static int hf_lpp_sensor_ProvideCapabilities_r13 = -1;  /* Sensor_ProvideCapabilities_r13 */
static int hf_lpp_tbs_ProvideCapabilities_r13 = -1;  /* TBS_ProvideCapabilities_r13 */
static int hf_lpp_wlan_ProvideCapabilities_r13 = -1;  /* WLAN_ProvideCapabilities_r13 */
static int hf_lpp_bt_ProvideCapabilities_r13 = -1;  /* BT_ProvideCapabilities_r13 */
static int hf_lpp_nr_ECID_ProvideCapabilities_r16 = -1;  /* NR_ECID_ProvideCapabilities_r16 */
static int hf_lpp_nr_Multi_RTT_ProvideCapabilities_r16 = -1;  /* NR_Multi_RTT_ProvideCapabilities_r16 */
static int hf_lpp_nr_DL_AoD_ProvideCapabilities_r16 = -1;  /* NR_DL_AoD_ProvideCapabilities_r16 */
static int hf_lpp_nr_DL_TDOA_ProvideCapabilities_r16 = -1;  /* NR_DL_TDOA_ProvideCapabilities_r16 */
static int hf_lpp_nr_UL_ProvideCapabilities_r16 = -1;  /* NR_UL_ProvideCapabilities_r16 */
static int hf_lpp_criticalExtensions_02 = -1;     /* T_criticalExtensions_02 */
static int hf_lpp_c1_03 = -1;                     /* T_c1_03 */
static int hf_lpp_requestAssistanceData_r9 = -1;  /* RequestAssistanceData_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_02 = -1;  /* T_criticalExtensionsFuture_02 */
static int hf_lpp_commonIEsRequestAssistanceData = -1;  /* CommonIEsRequestAssistanceData */
static int hf_lpp_a_gnss_RequestAssistanceData = -1;  /* A_GNSS_RequestAssistanceData */
static int hf_lpp_otdoa_RequestAssistanceData = -1;  /* OTDOA_RequestAssistanceData */
static int hf_lpp_epdu_RequestAssistanceData = -1;  /* EPDU_Sequence */
static int hf_lpp_sensor_RequestAssistanceData_r14 = -1;  /* Sensor_RequestAssistanceData_r14 */
static int hf_lpp_tbs_RequestAssistanceData_r14 = -1;  /* TBS_RequestAssistanceData_r14 */
static int hf_lpp_wlan_RequestAssistanceData_r14 = -1;  /* WLAN_RequestAssistanceData_r14 */
static int hf_lpp_nr_Multi_RTT_RequestAssistanceData_r16 = -1;  /* NR_Multi_RTT_RequestAssistanceData_r16 */
static int hf_lpp_nr_DL_AoD_RequestAssistanceData_r16 = -1;  /* NR_DL_AoD_RequestAssistanceData_r16 */
static int hf_lpp_nr_DL_TDOA_RequestAssistanceData_r16 = -1;  /* NR_DL_TDOA_RequestAssistanceData_r16 */
static int hf_lpp_criticalExtensions_03 = -1;     /* T_criticalExtensions_03 */
static int hf_lpp_c1_04 = -1;                     /* T_c1_04 */
static int hf_lpp_provideAssistanceData_r9 = -1;  /* ProvideAssistanceData_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_03 = -1;  /* T_criticalExtensionsFuture_03 */
static int hf_lpp_commonIEsProvideAssistanceData = -1;  /* CommonIEsProvideAssistanceData */
static int hf_lpp_a_gnss_ProvideAssistanceData = -1;  /* A_GNSS_ProvideAssistanceData */
static int hf_lpp_otdoa_ProvideAssistanceData = -1;  /* OTDOA_ProvideAssistanceData */
static int hf_lpp_epdu_Provide_Assistance_Data = -1;  /* EPDU_Sequence */
static int hf_lpp_sensor_ProvideAssistanceData_r14 = -1;  /* Sensor_ProvideAssistanceData_r14 */
static int hf_lpp_tbs_ProvideAssistanceData_r14 = -1;  /* TBS_ProvideAssistanceData_r14 */
static int hf_lpp_wlan_ProvideAssistanceData_r14 = -1;  /* WLAN_ProvideAssistanceData_r14 */
static int hf_lpp_nr_Multi_RTT_ProvideAssistanceData_r16 = -1;  /* NR_Multi_RTT_ProvideAssistanceData_r16 */
static int hf_lpp_nr_DL_AoD_ProvideAssistanceData_r16 = -1;  /* NR_DL_AoD_ProvideAssistanceData_r16 */
static int hf_lpp_nr_DL_TDOA_ProvideAssistanceData_r16 = -1;  /* NR_DL_TDOA_ProvideAssistanceData_r16 */
static int hf_lpp_criticalExtensions_04 = -1;     /* T_criticalExtensions_04 */
static int hf_lpp_c1_05 = -1;                     /* T_c1_05 */
static int hf_lpp_requestLocationInformation_r9 = -1;  /* RequestLocationInformation_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_04 = -1;  /* T_criticalExtensionsFuture_04 */
static int hf_lpp_commonIEsRequestLocationInformation = -1;  /* CommonIEsRequestLocationInformation */
static int hf_lpp_a_gnss_RequestLocationInformation = -1;  /* A_GNSS_RequestLocationInformation */
static int hf_lpp_otdoa_RequestLocationInformation = -1;  /* OTDOA_RequestLocationInformation */
static int hf_lpp_ecid_RequestLocationInformation = -1;  /* ECID_RequestLocationInformation */
static int hf_lpp_epdu_RequestLocationInformation = -1;  /* EPDU_Sequence */
static int hf_lpp_sensor_RequestLocationInformation_r13 = -1;  /* Sensor_RequestLocationInformation_r13 */
static int hf_lpp_tbs_RequestLocationInformation_r13 = -1;  /* TBS_RequestLocationInformation_r13 */
static int hf_lpp_wlan_RequestLocationInformation_r13 = -1;  /* WLAN_RequestLocationInformation_r13 */
static int hf_lpp_bt_RequestLocationInformation_r13 = -1;  /* BT_RequestLocationInformation_r13 */
static int hf_lpp_nr_ECID_RequestLocationInformation_r16 = -1;  /* NR_ECID_RequestLocationInformation_r16 */
static int hf_lpp_nr_Multi_RTT_RequestLocationInformation_r16 = -1;  /* NR_Multi_RTT_RequestLocationInformation_r16 */
static int hf_lpp_nr_DL_AoD_RequestLocationInformation_r16 = -1;  /* NR_DL_AoD_RequestLocationInformation_r16 */
static int hf_lpp_nr_DL_TDOA_RequestLocationInformation_r16 = -1;  /* NR_DL_TDOA_RequestLocationInformation_r16 */
static int hf_lpp_criticalExtensions_05 = -1;     /* T_criticalExtensions_05 */
static int hf_lpp_c1_06 = -1;                     /* T_c1_06 */
static int hf_lpp_provideLocationInformation_r9 = -1;  /* ProvideLocationInformation_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_05 = -1;  /* T_criticalExtensionsFuture_05 */
static int hf_lpp_commonIEsProvideLocationInformation = -1;  /* CommonIEsProvideLocationInformation */
static int hf_lpp_a_gnss_ProvideLocationInformation = -1;  /* A_GNSS_ProvideLocationInformation */
static int hf_lpp_otdoa_ProvideLocationInformation = -1;  /* OTDOA_ProvideLocationInformation */
static int hf_lpp_ecid_ProvideLocationInformation = -1;  /* ECID_ProvideLocationInformation */
static int hf_lpp_epdu_ProvideLocationInformation = -1;  /* EPDU_Sequence */
static int hf_lpp_sensor_ProvideLocationInformation_r13 = -1;  /* Sensor_ProvideLocationInformation_r13 */
static int hf_lpp_tbs_ProvideLocationInformation_r13 = -1;  /* TBS_ProvideLocationInformation_r13 */
static int hf_lpp_wlan_ProvideLocationInformation_r13 = -1;  /* WLAN_ProvideLocationInformation_r13 */
static int hf_lpp_bt_ProvideLocationInformation_r13 = -1;  /* BT_ProvideLocationInformation_r13 */
static int hf_lpp_nr_ECID_ProvideLocationInformation_r16 = -1;  /* NR_ECID_ProvideLocationInformation_r16 */
static int hf_lpp_nr_Multi_RTT_ProvideLocationInformation_r16 = -1;  /* NR_Multi_RTT_ProvideLocationInformation_r16 */
static int hf_lpp_nr_DL_AoD_ProvideLocationInformation_r16 = -1;  /* NR_DL_AoD_ProvideLocationInformation_r16 */
static int hf_lpp_nr_DL_TDOA_ProvideLocationInformation_r16 = -1;  /* NR_DL_TDOA_ProvideLocationInformation_r16 */
static int hf_lpp_criticalExtensions_06 = -1;     /* T_criticalExtensions_06 */
static int hf_lpp_c1_07 = -1;                     /* T_c1_07 */
static int hf_lpp_abort_r9 = -1;                  /* Abort_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_06 = -1;  /* T_criticalExtensionsFuture_06 */
static int hf_lpp_commonIEsAbort = -1;            /* CommonIEsAbort */
static int hf_lpp_epdu_Abort = -1;                /* EPDU_Sequence */
static int hf_lpp_error_r9 = -1;                  /* Error_r9_IEs */
static int hf_lpp_criticalExtensionsFuture_07 = -1;  /* T_criticalExtensionsFuture_07 */
static int hf_lpp_commonIEsError = -1;            /* CommonIEsError */
static int hf_lpp_epdu_Error = -1;                /* EPDU_Sequence */
static int hf_lpp_accessTypes = -1;               /* T_accessTypes */
static int hf_lpp_carrierFreq_r14 = -1;           /* ARFCN_ValueEUTRA_r14 */
static int hf_lpp_carrierFreqOffset_r14 = -1;     /* CarrierFreqOffsetNB_r14 */
static int hf_lpp_plmn_Identity = -1;             /* T_plmn_Identity */
static int hf_lpp_mcc = -1;                       /* T_mcc */
static int hf_lpp_mcc_item = -1;                  /* INTEGER_0_9 */
static int hf_lpp_mnc = -1;                       /* T_mnc */
static int hf_lpp_mnc_item = -1;                  /* INTEGER_0_9 */
static int hf_lpp_cellIdentity = -1;              /* T_cellIdentity */
static int hf_lpp_eutra = -1;                     /* BIT_STRING_SIZE_28 */
static int hf_lpp_utra = -1;                      /* BIT_STRING_SIZE_32 */
static int hf_lpp_plmn_Identity_01 = -1;          /* T_plmn_Identity_01 */
static int hf_lpp_mcc_01 = -1;                    /* T_mcc_01 */
static int hf_lpp_mnc_01 = -1;                    /* T_mnc_01 */
static int hf_lpp_locationAreaCode = -1;          /* BIT_STRING_SIZE_16 */
static int hf_lpp_cellGlobalIdGERAN_cellIdentity = -1;  /* BIT_STRING_SIZE_16 */
static int hf_lpp_mcc_02 = -1;                    /* T_mcc_02 */
static int hf_lpp_mnc_02 = -1;                    /* T_mnc_02 */
static int hf_lpp_cellidentity = -1;              /* BIT_STRING_SIZE_28 */
static int hf_lpp_latitudeSign = -1;              /* T_latitudeSign */
static int hf_lpp_degreesLatitude = -1;           /* INTEGER_0_8388607 */
static int hf_lpp_degreesLongitude = -1;          /* INTEGER_M8388608_8388607 */
static int hf_lpp_latitudeSign_01 = -1;           /* T_latitudeSign_01 */
static int hf_lpp_uncertainty = -1;               /* INTEGER_0_127 */
static int hf_lpp_latitudeSign_02 = -1;           /* T_latitudeSign_02 */
static int hf_lpp_uncertaintySemiMajor = -1;      /* INTEGER_0_127 */
static int hf_lpp_uncertaintySemiMinor = -1;      /* INTEGER_0_127 */
static int hf_lpp_orientationMajorAxis = -1;      /* INTEGER_0_179 */
static int hf_lpp_confidence = -1;                /* INTEGER_0_100 */
static int hf_lpp_latitudeSign_03 = -1;           /* T_latitudeSign_03 */
static int hf_lpp_altitudeDirection = -1;         /* T_altitudeDirection */
static int hf_lpp_altitude = -1;                  /* INTEGER_0_32767 */
static int hf_lpp_latitudeSign_04 = -1;           /* T_latitudeSign_04 */
static int hf_lpp_altitudeDirection_01 = -1;      /* T_altitudeDirection_01 */
static int hf_lpp_uncertaintyAltitude = -1;       /* INTEGER_0_127 */
static int hf_lpp_latitudeSign_05 = -1;           /* T_latitudeSign_05 */
static int hf_lpp_innerRadius = -1;               /* INTEGER_0_65535 */
static int hf_lpp_uncertaintyRadius = -1;         /* INTEGER_0_127 */
static int hf_lpp_offsetAngle = -1;               /* INTEGER_0_179 */
static int hf_lpp_includedAngle = -1;             /* INTEGER_0_179 */
static int hf_lpp_EPDU_Sequence_item = -1;        /* EPDU */
static int hf_lpp_ePDU_Identifier = -1;           /* EPDU_Identifier */
static int hf_lpp_ePDU_Body = -1;                 /* EPDU_Body */
static int hf_lpp_ePDU_ID = -1;                   /* EPDU_ID */
static int hf_lpp_ePDU_Name = -1;                 /* EPDU_Name */
static int hf_lpp_degreesLatitude_r16 = -1;       /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_degreesLongitude_r16 = -1;      /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_altitude_r16 = -1;              /* INTEGER_M64000_1280000 */
static int hf_lpp_uncertaintySemiMajor_r16 = -1;  /* INTEGER_0_255 */
static int hf_lpp_uncertaintySemiMinor_r16 = -1;  /* INTEGER_0_255 */
static int hf_lpp_orientationMajorAxis_r16 = -1;  /* INTEGER_0_179 */
static int hf_lpp_horizontalConfidence_r16 = -1;  /* INTEGER_0_100 */
static int hf_lpp_uncertaintyAltitude_r16 = -1;   /* INTEGER_0_255 */
static int hf_lpp_verticalConfidence_r16 = -1;    /* INTEGER_0_100 */
static int hf_lpp_ha_HorizontalExtendedRangeUsed_r16 = -1;  /* BOOLEAN */
static int hf_lpp_ha_VerticalExtendedRangeUsed_r16 = -1;  /* BOOLEAN */
static int hf_lpp_confidence_r16 = -1;            /* INTEGER_0_100 */
static int hf_lpp_ha_ExtendedUncertaintyRangeUsed_r16 = -1;  /* BOOLEAN */
static int hf_lpp_degreesLatitude_r15 = -1;       /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_degreesLongitude_r15 = -1;      /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_uncertaintySemiMajor_r15 = -1;  /* INTEGER_0_255 */
static int hf_lpp_uncertaintySemiMinor_r15 = -1;  /* INTEGER_0_255 */
static int hf_lpp_orientationMajorAxis_r15 = -1;  /* INTEGER_0_179 */
static int hf_lpp_confidence_r15 = -1;            /* INTEGER_0_100 */
static int hf_lpp_altitude_r15 = -1;              /* INTEGER_M64000_1280000 */
static int hf_lpp_horizontalConfidence_r15 = -1;  /* INTEGER_0_100 */
static int hf_lpp_uncertaintyAltitude_r15 = -1;   /* INTEGER_0_255 */
static int hf_lpp_verticalConfidence_r15 = -1;    /* INTEGER_0_100 */
static int hf_lpp_bearing = -1;                   /* INTEGER_0_359 */
static int hf_lpp_horizontalSpeed = -1;           /* INTEGER_0_2047 */
static int hf_lpp_verticalDirection = -1;         /* T_verticalDirection */
static int hf_lpp_verticalSpeed = -1;             /* INTEGER_0_255 */
static int hf_lpp_uncertaintySpeed = -1;          /* INTEGER_0_255 */
static int hf_lpp_verticalDirection_01 = -1;      /* T_verticalDirection_01 */
static int hf_lpp_horizontalUncertaintySpeed = -1;  /* INTEGER_0_255 */
static int hf_lpp_verticalUncertaintySpeed = -1;  /* INTEGER_0_255 */
static int hf_lpp_ellipsoidPoint = -1;            /* BOOLEAN */
static int hf_lpp_ellipsoidPointWithUncertaintyCircle = -1;  /* BOOLEAN */
static int hf_lpp_ellipsoidPointWithUncertaintyEllipse = -1;  /* BOOLEAN */
static int hf_lpp_polygon = -1;                   /* BOOLEAN */
static int hf_lpp_ellipsoidPointWithAltitude = -1;  /* BOOLEAN */
static int hf_lpp_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid = -1;  /* BOOLEAN */
static int hf_lpp_ellipsoidArc = -1;              /* BOOLEAN */
static int hf_lpp_highAccuracyEllipsoidPointWithUncertaintyEllipse_r15 = -1;  /* BOOLEAN */
static int hf_lpp_highAccuracyEllipsoidPointWithAltitudeAndUncertaintyEllipsoid_r15 = -1;  /* BOOLEAN */
static int hf_lpp_ha_EllipsoidPointWithScalableUncertaintyEllipse_r16 = -1;  /* BOOLEAN */
static int hf_lpp_ha_EllipsoidPointWithAltitudeAndScalableUncertaintyEllipsoid_r16 = -1;  /* BOOLEAN */
static int hf_lpp_mcc_r15 = -1;                   /* T_mcc_r15 */
static int hf_lpp_mcc_r15_item = -1;              /* INTEGER_0_9 */
static int hf_lpp_mnc_r15 = -1;                   /* T_mnc_r15 */
static int hf_lpp_mnc_r15_item = -1;              /* INTEGER_0_9 */
static int hf_lpp_nr_cellidentity_r15 = -1;       /* BIT_STRING_SIZE_36 */
static int hf_lpp_periodicSessionID_r15 = -1;     /* PeriodicSessionID_r15 */
static int hf_lpp_updateCapabilities_r15 = -1;    /* UpdateCapabilities_r15 */
static int hf_lpp_periodicSessionInitiator_r15 = -1;  /* T_periodicSessionInitiator_r15 */
static int hf_lpp_periodicSessionNumber_r15 = -1;  /* INTEGER_0_255 */
static int hf_lpp_Polygon_item = -1;              /* PolygonPoints */
static int hf_lpp_latitudeSign_06 = -1;           /* T_latitudeSign_06 */
static int hf_lpp_posModes = -1;                  /* T_posModes */
static int hf_lpp_utcTime_r17 = -1;               /* T_utcTime_r17 */
static int hf_lpp_gnssTime_r17 = -1;              /* GNSS_ID_Bitmap */
static int hf_lpp_e_utraTime_r17 = -1;            /* T_e_utraTime_r17 */
static int hf_lpp_nrTime_r17 = -1;                /* T_nrTime_r17 */
static int hf_lpp_relativeTime_r17 = -1;          /* T_relativeTime_r17 */
static int hf_lpp_utcTime_r17_01 = -1;            /* PositioningModes */
static int hf_lpp_gnssTime_r17_01 = -1;           /* T_gnssTime_r17 */
static int hf_lpp_posModes_r17 = -1;              /* PositioningModes */
static int hf_lpp_gnss_TimeIDs_r17 = -1;          /* GNSS_ID_Bitmap */
static int hf_lpp_e_utraTime_r17_01 = -1;         /* PositioningModes */
static int hf_lpp_nrTime_r17_01 = -1;             /* PositioningModes */
static int hf_lpp_relativeTime_r17_01 = -1;       /* PositioningModes */
static int hf_lpp_horizontalVelocity = -1;        /* BOOLEAN */
static int hf_lpp_horizontalWithVerticalVelocity = -1;  /* BOOLEAN */
static int hf_lpp_horizontalVelocityWithUncertainty = -1;  /* BOOLEAN */
static int hf_lpp_horizontalWithVerticalVelocityAndUncertainty = -1;  /* BOOLEAN */
static int hf_lpp_lpp_message_segmentation_req_r14 = -1;  /* T_lpp_message_segmentation_req_r14 */
static int hf_lpp_segmentationInfo_r14 = -1;      /* SegmentationInfo_r14 */
static int hf_lpp_lpp_message_segmentation_r14 = -1;  /* T_lpp_message_segmentation_r14 */
static int hf_lpp_primaryCellID = -1;             /* ECGI */
static int hf_lpp_periodicAssistanceDataReq_r15 = -1;  /* PeriodicAssistanceDataControlParameters_r15 */
static int hf_lpp_primaryCellID_r15 = -1;         /* NCGI_r15 */
static int hf_lpp_periodicAssistanceData_r15 = -1;  /* PeriodicAssistanceDataControlParameters_r15 */
static int hf_lpp_locationInformationType = -1;   /* LocationInformationType */
static int hf_lpp_triggeredReporting = -1;        /* TriggeredReportingCriteria */
static int hf_lpp_periodicalReporting = -1;       /* PeriodicalReportingCriteria */
static int hf_lpp_additionalInformation = -1;     /* AdditionalInformation */
static int hf_lpp_qos = -1;                       /* QoS */
static int hf_lpp_environment = -1;               /* Environment */
static int hf_lpp_locationCoordinateTypes = -1;   /* LocationCoordinateTypes */
static int hf_lpp_velocityTypes = -1;             /* VelocityTypes */
static int hf_lpp_messageSizeLimitNB_r14 = -1;    /* MessageSizeLimitNB_r14 */
static int hf_lpp_scheduledLocationTime_r17 = -1;  /* ScheduledLocationTime_r17 */
static int hf_lpp_targetIntegrityRisk_r17 = -1;   /* TargetIntegrityRisk_r17 */
static int hf_lpp_reportingAmount = -1;           /* T_reportingAmount */
static int hf_lpp_reportingInterval = -1;         /* T_reportingInterval */
static int hf_lpp_cellChange = -1;                /* BOOLEAN */
static int hf_lpp_reportingDuration = -1;         /* ReportingDuration */
static int hf_lpp_horizontalAccuracy = -1;        /* HorizontalAccuracy */
static int hf_lpp_verticalCoordinateRequest = -1;  /* BOOLEAN */
static int hf_lpp_verticalAccuracy = -1;          /* VerticalAccuracy */
static int hf_lpp_responseTime = -1;              /* ResponseTime */
static int hf_lpp_velocityRequest = -1;           /* BOOLEAN */
static int hf_lpp_responseTimeNB_r14 = -1;        /* ResponseTimeNB_r14 */
static int hf_lpp_horizontalAccuracyExt_r15 = -1;  /* HorizontalAccuracyExt_r15 */
static int hf_lpp_verticalAccuracyExt_r15 = -1;   /* VerticalAccuracyExt_r15 */
static int hf_lpp_accuracy = -1;                  /* INTEGER_0_127 */
static int hf_lpp_accuracyExt_r15 = -1;           /* INTEGER_0_255 */
static int hf_lpp_time = -1;                      /* INTEGER_1_128 */
static int hf_lpp_responseTimeEarlyFix_r12 = -1;  /* INTEGER_1_128 */
static int hf_lpp_unit_r15 = -1;                  /* T_unit_r15 */
static int hf_lpp_timeNB_r14 = -1;                /* INTEGER_1_512 */
static int hf_lpp_responseTimeEarlyFixNB_r14 = -1;  /* INTEGER_1_512 */
static int hf_lpp_unitNB_r15 = -1;                /* T_unitNB_r15 */
static int hf_lpp_measurementLimit_r14 = -1;      /* INTEGER_1_512 */
static int hf_lpp_utcTime_r17_02 = -1;            /* UTCTime */
static int hf_lpp_gnssTime_r17_02 = -1;           /* T_gnssTime_r17_01 */
static int hf_lpp_gnss_TOD_msec_r17 = -1;         /* INTEGER_0_3599999 */
static int hf_lpp_gnss_TimeID_r17 = -1;           /* GNSS_ID */
static int hf_lpp_networkTime_r17 = -1;           /* T_networkTime_r17 */
static int hf_lpp_e_utraTime_r17_02 = -1;         /* T_e_utraTime_r17_01 */
static int hf_lpp_lte_PhysCellId_r17 = -1;        /* INTEGER_0_503 */
static int hf_lpp_lte_ArfcnEUTRA_r17 = -1;        /* ARFCN_ValueEUTRA */
static int hf_lpp_lte_CellGlobalId_r17 = -1;      /* CellGlobalIdEUTRA_AndUTRA */
static int hf_lpp_lte_SystemFrameNumber_r17 = -1;  /* INTEGER_0_1023 */
static int hf_lpp_nrTime_r17_02 = -1;             /* T_nrTime_r17_01 */
static int hf_lpp_nr_PhysCellID_r17 = -1;         /* NR_PhysCellID_r16 */
static int hf_lpp_nr_ARFCN_r17 = -1;              /* ARFCN_ValueNR_r15 */
static int hf_lpp_nr_CellGlobalID_r17 = -1;       /* NCGI_r15 */
static int hf_lpp_nr_SFN_r17 = -1;                /* INTEGER_0_1023 */
static int hf_lpp_nr_Slot_r17 = -1;               /* T_nr_Slot_r17 */
static int hf_lpp_scs15_r17 = -1;                 /* INTEGER_0_9 */
static int hf_lpp_scs30_r17 = -1;                 /* INTEGER_0_19 */
static int hf_lpp_scs60_r17 = -1;                 /* INTEGER_0_39 */
static int hf_lpp_scs120_r17 = -1;                /* INTEGER_0_79 */
static int hf_lpp_relativeTime_r17_02 = -1;       /* INTEGER_1_1024 */
static int hf_lpp_locationEstimate = -1;          /* LocationCoordinates */
static int hf_lpp_velocityEstimate = -1;          /* Velocity */
static int hf_lpp_locationError = -1;             /* LocationError */
static int hf_lpp_earlyFixReport_r12 = -1;        /* EarlyFixReport_r12 */
static int hf_lpp_locationSource_r13 = -1;        /* LocationSource_r13 */
static int hf_lpp_locationTimestamp_r13 = -1;     /* UTCTime */
static int hf_lpp_integrityInfo_r17 = -1;         /* IntegrityInfo_r17 */
static int hf_lpp_ellipsoidPoint_01 = -1;         /* Ellipsoid_Point */
static int hf_lpp_ellipsoidPointWithUncertaintyCircle_01 = -1;  /* Ellipsoid_PointWithUncertaintyCircle */
static int hf_lpp_ellipsoidPointWithUncertaintyEllipse_01 = -1;  /* EllipsoidPointWithUncertaintyEllipse */
static int hf_lpp_locationCoordinates_polygon = -1;  /* Polygon */
static int hf_lpp_ellipsoidPointWithAltitude_01 = -1;  /* EllipsoidPointWithAltitude */
static int hf_lpp_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid_01 = -1;  /* EllipsoidPointWithAltitudeAndUncertaintyEllipsoid */
static int hf_lpp_ellipsoidArc_01 = -1;           /* EllipsoidArc */
static int hf_lpp_highAccuracyEllipsoidPointWithUncertaintyEllipse_v1510 = -1;  /* HighAccuracyEllipsoidPointWithUncertaintyEllipse_r15 */
static int hf_lpp_highAccuracyEllipsoidPointWithAltitudeAndUncertaintyEllipsoid_v1510 = -1;  /* HighAccuracyEllipsoidPointWithAltitudeAndUncertaintyEllipsoid_r15 */
static int hf_lpp_ha_EllipsoidPointWithScalableUncertaintyEllipse_v1680 = -1;  /* HA_EllipsoidPointWithScalableUncertaintyEllipse_r16 */
static int hf_lpp_ha_EllipsoidPointWithAltitudeAndScalableUncertaintyEllipsoid_v1680 = -1;  /* HA_EllipsoidPointWithAltitudeAndScalableUncertaintyEllipsoid_r16 */
static int hf_lpp_horizontalVelocity_01 = -1;     /* HorizontalVelocity */
static int hf_lpp_horizontalWithVerticalVelocity_01 = -1;  /* HorizontalWithVerticalVelocity */
static int hf_lpp_horizontalVelocityWithUncertainty_01 = -1;  /* HorizontalVelocityWithUncertainty */
static int hf_lpp_horizontalWithVerticalVelocityAndUncertainty_01 = -1;  /* HorizontalWithVerticalVelocityAndUncertainty */
static int hf_lpp_locationfailurecause = -1;      /* LocationFailureCause */
static int hf_lpp_horizontalProtectionLevel_r17 = -1;  /* INTEGER_0_50000 */
static int hf_lpp_verticalProtectionLevel_r17 = -1;  /* INTEGER_0_50000 */
static int hf_lpp_achievableTargetIntegrityRisk_r17 = -1;  /* INTEGER_10_90 */
static int hf_lpp_abortCause = -1;                /* T_abortCause */
static int hf_lpp_errorCause = -1;                /* T_errorCause */
static int hf_lpp_AreaID_CellList_r17_item = -1;  /* NR_Cell_IDs_r17 */
static int hf_lpp_dl_PRS_ID_r16 = -1;             /* INTEGER_0_255 */
static int hf_lpp_nr_DL_PRS_ResourceID_List_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxResourceIDs_r16_OF_NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_nr_DL_PRS_ResourceID_List_r16_item = -1;  /* NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_nr_DL_PRS_ResourceSetID_r16 = -1;  /* NR_DL_PRS_ResourceSetID_r16 */
static int hf_lpp_alpha_r16 = -1;                 /* INTEGER_0_359 */
static int hf_lpp_alpha_fine_r16 = -1;            /* INTEGER_0_9 */
static int hf_lpp_beta_r16 = -1;                  /* INTEGER_0_359 */
static int hf_lpp_beta_fine_r16 = -1;             /* INTEGER_0_9 */
static int hf_lpp_gamma_r16 = -1;                 /* INTEGER_0_359 */
static int hf_lpp_gamma_fine_r16 = -1;            /* INTEGER_0_9 */
static int hf_lpp_indicator_r17 = -1;             /* T_indicator_r17 */
static int hf_lpp_soft_r17 = -1;                  /* INTEGER_0_10 */
static int hf_lpp_hard_r17 = -1;                  /* BOOLEAN */
static int hf_lpp_NR_AdditionalPathList_r16_item = -1;  /* NR_AdditionalPath_r16 */
static int hf_lpp_NR_AdditionalPathListExt_r17_item = -1;  /* NR_AdditionalPath_r16 */
static int hf_lpp_nr_RelativeTimeDifference_r16 = -1;  /* T_nr_RelativeTimeDifference_r16 */
static int hf_lpp_k0_r16 = -1;                    /* INTEGER_0_16351 */
static int hf_lpp_k1_r16 = -1;                    /* INTEGER_0_8176 */
static int hf_lpp_k2_r16 = -1;                    /* INTEGER_0_4088 */
static int hf_lpp_k3_r16 = -1;                    /* INTEGER_0_2044 */
static int hf_lpp_k4_r16 = -1;                    /* INTEGER_0_1022 */
static int hf_lpp_k5_r16 = -1;                    /* INTEGER_0_511 */
static int hf_lpp_nr_PathQuality_r16 = -1;        /* NR_TimingQuality_r16 */
static int hf_lpp_nr_DL_PRS_RSRPP_r17 = -1;       /* INTEGER_0_126 */
static int hf_lpp_nr_DL_PRS_ReferenceInfo_r16 = -1;  /* DL_PRS_ID_Info_r16 */
static int hf_lpp_nr_DL_PRS_AssistanceDataList_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxFreqLayers_r16_OF_NR_DL_PRS_AssistanceDataPerFreq_r16 */
static int hf_lpp_nr_DL_PRS_AssistanceDataList_r16_item = -1;  /* NR_DL_PRS_AssistanceDataPerFreq_r16 */
static int hf_lpp_nr_SSB_Config_r16 = -1;         /* SEQUENCE_SIZE_1_nrMaxTRPs_r16_OF_NR_SSB_Config_r16 */
static int hf_lpp_nr_SSB_Config_r16_item = -1;    /* NR_SSB_Config_r16 */
static int hf_lpp_nr_DL_PRS_PositioningFrequencyLayer_r16 = -1;  /* NR_DL_PRS_PositioningFrequencyLayer_r16 */
static int hf_lpp_nr_DL_PRS_AssistanceDataPerFreq_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_NR_DL_PRS_AssistanceDataPerTRP_r16 */
static int hf_lpp_nr_DL_PRS_AssistanceDataPerFreq_r16_item = -1;  /* NR_DL_PRS_AssistanceDataPerTRP_r16 */
static int hf_lpp_nr_PhysCellID_r16 = -1;         /* NR_PhysCellID_r16 */
static int hf_lpp_nr_CellGlobalID_r16 = -1;       /* NCGI_r15 */
static int hf_lpp_nr_ARFCN_r16 = -1;              /* ARFCN_ValueNR_r15 */
static int hf_lpp_nr_DL_PRS_SFN0_Offset_r16 = -1;  /* NR_DL_PRS_SFN0_Offset_r16 */
static int hf_lpp_nr_DL_PRS_ExpectedRSTD_r16 = -1;  /* INTEGER_M3841_3841 */
static int hf_lpp_nr_DL_PRS_ExpectedRSTD_Uncertainty_r16 = -1;  /* INTEGER_0_246 */
static int hf_lpp_nr_DL_PRS_Info_r16 = -1;        /* NR_DL_PRS_Info_r16 */
static int hf_lpp_prs_OnlyTP_r16 = -1;            /* T_prs_OnlyTP_r16 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_r17 = -1;  /* NR_DL_PRS_ExpectedAoD_or_AoA_r17 */
static int hf_lpp_dl_PRS_SubcarrierSpacing_r16 = -1;  /* T_dl_PRS_SubcarrierSpacing_r16 */
static int hf_lpp_dl_PRS_ResourceBandwidth_r16 = -1;  /* INTEGER_1_63 */
static int hf_lpp_dl_PRS_StartPRB_r16 = -1;       /* INTEGER_0_2176 */
static int hf_lpp_dl_PRS_PointA_r16 = -1;         /* ARFCN_ValueNR_r15 */
static int hf_lpp_dl_PRS_CombSizeN_r16 = -1;      /* T_dl_PRS_CombSizeN_r16 */
static int hf_lpp_dl_PRS_CyclicPrefix_r16 = -1;   /* T_dl_PRS_CyclicPrefix_r16 */
static int hf_lpp_sfn_Offset_r16 = -1;            /* INTEGER_0_1023 */
static int hf_lpp_integerSubframeOffset_r16 = -1;  /* INTEGER_0_9 */
static int hf_lpp_expectedAoD_r17 = -1;           /* T_expectedAoD_r17 */
static int hf_lpp_expectedDL_AzimuthAoD_r17 = -1;  /* INTEGER_0_359 */
static int hf_lpp_expectedDL_AzimuthAoD_Unc_r17 = -1;  /* INTEGER_0_60 */
static int hf_lpp_expectedDL_ZenithAoD_r17 = -1;  /* INTEGER_0_180 */
static int hf_lpp_expectedDL_ZenithAoD_Unc_r17 = -1;  /* INTEGER_0_30 */
static int hf_lpp_expectedAoA_r17 = -1;           /* T_expectedAoA_r17 */
static int hf_lpp_expectedDL_AzimuthAoA_r17 = -1;  /* INTEGER_0_359 */
static int hf_lpp_expectedDL_AzimuthAoA_Unc_r17 = -1;  /* INTEGER_0_60 */
static int hf_lpp_expectedDL_ZenithAoA_r17 = -1;  /* INTEGER_0_180 */
static int hf_lpp_expectedDL_ZenithAoA_Unc_r17 = -1;  /* INTEGER_0_30 */
static int hf_lpp_NR_DL_PRS_BeamInfo_r16_item = -1;  /* NR_DL_PRS_BeamInfoPerFreqLayer_r16 */
static int hf_lpp_NR_DL_PRS_BeamInfoPerFreqLayer_r16_item = -1;  /* NR_DL_PRS_BeamInfoPerTRP_r16 */
static int hf_lpp_associated_DL_PRS_ID_r16 = -1;  /* INTEGER_0_255 */
static int hf_lpp_lcs_GCS_TranslationParameter_r16 = -1;  /* LCS_GCS_TranslationParameter_r16 */
static int hf_lpp_dl_PRS_BeamInfoSet_r16 = -1;    /* DL_PRS_BeamInfoSet_r16 */
static int hf_lpp_DL_PRS_BeamInfoSet_r16_item = -1;  /* DL_PRS_BeamInfoResourceSet_r16 */
static int hf_lpp_DL_PRS_BeamInfoResourceSet_r16_item = -1;  /* DL_PRS_BeamInfoElement_r16 */
static int hf_lpp_dl_PRS_Azimuth_r16 = -1;        /* INTEGER_0_359 */
static int hf_lpp_dl_PRS_Azimuth_fine_r16 = -1;   /* INTEGER_0_9 */
static int hf_lpp_dl_PRS_Elevation_r16 = -1;      /* INTEGER_0_180 */
static int hf_lpp_dl_PRS_Elevation_fine_r16 = -1;  /* INTEGER_0_9 */
static int hf_lpp_NR_DL_PRS_ExpectedLOS_NLOS_Assistance_r17_item = -1;  /* NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerFreqLayer_r17 */
static int hf_lpp_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerFreqLayer_r17_item = -1;  /* NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerTRP_r17 */
static int hf_lpp_dl_PRS_ID_r17 = -1;             /* INTEGER_0_255 */
static int hf_lpp_nr_los_nlos_indicator_r17 = -1;  /* T_nr_los_nlos_indicator_r17 */
static int hf_lpp_perTrp_r17 = -1;                /* LOS_NLOS_Indicator_r17 */
static int hf_lpp_perResource_r17 = -1;           /* SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerResource_r17 */
static int hf_lpp_perResource_r17_item = -1;      /* NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerResource_r17 */
static int hf_lpp_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerResource_r17_item = -1;  /* LOS_NLOS_Indicator_r17 */
static int hf_lpp_nr_DL_PRS_ResourceSetList_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_NR_DL_PRS_ResourceSet_r16 */
static int hf_lpp_nr_DL_PRS_ResourceSetList_r16_item = -1;  /* NR_DL_PRS_ResourceSet_r16 */
static int hf_lpp_dl_PRS_Periodicity_and_ResourceSetSlotOffset_r16 = -1;  /* NR_DL_PRS_Periodicity_and_ResourceSetSlotOffset_r16 */
static int hf_lpp_dl_PRS_ResourceRepetitionFactor_r16 = -1;  /* T_dl_PRS_ResourceRepetitionFactor_r16 */
static int hf_lpp_dl_PRS_ResourceTimeGap_r16 = -1;  /* T_dl_PRS_ResourceTimeGap_r16 */
static int hf_lpp_dl_PRS_NumSymbols_r16 = -1;     /* T_dl_PRS_NumSymbols_r16 */
static int hf_lpp_dl_PRS_MutingOption1_r16 = -1;  /* DL_PRS_MutingOption1_r16 */
static int hf_lpp_dl_PRS_MutingOption2_r16 = -1;  /* DL_PRS_MutingOption2_r16 */
static int hf_lpp_dl_PRS_ResourcePower_r16 = -1;  /* INTEGER_M60_50 */
static int hf_lpp_dl_PRS_ResourceList_r16 = -1;   /* SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_NR_DL_PRS_Resource_r16 */
static int hf_lpp_dl_PRS_ResourceList_r16_item = -1;  /* NR_DL_PRS_Resource_r16 */
static int hf_lpp_dl_prs_MutingBitRepetitionFactor_r16 = -1;  /* T_dl_prs_MutingBitRepetitionFactor_r16 */
static int hf_lpp_nr_option1_muting_r16 = -1;     /* NR_MutingPattern_r16 */
static int hf_lpp_nr_option2_muting_r16 = -1;     /* NR_MutingPattern_r16 */
static int hf_lpp_po2_r16 = -1;                   /* BIT_STRING_SIZE_2 */
static int hf_lpp_po4_r16 = -1;                   /* BIT_STRING_SIZE_4 */
static int hf_lpp_po6_r16 = -1;                   /* BIT_STRING_SIZE_6 */
static int hf_lpp_po8_r16 = -1;                   /* BIT_STRING_SIZE_8 */
static int hf_lpp_po16_r16 = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_lpp_po32_r16 = -1;                  /* BIT_STRING_SIZE_32 */
static int hf_lpp_nr_DL_PRS_ResourceID_r16 = -1;  /* NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_dl_PRS_SequenceID_r16 = -1;     /* INTEGER_0_4095 */
static int hf_lpp_dl_PRS_CombSizeN_AndReOffset_r16 = -1;  /* T_dl_PRS_CombSizeN_AndReOffset_r16 */
static int hf_lpp_n2_r16 = -1;                    /* INTEGER_0_1 */
static int hf_lpp_n4_r16 = -1;                    /* INTEGER_0_3 */
static int hf_lpp_n6_r16 = -1;                    /* INTEGER_0_5 */
static int hf_lpp_n12_r16 = -1;                   /* INTEGER_0_11 */
static int hf_lpp_dl_PRS_ResourceSlotOffset_r16 = -1;  /* INTEGER_0_nrMaxResourceOffsetValue_1_r16 */
static int hf_lpp_dl_PRS_ResourceSymbolOffset_r16 = -1;  /* INTEGER_0_12 */
static int hf_lpp_dl_PRS_QCL_Info_r16 = -1;       /* DL_PRS_QCL_Info_r16 */
static int hf_lpp_dl_PRS_ResourcePrioritySubset_r17 = -1;  /* DL_PRS_ResourcePrioritySubset_r17 */
static int hf_lpp_ssb_r16 = -1;                   /* T_ssb_r16 */
static int hf_lpp_pci_r16 = -1;                   /* NR_PhysCellID_r16 */
static int hf_lpp_ssb_Index_r16 = -1;             /* INTEGER_0_63 */
static int hf_lpp_rs_Type_r16 = -1;               /* T_rs_Type_r16 */
static int hf_lpp_dl_PRS_r16 = -1;                /* T_dl_PRS_r16 */
static int hf_lpp_qcl_DL_PRS_ResourceID_r16 = -1;  /* NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_qcl_DL_PRS_ResourceSetID_r16 = -1;  /* NR_DL_PRS_ResourceSetID_r16 */
static int hf_lpp_scs15_r16 = -1;                 /* T_scs15_r16 */
static int hf_lpp_n5_r16 = -1;                    /* INTEGER_0_4 */
static int hf_lpp_n8_r16 = -1;                    /* INTEGER_0_7 */
static int hf_lpp_n10_r16 = -1;                   /* INTEGER_0_9 */
static int hf_lpp_n16_r16 = -1;                   /* INTEGER_0_15 */
static int hf_lpp_n20_r16 = -1;                   /* INTEGER_0_19 */
static int hf_lpp_n32_r16 = -1;                   /* INTEGER_0_31 */
static int hf_lpp_n40_r16 = -1;                   /* INTEGER_0_39 */
static int hf_lpp_n64_r16 = -1;                   /* INTEGER_0_63 */
static int hf_lpp_n80_r16 = -1;                   /* INTEGER_0_79 */
static int hf_lpp_n160_r16 = -1;                  /* INTEGER_0_159 */
static int hf_lpp_n320_r16 = -1;                  /* INTEGER_0_319 */
static int hf_lpp_n640_r16 = -1;                  /* INTEGER_0_639 */
static int hf_lpp_n1280_r16 = -1;                 /* INTEGER_0_1279 */
static int hf_lpp_n2560_r16 = -1;                 /* INTEGER_0_2559 */
static int hf_lpp_n5120_r16 = -1;                 /* INTEGER_0_5119 */
static int hf_lpp_n10240_r16 = -1;                /* INTEGER_0_10239 */
static int hf_lpp_scs30_r16 = -1;                 /* T_scs30_r16 */
static int hf_lpp_n128_r16 = -1;                  /* INTEGER_0_127 */
static int hf_lpp_n20480_r16 = -1;                /* INTEGER_0_20479 */
static int hf_lpp_scs60_r16 = -1;                 /* T_scs60_r16 */
static int hf_lpp_n256_r16 = -1;                  /* INTEGER_0_255 */
static int hf_lpp_n40960_r16 = -1;                /* INTEGER_0_40959 */
static int hf_lpp_scs120_r16 = -1;                /* T_scs120_r16 */
static int hf_lpp_n512_r16 = -1;                  /* INTEGER_0_511 */
static int hf_lpp_n81920_r16 = -1;                /* INTEGER_0_81919 */
static int hf_lpp_DL_PRS_ResourcePrioritySubset_r17_item = -1;  /* NR_DL_PRSResourcePriorityItem_r17 */
static int hf_lpp_nr_DL_PRS_PrioResourceSetID_r17 = -1;  /* NR_DL_PRS_ResourceSetID_r16 */
static int hf_lpp_nr_DL_PRS_PrioResourceID_r17 = -1;  /* NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_prs_ProcessingCapabilityBandList_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16 */
static int hf_lpp_prs_ProcessingCapabilityBandList_r16_item = -1;  /* PRS_ProcessingCapabilityPerBand_r16 */
static int hf_lpp_maxSupportedFreqLayers_r16 = -1;  /* INTEGER_1_4 */
static int hf_lpp_simulLTE_NR_PRS_r16 = -1;       /* T_simulLTE_NR_PRS_r16 */
static int hf_lpp_dummy = -1;                     /* T_dummy */
static int hf_lpp_freqBandIndicatorNR_r16 = -1;   /* FreqBandIndicatorNR_r16 */
static int hf_lpp_supportedBandwidthPRS_r16 = -1;  /* T_supportedBandwidthPRS_r16 */
static int hf_lpp_fr1 = -1;                       /* T_fr1 */
static int hf_lpp_fr2 = -1;                       /* T_fr2 */
static int hf_lpp_dl_PRS_BufferType_r16 = -1;     /* T_dl_PRS_BufferType_r16 */
static int hf_lpp_durationOfPRS_Processing_r16 = -1;  /* T_durationOfPRS_Processing_r16 */
static int hf_lpp_durationOfPRS_ProcessingSymbols_r16 = -1;  /* T_durationOfPRS_ProcessingSymbols_r16 */
static int hf_lpp_durationOfPRS_ProcessingSymbolsInEveryTms_r16 = -1;  /* T_durationOfPRS_ProcessingSymbolsInEveryTms_r16 */
static int hf_lpp_maxNumOfDL_PRS_ResProcessedPerSlot_r16 = -1;  /* T_maxNumOfDL_PRS_ResProcessedPerSlot_r16 */
static int hf_lpp_scs15_r16_01 = -1;              /* T_scs15_r16_01 */
static int hf_lpp_scs30_r16_01 = -1;              /* T_scs30_r16_01 */
static int hf_lpp_scs60_r16_01 = -1;              /* T_scs60_r16_01 */
static int hf_lpp_scs120_r16_01 = -1;             /* T_scs120_r16_01 */
static int hf_lpp_scs15_v1690 = -1;               /* T_scs15_v1690 */
static int hf_lpp_scs30_v1690 = -1;               /* T_scs30_v1690 */
static int hf_lpp_scs60_v1690 = -1;               /* T_scs60_v1690 */
static int hf_lpp_scs120_v1690 = -1;              /* T_scs120_v1690 */
static int hf_lpp_supportedDL_PRS_ProcessingSamples_RRC_CONNECTED_r17 = -1;  /* T_supportedDL_PRS_ProcessingSamples_RRC_CONNECTED_r17 */
static int hf_lpp_prs_ProcessingWindowType1A_r17 = -1;  /* T_prs_ProcessingWindowType1A_r17 */
static int hf_lpp_prs_ProcessingWindowType1B_r17 = -1;  /* T_prs_ProcessingWindowType1B_r17 */
static int hf_lpp_prs_ProcessingWindowType2_r17 = -1;  /* T_prs_ProcessingWindowType2_r17 */
static int hf_lpp_prs_ProcessingCapabilityOutsideMGinPPW_r17 = -1;  /* SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17 */
static int hf_lpp_prs_ProcessingCapabilityOutsideMGinPPW_r17_item = -1;  /* PRS_ProcessingCapabilityOutsideMGinPPWperType_r17 */
static int hf_lpp_dl_PRS_BufferType_RRC_Inactive_r17 = -1;  /* T_dl_PRS_BufferType_RRC_Inactive_r17 */
static int hf_lpp_durationOfPRS_Processing_RRC_Inactive_r17 = -1;  /* T_durationOfPRS_Processing_RRC_Inactive_r17 */
static int hf_lpp_durationOfPRS_ProcessingSymbols_r17 = -1;  /* T_durationOfPRS_ProcessingSymbols_r17 */
static int hf_lpp_durationOfPRS_ProcessingSymbolsInEveryTms_r17 = -1;  /* T_durationOfPRS_ProcessingSymbolsInEveryTms_r17 */
static int hf_lpp_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17 = -1;  /* T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17 */
static int hf_lpp_scs15_r17_01 = -1;              /* T_scs15_r17 */
static int hf_lpp_scs30_r17_01 = -1;              /* T_scs30_r17 */
static int hf_lpp_scs60_r17_01 = -1;              /* T_scs60_r17 */
static int hf_lpp_scs120_r17_01 = -1;             /* T_scs120_r17 */
static int hf_lpp_supportedLowerRxBeamSweepingFactor_FR2_r17 = -1;  /* T_supportedLowerRxBeamSweepingFactor_FR2_r17 */
static int hf_lpp_supportedDL_PRS_ProcessingSamples_RRC_Inactive_r17 = -1;  /* T_supportedDL_PRS_ProcessingSamples_RRC_Inactive_r17 */
static int hf_lpp_prs_MeasurementWithoutMG_r17 = -1;  /* T_prs_MeasurementWithoutMG_r17 */
static int hf_lpp_prsProcessingType_r17 = -1;     /* T_prsProcessingType_r17 */
static int hf_lpp_ppw_dl_PRS_BufferType_r17 = -1;  /* T_ppw_dl_PRS_BufferType_r17 */
static int hf_lpp_ppw_durationOfPRS_Processing1_r17 = -1;  /* T_ppw_durationOfPRS_Processing1_r17 */
static int hf_lpp_ppw_durationOfPRS_ProcessingSymbolsN_r17 = -1;  /* T_ppw_durationOfPRS_ProcessingSymbolsN_r17 */
static int hf_lpp_ppw_durationOfPRS_ProcessingSymbolsT_r17 = -1;  /* T_ppw_durationOfPRS_ProcessingSymbolsT_r17 */
static int hf_lpp_ppw_durationOfPRS_Processing2_r17 = -1;  /* T_ppw_durationOfPRS_Processing2_r17 */
static int hf_lpp_ppw_durationOfPRS_ProcessingSymbolsN2_r17 = -1;  /* T_ppw_durationOfPRS_ProcessingSymbolsN2_r17 */
static int hf_lpp_ppw_durationOfPRS_ProcessingSymbolsT2_r17 = -1;  /* T_ppw_durationOfPRS_ProcessingSymbolsT2_r17 */
static int hf_lpp_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17 = -1;  /* T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17 */
static int hf_lpp_scs15_r17_02 = -1;              /* T_scs15_r17_01 */
static int hf_lpp_scs30_r17_02 = -1;              /* T_scs30_r17_01 */
static int hf_lpp_scs60_r17_02 = -1;              /* T_scs60_r17_01 */
static int hf_lpp_scs120_r17_02 = -1;             /* T_scs120_r17_01 */
static int hf_lpp_ppw_maxNumOfDL_Bandwidth_r17 = -1;  /* T_ppw_maxNumOfDL_Bandwidth_r17 */
static int hf_lpp_fr1_01 = -1;                    /* T_fr1_01 */
static int hf_lpp_fr2_01 = -1;                    /* T_fr2_01 */
static int hf_lpp_dl_PRS_QCL_ProcessingCapabilityBandList_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16 */
static int hf_lpp_dl_PRS_QCL_ProcessingCapabilityBandList_r16_item = -1;  /* DL_PRS_QCL_ProcessingCapabilityPerBand_r16 */
static int hf_lpp_ssb_FromNeighCellAsQCL_r16 = -1;  /* T_ssb_FromNeighCellAsQCL_r16 */
static int hf_lpp_prs_FromServNeighCellAsQCL_r16 = -1;  /* T_prs_FromServNeighCellAsQCL_r16 */
static int hf_lpp_maxNrOfDL_PRS_ResourceSetPerTrpPerFrequencyLayer_r16 = -1;  /* INTEGER_1_2 */
static int hf_lpp_maxNrOfTRP_AcrossFreqs_r16 = -1;  /* T_maxNrOfTRP_AcrossFreqs_r16 */
static int hf_lpp_maxNrOfPosLayer_r16 = -1;       /* INTEGER_1_4 */
static int hf_lpp_dl_PRS_ResourcesCapabilityBandList_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16 */
static int hf_lpp_dl_PRS_ResourcesCapabilityBandList_r16_item = -1;  /* DL_PRS_ResourcesCapabilityPerBand_r16 */
static int hf_lpp_dl_PRS_ResourcesBandCombinationList_r16 = -1;  /* DL_PRS_ResourcesBandCombinationList_r16 */
static int hf_lpp_maxNrOfDL_PRS_ResourcesPerResourceSet_r16 = -1;  /* T_maxNrOfDL_PRS_ResourcesPerResourceSet_r16 */
static int hf_lpp_maxNrOfDL_PRS_ResourcesPerPositioningFrequencylayer_r16 = -1;  /* T_maxNrOfDL_PRS_ResourcesPerPositioningFrequencylayer_r16 */
static int hf_lpp_DL_PRS_ResourcesBandCombinationList_r16_item = -1;  /* DL_PRS_ResourcesBandCombination_r16 */
static int hf_lpp_bandList_r16 = -1;              /* SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16 */
static int hf_lpp_bandList_r16_item = -1;         /* FreqBandIndicatorNR_r16 */
static int hf_lpp_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16 = -1;  /* T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16 */
static int hf_lpp_fr1_Only_r16 = -1;              /* T_fr1_Only_r16 */
static int hf_lpp_fr2_Only_r16 = -1;              /* T_fr2_Only_r16 */
static int hf_lpp_fr1_FR2Mix_r16 = -1;            /* T_fr1_FR2Mix_r16 */
static int hf_lpp_fr1_r16 = -1;                   /* T_fr1_r16 */
static int hf_lpp_fr2_r16 = -1;                   /* T_fr2_r16 */
static int hf_lpp_NR_DL_PRS_TRP_TEG_Info_r17_item = -1;  /* NR_DL_PRS_TRP_TEG_InfoPerFreqLayer_r17 */
static int hf_lpp_NR_DL_PRS_TRP_TEG_InfoPerFreqLayer_r17_item = -1;  /* NR_DL_PRS_TRP_TEG_InfoPerTRP_r17 */
static int hf_lpp_dl_PRS_TEG_InfoSet_r17 = -1;    /* SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_TEG_InfoPerResourceSet_r17 */
static int hf_lpp_dl_PRS_TEG_InfoSet_r17_item = -1;  /* DL_PRS_TEG_InfoPerResourceSet_r17 */
static int hf_lpp_nr_TRP_TxTEG_TimingErrorMargin_r17 = -1;  /* TEG_TimingErrorMargin_r17 */
static int hf_lpp_DL_PRS_TEG_InfoPerResourceSet_r17_item = -1;  /* DL_PRS_TEG_InfoElement_r17 */
static int hf_lpp_dl_prs_trp_Tx_TEG_ID_r17 = -1;  /* INTEGER_0_maxNumOfTRP_TxTEGs_1_r17 */
static int hf_lpp_on_demand_dl_prs_configuration_list_r17 = -1;  /* SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_On_Demand_DL_PRS_Configuration_r17 */
static int hf_lpp_on_demand_dl_prs_configuration_list_r17_item = -1;  /* On_Demand_DL_PRS_Configuration_r17 */
static int hf_lpp_dl_prs_configuration_id_r17 = -1;  /* DL_PRS_Configuration_ID_r17 */
static int hf_lpp_nr_DL_PRS_PositioningFrequencyLayer_r17 = -1;  /* NR_DL_PRS_PositioningFrequencyLayer_r16 */
static int hf_lpp_nr_DL_PRS_Info_r17 = -1;        /* NR_DL_PRS_Info_r16 */
static int hf_lpp_nr_dl_prs_configuration_id_r17 = -1;  /* INTEGER_1_maxOD_DL_PRS_Configs_r17 */
static int hf_lpp_NR_On_Demand_DL_PRS_Information_r17_item = -1;  /* NR_On_Demand_DL_PRS_PerFreqLayer_r17 */
static int hf_lpp_dl_prs_FrequencyRangeReq_r17 = -1;  /* T_dl_prs_FrequencyRangeReq_r17 */
static int hf_lpp_dl_prs_ResourceSetPeriodicityReq_r17 = -1;  /* T_dl_prs_ResourceSetPeriodicityReq_r17 */
static int hf_lpp_dl_prs_ResourceBandwidthReq_r17 = -1;  /* INTEGER_1_63 */
static int hf_lpp_dl_prs_ResourceRepetitionFactorReq_r17 = -1;  /* T_dl_prs_ResourceRepetitionFactorReq_r17 */
static int hf_lpp_dl_prs_NumSymbolsReq_r17 = -1;  /* T_dl_prs_NumSymbolsReq_r17 */
static int hf_lpp_dl_prs_CombSizeN_Req_r17 = -1;  /* T_dl_prs_CombSizeN_Req_r17 */
static int hf_lpp_dl_prs_QCL_InformationReqTRPlist_r17 = -1;  /* DL_PRS_QCL_InformationReqTRPlist_r17 */
static int hf_lpp_DL_PRS_QCL_InformationReqTRPlist_r17_item = -1;  /* DL_PRS_QCL_InformationReqPerTRP_r17 */
static int hf_lpp_dl_prs_QCL_InformationReqSet_r17 = -1;  /* SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17 */
static int hf_lpp_dl_prs_QCL_InformationReqSet_r17_item = -1;  /* DL_PRS_QCL_InfoReq_r17 */
static int hf_lpp_nr_DL_PRS_ResourceSetID_r17 = -1;  /* NR_DL_PRS_ResourceSetID_r16 */
static int hf_lpp_dl_prs_QCL_InformationReq_r17 = -1;  /* T_dl_prs_QCL_InformationReq_r17 */
static int hf_lpp_dl_prs_QCL_InfoRecPerResourceSet_r17 = -1;  /* DL_PRS_QCL_Info_r16 */
static int hf_lpp_dl_prs_QCL_Info_requested_r17 = -1;  /* NULL */
static int hf_lpp_dl_prs_QCL_InfoRecPerResource_r17 = -1;  /* SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16 */
static int hf_lpp_dl_prs_QCL_InfoRecPerResource_r17_item = -1;  /* DL_PRS_QCL_Info_r16 */
static int hf_lpp_dl_prs_StartTime_and_Duration_r17 = -1;  /* DL_PRS_StartTime_and_Duration_r17 */
static int hf_lpp_nr_on_demand_DL_PRS_Information_r17 = -1;  /* NR_On_Demand_DL_PRS_Information_r17 */
static int hf_lpp_dl_prs_configuration_id_PrefList_r17 = -1;  /* SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17 */
static int hf_lpp_dl_prs_configuration_id_PrefList_r17_item = -1;  /* DL_PRS_Configuration_ID_r17 */
static int hf_lpp_dl_prs_start_time_r17 = -1;     /* INTEGER_1_1024 */
static int hf_lpp_dl_prs_duration_r17 = -1;       /* T_dl_prs_duration_r17 */
static int hf_lpp_seconds_r17 = -1;               /* INTEGER_0_59 */
static int hf_lpp_minutes_r17 = -1;               /* INTEGER_0_59 */
static int hf_lpp_hours_r17 = -1;                 /* INTEGER_0_23 */
static int hf_lpp_NR_On_Demand_DL_PRS_Configurations_Selected_IndexList_r17_item = -1;  /* DL_PRS_Configuration_ID_r17 */
static int hf_lpp_nr_on_demand_DL_PRS_InformationSup_r17 = -1;  /* T_nr_on_demand_DL_PRS_InformationSup_r17 */
static int hf_lpp_nr_on_demand_DL_PRS_ConfigurationsSup_r17 = -1;  /* T_nr_on_demand_DL_PRS_ConfigurationsSup_r17 */
static int hf_lpp_nr_TRP_LocationInfo_r16 = -1;   /* NR_TRP_LocationInfo_r16 */
static int hf_lpp_nr_DL_PRS_BeamInfo_r16 = -1;    /* NR_DL_PRS_BeamInfo_r16 */
static int hf_lpp_nr_RTD_Info_r16 = -1;           /* NR_RTD_Info_r16 */
static int hf_lpp_nr_TRP_BeamAntennaInfo_r17 = -1;  /* NR_TRP_BeamAntennaInfo_r17 */
static int hf_lpp_nr_DL_PRS_Expected_LOS_NLOS_Assistance_r17 = -1;  /* NR_DL_PRS_ExpectedLOS_NLOS_Assistance_r17 */
static int hf_lpp_nr_DL_PRS_TRP_TEG_Info_r17 = -1;  /* NR_DL_PRS_TRP_TEG_Info_r17 */
static int hf_lpp_referenceTRP_RTD_Info_r16 = -1;  /* ReferenceTRP_RTD_Info_r16 */
static int hf_lpp_rtd_InfoList_r16 = -1;          /* RTD_InfoList_r16 */
static int hf_lpp_dl_PRS_ID_Ref_r16 = -1;         /* INTEGER_0_255 */
static int hf_lpp_nr_PhysCellID_Ref_r16 = -1;     /* NR_PhysCellID_r16 */
static int hf_lpp_nr_CellGlobalID_Ref_r16 = -1;   /* NCGI_r15 */
static int hf_lpp_nr_ARFCN_Ref_r16 = -1;          /* ARFCN_ValueNR_r15 */
static int hf_lpp_refTime_r16 = -1;               /* T_refTime_r16 */
static int hf_lpp_systemFrameNumber_r16 = -1;     /* BIT_STRING_SIZE_10 */
static int hf_lpp_utc_r16 = -1;                   /* UTCTime */
static int hf_lpp_rtd_RefQuality_r16 = -1;        /* NR_TimingQuality_r16 */
static int hf_lpp_RTD_InfoList_r16_item = -1;     /* RTD_InfoListPerFreqLayer_r16 */
static int hf_lpp_RTD_InfoListPerFreqLayer_r16_item = -1;  /* RTD_InfoElement_r16 */
static int hf_lpp_subframeOffset_r16 = -1;        /* INTEGER_0_1966079 */
static int hf_lpp_rtd_Quality_r16 = -1;           /* NR_TimingQuality_r16 */
static int hf_lpp_NR_SelectedDL_PRS_IndexList_r16_item = -1;  /* NR_SelectedDL_PRS_PerFreq_r16 */
static int hf_lpp_nr_SelectedDL_PRS_FrequencyLayerIndex_r16 = -1;  /* INTEGER_0_nrMaxFreqLayers_1_r16 */
static int hf_lpp_nr_SelectedDL_PRS_IndexListPerFreq_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_NR_SelectedDL_PRS_IndexPerTRP_r16 */
static int hf_lpp_nr_SelectedDL_PRS_IndexListPerFreq_r16_item = -1;  /* NR_SelectedDL_PRS_IndexPerTRP_r16 */
static int hf_lpp_nr_SelectedTRP_Index_r16 = -1;  /* INTEGER_0_nrMaxTRPsPerFreq_1_r16 */
static int hf_lpp_dl_SelectedPRS_ResourceSetIndexList_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_SelectedPRS_ResourceSetIndex_r16 */
static int hf_lpp_dl_SelectedPRS_ResourceSetIndexList_r16_item = -1;  /* DL_SelectedPRS_ResourceSetIndex_r16 */
static int hf_lpp_nr_DL_SelectedPRS_ResourceSetIndex_r16 = -1;  /* INTEGER_0_nrMaxSetsPerTrpPerFreqLayer_1_r16 */
static int hf_lpp_dl_SelectedPRS_ResourceIndexList_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_SelectedPRS_ResourceIndex_r16 */
static int hf_lpp_dl_SelectedPRS_ResourceIndexList_r16_item = -1;  /* DL_SelectedPRS_ResourceIndex_r16 */
static int hf_lpp_nr_DL_SelectedPRS_ResourceIdIndex_r16 = -1;  /* INTEGER_0_nrMaxNumDL_PRS_ResourcesPerSet_1_r16 */
static int hf_lpp_ss_PBCH_BlockPower_r16 = -1;    /* INTEGER_M60_50 */
static int hf_lpp_halfFrameIndex_r16 = -1;        /* INTEGER_0_1 */
static int hf_lpp_ssb_periodicity_r16 = -1;       /* T_ssb_periodicity_r16 */
static int hf_lpp_ssb_PositionsInBurst_r16 = -1;  /* T_ssb_PositionsInBurst_r16 */
static int hf_lpp_shortBitmap_r16 = -1;           /* BIT_STRING_SIZE_4 */
static int hf_lpp_mediumBitmap_r16 = -1;          /* BIT_STRING_SIZE_8 */
static int hf_lpp_longBitmap_r16 = -1;            /* BIT_STRING_SIZE_64 */
static int hf_lpp_ssb_SubcarrierSpacing_r16 = -1;  /* T_ssb_SubcarrierSpacing_r16 */
static int hf_lpp_sfn_SSB_Offset_r16 = -1;        /* INTEGER_0_15 */
static int hf_lpp_nr_SFN_r16 = -1;                /* INTEGER_0_1023 */
static int hf_lpp_nr_Slot_r16 = -1;               /* T_nr_Slot_r16 */
static int hf_lpp_scs15_r16_02 = -1;              /* INTEGER_0_9 */
static int hf_lpp_scs30_r16_02 = -1;              /* INTEGER_0_19 */
static int hf_lpp_scs60_r16_02 = -1;              /* INTEGER_0_39 */
static int hf_lpp_scs120_r16_02 = -1;             /* INTEGER_0_79 */
static int hf_lpp_timingQualityValue_r16 = -1;    /* INTEGER_0_31 */
static int hf_lpp_timingQualityResolution_r16 = -1;  /* T_timingQualityResolution_r16 */
static int hf_lpp_NR_TRP_BeamAntennaInfo_r17_item = -1;  /* NR_TRP_BeamAntennaInfoPerFreqLayer_r17 */
static int hf_lpp_NR_TRP_BeamAntennaInfoPerFreqLayer_r17_item = -1;  /* NR_TRP_BeamAntennaInfoPerTRP_r17 */
static int hf_lpp_associated_DL_PRS_ID_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_lcs_GCS_TranslationParameter_r17 = -1;  /* LCS_GCS_TranslationParameter_r16 */
static int hf_lpp_nr_TRP_BeamAntennaAngles_r17 = -1;  /* NR_TRP_BeamAntennaAngles_r17 */
static int hf_lpp_NR_TRP_BeamAntennaAngles_r17_item = -1;  /* NR_TRP_BeamAntennaInfoAzimuthElevation_r17 */
static int hf_lpp_azimuth_r17 = -1;               /* INTEGER_0_359 */
static int hf_lpp_azimuth_fine_r17 = -1;          /* INTEGER_0_9 */
static int hf_lpp_elevationList_r17 = -1;         /* SEQUENCE_SIZE_1_1801_OF_ElevationElement_R17 */
static int hf_lpp_elevationList_r17_item = -1;    /* ElevationElement_R17 */
static int hf_lpp_elevation_r17 = -1;             /* INTEGER_0_180 */
static int hf_lpp_elevation_fine_r17 = -1;        /* INTEGER_0_9 */
static int hf_lpp_beamPowerList_r17 = -1;         /* SEQUENCE_SIZE_2_maxNumResourcesPerAngle_r17_OF_BeamPowerElement_r17 */
static int hf_lpp_beamPowerList_r17_item = -1;    /* BeamPowerElement_r17 */
static int hf_lpp_nr_dl_prs_ResourceSetID_r17 = -1;  /* NR_DL_PRS_ResourceSetID_r16 */
static int hf_lpp_nr_dl_prs_ResourceID_r17 = -1;  /* NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_nr_dl_prs_RelativePower_r17 = -1;  /* INTEGER_0_30 */
static int hf_lpp_nr_dl_prs_RelativePowerFine_r17 = -1;  /* INTEGER_0_9 */
static int hf_lpp_NR_TRP_LocationInfo_r16_item = -1;  /* NR_TRP_LocationInfoPerFreqLayer_r16 */
static int hf_lpp_referencePoint_r16 = -1;        /* ReferencePoint_r16 */
static int hf_lpp_trp_LocationInfoList_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_TRP_LocationInfoElement_r16 */
static int hf_lpp_trp_LocationInfoList_r16_item = -1;  /* TRP_LocationInfoElement_r16 */
static int hf_lpp_trp_Location_r16 = -1;          /* RelativeLocation_r16 */
static int hf_lpp_trp_DL_PRS_ResourceSets_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_ResourceSets_TRP_Element_r16 */
static int hf_lpp_trp_DL_PRS_ResourceSets_r16_item = -1;  /* DL_PRS_ResourceSets_TRP_Element_r16 */
static int hf_lpp_dl_PRS_ResourceSetARP_r16 = -1;  /* RelativeLocation_r16 */
static int hf_lpp_dl_PRS_Resource_ARP_List_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_Resource_ARP_Element_r16 */
static int hf_lpp_dl_PRS_Resource_ARP_List_r16_item = -1;  /* DL_PRS_Resource_ARP_Element_r16 */
static int hf_lpp_dl_PRS_Resource_ARP_location_r16 = -1;  /* RelativeLocation_r16 */
static int hf_lpp_nr_UE_TEG_ID_CapabilityBandList_r17 = -1;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17 */
static int hf_lpp_nr_UE_TEG_ID_CapabilityBandList_r17_item = -1;  /* NR_UE_TEG_ID_CapabilityPerBand_r17 */
static int hf_lpp_freqBandIndicatorNR_r17 = -1;   /* FreqBandIndicatorNR_r16 */
static int hf_lpp_nr_UE_RxTEG_ID_MaxSupport_r17 = -1;  /* T_nr_UE_RxTEG_ID_MaxSupport_r17 */
static int hf_lpp_nr_UE_TxTEG_ID_MaxSupport_r17 = -1;  /* T_nr_UE_TxTEG_ID_MaxSupport_r17 */
static int hf_lpp_nr_UE_RxTxTEG_ID_MaxSupport_r17 = -1;  /* T_nr_UE_RxTxTEG_ID_MaxSupport_r17 */
static int hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17 = -1;  /* T_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17 */
static int hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTEGsSimul_r17 = -1;  /* T_measureSameDL_PRS_ResourceWithDifferentRxTEGsSimul_r17 */
static int hf_lpp_srs_CapabilityBandList_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16 */
static int hf_lpp_srs_CapabilityBandList_r16_item = -1;  /* SRS_CapabilityPerBand_r16 */
static int hf_lpp_srs_PosResourceConfigCA_BandList_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16 */
static int hf_lpp_srs_PosResourceConfigCA_BandList_r16_item = -1;  /* SRS_PosResourcesPerBand_r16 */
static int hf_lpp_maxNumberSRS_PosPathLossEstimateAllServingCells_r16 = -1;  /* T_maxNumberSRS_PosPathLossEstimateAllServingCells_r16 */
static int hf_lpp_maxNumberSRS_PosSpatialRelationsAllServingCells_r16 = -1;  /* T_maxNumberSRS_PosSpatialRelationsAllServingCells_r16 */
static int hf_lpp_olpc_SRS_Pos_r16 = -1;          /* OLPC_SRS_Pos_r16 */
static int hf_lpp_spatialRelationsSRS_Pos_r16 = -1;  /* SpatialRelationsSRS_Pos_r16 */
static int hf_lpp_posSRS_RRC_Inactive_InInitialUL_BWP_r17 = -1;  /* PosSRS_RRC_Inactive_InInitialUL_BWP_r17 */
static int hf_lpp_posSRS_RRC_Inactive_OutsideInitialUL_BWP_r17 = -1;  /* PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17 */
static int hf_lpp_olpc_SRS_PosRRC_Inactive_r17 = -1;  /* OLPC_SRS_Pos_r16 */
static int hf_lpp_spatialRelationsSRS_PosRRC_Inactive_r17 = -1;  /* SpatialRelationsSRS_Pos_r16 */
static int hf_lpp_posSRS_SP_RRC_Inactive_InInitialUL_BWP_r17 = -1;  /* PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17 */
static int hf_lpp_olpc_SRS_PosBasedOnPRS_Serving_r16 = -1;  /* T_olpc_SRS_PosBasedOnPRS_Serving_r16 */
static int hf_lpp_olpc_SRS_PosBasedOnSSB_Neigh_r16 = -1;  /* T_olpc_SRS_PosBasedOnSSB_Neigh_r16 */
static int hf_lpp_olpc_SRS_PosBasedOnPRS_Neigh_r16 = -1;  /* T_olpc_SRS_PosBasedOnPRS_Neigh_r16 */
static int hf_lpp_maxNumberPathLossEstimatePerServing_r16 = -1;  /* T_maxNumberPathLossEstimatePerServing_r16 */
static int hf_lpp_spatialRelation_SRS_PosBasedOnSSB_Serving_r16 = -1;  /* T_spatialRelation_SRS_PosBasedOnSSB_Serving_r16 */
static int hf_lpp_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16 = -1;  /* T_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16 */
static int hf_lpp_spatialRelation_SRS_PosBasedOnPRS_Serving_r16 = -1;  /* T_spatialRelation_SRS_PosBasedOnPRS_Serving_r16 */
static int hf_lpp_spatialRelation_SRS_PosBasedOnSRS_r16 = -1;  /* T_spatialRelation_SRS_PosBasedOnSRS_r16 */
static int hf_lpp_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16 = -1;  /* T_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16 */
static int hf_lpp_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16 = -1;  /* T_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16 */
static int hf_lpp_maxNumberSRS_PosResourceSetsPerBWP_r16 = -1;  /* T_maxNumberSRS_PosResourceSetsPerBWP_r16 */
static int hf_lpp_maxNumberSRS_PosResourcesPerBWP_r16 = -1;  /* T_maxNumberSRS_PosResourcesPerBWP_r16 */
static int hf_lpp_maxNumberPeriodicSRS_PosResourcesPerBWP_r16 = -1;  /* T_maxNumberPeriodicSRS_PosResourcesPerBWP_r16 */
static int hf_lpp_maxNumberAP_SRS_PosResourcesPerBWP_r16 = -1;  /* T_maxNumberAP_SRS_PosResourcesPerBWP_r16 */
static int hf_lpp_maxNumberSP_SRS_PosResourcesPerBWP_r16 = -1;  /* T_maxNumberSP_SRS_PosResourcesPerBWP_r16 */
static int hf_lpp_maxNumOfSRSposResourceSets_r17 = -1;  /* T_maxNumOfSRSposResourceSets_r17 */
static int hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17 = -1;  /* T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17 */
static int hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17 = -1;  /* T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17 */
static int hf_lpp_maxNumOfPeriodicSRSposResources_r17 = -1;  /* T_maxNumOfPeriodicSRSposResources_r17 */
static int hf_lpp_maxNumOfPeriodicSRSposResourcesPerSlot_r17 = -1;  /* T_maxNumOfPeriodicSRSposResourcesPerSlot_r17 */
static int hf_lpp_dummy1 = -1;                    /* T_dummy1 */
static int hf_lpp_dummy2 = -1;                    /* T_dummy2 */
static int hf_lpp_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17 = -1;  /* T_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17 */
static int hf_lpp_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17 = -1;  /* T_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17 */
static int hf_lpp_maxNumOfSRSposResourceSets_r17_01 = -1;  /* T_maxNumOfSRSposResourceSets_r17_01 */
static int hf_lpp_maxNumOfPeriodicSRSposResources_r17_01 = -1;  /* T_maxNumOfPeriodicSRSposResources_r17_01 */
static int hf_lpp_maxNumOfPeriodicSRSposResourcesPerSlot_r17_01 = -1;  /* T_maxNumOfPeriodicSRSposResourcesPerSlot_r17_01 */
static int hf_lpp_differentNumerologyBetweenSRSposAndInitialBWP_r17 = -1;  /* T_differentNumerologyBetweenSRSposAndInitialBWP_r17 */
static int hf_lpp_srsPosWithoutRestrictionOnBWP_r17 = -1;  /* T_srsPosWithoutRestrictionOnBWP_r17 */
static int hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_01 = -1;  /* T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_01 */
static int hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_01 = -1;  /* T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_01 */
static int hf_lpp_differentCenterFreqBetweenSRSposAndInitialBWP_r17 = -1;  /* T_differentCenterFreqBetweenSRSposAndInitialBWP_r17 */
static int hf_lpp_maxNumOfSemiPersistentSRSposResources_r17 = -1;  /* T_maxNumOfSemiPersistentSRSposResources_r17 */
static int hf_lpp_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17 = -1;  /* T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17 */
static int hf_lpp_switchingTimeSRS_TX_OtherTX_r17 = -1;  /* T_switchingTimeSRS_TX_OtherTX_r17 */
static int hf_lpp_maxNumOfSemiPersistentSRSposResources_r17_01 = -1;  /* T_maxNumOfSemiPersistentSRSposResources_r17_01 */
static int hf_lpp_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01 = -1;  /* T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01 */
static int hf_lpp_referencePointGeographicLocation_r16 = -1;  /* T_referencePointGeographicLocation_r16 */
static int hf_lpp_location3D_r16 = -1;            /* EllipsoidPointWithAltitudeAndUncertaintyEllipsoid */
static int hf_lpp_ha_location3D_r16 = -1;         /* HighAccuracyEllipsoidPointWithAltitudeAndUncertaintyEllipsoid_r15 */
static int hf_lpp_milli_arc_second_units_r16 = -1;  /* T_milli_arc_second_units_r16 */
static int hf_lpp_height_units_r16 = -1;          /* T_height_units_r16 */
static int hf_lpp_delta_latitude_r16 = -1;        /* Delta_Latitude_r16 */
static int hf_lpp_delta_longitude_r16 = -1;       /* Delta_Longitude_r16 */
static int hf_lpp_delta_height_r16 = -1;          /* Delta_Height_r16 */
static int hf_lpp_locationUNC_r16 = -1;           /* LocationUncertainty_r16 */
static int hf_lpp_delta_Latitude_r16 = -1;        /* INTEGER_M1024_1023 */
static int hf_lpp_coarse_delta_Latitude_r16 = -1;  /* INTEGER_0_4095 */
static int hf_lpp_delta_Longitude_r16 = -1;       /* INTEGER_M1024_1023 */
static int hf_lpp_coarse_delta_Longitude_r16 = -1;  /* INTEGER_0_4095 */
static int hf_lpp_delta_Height_r16 = -1;          /* INTEGER_M1024_1023 */
static int hf_lpp_coarse_delta_Height_r16 = -1;   /* INTEGER_0_4095 */
static int hf_lpp_horizontalUncertainty_r16 = -1;  /* INTEGER_0_255 */
static int hf_lpp_verticalUncertainty_r16 = -1;   /* INTEGER_0_255 */
static int hf_lpp_otdoa_ReferenceCellInfo = -1;   /* OTDOA_ReferenceCellInfo */
static int hf_lpp_otdoa_NeighbourCellInfo = -1;   /* OTDOA_NeighbourCellInfoList */
static int hf_lpp_otdoa_Error = -1;               /* OTDOA_Error */
static int hf_lpp_otdoa_ReferenceCellInfoNB_r14 = -1;  /* OTDOA_ReferenceCellInfoNB_r14 */
static int hf_lpp_otdoa_NeighbourCellInfoNB_r14 = -1;  /* OTDOA_NeighbourCellInfoListNB_r14 */
static int hf_lpp_physCellId = -1;                /* INTEGER_0_503 */
static int hf_lpp_cellGlobalId = -1;              /* ECGI */
static int hf_lpp_earfcnRef = -1;                 /* ARFCN_ValueEUTRA */
static int hf_lpp_antennaPortConfig = -1;         /* T_antennaPortConfig */
static int hf_lpp_cpLength = -1;                  /* T_cpLength */
static int hf_lpp_prsInfo = -1;                   /* PRS_Info */
static int hf_lpp_earfcnRef_v9a0 = -1;            /* ARFCN_ValueEUTRA_v9a0 */
static int hf_lpp_tpId_r14 = -1;                  /* INTEGER_0_4095 */
static int hf_lpp_cpLengthCRS_r14 = -1;           /* T_cpLengthCRS_r14 */
static int hf_lpp_sameMBSFNconfigRef_r14 = -1;    /* BOOLEAN */
static int hf_lpp_dlBandwidth_r14 = -1;           /* T_dlBandwidth_r14 */
static int hf_lpp_addPRSconfigRef_r14 = -1;       /* SEQUENCE_SIZE_1_maxAddPRSconfig_r14_OF_PRS_Info */
static int hf_lpp_addPRSconfigRef_r14_item = -1;  /* PRS_Info */
static int hf_lpp_nr_LTE_SFN_Offset_r15 = -1;     /* INTEGER_0_1023 */
static int hf_lpp_tdd_config_v1520 = -1;          /* TDD_Config_v1520 */
static int hf_lpp_nr_LTE_fineTiming_Offset_r15 = -1;  /* INTEGER_0_19 */
static int hf_lpp_prs_Bandwidth = -1;             /* T_prs_Bandwidth */
static int hf_lpp_prs_ConfigurationIndex = -1;    /* INTEGER_0_4095 */
static int hf_lpp_numDL_Frames = -1;              /* T_numDL_Frames */
static int hf_lpp_prs_MutingInfo_r9 = -1;         /* T_prs_MutingInfo_r9 */
static int hf_lpp_po2_r9 = -1;                    /* BIT_STRING_SIZE_2 */
static int hf_lpp_po4_r9 = -1;                    /* BIT_STRING_SIZE_4 */
static int hf_lpp_po8_r9 = -1;                    /* BIT_STRING_SIZE_8 */
static int hf_lpp_po16_r9 = -1;                   /* BIT_STRING_SIZE_16 */
static int hf_lpp_po32_v1420 = -1;                /* BIT_STRING_SIZE_32 */
static int hf_lpp_po64_v1420 = -1;                /* BIT_STRING_SIZE_64 */
static int hf_lpp_po128_v1420 = -1;               /* BIT_STRING_SIZE_128 */
static int hf_lpp_po256_v1420 = -1;               /* BIT_STRING_SIZE_256 */
static int hf_lpp_po512_v1420 = -1;               /* BIT_STRING_SIZE_512 */
static int hf_lpp_po1024_v1420 = -1;              /* BIT_STRING_SIZE_1024 */
static int hf_lpp_prsID_r14 = -1;                 /* INTEGER_0_4095 */
static int hf_lpp_add_numDL_Frames_r14 = -1;      /* INTEGER_1_160 */
static int hf_lpp_prsOccGroupLen_r14 = -1;        /* T_prsOccGroupLen_r14 */
static int hf_lpp_prsHoppingInfo_r14 = -1;        /* T_prsHoppingInfo_r14 */
static int hf_lpp_nb2_r14 = -1;                   /* INTEGER_0_maxAvailNarrowBands_Minus1_r14 */
static int hf_lpp_nb4_r14 = -1;                   /* T_nb4_r14 */
static int hf_lpp_nb4_r14_item = -1;              /* INTEGER_0_maxAvailNarrowBands_Minus1_r14 */
static int hf_lpp_subframeAssignment_v1520 = -1;  /* T_subframeAssignment_v1520 */
static int hf_lpp_OTDOA_NeighbourCellInfoList_item = -1;  /* OTDOA_NeighbourFreqInfo */
static int hf_lpp_OTDOA_NeighbourFreqInfo_item = -1;  /* OTDOA_NeighbourCellInfoElement */
static int hf_lpp_earfcn = -1;                    /* ARFCN_ValueEUTRA */
static int hf_lpp_cpLength_01 = -1;               /* T_cpLength_01 */
static int hf_lpp_antennaPortConfig_01 = -1;      /* T_antennaPortConfig_01 */
static int hf_lpp_slotNumberOffset = -1;          /* INTEGER_0_19 */
static int hf_lpp_prs_SubframeOffset = -1;        /* INTEGER_0_1279 */
static int hf_lpp_expectedRSTD = -1;              /* INTEGER_0_16383 */
static int hf_lpp_expectedRSTD_Uncertainty = -1;  /* INTEGER_0_1023 */
static int hf_lpp_earfcn_v9a0 = -1;               /* ARFCN_ValueEUTRA_v9a0 */
static int hf_lpp_prs_only_tp_r14 = -1;           /* T_prs_only_tp_r14 */
static int hf_lpp_cpLengthCRS_r14_01 = -1;        /* T_cpLengthCRS_r14_01 */
static int hf_lpp_sameMBSFNconfigNeighbour_r14 = -1;  /* BOOLEAN */
static int hf_lpp_dlBandwidth_r14_01 = -1;        /* T_dlBandwidth_r14_01 */
static int hf_lpp_addPRSconfigNeighbour_r14 = -1;  /* SEQUENCE_SIZE_1_maxAddPRSconfig_r14_OF_Add_PRSconfigNeighbourElement_r14 */
static int hf_lpp_addPRSconfigNeighbour_r14_item = -1;  /* Add_PRSconfigNeighbourElement_r14 */
static int hf_lpp_add_prsInfo_r14 = -1;           /* PRS_Info */
static int hf_lpp_physCellIdNB_r14 = -1;          /* INTEGER_0_503 */
static int hf_lpp_cellGlobalIdNB_r14 = -1;        /* ECGI */
static int hf_lpp_carrierFreqRef_r14 = -1;        /* CarrierFreq_NB_r14 */
static int hf_lpp_earfcn_r14 = -1;                /* ARFCN_ValueEUTRA_r14 */
static int hf_lpp_eutra_NumCRS_Ports_r14 = -1;    /* T_eutra_NumCRS_Ports_r14 */
static int hf_lpp_otdoa_SIB1_NB_repetitions_r14 = -1;  /* T_otdoa_SIB1_NB_repetitions_r14 */
static int hf_lpp_nprsInfo_r14 = -1;              /* PRS_Info_NB_r14 */
static int hf_lpp_nprsInfo_Type2_v1470 = -1;      /* PRS_Info_NB_r14 */
static int hf_lpp_tdd_config_r15 = -1;            /* TDD_Config_v1520 */
static int hf_lpp_PRS_Info_NB_r14_item = -1;      /* NPRS_Info_r14 */
static int hf_lpp_operationModeInfoNPRS_r14 = -1;  /* T_operationModeInfoNPRS_r14 */
static int hf_lpp_nprs_carrier_r14 = -1;          /* CarrierFreq_NB_r14 */
static int hf_lpp_nprsSequenceInfo_r14 = -1;      /* INTEGER_0_174 */
static int hf_lpp_nprsID_r14 = -1;                /* INTEGER_0_4095 */
static int hf_lpp_partA_r14 = -1;                 /* T_partA_r14 */
static int hf_lpp_nprsBitmap_r14 = -1;            /* T_nprsBitmap_r14 */
static int hf_lpp_subframePattern10_r14 = -1;     /* BIT_STRING_SIZE_10 */
static int hf_lpp_subframePattern40_r14 = -1;     /* BIT_STRING_SIZE_40 */
static int hf_lpp_nprs_MutingInfoA_r14 = -1;      /* T_nprs_MutingInfoA_r14 */
static int hf_lpp_po2_r14 = -1;                   /* BIT_STRING_SIZE_2 */
static int hf_lpp_po4_r14 = -1;                   /* BIT_STRING_SIZE_4 */
static int hf_lpp_po8_r14 = -1;                   /* BIT_STRING_SIZE_8 */
static int hf_lpp_po16_r14 = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_lpp_partB_r14 = -1;                 /* T_partB_r14 */
static int hf_lpp_nprs_Period_r14 = -1;           /* T_nprs_Period_r14 */
static int hf_lpp_nprs_startSF_r14 = -1;          /* T_nprs_startSF_r14 */
static int hf_lpp_nprs_NumSF_r14 = -1;            /* T_nprs_NumSF_r14 */
static int hf_lpp_nprs_MutingInfoB_r14 = -1;      /* T_nprs_MutingInfoB_r14 */
static int hf_lpp_sib1_SF_TDD_r15 = -1;           /* T_sib1_SF_TDD_r15 */
static int hf_lpp_partA_TDD_r15 = -1;             /* T_partA_TDD_r15 */
static int hf_lpp_nprsBitmap_r15 = -1;            /* T_nprsBitmap_r15 */
static int hf_lpp_subframePattern10_TDD_r15 = -1;  /* BIT_STRING_SIZE_8 */
static int hf_lpp_subframePattern40_TDD_r15 = -1;  /* BIT_STRING_SIZE_32 */
static int hf_lpp_nprs_MutingInfoA_r15 = -1;      /* T_nprs_MutingInfoA_r15 */
static int hf_lpp_po2_r15 = -1;                   /* BIT_STRING_SIZE_2 */
static int hf_lpp_po4_r15 = -1;                   /* BIT_STRING_SIZE_4 */
static int hf_lpp_po8_r15 = -1;                   /* BIT_STRING_SIZE_8 */
static int hf_lpp_po16_r15 = -1;                  /* BIT_STRING_SIZE_16 */
static int hf_lpp_OTDOA_NeighbourCellInfoListNB_r14_item = -1;  /* OTDOA_NeighbourCellInfoNB_r14 */
static int hf_lpp_carrierFreq_r14_01 = -1;        /* CarrierFreq_NB_r14 */
static int hf_lpp_eutra_NumCRS_Ports_r14_01 = -1;  /* T_eutra_NumCRS_Ports_r14_01 */
static int hf_lpp_otdoa_SIB1_NB_repetitions_r14_01 = -1;  /* T_otdoa_SIB1_NB_repetitions_r14_01 */
static int hf_lpp_nprs_slotNumberOffset_r14 = -1;  /* INTEGER_0_19 */
static int hf_lpp_nprs_SFN_Offset_r14 = -1;       /* INTEGER_0_63 */
static int hf_lpp_nprs_SubframeOffset_r14 = -1;   /* INTEGER_0_1279 */
static int hf_lpp_expectedRSTD_r14 = -1;          /* INTEGER_0_16383 */
static int hf_lpp_expectedRSTD_Uncertainty_r14 = -1;  /* INTEGER_0_1023 */
static int hf_lpp_prsNeighbourCellIndex_r14 = -1;  /* INTEGER_1_72 */
static int hf_lpp_adType_r14 = -1;                /* T_adType_r14 */
static int hf_lpp_nrPhysCellId_r15 = -1;          /* INTEGER_0_1007 */
static int hf_lpp_otdoaSignalMeasurementInformation = -1;  /* OTDOA_SignalMeasurementInformation */
static int hf_lpp_otdoaSignalMeasurementInformation_NB_r14 = -1;  /* OTDOA_SignalMeasurementInformation_NB_r14 */
static int hf_lpp_systemFrameNumber = -1;         /* BIT_STRING_SIZE_10 */
static int hf_lpp_physCellIdRef = -1;             /* INTEGER_0_503 */
static int hf_lpp_cellGlobalIdRef = -1;           /* ECGI */
static int hf_lpp_referenceQuality = -1;          /* OTDOA_MeasQuality */
static int hf_lpp_neighbourMeasurementList = -1;  /* NeighbourMeasurementList */
static int hf_lpp_tpIdRef_r14 = -1;               /* INTEGER_0_4095 */
static int hf_lpp_prsIdRef_r14 = -1;              /* INTEGER_0_4095 */
static int hf_lpp_additionalPathsRef_r14 = -1;    /* AdditionalPathList_r14 */
static int hf_lpp_nprsIdRef_r14 = -1;             /* INTEGER_0_4095 */
static int hf_lpp_carrierFreqOffsetNB_Ref_r14 = -1;  /* CarrierFreqOffsetNB_r14 */
static int hf_lpp_hyperSFN_r14 = -1;              /* BIT_STRING_SIZE_10 */
static int hf_lpp_motionTimeSource_r15 = -1;      /* MotionTimeSource_r15 */
static int hf_lpp_NeighbourMeasurementList_item = -1;  /* NeighbourMeasurementElement */
static int hf_lpp_physCellIdNeighbour = -1;       /* INTEGER_0_503 */
static int hf_lpp_cellGlobalIdNeighbour = -1;     /* ECGI */
static int hf_lpp_earfcnNeighbour = -1;           /* ARFCN_ValueEUTRA */
static int hf_lpp_rstd = -1;                      /* INTEGER_0_12711 */
static int hf_lpp_rstd_Quality = -1;              /* OTDOA_MeasQuality */
static int hf_lpp_earfcnNeighbour_v9a0 = -1;      /* ARFCN_ValueEUTRA_v9a0 */
static int hf_lpp_tpIdNeighbour_r14 = -1;         /* INTEGER_0_4095 */
static int hf_lpp_prsIdNeighbour_r14 = -1;        /* INTEGER_0_4095 */
static int hf_lpp_delta_rstd_r14 = -1;            /* INTEGER_0_5 */
static int hf_lpp_additionalPathsNeighbour_r14 = -1;  /* AdditionalPathList_r14 */
static int hf_lpp_nprsIdNeighbour_r14 = -1;       /* INTEGER_0_4095 */
static int hf_lpp_carrierFreqOffsetNB_Neighbour_r14 = -1;  /* CarrierFreqOffsetNB_r14 */
static int hf_lpp_delta_SFN_r15 = -1;             /* INTEGER_M8192_8191 */
static int hf_lpp_AdditionalPathList_r14_item = -1;  /* AdditionalPath_r14 */
static int hf_lpp_timeSource_r15 = -1;            /* T_timeSource_r15 */
static int hf_lpp_systemFrameNumber_r14 = -1;     /* BIT_STRING_SIZE_10 */
static int hf_lpp_physCellIdRef_r14 = -1;         /* INTEGER_0_503 */
static int hf_lpp_cellGlobalIdRef_r14 = -1;       /* ECGI */
static int hf_lpp_earfcnRef_r14 = -1;             /* ARFCN_ValueEUTRA_r14 */
static int hf_lpp_referenceQuality_r14 = -1;      /* OTDOA_MeasQuality */
static int hf_lpp_neighbourMeasurementList_r14 = -1;  /* NeighbourMeasurementList_NB_r14 */
static int hf_lpp_NeighbourMeasurementList_NB_r14_item = -1;  /* NeighbourMeasurementElement_NB_r14 */
static int hf_lpp_physCellIdNeighbour_r14 = -1;   /* INTEGER_0_503 */
static int hf_lpp_cellGlobalIdNeighbour_r14 = -1;  /* ECGI */
static int hf_lpp_earfcnNeighbour_r14 = -1;       /* ARFCN_ValueEUTRA_r14 */
static int hf_lpp_rstd_r14 = -1;                  /* INTEGER_0_12711 */
static int hf_lpp_rstd_Quality_r14 = -1;          /* OTDOA_MeasQuality */
static int hf_lpp_error_Resolution = -1;          /* T_error_Resolution */
static int hf_lpp_error_Value = -1;               /* T_error_Value */
static int hf_lpp_error_NumSamples = -1;          /* T_error_NumSamples */
static int hf_lpp_relativeTimeDifference_r14 = -1;  /* INTEGER_M256_255 */
static int hf_lpp_path_Quality_r14 = -1;          /* OTDOA_MeasQuality */
static int hf_lpp_assistanceAvailability = -1;    /* BOOLEAN */
static int hf_lpp_multipathRSTD_r14 = -1;         /* T_multipathRSTD_r14 */
static int hf_lpp_maxNoOfRSTDmeas_r14 = -1;       /* INTEGER_1_32 */
static int hf_lpp_motionMeasurements_r15 = -1;    /* T_motionMeasurements_r15 */
static int hf_lpp_otdoa_Mode = -1;                /* T_otdoa_Mode */
static int hf_lpp_supportedBandListEUTRA = -1;    /* SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA */
static int hf_lpp_supportedBandListEUTRA_item = -1;  /* SupportedBandEUTRA */
static int hf_lpp_supportedBandListEUTRA_v9a0 = -1;  /* SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0 */
static int hf_lpp_supportedBandListEUTRA_v9a0_item = -1;  /* SupportedBandEUTRA_v9a0 */
static int hf_lpp_interFreqRSTDmeasurement_r10 = -1;  /* T_interFreqRSTDmeasurement_r10 */
static int hf_lpp_additionalNeighbourCellInfoList_r10 = -1;  /* T_additionalNeighbourCellInfoList_r10 */
static int hf_lpp_prs_id_r14 = -1;                /* T_prs_id_r14 */
static int hf_lpp_tp_separation_via_muting_r14 = -1;  /* T_tp_separation_via_muting_r14 */
static int hf_lpp_additional_prs_config_r14 = -1;  /* T_additional_prs_config_r14 */
static int hf_lpp_prs_based_tbs_r14 = -1;         /* T_prs_based_tbs_r14 */
static int hf_lpp_additionalPathsReport_r14 = -1;  /* T_additionalPathsReport_r14 */
static int hf_lpp_densePrsConfig_r14 = -1;        /* T_densePrsConfig_r14 */
static int hf_lpp_maxSupportedPrsBandwidth_r14 = -1;  /* T_maxSupportedPrsBandwidth_r14 */
static int hf_lpp_prsOccGroup_r14 = -1;           /* T_prsOccGroup_r14 */
static int hf_lpp_prsFrequencyHopping_r14 = -1;   /* T_prsFrequencyHopping_r14 */
static int hf_lpp_maxSupportedPrsConfigs_r14 = -1;  /* T_maxSupportedPrsConfigs_r14 */
static int hf_lpp_periodicalReporting_r14 = -1;   /* T_periodicalReporting_r14 */
static int hf_lpp_multiPrbNprs_r14 = -1;          /* T_multiPrbNprs_r14 */
static int hf_lpp_idleStateForMeasurements_r14 = -1;  /* T_idleStateForMeasurements_r14 */
static int hf_lpp_numberOfRXantennas_r14 = -1;    /* T_numberOfRXantennas_r14 */
static int hf_lpp_motionMeasurements_r15_01 = -1;  /* T_motionMeasurements_r15_01 */
static int hf_lpp_interRAT_RSTDmeasurement_r15 = -1;  /* T_interRAT_RSTDmeasurement_r15 */
static int hf_lpp_scheduledLocationRequestSupported_r17 = -1;  /* ScheduledLocationTimeSupport_r17 */
static int hf_lpp_bandEUTRA = -1;                 /* INTEGER_1_maxFBI */
static int hf_lpp_bandEUTRA_v9a0 = -1;            /* INTEGER_maxFBI_Plus1_maxFBI2 */
static int hf_lpp_locationServerErrorCauses = -1;  /* OTDOA_LocationServerErrorCauses */
static int hf_lpp_targetDeviceErrorCauses = -1;   /* OTDOA_TargetDeviceErrorCauses */
static int hf_lpp_cause = -1;                     /* T_cause */
static int hf_lpp_cause_01 = -1;                  /* T_cause_01 */
static int hf_lpp_gnss_CommonAssistData = -1;     /* GNSS_CommonAssistData */
static int hf_lpp_gnss_GenericAssistData = -1;    /* GNSS_GenericAssistData */
static int hf_lpp_gnss_Error = -1;                /* A_GNSS_Error */
static int hf_lpp_gnss_PeriodicAssistData_r15 = -1;  /* GNSS_PeriodicAssistData_r15 */
static int hf_lpp_gnss_ReferenceTime = -1;        /* GNSS_ReferenceTime */
static int hf_lpp_gnss_ReferenceLocation = -1;    /* GNSS_ReferenceLocation */
static int hf_lpp_gnss_IonosphericModel = -1;     /* GNSS_IonosphericModel */
static int hf_lpp_gnss_EarthOrientationParameters = -1;  /* GNSS_EarthOrientationParameters */
static int hf_lpp_gnss_RTK_ReferenceStationInfo_r15 = -1;  /* GNSS_RTK_ReferenceStationInfo_r15 */
static int hf_lpp_gnss_RTK_CommonObservationInfo_r15 = -1;  /* GNSS_RTK_CommonObservationInfo_r15 */
static int hf_lpp_gnss_RTK_AuxiliaryStationData_r15 = -1;  /* GNSS_RTK_AuxiliaryStationData_r15 */
static int hf_lpp_gnss_SSR_CorrectionPoints_r16 = -1;  /* GNSS_SSR_CorrectionPoints_r16 */
static int hf_lpp_gnss_Integrity_ServiceParameters_r17 = -1;  /* GNSS_Integrity_ServiceParameters_r17 */
static int hf_lpp_gnss_Integrity_ServiceAlert_r17 = -1;  /* GNSS_Integrity_ServiceAlert_r17 */
static int hf_lpp_GNSS_GenericAssistData_item = -1;  /* GNSS_GenericAssistDataElement */
static int hf_lpp_gnss_ID = -1;                   /* GNSS_ID */
static int hf_lpp_sbas_ID = -1;                   /* SBAS_ID */
static int hf_lpp_gnss_TimeModels = -1;           /* GNSS_TimeModelList */
static int hf_lpp_gnss_DifferentialCorrections = -1;  /* GNSS_DifferentialCorrections */
static int hf_lpp_gnss_NavigationModel = -1;      /* GNSS_NavigationModel */
static int hf_lpp_gnss_RealTimeIntegrity = -1;    /* GNSS_RealTimeIntegrity */
static int hf_lpp_gnss_DataBitAssistance = -1;    /* GNSS_DataBitAssistance */
static int hf_lpp_gnss_AcquisitionAssistance = -1;  /* GNSS_AcquisitionAssistance */
static int hf_lpp_gnss_Almanac = -1;              /* GNSS_Almanac */
static int hf_lpp_gnss_UTC_Model = -1;            /* GNSS_UTC_Model */
static int hf_lpp_gnss_AuxiliaryInformation = -1;  /* GNSS_AuxiliaryInformation */
static int hf_lpp_bds_DifferentialCorrections_r12 = -1;  /* BDS_DifferentialCorrections_r12 */
static int hf_lpp_bds_GridModel_r12 = -1;         /* BDS_GridModelParameter_r12 */
static int hf_lpp_gnss_RTK_Observations_r15 = -1;  /* GNSS_RTK_Observations_r15 */
static int hf_lpp_glo_RTK_BiasInformation_r15 = -1;  /* GLO_RTK_BiasInformation_r15 */
static int hf_lpp_gnss_RTK_MAC_CorrectionDifferences_r15 = -1;  /* GNSS_RTK_MAC_CorrectionDifferences_r15 */
static int hf_lpp_gnss_RTK_Residuals_r15 = -1;    /* GNSS_RTK_Residuals_r15 */
static int hf_lpp_gnss_RTK_FKP_Gradients_r15 = -1;  /* GNSS_RTK_FKP_Gradients_r15 */
static int hf_lpp_gnss_SSR_OrbitCorrections_r15 = -1;  /* GNSS_SSR_OrbitCorrections_r15 */
static int hf_lpp_gnss_SSR_ClockCorrections_r15 = -1;  /* GNSS_SSR_ClockCorrections_r15 */
static int hf_lpp_gnss_SSR_CodeBias_r15 = -1;     /* GNSS_SSR_CodeBias_r15 */
static int hf_lpp_gnss_SSR_URA_r16 = -1;          /* GNSS_SSR_URA_r16 */
static int hf_lpp_gnss_SSR_PhaseBias_r16 = -1;    /* GNSS_SSR_PhaseBias_r16 */
static int hf_lpp_gnss_SSR_STEC_Correction_r16 = -1;  /* GNSS_SSR_STEC_Correction_r16 */
static int hf_lpp_gnss_SSR_GriddedCorrection_r16 = -1;  /* GNSS_SSR_GriddedCorrection_r16 */
static int hf_lpp_navic_DifferentialCorrections_r16 = -1;  /* NavIC_DifferentialCorrections_r16 */
static int hf_lpp_navic_GridModel_r16 = -1;       /* NavIC_GridModelParameter_r16 */
static int hf_lpp_gnss_RTK_PeriodicObservations_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_glo_RTK_PeriodicBiasInformation_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_RTK_MAC_PeriodicCorrectionDifferences_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_RTK_PeriodicResiduals_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_RTK_FKP_PeriodicGradients_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicOrbitCorrections_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicClockCorrections_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicCodeBias_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicURA_r16 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicPhaseBias_r16 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicSTEC_Correction_r16 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicGriddedCorrection_r16 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_Integrity_PeriodicServiceAlert_r17 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SystemTime = -1;           /* GNSS_SystemTime */
static int hf_lpp_referenceTimeUnc = -1;          /* INTEGER_0_127 */
static int hf_lpp_gnss_ReferenceTimeForCells = -1;  /* SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell */
static int hf_lpp_gnss_ReferenceTimeForCells_item = -1;  /* GNSS_ReferenceTimeForOneCell */
static int hf_lpp_networkTime = -1;               /* NetworkTime */
static int hf_lpp_bsAlign = -1;                   /* T_bsAlign */
static int hf_lpp_gnss_TimeID = -1;               /* GNSS_ID */
static int hf_lpp_gnss_DayNumber = -1;            /* INTEGER_0_32767 */
static int hf_lpp_gnss_TimeOfDay = -1;            /* INTEGER_0_86399 */
static int hf_lpp_gnss_TimeOfDayFrac_msec = -1;   /* INTEGER_0_999 */
static int hf_lpp_notificationOfLeapSecond = -1;  /* T_notificationOfLeapSecond */
static int hf_lpp_gps_TOW_Assist = -1;            /* GPS_TOW_Assist */
static int hf_lpp_GPS_TOW_Assist_item = -1;       /* GPS_TOW_AssistElement */
static int hf_lpp_satelliteID = -1;               /* INTEGER_1_64 */
static int hf_lpp_tlmWord = -1;                   /* INTEGER_0_16383 */
static int hf_lpp_antiSpoof = -1;                 /* INTEGER_0_1 */
static int hf_lpp_alert = -1;                     /* INTEGER_0_1 */
static int hf_lpp_tlmRsvdBits = -1;               /* INTEGER_0_3 */
static int hf_lpp_secondsFromFrameStructureStart = -1;  /* INTEGER_0_12533 */
static int hf_lpp_fractionalSecondsFromFrameStructureStart = -1;  /* INTEGER_0_3999999 */
static int hf_lpp_frameDrift = -1;                /* INTEGER_M64_63 */
static int hf_lpp_cellID = -1;                    /* T_cellID */
static int hf_lpp_eUTRA = -1;                     /* T_eUTRA */
static int hf_lpp_cellGlobalIdEUTRA = -1;         /* CellGlobalIdEUTRA_AndUTRA */
static int hf_lpp_uTRA = -1;                      /* T_uTRA */
static int hf_lpp_mode = -1;                      /* T_mode */
static int hf_lpp_fdd = -1;                       /* T_fdd */
static int hf_lpp_primary_CPICH_Info = -1;        /* INTEGER_0_511 */
static int hf_lpp_tdd = -1;                       /* T_tdd */
static int hf_lpp_cellParameters = -1;            /* INTEGER_0_127 */
static int hf_lpp_cellGlobalIdUTRA = -1;          /* CellGlobalIdEUTRA_AndUTRA */
static int hf_lpp_uarfcn = -1;                    /* ARFCN_ValueUTRA */
static int hf_lpp_gSM = -1;                       /* T_gSM */
static int hf_lpp_bcchCarrier = -1;               /* INTEGER_0_1023 */
static int hf_lpp_bsic = -1;                      /* INTEGER_0_63 */
static int hf_lpp_cellGlobalIdGERAN = -1;         /* CellGlobalIdGERAN */
static int hf_lpp_nBIoT_r14 = -1;                 /* T_nBIoT_r14 */
static int hf_lpp_nbPhysCellId_r14 = -1;          /* INTEGER_0_503 */
static int hf_lpp_nbCellGlobalId_r14 = -1;        /* ECGI */
static int hf_lpp_nbCarrierFreq_r14 = -1;         /* CarrierFreq_NB_r14 */
static int hf_lpp_nr_r15 = -1;                    /* T_nr_r15 */
static int hf_lpp_nrCellGlobalID_r15 = -1;        /* NCGI_r15 */
static int hf_lpp_nrARFCN_r15 = -1;               /* ARFCN_ValueNR_r15 */
static int hf_lpp_threeDlocation = -1;            /* EllipsoidPointWithAltitudeAndUncertaintyEllipsoid */
static int hf_lpp_klobucharModel = -1;            /* KlobucharModelParameter */
static int hf_lpp_neQuickModel = -1;              /* NeQuickModelParameter */
static int hf_lpp_klobucharModel2_r16 = -1;       /* KlobucharModel2Parameter_r16 */
static int hf_lpp_dataID = -1;                    /* T_dataID */
static int hf_lpp_alfa0 = -1;                     /* INTEGER_M128_127 */
static int hf_lpp_alfa1 = -1;                     /* INTEGER_M128_127 */
static int hf_lpp_alfa2 = -1;                     /* INTEGER_M128_127 */
static int hf_lpp_alfa3 = -1;                     /* INTEGER_M128_127 */
static int hf_lpp_beta0 = -1;                     /* INTEGER_M128_127 */
static int hf_lpp_beta1 = -1;                     /* INTEGER_M128_127 */
static int hf_lpp_beta2 = -1;                     /* INTEGER_M128_127 */
static int hf_lpp_beta3 = -1;                     /* INTEGER_M128_127 */
static int hf_lpp_alfa1_r16 = -1;                 /* INTEGER_0_1023 */
static int hf_lpp_alfa2_r16 = -1;                 /* INTEGER_M128_127 */
static int hf_lpp_alfa3_r16 = -1;                 /* INTEGER_0_255 */
static int hf_lpp_alfa4_r16 = -1;                 /* INTEGER_0_255 */
static int hf_lpp_alfa5_r16 = -1;                 /* INTEGER_0_255 */
static int hf_lpp_alfa6_r16 = -1;                 /* INTEGER_M128_127 */
static int hf_lpp_alfa7_r16 = -1;                 /* INTEGER_M128_127 */
static int hf_lpp_alfa8_r16 = -1;                 /* INTEGER_M128_127 */
static int hf_lpp_alfa9_r16 = -1;                 /* INTEGER_M128_127 */
static int hf_lpp_ai0 = -1;                       /* INTEGER_0_2047 */
static int hf_lpp_ai1 = -1;                       /* INTEGER_M1024_1023 */
static int hf_lpp_ai2 = -1;                       /* INTEGER_M8192_8191 */
static int hf_lpp_ionoStormFlag1 = -1;            /* INTEGER_0_1 */
static int hf_lpp_ionoStormFlag2 = -1;            /* INTEGER_0_1 */
static int hf_lpp_ionoStormFlag3 = -1;            /* INTEGER_0_1 */
static int hf_lpp_ionoStormFlag4 = -1;            /* INTEGER_0_1 */
static int hf_lpp_ionoStormFlag5 = -1;            /* INTEGER_0_1 */
static int hf_lpp_teop = -1;                      /* INTEGER_0_65535 */
static int hf_lpp_pmX = -1;                       /* INTEGER_M1048576_1048575 */
static int hf_lpp_pmXdot = -1;                    /* INTEGER_M16384_16383 */
static int hf_lpp_pmY = -1;                       /* INTEGER_M1048576_1048575 */
static int hf_lpp_pmYdot = -1;                    /* INTEGER_M16384_16383 */
static int hf_lpp_deltaUT1 = -1;                  /* INTEGER_M1073741824_1073741823 */
static int hf_lpp_deltaUT1dot = -1;               /* INTEGER_M262144_262143 */
static int hf_lpp_referenceStationID_r15 = -1;    /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_referenceStationIndicator_r15 = -1;  /* T_referenceStationIndicator_r15 */
static int hf_lpp_antenna_reference_point_ECEF_X_r15 = -1;  /* INTEGER_M137438953472_137438953471 */
static int hf_lpp_antenna_reference_point_ECEF_Y_r15 = -1;  /* INTEGER_M137438953472_137438953471 */
static int hf_lpp_antenna_reference_point_ECEF_Z_r15 = -1;  /* INTEGER_M137438953472_137438953471 */
static int hf_lpp_antennaHeight_r15 = -1;         /* INTEGER_0_65535 */
static int hf_lpp_antennaDescription_r15 = -1;    /* AntennaDescription_r15 */
static int hf_lpp_antenna_reference_point_unc_r15 = -1;  /* AntennaReferencePointUnc_r15 */
static int hf_lpp_physical_reference_station_info_r15 = -1;  /* PhysicalReferenceStationInfo_r15 */
static int hf_lpp_equalIntegerAmbiguityLevel_r16 = -1;  /* EqualIntegerAmbiguityLevel_r16 */
static int hf_lpp_antennaDescriptor_r15 = -1;     /* VisibleString_SIZE_1_256 */
static int hf_lpp_antennaSetUpID_r15 = -1;        /* T_antennaSetUpID_r15 */
static int hf_lpp_uncertainty_X_r15 = -1;         /* INTEGER_0_255 */
static int hf_lpp_confidence_X_r15 = -1;          /* INTEGER_0_100 */
static int hf_lpp_uncertainty_Y_r15 = -1;         /* INTEGER_0_255 */
static int hf_lpp_confidence_Y_r15 = -1;          /* INTEGER_0_100 */
static int hf_lpp_uncertainty_Z_r15 = -1;         /* INTEGER_0_255 */
static int hf_lpp_confidence_Z_r15 = -1;          /* INTEGER_0_100 */
static int hf_lpp_physicalReferenceStationID_r15 = -1;  /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_physical_ARP_ECEF_X_r15 = -1;   /* INTEGER_M137438953472_137438953471 */
static int hf_lpp_physical_ARP_ECEF_Y_r15 = -1;   /* INTEGER_M137438953472_137438953471 */
static int hf_lpp_physical_ARP_ECEF_Z_r15 = -1;   /* INTEGER_M137438953472_137438953471 */
static int hf_lpp_physical_ARP_unc_r15 = -1;      /* AntennaReferencePointUnc_r15 */
static int hf_lpp_allReferenceStations_r16 = -1;  /* NULL */
static int hf_lpp_referenceStationList_r16 = -1;  /* ReferenceStationList_r16 */
static int hf_lpp_ReferenceStationList_r16_item = -1;  /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_clockSteeringIndicator_r15 = -1;  /* INTEGER_0_3 */
static int hf_lpp_externalClockIndicator_r15 = -1;  /* INTEGER_0_3 */
static int hf_lpp_smoothingIndicator_r15 = -1;    /* T_smoothingIndicator_r15 */
static int hf_lpp_smoothingInterval_r15 = -1;     /* T_smoothingInterval_r15 */
static int hf_lpp_networkID_r15 = -1;             /* GNSS_NetworkID_r15 */
static int hf_lpp_subNetworkID_r15 = -1;          /* GNSS_SubNetworkID_r15 */
static int hf_lpp_master_referenceStationID_r15 = -1;  /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_auxiliaryStationList_r15 = -1;  /* AuxiliaryStationList_r15 */
static int hf_lpp_AuxiliaryStationList_r15_item = -1;  /* AuxiliaryStationElement_r15 */
static int hf_lpp_aux_referenceStationID_r15 = -1;  /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_aux_master_delta_latitude_r15 = -1;  /* INTEGER_M524288_524287 */
static int hf_lpp_aux_master_delta_longitude_r15 = -1;  /* INTEGER_M1048576_1048575 */
static int hf_lpp_aux_master_delta_height_r15 = -1;  /* INTEGER_M4194304_4194303 */
static int hf_lpp_aux_ARP_unc_r15 = -1;           /* Aux_ARP_Unc_r15 */
static int hf_lpp_horizontalUncertainty_r15 = -1;  /* INTEGER_0_255 */
static int hf_lpp_verticalUncertainty_r15 = -1;   /* INTEGER_0_255 */
static int hf_lpp_correctionPointSetID_r16 = -1;  /* INTEGER_0_16383 */
static int hf_lpp_correctionPoints_r16 = -1;      /* T_correctionPoints_r16 */
static int hf_lpp_listOfCorrectionPoints_r16 = -1;  /* GNSS_SSR_ListOfCorrectionPoints_r16 */
static int hf_lpp_arrayOfCorrectionPoints_r16 = -1;  /* GNSS_SSR_ArrayOfCorrectionPoints_r16 */
static int hf_lpp_referencePointLatitude_r16 = -1;  /* INTEGER_M16384_16383 */
static int hf_lpp_referencePointLongitude_r16 = -1;  /* INTEGER_M32768_32767 */
static int hf_lpp_relativeLocationsList_r16 = -1;  /* SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16 */
static int hf_lpp_relativeLocationsList_r16_item = -1;  /* RelativeLocationElement_r16 */
static int hf_lpp_deltaLatitude_r16 = -1;         /* INTEGER_M512_511 */
static int hf_lpp_deltaLongitude_r16 = -1;        /* INTEGER_M1024_1023 */
static int hf_lpp_numberOfStepsLatitude_r16 = -1;  /* INTEGER_0_63 */
static int hf_lpp_numberOfStepsLongitude_r16 = -1;  /* INTEGER_0_63 */
static int hf_lpp_stepOfLatitude_r16 = -1;        /* INTEGER_1_511 */
static int hf_lpp_stepOfLongitude_r16 = -1;       /* INTEGER_1_1023 */
static int hf_lpp_bitmaskOfGrids_r16 = -1;        /* BIT_STRING_SIZE_64 */
static int hf_lpp_irMinimum_r17 = -1;             /* INTEGER_0_255 */
static int hf_lpp_irMaximum_r17 = -1;             /* INTEGER_0_255 */
static int hf_lpp_ionosphereDoNotUse_r17 = -1;    /* BOOLEAN */
static int hf_lpp_troposphereDoNotUse_r17 = -1;   /* BOOLEAN */
static int hf_lpp_GNSS_TimeModelList_item = -1;   /* GNSS_TimeModelElement */
static int hf_lpp_gnss_TimeModelRefTime = -1;     /* INTEGER_0_65535 */
static int hf_lpp_tA0 = -1;                       /* INTEGER_M67108864_67108863 */
static int hf_lpp_tA1 = -1;                       /* INTEGER_M4096_4095 */
static int hf_lpp_tA2 = -1;                       /* INTEGER_M64_63 */
static int hf_lpp_gnss_TO_ID = -1;                /* INTEGER_1_15 */
static int hf_lpp_weekNumber = -1;                /* INTEGER_0_8191 */
static int hf_lpp_deltaT = -1;                    /* INTEGER_M128_127 */
static int hf_lpp_dgnss_RefTime = -1;             /* INTEGER_0_3599 */
static int hf_lpp_dgnss_SgnTypeList = -1;         /* DGNSS_SgnTypeList */
static int hf_lpp_DGNSS_SgnTypeList_item = -1;    /* DGNSS_SgnTypeElement */
static int hf_lpp_gnss_SignalID = -1;             /* GNSS_SignalID */
static int hf_lpp_gnss_StatusHealth = -1;         /* INTEGER_0_7 */
static int hf_lpp_dgnss_SatList = -1;             /* DGNSS_SatList */
static int hf_lpp_DGNSS_SatList_item = -1;        /* DGNSS_CorrectionsElement */
static int hf_lpp_svID = -1;                      /* SV_ID */
static int hf_lpp_iod = -1;                       /* BIT_STRING_SIZE_11 */
static int hf_lpp_udre = -1;                      /* INTEGER_0_3 */
static int hf_lpp_pseudoRangeCor = -1;            /* INTEGER_M2047_2047 */
static int hf_lpp_rangeRateCor = -1;              /* INTEGER_M127_127 */
static int hf_lpp_udreGrowthRate = -1;            /* INTEGER_0_7 */
static int hf_lpp_udreValidityTime = -1;          /* INTEGER_0_7 */
static int hf_lpp_nonBroadcastIndFlag = -1;       /* INTEGER_0_1 */
static int hf_lpp_gnss_SatelliteList = -1;        /* GNSS_NavModelSatelliteList */
static int hf_lpp_GNSS_NavModelSatelliteList_item = -1;  /* GNSS_NavModelSatelliteElement */
static int hf_lpp_svHealth = -1;                  /* BIT_STRING_SIZE_8 */
static int hf_lpp_gnss_ClockModel = -1;           /* GNSS_ClockModel */
static int hf_lpp_gnss_OrbitModel = -1;           /* GNSS_OrbitModel */
static int hf_lpp_svHealthExt_v1240 = -1;         /* T_svHealthExt_v1240 */
static int hf_lpp_standardClockModelList = -1;    /* StandardClockModelList */
static int hf_lpp_nav_ClockModel = -1;            /* NAV_ClockModel */
static int hf_lpp_cnav_ClockModel = -1;           /* CNAV_ClockModel */
static int hf_lpp_glonass_ClockModel = -1;        /* GLONASS_ClockModel */
static int hf_lpp_sbas_ClockModel = -1;           /* SBAS_ClockModel */
static int hf_lpp_bds_ClockModel_r12 = -1;        /* BDS_ClockModel_r12 */
static int hf_lpp_bds_ClockModel2_r16 = -1;       /* BDS_ClockModel2_r16 */
static int hf_lpp_navic_ClockModel_r16 = -1;      /* NavIC_ClockModel_r16 */
static int hf_lpp_keplerianSet = -1;              /* NavModelKeplerianSet */
static int hf_lpp_nav_KeplerianSet = -1;          /* NavModelNAV_KeplerianSet */
static int hf_lpp_cnav_KeplerianSet = -1;         /* NavModelCNAV_KeplerianSet */
static int hf_lpp_glonass_ECEF = -1;              /* NavModel_GLONASS_ECEF */
static int hf_lpp_sbas_ECEF = -1;                 /* NavModel_SBAS_ECEF */
static int hf_lpp_bds_KeplerianSet_r12 = -1;      /* NavModel_BDS_KeplerianSet_r12 */
static int hf_lpp_bds_KeplerianSet2_r16 = -1;     /* NavModel_BDS_KeplerianSet2_r16 */
static int hf_lpp_navic_KeplerianSet_r16 = -1;    /* NavModel_NavIC_KeplerianSet_r16 */
static int hf_lpp_StandardClockModelList_item = -1;  /* StandardClockModelElement */
static int hf_lpp_stanClockToc = -1;              /* INTEGER_0_16383 */
static int hf_lpp_stanClockAF2 = -1;              /* INTEGER_M32_31 */
static int hf_lpp_stanClockAF1 = -1;              /* INTEGER_M1048576_1048575 */
static int hf_lpp_stanClockAF0 = -1;              /* INTEGER_M1073741824_1073741823 */
static int hf_lpp_stanClockTgd = -1;              /* INTEGER_M512_511 */
static int hf_lpp_sisa = -1;                      /* INTEGER_0_255 */
static int hf_lpp_stanModelID = -1;               /* INTEGER_0_1 */
static int hf_lpp_navToc = -1;                    /* INTEGER_0_37799 */
static int hf_lpp_navaf2 = -1;                    /* INTEGER_M128_127 */
static int hf_lpp_navaf1 = -1;                    /* INTEGER_M32768_32767 */
static int hf_lpp_navaf0 = -1;                    /* INTEGER_M2097152_2097151 */
static int hf_lpp_navTgd = -1;                    /* INTEGER_M128_127 */
static int hf_lpp_cnavToc = -1;                   /* INTEGER_0_2015 */
static int hf_lpp_cnavTop = -1;                   /* INTEGER_0_2015 */
static int hf_lpp_cnavURA0 = -1;                  /* INTEGER_M16_15 */
static int hf_lpp_cnavURA1 = -1;                  /* INTEGER_0_7 */
static int hf_lpp_cnavURA2 = -1;                  /* INTEGER_0_7 */
static int hf_lpp_cnavAf2 = -1;                   /* INTEGER_M512_511 */
static int hf_lpp_cnavAf1 = -1;                   /* INTEGER_M524288_524287 */
static int hf_lpp_cnavAf0 = -1;                   /* INTEGER_M33554432_33554431 */
static int hf_lpp_cnavTgd = -1;                   /* INTEGER_M4096_4095 */
static int hf_lpp_cnavISCl1cp = -1;               /* INTEGER_M4096_4095 */
static int hf_lpp_cnavISCl1cd = -1;               /* INTEGER_M4096_4095 */
static int hf_lpp_cnavISCl1ca = -1;               /* INTEGER_M4096_4095 */
static int hf_lpp_cnavISCl2c = -1;                /* INTEGER_M4096_4095 */
static int hf_lpp_cnavISCl5i5 = -1;               /* INTEGER_M4096_4095 */
static int hf_lpp_cnavISCl5q5 = -1;               /* INTEGER_M4096_4095 */
static int hf_lpp_gloTau = -1;                    /* INTEGER_M2097152_2097151 */
static int hf_lpp_gloGamma = -1;                  /* INTEGER_M1024_1023 */
static int hf_lpp_gloDeltaTau = -1;               /* INTEGER_M16_15 */
static int hf_lpp_sbasTo = -1;                    /* INTEGER_0_5399 */
static int hf_lpp_sbasAgfo = -1;                  /* INTEGER_M2048_2047 */
static int hf_lpp_sbasAgf1 = -1;                  /* INTEGER_M128_127 */
static int hf_lpp_bdsAODC_r12 = -1;               /* INTEGER_0_31 */
static int hf_lpp_bdsToc_r12 = -1;                /* INTEGER_0_131071 */
static int hf_lpp_bdsA0_r12 = -1;                 /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsA1_r12 = -1;                 /* INTEGER_M2097152_2097151 */
static int hf_lpp_bdsA2_r12 = -1;                 /* INTEGER_M1024_1023 */
static int hf_lpp_bdsTgd1_r12 = -1;               /* INTEGER_M512_511 */
static int hf_lpp_bdsTgd2_r16 = -1;               /* INTEGER_M512_511 */
static int hf_lpp_bdsToc_r16 = -1;                /* INTEGER_0_2047 */
static int hf_lpp_bdsA0_r16 = -1;                 /* INTEGER_M16777216_16777215 */
static int hf_lpp_bdsA1_r16 = -1;                 /* INTEGER_M2097152_2097151 */
static int hf_lpp_bdsA2_r16 = -1;                 /* INTEGER_M1024_1023 */
static int hf_lpp_bdsTgdB1Cp_r16 = -1;            /* INTEGER_M2048_2047 */
static int hf_lpp_bdsIscB1Cd_r16 = -1;            /* INTEGER_M2048_2047 */
static int hf_lpp_bdsTgdB2ap_r17 = -1;            /* INTEGER_M2048_2047 */
static int hf_lpp_bdsIscB2ad_r17 = -1;            /* INTEGER_M2048_2047 */
static int hf_lpp_navic_Toc_r16 = -1;             /* INTEGER_0_65535 */
static int hf_lpp_navic_af2_r16 = -1;             /* INTEGER_M128_127 */
static int hf_lpp_navic_af1_r16 = -1;             /* INTEGER_M32768_32767 */
static int hf_lpp_navic_af0_r16 = -1;             /* INTEGER_M2097152_2097151 */
static int hf_lpp_navic_Tgd_r16 = -1;             /* INTEGER_M128_127 */
static int hf_lpp_keplerToe = -1;                 /* INTEGER_0_16383 */
static int hf_lpp_keplerW = -1;                   /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_keplerDeltaN = -1;              /* INTEGER_M32768_32767 */
static int hf_lpp_keplerM0 = -1;                  /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_keplerOmegaDot = -1;            /* INTEGER_M8388608_8388607 */
static int hf_lpp_keplerE = -1;                   /* INTEGER_0_4294967295 */
static int hf_lpp_keplerIDot = -1;                /* INTEGER_M8192_8191 */
static int hf_lpp_keplerAPowerHalf = -1;          /* INTEGER_0_4294967295 */
static int hf_lpp_keplerI0 = -1;                  /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_keplerOmega0 = -1;              /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_keplerCrs = -1;                 /* INTEGER_M32768_32767 */
static int hf_lpp_keplerCis = -1;                 /* INTEGER_M32768_32767 */
static int hf_lpp_keplerCus = -1;                 /* INTEGER_M32768_32767 */
static int hf_lpp_keplerCrc = -1;                 /* INTEGER_M32768_32767 */
static int hf_lpp_keplerCic = -1;                 /* INTEGER_M32768_32767 */
static int hf_lpp_keplerCuc = -1;                 /* INTEGER_M32768_32767 */
static int hf_lpp_navURA = -1;                    /* INTEGER_0_15 */
static int hf_lpp_navFitFlag = -1;                /* INTEGER_0_1 */
static int hf_lpp_navToe = -1;                    /* INTEGER_0_37799 */
static int hf_lpp_navOmega = -1;                  /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navDeltaN = -1;                 /* INTEGER_M32768_32767 */
static int hf_lpp_navM0 = -1;                     /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navOmegaADot = -1;              /* INTEGER_M8388608_8388607 */
static int hf_lpp_navE = -1;                      /* INTEGER_0_4294967295 */
static int hf_lpp_navIDot = -1;                   /* INTEGER_M8192_8191 */
static int hf_lpp_navAPowerHalf = -1;             /* INTEGER_0_4294967295 */
static int hf_lpp_navI0 = -1;                     /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navOmegaA0 = -1;                /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navCrs = -1;                    /* INTEGER_M32768_32767 */
static int hf_lpp_navCis = -1;                    /* INTEGER_M32768_32767 */
static int hf_lpp_navCus = -1;                    /* INTEGER_M32768_32767 */
static int hf_lpp_navCrc = -1;                    /* INTEGER_M32768_32767 */
static int hf_lpp_navCic = -1;                    /* INTEGER_M32768_32767 */
static int hf_lpp_navCuc = -1;                    /* INTEGER_M32768_32767 */
static int hf_lpp_addNAVparam = -1;               /* T_addNAVparam */
static int hf_lpp_ephemCodeOnL2 = -1;             /* INTEGER_0_3 */
static int hf_lpp_ephemL2Pflag = -1;              /* INTEGER_0_1 */
static int hf_lpp_ephemSF1Rsvd = -1;              /* T_ephemSF1Rsvd */
static int hf_lpp_reserved1 = -1;                 /* INTEGER_0_8388607 */
static int hf_lpp_reserved2 = -1;                 /* INTEGER_0_16777215 */
static int hf_lpp_reserved3 = -1;                 /* INTEGER_0_16777215 */
static int hf_lpp_reserved4 = -1;                 /* INTEGER_0_65535 */
static int hf_lpp_ephemAODA = -1;                 /* INTEGER_0_31 */
static int hf_lpp_cnavURAindex = -1;              /* INTEGER_M16_15 */
static int hf_lpp_cnavDeltaA = -1;                /* INTEGER_M33554432_33554431 */
static int hf_lpp_cnavAdot = -1;                  /* INTEGER_M16777216_16777215 */
static int hf_lpp_cnavDeltaNo = -1;               /* INTEGER_M65536_65535 */
static int hf_lpp_cnavDeltaNoDot = -1;            /* INTEGER_M4194304_4194303 */
static int hf_lpp_cnavMo = -1;                    /* T_cnavMo */
static int hf_lpp_cnavE = -1;                     /* T_cnavE */
static int hf_lpp_cnavOmega = -1;                 /* T_cnavOmega */
static int hf_lpp_cnavOMEGA0 = -1;                /* T_cnavOMEGA0 */
static int hf_lpp_cnavDeltaOmegaDot = -1;         /* INTEGER_M65536_65535 */
static int hf_lpp_cnavIo = -1;                    /* T_cnavIo */
static int hf_lpp_cnavIoDot = -1;                 /* INTEGER_M16384_16383 */
static int hf_lpp_cnavCis = -1;                   /* INTEGER_M32768_32767 */
static int hf_lpp_cnavCic = -1;                   /* INTEGER_M32768_32767 */
static int hf_lpp_cnavCrs = -1;                   /* INTEGER_M8388608_8388607 */
static int hf_lpp_cnavCrc = -1;                   /* INTEGER_M8388608_8388607 */
static int hf_lpp_cnavCus = -1;                   /* INTEGER_M1048576_1048575 */
static int hf_lpp_cnavCuc = -1;                   /* INTEGER_M1048576_1048575 */
static int hf_lpp_gloEn = -1;                     /* INTEGER_0_31 */
static int hf_lpp_gloP1 = -1;                     /* T_gloP1 */
static int hf_lpp_gloP2 = -1;                     /* BOOLEAN */
static int hf_lpp_gloM = -1;                      /* INTEGER_0_3 */
static int hf_lpp_gloX = -1;                      /* INTEGER_M67108864_67108863 */
static int hf_lpp_gloXdot = -1;                   /* INTEGER_M8388608_8388607 */
static int hf_lpp_gloXdotdot = -1;                /* INTEGER_M16_15 */
static int hf_lpp_gloY = -1;                      /* INTEGER_M67108864_67108863 */
static int hf_lpp_gloYdot = -1;                   /* INTEGER_M8388608_8388607 */
static int hf_lpp_gloYdotdot = -1;                /* INTEGER_M16_15 */
static int hf_lpp_gloZ = -1;                      /* INTEGER_M67108864_67108863 */
static int hf_lpp_gloZdot = -1;                   /* INTEGER_M8388608_8388607 */
static int hf_lpp_gloZdotdot = -1;                /* INTEGER_M16_15 */
static int hf_lpp_sbasAccuracy = -1;              /* BIT_STRING_SIZE_4 */
static int hf_lpp_sbasXg = -1;                    /* INTEGER_M536870912_536870911 */
static int hf_lpp_sbasYg = -1;                    /* INTEGER_M536870912_536870911 */
static int hf_lpp_sbasZg = -1;                    /* INTEGER_M16777216_16777215 */
static int hf_lpp_sbasXgDot = -1;                 /* INTEGER_M65536_65535 */
static int hf_lpp_sbasYgDot = -1;                 /* INTEGER_M65536_65535 */
static int hf_lpp_sbasZgDot = -1;                 /* INTEGER_M131072_131071 */
static int hf_lpp_sbasXgDotDot = -1;              /* INTEGER_M512_511 */
static int hf_lpp_sbagYgDotDot = -1;              /* INTEGER_M512_511 */
static int hf_lpp_sbasZgDotDot = -1;              /* INTEGER_M512_511 */
static int hf_lpp_bdsAODE_r12 = -1;               /* INTEGER_0_31 */
static int hf_lpp_bdsURAI_r12 = -1;               /* INTEGER_0_15 */
static int hf_lpp_bdsToe_r12 = -1;                /* INTEGER_0_131071 */
static int hf_lpp_bdsAPowerHalf_r12 = -1;         /* INTEGER_0_4294967295 */
static int hf_lpp_bdsE_r12 = -1;                  /* INTEGER_0_4294967295 */
static int hf_lpp_bdsW_r12 = -1;                  /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_bdsDeltaN_r12 = -1;             /* INTEGER_M32768_32767 */
static int hf_lpp_bdsM0_r12 = -1;                 /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_bdsOmega0_r12 = -1;             /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_bdsOmegaDot_r12 = -1;           /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsI0_r12 = -1;                 /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_bdsIDot_r12 = -1;               /* INTEGER_M8192_8191 */
static int hf_lpp_bdsCuc_r12 = -1;                /* INTEGER_M131072_131071 */
static int hf_lpp_bdsCus_r12 = -1;                /* INTEGER_M131072_131071 */
static int hf_lpp_bdsCrc_r12 = -1;                /* INTEGER_M131072_131071 */
static int hf_lpp_bdsCrs_r12 = -1;                /* INTEGER_M131072_131071 */
static int hf_lpp_bdsCic_r12 = -1;                /* INTEGER_M131072_131071 */
static int hf_lpp_bdsCis_r12 = -1;                /* INTEGER_M131072_131071 */
static int hf_lpp_bdsIODE_r16 = -1;               /* INTEGER_0_255 */
static int hf_lpp_bdsToe_r16 = -1;                /* INTEGER_0_2047 */
static int hf_lpp_bdsDeltaA_r16 = -1;             /* INTEGER_M33554432_33554431 */
static int hf_lpp_bdsAdot_r16 = -1;               /* INTEGER_M16777216_16777216 */
static int hf_lpp_bdsDeltaN0_r16 = -1;            /* INTEGER_M65536_65535 */
static int hf_lpp_bdsDeltaN0dot_r16 = -1;         /* INTEGER_M4194304_4194303 */
static int hf_lpp_bdsM0_r16 = -1;                 /* INTEGER_M4294967296_4294967295 */
static int hf_lpp_bdsE_r16 = -1;                  /* INTEGER_0_8589934591 */
static int hf_lpp_bdsOmega_r16 = -1;              /* INTEGER_M4294967296_4294967295 */
static int hf_lpp_bdsOmega0_r16 = -1;             /* INTEGER_M4294967296_4294967295 */
static int hf_lpp_bdsI0_r16 = -1;                 /* INTEGER_M4294967296_4294967295 */
static int hf_lpp_bdsOmegaDot_r16 = -1;           /* INTEGER_M262144_262143 */
static int hf_lpp_bdsI0Dot_r16 = -1;              /* INTEGER_M16384_16383 */
static int hf_lpp_bdsCuc_r16 = -1;                /* INTEGER_M1048576_1048575 */
static int hf_lpp_bdsCus_r16 = -1;                /* INTEGER_M1048576_1048575 */
static int hf_lpp_bdsCrc_r16 = -1;                /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsCrs_r16 = -1;                /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsCic_r16 = -1;                /* INTEGER_M32768_32767 */
static int hf_lpp_bdsCis_r16 = -1;                /* INTEGER_M32768_32767 */
static int hf_lpp_navic_Toe_r16 = -1;             /* INTEGER_0_65536 */
static int hf_lpp_navic_URAI_r16 = -1;            /* INTEGER_0_15 */
static int hf_lpp_navic_W_r16 = -1;               /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navic_DeltaN_r16 = -1;          /* INTEGER_M2097152_2097151 */
static int hf_lpp_navic_M0_r16 = -1;              /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navic_OmegaDot_r16 = -1;        /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navic_E_r16 = -1;               /* INTEGER_0_4294967295 */
static int hf_lpp_navic_IDot_r16 = -1;            /* INTEGER_M8192_8191 */
static int hf_lpp_navic_APowerHalf_r16 = -1;      /* INTEGER_0_4294967295 */
static int hf_lpp_navic_I0_r16 = -1;              /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navic_Omega0_r16 = -1;          /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_navic_Crs_r16 = -1;             /* INTEGER_M32768_32767 */
static int hf_lpp_navic_Cis_r16 = -1;             /* INTEGER_M32768_32767 */
static int hf_lpp_navic_Cus_r16 = -1;             /* INTEGER_M32768_32767 */
static int hf_lpp_navic_Crc_r16 = -1;             /* INTEGER_M32768_32767 */
static int hf_lpp_navic_Cic_r16 = -1;             /* INTEGER_M32768_32767 */
static int hf_lpp_navic_Cuc_r16 = -1;             /* INTEGER_M32768_32767 */
static int hf_lpp_gnss_BadSignalList = -1;        /* GNSS_BadSignalList */
static int hf_lpp_GNSS_BadSignalList_item = -1;   /* BadSignalElement */
static int hf_lpp_badSVID = -1;                   /* SV_ID */
static int hf_lpp_badSignalID = -1;               /* GNSS_SignalIDs */
static int hf_lpp_gnss_TOD = -1;                  /* INTEGER_0_3599 */
static int hf_lpp_gnss_TODfrac = -1;              /* INTEGER_0_999 */
static int hf_lpp_gnss_DataBitsSatList = -1;      /* GNSS_DataBitsSatList */
static int hf_lpp_GNSS_DataBitsSatList_item = -1;  /* GNSS_DataBitsSatElement */
static int hf_lpp_gnss_DataBitsSgnList = -1;      /* GNSS_DataBitsSgnList */
static int hf_lpp_GNSS_DataBitsSgnList_item = -1;  /* GNSS_DataBitsSgnElement */
static int hf_lpp_gnss_SignalType = -1;           /* GNSS_SignalID */
static int hf_lpp_gnss_DataBits = -1;             /* BIT_STRING_SIZE_1_1024 */
static int hf_lpp_gnss_AcquisitionAssistList = -1;  /* GNSS_AcquisitionAssistList */
static int hf_lpp_confidence_r10 = -1;            /* INTEGER_0_100 */
static int hf_lpp_GNSS_AcquisitionAssistList_item = -1;  /* GNSS_AcquisitionAssistElement */
static int hf_lpp_doppler0 = -1;                  /* INTEGER_M2048_2047 */
static int hf_lpp_doppler1 = -1;                  /* INTEGER_0_63 */
static int hf_lpp_dopplerUncertainty = -1;        /* INTEGER_0_4 */
static int hf_lpp_codePhase = -1;                 /* INTEGER_0_1022 */
static int hf_lpp_intCodePhase = -1;              /* INTEGER_0_127 */
static int hf_lpp_codePhaseSearchWindow = -1;     /* INTEGER_0_31 */
static int hf_lpp_azimuth = -1;                   /* INTEGER_0_511 */
static int hf_lpp_elevation = -1;                 /* INTEGER_0_127 */
static int hf_lpp_codePhase1023 = -1;             /* BOOLEAN */
static int hf_lpp_dopplerUncertaintyExt_r10 = -1;  /* T_dopplerUncertaintyExt_r10 */
static int hf_lpp_weekNumber_01 = -1;             /* INTEGER_0_255 */
static int hf_lpp_toa = -1;                       /* T_toa */
static int hf_lpp_ioda = -1;                      /* INTEGER_0_3 */
static int hf_lpp_completeAlmanacProvided = -1;   /* BOOLEAN */
static int hf_lpp_gnss_AlmanacList = -1;          /* GNSS_AlmanacList */
static int hf_lpp_toa_ext_v1240 = -1;             /* T_toa_ext_v1240 */
static int hf_lpp_ioda_ext_v1240 = -1;            /* INTEGER_4_15 */
static int hf_lpp_weekNumber_ext_r16 = -1;        /* INTEGER_256_8191 */
static int hf_lpp_toa_ext2_r16 = -1;              /* INTEGER_256_65535 */
static int hf_lpp_GNSS_AlmanacList_item = -1;     /* GNSS_AlmanacElement */
static int hf_lpp_keplerianAlmanacSet = -1;       /* AlmanacKeplerianSet */
static int hf_lpp_keplerianNAV_Almanac = -1;      /* AlmanacNAV_KeplerianSet */
static int hf_lpp_keplerianReducedAlmanac = -1;   /* AlmanacReducedKeplerianSet */
static int hf_lpp_keplerianMidiAlmanac = -1;      /* AlmanacMidiAlmanacSet */
static int hf_lpp_keplerianGLONASS = -1;          /* AlmanacGLONASS_AlmanacSet */
static int hf_lpp_ecef_SBAS_Almanac = -1;         /* AlmanacECEF_SBAS_AlmanacSet */
static int hf_lpp_keplerianBDS_Almanac_r12 = -1;  /* AlmanacBDS_AlmanacSet_r12 */
static int hf_lpp_keplerianNavIC_Almanac_r16 = -1;  /* AlmanacNavIC_AlmanacSet_r16 */
static int hf_lpp_kepAlmanacE = -1;               /* INTEGER_0_2047 */
static int hf_lpp_kepAlmanacDeltaI = -1;          /* INTEGER_M1024_1023 */
static int hf_lpp_kepAlmanacOmegaDot = -1;        /* INTEGER_M1024_1023 */
static int hf_lpp_kepSV_StatusINAV = -1;          /* T_kepSV_StatusINAV */
static int hf_lpp_kepSV_StatusFNAV = -1;          /* T_kepSV_StatusFNAV */
static int hf_lpp_kepAlmanacAPowerHalf = -1;      /* INTEGER_M4096_4095 */
static int hf_lpp_kepAlmanacOmega0 = -1;          /* INTEGER_M32768_32767 */
static int hf_lpp_kepAlmanacW = -1;               /* INTEGER_M32768_32767 */
static int hf_lpp_kepAlmanacM0 = -1;              /* INTEGER_M32768_32767 */
static int hf_lpp_kepAlmanacAF0 = -1;             /* INTEGER_M32768_32767 */
static int hf_lpp_kepAlmanacAF1 = -1;             /* INTEGER_M4096_4095 */
static int hf_lpp_navAlmE = -1;                   /* INTEGER_0_65535 */
static int hf_lpp_navAlmDeltaI = -1;              /* INTEGER_M32768_32767 */
static int hf_lpp_navAlmOMEGADOT = -1;            /* INTEGER_M32768_32767 */
static int hf_lpp_navAlmSVHealth = -1;            /* INTEGER_0_255 */
static int hf_lpp_navAlmSqrtA = -1;               /* INTEGER_0_16777215 */
static int hf_lpp_navAlmOMEGAo = -1;              /* INTEGER_M8388608_8388607 */
static int hf_lpp_navAlmOmega = -1;               /* INTEGER_M8388608_8388607 */
static int hf_lpp_navAlmMo = -1;                  /* INTEGER_M8388608_8388607 */
static int hf_lpp_navAlmaf0 = -1;                 /* INTEGER_M1024_1023 */
static int hf_lpp_navAlmaf1 = -1;                 /* INTEGER_M1024_1023 */
static int hf_lpp_redAlmDeltaA = -1;              /* INTEGER_M128_127 */
static int hf_lpp_redAlmOmega0 = -1;              /* INTEGER_M64_63 */
static int hf_lpp_redAlmPhi0 = -1;                /* INTEGER_M64_63 */
static int hf_lpp_redAlmL1Health = -1;            /* BOOLEAN */
static int hf_lpp_redAlmL2Health = -1;            /* BOOLEAN */
static int hf_lpp_redAlmL5Health = -1;            /* BOOLEAN */
static int hf_lpp_midiAlmE = -1;                  /* INTEGER_0_2047 */
static int hf_lpp_midiAlmDeltaI = -1;             /* INTEGER_M1024_1023 */
static int hf_lpp_midiAlmOmegaDot = -1;           /* INTEGER_M1024_1023 */
static int hf_lpp_midiAlmSqrtA = -1;              /* INTEGER_0_131071 */
static int hf_lpp_midiAlmOmega0 = -1;             /* INTEGER_M32768_32767 */
static int hf_lpp_midiAlmOmega = -1;              /* INTEGER_M32768_32767 */
static int hf_lpp_midiAlmMo = -1;                 /* INTEGER_M32768_32767 */
static int hf_lpp_midiAlmaf0 = -1;                /* INTEGER_M1024_1023 */
static int hf_lpp_midiAlmaf1 = -1;                /* INTEGER_M512_511 */
static int hf_lpp_midiAlmL1Health = -1;           /* BOOLEAN */
static int hf_lpp_midiAlmL2Health = -1;           /* BOOLEAN */
static int hf_lpp_midiAlmL5Health = -1;           /* BOOLEAN */
static int hf_lpp_gloAlm_NA = -1;                 /* INTEGER_1_1461 */
static int hf_lpp_gloAlmnA = -1;                  /* INTEGER_1_24 */
static int hf_lpp_gloAlmHA = -1;                  /* INTEGER_0_31 */
static int hf_lpp_gloAlmLambdaA = -1;             /* INTEGER_M1048576_1048575 */
static int hf_lpp_gloAlmtlambdaA = -1;            /* INTEGER_0_2097151 */
static int hf_lpp_gloAlmDeltaIa = -1;             /* INTEGER_M131072_131071 */
static int hf_lpp_gloAlmDeltaTA = -1;             /* INTEGER_M2097152_2097151 */
static int hf_lpp_gloAlmDeltaTdotA = -1;          /* INTEGER_M64_63 */
static int hf_lpp_gloAlmEpsilonA = -1;            /* INTEGER_0_32767 */
static int hf_lpp_gloAlmOmegaA = -1;              /* INTEGER_M32768_32767 */
static int hf_lpp_gloAlmTauA = -1;                /* INTEGER_M512_511 */
static int hf_lpp_gloAlmCA = -1;                  /* INTEGER_0_1 */
static int hf_lpp_gloAlmMA = -1;                  /* BIT_STRING_SIZE_2 */
static int hf_lpp_sbasAlmDataID = -1;             /* INTEGER_0_3 */
static int hf_lpp_sbasAlmHealth = -1;             /* BIT_STRING_SIZE_8 */
static int hf_lpp_sbasAlmXg = -1;                 /* INTEGER_M16384_16383 */
static int hf_lpp_sbasAlmYg = -1;                 /* INTEGER_M16384_16383 */
static int hf_lpp_sbasAlmZg = -1;                 /* INTEGER_M256_255 */
static int hf_lpp_sbasAlmXgdot = -1;              /* INTEGER_M4_3 */
static int hf_lpp_sbasAlmYgDot = -1;              /* INTEGER_M4_3 */
static int hf_lpp_sbasAlmZgDot = -1;              /* INTEGER_M8_7 */
static int hf_lpp_sbasAlmTo = -1;                 /* INTEGER_0_2047 */
static int hf_lpp_bdsAlmToa_r12 = -1;             /* INTEGER_0_255 */
static int hf_lpp_bdsAlmSqrtA_r12 = -1;           /* INTEGER_0_16777215 */
static int hf_lpp_bdsAlmE_r12 = -1;               /* INTEGER_0_131071 */
static int hf_lpp_bdsAlmW_r12 = -1;               /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsAlmM0_r12 = -1;              /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsAlmOmega0_r12 = -1;          /* INTEGER_M8388608_8388607 */
static int hf_lpp_bdsAlmOmegaDot_r12 = -1;        /* INTEGER_M65536_65535 */
static int hf_lpp_bdsAlmDeltaI_r12 = -1;          /* INTEGER_M32768_32767 */
static int hf_lpp_bdsAlmA0_r12 = -1;              /* INTEGER_M1024_1023 */
static int hf_lpp_bdsAlmA1_r12 = -1;              /* INTEGER_M1024_1023 */
static int hf_lpp_bdsSvHealth_r12 = -1;           /* T_bdsSvHealth_r12 */
static int hf_lpp_svID_r16 = -1;                  /* SV_ID */
static int hf_lpp_navic_AlmToa_r16 = -1;          /* INTEGER_0_65535 */
static int hf_lpp_navic_AlmE_r16 = -1;            /* INTEGER_0_65535 */
static int hf_lpp_navic_AlmOMEGADOT_r16 = -1;     /* INTEGER_M32768_32767 */
static int hf_lpp_navic_AlmSqrtA_r16 = -1;        /* INTEGER_0_16777215 */
static int hf_lpp_navic_AlmOMEGAo_r16 = -1;       /* INTEGER_M8388608_8388607 */
static int hf_lpp_navic_AlmOmega_r16 = -1;        /* INTEGER_M8388608_8388607 */
static int hf_lpp_navic_AlmMo_r16 = -1;           /* INTEGER_M8388608_8388607 */
static int hf_lpp_navic_Almaf0_r16 = -1;          /* INTEGER_M1024_1023 */
static int hf_lpp_navic_Almaf1_r16 = -1;          /* INTEGER_M1024_1023 */
static int hf_lpp_utcModel1 = -1;                 /* UTC_ModelSet1 */
static int hf_lpp_utcModel2 = -1;                 /* UTC_ModelSet2 */
static int hf_lpp_utcModel3 = -1;                 /* UTC_ModelSet3 */
static int hf_lpp_utcModel4 = -1;                 /* UTC_ModelSet4 */
static int hf_lpp_utcModel5_r12 = -1;             /* UTC_ModelSet5_r12 */
static int hf_lpp_gnss_Utc_A1 = -1;               /* INTEGER_M8388608_8388607 */
static int hf_lpp_gnss_Utc_A0 = -1;               /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_gnss_Utc_Tot = -1;              /* INTEGER_0_255 */
static int hf_lpp_gnss_Utc_WNt = -1;              /* INTEGER_0_255 */
static int hf_lpp_gnss_Utc_DeltaTls = -1;         /* INTEGER_M128_127 */
static int hf_lpp_gnss_Utc_WNlsf = -1;            /* INTEGER_0_255 */
static int hf_lpp_gnss_Utc_DN = -1;               /* INTEGER_M128_127 */
static int hf_lpp_gnss_Utc_DeltaTlsf = -1;        /* INTEGER_M128_127 */
static int hf_lpp_utcA0 = -1;                     /* INTEGER_M32768_32767 */
static int hf_lpp_utcA1 = -1;                     /* INTEGER_M4096_4095 */
static int hf_lpp_utcA2 = -1;                     /* INTEGER_M64_63 */
static int hf_lpp_utcDeltaTls = -1;               /* INTEGER_M128_127 */
static int hf_lpp_utcTot = -1;                    /* INTEGER_0_65535 */
static int hf_lpp_utcWNot = -1;                   /* INTEGER_0_8191 */
static int hf_lpp_utcWNlsf = -1;                  /* INTEGER_0_255 */
static int hf_lpp_utcDN = -1;                     /* T_utcDN */
static int hf_lpp_utcDeltaTlsf = -1;              /* INTEGER_M128_127 */
static int hf_lpp_utcWNlsf_ext_r16 = -1;          /* INTEGER_256_8191 */
static int hf_lpp_nA = -1;                        /* INTEGER_1_1461 */
static int hf_lpp_tauC = -1;                      /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_b1 = -1;                        /* INTEGER_M1024_1023 */
static int hf_lpp_b2 = -1;                        /* INTEGER_M512_511 */
static int hf_lpp_kp = -1;                        /* T_kp */
static int hf_lpp_utcA1wnt = -1;                  /* INTEGER_M8388608_8388607 */
static int hf_lpp_utcA0wnt = -1;                  /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_utcTot_01 = -1;                 /* INTEGER_0_255 */
static int hf_lpp_utcWNt = -1;                    /* INTEGER_0_255 */
static int hf_lpp_UTC_ModelSet4_utcDN = -1;       /* INTEGER_M128_127 */
static int hf_lpp_utcStandardID = -1;             /* INTEGER_0_7 */
static int hf_lpp_utcA0_r12 = -1;                 /* INTEGER_M2147483648_2147483647 */
static int hf_lpp_utcA1_r12 = -1;                 /* INTEGER_M8388608_8388607 */
static int hf_lpp_utcDeltaTls_r12 = -1;           /* INTEGER_M128_127 */
static int hf_lpp_utcWNlsf_r12 = -1;              /* INTEGER_0_255 */
static int hf_lpp_utcDN_r12 = -1;                 /* INTEGER_0_255 */
static int hf_lpp_utcDeltaTlsf_r12 = -1;          /* INTEGER_M128_127 */
static int hf_lpp_gnss_ID_GPS = -1;               /* GNSS_ID_GPS */
static int hf_lpp_gnss_ID_GLONASS = -1;           /* GNSS_ID_GLONASS */
static int hf_lpp_gnss_ID_BDS_r16 = -1;           /* GNSS_ID_BDS_r16 */
static int hf_lpp_GNSS_ID_GPS_item = -1;          /* GNSS_ID_GPS_SatElement */
static int hf_lpp_signalsAvailable = -1;          /* GNSS_SignalIDs */
static int hf_lpp_GNSS_ID_GLONASS_item = -1;      /* GNSS_ID_GLONASS_SatElement */
static int hf_lpp_channelNumber = -1;             /* INTEGER_M7_13 */
static int hf_lpp_GNSS_ID_BDS_r16_item = -1;      /* GNSS_ID_BDS_SatElement_r16 */
static int hf_lpp_satType_r16 = -1;               /* INTEGER_0_3 */
static int hf_lpp_dbds_RefTime_r12 = -1;          /* INTEGER_0_3599 */
static int hf_lpp_bds_SgnTypeList_r12 = -1;       /* BDS_SgnTypeList_r12 */
static int hf_lpp_BDS_SgnTypeList_r12_item = -1;  /* BDS_SgnTypeElement_r12 */
static int hf_lpp_dbds_CorrectionList_r12 = -1;   /* DBDS_CorrectionList_r12 */
static int hf_lpp_DBDS_CorrectionList_r12_item = -1;  /* DBDS_CorrectionElement_r12 */
static int hf_lpp_bds_UDREI_r12 = -1;             /* INTEGER_0_15 */
static int hf_lpp_bds_RURAI_r12 = -1;             /* INTEGER_0_15 */
static int hf_lpp_bds_ECC_DeltaT_r12 = -1;        /* INTEGER_M4096_4095 */
static int hf_lpp_bds_RefTime_r12 = -1;           /* INTEGER_0_3599 */
static int hf_lpp_gridIonList_r12 = -1;           /* GridIonList_r12 */
static int hf_lpp_GridIonList_r12_item = -1;      /* GridIonElement_r12 */
static int hf_lpp_igp_ID_r12 = -1;                /* INTEGER_1_320 */
static int hf_lpp_dt_r12 = -1;                    /* INTEGER_0_511 */
static int hf_lpp_givei_r12 = -1;                 /* INTEGER_0_15 */
static int hf_lpp_epochTime_r15 = -1;             /* GNSS_SystemTime */
static int hf_lpp_gnss_ObservationList_r15 = -1;  /* GNSS_ObservationList_r15 */
static int hf_lpp_GNSS_ObservationList_r15_item = -1;  /* GNSS_RTK_SatelliteDataElement_r15 */
static int hf_lpp_svID_r15 = -1;                  /* SV_ID */
static int hf_lpp_integer_ms_r15 = -1;            /* INTEGER_0_254 */
static int hf_lpp_rough_range_r15 = -1;           /* INTEGER_0_1023 */
static int hf_lpp_rough_phase_range_rate_r15 = -1;  /* INTEGER_M8192_8191 */
static int hf_lpp_gnss_rtk_SatelliteSignalDataList_r15 = -1;  /* GNSS_RTK_SatelliteSignalDataList_r15 */
static int hf_lpp_GNSS_RTK_SatelliteSignalDataList_r15_item = -1;  /* GNSS_RTK_SatelliteSignalDataElement_r15 */
static int hf_lpp_gnss_SignalID_r15 = -1;         /* GNSS_SignalID */
static int hf_lpp_fine_PseudoRange_r15 = -1;      /* INTEGER_M524288_524287 */
static int hf_lpp_fine_PhaseRange_r15 = -1;       /* INTEGER_M8388608_8388607 */
static int hf_lpp_lockTimeIndicator_r15 = -1;     /* INTEGER_0_1023 */
static int hf_lpp_halfCycleAmbiguityIndicator_r15 = -1;  /* BIT_STRING_SIZE_1 */
static int hf_lpp_carrier_to_noise_ratio_r15 = -1;  /* INTEGER_0_1023 */
static int hf_lpp_fine_PhaseRangeRate_r15 = -1;   /* INTEGER_M16384_16383 */
static int hf_lpp_cpbIndicator_r15 = -1;          /* BIT_STRING_SIZE_1 */
static int hf_lpp_l1_ca_cpBias_r15 = -1;          /* INTEGER_M32768_32767 */
static int hf_lpp_l1_p_cpBias_r15 = -1;           /* INTEGER_M32768_32767 */
static int hf_lpp_l2_ca_cpBias_r15 = -1;          /* INTEGER_M32768_32767 */
static int hf_lpp_l2_p_cpBias_r15 = -1;           /* INTEGER_M32768_32767 */
static int hf_lpp_master_ReferenceStationID_r15 = -1;  /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_l1_r15 = -1;                    /* GNSS_FrequencyID_r15 */
static int hf_lpp_l2_r15 = -1;                    /* GNSS_FrequencyID_r15 */
static int hf_lpp_rtkCorrectionDifferencesList_r15 = -1;  /* RTK_CorrectionDifferencesList_r15 */
static int hf_lpp_RTK_CorrectionDifferencesList_r15_item = -1;  /* RTK_CorrectionDifferencesElement_r15 */
static int hf_lpp_auxiliary_referenceStationID_r15 = -1;  /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_geometric_ionospheric_corrections_differences_r15 = -1;  /* Geometric_Ionospheric_Corrections_Differences_r15 */
static int hf_lpp_Geometric_Ionospheric_Corrections_Differences_r15_item = -1;  /* Geometric_Ionospheric_Corrections_Differences_Element_r15 */
static int hf_lpp_ambiguityStatusFlag_r15 = -1;   /* INTEGER_0_3 */
static int hf_lpp_non_synch_count_r15 = -1;       /* INTEGER_0_7 */
static int hf_lpp_geometricCarrierPhaseCorrectionDifference_r15 = -1;  /* INTEGER_M65536_65535 */
static int hf_lpp_iod_r15 = -1;                   /* BIT_STRING_SIZE_11 */
static int hf_lpp_ionosphericCarrierPhaseCorrectionDifference_r15 = -1;  /* INTEGER_M65536_65535 */
static int hf_lpp_n_Refs_r15 = -1;                /* INTEGER_0_127 */
static int hf_lpp_rtk_residuals_list_r15 = -1;    /* RTK_Residuals_List_r15 */
static int hf_lpp_RTK_Residuals_List_r15_item = -1;  /* RTK_Residuals_Element_r15 */
static int hf_lpp_s_oc_r15 = -1;                  /* INTEGER_0_255 */
static int hf_lpp_s_od_r15 = -1;                  /* INTEGER_0_511 */
static int hf_lpp_s_oh_r15 = -1;                  /* INTEGER_0_63 */
static int hf_lpp_s_lc_r15 = -1;                  /* INTEGER_0_1023 */
static int hf_lpp_s_ld_r15 = -1;                  /* INTEGER_0_1023 */
static int hf_lpp_fkp_gradients_list_r15 = -1;    /* FKP_Gradients_List_r15 */
static int hf_lpp_FKP_Gradients_List_r15_item = -1;  /* FKP_Gradients_Element_r15 */
static int hf_lpp_north_geometric_gradient_r15 = -1;  /* INTEGER_M2048_2047 */
static int hf_lpp_east_geometric_gradient_r15 = -1;  /* INTEGER_M2048_2047 */
static int hf_lpp_north_ionospheric_gradient_r15 = -1;  /* INTEGER_M8192_8191 */
static int hf_lpp_east_ionospheric_gradient_r15 = -1;  /* INTEGER_M8192_8191 */
static int hf_lpp_ssrUpdateInterval_r15 = -1;     /* INTEGER_0_15 */
static int hf_lpp_satelliteReferenceDatum_r15 = -1;  /* T_satelliteReferenceDatum_r15 */
static int hf_lpp_iod_ssr_r15 = -1;               /* INTEGER_0_15 */
static int hf_lpp_ssr_OrbitCorrectionList_r15 = -1;  /* SSR_OrbitCorrectionList_r15 */
static int hf_lpp_orbit_IntegrityParameters_r17 = -1;  /* ORBIT_IntegrityParameters_r17 */
static int hf_lpp_SSR_OrbitCorrectionList_r15_item = -1;  /* SSR_OrbitCorrectionSatelliteElement_r15 */
static int hf_lpp_delta_radial_r15 = -1;          /* INTEGER_M2097152_2097151 */
static int hf_lpp_delta_AlongTrack_r15 = -1;      /* INTEGER_M524288_524287 */
static int hf_lpp_delta_CrossTrack_r15 = -1;      /* INTEGER_M524288_524287 */
static int hf_lpp_dot_delta_radial_r15 = -1;      /* INTEGER_M1048576_1048575 */
static int hf_lpp_dot_delta_AlongTrack_r15 = -1;  /* INTEGER_M262144_262143 */
static int hf_lpp_dot_delta_CrossTrack_r15 = -1;  /* INTEGER_M262144_262143 */
static int hf_lpp_ssr_IntegrityOrbitBounds_r17 = -1;  /* SSR_IntegrityOrbitBounds_r17 */
static int hf_lpp_probOnsetConstFault_r17 = -1;   /* INTEGER_0_255 */
static int hf_lpp_meanConstFaultDuration_r17 = -1;  /* INTEGER_1_3600 */
static int hf_lpp_probOnsetSatFault_r17 = -1;     /* INTEGER_0_255 */
static int hf_lpp_meanSatFaultDuration_r17 = -1;  /* INTEGER_1_3600 */
static int hf_lpp_orbitRangeErrorCorrelationTime_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_orbitRangeRateErrorCorrelationTime_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_meanOrbitError_r17 = -1;        /* RAC_OrbitalErrorComponents_r17 */
static int hf_lpp_stdDevOrbitError_r17 = -1;      /* RAC_OrbitalErrorComponents_r17 */
static int hf_lpp_meanOrbitRateError_r17 = -1;    /* RAC_OrbitalErrorComponents_r17 */
static int hf_lpp_stdDevOrbitRateError_r17 = -1;  /* RAC_OrbitalErrorComponents_r17 */
static int hf_lpp_radial_r17 = -1;                /* INTEGER_0_255 */
static int hf_lpp_alongTrack_r17 = -1;            /* INTEGER_0_255 */
static int hf_lpp_crossTrack_r17 = -1;            /* INTEGER_0_255 */
static int hf_lpp_ssr_ClockCorrectionList_r15 = -1;  /* SSR_ClockCorrectionList_r15 */
static int hf_lpp_clock_IntegrityParameters_r17 = -1;  /* CLOCK_IntegrityParameters_r17 */
static int hf_lpp_SSR_ClockCorrectionList_r15_item = -1;  /* SSR_ClockCorrectionSatelliteElement_r15 */
static int hf_lpp_delta_Clock_C0_r15 = -1;        /* INTEGER_M2097152_2097151 */
static int hf_lpp_delta_Clock_C1_r15 = -1;        /* INTEGER_M1048576_1048575 */
static int hf_lpp_delta_Clock_C2_r15 = -1;        /* INTEGER_M67108864_67108863 */
static int hf_lpp_ssr_IntegrityClockBounds_r17 = -1;  /* SSR_IntegrityClockBounds_r17 */
static int hf_lpp_clockRangeErrorCorrelationTime_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_clockRangeRateErrorCorrelationTime_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_meanClock_r17 = -1;             /* INTEGER_0_255 */
static int hf_lpp_stdDevClock_r17 = -1;           /* INTEGER_0_255 */
static int hf_lpp_meanClockRate_r17 = -1;         /* INTEGER_0_255 */
static int hf_lpp_stdDevClockRate_r17 = -1;       /* INTEGER_0_255 */
static int hf_lpp_ssr_CodeBiasSatList_r15 = -1;   /* SSR_CodeBiasSatList_r15 */
static int hf_lpp_SSR_CodeBiasSatList_r15_item = -1;  /* SSR_CodeBiasSatElement_r15 */
static int hf_lpp_ssr_CodeBiasSignalList_r15 = -1;  /* SSR_CodeBiasSignalList_r15 */
static int hf_lpp_SSR_CodeBiasSignalList_r15_item = -1;  /* SSR_CodeBiasSignalElement_r15 */
static int hf_lpp_signal_and_tracking_mode_ID_r15 = -1;  /* GNSS_SignalID */
static int hf_lpp_codeBias_r15 = -1;              /* INTEGER_M8192_8191 */
static int hf_lpp_ssr_IntegrityCodeBiasBounds_r17 = -1;  /* SSR_IntegrityCodeBiasBounds_r17 */
static int hf_lpp_meanCodeBias_r17 = -1;          /* INTEGER_0_255 */
static int hf_lpp_stdDevCodeBias_r17 = -1;        /* INTEGER_0_255 */
static int hf_lpp_meanCodeBiasRate_r17 = -1;      /* INTEGER_0_255 */
static int hf_lpp_stdDevCodeBiasRate_r17 = -1;    /* INTEGER_0_255 */
static int hf_lpp_epochTime_r16 = -1;             /* GNSS_SystemTime */
static int hf_lpp_ssrUpdateInterval_r16 = -1;     /* INTEGER_0_15 */
static int hf_lpp_iod_ssr_r16 = -1;               /* INTEGER_0_15 */
static int hf_lpp_ssr_URA_SatList_r16 = -1;       /* SSR_URA_SatList_r16 */
static int hf_lpp_SSR_URA_SatList_r16_item = -1;  /* SSR_URA_SatElement_r16 */
static int hf_lpp_ssr_URA_r16 = -1;               /* BIT_STRING_SIZE_6 */
static int hf_lpp_ssr_PhaseBiasSatList_r16 = -1;  /* SSR_PhaseBiasSatList_r16 */
static int hf_lpp_SSR_PhaseBiasSatList_r16_item = -1;  /* SSR_PhaseBiasSatElement_r16 */
static int hf_lpp_ssr_PhaseBiasSignalList_r16 = -1;  /* SSR_PhaseBiasSignalList_r16 */
static int hf_lpp_SSR_PhaseBiasSignalList_r16_item = -1;  /* SSR_PhaseBiasSignalElement_r16 */
static int hf_lpp_signal_and_tracking_mode_ID_r16 = -1;  /* GNSS_SignalID */
static int hf_lpp_phaseBias_r16 = -1;             /* INTEGER_M16384_16383 */
static int hf_lpp_phaseDiscontinuityIndicator_r16 = -1;  /* INTEGER_0_3 */
static int hf_lpp_phaseBiasIntegerIndicator_r16 = -1;  /* INTEGER_0_3 */
static int hf_lpp_ssr_IntegrityPhaseBiasBounds_r17 = -1;  /* SSR_IntegrityPhaseBiasBounds_r17 */
static int hf_lpp_meanPhaseBias_r17 = -1;         /* INTEGER_0_255 */
static int hf_lpp_stdDevPhaseBias_r17 = -1;       /* INTEGER_0_255 */
static int hf_lpp_meanPhaseBiasRate_r17 = -1;     /* INTEGER_0_255 */
static int hf_lpp_stdDevPhaseBiasRate_r17 = -1;   /* INTEGER_0_255 */
static int hf_lpp_stec_SatList_r16 = -1;          /* STEC_SatList_r16 */
static int hf_lpp_stec_IntegrityParameters_r17 = -1;  /* STEC_IntegrityParameters_r17 */
static int hf_lpp_STEC_SatList_r16_item = -1;     /* STEC_SatElement_r16 */
static int hf_lpp_stecQualityIndicator_r16 = -1;  /* BIT_STRING_SIZE_6 */
static int hf_lpp_stec_C00_r16 = -1;              /* INTEGER_M8192_8191 */
static int hf_lpp_stec_C01_r16 = -1;              /* INTEGER_M2048_2047 */
static int hf_lpp_stec_C10_r16 = -1;              /* INTEGER_M2048_2047 */
static int hf_lpp_stec_C11_r16 = -1;              /* INTEGER_M512_511 */
static int hf_lpp_stec_IntegrityErrorBounds_r17 = -1;  /* STEC_IntegrityErrorBounds_r17 */
static int hf_lpp_probOnsetIonoFault_r17 = -1;    /* INTEGER_0_255 */
static int hf_lpp_meanIonoFaultDuration_r17 = -1;  /* INTEGER_1_256 */
static int hf_lpp_ionoRangeErrorCorrelationTime_r17 = -1;  /* INTEGER_1_255 */
static int hf_lpp_ionoRangeRateErrorCorrelationTime_r17 = -1;  /* INTEGER_1_255 */
static int hf_lpp_meanIonosphere_r17 = -1;        /* INTEGER_0_255 */
static int hf_lpp_stdDevIonosphere_r17 = -1;      /* INTEGER_0_255 */
static int hf_lpp_meanIonosphereRate_r17 = -1;    /* INTEGER_0_255 */
static int hf_lpp_stdDevIonosphereRate_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_troposphericDelayQualityIndicator_r16 = -1;  /* BIT_STRING_SIZE_6 */
static int hf_lpp_gridList_r16 = -1;              /* GridList_r16 */
static int hf_lpp_ssr_GriddedCorrectionIntegrityParameters_r17 = -1;  /* SSR_GriddedCorrectionIntegrityParameters_r17 */
static int hf_lpp_GridList_r16_item = -1;         /* GridElement_r16 */
static int hf_lpp_tropospericDelayCorrection_r16 = -1;  /* TropospericDelayCorrection_r16 */
static int hf_lpp_stec_ResidualSatList_r16 = -1;  /* STEC_ResidualSatList_r16 */
static int hf_lpp_tropoHydroStaticVerticalDelay_r16 = -1;  /* INTEGER_M256_255 */
static int hf_lpp_tropoWetVerticalDelay_r16 = -1;  /* INTEGER_M128_127 */
static int hf_lpp_tropoDelayIntegrityErrorBounds_r17 = -1;  /* TropoDelayIntegrityErrorBounds_r17 */
static int hf_lpp_STEC_ResidualSatList_r16_item = -1;  /* STEC_ResidualSatElement_r16 */
static int hf_lpp_stecResidualCorrection_r16 = -1;  /* T_stecResidualCorrection_r16 */
static int hf_lpp_b7_r16 = -1;                    /* INTEGER_M64_63 */
static int hf_lpp_b16_r16 = -1;                   /* INTEGER_M32768_32767 */
static int hf_lpp_probOnsetTroposphereFault_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_meanTroposphereFaultDuration_r17 = -1;  /* INTEGER_1_256 */
static int hf_lpp_troposphereRangeErrorCorrelationTime_r17 = -1;  /* INTEGER_1_255 */
static int hf_lpp_troposphereRangeRateErrorCorrelationTime_r17 = -1;  /* INTEGER_1_255 */
static int hf_lpp_meanTroposphereVerticalHydroStaticDelay_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_stdDevTroposphereVerticalHydroStaticDelay_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_meanTroposphereVerticalWetDelay_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_stdDevTroposphereVerticalWetDelay_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_meanTroposphereVerticalHydroStaticDelayRate_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_stdDevTroposphereVerticalHydroStaticDelayRate_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_meanTroposphereVerticalWetDelayRate_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_stdDevTroposphereVerticalWetDelayRate_r17 = -1;  /* INTEGER_0_255 */
static int hf_lpp_navic_RefTOWC_r16 = -1;         /* INTEGER_0_50400 */
static int hf_lpp_navic_CorrectionListAutoNav_r16 = -1;  /* NavIC_CorrectionListAutoNav_r16 */
static int hf_lpp_NavIC_CorrectionListAutoNav_r16_item = -1;  /* NavIC_CorrectionElementAutoNav_r16 */
static int hf_lpp_navic_Tod_r16 = -1;             /* INTEGER_0_65535 */
static int hf_lpp_navic_iodec_r16 = -1;           /* INTEGER_0_255 */
static int hf_lpp_navic_UDRAI_r16 = -1;           /* INTEGER_M16_15 */
static int hf_lpp_navic_UDRArateI_r16 = -1;       /* INTEGER_M16_15 */
static int hf_lpp_navic_EDC_r16 = -1;             /* NavIC_EDC_r16 */
static int hf_lpp_navic_CDC_r16 = -1;             /* NavIC_CDC_r16 */
static int hf_lpp_navic_AlphaEDC_r16 = -1;        /* INTEGER_M8192_8191 */
static int hf_lpp_navic_BetaEDC_r16 = -1;         /* INTEGER_M8192_8191 */
static int hf_lpp_navic_GammaEDC_r16 = -1;        /* INTEGER_M16384_16383 */
static int hf_lpp_navic_AoIcorrection_r16 = -1;   /* INTEGER_M2048_2047 */
static int hf_lpp_navic_AoRAcorrection_r16 = -1;  /* INTEGER_M2048_2047 */
static int hf_lpp_navic_SemiMajorcorrection_r16 = -1;  /* INTEGER_M2048_2047 */
static int hf_lpp_navic_ClockBiasCorrection_r16 = -1;  /* INTEGER_M4096_4095 */
static int hf_lpp_navic_ClockDriftCorrection_r16 = -1;  /* INTEGER_M128_127 */
static int hf_lpp_regionMasked_r16 = -1;          /* INTEGER_0_1023 */
static int hf_lpp_regionIgpList_r16 = -1;         /* RegionIgpList_r16 */
static int hf_lpp_RegionIgpList_r16_item = -1;    /* RegionIgpElement_r16 */
static int hf_lpp_regionID_r16 = -1;              /* INTEGER_0_15 */
static int hf_lpp_givei1_r16 = -1;                /* INTEGER_0_15 */
static int hf_lpp_givd1_r16 = -1;                 /* INTEGER_0_511 */
static int hf_lpp_givei2_r16 = -1;                /* INTEGER_0_15 */
static int hf_lpp_givd2_r16 = -1;                 /* INTEGER_0_511 */
static int hf_lpp_givei3_r16 = -1;                /* INTEGER_0_15 */
static int hf_lpp_givd3_r16 = -1;                 /* INTEGER_0_511 */
static int hf_lpp_givei4_r16 = -1;                /* INTEGER_0_15 */
static int hf_lpp_givd4_r16 = -1;                 /* INTEGER_0_511 */
static int hf_lpp_givei5_r16 = -1;                /* INTEGER_0_15 */
static int hf_lpp_givd5_r16 = -1;                 /* INTEGER_0_511 */
static int hf_lpp_givei6_r16 = -1;                /* INTEGER_0_15 */
static int hf_lpp_givd6_r16 = -1;                 /* INTEGER_0_511 */
static int hf_lpp_givei7_r16 = -1;                /* INTEGER_0_15 */
static int hf_lpp_givd7_r16 = -1;                 /* INTEGER_0_511 */
static int hf_lpp_givei8_r16 = -1;                /* INTEGER_0_15 */
static int hf_lpp_givd8_r16 = -1;                 /* INTEGER_0_511 */
static int hf_lpp_givei9_r16 = -1;                /* INTEGER_0_15 */
static int hf_lpp_givd9_r16 = -1;                 /* INTEGER_0_511 */
static int hf_lpp_givei10_r16 = -1;               /* INTEGER_0_15 */
static int hf_lpp_givd10_r16 = -1;                /* INTEGER_0_511 */
static int hf_lpp_givei11_r16 = -1;               /* INTEGER_0_15 */
static int hf_lpp_givd11_r16 = -1;                /* INTEGER_0_511 */
static int hf_lpp_givei12_r16 = -1;               /* INTEGER_0_15 */
static int hf_lpp_givd12_r16 = -1;                /* INTEGER_0_511 */
static int hf_lpp_givei13_r16 = -1;               /* INTEGER_0_15 */
static int hf_lpp_givd13_r16 = -1;                /* INTEGER_0_511 */
static int hf_lpp_givei14_r16 = -1;               /* INTEGER_0_15 */
static int hf_lpp_givd14_r16 = -1;                /* INTEGER_0_511 */
static int hf_lpp_givei15_r16 = -1;               /* INTEGER_0_15 */
static int hf_lpp_givd15_r16 = -1;                /* INTEGER_0_511 */
static int hf_lpp_gnss_CommonAssistDataReq = -1;  /* GNSS_CommonAssistDataReq */
static int hf_lpp_gnss_GenericAssistDataReq = -1;  /* GNSS_GenericAssistDataReq */
static int hf_lpp_gnss_PeriodicAssistDataReq_r15 = -1;  /* GNSS_PeriodicAssistDataReq_r15 */
static int hf_lpp_gnss_ReferenceTimeReq = -1;     /* GNSS_ReferenceTimeReq */
static int hf_lpp_gnss_ReferenceLocationReq = -1;  /* GNSS_ReferenceLocationReq */
static int hf_lpp_gnss_IonosphericModelReq = -1;  /* GNSS_IonosphericModelReq */
static int hf_lpp_gnss_EarthOrientationParametersReq = -1;  /* GNSS_EarthOrientationParametersReq */
static int hf_lpp_gnss_RTK_ReferenceStationInfoReq_r15 = -1;  /* GNSS_RTK_ReferenceStationInfoReq_r15 */
static int hf_lpp_gnss_RTK_AuxiliaryStationDataReq_r15 = -1;  /* GNSS_RTK_AuxiliaryStationDataReq_r15 */
static int hf_lpp_gnss_SSR_CorrectionPointsReq_r16 = -1;  /* GNSS_SSR_CorrectionPointsReq_r16 */
static int hf_lpp_gnss_Integrity_ServiceParametersReq_r17 = -1;  /* GNSS_Integrity_ServiceParametersReq_r17 */
static int hf_lpp_gnss_Integrity_ServiceAlertReq_r17 = -1;  /* GNSS_Integrity_ServiceAlertReq_r17 */
static int hf_lpp_GNSS_GenericAssistDataReq_item = -1;  /* GNSS_GenericAssistDataReqElement */
static int hf_lpp_gnss_TimeModelsReq = -1;        /* GNSS_TimeModelListReq */
static int hf_lpp_gnss_DifferentialCorrectionsReq = -1;  /* GNSS_DifferentialCorrectionsReq */
static int hf_lpp_gnss_NavigationModelReq = -1;   /* GNSS_NavigationModelReq */
static int hf_lpp_gnss_RealTimeIntegrityReq = -1;  /* GNSS_RealTimeIntegrityReq */
static int hf_lpp_gnss_DataBitAssistanceReq = -1;  /* GNSS_DataBitAssistanceReq */
static int hf_lpp_gnss_AcquisitionAssistanceReq = -1;  /* GNSS_AcquisitionAssistanceReq */
static int hf_lpp_gnss_AlmanacReq = -1;           /* GNSS_AlmanacReq */
static int hf_lpp_gnss_UTCModelReq = -1;          /* GNSS_UTC_ModelReq */
static int hf_lpp_gnss_AuxiliaryInformationReq = -1;  /* GNSS_AuxiliaryInformationReq */
static int hf_lpp_bds_DifferentialCorrectionsReq_r12 = -1;  /* BDS_DifferentialCorrectionsReq_r12 */
static int hf_lpp_bds_GridModelReq_r12 = -1;      /* BDS_GridModelReq_r12 */
static int hf_lpp_gnss_RTK_ObservationsReq_r15 = -1;  /* GNSS_RTK_ObservationsReq_r15 */
static int hf_lpp_glo_RTK_BiasInformationReq_r15 = -1;  /* GLO_RTK_BiasInformationReq_r15 */
static int hf_lpp_gnss_RTK_MAC_CorrectionDifferencesReq_r15 = -1;  /* GNSS_RTK_MAC_CorrectionDifferencesReq_r15 */
static int hf_lpp_gnss_RTK_ResidualsReq_r15 = -1;  /* GNSS_RTK_ResidualsReq_r15 */
static int hf_lpp_gnss_RTK_FKP_GradientsReq_r15 = -1;  /* GNSS_RTK_FKP_GradientsReq_r15 */
static int hf_lpp_gnss_SSR_OrbitCorrectionsReq_r15 = -1;  /* GNSS_SSR_OrbitCorrectionsReq_r15 */
static int hf_lpp_gnss_SSR_ClockCorrectionsReq_r15 = -1;  /* GNSS_SSR_ClockCorrectionsReq_r15 */
static int hf_lpp_gnss_SSR_CodeBiasReq_r15 = -1;  /* GNSS_SSR_CodeBiasReq_r15 */
static int hf_lpp_gnss_SSR_URA_Req_r16 = -1;      /* GNSS_SSR_URA_Req_r16 */
static int hf_lpp_gnss_SSR_PhaseBiasReq_r16 = -1;  /* GNSS_SSR_PhaseBiasReq_r16 */
static int hf_lpp_gnss_SSR_STEC_CorrectionReq_r16 = -1;  /* GNSS_SSR_STEC_CorrectionReq_r16 */
static int hf_lpp_gnss_SSR_GriddedCorrectionReq_r16 = -1;  /* GNSS_SSR_GriddedCorrectionReq_r16 */
static int hf_lpp_navic_DifferentialCorrectionsReq_r16 = -1;  /* NavIC_DifferentialCorrectionsReq_r16 */
static int hf_lpp_navic_GridModelReq_r16 = -1;    /* NavIC_GridModelReq_r16 */
static int hf_lpp_gnss_RTK_PeriodicObservationsReq_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_glo_RTK_PeriodicBiasInformationReq_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_RTK_MAC_PeriodicCorrectionDifferencesReq_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_RTK_PeriodicResidualsReq_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_RTK_FKP_PeriodicGradientsReq_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicOrbitCorrectionsReq_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicClockCorrectionsReq_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicCodeBiasReq_r15 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicURA_Req_r16 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicPhaseBiasReq_r16 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicSTEC_CorrectionReq_r16 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_SSR_PeriodicGriddedCorrectionReq_r16 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_Integrity_PeriodicServiceAlertReq_r17 = -1;  /* GNSS_PeriodicControlParam_r15 */
static int hf_lpp_gnss_TimeReqPrefList = -1;      /* SEQUENCE_SIZE_1_8_OF_GNSS_ID */
static int hf_lpp_gnss_TimeReqPrefList_item = -1;  /* GNSS_ID */
static int hf_lpp_gps_TOW_assistReq = -1;         /* BOOLEAN */
static int hf_lpp_notOfLeapSecReq = -1;           /* BOOLEAN */
static int hf_lpp_klobucharModelReq = -1;         /* BIT_STRING_SIZE_2 */
static int hf_lpp_neQuickModelReq = -1;           /* NULL */
static int hf_lpp_klobucharModel2Req_r16 = -1;    /* NULL */
static int hf_lpp_antennaDescriptionReq_r15 = -1;  /* BOOLEAN */
static int hf_lpp_antennaHeightReq_r15 = -1;      /* BOOLEAN */
static int hf_lpp_physicalReferenceStationReq_r15 = -1;  /* BOOLEAN */
static int hf_lpp_stationID_r15 = -1;             /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_correctionPointSetID_Req_r16 = -1;  /* INTEGER_0_16383 */
static int hf_lpp_GNSS_TimeModelListReq_item = -1;  /* GNSS_TimeModelElementReq */
static int hf_lpp_gnss_TO_IDsReq = -1;            /* INTEGER_1_15 */
static int hf_lpp_deltaTreq = -1;                 /* BOOLEAN */
static int hf_lpp_dgnss_SignalsReq = -1;          /* GNSS_SignalIDs */
static int hf_lpp_dgnss_ValidityTimeReq = -1;     /* BOOLEAN */
static int hf_lpp_storedNavList = -1;             /* StoredNavListInfo */
static int hf_lpp_reqNavList = -1;                /* ReqNavListInfo */
static int hf_lpp_gnss_WeekOrDay = -1;            /* T_gnss_WeekOrDay */
static int hf_lpp_gnss_Toe = -1;                  /* T_gnss_Toe */
static int hf_lpp_t_toeLimit = -1;                /* T_t_toeLimit */
static int hf_lpp_satListRelatedDataList = -1;    /* SatListRelatedDataList */
static int hf_lpp_SatListRelatedDataList_item = -1;  /* SatListRelatedDataElement */
static int hf_lpp_clockModelID = -1;              /* INTEGER_1_8 */
static int hf_lpp_orbitModelID = -1;              /* INTEGER_1_8 */
static int hf_lpp_svReqList = -1;                 /* BIT_STRING_SIZE_64 */
static int hf_lpp_clockModelID_PrefList = -1;     /* T_clockModelID_PrefList */
static int hf_lpp_clockModelID_PrefList_item = -1;  /* INTEGER_1_8 */
static int hf_lpp_orbitModelID_PrefList = -1;     /* T_orbitModelID_PrefList */
static int hf_lpp_orbitModelID_PrefList_item = -1;  /* INTEGER_1_8 */
static int hf_lpp_addNavparamReq = -1;            /* BOOLEAN */
static int hf_lpp_gnss_TOD_Req = -1;              /* INTEGER_0_3599 */
static int hf_lpp_gnss_TOD_FracReq = -1;          /* INTEGER_0_999 */
static int hf_lpp_dataBitInterval = -1;           /* INTEGER_0_15 */
static int hf_lpp_gnss_SignalType_01 = -1;        /* GNSS_SignalIDs */
static int hf_lpp_gnss_DataBitsReq = -1;          /* GNSS_DataBitsReqSatList */
static int hf_lpp_GNSS_DataBitsReqSatList_item = -1;  /* GNSS_DataBitsReqSatElement */
static int hf_lpp_gnss_SignalID_Req = -1;         /* GNSS_SignalID */
static int hf_lpp_modelID = -1;                   /* INTEGER_1_8 */
static int hf_lpp_gnss_RTK_SignalsReq_r15 = -1;   /* GNSS_SignalIDs */
static int hf_lpp_gnss_RTK_Integer_ms_Req_r15 = -1;  /* BOOLEAN */
static int hf_lpp_gnss_RTK_PhaseRangeRateReq_r15 = -1;  /* BOOLEAN */
static int hf_lpp_gnss_RTK_CNR_Req_r15 = -1;      /* BOOLEAN */
static int hf_lpp_aux_ReferenceStationList_r15 = -1;  /* AUX_ReferenceStationList_r15 */
static int hf_lpp_linkCombinations_PrefList_r15 = -1;  /* GNSS_Link_CombinationsList_r15 */
static int hf_lpp_AUX_ReferenceStationList_r15_item = -1;  /* AUX_ReferenceStationID_Element_r15 */
static int hf_lpp_aux_stationID_r15 = -1;         /* GNSS_ReferenceStationID_r15 */
static int hf_lpp_storedNavList_r15 = -1;         /* GNSS_NavListInfo_r15 */
static int hf_lpp_orbit_IntegrityReq_r17 = -1;    /* T_orbit_IntegrityReq_r17 */
static int hf_lpp_clock_IntegrityParametersReq_r17 = -1;  /* T_clock_IntegrityParametersReq_r17 */
static int hf_lpp_ssr_IntegrityClockBoundsReq_r17 = -1;  /* T_ssr_IntegrityClockBoundsReq_r17 */
static int hf_lpp_signal_and_tracking_mode_ID_Map_r15 = -1;  /* GNSS_SignalIDs */
static int hf_lpp_ssr_IntegrityCodeBiasBoundsReq_r17 = -1;  /* T_ssr_IntegrityCodeBiasBoundsReq_r17 */
static int hf_lpp_signal_and_tracking_mode_ID_Map_r16 = -1;  /* GNSS_SignalIDs */
static int hf_lpp_storedNavList_r16 = -1;         /* GNSS_NavListInfo_r15 */
static int hf_lpp_ssr_IntegrityPhaseBiasBoundsReq_r17 = -1;  /* T_ssr_IntegrityPhaseBiasBoundsReq_r17 */
static int hf_lpp_stec_IntegrityReq_r17 = -1;     /* T_stec_IntegrityReq_r17 */
static int hf_lpp_griddedCorrectionIntegrityReq_r17 = -1;  /* T_griddedCorrectionIntegrityReq_r17 */
static int hf_lpp_dgnss_SignalsReq_r16 = -1;      /* GNSS_SignalIDs */
static int hf_lpp_gnss_SignalMeasurementInformation = -1;  /* GNSS_SignalMeasurementInformation */
static int hf_lpp_gnss_LocationInformation = -1;  /* GNSS_LocationInformation */
static int hf_lpp_measurementReferenceTime = -1;  /* MeasurementReferenceTime */
static int hf_lpp_gnss_MeasurementList = -1;      /* GNSS_MeasurementList */
static int hf_lpp_gnss_TOD_msec = -1;             /* INTEGER_0_3599999 */
static int hf_lpp_gnss_TOD_frac = -1;             /* INTEGER_0_3999 */
static int hf_lpp_gnss_TOD_unc = -1;              /* INTEGER_0_127 */
static int hf_lpp_networkTime_01 = -1;            /* T_networkTime */
static int hf_lpp_eUTRA_01 = -1;                  /* T_eUTRA_01 */
static int hf_lpp_cellGlobalId_01 = -1;           /* CellGlobalIdEUTRA_AndUTRA */
static int hf_lpp_uTRA_01 = -1;                   /* T_uTRA_01 */
static int hf_lpp_mode_01 = -1;                   /* T_mode_01 */
static int hf_lpp_fdd_01 = -1;                    /* T_fdd_01 */
static int hf_lpp_tdd_01 = -1;                    /* T_tdd_01 */
static int hf_lpp_referenceSystemFrameNumber = -1;  /* INTEGER_0_4095 */
static int hf_lpp_gSM_01 = -1;                    /* T_gSM_01 */
static int hf_lpp_cellGlobalId_02 = -1;           /* CellGlobalIdGERAN */
static int hf_lpp_referenceFrame = -1;            /* T_referenceFrame */
static int hf_lpp_referenceFN = -1;               /* INTEGER_0_65535 */
static int hf_lpp_referenceFNMSB = -1;            /* INTEGER_0_63 */
static int hf_lpp_deltaGNSS_TOD = -1;             /* INTEGER_0_127 */
static int hf_lpp_nbIoT_r14 = -1;                 /* T_nbIoT_r14 */
static int hf_lpp_sfn_r14 = -1;                   /* BIT_STRING_SIZE_10 */
static int hf_lpp_nr_r15_01 = -1;                 /* T_nr_r15_01 */
static int hf_lpp_nr_sfn_r15 = -1;                /* BIT_STRING_SIZE_10 */
static int hf_lpp_GNSS_MeasurementList_item = -1;  /* GNSS_MeasurementForOneGNSS */
static int hf_lpp_gnss_SgnMeasList = -1;          /* GNSS_SgnMeasList */
static int hf_lpp_GNSS_SgnMeasList_item = -1;     /* GNSS_SgnMeasElement */
static int hf_lpp_gnss_CodePhaseAmbiguity = -1;   /* INTEGER_0_127 */
static int hf_lpp_gnss_SatMeasList = -1;          /* GNSS_SatMeasList */
static int hf_lpp_GNSS_SatMeasList_item = -1;     /* GNSS_SatMeasElement */
static int hf_lpp_cNo = -1;                       /* INTEGER_0_63 */
static int hf_lpp_mpathDet = -1;                  /* T_mpathDet */
static int hf_lpp_carrierQualityInd = -1;         /* INTEGER_0_3 */
static int hf_lpp_codePhase_01 = -1;              /* INTEGER_0_2097151 */
static int hf_lpp_integerCodePhase = -1;          /* INTEGER_0_127 */
static int hf_lpp_codePhaseRMSError = -1;         /* INTEGER_0_63 */
static int hf_lpp_doppler = -1;                   /* INTEGER_M32768_32767 */
static int hf_lpp_adr = -1;                       /* INTEGER_0_33554431 */
static int hf_lpp_adrMSB_r15 = -1;                /* INTEGER_0_15 */
static int hf_lpp_adrSign_r15 = -1;               /* T_adrSign_r15 */
static int hf_lpp_adrRMSerror_r15 = -1;           /* INTEGER_0_127 */
static int hf_lpp_delta_codePhase_r15 = -1;       /* INTEGER_0_7 */
static int hf_lpp_agnss_List = -1;                /* GNSS_ID_Bitmap */
static int hf_lpp_ha_GNSS_Metrics_r17 = -1;       /* HA_GNSS_Metrics_r17 */
static int hf_lpp_nrOfUsedSatellites_r17 = -1;    /* INTEGER_0_64 */
static int hf_lpp_hdopi_r17 = -1;                 /* INTEGER_1_256 */
static int hf_lpp_pdopi_r17 = -1;                 /* INTEGER_1_256 */
static int hf_lpp_age_r17 = -1;                   /* INTEGER_0_99 */
static int hf_lpp_fixType_r17 = -1;               /* T_fixType_r17 */
static int hf_lpp_gnss_PositioningInstructions = -1;  /* GNSS_PositioningInstructions */
static int hf_lpp_gnss_Methods = -1;              /* GNSS_ID_Bitmap */
static int hf_lpp_fineTimeAssistanceMeasReq = -1;  /* BOOLEAN */
static int hf_lpp_adrMeasReq = -1;                /* BOOLEAN */
static int hf_lpp_multiFreqMeasReq = -1;          /* BOOLEAN */
static int hf_lpp_ha_GNSS_Req_r15 = -1;           /* T_ha_GNSS_Req_r15 */
static int hf_lpp_ha_GNSS_MetricsReq_r17 = -1;    /* T_ha_GNSS_MetricsReq_r17 */
static int hf_lpp_gnss_SupportList = -1;          /* GNSS_SupportList */
static int hf_lpp_assistanceDataSupportList = -1;  /* AssistanceDataSupportList */
static int hf_lpp_periodicalReportingNotSupported_r14 = -1;  /* PositioningModes */
static int hf_lpp_idleStateForMeasurements_r14_01 = -1;  /* T_idleStateForMeasurements_r14_01 */
static int hf_lpp_periodicAssistanceData_r15_01 = -1;  /* T_periodicAssistanceData_r15 */
static int hf_lpp_scheduledLocationRequestSupported_r17_01 = -1;  /* ScheduledLocationTimeSupportPerMode_r17 */
static int hf_lpp_GNSS_SupportList_item = -1;     /* GNSS_SupportElement */
static int hf_lpp_sbas_IDs = -1;                  /* SBAS_IDs */
static int hf_lpp_agnss_Modes = -1;               /* PositioningModes */
static int hf_lpp_gnss_Signals = -1;              /* GNSS_SignalIDs */
static int hf_lpp_fta_MeasSupport = -1;           /* T_fta_MeasSupport */
static int hf_lpp_cellTime = -1;                  /* AccessTypes */
static int hf_lpp_mode_02 = -1;                   /* PositioningModes */
static int hf_lpp_adr_Support = -1;               /* BOOLEAN */
static int hf_lpp_velocityMeasurementSupport = -1;  /* BOOLEAN */
static int hf_lpp_adrEnhancementsSupport_r15 = -1;  /* T_adrEnhancementsSupport_r15 */
static int hf_lpp_ha_gnss_Modes_r15 = -1;         /* PositioningModes */
static int hf_lpp_ha_gnss_MetricsSupport_r17 = -1;  /* T_ha_gnss_MetricsSupport_r17 */
static int hf_lpp_gnss_CommonAssistanceDataSupport = -1;  /* GNSS_CommonAssistanceDataSupport */
static int hf_lpp_gnss_GenericAssistanceDataSupport = -1;  /* GNSS_GenericAssistanceDataSupport */
static int hf_lpp_gnss_ReferenceTimeSupport = -1;  /* GNSS_ReferenceTimeSupport */
static int hf_lpp_gnss_ReferenceLocationSupport = -1;  /* GNSS_ReferenceLocationSupport */
static int hf_lpp_gnss_IonosphericModelSupport = -1;  /* GNSS_IonosphericModelSupport */
static int hf_lpp_gnss_EarthOrientationParametersSupport = -1;  /* GNSS_EarthOrientationParametersSupport */
static int hf_lpp_gnss_RTK_ReferenceStationInfoSupport_r15 = -1;  /* GNSS_RTK_ReferenceStationInfoSupport_r15 */
static int hf_lpp_gnss_RTK_AuxiliaryStationDataSupport_r15 = -1;  /* GNSS_RTK_AuxiliaryStationDataSupport_r15 */
static int hf_lpp_gnss_Integrity_ServiceParametersSupport_r17 = -1;  /* GNSS_Integrity_ServiceParametersSupport_r17 */
static int hf_lpp_gnss_Integrity_ServiceAlertSupport_r17 = -1;  /* GNSS_Integrity_ServiceAlertSupport_r17 */
static int hf_lpp_gnss_SystemTime_01 = -1;        /* GNSS_ID_Bitmap */
static int hf_lpp_fta_Support = -1;               /* AccessTypes */
static int hf_lpp_ionoModel = -1;                 /* T_ionoModel */
static int hf_lpp_GNSS_GenericAssistanceDataSupport_item = -1;  /* GNSS_GenericAssistDataSupportElement */
static int hf_lpp_gnss_TimeModelsSupport = -1;    /* GNSS_TimeModelListSupport */
static int hf_lpp_gnss_DifferentialCorrectionsSupport = -1;  /* GNSS_DifferentialCorrectionsSupport */
static int hf_lpp_gnss_NavigationModelSupport = -1;  /* GNSS_NavigationModelSupport */
static int hf_lpp_gnss_RealTimeIntegritySupport = -1;  /* GNSS_RealTimeIntegritySupport */
static int hf_lpp_gnss_DataBitAssistanceSupport = -1;  /* GNSS_DataBitAssistanceSupport */
static int hf_lpp_gnss_AcquisitionAssistanceSupport = -1;  /* GNSS_AcquisitionAssistanceSupport */
static int hf_lpp_gnss_AlmanacSupport = -1;       /* GNSS_AlmanacSupport */
static int hf_lpp_gnss_UTC_ModelSupport = -1;     /* GNSS_UTC_ModelSupport */
static int hf_lpp_gnss_AuxiliaryInformationSupport = -1;  /* GNSS_AuxiliaryInformationSupport */
static int hf_lpp_bds_DifferentialCorrectionsSupport_r12 = -1;  /* BDS_DifferentialCorrectionsSupport_r12 */
static int hf_lpp_bds_GridModelSupport_r12 = -1;  /* BDS_GridModelSupport_r12 */
static int hf_lpp_gnss_RTK_ObservationsSupport_r15 = -1;  /* GNSS_RTK_ObservationsSupport_r15 */
static int hf_lpp_glo_RTK_BiasInformationSupport_r15 = -1;  /* GLO_RTK_BiasInformationSupport_r15 */
static int hf_lpp_gnss_RTK_MAC_CorrectionDifferencesSupport_r15 = -1;  /* GNSS_RTK_MAC_CorrectionDifferencesSupport_r15 */
static int hf_lpp_gnss_RTK_ResidualsSupport_r15 = -1;  /* GNSS_RTK_ResidualsSupport_r15 */
static int hf_lpp_gnss_RTK_FKP_GradientsSupport_r15 = -1;  /* GNSS_RTK_FKP_GradientsSupport_r15 */
static int hf_lpp_gnss_SSR_OrbitCorrectionsSupport_r15 = -1;  /* GNSS_SSR_OrbitCorrectionsSupport_r15 */
static int hf_lpp_gnss_SSR_ClockCorrectionsSupport_r15 = -1;  /* GNSS_SSR_ClockCorrectionsSupport_r15 */
static int hf_lpp_gnss_SSR_CodeBiasSupport_r15 = -1;  /* GNSS_SSR_CodeBiasSupport_r15 */
static int hf_lpp_gnss_SSR_URA_Support_r16 = -1;  /* GNSS_SSR_URA_Support_r16 */
static int hf_lpp_gnss_SSR_PhaseBiasSupport_r16 = -1;  /* GNSS_SSR_PhaseBiasSupport_r16 */
static int hf_lpp_gnss_SSR_STEC_CorrectionSupport_r16 = -1;  /* GNSS_SSR_STEC_CorrectionSupport_r16 */
static int hf_lpp_gnss_SSR_GriddedCorrectionSupport_r16 = -1;  /* GNSS_SSR_GriddedCorrectionSupport_r16 */
static int hf_lpp_navic_DifferentialCorrectionsSupport_r16 = -1;  /* NavIC_DifferentialCorrectionsSupport_r16 */
static int hf_lpp_navic_GridModelSupport_r16 = -1;  /* NavIC_GridModelSupport_r16 */
static int hf_lpp_gnssSignalIDs = -1;             /* GNSS_SignalIDs */
static int hf_lpp_dgnss_ValidityTimeSup = -1;     /* BOOLEAN */
static int hf_lpp_clockModel = -1;                /* T_clockModel */
static int hf_lpp_orbitModel = -1;                /* T_orbitModel */
static int hf_lpp_confidenceSupport_r10 = -1;     /* T_confidenceSupport_r10 */
static int hf_lpp_dopplerUncertaintyExtSupport_r10 = -1;  /* T_dopplerUncertaintyExtSupport_r10 */
static int hf_lpp_almanacModel = -1;              /* T_almanacModel */
static int hf_lpp_utc_Model = -1;                 /* T_utc_Model */
static int hf_lpp_gnssSignalIDs_r15 = -1;         /* GNSS_SignalIDs */
static int hf_lpp_link_combinations_support_r15 = -1;  /* GNSS_Link_CombinationsList_r15 */
static int hf_lpp_orbit_IntegritySup_r17 = -1;    /* T_orbit_IntegritySup_r17 */
static int hf_lpp_clock_IntegrityParameterSupport_r17 = -1;  /* T_clock_IntegrityParameterSupport_r17 */
static int hf_lpp_ssr_IntegrityClockBoundsSupport_r17 = -1;  /* T_ssr_IntegrityClockBoundsSupport_r17 */
static int hf_lpp_signal_and_tracking_mode_ID_Sup_r15 = -1;  /* GNSS_SignalIDs */
static int hf_lpp_ssr_IntegrityCodeBiasBoundsSup_r17 = -1;  /* T_ssr_IntegrityCodeBiasBoundsSup_r17 */
static int hf_lpp_signal_and_tracking_mode_ID_Sup_r16 = -1;  /* GNSS_SignalIDs */
static int hf_lpp_ssr_IntegrityPhaseBiasBoundsSup_r17 = -1;  /* T_ssr_IntegrityPhaseBiasBoundsSup_r17 */
static int hf_lpp_stec_IntegritySup_r17 = -1;     /* T_stec_IntegritySup_r17 */
static int hf_lpp_griddedCorrectionIntegritySup_r17 = -1;  /* T_griddedCorrectionIntegritySup_r17 */
static int hf_lpp_gnssSignalIDs_r16 = -1;         /* GNSS_SignalIDs */
static int hf_lpp_gnss_SupportListReq = -1;       /* BOOLEAN */
static int hf_lpp_assistanceDataSupportListReq = -1;  /* BOOLEAN */
static int hf_lpp_locationVelocityTypesReq = -1;  /* BOOLEAN */
static int hf_lpp_locationServerErrorCauses_01 = -1;  /* GNSS_LocationServerErrorCauses */
static int hf_lpp_targetDeviceErrorCauses_01 = -1;  /* GNSS_TargetDeviceErrorCauses */
static int hf_lpp_cause_02 = -1;                  /* T_cause_02 */
static int hf_lpp_cause_03 = -1;                  /* T_cause_03 */
static int hf_lpp_fineTimeAssistanceMeasurementsNotPossible = -1;  /* NULL */
static int hf_lpp_adrMeasurementsNotPossible = -1;  /* NULL */
static int hf_lpp_multiFrequencyMeasurementsNotPossible = -1;  /* NULL */
static int hf_lpp_gnss_FrequencyID_r15 = -1;      /* INTEGER_0_7 */
static int hf_lpp_gnss_id = -1;                   /* T_gnss_id */
static int hf_lpp_gnss_ids = -1;                  /* T_gnss_ids */
static int hf_lpp_GNSS_Link_CombinationsList_r15_item = -1;  /* GNSS_Link_Combinations_r15 */
static int hf_lpp_GNSS_NavListInfo_r15_item = -1;  /* SatListElement_r15 */
static int hf_lpp_networkID_r15_01 = -1;          /* INTEGER_0_255 */
static int hf_lpp_deliveryAmount_r15 = -1;        /* INTEGER_1_32 */
static int hf_lpp_deliveryInterval_r15 = -1;      /* INTEGER_1_64 */
static int hf_lpp_referenceStationID_r15_01 = -1;  /* INTEGER_0_65535 */
static int hf_lpp_providerName_r15 = -1;          /* VisibleString_SIZE_1_32 */
static int hf_lpp_gnss_SignalID_01 = -1;          /* INTEGER_0_7 */
static int hf_lpp_gnss_SignalID_Ext_r15 = -1;     /* INTEGER_8_23 */
static int hf_lpp_gnss_SignalIDs = -1;            /* BIT_STRING_SIZE_8 */
static int hf_lpp_gnss_SignalIDs_Ext_r15 = -1;    /* BIT_STRING_SIZE_16 */
static int hf_lpp_subNetworkID_r15_01 = -1;       /* INTEGER_0_15 */
static int hf_lpp_sbas_id = -1;                   /* T_sbas_id */
static int hf_lpp_sbas_IDs_01 = -1;               /* T_sbas_IDs */
static int hf_lpp_satellite_id = -1;              /* INTEGER_0_63 */
static int hf_lpp_ecid_SignalMeasurementInformation = -1;  /* ECID_SignalMeasurementInformation */
static int hf_lpp_ecid_Error = -1;                /* ECID_Error */
static int hf_lpp_primaryCellMeasuredResults = -1;  /* MeasuredResultsElement */
static int hf_lpp_measuredResultsList = -1;       /* MeasuredResultsList */
static int hf_lpp_MeasuredResultsList_item = -1;  /* MeasuredResultsElement */
static int hf_lpp_arfcnEUTRA = -1;                /* ARFCN_ValueEUTRA */
static int hf_lpp_rsrp_Result = -1;               /* INTEGER_0_97 */
static int hf_lpp_rsrq_Result = -1;               /* INTEGER_0_34 */
static int hf_lpp_ue_RxTxTimeDiff = -1;           /* INTEGER_0_4095 */
static int hf_lpp_arfcnEUTRA_v9a0 = -1;           /* ARFCN_ValueEUTRA_v9a0 */
static int hf_lpp_nrsrp_Result_r14 = -1;          /* INTEGER_0_113 */
static int hf_lpp_nrsrq_Result_r14 = -1;          /* INTEGER_0_74 */
static int hf_lpp_carrierFreqOffsetNB_r14 = -1;   /* CarrierFreqOffsetNB_r14 */
static int hf_lpp_rsrp_Result_v1470 = -1;         /* INTEGER_M17_M1 */
static int hf_lpp_rsrq_Result_v1470 = -1;         /* INTEGER_M30_46 */
static int hf_lpp_requestedMeasurements = -1;     /* T_requestedMeasurements */
static int hf_lpp_ecid_MeasSupported = -1;        /* T_ecid_MeasSupported */
static int hf_lpp_ueRxTxSupTDD_r13 = -1;          /* T_ueRxTxSupTDD_r13 */
static int hf_lpp_periodicalReporting_r14_01 = -1;  /* T_periodicalReporting_r14_01 */
static int hf_lpp_triggeredReporting_r14 = -1;    /* T_triggeredReporting_r14 */
static int hf_lpp_idleStateForMeasurements_r14_02 = -1;  /* T_idleStateForMeasurements_r14_02 */
static int hf_lpp_locationServerErrorCauses_02 = -1;  /* ECID_LocationServerErrorCauses */
static int hf_lpp_targetDeviceErrorCauses_02 = -1;  /* ECID_TargetDeviceErrorCauses */
static int hf_lpp_cause_04 = -1;                  /* T_cause_04 */
static int hf_lpp_cause_05 = -1;                  /* T_cause_05 */
static int hf_lpp_rsrpMeasurementNotPossible = -1;  /* NULL */
static int hf_lpp_rsrqMeasurementNotPossible = -1;  /* NULL */
static int hf_lpp_ueRxTxMeasurementNotPossible = -1;  /* NULL */
static int hf_lpp_nrsrpMeasurementNotPossible_r14 = -1;  /* NULL */
static int hf_lpp_nrsrqMeasurementNotPossible_r14 = -1;  /* NULL */
static int hf_lpp_tbs_MeasurementInformation_r13 = -1;  /* TBS_MeasurementInformation_r13 */
static int hf_lpp_tbs_Error_r13 = -1;             /* TBS_Error_r13 */
static int hf_lpp_measurementReferenceTime_r13 = -1;  /* UTCTime */
static int hf_lpp_mbs_SgnMeasList_r13 = -1;       /* MBS_BeaconMeasList_r13 */
static int hf_lpp_MBS_BeaconMeasList_r13_item = -1;  /* MBS_BeaconMeasElement_r13 */
static int hf_lpp_transmitterID_r13 = -1;         /* INTEGER_0_32767 */
static int hf_lpp_codePhase_r13 = -1;             /* INTEGER_0_2097151 */
static int hf_lpp_codePhaseRMSError_r13 = -1;     /* INTEGER_0_63 */
static int hf_lpp_rssi_r14 = -1;                  /* INTEGER_M130_M30 */
static int hf_lpp_mbsSgnMeasListReq_r13 = -1;     /* BOOLEAN */
static int hf_lpp_mbsAssistanceAvailability_r14 = -1;  /* BOOLEAN */
static int hf_lpp_mbsRequestedMeasurements_r14 = -1;  /* T_mbsRequestedMeasurements_r14 */
static int hf_lpp_tbs_Modes_r13 = -1;             /* T_tbs_Modes_r13 */
static int hf_lpp_mbs_AssistanceDataSupportList_r14 = -1;  /* MBS_AssistanceDataSupportList_r14 */
static int hf_lpp_periodicalReportingSupported_r14 = -1;  /* PositioningModes */
static int hf_lpp_mbs_ConfigSupport_r14 = -1;     /* T_mbs_ConfigSupport_r14 */
static int hf_lpp_mbs_IdleStateForMeasurements_r14 = -1;  /* T_mbs_IdleStateForMeasurements_r14 */
static int hf_lpp_mbs_AcquisitionAssistanceDataSupport_r14 = -1;  /* BOOLEAN */
static int hf_lpp_mbs_AlmanacAssistanceDataSupport_r14 = -1;  /* BOOLEAN */
static int hf_lpp_locationServerErrorCauses_r13 = -1;  /* TBS_LocationServerErrorCauses_r13 */
static int hf_lpp_targetDeviceErrorCauses_r13 = -1;  /* TBS_TargetDeviceErrorCauses_r13 */
static int hf_lpp_cause_r13 = -1;                 /* T_cause_r13 */
static int hf_lpp_cause_r13_01 = -1;              /* T_cause_r13_01 */
static int hf_lpp_tbs_AssistanceDataList_r14 = -1;  /* TBS_AssistanceDataList_r14 */
static int hf_lpp_tbs_Error_r14 = -1;             /* TBS_Error_r13 */
static int hf_lpp_mbs_AssistanceDataList_r14 = -1;  /* MBS_AssistanceDataList_r14 */
static int hf_lpp_MBS_AssistanceDataList_r14_item = -1;  /* MBS_AssistanceDataElement_r14 */
static int hf_lpp_mbs_AlmanacAssistance_r14 = -1;  /* MBS_AlmanacAssistance_r14 */
static int hf_lpp_mbs_AcquisitionAssistance_r14 = -1;  /* MBS_AcquisitionAssistance_r14 */
static int hf_lpp_transmitterID_r14 = -1;         /* INTEGER_0_32767 */
static int hf_lpp_transmitterLatitude_r14 = -1;   /* T_transmitterLatitude_r14 */
static int hf_lpp_transmitterLongitude_r14 = -1;  /* T_transmitterLongitude_r14 */
static int hf_lpp_transmitterAltitude_r14 = -1;   /* T_transmitterAltitude_r14 */
static int hf_lpp_timeCorrection_r14 = -1;        /* INTEGER_0_25 */
static int hf_lpp_mbsConfiguration_r14 = -1;      /* T_mbsConfiguration_r14 */
static int hf_lpp_pnCodeIndex_r14 = -1;           /* INTEGER_1_128 */
static int hf_lpp_freq_r14 = -1;                  /* INTEGER_919750000_927250000 */
static int hf_lpp_mbs_AlmanacAssistanceDataReq_r14 = -1;  /* BOOLEAN */
static int hf_lpp_mbs_AcquisitionAssistanceDataReq_r14 = -1;  /* BOOLEAN */
static int hf_lpp_sensor_MeasurementInformation_r13 = -1;  /* Sensor_MeasurementInformation_r13 */
static int hf_lpp_sensor_Error_r13 = -1;          /* Sensor_Error_r13 */
static int hf_lpp_sensor_MotionInformation_r15 = -1;  /* Sensor_MotionInformation_r15 */
static int hf_lpp_uncompensatedBarometricPressure_r13 = -1;  /* INTEGER_30000_115000 */
static int hf_lpp_uncertainty_r14 = -1;           /* T_uncertainty_r14 */
static int hf_lpp_range_r14 = -1;                 /* INTEGER_0_1000 */
static int hf_lpp_confidence_r14 = -1;            /* INTEGER_1_100 */
static int hf_lpp_adjustment_r16 = -1;            /* INTEGER_M5000_5000 */
static int hf_lpp_refTime_r15 = -1;               /* DisplacementTimeStamp_r15 */
static int hf_lpp_displacementInfoList_r15 = -1;  /* DisplacementInfoList_r15 */
static int hf_lpp_DisplacementInfoList_r15_item = -1;  /* DisplacementInfoListElement_r15 */
static int hf_lpp_deltaTimeStamp_r15 = -1;        /* DeltaTime_r15 */
static int hf_lpp_displacement_r15 = -1;          /* Displacement_r15 */
static int hf_lpp_utcTime_r15 = -1;               /* UTC_Time_r15 */
static int hf_lpp_gnssTime_r15 = -1;              /* MeasurementReferenceTime */
static int hf_lpp_systemFrameNumber_r15 = -1;     /* SFN_r15 */
static int hf_lpp_measurementSFN_r15 = -1;        /* INTEGER_M8192_9214 */
static int hf_lpp_deltaTimeSec_r15 = -1;          /* INTEGER_1_16384 */
static int hf_lpp_deltaTimeSFN_r15 = -1;          /* INTEGER_1_4096 */
static int hf_lpp_sfn_r15 = -1;                   /* BIT_STRING_SIZE_10 */
static int hf_lpp_hyperSFN_r15 = -1;              /* BIT_STRING_SIZE_10 */
static int hf_lpp_bearing_r15 = -1;               /* INTEGER_0_3599 */
static int hf_lpp_bearingUncConfidence_r15 = -1;  /* INTEGER_0_100 */
static int hf_lpp_bearingRef_r15 = -1;            /* T_bearingRef_r15 */
static int hf_lpp_horizontalDistance_r15 = -1;    /* INTEGER_0_8191 */
static int hf_lpp_horizontalDistanceUnc_r15 = -1;  /* INTEGER_0_255 */
static int hf_lpp_horizontalUncConfidence_r15 = -1;  /* INTEGER_0_100 */
static int hf_lpp_verticalDirection_r15 = -1;     /* T_verticalDirection_r15 */
static int hf_lpp_verticalDistance_r15 = -1;      /* INTEGER_0_8191 */
static int hf_lpp_verticalDistanceUnc_r15 = -1;   /* INTEGER_0_255 */
static int hf_lpp_verticalUncConfidence_r15 = -1;  /* INTEGER_0_100 */
static int hf_lpp_utcTime_r15_01 = -1;            /* UTCTime */
static int hf_lpp_utcTime_ms_r15 = -1;            /* INTEGER_0_999 */
static int hf_lpp_uncompensatedBarometricPressureReq_r13 = -1;  /* BOOLEAN */
static int hf_lpp_assistanceAvailability_r14 = -1;  /* BOOLEAN */
static int hf_lpp_sensor_MotionInformationReq_r15 = -1;  /* BOOLEAN */
static int hf_lpp_adjustmentReq_r16 = -1;         /* BOOLEAN */
static int hf_lpp_sensor_Modes_r13 = -1;          /* T_sensor_Modes_r13 */
static int hf_lpp_sensor_AssistanceDataSupportList_r14 = -1;  /* Sensor_AssistanceDataSupportList_r14 */
static int hf_lpp_idleStateForMeasurements_r14_03 = -1;  /* T_idleStateForMeasurements_r14_03 */
static int hf_lpp_sensor_MotionInformationSup_r15 = -1;  /* T_sensor_MotionInformationSup_r15 */
static int hf_lpp_adjustmentSupported_r16 = -1;   /* T_adjustmentSupported_r16 */
static int hf_lpp_validityPeriodSupported_v1520 = -1;  /* T_validityPeriodSupported_v1520 */
static int hf_lpp_validityAreaSupported_v1520 = -1;  /* T_validityAreaSupported_v1520 */
static int hf_lpp_locationServerErrorCauses_r13_01 = -1;  /* Sensor_LocationServerErrorCauses_r13 */
static int hf_lpp_targetDeviceErrorCauses_r13_01 = -1;  /* Sensor_TargetDeviceErrorCauses_r13 */
static int hf_lpp_cause_r13_02 = -1;              /* T_cause_r13_02 */
static int hf_lpp_cause_r13_03 = -1;              /* T_cause_r13_03 */
static int hf_lpp_sensor_AssistanceDataList_r14 = -1;  /* Sensor_AssistanceDataList_r14 */
static int hf_lpp_sensor_Error_r14 = -1;          /* Sensor_Error_r13 */
static int hf_lpp_refPressure_r14 = -1;           /* INTEGER_M20000_10000 */
static int hf_lpp_refPosition_r14 = -1;           /* EllipsoidPointWithAltitudeAndUncertaintyEllipsoid */
static int hf_lpp_refTemperature_r14 = -1;        /* INTEGER_M64_63 */
static int hf_lpp_period_v1520 = -1;              /* T_period_v1520 */
static int hf_lpp_pressureValidityPeriod_v1520 = -1;  /* PressureValidityPeriod_v1520 */
static int hf_lpp_referencePressureRate_v1520 = -1;  /* INTEGER_M128_127 */
static int hf_lpp_area_v1520 = -1;                /* T_area_v1520 */
static int hf_lpp_pressureValidityArea_v1520 = -1;  /* PressureValidityArea_v1520 */
static int hf_lpp_gN_pressure_v1520 = -1;         /* T_gN_pressure_v1520 */
static int hf_lpp_gE_pressure_v1520 = -1;         /* T_gE_pressure_v1520 */
static int hf_lpp_centerPoint_v1520 = -1;         /* Ellipsoid_Point */
static int hf_lpp_validityAreaWidth_v1520 = -1;   /* INTEGER_1_128 */
static int hf_lpp_validityAreaHeight_v1520 = -1;  /* INTEGER_1_128 */
static int hf_lpp_beginTime_v1520 = -1;           /* GNSS_SystemTime */
static int hf_lpp_beginTimeAlt_v1520 = -1;        /* INTEGER_0_2881 */
static int hf_lpp_duration_v1520 = -1;            /* INTEGER_1_2881 */
static int hf_lpp_wlan_MeasurementInformation_r13 = -1;  /* WLAN_MeasurementInformation_r13 */
static int hf_lpp_wlan_Error_r13 = -1;            /* WLAN_Error_r13 */
static int hf_lpp_wlan_MeasurementList_r13 = -1;  /* WLAN_MeasurementList_r13 */
static int hf_lpp_WLAN_MeasurementList_r13_item = -1;  /* WLAN_MeasurementElement_r13 */
static int hf_lpp_wlan_AP_Identifier_r13 = -1;    /* WLAN_AP_Identifier_r13 */
static int hf_lpp_rssi_r13 = -1;                  /* INTEGER_M127_128 */
static int hf_lpp_rtt_r13 = -1;                   /* WLAN_RTT_r13 */
static int hf_lpp_apChannelFrequency_r13 = -1;    /* INTEGER_0_256 */
static int hf_lpp_servingFlag_r13 = -1;           /* BOOLEAN */
static int hf_lpp_bssid_r13 = -1;                 /* OCTET_STRING_SIZE_6 */
static int hf_lpp_ssid_r13 = -1;                  /* T_ssid_r13 */
static int hf_lpp_rttValue_r13 = -1;              /* INTEGER_0_16777215 */
static int hf_lpp_rttUnits_r13 = -1;              /* T_rttUnits_r13 */
static int hf_lpp_rttAccuracy_r13 = -1;           /* INTEGER_0_255 */
static int hf_lpp_requestedMeasurements_r13 = -1;  /* T_requestedMeasurements_r13 */
static int hf_lpp_wlan_Modes_r13 = -1;            /* T_wlan_Modes_r13 */
static int hf_lpp_wlan_MeasSupported_r13 = -1;    /* T_wlan_MeasSupported_r13 */
static int hf_lpp_wlan_AP_AD_Supported_r14 = -1;  /* T_wlan_AP_AD_Supported_r14 */
static int hf_lpp_idleStateForMeasurements_r14_04 = -1;  /* T_idleStateForMeasurements_r14_04 */
static int hf_lpp_locationServerErrorCauses_r13_02 = -1;  /* WLAN_LocationServerErrorCauses_r13 */
static int hf_lpp_targetDeviceErrorCauses_r13_02 = -1;  /* WLAN_TargetDeviceErrorCauses_r13 */
static int hf_lpp_cause_r13_04 = -1;              /* T_cause_r13_04 */
static int hf_lpp_apLocationDataUnavailable_r14 = -1;  /* NULL */
static int hf_lpp_cause_r13_05 = -1;              /* T_cause_r13_05 */
static int hf_lpp_wlan_AP_RSSI_MeasurementNotPossible_r13 = -1;  /* NULL */
static int hf_lpp_wlan_AP_RTT_MeasurementNotPossible_r13 = -1;  /* NULL */
static int hf_lpp_wlan_DataSet_r14 = -1;          /* SEQUENCE_SIZE_1_maxWLAN_DataSets_r14_OF_WLAN_DataSet_r14 */
static int hf_lpp_wlan_DataSet_r14_item = -1;     /* WLAN_DataSet_r14 */
static int hf_lpp_wlan_Error_r14 = -1;            /* WLAN_Error_r13 */
static int hf_lpp_wlan_AP_List_r14 = -1;          /* SEQUENCE_SIZE_1_maxWLAN_AP_r14_OF_WLAN_AP_Data_r14 */
static int hf_lpp_wlan_AP_List_r14_item = -1;     /* WLAN_AP_Data_r14 */
static int hf_lpp_supportedChannels_11a_r14 = -1;  /* SupportedChannels_11a_r14 */
static int hf_lpp_supportedChannels_11bg_r14 = -1;  /* SupportedChannels_11bg_r14 */
static int hf_lpp_ch34_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch36_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch38_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch40_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch42_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch44_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch46_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch48_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch52_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch56_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch60_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch64_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch149_r14 = -1;                 /* BOOLEAN */
static int hf_lpp_ch153_r14 = -1;                 /* BOOLEAN */
static int hf_lpp_ch157_r14 = -1;                 /* BOOLEAN */
static int hf_lpp_ch161_r14 = -1;                 /* BOOLEAN */
static int hf_lpp_ch1_r14 = -1;                   /* BOOLEAN */
static int hf_lpp_ch2_r14 = -1;                   /* BOOLEAN */
static int hf_lpp_ch3_r14 = -1;                   /* BOOLEAN */
static int hf_lpp_ch4_r14 = -1;                   /* BOOLEAN */
static int hf_lpp_ch5_r14 = -1;                   /* BOOLEAN */
static int hf_lpp_ch6_r14 = -1;                   /* BOOLEAN */
static int hf_lpp_ch7_r14 = -1;                   /* BOOLEAN */
static int hf_lpp_ch8_r14 = -1;                   /* BOOLEAN */
static int hf_lpp_ch9_r14 = -1;                   /* BOOLEAN */
static int hf_lpp_ch10_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch11_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch12_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch13_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_ch14_r14 = -1;                  /* BOOLEAN */
static int hf_lpp_wlan_AP_Identifier_r14 = -1;    /* WLAN_AP_Identifier_r13 */
static int hf_lpp_wlan_AP_Location_r14 = -1;      /* WLAN_AP_Location_r14 */
static int hf_lpp_locationDataLCI_r14 = -1;       /* LocationDataLCI_r14 */
static int hf_lpp_latitudeUncertainty_r14 = -1;   /* BIT_STRING_SIZE_6 */
static int hf_lpp_latitude_r14 = -1;              /* BIT_STRING_SIZE_34 */
static int hf_lpp_longitudeUncertainty_r14 = -1;  /* BIT_STRING_SIZE_6 */
static int hf_lpp_longitude_r14 = -1;             /* BIT_STRING_SIZE_34 */
static int hf_lpp_altitudeUncertainty_r14 = -1;   /* BIT_STRING_SIZE_6 */
static int hf_lpp_altitude_r14 = -1;              /* BIT_STRING_SIZE_30 */
static int hf_lpp_datum_r14 = -1;                 /* BIT_STRING_SIZE_8 */
static int hf_lpp_requestedAD_r14 = -1;           /* T_requestedAD_r14 */
static int hf_lpp_visibleAPs_r14 = -1;            /* SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13 */
static int hf_lpp_visibleAPs_r14_item = -1;       /* WLAN_AP_Identifier_r13 */
static int hf_lpp_wlan_AP_StoredData_r14 = -1;    /* SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13 */
static int hf_lpp_wlan_AP_StoredData_r14_item = -1;  /* WLAN_AP_Identifier_r13 */
static int hf_lpp_bt_MeasurementInformation_r13 = -1;  /* BT_MeasurementInformation_r13 */
static int hf_lpp_bt_Error_r13 = -1;              /* BT_Error_r13 */
static int hf_lpp_bt_MeasurementList_r13 = -1;    /* BT_MeasurementList_r13 */
static int hf_lpp_BT_MeasurementList_r13_item = -1;  /* BT_MeasurementElement_r13 */
static int hf_lpp_btAddr_r13 = -1;                /* T_btAddr_r13 */
static int hf_lpp_rssi_r13_01 = -1;               /* INTEGER_M128_127 */
static int hf_lpp_requestedMeasurements_r13_01 = -1;  /* T_requestedMeasurements_r13_01 */
static int hf_lpp_bt_Modes_r13 = -1;              /* T_bt_Modes_r13 */
static int hf_lpp_bt_MeasSupported_r13 = -1;      /* T_bt_MeasSupported_r13 */
static int hf_lpp_idleStateForMeasurements_r14_05 = -1;  /* T_idleStateForMeasurements_r14_05 */
static int hf_lpp_locationServerErrorCauses_r13_03 = -1;  /* BT_LocationServerErrorCauses_r13 */
static int hf_lpp_targetDeviceErrorCauses_r13_03 = -1;  /* BT_TargetDeviceErrorCauses_r13 */
static int hf_lpp_cause_r13_06 = -1;              /* T_cause_r13_06 */
static int hf_lpp_cause_r13_07 = -1;              /* T_cause_r13_07 */
static int hf_lpp_bt_Beacon_rssiMeasurementNotPossible_r13 = -1;  /* NULL */
static int hf_lpp_nr_UL_SRS_Capability_r16 = -1;  /* NR_UL_SRS_Capability_r16 */
static int hf_lpp_nr_UE_TEG_Capability_r17 = -1;  /* NR_UE_TEG_Capability_r17 */
static int hf_lpp_nr_ECID_SignalMeasurementInformation_r16 = -1;  /* NR_ECID_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_ECID_Error_r16 = -1;         /* NR_ECID_Error_r16 */
static int hf_lpp_nr_PrimaryCellMeasuredResults_r16 = -1;  /* NR_MeasuredResultsElement_r16 */
static int hf_lpp_nr_MeasuredResultsList_r16 = -1;  /* NR_MeasuredResultsList_r16 */
static int hf_lpp_NR_MeasuredResultsList_r16_item = -1;  /* NR_MeasuredResultsElement_r16 */
static int hf_lpp_nr_ARFCN_r16_01 = -1;           /* T_nr_ARFCN_r16 */
static int hf_lpp_ssb_ARFCN_r16 = -1;             /* ARFCN_ValueNR_r15 */
static int hf_lpp_csi_RS_pointA_r16 = -1;         /* ARFCN_ValueNR_r15 */
static int hf_lpp_resultsSSB_Cell_r16 = -1;       /* MeasQuantityResults_r16 */
static int hf_lpp_resultsCSI_RS_Cell_r16 = -1;    /* MeasQuantityResults_r16 */
static int hf_lpp_resultsSSB_Indexes_r16 = -1;    /* ResultsPerSSB_IndexList_r16 */
static int hf_lpp_resultsCSI_RS_Indexes_r16 = -1;  /* ResultsPerCSI_RS_IndexList_r16 */
static int hf_lpp_nr_RSRP_r16 = -1;               /* INTEGER_0_127 */
static int hf_lpp_nr_RSRQ_r16 = -1;               /* INTEGER_0_127 */
static int hf_lpp_ResultsPerSSB_IndexList_r16_item = -1;  /* ResultsPerSSB_Index_r16 */
static int hf_lpp_ssb_Results_r16 = -1;           /* MeasQuantityResults_r16 */
static int hf_lpp_ResultsPerCSI_RS_IndexList_r16_item = -1;  /* ResultsPerCSI_RS_Index_r16 */
static int hf_lpp_csi_RS_Index_r16 = -1;          /* INTEGER_0_95 */
static int hf_lpp_csi_RS_Results_r16 = -1;        /* MeasQuantityResults_r16 */
static int hf_lpp_requestedMeasurements_r16 = -1;  /* T_requestedMeasurements_r16 */
static int hf_lpp_nr_ECID_MeasSupported_r16 = -1;  /* T_nr_ECID_MeasSupported_r16 */
static int hf_lpp_periodicalReporting_r16 = -1;   /* T_periodicalReporting_r16 */
static int hf_lpp_triggeredReporting_r16 = -1;    /* T_triggeredReporting_r16 */
static int hf_lpp_ten_ms_unit_ResponseTime_r17 = -1;  /* T_ten_ms_unit_ResponseTime_r17 */
static int hf_lpp_locationServerErrorCauses_r16 = -1;  /* NR_ECID_LocationServerErrorCauses_r16 */
static int hf_lpp_targetDeviceErrorCauses_r16 = -1;  /* NR_ECID_TargetDeviceErrorCauses_r16 */
static int hf_lpp_cause_r16 = -1;                 /* T_cause_r16 */
static int hf_lpp_cause_r16_01 = -1;              /* T_cause_r16_01 */
static int hf_lpp_ss_RSRPMeasurementNotPossible_r16 = -1;  /* NULL */
static int hf_lpp_ss_RSRQMeasurementNotPossible_r16 = -1;  /* NULL */
static int hf_lpp_csi_RSRPMeasurementNotPossible_r16 = -1;  /* NULL */
static int hf_lpp_csi_RSRQMeasurementNotPossible_r16 = -1;  /* NULL */
static int hf_lpp_nr_DL_PRS_AssistanceData_r16 = -1;  /* NR_DL_PRS_AssistanceData_r16 */
static int hf_lpp_nr_SelectedDL_PRS_IndexList_r16 = -1;  /* NR_SelectedDL_PRS_IndexList_r16 */
static int hf_lpp_nr_PositionCalculationAssistance_r16 = -1;  /* NR_PositionCalculationAssistance_r16 */
static int hf_lpp_nr_DL_TDOA_Error_r16 = -1;      /* NR_DL_TDOA_Error_r16 */
static int hf_lpp_nr_On_Demand_DL_PRS_Configurations_r17 = -1;  /* NR_On_Demand_DL_PRS_Configurations_r17 */
static int hf_lpp_nr_On_Demand_DL_PRS_Configurations_Selected_IndexList_r17 = -1;  /* NR_On_Demand_DL_PRS_Configurations_Selected_IndexList_r17 */
static int hf_lpp_assistanceDataValidityArea_r17 = -1;  /* AreaID_CellList_r17 */
static int hf_lpp_nr_AdType_r16 = -1;             /* T_nr_AdType_r16 */
static int hf_lpp_nr_PosCalcAssistanceRequest_r17 = -1;  /* T_nr_PosCalcAssistanceRequest_r17 */
static int hf_lpp_nr_on_demand_DL_PRS_Request_r17 = -1;  /* NR_On_Demand_DL_PRS_Request_r17 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17 = -1;  /* T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17 */
static int hf_lpp_pre_configured_AssistanceDataRequest_r17 = -1;  /* T_pre_configured_AssistanceDataRequest_r17 */
static int hf_lpp_nr_DL_TDOA_SignalMeasurementInformation_r16 = -1;  /* NR_DL_TDOA_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_dl_tdoa_LocationInformation_r16 = -1;  /* NR_DL_TDOA_LocationInformation_r16 */
static int hf_lpp_nr_DL_TDOA_SignalMeasurementInstances_r17 = -1;  /* SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_TDOA_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_DL_TDOA_SignalMeasurementInstances_r17_item = -1;  /* NR_DL_TDOA_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_DL_TDOA_LocationInformationInstances_r17 = -1;  /* SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_TDOA_LocationInformation_r16 */
static int hf_lpp_nr_DL_TDOA_LocationInformationInstances_r17_item = -1;  /* NR_DL_TDOA_LocationInformation_r16 */
static int hf_lpp_dl_PRS_ReferenceInfo_r16 = -1;  /* DL_PRS_ID_Info_r16 */
static int hf_lpp_nr_DL_TDOA_MeasList_r16 = -1;   /* NR_DL_TDOA_MeasList_r16 */
static int hf_lpp_nr_UE_RxTEG_TimingErrorMargin_r17 = -1;  /* TEG_TimingErrorMargin_r17 */
static int hf_lpp_NR_DL_TDOA_MeasList_r16_item = -1;  /* NR_DL_TDOA_MeasElement_r16 */
static int hf_lpp_nr_TimeStamp_r16 = -1;          /* NR_TimeStamp_r16 */
static int hf_lpp_nr_RSTD_r16 = -1;               /* T_nr_RSTD_r16 */
static int hf_lpp_k0_r16_01 = -1;                 /* INTEGER_0_1970049 */
static int hf_lpp_k1_r16_01 = -1;                 /* INTEGER_0_985025 */
static int hf_lpp_k2_r16_01 = -1;                 /* INTEGER_0_492513 */
static int hf_lpp_k3_r16_01 = -1;                 /* INTEGER_0_246257 */
static int hf_lpp_k4_r16_01 = -1;                 /* INTEGER_0_123129 */
static int hf_lpp_k5_r16_01 = -1;                 /* INTEGER_0_61565 */
static int hf_lpp_nr_AdditionalPathList_r16 = -1;  /* NR_AdditionalPathList_r16 */
static int hf_lpp_nr_TimingQuality_r16 = -1;      /* NR_TimingQuality_r16 */
static int hf_lpp_nr_DL_PRS_RSRP_Result_r16 = -1;  /* INTEGER_0_126 */
static int hf_lpp_nr_DL_TDOA_AdditionalMeasurements_r16 = -1;  /* NR_DL_TDOA_AdditionalMeasurements_r16 */
static int hf_lpp_nr_UE_Rx_TEG_ID_r17 = -1;       /* INTEGER_0_maxNumOfRxTEGs_1_r17 */
static int hf_lpp_nr_DL_PRS_FirstPathRSRP_Result_r17 = -1;  /* INTEGER_0_126 */
static int hf_lpp_nr_los_nlos_Indicator_r17 = -1;  /* T_nr_los_nlos_Indicator_r17 */
static int hf_lpp_perTRP_r17 = -1;                /* LOS_NLOS_Indicator_r17 */
static int hf_lpp_perResource_r17_01 = -1;        /* LOS_NLOS_Indicator_r17 */
static int hf_lpp_nr_AdditionalPathListExt_r17 = -1;  /* NR_AdditionalPathListExt_r17 */
static int hf_lpp_nr_DL_TDOA_AdditionalMeasurementsExt_r17 = -1;  /* NR_DL_TDOA_AdditionalMeasurementsExt_r17 */
static int hf_lpp_NR_DL_TDOA_AdditionalMeasurements_r16_item = -1;  /* NR_DL_TDOA_AdditionalMeasurementElement_r16 */
static int hf_lpp_NR_DL_TDOA_AdditionalMeasurementsExt_r17_item = -1;  /* NR_DL_TDOA_AdditionalMeasurementElement_r16 */
static int hf_lpp_nr_RSTD_ResultDiff_r16 = -1;    /* T_nr_RSTD_ResultDiff_r16 */
static int hf_lpp_k0_r16_02 = -1;                 /* INTEGER_0_8191 */
static int hf_lpp_k1_r16_02 = -1;                 /* INTEGER_0_4095 */
static int hf_lpp_k2_r16_02 = -1;                 /* INTEGER_0_2047 */
static int hf_lpp_k3_r16_02 = -1;                 /* INTEGER_0_1023 */
static int hf_lpp_k4_r16_02 = -1;                 /* INTEGER_0_511 */
static int hf_lpp_k5_r16_02 = -1;                 /* INTEGER_0_255 */
static int hf_lpp_nr_DL_PRS_RSRP_ResultDiff_r16 = -1;  /* INTEGER_0_61 */
static int hf_lpp_nr_DL_PRS_FirstPathRSRP_ResultDiff_r17 = -1;  /* INTEGER_0_61 */
static int hf_lpp_nr_los_nlos_IndicatorPerResource_r17 = -1;  /* LOS_NLOS_Indicator_r17 */
static int hf_lpp_measurementReferenceTime_r16 = -1;  /* T_measurementReferenceTime_r16 */
static int hf_lpp_systemFrameNumber_r16_01 = -1;  /* NR_TimeStamp_r16 */
static int hf_lpp_utc_time_r16 = -1;              /* UTCTime */
static int hf_lpp_locationCoordinates_r17 = -1;   /* LocationCoordinates */
static int hf_lpp_locationSource_r17 = -1;        /* LocationSource_r13 */
static int hf_lpp_nr_DL_PRS_RstdMeasurementInfoRequest_r16 = -1;  /* T_nr_DL_PRS_RstdMeasurementInfoRequest_r16 */
static int hf_lpp_nr_RequestedMeasurements_r16 = -1;  /* T_nr_RequestedMeasurements_r16 */
static int hf_lpp_nr_AssistanceAvailability_r16 = -1;  /* BOOLEAN */
static int hf_lpp_nr_DL_TDOA_ReportConfig_r16 = -1;  /* NR_DL_TDOA_ReportConfig_r16 */
static int hf_lpp_additionalPaths_r16 = -1;       /* T_additionalPaths_r16 */
static int hf_lpp_nr_UE_RxTEG_Request_r17 = -1;   /* T_nr_UE_RxTEG_Request_r17 */
static int hf_lpp_nr_los_nlos_IndicatorRequest_r17 = -1;  /* T_nr_los_nlos_IndicatorRequest_r17 */
static int hf_lpp_type_r17 = -1;                  /* LOS_NLOS_IndicatorType1_r17 */
static int hf_lpp_granularity_r17 = -1;           /* LOS_NLOS_IndicatorGranularity1_r17 */
static int hf_lpp_additionalPathsExt_r17 = -1;    /* T_additionalPathsExt_r17 */
static int hf_lpp_additionalPathsDL_PRS_RSRP_Request_r17 = -1;  /* T_additionalPathsDL_PRS_RSRP_Request_r17 */
static int hf_lpp_multiMeasInSameReport_r17 = -1;  /* T_multiMeasInSameReport_r17 */
static int hf_lpp_maxDL_PRS_RSTD_MeasurementsPerTRP_Pair_r16 = -1;  /* INTEGER_1_4 */
static int hf_lpp_timingReportingGranularityFactor_r16 = -1;  /* INTEGER_0_5 */
static int hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17_01 = -1;  /* T_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17_01 */
static int hf_lpp_reducedDL_PRS_ProcessingSamples_r17 = -1;  /* T_reducedDL_PRS_ProcessingSamples_r17 */
static int hf_lpp_lowerRxBeamSweepingFactor_FR2_r17 = -1;  /* T_lowerRxBeamSweepingFactor_FR2_r17 */
static int hf_lpp_nr_DL_TDOA_Mode_r16 = -1;       /* PositioningModes */
static int hf_lpp_nr_DL_TDOA_PRS_Capability_r16 = -1;  /* NR_DL_PRS_ResourcesCapability_r16 */
static int hf_lpp_nr_DL_TDOA_MeasurementCapability_r16 = -1;  /* NR_DL_TDOA_MeasurementCapability_r16 */
static int hf_lpp_nr_DL_PRS_QCL_ProcessingCapability_r16 = -1;  /* NR_DL_PRS_QCL_ProcessingCapability_r16 */
static int hf_lpp_nr_DL_PRS_ProcessingCapability_r16 = -1;  /* NR_DL_PRS_ProcessingCapability_r16 */
static int hf_lpp_additionalPathsReport_r16 = -1;  /* T_additionalPathsReport_r16 */
static int hf_lpp_periodicalReporting_r16_01 = -1;  /* PositioningModes */
static int hf_lpp_ten_ms_unit_ResponseTime_r17_01 = -1;  /* PositioningModes */
static int hf_lpp_nr_PosCalcAssistanceSupport_r17 = -1;  /* T_nr_PosCalcAssistanceSupport_r17 */
static int hf_lpp_nr_los_nlos_AssistanceDataSupport_r17 = -1;  /* T_nr_los_nlos_AssistanceDataSupport_r17 */
static int hf_lpp_type_r17_01 = -1;               /* LOS_NLOS_IndicatorType2_r17 */
static int hf_lpp_granularity_r17_01 = -1;        /* LOS_NLOS_IndicatorGranularity2_r17 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17 = -1;  /* T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17 */
static int hf_lpp_nr_DL_TDOA_On_Demand_DL_PRS_Support_r17 = -1;  /* NR_On_Demand_DL_PRS_Support_r17 */
static int hf_lpp_nr_los_nlos_IndicatorSupport_r17 = -1;  /* T_nr_los_nlos_IndicatorSupport_r17 */
static int hf_lpp_additionalPathsExtSupport_r17 = -1;  /* T_additionalPathsExtSupport_r17 */
static int hf_lpp_nr_dl_prs_AssistanceDataValidity_r17 = -1;  /* T_nr_dl_prs_AssistanceDataValidity_r17 */
static int hf_lpp_area_validity_r17 = -1;         /* INTEGER_1_maxNrOfAreas_r17 */
static int hf_lpp_multiMeasInSameMeasReport_r17 = -1;  /* T_multiMeasInSameMeasReport_r17 */
static int hf_lpp_mg_ActivationRequest_r17 = -1;  /* T_mg_ActivationRequest_r17 */
static int hf_lpp_posMeasGapSupport_r17 = -1;     /* T_posMeasGapSupport_r17 */
static int hf_lpp_dl_RSTD_MeasurementPerPairOfTRP_FR1_r16 = -1;  /* INTEGER_1_4 */
static int hf_lpp_dl_RSTD_MeasurementPerPairOfTRP_FR2_r16 = -1;  /* INTEGER_1_4 */
static int hf_lpp_supportOfDL_PRS_RSRP_MeasFR1_r16 = -1;  /* T_supportOfDL_PRS_RSRP_MeasFR1_r16 */
static int hf_lpp_supportOfDL_PRS_RSRP_MeasFR2_r16 = -1;  /* T_supportOfDL_PRS_RSRP_MeasFR2_r16 */
static int hf_lpp_dl_tdoa_MeasCapabilityBandList_r17 = -1;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17 */
static int hf_lpp_dl_tdoa_MeasCapabilityBandList_r17_item = -1;  /* DL_TDOA_MeasCapabilityPerBand_r17 */
static int hf_lpp_supportOfDL_PRS_FirstPathRSRP_r17 = -1;  /* T_supportOfDL_PRS_FirstPathRSRP_r17 */
static int hf_lpp_dl_PRS_MeasRRC_Inactive_r17 = -1;  /* T_dl_PRS_MeasRRC_Inactive_r17 */
static int hf_lpp_locationServerErrorCauses_r16_01 = -1;  /* NR_DL_TDOA_LocationServerErrorCauses_r16 */
static int hf_lpp_targetDeviceErrorCauses_r16_01 = -1;  /* NR_DL_TDOA_TargetDeviceErrorCauses_r16 */
static int hf_lpp_cause_r16_02 = -1;              /* T_cause_r16_02 */
static int hf_lpp_cause_r16_03 = -1;              /* T_cause_r16_03 */
static int hf_lpp_nr_DL_AoD_Error_r16 = -1;       /* NR_DL_AoD_Error_r16 */
static int hf_lpp_nr_DL_PRS_BeamInfo_r17 = -1;    /* NR_DL_PRS_BeamInfo_r16 */
static int hf_lpp_nr_AdType_r16_01 = -1;          /* T_nr_AdType_r16_01 */
static int hf_lpp_nr_PosCalcAssistanceRequest_r17_01 = -1;  /* T_nr_PosCalcAssistanceRequest_r17_01 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_01 = -1;  /* T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_01 */
static int hf_lpp_nr_DL_PRS_BeamInfoRequest_r17 = -1;  /* T_nr_DL_PRS_BeamInfoRequest_r17 */
static int hf_lpp_pre_configured_AssistanceDataRequest_r17_01 = -1;  /* T_pre_configured_AssistanceDataRequest_r17_01 */
static int hf_lpp_nr_DL_AoD_SignalMeasurementInformation_r16 = -1;  /* NR_DL_AoD_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_dl_AoD_LocationInformation_r16 = -1;  /* NR_DL_AoD_LocationInformation_r16 */
static int hf_lpp_nr_DL_AoD_SignalMeasurementInstances_r17 = -1;  /* SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_AoD_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_DL_AoD_SignalMeasurementInstances_r17_item = -1;  /* NR_DL_AoD_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_DL_AoD_LocationInformationInstances_r17 = -1;  /* SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_AoD_LocationInformation_r16 */
static int hf_lpp_nr_DL_AoD_LocationInformationInstances_r17_item = -1;  /* NR_DL_AoD_LocationInformation_r16 */
static int hf_lpp_nr_DL_AoD_MeasList_r16 = -1;    /* NR_DL_AoD_MeasList_r16 */
static int hf_lpp_NR_DL_AoD_MeasList_r16_item = -1;  /* NR_DL_AoD_MeasElement_r16 */
static int hf_lpp_nr_DL_PRS_RxBeamIndex_r16 = -1;  /* INTEGER_1_8 */
static int hf_lpp_nr_DL_AoD_AdditionalMeasurements_r16 = -1;  /* NR_DL_AoD_AdditionalMeasurements_r16 */
static int hf_lpp_nr_los_nlos_Indicator_r17_01 = -1;  /* T_nr_los_nlos_Indicator_r17_01 */
static int hf_lpp_nr_DL_AoD_AdditionalMeasurementsExt_r17 = -1;  /* NR_DL_AoD_AdditionalMeasurementsExt_r17 */
static int hf_lpp_NR_DL_AoD_AdditionalMeasurements_r16_item = -1;  /* NR_DL_AoD_AdditionalMeasurementElement_r16 */
static int hf_lpp_NR_DL_AoD_AdditionalMeasurementsExt_r17_item = -1;  /* NR_DL_AoD_AdditionalMeasurementElement_r17 */
static int hf_lpp_nr_DL_PRS_RSRP_ResultDiff_r16_01 = -1;  /* INTEGER_0_30 */
static int hf_lpp_nr_DL_PRS_ResourceID_r17 = -1;  /* NR_DL_PRS_ResourceID_r16 */
static int hf_lpp_nr_TimeStamp_r17 = -1;          /* NR_TimeStamp_r16 */
static int hf_lpp_nr_DL_PRS_RSRP_ResultDiff_r17 = -1;  /* INTEGER_0_30 */
static int hf_lpp_nr_DL_PRS_RxBeamIndex_r17 = -1;  /* INTEGER_1_8 */
static int hf_lpp_measurementReferenceTime_r16_01 = -1;  /* T_measurementReferenceTime_r16_01 */
static int hf_lpp_sfn_time_r16 = -1;              /* NR_TimeStamp_r16 */
static int hf_lpp_nr_DL_AoD_ReportConfig_r16 = -1;  /* NR_DL_AoD_ReportConfig_r16 */
static int hf_lpp_multiMeasInSameReport_r17_01 = -1;  /* T_multiMeasInSameReport_r17_01 */
static int hf_lpp_maxDL_PRS_RSRP_MeasurementsPerTRP_r16 = -1;  /* INTEGER_1_8 */
static int hf_lpp_maxDL_PRS_RSRP_MeasurementsPerTRP_r17 = -1;  /* INTEGER_9_24 */
static int hf_lpp_maxDL_PRS_RSRPP_MeasurementsPerTRP_r17 = -1;  /* INTEGER_1_24 */
static int hf_lpp_nr_los_nlos_IndicatorRequest_r17_01 = -1;  /* T_nr_los_nlos_IndicatorRequest_r17_01 */
static int hf_lpp_reducedDL_PRS_ProcessingSamples_r17_01 = -1;  /* T_reducedDL_PRS_ProcessingSamples_r17_01 */
static int hf_lpp_lowerRxBeamSweepingFactor_FR2_r17_01 = -1;  /* T_lowerRxBeamSweepingFactor_FR2_r17_01 */
static int hf_lpp_nr_DL_AoD_Mode_r16 = -1;        /* PositioningModes */
static int hf_lpp_nr_DL_AoD_PRS_Capability_r16 = -1;  /* NR_DL_PRS_ResourcesCapability_r16 */
static int hf_lpp_nr_DL_AoD_MeasurementCapability_r16 = -1;  /* NR_DL_AoD_MeasurementCapability_r16 */
static int hf_lpp_nr_PosCalcAssistanceSupport_r17_01 = -1;  /* T_nr_PosCalcAssistanceSupport_r17_01 */
static int hf_lpp_nr_los_nlos_AssistanceDataSupport_r17_01 = -1;  /* T_nr_los_nlos_AssistanceDataSupport_r17_01 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01 = -1;  /* T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01 */
static int hf_lpp_dl_PRS_ResourcePrioritySubset_Sup_r17 = -1;  /* T_dl_PRS_ResourcePrioritySubset_Sup_r17 */
static int hf_lpp_nr_DL_PRS_BeamInfoSup_r17 = -1;  /* T_nr_DL_PRS_BeamInfoSup_r17 */
static int hf_lpp_nr_DL_AoD_On_Demand_DL_PRS_Support_r17 = -1;  /* NR_On_Demand_DL_PRS_Support_r17 */
static int hf_lpp_nr_los_nlos_IndicatorSupport_r17_01 = -1;  /* T_nr_los_nlos_IndicatorSupport_r17_01 */
static int hf_lpp_nr_dl_prs_AssistanceDataValidity_r17_01 = -1;  /* T_nr_dl_prs_AssistanceDataValidity_r17_01 */
static int hf_lpp_multiMeasInSameMeasReport_r17_01 = -1;  /* T_multiMeasInSameMeasReport_r17_01 */
static int hf_lpp_mg_ActivationRequest_r17_01 = -1;  /* T_mg_ActivationRequest_r17_01 */
static int hf_lpp_posMeasGapSupport_r17_01 = -1;  /* T_posMeasGapSupport_r17_01 */
static int hf_lpp_maxDL_PRS_RSRP_MeasurementFR1_r16 = -1;  /* INTEGER_1_8 */
static int hf_lpp_maxDL_PRS_RSRP_MeasurementFR2_r16 = -1;  /* INTEGER_1_8 */
static int hf_lpp_dl_AoD_MeasCapabilityBandList_r16 = -1;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16 */
static int hf_lpp_dl_AoD_MeasCapabilityBandList_r16_item = -1;  /* DL_AoD_MeasCapabilityPerBand_r16 */
static int hf_lpp_maxDL_PRS_RSRP_MeasurementFR1_v1730 = -1;  /* T_maxDL_PRS_RSRP_MeasurementFR1_v1730 */
static int hf_lpp_maxDL_PRS_RSRP_MeasurementFR2_v1730 = -1;  /* T_maxDL_PRS_RSRP_MeasurementFR2_v1730 */
static int hf_lpp_simul_NR_DL_AoD_DL_TDOA_r16 = -1;  /* T_simul_NR_DL_AoD_DL_TDOA_r16 */
static int hf_lpp_simul_NR_DL_AoD_Multi_RTT_r16 = -1;  /* T_simul_NR_DL_AoD_Multi_RTT_r16 */
static int hf_lpp_maxDL_PRS_FirstPathRSRP_MeasPerTRP_r17 = -1;  /* T_maxDL_PRS_FirstPathRSRP_MeasPerTRP_r17 */
static int hf_lpp_dl_PRS_MeasRRC_Inactive_r17_01 = -1;  /* T_dl_PRS_MeasRRC_Inactive_r17_01 */
static int hf_lpp_locationServerErrorCauses_r16_02 = -1;  /* NR_DL_AoD_LocationServerErrorCauses_r16 */
static int hf_lpp_targetDeviceErrorCauses_r16_02 = -1;  /* NR_DL_AoD_TargetDeviceErrorCauses_r16 */
static int hf_lpp_cause_r16_04 = -1;              /* T_cause_r16_04 */
static int hf_lpp_cause_r16_05 = -1;              /* T_cause_r16_05 */
static int hf_lpp_nr_Multi_RTT_Error_r16 = -1;    /* NR_Multi_RTT_Error_r16 */
static int hf_lpp_nr_AdType_r16_02 = -1;          /* T_nr_AdType_r16_02 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_02 = -1;  /* T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_02 */
static int hf_lpp_pre_configured_AssistanceDataRequest_r17_02 = -1;  /* T_pre_configured_AssistanceDataRequest_r17_02 */
static int hf_lpp_nr_Multi_RTT_SignalMeasurementInformation_r16 = -1;  /* NR_Multi_RTT_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_Multi_RTT_SignalMeasurementInstances_r17 = -1;  /* SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_Multi_RTT_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_Multi_RTT_SignalMeasurementInstances_r17_item = -1;  /* NR_Multi_RTT_SignalMeasurementInformation_r16 */
static int hf_lpp_nr_Multi_RTT_MeasList_r16 = -1;  /* NR_Multi_RTT_MeasList_r16 */
static int hf_lpp_nr_NTA_Offset_r16 = -1;         /* T_nr_NTA_Offset_r16 */
static int hf_lpp_nr_SRS_TxTEG_Set_r17 = -1;      /* SEQUENCE_SIZE_1_maxTxTEG_Sets_r17_OF_NR_SRS_TxTEG_Element_r17 */
static int hf_lpp_nr_SRS_TxTEG_Set_r17_item = -1;  /* NR_SRS_TxTEG_Element_r17 */
static int hf_lpp_nr_UE_TxTEG_TimingErrorMargin_r17 = -1;  /* TEG_TimingErrorMargin_r17 */
static int hf_lpp_nr_UE_RxTxTEG_TimingErrorMargin_r17 = -1;  /* RxTxTEG_TimingErrorMargin_r17 */
static int hf_lpp_NR_Multi_RTT_MeasList_r16_item = -1;  /* NR_Multi_RTT_MeasElement_r16 */
static int hf_lpp_nr_UE_RxTxTimeDiff_r16 = -1;    /* T_nr_UE_RxTxTimeDiff_r16 */
static int hf_lpp_nr_Multi_RTT_AdditionalMeasurements_r16 = -1;  /* NR_Multi_RTT_AdditionalMeasurements_r16 */
static int hf_lpp_nr_UE_RxTx_TEG_Info_r17 = -1;   /* NR_UE_RxTx_TEG_Info_r17 */
static int hf_lpp_nr_los_nlos_Indicator_r17_02 = -1;  /* T_nr_los_nlos_Indicator_r17_02 */
static int hf_lpp_nr_Multi_RTT_AdditionalMeasurementsExt_r17 = -1;  /* NR_Multi_RTT_AdditionalMeasurementsExt_r17 */
static int hf_lpp_NR_Multi_RTT_AdditionalMeasurements_r16_item = -1;  /* NR_Multi_RTT_AdditionalMeasurementElement_r16 */
static int hf_lpp_NR_Multi_RTT_AdditionalMeasurementsExt_r17_item = -1;  /* NR_Multi_RTT_AdditionalMeasurementElement_r16 */
static int hf_lpp_nr_UE_RxTxTimeDiffAdditional_r16 = -1;  /* T_nr_UE_RxTxTimeDiffAdditional_r16 */
static int hf_lpp_nr_UE_Tx_TEG_ID_r17 = -1;       /* INTEGER_0_maxNumOfTxTEGs_1_r17 */
static int hf_lpp_carrierFreq_r17 = -1;           /* T_carrierFreq_r17 */
static int hf_lpp_absoluteFrequencyPointA_r17 = -1;  /* ARFCN_ValueNR_r15 */
static int hf_lpp_offsetToPointA_r17 = -1;        /* INTEGER_0_2199 */
static int hf_lpp_srs_PosResourceList_r17 = -1;   /* T_srs_PosResourceList_r17 */
static int hf_lpp_srs_PosResourceList_r17_item = -1;  /* INTEGER_0_maxNumOfSRS_PosResources_1_r17 */
static int hf_lpp_case1_r17 = -1;                 /* T_case1_r17 */
static int hf_lpp_nr_UE_RxTx_TEG_ID_r17 = -1;     /* INTEGER_0_maxNumOfRxTxTEGs_1_r17 */
static int hf_lpp_case2_r17 = -1;                 /* T_case2_r17 */
static int hf_lpp_nr_UE_Tx_TEG_Index_r17 = -1;    /* INTEGER_1_maxTxTEG_Sets_r17 */
static int hf_lpp_case3_r17 = -1;                 /* T_case3_r17 */
static int hf_lpp_nr_UE_RxTxTimeDiffMeasurementInfoRequest_r16 = -1;  /* T_nr_UE_RxTxTimeDiffMeasurementInfoRequest_r16 */
static int hf_lpp_nr_RequestedMeasurements_r16_01 = -1;  /* T_nr_RequestedMeasurements_r16_01 */
static int hf_lpp_nr_Multi_RTT_ReportConfig_r16 = -1;  /* NR_Multi_RTT_ReportConfig_r16 */
static int hf_lpp_additionalPaths_r16_01 = -1;    /* T_additionalPaths_r16_01 */
static int hf_lpp_nr_UE_RxTxTEG_Request_r17 = -1;  /* T_nr_UE_RxTxTEG_Request_r17 */
static int hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTxTEGs_r17 = -1;  /* T_measureSameDL_PRS_ResourceWithDifferentRxTxTEGs_r17 */
static int hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17_02 = -1;  /* T_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17_02 */
static int hf_lpp_reducedDL_PRS_ProcessingSamples_r17_02 = -1;  /* T_reducedDL_PRS_ProcessingSamples_r17_02 */
static int hf_lpp_nr_los_nlos_IndicatorRequest_r17_02 = -1;  /* T_nr_los_nlos_IndicatorRequest_r17_02 */
static int hf_lpp_additionalPathsExt_r17_01 = -1;  /* T_additionalPathsExt_r17_01 */
static int hf_lpp_additionalPathsDL_PRS_RSRP_Request_r17_01 = -1;  /* T_additionalPathsDL_PRS_RSRP_Request_r17_01 */
static int hf_lpp_multiMeasInSameReport_r17_02 = -1;  /* T_multiMeasInSameReport_r17_02 */
static int hf_lpp_lowerRxBeamSweepingFactor_FR2_r17_02 = -1;  /* T_lowerRxBeamSweepingFactor_FR2_r17_02 */
static int hf_lpp_maxDL_PRS_RxTxTimeDiffMeasPerTRP_r16 = -1;  /* INTEGER_1_4 */
static int hf_lpp_nr_Multi_RTT_PRS_Capability_r16 = -1;  /* NR_DL_PRS_ResourcesCapability_r16 */
static int hf_lpp_nr_Multi_RTT_MeasurementCapability_r16 = -1;  /* NR_Multi_RTT_MeasurementCapability_r16 */
static int hf_lpp_additionalPathsReport_r16_01 = -1;  /* T_additionalPathsReport_r16_01 */
static int hf_lpp_periodicalReporting_r16_02 = -1;  /* T_periodicalReporting_r16_01 */
static int hf_lpp_ten_ms_unit_ResponseTime_r17_02 = -1;  /* T_ten_ms_unit_ResponseTime_r17_01 */
static int hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02 = -1;  /* T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02 */
static int hf_lpp_nr_Multi_RTT_On_Demand_DL_PRS_Support_r17 = -1;  /* NR_On_Demand_DL_PRS_Support_r17 */
static int hf_lpp_nr_UE_RxTx_TEG_ID_ReportingSupport_r17 = -1;  /* T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17 */
static int hf_lpp_nr_los_nlos_IndicatorSupport_r17_02 = -1;  /* T_nr_los_nlos_IndicatorSupport_r17_02 */
static int hf_lpp_additionalPathsExtSupport_r17_01 = -1;  /* T_additionalPathsExtSupport_r17_01 */
static int hf_lpp_nr_dl_prs_AssistanceDataValidity_r17_02 = -1;  /* T_nr_dl_prs_AssistanceDataValidity_r17_02 */
static int hf_lpp_multiMeasInSameMeasReport_r17_02 = -1;  /* T_multiMeasInSameMeasReport_r17_02 */
static int hf_lpp_mg_ActivationRequest_r17_02 = -1;  /* T_mg_ActivationRequest_r17_02 */
static int hf_lpp_posMeasGapSupport_r17_02 = -1;  /* T_posMeasGapSupport_r17_02 */
static int hf_lpp_maxNrOfRx_TX_MeasFR1_r16 = -1;  /* INTEGER_1_4 */
static int hf_lpp_maxNrOfRx_TX_MeasFR2_r16 = -1;  /* INTEGER_1_4 */
static int hf_lpp_supportOfRSRP_MeasFR1_r16 = -1;  /* T_supportOfRSRP_MeasFR1_r16 */
static int hf_lpp_supportOfRSRP_MeasFR2_r16 = -1;  /* T_supportOfRSRP_MeasFR2_r16 */
static int hf_lpp_srs_AssocPRS_MultiLayersFR1_r16 = -1;  /* T_srs_AssocPRS_MultiLayersFR1_r16 */
static int hf_lpp_srs_AssocPRS_MultiLayersFR2_r16 = -1;  /* T_srs_AssocPRS_MultiLayersFR2_r16 */
static int hf_lpp_multi_RTT_MeasCapabilityBandList_r17 = -1;  /* SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17 */
static int hf_lpp_multi_RTT_MeasCapabilityBandList_r17_item = -1;  /* Multi_RTT_MeasCapabilityPerBand_r17 */
static int hf_lpp_supportOfDL_PRS_FirstPathRSRP_r17_01 = -1;  /* T_supportOfDL_PRS_FirstPathRSRP_r17_01 */
static int hf_lpp_dl_PRS_MeasRRC_Inactive_r17_02 = -1;  /* T_dl_PRS_MeasRRC_Inactive_r17_02 */
static int hf_lpp_locationServerErrorCauses_r16_03 = -1;  /* NR_Multi_RTT_LocationServerErrorCauses_r16 */
static int hf_lpp_targetDeviceErrorCauses_r16_03 = -1;  /* NR_Multi_RTT_TargetDeviceErrorCauses_r16 */
static int hf_lpp_cause_r16_06 = -1;              /* T_cause_r16_06 */
static int hf_lpp_cause_r16_07 = -1;              /* T_cause_r16_07 */
static int hf_lpp_valueTag_r15 = -1;              /* INTEGER_0_63 */
static int hf_lpp_expirationTime_r15 = -1;        /* UTCTime */
static int hf_lpp_cipheringKeyData_r15 = -1;      /* CipheringKeyData_r15 */
static int hf_lpp_segmentationInfo_r15 = -1;      /* SegmentationInfo_r15 */
static int hf_lpp_assistanceDataElement_r15 = -1;  /* T_assistanceDataElement_r15 */
static int hf_lpp_cipherSetID_r15 = -1;           /* INTEGER_0_65535 */
static int hf_lpp_d0_r15 = -1;                    /* BIT_STRING_SIZE_1_128 */
static int hf_lpp_segmentationOption_r15 = -1;    /* T_segmentationOption_r15 */
static int hf_lpp_assistanceDataSegmentType_r15 = -1;  /* T_assistanceDataSegmentType_r15 */
static int hf_lpp_assistanceDataSegmentNumber_r15 = -1;  /* INTEGER_0_63 */
static int hf_lpp_otdoa_ReferenceCellInfo_r15 = -1;  /* OTDOA_ReferenceCellInfo */
static int hf_lpp_otdoa_NeighbourCellInfo_r15 = -1;  /* OTDOA_NeighbourCellInfoList */
static int hf_lpp_nr_trp_LocationInfo_r16 = -1;   /* NR_TRP_LocationInfo_r16 */
static int hf_lpp_nr_dl_prs_BeamInfo_r16 = -1;    /* NR_DL_PRS_BeamInfo_r16 */
static int hf_lpp_nr_rtd_Info_r16 = -1;           /* NR_RTD_Info_r16 */
/* named bits */
static int hf_lpp_T_accessTypes_eutra = -1;
static int hf_lpp_T_accessTypes_utra = -1;
static int hf_lpp_T_accessTypes_gsm = -1;
static int hf_lpp_T_accessTypes_nb_iot = -1;
static int hf_lpp_T_accessTypes_nr_v1510 = -1;
static int hf_lpp_UpdateCapabilities_r15_primaryCellID_r15 = -1;
static int hf_lpp_T_posModes_standalone = -1;
static int hf_lpp_T_posModes_ue_based = -1;
static int hf_lpp_T_posModes_ue_assisted = -1;
static int hf_lpp_T_lpp_message_segmentation_req_r14_serverToTarget = -1;
static int hf_lpp_T_lpp_message_segmentation_req_r14_targetToServer = -1;
static int hf_lpp_T_lpp_message_segmentation_r14_serverToTarget = -1;
static int hf_lpp_T_lpp_message_segmentation_r14_targetToServer = -1;
static int hf_lpp_LocationSource_r13_a_gnss = -1;
static int hf_lpp_LocationSource_r13_wlan = -1;
static int hf_lpp_LocationSource_r13_bt = -1;
static int hf_lpp_LocationSource_r13_tbs = -1;
static int hf_lpp_LocationSource_r13_sensor = -1;
static int hf_lpp_LocationSource_r13_ha_gnss_v1510 = -1;
static int hf_lpp_LocationSource_r13_motion_sensor_v1550 = -1;
static int hf_lpp_LocationSource_r13_dl_tdoa_r16 = -1;
static int hf_lpp_LocationSource_r13_dl_aod_r16 = -1;
static int hf_lpp_T_adType_r14_prs = -1;
static int hf_lpp_T_adType_r14_nprs = -1;
static int hf_lpp_T_otdoa_Mode_ue_assisted = -1;
static int hf_lpp_T_otdoa_Mode_ue_assisted_NB_r14 = -1;
static int hf_lpp_T_otdoa_Mode_ue_assisted_NB_TDD_r15 = -1;
static int hf_lpp_T_orbit_IntegrityReq_r17_correlationTimeReq = -1;
static int hf_lpp_T_stec_IntegrityReq_r17_correlationTimeReq = -1;
static int hf_lpp_T_periodicAssistanceData_r15_solicited = -1;
static int hf_lpp_T_periodicAssistanceData_r15_unsolicited = -1;
static int hf_lpp_T_ionoModel_klobuchar = -1;
static int hf_lpp_T_ionoModel_neQuick = -1;
static int hf_lpp_T_ionoModel_klobuchar2_r16 = -1;
static int hf_lpp_T_clockModel_model_1 = -1;
static int hf_lpp_T_clockModel_model_2 = -1;
static int hf_lpp_T_clockModel_model_3 = -1;
static int hf_lpp_T_clockModel_model_4 = -1;
static int hf_lpp_T_clockModel_model_5 = -1;
static int hf_lpp_T_clockModel_model_6 = -1;
static int hf_lpp_T_clockModel_model_7_r16 = -1;
static int hf_lpp_T_clockModel_model_8_r16 = -1;
static int hf_lpp_T_orbitModel_model_1 = -1;
static int hf_lpp_T_orbitModel_model_2 = -1;
static int hf_lpp_T_orbitModel_model_3 = -1;
static int hf_lpp_T_orbitModel_model_4 = -1;
static int hf_lpp_T_orbitModel_model_5 = -1;
static int hf_lpp_T_orbitModel_model_6 = -1;
static int hf_lpp_T_orbitModel_model_7_r16 = -1;
static int hf_lpp_T_orbitModel_model_8_r16 = -1;
static int hf_lpp_T_almanacModel_model_1 = -1;
static int hf_lpp_T_almanacModel_model_2 = -1;
static int hf_lpp_T_almanacModel_model_3 = -1;
static int hf_lpp_T_almanacModel_model_4 = -1;
static int hf_lpp_T_almanacModel_model_5 = -1;
static int hf_lpp_T_almanacModel_model_6 = -1;
static int hf_lpp_T_almanacModel_model_7 = -1;
static int hf_lpp_T_utc_Model_model_1 = -1;
static int hf_lpp_T_utc_Model_model_2 = -1;
static int hf_lpp_T_utc_Model_model_3 = -1;
static int hf_lpp_T_utc_Model_model_4 = -1;
static int hf_lpp_T_utc_Model_model_5 = -1;
static int hf_lpp_T_orbit_IntegritySup_r17_correlationTimeSup = -1;
static int hf_lpp_T_stec_IntegritySup_r17_correlationTimeSup = -1;
static int hf_lpp_T_gnss_ids_gps = -1;
static int hf_lpp_T_gnss_ids_sbas = -1;
static int hf_lpp_T_gnss_ids_qzss = -1;
static int hf_lpp_T_gnss_ids_galileo = -1;
static int hf_lpp_T_gnss_ids_glonass = -1;
static int hf_lpp_T_gnss_ids_bds = -1;
static int hf_lpp_T_gnss_ids_navic_v1610 = -1;
static int hf_lpp_T_sbas_IDs_waas = -1;
static int hf_lpp_T_sbas_IDs_egnos = -1;
static int hf_lpp_T_sbas_IDs_msas = -1;
static int hf_lpp_T_sbas_IDs_gagan = -1;
static int hf_lpp_T_requestedMeasurements_rsrpReq = -1;
static int hf_lpp_T_requestedMeasurements_rsrqReq = -1;
static int hf_lpp_T_requestedMeasurements_ueRxTxReq = -1;
static int hf_lpp_T_requestedMeasurements_nrsrpReq_r14 = -1;
static int hf_lpp_T_requestedMeasurements_nrsrqReq_r14 = -1;
static int hf_lpp_T_ecid_MeasSupported_rsrpSup = -1;
static int hf_lpp_T_ecid_MeasSupported_rsrqSup = -1;
static int hf_lpp_T_ecid_MeasSupported_ueRxTxSup = -1;
static int hf_lpp_T_ecid_MeasSupported_nrsrpSup_r14 = -1;
static int hf_lpp_T_ecid_MeasSupported_nrsrqSup_r14 = -1;
static int hf_lpp_T_mbsRequestedMeasurements_r14_rssi = -1;
static int hf_lpp_T_tbs_Modes_r13_standalone = -1;
static int hf_lpp_T_tbs_Modes_r13_ue_assisted = -1;
static int hf_lpp_T_tbs_Modes_r13_ue_based = -1;
static int hf_lpp_T_mbs_ConfigSupport_r14_tb1 = -1;
static int hf_lpp_T_mbs_ConfigSupport_r14_tb2 = -1;
static int hf_lpp_T_mbs_ConfigSupport_r14_tb3 = -1;
static int hf_lpp_T_mbs_ConfigSupport_r14_tb4 = -1;
static int hf_lpp_T_sensor_Modes_r13_standalone = -1;
static int hf_lpp_T_sensor_Modes_r13_ue_assisted = -1;
static int hf_lpp_T_sensor_Modes_r13_ue_based = -1;
static int hf_lpp_T_requestedMeasurements_r13_rssi = -1;
static int hf_lpp_T_requestedMeasurements_r13_rtt = -1;
static int hf_lpp_T_wlan_Modes_r13_standalone = -1;
static int hf_lpp_T_wlan_Modes_r13_ue_assisted = -1;
static int hf_lpp_T_wlan_Modes_r13_ue_based = -1;
static int hf_lpp_T_wlan_MeasSupported_r13_rssi_r13 = -1;
static int hf_lpp_T_wlan_MeasSupported_r13_rtt_r13 = -1;
static int hf_lpp_T_wlan_AP_AD_Supported_r14_ap_identifier = -1;
static int hf_lpp_T_wlan_AP_AD_Supported_r14_ap_location = -1;
static int hf_lpp_T_requestedAD_r14_ap_identifier = -1;
static int hf_lpp_T_requestedAD_r14_ap_location = -1;
static int hf_lpp_T_requestedMeasurements_r13_01_rssi = -1;
static int hf_lpp_T_bt_Modes_r13_standalone = -1;
static int hf_lpp_T_bt_Modes_r13_ue_assisted = -1;
static int hf_lpp_T_bt_MeasSupported_r13_rssi_r13 = -1;
static int hf_lpp_T_requestedMeasurements_r16_ssrsrpReq = -1;
static int hf_lpp_T_requestedMeasurements_r16_ssrsrqReq = -1;
static int hf_lpp_T_requestedMeasurements_r16_csirsrpReq = -1;
static int hf_lpp_T_requestedMeasurements_r16_csirsrqReq = -1;
static int hf_lpp_T_nr_ECID_MeasSupported_r16_ssrsrpSup = -1;
static int hf_lpp_T_nr_ECID_MeasSupported_r16_ssrsrqSup = -1;
static int hf_lpp_T_nr_ECID_MeasSupported_r16_csirsrpSup = -1;
static int hf_lpp_T_nr_ECID_MeasSupported_r16_csirsrqSup = -1;
static int hf_lpp_T_nr_AdType_r16_dl_prs = -1;
static int hf_lpp_T_nr_AdType_r16_posCalc = -1;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_trpLoc = -1;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_beamInfo = -1;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_rtdInfo = -1;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_losNlosInfo = -1;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_trpTEG_Info = -1;
static int hf_lpp_T_nr_RequestedMeasurements_r16_prsrsrpReq = -1;
static int hf_lpp_T_nr_RequestedMeasurements_r16_firstPathRsrpReq_r17 = -1;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_trpLocSup = -1;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_beamInfoSup = -1;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_rtdInfoSup = -1;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_trpTEG_InfoSup = -1;
static int hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_eAoD = -1;
static int hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_eAoA = -1;
static int hf_lpp_T_nr_AdType_r16_01_dl_prs = -1;
static int hf_lpp_T_nr_AdType_r16_01_posCalc = -1;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_trpLoc = -1;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_beamInfo = -1;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_rtdInfo = -1;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_beamAntInfo = -1;
static int hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_losNlosInfo = -1;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_trpLocSup = -1;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_beamInfoSup = -1;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_rtdInfoSup = -1;
static int hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_beamAntInfoSup = -1;
static int hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01_eAoD = -1;
static int hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01_eAoA = -1;
static int hf_lpp_T_nr_AdType_r16_02_dl_prs = -1;
static int hf_lpp_T_nr_AdType_r16_02_ul_srs = -1;
static int hf_lpp_T_nr_RequestedMeasurements_r16_01_prsrsrpReq = -1;
static int hf_lpp_T_nr_RequestedMeasurements_r16_01_firstPathRsrpReq_r17 = -1;
static int hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02_eAoD = -1;
static int hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02_eAoA = -1;
static int hf_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_case1 = -1;
static int hf_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_case2 = -1;
static int hf_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_case3 = -1;
static int dummy_hf_lpp_eag_field = -1; /* never registered */
static int hf_lpp_svHealthExt_v1240_e5bhs = -1;
static int hf_lpp_svHealthExt_v1240_e1_bhs = -1;
static int hf_lpp_kepSV_StatusINAV_e5bhs = -1;
static int hf_lpp_kepSV_StatusINAV_e1_bhs = -1;
static int hf_lpp_kepSV_StatusFNAV_e5ahs = -1;
static int hf_lpp_bdsSvHealth_r12_sat_clock = -1;
static int hf_lpp_bdsSvHealth_r12_b1i = -1;
static int hf_lpp_bdsSvHealth_r12_b2i = -1;
static int hf_lpp_bdsSvHealth_r12_nav = -1;
static int hf_lpp_AssistanceDataSIBelement_r15_PDU = -1;

static dissector_handle_t lppe_handle = NULL;

static guint32 lpp_epdu_id = -1;

/* Initialize the subtree pointers */
static gint ett_lpp = -1;
static gint ett_lpp_svHealthExt_v1240 = -1;
static gint ett_kepSV_StatusINAV = -1;
static gint ett_kepSV_StatusFNAV = -1;
static gint ett_lpp_bdsSvHealth_r12 = -1;
static gint ett_lpp_assistanceDataElement_r15 = -1;
static gint ett_lpp_LPP_Message = -1;
static gint ett_lpp_Acknowledgement = -1;
static gint ett_lpp_LPP_MessageBody = -1;
static gint ett_lpp_T_c1 = -1;
static gint ett_lpp_T_messageClassExtension = -1;
static gint ett_lpp_LPP_TransactionID = -1;
static gint ett_lpp_RequestCapabilities = -1;
static gint ett_lpp_T_criticalExtensions = -1;
static gint ett_lpp_T_c1_01 = -1;
static gint ett_lpp_T_criticalExtensionsFuture = -1;
static gint ett_lpp_RequestCapabilities_r9_IEs = -1;
static gint ett_lpp_ProvideCapabilities = -1;
static gint ett_lpp_T_criticalExtensions_01 = -1;
static gint ett_lpp_T_c1_02 = -1;
static gint ett_lpp_T_criticalExtensionsFuture_01 = -1;
static gint ett_lpp_ProvideCapabilities_r9_IEs = -1;
static gint ett_lpp_RequestAssistanceData = -1;
static gint ett_lpp_T_criticalExtensions_02 = -1;
static gint ett_lpp_T_c1_03 = -1;
static gint ett_lpp_T_criticalExtensionsFuture_02 = -1;
static gint ett_lpp_RequestAssistanceData_r9_IEs = -1;
static gint ett_lpp_ProvideAssistanceData = -1;
static gint ett_lpp_T_criticalExtensions_03 = -1;
static gint ett_lpp_T_c1_04 = -1;
static gint ett_lpp_T_criticalExtensionsFuture_03 = -1;
static gint ett_lpp_ProvideAssistanceData_r9_IEs = -1;
static gint ett_lpp_RequestLocationInformation = -1;
static gint ett_lpp_T_criticalExtensions_04 = -1;
static gint ett_lpp_T_c1_05 = -1;
static gint ett_lpp_T_criticalExtensionsFuture_04 = -1;
static gint ett_lpp_RequestLocationInformation_r9_IEs = -1;
static gint ett_lpp_ProvideLocationInformation = -1;
static gint ett_lpp_T_criticalExtensions_05 = -1;
static gint ett_lpp_T_c1_06 = -1;
static gint ett_lpp_T_criticalExtensionsFuture_05 = -1;
static gint ett_lpp_ProvideLocationInformation_r9_IEs = -1;
static gint ett_lpp_Abort = -1;
static gint ett_lpp_T_criticalExtensions_06 = -1;
static gint ett_lpp_T_c1_07 = -1;
static gint ett_lpp_T_criticalExtensionsFuture_06 = -1;
static gint ett_lpp_Abort_r9_IEs = -1;
static gint ett_lpp_Error = -1;
static gint ett_lpp_T_criticalExtensionsFuture_07 = -1;
static gint ett_lpp_Error_r9_IEs = -1;
static gint ett_lpp_AccessTypes = -1;
static gint ett_lpp_T_accessTypes = -1;
static gint ett_lpp_CarrierFreq_NB_r14 = -1;
static gint ett_lpp_CellGlobalIdEUTRA_AndUTRA = -1;
static gint ett_lpp_T_plmn_Identity = -1;
static gint ett_lpp_T_mcc = -1;
static gint ett_lpp_T_mnc = -1;
static gint ett_lpp_T_cellIdentity = -1;
static gint ett_lpp_CellGlobalIdGERAN = -1;
static gint ett_lpp_T_plmn_Identity_01 = -1;
static gint ett_lpp_T_mcc_01 = -1;
static gint ett_lpp_T_mnc_01 = -1;
static gint ett_lpp_ECGI = -1;
static gint ett_lpp_T_mcc_02 = -1;
static gint ett_lpp_T_mnc_02 = -1;
static gint ett_lpp_Ellipsoid_Point = -1;
static gint ett_lpp_Ellipsoid_PointWithUncertaintyCircle = -1;
static gint ett_lpp_EllipsoidPointWithUncertaintyEllipse = -1;
static gint ett_lpp_EllipsoidPointWithAltitude = -1;
static gint ett_lpp_EllipsoidPointWithAltitudeAndUncertaintyEllipsoid = -1;
static gint ett_lpp_EllipsoidArc = -1;
static gint ett_lpp_EPDU_Sequence = -1;
static gint ett_lpp_EPDU = -1;
static gint ett_lpp_EPDU_Identifier = -1;
static gint ett_lpp_HA_EllipsoidPointWithAltitudeAndScalableUncertaintyEllipsoid_r16 = -1;
static gint ett_lpp_HA_EllipsoidPointWithScalableUncertaintyEllipse_r16 = -1;
static gint ett_lpp_HighAccuracyEllipsoidPointWithUncertaintyEllipse_r15 = -1;
static gint ett_lpp_HighAccuracyEllipsoidPointWithAltitudeAndUncertaintyEllipsoid_r15 = -1;
static gint ett_lpp_HorizontalVelocity = -1;
static gint ett_lpp_HorizontalWithVerticalVelocity = -1;
static gint ett_lpp_HorizontalVelocityWithUncertainty = -1;
static gint ett_lpp_HorizontalWithVerticalVelocityAndUncertainty = -1;
static gint ett_lpp_LocationCoordinateTypes = -1;
static gint ett_lpp_NCGI_r15 = -1;
static gint ett_lpp_T_mcc_r15 = -1;
static gint ett_lpp_T_mnc_r15 = -1;
static gint ett_lpp_PeriodicAssistanceDataControlParameters_r15 = -1;
static gint ett_lpp_PeriodicSessionID_r15 = -1;
static gint ett_lpp_UpdateCapabilities_r15 = -1;
static gint ett_lpp_Polygon = -1;
static gint ett_lpp_PolygonPoints = -1;
static gint ett_lpp_PositioningModes = -1;
static gint ett_lpp_T_posModes = -1;
static gint ett_lpp_ScheduledLocationTimeSupport_r17 = -1;
static gint ett_lpp_ScheduledLocationTimeSupportPerMode_r17 = -1;
static gint ett_lpp_T_gnssTime_r17 = -1;
static gint ett_lpp_VelocityTypes = -1;
static gint ett_lpp_CommonIEsRequestCapabilities = -1;
static gint ett_lpp_T_lpp_message_segmentation_req_r14 = -1;
static gint ett_lpp_CommonIEsProvideCapabilities = -1;
static gint ett_lpp_T_lpp_message_segmentation_r14 = -1;
static gint ett_lpp_CommonIEsRequestAssistanceData = -1;
static gint ett_lpp_CommonIEsProvideAssistanceData = -1;
static gint ett_lpp_CommonIEsRequestLocationInformation = -1;
static gint ett_lpp_PeriodicalReportingCriteria = -1;
static gint ett_lpp_TriggeredReportingCriteria = -1;
static gint ett_lpp_QoS = -1;
static gint ett_lpp_HorizontalAccuracy = -1;
static gint ett_lpp_VerticalAccuracy = -1;
static gint ett_lpp_HorizontalAccuracyExt_r15 = -1;
static gint ett_lpp_VerticalAccuracyExt_r15 = -1;
static gint ett_lpp_ResponseTime = -1;
static gint ett_lpp_ResponseTimeNB_r14 = -1;
static gint ett_lpp_MessageSizeLimitNB_r14 = -1;
static gint ett_lpp_ScheduledLocationTime_r17 = -1;
static gint ett_lpp_T_gnssTime_r17_01 = -1;
static gint ett_lpp_T_networkTime_r17 = -1;
static gint ett_lpp_T_e_utraTime_r17_01 = -1;
static gint ett_lpp_T_nrTime_r17_01 = -1;
static gint ett_lpp_T_nr_Slot_r17 = -1;
static gint ett_lpp_CommonIEsProvideLocationInformation = -1;
static gint ett_lpp_LocationCoordinates = -1;
static gint ett_lpp_Velocity = -1;
static gint ett_lpp_LocationError = -1;
static gint ett_lpp_LocationSource_r13 = -1;
static gint ett_lpp_IntegrityInfo_r17 = -1;
static gint ett_lpp_CommonIEsAbort = -1;
static gint ett_lpp_CommonIEsError = -1;
static gint ett_lpp_AreaID_CellList_r17 = -1;
static gint ett_lpp_NR_Cell_IDs_r17 = -1;
static gint ett_lpp_DL_PRS_ID_Info_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxResourceIDs_r16_OF_NR_DL_PRS_ResourceID_r16 = -1;
static gint ett_lpp_LCS_GCS_TranslationParameter_r16 = -1;
static gint ett_lpp_LOS_NLOS_Indicator_r17 = -1;
static gint ett_lpp_T_indicator_r17 = -1;
static gint ett_lpp_NR_AdditionalPathList_r16 = -1;
static gint ett_lpp_NR_AdditionalPathListExt_r17 = -1;
static gint ett_lpp_NR_AdditionalPath_r16 = -1;
static gint ett_lpp_T_nr_RelativeTimeDifference_r16 = -1;
static gint ett_lpp_NR_DL_PRS_AssistanceData_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxFreqLayers_r16_OF_NR_DL_PRS_AssistanceDataPerFreq_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxTRPs_r16_OF_NR_SSB_Config_r16 = -1;
static gint ett_lpp_NR_DL_PRS_AssistanceDataPerFreq_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_NR_DL_PRS_AssistanceDataPerTRP_r16 = -1;
static gint ett_lpp_NR_DL_PRS_AssistanceDataPerTRP_r16 = -1;
static gint ett_lpp_NR_DL_PRS_PositioningFrequencyLayer_r16 = -1;
static gint ett_lpp_NR_DL_PRS_SFN0_Offset_r16 = -1;
static gint ett_lpp_NR_DL_PRS_ExpectedAoD_or_AoA_r17 = -1;
static gint ett_lpp_T_expectedAoD_r17 = -1;
static gint ett_lpp_T_expectedAoA_r17 = -1;
static gint ett_lpp_NR_DL_PRS_BeamInfo_r16 = -1;
static gint ett_lpp_NR_DL_PRS_BeamInfoPerFreqLayer_r16 = -1;
static gint ett_lpp_NR_DL_PRS_BeamInfoPerTRP_r16 = -1;
static gint ett_lpp_DL_PRS_BeamInfoSet_r16 = -1;
static gint ett_lpp_DL_PRS_BeamInfoResourceSet_r16 = -1;
static gint ett_lpp_DL_PRS_BeamInfoElement_r16 = -1;
static gint ett_lpp_NR_DL_PRS_ExpectedLOS_NLOS_Assistance_r17 = -1;
static gint ett_lpp_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerFreqLayer_r17 = -1;
static gint ett_lpp_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerTRP_r17 = -1;
static gint ett_lpp_T_nr_los_nlos_indicator_r17 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerResource_r17 = -1;
static gint ett_lpp_NR_DL_PRS_ExpectedLOS_NLOS_AssistancePerResource_r17 = -1;
static gint ett_lpp_NR_DL_PRS_Info_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_NR_DL_PRS_ResourceSet_r16 = -1;
static gint ett_lpp_NR_DL_PRS_ResourceSet_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_NR_DL_PRS_Resource_r16 = -1;
static gint ett_lpp_DL_PRS_MutingOption1_r16 = -1;
static gint ett_lpp_DL_PRS_MutingOption2_r16 = -1;
static gint ett_lpp_NR_MutingPattern_r16 = -1;
static gint ett_lpp_NR_DL_PRS_Resource_r16 = -1;
static gint ett_lpp_T_dl_PRS_CombSizeN_AndReOffset_r16 = -1;
static gint ett_lpp_DL_PRS_QCL_Info_r16 = -1;
static gint ett_lpp_T_ssb_r16 = -1;
static gint ett_lpp_T_dl_PRS_r16 = -1;
static gint ett_lpp_NR_DL_PRS_Periodicity_and_ResourceSetSlotOffset_r16 = -1;
static gint ett_lpp_T_scs15_r16 = -1;
static gint ett_lpp_T_scs30_r16 = -1;
static gint ett_lpp_T_scs60_r16 = -1;
static gint ett_lpp_T_scs120_r16 = -1;
static gint ett_lpp_DL_PRS_ResourcePrioritySubset_r17 = -1;
static gint ett_lpp_NR_DL_PRSResourcePriorityItem_r17 = -1;
static gint ett_lpp_NR_DL_PRS_ProcessingCapability_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16 = -1;
static gint ett_lpp_PRS_ProcessingCapabilityPerBand_r16 = -1;
static gint ett_lpp_T_supportedBandwidthPRS_r16 = -1;
static gint ett_lpp_T_durationOfPRS_Processing_r16 = -1;
static gint ett_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17 = -1;
static gint ett_lpp_T_durationOfPRS_Processing_RRC_Inactive_r17 = -1;
static gint ett_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17 = -1;
static gint ett_lpp_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17 = -1;
static gint ett_lpp_T_ppw_durationOfPRS_Processing1_r17 = -1;
static gint ett_lpp_T_ppw_durationOfPRS_Processing2_r17 = -1;
static gint ett_lpp_T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17 = -1;
static gint ett_lpp_T_ppw_maxNumOfDL_Bandwidth_r17 = -1;
static gint ett_lpp_NR_DL_PRS_QCL_ProcessingCapability_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16 = -1;
static gint ett_lpp_DL_PRS_QCL_ProcessingCapabilityPerBand_r16 = -1;
static gint ett_lpp_NR_DL_PRS_ResourcesCapability_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16 = -1;
static gint ett_lpp_DL_PRS_ResourcesCapabilityPerBand_r16 = -1;
static gint ett_lpp_DL_PRS_ResourcesBandCombinationList_r16 = -1;
static gint ett_lpp_DL_PRS_ResourcesBandCombination_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16 = -1;
static gint ett_lpp_T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16 = -1;
static gint ett_lpp_T_fr1_FR2Mix_r16 = -1;
static gint ett_lpp_NR_DL_PRS_TRP_TEG_Info_r17 = -1;
static gint ett_lpp_NR_DL_PRS_TRP_TEG_InfoPerFreqLayer_r17 = -1;
static gint ett_lpp_NR_DL_PRS_TRP_TEG_InfoPerTRP_r17 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_TEG_InfoPerResourceSet_r17 = -1;
static gint ett_lpp_DL_PRS_TEG_InfoPerResourceSet_r17 = -1;
static gint ett_lpp_DL_PRS_TEG_InfoElement_r17 = -1;
static gint ett_lpp_NR_On_Demand_DL_PRS_Configurations_r17 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_On_Demand_DL_PRS_Configuration_r17 = -1;
static gint ett_lpp_On_Demand_DL_PRS_Configuration_r17 = -1;
static gint ett_lpp_DL_PRS_Configuration_ID_r17 = -1;
static gint ett_lpp_NR_On_Demand_DL_PRS_Information_r17 = -1;
static gint ett_lpp_NR_On_Demand_DL_PRS_PerFreqLayer_r17 = -1;
static gint ett_lpp_DL_PRS_QCL_InformationReqTRPlist_r17 = -1;
static gint ett_lpp_DL_PRS_QCL_InformationReqPerTRP_r17 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17 = -1;
static gint ett_lpp_DL_PRS_QCL_InfoReq_r17 = -1;
static gint ett_lpp_T_dl_prs_QCL_InformationReq_r17 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16 = -1;
static gint ett_lpp_NR_On_Demand_DL_PRS_Request_r17 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17 = -1;
static gint ett_lpp_DL_PRS_StartTime_and_Duration_r17 = -1;
static gint ett_lpp_T_dl_prs_duration_r17 = -1;
static gint ett_lpp_NR_On_Demand_DL_PRS_Configurations_Selected_IndexList_r17 = -1;
static gint ett_lpp_NR_On_Demand_DL_PRS_Support_r17 = -1;
static gint ett_lpp_NR_PositionCalculationAssistance_r16 = -1;
static gint ett_lpp_NR_RTD_Info_r16 = -1;
static gint ett_lpp_ReferenceTRP_RTD_Info_r16 = -1;
static gint ett_lpp_T_refTime_r16 = -1;
static gint ett_lpp_RTD_InfoList_r16 = -1;
static gint ett_lpp_RTD_InfoListPerFreqLayer_r16 = -1;
static gint ett_lpp_RTD_InfoElement_r16 = -1;
static gint ett_lpp_NR_SelectedDL_PRS_IndexList_r16 = -1;
static gint ett_lpp_NR_SelectedDL_PRS_PerFreq_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_NR_SelectedDL_PRS_IndexPerTRP_r16 = -1;
static gint ett_lpp_NR_SelectedDL_PRS_IndexPerTRP_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_SelectedPRS_ResourceSetIndex_r16 = -1;
static gint ett_lpp_DL_SelectedPRS_ResourceSetIndex_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_SelectedPRS_ResourceIndex_r16 = -1;
static gint ett_lpp_DL_SelectedPRS_ResourceIndex_r16 = -1;
static gint ett_lpp_NR_SSB_Config_r16 = -1;
static gint ett_lpp_T_ssb_PositionsInBurst_r16 = -1;
static gint ett_lpp_NR_TimeStamp_r16 = -1;
static gint ett_lpp_T_nr_Slot_r16 = -1;
static gint ett_lpp_NR_TimingQuality_r16 = -1;
static gint ett_lpp_NR_TRP_BeamAntennaInfo_r17 = -1;
static gint ett_lpp_NR_TRP_BeamAntennaInfoPerFreqLayer_r17 = -1;
static gint ett_lpp_NR_TRP_BeamAntennaInfoPerTRP_r17 = -1;
static gint ett_lpp_NR_TRP_BeamAntennaAngles_r17 = -1;
static gint ett_lpp_NR_TRP_BeamAntennaInfoAzimuthElevation_r17 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_1801_OF_ElevationElement_R17 = -1;
static gint ett_lpp_ElevationElement_R17 = -1;
static gint ett_lpp_SEQUENCE_SIZE_2_maxNumResourcesPerAngle_r17_OF_BeamPowerElement_r17 = -1;
static gint ett_lpp_BeamPowerElement_r17 = -1;
static gint ett_lpp_NR_TRP_LocationInfo_r16 = -1;
static gint ett_lpp_NR_TRP_LocationInfoPerFreqLayer_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxTRPsPerFreq_r16_OF_TRP_LocationInfoElement_r16 = -1;
static gint ett_lpp_TRP_LocationInfoElement_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_ResourceSets_TRP_Element_r16 = -1;
static gint ett_lpp_DL_PRS_ResourceSets_TRP_Element_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_Resource_ARP_Element_r16 = -1;
static gint ett_lpp_DL_PRS_Resource_ARP_Element_r16 = -1;
static gint ett_lpp_NR_UE_TEG_Capability_r17 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17 = -1;
static gint ett_lpp_NR_UE_TEG_ID_CapabilityPerBand_r17 = -1;
static gint ett_lpp_NR_UL_SRS_Capability_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16 = -1;
static gint ett_lpp_SRS_CapabilityPerBand_r16 = -1;
static gint ett_lpp_OLPC_SRS_Pos_r16 = -1;
static gint ett_lpp_SpatialRelationsSRS_Pos_r16 = -1;
static gint ett_lpp_SRS_PosResourcesPerBand_r16 = -1;
static gint ett_lpp_PosSRS_RRC_Inactive_InInitialUL_BWP_r17 = -1;
static gint ett_lpp_PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17 = -1;
static gint ett_lpp_PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17 = -1;
static gint ett_lpp_ReferencePoint_r16 = -1;
static gint ett_lpp_T_referencePointGeographicLocation_r16 = -1;
static gint ett_lpp_RelativeLocation_r16 = -1;
static gint ett_lpp_Delta_Latitude_r16 = -1;
static gint ett_lpp_Delta_Longitude_r16 = -1;
static gint ett_lpp_Delta_Height_r16 = -1;
static gint ett_lpp_LocationUncertainty_r16 = -1;
static gint ett_lpp_OTDOA_ProvideAssistanceData = -1;
static gint ett_lpp_OTDOA_ReferenceCellInfo = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxAddPRSconfig_r14_OF_PRS_Info = -1;
static gint ett_lpp_PRS_Info = -1;
static gint ett_lpp_T_prs_MutingInfo_r9 = -1;
static gint ett_lpp_T_prsHoppingInfo_r14 = -1;
static gint ett_lpp_T_nb4_r14 = -1;
static gint ett_lpp_TDD_Config_v1520 = -1;
static gint ett_lpp_OTDOA_NeighbourCellInfoList = -1;
static gint ett_lpp_OTDOA_NeighbourFreqInfo = -1;
static gint ett_lpp_OTDOA_NeighbourCellInfoElement = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxAddPRSconfig_r14_OF_Add_PRSconfigNeighbourElement_r14 = -1;
static gint ett_lpp_Add_PRSconfigNeighbourElement_r14 = -1;
static gint ett_lpp_OTDOA_ReferenceCellInfoNB_r14 = -1;
static gint ett_lpp_PRS_Info_NB_r14 = -1;
static gint ett_lpp_NPRS_Info_r14 = -1;
static gint ett_lpp_T_partA_r14 = -1;
static gint ett_lpp_T_nprsBitmap_r14 = -1;
static gint ett_lpp_T_nprs_MutingInfoA_r14 = -1;
static gint ett_lpp_T_partB_r14 = -1;
static gint ett_lpp_T_nprs_MutingInfoB_r14 = -1;
static gint ett_lpp_T_partA_TDD_r15 = -1;
static gint ett_lpp_T_nprsBitmap_r15 = -1;
static gint ett_lpp_T_nprs_MutingInfoA_r15 = -1;
static gint ett_lpp_OTDOA_NeighbourCellInfoListNB_r14 = -1;
static gint ett_lpp_OTDOA_NeighbourCellInfoNB_r14 = -1;
static gint ett_lpp_OTDOA_RequestAssistanceData = -1;
static gint ett_lpp_T_adType_r14 = -1;
static gint ett_lpp_OTDOA_ProvideLocationInformation = -1;
static gint ett_lpp_OTDOA_SignalMeasurementInformation = -1;
static gint ett_lpp_NeighbourMeasurementList = -1;
static gint ett_lpp_NeighbourMeasurementElement = -1;
static gint ett_lpp_AdditionalPathList_r14 = -1;
static gint ett_lpp_MotionTimeSource_r15 = -1;
static gint ett_lpp_OTDOA_SignalMeasurementInformation_NB_r14 = -1;
static gint ett_lpp_NeighbourMeasurementList_NB_r14 = -1;
static gint ett_lpp_NeighbourMeasurementElement_NB_r14 = -1;
static gint ett_lpp_OTDOA_MeasQuality = -1;
static gint ett_lpp_AdditionalPath_r14 = -1;
static gint ett_lpp_OTDOA_RequestLocationInformation = -1;
static gint ett_lpp_OTDOA_ProvideCapabilities = -1;
static gint ett_lpp_T_otdoa_Mode = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0 = -1;
static gint ett_lpp_SupportedBandEUTRA = -1;
static gint ett_lpp_SupportedBandEUTRA_v9a0 = -1;
static gint ett_lpp_OTDOA_RequestCapabilities = -1;
static gint ett_lpp_OTDOA_Error = -1;
static gint ett_lpp_OTDOA_LocationServerErrorCauses = -1;
static gint ett_lpp_OTDOA_TargetDeviceErrorCauses = -1;
static gint ett_lpp_A_GNSS_ProvideAssistanceData = -1;
static gint ett_lpp_GNSS_CommonAssistData = -1;
static gint ett_lpp_GNSS_GenericAssistData = -1;
static gint ett_lpp_GNSS_GenericAssistDataElement = -1;
static gint ett_lpp_GNSS_PeriodicAssistData_r15 = -1;
static gint ett_lpp_GNSS_ReferenceTime = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell = -1;
static gint ett_lpp_GNSS_ReferenceTimeForOneCell = -1;
static gint ett_lpp_GNSS_SystemTime = -1;
static gint ett_lpp_GPS_TOW_Assist = -1;
static gint ett_lpp_GPS_TOW_AssistElement = -1;
static gint ett_lpp_NetworkTime = -1;
static gint ett_lpp_T_cellID = -1;
static gint ett_lpp_T_eUTRA = -1;
static gint ett_lpp_T_uTRA = -1;
static gint ett_lpp_T_mode = -1;
static gint ett_lpp_T_fdd = -1;
static gint ett_lpp_T_tdd = -1;
static gint ett_lpp_T_gSM = -1;
static gint ett_lpp_T_nBIoT_r14 = -1;
static gint ett_lpp_T_nr_r15 = -1;
static gint ett_lpp_GNSS_ReferenceLocation = -1;
static gint ett_lpp_GNSS_IonosphericModel = -1;
static gint ett_lpp_KlobucharModelParameter = -1;
static gint ett_lpp_KlobucharModel2Parameter_r16 = -1;
static gint ett_lpp_NeQuickModelParameter = -1;
static gint ett_lpp_GNSS_EarthOrientationParameters = -1;
static gint ett_lpp_GNSS_RTK_ReferenceStationInfo_r15 = -1;
static gint ett_lpp_AntennaDescription_r15 = -1;
static gint ett_lpp_AntennaReferencePointUnc_r15 = -1;
static gint ett_lpp_PhysicalReferenceStationInfo_r15 = -1;
static gint ett_lpp_EqualIntegerAmbiguityLevel_r16 = -1;
static gint ett_lpp_ReferenceStationList_r16 = -1;
static gint ett_lpp_GNSS_RTK_CommonObservationInfo_r15 = -1;
static gint ett_lpp_GNSS_RTK_AuxiliaryStationData_r15 = -1;
static gint ett_lpp_AuxiliaryStationList_r15 = -1;
static gint ett_lpp_AuxiliaryStationElement_r15 = -1;
static gint ett_lpp_Aux_ARP_Unc_r15 = -1;
static gint ett_lpp_GNSS_SSR_CorrectionPoints_r16 = -1;
static gint ett_lpp_T_correctionPoints_r16 = -1;
static gint ett_lpp_GNSS_SSR_ListOfCorrectionPoints_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16 = -1;
static gint ett_lpp_RelativeLocationElement_r16 = -1;
static gint ett_lpp_GNSS_SSR_ArrayOfCorrectionPoints_r16 = -1;
static gint ett_lpp_GNSS_Integrity_ServiceParameters_r17 = -1;
static gint ett_lpp_GNSS_Integrity_ServiceAlert_r17 = -1;
static gint ett_lpp_GNSS_TimeModelList = -1;
static gint ett_lpp_GNSS_TimeModelElement = -1;
static gint ett_lpp_GNSS_DifferentialCorrections = -1;
static gint ett_lpp_DGNSS_SgnTypeList = -1;
static gint ett_lpp_DGNSS_SgnTypeElement = -1;
static gint ett_lpp_DGNSS_SatList = -1;
static gint ett_lpp_DGNSS_CorrectionsElement = -1;
static gint ett_lpp_GNSS_NavigationModel = -1;
static gint ett_lpp_GNSS_NavModelSatelliteList = -1;
static gint ett_lpp_GNSS_NavModelSatelliteElement = -1;
static gint ett_lpp_GNSS_ClockModel = -1;
static gint ett_lpp_GNSS_OrbitModel = -1;
static gint ett_lpp_StandardClockModelList = -1;
static gint ett_lpp_StandardClockModelElement = -1;
static gint ett_lpp_NAV_ClockModel = -1;
static gint ett_lpp_CNAV_ClockModel = -1;
static gint ett_lpp_GLONASS_ClockModel = -1;
static gint ett_lpp_SBAS_ClockModel = -1;
static gint ett_lpp_BDS_ClockModel_r12 = -1;
static gint ett_lpp_BDS_ClockModel2_r16 = -1;
static gint ett_lpp_NavIC_ClockModel_r16 = -1;
static gint ett_lpp_NavModelKeplerianSet = -1;
static gint ett_lpp_NavModelNAV_KeplerianSet = -1;
static gint ett_lpp_T_addNAVparam = -1;
static gint ett_lpp_T_ephemSF1Rsvd = -1;
static gint ett_lpp_NavModelCNAV_KeplerianSet = -1;
static gint ett_lpp_NavModel_GLONASS_ECEF = -1;
static gint ett_lpp_NavModel_SBAS_ECEF = -1;
static gint ett_lpp_NavModel_BDS_KeplerianSet_r12 = -1;
static gint ett_lpp_NavModel_BDS_KeplerianSet2_r16 = -1;
static gint ett_lpp_NavModel_NavIC_KeplerianSet_r16 = -1;
static gint ett_lpp_GNSS_RealTimeIntegrity = -1;
static gint ett_lpp_GNSS_BadSignalList = -1;
static gint ett_lpp_BadSignalElement = -1;
static gint ett_lpp_GNSS_DataBitAssistance = -1;
static gint ett_lpp_GNSS_DataBitsSatList = -1;
static gint ett_lpp_GNSS_DataBitsSatElement = -1;
static gint ett_lpp_GNSS_DataBitsSgnList = -1;
static gint ett_lpp_GNSS_DataBitsSgnElement = -1;
static gint ett_lpp_GNSS_AcquisitionAssistance = -1;
static gint ett_lpp_GNSS_AcquisitionAssistList = -1;
static gint ett_lpp_GNSS_AcquisitionAssistElement = -1;
static gint ett_lpp_GNSS_Almanac = -1;
static gint ett_lpp_GNSS_AlmanacList = -1;
static gint ett_lpp_GNSS_AlmanacElement = -1;
static gint ett_lpp_AlmanacKeplerianSet = -1;
static gint ett_lpp_AlmanacNAV_KeplerianSet = -1;
static gint ett_lpp_AlmanacReducedKeplerianSet = -1;
static gint ett_lpp_AlmanacMidiAlmanacSet = -1;
static gint ett_lpp_AlmanacGLONASS_AlmanacSet = -1;
static gint ett_lpp_AlmanacECEF_SBAS_AlmanacSet = -1;
static gint ett_lpp_AlmanacBDS_AlmanacSet_r12 = -1;
static gint ett_lpp_AlmanacNavIC_AlmanacSet_r16 = -1;
static gint ett_lpp_GNSS_UTC_Model = -1;
static gint ett_lpp_UTC_ModelSet1 = -1;
static gint ett_lpp_UTC_ModelSet2 = -1;
static gint ett_lpp_UTC_ModelSet3 = -1;
static gint ett_lpp_UTC_ModelSet4 = -1;
static gint ett_lpp_UTC_ModelSet5_r12 = -1;
static gint ett_lpp_GNSS_AuxiliaryInformation = -1;
static gint ett_lpp_GNSS_ID_GPS = -1;
static gint ett_lpp_GNSS_ID_GPS_SatElement = -1;
static gint ett_lpp_GNSS_ID_GLONASS = -1;
static gint ett_lpp_GNSS_ID_GLONASS_SatElement = -1;
static gint ett_lpp_GNSS_ID_BDS_r16 = -1;
static gint ett_lpp_GNSS_ID_BDS_SatElement_r16 = -1;
static gint ett_lpp_BDS_DifferentialCorrections_r12 = -1;
static gint ett_lpp_BDS_SgnTypeList_r12 = -1;
static gint ett_lpp_BDS_SgnTypeElement_r12 = -1;
static gint ett_lpp_DBDS_CorrectionList_r12 = -1;
static gint ett_lpp_DBDS_CorrectionElement_r12 = -1;
static gint ett_lpp_BDS_GridModelParameter_r12 = -1;
static gint ett_lpp_GridIonList_r12 = -1;
static gint ett_lpp_GridIonElement_r12 = -1;
static gint ett_lpp_GNSS_RTK_Observations_r15 = -1;
static gint ett_lpp_GNSS_ObservationList_r15 = -1;
static gint ett_lpp_GNSS_RTK_SatelliteDataElement_r15 = -1;
static gint ett_lpp_GNSS_RTK_SatelliteSignalDataList_r15 = -1;
static gint ett_lpp_GNSS_RTK_SatelliteSignalDataElement_r15 = -1;
static gint ett_lpp_GLO_RTK_BiasInformation_r15 = -1;
static gint ett_lpp_GNSS_RTK_MAC_CorrectionDifferences_r15 = -1;
static gint ett_lpp_RTK_CorrectionDifferencesList_r15 = -1;
static gint ett_lpp_RTK_CorrectionDifferencesElement_r15 = -1;
static gint ett_lpp_Geometric_Ionospheric_Corrections_Differences_r15 = -1;
static gint ett_lpp_Geometric_Ionospheric_Corrections_Differences_Element_r15 = -1;
static gint ett_lpp_GNSS_RTK_Residuals_r15 = -1;
static gint ett_lpp_RTK_Residuals_List_r15 = -1;
static gint ett_lpp_RTK_Residuals_Element_r15 = -1;
static gint ett_lpp_GNSS_RTK_FKP_Gradients_r15 = -1;
static gint ett_lpp_FKP_Gradients_List_r15 = -1;
static gint ett_lpp_FKP_Gradients_Element_r15 = -1;
static gint ett_lpp_GNSS_SSR_OrbitCorrections_r15 = -1;
static gint ett_lpp_SSR_OrbitCorrectionList_r15 = -1;
static gint ett_lpp_SSR_OrbitCorrectionSatelliteElement_r15 = -1;
static gint ett_lpp_ORBIT_IntegrityParameters_r17 = -1;
static gint ett_lpp_SSR_IntegrityOrbitBounds_r17 = -1;
static gint ett_lpp_RAC_OrbitalErrorComponents_r17 = -1;
static gint ett_lpp_GNSS_SSR_ClockCorrections_r15 = -1;
static gint ett_lpp_SSR_ClockCorrectionList_r15 = -1;
static gint ett_lpp_SSR_ClockCorrectionSatelliteElement_r15 = -1;
static gint ett_lpp_CLOCK_IntegrityParameters_r17 = -1;
static gint ett_lpp_SSR_IntegrityClockBounds_r17 = -1;
static gint ett_lpp_GNSS_SSR_CodeBias_r15 = -1;
static gint ett_lpp_SSR_CodeBiasSatList_r15 = -1;
static gint ett_lpp_SSR_CodeBiasSatElement_r15 = -1;
static gint ett_lpp_SSR_CodeBiasSignalList_r15 = -1;
static gint ett_lpp_SSR_CodeBiasSignalElement_r15 = -1;
static gint ett_lpp_SSR_IntegrityCodeBiasBounds_r17 = -1;
static gint ett_lpp_GNSS_SSR_URA_r16 = -1;
static gint ett_lpp_SSR_URA_SatList_r16 = -1;
static gint ett_lpp_SSR_URA_SatElement_r16 = -1;
static gint ett_lpp_GNSS_SSR_PhaseBias_r16 = -1;
static gint ett_lpp_SSR_PhaseBiasSatList_r16 = -1;
static gint ett_lpp_SSR_PhaseBiasSatElement_r16 = -1;
static gint ett_lpp_SSR_PhaseBiasSignalList_r16 = -1;
static gint ett_lpp_SSR_PhaseBiasSignalElement_r16 = -1;
static gint ett_lpp_SSR_IntegrityPhaseBiasBounds_r17 = -1;
static gint ett_lpp_GNSS_SSR_STEC_Correction_r16 = -1;
static gint ett_lpp_STEC_SatList_r16 = -1;
static gint ett_lpp_STEC_SatElement_r16 = -1;
static gint ett_lpp_STEC_IntegrityParameters_r17 = -1;
static gint ett_lpp_STEC_IntegrityErrorBounds_r17 = -1;
static gint ett_lpp_GNSS_SSR_GriddedCorrection_r16 = -1;
static gint ett_lpp_GridList_r16 = -1;
static gint ett_lpp_GridElement_r16 = -1;
static gint ett_lpp_TropospericDelayCorrection_r16 = -1;
static gint ett_lpp_STEC_ResidualSatList_r16 = -1;
static gint ett_lpp_STEC_ResidualSatElement_r16 = -1;
static gint ett_lpp_T_stecResidualCorrection_r16 = -1;
static gint ett_lpp_SSR_GriddedCorrectionIntegrityParameters_r17 = -1;
static gint ett_lpp_TropoDelayIntegrityErrorBounds_r17 = -1;
static gint ett_lpp_NavIC_DifferentialCorrections_r16 = -1;
static gint ett_lpp_NavIC_CorrectionListAutoNav_r16 = -1;
static gint ett_lpp_NavIC_CorrectionElementAutoNav_r16 = -1;
static gint ett_lpp_NavIC_EDC_r16 = -1;
static gint ett_lpp_NavIC_CDC_r16 = -1;
static gint ett_lpp_NavIC_GridModelParameter_r16 = -1;
static gint ett_lpp_RegionIgpList_r16 = -1;
static gint ett_lpp_RegionIgpElement_r16 = -1;
static gint ett_lpp_A_GNSS_RequestAssistanceData = -1;
static gint ett_lpp_GNSS_CommonAssistDataReq = -1;
static gint ett_lpp_GNSS_GenericAssistDataReq = -1;
static gint ett_lpp_GNSS_GenericAssistDataReqElement = -1;
static gint ett_lpp_GNSS_PeriodicAssistDataReq_r15 = -1;
static gint ett_lpp_GNSS_ReferenceTimeReq = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_8_OF_GNSS_ID = -1;
static gint ett_lpp_GNSS_ReferenceLocationReq = -1;
static gint ett_lpp_GNSS_IonosphericModelReq = -1;
static gint ett_lpp_GNSS_EarthOrientationParametersReq = -1;
static gint ett_lpp_GNSS_RTK_ReferenceStationInfoReq_r15 = -1;
static gint ett_lpp_GNSS_RTK_AuxiliaryStationDataReq_r15 = -1;
static gint ett_lpp_GNSS_SSR_CorrectionPointsReq_r16 = -1;
static gint ett_lpp_GNSS_Integrity_ServiceParametersReq_r17 = -1;
static gint ett_lpp_GNSS_Integrity_ServiceAlertReq_r17 = -1;
static gint ett_lpp_GNSS_TimeModelListReq = -1;
static gint ett_lpp_GNSS_TimeModelElementReq = -1;
static gint ett_lpp_GNSS_DifferentialCorrectionsReq = -1;
static gint ett_lpp_GNSS_NavigationModelReq = -1;
static gint ett_lpp_StoredNavListInfo = -1;
static gint ett_lpp_SatListRelatedDataList = -1;
static gint ett_lpp_SatListRelatedDataElement = -1;
static gint ett_lpp_ReqNavListInfo = -1;
static gint ett_lpp_T_clockModelID_PrefList = -1;
static gint ett_lpp_T_orbitModelID_PrefList = -1;
static gint ett_lpp_GNSS_RealTimeIntegrityReq = -1;
static gint ett_lpp_GNSS_DataBitAssistanceReq = -1;
static gint ett_lpp_GNSS_DataBitsReqSatList = -1;
static gint ett_lpp_GNSS_DataBitsReqSatElement = -1;
static gint ett_lpp_GNSS_AcquisitionAssistanceReq = -1;
static gint ett_lpp_GNSS_AlmanacReq = -1;
static gint ett_lpp_GNSS_UTC_ModelReq = -1;
static gint ett_lpp_GNSS_AuxiliaryInformationReq = -1;
static gint ett_lpp_BDS_DifferentialCorrectionsReq_r12 = -1;
static gint ett_lpp_BDS_GridModelReq_r12 = -1;
static gint ett_lpp_GNSS_RTK_ObservationsReq_r15 = -1;
static gint ett_lpp_GLO_RTK_BiasInformationReq_r15 = -1;
static gint ett_lpp_GNSS_RTK_MAC_CorrectionDifferencesReq_r15 = -1;
static gint ett_lpp_AUX_ReferenceStationList_r15 = -1;
static gint ett_lpp_AUX_ReferenceStationID_Element_r15 = -1;
static gint ett_lpp_GNSS_RTK_ResidualsReq_r15 = -1;
static gint ett_lpp_GNSS_RTK_FKP_GradientsReq_r15 = -1;
static gint ett_lpp_GNSS_SSR_OrbitCorrectionsReq_r15 = -1;
static gint ett_lpp_T_orbit_IntegrityReq_r17 = -1;
static gint ett_lpp_GNSS_SSR_ClockCorrectionsReq_r15 = -1;
static gint ett_lpp_GNSS_SSR_CodeBiasReq_r15 = -1;
static gint ett_lpp_GNSS_SSR_URA_Req_r16 = -1;
static gint ett_lpp_GNSS_SSR_PhaseBiasReq_r16 = -1;
static gint ett_lpp_GNSS_SSR_STEC_CorrectionReq_r16 = -1;
static gint ett_lpp_T_stec_IntegrityReq_r17 = -1;
static gint ett_lpp_GNSS_SSR_GriddedCorrectionReq_r16 = -1;
static gint ett_lpp_NavIC_DifferentialCorrectionsReq_r16 = -1;
static gint ett_lpp_NavIC_GridModelReq_r16 = -1;
static gint ett_lpp_A_GNSS_ProvideLocationInformation = -1;
static gint ett_lpp_GNSS_SignalMeasurementInformation = -1;
static gint ett_lpp_MeasurementReferenceTime = -1;
static gint ett_lpp_T_networkTime = -1;
static gint ett_lpp_T_eUTRA_01 = -1;
static gint ett_lpp_T_uTRA_01 = -1;
static gint ett_lpp_T_mode_01 = -1;
static gint ett_lpp_T_fdd_01 = -1;
static gint ett_lpp_T_tdd_01 = -1;
static gint ett_lpp_T_gSM_01 = -1;
static gint ett_lpp_T_referenceFrame = -1;
static gint ett_lpp_T_nbIoT_r14 = -1;
static gint ett_lpp_T_nr_r15_01 = -1;
static gint ett_lpp_GNSS_MeasurementList = -1;
static gint ett_lpp_GNSS_MeasurementForOneGNSS = -1;
static gint ett_lpp_GNSS_SgnMeasList = -1;
static gint ett_lpp_GNSS_SgnMeasElement = -1;
static gint ett_lpp_GNSS_SatMeasList = -1;
static gint ett_lpp_GNSS_SatMeasElement = -1;
static gint ett_lpp_GNSS_LocationInformation = -1;
static gint ett_lpp_HA_GNSS_Metrics_r17 = -1;
static gint ett_lpp_A_GNSS_RequestLocationInformation = -1;
static gint ett_lpp_GNSS_PositioningInstructions = -1;
static gint ett_lpp_A_GNSS_ProvideCapabilities = -1;
static gint ett_lpp_T_periodicAssistanceData_r15 = -1;
static gint ett_lpp_GNSS_SupportList = -1;
static gint ett_lpp_GNSS_SupportElement = -1;
static gint ett_lpp_T_fta_MeasSupport = -1;
static gint ett_lpp_AssistanceDataSupportList = -1;
static gint ett_lpp_GNSS_CommonAssistanceDataSupport = -1;
static gint ett_lpp_GNSS_ReferenceTimeSupport = -1;
static gint ett_lpp_GNSS_ReferenceLocationSupport = -1;
static gint ett_lpp_GNSS_IonosphericModelSupport = -1;
static gint ett_lpp_T_ionoModel = -1;
static gint ett_lpp_GNSS_EarthOrientationParametersSupport = -1;
static gint ett_lpp_GNSS_RTK_ReferenceStationInfoSupport_r15 = -1;
static gint ett_lpp_GNSS_RTK_AuxiliaryStationDataSupport_r15 = -1;
static gint ett_lpp_GNSS_Integrity_ServiceParametersSupport_r17 = -1;
static gint ett_lpp_GNSS_Integrity_ServiceAlertSupport_r17 = -1;
static gint ett_lpp_GNSS_GenericAssistanceDataSupport = -1;
static gint ett_lpp_GNSS_GenericAssistDataSupportElement = -1;
static gint ett_lpp_GNSS_TimeModelListSupport = -1;
static gint ett_lpp_GNSS_DifferentialCorrectionsSupport = -1;
static gint ett_lpp_GNSS_NavigationModelSupport = -1;
static gint ett_lpp_T_clockModel = -1;
static gint ett_lpp_T_orbitModel = -1;
static gint ett_lpp_GNSS_RealTimeIntegritySupport = -1;
static gint ett_lpp_GNSS_DataBitAssistanceSupport = -1;
static gint ett_lpp_GNSS_AcquisitionAssistanceSupport = -1;
static gint ett_lpp_GNSS_AlmanacSupport = -1;
static gint ett_lpp_T_almanacModel = -1;
static gint ett_lpp_GNSS_UTC_ModelSupport = -1;
static gint ett_lpp_T_utc_Model = -1;
static gint ett_lpp_GNSS_AuxiliaryInformationSupport = -1;
static gint ett_lpp_BDS_DifferentialCorrectionsSupport_r12 = -1;
static gint ett_lpp_BDS_GridModelSupport_r12 = -1;
static gint ett_lpp_GNSS_RTK_ObservationsSupport_r15 = -1;
static gint ett_lpp_GLO_RTK_BiasInformationSupport_r15 = -1;
static gint ett_lpp_GNSS_RTK_MAC_CorrectionDifferencesSupport_r15 = -1;
static gint ett_lpp_GNSS_RTK_ResidualsSupport_r15 = -1;
static gint ett_lpp_GNSS_RTK_FKP_GradientsSupport_r15 = -1;
static gint ett_lpp_GNSS_SSR_OrbitCorrectionsSupport_r15 = -1;
static gint ett_lpp_T_orbit_IntegritySup_r17 = -1;
static gint ett_lpp_GNSS_SSR_ClockCorrectionsSupport_r15 = -1;
static gint ett_lpp_GNSS_SSR_CodeBiasSupport_r15 = -1;
static gint ett_lpp_GNSS_SSR_URA_Support_r16 = -1;
static gint ett_lpp_GNSS_SSR_PhaseBiasSupport_r16 = -1;
static gint ett_lpp_GNSS_SSR_STEC_CorrectionSupport_r16 = -1;
static gint ett_lpp_T_stec_IntegritySup_r17 = -1;
static gint ett_lpp_GNSS_SSR_GriddedCorrectionSupport_r16 = -1;
static gint ett_lpp_NavIC_DifferentialCorrectionsSupport_r16 = -1;
static gint ett_lpp_NavIC_GridModelSupport_r16 = -1;
static gint ett_lpp_A_GNSS_RequestCapabilities = -1;
static gint ett_lpp_A_GNSS_Error = -1;
static gint ett_lpp_GNSS_LocationServerErrorCauses = -1;
static gint ett_lpp_GNSS_TargetDeviceErrorCauses = -1;
static gint ett_lpp_GNSS_FrequencyID_r15 = -1;
static gint ett_lpp_GNSS_ID = -1;
static gint ett_lpp_GNSS_ID_Bitmap = -1;
static gint ett_lpp_T_gnss_ids = -1;
static gint ett_lpp_GNSS_Link_CombinationsList_r15 = -1;
static gint ett_lpp_GNSS_Link_Combinations_r15 = -1;
static gint ett_lpp_GNSS_NavListInfo_r15 = -1;
static gint ett_lpp_SatListElement_r15 = -1;
static gint ett_lpp_GNSS_NetworkID_r15 = -1;
static gint ett_lpp_GNSS_PeriodicControlParam_r15 = -1;
static gint ett_lpp_GNSS_ReferenceStationID_r15 = -1;
static gint ett_lpp_GNSS_SignalID = -1;
static gint ett_lpp_GNSS_SignalIDs = -1;
static gint ett_lpp_GNSS_SubNetworkID_r15 = -1;
static gint ett_lpp_SBAS_ID = -1;
static gint ett_lpp_SBAS_IDs = -1;
static gint ett_lpp_T_sbas_IDs = -1;
static gint ett_lpp_SV_ID = -1;
static gint ett_lpp_ECID_ProvideLocationInformation = -1;
static gint ett_lpp_ECID_SignalMeasurementInformation = -1;
static gint ett_lpp_MeasuredResultsList = -1;
static gint ett_lpp_MeasuredResultsElement = -1;
static gint ett_lpp_ECID_RequestLocationInformation = -1;
static gint ett_lpp_T_requestedMeasurements = -1;
static gint ett_lpp_ECID_ProvideCapabilities = -1;
static gint ett_lpp_T_ecid_MeasSupported = -1;
static gint ett_lpp_ECID_RequestCapabilities = -1;
static gint ett_lpp_ECID_Error = -1;
static gint ett_lpp_ECID_LocationServerErrorCauses = -1;
static gint ett_lpp_ECID_TargetDeviceErrorCauses = -1;
static gint ett_lpp_TBS_ProvideLocationInformation_r13 = -1;
static gint ett_lpp_TBS_MeasurementInformation_r13 = -1;
static gint ett_lpp_MBS_BeaconMeasList_r13 = -1;
static gint ett_lpp_MBS_BeaconMeasElement_r13 = -1;
static gint ett_lpp_TBS_RequestLocationInformation_r13 = -1;
static gint ett_lpp_T_mbsRequestedMeasurements_r14 = -1;
static gint ett_lpp_TBS_ProvideCapabilities_r13 = -1;
static gint ett_lpp_T_tbs_Modes_r13 = -1;
static gint ett_lpp_T_mbs_ConfigSupport_r14 = -1;
static gint ett_lpp_MBS_AssistanceDataSupportList_r14 = -1;
static gint ett_lpp_TBS_RequestCapabilities_r13 = -1;
static gint ett_lpp_TBS_Error_r13 = -1;
static gint ett_lpp_TBS_LocationServerErrorCauses_r13 = -1;
static gint ett_lpp_TBS_TargetDeviceErrorCauses_r13 = -1;
static gint ett_lpp_TBS_ProvideAssistanceData_r14 = -1;
static gint ett_lpp_TBS_AssistanceDataList_r14 = -1;
static gint ett_lpp_MBS_AssistanceDataList_r14 = -1;
static gint ett_lpp_MBS_AssistanceDataElement_r14 = -1;
static gint ett_lpp_MBS_AlmanacAssistance_r14 = -1;
static gint ett_lpp_MBS_AcquisitionAssistance_r14 = -1;
static gint ett_lpp_TBS_RequestAssistanceData_r14 = -1;
static gint ett_lpp_Sensor_ProvideLocationInformation_r13 = -1;
static gint ett_lpp_Sensor_MeasurementInformation_r13 = -1;
static gint ett_lpp_T_uncertainty_r14 = -1;
static gint ett_lpp_Sensor_MotionInformation_r15 = -1;
static gint ett_lpp_DisplacementInfoList_r15 = -1;
static gint ett_lpp_DisplacementInfoListElement_r15 = -1;
static gint ett_lpp_DisplacementTimeStamp_r15 = -1;
static gint ett_lpp_DeltaTime_r15 = -1;
static gint ett_lpp_SFN_r15 = -1;
static gint ett_lpp_Displacement_r15 = -1;
static gint ett_lpp_UTC_Time_r15 = -1;
static gint ett_lpp_Sensor_RequestLocationInformation_r13 = -1;
static gint ett_lpp_Sensor_ProvideCapabilities_r13 = -1;
static gint ett_lpp_T_sensor_Modes_r13 = -1;
static gint ett_lpp_Sensor_AssistanceDataSupportList_r14 = -1;
static gint ett_lpp_Sensor_RequestCapabilities_r13 = -1;
static gint ett_lpp_Sensor_Error_r13 = -1;
static gint ett_lpp_Sensor_LocationServerErrorCauses_r13 = -1;
static gint ett_lpp_Sensor_TargetDeviceErrorCauses_r13 = -1;
static gint ett_lpp_Sensor_ProvideAssistanceData_r14 = -1;
static gint ett_lpp_Sensor_AssistanceDataList_r14 = -1;
static gint ett_lpp_T_period_v1520 = -1;
static gint ett_lpp_T_area_v1520 = -1;
static gint ett_lpp_PressureValidityArea_v1520 = -1;
static gint ett_lpp_PressureValidityPeriod_v1520 = -1;
static gint ett_lpp_Sensor_RequestAssistanceData_r14 = -1;
static gint ett_lpp_WLAN_ProvideLocationInformation_r13 = -1;
static gint ett_lpp_WLAN_MeasurementInformation_r13 = -1;
static gint ett_lpp_WLAN_MeasurementList_r13 = -1;
static gint ett_lpp_WLAN_MeasurementElement_r13 = -1;
static gint ett_lpp_WLAN_AP_Identifier_r13 = -1;
static gint ett_lpp_WLAN_RTT_r13 = -1;
static gint ett_lpp_WLAN_RequestLocationInformation_r13 = -1;
static gint ett_lpp_T_requestedMeasurements_r13 = -1;
static gint ett_lpp_WLAN_ProvideCapabilities_r13 = -1;
static gint ett_lpp_T_wlan_Modes_r13 = -1;
static gint ett_lpp_T_wlan_MeasSupported_r13 = -1;
static gint ett_lpp_T_wlan_AP_AD_Supported_r14 = -1;
static gint ett_lpp_WLAN_RequestCapabilities_r13 = -1;
static gint ett_lpp_WLAN_Error_r13 = -1;
static gint ett_lpp_WLAN_LocationServerErrorCauses_r13 = -1;
static gint ett_lpp_WLAN_TargetDeviceErrorCauses_r13 = -1;
static gint ett_lpp_WLAN_ProvideAssistanceData_r14 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxWLAN_DataSets_r14_OF_WLAN_DataSet_r14 = -1;
static gint ett_lpp_WLAN_DataSet_r14 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxWLAN_AP_r14_OF_WLAN_AP_Data_r14 = -1;
static gint ett_lpp_SupportedChannels_11a_r14 = -1;
static gint ett_lpp_SupportedChannels_11bg_r14 = -1;
static gint ett_lpp_WLAN_AP_Data_r14 = -1;
static gint ett_lpp_WLAN_AP_Location_r14 = -1;
static gint ett_lpp_LocationDataLCI_r14 = -1;
static gint ett_lpp_WLAN_RequestAssistanceData_r14 = -1;
static gint ett_lpp_T_requestedAD_r14 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13 = -1;
static gint ett_lpp_BT_ProvideLocationInformation_r13 = -1;
static gint ett_lpp_BT_MeasurementInformation_r13 = -1;
static gint ett_lpp_BT_MeasurementList_r13 = -1;
static gint ett_lpp_BT_MeasurementElement_r13 = -1;
static gint ett_lpp_BT_RequestLocationInformation_r13 = -1;
static gint ett_lpp_T_requestedMeasurements_r13_01 = -1;
static gint ett_lpp_BT_ProvideCapabilities_r13 = -1;
static gint ett_lpp_T_bt_Modes_r13 = -1;
static gint ett_lpp_T_bt_MeasSupported_r13 = -1;
static gint ett_lpp_BT_RequestCapabilities_r13 = -1;
static gint ett_lpp_BT_Error_r13 = -1;
static gint ett_lpp_BT_LocationServerErrorCauses_r13 = -1;
static gint ett_lpp_BT_TargetDeviceErrorCauses_r13 = -1;
static gint ett_lpp_NR_UL_ProvideCapabilities_r16 = -1;
static gint ett_lpp_NR_UL_RequestCapabilities_r16 = -1;
static gint ett_lpp_NR_ECID_ProvideLocationInformation_r16 = -1;
static gint ett_lpp_NR_ECID_SignalMeasurementInformation_r16 = -1;
static gint ett_lpp_NR_MeasuredResultsList_r16 = -1;
static gint ett_lpp_NR_MeasuredResultsElement_r16 = -1;
static gint ett_lpp_T_nr_ARFCN_r16 = -1;
static gint ett_lpp_MeasQuantityResults_r16 = -1;
static gint ett_lpp_ResultsPerSSB_IndexList_r16 = -1;
static gint ett_lpp_ResultsPerSSB_Index_r16 = -1;
static gint ett_lpp_ResultsPerCSI_RS_IndexList_r16 = -1;
static gint ett_lpp_ResultsPerCSI_RS_Index_r16 = -1;
static gint ett_lpp_NR_ECID_RequestLocationInformation_r16 = -1;
static gint ett_lpp_T_requestedMeasurements_r16 = -1;
static gint ett_lpp_NR_ECID_ProvideCapabilities_r16 = -1;
static gint ett_lpp_T_nr_ECID_MeasSupported_r16 = -1;
static gint ett_lpp_NR_ECID_RequestCapabilities_r16 = -1;
static gint ett_lpp_NR_ECID_Error_r16 = -1;
static gint ett_lpp_NR_ECID_LocationServerErrorCauses_r16 = -1;
static gint ett_lpp_NR_ECID_TargetDeviceErrorCauses_r16 = -1;
static gint ett_lpp_NR_DL_TDOA_ProvideAssistanceData_r16 = -1;
static gint ett_lpp_NR_DL_TDOA_RequestAssistanceData_r16 = -1;
static gint ett_lpp_T_nr_AdType_r16 = -1;
static gint ett_lpp_T_nr_PosCalcAssistanceRequest_r17 = -1;
static gint ett_lpp_NR_DL_TDOA_ProvideLocationInformation_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_TDOA_SignalMeasurementInformation_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_TDOA_LocationInformation_r16 = -1;
static gint ett_lpp_NR_DL_TDOA_SignalMeasurementInformation_r16 = -1;
static gint ett_lpp_NR_DL_TDOA_MeasList_r16 = -1;
static gint ett_lpp_NR_DL_TDOA_MeasElement_r16 = -1;
static gint ett_lpp_T_nr_RSTD_r16 = -1;
static gint ett_lpp_T_nr_los_nlos_Indicator_r17 = -1;
static gint ett_lpp_NR_DL_TDOA_AdditionalMeasurements_r16 = -1;
static gint ett_lpp_NR_DL_TDOA_AdditionalMeasurementsExt_r17 = -1;
static gint ett_lpp_NR_DL_TDOA_AdditionalMeasurementElement_r16 = -1;
static gint ett_lpp_T_nr_RSTD_ResultDiff_r16 = -1;
static gint ett_lpp_NR_DL_TDOA_LocationInformation_r16 = -1;
static gint ett_lpp_T_measurementReferenceTime_r16 = -1;
static gint ett_lpp_NR_DL_TDOA_RequestLocationInformation_r16 = -1;
static gint ett_lpp_T_nr_RequestedMeasurements_r16 = -1;
static gint ett_lpp_T_nr_los_nlos_IndicatorRequest_r17 = -1;
static gint ett_lpp_NR_DL_TDOA_ReportConfig_r16 = -1;
static gint ett_lpp_NR_DL_TDOA_ProvideCapabilities_r16 = -1;
static gint ett_lpp_T_nr_PosCalcAssistanceSupport_r17 = -1;
static gint ett_lpp_T_nr_los_nlos_AssistanceDataSupport_r17 = -1;
static gint ett_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17 = -1;
static gint ett_lpp_T_nr_los_nlos_IndicatorSupport_r17 = -1;
static gint ett_lpp_T_nr_dl_prs_AssistanceDataValidity_r17 = -1;
static gint ett_lpp_NR_DL_TDOA_MeasurementCapability_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17 = -1;
static gint ett_lpp_DL_TDOA_MeasCapabilityPerBand_r17 = -1;
static gint ett_lpp_NR_DL_TDOA_RequestCapabilities_r16 = -1;
static gint ett_lpp_NR_DL_TDOA_Error_r16 = -1;
static gint ett_lpp_NR_DL_TDOA_LocationServerErrorCauses_r16 = -1;
static gint ett_lpp_NR_DL_TDOA_TargetDeviceErrorCauses_r16 = -1;
static gint ett_lpp_NR_DL_AoD_ProvideAssistanceData_r16 = -1;
static gint ett_lpp_NR_DL_AoD_RequestAssistanceData_r16 = -1;
static gint ett_lpp_T_nr_AdType_r16_01 = -1;
static gint ett_lpp_T_nr_PosCalcAssistanceRequest_r17_01 = -1;
static gint ett_lpp_NR_DL_AoD_ProvideLocationInformation_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_AoD_SignalMeasurementInformation_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_DL_AoD_LocationInformation_r16 = -1;
static gint ett_lpp_NR_DL_AoD_SignalMeasurementInformation_r16 = -1;
static gint ett_lpp_NR_DL_AoD_MeasList_r16 = -1;
static gint ett_lpp_NR_DL_AoD_MeasElement_r16 = -1;
static gint ett_lpp_T_nr_los_nlos_Indicator_r17_01 = -1;
static gint ett_lpp_NR_DL_AoD_AdditionalMeasurements_r16 = -1;
static gint ett_lpp_NR_DL_AoD_AdditionalMeasurementsExt_r17 = -1;
static gint ett_lpp_NR_DL_AoD_AdditionalMeasurementElement_r16 = -1;
static gint ett_lpp_NR_DL_AoD_AdditionalMeasurementElement_r17 = -1;
static gint ett_lpp_NR_DL_AoD_LocationInformation_r16 = -1;
static gint ett_lpp_T_measurementReferenceTime_r16_01 = -1;
static gint ett_lpp_NR_DL_AoD_RequestLocationInformation_r16 = -1;
static gint ett_lpp_NR_DL_AoD_ReportConfig_r16 = -1;
static gint ett_lpp_T_nr_los_nlos_IndicatorRequest_r17_01 = -1;
static gint ett_lpp_NR_DL_AoD_ProvideCapabilities_r16 = -1;
static gint ett_lpp_T_nr_PosCalcAssistanceSupport_r17_01 = -1;
static gint ett_lpp_T_nr_los_nlos_AssistanceDataSupport_r17_01 = -1;
static gint ett_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01 = -1;
static gint ett_lpp_T_nr_los_nlos_IndicatorSupport_r17_01 = -1;
static gint ett_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_01 = -1;
static gint ett_lpp_NR_DL_AoD_MeasurementCapability_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16 = -1;
static gint ett_lpp_DL_AoD_MeasCapabilityPerBand_r16 = -1;
static gint ett_lpp_NR_DL_AoD_RequestCapabilities_r16 = -1;
static gint ett_lpp_NR_DL_AoD_Error_r16 = -1;
static gint ett_lpp_NR_DL_AoD_LocationServerErrorCauses_r16 = -1;
static gint ett_lpp_NR_DL_AoD_TargetDeviceErrorCauses_r16 = -1;
static gint ett_lpp_NR_Multi_RTT_ProvideAssistanceData_r16 = -1;
static gint ett_lpp_NR_Multi_RTT_RequestAssistanceData_r16 = -1;
static gint ett_lpp_T_nr_AdType_r16_02 = -1;
static gint ett_lpp_NR_Multi_RTT_ProvideLocationInformation_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxMeasInstances_r17_OF_NR_Multi_RTT_SignalMeasurementInformation_r16 = -1;
static gint ett_lpp_NR_Multi_RTT_SignalMeasurementInformation_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_maxTxTEG_Sets_r17_OF_NR_SRS_TxTEG_Element_r17 = -1;
static gint ett_lpp_NR_Multi_RTT_MeasList_r16 = -1;
static gint ett_lpp_NR_Multi_RTT_MeasElement_r16 = -1;
static gint ett_lpp_T_nr_UE_RxTxTimeDiff_r16 = -1;
static gint ett_lpp_T_nr_los_nlos_Indicator_r17_02 = -1;
static gint ett_lpp_NR_Multi_RTT_AdditionalMeasurements_r16 = -1;
static gint ett_lpp_NR_Multi_RTT_AdditionalMeasurementsExt_r17 = -1;
static gint ett_lpp_NR_Multi_RTT_AdditionalMeasurementElement_r16 = -1;
static gint ett_lpp_T_nr_UE_RxTxTimeDiffAdditional_r16 = -1;
static gint ett_lpp_NR_SRS_TxTEG_Element_r17 = -1;
static gint ett_lpp_T_carrierFreq_r17 = -1;
static gint ett_lpp_T_srs_PosResourceList_r17 = -1;
static gint ett_lpp_NR_UE_RxTx_TEG_Info_r17 = -1;
static gint ett_lpp_T_case1_r17 = -1;
static gint ett_lpp_T_case2_r17 = -1;
static gint ett_lpp_T_case3_r17 = -1;
static gint ett_lpp_NR_Multi_RTT_RequestLocationInformation_r16 = -1;
static gint ett_lpp_T_nr_RequestedMeasurements_r16_01 = -1;
static gint ett_lpp_T_nr_los_nlos_IndicatorRequest_r17_02 = -1;
static gint ett_lpp_NR_Multi_RTT_ReportConfig_r16 = -1;
static gint ett_lpp_NR_Multi_RTT_ProvideCapabilities_r16 = -1;
static gint ett_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02 = -1;
static gint ett_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17 = -1;
static gint ett_lpp_T_nr_los_nlos_IndicatorSupport_r17_02 = -1;
static gint ett_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_02 = -1;
static gint ett_lpp_NR_Multi_RTT_MeasurementCapability_r16 = -1;
static gint ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17 = -1;
static gint ett_lpp_Multi_RTT_MeasCapabilityPerBand_r17 = -1;
static gint ett_lpp_NR_Multi_RTT_RequestCapabilities_r16 = -1;
static gint ett_lpp_NR_Multi_RTT_Error_r16 = -1;
static gint ett_lpp_NR_Multi_RTT_LocationServerErrorCauses_r16 = -1;
static gint ett_lpp_NR_Multi_RTT_TargetDeviceErrorCauses_r16 = -1;
static gint ett_lpp_AssistanceDataSIBelement_r15 = -1;
static gint ett_lpp_CipheringKeyData_r15 = -1;
static gint ett_lpp_SegmentationInfo_r15 = -1;
static gint ett_lpp_OTDOA_UE_Assisted_r15 = -1;
static gint ett_lpp_NR_UEB_TRP_LocationData_r16 = -1;
static gint ett_lpp_NR_UEB_TRP_RTD_Info_r16 = -1;

/* Include constants */
#define maxEPDU                        16
#define maxAddPRSconfig_r14            2
#define maxAvailNarrowBands_Minus1_r14 15
#define maxFreqLayers                  3
#define maxCarrier_r14                 5
#define maxCells_r14                   72
#define maxPaths_r14                   2
#define maxBands                       64
#define maxFBI                         64
#define maxFBI_Plus1                   65
#define maxFBI2                        256
#define maxEARFCN                      65535
#define maxEARFCN_Plus1                65536
#define maxEARFCN2                     262143
#define maxMBS_r14                     64
#define maxWLAN_AP_r13                 64
#define maxKnownAPs_r14                2048
#define maxVisibleAPs_r14              32
#define maxWLAN_AP_r14                 128
#define maxWLAN_DataSets_r14           8
#define maxBT_Beacon_r13               32
#define nrMaxBands_r16                 1024
#define nrMaxFreqLayers_r16            4
#define nrMaxFreqLayers_1_r16          3
#define nrMaxNumDL_PRS_ResourcesPerSet_1_r16 63
#define nrMaxNumDL_PRS_ResourceSetsPerTRP_1_r16 7
#define nrMaxResourceIDs_r16           64
#define nrMaxResourceOffsetValue_1_r16 511
#define nrMaxResourcesPerSet_r16       64
#define nrMaxSetsPerTrpPerFreqLayer_r16 2
#define nrMaxSetsPerTrpPerFreqLayer_1_r16 1
#define nrMaxTRPs_r16                  256
#define nrMaxTRPsPerFreq_r16           64
#define nrMaxTRPsPerFreq_1_r16         63
#define maxSimultaneousBands_r16       4
#define maxBandComb_r16                1024
#define nrMaxConfiguredBands_r16       16
#define maxNumOfRxTEGs_r17             32
#define maxNumOfRxTEGs_1_r17           31
#define maxNumOfTxTEGs_1_r17           7
#define maxTxTEG_Sets_r17              256
#define maxNumOfRxTxTEGs_1_r17         255
#define maxNumOfTRP_TxTEGs_1_r17       7
#define maxNumOfSRS_PosResources_r17   64
#define maxNumOfSRS_PosResources_1_r17 63
#define maxNumResourcesPerAngle_r17    24
#define maxNumPrioResources_r17        24
#define maxAddMeasTDOA_r17             31
#define maxAddMeasAoD_r17              23
#define maxAddMeasRTT_r17              31
#define maxOD_DL_PRS_Configs_r17       8
#define maxCellIDsPerArea_r17          256
#define maxNrOfAreas_r17               16
#define maxMeasInstances_r17           32

typedef enum _T_GNSS_ID_enum {
  T_GNSS_ID_GPS =   0,
  T_GNSS_ID_SBAS =   1,
  T_GNSS_ID_QZSS =   2,
  T_GNSS_ID_GALILEO =   3,
  T_GNSS_ID_GLONASS =   4,
  T_GNSS_ID_BDS =   5,
  T_GNSS_ID_NAVIC_V1610 =   6
} T_GNSS_ID_enum;

static const value_string lpp_ePDU_ID_vals[] = {
  { 1, "OMA LPP extensions (LPPe)"},
  { 0, NULL}
};

struct lpp_private_data {
  lpp_pos_sib_type_t pos_sib_type;
  gboolean is_ciphered;
  gboolean is_segmented;
};

static struct lpp_private_data*
lpp_get_private_data(packet_info *pinfo)
{
  struct lpp_private_data *lpp_data = (struct lpp_private_data*)p_get_proto_data(pinfo->pool, pinfo, proto_lpp, 0);
  if (!lpp_data) {
    lpp_data = wmem_new0(pinfo->pool, struct lpp_private_data);
    p_add_proto_data(pinfo->pool, pinfo, proto_lpp, 0, lpp_data);
  }
  return lpp_data;
}

/* Forward declarations */
static int dissect_GNSS_ReferenceTime_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_ReferenceLocation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_IonosphericModel_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_EarthOrientationParameters_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_ReferenceStationInfo_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_CommonObservationInfo_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_AuxiliaryStationData_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_CorrectionPoints_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_Integrity_ServiceParameters_r17_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_Integrity_ServiceAlert_r17_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_TimeModelList_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_DifferentialCorrections_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_NavigationModel_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RealTimeIntegrity_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_DataBitAssistance_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_AcquisitionAssistance_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_Almanac_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_UTC_Model_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_AuxiliaryInformation_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_BDS_DifferentialCorrections_r12_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_BDS_GridModelParameter_r12_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_Observations_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GLO_RTK_BiasInformation_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_MAC_CorrectionDifferences_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_Residuals_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_RTK_FKP_Gradients_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_OrbitCorrections_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_ClockCorrections_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_CodeBias_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_URA_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_PhaseBias_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_STEC_Correction_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_GNSS_SSR_GriddedCorrection_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NavIC_DifferentialCorrections_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NavIC_GridModelParameter_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_OTDOA_UE_Assisted_r15_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_Sensor_AssistanceDataList_r14_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_TBS_AssistanceDataList_r14_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_DL_PRS_AssistanceData_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_UEB_TRP_LocationData_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_UEB_TRP_RTD_Info_r16_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_TRP_BeamAntennaInfo_r17_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_DL_PRS_TRP_TEG_Info_r17_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);
static int dissect_NR_On_Demand_DL_PRS_Configurations_r17_PDU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, void *data _U_);

static void
lpp_degreesLatitude_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%f degrees (%u)",
             ((float)v/8388607.0)*90, v);
}

static void
lpp_degreesLongitude_fmt(gchar *s, guint32 v)
{
  gint32 longitude = (gint32) v;

  snprintf(s, ITEM_LABEL_LENGTH, "%f degrees (%d)",
             ((float)longitude/8388608.0)*180, longitude);
}

static void
lpp_uncertainty_fmt(gchar *s, guint32 v)
{
  double uncertainty = 10*(pow(1.1, (double)v)-1);

  if (uncertainty < 1000) {
    snprintf(s, ITEM_LABEL_LENGTH, "%fm (%u)", uncertainty, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%fkm (%u)", uncertainty/1000, v);
  }
}

static void
lpp_angle_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%u degrees (%u)", 2*v, v);
}

static void
lpp_confidence_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "no information (0)");
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%u%%", v);
  }
}

static void
lpp_1_10_degrees_fmt(gchar *s, guint32 v)
{
  double val = (double)v/10;

  snprintf(s, ITEM_LABEL_LENGTH, "%g degrees (%u)", val, v);
}

static void
lpp_1_100_m_fmt(gchar *s, guint32 v)
{
  double val = (double)v/100;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%u)", val, v);
}

static void
lpp_measurementLimit_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%u octets (%u)", 100*v, v);
}

static void
lpp_altitude_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%um", v);
}

static void
lpp_uncertaintyAltitude_fmt(gchar *s, guint32 v)
{
  double uncertainty = 45*(pow(1.025, (double)v)-1);

  snprintf(s, ITEM_LABEL_LENGTH, "%fm (%u)", uncertainty, v);
}

static void
lpp_radius_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%um (%u)", 5*v, v);
}

static void
lpp_nr_LTE_fineTiming_Offset_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%.1fms (%u)", (float)v/2, v);
}

static void
lpp_expectedRSTD_fmt(gchar *s, guint32 v)
{
  gint32 rstd = 3*((gint32)v-8192);

  snprintf(s, ITEM_LABEL_LENGTH, "%dTs (%u)", rstd, v);
}

static void
lpp_expectedRSTD_Uncertainty_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%uTs (%u)", 3*v, v);
}

static void
lpp_rstd_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSTD < -15391Ts (0)");
  } else if (v < 2260) {
    snprintf(s, ITEM_LABEL_LENGTH, "-%uTs <= RSTD < -%uTs (%u)", 15391-5*(v-1), 15391-5*v, v);
  } else if (v < 6355) {
    snprintf(s, ITEM_LABEL_LENGTH, "-%uTs <= RSTD < -%uTs (%u)", 6356-v, 6355-v, v);
  } else if (v == 6355) {
    snprintf(s, ITEM_LABEL_LENGTH, "-1Ts <= RSTD <= 0Ts (6355)");
  } else if (v < 10452) {
    snprintf(s, ITEM_LABEL_LENGTH, "%uTs < RSTD <= %uTs (%u)", v-6356, v-6355, v);
  } else if (v < 12711) {
    snprintf(s, ITEM_LABEL_LENGTH, "%uTs < RSTD <= %uTs (%u)", 5*(v-1)-48159, 5*v-48159, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "15391Ts < RSTD (12711)");
  }
}

static const value_string lpp_error_Resolution_vals[] = {
  { 0, "5 meters"},
  { 1, "10 meters"},
  { 2, "20 meters"},
  { 3, "30 meters"},
  { 0, NULL}
};

static const value_string lpp_error_Value_vals[] = {
  {  0, "0 to (R*1-1) meters"},
  {  1, "R*1 to (R*2-1) meters"},
  {  2, "R*2 to (R*3-1) meters"},
  {  3, "R*3 to (R*4-1) meters"},
  {  4, "R*4 to (R*5-1) meters"},
  {  5, "R*5 to (R*6-1) meters"},
  {  6, "R*6 to (R*7-1) meters"},
  {  7, "R*7 to (R*8-1) meters"},
  {  8, "R*8 to (R*9-1) meters"},
  {  9, "R*9 to (R*10-1) meters"},
  { 10, "R*10 to (R*11-1) meters"},
  { 11, "R*11 to (R*12-1) meters"},
  { 12, "R*12 to (R*13-1) meters"},
  { 13, "R*13 to (R*14-1) meters"},
  { 14, "R*14 to (R*15-1) meters"},
  { 15, "R*15 to (R*16-1) meters"},
  { 16, "R*16 to (R*17-1) meters"},
  { 17, "R*17 to (R*18-1) meters"},
  { 18, "R*18 to (R*19-1) meters"},
  { 19, "R*19 to (R*20-1) meters"},
  { 20, "R*20 to (R*21-1) meters"},
  { 21, "R*21 to (R*22-1) meters"},
  { 22, "R*22 to (R*23-1) meters"},
  { 23, "R*23 to (R*24-1) meters"},
  { 24, "R*24 to (R*25-1) meters"},
  { 25, "R*25 to (R*26-1) meters"},
  { 26, "R*26 to (R*27-1) meters"},
  { 27, "R*27 to (R*28-1) meters"},
  { 28, "R*28 to (R*29-1) meters"},
  { 29, "R*29 to (R*30-1) meters"},
  { 30, "R*30 to (R*31-1) meters"},
  { 31, "R*31 meters or more"},
  { 0, NULL}
};
static value_string_ext lpp_error_Value_vals_ext = VALUE_STRING_EXT_INIT(lpp_error_Value_vals);

static const value_string lpp_error_NumSamples_vals[] = {
  {  0, "Not the baseline metric"},
  {  1, "5-9"},
  {  2, "10-14"},
  {  3, "15-24"},
  {  4, "25-34"},
  {  5, "35-44"},
  {  6, "45-54"},
  {  7, "55 or more"},
  { 0, NULL}
};

static void
lpp_relativeTimeDifference_fmt(gchar *s, guint32 v)
{
  double rtd = (double)((gint32)v)*0.5;

  snprintf(s, ITEM_LABEL_LENGTH, "%.1f Ts (%d)", rtd, (gint32)v);
}

static void
lpp_referenceTimeUnc_fmt(gchar *s, guint32 v)
{
  double referenceTimeUnc = 0.5*(pow(1.14, (double)v)-1);

  snprintf(s, ITEM_LABEL_LENGTH, "%fus (%u)", referenceTimeUnc, v);
}

static const value_string lpp_kp_vals[] = {
  { 0, "No UTC correction at the end of current quarter"},
  { 1, "UTC correction by plus (+1 s) in the end of current quarter"},
  { 3, "UTC correction by minus (-1 s) in the end of current quarter"},
  { 0, NULL}
};

static void
lpp_fractionalSecondsFromFrameStructureStart_fmt(gchar *s, guint32 v)
{
  float frac = ((float)v)/4;

  snprintf(s, ITEM_LABEL_LENGTH, "%fus (%u)", frac, v);
}

static void
lpp_frameDrift_fmt(gchar *s, guint32 v)
{
  double drift = (double)((gint32)v)*pow(2, -30);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", drift, (gint32)v);
}

static const value_string lpp_dataID_vals[] = {
  { 0, "Parameters are applicable worldwide"},
  { 1, "Parameters have been generated by BDS"},
  { 3, "Parameters have been generated by QZSS"},
  { 0, NULL}
};

static void
lpp_alpha0_fmt(gchar *s, guint32 v)
{
  double alpha = (double)((gint32)v)*pow(2, -30);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", alpha, (gint32)v);
}

static void
lpp_alpha1_fmt(gchar *s, guint32 v)
{
  double alpha = (double)((gint32)v)*pow(2, -27);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/semi-circle (%d)", alpha, (gint32)v);
}

static void
lpp_alpha2_3_fmt(gchar *s, guint32 v)
{
  double alpha = (double)((gint32)v)*pow(2, -24);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/semi-circle (%d)", alpha, (gint32)v);
}

static void
lpp_beta0_fmt(gchar *s, guint32 v)
{
  double beta = (double)((gint32)v)*pow(2, 11);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", beta, (gint32)v);
}

static void
lpp_beta1_fmt(gchar *s, guint32 v)
{
  double beta = (double)((gint32)v)*pow(2, 14);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/semi-circle (%d)", beta, (gint32)v);
}

static void
lpp_beta2_3_fmt(gchar *s, guint32 v)
{
  double beta = (double)((gint32)v)*pow(2, 16);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/semi-circle (%d)", beta, (gint32)v);
}

static void
lpp_ai0_fmt(gchar *s, guint32 v)
{
  double ai = (double)v*pow(2, -2);

  snprintf(s, ITEM_LABEL_LENGTH, "%gsfu (%u)", ai, v);
}

static void
lpp_ai1_fmt(gchar *s, guint32 v)
{
  double ai = (double)v*pow(2, -8);

  snprintf(s, ITEM_LABEL_LENGTH, "%gsfu/degree (%u)", ai, v);
}

static void
lpp_ai2_fmt(gchar *s, guint32 v)
{
  double ai = (double)v*pow(2, -15);

  snprintf(s, ITEM_LABEL_LENGTH, "%gsfu/degree2 (%u)", ai, v);
}

static void
lpp_teop_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", 16*v, v);
}

static void
lpp_pmX_Y_fmt(gchar *s, guint32 v)
{
  double pm = (double)((gint32)v)*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%g arc-seconds (%d)", pm, (gint32)v);
}

static void
lpp_pmX_Ydot_fmt(gchar *s, guint32 v)
{
  double pmDot = (double)((gint32)v)*pow(2, -21);

  snprintf(s, ITEM_LABEL_LENGTH, "%g arc-seconds/day (%d)", pmDot, (gint32)v);
}

static void
lpp_deltaUT1_fmt(gchar *s, guint32 v)
{
  double deltaUT1 = (double)((gint32)v)*pow(2, -24);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", deltaUT1, (gint32)v);
}

static void
lpp_deltaUT1dot_fmt(gchar *s, guint32 v)
{
  double deltaUT1dot = (double)((gint32)v)*pow(2, -25);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/day (%d)", deltaUT1dot, (gint32)v);
}

static void
lpp_1_1000m_64_fmt(gchar *s, uint64_t v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%"PRId64")", (double)v/1000, (int64_t)v);
}

static void
lpp_1_1000m_32_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", (double)v/1000, (gint32)v);
}

static const value_string lpp_clockSteeringIndicator_vals[] = {
  { 0, "Clock steering is not applied"},
  { 1, "Clock steering has been applied"},
  { 2, "Unknown clock steering status"},
  { 3, "Reserved"},
  { 0, NULL}
};

static const value_string lpp_externalClockIndicator_vals[] = {
  { 0, "Internal clock is used"},
  { 1, "External clock is used, clock status is \"locked\""},
  { 2, "External clock is used, clock status is \"not locked\", which may indicate external clock failure and that the transmitted data may not be reliable"},
  { 3, "Unknown clock is used"},
  { 0, NULL}
};

static const value_string lpp_smoothingIndicator_r15_vals[] = {
  { 0, "Other type of smoothing is used"},
  { 1, "Divergence-free smoothing is used"},
  { 0, NULL}
};

static const value_string lpp_smoothingInterval_r15_vals[] = {
  { 0, "No smoothing"},
  { 1, "< 30 s"},
  { 2, "30-60 s"},
  { 3, "1-2 min"},
  { 4, "2-4 min"},
  { 5, "4-8 min"},
  { 6, "> 8 min"},
  { 7, "Unlimited smoothing interval"},
  { 0, NULL}
};

static void
lpp_aux_master_delta_fmt(gchar *s, guint32 v)
{
  double delta = (double)((gint32)v)*25*pow(10, -6);
  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%u)", delta, (gint32)v);
}

static void
lpp_gnss_TimeModelRefTime_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", v*16, v);
}

static void
lpp_tA0_fmt(gchar *s, guint32 v)
{
  double tA0 = (double)((gint32)v)*pow(2, -35);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", tA0, (gint32)v);
}

static void
lpp_tA1_fmt(gchar *s, guint32 v)
{
  double tA1 = (double)((gint32)v)*pow(2, -51);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", tA1, (gint32)v);
}

static void
lpp_tA2_fmt(gchar *s, guint32 v)
{
  double tA2 = (double)((gint32)v)*pow(2, -68);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s2 (%d)", tA2, (gint32)v);
}

static const value_string lpp_gnss_TO_ID_vals[] = {
  { 1, "GPS"},
  { 2, "Galileo"},
  { 3, "QZSS"},
  { 4, "GLONASS"},
  { 0, NULL}
};

static const value_string lpp_gnss_StatusHealth_vals[] = {
  { 0, "UDRE Scale Factor = 1.0"},
  { 1, "UDRE Scale Factor = 0.75"},
  { 2, "UDRE Scale Factor = 0.5"},
  { 3, "UDRE Scale Factor = 0.3"},
  { 4, "UDRE Scale Factor = 0.2"},
  { 5, "UDRE Scale Factor = 0.1"},
  { 6, "Reference Station Transmission Not Monitored"},
  { 7, "Data is invalid - disregard"},
  { 0, NULL}
};

static const value_string lpp_udre_vals[] = {
  { 0, "UDRE <= 1.0m"},
  { 1, "1.0m < UDRE <= 4.0m"},
  { 2, "4.0m < UDRE <= 8.0m"},
  { 3, "8.0m < UDRE"},
  { 0, NULL}
};

static void
lpp_pseudoRangeCor_fmt(gchar *s, guint32 v)
{
  double pseudoRangeCor = ((double)(gint32)v)*0.32;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm (%d)", pseudoRangeCor, (gint32)v);
}

static void
lpp_rangeRateCor_fmt(gchar *s, guint32 v)
{
  double rangeRateCor = ((double)(gint32)v)*0.032;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm/s (%d)", rangeRateCor, (gint32)v);
}

static const value_string lpp_udreGrowthRate_vals[] = {
  { 0, "1.5"},
  { 1, "2"},
  { 2, "4"},
  { 3, "6"},
  { 4, "8"},
  { 5, "10"},
  { 6, "12"},
  { 7, "16"},
  { 0, NULL}
};

static const value_string lpp_udreValidityTime_vals[] = {
  { 0, "20s"},
  { 1, "40s"},
  { 2, "80s"},
  { 3, "160s"},
  { 4, "320s"},
  { 5, "640s"},
  { 6, "1280s"},
  { 7, "2560s"},
  { 0, NULL}
};

static const value_string lpp_signal_health_status_vals[] = {
  { 0, "Signal OK"},
  { 1, "Signal out of service"},
  { 2, "Signal will be out of service"},
  { 3, "Signal Component currently in Test"},
  { 0, NULL}
};
static void
lpp_stanClockToc_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%um/s (%u)", 60*v, v);
}

static void
lpp_stanClockAF2_fmt(gchar *s, guint32 v)
{
  double stanClockAF2 = (double)((gint32)v)*pow(2, -59);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s2 (%d)", stanClockAF2, (gint32)v);
}

static void
lpp_stanClockAF1_fmt(gchar *s, guint32 v)
{
  double stanClockAF1 = (double)((gint32)v)*pow(2, -46);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", stanClockAF1, (gint32)v);
}

static void
lpp_stanClockAF0_fmt(gchar *s, guint32 v)
{
  double stanClockAF0 = (double)((gint32)v)*pow(2, -34);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", stanClockAF0, (gint32)v);
}

static void
lpp_stanClockTgd_fmt(gchar *s, guint32 v)
{
  double stanClockTgd = (double)((gint32)v)*pow(2, -32);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", stanClockTgd, (gint32)v);
}

static void
lpp_sisa_fmt(gchar *s, guint32 v)
{
  if (v < 50) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ucm (%u)", v, v);
  } else if (v < 75) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ucm (%u)", 50+((v-50)*2), v);
  } else if (v < 100) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ucm (%u)", 100+((v-75)*4), v);
  } else if (v < 126) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ucm (%u)", 200+((v-100)*16), v);
  } else if (v < 255) {
    snprintf(s, ITEM_LABEL_LENGTH, "Spare (%u)", v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "No Accuracy Prediction Available (255)");
  }
}

static const value_string lpp_stanModelID_vals[] = {
  { 0, "I/Nav"},
  { 1, "F/Nav"},
  { 0, NULL}
};

static void
lpp_navToc_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", 16*v, v);
}

static void
lpp_navaf2_fmt(gchar *s, guint32 v)
{
  double navaf2 = (double)((gint32)v)*pow(2, -55);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s2 (%d)", navaf2, (gint32)v);
}

static void
lpp_navaf1_fmt(gchar *s, guint32 v)
{
  double navaf1 = (double)((gint32)v)*pow(2, -43);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", navaf1, (gint32)v);
}

static void
lpp_navaf0_navTgd_fmt(gchar *s, guint32 v)
{
  double navaf0_navTgd = (double)((gint32)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", navaf0_navTgd, (gint32)v);
}

static void
lpp_cnavToc_cnavTop_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", 300*v, v);
}

static void
lpp_cnavAf2_fmt(gchar *s, guint32 v)
{
  double cnavAf2 = (double)((gint32)v)*pow(2, -60);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s2 (%d)", cnavAf2, (gint32)v);
}

static void
lpp_cnavAf1_fmt(gchar *s, guint32 v)
{
  double cnavAf1 = (double)((gint32)v)*pow(2, -48);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", cnavAf1, (gint32)v);
}

static void
lpp_cnavX_fmt(gchar *s, guint32 v)
{
  double cnavX = (double)((gint32)v)*pow(2, -35);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", cnavX, (gint32)v);
}

static void
lpp_gloTau_gloDeltaTau_fmt(gchar *s, guint32 v)
{
  double gloTau_gloDeltaTau = (double)((gint32)v)*pow(2, -30);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", gloTau_gloDeltaTau, (gint32)v);
}

static void
lpp_gloGamma_fmt(gchar *s, guint32 v)
{
  double gloGamma = (double)((gint32)v)*pow(2, -40);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%d)", gloGamma, (gint32)v);
}

static void
lpp_sbasTo_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", 16*v, v);
}

static void
lpp_sbasAgfo_fmt(gchar *s, guint32 v)
{
  double sbasAgfo = (double)((gint32)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", sbasAgfo, (gint32)v);
}

static void
lpp_sbasAgf1_fmt(gchar *s, guint32 v)
{
  double sbasAgf1 = (double)((gint32)v)*pow(2, -40);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", sbasAgf1, (gint32)v);
}

static void
lpp_bdsAODC_AODE_r12_fmt(gchar *s, guint32 v)
{
  if (v < 25) {
    snprintf(s, ITEM_LABEL_LENGTH, "Age of the satellite clock correction parameters is %u hours (%u)", v, v);
  } else if (v < 31) {
    snprintf(s, ITEM_LABEL_LENGTH, "Age of the satellite clock correction parameters is %u days (%u)", v-23, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "Age of the satellite clock correction parameters is over 7 days (%u)", v);
  }
}


static void
lpp_bdsToc_Toe_r12_fmt(gchar *s, guint32 v)
{
  double bdsToc = (double)((gint32)v)*pow(2, 3);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", bdsToc, (gint32)v);
}

static void
lpp_bdsA0_r12_fmt(gchar *s, guint32 v)
{
  double bdsA0 = (double)((gint32)v)*pow(2, -33);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", bdsA0, (gint32)v);
}

static void
lpp_bdsA1_r12_fmt(gchar *s, guint32 v)
{
  double bdsA1 = (double)((gint32)v)*pow(2, -50);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", bdsA1, (gint32)v);
}

static void
lpp_bdsA2_r12_fmt(gchar *s, guint32 v)
{
  double bdsA2 = (double)((gint32)v)*pow(2, -66);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s2 (%d)", bdsA2, (gint32)v);
}

static void
lpp_bdsTgd1_r12_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%gns (%d)", (float)((gint32)v)*0.1, (gint32)v);
}

static void
lpp_keplerToe_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", 60*v, v);
}

static void
lpp_keplerW_M0_I0_Omega0_fmt(gchar *s, guint32 v)
{
  double keplerW_M0_I0_Omega0 = (double)((gint32)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", keplerW_M0_I0_Omega0, (gint32)v);
}

static void
lpp_keplerDeltaN_OmegaDot_IDot_fmt(gchar *s, guint32 v)
{
  double keplerDeltaN_OmegaDot_IDot = (double)((gint32)v)*pow(2, -43);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", keplerDeltaN_OmegaDot_IDot, (gint32)v);
}

static void
lpp_keplerE_fmt(gchar *s, guint32 v)
{
  double keplerE = (double)v*pow(2, -33);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", keplerE, v);
}

static void
lpp_keplerAPowerHalf_fmt(gchar *s, guint32 v)
{
  double keplerAPowerHalf = (double)v*pow(2, -19);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%u)", keplerAPowerHalf, v);
}

static void
lpp_keplerCrs_Crc_fmt(gchar *s, guint32 v)
{
  double keplerCrs_Crc = (double)((gint32)v)*pow(2, -5);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", keplerCrs_Crc, (gint32)v);
}

static void
lpp_keplerCx_fmt(gchar *s, guint32 v)
{
  double keplerCx = (double)((gint32)v)*pow(2, -29);

  snprintf(s, ITEM_LABEL_LENGTH, "%grad (%d)", keplerCx, (gint32)v);
}

static void
lpp_navToe_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", 16*v, v);
}

static void
lpp_navOmega_M0_I0_OmegaA0_fmt(gchar *s, guint32 v)
{
  double navOmega_M0_I0_OmegaA0 = (double)((gint32)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", navOmega_M0_I0_OmegaA0, (gint32)v);
}

static void
lpp_navDeltaN_OmegaADot_IDot_fmt(gchar *s, guint32 v)
{
  double navDeltaN_OmegaADot_IDot = (double)((gint32)v)*pow(2, -43);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", navDeltaN_OmegaADot_IDot, (gint32)v);
}

static void
lpp_navE_fmt(gchar *s, guint32 v)
{
  double navE = (double)v*pow(2, -33);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", navE, v);
}

static void
lpp_navAPowerHalf_fmt(gchar *s, guint32 v)
{
  double navAPowerHalf = (double)v*pow(2, -19);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%u)", navAPowerHalf, v);
}

static void
lpp_navCrs_Crc_fmt(gchar *s, guint32 v)
{
  double navCrs_Crc = (double)((gint32)v)*pow(2, -5);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", navCrs_Crc, (gint32)v);
}

static void
lpp_navCx_fmt(gchar *s, guint32 v)
{
  double navCx = (double)((gint32)v)*pow(2, -29);

  snprintf(s, ITEM_LABEL_LENGTH, "%grad (%d)", navCx, (gint32)v);
}

static void
lpp_cnavDeltaA_fmt(gchar *s, guint32 v)
{
  double cnavDeltaA = (double)((gint32)v)*pow(2, -9);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", cnavDeltaA, (gint32)v);
}

static void
lpp_cnavAdot_fmt(gchar *s, guint32 v)
{
  double cnavAdot = (double)((gint32)v)*pow(2, -21);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s (%d)", cnavAdot, (gint32)v);
}

static void
lpp_cnavDeltaNo_fmt(gchar *s, guint32 v)
{
  double cnavDeltaNo = (double)((gint32)v)*pow(2, -44);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", cnavDeltaNo, (gint32)v);
}

static void
lpp_cnavDeltaNoDot_fmt(gchar *s, guint32 v)
{
  double cnavDeltaNoDot = (double)((gint32)v)*pow(2, -57);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s2 (%d)", cnavDeltaNoDot, (gint32)v);
}

static void
lpp_cnavDeltaOmegaDot_IoDot_fmt(gchar *s, guint32 v)
{
  double cnavDeltaOmegaDot_IoDot = (double)((gint32)v)*pow(2, -44);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", cnavDeltaOmegaDot_IoDot, (gint32)v);
}

static void
lpp_cnavCx_fmt(gchar *s, guint32 v)
{
  double cnavCx = (double)((gint32)v)*pow(2, -30);

  snprintf(s, ITEM_LABEL_LENGTH, "%grad (%d)", cnavCx, (gint32)v);
}

static void
lpp_cnavCrs_Crc_fmt(gchar *s, guint32 v)
{
  double cnavCrs_Crc = (double)((gint32)v)*pow(2, -8);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", cnavCrs_Crc, (gint32)v);
}

static void
lpp_gloX_Y_Z_fmt(gchar *s, guint32 v)
{
  double gloX_Y_Z = (double)((gint32)v)*pow(2, -11);

  snprintf(s, ITEM_LABEL_LENGTH, "%gkm (%d)", gloX_Y_Z, (gint32)v);
}

static void
lpp_gloXdot_Ydot_Zdot_fmt(gchar *s, guint32 v)
{
  double gloXdot_Ydot_Zdot = (double)((gint32)v)*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%gkm/s (%d)", gloXdot_Ydot_Zdot, (gint32)v);
}

static void
lpp_gloXdotdot_Ydotdot_Zdotdot_fmt(gchar *s, guint32 v)
{
  double gloXdotdot_Ydotdot_Zdotdot = (double)((gint32)v)*pow(2, -30);

  snprintf(s, ITEM_LABEL_LENGTH, "%gkm/s2 (%d)", gloXdotdot_Ydotdot_Zdotdot, (gint32)v);
}

static void
lpp_sbasXg_Yg_fmt(gchar *s, guint32 v)
{
  double sbasXg_Yg = (double)((gint32)v)*0.08;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm (%d)", sbasXg_Yg, (gint32)v);
}

static void
lpp_sbasZg_fmt(gchar *s, guint32 v)
{
  double sbasZg = (double)((gint32)v)*0.4;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm (%d)", sbasZg, (gint32)v);
}

static void
lpp_sbasXgDot_YgDot_fmt(gchar *s, guint32 v)
{
  double sbasXgDot_YgDot = (double)((gint32)v)*0.000625;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm/s (%d)", sbasXgDot_YgDot, (gint32)v);
}

static void
lpp_sbasZgDot_fmt(gchar *s, guint32 v)
{
  double sbasZgDot = (double)((gint32)v)*0.004;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm/s (%d)", sbasZgDot, (gint32)v);
}

static void
lpp_sbasXgDotDot_YgDotDot_fmt(gchar *s, guint32 v)
{
  double sbasXgDotDot_YgDotDot = (double)((gint32)v)*0.0000125;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s2 (%d)", sbasXgDotDot_YgDotDot, (gint32)v);
}

static void
lpp_sbasZgDotDot_fmt(gchar *s, guint32 v)
{
  double sbasZgDotDot = (double)((gint32)v)*0.0000625;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s2 (%d)", sbasZgDotDot, (gint32)v);
}

static void
lpp_bdsAPowerHalf_r12_fmt(gchar *s, guint32 v)
{
  double bdsAPowerHalf = (double)v*pow(2, -19);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%u)", bdsAPowerHalf, v);
}

static void
lpp_bdsE_r12_fmt(gchar *s, guint32 v)
{
  double bdsE = (double)v*pow(2, -33);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", bdsE, v);
}

static void
lpp_bdsW_M0_Omega0_I0_r12_fmt(gchar *s, guint32 v)
{
  double bdsW_M0_Omega0_I0 = (double)((gint32)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", bdsW_M0_Omega0_I0, (gint32)v);
}

static void
lpp_bdsDeltaN_OmegaDot_IDot_r12_fmt(gchar *s, guint32 v)
{
  double bdsDeltaN_OmegaDot_IDot = (double)((gint32)v)*pow(2, -43);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", bdsDeltaN_OmegaDot_IDot, (gint32)v);
}

static void
lpp_bdsCuc_Cus_Cic_Cis_r12_fmt(gchar *s, guint32 v)
{
  double bdsCuc_Cus_Cic_Cis = (double)((gint32)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%grad (%d)", bdsCuc_Cus_Cic_Cis, (gint32)v);
}

static void
lpp_bdsCrc_Crs_r12_fmt(gchar *s, guint32 v)
{
  double bdsCrc_Crs = (double)((gint32)v)*pow(2, -6);

  snprintf(s, ITEM_LABEL_LENGTH, "%grad (%d)", bdsCrc_Crs, (gint32)v);
}

static void
lpp_doppler0_fmt(gchar *s, guint32 v)
{
  double doppler0 = (double)((gint32)v)*0.5;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm/s (%d)", doppler0, (gint32)v);
}

static void
lpp_doppler1_fmt(gchar *s, guint32 v)
{
  double doppler1 = (double)((gint32)(v-42))/210;

  snprintf(s, ITEM_LABEL_LENGTH, "%fm/s2 (%u)", doppler1, v);
}

static const value_string lpp_dopplerUncertainty_vals[] = {
  { 0, "40m/s"},
  { 1, "20m/s"},
  { 2, "10m/s"},
  { 3, "5m/s"},
  { 4, "2.5m/s"},
  { 0, NULL}
};

static void
lpp_codePhase_fmt(gchar *s, guint32 v)
{
  double codePhase = (double)v*pow(2, -10);

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%u)", codePhase, v);
}

static const value_string lpp_codePhaseSearchWindow_vals[] = {
  {  0, "No information"},
  {  1, "0.002ms"},
  {  2, "0.004ms"},
  {  3, "0.008ms"},
  {  4, "0.012ms"},
  {  5, "0.016ms"},
  {  6, "0.024ms"},
  {  7, "0.032ms"},
  {  8, "0.048ms"},
  {  9, "0.064ms"},
  { 10, "0.096ms"},
  { 11, "0.128ms"},
  { 12, "0.164ms"},
  { 13, "0.200ms"},
  { 14, "0.250ms"},
  { 15, "0.300ms"},
  { 16, "0.360ms"},
  { 17, "0.420ms"},
  { 18, "0.480ms"},
  { 19, "0.540ms"},
  { 20, "0.600ms"},
  { 21, "0.660ms"},
  { 22, "0.720ms"},
  { 23, "0.780ms"},
  { 24, "0.850ms"},
  { 25, "1.000ms"},
  { 26, "1.150ms"},
  { 27, "1.300ms"},
  { 28, "1.450ms"},
  { 29, "1.600ms"},
  { 30, "1.800ms"},
  { 31, "2.000ms"},
  { 0, NULL}
};
static value_string_ext lpp_codePhaseSearchWindow_vals_ext = VALUE_STRING_EXT_INIT(lpp_codePhaseSearchWindow_vals);

static void
lpp_azimuth_elevation_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%f degrees (%u)", (float)v*0.703125, v);
}

static void
lpp_kepAlmanacE_fmt(gchar *s, guint32 v)
{
  double kepAlmanacE = (double)v*pow(2, -16);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", kepAlmanacE, v);
}

static void
lpp_kepAlmanacDeltaI_fmt(gchar *s, guint32 v)
{
  double kepAlmanacDeltaI = (double)((gint32)v)*pow(2, -14);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", kepAlmanacDeltaI, (gint32)v);
}

static void
lpp_kepAlmanacOmegaDot_fmt(gchar *s, guint32 v)
{
  double kepAlmanacOmegaDot = (double)((gint32)v)*pow(2, -33);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", kepAlmanacOmegaDot, (gint32)v);
}

static void
lpp_kepAlmanacAPowerHalf_fmt(gchar *s, guint32 v)
{
  double kepAlmanacAPowerHalf = (double)((gint32)v)*pow(2, -9);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%d)", kepAlmanacAPowerHalf, (gint32)v);
}

static void
lpp_kepAlmanacOmega0_W_M0_fmt(gchar *s, guint32 v)
{
  double kepAlmanacOmega0_W_M0 = (double)((gint32)v)*pow(2, -15);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", kepAlmanacOmega0_W_M0, (gint32)v);
}

static void
lpp_kepAlmanacAF0_fmt(gchar *s, guint32 v)
{
  double kepAlmanacAF0 = (double)((gint32)v)*pow(2, -19);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", kepAlmanacAF0, (gint32)v);
}

static void
lpp_kepAlmanacAF1_fmt(gchar *s, guint32 v)
{
  double kepAlmanacAF1 = (double)((gint32)v)*pow(2, -38);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", kepAlmanacAF1, (gint32)v);
}

static void
lpp_navAlmE_fmt(gchar *s, guint32 v)
{
  double navAlmE = (double)v*pow(2, -21);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", navAlmE, v);
}

static void
lpp_navAlmDeltaI_fmt(gchar *s, guint32 v)
{
  double navAlmDeltaI = (double)((gint32)v)*pow(2, -19);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", navAlmDeltaI, (gint32)v);
}

static void
lpp_navAlmOMEGADOT_fmt(gchar *s, guint32 v)
{
  double navAlmOMEGADOT = (double)((gint32)v)*pow(2, -38);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", navAlmOMEGADOT, (gint32)v);
}

static void
lpp_navAlmSqrtA_fmt(gchar *s, guint32 v)
{
  double navAlmSqrtA = (double)v*pow(2, -11);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%u)", navAlmSqrtA, v);
}

static void
lpp_navAlmOMEGAo_Omega_Mo_fmt(gchar *s, guint32 v)
{
  double navAlmOMEGAo_Omega_Mo = (double)((gint32)v)*pow(2, -23);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", navAlmOMEGAo_Omega_Mo, (gint32)v);
}

static void
lpp_navAlmaf0_fmt(gchar *s, guint32 v)
{
  double navAlmaf0 = (double)((gint32)v)*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", navAlmaf0, (gint32)v);
}

static void
lpp_navAlmaf1_fmt(gchar *s, guint32 v)
{
  double navAlmaf1 = (double)((gint32)v)*pow(2, -38);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", navAlmaf1, (gint32)v);
}

static void
lpp_redAlmDeltaA_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%dm (%d)", 512*(gint)v, (gint)v);
}

static void
lpp_redAlmOmega0_Phi0_fmt(gchar *s, guint32 v)
{
  double redAlmOmega0_Phi0 = (double)((gint32)v)*pow(2, -6);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", redAlmOmega0_Phi0, (gint32)v);
}

static void
lpp_midiAlmE_fmt(gchar *s, guint32 v)
{
  double midiAlmE = (double)v*pow(2, -16);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", midiAlmE, v);
}

static void
lpp_midiAlmDeltaI_fmt(gchar *s, guint32 v)
{
  double midiAlmDeltaI = (double)((gint32)v)*pow(2, -14);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", midiAlmDeltaI, (gint32)v);
}

static void
lpp_midiAlmOmegaDot_fmt(gchar *s, guint32 v)
{
  double midiAlmOmegaDot = (double)((gint32)v)*pow(2, -33);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", midiAlmOmegaDot, (gint32)v);
}

static void
lpp_midiAlmSqrtA_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%fm1/2 (%u)", (float)v*0.0625, v);
}

static void
lpp_midiAlmOmega0_Omega_Mo_fmt(gchar *s, guint32 v)
{
  double midiAlmOmega0_Omega_Mo = (double)((gint32)v)*pow(2, -15);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", midiAlmOmega0_Omega_Mo, (gint32)v);
}

static void
lpp_midiAlmaf0_fmt(gchar *s, guint32 v)
{
  double midiAlmaf0 = (double)((gint32)v)*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", midiAlmaf0, (gint32)v);
}

static void
lpp_midiAlmaf1_fmt(gchar *s, guint32 v)
{
  double midiAlmaf1 = (double)((gint32)v)*pow(2, -37);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", midiAlmaf1, (gint32)v);
}

static void
lpp_gloAlmLambdaA_DeltaIa_fmt(gchar *s, guint32 v)
{
  double gloAlmLambdaA_DeltaIa = (double)((gint32)v)*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", gloAlmLambdaA_DeltaIa, (gint32)v);
}

static void
lpp_gloAlmtlambdaA_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%fs (%u)", (float)v*0.03125, v);
}

static void
lpp_gloAlmDeltaTA_fmt(gchar *s, guint32 v)
{
  double gloAlmDeltaTA = (double)((gint32)v)*pow(2, -9);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/orbit period (%d)", gloAlmDeltaTA, (gint32)v);
}

static void
lpp_gloAlmDeltaTdotA_fmt(gchar *s, guint32 v)
{
  double gloAlmDeltaTdotA = (double)((gint32)v)*pow(2, -14);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/orbit period (%d)", gloAlmDeltaTdotA, (gint32)v);
}

static void
lpp_gloAlmEpsilonA_fmt(gchar *s, guint32 v)
{
  double gloAlmEpsilonA = (double)v*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", gloAlmEpsilonA, (gint32)v);
}

static void
lpp_gloAlmOmegaA_fmt(gchar *s, guint32 v)
{
  double gloAlmOmegaA = (double)((gint32)v)*pow(2, -15);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", gloAlmOmegaA, (gint32)v);
}

static void
lpp_gloAlmTauA_fmt(gchar *s, guint32 v)
{
  double gloAlmTauA = (double)((gint32)v)*pow(2, -18);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", gloAlmTauA, (gint32)v);
}

static void
lpp_sbasAlmXg_Yg_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%fkm (%d)", (gint32)v*2.6, (gint32)v);
}

static void
lpp_sbasAlmZg_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%dkm (%d)", (gint32)v*26, (gint32)v);
}

static void
lpp_sbasAlmXgdot_YgDot_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%dm/s (%d)", (gint32)v*10, (gint32)v);
}

static void
lpp_sbasAlmZgDot_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%fm/s (%d)", (gint32)v*40.96, (gint32)v);
}

static void
lpp_sbasAlmTo_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%um/s (%u)", v*64, v);
}

static void
lpp_bdsAlmToa_r12_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", v*4096, v);
}

static void
lpp_bdsAlmSqrtA_r12_fmt(gchar *s, guint32 v)
{
  double bdsAlmSqrtA = (double)v*pow(2, -11);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%u)", bdsAlmSqrtA, v);
}

static void
lpp_bdsAlmE_r12_fmt(gchar *s, guint32 v)
{
  double bdsAlmE = (double)v*pow(2, -21);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm1/2 (%u)", bdsAlmE, v);
}

static void
lpp_bdsAlmW_M0_Omega0_r12_fmt(gchar *s, guint32 v)
{
  double bdsAlmW_M0_Omega0 = (double)((gint32)v)*pow(2, -23);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", bdsAlmW_M0_Omega0, (gint32)v);
}

static void
lpp_bdsAlmOmegaDot_r12_fmt(gchar *s, guint32 v)
{
  double bdsAlmOmegaDot = (double)((gint32)v)*pow(2, -38);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles/s (%d)", bdsAlmOmegaDot, (gint32)v);
}

static void
lpp_bdsAlmDeltaI_r12_fmt(gchar *s, guint32 v)
{
  double bdsAlmDeltaI = (double)((gint32)v)*pow(2, -19);

  snprintf(s, ITEM_LABEL_LENGTH, "%g semi-circles (%d)", bdsAlmDeltaI, (gint32)v);
}

static void
lpp_bdsAlmA0_r12_fmt(gchar *s, guint32 v)
{
  double bdsAlmA0 = (double)((gint32)v)*pow(2, -20);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", bdsAlmA0, (gint32)v);
}

static void
lpp_bdsAlmA1_r12_fmt(gchar *s, guint32 v)
{
  double bdsAlmA1 = (double)((gint32)v)*pow(2, -38);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", bdsAlmA1, (gint32)v);
}

static const true_false_string lpp_bdsSvHealth_r12_b1i_b2i_value = {
  "OK",
  "Weak"
};

static const true_false_string lpp_bdsSvHealth_r12_nav_value = {
  "OK",
  "Bad (IOD over limit)"
};

static void
lpp_gnss_Utc_A1_fmt(gchar *s, guint32 v)
{
  double gnss_Utc_A1 = (double)((gint32)v)*pow(2, -50);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/s (%d)", gnss_Utc_A1, (gint32)v);
}

static void
lpp_gnss_Utc_A0_fmt(gchar *s, guint32 v)
{
  double gnss_Utc_A0 = (double)((gint32)v)*pow(2, -30);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", gnss_Utc_A0, (gint32)v);
}

static void
lpp_gnss_Utc_Tot_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%us (%u)", v*4096, v);
}

static const value_string lpp_bds_UDREI_vals[] = {
  {  0, "1 meter"},
  {  1, "1.5 meters"},
  {  2, "2 meters"},
  {  3, "3 meters"},
  {  4, "4 meters"},
  {  5, "5 meters"},
  {  6, "6 meters"},
  {  7, "8 meters"},
  {  8, "10 meters"},
  {  9, "15 meters"},
  { 10, "20 meters"},
  { 11, "50 meters"},
  { 12, "100 meters"},
  { 13, "150 meters"},
  { 14, "Not monitored"},
  { 15, "Not available"},
  { 0, NULL}
};
static value_string_ext lpp_bds_UDREI_vals_ext = VALUE_STRING_EXT_INIT(lpp_bds_UDREI_vals);

static const value_string lpp_bds_RURAI_vals[] = {
  {  0, "0.75 meter"},
  {  1, "1 meter"},
  {  2, "1.25 meters"},
  {  3, "1.75 meters"},
  {  4, "2.25 meters"},
  {  5, "3 meters"},
  {  6, "3.75 meters"},
  {  7, "4.5 meters"},
  {  8, "5.25 meters"},
  {  9, "6 meters"},
  { 10, "7.5 meters"},
  { 11, "15 meters"},
  { 12, "50 meters"},
  { 13, "150 meters"},
  { 14, "300 meters"},
  { 15, "> 300 meters"},
  { 0, NULL}
};
static value_string_ext lpp_bds_RURAI_vals_ext = VALUE_STRING_EXT_INIT(lpp_bds_RURAI_vals);

static void
lpp_bds_ECC_DeltaT_r12_fmt(gchar *s, guint32 v)
{
  if ((gint32)v == -4096) {
    snprintf(s, ITEM_LABEL_LENGTH, "Not available (%d)", (gint32)v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", (float)((gint32)v)*0.1, (gint32)v);
  }
}

static void
lpp_bds_GridIonElement_dt_r12_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", (float)((gint32)v)*0.125, (gint32)v);
}

static const value_string lpp_bds_givei_vals[] = {
  {  0, "0.3 meter"},
  {  1, "0.6 meter"},
  {  2, "0.9 meter"},
  {  3, "1.2 meters"},
  {  4, "1.5 meters"},
  {  5, "1.8 meters"},
  {  6, "2.1 meters"},
  {  7, "2.4 meters"},
  {  8, "2.7 meters"},
  {  9, "3 meters"},
  { 10, "3.6 meters"},
  { 11, "4.5 meters"},
  { 12, "6 meters"},
  { 13, "9 meters"},
  { 14, "15 meters"},
  { 15, "45 meters"},
  { 0, NULL}
};
static value_string_ext lpp_bds_givei_vals_ext = VALUE_STRING_EXT_INIT(lpp_bds_givei_vals);

static void
lpp_fine_PseudoRange_r15_fmt(gchar *s, guint32 v)
{
  double val = (double)((gint32)v)*pow(2, -29);

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%d)", val, (gint32)v);
}

static void
lpp_fine_PhaseRange_r15_fmt(gchar *s, guint32 v)
{
  double val = (double)((gint32)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%d)", val, (gint32)v);
}

static void
lpp_carrier_to_noise_ratio_r15_fmt(gchar *s, guint32 v)
{
  double val = (double)v*pow(2, -4);

  snprintf(s, ITEM_LABEL_LENGTH, "%gdB-Hz (%d)", val, v);
}

static void
lpp_fine_PhaseRangeRate_r15_fmt(gchar *s, guint32 v)
{
  double val = (double)((gint32)v)/1000;

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%d)", val, (gint32)v);
}

static void
lpp_cpBias_r15_fmt(gchar *s, guint32 v)
{
  double val = (double)((gint32)v)/50;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", val, (gint32)v);
}

static const value_string lpp_ambiguityStatusFlag_r15_vals[] = {
  { 0, "Reserved for future use (artificial observations)"},
  { 1, "Correct Integer Ambiguity Level for L1 and L2"},
  { 2, "Correct Integer Ambiguity Level for L1-L2 widelane"},
  { 3, "Uncertain Integer Ambiguity Level. Only a likely guess is used"},
  { 0, NULL}
};

static void
lpp_1_2000m_fmt(gchar *s, guint32 v)
{
  double val = (double)((gint32)v)/2000;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", val, (gint32)v);
}

static void
lpp_1_100ppm_fmt(gchar *s, guint32 v)
{
  double val = (double)((gint32)v)/100;

  snprintf(s, ITEM_LABEL_LENGTH, "%gppm (%d)", val, (gint32)v);
}

static void
lpp_1_10ppm_fmt(gchar *s, guint32 v)
{
  double val = (double)((gint32)v)/10;

  snprintf(s, ITEM_LABEL_LENGTH, "%gppm (%d)", val, (gint32)v);
}

static const value_string lpp_ssrUpdateInterval_r15_vals[] = {
  {  0, "1 second"},
  {  1, "2 seconds"},
  {  2, "5 seconds"},
  {  3, "10 seconds"},
  {  4, "15 seconds"},
  {  5, "30 seconds"},
  {  6, "60 seconds"},
  {  7, "120 seconds"},
  {  8, "240 seconds"},
  {  9, "300 seconds"},
  { 10, "600 seconds"},
  { 11, "900 seconds"},
  { 12, "1800 seconds"},
  { 13, "3600 seconds"},
  { 14, "7200 seconds"},
  { 15, "10800 seconds"},
  { 0, NULL}
};

static void
lpp_1_10000m_fmt(gchar *s, guint32 v)
{
  double val = (double)((gint32)v)/10000;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", val, (gint32)v);
}

static void
lpp_4_10000m_fmt(gchar *s, guint32 v)
{
  double val = (double)((gint32)v)/10000*4;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", val, (gint32)v);
}

static void
lpp_1_1000000m_s_fmt(gchar *s, guint32 v)
{
  double val = (double)((gint32)v)/1000000;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s (%d)", val, (gint32)v);
}

static void
lpp_4_1000000m_s_fmt(gchar *s, guint32 v)
{
  double val = (double)((gint32)v)/1000000*4;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s (%d)", val, (gint32)v);
}

static void
lpp_2_100000000m_s2_fmt(gchar *s, guint32 v)
{
  double val = (double)((gint32)v)/100000000*2;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s2 (%d)", val, (gint32)v);
}

static void
lpp_1_100000m_fmt(gchar *s, guint32 v)
{
  double val = (double)((gint32)v)/100000;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%d)", val, (gint32)v);
}

static void
lpp_tauC_fmt(gchar *s, guint32 v)
{
  double tauC = (double)((gint32)v)*pow(2, -31);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", tauC, (gint32)v);
}

static void
lpp_b1_fmt(gchar *s, guint32 v)
{
  double b1 = (double)((gint32)v)*pow(2, -10);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs (%d)", b1, (gint32)v);
}

static void
lpp_b2_fmt(gchar *s, guint32 v)
{
  double b2 = (double)((gint32)v)*pow(2, -16);

  snprintf(s, ITEM_LABEL_LENGTH, "%gs/msd (%d)", b2, (gint32)v);
}

static const value_string lpp_utcStandardID_vals[] = {
  { 0, "UTC as operated by the Communications Research Laboratory (CRL), Tokyo, Japan"},
  { 1, "UTC as operated by the National Institute of Standards and Technology (NIST)"},
  { 2, "UTC as operated by the U. S. Naval Observatory (USNO)"},
  { 3, "UTC as operated by the International Bureau of Weights and Measures (BIPM)"},
  { 0, NULL}
};

static const value_string lpp_dataBitInterval_vals[] = {
  {  0, "0.1"},
  {  1, "0.2"},
  {  2, "0.4"},
  {  3, "0.8"},
  {  4, "1.6"},
  {  5, "3.2"},
  {  6, "6.4"},
  {  7, "12.8"},
  {  8, "25.6"},
  {  9, "51.2"},
  { 10, "102.4"},
  { 11, "204.8"},
  { 12, "409.6"},
  { 13, "819.2"},
  { 14, "1638.4"},
  { 15, "Not specified"},
  { 0, NULL}
};
static value_string_ext lpp_dataBitInterval_vals_ext = VALUE_STRING_EXT_INIT(lpp_dataBitInterval_vals);

static const value_string lpp_carrierQualityInd_vals[] = {
  { 0, "Data direct, carrier phase not continuous"},
  { 1, "Data inverted, carrier phase not continuous"},
  { 2, "Data direct, carrier phase continuous"},
  { 3, "Data inverted, carrier phase continuous"},
  { 0, NULL}
};

static void
lpp_GNSS_SatMeas_codePhase_fmt(gchar *s, guint32 v)
{
  double codePhase = (double)v*pow(2, -21);

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%u)", codePhase, v);
}

static void
lpp_codePhaseRMSError_fmt(gchar *s, guint32 v)
{
  guint8 mantissa = v & 0x07;
  guint8 exponent = (v & 0x38) >> 3;
  guint8 mantissa_1 = (v - 1) & 0x07;
  guint8 exponent_1 = ((v - 1) & 0x38) >> 3;

  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "P < 0.5 (0)");
  } else if (v < 63) {
    snprintf(s, ITEM_LABEL_LENGTH, "%f <= P < %f (%u)", 0.5*(1+mantissa_1/8)*pow(2, exponent_1),
               0.5*(1+mantissa/8)*pow(2, exponent), v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "112 <= P (63)");
  }
}

static void
lpp_transmitterLatitude_fmt(gchar *s, guint32 v)
{
  double lat = ((double)v*4.0/pow(2, 20))-90.0;

  snprintf(s, ITEM_LABEL_LENGTH, "%g degrees (%u)", lat, v);
}

static void
lpp_transmitterLongitude_fmt(gchar *s, guint32 v)
{
  double longitude = ((double)v*4.0/pow(2, 20))-180.0;

  snprintf(s, ITEM_LABEL_LENGTH, "%g degrees (%u)", longitude, v);
}

static void
lpp_transmitterAltitude_fmt(gchar *s, guint32 v)
{
  double alt = ((double)v*0.29)-500.0;

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%u)", alt, v);
}

static void
lpp_refPressure_fmt(gchar *s, guint32 v)
{
  gint32 pressure = (gint32)v;

  snprintf(s, ITEM_LABEL_LENGTH, "%dPa (%d)", 101325+pressure, pressure);
}

static void
lpp_refTemperature_fmt(gchar *s, guint32 v)
{
  gint32 temp = (gint32)v;

  snprintf(s, ITEM_LABEL_LENGTH, "%dK (%d)", 273+temp, temp);
}

static void
lpp_referencePressureRate_v1520_fmt(gchar *s, guint32 v)
{
  gint32 rate = (gint32)v;

  snprintf(s, ITEM_LABEL_LENGTH, "%dPa/hour (%d)", 10*rate, rate);
}

static void
lpp_PressureValidityPeriod_v1520_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%umin (%u)", 15*v, v);
}

static void
lpp_doppler_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%gm/s (%d)", (gint32)v*0.04, (gint32)v);
}

static void
lpp_adr_fmt(gchar *s, guint32 v)
{
  double adr = (double)v*pow(2, -10);

  snprintf(s, ITEM_LABEL_LENGTH, "%gm (%u)", adr, v);
}

static void
lpp_adrMSB_r15_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%um (%u)", v*32768, v);
}

static void
lpp_GNSS_SatMeas_delta_codePhase_r15_fmt(gchar *s, guint32 v)
{
  double codePhase = (double)v*pow(2, -24);

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%u)", codePhase, v);
}

static void
lpp_deliveryAmount_r15_fmt(gchar *s, guint32 v)
{
  snprintf(s, ITEM_LABEL_LENGTH, "%g (%u)", pow(2, v), v);
}

static void
lpp_rsrp_Result_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSRP < -140dBm (0)");
  } else if (v < 97) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= RSRP < %ddBm (%u)", v-141, v-140, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "-44dBm <= RSRP (97)");
  }
}

static void
lpp_rsrq_Result_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSRQ < -19.5dB (0)");
  } else if (v < 34) {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= RSRQ < %.1fdB (%u)", ((float)v/2)-20, (((float)v+1)/2)-20, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "-3dB <= RSRQ (34)");
  }
}

static void
lpp_nrsrp_Result_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "NRSRP < -156dBm (0)");
  } else if (v < 113) {
    snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= NRSRP < %ddBm (%u)", v-157, v-156, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "-44dBm <= NRSRP (97)");
  }
}

static void
lpp_nrsrq_Result_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "NRSRQ < -34dB (0)");
  } else if (v < 74) {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= NRSRQ < %.1fdB (%u)", (((float)v-1)/2)-34, ((float)v/2)-34, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "2.5dB <= NRSRQ (%u)", v);
  }
}

static void
lpp_rsrp_Result_v1470_fmt(gchar *s, guint32 v)
{
  gint32 d = (gint32)v;

  if (d == -17) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSRP < -157dBm (-17)");
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "%ddBm <= RSRP < %ddBm (%d)", d-141, d-140, d);
  }
}

static void
lpp_rsrq_Result_v1470_fmt(gchar *s, guint32 v)
{
  gint32 d = (gint32)v;

  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "RSRQ < -34.5dB (-30)");
  } else if (v < 46) {
    snprintf(s, ITEM_LABEL_LENGTH, "%.1fdB <= RSRQ < %.1fdB (%d)", ((float)d/2)-20, (((float)d+1)/2)-20, d);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "3dB <= RSRQ (46)");
  }
}

static void
lpp_ue_RxTxTimeDiff_fmt(gchar *s, guint32 v)
{
  if (v == 0) {
    snprintf(s, ITEM_LABEL_LENGTH, "T < 2Ts (0)");
  } else if (v < 2048) {
    snprintf(s, ITEM_LABEL_LENGTH, "%uTs <= T < %uTs (%u)", v*2, (v+1)*2, v);
  } else if (v < 4095) {
    snprintf(s, ITEM_LABEL_LENGTH, "%uTs <= T < %uTs (%u)", (v*8)-12288, ((v+1)*8)-12288, v);
  } else {
    snprintf(s, ITEM_LABEL_LENGTH, "20472Ts <= T (4095)");
  }
}

static void
lpp_mbs_beaconMeasElt_codePhase_fmt(gchar *s, guint32 v)
{
  double codePhase = (double)v*pow(2, -21);

  snprintf(s, ITEM_LABEL_LENGTH, "%gms (%u)", codePhase, v);
}

const unit_name_string units_pa = { "Pa", NULL };


static const value_string lpp_Initiator_vals[] = {
  {   0, "locationServer" },
  {   1, "targetDevice" },
  { 0, NULL }
};


static int
dissect_lpp_Initiator(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_lpp_TransactionNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t LPP_TransactionID_sequence[] = {
  { &hf_lpp_initiator       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_Initiator },
  { &hf_lpp_transactionNumber, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_TransactionNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_LPP_TransactionID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_LPP_TransactionID, LPP_TransactionID_sequence);

  return offset;
}



static int
dissect_lpp_BOOLEAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_boolean(tvb, offset, actx, tree, hf_index, NULL);

  return offset;
}



static int
dissect_lpp_SequenceNumber(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Acknowledgement_sequence[] = {
  { &hf_lpp_ackRequested    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_ackIndicator    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SequenceNumber },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Acknowledgement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Acknowledgement, Acknowledgement_sequence);

  return offset;
}


static int * const T_lpp_message_segmentation_req_r14_bits[] = {
  &hf_lpp_T_lpp_message_segmentation_req_r14_serverToTarget,
  &hf_lpp_T_lpp_message_segmentation_req_r14_targetToServer,
  NULL
};

static int
dissect_lpp_T_lpp_message_segmentation_req_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     NO_BOUND, NO_BOUND, FALSE, T_lpp_message_segmentation_req_r14_bits, 2, NULL, NULL);

  return offset;
}


static const per_sequence_t CommonIEsRequestCapabilities_eag_1_sequence[] = {
  { &hf_lpp_lpp_message_segmentation_req_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_lpp_message_segmentation_req_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsRequestCapabilities_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsRequestCapabilities_eag_1_sequence);

  return offset;
}


static const per_sequence_t CommonIEsRequestCapabilities_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsRequestCapabilities_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsRequestCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CommonIEsRequestCapabilities, CommonIEsRequestCapabilities_sequence);

  return offset;
}


static const per_sequence_t A_GNSS_RequestCapabilities_sequence[] = {
  { &hf_lpp_gnss_SupportListReq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_assistanceDataSupportListReq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_locationVelocityTypesReq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_RequestCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_A_GNSS_RequestCapabilities, A_GNSS_RequestCapabilities_sequence);

  return offset;
}


static const per_sequence_t OTDOA_RequestCapabilities_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_OTDOA_RequestCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_OTDOA_RequestCapabilities, OTDOA_RequestCapabilities_sequence);

  return offset;
}


static const per_sequence_t ECID_RequestCapabilities_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_ECID_RequestCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ECID_RequestCapabilities, ECID_RequestCapabilities_sequence);

  return offset;
}



static int
dissect_lpp_EPDU_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, &lpp_epdu_id, FALSE);



  return offset;
}



static int
dissect_lpp_EPDU_Name(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          1, 32, FALSE,
                                          NULL);

  return offset;
}


static const per_sequence_t EPDU_Identifier_sequence[] = {
  { &hf_lpp_ePDU_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_EPDU_ID },
  { &hf_lpp_ePDU_Name       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_EPDU_Name },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_EPDU_Identifier(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_EPDU_Identifier, EPDU_Identifier_sequence);

  return offset;
}



static int
dissect_lpp_EPDU_Body(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *lppe_tvb = NULL;
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       NO_BOUND, NO_BOUND, FALSE, &lppe_tvb);

  switch(lpp_epdu_id){
  case 1:
    if (lppe_tvb && lppe_handle) {
      call_dissector(lppe_handle, lppe_tvb, actx->pinfo, tree);
    }
    break;
  default:
    break;
  }
  lpp_epdu_id = -1;


  return offset;
}


static const per_sequence_t EPDU_sequence[] = {
  { &hf_lpp_ePDU_Identifier , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_EPDU_Identifier },
  { &hf_lpp_ePDU_Body       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_EPDU_Body },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_EPDU(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_EPDU, EPDU_sequence);

  return offset;
}


static const per_sequence_t EPDU_Sequence_sequence_of[1] = {
  { &hf_lpp_EPDU_Sequence_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_EPDU },
};

static int
dissect_lpp_EPDU_Sequence(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_EPDU_Sequence, EPDU_Sequence_sequence_of,
                                                  1, maxEPDU, FALSE);

  return offset;
}


static const per_sequence_t Sensor_RequestCapabilities_r13_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_Sensor_RequestCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Sensor_RequestCapabilities_r13, Sensor_RequestCapabilities_r13_sequence);

  return offset;
}


static const per_sequence_t TBS_RequestCapabilities_r13_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_TBS_RequestCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_TBS_RequestCapabilities_r13, TBS_RequestCapabilities_r13_sequence);

  return offset;
}


static const per_sequence_t WLAN_RequestCapabilities_r13_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_WLAN_RequestCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_WLAN_RequestCapabilities_r13, WLAN_RequestCapabilities_r13_sequence);

  return offset;
}


static const per_sequence_t BT_RequestCapabilities_r13_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_BT_RequestCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BT_RequestCapabilities_r13, BT_RequestCapabilities_r13_sequence);

  return offset;
}


static const per_sequence_t RequestCapabilities_r9_IEs_eag_1_sequence[] = {
  { &hf_lpp_sensor_RequestCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_Sensor_RequestCapabilities_r13 },
  { &hf_lpp_tbs_RequestCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_TBS_RequestCapabilities_r13 },
  { &hf_lpp_wlan_RequestCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_WLAN_RequestCapabilities_r13 },
  { &hf_lpp_bt_RequestCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BT_RequestCapabilities_r13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestCapabilities_r9_IEs_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RequestCapabilities_r9_IEs_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_ECID_RequestCapabilities_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NR_ECID_RequestCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_ECID_RequestCapabilities_r16, NR_ECID_RequestCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_RequestCapabilities_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_RequestCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_Multi_RTT_RequestCapabilities_r16, NR_Multi_RTT_RequestCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t NR_DL_AoD_RequestCapabilities_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_RequestCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_AoD_RequestCapabilities_r16, NR_DL_AoD_RequestCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_RequestCapabilities_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_RequestCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_TDOA_RequestCapabilities_r16, NR_DL_TDOA_RequestCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t NR_UL_RequestCapabilities_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NR_UL_RequestCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_UL_RequestCapabilities_r16, NR_UL_RequestCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t RequestCapabilities_r9_IEs_eag_2_sequence[] = {
  { &hf_lpp_nr_ECID_RequestCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_ECID_RequestCapabilities_r16 },
  { &hf_lpp_nr_Multi_RTT_RequestCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_Multi_RTT_RequestCapabilities_r16 },
  { &hf_lpp_nr_DL_AoD_RequestCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_DL_AoD_RequestCapabilities_r16 },
  { &hf_lpp_nr_DL_TDOA_RequestCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_DL_TDOA_RequestCapabilities_r16 },
  { &hf_lpp_nr_UL_RequestCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_UL_RequestCapabilities_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestCapabilities_r9_IEs_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RequestCapabilities_r9_IEs_eag_2_sequence);

  return offset;
}


static const per_sequence_t RequestCapabilities_r9_IEs_sequence[] = {
  { &hf_lpp_commonIEsRequestCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CommonIEsRequestCapabilities },
  { &hf_lpp_a_gnss_RequestCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_A_GNSS_RequestCapabilities },
  { &hf_lpp_otdoa_RequestCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_OTDOA_RequestCapabilities },
  { &hf_lpp_ecid_RequestCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_ECID_RequestCapabilities },
  { &hf_lpp_epdu_RequestCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_EPDU_Sequence },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_RequestCapabilities_r9_IEs_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_RequestCapabilities_r9_IEs_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestCapabilities_r9_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RequestCapabilities_r9_IEs, RequestCapabilities_r9_IEs_sequence);

  return offset;
}



static int
dissect_lpp_NULL(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_null(tvb, offset, actx, tree, hf_index);

  return offset;
}


static const value_string lpp_T_c1_01_vals[] = {
  {   0, "requestCapabilities-r9" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_01_choice[] = {
  {   0, &hf_lpp_requestCapabilities_r9, ASN1_NO_EXTENSIONS     , dissect_lpp_RequestCapabilities_r9_IEs },
  {   1, &hf_lpp_spare3          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   2, &hf_lpp_spare2          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   3, &hf_lpp_spare1          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_c1_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_c1_01, T_c1_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_criticalExtensionsFuture(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_criticalExtensionsFuture, T_criticalExtensionsFuture_sequence);

  return offset;
}


static const value_string lpp_T_criticalExtensions_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_choice[] = {
  {   0, &hf_lpp_c1_01           , ASN1_NO_EXTENSIONS     , dissect_lpp_T_c1_01 },
  {   1, &hf_lpp_criticalExtensionsFuture, ASN1_NO_EXTENSIONS     , dissect_lpp_T_criticalExtensionsFuture },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_criticalExtensions(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_criticalExtensions, T_criticalExtensions_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RequestCapabilities_sequence[] = {
  { &hf_lpp_criticalExtensions, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_criticalExtensions },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Request Capabilities");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RequestCapabilities, RequestCapabilities_sequence);

  return offset;
}


static const value_string lpp_SegmentationInfo_r14_vals[] = {
  {   0, "noMoreMessages" },
  {   1, "moreMessagesOnTheWay" },
  { 0, NULL }
};


static int
dissect_lpp_SegmentationInfo_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static int * const T_lpp_message_segmentation_r14_bits[] = {
  &hf_lpp_T_lpp_message_segmentation_r14_serverToTarget,
  &hf_lpp_T_lpp_message_segmentation_r14_targetToServer,
  NULL
};

static int
dissect_lpp_T_lpp_message_segmentation_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     NO_BOUND, NO_BOUND, FALSE, T_lpp_message_segmentation_r14_bits, 2, NULL, NULL);

  return offset;
}


static const per_sequence_t CommonIEsProvideCapabilities_eag_1_sequence[] = {
  { &hf_lpp_segmentationInfo_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SegmentationInfo_r14 },
  { &hf_lpp_lpp_message_segmentation_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_lpp_message_segmentation_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsProvideCapabilities_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsProvideCapabilities_eag_1_sequence);

  return offset;
}


static const per_sequence_t CommonIEsProvideCapabilities_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsProvideCapabilities_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsProvideCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CommonIEsProvideCapabilities, CommonIEsProvideCapabilities_sequence);

  return offset;
}


static const value_string lpp_T_gnss_id_vals[] = {
  { T_GNSS_ID_GPS, "gps" },
  { T_GNSS_ID_SBAS, "sbas" },
  { T_GNSS_ID_QZSS, "qzss" },
  { T_GNSS_ID_GALILEO, "galileo" },
  { T_GNSS_ID_GLONASS, "glonass" },
  { T_GNSS_ID_BDS, "bds" },
  { T_GNSS_ID_NAVIC_V1610, "navic-v1610" },
  { 0, NULL }
};


static int
dissect_lpp_T_gnss_id(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  guint32 gnss_id;
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, &gnss_id, TRUE, 2, NULL);

  actx->private_data = GUINT_TO_POINTER(gnss_id);


  return offset;
}


static const per_sequence_t GNSS_ID_sequence[] = {
  { &hf_lpp_gnss_id         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_gnss_id },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_GNSS_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ID, GNSS_ID_sequence);

  return offset;
}


static int * const T_sbas_IDs_bits[] = {
  &hf_lpp_T_sbas_IDs_waas,
  &hf_lpp_T_sbas_IDs_egnos,
  &hf_lpp_T_sbas_IDs_msas,
  &hf_lpp_T_sbas_IDs_gagan,
  NULL
};

static int
dissect_lpp_T_sbas_IDs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_sbas_IDs_bits, 4, NULL, NULL);

  return offset;
}


static const per_sequence_t SBAS_IDs_sequence[] = {
  { &hf_lpp_sbas_IDs_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_sbas_IDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SBAS_IDs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SBAS_IDs, SBAS_IDs_sequence);

  return offset;
}


static int * const T_posModes_bits[] = {
  &hf_lpp_T_posModes_standalone,
  &hf_lpp_T_posModes_ue_based,
  &hf_lpp_T_posModes_ue_assisted,
  NULL
};

static int
dissect_lpp_T_posModes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_posModes_bits, 3, NULL, NULL);

  return offset;
}


static const per_sequence_t PositioningModes_sequence[] = {
  { &hf_lpp_posModes        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_posModes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PositioningModes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PositioningModes, PositioningModes_sequence);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     8, 8, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     16, 16, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_SignalIDs_eag_1_sequence[] = {
  { &hf_lpp_gnss_SignalIDs_Ext_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BIT_STRING_SIZE_16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SignalIDs_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SignalIDs_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SignalIDs_sequence[] = {
  { &hf_lpp_gnss_SignalIDs  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_8 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs_eag_1 },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_GNSS_SignalIDs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SignalIDs, GNSS_SignalIDs_sequence);

  return offset;
}


static int * const T_accessTypes_bits[] = {
  &hf_lpp_T_accessTypes_eutra,
  &hf_lpp_T_accessTypes_utra,
  &hf_lpp_T_accessTypes_gsm,
  &hf_lpp_T_accessTypes_nb_iot,
  &hf_lpp_T_accessTypes_nr_v1510,
  NULL
};

static int
dissect_lpp_T_accessTypes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_accessTypes_bits, 5, NULL, NULL);

  return offset;
}


static const per_sequence_t AccessTypes_sequence[] = {
  { &hf_lpp_accessTypes     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_accessTypes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AccessTypes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AccessTypes, AccessTypes_sequence);

  return offset;
}


static const per_sequence_t T_fta_MeasSupport_sequence[] = {
  { &hf_lpp_cellTime        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_AccessTypes },
  { &hf_lpp_mode_02         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_PositioningModes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_fta_MeasSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_fta_MeasSupport, T_fta_MeasSupport_sequence);

  return offset;
}


static const value_string lpp_T_adrEnhancementsSupport_r15_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_adrEnhancementsSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SupportElement_eag_1_sequence[] = {
  { &hf_lpp_adrEnhancementsSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_adrEnhancementsSupport_r15 },
  { &hf_lpp_ha_gnss_Modes_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SupportElement_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SupportElement_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_ha_gnss_MetricsSupport_r17_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_ha_gnss_MetricsSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SupportElement_eag_2_sequence[] = {
  { &hf_lpp_ha_gnss_MetricsSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ha_gnss_MetricsSupport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SupportElement_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SupportElement_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_SupportElement_sequence[] = {
  { &hf_lpp_gnss_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID },
  { &hf_lpp_sbas_IDs        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SBAS_IDs },
  { &hf_lpp_agnss_Modes     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_PositioningModes },
  { &hf_lpp_gnss_Signals    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_fta_MeasSupport , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_fta_MeasSupport },
  { &hf_lpp_adr_Support     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_velocityMeasurementSupport, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SupportElement_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SupportElement_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SupportElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SupportElement, GNSS_SupportElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_SupportList_sequence_of[1] = {
  { &hf_lpp_GNSS_SupportList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SupportElement },
};

static int
dissect_lpp_GNSS_SupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_SupportList, GNSS_SupportList_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static int * const T_gnss_ids_bits[] = {
  &hf_lpp_T_gnss_ids_gps,
  &hf_lpp_T_gnss_ids_sbas,
  &hf_lpp_T_gnss_ids_qzss,
  &hf_lpp_T_gnss_ids_galileo,
  &hf_lpp_T_gnss_ids_glonass,
  &hf_lpp_T_gnss_ids_bds,
  &hf_lpp_T_gnss_ids_navic_v1610,
  NULL
};

static int
dissect_lpp_T_gnss_ids(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 16, FALSE, T_gnss_ids_bits, 7, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_ID_Bitmap_sequence[] = {
  { &hf_lpp_gnss_ids        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_gnss_ids },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_GNSS_ID_Bitmap(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ID_Bitmap, GNSS_ID_Bitmap_sequence);

  return offset;
}


static const per_sequence_t GNSS_ReferenceTimeSupport_sequence[] = {
  { &hf_lpp_gnss_SystemTime_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID_Bitmap },
  { &hf_lpp_fta_Support     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_AccessTypes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceTimeSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceTimeSupport, GNSS_ReferenceTimeSupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_ReferenceLocationSupport_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceLocationSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceLocationSupport, GNSS_ReferenceLocationSupport_sequence);

  return offset;
}


static int * const T_ionoModel_bits[] = {
  &hf_lpp_T_ionoModel_klobuchar,
  &hf_lpp_T_ionoModel_neQuick,
  &hf_lpp_T_ionoModel_klobuchar2_r16,
  NULL
};

static int
dissect_lpp_T_ionoModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_ionoModel_bits, 3, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_IonosphericModelSupport_sequence[] = {
  { &hf_lpp_ionoModel       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_ionoModel },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_IonosphericModelSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_IonosphericModelSupport, GNSS_IonosphericModelSupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_EarthOrientationParametersSupport_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_EarthOrientationParametersSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_EarthOrientationParametersSupport, GNSS_EarthOrientationParametersSupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ReferenceStationInfoSupport_r15_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ReferenceStationInfoSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ReferenceStationInfoSupport_r15, GNSS_RTK_ReferenceStationInfoSupport_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_AuxiliaryStationDataSupport_r15_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_AuxiliaryStationDataSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_AuxiliaryStationDataSupport_r15, GNSS_RTK_AuxiliaryStationDataSupport_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistanceDataSupport_eag_1_sequence[] = {
  { &hf_lpp_gnss_RTK_ReferenceStationInfoSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ReferenceStationInfoSupport_r15 },
  { &hf_lpp_gnss_RTK_AuxiliaryStationDataSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_AuxiliaryStationDataSupport_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistanceDataSupport_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistanceDataSupport_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_Integrity_ServiceParametersSupport_r17_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_Integrity_ServiceParametersSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_Integrity_ServiceParametersSupport_r17, GNSS_Integrity_ServiceParametersSupport_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_Integrity_ServiceAlertSupport_r17_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_Integrity_ServiceAlertSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_Integrity_ServiceAlertSupport_r17, GNSS_Integrity_ServiceAlertSupport_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistanceDataSupport_eag_2_sequence[] = {
  { &hf_lpp_gnss_Integrity_ServiceParametersSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_Integrity_ServiceParametersSupport_r17 },
  { &hf_lpp_gnss_Integrity_ServiceAlertSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_Integrity_ServiceAlertSupport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistanceDataSupport_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistanceDataSupport_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistanceDataSupport_sequence[] = {
  { &hf_lpp_gnss_ReferenceTimeSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceTimeSupport },
  { &hf_lpp_gnss_ReferenceLocationSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceLocationSupport },
  { &hf_lpp_gnss_IonosphericModelSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_IonosphericModelSupport },
  { &hf_lpp_gnss_EarthOrientationParametersSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_EarthOrientationParametersSupport },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistanceDataSupport_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistanceDataSupport_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistanceDataSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_CommonAssistanceDataSupport, GNSS_CommonAssistanceDataSupport_sequence);

  return offset;
}


static const value_string lpp_T_sbas_id_vals[] = {
  {   0, "waas" },
  {   1, "egnos" },
  {   2, "msas" },
  {   3, "gagan" },
  { 0, NULL }
};


static int
dissect_lpp_T_sbas_id(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t SBAS_ID_sequence[] = {
  { &hf_lpp_sbas_id         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_sbas_id },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SBAS_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SBAS_ID, SBAS_ID_sequence);

  return offset;
}


static const per_sequence_t GNSS_TimeModelListSupport_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_TimeModelListSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_TimeModelListSupport, GNSS_TimeModelListSupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_DifferentialCorrectionsSupport_sequence[] = {
  { &hf_lpp_gnssSignalIDs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_dgnss_ValidityTimeSup, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_DifferentialCorrectionsSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DifferentialCorrectionsSupport, GNSS_DifferentialCorrectionsSupport_sequence);

  return offset;
}


static int * const T_clockModel_bits[] = {
  &hf_lpp_T_clockModel_model_1,
  &hf_lpp_T_clockModel_model_2,
  &hf_lpp_T_clockModel_model_3,
  &hf_lpp_T_clockModel_model_4,
  &hf_lpp_T_clockModel_model_5,
  &hf_lpp_T_clockModel_model_6,
  &hf_lpp_T_clockModel_model_7_r16,
  &hf_lpp_T_clockModel_model_8_r16,
  NULL
};

static int
dissect_lpp_T_clockModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_clockModel_bits, 8, NULL, NULL);

  return offset;
}


static int * const T_orbitModel_bits[] = {
  &hf_lpp_T_orbitModel_model_1,
  &hf_lpp_T_orbitModel_model_2,
  &hf_lpp_T_orbitModel_model_3,
  &hf_lpp_T_orbitModel_model_4,
  &hf_lpp_T_orbitModel_model_5,
  &hf_lpp_T_orbitModel_model_6,
  &hf_lpp_T_orbitModel_model_7_r16,
  &hf_lpp_T_orbitModel_model_8_r16,
  NULL
};

static int
dissect_lpp_T_orbitModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_orbitModel_bits, 8, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_NavigationModelSupport_sequence[] = {
  { &hf_lpp_clockModel      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_clockModel },
  { &hf_lpp_orbitModel      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_orbitModel },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_NavigationModelSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_NavigationModelSupport, GNSS_NavigationModelSupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_RealTimeIntegritySupport_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_RealTimeIntegritySupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RealTimeIntegritySupport, GNSS_RealTimeIntegritySupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_DataBitAssistanceSupport_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_DataBitAssistanceSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DataBitAssistanceSupport, GNSS_DataBitAssistanceSupport_sequence);

  return offset;
}


static const value_string lpp_T_confidenceSupport_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_confidenceSupport_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_dopplerUncertaintyExtSupport_r10_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_dopplerUncertaintyExtSupport_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_AcquisitionAssistanceSupport_sequence[] = {
  { &hf_lpp_confidenceSupport_r10, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_confidenceSupport_r10 },
  { &hf_lpp_dopplerUncertaintyExtSupport_r10, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_dopplerUncertaintyExtSupport_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_AcquisitionAssistanceSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AcquisitionAssistanceSupport, GNSS_AcquisitionAssistanceSupport_sequence);

  return offset;
}


static int * const T_almanacModel_bits[] = {
  &hf_lpp_T_almanacModel_model_1,
  &hf_lpp_T_almanacModel_model_2,
  &hf_lpp_T_almanacModel_model_3,
  &hf_lpp_T_almanacModel_model_4,
  &hf_lpp_T_almanacModel_model_5,
  &hf_lpp_T_almanacModel_model_6,
  &hf_lpp_T_almanacModel_model_7,
  NULL
};

static int
dissect_lpp_T_almanacModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_almanacModel_bits, 7, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_AlmanacSupport_sequence[] = {
  { &hf_lpp_almanacModel    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_almanacModel },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_AlmanacSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AlmanacSupport, GNSS_AlmanacSupport_sequence);

  return offset;
}


static int * const T_utc_Model_bits[] = {
  &hf_lpp_T_utc_Model_model_1,
  &hf_lpp_T_utc_Model_model_2,
  &hf_lpp_T_utc_Model_model_3,
  &hf_lpp_T_utc_Model_model_4,
  &hf_lpp_T_utc_Model_model_5,
  NULL
};

static int
dissect_lpp_T_utc_Model(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_utc_Model_bits, 5, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_UTC_ModelSupport_sequence[] = {
  { &hf_lpp_utc_Model       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_utc_Model },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_UTC_ModelSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_UTC_ModelSupport, GNSS_UTC_ModelSupport_sequence);

  return offset;
}


static const per_sequence_t GNSS_AuxiliaryInformationSupport_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_AuxiliaryInformationSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AuxiliaryInformationSupport, GNSS_AuxiliaryInformationSupport_sequence);

  return offset;
}


static const per_sequence_t BDS_DifferentialCorrectionsSupport_r12_sequence[] = {
  { &hf_lpp_gnssSignalIDs   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BDS_DifferentialCorrectionsSupport_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BDS_DifferentialCorrectionsSupport_r12, BDS_DifferentialCorrectionsSupport_r12_sequence);

  return offset;
}


static const per_sequence_t BDS_GridModelSupport_r12_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_BDS_GridModelSupport_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BDS_GridModelSupport_r12, BDS_GridModelSupport_r12_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataSupportElement_eag_1_sequence[] = {
  { &hf_lpp_bds_DifferentialCorrectionsSupport_r12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BDS_DifferentialCorrectionsSupport_r12 },
  { &hf_lpp_bds_GridModelSupport_r12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BDS_GridModelSupport_r12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataSupportElement_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ObservationsSupport_r15_sequence[] = {
  { &hf_lpp_gnssSignalIDs_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ObservationsSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ObservationsSupport_r15, GNSS_RTK_ObservationsSupport_r15_sequence);

  return offset;
}


static const per_sequence_t GLO_RTK_BiasInformationSupport_r15_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GLO_RTK_BiasInformationSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GLO_RTK_BiasInformationSupport_r15, GLO_RTK_BiasInformationSupport_r15_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GNSS_FrequencyID_r15_sequence[] = {
  { &hf_lpp_gnss_FrequencyID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_7 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_FrequencyID_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_FrequencyID_r15, GNSS_FrequencyID_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_Link_Combinations_r15_sequence[] = {
  { &hf_lpp_l1_r15          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_FrequencyID_r15 },
  { &hf_lpp_l2_r15          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_FrequencyID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_Link_Combinations_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_Link_Combinations_r15, GNSS_Link_Combinations_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_Link_CombinationsList_r15_sequence_of[1] = {
  { &hf_lpp_GNSS_Link_CombinationsList_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_Link_Combinations_r15 },
};

static int
dissect_lpp_GNSS_Link_CombinationsList_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_Link_CombinationsList_r15, GNSS_Link_CombinationsList_r15_sequence_of,
                                                  1, 8, FALSE);

  return offset;
}


static const per_sequence_t GNSS_RTK_MAC_CorrectionDifferencesSupport_r15_sequence[] = {
  { &hf_lpp_link_combinations_support_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_Link_CombinationsList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_MAC_CorrectionDifferencesSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_MAC_CorrectionDifferencesSupport_r15, GNSS_RTK_MAC_CorrectionDifferencesSupport_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ResidualsSupport_r15_sequence[] = {
  { &hf_lpp_link_combinations_support_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_Link_CombinationsList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ResidualsSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ResidualsSupport_r15, GNSS_RTK_ResidualsSupport_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_FKP_GradientsSupport_r15_sequence[] = {
  { &hf_lpp_link_combinations_support_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_Link_CombinationsList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_FKP_GradientsSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_FKP_GradientsSupport_r15, GNSS_RTK_FKP_GradientsSupport_r15_sequence);

  return offset;
}


static int * const T_orbit_IntegritySup_r17_bits[] = {
  &hf_lpp_T_orbit_IntegritySup_r17_correlationTimeSup,
  NULL
};

static int
dissect_lpp_T_orbit_IntegritySup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_orbit_IntegritySup_r17_bits, 1, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_OrbitCorrectionsSupport_r15_eag_1_sequence[] = {
  { &hf_lpp_orbit_IntegritySup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_orbit_IntegritySup_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_OrbitCorrectionsSupport_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_OrbitCorrectionsSupport_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_OrbitCorrectionsSupport_r15_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_OrbitCorrectionsSupport_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_OrbitCorrectionsSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_OrbitCorrectionsSupport_r15, GNSS_SSR_OrbitCorrectionsSupport_r15_sequence);

  return offset;
}


static const value_string lpp_T_clock_IntegrityParameterSupport_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_clock_IntegrityParameterSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_ssr_IntegrityClockBoundsSupport_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssr_IntegrityClockBoundsSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_ClockCorrectionsSupport_r15_eag_1_sequence[] = {
  { &hf_lpp_clock_IntegrityParameterSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_clock_IntegrityParameterSupport_r17 },
  { &hf_lpp_ssr_IntegrityClockBoundsSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ssr_IntegrityClockBoundsSupport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ClockCorrectionsSupport_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_ClockCorrectionsSupport_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_ClockCorrectionsSupport_r15_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_ClockCorrectionsSupport_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ClockCorrectionsSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_ClockCorrectionsSupport_r15, GNSS_SSR_ClockCorrectionsSupport_r15_sequence);

  return offset;
}


static const value_string lpp_T_ssr_IntegrityCodeBiasBoundsSup_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssr_IntegrityCodeBiasBoundsSup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_CodeBiasSupport_r15_eag_1_sequence[] = {
  { &hf_lpp_ssr_IntegrityCodeBiasBoundsSup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ssr_IntegrityCodeBiasBoundsSup_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_CodeBiasSupport_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_CodeBiasSupport_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_CodeBiasSupport_r15_sequence[] = {
  { &hf_lpp_signal_and_tracking_mode_ID_Sup_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_CodeBiasSupport_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_CodeBiasSupport_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_CodeBiasSupport_r15, GNSS_SSR_CodeBiasSupport_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataSupportElement_eag_2_sequence[] = {
  { &hf_lpp_gnss_RTK_ObservationsSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ObservationsSupport_r15 },
  { &hf_lpp_glo_RTK_BiasInformationSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GLO_RTK_BiasInformationSupport_r15 },
  { &hf_lpp_gnss_RTK_MAC_CorrectionDifferencesSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_MAC_CorrectionDifferencesSupport_r15 },
  { &hf_lpp_gnss_RTK_ResidualsSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ResidualsSupport_r15 },
  { &hf_lpp_gnss_RTK_FKP_GradientsSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_FKP_GradientsSupport_r15 },
  { &hf_lpp_gnss_SSR_OrbitCorrectionsSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_OrbitCorrectionsSupport_r15 },
  { &hf_lpp_gnss_SSR_ClockCorrectionsSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_ClockCorrectionsSupport_r15 },
  { &hf_lpp_gnss_SSR_CodeBiasSupport_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_CodeBiasSupport_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataSupportElement_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_URA_Support_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_URA_Support_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_URA_Support_r16, GNSS_SSR_URA_Support_r16_sequence);

  return offset;
}


static const value_string lpp_T_ssr_IntegrityPhaseBiasBoundsSup_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssr_IntegrityPhaseBiasBoundsSup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_PhaseBiasSupport_r16_eag_1_sequence[] = {
  { &hf_lpp_ssr_IntegrityPhaseBiasBoundsSup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ssr_IntegrityPhaseBiasBoundsSup_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_PhaseBiasSupport_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_PhaseBiasSupport_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_PhaseBiasSupport_r16_sequence[] = {
  { &hf_lpp_signal_and_tracking_mode_ID_Sup_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_PhaseBiasSupport_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_PhaseBiasSupport_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_PhaseBiasSupport_r16, GNSS_SSR_PhaseBiasSupport_r16_sequence);

  return offset;
}


static int * const T_stec_IntegritySup_r17_bits[] = {
  &hf_lpp_T_stec_IntegritySup_r17_correlationTimeSup,
  NULL
};

static int
dissect_lpp_T_stec_IntegritySup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_stec_IntegritySup_r17_bits, 1, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_STEC_CorrectionSupport_r16_eag_1_sequence[] = {
  { &hf_lpp_stec_IntegritySup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_stec_IntegritySup_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_STEC_CorrectionSupport_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_STEC_CorrectionSupport_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_STEC_CorrectionSupport_r16_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_STEC_CorrectionSupport_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_STEC_CorrectionSupport_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_STEC_CorrectionSupport_r16, GNSS_SSR_STEC_CorrectionSupport_r16_sequence);

  return offset;
}


static const value_string lpp_T_griddedCorrectionIntegritySup_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_griddedCorrectionIntegritySup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_GriddedCorrectionSupport_r16_eag_1_sequence[] = {
  { &hf_lpp_griddedCorrectionIntegritySup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_griddedCorrectionIntegritySup_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_GriddedCorrectionSupport_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_GriddedCorrectionSupport_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_GriddedCorrectionSupport_r16_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_GriddedCorrectionSupport_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_GriddedCorrectionSupport_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_GriddedCorrectionSupport_r16, GNSS_SSR_GriddedCorrectionSupport_r16_sequence);

  return offset;
}


static const per_sequence_t NavIC_DifferentialCorrectionsSupport_r16_sequence[] = {
  { &hf_lpp_gnssSignalIDs_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavIC_DifferentialCorrectionsSupport_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_DifferentialCorrectionsSupport_r16, NavIC_DifferentialCorrectionsSupport_r16_sequence);

  return offset;
}


static const per_sequence_t NavIC_GridModelSupport_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NavIC_GridModelSupport_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_GridModelSupport_r16, NavIC_GridModelSupport_r16_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataSupportElement_eag_3_sequence[] = {
  { &hf_lpp_gnss_SSR_URA_Support_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_URA_Support_r16 },
  { &hf_lpp_gnss_SSR_PhaseBiasSupport_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_PhaseBiasSupport_r16 },
  { &hf_lpp_gnss_SSR_STEC_CorrectionSupport_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_STEC_CorrectionSupport_r16 },
  { &hf_lpp_gnss_SSR_GriddedCorrectionSupport_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_GriddedCorrectionSupport_r16 },
  { &hf_lpp_navic_DifferentialCorrectionsSupport_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NavIC_DifferentialCorrectionsSupport_r16 },
  { &hf_lpp_navic_GridModelSupport_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NavIC_GridModelSupport_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataSupportElement_eag_3_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataSupportElement_sequence[] = {
  { &hf_lpp_gnss_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID },
  { &hf_lpp_sbas_ID         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SBAS_ID },
  { &hf_lpp_gnss_TimeModelsSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_TimeModelListSupport },
  { &hf_lpp_gnss_DifferentialCorrectionsSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_DifferentialCorrectionsSupport },
  { &hf_lpp_gnss_NavigationModelSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_NavigationModelSupport },
  { &hf_lpp_gnss_RealTimeIntegritySupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_RealTimeIntegritySupport },
  { &hf_lpp_gnss_DataBitAssistanceSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_DataBitAssistanceSupport },
  { &hf_lpp_gnss_AcquisitionAssistanceSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AcquisitionAssistanceSupport },
  { &hf_lpp_gnss_AlmanacSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AlmanacSupport },
  { &hf_lpp_gnss_UTC_ModelSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_UTC_ModelSupport },
  { &hf_lpp_gnss_AuxiliaryInformationSupport, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AuxiliaryInformationSupport },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataSupportElement_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataSupportElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_GenericAssistDataSupportElement, GNSS_GenericAssistDataSupportElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistanceDataSupport_sequence_of[1] = {
  { &hf_lpp_GNSS_GenericAssistanceDataSupport_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataSupportElement },
};

static int
dissect_lpp_GNSS_GenericAssistanceDataSupport(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_GenericAssistanceDataSupport, GNSS_GenericAssistanceDataSupport_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const per_sequence_t AssistanceDataSupportList_sequence[] = {
  { &hf_lpp_gnss_CommonAssistanceDataSupport, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistanceDataSupport },
  { &hf_lpp_gnss_GenericAssistanceDataSupport, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistanceDataSupport },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AssistanceDataSupportList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AssistanceDataSupportList, AssistanceDataSupportList_sequence);

  return offset;
}


static const per_sequence_t LocationCoordinateTypes_eag_1_sequence[] = {
  { &hf_lpp_highAccuracyEllipsoidPointWithUncertaintyEllipse_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { &hf_lpp_highAccuracyEllipsoidPointWithAltitudeAndUncertaintyEllipsoid_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_LocationCoordinateTypes_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, LocationCoordinateTypes_eag_1_sequence);

  return offset;
}


static const per_sequence_t LocationCoordinateTypes_eag_2_sequence[] = {
  { &hf_lpp_ha_EllipsoidPointWithScalableUncertaintyEllipse_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { &hf_lpp_ha_EllipsoidPointWithAltitudeAndScalableUncertaintyEllipsoid_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_LocationCoordinateTypes_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, LocationCoordinateTypes_eag_2_sequence);

  return offset;
}


static const per_sequence_t LocationCoordinateTypes_sequence[] = {
  { &hf_lpp_ellipsoidPoint  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_ellipsoidPointWithUncertaintyCircle, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_ellipsoidPointWithUncertaintyEllipse, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_polygon         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_ellipsoidPointWithAltitude, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_ellipsoidPointWithAltitudeAndUncertaintyEllipsoid, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_ellipsoidArc    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_LocationCoordinateTypes_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_LocationCoordinateTypes_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_LocationCoordinateTypes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_LocationCoordinateTypes, LocationCoordinateTypes_sequence);

  return offset;
}


static const per_sequence_t VelocityTypes_sequence[] = {
  { &hf_lpp_horizontalVelocity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_horizontalWithVerticalVelocity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_horizontalVelocityWithUncertainty, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_horizontalWithVerticalVelocityAndUncertainty, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_VelocityTypes(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_VelocityTypes, VelocityTypes_sequence);

  return offset;
}


static const value_string lpp_T_idleStateForMeasurements_r14_01_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_idleStateForMeasurements_r14_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t A_GNSS_ProvideCapabilities_eag_1_sequence[] = {
  { &hf_lpp_periodicalReportingNotSupported_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_idleStateForMeasurements_r14_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_idleStateForMeasurements_r14_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_ProvideCapabilities_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, A_GNSS_ProvideCapabilities_eag_1_sequence);

  return offset;
}


static int * const T_periodicAssistanceData_r15_bits[] = {
  &hf_lpp_T_periodicAssistanceData_r15_solicited,
  &hf_lpp_T_periodicAssistanceData_r15_unsolicited,
  NULL
};

static int
dissect_lpp_T_periodicAssistanceData_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_periodicAssistanceData_r15_bits, 2, NULL, NULL);

  return offset;
}


static const per_sequence_t A_GNSS_ProvideCapabilities_eag_2_sequence[] = {
  { &hf_lpp_periodicAssistanceData_r15_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_periodicAssistanceData_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_ProvideCapabilities_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, A_GNSS_ProvideCapabilities_eag_2_sequence);

  return offset;
}


static const per_sequence_t T_gnssTime_r17_sequence[] = {
  { &hf_lpp_posModes_r17    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_PositioningModes },
  { &hf_lpp_gnss_TimeIDs_r17, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID_Bitmap },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_gnssTime_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_gnssTime_r17, T_gnssTime_r17_sequence);

  return offset;
}


static const per_sequence_t ScheduledLocationTimeSupportPerMode_r17_sequence[] = {
  { &hf_lpp_utcTime_r17_01  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_gnssTime_r17_01 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_gnssTime_r17 },
  { &hf_lpp_e_utraTime_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_nrTime_r17_01   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_relativeTime_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ScheduledLocationTimeSupportPerMode_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ScheduledLocationTimeSupportPerMode_r17, ScheduledLocationTimeSupportPerMode_r17_sequence);

  return offset;
}


static const per_sequence_t A_GNSS_ProvideCapabilities_eag_3_sequence[] = {
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_ProvideCapabilities_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, A_GNSS_ProvideCapabilities_eag_3_sequence);

  return offset;
}


static const per_sequence_t A_GNSS_ProvideCapabilities_sequence[] = {
  { &hf_lpp_gnss_SupportList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_SupportList },
  { &hf_lpp_assistanceDataSupportList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_AssistanceDataSupportList },
  { &hf_lpp_locationCoordinateTypes, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_LocationCoordinateTypes },
  { &hf_lpp_velocityTypes   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_VelocityTypes },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_A_GNSS_ProvideCapabilities_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_A_GNSS_ProvideCapabilities_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_A_GNSS_ProvideCapabilities_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_ProvideCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_A_GNSS_ProvideCapabilities, A_GNSS_ProvideCapabilities_sequence);

  return offset;
}


static int * const T_otdoa_Mode_bits[] = {
  &hf_lpp_T_otdoa_Mode_ue_assisted,
  &hf_lpp_T_otdoa_Mode_ue_assisted_NB_r14,
  &hf_lpp_T_otdoa_Mode_ue_assisted_NB_TDD_r15,
  NULL
};

static int
dissect_lpp_T_otdoa_Mode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_otdoa_Mode_bits, 3, NULL, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_1_maxFBI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxFBI, NULL, FALSE);

  return offset;
}


static const per_sequence_t SupportedBandEUTRA_sequence[] = {
  { &hf_lpp_bandEUTRA       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_maxFBI },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SupportedBandEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SupportedBandEUTRA, SupportedBandEUTRA_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_sequence_of[1] = {
  { &hf_lpp_supportedBandListEUTRA_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SupportedBandEUTRA },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA, SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_sequence_of,
                                                  1, maxBands, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_maxFBI_Plus1_maxFBI2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            maxFBI_Plus1, maxFBI2, NULL, FALSE);

  return offset;
}


static const per_sequence_t SupportedBandEUTRA_v9a0_sequence[] = {
  { &hf_lpp_bandEUTRA_v9a0  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_maxFBI_Plus1_maxFBI2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SupportedBandEUTRA_v9a0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SupportedBandEUTRA_v9a0, SupportedBandEUTRA_v9a0_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0_sequence_of[1] = {
  { &hf_lpp_supportedBandListEUTRA_v9a0_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SupportedBandEUTRA_v9a0 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0, SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0_sequence_of,
                                                  1, maxBands, FALSE);

  return offset;
}


static const value_string lpp_T_interFreqRSTDmeasurement_r10_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_interFreqRSTDmeasurement_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_additionalNeighbourCellInfoList_r10_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_additionalNeighbourCellInfoList_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_id_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_id_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_tp_separation_via_muting_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_tp_separation_via_muting_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_additional_prs_config_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_additional_prs_config_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_based_tbs_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_based_tbs_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_additionalPathsReport_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_additionalPathsReport_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_densePrsConfig_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_densePrsConfig_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxSupportedPrsBandwidth_r14_vals[] = {
  {   0, "n6" },
  {   1, "n15" },
  {   2, "n25" },
  {   3, "n50" },
  {   4, "n75" },
  {   5, "n100" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxSupportedPrsBandwidth_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string lpp_T_prsOccGroup_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_prsOccGroup_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_prsFrequencyHopping_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_prsFrequencyHopping_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxSupportedPrsConfigs_r14_vals[] = {
  {   0, "c2" },
  {   1, "c3" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxSupportedPrsConfigs_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_periodicalReporting_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_periodicalReporting_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_multiPrbNprs_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_multiPrbNprs_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_idleStateForMeasurements_r14_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_idleStateForMeasurements_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_numberOfRXantennas_r14_vals[] = {
  {   0, "rx1" },
  { 0, NULL }
};


static int
dissect_lpp_T_numberOfRXantennas_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string lpp_T_motionMeasurements_r15_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_motionMeasurements_r15_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_interRAT_RSTDmeasurement_r15_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_interRAT_RSTDmeasurement_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_utcTime_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_utcTime_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_e_utraTime_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_e_utraTime_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_nrTime_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nrTime_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_relativeTime_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_relativeTime_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ScheduledLocationTimeSupport_r17_sequence[] = {
  { &hf_lpp_utcTime_r17     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_utcTime_r17 },
  { &hf_lpp_gnssTime_r17    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ID_Bitmap },
  { &hf_lpp_e_utraTime_r17  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_e_utraTime_r17 },
  { &hf_lpp_nrTime_r17      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_nrTime_r17 },
  { &hf_lpp_relativeTime_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_relativeTime_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ScheduledLocationTimeSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ScheduledLocationTimeSupport_r17, ScheduledLocationTimeSupport_r17_sequence);

  return offset;
}


static const per_sequence_t OTDOA_ProvideCapabilities_sequence[] = {
  { &hf_lpp_otdoa_Mode      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_otdoa_Mode },
  { &hf_lpp_supportedBandListEUTRA, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA },
  { &hf_lpp_supportedBandListEUTRA_v9a0, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_maxBands_OF_SupportedBandEUTRA_v9a0 },
  { &hf_lpp_interFreqRSTDmeasurement_r10, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_interFreqRSTDmeasurement_r10 },
  { &hf_lpp_additionalNeighbourCellInfoList_r10, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_additionalNeighbourCellInfoList_r10 },
  { &hf_lpp_prs_id_r14      , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_prs_id_r14 },
  { &hf_lpp_tp_separation_via_muting_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_tp_separation_via_muting_r14 },
  { &hf_lpp_additional_prs_config_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_additional_prs_config_r14 },
  { &hf_lpp_prs_based_tbs_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_prs_based_tbs_r14 },
  { &hf_lpp_additionalPathsReport_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_additionalPathsReport_r14 },
  { &hf_lpp_densePrsConfig_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_densePrsConfig_r14 },
  { &hf_lpp_maxSupportedPrsBandwidth_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_maxSupportedPrsBandwidth_r14 },
  { &hf_lpp_prsOccGroup_r14 , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_prsOccGroup_r14 },
  { &hf_lpp_prsFrequencyHopping_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_prsFrequencyHopping_r14 },
  { &hf_lpp_maxSupportedPrsConfigs_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_maxSupportedPrsConfigs_r14 },
  { &hf_lpp_periodicalReporting_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_periodicalReporting_r14 },
  { &hf_lpp_multiPrbNprs_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_multiPrbNprs_r14 },
  { &hf_lpp_idleStateForMeasurements_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_idleStateForMeasurements_r14 },
  { &hf_lpp_numberOfRXantennas_r14, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_numberOfRXantennas_r14 },
  { &hf_lpp_motionMeasurements_r15_01, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_motionMeasurements_r15_01 },
  { &hf_lpp_interRAT_RSTDmeasurement_r15, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_interRAT_RSTDmeasurement_r15 },
  { &hf_lpp_scheduledLocationRequestSupported_r17, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_OTDOA_ProvideCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_OTDOA_ProvideCapabilities, OTDOA_ProvideCapabilities_sequence);

  return offset;
}


static int * const T_ecid_MeasSupported_bits[] = {
  &hf_lpp_T_ecid_MeasSupported_rsrpSup,
  &hf_lpp_T_ecid_MeasSupported_rsrqSup,
  &hf_lpp_T_ecid_MeasSupported_ueRxTxSup,
  &hf_lpp_T_ecid_MeasSupported_nrsrpSup_r14,
  &hf_lpp_T_ecid_MeasSupported_nrsrqSup_r14,
  NULL
};

static int
dissect_lpp_T_ecid_MeasSupported(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_ecid_MeasSupported_bits, 5, NULL, NULL);

  return offset;
}


static const value_string lpp_T_ueRxTxSupTDD_r13_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_ueRxTxSupTDD_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ECID_ProvideCapabilities_eag_1_sequence[] = {
  { &hf_lpp_ueRxTxSupTDD_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ueRxTxSupTDD_r13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ECID_ProvideCapabilities_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ECID_ProvideCapabilities_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_periodicalReporting_r14_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_periodicalReporting_r14_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_triggeredReporting_r14_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_triggeredReporting_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_idleStateForMeasurements_r14_02_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_idleStateForMeasurements_r14_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t ECID_ProvideCapabilities_eag_2_sequence[] = {
  { &hf_lpp_periodicalReporting_r14_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_periodicalReporting_r14_01 },
  { &hf_lpp_triggeredReporting_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_triggeredReporting_r14 },
  { &hf_lpp_idleStateForMeasurements_r14_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_idleStateForMeasurements_r14_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ECID_ProvideCapabilities_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ECID_ProvideCapabilities_eag_2_sequence);

  return offset;
}


static const per_sequence_t ECID_ProvideCapabilities_eag_3_sequence[] = {
  { &hf_lpp_scheduledLocationRequestSupported_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ECID_ProvideCapabilities_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ECID_ProvideCapabilities_eag_3_sequence);

  return offset;
}


static const per_sequence_t ECID_ProvideCapabilities_sequence[] = {
  { &hf_lpp_ecid_MeasSupported, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_ecid_MeasSupported },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_ECID_ProvideCapabilities_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_ECID_ProvideCapabilities_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_ECID_ProvideCapabilities_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ECID_ProvideCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ECID_ProvideCapabilities, ECID_ProvideCapabilities_sequence);

  return offset;
}


static int * const T_sensor_Modes_r13_bits[] = {
  &hf_lpp_T_sensor_Modes_r13_standalone,
  &hf_lpp_T_sensor_Modes_r13_ue_assisted,
  &hf_lpp_T_sensor_Modes_r13_ue_based,
  NULL
};

static int
dissect_lpp_T_sensor_Modes_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_sensor_Modes_r13_bits, 3, NULL, NULL);

  return offset;
}


static const value_string lpp_T_validityPeriodSupported_v1520_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_validityPeriodSupported_v1520(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_validityAreaSupported_v1520_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_validityAreaSupported_v1520(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t Sensor_AssistanceDataSupportList_r14_eag_1_sequence[] = {
  { &hf_lpp_validityPeriodSupported_v1520, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_validityPeriodSupported_v1520 },
  { &hf_lpp_validityAreaSupported_v1520, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_validityAreaSupported_v1520 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_AssistanceDataSupportList_r14_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, Sensor_AssistanceDataSupportList_r14_eag_1_sequence);

  return offset;
}


static const per_sequence_t Sensor_AssistanceDataSupportList_r14_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_Sensor_AssistanceDataSupportList_r14_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_AssistanceDataSupportList_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Sensor_AssistanceDataSupportList_r14, Sensor_AssistanceDataSupportList_r14_sequence);

  return offset;
}


static const value_string lpp_T_idleStateForMeasurements_r14_03_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_idleStateForMeasurements_r14_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t Sensor_ProvideCapabilities_r13_eag_1_sequence[] = {
  { &hf_lpp_sensor_AssistanceDataSupportList_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_Sensor_AssistanceDataSupportList_r14 },
  { &hf_lpp_periodicalReportingSupported_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_idleStateForMeasurements_r14_03, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_idleStateForMeasurements_r14_03 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_ProvideCapabilities_r13_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, Sensor_ProvideCapabilities_r13_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_sensor_MotionInformationSup_r15_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_sensor_MotionInformationSup_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t Sensor_ProvideCapabilities_r13_eag_2_sequence[] = {
  { &hf_lpp_sensor_MotionInformationSup_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_sensor_MotionInformationSup_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_ProvideCapabilities_r13_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, Sensor_ProvideCapabilities_r13_eag_2_sequence);

  return offset;
}


static const value_string lpp_T_adjustmentSupported_r16_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_adjustmentSupported_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t Sensor_ProvideCapabilities_r13_eag_3_sequence[] = {
  { &hf_lpp_adjustmentSupported_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_adjustmentSupported_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_ProvideCapabilities_r13_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, Sensor_ProvideCapabilities_r13_eag_3_sequence);

  return offset;
}


static const per_sequence_t Sensor_ProvideCapabilities_r13_eag_4_sequence[] = {
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_ProvideCapabilities_r13_eag_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, Sensor_ProvideCapabilities_r13_eag_4_sequence);

  return offset;
}


static const per_sequence_t Sensor_ProvideCapabilities_r13_sequence[] = {
  { &hf_lpp_sensor_Modes_r13, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_sensor_Modes_r13 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_Sensor_ProvideCapabilities_r13_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_Sensor_ProvideCapabilities_r13_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_Sensor_ProvideCapabilities_r13_eag_3 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_Sensor_ProvideCapabilities_r13_eag_4 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Sensor_ProvideCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Sensor_ProvideCapabilities_r13, Sensor_ProvideCapabilities_r13_sequence);

  return offset;
}


static int * const T_tbs_Modes_r13_bits[] = {
  &hf_lpp_T_tbs_Modes_r13_standalone,
  &hf_lpp_T_tbs_Modes_r13_ue_assisted,
  &hf_lpp_T_tbs_Modes_r13_ue_based,
  NULL
};

static int
dissect_lpp_T_tbs_Modes_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_tbs_Modes_r13_bits, 3, NULL, NULL);

  return offset;
}


static const per_sequence_t MBS_AssistanceDataSupportList_r14_sequence[] = {
  { &hf_lpp_mbs_AcquisitionAssistanceDataSupport_r14, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_mbs_AlmanacAssistanceDataSupport_r14, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_MBS_AssistanceDataSupportList_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_MBS_AssistanceDataSupportList_r14, MBS_AssistanceDataSupportList_r14_sequence);

  return offset;
}


static int * const T_mbs_ConfigSupport_r14_bits[] = {
  &hf_lpp_T_mbs_ConfigSupport_r14_tb1,
  &hf_lpp_T_mbs_ConfigSupport_r14_tb2,
  &hf_lpp_T_mbs_ConfigSupport_r14_tb3,
  &hf_lpp_T_mbs_ConfigSupport_r14_tb4,
  NULL
};

static int
dissect_lpp_T_mbs_ConfigSupport_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_mbs_ConfigSupport_r14_bits, 4, NULL, NULL);

  return offset;
}


static const value_string lpp_T_mbs_IdleStateForMeasurements_r14_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_mbs_IdleStateForMeasurements_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t TBS_ProvideCapabilities_r13_eag_1_sequence[] = {
  { &hf_lpp_mbs_AssistanceDataSupportList_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_MBS_AssistanceDataSupportList_r14 },
  { &hf_lpp_periodicalReportingSupported_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_mbs_ConfigSupport_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_mbs_ConfigSupport_r14 },
  { &hf_lpp_mbs_IdleStateForMeasurements_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_mbs_IdleStateForMeasurements_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_TBS_ProvideCapabilities_r13_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, TBS_ProvideCapabilities_r13_eag_1_sequence);

  return offset;
}


static const per_sequence_t TBS_ProvideCapabilities_r13_eag_2_sequence[] = {
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_TBS_ProvideCapabilities_r13_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, TBS_ProvideCapabilities_r13_eag_2_sequence);

  return offset;
}


static const per_sequence_t TBS_ProvideCapabilities_r13_sequence[] = {
  { &hf_lpp_tbs_Modes_r13   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_tbs_Modes_r13 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_TBS_ProvideCapabilities_r13_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_TBS_ProvideCapabilities_r13_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_TBS_ProvideCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_TBS_ProvideCapabilities_r13, TBS_ProvideCapabilities_r13_sequence);

  return offset;
}


static int * const T_wlan_Modes_r13_bits[] = {
  &hf_lpp_T_wlan_Modes_r13_standalone,
  &hf_lpp_T_wlan_Modes_r13_ue_assisted,
  &hf_lpp_T_wlan_Modes_r13_ue_based,
  NULL
};

static int
dissect_lpp_T_wlan_Modes_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_wlan_Modes_r13_bits, 3, NULL, NULL);

  return offset;
}


static int * const T_wlan_MeasSupported_r13_bits[] = {
  &hf_lpp_T_wlan_MeasSupported_r13_rssi_r13,
  &hf_lpp_T_wlan_MeasSupported_r13_rtt_r13,
  NULL
};

static int
dissect_lpp_T_wlan_MeasSupported_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_wlan_MeasSupported_r13_bits, 2, NULL, NULL);

  return offset;
}


static int * const T_wlan_AP_AD_Supported_r14_bits[] = {
  &hf_lpp_T_wlan_AP_AD_Supported_r14_ap_identifier,
  &hf_lpp_T_wlan_AP_AD_Supported_r14_ap_location,
  NULL
};

static int
dissect_lpp_T_wlan_AP_AD_Supported_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_wlan_AP_AD_Supported_r14_bits, 2, NULL, NULL);

  return offset;
}


static const value_string lpp_T_idleStateForMeasurements_r14_04_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_idleStateForMeasurements_r14_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t WLAN_ProvideCapabilities_r13_eag_1_sequence[] = {
  { &hf_lpp_wlan_AP_AD_Supported_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_wlan_AP_AD_Supported_r14 },
  { &hf_lpp_periodicalReportingSupported_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_idleStateForMeasurements_r14_04, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_idleStateForMeasurements_r14_04 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_WLAN_ProvideCapabilities_r13_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, WLAN_ProvideCapabilities_r13_eag_1_sequence);

  return offset;
}


static const per_sequence_t WLAN_ProvideCapabilities_r13_eag_2_sequence[] = {
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_WLAN_ProvideCapabilities_r13_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, WLAN_ProvideCapabilities_r13_eag_2_sequence);

  return offset;
}


static const per_sequence_t WLAN_ProvideCapabilities_r13_sequence[] = {
  { &hf_lpp_wlan_Modes_r13  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_wlan_Modes_r13 },
  { &hf_lpp_wlan_MeasSupported_r13, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_wlan_MeasSupported_r13 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_WLAN_ProvideCapabilities_r13_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_WLAN_ProvideCapabilities_r13_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_WLAN_ProvideCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_WLAN_ProvideCapabilities_r13, WLAN_ProvideCapabilities_r13_sequence);

  return offset;
}


static int * const T_bt_Modes_r13_bits[] = {
  &hf_lpp_T_bt_Modes_r13_standalone,
  &hf_lpp_T_bt_Modes_r13_ue_assisted,
  NULL
};

static int
dissect_lpp_T_bt_Modes_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_bt_Modes_r13_bits, 2, NULL, NULL);

  return offset;
}


static int * const T_bt_MeasSupported_r13_bits[] = {
  &hf_lpp_T_bt_MeasSupported_r13_rssi_r13,
  NULL
};

static int
dissect_lpp_T_bt_MeasSupported_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_bt_MeasSupported_r13_bits, 1, NULL, NULL);

  return offset;
}


static const value_string lpp_T_idleStateForMeasurements_r14_05_vals[] = {
  {   0, "required" },
  { 0, NULL }
};


static int
dissect_lpp_T_idleStateForMeasurements_r14_05(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t BT_ProvideCapabilities_r13_eag_1_sequence[] = {
  { &hf_lpp_idleStateForMeasurements_r14_05, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_idleStateForMeasurements_r14_05 },
  { &hf_lpp_periodicalReportingSupported_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BT_ProvideCapabilities_r13_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, BT_ProvideCapabilities_r13_eag_1_sequence);

  return offset;
}


static const per_sequence_t BT_ProvideCapabilities_r13_eag_2_sequence[] = {
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BT_ProvideCapabilities_r13_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, BT_ProvideCapabilities_r13_eag_2_sequence);

  return offset;
}


static const per_sequence_t BT_ProvideCapabilities_r13_sequence[] = {
  { &hf_lpp_bt_Modes_r13    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_bt_Modes_r13 },
  { &hf_lpp_bt_MeasSupported_r13, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_bt_MeasSupported_r13 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_BT_ProvideCapabilities_r13_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_BT_ProvideCapabilities_r13_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BT_ProvideCapabilities_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BT_ProvideCapabilities_r13, BT_ProvideCapabilities_r13_sequence);

  return offset;
}


static const per_sequence_t ProvideCapabilities_r9_IEs_eag_1_sequence[] = {
  { &hf_lpp_sensor_ProvideCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_Sensor_ProvideCapabilities_r13 },
  { &hf_lpp_tbs_ProvideCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_TBS_ProvideCapabilities_r13 },
  { &hf_lpp_wlan_ProvideCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_WLAN_ProvideCapabilities_r13 },
  { &hf_lpp_bt_ProvideCapabilities_r13, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BT_ProvideCapabilities_r13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ProvideCapabilities_r9_IEs_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ProvideCapabilities_r9_IEs_eag_1_sequence);

  return offset;
}


static int * const T_nr_ECID_MeasSupported_r16_bits[] = {
  &hf_lpp_T_nr_ECID_MeasSupported_r16_ssrsrpSup,
  &hf_lpp_T_nr_ECID_MeasSupported_r16_ssrsrqSup,
  &hf_lpp_T_nr_ECID_MeasSupported_r16_csirsrpSup,
  &hf_lpp_T_nr_ECID_MeasSupported_r16_csirsrqSup,
  NULL
};

static int
dissect_lpp_T_nr_ECID_MeasSupported_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_nr_ECID_MeasSupported_r16_bits, 4, NULL, NULL);

  return offset;
}


static const value_string lpp_T_periodicalReporting_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_periodicalReporting_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_triggeredReporting_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_triggeredReporting_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_ten_ms_unit_ResponseTime_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_ten_ms_unit_ResponseTime_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_ECID_ProvideCapabilities_r16_eag_1_sequence[] = {
  { &hf_lpp_ten_ms_unit_ResponseTime_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ten_ms_unit_ResponseTime_r17 },
  { &hf_lpp_scheduledLocationRequestSupported_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_ECID_ProvideCapabilities_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_ECID_ProvideCapabilities_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_ECID_ProvideCapabilities_r16_sequence[] = {
  { &hf_lpp_nr_ECID_MeasSupported_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_nr_ECID_MeasSupported_r16 },
  { &hf_lpp_periodicalReporting_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_periodicalReporting_r16 },
  { &hf_lpp_triggeredReporting_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_triggeredReporting_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_ECID_ProvideCapabilities_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_ECID_ProvideCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_ECID_ProvideCapabilities_r16, NR_ECID_ProvideCapabilities_r16_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_1_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 2U, NULL, FALSE);

  return offset;
}


static const value_string lpp_T_maxNrOfTRP_AcrossFreqs_r16_vals[] = {
  {   0, "n4" },
  {   1, "n6" },
  {   2, "n12" },
  {   3, "n16" },
  {   4, "n32" },
  {   5, "n64" },
  {   6, "n128" },
  {   7, "n256" },
  {   8, "n24-v1690" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNrOfTRP_AcrossFreqs_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     8, NULL, TRUE, 1, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_1_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 4U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_FreqBandIndicatorNR_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, FALSE);

  return offset;
}


static const value_string lpp_T_maxNrOfDL_PRS_ResourcesPerResourceSet_r16_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNrOfDL_PRS_ResourcesPerResourceSet_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNrOfDL_PRS_ResourcesPerPositioningFrequencylayer_r16_vals[] = {
  {   0, "n6" },
  {   1, "n24" },
  {   2, "n32" },
  {   3, "n64" },
  {   4, "n96" },
  {   5, "n128" },
  {   6, "n256" },
  {   7, "n512" },
  {   8, "n1024" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNrOfDL_PRS_ResourcesPerPositioningFrequencylayer_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t DL_PRS_ResourcesCapabilityPerBand_r16_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_maxNrOfDL_PRS_ResourcesPerResourceSet_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNrOfDL_PRS_ResourcesPerResourceSet_r16 },
  { &hf_lpp_maxNrOfDL_PRS_ResourcesPerPositioningFrequencylayer_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNrOfDL_PRS_ResourcesPerPositioningFrequencylayer_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_ResourcesCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_ResourcesCapabilityPerBand_r16, DL_PRS_ResourcesCapabilityPerBand_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16_sequence_of[1] = {
  { &hf_lpp_dl_PRS_ResourcesCapabilityBandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_ResourcesCapabilityPerBand_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16_sequence_of,
                                                  1, nrMaxBands_r16, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16_sequence_of[1] = {
  { &hf_lpp_bandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16, SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16_sequence_of,
                                                  1, maxSimultaneousBands_r16, FALSE);

  return offset;
}


static const value_string lpp_T_fr1_Only_r16_vals[] = {
  {   0, "n6" },
  {   1, "n24" },
  {   2, "n64" },
  {   3, "n128" },
  {   4, "n192" },
  {   5, "n256" },
  {   6, "n512" },
  {   7, "n1024" },
  {   8, "n2048" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr1_Only_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_fr2_Only_r16_vals[] = {
  {   0, "n24" },
  {   1, "n64" },
  {   2, "n96" },
  {   3, "n128" },
  {   4, "n192" },
  {   5, "n256" },
  {   6, "n512" },
  {   7, "n1024" },
  {   8, "n2048" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr2_Only_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_fr1_r16_vals[] = {
  {   0, "n6" },
  {   1, "n24" },
  {   2, "n64" },
  {   3, "n96" },
  {   4, "n128" },
  {   5, "n192" },
  {   6, "n256" },
  {   7, "n512" },
  {   8, "n1024" },
  {   9, "n2048" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr1_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_fr2_r16_vals[] = {
  {   0, "n24" },
  {   1, "n64" },
  {   2, "n96" },
  {   3, "n128" },
  {   4, "n192" },
  {   5, "n256" },
  {   6, "n512" },
  {   7, "n1024" },
  {   8, "n2048" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr2_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_fr1_FR2Mix_r16_sequence[] = {
  { &hf_lpp_fr1_r16         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_fr1_r16 },
  { &hf_lpp_fr2_r16         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_fr2_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_fr1_FR2Mix_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_fr1_FR2Mix_r16, T_fr1_FR2Mix_r16_sequence);

  return offset;
}


static const value_string lpp_T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16_vals[] = {
  {   0, "fr1-Only-r16" },
  {   1, "fr2-Only-r16" },
  {   2, "fr1-FR2Mix-r16" },
  { 0, NULL }
};

static const per_choice_t T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16_choice[] = {
  {   0, &hf_lpp_fr1_Only_r16    , ASN1_EXTENSION_ROOT    , dissect_lpp_T_fr1_Only_r16 },
  {   1, &hf_lpp_fr2_Only_r16    , ASN1_EXTENSION_ROOT    , dissect_lpp_T_fr2_Only_r16 },
  {   2, &hf_lpp_fr1_FR2Mix_r16  , ASN1_EXTENSION_ROOT    , dissect_lpp_T_fr1_FR2Mix_r16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16, T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DL_PRS_ResourcesBandCombination_r16_sequence[] = {
  { &hf_lpp_bandList_r16    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_maxSimultaneousBands_r16_OF_FreqBandIndicatorNR_r16 },
  { &hf_lpp_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNrOfDL_PRS_ResourcesAcrossAllFL_TRP_ResourceSet_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_ResourcesBandCombination_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_ResourcesBandCombination_r16, DL_PRS_ResourcesBandCombination_r16_sequence);

  return offset;
}


static const per_sequence_t DL_PRS_ResourcesBandCombinationList_r16_sequence_of[1] = {
  { &hf_lpp_DL_PRS_ResourcesBandCombinationList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_ResourcesBandCombination_r16 },
};

static int
dissect_lpp_DL_PRS_ResourcesBandCombinationList_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_DL_PRS_ResourcesBandCombinationList_r16, DL_PRS_ResourcesBandCombinationList_r16_sequence_of,
                                                  1, maxBandComb_r16, FALSE);

  return offset;
}


static const per_sequence_t NR_DL_PRS_ResourcesCapability_r16_sequence[] = {
  { &hf_lpp_maxNrOfDL_PRS_ResourceSetPerTrpPerFrequencyLayer_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_2 },
  { &hf_lpp_maxNrOfTRP_AcrossFreqs_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNrOfTRP_AcrossFreqs_r16 },
  { &hf_lpp_maxNrOfPosLayer_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_4 },
  { &hf_lpp_dl_PRS_ResourcesCapabilityBandList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_ResourcesCapabilityPerBand_r16 },
  { &hf_lpp_dl_PRS_ResourcesBandCombinationList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_ResourcesBandCombinationList_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_PRS_ResourcesCapability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_PRS_ResourcesCapability_r16, NR_DL_PRS_ResourcesCapability_r16_sequence);

  return offset;
}


static const value_string lpp_T_supportOfRSRP_MeasFR1_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfRSRP_MeasFR1_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfRSRP_MeasFR2_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfRSRP_MeasFR2_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_srs_AssocPRS_MultiLayersFR1_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_srs_AssocPRS_MultiLayersFR1_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_srs_AssocPRS_MultiLayersFR2_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_srs_AssocPRS_MultiLayersFR2_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_UE_RxTEG_ID_MaxSupport_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n6" },
  {   5, "n8" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_UE_RxTEG_ID_MaxSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_UE_TxTEG_ID_MaxSupport_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n6" },
  {   5, "n8" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_UE_TxTEG_ID_MaxSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_UE_RxTxTEG_ID_MaxSupport_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n36" },
  {  10, "n48" },
  {  11, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_UE_RxTxTEG_ID_MaxSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     12, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17_vals[] = {
  {   0, "n2" },
  {   1, "n3" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  { 0, NULL }
};


static int
dissect_lpp_T_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_measureSameDL_PRS_ResourceWithDifferentRxTEGsSimul_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n6" },
  {   5, "n8" },
  { 0, NULL }
};


static int
dissect_lpp_T_measureSameDL_PRS_ResourceWithDifferentRxTEGsSimul_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_UE_TEG_ID_CapabilityPerBand_r17_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_nr_UE_RxTEG_ID_MaxSupport_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_nr_UE_RxTEG_ID_MaxSupport_r17 },
  { &hf_lpp_nr_UE_TxTEG_ID_MaxSupport_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_nr_UE_TxTEG_ID_MaxSupport_r17 },
  { &hf_lpp_nr_UE_RxTxTEG_ID_MaxSupport_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_nr_UE_RxTxTEG_ID_MaxSupport_r17 },
  { &hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_measureSameDL_PRS_ResourceWithDifferentRxTEGs_r17 },
  { &hf_lpp_measureSameDL_PRS_ResourceWithDifferentRxTEGsSimul_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_measureSameDL_PRS_ResourceWithDifferentRxTEGsSimul_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_UE_TEG_ID_CapabilityPerBand_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_UE_TEG_ID_CapabilityPerBand_r17, NR_UE_TEG_ID_CapabilityPerBand_r17_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17_sequence_of[1] = {
  { &hf_lpp_nr_UE_TEG_ID_CapabilityBandList_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_NR_UE_TEG_ID_CapabilityPerBand_r17 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17_sequence_of,
                                                  1, nrMaxBands_r16, FALSE);

  return offset;
}


static const per_sequence_t NR_UE_TEG_Capability_r17_sequence[] = {
  { &hf_lpp_nr_UE_TEG_ID_CapabilityBandList_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_NR_UE_TEG_ID_CapabilityPerBand_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_UE_TEG_Capability_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_UE_TEG_Capability_r17, NR_UE_TEG_Capability_r17_sequence);

  return offset;
}


static const value_string lpp_T_supportOfDL_PRS_FirstPathRSRP_r17_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfDL_PRS_FirstPathRSRP_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_MeasRRC_Inactive_r17_02_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_MeasRRC_Inactive_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t Multi_RTT_MeasCapabilityPerBand_r17_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_supportOfDL_PRS_FirstPathRSRP_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_supportOfDL_PRS_FirstPathRSRP_r17_01 },
  { &hf_lpp_dl_PRS_MeasRRC_Inactive_r17_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_PRS_MeasRRC_Inactive_r17_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Multi_RTT_MeasCapabilityPerBand_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Multi_RTT_MeasCapabilityPerBand_r17, Multi_RTT_MeasCapabilityPerBand_r17_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17_sequence_of[1] = {
  { &hf_lpp_multi_RTT_MeasCapabilityBandList_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_Multi_RTT_MeasCapabilityPerBand_r17 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17_sequence_of,
                                                  1, nrMaxBands_r16, FALSE);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_MeasurementCapability_r16_eag_1_sequence[] = {
  { &hf_lpp_nr_UE_TEG_Capability_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_UE_TEG_Capability_r17 },
  { &hf_lpp_multi_RTT_MeasCapabilityBandList_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_Multi_RTT_MeasCapabilityPerBand_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_MeasurementCapability_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_Multi_RTT_MeasurementCapability_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_MeasurementCapability_r16_sequence[] = {
  { &hf_lpp_maxNrOfRx_TX_MeasFR1_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_4 },
  { &hf_lpp_maxNrOfRx_TX_MeasFR2_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_4 },
  { &hf_lpp_supportOfRSRP_MeasFR1_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_supportOfRSRP_MeasFR1_r16 },
  { &hf_lpp_supportOfRSRP_MeasFR2_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_supportOfRSRP_MeasFR2_r16 },
  { &hf_lpp_srs_AssocPRS_MultiLayersFR1_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_srs_AssocPRS_MultiLayersFR1_r16 },
  { &hf_lpp_srs_AssocPRS_MultiLayersFR2_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_srs_AssocPRS_MultiLayersFR2_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_Multi_RTT_MeasurementCapability_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_MeasurementCapability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_Multi_RTT_MeasurementCapability_r16, NR_Multi_RTT_MeasurementCapability_r16_sequence);

  return offset;
}


static const value_string lpp_T_ssb_FromNeighCellAsQCL_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssb_FromNeighCellAsQCL_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_FromServNeighCellAsQCL_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_FromServNeighCellAsQCL_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DL_PRS_QCL_ProcessingCapabilityPerBand_r16_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_ssb_FromNeighCellAsQCL_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_ssb_FromNeighCellAsQCL_r16 },
  { &hf_lpp_prs_FromServNeighCellAsQCL_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_prs_FromServNeighCellAsQCL_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_QCL_ProcessingCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_QCL_ProcessingCapabilityPerBand_r16, DL_PRS_QCL_ProcessingCapabilityPerBand_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16_sequence_of[1] = {
  { &hf_lpp_dl_PRS_QCL_ProcessingCapabilityBandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_QCL_ProcessingCapabilityPerBand_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16_sequence_of,
                                                  1, nrMaxBands_r16, FALSE);

  return offset;
}


static const per_sequence_t NR_DL_PRS_QCL_ProcessingCapability_r16_sequence[] = {
  { &hf_lpp_dl_PRS_QCL_ProcessingCapabilityBandList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_PRS_QCL_ProcessingCapabilityPerBand_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_PRS_QCL_ProcessingCapability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_PRS_QCL_ProcessingCapability_r16, NR_DL_PRS_QCL_ProcessingCapability_r16_sequence);

  return offset;
}


static const value_string lpp_T_fr1_vals[] = {
  {   0, "mhz5" },
  {   1, "mhz10" },
  {   2, "mhz20" },
  {   3, "mhz40" },
  {   4, "mhz50" },
  {   5, "mhz80" },
  {   6, "mhz100" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_fr2_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz400" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportedBandwidthPRS_r16_vals[] = {
  {   0, "fr1" },
  {   1, "fr2" },
  { 0, NULL }
};

static const per_choice_t T_supportedBandwidthPRS_r16_choice[] = {
  {   0, &hf_lpp_fr1             , ASN1_EXTENSION_ROOT    , dissect_lpp_T_fr1 },
  {   1, &hf_lpp_fr2             , ASN1_EXTENSION_ROOT    , dissect_lpp_T_fr2 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_supportedBandwidthPRS_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_supportedBandwidthPRS_r16, T_supportedBandwidthPRS_r16_choice,
                                 NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_BufferType_r16_vals[] = {
  {   0, "type1" },
  {   1, "type2" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_BufferType_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string lpp_T_durationOfPRS_ProcessingSymbols_r16_vals[] = {
  {   0, "nDot125" },
  {   1, "nDot25" },
  {   2, "nDot5" },
  {   3, "n1" },
  {   4, "n2" },
  {   5, "n4" },
  {   6, "n6" },
  {   7, "n8" },
  {   8, "n12" },
  {   9, "n16" },
  {  10, "n20" },
  {  11, "n25" },
  {  12, "n30" },
  {  13, "n32" },
  {  14, "n35" },
  {  15, "n40" },
  {  16, "n45" },
  {  17, "n50" },
  { 0, NULL }
};


static int
dissect_lpp_T_durationOfPRS_ProcessingSymbols_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     18, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_durationOfPRS_ProcessingSymbolsInEveryTms_r16_vals[] = {
  {   0, "n8" },
  {   1, "n16" },
  {   2, "n20" },
  {   3, "n30" },
  {   4, "n40" },
  {   5, "n80" },
  {   6, "n160" },
  {   7, "n320" },
  {   8, "n640" },
  {   9, "n1280" },
  { 0, NULL }
};


static int
dissect_lpp_T_durationOfPRS_ProcessingSymbolsInEveryTms_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_durationOfPRS_Processing_r16_sequence[] = {
  { &hf_lpp_durationOfPRS_ProcessingSymbols_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_durationOfPRS_ProcessingSymbols_r16 },
  { &hf_lpp_durationOfPRS_ProcessingSymbolsInEveryTms_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_durationOfPRS_ProcessingSymbolsInEveryTms_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_durationOfPRS_Processing_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_durationOfPRS_Processing_r16, T_durationOfPRS_Processing_r16_sequence);

  return offset;
}


static const value_string lpp_T_scs15_r16_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n24" },
  {   6, "n32" },
  {   7, "n48" },
  {   8, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs15_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs30_r16_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n24" },
  {   6, "n32" },
  {   7, "n48" },
  {   8, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs30_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs60_r16_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n24" },
  {   6, "n32" },
  {   7, "n48" },
  {   8, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs120_r16_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n24" },
  {   6, "n32" },
  {   7, "n48" },
  {   8, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs120_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     9, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs15_v1690_vals[] = {
  {   0, "n6" },
  {   1, "n12" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs15_v1690(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs30_v1690_vals[] = {
  {   0, "n6" },
  {   1, "n12" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs30_v1690(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs60_v1690_vals[] = {
  {   0, "n6" },
  {   1, "n12" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_v1690(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs120_v1690_vals[] = {
  {   0, "n6" },
  {   1, "n12" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs120_v1690(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_eag_1_sequence[] = {
  { &hf_lpp_scs15_v1690     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs15_v1690 },
  { &hf_lpp_scs30_v1690     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs30_v1690 },
  { &hf_lpp_scs60_v1690     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs60_v1690 },
  { &hf_lpp_scs120_v1690    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_scs120_v1690 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, T_eag_1_sequence);

  return offset;
}


static const per_sequence_t T_maxNumOfDL_PRS_ResProcessedPerSlot_r16_sequence[] = {
  { &hf_lpp_scs15_r16_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs15_r16_01 },
  { &hf_lpp_scs30_r16_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs30_r16_01 },
  { &hf_lpp_scs60_r16_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs60_r16_01 },
  { &hf_lpp_scs120_r16_01   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs120_r16_01 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_T_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_r16, T_maxNumOfDL_PRS_ResProcessedPerSlot_r16_sequence);

  return offset;
}


static const value_string lpp_T_supportedDL_PRS_ProcessingSamples_RRC_CONNECTED_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportedDL_PRS_ProcessingSamples_RRC_CONNECTED_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_ProcessingWindowType1A_r17_vals[] = {
  {   0, "option1" },
  {   1, "option2" },
  {   2, "option3" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_ProcessingWindowType1A_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_ProcessingWindowType1B_r17_vals[] = {
  {   0, "option1" },
  {   1, "option2" },
  {   2, "option3" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_ProcessingWindowType1B_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_ProcessingWindowType2_r17_vals[] = {
  {   0, "option1" },
  {   1, "option2" },
  {   2, "option3" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_ProcessingWindowType2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_prsProcessingType_r17_vals[] = {
  {   0, "type1A" },
  {   1, "type1B" },
  {   2, "type2" },
  { 0, NULL }
};


static int
dissect_lpp_T_prsProcessingType_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_ppw_dl_PRS_BufferType_r17_vals[] = {
  {   0, "type1" },
  {   1, "type2" },
  { 0, NULL }
};


static int
dissect_lpp_T_ppw_dl_PRS_BufferType_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string lpp_T_ppw_durationOfPRS_ProcessingSymbolsN_r17_vals[] = {
  {   0, "msDot125" },
  {   1, "msDot25" },
  {   2, "msDot5" },
  {   3, "ms1" },
  {   4, "ms2" },
  {   5, "ms4" },
  {   6, "ms6" },
  {   7, "ms8" },
  {   8, "ms12" },
  {   9, "ms16" },
  {  10, "ms20" },
  {  11, "ms25" },
  {  12, "ms30" },
  {  13, "ms32" },
  {  14, "ms35" },
  {  15, "ms40" },
  {  16, "ms45" },
  {  17, "ms50" },
  { 0, NULL }
};


static int
dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsN_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     18, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_ppw_durationOfPRS_ProcessingSymbolsT_r17_vals[] = {
  {   0, "ms1" },
  {   1, "ms2" },
  {   2, "ms4" },
  {   3, "ms8" },
  {   4, "ms16" },
  {   5, "ms20" },
  {   6, "ms30" },
  {   7, "ms40" },
  {   8, "ms80" },
  {   9, "ms160" },
  {  10, "ms320" },
  {  11, "ms640" },
  {  12, "ms1280" },
  { 0, NULL }
};


static int
dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsT_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     13, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_ppw_durationOfPRS_Processing1_r17_sequence[] = {
  { &hf_lpp_ppw_durationOfPRS_ProcessingSymbolsN_r17, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsN_r17 },
  { &hf_lpp_ppw_durationOfPRS_ProcessingSymbolsT_r17, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsT_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_ppw_durationOfPRS_Processing1_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_ppw_durationOfPRS_Processing1_r17, T_ppw_durationOfPRS_Processing1_r17_sequence);

  return offset;
}


static const value_string lpp_T_ppw_durationOfPRS_ProcessingSymbolsN2_r17_vals[] = {
  {   0, "msDot125" },
  {   1, "msDot25" },
  {   2, "msDot5" },
  {   3, "ms1" },
  {   4, "ms2" },
  {   5, "ms3" },
  {   6, "ms4" },
  {   7, "ms5" },
  {   8, "ms6" },
  {   9, "ms8" },
  {  10, "ms12" },
  { 0, NULL }
};


static int
dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsN2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_ppw_durationOfPRS_ProcessingSymbolsT2_r17_vals[] = {
  {   0, "ms4" },
  {   1, "ms5" },
  {   2, "ms6" },
  {   3, "ms8" },
  { 0, NULL }
};


static int
dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsT2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_ppw_durationOfPRS_Processing2_r17_sequence[] = {
  { &hf_lpp_ppw_durationOfPRS_ProcessingSymbolsN2_r17, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsN2_r17 },
  { &hf_lpp_ppw_durationOfPRS_ProcessingSymbolsT2_r17, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_ppw_durationOfPRS_ProcessingSymbolsT2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_ppw_durationOfPRS_Processing2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_ppw_durationOfPRS_Processing2_r17, T_ppw_durationOfPRS_Processing2_r17_sequence);

  return offset;
}


static const value_string lpp_T_scs15_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs15_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs30_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs30_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs60_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs120_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs120_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17_sequence[] = {
  { &hf_lpp_scs15_r17_02    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs15_r17_01 },
  { &hf_lpp_scs30_r17_02    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs30_r17_01 },
  { &hf_lpp_scs60_r17_02    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs60_r17_01 },
  { &hf_lpp_scs120_r17_02   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs120_r17_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17, T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17_sequence);

  return offset;
}


static const value_string lpp_T_fr1_01_vals[] = {
  {   0, "mhz5" },
  {   1, "mhz10" },
  {   2, "mhz20" },
  {   3, "mhz40" },
  {   4, "mhz50" },
  {   5, "mhz80" },
  {   6, "mhz100" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr1_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_fr2_01_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz400" },
  { 0, NULL }
};


static int
dissect_lpp_T_fr2_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_ppw_maxNumOfDL_Bandwidth_r17_vals[] = {
  {   0, "fr1" },
  {   1, "fr2" },
  { 0, NULL }
};

static const per_choice_t T_ppw_maxNumOfDL_Bandwidth_r17_choice[] = {
  {   0, &hf_lpp_fr1_01          , ASN1_NO_EXTENSIONS     , dissect_lpp_T_fr1_01 },
  {   1, &hf_lpp_fr2_01          , ASN1_NO_EXTENSIONS     , dissect_lpp_T_fr2_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_ppw_maxNumOfDL_Bandwidth_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_ppw_maxNumOfDL_Bandwidth_r17, T_ppw_maxNumOfDL_Bandwidth_r17_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_eag_1_sequence[] = {
  { &hf_lpp_ppw_maxNumOfDL_Bandwidth_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ppw_maxNumOfDL_Bandwidth_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_eag_1_sequence);

  return offset;
}


static const per_sequence_t PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_sequence[] = {
  { &hf_lpp_prsProcessingType_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_prsProcessingType_r17 },
  { &hf_lpp_ppw_dl_PRS_BufferType_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_ppw_dl_PRS_BufferType_r17 },
  { &hf_lpp_ppw_durationOfPRS_Processing1_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_ppw_durationOfPRS_Processing1_r17 },
  { &hf_lpp_ppw_durationOfPRS_Processing2_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_ppw_durationOfPRS_Processing2_r17 },
  { &hf_lpp_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_ppw_maxNumOfDL_PRS_ResProcessedPerSlot_r17 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17, PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_sequence_of[1] = {
  { &hf_lpp_prs_ProcessingCapabilityOutsideMGinPPW_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17, SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17_sequence_of,
                                                  1, 3, FALSE);

  return offset;
}


static const value_string lpp_T_dl_PRS_BufferType_RRC_Inactive_r17_vals[] = {
  {   0, "type1" },
  {   1, "type2" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_BufferType_RRC_Inactive_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string lpp_T_durationOfPRS_ProcessingSymbols_r17_vals[] = {
  {   0, "nDot125" },
  {   1, "nDot25" },
  {   2, "nDot5" },
  {   3, "n1" },
  {   4, "n2" },
  {   5, "n4" },
  {   6, "n6" },
  {   7, "n8" },
  {   8, "n12" },
  {   9, "n16" },
  {  10, "n20" },
  {  11, "n25" },
  {  12, "n30" },
  {  13, "n32" },
  {  14, "n35" },
  {  15, "n40" },
  {  16, "n45" },
  {  17, "n50" },
  { 0, NULL }
};


static int
dissect_lpp_T_durationOfPRS_ProcessingSymbols_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     18, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_durationOfPRS_ProcessingSymbolsInEveryTms_r17_vals[] = {
  {   0, "n8" },
  {   1, "n16" },
  {   2, "n20" },
  {   3, "n30" },
  {   4, "n40" },
  {   5, "n80" },
  {   6, "n160" },
  {   7, "n320" },
  {   8, "n640" },
  {   9, "n1280" },
  { 0, NULL }
};


static int
dissect_lpp_T_durationOfPRS_ProcessingSymbolsInEveryTms_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_durationOfPRS_Processing_RRC_Inactive_r17_sequence[] = {
  { &hf_lpp_durationOfPRS_ProcessingSymbols_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_durationOfPRS_ProcessingSymbols_r17 },
  { &hf_lpp_durationOfPRS_ProcessingSymbolsInEveryTms_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_durationOfPRS_ProcessingSymbolsInEveryTms_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_durationOfPRS_Processing_RRC_Inactive_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_durationOfPRS_Processing_RRC_Inactive_r17, T_durationOfPRS_Processing_RRC_Inactive_r17_sequence);

  return offset;
}


static const value_string lpp_T_scs15_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs15_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs30_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs30_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs60_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs60_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_scs120_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  {   4, "n8" },
  {   5, "n12" },
  {   6, "n16" },
  {   7, "n24" },
  {   8, "n32" },
  {   9, "n48" },
  {  10, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_scs120_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     11, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17_sequence[] = {
  { &hf_lpp_scs15_r17_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs15_r17 },
  { &hf_lpp_scs30_r17_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs30_r17 },
  { &hf_lpp_scs60_r17_01    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs60_r17 },
  { &hf_lpp_scs120_r17_01   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_scs120_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17, T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17_sequence);

  return offset;
}


static const value_string lpp_T_supportedLowerRxBeamSweepingFactor_FR2_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n6" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportedLowerRxBeamSweepingFactor_FR2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PRS_ProcessingCapabilityPerBand_r16_eag_1_sequence[] = {
  { &hf_lpp_supportedDL_PRS_ProcessingSamples_RRC_CONNECTED_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportedDL_PRS_ProcessingSamples_RRC_CONNECTED_r17 },
  { &hf_lpp_prs_ProcessingWindowType1A_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_prs_ProcessingWindowType1A_r17 },
  { &hf_lpp_prs_ProcessingWindowType1B_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_prs_ProcessingWindowType1B_r17 },
  { &hf_lpp_prs_ProcessingWindowType2_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_prs_ProcessingWindowType2_r17 },
  { &hf_lpp_prs_ProcessingCapabilityOutsideMGinPPW_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_3_OF_PRS_ProcessingCapabilityOutsideMGinPPWperType_r17 },
  { &hf_lpp_dl_PRS_BufferType_RRC_Inactive_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_dl_PRS_BufferType_RRC_Inactive_r17 },
  { &hf_lpp_durationOfPRS_Processing_RRC_Inactive_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_durationOfPRS_Processing_RRC_Inactive_r17 },
  { &hf_lpp_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_RRC_Inactive_r17 },
  { &hf_lpp_supportedLowerRxBeamSweepingFactor_FR2_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportedLowerRxBeamSweepingFactor_FR2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PRS_ProcessingCapabilityPerBand_r16_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_supportedDL_PRS_ProcessingSamples_RRC_Inactive_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportedDL_PRS_ProcessingSamples_RRC_Inactive_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PRS_ProcessingCapabilityPerBand_r16_eag_2_sequence[] = {
  { &hf_lpp_supportedDL_PRS_ProcessingSamples_RRC_Inactive_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_supportedDL_PRS_ProcessingSamples_RRC_Inactive_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PRS_ProcessingCapabilityPerBand_r16_eag_2_sequence);

  return offset;
}


static const value_string lpp_T_prs_MeasurementWithoutMG_r17_vals[] = {
  {   0, "cp" },
  {   1, "symbolDot25" },
  {   2, "symbolDot5" },
  {   3, "slotDot5" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_MeasurementWithoutMG_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PRS_ProcessingCapabilityPerBand_r16_eag_3_sequence[] = {
  { &hf_lpp_prs_MeasurementWithoutMG_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_prs_MeasurementWithoutMG_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PRS_ProcessingCapabilityPerBand_r16_eag_3_sequence);

  return offset;
}


static const per_sequence_t PRS_ProcessingCapabilityPerBand_r16_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_supportedBandwidthPRS_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_supportedBandwidthPRS_r16 },
  { &hf_lpp_dl_PRS_BufferType_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_dl_PRS_BufferType_r16 },
  { &hf_lpp_durationOfPRS_Processing_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_durationOfPRS_Processing_r16 },
  { &hf_lpp_maxNumOfDL_PRS_ResProcessedPerSlot_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNumOfDL_PRS_ResProcessedPerSlot_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_PRS_ProcessingCapabilityPerBand_r16_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_ProcessingCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PRS_ProcessingCapabilityPerBand_r16, PRS_ProcessingCapabilityPerBand_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16_sequence_of[1] = {
  { &hf_lpp_prs_ProcessingCapabilityBandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_PRS_ProcessingCapabilityPerBand_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16_sequence_of,
                                                  1, nrMaxBands_r16, FALSE);

  return offset;
}


static const value_string lpp_T_simulLTE_NR_PRS_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_simulLTE_NR_PRS_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_dummy_vals[] = {
  {   0, "m1" },
  {   1, "m2" },
  { 0, NULL }
};


static int
dissect_lpp_T_dummy(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_PRS_ProcessingCapability_r16_eag_1_sequence[] = {
  { &hf_lpp_dummy           , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_dummy },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_PRS_ProcessingCapability_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_PRS_ProcessingCapability_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_DL_PRS_ProcessingCapability_r16_sequence[] = {
  { &hf_lpp_prs_ProcessingCapabilityBandList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_PRS_ProcessingCapabilityPerBand_r16 },
  { &hf_lpp_maxSupportedFreqLayers_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_4 },
  { &hf_lpp_simulLTE_NR_PRS_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_simulLTE_NR_PRS_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ProcessingCapability_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_PRS_ProcessingCapability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_PRS_ProcessingCapability_r16, NR_DL_PRS_ProcessingCapability_r16_sequence);

  return offset;
}


static const value_string lpp_T_olpc_SRS_PosBasedOnPRS_Serving_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_olpc_SRS_PosBasedOnPRS_Serving_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_olpc_SRS_PosBasedOnSSB_Neigh_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_olpc_SRS_PosBasedOnSSB_Neigh_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_olpc_SRS_PosBasedOnPRS_Neigh_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_olpc_SRS_PosBasedOnPRS_Neigh_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumberPathLossEstimatePerServing_r16_vals[] = {
  {   0, "n1" },
  {   1, "n4" },
  {   2, "n8" },
  {   3, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberPathLossEstimatePerServing_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t OLPC_SRS_Pos_r16_sequence[] = {
  { &hf_lpp_olpc_SRS_PosBasedOnPRS_Serving_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_olpc_SRS_PosBasedOnPRS_Serving_r16 },
  { &hf_lpp_olpc_SRS_PosBasedOnSSB_Neigh_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_olpc_SRS_PosBasedOnSSB_Neigh_r16 },
  { &hf_lpp_olpc_SRS_PosBasedOnPRS_Neigh_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_olpc_SRS_PosBasedOnPRS_Neigh_r16 },
  { &hf_lpp_maxNumberPathLossEstimatePerServing_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumberPathLossEstimatePerServing_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_OLPC_SRS_Pos_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_OLPC_SRS_Pos_r16, OLPC_SRS_Pos_r16_sequence);

  return offset;
}


static const value_string lpp_T_spatialRelation_SRS_PosBasedOnSSB_Serving_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_spatialRelation_SRS_PosBasedOnSSB_Serving_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_spatialRelation_SRS_PosBasedOnPRS_Serving_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_spatialRelation_SRS_PosBasedOnPRS_Serving_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_spatialRelation_SRS_PosBasedOnSRS_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_spatialRelation_SRS_PosBasedOnSRS_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SpatialRelationsSRS_Pos_r16_sequence[] = {
  { &hf_lpp_spatialRelation_SRS_PosBasedOnSSB_Serving_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_spatialRelation_SRS_PosBasedOnSSB_Serving_r16 },
  { &hf_lpp_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_spatialRelation_SRS_PosBasedOnCSI_RS_Serving_r16 },
  { &hf_lpp_spatialRelation_SRS_PosBasedOnPRS_Serving_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_spatialRelation_SRS_PosBasedOnPRS_Serving_r16 },
  { &hf_lpp_spatialRelation_SRS_PosBasedOnSRS_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_spatialRelation_SRS_PosBasedOnSRS_r16 },
  { &hf_lpp_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_spatialRelation_SRS_PosBasedOnSSB_Neigh_r16 },
  { &hf_lpp_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_spatialRelation_SRS_PosBasedOnPRS_Neigh_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SpatialRelationsSRS_Pos_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SpatialRelationsSRS_Pos_r16, SpatialRelationsSRS_Pos_r16_sequence);

  return offset;
}


static const value_string lpp_T_maxNumOfSRSposResourceSets_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n12" },
  {   5, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfSRSposResourceSets_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicSRSposResources_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicSRSposResources_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicSRSposResourcesPerSlot_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicSRSposResourcesPerSlot_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_dummy1_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_dummy1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_dummy2_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_dummy2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PosSRS_RRC_Inactive_InInitialUL_BWP_r17_sequence[] = {
  { &hf_lpp_maxNumOfSRSposResourceSets_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfSRSposResourceSets_r17 },
  { &hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17 },
  { &hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17 },
  { &hf_lpp_maxNumOfPeriodicSRSposResources_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicSRSposResources_r17 },
  { &hf_lpp_maxNumOfPeriodicSRSposResourcesPerSlot_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicSRSposResourcesPerSlot_r17 },
  { &hf_lpp_dummy1          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dummy1 },
  { &hf_lpp_dummy2          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dummy2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PosSRS_RRC_Inactive_InInitialUL_BWP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PosSRS_RRC_Inactive_InInitialUL_BWP_r17, PosSRS_RRC_Inactive_InInitialUL_BWP_r17_sequence);

  return offset;
}


static const value_string lpp_T_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17_vals[] = {
  {   0, "mhz5" },
  {   1, "mhz10" },
  {   2, "mhz15" },
  {   3, "mhz20" },
  {   4, "mhz25" },
  {   5, "mhz30" },
  {   6, "mhz35" },
  {   7, "mhz40" },
  {   8, "mhz45" },
  {   9, "mhz50" },
  {  10, "mhz60" },
  {  11, "mhz70" },
  {  12, "mhz80" },
  {  13, "mhz90" },
  {  14, "mhz100" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     15, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17_vals[] = {
  {   0, "mhz50" },
  {   1, "mhz100" },
  {   2, "mhz200" },
  {   3, "mhz400" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfSRSposResourceSets_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n12" },
  {   5, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfSRSposResourceSets_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicSRSposResources_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicSRSposResources_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicSRSposResourcesPerSlot_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicSRSposResourcesPerSlot_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_differentNumerologyBetweenSRSposAndInitialBWP_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_differentNumerologyBetweenSRSposAndInitialBWP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_srsPosWithoutRestrictionOnBWP_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_srsPosWithoutRestrictionOnBWP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_differentCenterFreqBetweenSRSposAndInitialBWP_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_differentCenterFreqBetweenSRSposAndInitialBWP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfSemiPersistentSRSposResources_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfSemiPersistentSRSposResources_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_switchingTimeSRS_TX_OtherTX_r17_vals[] = {
  {   0, "us100" },
  {   1, "us140" },
  {   2, "us200" },
  {   3, "us300" },
  {   4, "us500" },
  { 0, NULL }
};


static int
dissect_lpp_T_switchingTimeSRS_TX_OtherTX_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17_sequence[] = {
  { &hf_lpp_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxSRSposBandwidthForEachSCS_withinCC_FR1_r17 },
  { &hf_lpp_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxSRSposBandwidthForEachSCS_withinCC_FR2_r17 },
  { &hf_lpp_maxNumOfSRSposResourceSets_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfSRSposResourceSets_r17_01 },
  { &hf_lpp_maxNumOfPeriodicSRSposResources_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicSRSposResources_r17_01 },
  { &hf_lpp_maxNumOfPeriodicSRSposResourcesPerSlot_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicSRSposResourcesPerSlot_r17_01 },
  { &hf_lpp_differentNumerologyBetweenSRSposAndInitialBWP_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_differentNumerologyBetweenSRSposAndInitialBWP_r17 },
  { &hf_lpp_srsPosWithoutRestrictionOnBWP_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_srsPosWithoutRestrictionOnBWP_r17 },
  { &hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResources_r17_01 },
  { &hf_lpp_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfPeriodicAndSemiPersistentSRSposResourcesPerSlot_r17_01 },
  { &hf_lpp_differentCenterFreqBetweenSRSposAndInitialBWP_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_differentCenterFreqBetweenSRSposAndInitialBWP_r17 },
  { &hf_lpp_maxNumOfSemiPersistentSRSposResources_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfSemiPersistentSRSposResources_r17 },
  { &hf_lpp_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17 },
  { &hf_lpp_switchingTimeSRS_TX_OtherTX_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_switchingTimeSRS_TX_OtherTX_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17, PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17_sequence);

  return offset;
}


static const per_sequence_t SRS_CapabilityPerBand_r16_eag_1_sequence[] = {
  { &hf_lpp_posSRS_RRC_Inactive_InInitialUL_BWP_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PosSRS_RRC_Inactive_InInitialUL_BWP_r17 },
  { &hf_lpp_posSRS_RRC_Inactive_OutsideInitialUL_BWP_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PosSRS_RRC_Inactive_OutsideInitialUL_BWP_r17 },
  { &hf_lpp_olpc_SRS_PosRRC_Inactive_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_OLPC_SRS_Pos_r16 },
  { &hf_lpp_spatialRelationsSRS_PosRRC_Inactive_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SpatialRelationsSRS_Pos_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SRS_CapabilityPerBand_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SRS_CapabilityPerBand_r16_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_maxNumOfSemiPersistentSRSposResources_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfSemiPersistentSRSposResources_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n3" },
  {   3, "n4" },
  {   4, "n5" },
  {   5, "n6" },
  {   6, "n8" },
  {   7, "n10" },
  {   8, "n12" },
  {   9, "n14" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     10, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17_sequence[] = {
  { &hf_lpp_maxNumOfSemiPersistentSRSposResources_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfSemiPersistentSRSposResources_r17_01 },
  { &hf_lpp_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumOfSemiPersistentSRSposResourcesPerSlot_r17_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17, PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17_sequence);

  return offset;
}


static const per_sequence_t SRS_CapabilityPerBand_r16_eag_2_sequence[] = {
  { &hf_lpp_posSRS_SP_RRC_Inactive_InInitialUL_BWP_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PosSRS_SP_RRC_Inactive_InInitialUL_BWP_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SRS_CapabilityPerBand_r16_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SRS_CapabilityPerBand_r16_eag_2_sequence);

  return offset;
}


static const per_sequence_t SRS_CapabilityPerBand_r16_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_olpc_SRS_Pos_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_OLPC_SRS_Pos_r16 },
  { &hf_lpp_spatialRelationsSRS_Pos_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SpatialRelationsSRS_Pos_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_SRS_CapabilityPerBand_r16_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_SRS_CapabilityPerBand_r16_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SRS_CapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SRS_CapabilityPerBand_r16, SRS_CapabilityPerBand_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16_sequence_of[1] = {
  { &hf_lpp_srs_CapabilityBandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SRS_CapabilityPerBand_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16_sequence_of,
                                                  1, nrMaxBands_r16, FALSE);

  return offset;
}


static const value_string lpp_T_maxNumberSRS_PosResourceSetsPerBWP_r16_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n12" },
  {   5, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberSRS_PosResourceSetsPerBWP_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumberSRS_PosResourcesPerBWP_r16_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberSRS_PosResourcesPerBWP_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumberPeriodicSRS_PosResourcesPerBWP_r16_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberPeriodicSRS_PosResourcesPerBWP_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumberAP_SRS_PosResourcesPerBWP_r16_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberAP_SRS_PosResourcesPerBWP_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumberSP_SRS_PosResourcesPerBWP_r16_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  {   6, "n64" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberSP_SRS_PosResourcesPerBWP_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SRS_PosResourcesPerBand_r16_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_maxNumberSRS_PosResourceSetsPerBWP_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNumberSRS_PosResourceSetsPerBWP_r16 },
  { &hf_lpp_maxNumberSRS_PosResourcesPerBWP_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNumberSRS_PosResourcesPerBWP_r16 },
  { &hf_lpp_maxNumberPeriodicSRS_PosResourcesPerBWP_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_maxNumberPeriodicSRS_PosResourcesPerBWP_r16 },
  { &hf_lpp_maxNumberAP_SRS_PosResourcesPerBWP_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumberAP_SRS_PosResourcesPerBWP_r16 },
  { &hf_lpp_maxNumberSP_SRS_PosResourcesPerBWP_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumberSP_SRS_PosResourcesPerBWP_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SRS_PosResourcesPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SRS_PosResourcesPerBand_r16, SRS_PosResourcesPerBand_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16_sequence_of[1] = {
  { &hf_lpp_srs_PosResourceConfigCA_BandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SRS_PosResourcesPerBand_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16, SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16_sequence_of,
                                                  1, nrMaxConfiguredBands_r16, FALSE);

  return offset;
}


static const value_string lpp_T_maxNumberSRS_PosPathLossEstimateAllServingCells_r16_vals[] = {
  {   0, "n1" },
  {   1, "n4" },
  {   2, "n8" },
  {   3, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberSRS_PosPathLossEstimateAllServingCells_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxNumberSRS_PosSpatialRelationsAllServingCells_r16_vals[] = {
  {   0, "n0" },
  {   1, "n1" },
  {   2, "n2" },
  {   3, "n4" },
  {   4, "n8" },
  {   5, "n16" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxNumberSRS_PosSpatialRelationsAllServingCells_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_UL_SRS_Capability_r16_sequence[] = {
  { &hf_lpp_srs_CapabilityBandList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_SRS_CapabilityPerBand_r16 },
  { &hf_lpp_srs_PosResourceConfigCA_BandList_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_nrMaxConfiguredBands_r16_OF_SRS_PosResourcesPerBand_r16 },
  { &hf_lpp_maxNumberSRS_PosPathLossEstimateAllServingCells_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumberSRS_PosPathLossEstimateAllServingCells_r16 },
  { &hf_lpp_maxNumberSRS_PosSpatialRelationsAllServingCells_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_maxNumberSRS_PosSpatialRelationsAllServingCells_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_UL_SRS_Capability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_UL_SRS_Capability_r16, NR_UL_SRS_Capability_r16_sequence);

  return offset;
}


static const value_string lpp_T_additionalPathsReport_r16_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_additionalPathsReport_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_periodicalReporting_r16_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_periodicalReporting_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_ten_ms_unit_ResponseTime_r17_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_ten_ms_unit_ResponseTime_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static int * const T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02_bits[] = {
  &hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02_eAoD,
  &hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02_eAoA,
  NULL
};

static int
dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02_bits, 2, NULL, NULL);

  return offset;
}


static const value_string lpp_T_nr_on_demand_DL_PRS_InformationSup_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_on_demand_DL_PRS_InformationSup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_on_demand_DL_PRS_ConfigurationsSup_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_on_demand_DL_PRS_ConfigurationsSup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_On_Demand_DL_PRS_Support_r17_sequence[] = {
  { &hf_lpp_nr_on_demand_DL_PRS_InformationSup_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_nr_on_demand_DL_PRS_InformationSup_r17 },
  { &hf_lpp_nr_on_demand_DL_PRS_ConfigurationsSup_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_nr_on_demand_DL_PRS_ConfigurationsSup_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_On_Demand_DL_PRS_Support_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_On_Demand_DL_PRS_Support_r17, NR_On_Demand_DL_PRS_Support_r17_sequence);

  return offset;
}


static int * const T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_bits[] = {
  &hf_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_case1,
  &hf_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_case2,
  &hf_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_case3,
  NULL
};

static int
dissect_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17_bits, 3, NULL, NULL);

  return offset;
}


static const value_string lpp_LOS_NLOS_IndicatorType2_r17_vals[] = {
  {   0, "hardvalue" },
  {   1, "hardAndsoftvalue" },
  { 0, NULL }
};


static int
dissect_lpp_LOS_NLOS_IndicatorType2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_LOS_NLOS_IndicatorGranularity2_r17_vals[] = {
  {   0, "trpspecific" },
  {   1, "resourcespecific" },
  {   2, "both" },
  { 0, NULL }
};


static int
dissect_lpp_LOS_NLOS_IndicatorGranularity2_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nr_los_nlos_IndicatorSupport_r17_02_sequence[] = {
  { &hf_lpp_type_r17_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorType2_r17 },
  { &hf_lpp_granularity_r17_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorGranularity2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_los_nlos_IndicatorSupport_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_los_nlos_IndicatorSupport_r17_02, T_nr_los_nlos_IndicatorSupport_r17_02_sequence);

  return offset;
}


static const value_string lpp_T_additionalPathsExtSupport_r17_01_vals[] = {
  {   0, "n4" },
  {   1, "n6" },
  {   2, "n8" },
  { 0, NULL }
};


static int
dissect_lpp_T_additionalPathsExtSupport_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_1_maxNrOfAreas_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxNrOfAreas_r17, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_nr_dl_prs_AssistanceDataValidity_r17_02_sequence[] = {
  { &hf_lpp_area_validity_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_maxNrOfAreas_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_02, T_nr_dl_prs_AssistanceDataValidity_r17_02_sequence);

  return offset;
}


static const value_string lpp_T_multiMeasInSameMeasReport_r17_02_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_multiMeasInSameMeasReport_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_mg_ActivationRequest_r17_02_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_mg_ActivationRequest_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_ProvideCapabilities_r16_eag_1_sequence[] = {
  { &hf_lpp_ten_ms_unit_ResponseTime_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ten_ms_unit_ResponseTime_r17_01 },
  { &hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_02 },
  { &hf_lpp_nr_Multi_RTT_On_Demand_DL_PRS_Support_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Support_r17 },
  { &hf_lpp_nr_UE_RxTx_TEG_ID_ReportingSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_UE_RxTx_TEG_ID_ReportingSupport_r17 },
  { &hf_lpp_nr_los_nlos_IndicatorSupport_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_los_nlos_IndicatorSupport_r17_02 },
  { &hf_lpp_additionalPathsExtSupport_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_additionalPathsExtSupport_r17_01 },
  { &hf_lpp_scheduledLocationRequestSupported_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupport_r17 },
  { &hf_lpp_nr_dl_prs_AssistanceDataValidity_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_02 },
  { &hf_lpp_multiMeasInSameMeasReport_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_multiMeasInSameMeasReport_r17_02 },
  { &hf_lpp_mg_ActivationRequest_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_mg_ActivationRequest_r17_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_Multi_RTT_ProvideCapabilities_r16_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_posMeasGapSupport_r17_02_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_posMeasGapSupport_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_ProvideCapabilities_r16_eag_2_sequence[] = {
  { &hf_lpp_posMeasGapSupport_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_posMeasGapSupport_r17_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_Multi_RTT_ProvideCapabilities_r16_eag_2_sequence);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_ProvideCapabilities_r16_sequence[] = {
  { &hf_lpp_nr_Multi_RTT_PRS_Capability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ResourcesCapability_r16 },
  { &hf_lpp_nr_Multi_RTT_MeasurementCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_Multi_RTT_MeasurementCapability_r16 },
  { &hf_lpp_nr_DL_PRS_QCL_ProcessingCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_QCL_ProcessingCapability_r16 },
  { &hf_lpp_nr_DL_PRS_ProcessingCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ProcessingCapability_r16 },
  { &hf_lpp_nr_UL_SRS_Capability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_UL_SRS_Capability_r16 },
  { &hf_lpp_additionalPathsReport_r16_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_additionalPathsReport_r16_01 },
  { &hf_lpp_periodicalReporting_r16_02, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_periodicalReporting_r16_01 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_Multi_RTT_ProvideCapabilities_r16, NR_Multi_RTT_ProvideCapabilities_r16_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_1_8(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 8U, NULL, FALSE);

  return offset;
}


static const value_string lpp_T_simul_NR_DL_AoD_DL_TDOA_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_simul_NR_DL_AoD_DL_TDOA_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_simul_NR_DL_AoD_Multi_RTT_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_simul_NR_DL_AoD_Multi_RTT_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxDL_PRS_FirstPathRSRP_MeasPerTRP_r17_vals[] = {
  {   0, "n1" },
  {   1, "n2" },
  {   2, "n4" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n24" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxDL_PRS_FirstPathRSRP_MeasPerTRP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_MeasRRC_Inactive_r17_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_MeasRRC_Inactive_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DL_AoD_MeasCapabilityPerBand_r16_eag_1_sequence[] = {
  { &hf_lpp_maxDL_PRS_FirstPathRSRP_MeasPerTRP_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maxDL_PRS_FirstPathRSRP_MeasPerTRP_r17 },
  { &hf_lpp_dl_PRS_MeasRRC_Inactive_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_dl_PRS_MeasRRC_Inactive_r17_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_AoD_MeasCapabilityPerBand_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, DL_AoD_MeasCapabilityPerBand_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t DL_AoD_MeasCapabilityPerBand_r16_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_simul_NR_DL_AoD_DL_TDOA_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_simul_NR_DL_AoD_DL_TDOA_r16 },
  { &hf_lpp_simul_NR_DL_AoD_Multi_RTT_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_simul_NR_DL_AoD_Multi_RTT_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_DL_AoD_MeasCapabilityPerBand_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_AoD_MeasCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_AoD_MeasCapabilityPerBand_r16, DL_AoD_MeasCapabilityPerBand_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16_sequence_of[1] = {
  { &hf_lpp_dl_AoD_MeasCapabilityBandList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_AoD_MeasCapabilityPerBand_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16_sequence_of,
                                                  1, nrMaxBands_r16, FALSE);

  return offset;
}


static const value_string lpp_T_maxDL_PRS_RSRP_MeasurementFR1_v1730_vals[] = {
  {   0, "n16" },
  {   1, "n24" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxDL_PRS_RSRP_MeasurementFR1_v1730(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_maxDL_PRS_RSRP_MeasurementFR2_v1730_vals[] = {
  {   0, "n16" },
  {   1, "n24" },
  { 0, NULL }
};


static int
dissect_lpp_T_maxDL_PRS_RSRP_MeasurementFR2_v1730(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_AoD_MeasurementCapability_r16_eag_1_sequence[] = {
  { &hf_lpp_maxDL_PRS_RSRP_MeasurementFR1_v1730, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maxDL_PRS_RSRP_MeasurementFR1_v1730 },
  { &hf_lpp_maxDL_PRS_RSRP_MeasurementFR2_v1730, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_maxDL_PRS_RSRP_MeasurementFR2_v1730 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_MeasurementCapability_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_AoD_MeasurementCapability_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_DL_AoD_MeasurementCapability_r16_sequence[] = {
  { &hf_lpp_maxDL_PRS_RSRP_MeasurementFR1_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_8 },
  { &hf_lpp_maxDL_PRS_RSRP_MeasurementFR2_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_8 },
  { &hf_lpp_dl_AoD_MeasCapabilityBandList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_AoD_MeasCapabilityPerBand_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_AoD_MeasurementCapability_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_MeasurementCapability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_AoD_MeasurementCapability_r16, NR_DL_AoD_MeasurementCapability_r16_sequence);

  return offset;
}


static int * const T_nr_PosCalcAssistanceSupport_r17_01_bits[] = {
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_trpLocSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_beamInfoSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_rtdInfoSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_01_beamAntInfoSup,
  NULL
};

static int
dissect_lpp_T_nr_PosCalcAssistanceSupport_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_nr_PosCalcAssistanceSupport_r17_01_bits, 4, NULL, NULL);

  return offset;
}


static const per_sequence_t T_nr_los_nlos_AssistanceDataSupport_r17_01_sequence[] = {
  { &hf_lpp_type_r17_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorType2_r17 },
  { &hf_lpp_granularity_r17_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorGranularity2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_los_nlos_AssistanceDataSupport_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_los_nlos_AssistanceDataSupport_r17_01, T_nr_los_nlos_AssistanceDataSupport_r17_01_sequence);

  return offset;
}


static int * const T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01_bits[] = {
  &hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01_eAoD,
  &hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01_eAoA,
  NULL
};

static int
dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01_bits, 2, NULL, NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_ResourcePrioritySubset_Sup_r17_vals[] = {
  {   0, "sameSet" },
  {   1, "differentSet" },
  {   2, "sameOrDifferentSet" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_ResourcePrioritySubset_Sup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_BeamInfoSup_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_BeamInfoSup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nr_los_nlos_IndicatorSupport_r17_01_sequence[] = {
  { &hf_lpp_type_r17_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorType2_r17 },
  { &hf_lpp_granularity_r17_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorGranularity2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_los_nlos_IndicatorSupport_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_los_nlos_IndicatorSupport_r17_01, T_nr_los_nlos_IndicatorSupport_r17_01_sequence);

  return offset;
}


static const per_sequence_t T_nr_dl_prs_AssistanceDataValidity_r17_01_sequence[] = {
  { &hf_lpp_area_validity_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_maxNrOfAreas_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_01, T_nr_dl_prs_AssistanceDataValidity_r17_01_sequence);

  return offset;
}


static const value_string lpp_T_multiMeasInSameMeasReport_r17_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_multiMeasInSameMeasReport_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_mg_ActivationRequest_r17_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_mg_ActivationRequest_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_AoD_ProvideCapabilities_r16_eag_1_sequence[] = {
  { &hf_lpp_ten_ms_unit_ResponseTime_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_nr_PosCalcAssistanceSupport_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_PosCalcAssistanceSupport_r17_01 },
  { &hf_lpp_nr_los_nlos_AssistanceDataSupport_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_los_nlos_AssistanceDataSupport_r17_01 },
  { &hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_01 },
  { &hf_lpp_dl_PRS_ResourcePrioritySubset_Sup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_dl_PRS_ResourcePrioritySubset_Sup_r17 },
  { &hf_lpp_nr_DL_PRS_BeamInfoSup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_BeamInfoSup_r17 },
  { &hf_lpp_nr_DL_AoD_On_Demand_DL_PRS_Support_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Support_r17 },
  { &hf_lpp_nr_los_nlos_IndicatorSupport_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_los_nlos_IndicatorSupport_r17_01 },
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { &hf_lpp_nr_dl_prs_AssistanceDataValidity_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_dl_prs_AssistanceDataValidity_r17_01 },
  { &hf_lpp_multiMeasInSameMeasReport_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_multiMeasInSameMeasReport_r17_01 },
  { &hf_lpp_mg_ActivationRequest_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_mg_ActivationRequest_r17_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_AoD_ProvideCapabilities_r16_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_posMeasGapSupport_r17_01_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_posMeasGapSupport_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_AoD_ProvideCapabilities_r16_eag_2_sequence[] = {
  { &hf_lpp_posMeasGapSupport_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_posMeasGapSupport_r17_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_AoD_ProvideCapabilities_r16_eag_2_sequence);

  return offset;
}


static const per_sequence_t NR_DL_AoD_ProvideCapabilities_r16_sequence[] = {
  { &hf_lpp_nr_DL_AoD_Mode_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_PositioningModes },
  { &hf_lpp_nr_DL_AoD_PRS_Capability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ResourcesCapability_r16 },
  { &hf_lpp_nr_DL_AoD_MeasurementCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_AoD_MeasurementCapability_r16 },
  { &hf_lpp_nr_DL_PRS_QCL_ProcessingCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_QCL_ProcessingCapability_r16 },
  { &hf_lpp_nr_DL_PRS_ProcessingCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ProcessingCapability_r16 },
  { &hf_lpp_periodicalReporting_r16_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_AoD_ProvideCapabilities_r16, NR_DL_AoD_ProvideCapabilities_r16_sequence);

  return offset;
}


static const value_string lpp_T_supportOfDL_PRS_RSRP_MeasFR1_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfDL_PRS_RSRP_MeasFR1_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfDL_PRS_RSRP_MeasFR2_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfDL_PRS_RSRP_MeasFR2_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_supportOfDL_PRS_FirstPathRSRP_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_supportOfDL_PRS_FirstPathRSRP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_PRS_MeasRRC_Inactive_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_PRS_MeasRRC_Inactive_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t DL_TDOA_MeasCapabilityPerBand_r17_sequence[] = {
  { &hf_lpp_freqBandIndicatorNR_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FreqBandIndicatorNR_r16 },
  { &hf_lpp_supportOfDL_PRS_FirstPathRSRP_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_supportOfDL_PRS_FirstPathRSRP_r17 },
  { &hf_lpp_dl_PRS_MeasRRC_Inactive_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_PRS_MeasRRC_Inactive_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_TDOA_MeasCapabilityPerBand_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_TDOA_MeasCapabilityPerBand_r17, DL_TDOA_MeasCapabilityPerBand_r17_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17_sequence_of[1] = {
  { &hf_lpp_dl_tdoa_MeasCapabilityBandList_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_TDOA_MeasCapabilityPerBand_r17 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17, SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17_sequence_of,
                                                  1, nrMaxBands_r16, FALSE);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_MeasurementCapability_r16_eag_1_sequence[] = {
  { &hf_lpp_nr_UE_TEG_Capability_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_UE_TEG_Capability_r17 },
  { &hf_lpp_dl_tdoa_MeasCapabilityBandList_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_nrMaxBands_r16_OF_DL_TDOA_MeasCapabilityPerBand_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_MeasurementCapability_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_TDOA_MeasurementCapability_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_MeasurementCapability_r16_sequence[] = {
  { &hf_lpp_dl_RSTD_MeasurementPerPairOfTRP_FR1_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_4 },
  { &hf_lpp_dl_RSTD_MeasurementPerPairOfTRP_FR2_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_4 },
  { &hf_lpp_supportOfDL_PRS_RSRP_MeasFR1_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_supportOfDL_PRS_RSRP_MeasFR1_r16 },
  { &hf_lpp_supportOfDL_PRS_RSRP_MeasFR2_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_supportOfDL_PRS_RSRP_MeasFR2_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_TDOA_MeasurementCapability_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_MeasurementCapability_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_TDOA_MeasurementCapability_r16, NR_DL_TDOA_MeasurementCapability_r16_sequence);

  return offset;
}


static const value_string lpp_T_additionalPathsReport_r16_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_additionalPathsReport_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static int * const T_nr_PosCalcAssistanceSupport_r17_bits[] = {
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_trpLocSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_beamInfoSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_rtdInfoSup,
  &hf_lpp_T_nr_PosCalcAssistanceSupport_r17_trpTEG_InfoSup,
  NULL
};

static int
dissect_lpp_T_nr_PosCalcAssistanceSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_nr_PosCalcAssistanceSupport_r17_bits, 4, NULL, NULL);

  return offset;
}


static const per_sequence_t T_nr_los_nlos_AssistanceDataSupport_r17_sequence[] = {
  { &hf_lpp_type_r17_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorType2_r17 },
  { &hf_lpp_granularity_r17_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorGranularity2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_los_nlos_AssistanceDataSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_los_nlos_AssistanceDataSupport_r17, T_nr_los_nlos_AssistanceDataSupport_r17_sequence);

  return offset;
}


static int * const T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_bits[] = {
  &hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_eAoD,
  &hf_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_eAoA,
  NULL
};

static int
dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17_bits, 2, NULL, NULL);

  return offset;
}


static const per_sequence_t T_nr_los_nlos_IndicatorSupport_r17_sequence[] = {
  { &hf_lpp_type_r17_01     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorType2_r17 },
  { &hf_lpp_granularity_r17_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_LOS_NLOS_IndicatorGranularity2_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_los_nlos_IndicatorSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_los_nlos_IndicatorSupport_r17, T_nr_los_nlos_IndicatorSupport_r17_sequence);

  return offset;
}


static const value_string lpp_T_additionalPathsExtSupport_r17_vals[] = {
  {   0, "n4" },
  {   1, "n6" },
  {   2, "n8" },
  { 0, NULL }
};


static int
dissect_lpp_T_additionalPathsExtSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_nr_dl_prs_AssistanceDataValidity_r17_sequence[] = {
  { &hf_lpp_area_validity_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_maxNrOfAreas_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_dl_prs_AssistanceDataValidity_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_dl_prs_AssistanceDataValidity_r17, T_nr_dl_prs_AssistanceDataValidity_r17_sequence);

  return offset;
}


static const value_string lpp_T_multiMeasInSameMeasReport_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_multiMeasInSameMeasReport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_mg_ActivationRequest_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_mg_ActivationRequest_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_ProvideCapabilities_r16_eag_1_sequence[] = {
  { &hf_lpp_ten_ms_unit_ResponseTime_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &hf_lpp_nr_PosCalcAssistanceSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_PosCalcAssistanceSupport_r17 },
  { &hf_lpp_nr_los_nlos_AssistanceDataSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_los_nlos_AssistanceDataSupport_r17 },
  { &hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Sup_r17 },
  { &hf_lpp_nr_DL_TDOA_On_Demand_DL_PRS_Support_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Support_r17 },
  { &hf_lpp_nr_los_nlos_IndicatorSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_los_nlos_IndicatorSupport_r17 },
  { &hf_lpp_additionalPathsExtSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_additionalPathsExtSupport_r17 },
  { &hf_lpp_scheduledLocationRequestSupported_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ScheduledLocationTimeSupportPerMode_r17 },
  { &hf_lpp_nr_dl_prs_AssistanceDataValidity_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_dl_prs_AssistanceDataValidity_r17 },
  { &hf_lpp_multiMeasInSameMeasReport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_multiMeasInSameMeasReport_r17 },
  { &hf_lpp_mg_ActivationRequest_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_mg_ActivationRequest_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_TDOA_ProvideCapabilities_r16_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_posMeasGapSupport_r17_vals[] = {
  {   0, "supported" },
  { 0, NULL }
};


static int
dissect_lpp_T_posMeasGapSupport_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_ProvideCapabilities_r16_eag_2_sequence[] = {
  { &hf_lpp_posMeasGapSupport_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_posMeasGapSupport_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_TDOA_ProvideCapabilities_r16_eag_2_sequence);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_ProvideCapabilities_r16_sequence[] = {
  { &hf_lpp_nr_DL_TDOA_Mode_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_PositioningModes },
  { &hf_lpp_nr_DL_TDOA_PRS_Capability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ResourcesCapability_r16 },
  { &hf_lpp_nr_DL_TDOA_MeasurementCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_TDOA_MeasurementCapability_r16 },
  { &hf_lpp_nr_DL_PRS_QCL_ProcessingCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_QCL_ProcessingCapability_r16 },
  { &hf_lpp_nr_DL_PRS_ProcessingCapability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ProcessingCapability_r16 },
  { &hf_lpp_additionalPathsReport_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_additionalPathsReport_r16 },
  { &hf_lpp_periodicalReporting_r16_01, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PositioningModes },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_TDOA_ProvideCapabilities_r16, NR_DL_TDOA_ProvideCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t NR_UL_ProvideCapabilities_r16_eag_1_sequence[] = {
  { &hf_lpp_nr_UE_TEG_Capability_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_UE_TEG_Capability_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_UL_ProvideCapabilities_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_UL_ProvideCapabilities_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_UL_ProvideCapabilities_r16_sequence[] = {
  { &hf_lpp_nr_UL_SRS_Capability_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_UL_SRS_Capability_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_UL_ProvideCapabilities_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_UL_ProvideCapabilities_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_UL_ProvideCapabilities_r16, NR_UL_ProvideCapabilities_r16_sequence);

  return offset;
}


static const per_sequence_t ProvideCapabilities_r9_IEs_eag_2_sequence[] = {
  { &hf_lpp_nr_ECID_ProvideCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_ECID_ProvideCapabilities_r16 },
  { &hf_lpp_nr_Multi_RTT_ProvideCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_Multi_RTT_ProvideCapabilities_r16 },
  { &hf_lpp_nr_DL_AoD_ProvideCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_DL_AoD_ProvideCapabilities_r16 },
  { &hf_lpp_nr_DL_TDOA_ProvideCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_DL_TDOA_ProvideCapabilities_r16 },
  { &hf_lpp_nr_UL_ProvideCapabilities_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_UL_ProvideCapabilities_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ProvideCapabilities_r9_IEs_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, ProvideCapabilities_r9_IEs_eag_2_sequence);

  return offset;
}


static const per_sequence_t ProvideCapabilities_r9_IEs_sequence[] = {
  { &hf_lpp_commonIEsProvideCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CommonIEsProvideCapabilities },
  { &hf_lpp_a_gnss_ProvideCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_A_GNSS_ProvideCapabilities },
  { &hf_lpp_otdoa_ProvideCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_OTDOA_ProvideCapabilities },
  { &hf_lpp_ecid_ProvideCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_ECID_ProvideCapabilities },
  { &hf_lpp_epdu_ProvideCapabilities, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_EPDU_Sequence },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_ProvideCapabilities_r9_IEs_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_ProvideCapabilities_r9_IEs_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ProvideCapabilities_r9_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ProvideCapabilities_r9_IEs, ProvideCapabilities_r9_IEs_sequence);

  return offset;
}


static const value_string lpp_T_c1_02_vals[] = {
  {   0, "provideCapabilities-r9" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_02_choice[] = {
  {   0, &hf_lpp_provideCapabilities_r9, ASN1_NO_EXTENSIONS     , dissect_lpp_ProvideCapabilities_r9_IEs },
  {   1, &hf_lpp_spare3          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   2, &hf_lpp_spare2          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   3, &hf_lpp_spare1          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_c1_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_c1_02, T_c1_02_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_01_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_criticalExtensionsFuture_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_criticalExtensionsFuture_01, T_criticalExtensionsFuture_01_sequence);

  return offset;
}


static const value_string lpp_T_criticalExtensions_01_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_01_choice[] = {
  {   0, &hf_lpp_c1_02           , ASN1_NO_EXTENSIONS     , dissect_lpp_T_c1_02 },
  {   1, &hf_lpp_criticalExtensionsFuture_01, ASN1_NO_EXTENSIONS     , dissect_lpp_T_criticalExtensionsFuture_01 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_criticalExtensions_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_criticalExtensions_01, T_criticalExtensions_01_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t ProvideCapabilities_sequence[] = {
  { &hf_lpp_criticalExtensions_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_criticalExtensions_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ProvideCapabilities(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Provide Capabilities");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ProvideCapabilities, ProvideCapabilities_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 9U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_mcc_02_sequence_of[1] = {
  { &hf_lpp_mcc_item        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mcc_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mcc_02, T_mcc_02_sequence_of,
                                                  3, 3, FALSE);

  return offset;
}


static const per_sequence_t T_mnc_02_sequence_of[1] = {
  { &hf_lpp_mnc_item        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mnc_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mnc_02, T_mnc_02_sequence_of,
                                                  2, 3, FALSE);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_28(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     28, 28, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t ECGI_sequence[] = {
  { &hf_lpp_mcc_02          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mcc_02 },
  { &hf_lpp_mnc_02          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mnc_02 },
  { &hf_lpp_cellidentity    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_28 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ECGI(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ECGI, ECGI_sequence);

  return offset;
}


static const per_sequence_t CommonIEsRequestAssistanceData_eag_1_sequence[] = {
  { &hf_lpp_segmentationInfo_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SegmentationInfo_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsRequestAssistanceData_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsRequestAssistanceData_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_periodicSessionInitiator_r15_vals[] = {
  {   0, "locationServer" },
  {   1, "targetDevice" },
  { 0, NULL }
};


static int
dissect_lpp_T_periodicSessionInitiator_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_0_255(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t PeriodicSessionID_r15_sequence[] = {
  { &hf_lpp_periodicSessionInitiator_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_periodicSessionInitiator_r15 },
  { &hf_lpp_periodicSessionNumber_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PeriodicSessionID_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PeriodicSessionID_r15, PeriodicSessionID_r15_sequence);

  return offset;
}


static int * const UpdateCapabilities_r15_bits[] = {
  &hf_lpp_UpdateCapabilities_r15_primaryCellID_r15,
  NULL
};

static int
dissect_lpp_UpdateCapabilities_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, UpdateCapabilities_r15_bits, 1, NULL, NULL);

  return offset;
}


static const per_sequence_t PeriodicAssistanceDataControlParameters_r15_eag_1_sequence[] = {
  { &hf_lpp_updateCapabilities_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_UpdateCapabilities_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PeriodicAssistanceDataControlParameters_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PeriodicAssistanceDataControlParameters_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t PeriodicAssistanceDataControlParameters_r15_sequence[] = {
  { &hf_lpp_periodicSessionID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_PeriodicSessionID_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_PeriodicAssistanceDataControlParameters_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PeriodicAssistanceDataControlParameters_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PeriodicAssistanceDataControlParameters_r15, PeriodicAssistanceDataControlParameters_r15_sequence);

  return offset;
}


static const per_sequence_t T_mcc_r15_sequence_of[1] = {
  { &hf_lpp_mcc_r15_item    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mcc_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mcc_r15, T_mcc_r15_sequence_of,
                                                  3, 3, FALSE);

  return offset;
}


static const per_sequence_t T_mnc_r15_sequence_of[1] = {
  { &hf_lpp_mnc_r15_item    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mnc_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mnc_r15, T_mnc_r15_sequence_of,
                                                  2, 3, FALSE);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_36(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     36, 36, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t NCGI_r15_sequence[] = {
  { &hf_lpp_mcc_r15         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mcc_r15 },
  { &hf_lpp_mnc_r15         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mnc_r15 },
  { &hf_lpp_nr_cellidentity_r15, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_36 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NCGI_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NCGI_r15, NCGI_r15_sequence);

  return offset;
}


static const per_sequence_t CommonIEsRequestAssistanceData_eag_2_sequence[] = {
  { &hf_lpp_periodicAssistanceDataReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicAssistanceDataControlParameters_r15 },
  { &hf_lpp_primaryCellID_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NCGI_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsRequestAssistanceData_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsRequestAssistanceData_eag_2_sequence);

  return offset;
}


static const per_sequence_t CommonIEsRequestAssistanceData_sequence[] = {
  { &hf_lpp_primaryCellID   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_ECGI },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsRequestAssistanceData_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsRequestAssistanceData_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsRequestAssistanceData(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CommonIEsRequestAssistanceData, CommonIEsRequestAssistanceData_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_8_OF_GNSS_ID_sequence_of[1] = {
  { &hf_lpp_gnss_TimeReqPrefList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_8_OF_GNSS_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_8_OF_GNSS_ID, SEQUENCE_SIZE_1_8_OF_GNSS_ID_sequence_of,
                                                  1, 8, FALSE);

  return offset;
}


static const per_sequence_t GNSS_ReferenceTimeReq_sequence[] = {
  { &hf_lpp_gnss_TimeReqPrefList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_8_OF_GNSS_ID },
  { &hf_lpp_gps_TOW_assistReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { &hf_lpp_notOfLeapSecReq , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceTimeReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceTimeReq, GNSS_ReferenceTimeReq_sequence);

  return offset;
}


static const per_sequence_t GNSS_ReferenceLocationReq_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceLocationReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceLocationReq, GNSS_ReferenceLocationReq_sequence);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_IonosphericModelReq_eag_1_sequence[] = {
  { &hf_lpp_klobucharModel2Req_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NULL },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_IonosphericModelReq_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_IonosphericModelReq_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_IonosphericModelReq_sequence[] = {
  { &hf_lpp_klobucharModelReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_BIT_STRING_SIZE_2 },
  { &hf_lpp_neQuickModelReq , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NULL },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_IonosphericModelReq_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_IonosphericModelReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_IonosphericModelReq, GNSS_IonosphericModelReq_sequence);

  return offset;
}


static const per_sequence_t GNSS_EarthOrientationParametersReq_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_EarthOrientationParametersReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_EarthOrientationParametersReq, GNSS_EarthOrientationParametersReq_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_65535(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65535U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_VisibleString_SIZE_1_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          1, 32, FALSE,
                                          NULL);

  return offset;
}


static const per_sequence_t GNSS_ReferenceStationID_r15_sequence[] = {
  { &hf_lpp_referenceStationID_r15_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_65535 },
  { &hf_lpp_providerName_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_VisibleString_SIZE_1_32 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceStationID_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceStationID_r15, GNSS_ReferenceStationID_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ReferenceStationInfoReq_r15_sequence[] = {
  { &hf_lpp_antennaDescriptionReq_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_antennaHeightReq_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_physicalReferenceStationReq_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_stationID_r15   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ReferenceStationInfoReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ReferenceStationInfoReq_r15, GNSS_RTK_ReferenceStationInfoReq_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_AuxiliaryStationDataReq_r15_sequence[] = {
  { &hf_lpp_master_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_AuxiliaryStationDataReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_AuxiliaryStationDataReq_r15, GNSS_RTK_AuxiliaryStationDataReq_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistDataReq_eag_1_sequence[] = {
  { &hf_lpp_gnss_RTK_ReferenceStationInfoReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ReferenceStationInfoReq_r15 },
  { &hf_lpp_gnss_RTK_AuxiliaryStationDataReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_AuxiliaryStationDataReq_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistDataReq_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistDataReq_eag_1_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_16383(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GNSS_SSR_CorrectionPointsReq_r16_sequence[] = {
  { &hf_lpp_correctionPointSetID_Req_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_16383 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_CorrectionPointsReq_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_CorrectionPointsReq_r16, GNSS_SSR_CorrectionPointsReq_r16_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistDataReq_eag_2_sequence[] = {
  { &hf_lpp_gnss_SSR_CorrectionPointsReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_CorrectionPointsReq_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistDataReq_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistDataReq_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_Integrity_ServiceParametersReq_r17_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_Integrity_ServiceParametersReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_Integrity_ServiceParametersReq_r17, GNSS_Integrity_ServiceParametersReq_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_Integrity_ServiceAlertReq_r17_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_Integrity_ServiceAlertReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_Integrity_ServiceAlertReq_r17, GNSS_Integrity_ServiceAlertReq_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistDataReq_eag_3_sequence[] = {
  { &hf_lpp_gnss_Integrity_ServiceParametersReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_Integrity_ServiceParametersReq_r17 },
  { &hf_lpp_gnss_Integrity_ServiceAlertReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_Integrity_ServiceAlertReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistDataReq_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistDataReq_eag_3_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistDataReq_sequence[] = {
  { &hf_lpp_gnss_ReferenceTimeReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceTimeReq },
  { &hf_lpp_gnss_ReferenceLocationReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceLocationReq },
  { &hf_lpp_gnss_IonosphericModelReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_IonosphericModelReq },
  { &hf_lpp_gnss_EarthOrientationParametersReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_EarthOrientationParametersReq },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistDataReq_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistDataReq_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistDataReq_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistDataReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_CommonAssistDataReq, GNSS_CommonAssistDataReq_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_1_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 15U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GNSS_TimeModelElementReq_sequence[] = {
  { &hf_lpp_gnss_TO_IDsReq  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_15 },
  { &hf_lpp_deltaTreq       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_TimeModelElementReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_TimeModelElementReq, GNSS_TimeModelElementReq_sequence);

  return offset;
}


static const per_sequence_t GNSS_TimeModelListReq_sequence_of[1] = {
  { &hf_lpp_GNSS_TimeModelListReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_TimeModelElementReq },
};

static int
dissect_lpp_GNSS_TimeModelListReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_TimeModelListReq, GNSS_TimeModelListReq_sequence_of,
                                                  1, 15, FALSE);

  return offset;
}


static const per_sequence_t GNSS_DifferentialCorrectionsReq_sequence[] = {
  { &hf_lpp_dgnss_SignalsReq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_dgnss_ValidityTimeReq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_DifferentialCorrectionsReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DifferentialCorrectionsReq, GNSS_DifferentialCorrectionsReq_sequence);

  return offset;
}



static int
dissect_lpp_T_gnss_WeekOrDay(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  proto_item_append_text(actx->created_item, " (days for glonass, weeks otherwise)");

  return offset;
}



static int
dissect_lpp_T_gnss_Toe(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, NULL, FALSE);

  proto_item_append_text(actx->created_item, " (units of 15 mns for glonass, hours otherwise)");

  return offset;
}



static int
dissect_lpp_T_t_toeLimit(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  proto_item_append_text(actx->created_item, " (units of 30 mns for glonass, hours otherwise)");

  return offset;
}



static int
dissect_lpp_INTEGER_0_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SV_ID_sequence[] = {
  { &hf_lpp_satellite_id    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_63 },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_SV_ID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SV_ID, SV_ID_sequence);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_11(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     11, 11, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t SatListRelatedDataElement_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_iod             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_11 },
  { &hf_lpp_clockModelID    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_8 },
  { &hf_lpp_orbitModelID    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SatListRelatedDataElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SatListRelatedDataElement, SatListRelatedDataElement_sequence);

  return offset;
}


static const per_sequence_t SatListRelatedDataList_sequence_of[1] = {
  { &hf_lpp_SatListRelatedDataList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SatListRelatedDataElement },
};

static int
dissect_lpp_SatListRelatedDataList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SatListRelatedDataList, SatListRelatedDataList_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t StoredNavListInfo_sequence[] = {
  { &hf_lpp_gnss_WeekOrDay  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_gnss_WeekOrDay },
  { &hf_lpp_gnss_Toe        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_gnss_Toe },
  { &hf_lpp_t_toeLimit      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_t_toeLimit },
  { &hf_lpp_satListRelatedDataList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SatListRelatedDataList },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_StoredNavListInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_StoredNavListInfo, StoredNavListInfo_sequence);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     64, 64, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t T_clockModelID_PrefList_sequence_of[1] = {
  { &hf_lpp_clockModelID_PrefList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_8 },
};

static int
dissect_lpp_T_clockModelID_PrefList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_clockModelID_PrefList, T_clockModelID_PrefList_sequence_of,
                                                  1, 8, FALSE);

  return offset;
}


static const per_sequence_t T_orbitModelID_PrefList_sequence_of[1] = {
  { &hf_lpp_orbitModelID_PrefList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_8 },
};

static int
dissect_lpp_T_orbitModelID_PrefList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_orbitModelID_PrefList, T_orbitModelID_PrefList_sequence_of,
                                                  1, 8, FALSE);

  return offset;
}


static const per_sequence_t ReqNavListInfo_sequence[] = {
  { &hf_lpp_svReqList       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_64 },
  { &hf_lpp_clockModelID_PrefList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_clockModelID_PrefList },
  { &hf_lpp_orbitModelID_PrefList, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_orbitModelID_PrefList },
  { &hf_lpp_addNavparamReq  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ReqNavListInfo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ReqNavListInfo, ReqNavListInfo_sequence);

  return offset;
}


static const value_string lpp_GNSS_NavigationModelReq_vals[] = {
  {   0, "storedNavList" },
  {   1, "reqNavList" },
  { 0, NULL }
};

static const per_choice_t GNSS_NavigationModelReq_choice[] = {
  {   0, &hf_lpp_storedNavList   , ASN1_EXTENSION_ROOT    , dissect_lpp_StoredNavListInfo },
  {   1, &hf_lpp_reqNavList      , ASN1_EXTENSION_ROOT    , dissect_lpp_ReqNavListInfo },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_GNSS_NavigationModelReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_GNSS_NavigationModelReq, GNSS_NavigationModelReq_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GNSS_RealTimeIntegrityReq_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_RealTimeIntegrityReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RealTimeIntegrityReq, GNSS_RealTimeIntegrityReq_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_3599(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3599U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_999(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 999U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 15U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GNSS_DataBitsReqSatElement_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_DataBitsReqSatElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DataBitsReqSatElement, GNSS_DataBitsReqSatElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_DataBitsReqSatList_sequence_of[1] = {
  { &hf_lpp_GNSS_DataBitsReqSatList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_DataBitsReqSatElement },
};

static int
dissect_lpp_GNSS_DataBitsReqSatList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_DataBitsReqSatList, GNSS_DataBitsReqSatList_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GNSS_DataBitAssistanceReq_sequence[] = {
  { &hf_lpp_gnss_TOD_Req    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3599 },
  { &hf_lpp_gnss_TOD_FracReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_999 },
  { &hf_lpp_dataBitInterval , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_gnss_SignalType_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_gnss_DataBitsReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_DataBitsReqSatList },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_DataBitAssistanceReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DataBitAssistanceReq, GNSS_DataBitAssistanceReq_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_8_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            8U, 23U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GNSS_SignalID_eag_1_sequence[] = {
  { &hf_lpp_gnss_SignalID_Ext_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_8_23 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SignalID_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SignalID_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SignalID_sequence[] = {
  { &hf_lpp_gnss_SignalID_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_7 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalID_eag_1 },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_GNSS_SignalID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SignalID, GNSS_SignalID_sequence);

  return offset;
}


static const per_sequence_t GNSS_AcquisitionAssistanceReq_sequence[] = {
  { &hf_lpp_gnss_SignalID_Req, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalID },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_AcquisitionAssistanceReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AcquisitionAssistanceReq, GNSS_AcquisitionAssistanceReq_sequence);

  return offset;
}


static const per_sequence_t GNSS_AlmanacReq_sequence[] = {
  { &hf_lpp_modelID         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_AlmanacReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AlmanacReq, GNSS_AlmanacReq_sequence);

  return offset;
}


static const per_sequence_t GNSS_UTC_ModelReq_sequence[] = {
  { &hf_lpp_modelID         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_8 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_UTC_ModelReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_UTC_ModelReq, GNSS_UTC_ModelReq_sequence);

  return offset;
}


static const per_sequence_t GNSS_AuxiliaryInformationReq_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_AuxiliaryInformationReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AuxiliaryInformationReq, GNSS_AuxiliaryInformationReq_sequence);

  return offset;
}


static const per_sequence_t BDS_DifferentialCorrectionsReq_r12_sequence[] = {
  { &hf_lpp_dgnss_SignalsReq, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BDS_DifferentialCorrectionsReq_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BDS_DifferentialCorrectionsReq_r12, BDS_DifferentialCorrectionsReq_r12_sequence);

  return offset;
}


static const per_sequence_t BDS_GridModelReq_r12_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_BDS_GridModelReq_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BDS_GridModelReq_r12, BDS_GridModelReq_r12_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataReqElement_eag_1_sequence[] = {
  { &hf_lpp_bds_DifferentialCorrectionsReq_r12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BDS_DifferentialCorrectionsReq_r12 },
  { &hf_lpp_bds_GridModelReq_r12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BDS_GridModelReq_r12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataReqElement_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataReqElement_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ObservationsReq_r15_sequence[] = {
  { &hf_lpp_gnss_RTK_SignalsReq_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_gnss_RTK_Integer_ms_Req_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_gnss_RTK_PhaseRangeRateReq_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_gnss_RTK_CNR_Req_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_stationID_r15   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ObservationsReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ObservationsReq_r15, GNSS_RTK_ObservationsReq_r15_sequence);

  return offset;
}


static const per_sequence_t GLO_RTK_BiasInformationReq_r15_sequence[] = {
  { &hf_lpp_stationID_r15   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GLO_RTK_BiasInformationReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GLO_RTK_BiasInformationReq_r15, GLO_RTK_BiasInformationReq_r15_sequence);

  return offset;
}


static const per_sequence_t AUX_ReferenceStationID_Element_r15_sequence[] = {
  { &hf_lpp_aux_stationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AUX_ReferenceStationID_Element_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AUX_ReferenceStationID_Element_r15, AUX_ReferenceStationID_Element_r15_sequence);

  return offset;
}


static const per_sequence_t AUX_ReferenceStationList_r15_sequence_of[1] = {
  { &hf_lpp_AUX_ReferenceStationList_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_AUX_ReferenceStationID_Element_r15 },
};

static int
dissect_lpp_AUX_ReferenceStationList_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_AUX_ReferenceStationList_r15, AUX_ReferenceStationList_r15_sequence_of,
                                                  1, 32, FALSE);

  return offset;
}


static const per_sequence_t GNSS_RTK_MAC_CorrectionDifferencesReq_r15_sequence[] = {
  { &hf_lpp_master_ReferenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_aux_ReferenceStationList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_AUX_ReferenceStationList_r15 },
  { &hf_lpp_linkCombinations_PrefList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_Link_CombinationsList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_MAC_CorrectionDifferencesReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_MAC_CorrectionDifferencesReq_r15, GNSS_RTK_MAC_CorrectionDifferencesReq_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ResidualsReq_r15_sequence[] = {
  { &hf_lpp_stationID_r15   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_linkCombinations_PrefList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_Link_CombinationsList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ResidualsReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ResidualsReq_r15, GNSS_RTK_ResidualsReq_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_FKP_GradientsReq_r15_sequence[] = {
  { &hf_lpp_stationID_r15   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_linkCombinations_PrefList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_Link_CombinationsList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_FKP_GradientsReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_FKP_GradientsReq_r15, GNSS_RTK_FKP_GradientsReq_r15_sequence);

  return offset;
}


static const per_sequence_t SatListElement_r15_sequence[] = {
  { &hf_lpp_svID_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_iod_r15         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_11 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SatListElement_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SatListElement_r15, SatListElement_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_NavListInfo_r15_sequence_of[1] = {
  { &hf_lpp_GNSS_NavListInfo_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SatListElement_r15 },
};

static int
dissect_lpp_GNSS_NavListInfo_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_NavListInfo_r15, GNSS_NavListInfo_r15_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static int * const T_orbit_IntegrityReq_r17_bits[] = {
  &hf_lpp_T_orbit_IntegrityReq_r17_correlationTimeReq,
  NULL
};

static int
dissect_lpp_T_orbit_IntegrityReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_orbit_IntegrityReq_r17_bits, 1, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_OrbitCorrectionsReq_r15_eag_1_sequence[] = {
  { &hf_lpp_orbit_IntegrityReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_orbit_IntegrityReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_OrbitCorrectionsReq_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_OrbitCorrectionsReq_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_OrbitCorrectionsReq_r15_sequence[] = {
  { &hf_lpp_storedNavList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_NavListInfo_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_OrbitCorrectionsReq_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_OrbitCorrectionsReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_OrbitCorrectionsReq_r15, GNSS_SSR_OrbitCorrectionsReq_r15_sequence);

  return offset;
}


static const value_string lpp_T_clock_IntegrityParametersReq_r17_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_clock_IntegrityParametersReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_ssr_IntegrityClockBoundsReq_r17_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssr_IntegrityClockBoundsReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_ClockCorrectionsReq_r15_eag_1_sequence[] = {
  { &hf_lpp_clock_IntegrityParametersReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_clock_IntegrityParametersReq_r17 },
  { &hf_lpp_ssr_IntegrityClockBoundsReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ssr_IntegrityClockBoundsReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ClockCorrectionsReq_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_ClockCorrectionsReq_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_ClockCorrectionsReq_r15_sequence[] = {
  { &hf_lpp_storedNavList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_NavListInfo_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_ClockCorrectionsReq_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ClockCorrectionsReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_ClockCorrectionsReq_r15, GNSS_SSR_ClockCorrectionsReq_r15_sequence);

  return offset;
}


static const value_string lpp_T_ssr_IntegrityCodeBiasBoundsReq_r17_vals[] = {
  {   0, "requested" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssr_IntegrityCodeBiasBoundsReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_CodeBiasReq_r15_eag_1_sequence[] = {
  { &hf_lpp_ssr_IntegrityCodeBiasBoundsReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ssr_IntegrityCodeBiasBoundsReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_CodeBiasReq_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_CodeBiasReq_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_CodeBiasReq_r15_sequence[] = {
  { &hf_lpp_signal_and_tracking_mode_ID_Map_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_storedNavList_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_NavListInfo_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_CodeBiasReq_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_CodeBiasReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_CodeBiasReq_r15, GNSS_SSR_CodeBiasReq_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataReqElement_eag_2_sequence[] = {
  { &hf_lpp_gnss_RTK_ObservationsReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ObservationsReq_r15 },
  { &hf_lpp_glo_RTK_BiasInformationReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GLO_RTK_BiasInformationReq_r15 },
  { &hf_lpp_gnss_RTK_MAC_CorrectionDifferencesReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_MAC_CorrectionDifferencesReq_r15 },
  { &hf_lpp_gnss_RTK_ResidualsReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ResidualsReq_r15 },
  { &hf_lpp_gnss_RTK_FKP_GradientsReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_FKP_GradientsReq_r15 },
  { &hf_lpp_gnss_SSR_OrbitCorrectionsReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_OrbitCorrectionsReq_r15 },
  { &hf_lpp_gnss_SSR_ClockCorrectionsReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_ClockCorrectionsReq_r15 },
  { &hf_lpp_gnss_SSR_CodeBiasReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_CodeBiasReq_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataReqElement_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataReqElement_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_URA_Req_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_URA_Req_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_URA_Req_r16, GNSS_SSR_URA_Req_r16_sequence);

  return offset;
}


static const value_string lpp_T_ssr_IntegrityPhaseBiasBoundsReq_r17_vals[] = {
  {   0, "requested" },
  { 0, NULL }
};


static int
dissect_lpp_T_ssr_IntegrityPhaseBiasBoundsReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_PhaseBiasReq_r16_eag_1_sequence[] = {
  { &hf_lpp_ssr_IntegrityPhaseBiasBoundsReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_ssr_IntegrityPhaseBiasBoundsReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_PhaseBiasReq_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_PhaseBiasReq_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_PhaseBiasReq_r16_sequence[] = {
  { &hf_lpp_signal_and_tracking_mode_ID_Map_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_storedNavList_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_NavListInfo_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_PhaseBiasReq_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_PhaseBiasReq_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_PhaseBiasReq_r16, GNSS_SSR_PhaseBiasReq_r16_sequence);

  return offset;
}


static int * const T_stec_IntegrityReq_r17_bits[] = {
  &hf_lpp_T_stec_IntegrityReq_r17_correlationTimeReq,
  NULL
};

static int
dissect_lpp_T_stec_IntegrityReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_stec_IntegrityReq_r17_bits, 1, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_STEC_CorrectionReq_r16_eag_1_sequence[] = {
  { &hf_lpp_stec_IntegrityReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_stec_IntegrityReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_STEC_CorrectionReq_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_STEC_CorrectionReq_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_STEC_CorrectionReq_r16_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_STEC_CorrectionReq_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_STEC_CorrectionReq_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_STEC_CorrectionReq_r16, GNSS_SSR_STEC_CorrectionReq_r16_sequence);

  return offset;
}


static const value_string lpp_T_griddedCorrectionIntegrityReq_r17_vals[] = {
  {   0, "requested" },
  { 0, NULL }
};


static int
dissect_lpp_T_griddedCorrectionIntegrityReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_GriddedCorrectionReq_r16_eag_1_sequence[] = {
  { &hf_lpp_griddedCorrectionIntegrityReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_griddedCorrectionIntegrityReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_GriddedCorrectionReq_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_GriddedCorrectionReq_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_GriddedCorrectionReq_r16_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_GriddedCorrectionReq_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_GriddedCorrectionReq_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_GriddedCorrectionReq_r16, GNSS_SSR_GriddedCorrectionReq_r16_sequence);

  return offset;
}


static const per_sequence_t NavIC_DifferentialCorrectionsReq_r16_sequence[] = {
  { &hf_lpp_dgnss_SignalsReq_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavIC_DifferentialCorrectionsReq_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_DifferentialCorrectionsReq_r16, NavIC_DifferentialCorrectionsReq_r16_sequence);

  return offset;
}


static const per_sequence_t NavIC_GridModelReq_r16_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_NavIC_GridModelReq_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_GridModelReq_r16, NavIC_GridModelReq_r16_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataReqElement_eag_3_sequence[] = {
  { &hf_lpp_gnss_SSR_URA_Req_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_URA_Req_r16 },
  { &hf_lpp_gnss_SSR_PhaseBiasReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_PhaseBiasReq_r16 },
  { &hf_lpp_gnss_SSR_STEC_CorrectionReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_STEC_CorrectionReq_r16 },
  { &hf_lpp_gnss_SSR_GriddedCorrectionReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_GriddedCorrectionReq_r16 },
  { &hf_lpp_navic_DifferentialCorrectionsReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NavIC_DifferentialCorrectionsReq_r16 },
  { &hf_lpp_navic_GridModelReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NavIC_GridModelReq_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataReqElement_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataReqElement_eag_3_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataReqElement_sequence[] = {
  { &hf_lpp_gnss_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID },
  { &hf_lpp_sbas_ID         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SBAS_ID },
  { &hf_lpp_gnss_TimeModelsReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_TimeModelListReq },
  { &hf_lpp_gnss_DifferentialCorrectionsReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_DifferentialCorrectionsReq },
  { &hf_lpp_gnss_NavigationModelReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_NavigationModelReq },
  { &hf_lpp_gnss_RealTimeIntegrityReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_RealTimeIntegrityReq },
  { &hf_lpp_gnss_DataBitAssistanceReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_DataBitAssistanceReq },
  { &hf_lpp_gnss_AcquisitionAssistanceReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AcquisitionAssistanceReq },
  { &hf_lpp_gnss_AlmanacReq , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AlmanacReq },
  { &hf_lpp_gnss_UTCModelReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_UTC_ModelReq },
  { &hf_lpp_gnss_AuxiliaryInformationReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AuxiliaryInformationReq },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataReqElement_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataReqElement_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataReqElement_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataReqElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_GenericAssistDataReqElement, GNSS_GenericAssistDataReqElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataReq_sequence_of[1] = {
  { &hf_lpp_GNSS_GenericAssistDataReq_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataReqElement },
};

static int
dissect_lpp_GNSS_GenericAssistDataReq(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_GenericAssistDataReq, GNSS_GenericAssistDataReq_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_1_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 32U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_1_64(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 64U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GNSS_PeriodicControlParam_r15_sequence[] = {
  { &hf_lpp_deliveryAmount_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_32 },
  { &hf_lpp_deliveryInterval_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_64 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_PeriodicControlParam_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_PeriodicControlParam_r15, GNSS_PeriodicControlParam_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_PeriodicAssistDataReq_r15_eag_1_sequence[] = {
  { &hf_lpp_gnss_SSR_PeriodicURA_Req_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicPhaseBiasReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicSTEC_CorrectionReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicGriddedCorrectionReq_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_PeriodicAssistDataReq_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_PeriodicAssistDataReq_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_PeriodicAssistDataReq_r15_eag_2_sequence[] = {
  { &hf_lpp_gnss_Integrity_PeriodicServiceAlertReq_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_PeriodicAssistDataReq_r15_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_PeriodicAssistDataReq_r15_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_PeriodicAssistDataReq_r15_sequence[] = {
  { &hf_lpp_gnss_RTK_PeriodicObservationsReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_glo_RTK_PeriodicBiasInformationReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_RTK_MAC_PeriodicCorrectionDifferencesReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_RTK_PeriodicResidualsReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_RTK_FKP_PeriodicGradientsReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicOrbitCorrectionsReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicClockCorrectionsReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicCodeBiasReq_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_PeriodicAssistDataReq_r15_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_PeriodicAssistDataReq_r15_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_PeriodicAssistDataReq_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_PeriodicAssistDataReq_r15, GNSS_PeriodicAssistDataReq_r15_sequence);

  return offset;
}


static const per_sequence_t A_GNSS_RequestAssistanceData_eag_1_sequence[] = {
  { &hf_lpp_gnss_PeriodicAssistDataReq_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicAssistDataReq_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_RequestAssistanceData_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, A_GNSS_RequestAssistanceData_eag_1_sequence);

  return offset;
}


static const per_sequence_t A_GNSS_RequestAssistanceData_sequence[] = {
  { &hf_lpp_gnss_CommonAssistDataReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_CommonAssistDataReq },
  { &hf_lpp_gnss_GenericAssistDataReq, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_GenericAssistDataReq },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_A_GNSS_RequestAssistanceData_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_RequestAssistanceData(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_A_GNSS_RequestAssistanceData, A_GNSS_RequestAssistanceData_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_503(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 503U, NULL, FALSE);

  return offset;
}


static int * const T_adType_r14_bits[] = {
  &hf_lpp_T_adType_r14_prs,
  &hf_lpp_T_adType_r14_nprs,
  NULL
};

static int
dissect_lpp_T_adType_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_adType_r14_bits, 2, NULL, NULL);

  return offset;
}


static const per_sequence_t OTDOA_RequestAssistanceData_eag_1_sequence[] = {
  { &hf_lpp_adType_r14      , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_adType_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_OTDOA_RequestAssistanceData_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, OTDOA_RequestAssistanceData_eag_1_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_1007(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, FALSE);

  return offset;
}


static const per_sequence_t OTDOA_RequestAssistanceData_eag_2_sequence[] = {
  { &hf_lpp_nrPhysCellId_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1007 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_OTDOA_RequestAssistanceData_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, OTDOA_RequestAssistanceData_eag_2_sequence);

  return offset;
}


static const per_sequence_t OTDOA_RequestAssistanceData_sequence[] = {
  { &hf_lpp_physCellId      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_503 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_OTDOA_RequestAssistanceData_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_OTDOA_RequestAssistanceData_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_OTDOA_RequestAssistanceData(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_OTDOA_RequestAssistanceData, OTDOA_RequestAssistanceData_sequence);

  return offset;
}


static const per_sequence_t Sensor_RequestAssistanceData_r14_sequence[] = {
  { NULL, ASN1_EXTENSION_ROOT, 0, NULL }
};

static int
dissect_lpp_Sensor_RequestAssistanceData_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Sensor_RequestAssistanceData_r14, Sensor_RequestAssistanceData_r14_sequence);

  return offset;
}


static const per_sequence_t TBS_RequestAssistanceData_r14_sequence[] = {
  { &hf_lpp_mbs_AlmanacAssistanceDataReq_r14, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_mbs_AcquisitionAssistanceDataReq_r14, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_TBS_RequestAssistanceData_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_TBS_RequestAssistanceData_r14, TBS_RequestAssistanceData_r14_sequence);

  return offset;
}


static int * const T_requestedAD_r14_bits[] = {
  &hf_lpp_T_requestedAD_r14_ap_identifier,
  &hf_lpp_T_requestedAD_r14_ap_location,
  NULL
};

static int
dissect_lpp_T_requestedAD_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_requestedAD_r14_bits, 2, NULL, NULL);

  return offset;
}



static int
dissect_lpp_OCTET_STRING_SIZE_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_octet_string(tvb, offset, actx, tree, hf_index,
                                       6, 6, FALSE, NULL);

  return offset;
}



static int
dissect_lpp_T_ssid_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *ssid_tvb = NULL;

  offset = dissect_per_octet_string(tvb, offset, actx, tree, -1,
                                       1, 32, FALSE, &ssid_tvb);

  actx->created_item = proto_tree_add_item(tree, hf_index, ssid_tvb, 0, -1, ENC_ASCII|ENC_NA);


  return offset;
}


static const per_sequence_t WLAN_AP_Identifier_r13_sequence[] = {
  { &hf_lpp_bssid_r13       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_OCTET_STRING_SIZE_6 },
  { &hf_lpp_ssid_r13        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_ssid_r13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_WLAN_AP_Identifier_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_WLAN_AP_Identifier_r13, WLAN_AP_Identifier_r13_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13_sequence_of[1] = {
  { &hf_lpp_visibleAPs_r14_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_WLAN_AP_Identifier_r13 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13, SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13_sequence_of,
                                                  1, maxVisibleAPs_r14, FALSE);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13_sequence_of[1] = {
  { &hf_lpp_wlan_AP_StoredData_r14_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_WLAN_AP_Identifier_r13 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13, SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13_sequence_of,
                                                  1, maxKnownAPs_r14, FALSE);

  return offset;
}


static const per_sequence_t WLAN_RequestAssistanceData_r14_sequence[] = {
  { &hf_lpp_requestedAD_r14 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_requestedAD_r14 },
  { &hf_lpp_visibleAPs_r14  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_maxVisibleAPs_r14_OF_WLAN_AP_Identifier_r13 },
  { &hf_lpp_wlan_AP_StoredData_r14, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_maxKnownAPs_r14_OF_WLAN_AP_Identifier_r13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_WLAN_RequestAssistanceData_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_WLAN_RequestAssistanceData_r14, WLAN_RequestAssistanceData_r14_sequence);

  return offset;
}


static const per_sequence_t RequestAssistanceData_r9_IEs_eag_1_sequence[] = {
  { &hf_lpp_sensor_RequestAssistanceData_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_Sensor_RequestAssistanceData_r14 },
  { &hf_lpp_tbs_RequestAssistanceData_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_TBS_RequestAssistanceData_r14 },
  { &hf_lpp_wlan_RequestAssistanceData_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_WLAN_RequestAssistanceData_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestAssistanceData_r9_IEs_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RequestAssistanceData_r9_IEs_eag_1_sequence);

  return offset;
}



static int
dissect_lpp_NR_PhysCellID_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1007U, NULL, FALSE);

  return offset;
}


static int * const T_nr_AdType_r16_02_bits[] = {
  &hf_lpp_T_nr_AdType_r16_02_dl_prs,
  &hf_lpp_T_nr_AdType_r16_02_ul_srs,
  NULL
};

static int
dissect_lpp_T_nr_AdType_r16_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_nr_AdType_r16_02_bits, 2, NULL, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_1_1024(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1024U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_59(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 59U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_23(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 23U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_dl_prs_duration_r17_sequence[] = {
  { &hf_lpp_seconds_r17     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_59 },
  { &hf_lpp_minutes_r17     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_59 },
  { &hf_lpp_hours_r17       , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_23 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_dl_prs_duration_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_dl_prs_duration_r17, T_dl_prs_duration_r17_sequence);

  return offset;
}


static const per_sequence_t DL_PRS_StartTime_and_Duration_r17_sequence[] = {
  { &hf_lpp_dl_prs_start_time_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_1024 },
  { &hf_lpp_dl_prs_duration_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_prs_duration_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_StartTime_and_Duration_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_StartTime_and_Duration_r17, DL_PRS_StartTime_and_Duration_r17_sequence);

  return offset;
}


static const value_string lpp_T_dl_prs_FrequencyRangeReq_r17_vals[] = {
  {   0, "fr1" },
  {   1, "fr2" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_prs_FrequencyRangeReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_prs_ResourceSetPeriodicityReq_r17_vals[] = {
  {   0, "p4" },
  {   1, "p5" },
  {   2, "p8" },
  {   3, "p10" },
  {   4, "p16" },
  {   5, "p20" },
  {   6, "p32" },
  {   7, "p40" },
  {   8, "p64" },
  {   9, "p80" },
  {  10, "p160" },
  {  11, "p320" },
  {  12, "p640" },
  {  13, "p1280" },
  {  14, "p2560" },
  {  15, "p5120" },
  {  16, "p10240" },
  {  17, "p20480" },
  {  18, "p40960" },
  {  19, "p81920" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_prs_ResourceSetPeriodicityReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     20, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_1_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 63U, NULL, FALSE);

  return offset;
}


static const value_string lpp_T_dl_prs_ResourceRepetitionFactorReq_r17_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "n6" },
  {   3, "n8" },
  {   4, "n16" },
  {   5, "n32" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_prs_ResourceRepetitionFactorReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_prs_NumSymbolsReq_r17_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "n6" },
  {   3, "n12" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_prs_NumSymbolsReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string lpp_T_dl_prs_CombSizeN_Req_r17_vals[] = {
  {   0, "n2" },
  {   1, "n4" },
  {   2, "n6" },
  {   3, "n12" },
  { 0, NULL }
};


static int
dissect_lpp_T_dl_prs_CombSizeN_Req_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_lpp_ARFCN_ValueNR_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3279165U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_NR_DL_PRS_ResourceSetID_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, nrMaxNumDL_PRS_ResourceSetsPerTRP_1_r16, NULL, FALSE);

  return offset;
}


static const value_string lpp_T_rs_Type_r16_vals[] = {
  {   0, "typeC" },
  {   1, "typeD" },
  {   2, "typeC-plus-typeD" },
  { 0, NULL }
};


static int
dissect_lpp_T_rs_Type_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     3, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t T_ssb_r16_sequence[] = {
  { &hf_lpp_pci_r16         , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_NR_PhysCellID_r16 },
  { &hf_lpp_ssb_Index_r16   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_63 },
  { &hf_lpp_rs_Type_r16     , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_rs_Type_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_ssb_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_ssb_r16, T_ssb_r16_sequence);

  return offset;
}



static int
dissect_lpp_NR_DL_PRS_ResourceID_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, nrMaxNumDL_PRS_ResourcesPerSet_1_r16, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_dl_PRS_r16_sequence[] = {
  { &hf_lpp_qcl_DL_PRS_ResourceID_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ResourceID_r16 },
  { &hf_lpp_qcl_DL_PRS_ResourceSetID_r16, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ResourceSetID_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_dl_PRS_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_dl_PRS_r16, T_dl_PRS_r16_sequence);

  return offset;
}


static const value_string lpp_DL_PRS_QCL_Info_r16_vals[] = {
  {   0, "ssb-r16" },
  {   1, "dl-PRS-r16" },
  { 0, NULL }
};

static const per_choice_t DL_PRS_QCL_Info_r16_choice[] = {
  {   0, &hf_lpp_ssb_r16         , ASN1_NO_EXTENSIONS     , dissect_lpp_T_ssb_r16 },
  {   1, &hf_lpp_dl_PRS_r16      , ASN1_NO_EXTENSIONS     , dissect_lpp_T_dl_PRS_r16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_DL_PRS_QCL_Info_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_DL_PRS_QCL_Info_r16, DL_PRS_QCL_Info_r16_choice,
                                 NULL);

  return offset;
}


static const value_string lpp_T_dl_prs_QCL_InformationReq_r17_vals[] = {
  {   0, "dl-prs-QCL-InfoRecPerResourceSet-r17" },
  {   1, "dl-prs-QCL-Info-requested-r17" },
  { 0, NULL }
};

static const per_choice_t T_dl_prs_QCL_InformationReq_r17_choice[] = {
  {   0, &hf_lpp_dl_prs_QCL_InfoRecPerResourceSet_r17, ASN1_NO_EXTENSIONS     , dissect_lpp_DL_PRS_QCL_Info_r16 },
  {   1, &hf_lpp_dl_prs_QCL_Info_requested_r17, ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_dl_prs_QCL_InformationReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_dl_prs_QCL_InformationReq_r17, T_dl_prs_QCL_InformationReq_r17_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16_sequence_of[1] = {
  { &hf_lpp_dl_prs_QCL_InfoRecPerResource_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_QCL_Info_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16, SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16_sequence_of,
                                                  1, nrMaxResourcesPerSet_r16, FALSE);

  return offset;
}


static const per_sequence_t DL_PRS_QCL_InfoReq_r17_eag_1_sequence[] = {
  { &hf_lpp_dl_prs_QCL_InfoRecPerResource_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_nrMaxResourcesPerSet_r16_OF_DL_PRS_QCL_Info_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_QCL_InfoReq_r17_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, DL_PRS_QCL_InfoReq_r17_eag_1_sequence);

  return offset;
}


static const per_sequence_t DL_PRS_QCL_InfoReq_r17_sequence[] = {
  { &hf_lpp_nr_DL_PRS_ResourceSetID_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_PRS_ResourceSetID_r16 },
  { &hf_lpp_dl_prs_QCL_InformationReq_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_dl_prs_QCL_InformationReq_r17 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_QCL_InfoReq_r17_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_QCL_InfoReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_QCL_InfoReq_r17, DL_PRS_QCL_InfoReq_r17_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17_sequence_of[1] = {
  { &hf_lpp_dl_prs_QCL_InformationReqSet_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_QCL_InfoReq_r17 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17, SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17_sequence_of,
                                                  1, nrMaxSetsPerTrpPerFreqLayer_r16, FALSE);

  return offset;
}


static const per_sequence_t DL_PRS_QCL_InformationReqPerTRP_r17_sequence[] = {
  { &hf_lpp_dl_PRS_ID_r17   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_nr_PhysCellID_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NR_PhysCellID_r16 },
  { &hf_lpp_nr_CellGlobalID_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NCGI_r15 },
  { &hf_lpp_nr_ARFCN_r17    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_ARFCN_ValueNR_r15 },
  { &hf_lpp_dl_prs_QCL_InformationReqSet_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_1_nrMaxSetsPerTrpPerFreqLayer_r16_OF_DL_PRS_QCL_InfoReq_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_QCL_InformationReqPerTRP_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_QCL_InformationReqPerTRP_r17, DL_PRS_QCL_InformationReqPerTRP_r17_sequence);

  return offset;
}


static const per_sequence_t DL_PRS_QCL_InformationReqTRPlist_r17_sequence_of[1] = {
  { &hf_lpp_DL_PRS_QCL_InformationReqTRPlist_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_QCL_InformationReqPerTRP_r17 },
};

static int
dissect_lpp_DL_PRS_QCL_InformationReqTRPlist_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_DL_PRS_QCL_InformationReqTRPlist_r17, DL_PRS_QCL_InformationReqTRPlist_r17_sequence_of,
                                                  1, nrMaxTRPsPerFreq_r16, FALSE);

  return offset;
}


static const per_sequence_t NR_On_Demand_DL_PRS_PerFreqLayer_r17_sequence[] = {
  { &hf_lpp_dl_prs_FrequencyRangeReq_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_dl_prs_FrequencyRangeReq_r17 },
  { &hf_lpp_dl_prs_ResourceSetPeriodicityReq_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_prs_ResourceSetPeriodicityReq_r17 },
  { &hf_lpp_dl_prs_ResourceBandwidthReq_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_63 },
  { &hf_lpp_dl_prs_ResourceRepetitionFactorReq_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_prs_ResourceRepetitionFactorReq_r17 },
  { &hf_lpp_dl_prs_NumSymbolsReq_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_prs_NumSymbolsReq_r17 },
  { &hf_lpp_dl_prs_CombSizeN_Req_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_dl_prs_CombSizeN_Req_r17 },
  { &hf_lpp_dl_prs_QCL_InformationReqTRPlist_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_DL_PRS_QCL_InformationReqTRPlist_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_On_Demand_DL_PRS_PerFreqLayer_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_On_Demand_DL_PRS_PerFreqLayer_r17, NR_On_Demand_DL_PRS_PerFreqLayer_r17_sequence);

  return offset;
}


static const per_sequence_t NR_On_Demand_DL_PRS_Information_r17_sequence_of[1] = {
  { &hf_lpp_NR_On_Demand_DL_PRS_Information_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_NR_On_Demand_DL_PRS_PerFreqLayer_r17 },
};

static int
dissect_lpp_NR_On_Demand_DL_PRS_Information_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_NR_On_Demand_DL_PRS_Information_r17, NR_On_Demand_DL_PRS_Information_r17_sequence_of,
                                                  1, nrMaxFreqLayers_r16, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_1_maxOD_DL_PRS_Configs_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, maxOD_DL_PRS_Configs_r17, NULL, FALSE);

  return offset;
}


static const per_sequence_t DL_PRS_Configuration_ID_r17_sequence[] = {
  { &hf_lpp_nr_dl_prs_configuration_id_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_maxOD_DL_PRS_Configs_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DL_PRS_Configuration_ID_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DL_PRS_Configuration_ID_r17, DL_PRS_Configuration_ID_r17_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17_sequence_of[1] = {
  { &hf_lpp_dl_prs_configuration_id_PrefList_r17_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DL_PRS_Configuration_ID_r17 },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17, SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17_sequence_of,
                                                  1, maxOD_DL_PRS_Configs_r17, FALSE);

  return offset;
}


static const per_sequence_t NR_On_Demand_DL_PRS_Request_r17_sequence[] = {
  { &hf_lpp_dl_prs_StartTime_and_Duration_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_DL_PRS_StartTime_and_Duration_r17 },
  { &hf_lpp_nr_on_demand_DL_PRS_Information_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Information_r17 },
  { &hf_lpp_dl_prs_configuration_id_PrefList_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_maxOD_DL_PRS_Configs_r17_OF_DL_PRS_Configuration_ID_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_On_Demand_DL_PRS_Request_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_On_Demand_DL_PRS_Request_r17, NR_On_Demand_DL_PRS_Request_r17_sequence);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_02_vals[] = {
  {   0, "eAoD" },
  {   1, "eAoA" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_pre_configured_AssistanceDataRequest_r17_02_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_pre_configured_AssistanceDataRequest_r17_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_RequestAssistanceData_r16_eag_1_sequence[] = {
  { &hf_lpp_nr_on_demand_DL_PRS_Request_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Request_r17 },
  { &hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_02 },
  { &hf_lpp_pre_configured_AssistanceDataRequest_r17_02, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_pre_configured_AssistanceDataRequest_r17_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_RequestAssistanceData_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_Multi_RTT_RequestAssistanceData_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_Multi_RTT_RequestAssistanceData_r16_sequence[] = {
  { &hf_lpp_nr_PhysCellID_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NR_PhysCellID_r16 },
  { &hf_lpp_nr_AdType_r16_02, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_nr_AdType_r16_02 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_Multi_RTT_RequestAssistanceData_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_Multi_RTT_RequestAssistanceData_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_Multi_RTT_RequestAssistanceData_r16, NR_Multi_RTT_RequestAssistanceData_r16_sequence);

  return offset;
}


static int * const T_nr_AdType_r16_01_bits[] = {
  &hf_lpp_T_nr_AdType_r16_01_dl_prs,
  &hf_lpp_T_nr_AdType_r16_01_posCalc,
  NULL
};

static int
dissect_lpp_T_nr_AdType_r16_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_nr_AdType_r16_01_bits, 2, NULL, NULL);

  return offset;
}


static int * const T_nr_PosCalcAssistanceRequest_r17_01_bits[] = {
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_trpLoc,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_beamInfo,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_rtdInfo,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_beamAntInfo,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_01_losNlosInfo,
  NULL
};

static int
dissect_lpp_T_nr_PosCalcAssistanceRequest_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_nr_PosCalcAssistanceRequest_r17_01_bits, 5, NULL, NULL);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_01_vals[] = {
  {   0, "eAoD" },
  {   1, "eAoA" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_BeamInfoRequest_r17_vals[] = {
  {   0, "requested" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_BeamInfoRequest_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_pre_configured_AssistanceDataRequest_r17_01_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_pre_configured_AssistanceDataRequest_r17_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_AoD_RequestAssistanceData_r16_eag_1_sequence[] = {
  { &hf_lpp_nr_PosCalcAssistanceRequest_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_PosCalcAssistanceRequest_r17_01 },
  { &hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_01 },
  { &hf_lpp_nr_DL_PRS_BeamInfoRequest_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_BeamInfoRequest_r17 },
  { &hf_lpp_nr_on_demand_DL_PRS_Request_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Request_r17 },
  { &hf_lpp_pre_configured_AssistanceDataRequest_r17_01, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_pre_configured_AssistanceDataRequest_r17_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_RequestAssistanceData_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_AoD_RequestAssistanceData_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_DL_AoD_RequestAssistanceData_r16_sequence[] = {
  { &hf_lpp_nr_PhysCellID_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NR_PhysCellID_r16 },
  { &hf_lpp_nr_AdType_r16_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_nr_AdType_r16_01 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_AoD_RequestAssistanceData_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_AoD_RequestAssistanceData_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_AoD_RequestAssistanceData_r16, NR_DL_AoD_RequestAssistanceData_r16_sequence);

  return offset;
}


static int * const T_nr_AdType_r16_bits[] = {
  &hf_lpp_T_nr_AdType_r16_dl_prs,
  &hf_lpp_T_nr_AdType_r16_posCalc,
  NULL
};

static int
dissect_lpp_T_nr_AdType_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_nr_AdType_r16_bits, 2, NULL, NULL);

  return offset;
}


static int * const T_nr_PosCalcAssistanceRequest_r17_bits[] = {
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_trpLoc,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_beamInfo,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_rtdInfo,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_losNlosInfo,
  &hf_lpp_T_nr_PosCalcAssistanceRequest_r17_trpTEG_Info,
  NULL
};

static int
dissect_lpp_T_nr_PosCalcAssistanceRequest_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 8, FALSE, T_nr_PosCalcAssistanceRequest_r17_bits, 5, NULL, NULL);

  return offset;
}


static const value_string lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17_vals[] = {
  {   0, "eAoD" },
  {   1, "eAoA" },
  { 0, NULL }
};


static int
dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}


static const value_string lpp_T_pre_configured_AssistanceDataRequest_r17_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_pre_configured_AssistanceDataRequest_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_RequestAssistanceData_r16_eag_1_sequence[] = {
  { &hf_lpp_nr_PosCalcAssistanceRequest_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_PosCalcAssistanceRequest_r17 },
  { &hf_lpp_nr_on_demand_DL_PRS_Request_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_On_Demand_DL_PRS_Request_r17 },
  { &hf_lpp_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_nr_DL_PRS_ExpectedAoD_or_AoA_Request_r17 },
  { &hf_lpp_pre_configured_AssistanceDataRequest_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_pre_configured_AssistanceDataRequest_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_RequestAssistanceData_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, NR_DL_TDOA_RequestAssistanceData_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t NR_DL_TDOA_RequestAssistanceData_r16_sequence[] = {
  { &hf_lpp_nr_PhysCellID_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NR_PhysCellID_r16 },
  { &hf_lpp_nr_AdType_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_nr_AdType_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_NR_DL_TDOA_RequestAssistanceData_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NR_DL_TDOA_RequestAssistanceData_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NR_DL_TDOA_RequestAssistanceData_r16, NR_DL_TDOA_RequestAssistanceData_r16_sequence);

  return offset;
}


static const per_sequence_t RequestAssistanceData_r9_IEs_eag_2_sequence[] = {
  { &hf_lpp_nr_Multi_RTT_RequestAssistanceData_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_Multi_RTT_RequestAssistanceData_r16 },
  { &hf_lpp_nr_DL_AoD_RequestAssistanceData_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_DL_AoD_RequestAssistanceData_r16 },
  { &hf_lpp_nr_DL_TDOA_RequestAssistanceData_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NR_DL_TDOA_RequestAssistanceData_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestAssistanceData_r9_IEs_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, RequestAssistanceData_r9_IEs_eag_2_sequence);

  return offset;
}


static const per_sequence_t RequestAssistanceData_r9_IEs_sequence[] = {
  { &hf_lpp_commonIEsRequestAssistanceData, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CommonIEsRequestAssistanceData },
  { &hf_lpp_a_gnss_RequestAssistanceData, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_A_GNSS_RequestAssistanceData },
  { &hf_lpp_otdoa_RequestAssistanceData, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_OTDOA_RequestAssistanceData },
  { &hf_lpp_epdu_RequestAssistanceData, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_EPDU_Sequence },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_RequestAssistanceData_r9_IEs_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_RequestAssistanceData_r9_IEs_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestAssistanceData_r9_IEs(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RequestAssistanceData_r9_IEs, RequestAssistanceData_r9_IEs_sequence);

  return offset;
}


static const value_string lpp_T_c1_03_vals[] = {
  {   0, "requestAssistanceData-r9" },
  {   1, "spare3" },
  {   2, "spare2" },
  {   3, "spare1" },
  { 0, NULL }
};

static const per_choice_t T_c1_03_choice[] = {
  {   0, &hf_lpp_requestAssistanceData_r9, ASN1_NO_EXTENSIONS     , dissect_lpp_RequestAssistanceData_r9_IEs },
  {   1, &hf_lpp_spare3          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   2, &hf_lpp_spare2          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   3, &hf_lpp_spare1          , ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_c1_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_c1_03, T_c1_03_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t T_criticalExtensionsFuture_02_sequence[] = {
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_criticalExtensionsFuture_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_criticalExtensionsFuture_02, T_criticalExtensionsFuture_02_sequence);

  return offset;
}


static const value_string lpp_T_criticalExtensions_02_vals[] = {
  {   0, "c1" },
  {   1, "criticalExtensionsFuture" },
  { 0, NULL }
};

static const per_choice_t T_criticalExtensions_02_choice[] = {
  {   0, &hf_lpp_c1_03           , ASN1_NO_EXTENSIONS     , dissect_lpp_T_c1_03 },
  {   1, &hf_lpp_criticalExtensionsFuture_02, ASN1_NO_EXTENSIONS     , dissect_lpp_T_criticalExtensionsFuture_02 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_criticalExtensions_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_criticalExtensions_02, T_criticalExtensions_02_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t RequestAssistanceData_sequence[] = {
  { &hf_lpp_criticalExtensions_02, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_criticalExtensions_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RequestAssistanceData(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  col_append_sep_str(actx->pinfo->cinfo, COL_INFO, NULL, "Request Assistance Data");

  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RequestAssistanceData, RequestAssistanceData_sequence);

  return offset;
}


static const per_sequence_t CommonIEsProvideAssistanceData_eag_1_sequence[] = {
  { &hf_lpp_segmentationInfo_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SegmentationInfo_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsProvideAssistanceData_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsProvideAssistanceData_eag_1_sequence);

  return offset;
}


static const per_sequence_t CommonIEsProvideAssistanceData_eag_2_sequence[] = {
  { &hf_lpp_periodicAssistanceData_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_PeriodicAssistanceDataControlParameters_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsProvideAssistanceData_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, CommonIEsProvideAssistanceData_eag_2_sequence);

  return offset;
}


static const per_sequence_t CommonIEsProvideAssistanceData_sequence[] = {
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsProvideAssistanceData_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_CommonIEsProvideAssistanceData_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CommonIEsProvideAssistanceData(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CommonIEsProvideAssistanceData, CommonIEsProvideAssistanceData_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_32767(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 32767U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_86399(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 86399U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_T_notificationOfLeapSecond(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *notificationOfLeapSecond_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     2, 2, FALSE, NULL, 0, &notificationOfLeapSecond_tvb, NULL);



  if (notificationOfLeapSecond_tvb) {
    guint bitvalue = tvb_get_bits8(notificationOfLeapSecond_tvb, 0, 2);
    actx->created_item = proto_tree_add_uint(tree, hf_index, notificationOfLeapSecond_tvb, 0, 1, bitvalue);
  }

  return offset;
}



static int
dissect_lpp_INTEGER_0_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GPS_TOW_AssistElement_sequence[] = {
  { &hf_lpp_satelliteID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_64 },
  { &hf_lpp_tlmWord         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_16383 },
  { &hf_lpp_antiSpoof       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_alert           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_tlmRsvdBits     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GPS_TOW_AssistElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GPS_TOW_AssistElement, GPS_TOW_AssistElement_sequence);

  return offset;
}


static const per_sequence_t GPS_TOW_Assist_sequence_of[1] = {
  { &hf_lpp_GPS_TOW_Assist_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GPS_TOW_AssistElement },
};

static int
dissect_lpp_GPS_TOW_Assist(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GPS_TOW_Assist, GPS_TOW_Assist_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GNSS_SystemTime_sequence[] = {
  { &hf_lpp_gnss_TimeID     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID },
  { &hf_lpp_gnss_DayNumber  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_32767 },
  { &hf_lpp_gnss_TimeOfDay  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_86399 },
  { &hf_lpp_gnss_TimeOfDayFrac_msec, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_999 },
  { &hf_lpp_notificationOfLeapSecond, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_notificationOfLeapSecond },
  { &hf_lpp_gps_TOW_Assist  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GPS_TOW_Assist },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_GNSS_SystemTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SystemTime, GNSS_SystemTime_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 127U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_12533(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 12533U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_3999999(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 3999999U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M64_63(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -64, 63U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_mcc_sequence_of[1] = {
  { &hf_lpp_mcc_item        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mcc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mcc, T_mcc_sequence_of,
                                                  3, 3, FALSE);

  return offset;
}


static const per_sequence_t T_mnc_sequence_of[1] = {
  { &hf_lpp_mnc_item        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mnc(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mnc, T_mnc_sequence_of,
                                                  2, 3, FALSE);

  return offset;
}


static const per_sequence_t T_plmn_Identity_sequence[] = {
  { &hf_lpp_mcc             , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mcc },
  { &hf_lpp_mnc             , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mnc },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_plmn_Identity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_plmn_Identity, T_plmn_Identity_sequence);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_32(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     32, 32, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string lpp_T_cellIdentity_vals[] = {
  {   0, "eutra" },
  {   1, "utra" },
  { 0, NULL }
};

static const per_choice_t T_cellIdentity_choice[] = {
  {   0, &hf_lpp_eutra           , ASN1_NO_EXTENSIONS     , dissect_lpp_BIT_STRING_SIZE_28 },
  {   1, &hf_lpp_utra            , ASN1_NO_EXTENSIONS     , dissect_lpp_BIT_STRING_SIZE_32 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_cellIdentity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_cellIdentity, T_cellIdentity_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t CellGlobalIdEUTRA_AndUTRA_sequence[] = {
  { &hf_lpp_plmn_Identity   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_plmn_Identity },
  { &hf_lpp_cellIdentity    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_cellIdentity },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_CellGlobalIdEUTRA_AndUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CellGlobalIdEUTRA_AndUTRA, CellGlobalIdEUTRA_AndUTRA_sequence);

  return offset;
}



int
dissect_lpp_ARFCN_ValueEUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxEARFCN, NULL, FALSE);

  return offset;
}



int
dissect_lpp_ARFCN_ValueEUTRA_v9a0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            maxEARFCN_Plus1, maxEARFCN2, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_eag_1_02_sequence[] = {
  { &hf_lpp_earfcn_v9a0     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ARFCN_ValueEUTRA_v9a0 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_eag_1_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, T_eag_1_02_sequence);

  return offset;
}


static const per_sequence_t T_eUTRA_sequence[] = {
  { &hf_lpp_physCellId      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_503 },
  { &hf_lpp_cellGlobalIdEUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CellGlobalIdEUTRA_AndUTRA },
  { &hf_lpp_earfcn          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_ARFCN_ValueEUTRA },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_T_eag_1_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_eUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_eUTRA, T_eUTRA_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_511(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 511U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_fdd_sequence[] = {
  { &hf_lpp_primary_CPICH_Info, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_fdd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_fdd, T_fdd_sequence);

  return offset;
}


static const per_sequence_t T_tdd_sequence[] = {
  { &hf_lpp_cellParameters  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_tdd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_tdd, T_tdd_sequence);

  return offset;
}


static const value_string lpp_T_mode_vals[] = {
  {   0, "fdd" },
  {   1, "tdd" },
  { 0, NULL }
};

static const per_choice_t T_mode_choice[] = {
  {   0, &hf_lpp_fdd             , ASN1_NO_EXTENSIONS     , dissect_lpp_T_fdd },
  {   1, &hf_lpp_tdd             , ASN1_NO_EXTENSIONS     , dissect_lpp_T_tdd },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_mode(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_mode, T_mode_choice,
                                 NULL);

  return offset;
}



int
dissect_lpp_ARFCN_ValueUTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16383U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_uTRA_sequence[] = {
  { &hf_lpp_mode            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_mode },
  { &hf_lpp_cellGlobalIdUTRA, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CellGlobalIdEUTRA_AndUTRA },
  { &hf_lpp_uarfcn          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_ARFCN_ValueUTRA },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_uTRA(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_uTRA, T_uTRA_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1023U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_mcc_01_sequence_of[1] = {
  { &hf_lpp_mcc_item        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mcc_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mcc_01, T_mcc_01_sequence_of,
                                                  3, 3, FALSE);

  return offset;
}


static const per_sequence_t T_mnc_01_sequence_of[1] = {
  { &hf_lpp_mnc_item        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_9 },
};

static int
dissect_lpp_T_mnc_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_mnc_01, T_mnc_01_sequence_of,
                                                  2, 3, FALSE);

  return offset;
}


static const per_sequence_t T_plmn_Identity_01_sequence[] = {
  { &hf_lpp_mcc_01          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mcc_01 },
  { &hf_lpp_mnc_01          , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_mnc_01 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_plmn_Identity_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_plmn_Identity_01, T_plmn_Identity_01_sequence);

  return offset;
}


static const per_sequence_t CellGlobalIdGERAN_sequence[] = {
  { &hf_lpp_plmn_Identity_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_plmn_Identity_01 },
  { &hf_lpp_locationAreaCode, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_16 },
  { &hf_lpp_cellGlobalIdGERAN_cellIdentity, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_16 },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_CellGlobalIdGERAN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CellGlobalIdGERAN, CellGlobalIdGERAN_sequence);

  return offset;
}


static const per_sequence_t T_gSM_sequence[] = {
  { &hf_lpp_bcchCarrier     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1023 },
  { &hf_lpp_bsic            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_63 },
  { &hf_lpp_cellGlobalIdGERAN, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CellGlobalIdGERAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_gSM(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_gSM, T_gSM_sequence);

  return offset;
}



static int
dissect_lpp_ARFCN_ValueEUTRA_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxEARFCN2, NULL, FALSE);

  return offset;
}


static const value_string lpp_CarrierFreqOffsetNB_r14_vals[] = {
  {   0, "v-10" },
  {   1, "v-9" },
  {   2, "v-8" },
  {   3, "v-7" },
  {   4, "v-6" },
  {   5, "v-5" },
  {   6, "v-4" },
  {   7, "v-3" },
  {   8, "v-2" },
  {   9, "v-1" },
  {  10, "v-0dot5" },
  {  11, "v0" },
  {  12, "v1" },
  {  13, "v2" },
  {  14, "v3" },
  {  15, "v4" },
  {  16, "v5" },
  {  17, "v6" },
  {  18, "v7" },
  {  19, "v8" },
  {  20, "v9" },
  { 0, NULL }
};

static value_string_ext lpp_CarrierFreqOffsetNB_r14_vals_ext = VALUE_STRING_EXT_INIT(lpp_CarrierFreqOffsetNB_r14_vals);


static int
dissect_lpp_CarrierFreqOffsetNB_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     21, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t CarrierFreq_NB_r14_sequence[] = {
  { &hf_lpp_carrierFreq_r14 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_ARFCN_ValueEUTRA_r14 },
  { &hf_lpp_carrierFreqOffset_r14, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_CarrierFreqOffsetNB_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CarrierFreq_NB_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CarrierFreq_NB_r14, CarrierFreq_NB_r14_sequence);

  return offset;
}


static const per_sequence_t T_nBIoT_r14_sequence[] = {
  { &hf_lpp_nbPhysCellId_r14, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_503 },
  { &hf_lpp_nbCellGlobalId_r14, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_ECGI },
  { &hf_lpp_nbCarrierFreq_r14, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_CarrierFreq_NB_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nBIoT_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nBIoT_r14, T_nBIoT_r14_sequence);

  return offset;
}


static const per_sequence_t T_nr_r15_sequence[] = {
  { &hf_lpp_nrPhysCellId_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1007 },
  { &hf_lpp_nrCellGlobalID_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NCGI_r15 },
  { &hf_lpp_nrARFCN_r15     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_ARFCN_ValueNR_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_nr_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_nr_r15, T_nr_r15_sequence);

  return offset;
}


static const value_string lpp_T_cellID_vals[] = {
  {   0, "eUTRA" },
  {   1, "uTRA" },
  {   2, "gSM" },
  {   3, "nBIoT-r14" },
  {   4, "nr-r15" },
  { 0, NULL }
};

static const per_choice_t T_cellID_choice[] = {
  {   0, &hf_lpp_eUTRA           , ASN1_EXTENSION_ROOT    , dissect_lpp_T_eUTRA },
  {   1, &hf_lpp_uTRA            , ASN1_EXTENSION_ROOT    , dissect_lpp_T_uTRA },
  {   2, &hf_lpp_gSM             , ASN1_EXTENSION_ROOT    , dissect_lpp_T_gSM },
  {   3, &hf_lpp_nBIoT_r14       , ASN1_NOT_EXTENSION_ROOT, dissect_lpp_T_nBIoT_r14 },
  {   4, &hf_lpp_nr_r15          , ASN1_NOT_EXTENSION_ROOT, dissect_lpp_T_nr_r15 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_cellID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_cellID, T_cellID_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t NetworkTime_sequence[] = {
  { &hf_lpp_secondsFromFrameStructureStart, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_12533 },
  { &hf_lpp_fractionalSecondsFromFrameStructureStart, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3999999 },
  { &hf_lpp_frameDrift      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M64_63 },
  { &hf_lpp_cellID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_cellID },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_NetworkTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NetworkTime, NetworkTime_sequence);

  return offset;
}


static const value_string lpp_T_bsAlign_vals[] = {
  {   0, "true" },
  { 0, NULL }
};


static int
dissect_lpp_T_bsAlign(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_ReferenceTimeForOneCell_sequence[] = {
  { &hf_lpp_networkTime     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NetworkTime },
  { &hf_lpp_referenceTimeUnc, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_127 },
  { &hf_lpp_bsAlign         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_bsAlign },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceTimeForOneCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceTimeForOneCell, GNSS_ReferenceTimeForOneCell_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell_sequence_of[1] = {
  { &hf_lpp_gnss_ReferenceTimeForCells_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceTimeForOneCell },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell, SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const per_sequence_t GNSS_ReferenceTime_sequence[] = {
  { &hf_lpp_gnss_SystemTime , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SystemTime },
  { &hf_lpp_referenceTimeUnc, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_127 },
  { &hf_lpp_gnss_ReferenceTimeForCells, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_16_OF_GNSS_ReferenceTimeForOneCell },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceTime(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceTime, GNSS_ReferenceTime_sequence);

  return offset;
}


static const value_string lpp_T_latitudeSign_04_vals[] = {
  {   0, "north" },
  {   1, "south" },
  { 0, NULL }
};


static int
dissect_lpp_T_latitudeSign_04(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_0_8388607(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8388607U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M8388608_8388607(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8388608, 8388607U, NULL, FALSE);

  return offset;
}


static const value_string lpp_T_altitudeDirection_01_vals[] = {
  {   0, "height" },
  {   1, "depth" },
  { 0, NULL }
};


static int
dissect_lpp_T_altitudeDirection_01(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_0_179(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 179U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_100(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 100U, NULL, FALSE);

  return offset;
}


static const per_sequence_t EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_sequence[] = {
  { &hf_lpp_latitudeSign_04 , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_latitudeSign_04 },
  { &hf_lpp_degreesLatitude , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_8388607 },
  { &hf_lpp_degreesLongitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_altitudeDirection_01, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_altitudeDirection_01 },
  { &hf_lpp_altitude        , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_32767 },
  { &hf_lpp_uncertaintySemiMajor, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_127 },
  { &hf_lpp_uncertaintySemiMinor, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_127 },
  { &hf_lpp_orientationMajorAxis, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_179 },
  { &hf_lpp_uncertaintyAltitude, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_127 },
  { &hf_lpp_confidence      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_100 },
  { NULL, 0, 0, NULL }
};

int
dissect_lpp_EllipsoidPointWithAltitudeAndUncertaintyEllipsoid(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_EllipsoidPointWithAltitudeAndUncertaintyEllipsoid, EllipsoidPointWithAltitudeAndUncertaintyEllipsoid_sequence);

  return offset;
}


static const per_sequence_t GNSS_ReferenceLocation_sequence[] = {
  { &hf_lpp_threeDlocation  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_EllipsoidPointWithAltitudeAndUncertaintyEllipsoid },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ReferenceLocation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ReferenceLocation, GNSS_ReferenceLocation_sequence);

  return offset;
}



static int
dissect_lpp_T_dataID(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *dataID_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     2, 2, FALSE, NULL, 0, &dataID_tvb, NULL);



  if (dataID_tvb) {
    guint bitvalue = tvb_get_bits8(dataID_tvb, 0, 2);
    actx->created_item = proto_tree_add_uint(tree, hf_index, dataID_tvb, 0, 1, bitvalue);
  }

  return offset;
}



static int
dissect_lpp_INTEGER_M128_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -128, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t KlobucharModelParameter_sequence[] = {
  { &hf_lpp_dataID          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_dataID },
  { &hf_lpp_alfa0           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa1           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa2           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa3           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_beta0           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_beta1           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_beta2           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_beta3           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_KlobucharModelParameter(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_KlobucharModelParameter, KlobucharModelParameter_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_2047(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2047U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M1024_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1024, 1023U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M8192_8191(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8192, 8191U, NULL, FALSE);

  return offset;
}


static const per_sequence_t NeQuickModelParameter_sequence[] = {
  { &hf_lpp_ai0             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_2047 },
  { &hf_lpp_ai1             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_ai2             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8192_8191 },
  { &hf_lpp_ionoStormFlag1  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_ionoStormFlag2  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_ionoStormFlag3  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_ionoStormFlag4  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_ionoStormFlag5  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NeQuickModelParameter(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NeQuickModelParameter, NeQuickModelParameter_sequence);

  return offset;
}


static const per_sequence_t KlobucharModel2Parameter_r16_sequence[] = {
  { &hf_lpp_alfa1_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1023 },
  { &hf_lpp_alfa2_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa3_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_alfa4_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_alfa5_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_alfa6_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa7_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa8_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_alfa9_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_KlobucharModel2Parameter_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_KlobucharModel2Parameter_r16, KlobucharModel2Parameter_r16_sequence);

  return offset;
}


static const per_sequence_t GNSS_IonosphericModel_eag_1_sequence[] = {
  { &hf_lpp_klobucharModel2_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_KlobucharModel2Parameter_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_IonosphericModel_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_IonosphericModel_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_IonosphericModel_sequence[] = {
  { &hf_lpp_klobucharModel  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_KlobucharModelParameter },
  { &hf_lpp_neQuickModel    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NeQuickModelParameter },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_IonosphericModel_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_IonosphericModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_IonosphericModel, GNSS_IonosphericModel_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_M1048576_1048575(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1048576, 1048575U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M16384_16383(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -16384, 16383U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M1073741824_1073741823(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -1073741824, 1073741823U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M262144_262143(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -262144, 262143U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GNSS_EarthOrientationParameters_sequence[] = {
  { &hf_lpp_teop            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_65535 },
  { &hf_lpp_pmX             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1048576_1048575 },
  { &hf_lpp_pmXdot          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_pmY             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1048576_1048575 },
  { &hf_lpp_pmYdot          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_deltaUT1        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1073741824_1073741823 },
  { &hf_lpp_deltaUT1dot     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M262144_262143 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_EarthOrientationParameters(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_EarthOrientationParameters, GNSS_EarthOrientationParameters_sequence);

  return offset;
}


static const value_string lpp_T_referenceStationIndicator_r15_vals[] = {
  {   0, "physical" },
  {   1, "non-physical" },
  { 0, NULL }
};


static int
dissect_lpp_T_referenceStationIndicator_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, FALSE, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_M137438953472_137438953471(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            G_GINT64_CONSTANT(-137438953472), G_GUINT64_CONSTANT(137438953471), NULL, FALSE);

  return offset;
}



static int
dissect_lpp_VisibleString_SIZE_1_256(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_VisibleString(tvb, offset, actx, tree, hf_index,
                                          1, 256, FALSE,
                                          NULL);

  return offset;
}


static const value_string lpp_T_antennaSetUpID_r15_vals[] = {
  {   0, "non-zero" },
  { 0, NULL }
};


static int
dissect_lpp_T_antennaSetUpID_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     1, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t AntennaDescription_r15_sequence[] = {
  { &hf_lpp_antennaDescriptor_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_VisibleString_SIZE_1_256 },
  { &hf_lpp_antennaSetUpID_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_antennaSetUpID_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AntennaDescription_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AntennaDescription_r15, AntennaDescription_r15_sequence);

  return offset;
}


static const per_sequence_t AntennaReferencePointUnc_r15_sequence[] = {
  { &hf_lpp_uncertainty_X_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_confidence_X_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_100 },
  { &hf_lpp_uncertainty_Y_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_confidence_Y_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_100 },
  { &hf_lpp_uncertainty_Z_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_confidence_Z_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_100 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AntennaReferencePointUnc_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AntennaReferencePointUnc_r15, AntennaReferencePointUnc_r15_sequence);

  return offset;
}


static const per_sequence_t PhysicalReferenceStationInfo_r15_sequence[] = {
  { &hf_lpp_physicalReferenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_physical_ARP_ECEF_X_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M137438953472_137438953471 },
  { &hf_lpp_physical_ARP_ECEF_Y_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M137438953472_137438953471 },
  { &hf_lpp_physical_ARP_ECEF_Z_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M137438953472_137438953471 },
  { &hf_lpp_physical_ARP_unc_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_AntennaReferencePointUnc_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PhysicalReferenceStationInfo_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PhysicalReferenceStationInfo_r15, PhysicalReferenceStationInfo_r15_sequence);

  return offset;
}


static const per_sequence_t ReferenceStationList_r16_sequence_of[1] = {
  { &hf_lpp_ReferenceStationList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
};

static int
dissect_lpp_ReferenceStationList_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_ReferenceStationList_r16, ReferenceStationList_r16_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const value_string lpp_EqualIntegerAmbiguityLevel_r16_vals[] = {
  {   0, "allReferenceStations-r16" },
  {   1, "referenceStationList-r16" },
  { 0, NULL }
};

static const per_choice_t EqualIntegerAmbiguityLevel_r16_choice[] = {
  {   0, &hf_lpp_allReferenceStations_r16, ASN1_NO_EXTENSIONS     , dissect_lpp_NULL },
  {   1, &hf_lpp_referenceStationList_r16, ASN1_NO_EXTENSIONS     , dissect_lpp_ReferenceStationList_r16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_EqualIntegerAmbiguityLevel_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_EqualIntegerAmbiguityLevel_r16, EqualIntegerAmbiguityLevel_r16_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GNSS_RTK_ReferenceStationInfo_r15_eag_1_sequence[] = {
  { &hf_lpp_equalIntegerAmbiguityLevel_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_EqualIntegerAmbiguityLevel_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ReferenceStationInfo_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_RTK_ReferenceStationInfo_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_ReferenceStationInfo_r15_sequence[] = {
  { &hf_lpp_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_referenceStationIndicator_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_referenceStationIndicator_r15 },
  { &hf_lpp_antenna_reference_point_ECEF_X_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M137438953472_137438953471 },
  { &hf_lpp_antenna_reference_point_ECEF_Y_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M137438953472_137438953471 },
  { &hf_lpp_antenna_reference_point_ECEF_Z_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M137438953472_137438953471 },
  { &hf_lpp_antennaHeight_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_65535 },
  { &hf_lpp_antennaDescription_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_AntennaDescription_r15 },
  { &hf_lpp_antenna_reference_point_unc_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_AntennaReferencePointUnc_r15 },
  { &hf_lpp_physical_reference_station_info_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_PhysicalReferenceStationInfo_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_RTK_ReferenceStationInfo_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_ReferenceStationInfo_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_ReferenceStationInfo_r15, GNSS_RTK_ReferenceStationInfo_r15_sequence);

  return offset;
}



static int
dissect_lpp_T_smoothingIndicator_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     1, 1, FALSE, NULL, 0, &param_tvb, NULL);



  if (param_tvb) {
    guint bitvalue = tvb_get_bits8(param_tvb, 0, 1);
    actx->created_item = proto_tree_add_uint(tree, hf_index, param_tvb, 0, 1, bitvalue);
  }

  return offset;
}



static int
dissect_lpp_T_smoothingInterval_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *param_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     3, 3, FALSE, NULL, 0, &param_tvb, NULL);



  if (param_tvb) {
    guint bitvalue = tvb_get_bits8(param_tvb, 0, 3);
    actx->created_item = proto_tree_add_uint(tree, hf_index, param_tvb, 0, 1, bitvalue);
  }

  return offset;
}


static const per_sequence_t GNSS_RTK_CommonObservationInfo_r15_sequence[] = {
  { &hf_lpp_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_clockSteeringIndicator_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3 },
  { &hf_lpp_externalClockIndicator_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3 },
  { &hf_lpp_smoothingIndicator_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_smoothingIndicator_r15 },
  { &hf_lpp_smoothingInterval_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_smoothingInterval_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_CommonObservationInfo_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_CommonObservationInfo_r15, GNSS_RTK_CommonObservationInfo_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_NetworkID_r15_sequence[] = {
  { &hf_lpp_networkID_r15_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_NetworkID_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_NetworkID_r15, GNSS_NetworkID_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_SubNetworkID_r15_sequence[] = {
  { &hf_lpp_subNetworkID_r15_01, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SubNetworkID_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SubNetworkID_r15, GNSS_SubNetworkID_r15_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_M524288_524287(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -524288, 524287U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M4194304_4194303(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -4194304, 4194303U, NULL, FALSE);

  return offset;
}


static const per_sequence_t Aux_ARP_Unc_r15_sequence[] = {
  { &hf_lpp_horizontalUncertainty_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_horizontalConfidence_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_100 },
  { &hf_lpp_verticalUncertainty_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_verticalConfidence_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_100 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Aux_ARP_Unc_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Aux_ARP_Unc_r15, Aux_ARP_Unc_r15_sequence);

  return offset;
}


static const per_sequence_t AuxiliaryStationElement_r15_sequence[] = {
  { &hf_lpp_aux_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_aux_master_delta_latitude_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M524288_524287 },
  { &hf_lpp_aux_master_delta_longitude_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1048576_1048575 },
  { &hf_lpp_aux_master_delta_height_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4194304_4194303 },
  { &hf_lpp_aux_ARP_unc_r15 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_Aux_ARP_Unc_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AuxiliaryStationElement_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AuxiliaryStationElement_r15, AuxiliaryStationElement_r15_sequence);

  return offset;
}


static const per_sequence_t AuxiliaryStationList_r15_sequence_of[1] = {
  { &hf_lpp_AuxiliaryStationList_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_AuxiliaryStationElement_r15 },
};

static int
dissect_lpp_AuxiliaryStationList_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_AuxiliaryStationList_r15, AuxiliaryStationList_r15_sequence_of,
                                                  1, 32, FALSE);

  return offset;
}


static const per_sequence_t GNSS_RTK_AuxiliaryStationData_r15_sequence[] = {
  { &hf_lpp_networkID_r15   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_NetworkID_r15 },
  { &hf_lpp_subNetworkID_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_SubNetworkID_r15 },
  { &hf_lpp_master_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_auxiliaryStationList_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_AuxiliaryStationList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_AuxiliaryStationData_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_AuxiliaryStationData_r15, GNSS_RTK_AuxiliaryStationData_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistData_eag_1_sequence[] = {
  { &hf_lpp_gnss_RTK_ReferenceStationInfo_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_ReferenceStationInfo_r15 },
  { &hf_lpp_gnss_RTK_CommonObservationInfo_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_CommonObservationInfo_r15 },
  { &hf_lpp_gnss_RTK_AuxiliaryStationData_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_AuxiliaryStationData_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistData_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistData_eag_1_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_M32768_32767(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -32768, 32767U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M512_511(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -512, 511U, NULL, FALSE);

  return offset;
}


static const per_sequence_t RelativeLocationElement_r16_sequence[] = {
  { &hf_lpp_deltaLatitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M512_511 },
  { &hf_lpp_deltaLongitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RelativeLocationElement_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RelativeLocationElement_r16, RelativeLocationElement_r16_sequence);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16_sequence_of[1] = {
  { &hf_lpp_relativeLocationsList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_RelativeLocationElement_r16 },
};

static int
dissect_lpp_SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16, SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16_sequence_of,
                                                  0, 63, FALSE);

  return offset;
}


static const per_sequence_t GNSS_SSR_ListOfCorrectionPoints_r16_sequence[] = {
  { &hf_lpp_referencePointLatitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_referencePointLongitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_relativeLocationsList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SEQUENCE_SIZE_0_63_OF_RelativeLocationElement_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ListOfCorrectionPoints_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_ListOfCorrectionPoints_r16, GNSS_SSR_ListOfCorrectionPoints_r16_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_1_511(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 511U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_1_1023(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1023U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GNSS_SSR_ArrayOfCorrectionPoints_r16_sequence[] = {
  { &hf_lpp_referencePointLatitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_referencePointLongitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_numberOfStepsLatitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_63 },
  { &hf_lpp_numberOfStepsLongitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_63 },
  { &hf_lpp_stepOfLatitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_511 },
  { &hf_lpp_stepOfLongitude_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_1023 },
  { &hf_lpp_bitmaskOfGrids_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_BIT_STRING_SIZE_64 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ArrayOfCorrectionPoints_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_ArrayOfCorrectionPoints_r16, GNSS_SSR_ArrayOfCorrectionPoints_r16_sequence);

  return offset;
}


static const value_string lpp_T_correctionPoints_r16_vals[] = {
  {   0, "listOfCorrectionPoints-r16" },
  {   1, "arrayOfCorrectionPoints-r16" },
  { 0, NULL }
};

static const per_choice_t T_correctionPoints_r16_choice[] = {
  {   0, &hf_lpp_listOfCorrectionPoints_r16, ASN1_NO_EXTENSIONS     , dissect_lpp_GNSS_SSR_ListOfCorrectionPoints_r16 },
  {   1, &hf_lpp_arrayOfCorrectionPoints_r16, ASN1_NO_EXTENSIONS     , dissect_lpp_GNSS_SSR_ArrayOfCorrectionPoints_r16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_correctionPoints_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_correctionPoints_r16, T_correctionPoints_r16_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GNSS_SSR_CorrectionPoints_r16_sequence[] = {
  { &hf_lpp_correctionPointSetID_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_16383 },
  { &hf_lpp_correctionPoints_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_correctionPoints_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_CorrectionPoints_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_CorrectionPoints_r16, GNSS_SSR_CorrectionPoints_r16_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistData_eag_2_sequence[] = {
  { &hf_lpp_gnss_SSR_CorrectionPoints_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_CorrectionPoints_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistData_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistData_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_Integrity_ServiceParameters_r17_sequence[] = {
  { &hf_lpp_irMinimum_r17   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_irMaximum_r17   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_Integrity_ServiceParameters_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_Integrity_ServiceParameters_r17, GNSS_Integrity_ServiceParameters_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_Integrity_ServiceAlert_r17_sequence[] = {
  { &hf_lpp_ionosphereDoNotUse_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_troposphereDoNotUse_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_Integrity_ServiceAlert_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_Integrity_ServiceAlert_r17, GNSS_Integrity_ServiceAlert_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistData_eag_3_sequence[] = {
  { &hf_lpp_gnss_Integrity_ServiceParameters_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_Integrity_ServiceParameters_r17 },
  { &hf_lpp_gnss_Integrity_ServiceAlert_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_Integrity_ServiceAlert_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistData_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_CommonAssistData_eag_3_sequence);

  return offset;
}


static const per_sequence_t GNSS_CommonAssistData_sequence[] = {
  { &hf_lpp_gnss_ReferenceTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceTime },
  { &hf_lpp_gnss_ReferenceLocation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_ReferenceLocation },
  { &hf_lpp_gnss_IonosphericModel, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_IonosphericModel },
  { &hf_lpp_gnss_EarthOrientationParameters, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_EarthOrientationParameters },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistData_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistData_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_CommonAssistData_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_CommonAssistData(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_CommonAssistData, GNSS_CommonAssistData_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_M67108864_67108863(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -67108864, 67108863U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M4096_4095(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -4096, 4095U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_8191(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 8191U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GNSS_TimeModelElement_sequence[] = {
  { &hf_lpp_gnss_TimeModelRefTime, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_65535 },
  { &hf_lpp_tA0             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M67108864_67108863 },
  { &hf_lpp_tA1             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M4096_4095 },
  { &hf_lpp_tA2             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M64_63 },
  { &hf_lpp_gnss_TO_ID      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_15 },
  { &hf_lpp_weekNumber      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_8191 },
  { &hf_lpp_deltaT          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M128_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_TimeModelElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_TimeModelElement, GNSS_TimeModelElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_TimeModelList_sequence_of[1] = {
  { &hf_lpp_GNSS_TimeModelList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_TimeModelElement },
};

static int
dissect_lpp_GNSS_TimeModelList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_TimeModelList, GNSS_TimeModelList_sequence_of,
                                                  1, 15, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M2047_2047(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -2047, 2047U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M127_127(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -127, 127U, NULL, FALSE);

  return offset;
}


static const per_sequence_t DGNSS_CorrectionsElement_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_iod             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_11 },
  { &hf_lpp_udre            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3 },
  { &hf_lpp_pseudoRangeCor  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2047_2047 },
  { &hf_lpp_rangeRateCor    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M127_127 },
  { &hf_lpp_udreGrowthRate  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_7 },
  { &hf_lpp_udreValidityTime, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_7 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DGNSS_CorrectionsElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DGNSS_CorrectionsElement, DGNSS_CorrectionsElement_sequence);

  return offset;
}


static const per_sequence_t DGNSS_SatList_sequence_of[1] = {
  { &hf_lpp_DGNSS_SatList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DGNSS_CorrectionsElement },
};

static int
dissect_lpp_DGNSS_SatList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_DGNSS_SatList, DGNSS_SatList_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t DGNSS_SgnTypeElement_sequence[] = {
  { &hf_lpp_gnss_SignalID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalID },
  { &hf_lpp_gnss_StatusHealth, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_7 },
  { &hf_lpp_dgnss_SatList   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_DGNSS_SatList },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DGNSS_SgnTypeElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DGNSS_SgnTypeElement, DGNSS_SgnTypeElement_sequence);

  return offset;
}


static const per_sequence_t DGNSS_SgnTypeList_sequence_of[1] = {
  { &hf_lpp_DGNSS_SgnTypeList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DGNSS_SgnTypeElement },
};

static int
dissect_lpp_DGNSS_SgnTypeList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_DGNSS_SgnTypeList, DGNSS_SgnTypeList_sequence_of,
                                                  1, 3, FALSE);

  return offset;
}


static const per_sequence_t GNSS_DifferentialCorrections_sequence[] = {
  { &hf_lpp_dgnss_RefTime   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3599 },
  { &hf_lpp_dgnss_SgnTypeList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_DGNSS_SgnTypeList },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_DifferentialCorrections(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DifferentialCorrections, GNSS_DifferentialCorrections_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_M32_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -32, 31U, NULL, FALSE);

  return offset;
}


static const per_sequence_t StandardClockModelElement_sequence[] = {
  { &hf_lpp_stanClockToc    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_16383 },
  { &hf_lpp_stanClockAF2    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32_31 },
  { &hf_lpp_stanClockAF1    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1048576_1048575 },
  { &hf_lpp_stanClockAF0    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1073741824_1073741823 },
  { &hf_lpp_stanClockTgd    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M512_511 },
  { &hf_lpp_sisa            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_stanModelID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_StandardClockModelElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_StandardClockModelElement, StandardClockModelElement_sequence);

  return offset;
}


static const per_sequence_t StandardClockModelList_sequence_of[1] = {
  { &hf_lpp_StandardClockModelList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_StandardClockModelElement },
};

static int
dissect_lpp_StandardClockModelList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_StandardClockModelList, StandardClockModelList_sequence_of,
                                                  1, 2, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_37799(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 37799U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M2097152_2097151(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -2097152, 2097151U, NULL, FALSE);

  return offset;
}


static const per_sequence_t NAV_ClockModel_sequence[] = {
  { &hf_lpp_navToc          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_37799 },
  { &hf_lpp_navaf2          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_navaf1          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navaf0          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2097152_2097151 },
  { &hf_lpp_navTgd          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NAV_ClockModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NAV_ClockModel, NAV_ClockModel_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_2015(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2015U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M16_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -16, 15U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M33554432_33554431(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -33554432, 33554431U, NULL, FALSE);

  return offset;
}


static const per_sequence_t CNAV_ClockModel_sequence[] = {
  { &hf_lpp_cnavToc         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_2015 },
  { &hf_lpp_cnavTop         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_2015 },
  { &hf_lpp_cnavURA0        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16_15 },
  { &hf_lpp_cnavURA1        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_7 },
  { &hf_lpp_cnavURA2        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_7 },
  { &hf_lpp_cnavAf2         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M512_511 },
  { &hf_lpp_cnavAf1         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M524288_524287 },
  { &hf_lpp_cnavAf0         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M33554432_33554431 },
  { &hf_lpp_cnavTgd         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4096_4095 },
  { &hf_lpp_cnavISCl1cp     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M4096_4095 },
  { &hf_lpp_cnavISCl1cd     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M4096_4095 },
  { &hf_lpp_cnavISCl1ca     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M4096_4095 },
  { &hf_lpp_cnavISCl2c      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M4096_4095 },
  { &hf_lpp_cnavISCl5i5     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M4096_4095 },
  { &hf_lpp_cnavISCl5q5     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M4096_4095 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CNAV_ClockModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CNAV_ClockModel, CNAV_ClockModel_sequence);

  return offset;
}


static const per_sequence_t GLONASS_ClockModel_sequence[] = {
  { &hf_lpp_gloTau          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2097152_2097151 },
  { &hf_lpp_gloGamma        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_gloDeltaTau     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M16_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GLONASS_ClockModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GLONASS_ClockModel, GLONASS_ClockModel_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_5399(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 5399U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M2048_2047(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -2048, 2047U, NULL, FALSE);

  return offset;
}


static const per_sequence_t SBAS_ClockModel_sequence[] = {
  { &hf_lpp_sbasTo          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_5399 },
  { &hf_lpp_sbasAgfo        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2048_2047 },
  { &hf_lpp_sbasAgf1        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SBAS_ClockModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SBAS_ClockModel, SBAS_ClockModel_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_31(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 31U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_131071(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 131071U, NULL, FALSE);

  return offset;
}


static const per_sequence_t BDS_ClockModel_r12_eag_1_sequence[] = {
  { &hf_lpp_bdsTgd2_r16     , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M512_511 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BDS_ClockModel_r12_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, BDS_ClockModel_r12_eag_1_sequence);

  return offset;
}


static const per_sequence_t BDS_ClockModel_r12_sequence[] = {
  { &hf_lpp_bdsAODC_r12     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_31 },
  { &hf_lpp_bdsToc_r12      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_131071 },
  { &hf_lpp_bdsA0_r12       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_bdsA1_r12       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2097152_2097151 },
  { &hf_lpp_bdsA2_r12       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_bdsTgd1_r12     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M512_511 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_BDS_ClockModel_r12_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BDS_ClockModel_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BDS_ClockModel_r12, BDS_ClockModel_r12_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_M16777216_16777215(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -16777216, 16777215U, NULL, FALSE);

  return offset;
}


static const per_sequence_t BDS_ClockModel2_r16_eag_1_sequence[] = {
  { &hf_lpp_bdsTgdB2ap_r17  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M2048_2047 },
  { &hf_lpp_bdsIscB2ad_r17  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M2048_2047 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BDS_ClockModel2_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, BDS_ClockModel2_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t BDS_ClockModel2_r16_sequence[] = {
  { &hf_lpp_bdsToc_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_2047 },
  { &hf_lpp_bdsA0_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16777216_16777215 },
  { &hf_lpp_bdsA1_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2097152_2097151 },
  { &hf_lpp_bdsA2_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_bdsTgdB1Cp_r16  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2048_2047 },
  { &hf_lpp_bdsIscB1Cd_r16  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2048_2047 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_BDS_ClockModel2_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BDS_ClockModel2_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BDS_ClockModel2_r16, BDS_ClockModel2_r16_sequence);

  return offset;
}


static const per_sequence_t NavIC_ClockModel_r16_sequence[] = {
  { &hf_lpp_navic_Toc_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_65535 },
  { &hf_lpp_navic_af2_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_navic_af1_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navic_af0_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2097152_2097151 },
  { &hf_lpp_navic_Tgd_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavIC_ClockModel_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_ClockModel_r16, NavIC_ClockModel_r16_sequence);

  return offset;
}


static const value_string lpp_GNSS_ClockModel_vals[] = {
  {   0, "standardClockModelList" },
  {   1, "nav-ClockModel" },
  {   2, "cnav-ClockModel" },
  {   3, "glonass-ClockModel" },
  {   4, "sbas-ClockModel" },
  {   5, "bds-ClockModel-r12" },
  {   6, "bds-ClockModel2-r16" },
  {   7, "navic-ClockModel-r16" },
  { 0, NULL }
};

static const per_choice_t GNSS_ClockModel_choice[] = {
  {   0, &hf_lpp_standardClockModelList, ASN1_EXTENSION_ROOT    , dissect_lpp_StandardClockModelList },
  {   1, &hf_lpp_nav_ClockModel  , ASN1_EXTENSION_ROOT    , dissect_lpp_NAV_ClockModel },
  {   2, &hf_lpp_cnav_ClockModel , ASN1_EXTENSION_ROOT    , dissect_lpp_CNAV_ClockModel },
  {   3, &hf_lpp_glonass_ClockModel, ASN1_EXTENSION_ROOT    , dissect_lpp_GLONASS_ClockModel },
  {   4, &hf_lpp_sbas_ClockModel , ASN1_EXTENSION_ROOT    , dissect_lpp_SBAS_ClockModel },
  {   5, &hf_lpp_bds_ClockModel_r12, ASN1_NOT_EXTENSION_ROOT, dissect_lpp_BDS_ClockModel_r12 },
  {   6, &hf_lpp_bds_ClockModel2_r16, ASN1_NOT_EXTENSION_ROOT, dissect_lpp_BDS_ClockModel2_r16 },
  {   7, &hf_lpp_navic_ClockModel_r16, ASN1_NOT_EXTENSION_ROOT, dissect_lpp_NavIC_ClockModel_r16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_GNSS_ClockModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_GNSS_ClockModel, GNSS_ClockModel_choice,
                                 NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_M2147483648_2147483647(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            G_MININT32, 2147483647U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_4294967295(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4294967295U, NULL, FALSE);

  return offset;
}


static const per_sequence_t NavModelKeplerianSet_sequence[] = {
  { &hf_lpp_keplerToe       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_16383 },
  { &hf_lpp_keplerW         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_keplerDeltaN    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_keplerM0        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_keplerOmegaDot  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_keplerE         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_4294967295 },
  { &hf_lpp_keplerIDot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8192_8191 },
  { &hf_lpp_keplerAPowerHalf, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_4294967295 },
  { &hf_lpp_keplerI0        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_keplerOmega0    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_keplerCrs       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_keplerCis       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_keplerCus       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_keplerCrc       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_keplerCic       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_keplerCuc       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavModelKeplerianSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavModelKeplerianSet, NavModelKeplerianSet_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_16777215(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 16777215U, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_ephemSF1Rsvd_sequence[] = {
  { &hf_lpp_reserved1       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_8388607 },
  { &hf_lpp_reserved2       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_16777215 },
  { &hf_lpp_reserved3       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_16777215 },
  { &hf_lpp_reserved4       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_65535 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_ephemSF1Rsvd(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_ephemSF1Rsvd, T_ephemSF1Rsvd_sequence);

  return offset;
}


static const per_sequence_t T_addNAVparam_sequence[] = {
  { &hf_lpp_ephemCodeOnL2   , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3 },
  { &hf_lpp_ephemL2Pflag    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_ephemSF1Rsvd    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_T_ephemSF1Rsvd },
  { &hf_lpp_ephemAODA       , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_31 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_T_addNAVparam(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_T_addNAVparam, T_addNAVparam_sequence);

  return offset;
}


static const per_sequence_t NavModelNAV_KeplerianSet_sequence[] = {
  { &hf_lpp_navURA          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_navFitFlag      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_navToe          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_37799 },
  { &hf_lpp_navOmega        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_navDeltaN       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navM0           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_navOmegaADot    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_navE            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_4294967295 },
  { &hf_lpp_navIDot         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8192_8191 },
  { &hf_lpp_navAPowerHalf   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_4294967295 },
  { &hf_lpp_navI0           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_navOmegaA0      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_navCrs          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navCis          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navCus          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navCrc          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navCic          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navCuc          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_addNAVparam     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_addNAVparam },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavModelNAV_KeplerianSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavModelNAV_KeplerianSet, NavModelNAV_KeplerianSet_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_M65536_65535(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -65536, 65535U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_T_cnavMo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  int64_t cnavMo;
  int curr_offset = offset;
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            G_GINT64_CONSTANT(-4294967296), 4294967295U, &cnavMo, FALSE);



  proto_item_set_hidden(actx->created_item);
  actx->created_item = proto_tree_add_int64_format_value(tree, hf_index, tvb, curr_offset>>3, (offset+7-curr_offset)>>3,
                                                         cnavMo, "%g semi-circles (%"PRId64")",
                                                         (double)cnavMo*pow(2, -32), cnavMo);

  return offset;
}



static int
dissect_lpp_T_cnavE(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  uint64_t cnavE;
  int curr_offset = offset;
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, G_GUINT64_CONSTANT(8589934591), &cnavE, FALSE);



  proto_item_set_hidden(actx->created_item);
  actx->created_item = proto_tree_add_uint64_format_value(tree, hf_index, tvb, curr_offset>>3, (offset+7-curr_offset)>>3,
                                                          cnavE, "%g (%"PRIu64")",
                                                          (double)cnavE*pow(2, -34), cnavE);

  return offset;
}



static int
dissect_lpp_T_cnavOmega(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  int64_t cnavOmega;
  int curr_offset = offset;
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            G_GINT64_CONSTANT(-4294967296), 4294967295U, &cnavOmega, FALSE);



  proto_item_set_hidden(actx->created_item);
  actx->created_item = proto_tree_add_int64_format_value(tree, hf_index, tvb, curr_offset>>3, (offset+7-curr_offset)>>3,
                                                         cnavOmega, "%g semi-circles (%"PRId64")",
                                                         (double)cnavOmega*pow(2, -32), cnavOmega);

  return offset;
}



static int
dissect_lpp_T_cnavOMEGA0(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  int64_t cnavOMEGA0;
  int curr_offset = offset;
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            G_GINT64_CONSTANT(-4294967296), 4294967295U, &cnavOMEGA0, FALSE);



  proto_item_set_hidden(actx->created_item);
  actx->created_item = proto_tree_add_int64_format_value(tree, hf_index, tvb, curr_offset>>3, (offset+7-curr_offset)>>3,
                                                         cnavOMEGA0, "%g semi-circles (%"PRId64")",
                                                         (double)cnavOMEGA0*pow(2, -32), cnavOMEGA0);

  return offset;
}



static int
dissect_lpp_T_cnavIo(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  int64_t cnavIo;
  int curr_offset = offset;
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            G_GINT64_CONSTANT(-4294967296), 4294967295U, &cnavIo, FALSE);



  proto_item_set_hidden(actx->created_item);
  actx->created_item = proto_tree_add_int64_format_value(tree, hf_index, tvb, curr_offset>>3, (offset+7-curr_offset)>>3,
                                                         cnavIo, "%g semi-circles (%"PRId64")",
                                                         (double)cnavIo*pow(2, -32), cnavIo);

  return offset;
}


static const per_sequence_t NavModelCNAV_KeplerianSet_sequence[] = {
  { &hf_lpp_cnavTop         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_2015 },
  { &hf_lpp_cnavURAindex    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16_15 },
  { &hf_lpp_cnavDeltaA      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M33554432_33554431 },
  { &hf_lpp_cnavAdot        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16777216_16777215 },
  { &hf_lpp_cnavDeltaNo     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M65536_65535 },
  { &hf_lpp_cnavDeltaNoDot  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4194304_4194303 },
  { &hf_lpp_cnavMo          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_cnavMo },
  { &hf_lpp_cnavE           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_cnavE },
  { &hf_lpp_cnavOmega       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_cnavOmega },
  { &hf_lpp_cnavOMEGA0      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_cnavOMEGA0 },
  { &hf_lpp_cnavDeltaOmegaDot, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M65536_65535 },
  { &hf_lpp_cnavIo          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_cnavIo },
  { &hf_lpp_cnavIoDot       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_cnavCis         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_cnavCic         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_cnavCrs         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_cnavCrc         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_cnavCus         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1048576_1048575 },
  { &hf_lpp_cnavCuc         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1048576_1048575 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavModelCNAV_KeplerianSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavModelCNAV_KeplerianSet, NavModelCNAV_KeplerianSet_sequence);

  return offset;
}



static int
dissect_lpp_T_gloP1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *gloP1_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     2, 2, FALSE, NULL, 0, &gloP1_tvb, NULL);



  if (gloP1_tvb) {
    guint bitvalue = tvb_get_bits8(gloP1_tvb, 0, 2);
    actx->created_item = proto_tree_add_uint(tree, hf_index, gloP1_tvb, 0, 1, bitvalue);
  }

  return offset;
}


static const per_sequence_t NavModel_GLONASS_ECEF_sequence[] = {
  { &hf_lpp_gloEn           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_31 },
  { &hf_lpp_gloP1           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_gloP1 },
  { &hf_lpp_gloP2           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_gloM            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3 },
  { &hf_lpp_gloX            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M67108864_67108863 },
  { &hf_lpp_gloXdot         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_gloXdotdot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16_15 },
  { &hf_lpp_gloY            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M67108864_67108863 },
  { &hf_lpp_gloYdot         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_gloYdotdot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16_15 },
  { &hf_lpp_gloZ            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M67108864_67108863 },
  { &hf_lpp_gloZdot         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_gloZdotdot      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavModel_GLONASS_ECEF(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavModel_GLONASS_ECEF, NavModel_GLONASS_ECEF_sequence);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_M536870912_536870911(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -536870912, 536870911U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M131072_131071(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -131072, 131071U, NULL, FALSE);

  return offset;
}


static const per_sequence_t NavModel_SBAS_ECEF_sequence[] = {
  { &hf_lpp_sbasTo          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_5399 },
  { &hf_lpp_sbasAccuracy    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_4 },
  { &hf_lpp_sbasXg          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M536870912_536870911 },
  { &hf_lpp_sbasYg          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M536870912_536870911 },
  { &hf_lpp_sbasZg          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16777216_16777215 },
  { &hf_lpp_sbasXgDot       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M65536_65535 },
  { &hf_lpp_sbasYgDot       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M65536_65535 },
  { &hf_lpp_sbasZgDot       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M131072_131071 },
  { &hf_lpp_sbasXgDotDot    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M512_511 },
  { &hf_lpp_sbagYgDotDot    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M512_511 },
  { &hf_lpp_sbasZgDotDot    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M512_511 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavModel_SBAS_ECEF(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavModel_SBAS_ECEF, NavModel_SBAS_ECEF_sequence);

  return offset;
}


static const per_sequence_t NavModel_BDS_KeplerianSet_r12_sequence[] = {
  { &hf_lpp_bdsAODE_r12     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_31 },
  { &hf_lpp_bdsURAI_r12     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_bdsToe_r12      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_131071 },
  { &hf_lpp_bdsAPowerHalf_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_4294967295 },
  { &hf_lpp_bdsE_r12        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_4294967295 },
  { &hf_lpp_bdsW_r12        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_bdsDeltaN_r12   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_bdsM0_r12       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_bdsOmega0_r12   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_bdsOmegaDot_r12 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_bdsI0_r12       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_bdsIDot_r12     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8192_8191 },
  { &hf_lpp_bdsCuc_r12      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M131072_131071 },
  { &hf_lpp_bdsCus_r12      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M131072_131071 },
  { &hf_lpp_bdsCrc_r12      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M131072_131071 },
  { &hf_lpp_bdsCrs_r12      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M131072_131071 },
  { &hf_lpp_bdsCic_r12      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M131072_131071 },
  { &hf_lpp_bdsCis_r12      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M131072_131071 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavModel_BDS_KeplerianSet_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavModel_BDS_KeplerianSet_r12, NavModel_BDS_KeplerianSet_r12_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_M16777216_16777216(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -16777216, 16777216U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M4294967296_4294967295(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            G_GINT64_CONSTANT(-4294967296), 4294967295U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_8589934591(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer_64b(tvb, offset, actx, tree, hf_index,
                                                            0U, G_GUINT64_CONSTANT(8589934591), NULL, FALSE);

  return offset;
}


static const per_sequence_t NavModel_BDS_KeplerianSet2_r16_sequence[] = {
  { &hf_lpp_bdsIODE_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_bdsToe_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_2047 },
  { &hf_lpp_bdsDeltaA_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M33554432_33554431 },
  { &hf_lpp_bdsAdot_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16777216_16777216 },
  { &hf_lpp_bdsDeltaN0_r16  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M65536_65535 },
  { &hf_lpp_bdsDeltaN0dot_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4194304_4194303 },
  { &hf_lpp_bdsM0_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4294967296_4294967295 },
  { &hf_lpp_bdsE_r16        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_8589934591 },
  { &hf_lpp_bdsOmega_r16    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4294967296_4294967295 },
  { &hf_lpp_bdsOmega0_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4294967296_4294967295 },
  { &hf_lpp_bdsI0_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4294967296_4294967295 },
  { &hf_lpp_bdsOmegaDot_r16 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M262144_262143 },
  { &hf_lpp_bdsI0Dot_r16    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_bdsCuc_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1048576_1048575 },
  { &hf_lpp_bdsCus_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1048576_1048575 },
  { &hf_lpp_bdsCrc_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_bdsCrs_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_bdsCic_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_bdsCis_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavModel_BDS_KeplerianSet2_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavModel_BDS_KeplerianSet2_r16, NavModel_BDS_KeplerianSet2_r16_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_65536(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 65536U, NULL, FALSE);

  return offset;
}


static const per_sequence_t NavModel_NavIC_KeplerianSet_r16_sequence[] = {
  { &hf_lpp_navic_Toe_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_65536 },
  { &hf_lpp_navic_URAI_r16  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_navic_W_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_navic_DeltaN_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2097152_2097151 },
  { &hf_lpp_navic_M0_r16    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_navic_OmegaDot_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_navic_E_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_4294967295 },
  { &hf_lpp_navic_IDot_r16  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8192_8191 },
  { &hf_lpp_navic_APowerHalf_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_4294967295 },
  { &hf_lpp_navic_I0_r16    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_navic_Omega0_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_navic_Crs_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navic_Cis_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navic_Cus_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navic_Crc_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navic_Cic_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navic_Cuc_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavModel_NavIC_KeplerianSet_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavModel_NavIC_KeplerianSet_r16, NavModel_NavIC_KeplerianSet_r16_sequence);

  return offset;
}


static const value_string lpp_GNSS_OrbitModel_vals[] = {
  {   0, "keplerianSet" },
  {   1, "nav-KeplerianSet" },
  {   2, "cnav-KeplerianSet" },
  {   3, "glonass-ECEF" },
  {   4, "sbas-ECEF" },
  {   5, "bds-KeplerianSet-r12" },
  {   6, "bds-KeplerianSet2-r16" },
  {   7, "navic-KeplerianSet-r16" },
  { 0, NULL }
};

static const per_choice_t GNSS_OrbitModel_choice[] = {
  {   0, &hf_lpp_keplerianSet    , ASN1_EXTENSION_ROOT    , dissect_lpp_NavModelKeplerianSet },
  {   1, &hf_lpp_nav_KeplerianSet, ASN1_EXTENSION_ROOT    , dissect_lpp_NavModelNAV_KeplerianSet },
  {   2, &hf_lpp_cnav_KeplerianSet, ASN1_EXTENSION_ROOT    , dissect_lpp_NavModelCNAV_KeplerianSet },
  {   3, &hf_lpp_glonass_ECEF    , ASN1_EXTENSION_ROOT    , dissect_lpp_NavModel_GLONASS_ECEF },
  {   4, &hf_lpp_sbas_ECEF       , ASN1_EXTENSION_ROOT    , dissect_lpp_NavModel_SBAS_ECEF },
  {   5, &hf_lpp_bds_KeplerianSet_r12, ASN1_NOT_EXTENSION_ROOT, dissect_lpp_NavModel_BDS_KeplerianSet_r12 },
  {   6, &hf_lpp_bds_KeplerianSet2_r16, ASN1_NOT_EXTENSION_ROOT, dissect_lpp_NavModel_BDS_KeplerianSet2_r16 },
  {   7, &hf_lpp_navic_KeplerianSet_r16, ASN1_NOT_EXTENSION_ROOT, dissect_lpp_NavModel_NavIC_KeplerianSet_r16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_GNSS_OrbitModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_GNSS_OrbitModel, GNSS_OrbitModel_choice,
                                 NULL);

  return offset;
}



static int
dissect_lpp_T_svHealthExt_v1240(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *svHealthExt_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, FALSE, NULL, 0, &svHealthExt_tvb, NULL);



  if (svHealthExt_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_lpp_svHealthExt_v1240);
    proto_tree_add_bits_item(subtree, hf_lpp_svHealthExt_v1240_e5bhs, svHealthExt_tvb, 0, 2, ENC_BIG_ENDIAN);
    proto_tree_add_bits_item(subtree, hf_lpp_svHealthExt_v1240_e1_bhs, svHealthExt_tvb, 2, 2, ENC_BIG_ENDIAN);
  }

  return offset;
}


static const per_sequence_t GNSS_NavModelSatelliteElement_eag_1_sequence[] = {
  { &hf_lpp_svHealthExt_v1240, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_svHealthExt_v1240 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_NavModelSatelliteElement_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_NavModelSatelliteElement_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_NavModelSatelliteElement_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_svHealth        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_8 },
  { &hf_lpp_iod             , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_11 },
  { &hf_lpp_gnss_ClockModel , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ClockModel },
  { &hf_lpp_gnss_OrbitModel , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_OrbitModel },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_NavModelSatelliteElement_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_NavModelSatelliteElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_NavModelSatelliteElement, GNSS_NavModelSatelliteElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_NavModelSatelliteList_sequence_of[1] = {
  { &hf_lpp_GNSS_NavModelSatelliteList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_NavModelSatelliteElement },
};

static int
dissect_lpp_GNSS_NavModelSatelliteList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_NavModelSatelliteList, GNSS_NavModelSatelliteList_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GNSS_NavigationModel_sequence[] = {
  { &hf_lpp_nonBroadcastIndFlag, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_gnss_SatelliteList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_NavModelSatelliteList },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_NavigationModel(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_NavigationModel, GNSS_NavigationModel_sequence);

  return offset;
}


static const per_sequence_t BadSignalElement_sequence[] = {
  { &hf_lpp_badSVID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_badSignalID     , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_SignalIDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BadSignalElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BadSignalElement, BadSignalElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_BadSignalList_sequence_of[1] = {
  { &hf_lpp_GNSS_BadSignalList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_BadSignalElement },
};

static int
dissect_lpp_GNSS_BadSignalList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_BadSignalList, GNSS_BadSignalList_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GNSS_RealTimeIntegrity_sequence[] = {
  { &hf_lpp_gnss_BadSignalList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_BadSignalList },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RealTimeIntegrity(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RealTimeIntegrity, GNSS_RealTimeIntegrity_sequence);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_1_1024(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 1024, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_DataBitsSgnElement_sequence[] = {
  { &hf_lpp_gnss_SignalType , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalID },
  { &hf_lpp_gnss_DataBits   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_1_1024 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_DataBitsSgnElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DataBitsSgnElement, GNSS_DataBitsSgnElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_DataBitsSgnList_sequence_of[1] = {
  { &hf_lpp_GNSS_DataBitsSgnList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_DataBitsSgnElement },
};

static int
dissect_lpp_GNSS_DataBitsSgnList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_DataBitsSgnList, GNSS_DataBitsSgnList_sequence_of,
                                                  1, 8, FALSE);

  return offset;
}


static const per_sequence_t GNSS_DataBitsSatElement_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_gnss_DataBitsSgnList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_DataBitsSgnList },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_DataBitsSatElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DataBitsSatElement, GNSS_DataBitsSatElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_DataBitsSatList_sequence_of[1] = {
  { &hf_lpp_GNSS_DataBitsSatList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_DataBitsSatElement },
};

static int
dissect_lpp_GNSS_DataBitsSatList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_DataBitsSatList, GNSS_DataBitsSatList_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GNSS_DataBitAssistance_sequence[] = {
  { &hf_lpp_gnss_TOD        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3599 },
  { &hf_lpp_gnss_TODfrac    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_999 },
  { &hf_lpp_gnss_DataBitsSatList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_DataBitsSatList },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_DataBitAssistance(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_DataBitAssistance, GNSS_DataBitAssistance_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_1022(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 1022U, NULL, FALSE);

  return offset;
}


static const value_string lpp_T_dopplerUncertaintyExt_r10_vals[] = {
  {   0, "d60" },
  {   1, "d80" },
  {   2, "d100" },
  {   3, "d120" },
  {   4, "noInformation" },
  { 0, NULL }
};


static int
dissect_lpp_T_dopplerUncertaintyExt_r10(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     5, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_AcquisitionAssistElement_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_doppler0        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2048_2047 },
  { &hf_lpp_doppler1        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_63 },
  { &hf_lpp_dopplerUncertainty, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_4 },
  { &hf_lpp_codePhase       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1022 },
  { &hf_lpp_intCodePhase    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_127 },
  { &hf_lpp_codePhaseSearchWindow, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_31 },
  { &hf_lpp_azimuth         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_elevation       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_127 },
  { &hf_lpp_codePhase1023   , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { &hf_lpp_dopplerUncertaintyExt_r10, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_dopplerUncertaintyExt_r10 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_AcquisitionAssistElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AcquisitionAssistElement, GNSS_AcquisitionAssistElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_AcquisitionAssistList_sequence_of[1] = {
  { &hf_lpp_GNSS_AcquisitionAssistList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_AcquisitionAssistElement },
};

static int
dissect_lpp_GNSS_AcquisitionAssistList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_AcquisitionAssistList, GNSS_AcquisitionAssistList_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GNSS_AcquisitionAssistance_sequence[] = {
  { &hf_lpp_gnss_SignalID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalID },
  { &hf_lpp_gnss_AcquisitionAssistList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_AcquisitionAssistList },
  { &hf_lpp_confidence_r10  , ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_100 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_AcquisitionAssistance(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_AcquisitionAssistance, GNSS_AcquisitionAssistance_sequence);

  return offset;
}



static int
dissect_lpp_T_toa(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  guint32 toa, val;
  int len, old_offset = offset;
  T_GNSS_ID_enum gnss_id = (T_GNSS_ID_enum)GPOINTER_TO_UINT(actx->private_data);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 255U, &toa, FALSE);



  len = (offset-old_offset) >> 3 ? (offset-old_offset) >> 3 : 1;
  val = (gnss_id == T_GNSS_ID_GALILEO) ? 600*toa : 4096*toa;
  actx->created_item = proto_tree_add_uint_format_value(tree, hf_lpp_toa, tvb, old_offset, len,
                                                        toa, "%u s (%u)", val, toa);

  return offset;
}



static int
dissect_lpp_T_kepSV_StatusINAV(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *statusINAV_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     4, 4, FALSE, NULL, 0, &statusINAV_tvb, NULL);



  if (statusINAV_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_kepSV_StatusINAV);
    proto_tree_add_bits_item(subtree, hf_lpp_kepSV_StatusINAV_e5bhs, statusINAV_tvb, 0, 2, ENC_BIG_ENDIAN);
    proto_tree_add_bits_item(subtree, hf_lpp_kepSV_StatusINAV_e1_bhs, statusINAV_tvb, 2, 2, ENC_BIG_ENDIAN);
  }

  return offset;
}



static int
dissect_lpp_T_kepSV_StatusFNAV(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *statusFNAV_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     2, 2, FALSE, NULL, 0, &statusFNAV_tvb, NULL);



  if (statusFNAV_tvb) {
    subtree = proto_item_add_subtree(actx->created_item, ett_kepSV_StatusFNAV);
    proto_tree_add_bits_item(subtree, hf_lpp_kepSV_StatusFNAV_e5ahs, statusFNAV_tvb, 0, 2, ENC_BIG_ENDIAN);
  }

  return offset;
}


static const per_sequence_t AlmanacKeplerianSet_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_kepAlmanacE     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_2047 },
  { &hf_lpp_kepAlmanacDeltaI, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_kepAlmanacOmegaDot, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_kepSV_StatusINAV, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_kepSV_StatusINAV },
  { &hf_lpp_kepSV_StatusFNAV, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_kepSV_StatusFNAV },
  { &hf_lpp_kepAlmanacAPowerHalf, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4096_4095 },
  { &hf_lpp_kepAlmanacOmega0, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_kepAlmanacW     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_kepAlmanacM0    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_kepAlmanacAF0   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_kepAlmanacAF1   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4096_4095 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AlmanacKeplerianSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AlmanacKeplerianSet, AlmanacKeplerianSet_sequence);

  return offset;
}


static const per_sequence_t AlmanacNAV_KeplerianSet_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_navAlmE         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_65535 },
  { &hf_lpp_navAlmDeltaI    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navAlmOMEGADOT  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navAlmSVHealth  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_navAlmSqrtA     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_16777215 },
  { &hf_lpp_navAlmOMEGAo    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_navAlmOmega     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_navAlmMo        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_navAlmaf0       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_navAlmaf1       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AlmanacNAV_KeplerianSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AlmanacNAV_KeplerianSet, AlmanacNAV_KeplerianSet_sequence);

  return offset;
}


static const per_sequence_t AlmanacReducedKeplerianSet_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_redAlmDeltaA    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_redAlmOmega0    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M64_63 },
  { &hf_lpp_redAlmPhi0      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M64_63 },
  { &hf_lpp_redAlmL1Health  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_redAlmL2Health  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_redAlmL5Health  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AlmanacReducedKeplerianSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AlmanacReducedKeplerianSet, AlmanacReducedKeplerianSet_sequence);

  return offset;
}


static const per_sequence_t AlmanacMidiAlmanacSet_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_midiAlmE        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_2047 },
  { &hf_lpp_midiAlmDeltaI   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_midiAlmOmegaDot , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_midiAlmSqrtA    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_131071 },
  { &hf_lpp_midiAlmOmega0   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_midiAlmOmega    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_midiAlmMo       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_midiAlmaf0      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_midiAlmaf1      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M512_511 },
  { &hf_lpp_midiAlmL1Health , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_midiAlmL2Health , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_midiAlmL5Health , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AlmanacMidiAlmanacSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AlmanacMidiAlmanacSet, AlmanacMidiAlmanacSet_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_1_1461(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 1461U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_1_24(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 24U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_0_2097151(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 2097151U, NULL, FALSE);

  return offset;
}


static const per_sequence_t AlmanacGLONASS_AlmanacSet_sequence[] = {
  { &hf_lpp_gloAlm_NA       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_1461 },
  { &hf_lpp_gloAlmnA        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_24 },
  { &hf_lpp_gloAlmHA        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_31 },
  { &hf_lpp_gloAlmLambdaA   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1048576_1048575 },
  { &hf_lpp_gloAlmtlambdaA  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_2097151 },
  { &hf_lpp_gloAlmDeltaIa   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M131072_131071 },
  { &hf_lpp_gloAlmDeltaTA   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2097152_2097151 },
  { &hf_lpp_gloAlmDeltaTdotA, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M64_63 },
  { &hf_lpp_gloAlmEpsilonA  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_32767 },
  { &hf_lpp_gloAlmOmegaA    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_gloAlmTauA      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M512_511 },
  { &hf_lpp_gloAlmCA        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1 },
  { &hf_lpp_gloAlmMA        , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_BIT_STRING_SIZE_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AlmanacGLONASS_AlmanacSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AlmanacGLONASS_AlmanacSet, AlmanacGLONASS_AlmanacSet_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_M256_255(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -256, 255U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M4_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -4, 3U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M8_7(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -8, 7U, NULL, FALSE);

  return offset;
}


static const per_sequence_t AlmanacECEF_SBAS_AlmanacSet_sequence[] = {
  { &hf_lpp_sbasAlmDataID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3 },
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_sbasAlmHealth   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_8 },
  { &hf_lpp_sbasAlmXg       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_sbasAlmYg       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_sbasAlmZg       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M256_255 },
  { &hf_lpp_sbasAlmXgdot    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4_3 },
  { &hf_lpp_sbasAlmYgDot    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4_3 },
  { &hf_lpp_sbasAlmZgDot    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8_7 },
  { &hf_lpp_sbasAlmTo       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_2047 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AlmanacECEF_SBAS_AlmanacSet(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AlmanacECEF_SBAS_AlmanacSet, AlmanacECEF_SBAS_AlmanacSet_sequence);

  return offset;
}



static int
dissect_lpp_T_bdsSvHealth_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *bdsSvHealth_tvb = NULL;
  proto_tree *subtree;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     9, 9, FALSE, NULL, 0, &bdsSvHealth_tvb, NULL);



  if (bdsSvHealth_tvb) {
    guint16 bits;
    subtree = proto_item_add_subtree(actx->created_item, ett_lpp_bdsSvHealth_r12);
    bits = tvb_get_bits16(bdsSvHealth_tvb, 0, 9,ENC_BIG_ENDIAN);
    if (bits == 0x1ff) {
      proto_tree_add_boolean_bits_format_value(subtree, hf_lpp_bdsSvHealth_r12_sat_clock, bdsSvHealth_tvb, 0, 1, 1,
                                               ENC_BIG_ENDIAN, "Satellite is in failure or permanently shut off (1)");
    } else if (bits == 0x100) {
      proto_tree_add_boolean_bits_format_value(subtree, hf_lpp_bdsSvHealth_r12_sat_clock, bdsSvHealth_tvb, 0, 1, 1,
                                               ENC_BIG_ENDIAN, "Satellite clock is unavailable (1)");
    } else {
      proto_tree_add_bits_item(subtree, hf_lpp_bdsSvHealth_r12_sat_clock, bdsSvHealth_tvb, 0, 1, ENC_BIG_ENDIAN);
      proto_tree_add_bits_item(subtree, hf_lpp_bdsSvHealth_r12_b1i, bdsSvHealth_tvb, 1, 1, ENC_BIG_ENDIAN);
      proto_tree_add_bits_item(subtree, hf_lpp_bdsSvHealth_r12_b2i, bdsSvHealth_tvb, 2, 1, ENC_BIG_ENDIAN);
      proto_tree_add_bits_item(subtree, hf_lpp_bdsSvHealth_r12_nav, bdsSvHealth_tvb, 7, 1, ENC_BIG_ENDIAN);
    }
  }

  return offset;
}


static const per_sequence_t AlmanacBDS_AlmanacSet_r12_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_bdsAlmToa_r12   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_bdsAlmSqrtA_r12 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_16777215 },
  { &hf_lpp_bdsAlmE_r12     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_131071 },
  { &hf_lpp_bdsAlmW_r12     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_bdsAlmM0_r12    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_bdsAlmOmega0_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_bdsAlmOmegaDot_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M65536_65535 },
  { &hf_lpp_bdsAlmDeltaI_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_bdsAlmA0_r12    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_bdsAlmA1_r12    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_bdsSvHealth_r12 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_bdsSvHealth_r12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AlmanacBDS_AlmanacSet_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AlmanacBDS_AlmanacSet_r12, AlmanacBDS_AlmanacSet_r12_sequence);

  return offset;
}


static const per_sequence_t AlmanacNavIC_AlmanacSet_r16_sequence[] = {
  { &hf_lpp_svID_r16        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_navic_AlmToa_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_65535 },
  { &hf_lpp_navic_AlmE_r16  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_65535 },
  { &hf_lpp_navic_AlmOMEGADOT_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_navic_AlmSqrtA_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_16777215 },
  { &hf_lpp_navic_AlmOMEGAo_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_navic_AlmOmega_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_navic_AlmMo_r16 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_navic_Almaf0_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_navic_Almaf1_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M1024_1023 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_AlmanacNavIC_AlmanacSet_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_AlmanacNavIC_AlmanacSet_r16, AlmanacNavIC_AlmanacSet_r16_sequence);

  return offset;
}


static const value_string lpp_GNSS_AlmanacElement_vals[] = {
  {   0, "keplerianAlmanacSet" },
  {   1, "keplerianNAV-Almanac" },
  {   2, "keplerianReducedAlmanac" },
  {   3, "keplerianMidiAlmanac" },
  {   4, "keplerianGLONASS" },
  {   5, "ecef-SBAS-Almanac" },
  {   6, "keplerianBDS-Almanac-r12" },
  {   7, "keplerianNavIC-Almanac-r16" },
  { 0, NULL }
};

static const per_choice_t GNSS_AlmanacElement_choice[] = {
  {   0, &hf_lpp_keplerianAlmanacSet, ASN1_EXTENSION_ROOT    , dissect_lpp_AlmanacKeplerianSet },
  {   1, &hf_lpp_keplerianNAV_Almanac, ASN1_EXTENSION_ROOT    , dissect_lpp_AlmanacNAV_KeplerianSet },
  {   2, &hf_lpp_keplerianReducedAlmanac, ASN1_EXTENSION_ROOT    , dissect_lpp_AlmanacReducedKeplerianSet },
  {   3, &hf_lpp_keplerianMidiAlmanac, ASN1_EXTENSION_ROOT    , dissect_lpp_AlmanacMidiAlmanacSet },
  {   4, &hf_lpp_keplerianGLONASS, ASN1_EXTENSION_ROOT    , dissect_lpp_AlmanacGLONASS_AlmanacSet },
  {   5, &hf_lpp_ecef_SBAS_Almanac, ASN1_EXTENSION_ROOT    , dissect_lpp_AlmanacECEF_SBAS_AlmanacSet },
  {   6, &hf_lpp_keplerianBDS_Almanac_r12, ASN1_NOT_EXTENSION_ROOT, dissect_lpp_AlmanacBDS_AlmanacSet_r12 },
  {   7, &hf_lpp_keplerianNavIC_Almanac_r16, ASN1_NOT_EXTENSION_ROOT, dissect_lpp_AlmanacNavIC_AlmanacSet_r16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_GNSS_AlmanacElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_GNSS_AlmanacElement, GNSS_AlmanacElement_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GNSS_AlmanacList_sequence_of[1] = {
  { &hf_lpp_GNSS_AlmanacList_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_AlmanacElement },
};

static int
dissect_lpp_GNSS_AlmanacList(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_AlmanacList, GNSS_AlmanacList_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}



static int
dissect_lpp_T_toa_ext_v1240(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  guint32 toa_ext, val;
  int len, old_offset = offset;
  T_GNSS_ID_enum gnss_id = (T_GNSS_ID_enum)GPOINTER_TO_UINT(actx->private_data);
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            256U, 1023U, &toa_ext, FALSE);



  len = (offset-old_offset) >> 3 ? (offset-old_offset) >> 3 : 1;
  val = (gnss_id == T_GNSS_ID_GALILEO) ? 600*toa_ext : 4096*toa_ext;
  actx->created_item = proto_tree_add_uint_format_value(tree, hf_lpp_toa_ext_v1240, tvb, old_offset, len,
                                                        toa_ext, "%u s (%u)", val, toa_ext);

  return offset;
}



static int
dissect_lpp_INTEGER_4_15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            4U, 15U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GNSS_Almanac_eag_1_sequence[] = {
  { &hf_lpp_toa_ext_v1240   , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_toa_ext_v1240 },
  { &hf_lpp_ioda_ext_v1240  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_4_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_Almanac_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_Almanac_eag_1_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_256_8191(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            256U, 8191U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_256_65535(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            256U, 65535U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GNSS_Almanac_eag_2_sequence[] = {
  { &hf_lpp_weekNumber_ext_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_256_8191 },
  { &hf_lpp_toa_ext2_r16    , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_256_65535 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_Almanac_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_Almanac_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_Almanac_sequence[] = {
  { &hf_lpp_weekNumber_01   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_toa             , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_toa },
  { &hf_lpp_ioda            , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_3 },
  { &hf_lpp_completeAlmanacProvided, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BOOLEAN },
  { &hf_lpp_gnss_AlmanacList, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_AlmanacList },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_Almanac_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_Almanac_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_Almanac(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_Almanac, GNSS_Almanac_sequence);

  return offset;
}


static const per_sequence_t UTC_ModelSet1_sequence[] = {
  { &hf_lpp_gnss_Utc_A1     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_gnss_Utc_A0     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_gnss_Utc_Tot    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_gnss_Utc_WNt    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_gnss_Utc_DeltaTls, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_gnss_Utc_WNlsf  , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_gnss_Utc_DN     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_gnss_Utc_DeltaTlsf, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_UTC_ModelSet1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_UTC_ModelSet1, UTC_ModelSet1_sequence);

  return offset;
}



static int
dissect_lpp_T_utcDN(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *utcDN_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     4, 4, FALSE, NULL, 0, &utcDN_tvb, NULL);



  if (utcDN_tvb) {
    guint bitvalue = tvb_get_bits8(utcDN_tvb, 0, 4);
    actx->created_item = proto_tree_add_uint(tree, hf_index, utcDN_tvb, 0, 1, bitvalue);
  }

  return offset;
}


static const per_sequence_t UTC_ModelSet2_eag_1_sequence[] = {
  { &hf_lpp_utcWNlsf_ext_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_256_8191 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_UTC_ModelSet2_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, UTC_ModelSet2_eag_1_sequence);

  return offset;
}


static const per_sequence_t UTC_ModelSet2_sequence[] = {
  { &hf_lpp_utcA0           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_utcA1           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4096_4095 },
  { &hf_lpp_utcA2           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M64_63 },
  { &hf_lpp_utcDeltaTls     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_utcTot          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_65535 },
  { &hf_lpp_utcWNot         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_8191 },
  { &hf_lpp_utcWNlsf        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_utcDN           , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_utcDN },
  { &hf_lpp_utcDeltaTlsf    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_UTC_ModelSet2_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_UTC_ModelSet2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_UTC_ModelSet2, UTC_ModelSet2_sequence);

  return offset;
}



static int
dissect_lpp_T_kp(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  tvbuff_t *kp_tvb = NULL;
  offset = dissect_per_bit_string(tvb, offset, actx, tree, -1,
                                     2, 2, FALSE, NULL, 0, &kp_tvb, NULL);



  if (kp_tvb) {
    guint bitvalue = tvb_get_bits8(kp_tvb, 0, 2);
    actx->created_item = proto_tree_add_uint(tree, hf_index, kp_tvb, 0, 1, bitvalue);
  }

  return offset;
}


static const per_sequence_t UTC_ModelSet3_sequence[] = {
  { &hf_lpp_nA              , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_1461 },
  { &hf_lpp_tauC            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_b1              , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M1024_1023 },
  { &hf_lpp_b2              , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M512_511 },
  { &hf_lpp_kp              , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_T_kp },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_UTC_ModelSet3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_UTC_ModelSet3, UTC_ModelSet3_sequence);

  return offset;
}


static const per_sequence_t UTC_ModelSet4_sequence[] = {
  { &hf_lpp_utcA1wnt        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_utcA0wnt        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_utcTot_01       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_utcWNt          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_utcDeltaTls     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_utcWNlsf        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_UTC_ModelSet4_utcDN, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_utcDeltaTlsf    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_utcStandardID   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_7 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_UTC_ModelSet4(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_UTC_ModelSet4, UTC_ModelSet4_sequence);

  return offset;
}


static const per_sequence_t UTC_ModelSet5_r12_sequence[] = {
  { &hf_lpp_utcA0_r12       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2147483648_2147483647 },
  { &hf_lpp_utcA1_r12       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_utcDeltaTls_r12 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &hf_lpp_utcWNlsf_r12    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_utcDN_r12       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_utcDeltaTlsf_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_UTC_ModelSet5_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_UTC_ModelSet5_r12, UTC_ModelSet5_r12_sequence);

  return offset;
}


static const value_string lpp_GNSS_UTC_Model_vals[] = {
  {   0, "utcModel1" },
  {   1, "utcModel2" },
  {   2, "utcModel3" },
  {   3, "utcModel4" },
  {   4, "utcModel5-r12" },
  { 0, NULL }
};

static const per_choice_t GNSS_UTC_Model_choice[] = {
  {   0, &hf_lpp_utcModel1       , ASN1_EXTENSION_ROOT    , dissect_lpp_UTC_ModelSet1 },
  {   1, &hf_lpp_utcModel2       , ASN1_EXTENSION_ROOT    , dissect_lpp_UTC_ModelSet2 },
  {   2, &hf_lpp_utcModel3       , ASN1_EXTENSION_ROOT    , dissect_lpp_UTC_ModelSet3 },
  {   3, &hf_lpp_utcModel4       , ASN1_EXTENSION_ROOT    , dissect_lpp_UTC_ModelSet4 },
  {   4, &hf_lpp_utcModel5_r12   , ASN1_NOT_EXTENSION_ROOT, dissect_lpp_UTC_ModelSet5_r12 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_GNSS_UTC_Model(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_GNSS_UTC_Model, GNSS_UTC_Model_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GNSS_ID_GPS_SatElement_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_signalsAvailable, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ID_GPS_SatElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ID_GPS_SatElement, GNSS_ID_GPS_SatElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_ID_GPS_sequence_of[1] = {
  { &hf_lpp_GNSS_ID_GPS_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID_GPS_SatElement },
};

static int
dissect_lpp_GNSS_ID_GPS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_ID_GPS, GNSS_ID_GPS_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_M7_13(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            -7, 13U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GNSS_ID_GLONASS_SatElement_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_signalsAvailable, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalIDs },
  { &hf_lpp_channelNumber   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M7_13 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ID_GLONASS_SatElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ID_GLONASS_SatElement, GNSS_ID_GLONASS_SatElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_ID_GLONASS_sequence_of[1] = {
  { &hf_lpp_GNSS_ID_GLONASS_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID_GLONASS_SatElement },
};

static int
dissect_lpp_GNSS_ID_GLONASS(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_ID_GLONASS, GNSS_ID_GLONASS_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GNSS_ID_BDS_SatElement_r16_sequence[] = {
  { &hf_lpp_svID_r16        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_satType_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_ID_BDS_SatElement_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_ID_BDS_SatElement_r16, GNSS_ID_BDS_SatElement_r16_sequence);

  return offset;
}


static const per_sequence_t GNSS_ID_BDS_r16_sequence_of[1] = {
  { &hf_lpp_GNSS_ID_BDS_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID_BDS_SatElement_r16 },
};

static int
dissect_lpp_GNSS_ID_BDS_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_ID_BDS_r16, GNSS_ID_BDS_r16_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const value_string lpp_GNSS_AuxiliaryInformation_vals[] = {
  {   0, "gnss-ID-GPS" },
  {   1, "gnss-ID-GLONASS" },
  {   2, "gnss-ID-BDS-r16" },
  { 0, NULL }
};

static const per_choice_t GNSS_AuxiliaryInformation_choice[] = {
  {   0, &hf_lpp_gnss_ID_GPS     , ASN1_EXTENSION_ROOT    , dissect_lpp_GNSS_ID_GPS },
  {   1, &hf_lpp_gnss_ID_GLONASS , ASN1_EXTENSION_ROOT    , dissect_lpp_GNSS_ID_GLONASS },
  {   2, &hf_lpp_gnss_ID_BDS_r16 , ASN1_NOT_EXTENSION_ROOT, dissect_lpp_GNSS_ID_BDS_r16 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_GNSS_AuxiliaryInformation(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_GNSS_AuxiliaryInformation, GNSS_AuxiliaryInformation_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t DBDS_CorrectionElement_r12_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_bds_UDREI_r12   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_bds_RURAI_r12   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_bds_ECC_DeltaT_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4096_4095 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_DBDS_CorrectionElement_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_DBDS_CorrectionElement_r12, DBDS_CorrectionElement_r12_sequence);

  return offset;
}


static const per_sequence_t DBDS_CorrectionList_r12_sequence_of[1] = {
  { &hf_lpp_DBDS_CorrectionList_r12_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_DBDS_CorrectionElement_r12 },
};

static int
dissect_lpp_DBDS_CorrectionList_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_DBDS_CorrectionList_r12, DBDS_CorrectionList_r12_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t BDS_SgnTypeElement_r12_sequence[] = {
  { &hf_lpp_gnss_SignalID   , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_SignalID },
  { &hf_lpp_dbds_CorrectionList_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_DBDS_CorrectionList_r12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BDS_SgnTypeElement_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BDS_SgnTypeElement_r12, BDS_SgnTypeElement_r12_sequence);

  return offset;
}


static const per_sequence_t BDS_SgnTypeList_r12_sequence_of[1] = {
  { &hf_lpp_BDS_SgnTypeList_r12_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_BDS_SgnTypeElement_r12 },
};

static int
dissect_lpp_BDS_SgnTypeList_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_BDS_SgnTypeList_r12, BDS_SgnTypeList_r12_sequence_of,
                                                  1, 3, FALSE);

  return offset;
}


static const per_sequence_t BDS_DifferentialCorrections_r12_sequence[] = {
  { &hf_lpp_dbds_RefTime_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3599 },
  { &hf_lpp_bds_SgnTypeList_r12, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BDS_SgnTypeList_r12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BDS_DifferentialCorrections_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BDS_DifferentialCorrections_r12, BDS_DifferentialCorrections_r12_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_1_320(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 320U, NULL, FALSE);

  return offset;
}


static const per_sequence_t GridIonElement_r12_sequence[] = {
  { &hf_lpp_igp_ID_r12      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_320 },
  { &hf_lpp_dt_r12          , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei_r12       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GridIonElement_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GridIonElement_r12, GridIonElement_r12_sequence);

  return offset;
}


static const per_sequence_t GridIonList_r12_sequence_of[1] = {
  { &hf_lpp_GridIonList_r12_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GridIonElement_r12 },
};

static int
dissect_lpp_GridIonList_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GridIonList_r12, GridIonList_r12_sequence_of,
                                                  1, 320, FALSE);

  return offset;
}


static const per_sequence_t BDS_GridModelParameter_r12_sequence[] = {
  { &hf_lpp_bds_RefTime_r12 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3599 },
  { &hf_lpp_gridIonList_r12 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GridIonList_r12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_BDS_GridModelParameter_r12(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_BDS_GridModelParameter_r12, BDS_GridModelParameter_r12_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataElement_eag_1_sequence[] = {
  { &hf_lpp_bds_DifferentialCorrections_r12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BDS_DifferentialCorrections_r12 },
  { &hf_lpp_bds_GridModel_r12, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BDS_GridModelParameter_r12 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataElement_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataElement_eag_1_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_254(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 254U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1, 1, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t GNSS_RTK_SatelliteSignalDataElement_r15_sequence[] = {
  { &hf_lpp_gnss_SignalID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalID },
  { &hf_lpp_fine_PseudoRange_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M524288_524287 },
  { &hf_lpp_fine_PhaseRange_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8388608_8388607 },
  { &hf_lpp_lockTimeIndicator_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1023 },
  { &hf_lpp_halfCycleAmbiguityIndicator_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_1 },
  { &hf_lpp_carrier_to_noise_ratio_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1023 },
  { &hf_lpp_fine_PhaseRangeRate_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M16384_16383 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_SatelliteSignalDataElement_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_SatelliteSignalDataElement_r15, GNSS_RTK_SatelliteSignalDataElement_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_RTK_SatelliteSignalDataList_r15_sequence_of[1] = {
  { &hf_lpp_GNSS_RTK_SatelliteSignalDataList_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_RTK_SatelliteSignalDataElement_r15 },
};

static int
dissect_lpp_GNSS_RTK_SatelliteSignalDataList_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_RTK_SatelliteSignalDataList_r15, GNSS_RTK_SatelliteSignalDataList_r15_sequence_of,
                                                  1, 24, FALSE);

  return offset;
}


static const per_sequence_t GNSS_RTK_SatelliteDataElement_r15_sequence[] = {
  { &hf_lpp_svID_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_integer_ms_r15  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_254 },
  { &hf_lpp_rough_range_r15 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1023 },
  { &hf_lpp_rough_phase_range_rate_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M8192_8191 },
  { &hf_lpp_gnss_rtk_SatelliteSignalDataList_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_RTK_SatelliteSignalDataList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_SatelliteDataElement_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_SatelliteDataElement_r15, GNSS_RTK_SatelliteDataElement_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_ObservationList_r15_sequence_of[1] = {
  { &hf_lpp_GNSS_ObservationList_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_RTK_SatelliteDataElement_r15 },
};

static int
dissect_lpp_GNSS_ObservationList_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_ObservationList_r15, GNSS_ObservationList_r15_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GNSS_RTK_Observations_r15_sequence[] = {
  { &hf_lpp_epochTime_r15   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SystemTime },
  { &hf_lpp_gnss_ObservationList_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ObservationList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_Observations_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_Observations_r15, GNSS_RTK_Observations_r15_sequence);

  return offset;
}


static const per_sequence_t GLO_RTK_BiasInformation_r15_sequence[] = {
  { &hf_lpp_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_cpbIndicator_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_1 },
  { &hf_lpp_l1_ca_cpBias_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_l1_p_cpBias_r15 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_l2_ca_cpBias_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M32768_32767 },
  { &hf_lpp_l2_p_cpBias_r15 , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M32768_32767 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GLO_RTK_BiasInformation_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GLO_RTK_BiasInformation_r15, GLO_RTK_BiasInformation_r15_sequence);

  return offset;
}


static const per_sequence_t Geometric_Ionospheric_Corrections_Differences_Element_r15_sequence[] = {
  { &hf_lpp_svID_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_ambiguityStatusFlag_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3 },
  { &hf_lpp_non_synch_count_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_7 },
  { &hf_lpp_geometricCarrierPhaseCorrectionDifference_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M65536_65535 },
  { &hf_lpp_iod_r15         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_11 },
  { &hf_lpp_ionosphericCarrierPhaseCorrectionDifference_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M65536_65535 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_Geometric_Ionospheric_Corrections_Differences_Element_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_Geometric_Ionospheric_Corrections_Differences_Element_r15, Geometric_Ionospheric_Corrections_Differences_Element_r15_sequence);

  return offset;
}


static const per_sequence_t Geometric_Ionospheric_Corrections_Differences_r15_sequence_of[1] = {
  { &hf_lpp_Geometric_Ionospheric_Corrections_Differences_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_Geometric_Ionospheric_Corrections_Differences_Element_r15 },
};

static int
dissect_lpp_Geometric_Ionospheric_Corrections_Differences_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_Geometric_Ionospheric_Corrections_Differences_r15, Geometric_Ionospheric_Corrections_Differences_r15_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t RTK_CorrectionDifferencesElement_r15_sequence[] = {
  { &hf_lpp_epochTime_r15   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SystemTime },
  { &hf_lpp_auxiliary_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_geometric_ionospheric_corrections_differences_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_Geometric_Ionospheric_Corrections_Differences_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RTK_CorrectionDifferencesElement_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RTK_CorrectionDifferencesElement_r15, RTK_CorrectionDifferencesElement_r15_sequence);

  return offset;
}


static const per_sequence_t RTK_CorrectionDifferencesList_r15_sequence_of[1] = {
  { &hf_lpp_RTK_CorrectionDifferencesList_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_RTK_CorrectionDifferencesElement_r15 },
};

static int
dissect_lpp_RTK_CorrectionDifferencesList_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_RTK_CorrectionDifferencesList_r15, RTK_CorrectionDifferencesList_r15_sequence_of,
                                                  1, 32, FALSE);

  return offset;
}


static const per_sequence_t GNSS_RTK_MAC_CorrectionDifferences_r15_sequence[] = {
  { &hf_lpp_networkID_r15   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_NetworkID_r15 },
  { &hf_lpp_subNetworkID_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_SubNetworkID_r15 },
  { &hf_lpp_master_ReferenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_l1_r15          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_FrequencyID_r15 },
  { &hf_lpp_l2_r15          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_FrequencyID_r15 },
  { &hf_lpp_rtkCorrectionDifferencesList_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_RTK_CorrectionDifferencesList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_MAC_CorrectionDifferences_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_MAC_CorrectionDifferences_r15, GNSS_RTK_MAC_CorrectionDifferences_r15_sequence);

  return offset;
}


static const per_sequence_t RTK_Residuals_Element_r15_sequence[] = {
  { &hf_lpp_svID_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_s_oc_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_s_od_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_s_oh_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_63 },
  { &hf_lpp_s_lc_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1023 },
  { &hf_lpp_s_ld_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1023 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RTK_Residuals_Element_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RTK_Residuals_Element_r15, RTK_Residuals_Element_r15_sequence);

  return offset;
}


static const per_sequence_t RTK_Residuals_List_r15_sequence_of[1] = {
  { &hf_lpp_RTK_Residuals_List_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_RTK_Residuals_Element_r15 },
};

static int
dissect_lpp_RTK_Residuals_List_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_RTK_Residuals_List_r15, RTK_Residuals_List_r15_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GNSS_RTK_Residuals_r15_sequence[] = {
  { &hf_lpp_epochTime_r15   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SystemTime },
  { &hf_lpp_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_n_Refs_r15      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_127 },
  { &hf_lpp_l1_r15          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_FrequencyID_r15 },
  { &hf_lpp_l2_r15          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_FrequencyID_r15 },
  { &hf_lpp_rtk_residuals_list_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_RTK_Residuals_List_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_Residuals_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_Residuals_r15, GNSS_RTK_Residuals_r15_sequence);

  return offset;
}


static const per_sequence_t FKP_Gradients_Element_r15_sequence[] = {
  { &hf_lpp_svID_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_iod_r15         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_11 },
  { &hf_lpp_north_geometric_gradient_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2048_2047 },
  { &hf_lpp_east_geometric_gradient_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2048_2047 },
  { &hf_lpp_north_ionospheric_gradient_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8192_8191 },
  { &hf_lpp_east_ionospheric_gradient_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8192_8191 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_FKP_Gradients_Element_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_FKP_Gradients_Element_r15, FKP_Gradients_Element_r15_sequence);

  return offset;
}


static const per_sequence_t FKP_Gradients_List_r15_sequence_of[1] = {
  { &hf_lpp_FKP_Gradients_List_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_FKP_Gradients_Element_r15 },
};

static int
dissect_lpp_FKP_Gradients_List_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_FKP_Gradients_List_r15, FKP_Gradients_List_r15_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GNSS_RTK_FKP_Gradients_r15_sequence[] = {
  { &hf_lpp_referenceStationID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ReferenceStationID_r15 },
  { &hf_lpp_epochTime_r15   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SystemTime },
  { &hf_lpp_l1_r15          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_FrequencyID_r15 },
  { &hf_lpp_l2_r15          , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_FrequencyID_r15 },
  { &hf_lpp_fkp_gradients_list_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_FKP_Gradients_List_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_RTK_FKP_Gradients_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_RTK_FKP_Gradients_r15, GNSS_RTK_FKP_Gradients_r15_sequence);

  return offset;
}


static const value_string lpp_T_satelliteReferenceDatum_r15_vals[] = {
  {   0, "itrf" },
  {   1, "regional" },
  { 0, NULL }
};


static int
dissect_lpp_T_satelliteReferenceDatum_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t RAC_OrbitalErrorComponents_r17_sequence[] = {
  { &hf_lpp_radial_r17      , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_alongTrack_r17  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_crossTrack_r17  , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RAC_OrbitalErrorComponents_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RAC_OrbitalErrorComponents_r17, RAC_OrbitalErrorComponents_r17_sequence);

  return offset;
}


static const per_sequence_t SSR_IntegrityOrbitBounds_r17_sequence[] = {
  { &hf_lpp_meanOrbitError_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_RAC_OrbitalErrorComponents_r17 },
  { &hf_lpp_stdDevOrbitError_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_RAC_OrbitalErrorComponents_r17 },
  { &hf_lpp_meanOrbitRateError_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_RAC_OrbitalErrorComponents_r17 },
  { &hf_lpp_stdDevOrbitRateError_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_RAC_OrbitalErrorComponents_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_IntegrityOrbitBounds_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SSR_IntegrityOrbitBounds_r17, SSR_IntegrityOrbitBounds_r17_sequence);

  return offset;
}


static const per_sequence_t SSR_OrbitCorrectionSatelliteElement_r15_eag_1_sequence[] = {
  { &hf_lpp_ssr_IntegrityOrbitBounds_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SSR_IntegrityOrbitBounds_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_OrbitCorrectionSatelliteElement_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SSR_OrbitCorrectionSatelliteElement_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t SSR_OrbitCorrectionSatelliteElement_r15_sequence[] = {
  { &hf_lpp_svID_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_iod_r15         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_11 },
  { &hf_lpp_delta_radial_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2097152_2097151 },
  { &hf_lpp_delta_AlongTrack_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M524288_524287 },
  { &hf_lpp_delta_CrossTrack_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M524288_524287 },
  { &hf_lpp_dot_delta_radial_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M1048576_1048575 },
  { &hf_lpp_dot_delta_AlongTrack_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M262144_262143 },
  { &hf_lpp_dot_delta_CrossTrack_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M262144_262143 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_SSR_OrbitCorrectionSatelliteElement_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_OrbitCorrectionSatelliteElement_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SSR_OrbitCorrectionSatelliteElement_r15, SSR_OrbitCorrectionSatelliteElement_r15_sequence);

  return offset;
}


static const per_sequence_t SSR_OrbitCorrectionList_r15_sequence_of[1] = {
  { &hf_lpp_SSR_OrbitCorrectionList_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_OrbitCorrectionSatelliteElement_r15 },
};

static int
dissect_lpp_SSR_OrbitCorrectionList_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SSR_OrbitCorrectionList_r15, SSR_OrbitCorrectionList_r15_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_1_3600(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 3600U, NULL, FALSE);

  return offset;
}


static const per_sequence_t ORBIT_IntegrityParameters_r17_sequence[] = {
  { &hf_lpp_probOnsetConstFault_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_meanConstFaultDuration_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_3600 },
  { &hf_lpp_probOnsetSatFault_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_meanSatFaultDuration_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_3600 },
  { &hf_lpp_orbitRangeErrorCorrelationTime_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_orbitRangeRateErrorCorrelationTime_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_ORBIT_IntegrityParameters_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_ORBIT_IntegrityParameters_r17, ORBIT_IntegrityParameters_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_OrbitCorrections_r15_eag_1_sequence[] = {
  { &hf_lpp_orbit_IntegrityParameters_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ORBIT_IntegrityParameters_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_OrbitCorrections_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_OrbitCorrections_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_OrbitCorrections_r15_sequence[] = {
  { &hf_lpp_epochTime_r15   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SystemTime },
  { &hf_lpp_ssrUpdateInterval_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_satelliteReferenceDatum_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_satelliteReferenceDatum_r15 },
  { &hf_lpp_iod_ssr_r15     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_ssr_OrbitCorrectionList_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_OrbitCorrectionList_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_OrbitCorrections_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_OrbitCorrections_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_OrbitCorrections_r15, GNSS_SSR_OrbitCorrections_r15_sequence);

  return offset;
}


static const per_sequence_t SSR_IntegrityClockBounds_r17_sequence[] = {
  { &hf_lpp_meanClock_r17   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_stdDevClock_r17 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_meanClockRate_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_stdDevClockRate_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_IntegrityClockBounds_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SSR_IntegrityClockBounds_r17, SSR_IntegrityClockBounds_r17_sequence);

  return offset;
}


static const per_sequence_t SSR_ClockCorrectionSatelliteElement_r15_eag_1_sequence[] = {
  { &hf_lpp_ssr_IntegrityClockBounds_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SSR_IntegrityClockBounds_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_ClockCorrectionSatelliteElement_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SSR_ClockCorrectionSatelliteElement_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t SSR_ClockCorrectionSatelliteElement_r15_sequence[] = {
  { &hf_lpp_svID_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_delta_Clock_C0_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2097152_2097151 },
  { &hf_lpp_delta_Clock_C1_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M1048576_1048575 },
  { &hf_lpp_delta_Clock_C2_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M67108864_67108863 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_SSR_ClockCorrectionSatelliteElement_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_ClockCorrectionSatelliteElement_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SSR_ClockCorrectionSatelliteElement_r15, SSR_ClockCorrectionSatelliteElement_r15_sequence);

  return offset;
}


static const per_sequence_t SSR_ClockCorrectionList_r15_sequence_of[1] = {
  { &hf_lpp_SSR_ClockCorrectionList_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_ClockCorrectionSatelliteElement_r15 },
};

static int
dissect_lpp_SSR_ClockCorrectionList_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SSR_ClockCorrectionList_r15, SSR_ClockCorrectionList_r15_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t CLOCK_IntegrityParameters_r17_sequence[] = {
  { &hf_lpp_clockRangeErrorCorrelationTime_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_clockRangeRateErrorCorrelationTime_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_CLOCK_IntegrityParameters_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_CLOCK_IntegrityParameters_r17, CLOCK_IntegrityParameters_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_ClockCorrections_r15_eag_1_sequence[] = {
  { &hf_lpp_clock_IntegrityParameters_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_CLOCK_IntegrityParameters_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ClockCorrections_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_ClockCorrections_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_ClockCorrections_r15_sequence[] = {
  { &hf_lpp_epochTime_r15   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SystemTime },
  { &hf_lpp_ssrUpdateInterval_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_iod_ssr_r15     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_ssr_ClockCorrectionList_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_ClockCorrectionList_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_ClockCorrections_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_ClockCorrections_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_ClockCorrections_r15, GNSS_SSR_ClockCorrections_r15_sequence);

  return offset;
}


static const per_sequence_t SSR_IntegrityCodeBiasBounds_r17_sequence[] = {
  { &hf_lpp_meanCodeBias_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_stdDevCodeBias_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_meanCodeBiasRate_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_stdDevCodeBiasRate_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_IntegrityCodeBiasBounds_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SSR_IntegrityCodeBiasBounds_r17, SSR_IntegrityCodeBiasBounds_r17_sequence);

  return offset;
}


static const per_sequence_t SSR_CodeBiasSignalElement_r15_eag_1_sequence[] = {
  { &hf_lpp_ssr_IntegrityCodeBiasBounds_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SSR_IntegrityCodeBiasBounds_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_CodeBiasSignalElement_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SSR_CodeBiasSignalElement_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t SSR_CodeBiasSignalElement_r15_sequence[] = {
  { &hf_lpp_signal_and_tracking_mode_ID_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalID },
  { &hf_lpp_codeBias_r15    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8192_8191 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_SSR_CodeBiasSignalElement_r15_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_CodeBiasSignalElement_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SSR_CodeBiasSignalElement_r15, SSR_CodeBiasSignalElement_r15_sequence);

  return offset;
}


static const per_sequence_t SSR_CodeBiasSignalList_r15_sequence_of[1] = {
  { &hf_lpp_SSR_CodeBiasSignalList_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_CodeBiasSignalElement_r15 },
};

static int
dissect_lpp_SSR_CodeBiasSignalList_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SSR_CodeBiasSignalList_r15, SSR_CodeBiasSignalList_r15_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const per_sequence_t SSR_CodeBiasSatElement_r15_sequence[] = {
  { &hf_lpp_svID_r15        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_ssr_CodeBiasSignalList_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_CodeBiasSignalList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_CodeBiasSatElement_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SSR_CodeBiasSatElement_r15, SSR_CodeBiasSatElement_r15_sequence);

  return offset;
}


static const per_sequence_t SSR_CodeBiasSatList_r15_sequence_of[1] = {
  { &hf_lpp_SSR_CodeBiasSatList_r15_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_CodeBiasSatElement_r15 },
};

static int
dissect_lpp_SSR_CodeBiasSatList_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SSR_CodeBiasSatList_r15, SSR_CodeBiasSatList_r15_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GNSS_SSR_CodeBias_r15_sequence[] = {
  { &hf_lpp_epochTime_r15   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SystemTime },
  { &hf_lpp_ssrUpdateInterval_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_iod_ssr_r15     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_ssr_CodeBiasSatList_r15, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_CodeBiasSatList_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_CodeBias_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_CodeBias_r15, GNSS_SSR_CodeBias_r15_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataElement_eag_2_sequence[] = {
  { &hf_lpp_gnss_RTK_Observations_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_Observations_r15 },
  { &hf_lpp_glo_RTK_BiasInformation_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GLO_RTK_BiasInformation_r15 },
  { &hf_lpp_gnss_RTK_MAC_CorrectionDifferences_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_MAC_CorrectionDifferences_r15 },
  { &hf_lpp_gnss_RTK_Residuals_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_Residuals_r15 },
  { &hf_lpp_gnss_RTK_FKP_Gradients_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_RTK_FKP_Gradients_r15 },
  { &hf_lpp_gnss_SSR_OrbitCorrections_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_OrbitCorrections_r15 },
  { &hf_lpp_gnss_SSR_ClockCorrections_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_ClockCorrections_r15 },
  { &hf_lpp_gnss_SSR_CodeBias_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_CodeBias_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataElement_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataElement_eag_2_sequence);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_6(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     6, 6, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const per_sequence_t SSR_URA_SatElement_r16_sequence[] = {
  { &hf_lpp_svID_r16        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_ssr_URA_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_6 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_URA_SatElement_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SSR_URA_SatElement_r16, SSR_URA_SatElement_r16_sequence);

  return offset;
}


static const per_sequence_t SSR_URA_SatList_r16_sequence_of[1] = {
  { &hf_lpp_SSR_URA_SatList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_URA_SatElement_r16 },
};

static int
dissect_lpp_SSR_URA_SatList_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SSR_URA_SatList_r16, SSR_URA_SatList_r16_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GNSS_SSR_URA_r16_sequence[] = {
  { &hf_lpp_epochTime_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SystemTime },
  { &hf_lpp_ssrUpdateInterval_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_iod_ssr_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_ssr_URA_SatList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_URA_SatList_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_URA_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_URA_r16, GNSS_SSR_URA_r16_sequence);

  return offset;
}


static const per_sequence_t SSR_IntegrityPhaseBiasBounds_r17_sequence[] = {
  { &hf_lpp_meanPhaseBias_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_stdDevPhaseBias_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_meanPhaseBiasRate_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_stdDevPhaseBiasRate_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_IntegrityPhaseBiasBounds_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SSR_IntegrityPhaseBiasBounds_r17, SSR_IntegrityPhaseBiasBounds_r17_sequence);

  return offset;
}


static const per_sequence_t SSR_PhaseBiasSignalElement_r16_eag_1_sequence[] = {
  { &hf_lpp_ssr_IntegrityPhaseBiasBounds_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SSR_IntegrityPhaseBiasBounds_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_PhaseBiasSignalElement_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, SSR_PhaseBiasSignalElement_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t SSR_PhaseBiasSignalElement_r16_sequence[] = {
  { &hf_lpp_signal_and_tracking_mode_ID_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SignalID },
  { &hf_lpp_phaseBias_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_phaseDiscontinuityIndicator_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_3 },
  { &hf_lpp_phaseBiasIntegerIndicator_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_3 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_SSR_PhaseBiasSignalElement_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_PhaseBiasSignalElement_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SSR_PhaseBiasSignalElement_r16, SSR_PhaseBiasSignalElement_r16_sequence);

  return offset;
}


static const per_sequence_t SSR_PhaseBiasSignalList_r16_sequence_of[1] = {
  { &hf_lpp_SSR_PhaseBiasSignalList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_PhaseBiasSignalElement_r16 },
};

static int
dissect_lpp_SSR_PhaseBiasSignalList_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SSR_PhaseBiasSignalList_r16, SSR_PhaseBiasSignalList_r16_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const per_sequence_t SSR_PhaseBiasSatElement_r16_sequence[] = {
  { &hf_lpp_svID_r16        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_ssr_PhaseBiasSignalList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_PhaseBiasSignalList_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_PhaseBiasSatElement_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SSR_PhaseBiasSatElement_r16, SSR_PhaseBiasSatElement_r16_sequence);

  return offset;
}


static const per_sequence_t SSR_PhaseBiasSatList_r16_sequence_of[1] = {
  { &hf_lpp_SSR_PhaseBiasSatList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_PhaseBiasSatElement_r16 },
};

static int
dissect_lpp_SSR_PhaseBiasSatList_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SSR_PhaseBiasSatList_r16, SSR_PhaseBiasSatList_r16_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GNSS_SSR_PhaseBias_r16_sequence[] = {
  { &hf_lpp_epochTime_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SystemTime },
  { &hf_lpp_ssrUpdateInterval_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_iod_ssr_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_ssr_PhaseBiasSatList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SSR_PhaseBiasSatList_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_PhaseBias_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_PhaseBias_r16, GNSS_SSR_PhaseBias_r16_sequence);

  return offset;
}


static const per_sequence_t STEC_IntegrityErrorBounds_r17_sequence[] = {
  { &hf_lpp_meanIonosphere_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_stdDevIonosphere_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_meanIonosphereRate_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_stdDevIonosphereRate_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_STEC_IntegrityErrorBounds_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_STEC_IntegrityErrorBounds_r17, STEC_IntegrityErrorBounds_r17_sequence);

  return offset;
}


static const per_sequence_t STEC_SatElement_r16_eag_1_sequence[] = {
  { &hf_lpp_stec_IntegrityErrorBounds_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_STEC_IntegrityErrorBounds_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_STEC_SatElement_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, STEC_SatElement_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t STEC_SatElement_r16_sequence[] = {
  { &hf_lpp_svID_r16        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_stecQualityIndicator_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_BIT_STRING_SIZE_6 },
  { &hf_lpp_stec_C00_r16    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8192_8191 },
  { &hf_lpp_stec_C01_r16    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M2048_2047 },
  { &hf_lpp_stec_C10_r16    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M2048_2047 },
  { &hf_lpp_stec_C11_r16    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_M512_511 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_STEC_SatElement_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_STEC_SatElement_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_STEC_SatElement_r16, STEC_SatElement_r16_sequence);

  return offset;
}


static const per_sequence_t STEC_SatList_r16_sequence_of[1] = {
  { &hf_lpp_STEC_SatList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_STEC_SatElement_r16 },
};

static int
dissect_lpp_STEC_SatList_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_STEC_SatList_r16, STEC_SatList_r16_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_1_256(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 256U, NULL, FALSE);

  return offset;
}



static int
dissect_lpp_INTEGER_1_255(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 255U, NULL, FALSE);

  return offset;
}


static const per_sequence_t STEC_IntegrityParameters_r17_sequence[] = {
  { &hf_lpp_probOnsetIonoFault_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_meanIonoFaultDuration_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_256 },
  { &hf_lpp_ionoRangeErrorCorrelationTime_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_255 },
  { &hf_lpp_ionoRangeRateErrorCorrelationTime_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_STEC_IntegrityParameters_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_STEC_IntegrityParameters_r17, STEC_IntegrityParameters_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_STEC_Correction_r16_eag_1_sequence[] = {
  { &hf_lpp_stec_IntegrityParameters_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_STEC_IntegrityParameters_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_STEC_Correction_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_STEC_Correction_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_STEC_Correction_r16_sequence[] = {
  { &hf_lpp_epochTime_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SystemTime },
  { &hf_lpp_ssrUpdateInterval_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_iod_ssr_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_correctionPointSetID_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_16383 },
  { &hf_lpp_stec_SatList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_STEC_SatList_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_STEC_Correction_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_STEC_Correction_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_STEC_Correction_r16, GNSS_SSR_STEC_Correction_r16_sequence);

  return offset;
}


static const per_sequence_t TropoDelayIntegrityErrorBounds_r17_sequence[] = {
  { &hf_lpp_meanTroposphereVerticalHydroStaticDelay_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_stdDevTroposphereVerticalHydroStaticDelay_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_meanTroposphereVerticalWetDelay_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_stdDevTroposphereVerticalWetDelay_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_meanTroposphereVerticalHydroStaticDelayRate_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_stdDevTroposphereVerticalHydroStaticDelayRate_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_meanTroposphereVerticalWetDelayRate_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_stdDevTroposphereVerticalWetDelayRate_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_TropoDelayIntegrityErrorBounds_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_TropoDelayIntegrityErrorBounds_r17, TropoDelayIntegrityErrorBounds_r17_sequence);

  return offset;
}


static const per_sequence_t TropospericDelayCorrection_r16_eag_1_sequence[] = {
  { &hf_lpp_tropoDelayIntegrityErrorBounds_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_TropoDelayIntegrityErrorBounds_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_TropospericDelayCorrection_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, TropospericDelayCorrection_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t TropospericDelayCorrection_r16_sequence[] = {
  { &hf_lpp_tropoHydroStaticVerticalDelay_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M256_255 },
  { &hf_lpp_tropoWetVerticalDelay_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_TropospericDelayCorrection_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_TropospericDelayCorrection_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_TropospericDelayCorrection_r16, TropospericDelayCorrection_r16_sequence);

  return offset;
}


static const value_string lpp_T_stecResidualCorrection_r16_vals[] = {
  {   0, "b7-r16" },
  {   1, "b16-r16" },
  { 0, NULL }
};

static const per_choice_t T_stecResidualCorrection_r16_choice[] = {
  {   0, &hf_lpp_b7_r16          , ASN1_NO_EXTENSIONS     , dissect_lpp_INTEGER_M64_63 },
  {   1, &hf_lpp_b16_r16         , ASN1_NO_EXTENSIONS     , dissect_lpp_INTEGER_M32768_32767 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_stecResidualCorrection_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_stecResidualCorrection_r16, T_stecResidualCorrection_r16_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t STEC_ResidualSatElement_r16_sequence[] = {
  { &hf_lpp_svID_r16        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_stecResidualCorrection_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_stecResidualCorrection_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_STEC_ResidualSatElement_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_STEC_ResidualSatElement_r16, STEC_ResidualSatElement_r16_sequence);

  return offset;
}


static const per_sequence_t STEC_ResidualSatList_r16_sequence_of[1] = {
  { &hf_lpp_STEC_ResidualSatList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_STEC_ResidualSatElement_r16 },
};

static int
dissect_lpp_STEC_ResidualSatList_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_STEC_ResidualSatList_r16, STEC_ResidualSatList_r16_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t GridElement_r16_sequence[] = {
  { &hf_lpp_tropospericDelayCorrection_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_TropospericDelayCorrection_r16 },
  { &hf_lpp_stec_ResidualSatList_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_STEC_ResidualSatList_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GridElement_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GridElement_r16, GridElement_r16_sequence);

  return offset;
}


static const per_sequence_t GridList_r16_sequence_of[1] = {
  { &hf_lpp_GridList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GridElement_r16 },
};

static int
dissect_lpp_GridList_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GridList_r16, GridList_r16_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t SSR_GriddedCorrectionIntegrityParameters_r17_sequence[] = {
  { &hf_lpp_probOnsetTroposphereFault_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_meanTroposphereFaultDuration_r17, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_1_256 },
  { &hf_lpp_troposphereRangeErrorCorrelationTime_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_255 },
  { &hf_lpp_troposphereRangeRateErrorCorrelationTime_r17, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_255 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_SSR_GriddedCorrectionIntegrityParameters_r17(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_SSR_GriddedCorrectionIntegrityParameters_r17, SSR_GriddedCorrectionIntegrityParameters_r17_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_GriddedCorrection_r16_eag_1_sequence[] = {
  { &hf_lpp_ssr_GriddedCorrectionIntegrityParameters_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SSR_GriddedCorrectionIntegrityParameters_r17 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_GriddedCorrection_r16_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_SSR_GriddedCorrection_r16_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_SSR_GriddedCorrection_r16_sequence[] = {
  { &hf_lpp_epochTime_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SystemTime },
  { &hf_lpp_ssrUpdateInterval_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_iod_ssr_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_troposphericDelayQualityIndicator_r16, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_BIT_STRING_SIZE_6 },
  { &hf_lpp_correctionPointSetID_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_16383 },
  { &hf_lpp_gridList_r16    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GridList_r16 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_SSR_GriddedCorrection_r16_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_SSR_GriddedCorrection_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_SSR_GriddedCorrection_r16, GNSS_SSR_GriddedCorrection_r16_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_50400(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 50400U, NULL, FALSE);

  return offset;
}


static const per_sequence_t NavIC_EDC_r16_sequence[] = {
  { &hf_lpp_navic_AlphaEDC_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8192_8191 },
  { &hf_lpp_navic_BetaEDC_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M8192_8191 },
  { &hf_lpp_navic_GammaEDC_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16384_16383 },
  { &hf_lpp_navic_AoIcorrection_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2048_2047 },
  { &hf_lpp_navic_AoRAcorrection_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2048_2047 },
  { &hf_lpp_navic_SemiMajorcorrection_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M2048_2047 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavIC_EDC_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_EDC_r16, NavIC_EDC_r16_sequence);

  return offset;
}


static const per_sequence_t NavIC_CDC_r16_sequence[] = {
  { &hf_lpp_navic_ClockBiasCorrection_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M4096_4095 },
  { &hf_lpp_navic_ClockDriftCorrection_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M128_127 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavIC_CDC_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_CDC_r16, NavIC_CDC_r16_sequence);

  return offset;
}


static const per_sequence_t NavIC_CorrectionElementAutoNav_r16_sequence[] = {
  { &hf_lpp_svID            , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_SV_ID },
  { &hf_lpp_navic_Tod_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_65535 },
  { &hf_lpp_navic_iodec_r16 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_255 },
  { &hf_lpp_navic_UDRAI_r16 , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16_15 },
  { &hf_lpp_navic_UDRArateI_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_M16_15 },
  { &hf_lpp_navic_EDC_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NavIC_EDC_r16 },
  { &hf_lpp_navic_CDC_r16   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NavIC_CDC_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavIC_CorrectionElementAutoNav_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_CorrectionElementAutoNav_r16, NavIC_CorrectionElementAutoNav_r16_sequence);

  return offset;
}


static const per_sequence_t NavIC_CorrectionListAutoNav_r16_sequence_of[1] = {
  { &hf_lpp_NavIC_CorrectionListAutoNav_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_NavIC_CorrectionElementAutoNav_r16 },
};

static int
dissect_lpp_NavIC_CorrectionListAutoNav_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_NavIC_CorrectionListAutoNav_r16, NavIC_CorrectionListAutoNav_r16_sequence_of,
                                                  1, 64, FALSE);

  return offset;
}


static const per_sequence_t NavIC_DifferentialCorrections_r16_sequence[] = {
  { &hf_lpp_navic_RefTOWC_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_50400 },
  { &hf_lpp_navic_CorrectionListAutoNav_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_NavIC_CorrectionListAutoNav_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavIC_DifferentialCorrections_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_DifferentialCorrections_r16, NavIC_DifferentialCorrections_r16_sequence);

  return offset;
}


static const per_sequence_t RegionIgpElement_r16_sequence[] = {
  { &hf_lpp_regionID_r16    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givei1_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd1_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei2_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd2_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei3_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd3_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei4_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd4_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei5_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd5_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei6_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd6_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei7_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd7_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei8_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd8_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei9_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd9_r16       , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei10_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd10_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei11_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd11_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei12_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd12_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei13_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd13_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei14_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd14_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { &hf_lpp_givei15_r16     , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_15 },
  { &hf_lpp_givd15_r16      , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_511 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_RegionIgpElement_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_RegionIgpElement_r16, RegionIgpElement_r16_sequence);

  return offset;
}


static const per_sequence_t RegionIgpList_r16_sequence_of[1] = {
  { &hf_lpp_RegionIgpList_r16_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_RegionIgpElement_r16 },
};

static int
dissect_lpp_RegionIgpList_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_RegionIgpList_r16, RegionIgpList_r16_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const per_sequence_t NavIC_GridModelParameter_r16_sequence[] = {
  { &hf_lpp_navic_RefTOWC_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_50400 },
  { &hf_lpp_regionMasked_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_1023 },
  { &hf_lpp_regionIgpList_r16, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_RegionIgpList_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_NavIC_GridModelParameter_r16(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_NavIC_GridModelParameter_r16, NavIC_GridModelParameter_r16_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataElement_eag_3_sequence[] = {
  { &hf_lpp_gnss_SSR_URA_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_URA_r16 },
  { &hf_lpp_gnss_SSR_PhaseBias_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_PhaseBias_r16 },
  { &hf_lpp_gnss_SSR_STEC_Correction_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_STEC_Correction_r16 },
  { &hf_lpp_gnss_SSR_GriddedCorrection_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_SSR_GriddedCorrection_r16 },
  { &hf_lpp_navic_DifferentialCorrections_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NavIC_DifferentialCorrections_r16 },
  { &hf_lpp_navic_GridModel_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_NavIC_GridModelParameter_r16 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataElement_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_GenericAssistDataElement_eag_3_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistDataElement_sequence[] = {
  { &hf_lpp_gnss_ID         , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_ID },
  { &hf_lpp_sbas_ID         , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_SBAS_ID },
  { &hf_lpp_gnss_TimeModels , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_TimeModelList },
  { &hf_lpp_gnss_DifferentialCorrections, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_DifferentialCorrections },
  { &hf_lpp_gnss_NavigationModel, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_NavigationModel },
  { &hf_lpp_gnss_RealTimeIntegrity, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_RealTimeIntegrity },
  { &hf_lpp_gnss_DataBitAssistance, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_DataBitAssistance },
  { &hf_lpp_gnss_AcquisitionAssistance, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AcquisitionAssistance },
  { &hf_lpp_gnss_Almanac    , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_Almanac },
  { &hf_lpp_gnss_UTC_Model  , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_UTC_Model },
  { &hf_lpp_gnss_AuxiliaryInformation, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_AuxiliaryInformation },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataElement_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataElement_eag_2 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataElement_eag_3 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_GenericAssistDataElement(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_GenericAssistDataElement, GNSS_GenericAssistDataElement_sequence);

  return offset;
}


static const per_sequence_t GNSS_GenericAssistData_sequence_of[1] = {
  { &hf_lpp_GNSS_GenericAssistData_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_GenericAssistDataElement },
};

static int
dissect_lpp_GNSS_GenericAssistData(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_GNSS_GenericAssistData, GNSS_GenericAssistData_sequence_of,
                                                  1, 16, FALSE);

  return offset;
}


static const value_string lpp_T_cause_02_vals[] = {
  {   0, "undefined" },
  {   1, "undeliveredAssistanceDataIsNotSupportedByServer" },
  {   2, "undeliveredAssistanceDataIsSupportedButCurrentlyNotAvailableByServer" },
  {   3, "undeliveredAssistanceDataIsPartlyNotSupportedAndPartlyNotAvailableByServer" },
  {   4, "unconfirmedPeriodicAssistanceDataIsNotSupported-v1510" },
  {   5, "unconfirmedPeriodicAssistanceDataIsSupportedButCurrentlyNotAvailable-v1510" },
  {   6, "unconfirmedPeriodicAssistanceDataIsPartlyNotSupportedAndPartlyNotAvailable-v1510" },
  {   7, "undeliveredPeriodicAssistanceDataIsCurrentlyNotAvailable-v1510" },
  { 0, NULL }
};


static int
dissect_lpp_T_cause_02(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 4, NULL);

  return offset;
}


static const per_sequence_t GNSS_LocationServerErrorCauses_sequence[] = {
  { &hf_lpp_cause_02        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_cause_02 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_LocationServerErrorCauses(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_LocationServerErrorCauses, GNSS_LocationServerErrorCauses_sequence);

  return offset;
}


static const value_string lpp_T_cause_03_vals[] = {
  {   0, "undefined" },
  {   1, "thereWereNotEnoughSatellitesReceived" },
  {   2, "assistanceDataMissing" },
  {   3, "notAllRequestedMeasurementsPossible" },
  { 0, NULL }
};


static int
dissect_lpp_T_cause_03(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 0, NULL);

  return offset;
}


static const per_sequence_t GNSS_TargetDeviceErrorCauses_sequence[] = {
  { &hf_lpp_cause_03        , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_cause_03 },
  { &hf_lpp_fineTimeAssistanceMeasurementsNotPossible, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NULL },
  { &hf_lpp_adrMeasurementsNotPossible, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NULL },
  { &hf_lpp_multiFrequencyMeasurementsNotPossible, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_NULL },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_TargetDeviceErrorCauses(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_TargetDeviceErrorCauses, GNSS_TargetDeviceErrorCauses_sequence);

  return offset;
}


static const value_string lpp_A_GNSS_Error_vals[] = {
  {   0, "locationServerErrorCauses" },
  {   1, "targetDeviceErrorCauses" },
  { 0, NULL }
};

static const per_choice_t A_GNSS_Error_choice[] = {
  {   0, &hf_lpp_locationServerErrorCauses_01, ASN1_EXTENSION_ROOT    , dissect_lpp_GNSS_LocationServerErrorCauses },
  {   1, &hf_lpp_targetDeviceErrorCauses_01, ASN1_EXTENSION_ROOT    , dissect_lpp_GNSS_TargetDeviceErrorCauses },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_A_GNSS_Error(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_A_GNSS_Error, A_GNSS_Error_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t GNSS_PeriodicAssistData_r15_eag_1_sequence[] = {
  { &hf_lpp_gnss_SSR_PeriodicURA_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicPhaseBias_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicSTEC_Correction_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicGriddedCorrection_r16, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_PeriodicAssistData_r15_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_PeriodicAssistData_r15_eag_1_sequence);

  return offset;
}


static const per_sequence_t GNSS_PeriodicAssistData_r15_eag_2_sequence[] = {
  { &hf_lpp_gnss_Integrity_PeriodicServiceAlert_r17, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_PeriodicAssistData_r15_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, GNSS_PeriodicAssistData_r15_eag_2_sequence);

  return offset;
}


static const per_sequence_t GNSS_PeriodicAssistData_r15_sequence[] = {
  { &hf_lpp_gnss_RTK_PeriodicObservations_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_glo_RTK_PeriodicBiasInformation_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_RTK_MAC_PeriodicCorrectionDifferences_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_RTK_PeriodicResiduals_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_RTK_FKP_PeriodicGradients_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicOrbitCorrections_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicClockCorrections_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &hf_lpp_gnss_SSR_PeriodicCodeBias_r15, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicControlParam_r15 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_PeriodicAssistData_r15_eag_1 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_GNSS_PeriodicAssistData_r15_eag_2 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_GNSS_PeriodicAssistData_r15(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_GNSS_PeriodicAssistData_r15, GNSS_PeriodicAssistData_r15_sequence);

  return offset;
}


static const per_sequence_t A_GNSS_ProvideAssistanceData_eag_1_sequence[] = {
  { &hf_lpp_gnss_PeriodicAssistData_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_GNSS_PeriodicAssistData_r15 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_ProvideAssistanceData_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, A_GNSS_ProvideAssistanceData_eag_1_sequence);

  return offset;
}


static const per_sequence_t A_GNSS_ProvideAssistanceData_sequence[] = {
  { &hf_lpp_gnss_CommonAssistData, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_CommonAssistData },
  { &hf_lpp_gnss_GenericAssistData, ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_GNSS_GenericAssistData },
  { &hf_lpp_gnss_Error      , ASN1_EXTENSION_ROOT    , ASN1_OPTIONAL    , dissect_lpp_A_GNSS_Error },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_A_GNSS_ProvideAssistanceData_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_A_GNSS_ProvideAssistanceData(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_A_GNSS_ProvideAssistanceData, A_GNSS_ProvideAssistanceData_sequence);

  return offset;
}


static const value_string lpp_T_antennaPortConfig_vals[] = {
  {   0, "ports1-or-2" },
  {   1, "ports4" },
  { 0, NULL }
};


static int
dissect_lpp_T_antennaPortConfig(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string lpp_T_cpLength_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_lpp_T_cpLength(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string lpp_T_prs_Bandwidth_vals[] = {
  {   0, "n6" },
  {   1, "n15" },
  {   2, "n25" },
  {   3, "n50" },
  {   4, "n75" },
  {   5, "n100" },
  { 0, NULL }
};


static int
dissect_lpp_T_prs_Bandwidth(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_0_4095(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 4095U, NULL, FALSE);

  return offset;
}


static const value_string lpp_T_numDL_Frames_vals[] = {
  {   0, "sf-1" },
  {   1, "sf-2" },
  {   2, "sf-4" },
  {   3, "sf-6" },
  {   4, "sf-add-v1420" },
  { 0, NULL }
};


static int
dissect_lpp_T_numDL_Frames(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     4, NULL, TRUE, 1, NULL);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_128(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     128, 128, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_256(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     256, 256, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_512(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     512, 512, FALSE, NULL, 0, NULL, NULL);

  return offset;
}



static int
dissect_lpp_BIT_STRING_SIZE_1024(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_bit_string(tvb, offset, actx, tree, hf_index,
                                     1024, 1024, FALSE, NULL, 0, NULL, NULL);

  return offset;
}


static const value_string lpp_T_prs_MutingInfo_r9_vals[] = {
  {   0, "po2-r9" },
  {   1, "po4-r9" },
  {   2, "po8-r9" },
  {   3, "po16-r9" },
  {   4, "po32-v1420" },
  {   5, "po64-v1420" },
  {   6, "po128-v1420" },
  {   7, "po256-v1420" },
  {   8, "po512-v1420" },
  {   9, "po1024-v1420" },
  { 0, NULL }
};

static const per_choice_t T_prs_MutingInfo_r9_choice[] = {
  {   0, &hf_lpp_po2_r9          , ASN1_EXTENSION_ROOT    , dissect_lpp_BIT_STRING_SIZE_2 },
  {   1, &hf_lpp_po4_r9          , ASN1_EXTENSION_ROOT    , dissect_lpp_BIT_STRING_SIZE_4 },
  {   2, &hf_lpp_po8_r9          , ASN1_EXTENSION_ROOT    , dissect_lpp_BIT_STRING_SIZE_8 },
  {   3, &hf_lpp_po16_r9         , ASN1_EXTENSION_ROOT    , dissect_lpp_BIT_STRING_SIZE_16 },
  {   4, &hf_lpp_po32_v1420      , ASN1_NOT_EXTENSION_ROOT, dissect_lpp_BIT_STRING_SIZE_32 },
  {   5, &hf_lpp_po64_v1420      , ASN1_NOT_EXTENSION_ROOT, dissect_lpp_BIT_STRING_SIZE_64 },
  {   6, &hf_lpp_po128_v1420     , ASN1_NOT_EXTENSION_ROOT, dissect_lpp_BIT_STRING_SIZE_128 },
  {   7, &hf_lpp_po256_v1420     , ASN1_NOT_EXTENSION_ROOT, dissect_lpp_BIT_STRING_SIZE_256 },
  {   8, &hf_lpp_po512_v1420     , ASN1_NOT_EXTENSION_ROOT, dissect_lpp_BIT_STRING_SIZE_512 },
  {   9, &hf_lpp_po1024_v1420    , ASN1_NOT_EXTENSION_ROOT, dissect_lpp_BIT_STRING_SIZE_1024 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_prs_MutingInfo_r9(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_prs_MutingInfo_r9, T_prs_MutingInfo_r9_choice,
                                 NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_1_160(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            1U, 160U, NULL, FALSE);

  return offset;
}


static const value_string lpp_T_prsOccGroupLen_r14_vals[] = {
  {   0, "g2" },
  {   1, "g4" },
  {   2, "g8" },
  {   3, "g16" },
  {   4, "g32" },
  {   5, "g64" },
  {   6, "g128" },
  { 0, NULL }
};


static int
dissect_lpp_T_prsOccGroupLen_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, TRUE, 0, NULL);

  return offset;
}



static int
dissect_lpp_INTEGER_0_maxAvailNarrowBands_Minus1_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, maxAvailNarrowBands_Minus1_r14, NULL, FALSE);

  return offset;
}


static const per_sequence_t T_nb4_r14_sequence_of[1] = {
  { &hf_lpp_nb4_r14_item    , ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_maxAvailNarrowBands_Minus1_r14 },
};

static int
dissect_lpp_T_nb4_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_T_nb4_r14, T_nb4_r14_sequence_of,
                                                  3, 3, FALSE);

  return offset;
}


static const value_string lpp_T_prsHoppingInfo_r14_vals[] = {
  {   0, "nb2-r14" },
  {   1, "nb4-r14" },
  { 0, NULL }
};

static const per_choice_t T_prsHoppingInfo_r14_choice[] = {
  {   0, &hf_lpp_nb2_r14         , ASN1_NO_EXTENSIONS     , dissect_lpp_INTEGER_0_maxAvailNarrowBands_Minus1_r14 },
  {   1, &hf_lpp_nb4_r14         , ASN1_NO_EXTENSIONS     , dissect_lpp_T_nb4_r14 },
  { 0, NULL, 0, NULL }
};

static int
dissect_lpp_T_prsHoppingInfo_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_choice(tvb, offset, actx, tree, hf_index,
                                 ett_lpp_T_prsHoppingInfo_r14, T_prsHoppingInfo_r14_choice,
                                 NULL);

  return offset;
}


static const per_sequence_t PRS_Info_eag_1_sequence[] = {
  { &hf_lpp_prsID_r14       , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_4095 },
  { &hf_lpp_add_numDL_Frames_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_1_160 },
  { &hf_lpp_prsOccGroupLen_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_prsOccGroupLen_r14 },
  { &hf_lpp_prsHoppingInfo_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_prsHoppingInfo_r14 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_Info_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, PRS_Info_eag_1_sequence);

  return offset;
}


static const per_sequence_t PRS_Info_sequence[] = {
  { &hf_lpp_prs_Bandwidth   , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_prs_Bandwidth },
  { &hf_lpp_prs_ConfigurationIndex, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_INTEGER_0_4095 },
  { &hf_lpp_numDL_Frames    , ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_numDL_Frames },
  { &hf_lpp_prs_MutingInfo_r9, ASN1_NOT_EXTENSION_ROOT, ASN1_OPTIONAL    , dissect_lpp_T_prs_MutingInfo_r9 },
  { &dummy_hf_lpp_eag_field , ASN1_NOT_EXTENSION_ROOT, ASN1_NOT_OPTIONAL, dissect_lpp_PRS_Info_eag_1 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_PRS_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_PRS_Info, PRS_Info_sequence);

  return offset;
}


static const per_sequence_t OTDOA_ReferenceCellInfo_eag_1_sequence[] = {
  { &hf_lpp_earfcnRef_v9a0  , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_ARFCN_ValueEUTRA_v9a0 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_OTDOA_ReferenceCellInfo_eag_1(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, OTDOA_ReferenceCellInfo_eag_1_sequence);

  return offset;
}


static const value_string lpp_T_cpLengthCRS_r14_vals[] = {
  {   0, "normal" },
  {   1, "extended" },
  { 0, NULL }
};


static int
dissect_lpp_T_cpLengthCRS_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     2, NULL, TRUE, 0, NULL);

  return offset;
}


static const value_string lpp_T_dlBandwidth_r14_vals[] = {
  {   0, "n6" },
  {   1, "n15" },
  {   2, "n25" },
  {   3, "n50" },
  {   4, "n75" },
  {   5, "n100" },
  { 0, NULL }
};


static int
dissect_lpp_T_dlBandwidth_r14(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     6, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t SEQUENCE_SIZE_1_maxAddPRSconfig_r14_OF_PRS_Info_sequence_of[1] = {
  { &hf_lpp_addPRSconfigRef_r14_item, ASN1_NO_EXTENSIONS     , ASN1_NOT_OPTIONAL, dissect_lpp_PRS_Info },
};

static int
dissect_lpp_SEQUENCE_SIZE_1_maxAddPRSconfig_r14_OF_PRS_Info(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_sequence_of(tvb, offset, actx, tree, hf_index,
                                                  ett_lpp_SEQUENCE_SIZE_1_maxAddPRSconfig_r14_OF_PRS_Info, SEQUENCE_SIZE_1_maxAddPRSconfig_r14_OF_PRS_Info_sequence_of,
                                                  1, maxAddPRSconfig_r14, FALSE);

  return offset;
}


static const per_sequence_t OTDOA_ReferenceCellInfo_eag_2_sequence[] = {
  { &hf_lpp_tpId_r14        , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_4095 },
  { &hf_lpp_cpLengthCRS_r14 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_cpLengthCRS_r14 },
  { &hf_lpp_sameMBSFNconfigRef_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_BOOLEAN },
  { &hf_lpp_dlBandwidth_r14 , ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_T_dlBandwidth_r14 },
  { &hf_lpp_addPRSconfigRef_r14, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_SEQUENCE_SIZE_1_maxAddPRSconfig_r14_OF_PRS_Info },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_OTDOA_ReferenceCellInfo_eag_2(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, OTDOA_ReferenceCellInfo_eag_2_sequence);

  return offset;
}


static const per_sequence_t OTDOA_ReferenceCellInfo_eag_3_sequence[] = {
  { &hf_lpp_nr_LTE_SFN_Offset_r15, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_INTEGER_0_1023 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_OTDOA_ReferenceCellInfo_eag_3(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence_eag(tvb, offset, actx, tree, OTDOA_ReferenceCellInfo_eag_3_sequence);

  return offset;
}


static const value_string lpp_T_subframeAssignment_v1520_vals[] = {
  {   0, "sa0" },
  {   1, "sa1" },
  {   2, "sa2" },
  {   3, "sa3" },
  {   4, "sa4" },
  {   5, "sa5" },
  {   6, "sa6" },
  { 0, NULL }
};


static int
dissect_lpp_T_subframeAssignment_v1520(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_enumerated(tvb, offset, actx, tree, hf_index,
                                     7, NULL, FALSE, 0, NULL);

  return offset;
}


static const per_sequence_t TDD_Config_v1520_sequence[] = {
  { &hf_lpp_subframeAssignment_v1520, ASN1_EXTENSION_ROOT    , ASN1_NOT_OPTIONAL, dissect_lpp_T_subframeAssignment_v1520 },
  { NULL, 0, 0, NULL }
};

static int
dissect_lpp_TDD_Config_v1520(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_sequence(tvb, offset, actx, tree, hf_index,
                                   ett_lpp_TDD_Config_v1520, TDD_Config_v1520_sequence);

  return offset;
}



static int
dissect_lpp_INTEGER_0_19(tvbuff_t *tvb _U_, int offset _U_, asn1_ctx_t *actx _U_, proto_tree *tree _U_, int hf_index _U_) {
  offset = dissect_per_constrained_integer(tvb, offset, actx, tree, hf_index,
                                                            0U, 19U, NULL, FALSE);

  return offset;
}


static const per_sequence_t OTDOA_ReferenceCellInfo_eag_4_sequence[] = {
  { &hf_lpp_tdd_config_v1520, ASN1_NO_EXTENSIONS     , ASN1_OPTIONAL    , dissect_lpp_TDD_Config_v1520 },
  { &hf_lpp_nr_LTE_fineTiming_Offset_r15, ASN1_NO_EXTENSI