/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.writers;

import com.sun.xml.stream.PropertyManager;
import com.sun.xml.stream.util.ReadOnlyIterator;
import com.sun.xml.stream.writers.WriterUtility;
import com.sun.xml.stream.xerces.util.NamespaceSupport;
import com.sun.xml.stream.xerces.util.SymbolTable;
import com.sun.xml.stream.xerces.xni.QName;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLStreamWriterImpl
extends WriterUtility
implements XMLStreamWriter {
    private OutputStream fOutputStream;
    private String fEncoding;
    private ElementStack fElementStack = new ElementStack();
    private boolean fStartTagOpened = false;
    private ElementState fCurrentElementState = null;
    private ElementState fillElementState = null;
    private NamespaceSupport fInternalNamespaceContext = null;
    private boolean fIsRepairingNamespace = false;
    private ArrayList fNamespaceDecls = null;
    private Random fPrefixGen = null;
    private PropertyManager fPropertyManager = null;
    private SymbolTable fSymbolTable = new SymbolTable();
    private ArrayList fAttributeCache = null;
    private String DEFAULT_PREFIX = null;
    private static final boolean DEBUG = false;
    private NamespaceContextImpl fNamespaceContext = null;
    private static ReadOnlyIterator fReadOnlyIterator = new ReadOnlyIterator();

    public void close() throws XMLStreamException {
        try {
            this.fWriter.close();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    private void closeStartTag() throws XMLStreamException {
        try {
            this.fCurrentElementState = this.fElementStack.peek();
            if (this.fIsRepairingNamespace) {
                this.repair();
                this.correctPrefix(this.fCurrentElementState);
                if (this.fCurrentElementState.prefix != null && this.fCurrentElementState.prefix != "") {
                    this.fWriter.write(this.fCurrentElementState.prefix);
                    this.fWriter.write(":");
                }
                this.fWriter.write(this.fCurrentElementState.localpart);
                int n = this.fNamespaceDecls.size();
                QName qName = null;
                int n2 = 0;
                while (n2 < n) {
                    qName = (QName)this.fNamespaceDecls.get(n2);
                    if (qName != null) {
                        this.fInternalNamespaceContext.declarePrefix(qName.prefix, qName.uri);
                        this.writenamespace(qName.prefix, qName.uri);
                    }
                    ++n2;
                }
                this.fNamespaceDecls.clear();
                Attribute attribute = null;
                int n3 = 0;
                while (n3 < this.fAttributeCache.size()) {
                    String string;
                    attribute = (Attribute)this.fAttributeCache.get(n3);
                    if (attribute.prefix != null && attribute.uri != null && ((string = this.fInternalNamespaceContext.getPrefix(attribute.uri)) == null || string != attribute.prefix)) {
                        this.fInternalNamespaceContext.declarePrefix(attribute.prefix, attribute.uri);
                        this.writenamespace(attribute.prefix, attribute.uri);
                    }
                    this.writeAttributeWithPrefix(attribute.prefix, attribute.localpart, attribute.value);
                    ++n3;
                }
                this.fAttributeCache.clear();
            }
            if (this.fCurrentElementState.isEmpty) {
                this.fElementStack.pop();
                this.fWriter.write("/>");
            } else {
                this.fWriter.write(62);
            }
            this.fStartTagOpened = false;
        }
        catch (IOException iOException) {
            this.fStartTagOpened = false;
            throw new XMLStreamException(iOException);
        }
    }

    public void flush() throws XMLStreamException {
        try {
            this.fWriter.flush();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    private void init() {
        this.fPropertyManager.setProperty("http://apache.org/xml/properties/internal/symbol-table", this.fSymbolTable);
        this.fNamespaceDecls = new ArrayList();
        this.fPrefixGen = new Random();
        if (this.fPropertyManager != null) {
            Boolean bl = (Boolean)this.fPropertyManager.getProperty("javax.xml.stream.isRepairingNamespaces");
            this.fIsRepairingNamespace = bl;
            bl = (Boolean)this.fPropertyManager.getProperty("escapeCharacters");
            this.setEscapeCharacters(bl);
        }
        this.fAttributeCache = new ArrayList();
        this.fInternalNamespaceContext = new NamespaceSupport();
        this.fInternalNamespaceContext.reset();
        this.fNamespaceContext = new NamespaceContextImpl();
        this.fNamespaceContext.internalContext = this.fInternalNamespaceContext;
        this.DEFAULT_PREFIX = this.fSymbolTable.addSymbol("");
        this.fillElementState = new ElementState();
    }

    private void openStartTag() throws IOException {
        this.fStartTagOpened = true;
        this.fWriter.write(60);
    }

    void removeDuplicateDecls() {
        int n = 0;
        while (n < this.fNamespaceDecls.size()) {
            QName qName = (QName)this.fNamespaceDecls.get(n);
            int n2 = n + 1;
            while (n2 < this.fNamespaceDecls.size()) {
                QName qName2 = (QName)this.fNamespaceDecls.get(n2);
                if (qName != null && qName.equals(qName2)) {
                    this.fNamespaceDecls.set(n2, null);
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void repair() {
        int n;
        Attribute attribute = null;
        Attribute attribute2 = null;
        this.fCurrentElementState = this.fElementStack.peek();
        this.removeDuplicateDecls();
        int n2 = 0;
        while (n2 < this.fAttributeCache.size()) {
            attribute = (Attribute)this.fAttributeCache.get(n2);
            if (attribute.prefix != null && this.fCurrentElementState.prefix != null) {
                this.correctPrefix(this.fCurrentElementState, attribute);
            }
            ++n2;
        }
        if (!this.isDeclared(this.fCurrentElementState) && this.fCurrentElementState.prefix != null && this.fCurrentElementState.uri != null) {
            this.fNamespaceDecls.add(this.fCurrentElementState);
        }
        int n3 = 0;
        while (n3 < this.fAttributeCache.size()) {
            attribute = (Attribute)this.fAttributeCache.get(n3);
            n = n3 + 1;
            while (n < this.fAttributeCache.size()) {
                attribute2 = (Attribute)this.fAttributeCache.get(n);
                if (attribute.prefix == null && attribute2.prefix != null) {
                    this.correctPrefix(attribute, attribute2);
                }
                ++n;
            }
            ++n3;
        }
        this.repairNamespaceDecl(this.fCurrentElementState);
        n = 0;
        n = 0;
        while (n < this.fAttributeCache.size()) {
            attribute = (Attribute)this.fAttributeCache.get(n);
            this.repairNamespaceDecl(attribute);
            ++n;
        }
        QName qName = null;
        n = 0;
        while (n < this.fNamespaceDecls.size()) {
            qName = (QName)this.fNamespaceDecls.get(n);
            if (qName != null) {
                this.fInternalNamespaceContext.declarePrefix(qName.prefix, qName.uri);
            }
            ++n;
        }
        n = 0;
        while (n < this.fAttributeCache.size()) {
            attribute = (Attribute)this.fAttributeCache.get(n);
            this.correctPrefix(attribute);
            ++n;
        }
    }

    public void writeEndDocument() throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            ElementState elementState = null;
            while (!this.fElementStack.empty()) {
                elementState = this.fElementStack.pop();
                this.fInternalNamespaceContext.popContext();
                if (elementState.isEmpty) continue;
                this.fWriter.write("</");
                if (elementState.prefix != null && !elementState.prefix.equals("")) {
                    this.fWriter.write(elementState.prefix);
                    this.fWriter.write(":");
                }
                this.fWriter.write(elementState.localpart);
                this.fWriter.write(62);
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XMLStreamException("No more elements to write");
        }
    }

    public void writeEndElement() throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fCurrentElementState = this.fElementStack.pop();
            if (this.fCurrentElementState == null) {
                throw new XMLStreamException("No element was found to write");
            }
            if (this.fCurrentElementState.isEmpty) {
                return;
            }
            this.fWriter.write("</");
            if (this.fCurrentElementState.prefix != null && !this.fCurrentElementState.prefix.equals("")) {
                this.fWriter.write(this.fCurrentElementState.prefix);
                this.fWriter.write(":");
            }
            this.fWriter.write(this.fCurrentElementState.localpart);
            this.fWriter.write(62);
            this.fInternalNamespaceContext.popContext();
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new XMLStreamException("No element was found to write");
        }
    }

    public void writeStartDocument() throws XMLStreamException {
        try {
            this.fWriter.write("<?xml version=\"1.0\" ?>");
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeCharacters(char[] cArray, int n, int n2) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.writeXMLContent(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    private void correctPrefix(QName qName) {
        String string = null;
        String string2 = qName.prefix;
        String string3 = qName.uri;
        if (string2 == null) {
            Object object;
            if (string3 == null) {
                return;
            }
            string3 = this.fSymbolTable.addSymbol(string3);
            QName qName2 = null;
            int n = 0;
            while (n < this.fNamespaceDecls.size()) {
                qName2 = (QName)this.fNamespaceDecls.get(n);
                if (qName2 != null && qName2.uri == qName.uri) {
                    qName.prefix = qName2.prefix;
                    return;
                }
                ++n;
            }
            string = this.fNamespaceContext.getPrefix(string3);
            if (string == "") {
                return;
            }
            if (string == null) {
                object = new StringBuffer("zdef");
                int n2 = 0;
                while (n2 < 1) {
                    ((StringBuffer)object).append(this.fPrefixGen.nextInt());
                    ++n2;
                }
                string2 = ((StringBuffer)object).toString();
                string2 = this.fSymbolTable.addSymbol(string2);
            } else {
                string2 = this.fSymbolTable.addSymbol(string);
            }
            if (string == null) {
                object = new QName();
                ((QName)object).setValues(string2, "xmlns", null, string3);
                this.fNamespaceDecls.add(object);
                this.fInternalNamespaceContext.declarePrefix(this.fSymbolTable.addSymbol(string2), string3);
            }
        }
        qName.prefix = string2;
    }

    void repairNamespaceDecl(QName qName) {
        QName qName2 = null;
        int n = 0;
        while (n < this.fNamespaceDecls.size()) {
            String string;
            qName2 = (QName)this.fNamespaceDecls.get(n);
            if (qName2 != null && qName.prefix != null && qName.prefix.equals(qName2.prefix) && !qName.uri.equals(qName2.uri) && (string = this.fNamespaceContext.getNamespaceURI(qName.prefix)) != null) {
                if (string.equals(qName.uri)) {
                    this.fNamespaceDecls.set(n, null);
                } else {
                    qName2.uri = qName.uri;
                }
            }
            ++n;
        }
    }

    boolean isDeclared(QName qName) {
        QName qName2 = null;
        int n = 0;
        while (n < this.fNamespaceDecls.size()) {
            qName2 = (QName)this.fNamespaceDecls.get(n);
            if (qName.prefix != null && qName.prefix == qName2.prefix && qName2.uri == qName.uri) {
                return true;
            }
            ++n;
        }
        return qName.uri != null && this.fNamespaceContext.getPrefix(qName.uri) != null;
    }

    public void setDefaultNamespace(String string) throws XMLStreamException {
        if (string != null) {
            string = this.fSymbolTable.addSymbol(string);
        }
        if (this.fIsRepairingNamespace) {
            if (this.isDefaultNamespace(string)) {
                return;
            }
            QName qName = new QName();
            qName.setValues(this.DEFAULT_PREFIX, "xmlns", null, string);
            this.fNamespaceDecls.add(qName);
            return;
        }
        this.fInternalNamespaceContext.declarePrefix(this.DEFAULT_PREFIX, string);
    }

    public void writeCData(String string) throws XMLStreamException {
        try {
            if (string == null) {
                throw new XMLStreamException("cdata cannot be null");
            }
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write("<![CDATA[");
            this.fWriter.write(string);
            this.fWriter.write("]]>");
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeCharacters(String string) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.writeXMLContent(string);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeComment(String string) throws XMLStreamException {
        try {
            this.fWriter.write("<!--");
            if (string != null) {
                this.fWriter.write(string);
            }
            this.fWriter.write("-->");
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeDTD(String string) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write(string);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeDefaultNamespace(String string) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Namespace Attribute not associated with any element");
            }
            if (this.fIsRepairingNamespace) {
                QName qName = new QName();
                qName.setValues("", "xmlns", null, string);
                this.fNamespaceDecls.add(qName);
                return;
            }
            this.fWriter.write(" ");
            this.fWriter.write("xmlns");
            this.fWriter.write("=");
            this.fWriter.write("\"");
            this.fWriter.write(string);
            this.fWriter.write("\"");
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeEmptyElement(String string) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            this.fElementStack.push(null, string, null, null, true);
            this.fInternalNamespaceContext.pushContext();
            if (this.fIsRepairingNamespace) {
                return;
            }
            this.fWriter.write(string);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeEntityRef(String string) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.fWriter.write(38);
            this.fWriter.write(string);
            this.fWriter.write(59);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeProcessingInstruction(String string) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            if (string != null) {
                this.fWriter.write("<?");
                this.fWriter.write(string);
                this.fWriter.write("?>");
                return;
            }
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
        throw new XMLStreamException("PI target cannot be null");
    }

    public void writeStartDocument(String string) throws XMLStreamException {
        try {
            if (string == null || string.equals("")) {
                this.writeStartDocument();
                return;
            }
            this.fWriter.write("<?xml version=\"");
            this.fWriter.write(string);
            this.fWriter.write("\"");
            this.fWriter.write("?>");
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeStartElement(String string) throws XMLStreamException {
        try {
            if (string == null) {
                throw new XMLStreamException("Local Name cannot be null");
            }
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            this.fElementStack.push(null, string, null, null, false);
            this.fInternalNamespaceContext.pushContext();
            if (this.fIsRepairingNamespace) {
                return;
            }
            this.fWriter.write(string);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    private boolean isDefaultNamespace(String string) {
        String string2 = this.fInternalNamespaceContext.getURI(this.DEFAULT_PREFIX);
        return string == string2;
    }

    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceContext;
    }

    public void setNamespaceContext(NamespaceContext namespaceContext) throws XMLStreamException {
        this.fNamespaceContext.userContext = namespaceContext;
    }

    public XMLStreamWriterImpl(OutputStream outputStream, PropertyManager propertyManager) {
        this.fOutputStream = outputStream;
        this.fWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.fPropertyManager = propertyManager;
        this.init();
    }

    public XMLStreamWriterImpl(Writer writer, PropertyManager propertyManager) {
        this.fWriter = writer;
        this.fPropertyManager = propertyManager;
        this.init();
    }

    void correctPrefix(QName qName, QName qName2) {
        String string = null;
        QName qName3 = null;
        boolean bl = false;
        if (qName.prefix.equals(qName2.prefix) && !qName.uri.equals(qName2.uri)) {
            string = this.fNamespaceContext.getPrefix(qName2.uri);
            if (string != null) {
                qName2.prefix = this.fSymbolTable.addSymbol(string);
            } else {
                qName3 = null;
                int n = 0;
                while (n < this.fNamespaceDecls.size()) {
                    qName3 = (QName)this.fNamespaceDecls.get(n);
                    if (qName3.uri == qName2.uri) {
                        qName2.prefix = qName3.prefix;
                        return;
                    }
                    ++n;
                }
                StringBuffer stringBuffer = new StringBuffer("zdef");
                int n2 = 0;
                while (n2 < 1) {
                    stringBuffer.append(this.fPrefixGen.nextInt());
                    ++n2;
                }
                string = stringBuffer.toString();
                qName2.prefix = string = this.fSymbolTable.addSymbol(string);
                QName qName4 = new QName();
                qName4.setValues(string, "xmlns", null, qName2.uri);
                this.fNamespaceDecls.add(qName4);
            }
        }
    }

    public Object getProperty(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (!this.fPropertyManager.containsProperty(string)) {
            throw new IllegalArgumentException(string + " is not supported");
        }
        return this.fPropertyManager.getProperty(string);
    }

    public String getPrefix(String string) throws XMLStreamException {
        return this.fNamespaceContext.getPrefix(string);
    }

    public void setPrefix(String string, String string2) throws XMLStreamException {
        if (string == null) {
            throw new XMLStreamException("Prefix cannot be null");
        }
        if (string2 == null) {
            throw new XMLStreamException("URI cannot be null");
        }
        string = this.fSymbolTable.addSymbol(string);
        string2 = this.fSymbolTable.addSymbol(string2);
        if (this.fIsRepairingNamespace) {
            String string3 = this.fInternalNamespaceContext.getURI(string);
            if (string3 != null && string3 == string2) {
                return;
            }
            if (this.checkUserNamespaceContext(string, string2)) {
                return;
            }
            QName qName = new QName();
            qName.setValues(string, "xmlns", null, string2);
            this.fNamespaceDecls.add(qName);
            return;
        }
        this.fInternalNamespaceContext.declarePrefix(string, string2);
    }

    public void writeAttribute(String string, String string2) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Attribute not associated with any element");
            }
            if (this.fIsRepairingNamespace) {
                Attribute attribute = new Attribute(string2);
                attribute.setValues(null, string, null, null);
                this.fAttributeCache.add(attribute);
                return;
            }
            this.fWriter.write(" ");
            this.fWriter.write(string);
            this.fWriter.write("=");
            this.fWriter.write("\"");
            this.writeXMLAttributeValue(string2);
            this.fWriter.write("\"");
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeEmptyElement(String string, String string2) throws XMLStreamException {
        if (string == null) {
            throw new XMLStreamException("NamespaceURI cannot be null");
        }
        string = this.fSymbolTable.addSymbol(string);
        String string3 = this.fNamespaceContext.getPrefix(string);
        this.writeEmptyElement(string3, string2, string);
    }

    public void writeNamespace(String string, String string2) throws XMLStreamException {
        try {
            QName qName = null;
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Namespace Attribute not associated with any element");
            }
            if (string == null || string.equals("")) {
                this.writeDefaultNamespace(string2);
                return;
            }
            if (string2 == null) {
                throw new XMLStreamException("Namespace`uri cannot be null");
            }
            string = this.fSymbolTable.addSymbol(string);
            string2 = this.fSymbolTable.addSymbol(string2);
            if (this.fIsRepairingNamespace) {
                String string3 = this.fInternalNamespaceContext.getURI(string);
                if (string3 != null && string3 == string2) {
                    return;
                }
                qName = new QName();
                qName.setValues(string, "xmlns", null, string2);
                this.fNamespaceDecls.add(qName);
                return;
            }
            String string4 = this.fInternalNamespaceContext.getURI(string);
            if (string4 == null || string4 == string2) {
                this.fInternalNamespaceContext.declarePrefix(string, string2);
            }
            this.writenamespace(string, string2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeProcessingInstruction(String string, String string2) throws XMLStreamException {
        try {
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            if (string == null || string2 == null) {
                throw new XMLStreamException("PI target cannot be null");
            }
            this.fWriter.write("<?");
            this.fWriter.write(string);
            this.fWriter.write(" ");
            this.fWriter.write(string2);
            this.fWriter.write("?>");
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeStartDocument(String string, String string2) throws XMLStreamException {
        try {
            if (string == null && string2 == null) {
                this.writeStartDocument();
                return;
            }
            if (string == null) {
                this.writeStartDocument(string2);
                return;
            }
            this.fWriter.write("<?xml version=\"");
            if (string2 == null || string2.equals("")) {
                this.fWriter.write("1.0");
            } else {
                this.fWriter.write(string2);
            }
            if (!string.equals("")) {
                this.fWriter.write("\" encoding=\"");
                this.fWriter.write(string);
            }
            this.fWriter.write(34);
            this.fWriter.write("?>");
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeStartElement(String string, String string2) throws XMLStreamException {
        if (string2 == null) {
            throw new XMLStreamException("Local Name cannot be null");
        }
        if (string == null) {
            throw new XMLStreamException("NamespaceURI cannot be null");
        }
        string = this.fSymbolTable.addSymbol(string);
        String string3 = null;
        if (!this.fIsRepairingNamespace && (string3 = this.fNamespaceContext.getPrefix(string)) != null) {
            string3 = this.fSymbolTable.addSymbol(string3);
        }
        this.writeStartElement(string3, string2, string);
    }

    private void writenamespace(String string, String string2) throws IOException {
        this.fWriter.write(" ");
        this.fWriter.write("xmlns");
        if (string != null && string != "") {
            this.fWriter.write(":");
            this.fWriter.write(string);
        }
        this.fWriter.write("=");
        this.fWriter.write("\"");
        this.fWriter.write(string2);
        this.fWriter.write("\"");
    }

    private boolean checkUserNamespaceContext(String string, String string2) {
        String string3;
        return this.fNamespaceContext.userContext != null && (string3 = this.fNamespaceContext.userContext.getNamespaceURI(string)) != null && string3.equals(string2);
    }

    public XMLStreamWriterImpl(OutputStream outputStream, String string, PropertyManager propertyManager) throws UnsupportedEncodingException {
        this.fOutputStream = outputStream;
        this.fEncoding = string;
        this.fWriter = new BufferedWriter(new OutputStreamWriter(outputStream, string));
        this.fPropertyManager = propertyManager;
        this.init();
    }

    public void writeAttribute(String string, String string2, String string3) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Attribute not associated with any element");
            }
            if (string == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            string = this.fSymbolTable.addSymbol(string);
            String string4 = this.fInternalNamespaceContext.getPrefix(string);
            if (!this.fIsRepairingNamespace) {
                if (string4 == null) {
                    throw new XMLStreamException("Prefix cannot be null");
                }
            } else {
                Attribute attribute = new Attribute(string3);
                attribute.setValues(null, string2, null, string);
                this.fAttributeCache.add(attribute);
                return;
            }
            this.writeAttributeWithPrefix(string4, string2, string3);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    private void writeAttributeWithPrefix(String string, String string2, String string3) throws IOException {
        this.fWriter.write(" ");
        if (string != null && string != "") {
            this.fWriter.write(string);
            this.fWriter.write(":");
        }
        this.fWriter.write(string2);
        this.fWriter.write("=");
        this.fWriter.write("\"");
        this.writeXMLAttributeValue(string3);
        this.fWriter.write("\"");
    }

    public void writeEmptyElement(String string, String string2, String string3) throws XMLStreamException {
        try {
            if (string2 == null) {
                throw new XMLStreamException("Local Name cannot be null");
            }
            if (string3 == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (string != null) {
                string = this.fSymbolTable.addSymbol(string);
            }
            string3 = this.fSymbolTable.addSymbol(string3);
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            this.fElementStack.push(string, string2, null, string3, true);
            this.fInternalNamespaceContext.pushContext();
            if (!this.fIsRepairingNamespace) {
                if (string == null) {
                    throw new XMLStreamException("NamespaceURI " + string3 + " has not been bound to any prefix");
                }
            } else {
                return;
            }
            if (string != null && string != "") {
                this.fWriter.write(string);
                this.fWriter.write(":");
            }
            this.fWriter.write(string2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeStartElement(String string, String string2, String string3) throws XMLStreamException {
        try {
            if (string2 == null) {
                throw new XMLStreamException("Local Name cannot be null");
            }
            if (string3 == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (!this.fIsRepairingNamespace && string == null) {
                throw new XMLStreamException("Prefix cannot be null");
            }
            if (this.fStartTagOpened) {
                this.closeStartTag();
            }
            this.openStartTag();
            string3 = this.fSymbolTable.addSymbol(string3);
            if (string != null) {
                string = this.fSymbolTable.addSymbol(string);
            }
            this.fElementStack.push(string, string2, null, string3, false);
            this.fInternalNamespaceContext.pushContext();
            String string4 = this.fNamespaceContext.getPrefix(string3);
            if (!(string == null || string4 != null && string.equals(string4))) {
                this.fInternalNamespaceContext.declarePrefix(string, string3);
            }
            if (this.fIsRepairingNamespace) {
                if (string == null || string4 != null && string.equals(string4)) {
                    return;
                }
                QName qName = new QName();
                qName.setValues(string, "xmlns", null, string3);
                this.fNamespaceDecls.add(qName);
                return;
            }
            if (string != null && string != "") {
                this.fWriter.write(string);
                this.fWriter.write(":");
            }
            this.fWriter.write(string2);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    public void writeAttribute(String string, String string2, String string3, String string4) throws XMLStreamException {
        try {
            if (!this.fStartTagOpened) {
                throw new XMLStreamException("Attribute not associated with any element");
            }
            if (string2 == null) {
                throw new XMLStreamException("NamespaceURI cannot be null");
            }
            if (string3 == null) {
                throw new XMLStreamException("Local name cannot be null");
            }
            if (!this.fIsRepairingNamespace) {
                if (string == null) {
                    throw new XMLStreamException("prefix cannot be null");
                }
            } else {
                if (string != null) {
                    string = this.fSymbolTable.addSymbol(string);
                }
                string2 = this.fSymbolTable.addSymbol(string2);
                Attribute attribute = new Attribute(string4);
                attribute.setValues(string, string3, null, string2);
                this.fAttributeCache.add(attribute);
                return;
            }
            this.writeAttributeWithPrefix(string, string3, string4);
        }
        catch (IOException iOException) {
            throw new XMLStreamException(iOException);
        }
    }

    class Attribute
    extends QName {
        String value;

        Attribute(String string) {
            this.value = string;
        }
    }

    protected class ElementStack {
        protected ElementState[] fElements = new ElementState[10];
        protected short fDepth;

        public void clear() {
            this.fDepth = 0;
        }

        public boolean empty() {
            return this.fDepth <= 0;
        }

        public ElementStack() {
            int n = 0;
            while (n < this.fElements.length) {
                this.fElements[n] = new ElementState();
                ++n;
            }
        }

        public ElementState peek() {
            return this.fElements[this.fDepth - 1];
        }

        public ElementState pop() {
            this.fDepth = (short)(this.fDepth - 1);
            return this.fElements[this.fDepth];
        }

        public ElementState push(ElementState elementState) {
            if (this.fDepth == this.fElements.length) {
                ElementState[] elementStateArray = new ElementState[this.fElements.length * 2];
                System.arraycopy(this.fElements, 0, elementStateArray, 0, this.fDepth);
                this.fElements = elementStateArray;
                int n = this.fDepth;
                while (n < this.fElements.length) {
                    this.fElements[n] = new ElementState();
                    ++n;
                }
            }
            this.fElements[this.fDepth].setValues(elementState);
            short s = this.fDepth;
            this.fDepth = (short)(s + 1);
            return this.fElements[s];
        }

        public ElementState push(String string, String string2, String string3, String string4, boolean bl) {
            if (this.fDepth == this.fElements.length) {
                ElementState[] elementStateArray = new ElementState[this.fElements.length * 2];
                System.arraycopy(this.fElements, 0, elementStateArray, 0, this.fDepth);
                this.fElements = elementStateArray;
                int n = this.fDepth;
                while (n < this.fElements.length) {
                    this.fElements[n] = new ElementState();
                    ++n;
                }
            }
            this.fElements[this.fDepth].setValues(string, string2, string3, string4, bl);
            short s = this.fDepth;
            this.fDepth = (short)(s + 1);
            return this.fElements[s];
        }
    }

    class ElementState
    extends QName {
        public boolean isEmpty = false;

        public ElementState() {
        }

        public void setValues(String string, String string2, String string3, String string4, boolean bl) {
            super.setValues(string, string2, string3, string4);
            this.isEmpty = bl;
        }

        public ElementState(String string, String string2, String string3, String string4) {
            super(string, string2, string3, string4);
        }
    }

    class NamespaceContextImpl
    implements NamespaceContext {
        NamespaceContext userContext = null;
        NamespaceSupport internalContext = null;

        NamespaceContextImpl() {
        }

        public String getNamespaceURI(String string) {
            String string2 = null;
            if (string != null) {
                string = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(string);
            }
            if (this.internalContext != null && (string2 = this.internalContext.getURI(string)) != null) {
                return string2;
            }
            if (this.userContext != null) {
                string2 = this.userContext.getNamespaceURI(string);
                return string2;
            }
            return null;
        }

        public String getPrefix(String string) {
            String string2 = null;
            if (string != null) {
                string = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(string);
            }
            if (this.internalContext != null && (string2 = this.internalContext.getPrefix(string)) != null) {
                return string2;
            }
            if (this.userContext != null) {
                return this.userContext.getPrefix(string);
            }
            return null;
        }

        public Iterator getPrefixes(String string) {
            Vector vector = null;
            Iterator<String> iterator = null;
            if (string != null) {
                string = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(string);
            }
            if (this.userContext != null) {
                iterator = this.userContext.getPrefixes(string);
            }
            if (this.internalContext != null) {
                vector = this.internalContext.getPrefixes(string);
            }
            if (vector == null && iterator != null) {
                return iterator;
            }
            if (vector != null && iterator == null) {
                return new ReadOnlyIterator(vector.iterator());
            }
            if (vector != null && iterator != null) {
                String string2 = null;
                while (iterator.hasNext()) {
                    string2 = iterator.next();
                    if (string2 != null) {
                        string2 = XMLStreamWriterImpl.this.fSymbolTable.addSymbol(string2);
                    }
                    if (vector.contains(string2)) continue;
                    vector.add(string2);
                }
                return new ReadOnlyIterator(vector.iterator());
            }
            return fReadOnlyIterator;
        }
    }
}

