/**
 * @typedef {import('./types.js').Selector} Selector
 * @typedef {import('./types.js').Selectors} Selectors
 * @typedef {import('./types.js').Rule} Rule
 * @typedef {import('./types.js').RuleSet} RuleSet
 * @typedef {import('./types.js').RulePseudo} RulePseudo
 * @typedef {import('./types.js').Query} Query
 * @typedef {import('./types.js').Node} Node
 * @typedef {import('./types.js').Parent} Parent
 * @typedef {import('./types.js').SelectIterator} SelectIterator
 * @typedef {import('./types.js').SelectState} SelectState
 */
/**
 * @param {Node} node
 * @returns {node is Parent}
 */
export function root(
  node: Node
): node is import('unist').Parent<
  import('unist').Node<import('unist').Data>,
  import('unist').Data
>
/**
 * @param {Node} node
 * @returns {node is Parent}
 */
export function parent(
  node: Node
): node is import('unist').Parent<
  import('unist').Node<import('unist').Data>,
  import('unist').Data
>
export type Selector = import('./types.js').Selector
export type Selectors = import('./types.js').Selectors
export type Rule = import('./types.js').Rule
export type RuleSet = import('./types.js').RuleSet
export type RulePseudo = import('./types.js').RulePseudo
export type Query = import('./types.js').Query
export type Node = import('./types.js').Node
export type Parent = import('./types.js').Parent
export type SelectIterator = import('./types.js').SelectIterator
export type SelectState = import('./types.js').SelectState
