/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeMessageProvider;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public class BooleanDatatypeValidator
extends AbstractDatatypeValidator {
    private Locale fLocale = null;
    private DatatypeValidator fBaseValidator = null;
    private String fPattern = null;
    private int fFacetsDefined = 0;
    private DatatypeMessageProvider fMessageProvider = new DatatypeMessageProvider();
    private static final String[] fValueSpace = new String[]{"false", "true", "0", "1"};
    private boolean fDerivedByList = false;
    private RegularExpression fRegex = null;

    public BooleanDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public BooleanDatatypeValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.setBasetype(datatypeValidator);
        this.fDerivedByList = bl;
        if (hashtable != null && !bl) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equals("pattern")) {
                    this.fFacetsDefined += 8;
                    this.fPattern = (String)hashtable.get(string);
                    if (this.fPattern == null) continue;
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                throw new InvalidDatatypeFacetException("Only constraining facet in boolean datatype is PATTERN");
            }
        }
    }

    private void checkContent(String string) throws InvalidDatatypeValueException {
        boolean bl = false;
        int n = 0;
        while (n < fValueSpace.length) {
            if (string.equals(fValueSpace[n])) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            throw new InvalidDatatypeValueException(this.getErrorString(2, 0, new Object[]{string}));
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value'" + string + "does not match regular expression facet" + this.fPattern);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    public int compare(String string, String string2) {
        return 0;
    }

    private String getErrorString(int n, int n2, Object[] objectArray) {
        try {
            return this.fMessageProvider.createMessage(this.fLocale, n, n2, objectArray);
        }
        catch (Exception exception) {
            return "Illegal Errorcode " + n2;
        }
    }

    public Hashtable getFacets() {
        return null;
    }

    private void setBasetype(DatatypeValidator datatypeValidator) {
        this.fBaseValidator = datatypeValidator;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        if (!this.fDerivedByList) {
            this.checkContent(string);
        }
        return null;
    }
}

