# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CollectionConfigurationErrorType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Collection configuration error type reported by SDK."""

    UNKNOWN = "Unknown"
    PERFORMANCE_COUNTER_PARSING = "PerformanceCounterParsing"
    PERFORMANCE_COUNTER_UNEXPECTED = "PerformanceCounterUnexpected"
    PERFORMANCE_COUNTER_DUPLICATE_IDS = "PerformanceCounterDuplicateIds"
    DOCUMENT_STREAM_DUPLICATE_IDS = "DocumentStreamDuplicateIds"
    DOCUMENT_STREAM_FAILURE_TO_CREATE = "DocumentStreamFailureToCreate"
    DOCUMENT_STREAM_FAILURE_TO_CREATE_FILTER_UNEXPECTED = "DocumentStreamFailureToCreateFilterUnexpected"
    METRIC_DUPLICATE_IDS = "MetricDuplicateIds"
    METRIC_TELEMETRY_TYPE_UNSUPPORTED = "MetricTelemetryTypeUnsupported"
    METRIC_FAILURE_TO_CREATE = "MetricFailureToCreate"
    METRIC_FAILURE_TO_CREATE_FILTER_UNEXPECTED = "MetricFailureToCreateFilterUnexpected"
    FILTER_FAILURE_TO_CREATE_UNEXPECTED = "FilterFailureToCreateUnexpected"
    COLLECTION_CONFIGURATION_FAILURE_TO_CREATE_UNEXPECTED = "CollectionConfigurationFailureToCreateUnexpected"


class DerivedMetricInfoAggregation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Aggregation type."""

    AVG = "Avg"
    SUM = "Sum"
    MIN = "Min"
    MAX = "Max"


class DocumentFilterConjunctionGroupInfoTelemetryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Telemetry type."""

    REQUEST = "Request"
    DEPENDENCY = "Dependency"
    EXCEPTION = "Exception"
    EVENT = "Event"
    METRIC = "Metric"
    PERFORMANCE_COUNTER = "PerformanceCounter"
    TRACE = "Trace"


class DocumentIngressDocumentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Telemetry type. Types not defined in enum will get replaced with a 'Unknown' type."""

    REQUEST = "Request"
    REMOTE_DEPENDENCY = "RemoteDependency"
    EXCEPTION = "Exception"
    EVENT = "Event"
    TRACE = "Trace"


class FilterInfoPredicate(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Operator of the filter."""

    EQUAL = "Equal"
    NOT_EQUAL = "NotEqual"
    LESS_THAN = "LessThan"
    GREATER_THAN = "GreaterThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    CONTAINS = "Contains"
    DOES_NOT_CONTAIN = "DoesNotContain"
