# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from json import loads as _loads
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.pipeline.transport._base import _format_url_section
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from msrest import Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, Optional, TypeVar

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
# fmt: off

def build_get_collection_request(
    collection_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections/{collectionName}')
    path_format_arguments = {
        "collectionName": _SERIALIZER.url("collection_name", collection_name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_create_or_update_collection_request(
    collection_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections/{collectionName}')
    path_format_arguments = {
        "collectionName": _SERIALIZER.url("collection_name", collection_name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_delete_collection_request(
    collection_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections/{collectionName}')
    path_format_arguments = {
        "collectionName": _SERIALIZER.url("collection_name", collection_name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_list_collections_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    skip_token = kwargs.pop('skip_token', None)  # type: Optional[str]

    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if skip_token is not None:
        query_parameters['$skipToken'] = _SERIALIZER.query("skip_token", skip_token, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_list_child_collection_names_request(
    collection_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    skip_token = kwargs.pop('skip_token', None)  # type: Optional[str]

    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections/{collectionName}/getChildCollectionNames')
    path_format_arguments = {
        "collectionName": _SERIALIZER.url("collection_name", collection_name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if skip_token is not None:
        query_parameters['$skipToken'] = _SERIALIZER.query("skip_token", skip_token, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_collection_path_request(
    collection_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = "2019-11-01-preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/collections/{collectionName}/getCollectionPath')
    path_format_arguments = {
        "collectionName": _SERIALIZER.url("collection_name", collection_name, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )

# fmt: on
class CollectionsOperations(object):
    """CollectionsOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def get_collection(
        self,
        collection_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Get a collection.

        :param collection_name:
        :type collection_name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "collectionProvisioningState": "str (optional)",
                    "description": "str (optional)",
                    "friendlyName": "str (optional)",
                    "name": "str (optional)",
                    "parentCollection": {
                        "referenceName": "str (optional)",
                        "type": "str (optional)"
                    },
                    "systemData": {
                        "createdAt": "datetime (optional)",
                        "createdBy": "str (optional)",
                        "createdByType": "str (optional)",
                        "lastModifiedAt": "datetime (optional)",
                        "lastModifiedBy": "str (optional)",
                        "lastModifiedByType": "str (optional)"
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_collection_request(
            collection_name=collection_name,
            template_url=self.get_collection.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_collection.metadata = {'url': '/collections/{collectionName}'}  # type: ignore


    @distributed_trace
    def create_or_update_collection(
        self,
        collection_name,  # type: str
        collection,  # type: Any
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Creates or updates a collection entity.

        :param collection_name:
        :type collection_name: str
        :param collection:
        :type collection: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                collection = {
                    "collectionProvisioningState": "str (optional)",
                    "description": "str (optional)",
                    "friendlyName": "str (optional)",
                    "name": "str (optional)",
                    "parentCollection": {
                        "referenceName": "str (optional)",
                        "type": "str (optional)"
                    },
                    "systemData": {
                        "createdAt": "datetime (optional)",
                        "createdBy": "str (optional)",
                        "createdByType": "str (optional)",
                        "lastModifiedAt": "datetime (optional)",
                        "lastModifiedBy": "str (optional)",
                        "lastModifiedByType": "str (optional)"
                    }
                }

                # response body for status code(s): 200
                response.json() == {
                    "collectionProvisioningState": "str (optional)",
                    "description": "str (optional)",
                    "friendlyName": "str (optional)",
                    "name": "str (optional)",
                    "parentCollection": {
                        "referenceName": "str (optional)",
                        "type": "str (optional)"
                    },
                    "systemData": {
                        "createdAt": "datetime (optional)",
                        "createdBy": "str (optional)",
                        "createdByType": "str (optional)",
                        "lastModifiedAt": "datetime (optional)",
                        "lastModifiedBy": "str (optional)",
                        "lastModifiedByType": "str (optional)"
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = collection

        request = build_create_or_update_collection_request(
            collection_name=collection_name,
            content_type=content_type,
            json=json,
            template_url=self.create_or_update_collection.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_collection.metadata = {'url': '/collections/{collectionName}'}  # type: ignore


    @distributed_trace
    def delete_collection(
        self,
        collection_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Deletes a Collection entity.

        :param collection_name:
        :type collection_name: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_delete_collection_request(
            collection_name=collection_name,
            template_url=self.delete_collection.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    delete_collection.metadata = {'url': '/collections/{collectionName}'}  # type: ignore


    @distributed_trace
    def list_collections(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable[Any]
        """List the collections in the account.

        :keyword skip_token:
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "count": "long (optional)",
                    "nextLink": "str (optional)",
                    "value": [
                        {
                            "collectionProvisioningState": "str (optional)",
                            "description": "str (optional)",
                            "friendlyName": "str (optional)",
                            "name": "str (optional)",
                            "parentCollection": {
                                "referenceName": "str (optional)",
                                "type": "str (optional)"
                            },
                            "systemData": {
                                "createdAt": "datetime (optional)",
                                "createdBy": "str (optional)",
                                "createdByType": "str (optional)",
                                "lastModifiedAt": "datetime (optional)",
                                "lastModifiedBy": "str (optional)",
                                "lastModifiedByType": "str (optional)"
                            }
                        }
                    ]
                }
        """
        skip_token = kwargs.pop('skip_token', None)  # type: Optional[str]

        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_collections_request(
                    skip_token=skip_token,
                    template_url=self.list_collections.metadata['url'],
                )._to_pipeline_transport_request()
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_list_collections_request(
                    skip_token=skip_token,
                    template_url=next_link,
                )._to_pipeline_transport_request()
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = _loads(pipeline_response.http_response.body())
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    list_collections.metadata = {'url': '/collections'}  # type: ignore

    @distributed_trace
    def list_child_collection_names(
        self,
        collection_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable[Any]
        """Lists the child collections names in the collection.

        :param collection_name:
        :type collection_name: str
        :keyword skip_token:
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "count": "long (optional)",
                    "nextLink": "str (optional)",
                    "value": [
                        {
                            "friendlyName": "str (optional)",
                            "name": "str (optional)"
                        }
                    ]
                }
        """
        skip_token = kwargs.pop('skip_token', None)  # type: Optional[str]

        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_child_collection_names_request(
                    collection_name=collection_name,
                    skip_token=skip_token,
                    template_url=self.list_child_collection_names.metadata['url'],
                )._to_pipeline_transport_request()
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_list_child_collection_names_request(
                    collection_name=collection_name,
                    skip_token=skip_token,
                    template_url=next_link,
                )._to_pipeline_transport_request()
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = _loads(pipeline_response.http_response.body())
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    list_child_collection_names.metadata = {'url': '/collections/{collectionName}/getChildCollectionNames'}  # type: ignore

    @distributed_trace
    def get_collection_path(
        self,
        collection_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Gets the parent name and parent friendly name chains that represent the collection path.

        :param collection_name:
        :type collection_name: str
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "parentFriendlyNameChain": [
                        "str (optional)"
                    ],
                    "parentNameChain": [
                        "str (optional)"
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_collection_path_request(
            collection_name=collection_name,
            template_url=self.get_collection_path.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_collection_path.metadata = {'url': '/collections/{collectionName}/getCollectionPath'}  # type: ignore

