/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import fr.jayasoft.ivy.AbstractArtifact;
import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.ArtifactRevisionId;
import fr.jayasoft.ivy.ModuleRevisionId;
import java.util.Date;

public class DefaultArtifact
extends AbstractArtifact {
    Date _publicationDate;
    ArtifactRevisionId _arid;

    public static Artifact cloneWithAnotherType(Artifact artifact, String newType) {
        return new DefaultArtifact(artifact.getModuleRevisionId(), artifact.getPublicationDate(), artifact.getName(), newType, artifact.getExt());
    }

    public DefaultArtifact(ModuleRevisionId mrid, Date publicationDate, String name, String type, String ext) {
        if (mrid == null) {
            throw new NullPointerException("null mrid not allowed");
        }
        if (publicationDate == null) {
            throw new NullPointerException("null publication date not allowed");
        }
        if (name == null) {
            throw new NullPointerException("null name not allowed");
        }
        if (type == null) {
            throw new NullPointerException("null type not allowed");
        }
        if (ext == null) {
            throw new NullPointerException("null ext not allowed");
        }
        this._publicationDate = publicationDate;
        this._arid = ArtifactRevisionId.newInstance(mrid, name, type, ext);
    }

    public ModuleRevisionId getModuleRevisionId() {
        return this._arid.getModuleRevisionId();
    }

    public String getName() {
        return this._arid.getName();
    }

    public Date getPublicationDate() {
        return this._publicationDate;
    }

    public String getType() {
        return this._arid.getType();
    }

    public String getExt() {
        return this._arid.getExt();
    }

    public ArtifactRevisionId getId() {
        return this._arid;
    }

    public String[] getConfigurations() {
        return new String[0];
    }
}

