%global efivar_version 32-1
%global efibootmgr_version 13-1
%global gnu_efi_version 3.0.5-11
%undefine _debuginfo_subpackages

Name:           fwupdate
Version:        10
Release:        1%{?dist}
Summary:        Tools to manage UEFI firmware updates
License:        GPLv2+
URL:            https://github.com/rhinstaller/fwupdate
Requires:       %{name}-libs%{?_isa} = %{version}-%{release}
BuildRequires:  efivar-devel >= %{efivar_version}
BuildRequires:  gnu-efi >= %{gnu_efi_version}
BuildRequires:  gnu-efi-devel >= %{gnu_efi_version}
BuildRequires:  pesign
BuildRequires:  elfutils popt-devel git gettext pkgconfig
BuildRequires:  systemd
BuildRequires:  libabigail
%ifarch x86_64
BuildRequires: libsmbios-devel
%endif
ExclusiveArch:  x86_64 aarch64
Source0:        https://github.com/rhinstaller/fwupdate/releases/download/%{name}-%{version}/%{name}-%{version}.tar.bz2
Source1:        find-debuginfo-efi.sh

%global __os_install_post %{expand:\
  %{?__debug_package:%{__debug_install_post}} \
  %{SOURCE1} \
  %{__arch_install_post} \
  %{__os_install_post} \
  %{nil}}%{nil}

%ifarch x86_64
%global efiarch x64
%global efialtarch ia32
%endif
%ifarch aarch64
%global efiarch aa64
%endif

# Figure out the right file path to use
%global efidir %(eval echo $(grep ^ID= /etc/os-release | sed -e 's/^ID=//' -e 's/rhel/redhat/'))

%description
fwupdate provides a simple command line interface to the UEFI firmware updates.

%package libs
Summary: Library to manage UEFI firmware updates
%ifnarch %{ix86}
Requires: shim
%endif
Requires: %{name}-efi = %{version}-%{release}

%description libs
Library to allow for the simple manipulation of UEFI firmware updates.

%package devel
Summary: Development headers for libfwup
Requires: %{name}-libs%{?_isa} = %{version}-%{release}
Requires: efivar-devel >= %{efivar_version}

%description devel
development headers required to use libfwup.

%package efi
Summary: UEFI binaries used by libfwup
Requires: %{name}-libs = %{version}-%{release}

%description efi
UEFI binaries used by libfwup.

%package efi-debuginfo
Summary: debuginfo for UEFI binaries used by libfwup
Requires: %{name}-efi = %{version}-%{release}
AutoReq: 0
AutoProv: 1

%description efi-debuginfo
debuginfo for UEFI binaries used by libfwup.

%prep
%setup -q -n %{name}-%{version}
git init
git config user.email "%{name}-owner@fedoraproject.org"
git config user.name "Fedora Ninjas"
git add .
mkdir build-%{efiarch}
%ifarch x86_64
mkdir build-%{efialtarch}
%endif
git commit -a -q -m "%{version} baseline."
git am %{patches} </dev/null
git config --unset user.email
git config --unset user.name
git config fwupdate.efidir %{efidir}

%build
cd build-%{efiarch}
make TOPDIR=.. -f ../Makefile OPT_FLAGS="$RPM_OPT_FLAGS" \
     libdir=%{_libdir} bindir=%{_bindir} \
     EFIDIR=%{efidir} %{?_smp_mflags}
mv -v efi/fwup%{efiarch}.efi efi/fwup%{efiarch}.unsigned.efi
%pesign -s -i efi/fwup%{efiarch}.unsigned.efi -o efi/fwup%{efiarch}.efi
cd ..

%ifarch x86_64
cd build-%{efialtarch}
setarch linux32 -B make TOPDIR=.. -f ../Makefile ARCH=%{efialtarch} \
                        OPT_FLAGS="$RPM_OPT_FLAGS" \
                        libdir=%{_libdir} bindir=%{_bindir} \
                        EFIDIR=%{efidir} %{?_smp_mflags}
mv -v efi/fwup%{efialtarch}.efi efi/fwup%{efialtarch}.unsigned.efi
%pesign -s -i efi/fwup%{efialtarch}.unsigned.efi -o efi/fwup%{efialtarch}.efi
cd ..
%endif

%install
rm -rf $RPM_BUILD_ROOT
cd build-%{efiarch}
%make_install TOPDIR=.. -f ../Makefile \
              EFIDIR=%{efidir} RPMARCH=%{_arch} RELEASE=%{RELEASE} \
              libdir=%{_libdir} bindir=%{_bindir} mandir=%{_mandir} \
              localedir=%{_datadir}/locale/ includedir=%{_includedir} \
              libexecdir=%{_libexecdir} datadir=%{_datadir} \
              sharedstatedir=%{_sharedstatedir}
cd ..

%ifarch x86_64
cd build-%{efialtarch}
setarch linux32 -B %make_install ARCH=%{efialtarch} TOPDIR=.. -f ../Makefile \
                                 EFIDIR=%{efidir} RPMARCH=%{_arch} \
                                 RELEASE=%{RELEASE} libdir=%{_libdir} \
                                 bindir=%{_bindir} mandir=%{_mandir} \
                                 localedir=%{_datadir}/locale/ \
                                 includedir=%{_includedir} \
                                 libexecdir=%{_libexecdir} \
                                 datadir=%{_datadir} \
                                 sharedstatedir=%{_sharedstatedir}
cd ..
%endif

%post libs
/sbin/ldconfig
%systemd_post fwupdate-cleanup.service

%preun libs
%systemd_preun fwupdate-cleanup.service

%postun libs
/sbin/ldconfig
%systemd_postun_with_restart pesign.service

%check
%ifarch x86_64
make abicheck
%endif

%files
%defattr(-,root,root,-)
%{!?_licensedir:%global license %%doc}
%license COPYING
# %%doc README
%{_bindir}/fwupdate
%{_datadir}/locale/en/fwupdate.po
%doc %{_mandir}/man1/*
%dir %{_datadir}/bash-completion/completions
%{_datadir}/bash-completion/completions/fwupdate

%files devel
%defattr(-,root,root,-)
%doc %{_mandir}/man3/*
%{_includedir}/*
%{_libdir}/*.so
%{_libdir}/pkgconfig/*.pc

%files libs
%defattr(-,root,root,-)
%{_libdir}/*.so.*
%{_datadir}/locale/en/libfwup.po
%{_unitdir}/fwupdate-cleanup.service
%attr(0755,root,root) %dir %{_sharedstatedir}/fwupdate/
%config(noreplace) %ghost %{_sharedstatedir}/fwupdate/done
%attr(0755,root,root) %dir %{_libexecdir}/fwupdate/
%{_libexecdir}/fwupdate/cleanup

%files efi
%defattr(-,root,root,-)
%attr(0700,root,root) %dir /boot/efi
%dir /boot/efi/EFI/%{efidir}/
%dir /boot/efi/EFI/%{efidir}/fw/
/boot/efi/EFI/%{efidir}/fwup%{efiarch}.efi
%ifarch x86_64
/boot/efi/EFI/%{efidir}/fwup%{efialtarch}.efi
%endif

%files efi-debuginfo -f debugfiles-efi.list
%defattr(-,root,root)

%changelog
* Mon Mar 06 2017 Peter Jones <pjones@redhat.com> - 9-1
- Update to fwupdate 9
- gcc 7 fixes
- Ensure BootNext entries are in BootOrder to work around some broken
  firmwares.
- Minor bug fixes
- Support for detecting that an admin password is set when trying to enable
  firmware features.

* Fri Aug 19 2016 Peter Jones <pjones@redhat.com> - 8-1
- Update to fwupdate 8
- Fix some i686 build errors
- Be less stupid about SONAMEs so in the future we'll only have to rebuild
  dependent things on actual ABI changes.
- Only depend on libsmbios on x86, for now, because it hasn't been ported to
  Aarch64.

* Tue Aug 16 2016 Peter Jones <pjones@redhat.com> - 7-1
- Update to fwupdate 7.
- Minor bug fixes.

* Tue Aug 16 2016 Peter Jones <pjones@redhat.com> - 6-1
- Update to 0.6
- lots of build fixes for newer compilers and such
- Use libsmbios on some systems to enable firmware updates (Mario Limonciello)
- Use the correct reset type from the QueryCapsuleInfo data
- Lots of fixes from auditing
- Use efivar's error reporting infrastructure

* Tue Jun 02 2015 Peter Jones <pjones@redhat.com> - 0.4-1
- Update to 0.4
- Set DESTDIR so it's more consistently respected
- Always use upper case for Boot#### names.
- Create abbreviated device paths for our BootNext entry.
- Make subdir Makefiles get the version right.
- Fix ucs2len() to handle max=-1 correctly.
- Compare the right blobs when we're searching old boot entries.
- Fix .efi generation on non-x86 platforms.
- Use a relative path for fwupdate.efi when launched from shim.
- Show fewer debugging messages.
- Set BootNext when we find an old Boot#### variable as well.
- Add fwup_get_fw_type().

* Thu May 28 2015 Peter Jones <pjones@redhat.com> - 0.3-1
- Here we go again.
