/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Stack;

public class NDC {
    private static final ThreadLocal tl = new ThreadLocal();
    static int pushCounter = 0;
    static final int REAP_THRESHOLD = 5;

    private NDC() {
    }

    public static void clear() {
        Stack stack = (Stack)tl.get();
        if (stack != null) {
            stack.setSize(0);
        }
    }

    public static Stack cloneStack() {
        Object o = tl.get();
        if (o == null) {
            return null;
        }
        Stack stack = (Stack)o;
        return (Stack)stack.clone();
    }

    public static void inherit(Stack stack) {
        if (stack != null) {
            tl.set(stack);
        }
    }

    public static String get() {
        Stack s = (Stack)tl.get();
        if (s != null && !s.isEmpty()) {
            return ((DiagnosticContext)s.peek()).fullMessage;
        }
        return null;
    }

    public static int getDepth() {
        Stack stack = (Stack)tl.get();
        if (stack == null) {
            return 0;
        }
        return stack.size();
    }

    public static String pop() {
        Stack stack = (Stack)tl.get();
        if (stack != null && !stack.isEmpty()) {
            return ((DiagnosticContext)stack.pop()).message;
        }
        return "";
    }

    public static String peek() {
        Stack stack = (Stack)tl.get();
        if (stack != null && !stack.isEmpty()) {
            return ((DiagnosticContext)stack.peek()).message;
        }
        return "";
    }

    public static void push(String message) {
        Stack<DiagnosticContext> stack = (Stack<DiagnosticContext>)tl.get();
        if (stack == null) {
            DiagnosticContext dc = new DiagnosticContext(message, null);
            stack = new Stack<DiagnosticContext>();
            tl.set(stack);
            stack.push(dc);
        } else if (stack.isEmpty()) {
            DiagnosticContext dc = new DiagnosticContext(message, null);
            stack.push(dc);
        } else {
            DiagnosticContext parent = (DiagnosticContext)stack.peek();
            stack.push(new DiagnosticContext(message, parent));
        }
    }

    public static void remove() {
    }

    public static void setMaxDepth(int maxDepth) {
        Stack stack = (Stack)tl.get();
        if (stack != null && maxDepth < stack.size()) {
            stack.setSize(maxDepth);
        }
    }

    private static class DiagnosticContext {
        String fullMessage;
        String message;

        DiagnosticContext(String message, DiagnosticContext parent) {
            this.message = message;
            this.fullMessage = parent != null ? parent.fullMessage + ' ' + message : message;
        }
    }
}

